/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeKind;

@BugPattern(name="HidingField", summary="Hiding fields of superclasses may cause confusion and errors", severity=BugPattern.SeverityLevel.WARNING, altNames={"hiding", "OvershadowingSubclassFields"})
public class HidingField
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final ImmutableSet<String> IGNORED_CLASSES = ImmutableSet.of((Object)"com.google.common.GoogleLogger", (Object)"java.util.logging.Logger");

    public Description matchClass(ClassTree classTree, VisitorState visitorState) {
        List originalClassMembers = classTree.getMembers().stream().filter(mem -> mem instanceof VariableTree).map(mem -> (VariableTree)mem).filter(mem -> !this.isSuppressed(ASTHelpers.getSymbol((VariableTree)mem)) && !HidingField.isIgnoredType(mem) && !HidingField.isStatic(mem)).collect(Collectors.toCollection(ArrayList::new));
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)classTree);
        while (!classSymbol.getSuperclass().getKind().equals((Object)TypeKind.NONE)) {
            Symbol.TypeSymbol parentSymbol = classSymbol.getSuperclass().asElement();
            List parentElements = parentSymbol.getEnclosedElements();
            Map<Name, Symbol.VarSymbol> parentMembers = parentElements.stream().filter(mem -> mem instanceof Symbol.VarSymbol).map(mem -> (Symbol.VarSymbol)mem).filter(mem -> !mem.isPrivate() && !mem.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toMap(Symbol::getSimpleName, mem -> mem));
            this.checkForHiddenFields(originalClassMembers, parentMembers, parentSymbol.getSimpleName(), classTree, visitorState);
            classSymbol = (Symbol.ClassSymbol)parentSymbol;
        }
        return Description.NO_MATCH;
    }

    private void checkForHiddenFields(List<VariableTree> originalClassMembers, Map<Name, Symbol.VarSymbol> parentMembers, Name parentClassName, ClassTree classTree, VisitorState visitorState) {
        Iterator<VariableTree> origVariableIterator = originalClassMembers.iterator();
        VariableTree origVariable = null;
        while (origVariableIterator.hasNext()) {
            origVariable = origVariableIterator.next();
            if (!parentMembers.containsKey(origVariable.getName()) || HidingField.isPackagePrivateAndInDiffPackage(parentMembers.get(origVariable.getName()), classTree)) continue;
            Description.Builder matchDesc = this.buildDescription(origVariable);
            matchDesc.setMessage("Hiding fields of superclasses may cause confusion and errors. This field is hiding a field of the same name in superclass: " + parentClassName);
            visitorState.reportMatch(matchDesc.build());
            origVariableIterator.remove();
        }
    }

    private static boolean isIgnoredType(VariableTree variableTree) {
        Symbol.VarSymbol varSymbol = ASTHelpers.getSymbol((VariableTree)variableTree);
        if (varSymbol != null) {
            return IGNORED_CLASSES.contains((Object)varSymbol.getQualifiedName().toString());
        }
        return false;
    }

    private static boolean isStatic(VariableTree varTree) {
        return varTree.getModifiers().getFlags().contains((Object)Modifier.STATIC);
    }

    private static boolean isPackagePrivateAndInDiffPackage(Symbol.VarSymbol parentVariable, ClassTree currClass) {
        return !parentVariable.getModifiers().contains((Object)Modifier.PRIVATE) && !parentVariable.getModifiers().contains((Object)Modifier.PROTECTED) && !parentVariable.getModifiers().contains((Object)Modifier.PUBLIC) && !parentVariable.packge().equals(ASTHelpers.getSymbol((ClassTree)currClass).packge());
    }
}

