/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="RemovedInJDK11", summary="This API is no longer supported in JDK 11", severity=BugPattern.SeverityLevel.ERROR)
public class RemovedInJDK11
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny(new String[]{"java.lang.Runtime", "java.lang.System"}).named("runFinalizersOnExit"), MethodMatchers.instanceMethod().onExactClass("java.lang.SecurityManager").namedAnyOf(new String[]{"checkAwtEventQueueAccess", "checkMemberAccess", "checkSystemClipboardAccess", "checkTopLevelWindow"}), MethodMatchers.instanceMethod().onExactClass("java.lang.Thread").named("stop").withParameters(new String[]{"java.lang.Throwable"}), MethodMatchers.instanceMethod().onExactClass("java.lang.Thread").named("destroy")});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return MATCHER.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

