/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import lombok.ast.MessageKey;

public class Message {
    private final MessageType type;
    private final MessageKey key;
    private final String message;

    public static Message warning(MessageKey key, String message) {
        return new Message(MessageType.WARNING, key, message);
    }

    public static Message error(MessageKey key, String message) {
        return new Message(MessageType.ERROR, key, message);
    }

    public static Message warning(String message) {
        return new Message(MessageType.WARNING, null, message);
    }

    public static Message error(String message) {
        return new Message(MessageType.ERROR, null, message);
    }

    public boolean isError() {
        return MessageType.ERROR == this.type;
    }

    public boolean isWarning() {
        return MessageType.WARNING == this.type;
    }

    public String toString() {
        return this.key == null ? this.message : String.format("[%s %s] %s", new Object[]{this.type, this.key, this.message});
    }

    public MessageType getType() {
        return this.type;
    }

    public MessageKey getKey() {
        return this.key;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() == null ? other.getType() != null : !this.getType().equals((Object)other.getType())) {
            return false;
        }
        if (this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey())) {
            return false;
        }
        return !(this.getMessage() == null ? other.getMessage() != null : !this.getMessage().equals(other.getMessage()));
    }

    public boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + (this.getType() == null ? 0 : this.getType().hashCode());
        result = result * 31 + (this.getKey() == null ? 0 : this.getKey().hashCode());
        result = result * 31 + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        return result;
    }

    private Message(MessageType type, MessageKey key, String message) {
        this.type = type;
        this.key = key;
        this.message = message;
    }

    public static enum MessageType {
        ERROR,
        WARNING;

    }
}

