/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import io.grpc.Internal;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.Utils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;

@Internal
public final class InternalNettyChannelBuilder {
    public static void disableCheckAuthority(NettyChannelBuilder builder) {
        builder.disableCheckAuthority();
    }

    public static void enableCheckAuthority(NettyChannelBuilder builder) {
        builder.enableCheckAuthority();
    }

    public static void setProtocolNegotiatorFactory(NettyChannelBuilder builder, ProtocolNegotiatorFactory protocolNegotiator) {
        builder.protocolNegotiatorFactory(protocolNegotiator);
    }

    public static void setStatsEnabled(NettyChannelBuilder builder, boolean value) {
        builder.setStatsEnabled(value);
    }

    public static void setTracingEnabled(NettyChannelBuilder builder, boolean value) {
        builder.setTracingEnabled(value);
    }

    public static void setStatsRecordStartedRpcs(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordStartedRpcs(value);
    }

    public static void setStatsRecordFinishedRpcs(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordFinishedRpcs(value);
    }

    public static void setStatsRecordRealTimeMetrics(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordRealTimeMetrics(value);
    }

    public static void useNioTransport(NettyChannelBuilder builder) {
        builder.channelType(NioSocketChannel.class);
        builder.eventLoopGroupPool((ObjectPool<? extends EventLoopGroup>)SharedResourcePool.forResource(Utils.NIO_WORKER_EVENT_LOOP_GROUP));
    }

    public static ClientTransportFactory buildTransportFactory(NettyChannelBuilder builder) {
        return builder.buildTransportFactory();
    }

    private InternalNettyChannelBuilder() {
    }

    public static interface ProtocolNegotiatorFactory
    extends NettyChannelBuilder.ProtocolNegotiatorFactory {
        @Override
        public InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator();
    }
}

