/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.autocodec;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

class SerializationProcessorUtil {
    private SerializationProcessorUtil() {
    }

    static TypeMirror sanitizeTypeParameter(TypeMirror type, ProcessingEnvironment env) {
        if (SerializationProcessorUtil.isVariableOrWildcardType(type)) {
            return env.getTypeUtils().erasure(type);
        }
        if (!(type instanceof DeclaredType)) {
            return type;
        }
        DeclaredType declaredType = (DeclaredType)type;
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            if (!SerializationProcessorUtil.isVariableOrWildcardType(typeMirror)) continue;
            return env.getTypeUtils().erasure(type);
        }
        return type;
    }

    static JavaFile writeGeneratedClassToFile(Element element, TypeSpec builtClass, ProcessingEnvironment env) throws SerializationProcessingFailedException {
        String packageName = env.getElementUtils().getPackageOf(element).getQualifiedName().toString();
        JavaFile file = JavaFile.builder((String)packageName, (TypeSpec)builtClass).build();
        try {
            file.writeTo(env.getFiler());
        }
        catch (IOException e) {
            throw new SerializationProcessingFailedException(element, "Failed to generate output file: %s", e.getMessage());
        }
        return file;
    }

    static String getGeneratedName(Element element, String suffix) {
        ImmutableList.Builder classNamesBuilder = new ImmutableList.Builder();
        classNamesBuilder.add((Object)suffix);
        do {
            classNamesBuilder.add((Object)element.getSimpleName().toString());
        } while ((element = element.getEnclosingElement()) instanceof TypeElement);
        return String.join((CharSequence)"_", (Iterable<? extends CharSequence>)classNamesBuilder.build().reverse());
    }

    static boolean isVariableOrWildcardType(TypeMirror type) {
        return type instanceof TypeVariable || type instanceof WildcardType;
    }

    static final class SerializationProcessingFailedException
    extends Exception {
        private final Element element;

        @FormatMethod
        SerializationProcessingFailedException(Element element, @FormatString String fmt, Object ... args) {
            super(String.format(fmt, args));
            this.element = element;
        }

        Element getElement() {
            return this.element;
        }
    }
}

