/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;

class ImmutableMapCodec<V>
implements ObjectCodec<ImmutableMap<?, V>> {
    @SerializationConstant
    static final Comparator<?> ORDERING_NATURAL = Ordering.natural();
    @SerializationConstant
    static final Comparator<?> COMPARATOR_NATURAL_ORDER = Comparator.naturalOrder();

    ImmutableMapCodec() {
    }

    @Override
    public Class<ImmutableMap<?, V>> getEncodedClass() {
        return ImmutableMap.class;
    }

    @Override
    public void serialize(SerializationContext context, ImmutableMap<?, V> map, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(map.size());
        Comparator comparator = map instanceof ImmutableSortedMap ? ((ImmutableSortedMap)map).comparator() : null;
        context.serialize(comparator, codedOut);
        ImmutableMapCodec.serializeEntries(context, map.entrySet(), codedOut);
    }

    static <K, V> void serializeEntries(SerializationContext context, Iterable<? extends Map.Entry<K, V>> entrySet, CodedOutputStream codedOut) throws IOException, SerializationException {
        for (Map.Entry<K, V> entry : entrySet) {
            context.serialize(entry.getKey(), codedOut);
            try {
                context.serialize(entry.getValue(), codedOut);
            }
            catch (SerializationException | IOException e) {
                throw SerializationException.propagate(String.format("Exception while serializing value of type %s for key '%s'", entry.getValue().getClass().getName(), entry.getKey()), e);
            }
        }
    }

    @Override
    public ImmutableMap<?, V> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int length = codedIn.readInt32();
        if (length < 0) {
            throw new SerializationException("Expected non-negative length: " + length);
        }
        Comparator comparator = (Comparator)context.deserialize(codedIn);
        Object builder = comparator != null ? ImmutableMapCodec.deserializeEntries(ImmutableSortedMap.orderedBy((Comparator)comparator), length, context, codedIn) : ImmutableMapCodec.deserializeEntries(ImmutableMap.builderWithExpectedSize((int)length), length, context, codedIn);
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException("Duplicate keys during ImmutableMapCodec deserialization", e);
        }
    }

    static <K, V, M extends ImmutableMap.Builder<K, V>> M deserializeEntries(M builder, int length, DeserializationContext context, CodedInputStream codedIn) throws IOException, SerializationException {
        for (int i = 0; i < length; ++i) {
            Object value;
            Object key = context.deserialize(codedIn);
            try {
                value = context.deserialize(codedIn);
            }
            catch (SerializationException | IOException e) {
                throw SerializationException.propagate(String.format("Exception while deserializing value for key '%s'", key), e);
            }
            builder.put(key, value);
        }
        return builder;
    }
}

