/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.turbine.model.Const;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public class ClassFile {
    private final int access;
    private final int majorVersion;
    private final String name;
    private final @Nullable String signature;
    private final @Nullable String superClass;
    private final List<String> interfaces;
    private final List<String> permits;
    private final List<MethodInfo> methods;
    private final List<FieldInfo> fields;
    private final List<AnnotationInfo> annotations;
    private final List<InnerClass> innerClasses;
    private final ImmutableList<TypeAnnotationInfo> typeAnnotations;
    private final @Nullable ModuleInfo module;
    private final @Nullable String nestHost;
    private final ImmutableList<String> nestMembers;
    private final @Nullable RecordInfo record;
    private final @Nullable String transitiveJar;

    public ClassFile(int access, int majorVersion, String name, @Nullable String signature, @Nullable String superClass, List<String> interfaces, List<String> permits, List<MethodInfo> methods, List<FieldInfo> fields, List<AnnotationInfo> annotations, List<InnerClass> innerClasses, ImmutableList<TypeAnnotationInfo> typeAnnotations, @Nullable ModuleInfo module, @Nullable String nestHost, ImmutableList<String> nestMembers, @Nullable RecordInfo record, @Nullable String transitiveJar) {
        this.access = access;
        this.majorVersion = majorVersion;
        this.name = name;
        this.signature = signature;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.permits = permits;
        this.methods = methods;
        this.fields = fields;
        this.annotations = annotations;
        this.innerClasses = innerClasses;
        this.typeAnnotations = typeAnnotations;
        this.module = module;
        this.nestHost = nestHost;
        this.nestMembers = nestMembers;
        this.record = record;
        this.transitiveJar = transitiveJar;
    }

    public int access() {
        return this.access;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public String name() {
        return this.name;
    }

    public @Nullable String signature() {
        return this.signature;
    }

    public @Nullable String superName() {
        return this.superClass;
    }

    public List<String> interfaces() {
        return this.interfaces;
    }

    public List<String> permits() {
        return this.permits;
    }

    public List<MethodInfo> methods() {
        return this.methods;
    }

    public List<FieldInfo> fields() {
        return this.fields;
    }

    public List<AnnotationInfo> annotations() {
        return this.annotations;
    }

    public List<InnerClass> innerClasses() {
        return this.innerClasses;
    }

    public ImmutableList<TypeAnnotationInfo> typeAnnotations() {
        return this.typeAnnotations;
    }

    public @Nullable ModuleInfo module() {
        return this.module;
    }

    public @Nullable String nestHost() {
        return this.nestHost;
    }

    public ImmutableList<String> nestMembers() {
        return this.nestMembers;
    }

    public @Nullable RecordInfo record() {
        return this.record;
    }

    public @Nullable String transitiveJar() {
        return this.transitiveJar;
    }

    public static class RecordInfo {
        private final ImmutableList<RecordComponentInfo> recordComponents;

        public RecordInfo(ImmutableList<RecordComponentInfo> recordComponents) {
            this.recordComponents = recordComponents;
        }

        public ImmutableList<RecordComponentInfo> recordComponents() {
            return this.recordComponents;
        }

        public static class RecordComponentInfo {
            private final String name;
            private final String descriptor;
            private final @Nullable String signature;
            private final ImmutableList<AnnotationInfo> annotations;
            private final ImmutableList<TypeAnnotationInfo> typeAnnotations;

            public RecordComponentInfo(String name, String descriptor, @Nullable String signature, ImmutableList<AnnotationInfo> annotations, ImmutableList<TypeAnnotationInfo> typeAnnotations) {
                this.name = name;
                this.descriptor = descriptor;
                this.signature = signature;
                this.annotations = annotations;
                this.typeAnnotations = typeAnnotations;
            }

            public String name() {
                return this.name;
            }

            public String descriptor() {
                return this.descriptor;
            }

            public @Nullable String signature() {
                return this.signature;
            }

            public ImmutableList<AnnotationInfo> annotations() {
                return this.annotations;
            }

            public ImmutableList<TypeAnnotationInfo> typeAnnotations() {
                return this.typeAnnotations;
            }
        }
    }

    public static class ModuleInfo {
        private final String name;
        private final @Nullable String version;
        private final int flags;
        private final ImmutableList<RequireInfo> requires;
        private final ImmutableList<ExportInfo> exports;
        private final ImmutableList<OpenInfo> opens;
        private final ImmutableList<UseInfo> uses;
        private final ImmutableList<ProvideInfo> provides;

        public ModuleInfo(String name, int flags, @Nullable String version, ImmutableList<RequireInfo> requires, ImmutableList<ExportInfo> exports, ImmutableList<OpenInfo> opens, ImmutableList<UseInfo> uses, ImmutableList<ProvideInfo> provides) {
            this.name = name;
            this.flags = flags;
            this.version = version;
            this.requires = requires;
            this.exports = exports;
            this.opens = opens;
            this.uses = uses;
            this.provides = provides;
        }

        public String name() {
            return this.name;
        }

        public int flags() {
            return this.flags;
        }

        public @Nullable String version() {
            return this.version;
        }

        public ImmutableList<RequireInfo> requires() {
            return this.requires;
        }

        public ImmutableList<ExportInfo> exports() {
            return this.exports;
        }

        public ImmutableList<OpenInfo> opens() {
            return this.opens;
        }

        public ImmutableList<UseInfo> uses() {
            return this.uses;
        }

        public ImmutableList<ProvideInfo> provides() {
            return this.provides;
        }

        public static class ProvideInfo {
            private final String descriptor;
            private final ImmutableList<String> implDescriptors;

            public ProvideInfo(String descriptor, ImmutableList<String> implDescriptors) {
                this.descriptor = descriptor;
                this.implDescriptors = implDescriptors;
            }

            public String descriptor() {
                return this.descriptor;
            }

            public ImmutableList<String> implDescriptors() {
                return this.implDescriptors;
            }
        }

        public static class UseInfo {
            private final String descriptor;

            public UseInfo(String descriptor) {
                this.descriptor = descriptor;
            }

            public String descriptor() {
                return this.descriptor;
            }
        }

        public static class OpenInfo {
            private final String moduleName;
            private final int flags;
            private final ImmutableList<String> modules;

            public OpenInfo(String moduleName, int flags, ImmutableList<String> modules) {
                this.moduleName = moduleName;
                this.flags = flags;
                this.modules = modules;
            }

            public String moduleName() {
                return this.moduleName;
            }

            public int flags() {
                return this.flags;
            }

            public ImmutableList<String> modules() {
                return this.modules;
            }
        }

        public static class ExportInfo {
            private final String moduleName;
            private final int flags;
            private final ImmutableList<String> modules;

            public ExportInfo(String moduleName, int flags, ImmutableList<String> modules) {
                this.moduleName = moduleName;
                this.flags = flags;
                this.modules = modules;
            }

            public String moduleName() {
                return this.moduleName;
            }

            public int flags() {
                return this.flags;
            }

            public ImmutableList<String> modules() {
                return this.modules;
            }
        }

        public static class RequireInfo {
            private final String moduleName;
            private final int flags;
            private final @Nullable String version;

            public RequireInfo(String moduleName, int flags, @Nullable String version) {
                this.moduleName = moduleName;
                this.flags = flags;
                this.version = version;
            }

            public String moduleName() {
                return this.moduleName;
            }

            public int flags() {
                return this.flags;
            }

            public @Nullable String version() {
                return this.version;
            }
        }
    }

    public static class TypeAnnotationInfo {
        private final TargetType targetType;
        private final Target target;
        private final TypePath path;
        private final AnnotationInfo anno;
        public static final Target EMPTY_TARGET = new Target(){

            @Override
            public Target.Kind kind() {
                return Target.Kind.EMPTY;
            }
        };

        public TypeAnnotationInfo(TargetType targetType, Target target, TypePath path, AnnotationInfo anno) {
            this.targetType = targetType;
            this.target = target;
            this.path = path;
            this.anno = anno;
        }

        public AnnotationInfo anno() {
            return this.anno;
        }

        public TargetType targetType() {
            return this.targetType;
        }

        public Target target() {
            return this.target;
        }

        public TypePath path() {
            return this.path;
        }

        public static class TypePath {
            private final @Nullable TypePath parent;
            private final @Nullable Kind kind;
            private final int index;

            public static TypePath root() {
                return new TypePath(null, null);
            }

            public TypePath array() {
                return new TypePath(Kind.ARRAY, this);
            }

            public TypePath nested() {
                return new TypePath(Kind.NESTED, this);
            }

            public TypePath wild() {
                return new TypePath(Kind.WILDCARD_BOUND, this);
            }

            public TypePath typeArgument(int idx) {
                return new TypePath(idx, Kind.TYPE_ARGUMENT, this);
            }

            private TypePath(@Nullable Kind kind, @Nullable TypePath parent) {
                this(0, kind, parent);
            }

            private TypePath(int index, @Nullable Kind kind, @Nullable TypePath parent) {
                this.index = index;
                this.kind = kind;
                this.parent = parent;
            }

            public int typeArgumentIndex() {
                return this.index;
            }

            public byte tag() {
                return (byte)Objects.requireNonNull(this.kind).tag;
            }

            public ImmutableList<TypePath> flatten() {
                ArrayDeque<TypePath> flat = new ArrayDeque<TypePath>();
                TypePath curr = this;
                while (Objects.requireNonNull(curr).kind != null) {
                    flat.addFirst(curr);
                    curr = curr.parent;
                }
                return ImmutableList.copyOf(flat);
            }

            static enum Kind {
                ARRAY(0),
                NESTED(1),
                WILDCARD_BOUND(2),
                TYPE_ARGUMENT(3);

                final int tag;

                private Kind(int tag) {
                    this.tag = tag;
                }
            }
        }

        public static class ThrowsTarget
        extends Target {
            private final int index;

            public ThrowsTarget(int index) {
                this.index = index;
            }

            @Override
            public Target.Kind kind() {
                return Target.Kind.THROWS;
            }

            public int index() {
                return this.index;
            }
        }

        public static class FormalParameterTarget
        extends Target {
            private final int index;

            public FormalParameterTarget(int index) {
                this.index = index;
            }

            @Override
            public Target.Kind kind() {
                return Target.Kind.FORMAL_PARAMETER;
            }

            public int index() {
                return this.index;
            }
        }

        public static class TypeParameterBoundTarget
        extends Target {
            private final int typeParameterIndex;
            private final int boundIndex;

            public TypeParameterBoundTarget(int typeParameterIndex, int boundIndex) {
                this.typeParameterIndex = typeParameterIndex;
                this.boundIndex = boundIndex;
            }

            @Override
            public Target.Kind kind() {
                return Target.Kind.TYPE_PARAMETER_BOUND;
            }

            public int typeParameterIndex() {
                return this.typeParameterIndex;
            }

            public int boundIndex() {
                return this.boundIndex;
            }
        }

        public static class SuperTypeTarget
        extends Target {
            private final int index;

            public SuperTypeTarget(int index) {
                this.index = index;
            }

            @Override
            public Target.Kind kind() {
                return Target.Kind.SUPERTYPE;
            }

            public int index() {
                return this.index;
            }
        }

        public static class TypeParameterTarget
        extends Target {
            private final int index;

            public TypeParameterTarget(int index) {
                this.index = index;
            }

            public int index() {
                return this.index;
            }

            @Override
            public Target.Kind kind() {
                return Target.Kind.TYPE_PARAMETER;
            }
        }

        public static abstract class Target {
            public abstract Kind kind();

            public static enum Kind {
                TYPE_PARAMETER,
                SUPERTYPE,
                TYPE_PARAMETER_BOUND,
                EMPTY,
                FORMAL_PARAMETER,
                THROWS;

            }
        }

        public static enum TargetType {
            CLASS_TYPE_PARAMETER(0),
            METHOD_TYPE_PARAMETER(1),
            SUPERTYPE(16),
            CLASS_TYPE_PARAMETER_BOUND(17),
            METHOD_TYPE_PARAMETER_BOUND(18),
            FIELD(19),
            METHOD_RETURN(20),
            METHOD_RECEIVER_PARAMETER(21),
            METHOD_FORMAL_PARAMETER(22),
            METHOD_THROWS(23);

            private final int tag;

            private TargetType(int tag) {
                this.tag = tag;
            }

            public int tag() {
                return this.tag;
            }
        }
    }

    public static class AnnotationInfo {
        private final String typeName;
        private final boolean runtimeVisible;
        private final Map<String, ElementValue> elementValuePairs;

        public AnnotationInfo(String typeName, boolean runtimeVisible, Map<String, ElementValue> elementValuePairs) {
            this.typeName = typeName;
            this.runtimeVisible = runtimeVisible;
            this.elementValuePairs = elementValuePairs;
        }

        public String typeName() {
            return this.typeName;
        }

        public boolean isRuntimeVisible() {
            return this.runtimeVisible;
        }

        public Map<String, ElementValue> elementValuePairs() {
            return this.elementValuePairs;
        }

        public static interface ElementValue {
            public Kind kind();

            public static class ConstTurbineAnnotationValue
            implements ElementValue {
                private final AnnotationInfo annotation;

                public ConstTurbineAnnotationValue(AnnotationInfo annotation) {
                    this.annotation = annotation;
                }

                @Override
                public Kind kind() {
                    return Kind.ANNOTATION;
                }

                public AnnotationInfo annotation() {
                    return this.annotation;
                }
            }

            public static class ConstTurbineClassValue
            implements ElementValue {
                private final String className;

                public ConstTurbineClassValue(String className) {
                    this.className = className;
                }

                @Override
                public Kind kind() {
                    return Kind.CLASS;
                }

                public String className() {
                    return this.className;
                }
            }

            public static class ArrayValue
            implements ElementValue {
                private final List<ElementValue> elements;

                public ArrayValue(List<ElementValue> elements) {
                    this.elements = elements;
                }

                @Override
                public Kind kind() {
                    return Kind.ARRAY;
                }

                public List<ElementValue> elements() {
                    return this.elements;
                }
            }

            public static class ConstValue
            implements ElementValue {
                private final Const.Value value;

                public ConstValue(Const.Value value) {
                    this.value = value;
                }

                @Override
                public Kind kind() {
                    return Kind.CONST;
                }

                public Const.Value value() {
                    return this.value;
                }
            }

            public static class EnumConstValue
            implements ElementValue {
                private final String typeName;
                private final String constName;

                public EnumConstValue(String typeName, String constName) {
                    this.typeName = typeName;
                    this.constName = constName;
                }

                @Override
                public Kind kind() {
                    return Kind.ENUM;
                }

                public String typeName() {
                    return this.typeName;
                }

                public String constName() {
                    return this.constName;
                }
            }

            public static enum Kind {
                ENUM,
                CONST,
                ARRAY,
                CLASS,
                ANNOTATION;

            }
        }
    }

    public static class MethodInfo {
        private final int access;
        private final String name;
        private final String descriptor;
        private final @Nullable String signature;
        private final List<String> exceptions;
        private final @Nullable AnnotationInfo.ElementValue defaultValue;
        private final List<AnnotationInfo> annotations;
        private final ImmutableList<ImmutableList<AnnotationInfo>> parameterAnnotations;
        private final ImmutableList<TypeAnnotationInfo> typeAnnotations;
        private final ImmutableList<ParameterInfo> parameters;

        public MethodInfo(int access, String name, String descriptor, @Nullable String signature, List<String> exceptions, @Nullable AnnotationInfo.ElementValue defaultValue, List<AnnotationInfo> annotations, ImmutableList<ImmutableList<AnnotationInfo>> parameterAnnotations, ImmutableList<TypeAnnotationInfo> typeAnnotations, ImmutableList<ParameterInfo> parameters) {
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            this.defaultValue = defaultValue;
            this.annotations = annotations;
            this.parameterAnnotations = parameterAnnotations;
            this.typeAnnotations = typeAnnotations;
            this.parameters = parameters;
        }

        public int access() {
            return this.access;
        }

        public String name() {
            return this.name;
        }

        public String descriptor() {
            return this.descriptor;
        }

        public @Nullable String signature() {
            return this.signature;
        }

        public List<String> exceptions() {
            return this.exceptions;
        }

        public @Nullable AnnotationInfo.ElementValue defaultValue() {
            return this.defaultValue;
        }

        public List<AnnotationInfo> annotations() {
            return this.annotations;
        }

        public ImmutableList<ImmutableList<AnnotationInfo>> parameterAnnotations() {
            return this.parameterAnnotations;
        }

        public ImmutableList<TypeAnnotationInfo> typeAnnotations() {
            return this.typeAnnotations;
        }

        public ImmutableList<ParameterInfo> parameters() {
            return this.parameters;
        }

        public static class ParameterInfo {
            private final String name;
            private final int access;

            public ParameterInfo(String name, int access) {
                this.name = name;
                this.access = access;
            }

            public String name() {
                return this.name;
            }

            public int access() {
                return this.access;
            }
        }
    }

    public static class InnerClass {
        private final String innerClass;
        private final String outerClass;
        private final String innerName;
        private final int access;

        public InnerClass(String innerClass, String outerClass, String innerName, int access) {
            this.innerClass = Objects.requireNonNull(innerClass);
            this.outerClass = Objects.requireNonNull(outerClass);
            this.innerName = Objects.requireNonNull(innerName);
            this.access = access;
        }

        public String innerClass() {
            return this.innerClass;
        }

        public String outerClass() {
            return this.outerClass;
        }

        public String innerName() {
            return this.innerName;
        }

        public int access() {
            return this.access;
        }
    }

    public static class FieldInfo {
        private final int access;
        private final String name;
        private final String descriptor;
        private final @Nullable String signature;
        private final @Nullable Const.Value value;
        private final List<AnnotationInfo> annotations;
        private final ImmutableList<TypeAnnotationInfo> typeAnnotations;

        public FieldInfo(int access, String name, String descriptor, @Nullable String signature, @Nullable Const.Value value, List<AnnotationInfo> annotations, ImmutableList<TypeAnnotationInfo> typeAnnotations) {
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.value = value;
            this.annotations = annotations;
            this.typeAnnotations = typeAnnotations;
        }

        public int access() {
            return this.access;
        }

        public String name() {
            return this.name;
        }

        public String descriptor() {
            return this.descriptor;
        }

        public @Nullable String signature() {
            return this.signature;
        }

        public @Nullable Const.Value value() {
            return this.value;
        }

        public List<AnnotationInfo> annotations() {
            return this.annotations;
        }

        public ImmutableList<TypeAnnotationInfo> typeAnnotations() {
            return this.typeAnnotations;
        }
    }
}

