// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

// FxCop Suppression file
// To Use:
// Add module level suppressions to this file to have them suppressed in the assembly
//
#if CODE_ANALYSIS
using System.Diagnostics.CodeAnalysis;
[module: SuppressMessage("Microsoft.Design", "CA1032:ImplementStandardExceptionConstructors", Scope="member", Target="Microsoft.Build.BuildEngine.Shared.InternalErrorException..ctor(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification="This is a shared class which is implementing the correct constructors, in this case the method is internal.")]
[module: SuppressMessage("Microsoft.Naming", "CA1721:PropertyNamesShouldNotMatchGetMethods", Scope="member", Target="Microsoft.Build.BuildEngine.BuildTask.Type", Justification="This method returns the object type of the task, however we need to do some work to actually get the object out to look at it, therefore a custom method is needed.")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Engine.Resources.Strings.resources", MessageId="itemname", Justification="itemname is spelled correctly")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Engine.Resources.Strings.resources", MessageId="sln", Justification="sln is the extension for a solution")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.BuildEngine.Utilities.Escape(System.String):System.String", MessageId="unescaped", Justification="unescaped is spelled correctly and cased correctly")]
[module: SuppressMessage("Microsoft.Performance", "CA1816:DisposeMethodsShouldCallSuppressFinalize", Scope="member", Target="Microsoft.Build.BuildEngine.SharedMemory.Dispose():System.Void", Justification="The methods is being called, fxcop is not picking it up for some reason")]
[module: SuppressMessage("Microsoft.Design","CA1032:ImplementStandardExceptionConstructors",Justification="We require this constructor for serialization")]
[module: SuppressMessage("Microsoft.Design", "CA2210:AssembliesShouldHaveValidStrongNames", Justification="We delay sign our assemblies.")]
[module: SuppressMessage("Microsoft.Usage", "CA2205:UseManagedEquivalentsOfWin32Api", Scope="member", Target="Microsoft.Build.BuildEngine.Shared.NativeMethods.GetCurrentDirectory(System.Int32,System.Text.StringBuilder):System.Int32", Justification="Native call is used to GetCurrentDirectory for perf reasons")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.Shared.FileUtilities.IsItemSpecModifier(System.String):System.Boolean", Justification="This is necessarily complex to give proven perf benefits.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.Shared.FileUtilities.GetItemSpecModifier(System.String,System.String,System.String,System.Collections.Hashtable&):System.String")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.Shared.TypeLoader.Load(System.String,Microsoft.Build.BuildEngine.Shared.AssemblyLoadInfo):Microsoft.Build.BuildEngine.Shared.LoadedType", MessageId="System.Reflection.Assembly.LoadFrom", Justification="We are deliberately calling LoadFrom, and we know what we're doing.")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope="namespace", Target="Microsoft.Build.BuildEngine", Justification="Microsoft.Build.BuildEngine is an approved namespace according to http://ddwww/apps/apiowners/")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.TaskWorkerThread.NodeActionLoop(Microsoft.Build.BuildEngine.TaskWorkerThread+NodeLoopExecutionMode,System.Int32,Microsoft.Build.BuildEngine.BuildResult[]):System.Void", Justification="This is a very tight loop, extracting methods would introduce overhead which is detremental in this case")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.Scanner.Advance():System.Boolean", Justification="I think this is most easily understandable as it is written.")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="type", Target="Microsoft.Build.BuildEngine.ColorResetter", MessageId="Resetter", Justification="Resetter may not be a real word in the dictionary, but most people will figure out what it means and it's spelled correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1010:CollectionsShouldImplementGenericInterface", Scope="type", Target="Microsoft.Build.BuildEngine.ImportCollection", Justification="We shouldn't implement generic interfaces in the engine only - we need to address this across the product if the team thinks its worth it.  I'll open a separate bug for that.")]
[module: SuppressMessage("Microsoft.Design", "CA1059:MembersShouldNotExposeCertainConcreteTypes", Scope="member", Target="Microsoft.Build.BuildEngine.InvalidProjectFileException..ctor(System.Xml.XmlNode,System.String,System.String,System.String,System.String)", MessageId="System.Xml.XmlNode", Justification="This is by design, we need specific functionality provided by XMLDoc/Node classes that is not exposed by IXPathNavigable.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope="type", Target="Microsoft.Build.BuildEngine.BuildPropertyGroupCollection", Justification="The strongly typed version of CopyTo is provided, but has a different name to avoid problems with COM interop.")]
[module: SuppressMessage("Microsoft.Performance", "CA1823:AvoidUnusedPrivateFields", Scope="member", Target="Microsoft.Build.BuildEngine.ItemExpander.itemVectorWithoutSeparatorSpecification", Justification="These fields are actually used, but only to compose static constants, so they aren't visible in the assembly")]
[module: SuppressMessage("Microsoft.Performance", "CA1823:AvoidUnusedPrivateFields", Scope="member", Target="Microsoft.Build.BuildEngine.ItemExpander.itemVectorWithTransformRHS", Justification="These fields are actually used, but only to compose static constants, so they aren't visible in the assembly")]
[module: SuppressMessage("Microsoft.Performance", "CA1823:AvoidUnusedPrivateFields", Scope="member", Target="Microsoft.Build.BuildEngine.ItemExpander.itemVectorWithTransformLHS", Justification="These fields are actually used, but only to compose static constants, so they aren't visible in the assembly")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.Introspector.DetectDeadlock(System.Int32,System.Int64,System.Int32):System.Int32", Justification="Ignore for now")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.TaskEngine.ExecuteInstantiatedTask(Microsoft.Build.BuildEngine.EngineProxy,Microsoft.Build.BuildEngine.ItemBucket,Microsoft.Build.BuildEngine.TaskExecutionMode,Microsoft.Build.Framework.ITask,System.Boolean&):System.Boolean", Justification="General exception types caught as part of task plugin model")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.TaskEngine.GatherTaskItemOutputs(Microsoft.Build.BuildEngine.Lookup,Microsoft.Build.BuildEngine.TaskOutput,System.String,System.String,System.Object):System.Void", Justification="According to the code author it is faster to use 'is' than 'as' here")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.TaskEngine.InitializeTask(Microsoft.Build.Framework.ITask,Microsoft.Build.BuildEngine.ItemBucket,Microsoft.Build.BuildEngine.EngineProxy):System.Boolean", Justification="General exception types caught as part of task plugin model")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.BuildProject(Microsoft.Build.BuildEngine.Project,System.String[]):System.Boolean", Justification="IProjectCacheable is going away soon.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.EngineBuildLoop(Microsoft.Build.BuildEngine.BuildRequest):Microsoft.Build.BuildEngine.BuildResult", Justification="These are tight performance critical loops, additional method calls due to refactoring could have a performance impact")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.BuildProject(Microsoft.Build.BuildEngine.Project,System.String[],System.Collections.IDictionary,Microsoft.Build.BuildEngine.BuildSettings):System.Boolean", Justification="IProjectCacheable is going away soon.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.UnregisterLoggersInternal(System.Collections.ArrayList):System.Void", Justification="Used to catch all exceptions related to logger initialization so they can be handled correctly. ")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.RegisterLogger(Microsoft.Build.Framework.ILogger):System.Void", Justification="We do rethrow the exception, we just wrap it in a known exception so we know where it came from.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.BuildProject(Microsoft.Build.BuildEngine.Project):System.Boolean", Justification="IProjectCacheable is going away soon.")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.RegisterLoggerInternal(Microsoft.Build.Framework.ILogger,Microsoft.Build.BuildEngine.EventSource,System.Boolean):System.Void", Justification="an is, is being used to determine which type of logger is being use, it is faster to do an is then a single usage of the correct type rather than an as")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.RegisterLoggerInternal(Microsoft.Build.Framework.ILogger,Microsoft.Build.BuildEngine.EventSource,System.Boolean):System.Void", Justification="Used to catch all exceptions related to logger initialization so they can be handled correctly. ")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.RegisterDistributedLogger(Microsoft.Build.Framework.ILogger,Microsoft.Build.BuildEngine.LoggerDescription):System.Void", Justification="Used to catch all exceptions related to logger initialization so they can be handled correctly. ")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.UnregisterAllLoggers():System.Void", Justification="We do rethrow the exception, we just wrap it in a known exception so we know where it came from.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.BuildProject(Microsoft.Build.BuildEngine.Project,System.String[],System.Collections.IDictionary):System.Boolean", Justification="I don't think so.  IProjectCacheable is an internal-only interface, and Engine.BuildProject is public.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.SolutionWrapperProject.AddPropertyGroupForAspNetConfiguration(Microsoft.Build.BuildEngine.Project,Microsoft.Build.BuildEngine.Shared.ProjectInSolution,System.String,Microsoft.Build.BuildEngine.Shared.AspNetCompilerParameters,System.String):System.Void", Justification="We do rethrow the exception as part of the call to ExceptionHandling.RethrowUnlessFileIO")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.SolutionWrapperProject.ScanProjectDependencies(Microsoft.Build.BuildEngine.Shared.SolutionParser,Microsoft.Build.BuildEngine.Engine,System.String,Microsoft.Build.Framework.BuildEventContext):System.Void", Justification="We don't want any problems scanning the project file to result in aborting the build.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.SolutionWrapperProject.AddTargetForWebProject(Microsoft.Build.BuildEngine.Project,Microsoft.Build.BuildEngine.Shared.SolutionParser,Microsoft.Build.BuildEngine.Shared.ProjectInSolution,System.String):System.Void", Justification="[lukaszg] A helper method rethrows the exception but FXCop cannot see that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.SolutionWrapperProject.AddTargetForVCProject(Microsoft.Build.BuildEngine.Project,Microsoft.Build.BuildEngine.Shared.SolutionParser,Microsoft.Build.BuildEngine.Shared.ProjectInSolution,System.String):System.Void", Justification="[lukaszg] A helper method rethrows the exception but FXCop cannot see that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseBuildStartedEvent(System.Object,Microsoft.Build.Framework.BuildStartedEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseTaskFinishedEvent(System.Object,Microsoft.Build.Framework.TaskFinishedEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseProjectFinishedEvent(System.Object,Microsoft.Build.Framework.ProjectFinishedEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseMessageEvent(System.Object,Microsoft.Build.Framework.BuildMessageEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseStronglyTypedEvent(Microsoft.Build.Framework.BuildEventArgs):System.Void", Justification="for performance reasons is is used rather than an as")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseWarningEvent(System.Object,Microsoft.Build.Framework.BuildWarningEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseTargetStartedEvent(System.Object,Microsoft.Build.Framework.TargetStartedEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseProjectStartedEvent(System.Object,Microsoft.Build.Framework.ProjectStartedEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseTargetFinishedEvent(System.Object,Microsoft.Build.Framework.TargetFinishedEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseBuildFinishedEvent(System.Object,Microsoft.Build.Framework.BuildFinishedEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseAnyEvent(System.Object,Microsoft.Build.Framework.BuildEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseTaskStartedEvent(System.Object,Microsoft.Build.Framework.TaskStartedEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseCustomEvent(System.Object,Microsoft.Build.Framework.CustomBuildEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseErrorEvent(System.Object,Microsoft.Build.Framework.BuildErrorEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseStatusEvent(System.Object,Microsoft.Build.Framework.BuildStatusEventArgs):System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.InternalLoggerException.SetDefaultsBeforeSerialization(System.Runtime.Serialization.StreamingContext):System.Void", MessageId="sc", Justification="Using the before serialization to set defaults. Am not using the serialization Context")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.InternalLoggerException.SetValueAfterDeserialization(System.Runtime.Serialization.StreamingContext):System.Void", MessageId="sx", Justification="Serialization context is not used but is required for method signature")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeCallback.SharedMemoryWriterThread():System.Void", Justification="Used to catch all exceptions at different points on child engines so they can be forwarded to the parent engine")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeCallback.PostMessageToParent(Microsoft.Build.BuildEngine.LocalCallDescriptor,System.Boolean):System.Void", Justification="Catch all exceptions so that they can be sent back to the parent")]
[module: SuppressMessage("Microsoft.Design", "CA1010:CollectionsShouldImplementGenericInterface", Scope="type", Target="Microsoft.Build.BuildEngine.BuildItemGroup", Justification="We shouldn't implement generic interfaces in the engine only - we need to address this across the product if the team thinks its worth it.  I'll open a separate bug for that.")]
[module: SuppressMessage("Microsoft.Naming", "CA1710:IdentifiersShouldHaveCorrectSuffix", Scope="type", Target="Microsoft.Build.BuildEngine.BuildItemGroup", Justification="This class represents the <ItemGroup> element in the XMake project file, so the name is appropriate.  We also have a class that represents a collection of these things, and we wouldn't want to call that class BuildItemCollectionCollection.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.ProjectStartedHandler(System.Object,Microsoft.Build.Framework.ProjectStartedEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.ProjectFinishedHandler(System.Object,Microsoft.Build.Framework.ProjectFinishedEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.ApplyParameter(System.String,System.String):System.Void", MessageId="parameterValue", Justification="Would be a breaking change to fix this now (on a public method) and it's not worth the risk.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.MessageHandler(System.Object,Microsoft.Build.Framework.BuildMessageEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TaskStartedHandler(System.Object,Microsoft.Build.Framework.TaskStartedEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TaskFinishedHandler(System.Object,Microsoft.Build.Framework.TaskFinishedEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TargetFinishedHandler(System.Object,Microsoft.Build.Framework.TargetFinishedEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.BuildStartedHandler(System.Object,Microsoft.Build.Framework.BuildStartedEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.BuildStartedHandler(System.Object,Microsoft.Build.Framework.BuildStartedEventArgs):System.Void", Justification="No, this makes no sense.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.CustomEventHandler(System.Object,Microsoft.Build.Framework.CustomBuildEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.CustomEventHandler(System.Object,Microsoft.Build.Framework.CustomBuildEventArgs):System.Void", Justification="No, this makes no sense.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TargetStartedHandler(System.Object,Microsoft.Build.Framework.TargetStartedEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.BuildFinishedHandler(System.Object,Microsoft.Build.Framework.BuildFinishedEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.ErrorHandler(System.Object,Microsoft.Build.Framework.BuildErrorEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.WarningHandler(System.Object,Microsoft.Build.Framework.BuildWarningEventArgs):System.Void", Justification="Reviewed these.  They are public by design so that the HostLogger can call them.")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.GroupingCollection.InsertAfter(Microsoft.Build.BuildEngine.IItemPropertyGrouping,Microsoft.Build.BuildEngine.IItemPropertyGrouping):System.Void", Justification="I don't think fixing either of these is worth it.  In both cases, a series of run-time type checks are performed to properly identify an input's type.  To avoid the second cast (after the is check), we'd need to allocate local variables for each of the three possible types, and we'd only end up using one - I wouldn't be surprised if that in fact led to another FxCop violation.")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.GroupingCollection.InsertAtEnd(Microsoft.Build.BuildEngine.IItemPropertyGrouping):System.Void", Justification="I don't think fixing either of these is worth it.  In both cases, a series of run-time type checks are performed to properly identify an input's type.  To avoid the second cast (after the is check), we'd need to allocate local variables for each of the three possible types, and we'd only end up using one - I wouldn't be surprised if that in fact led to another FxCop violation.")]
[module: SuppressMessage("Microsoft.Usage", "CA2201:DoNotRaiseReservedExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.ReportExceptionEngineCommand.Execute(Microsoft.Build.BuildEngine.Engine):System.Void", Justification="used to wrap communication errors")]
[module: SuppressMessage("Microsoft.Design", "CA1059:MembersShouldNotExposeCertainConcreteTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Project.Xml", MessageId="System.Xml.XmlNode", Justification="This is by design, we need specific functionality provided by XMLDoc/Node classes that is not exposed by IXPathNavigable.")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.NullCentralLogger.AnyEventRaisedHandler(System.Object,Microsoft.Build.Framework.BuildEventArgs):System.Void", Justification="These will only be called by the engine")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope="type", Target="Microsoft.Build.BuildEngine.TargetCollection", Justification="The strongly typed version of CopyTo is provided, but has a different name to avoid problems with COM interop.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1500:VariableNamesShouldNotMatchFieldNames", Scope="member", Target="Microsoft.Build.BuildEngine.PropertyCacheEntry.set_Value(System.String):System.Void", MessageId="value", Justification="value is proper name")]
[module: SuppressMessage("Microsoft.Design", "CA1032:ImplementStandardExceptionConstructors", Scope="type", Target="Microsoft.Build.BuildEngine.RemoteErrorException", Justification="This class is used to wrap remote exceptions, it is not to be instantiated by the public")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.LaunchNodeAndPostBuildRequest():System.Void", Justification="A helper method rethrows the exception, but FXCop cannot detect that.")]
[module: SuppressMessage("Microsoft.Usage", "CA2201:DoNotRaiseReservedExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.LaunchNodeAndPostBuildRequest():System.Void", Justification="used to wrap communication failures")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.RecordNodeResponse(System.Int32,Microsoft.Build.BuildEngine.Node+NodeShutdownLevel,System.Int32):System.Void", MessageId="totalTaskTime", Justification="Used for debugging purposes")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.SharedMemoryWriterThread():System.Void", Justification="The exception will be rethrown as an inner exception")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.SharedMemoryReaderThread():System.Void", Justification="The exception will be rethrown as an inner exception")]
[module: SuppressMessage("Microsoft.Performance", "CA1814:PreferJaggedArraysOverMultidimensional", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.InitializeNode(System.Int32):System.Void", MessageId="Body", Justification="We do not want to use jagged arrays as they are not cls compliant")]
[module: SuppressMessage("Microsoft.Design", "CA1001:TypesThatOwnDisposableFieldsShouldBeDisposable", Scope="type", Target="Microsoft.Build.BuildEngine.FileLogger", Justification="FileLogger implements the Shutdown method, which has the same purpose as Dispose. ")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.FileLogger.FileLoggerBuildFinished(System.Object,Microsoft.Build.Framework.BuildFinishedEventArgs):System.Void", Justification="These will only be called by the engine")]
[module: SuppressMessage("Microsoft.Design", "CA1001:TypesThatOwnDisposableFieldsShouldBeDisposable", Scope="type", Target="Microsoft.Build.BuildEngine.LocalNode", Justification="We are already disposing of the shared memory within the reader method so that it is only disposed when it is finished being used")]
[module: SuppressMessage("Microsoft.Usage", "CA2201:DoNotRaiseReservedExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode.ReportFatalCommunicationError(System.Exception):System.Void", Justification="used to wrap communication errors")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode.ShutdownHandler(System.Exception):System.Void", Justification=" Ignore exception because the error may have been caused by the parent failing in which case we want to avoid additional watson dialogs for each child node")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode.SharedMemoryReaderThread():System.Void", Justification="Used to catch all exceptions at different points on child engines so they can be forwarded to the parent engine")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode.StartLocalNodeServer(System.Int32):System.Void", MessageId="System.GC.Collect", Justification="We need to free resources when we know the resources are not going to be needed right away, in this case the node will be idling and does not need its resources")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode.ShutdownNode(Microsoft.Build.BuildEngine.Node+NodeShutdownLevel,System.Boolean,System.Boolean):System.Void", Justification="Report all communications which do not involve loss of node to node communication")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="Microsoft.Build.BuildEngine.SharedMemory.pageFileView", Justification="Used as an offset rather than a handle")]
[module: SuppressMessage("Microsoft.Usage", "CA2213:DisposableFieldsShouldBeDisposed", Scope="member", Target="Microsoft.Build.BuildEngine.SharedMemory.Dispose(System.Boolean):System.Void", MessageId="writeStream", Justification="the build writer when closed will close  its associated base stream")]
[module: SuppressMessage("Microsoft.Usage", "CA2213:DisposableFieldsShouldBeDisposed", Scope="member", Target="Microsoft.Build.BuildEngine.SharedMemory.Dispose(System.Boolean):System.Void", MessageId="readStream", Justification="BuildReader will close its base stream when closed")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostStatus(Microsoft.Build.BuildEngine.NodeStatus,System.Boolean):System.Void", Justification="Used to catch all exceptions at different points on child engines so they can be forwarded to the parent engine")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1500:VariableNamesShouldNotMatchFieldNames", Scope="member", Target="Microsoft.Build.BuildEngine.Node.UpdateNodeSettings(System.Boolean,System.Boolean,System.Boolean):System.Void", MessageId="useBreadthFirstTraversal", Justification="Used to set bool field, variable is not used for any other reason")]
[module: SuppressMessage("Microsoft.Usage", "CA2201:DoNotRaiseReservedExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.ReportUnhandledError(System.Exception):System.Void", Justification="used to wrap communication errors")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostBuildResultToHost(Microsoft.Build.BuildEngine.BuildResult):System.Void", Justification="Used to catch all exceptions at different points on child engines so they can be forwarded to the parent engine")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostBuildResult(Microsoft.Build.BuildEngine.BuildResult):System.Void", Justification="Used to catch all exceptions at different points on child engines so they can be forwarded to the parent engine")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostLoggingMessagesToHost(Microsoft.Build.BuildEngine.NodeLoggingEvent[]):System.Void", Justification="Used to catch all exceptions at different points on child engines so they can be forwarded to the parent engine")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.GetCachedEntriesFromHost(System.String[],System.String,Microsoft.Build.BuildEngine.BuildPropertyGroup,System.String,Microsoft.Build.BuildEngine.CacheContentType):Microsoft.Build.BuildEngine.CacheEntry[]", Justification="Used to catch all exceptions at different points on child engines so they can be forwarded to the parent engine")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.NodeLocalEngineLoop():System.Void", Justification="We actually rethrow the exception but FXCop doesn't detect that")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostBuildRequestToHost(Microsoft.Build.BuildEngine.BuildRequest):System.Void", Justification="Used to catch all exceptions at different points on child engines so they can be forwarded to the parent engine")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostCacheEntriesToHost(Microsoft.Build.BuildEngine.CacheEntry[],System.String,Microsoft.Build.BuildEngine.BuildPropertyGroup,System.String,Microsoft.Build.BuildEngine.CacheContentType):System.Exception", Justification="Used to catch all exceptions at different points on child engines so they can be forwarded to the parent engine")]
[module: SuppressMessage("Microsoft.Design", "CA1010:CollectionsShouldImplementGenericInterface", Scope="type", Target="Microsoft.Build.BuildEngine.Target", Justification="We shouldn't implement generic interfaces in the engine only - we need to address this across the product if the team thinks its worth it.  I'll open a separate bug for that.")]
[module: SuppressMessage("Microsoft.Naming", "CA1710:IdentifiersShouldHaveCorrectSuffix", Scope="type", Target="Microsoft.Build.BuildEngine.Target", Justification="This doesn't make sense for us. It is better for it to map to the name of the element in our XML file format. ")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.BuildEngine.Utilities.Escape(System.String):System.String", MessageId="0#unescaped", Justification="unescaped is spelled correctly.")]
[module: SuppressMessage("Microsoft.Design", "CA1010:CollectionsShouldImplementGenericInterface", Scope="type", Target="Microsoft.Build.BuildEngine.BuildPropertyGroup", Justification="We shouldn't implement generic interfaces in the engine only - we need to address this across the product if the team thinks its worth it.  I'll open a separate bug for that.")]
[module: SuppressMessage("Microsoft.Naming", "CA1710:IdentifiersShouldHaveCorrectSuffix", Scope="type", Target="Microsoft.Build.BuildEngine.BuildPropertyGroup", Justification="This class represents the <PropertyGroup> element in the XMake project file, so the name is appropriate.  We also have a class that represents a collection of these things, and we wouldn't want to call that class BuildPropertyCollectionCollection.")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.TaskEngineAssemblyResolver.ResolveAssembly(System.Object,System.ResolveEventArgs):System.Reflection.Assembly", MessageId="System.Reflection.Assembly.LoadFrom", Justification="We need to call Assembly.LoadFrom, it's by design. It's an optional way to load task assemblies.")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope="type", Target="Microsoft.Build.BuildEngine.BuildItemGroupCollection", Justification="The strongly typed version of CopyTo is provided, but has a different name to avoid problems with COM interop.")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.ExpressionShredder.GetReferencedItemNamesAndMetadata(System.String,System.Int32,System.Int32,Microsoft.Build.BuildEngine.ItemsAndMetadataPair&,Microsoft.Build.BuildEngine.ShredderOptions):System.Void", Justification="Any simpler and the readability would suffer, I think")]
[module: SuppressMessage("Microsoft.Performance", "CA1802:UseLiteralsWhereAppropriate", Scope="member", Target="Microsoft.Build.BuildEngine.NativeMethods.NullPtr", Justification="Cannot declare IntPtr as const must be static readonly")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Scheduler.NotifyOfBuildRequest(System.Int32,Microsoft.Build.BuildEngine.BuildRequest,System.Int32):System.Void", MessageId="currentRequest", Justification="Parameters are used to document API")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Scheduler.NotifyOfBuildRequest(System.Int32,Microsoft.Build.BuildEngine.BuildRequest,System.Int32):System.Void", MessageId="parentHandleId", Justification="Parameters are used to document API")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Scheduler.NotifyOfBuildRequest(System.Int32,Microsoft.Build.BuildEngine.BuildRequest,System.Int32):System.Void", MessageId="nodeIndex", Justification="Parameters are used to document API")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Scheduler.NotifyOfBuildResult(System.Int32,Microsoft.Build.BuildEngine.BuildResult):System.Void", MessageId="nodeId", Justification="Parameters are used to document API")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.XmlSearcher.GetElementAndAttributeNumber(System.Xml.XmlNode,System.Int32&,System.Int32&):System.Boolean", Justification="Again, code readability would degrade too much to save a single cast within this method.")]
[module: SuppressMessage("Microsoft.Design", "CA1010:CollectionsShouldImplementGenericInterface", Scope="type", Target="Microsoft.Build.BuildEngine.UsingTaskCollection", Justification="We shouldn't implement generic interfaces in the engine only - we need to address this across the product if the team thinks its worth it.  I'll open a separate bug for that.")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.BuildRequest..ctor(System.Int32,System.String,System.String[],System.Collections.IDictionary,System.String,System.Int32,System.Boolean,System.Boolean)", Justification="For performance reasons  and is and cast is faster than an  as")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1500:VariableNamesShouldNotMatchFieldNames", Scope="member", Target="Microsoft.Build.BuildEngine.TaskExecutionContext.SetTaskOutputs(System.Boolean,System.Exception,System.Int64):System.Void", MessageId="taskExecutedSuccessfully", Justification="These are used to set the fields in TaskExecutionContext, the variable names are important in describing what they are setting. There is no other code in the SetOutPuts so the variables cannot be confused for local ones - vladf")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1500:VariableNamesShouldNotMatchFieldNames", Scope="member", Target="Microsoft.Build.BuildEngine.TaskExecutionContext.SetTaskOutputs(System.Boolean,System.Exception,System.Int64):System.Void", MessageId="thrownException", Justification="These are used to set the fields in TaskExecutionContext, the variable names are important in describing what they are setting. There is no other code in the SetOutPuts so the variables cannot be confused for local ones - vladf")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Engine.Resources.Strings.resources", MessageId="precompilation", Justification="precompilation is correctly spelled.")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Engine.Resources.Strings.resources", MessageId="devenv", Justification="devenv is correctly spelled.")]

[module: SuppressMessage("Microsoft.Design", "CA2210:AssembliesShouldHaveValidStrongNames")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope="namespace", Target="Microsoft.Build.BuildEngine")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.TaskWorkerThread.NodeActionLoop(Microsoft.Build.BuildEngine.TaskWorkerThread+NodeLoopExecutionMode,System.Int32,Microsoft.Build.BuildEngine.BuildResult[]):System.Void")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.Scanner.Advance():System.Boolean")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="type", Target="Microsoft.Build.BuildEngine.ColorResetter", MessageId="Resetter")]
[module: SuppressMessage("Microsoft.Design", "CA1010:CollectionsShouldImplementGenericInterface", Scope="type", Target="Microsoft.Build.BuildEngine.ImportCollection")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.InvalidProjectFileException.GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1059:MembersShouldNotExposeCertainConcreteTypes", Scope="member", Target="Microsoft.Build.BuildEngine.InvalidProjectFileException..ctor(System.Xml.XmlNode,System.String,System.String,System.String,System.String)", MessageId="System.Xml.XmlNode")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope="type", Target="Microsoft.Build.BuildEngine.BuildPropertyGroupCollection")]
[module: SuppressMessage("Microsoft.Performance", "CA1823:AvoidUnusedPrivateFields", Scope="member", Target="Microsoft.Build.BuildEngine.ItemExpander.itemVectorWithoutSeparatorSpecification")]
[module: SuppressMessage("Microsoft.Performance", "CA1823:AvoidUnusedPrivateFields", Scope="member", Target="Microsoft.Build.BuildEngine.ItemExpander.itemVectorWithTransformRHS")]
[module: SuppressMessage("Microsoft.Performance", "CA1823:AvoidUnusedPrivateFields", Scope="member", Target="Microsoft.Build.BuildEngine.ItemExpander.itemVectorWithTransformLHS")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Introspector.SystemShutdown():System.Void", MessageId="Microsoft.Build.Shared.ErrorUtilities.ThrowInternalError(System.String,System.Object[])")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.Introspector.DetectDeadlock(System.Int32,System.Int64,System.Int32):System.Int32")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.TaskEngine.ExecuteInstantiatedTask(Microsoft.Build.BuildEngine.EngineProxy,Microsoft.Build.BuildEngine.ItemBucket,Microsoft.Build.BuildEngine.TaskExecutionMode,Microsoft.Build.Framework.ITask,System.Boolean&):System.Boolean")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.TaskEngine.GatherTaskItemOutputs(Microsoft.Build.BuildEngine.Lookup,Microsoft.Build.BuildEngine.TaskOutput,System.String,System.String,System.Object):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.TaskEngine.InitializeTask(Microsoft.Build.Framework.ITask,Microsoft.Build.BuildEngine.ItemBucket,Microsoft.Build.BuildEngine.EngineProxy):System.Boolean")]
[module: SuppressMessage("Microsoft.Design", "CA1001:TypesThatOwnDisposableFieldsShouldBeDisposable", Scope="type", Target="Microsoft.Build.BuildEngine.Engine")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.BuildProject(Microsoft.Build.BuildEngine.Project,System.String[]):System.Boolean")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.EngineBuildLoop(Microsoft.Build.BuildEngine.BuildRequest):Microsoft.Build.BuildEngine.BuildResult")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.BuildProject(Microsoft.Build.BuildEngine.Project,System.String[],System.Collections.IDictionary,Microsoft.Build.BuildEngine.BuildSettings):System.Boolean")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.RegisterLogger(Microsoft.Build.Framework.ILogger):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.BuildProject(Microsoft.Build.BuildEngine.Project):System.Boolean")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.BuildProject(Microsoft.Build.BuildEngine.Project,System.String[],System.Collections.IDictionary):System.Boolean")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.RegisterDistributedLogger(Microsoft.Build.Framework.ILogger,Microsoft.Build.BuildEngine.LoggerDescription):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Engine.UnregisterAllLoggers():System.Void")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.SerialConsoleLogger.VerifyStack(System.Boolean,System.String,System.Object[]):System.Void", MessageId="Microsoft.Build.Framework.BuildErrorEventArgs.#ctor(System.String,System.String,System.String,System.Int32,System.Int32,System.Int32,System.Int32,System.String,System.String,System.String)")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.SerialConsoleLogger.VerifyStack(System.Boolean,System.String,System.Object[]):System.Void", MessageId="Microsoft.Build.Shared.ErrorUtilities.ThrowInternalError(System.String,System.Object[])")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseBuildStartedEvent(System.Object,Microsoft.Build.Framework.BuildStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseTaskFinishedEvent(System.Object,Microsoft.Build.Framework.TaskFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseProjectFinishedEvent(System.Object,Microsoft.Build.Framework.ProjectFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseMessageEvent(System.Object,Microsoft.Build.Framework.BuildMessageEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseStronglyTypedEvent(Microsoft.Build.Framework.BuildEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseWarningEvent(System.Object,Microsoft.Build.Framework.BuildWarningEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseTargetStartedEvent(System.Object,Microsoft.Build.Framework.TargetStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseProjectStartedEvent(System.Object,Microsoft.Build.Framework.ProjectStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseTargetFinishedEvent(System.Object,Microsoft.Build.Framework.TargetFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseBuildFinishedEvent(System.Object,Microsoft.Build.Framework.BuildFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseAnyEvent(System.Object,Microsoft.Build.Framework.BuildEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseTaskStartedEvent(System.Object,Microsoft.Build.Framework.TaskStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseCustomEvent(System.Object,Microsoft.Build.Framework.CustomBuildEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseErrorEvent(System.Object,Microsoft.Build.Framework.BuildErrorEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.EventSource.RaiseStatusEvent(System.Object,Microsoft.Build.Framework.BuildStatusEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.InternalLoggerException.GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext):System.Void")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.InternalLoggerException.SetDefaultsBeforeSerialization(System.Runtime.Serialization.StreamingContext):System.Void", MessageId="sc")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.InternalLoggerException.SetValueAfterDeserialization(System.Runtime.Serialization.StreamingContext):System.Void", MessageId="sx")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.CopyOnWriteHashtable..ctor(System.Collections.IDictionary,System.StringComparer)", MessageId="Microsoft.Build.Shared.InternalErrorException.#ctor(System.String,System.Boolean)")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.CopyOnWriteHashtable..ctor(System.Collections.IDictionary,System.StringComparer)", MessageId="Microsoft.Build.Shared.ErrorUtilities.ThrowInternalError(System.String,System.Object[])")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeCallback.SharedMemoryWriterThread():System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeCallback.PostMessageToParent(Microsoft.Build.BuildEngine.LocalCallDescriptor,System.Boolean):System.Void")]
[module: SuppressMessage("Microsoft.Usage", "CA2201:DoNotRaiseReservedExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.BuildItem.BuildItemHelper(System.Xml.XmlDocument,System.String,System.String,System.Boolean,Microsoft.Build.BuildEngine.ItemDefinitionLibrary):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1010:CollectionsShouldImplementGenericInterface", Scope="type", Target="Microsoft.Build.BuildEngine.BuildItemGroup")]
[module: SuppressMessage("Microsoft.Naming", "CA1710:IdentifiersShouldHaveCorrectSuffix", Scope="type", Target="Microsoft.Build.BuildEngine.BuildItemGroup")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.ProjectStartedHandler(System.Object,Microsoft.Build.Framework.ProjectStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.ProjectStartedHandler(System.Object,Microsoft.Build.Framework.ProjectStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.ProjectFinishedHandler(System.Object,Microsoft.Build.Framework.ProjectFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.ProjectFinishedHandler(System.Object,Microsoft.Build.Framework.ProjectFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.ApplyParameter(System.String,System.String):System.Void", MessageId="parameterValue")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.MessageHandler(System.Object,Microsoft.Build.Framework.BuildMessageEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.MessageHandler(System.Object,Microsoft.Build.Framework.BuildMessageEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TaskStartedHandler(System.Object,Microsoft.Build.Framework.TaskStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TaskStartedHandler(System.Object,Microsoft.Build.Framework.TaskStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TaskFinishedHandler(System.Object,Microsoft.Build.Framework.TaskFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TaskFinishedHandler(System.Object,Microsoft.Build.Framework.TaskFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TargetFinishedHandler(System.Object,Microsoft.Build.Framework.TargetFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TargetFinishedHandler(System.Object,Microsoft.Build.Framework.TargetFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.BuildStartedHandler(System.Object,Microsoft.Build.Framework.BuildStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.BuildStartedHandler(System.Object,Microsoft.Build.Framework.BuildStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.BuildStartedHandler(System.Object,Microsoft.Build.Framework.BuildStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.CustomEventHandler(System.Object,Microsoft.Build.Framework.CustomBuildEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.CustomEventHandler(System.Object,Microsoft.Build.Framework.CustomBuildEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.CustomEventHandler(System.Object,Microsoft.Build.Framework.CustomBuildEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TargetStartedHandler(System.Object,Microsoft.Build.Framework.TargetStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.TargetStartedHandler(System.Object,Microsoft.Build.Framework.TargetStartedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.Initialize(Microsoft.Build.Framework.IEventSource):System.Void")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.BuildFinishedHandler(System.Object,Microsoft.Build.Framework.BuildFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.BuildFinishedHandler(System.Object,Microsoft.Build.Framework.BuildFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.ErrorHandler(System.Object,Microsoft.Build.Framework.BuildErrorEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.ConsoleLogger.WarningHandler(System.Object,Microsoft.Build.Framework.BuildWarningEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.GroupingCollection.InsertAfter(Microsoft.Build.BuildEngine.IItemPropertyGrouping,Microsoft.Build.BuildEngine.IItemPropertyGrouping):System.Void")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.GroupingCollection.InsertAtEnd(Microsoft.Build.BuildEngine.IItemPropertyGrouping):System.Void")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.EngineProxy.GetUpdatedMessage(System.String,System.String,System.String):System.String", MessageId="parentProjectFullFileName")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.EngineProxy.GetUpdatedMessage(System.String,System.String,System.String):System.String", MessageId="file")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.EngineProxy.LogErrorEvent(Microsoft.Build.Framework.BuildErrorEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Usage", "CA2201:DoNotRaiseReservedExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.ReportExceptionEngineCommand.Execute(Microsoft.Build.BuildEngine.Engine):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1059:MembersShouldNotExposeCertainConcreteTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Project.Xml", MessageId="System.Xml.XmlNode")]
[module: SuppressMessage("Microsoft.Reliability", "CA2000:DisposeObjectsBeforeLosingScope", Scope="member", Target="Microsoft.Build.BuildEngine.Project.get_Xml():System.String")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.NullCentralLogger.AnyEventRaisedHandler(System.Object,Microsoft.Build.Framework.BuildEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.NullCentralLogger.Initialize(Microsoft.Build.Framework.IEventSource,System.Int32):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope="type", Target="Microsoft.Build.BuildEngine.TargetCollection")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1500:VariableNamesShouldNotMatchFieldNames", Scope="member", Target="Microsoft.Build.BuildEngine.PropertyCacheEntry.set_Value(System.String):System.Void", MessageId="value")]
[module: SuppressMessage("Microsoft.Design", "CA1032:ImplementStandardExceptionConstructors", Scope="type", Target="Microsoft.Build.BuildEngine.RemoteErrorException")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.RemoteErrorException.GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext):System.Void")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.RecordNodeResponse(System.Int32,Microsoft.Build.BuildEngine.Node+NodeShutdownLevel,System.Int32):System.Void", MessageId="totalTaskTime")]
[module: SuppressMessage("Microsoft.Reliability", "CA2000:DisposeObjectsBeforeLosingScope", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.LaunchNode(System.Int32):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.SharedMemoryWriterThread():System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.SharedMemoryReaderThread():System.Void")]
[module: SuppressMessage("Microsoft.Globalization", "CA1303:DoNotPassLiteralsAsLocalizedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.ReportNodeCommunicationFailure(System.Int32,System.Exception,System.Boolean):System.Void", MessageId="System.Exception.#ctor(System.String,System.Exception)")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1500:VariableNamesShouldNotMatchFieldNames", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.Initialize(System.String,Microsoft.Build.BuildEngine.IEngineCallback,Microsoft.Build.BuildEngine.BuildPropertyGroup,Microsoft.Build.BuildEngine.ToolsetDefinitionLocations,System.String):System.Void", MessageId="startupDirectory")]
[module: SuppressMessage("Microsoft.Performance", "CA1814:PreferJaggedArraysOverMultidimensional", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.InitializeNode(System.Int32):System.Void", MessageId="Body")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.LaunchNodeAndPostBuildRequest():System.Void")]
[module: SuppressMessage("Microsoft.Usage", "CA2201:DoNotRaiseReservedExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNodeProvider.LaunchNodeAndPostBuildRequest():System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1001:TypesThatOwnDisposableFieldsShouldBeDisposable", Scope="type", Target="Microsoft.Build.BuildEngine.FileLogger")]
[module: SuppressMessage("Microsoft.Performance", "CA1807:AvoidUnnecessaryStringCreation", Scope="member", Target="Microsoft.Build.BuildEngine.FileLogger.ApplyFileLoggerParameter(System.String,System.String):System.Void", MessageId="parameterName")]
[module: SuppressMessage("Microsoft.Security", "CA2109:ReviewVisibleEventHandlers", Scope="member", Target="Microsoft.Build.BuildEngine.FileLogger.FileLoggerBuildFinished(System.Object,Microsoft.Build.Framework.BuildFinishedEventArgs):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.FileLogger.Initialize(Microsoft.Build.Framework.IEventSource):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1001:TypesThatOwnDisposableFieldsShouldBeDisposable", Scope="type", Target="Microsoft.Build.BuildEngine.LocalNode")]
[module: SuppressMessage("Microsoft.Performance", "CA1810:InitializeReferenceTypeStaticFieldsInline", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode..cctor()")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode.ShutdownNode(Microsoft.Build.BuildEngine.Node+NodeShutdownLevel,System.Boolean,System.Boolean):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode.SharedMemoryReaderThread():System.Void")]
[module: SuppressMessage("Microsoft.Usage", "CA2201:DoNotRaiseReservedExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode.ReportFatalCommunicationError(System.Exception):System.Void")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode.StartLocalNodeServer(System.Int32):System.Void", MessageId="System.GC.Collect")]
[module: SuppressMessage("Microsoft.Reliability", "CA2000:DisposeObjectsBeforeLosingScope", Scope="member", Target="Microsoft.Build.BuildEngine.LocalNode.StartLocalNodeServer(System.Int32):System.Void")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="Microsoft.Build.BuildEngine.SharedMemory.pageFileView")]
[module: SuppressMessage("Microsoft.Usage", "CA2213:DisposableFieldsShouldBeDisposed", Scope="member", Target="Microsoft.Build.BuildEngine.SharedMemory.Dispose(System.Boolean):System.Void", MessageId="writeStream")]
[module: SuppressMessage("Microsoft.Usage", "CA2213:DisposableFieldsShouldBeDisposed", Scope="member", Target="Microsoft.Build.BuildEngine.SharedMemory.Dispose(System.Boolean):System.Void", MessageId="readStream")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostStatus(Microsoft.Build.BuildEngine.NodeStatus,System.Boolean):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.ReportUnhandledError(System.Exception):System.Void")]
[module: SuppressMessage("Microsoft.Usage", "CA2201:DoNotRaiseReservedExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.ReportUnhandledError(System.Exception):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostBuildResultToHost(Microsoft.Build.BuildEngine.BuildResult):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostLoggingMessagesToHost(Microsoft.Build.BuildEngine.NodeLoggingEvent[]):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.GetCachedEntriesFromHost(System.String[],System.String,Microsoft.Build.BuildEngine.BuildPropertyGroup,System.String,Microsoft.Build.BuildEngine.CacheContentType):Microsoft.Build.BuildEngine.CacheEntry[]")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.NodeLocalEngineLoop():System.Void")]
[module: SuppressMessage("Microsoft.Usage", "CA2201:DoNotRaiseReservedExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.ReportFatalCommunicationError(System.Exception,System.IO.TextWriter):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostBuildResult(Microsoft.Build.BuildEngine.BuildResult):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostBuildRequestToHost(Microsoft.Build.BuildEngine.BuildRequest):System.Void")]
[module: SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes", Scope="member", Target="Microsoft.Build.BuildEngine.Node.PostCacheEntriesToHost(Microsoft.Build.BuildEngine.CacheEntry[],System.String,Microsoft.Build.BuildEngine.BuildPropertyGroup,System.String,Microsoft.Build.BuildEngine.CacheContentType):System.Exception")]
[module: SuppressMessage("Microsoft.Design", "CA1010:CollectionsShouldImplementGenericInterface", Scope="type", Target="Microsoft.Build.BuildEngine.Target")]
[module: SuppressMessage("Microsoft.Naming", "CA1710:IdentifiersShouldHaveCorrectSuffix", Scope="type", Target="Microsoft.Build.BuildEngine.Target")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.BaseConsoleLogger+ITaskItemItemSpecComparer.Compare(System.Object,System.Object):System.Int32")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.ItemBucket.CompareTo(System.Object):System.Int32")]
[module: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope="member", Target="Microsoft.Build.BuildEngine.Utilities.Escape(System.String):System.String", MessageId="0#unescaped")]
[module: SuppressMessage("Microsoft.Design", "CA1010:CollectionsShouldImplementGenericInterface", Scope="type", Target="Microsoft.Build.BuildEngine.BuildPropertyGroup")]
[module: SuppressMessage("Microsoft.Naming", "CA1710:IdentifiersShouldHaveCorrectSuffix", Scope="type", Target="Microsoft.Build.BuildEngine.BuildPropertyGroup")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.BuildPropertyGroup.set_Item(System.String,Microsoft.Build.BuildEngine.BuildProperty):System.Void")]
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.TaskEngineAssemblyResolver.ResolveAssembly(System.Object,System.ResolveEventArgs):System.Reflection.Assembly", MessageId="System.Reflection.Assembly.LoadFrom")]
[module: SuppressMessage("Microsoft.Design", "CA1035:ICollectionImplementationsHaveStronglyTypedMembers", Scope="type", Target="Microsoft.Build.BuildEngine.BuildItemGroupCollection")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity", Scope="member", Target="Microsoft.Build.BuildEngine.ExpressionShredder.GetReferencedItemNamesAndMetadata(System.String,System.Int32,System.Int32,Microsoft.Build.BuildEngine.ItemsAndMetadataPair&,Microsoft.Build.BuildEngine.ShredderOptions):System.Void")]
[module: SuppressMessage("Microsoft.Performance", "CA1802:UseLiteralsWhereAppropriate", Scope="member", Target="Microsoft.Build.BuildEngine.NativeMethods.NullPtr")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Scheduler.NotifyOfBuildRequest(System.Int32,Microsoft.Build.BuildEngine.BuildRequest,System.Int32):System.Void", MessageId="currentRequest")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Scheduler.NotifyOfBuildRequest(System.Int32,Microsoft.Build.BuildEngine.BuildRequest,System.Int32):System.Void", MessageId="parentHandleId")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Scheduler.NotifyOfBuildRequest(System.Int32,Microsoft.Build.BuildEngine.BuildRequest,System.Int32):System.Void", MessageId="nodeIndex")]
[module: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", Scope="member", Target="Microsoft.Build.BuildEngine.Scheduler.NotifyOfBuildResult(System.Int32,Microsoft.Build.BuildEngine.BuildResult):System.Void", MessageId="nodeId")]
[module: SuppressMessage("Microsoft.Reliability", "CA2000:DisposeObjectsBeforeLosingScope", Scope="member", Target="Microsoft.Build.BuildEngine.ProjectSchemaValidationHandler.VerifyProjectFileSchema(System.String,System.String):System.Void")]
[module: SuppressMessage("Microsoft.Reliability", "CA2000:DisposeObjectsBeforeLosingScope", Scope="member", Target="Microsoft.Build.BuildEngine.ProjectSchemaValidationHandler.VerifyProjectSchema(System.String,System.String):System.Void")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.XmlSearcher.GetElementAndAttributeNumber(System.Xml.XmlNode,System.Int32&,System.Int32&):System.Boolean")]
[module: SuppressMessage("Microsoft.Design", "CA1010:CollectionsShouldImplementGenericInterface", Scope="type", Target="Microsoft.Build.BuildEngine.UsingTaskCollection")]
[module: SuppressMessage("Microsoft.Performance", "CA1800:DoNotCastUnnecessarily", Scope="member", Target="Microsoft.Build.BuildEngine.BuildRequest..ctor(System.Int32,System.String,System.String[],System.Collections.IDictionary,System.String,System.Int32,System.Boolean,System.Boolean)")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1500:VariableNamesShouldNotMatchFieldNames", Scope="member", Target="Microsoft.Build.BuildEngine.TaskExecutionContext.SetTaskOutputs(System.Boolean,System.Exception,System.Int64):System.Void", MessageId="taskExecutedSuccessfully")]
[module: SuppressMessage("Microsoft.Maintainability", "CA1500:VariableNamesShouldNotMatchFieldNames", Scope="member", Target="Microsoft.Build.BuildEngine.TaskExecutionContext.SetTaskOutputs(System.Boolean,System.Exception,System.Int64):System.Void", MessageId="thrownException")]
[module: SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods", Scope="member", Target="Microsoft.Build.BuildEngine.BaseConsoleLogger.Initialize(Microsoft.Build.Framework.IEventSource):System.Void")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Engine.Resources.Strings.resources", MessageId="precompilation")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="Microsoft.Build.Engine.Resources.Strings.resources", MessageId="devenv")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="vcproj", Scope="resource", Target="Microsoft.Build.Engine.Resources.Strings.resources", Justification="vcproj is a file extension and is spelled correctly")]
[module: SuppressMessage("Microsoft.Reliability","CA2001:AvoidCallingProblematicMethods", MessageId="System.Reflection.Assembly.LoadWithPartialName", Scope="member", Target="Microsoft.Build.BuildEngine.Expander+Function.#GetTypeFromAssembly(System.String,System.String)")]

#endif
