import { TransportItemType } from '../../transports';
import { getCurrentTimestamp } from '../../utils';
import { defaultExceptionType } from './const';
export function initializeExceptionsAPI(config, transports, metas, tracesApi) {
    const pushError = (error, options = {}) => {
        var _a;
        const type = options.type || error.name || defaultExceptionType;
        const stackFrames = (_a = options.stackFrames) !== null && _a !== void 0 ? _a : (error.stack && config.parseStacktrace ? config.parseStacktrace(error).frames : undefined);
        const item = {
            meta: metas.value,
            payload: {
                type,
                value: error.message,
                timestamp: getCurrentTimestamp(),
                trace: tracesApi.getTraceContext(),
            },
            type: TransportItemType.EXCEPTION,
        };
        if (stackFrames === null || stackFrames === void 0 ? void 0 : stackFrames.length) {
            item.payload.stacktrace = {
                frames: stackFrames,
            };
        }
        transports.execute(item);
    };
    return {
        pushError,
    };
}
//# sourceMappingURL=initialize.js.map