import { BettererOptionsRunner, BettererOptionsStart, BettererOptionsResults, BettererOptionsWatch, BettererOptionsMerge } from './config';
import { BettererRunner } from './runner';
import { BettererResultsSummary } from './results';
import { BettererSuiteSummary } from './suite';
/**
 * @public Run **Betterer** with the given options.
 *
 * @example
 * ```typescript
 * import { betterer } from '@betterer/betterer';
 *
 * const suiteSummary = await betterer(options);
 * ```
 *
 * @param options - Options for running **Betterer**.
 * @throws {@link @betterer/errors#BettererError | `BettererError` }
 * Will throw if something goes wrong while running **Betterer**.
 */
export declare function betterer(options?: BettererOptionsStart): Promise<BettererSuiteSummary>;
export declare namespace betterer {
    var merge: typeof import("./betterer").merge;
    var results: typeof import("./betterer").results;
    var runner: typeof import("./betterer").runner;
    var watch: typeof import("./betterer").watch;
}
/**
 * @public Resolve any merge conflicts in the specified results file.
 *
 * @example
 * ```typescript
 * import { betterer } from '@betterer/betterer';
 *
 * await betterer.merge(options);
 * ```
 *
 * @param options - Options for merging conflicts in the results file.
 * @throws {@link @betterer/errors#BettererError | `BettererError` }
 * Will throw if something goes wrong while merging conflicts in the results file.
 */
export declare function merge(options?: BettererOptionsMerge): Promise<void>;
/**
 * @public Get a summary of the results of the defined {@link @betterer/betterer#BettererTest | `BettererTest`s}.
 *
 * **Betterer** will read the {@link https://phenomnomnominal.github.io/betterer/docs/test-definition-file | test definition file }
 * and the {@link https://phenomnomnominal.github.io/betterer/docs/results-file | results file} and return a summary of the results.
 *
 * @example
 * ```typescript
 * import { betterer } from '@betterer/betterer';
 *
 * const resultsSummary = await betterer.results(options);
 * ```
 *
 * @param options - Options for getting the summary of the results.
 * @throws {@link @betterer/errors#BettererError | `BettererError` }
 * Will throw if something goes wrong while getting the summary of the results.
 */
export declare function results(options?: BettererOptionsResults): Promise<BettererResultsSummary>;
/**
 * @public Create a **BettererRunner** with the given options.
 *
 * @example
 * ```typescript
 * import { betterer } from '@betterer/betterer';
 *
 * const runner = await betterer.runner(options);
 * ```
 *
 * @param options - Options for creating the runner.
 * @throws {@link @betterer/errors#BettererError | `BettererError` }
 * Will throw if something goes wrong while creating the runner.
 */
export declare function runner(options?: BettererOptionsRunner): Promise<BettererRunner>;
/**
 * @public Create a **BettererRunner** with the given options. Also starts up a file watcher
 * for tracked files in the current working directory.
 *
 * @example
 * ```typescript
 * import { betterer } from '@betterer/betterer';
 *
 * const runner = await betterer.watch(options);
 * ```
 *
 * @param options - Options for creating the runner.
 * @throws {@link @betterer/errors#BettererError | `BettererError` }
 * Will throw if something goes wrong while creating the runner or watcher.
 */
export declare function watch(options?: BettererOptionsWatch): Promise<BettererRunner>;
//# sourceMappingURL=betterer.d.ts.map