"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BettererRunΩ = void 0;
const results_1 = require("../results");
const utils_1 = require("../utils");
class BettererRunΩ {
    constructor(name, _workerHandle, testMeta, baseline, expected, filePaths) {
        this.name = name;
        this._workerHandle = _workerHandle;
        this.testMeta = testMeta;
        this.baseline = baseline;
        this.expected = expected;
        this.filePaths = filePaths;
        this.isNew = testMeta.isNew;
        this.isSkipped = testMeta.isSkipped;
        // Always run all files for a new test, even if just passed a single file:
        if (this.isNew && this.filePaths) {
            this.filePaths = [];
        }
    }
    static async create(runWorkerPool, testName, config, filePaths, versionControl) {
        const workerHandle = runWorkerPool.getWorkerHandle();
        await workerHandle.free;
        workerHandle.claim();
        const testMeta = await workerHandle.worker.init(testName, config, versionControl);
        workerHandle.release();
        const baseline = !testMeta.isNew ? new results_1.BettererResultΩ(JSON.parse(testMeta.baselineJSON)) : null;
        const expected = !testMeta.isNew ? new results_1.BettererResultΩ(JSON.parse(testMeta.expectedJSON)) : null;
        return new BettererRunΩ(testName, workerHandle, testMeta, baseline, expected, testMeta.isFileTest ? filePaths : null);
    }
    async run(isSkipped) {
        await this._workerHandle.free;
        this._workerHandle.claim();
        const timestamp = (0, utils_1.getTime)();
        const summary = await this._workerHandle.worker.run(this.name, this.filePaths, isSkipped, timestamp);
        this._workerHandle.release();
        return summary;
    }
}
exports.BettererRunΩ = BettererRunΩ;
//# sourceMappingURL=run.js.map