"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BettererSuiteSummaryΩ = void 0;
class BettererSuiteSummaryΩ {
    constructor(filePaths, runs, runSummaries, changed) {
        this.filePaths = filePaths;
        this.runs = runs;
        this.runSummaries = runSummaries;
        this.changed = changed;
    }
    get completed() {
        return this.runSummaries.filter((runSummary) => runSummary.isComplete);
    }
    get expired() {
        return this.runSummaries.filter((runSummary) => runSummary.isExpired);
    }
    get better() {
        return this.runSummaries.filter((runSummary) => runSummary.isBetter);
    }
    get failed() {
        return this.runSummaries.filter((runSummary) => runSummary.isFailed);
    }
    get new() {
        return this.runSummaries.filter((runSummary) => runSummary.isNew && !(runSummary.isSkipped || runSummary.isFailed || runSummary.isComplete));
    }
    get ran() {
        return this.runSummaries.filter((runSummary) => !(runSummary.isSkipped || runSummary.isFailed));
    }
    get same() {
        return this.runSummaries.filter((runSummary) => runSummary.isSame);
    }
    get skipped() {
        return this.runSummaries.filter((runSummary) => runSummary.isSkipped);
    }
    get updated() {
        return this.runSummaries.filter((runSummary) => runSummary.isUpdated);
    }
    get worse() {
        return this.runSummaries.filter((runSummary) => runSummary.isWorse);
    }
}
exports.BettererSuiteSummaryΩ = BettererSuiteSummaryΩ;
//# sourceMappingURL=suite-summary.js.map