import { BettererFileTest } from '@betterer/betterer';
/**
 * @public  Use this test to incrementally remove {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp | `RegExp` }
 * matches from your codebase.
 *
 * @remarks {@link regexp | `regexp`} is a {@link @betterer/betterer#BettererFileTest | `BettererFileTest`},
 * so you can use {@link @betterer/betterer#BettererFileTest.include | `include()`}, {@link @betterer/betterer#BettererFileTest.exclude | `exclude()`},
 * {@link @betterer/betterer#BettererFileTest.only | `only()`}, and {@link @betterer/betterer#BettererFileTest.skip | `skip()`}.
 *
 * @example
 * ```typescript
 * import { regexp } from '@betterer/regexp';
 *
 * export default {
 *   'no hack comments': () =>
 *     regexp(/(\/\/\s*HACK)/i)
 *     .include('./src/*.ts')
 * };
 * ```
 *
 * @param pattern - A {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp | `RegExp` }
 * pattern to match.
 *
 * @throws {@link @betterer/errors#BettererError | `BettererError` }
 * Will throw if the user doesn't pass `pattern`.
 */
export declare function regexp(pattern: RegExp): BettererFileTest;
//# sourceMappingURL=regexp.d.ts.map