"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
exports.__esModule = true;
var addons_1 = require("@storybook/addons");
var theming_1 = require("@storybook/theming");
var React = __importStar(require("react"));
var Tool_1 = __importStar(require("./Tool"));
var currentStore = Tool_1.store();
var currentTheme = currentStore.current || (Tool_1.prefersDark.matches && 'dark') || 'light';
addons_1.addons.setConfig({
    theme: __assign(__assign({}, theming_1.themes[currentTheme]), currentStore[currentTheme])
});
addons_1.addons.register('storybook/dark-mode', function (api) {
    addons_1.addons.add('storybook/dark-mode', {
        title: 'dark mode',
        type: addons_1.types.TOOL,
        match: function (_a) {
            var viewMode = _a.viewMode;
            return viewMode === 'story' || viewMode === 'docs';
        },
        render: function () { return React.createElement(Tool_1["default"], { api: api }); }
    });
});
//# sourceMappingURL=register.js.map