"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Results = void 0;
const render_1 = require("@betterer/render");
const worker_require_1 = require("@phenomnomnominal/worker-require");
const tasks_1 = require("@betterer/tasks");
const Results = function Results({ options }) {
    const [resultsSummary, setResultsSummary] = (0, render_1.useState)(null);
    (0, render_1.useEffect)(() => {
        void (async () => {
            const getResultsSummary = (0, worker_require_1.workerRequire)('./get-results-summary');
            try {
                setResultsSummary(await getResultsSummary.run(options));
            }
            finally {
                await getResultsSummary.destroy();
            }
        })();
    }, [options]);
    const app = (0, render_1.useApp)();
    (0, render_1.useEffect)(() => {
        if (resultsSummary) {
            setImmediate(() => app.exit());
        }
    }, [resultsSummary]);
    return (render_1.React.createElement(render_1.Box, { flexDirection: "column" },
        render_1.React.createElement(tasks_1.BettererLogo, null),
        resultsSummary && (render_1.React.createElement(render_1.Box, { flexDirection: "column" }, resultsSummary.resultSummaries.map((resultSummary) => {
            if (resultSummary.isFileTest) {
                return (render_1.React.createElement(render_1.Box, { key: resultSummary.name, flexDirection: "column" },
                    render_1.React.createElement(render_1.Text, { color: "yellowBright" }, `${resultSummary.name}: `),
                    render_1.React.createElement(render_1.Box, { flexDirection: "column", paddingTop: 1, paddingLeft: 2 }, Object.keys(resultSummary.details).map((filePath) => {
                        const issues = resultSummary.details[filePath];
                        return issues.map((issue, index) => (render_1.React.createElement(render_1.Box, { key: index },
                            render_1.React.createElement(render_1.Text, null, issue.message),
                            render_1.React.createElement(render_1.Text, null, " - "),
                            render_1.React.createElement(render_1.Text, { color: "cyan" }, filePath),
                            render_1.React.createElement(render_1.Text, null, ":"),
                            render_1.React.createElement(render_1.Text, { color: "yellow" }, issue.line + 1),
                            render_1.React.createElement(render_1.Text, null, ":"),
                            render_1.React.createElement(render_1.Text, { color: "yellow" }, issue.column))));
                    }))));
            }
            return (render_1.React.createElement(render_1.Box, { key: resultSummary.name },
                render_1.React.createElement(render_1.Text, { color: "yellowBright" }, `${resultSummary.name}: `),
                render_1.React.createElement(render_1.Text, null, resultSummary.details)));
        })))));
};
exports.Results = Results;
//# sourceMappingURL=results.js.map