import {useMemo as $1OoTj$useMemo, useEffect as $1OoTj$useEffect} from "react";
import {useMultipleSelectionState as $1OoTj$useMultipleSelectionState, SelectionManager as $1OoTj$SelectionManager} from "@react-stately/selection";
import {useCollection as $1OoTj$useCollection} from "@react-stately/collections";
import {useControlledState as $1OoTj$useControlledState} from "@react-stately/utils";

function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}
var $875d6693e12af071$exports = {};

$parcel$export($875d6693e12af071$exports, "useTreeState", () => $875d6693e12af071$export$728d6ba534403756);


var tmp = Symbol.iterator;
class $05ca4cd7c4a5a999$export$863faf230ee2118a {
    *[tmp]() {
        yield* this.iterable;
    }
    get size() {
        return this.keyMap.size;
    }
    getKeys() {
        return this.keyMap.keys();
    }
    getKeyBefore(key) {
        let node = this.keyMap.get(key);
        return node ? node.prevKey : null;
    }
    getKeyAfter(key) {
        let node = this.keyMap.get(key);
        return node ? node.nextKey : null;
    }
    getFirstKey() {
        return this.firstKey;
    }
    getLastKey() {
        return this.lastKey;
    }
    getItem(key) {
        return this.keyMap.get(key);
    }
    at(idx) {
        const keys = [
            ...this.getKeys()
        ];
        return this.getItem(keys[idx]);
    }
    constructor(nodes, { expandedKeys: expandedKeys  } = {
    }){
        this.keyMap = new Map();
        this.iterable = nodes;
        expandedKeys = expandedKeys || new Set();
        let visit = (node)=>{
            this.keyMap.set(node.key, node);
            if (node.childNodes && (node.type === 'section' || expandedKeys.has(node.key))) for (let child of node.childNodes)visit(child);
        };
        for (let node2 of nodes)visit(node2);
        let last;
        let index = 0;
        for (let [key, node1] of this.keyMap){
            if (last) {
                last.nextKey = key;
                node1.prevKey = last.key;
            } else {
                this.firstKey = key;
                node1.prevKey = undefined;
            }
            if (node1.type === 'item') node1.index = index++;
            last = node1;
            // Set nextKey as undefined since this might be the last node
            // If it isn't the last node, last.nextKey will properly set at start of new loop
            last.nextKey = undefined;
        }
        this.lastKey = last === null || last === void 0 ? void 0 : last.key;
    }
}




function $875d6693e12af071$export$728d6ba534403756(props) {
    let [expandedKeys, setExpandedKeys] = $1OoTj$useControlledState(props.expandedKeys ? new Set(props.expandedKeys) : undefined, props.defaultExpandedKeys ? new Set(props.defaultExpandedKeys) : new Set(), props.onExpandedChange);
    let selectionState = $1OoTj$useMultipleSelectionState(props);
    let disabledKeys = $1OoTj$useMemo(()=>props.disabledKeys ? new Set(props.disabledKeys) : new Set()
    , [
        props.disabledKeys
    ]);
    let tree = $1OoTj$useCollection(props, (nodes)=>new $05ca4cd7c4a5a999$export$863faf230ee2118a(nodes, {
            expandedKeys: expandedKeys
        })
    , null, [
        expandedKeys
    ]);
    // Reset focused key if that item is deleted from the collection.
    $1OoTj$useEffect(()=>{
        if (selectionState.focusedKey != null && !tree.getItem(selectionState.focusedKey)) selectionState.setFocusedKey(null);
    }, [
        tree,
        selectionState.focusedKey
    ]);
    let onToggle = (key)=>{
        setExpandedKeys($875d6693e12af071$var$toggleKey(expandedKeys, key));
    };
    return {
        collection: tree,
        expandedKeys: expandedKeys,
        disabledKeys: disabledKeys,
        toggleKey: onToggle,
        selectionManager: new $1OoTj$SelectionManager(tree, selectionState)
    };
}
function $875d6693e12af071$var$toggleKey(set, key) {
    let res = new Set(set);
    if (res.has(key)) res.delete(key);
    else res.add(key);
    return res;
}




export {$875d6693e12af071$export$728d6ba534403756 as useTreeState};
//# sourceMappingURL=module.js.map
