"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.code__ = void 0;
const tslib_1 = require("tslib");
const code_frame_1 = require("@babel/code-frame");
const lines_and_columns_1 = require("lines-and-columns");
const path = (0, tslib_1.__importStar)(require("path"));
const IS_JS_REGEXP = /.t|jsx?$/;
/**
 * @internal Definitely not stable! Please don't use!
 *
 * Logs a code block with syntax highlighting and a message.
 */
function code__(codeInfo) {
    const { filePath, fileText, message } = codeInfo;
    const isJS = IS_JS_REGEXP.exec(path.extname(filePath));
    const options = {
        highlightCode: !!isJS,
        message
    };
    const lc = new lines_and_columns_1.LinesAndColumns(fileText);
    const startLocation = codeInfo;
    const startIndex = lc.indexForLocation(startLocation) || 0;
    const endLocation = lc.locationForIndex(startIndex + codeInfo.length) || startLocation;
    const start = {
        line: startLocation.line + 1,
        column: startLocation.column + 1
    };
    const end = {
        line: endLocation.line + 1,
        column: endLocation.column + 1
    };
    // `codeFrameColumns` doesn't handle empty strings very well!
    return `\n  ${filePath}\n${(0, code_frame_1.codeFrameColumns)(fileText || ' ', { start, end }, options)}\n`;
}
exports.code__ = code__;
//# sourceMappingURL=code.js.map