import { Node, SourceFile, TransformationContext } from 'typescript';
export declare type TSTemplateApi = {
    (tmpl: string, data: TSTemplateData): SourceFile;
    compile: (tmpl: string) => (data: TSTemplateData) => SourceFile;
};
export declare type TSTemplateData = {
    [key: string]: string | Node | Array<Node>;
};
export declare type TSTemplateReplaceOptions = {
    visit: (node: Node, context?: TransformationContext) => Node | null | undefined;
};
export declare type TSTemplateTraverseOptions = {
    enter?: (node: Node, parent: Node | null) => void;
    leave?: (node: Node, parent: Node | null) => void;
};
