/// <reference types="react" />
/**
 * @public The state of the running tasks. `endTime` will only be present when there are no more
 * `running` tasks.
 */
export interface BettererTasksState {
    running: number;
    done: number;
    errors: number;
    startTime: number;
    endTime: number | null;
}
export declare type BettererTasksAction = {
    type: 'start';
} | {
    type: 'stop';
} | {
    type: 'error';
    data: Error;
};
export interface BettererTasksAPI {
    error(error: Error): void;
    start(): void;
    stop(): void;
}
export declare function useTasksState(): [BettererTasksState, BettererTasksAPI];
export declare const BettererTasksContext: import("react").Context<[BettererTasksState, BettererTasksAPI] | null>;
export declare function useTasks(): [BettererTasksState, BettererTasksAPI];
//# sourceMappingURL=useTasksState.d.ts.map