"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BettererRunWorkerPoolΩ = exports.BettererRunWorkerHandleΩ = void 0;
const tslib_1 = require("tslib");
const assert_1 = (0, tslib_1.__importDefault)(require("assert"));
const worker_require_1 = require("@phenomnomnominal/worker-require");
class BettererRunWorkerHandleΩ {
    constructor() {
        this.worker = (0, worker_require_1.workerRequire)('./run-worker', { cache: false });
        this.free = Promise.resolve();
        this._release = null;
    }
    claim() {
        this.free = new Promise((resolve) => {
            this._release = resolve;
        });
    }
    release() {
        (0, assert_1.default)(this._release);
        this._release();
    }
}
exports.BettererRunWorkerHandleΩ = BettererRunWorkerHandleΩ;
class BettererRunWorkerPoolΩ {
    constructor(workerCount) {
        this._handles = [];
        this._handleIndex = 0;
        this._handles = Array.from({ length: workerCount }).map(() => new BettererRunWorkerHandleΩ());
    }
    async destroy() {
        await Promise.all(this._handles.map((handle) => handle.worker.destroy()));
    }
    getWorkerHandle() {
        const worker = this._handles[this._handleIndex];
        this._handleIndex = this._handleIndex + 1 === this._handles.length ? 0 : this._handleIndex + 1;
        return worker;
    }
}
exports.BettererRunWorkerPoolΩ = BettererRunWorkerPoolΩ;
//# sourceMappingURL=run-worker-pool.js.map