"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.precommit = void 0;
const betterer_1 = require("@betterer/betterer");
const options_1 = require("./options");
const types_1 = require("./types");
/**
 * Run **Betterer** in `precommit` mode.
 */
function precommit(cwd) {
    const command = (0, options_1.cliCommand)(types_1.BettererCommand.precommit);
    command.description('run Betterer in precommit mode');
    command.action(async (config, command) => {
        (0, options_1.setEnv)(config);
        // Mark options as unknown...
        const options = {
            cache: config.cache,
            cachePath: config.cachePath,
            configPaths: config.config,
            cwd,
            excludes: config.exclude,
            filters: config.filter,
            includes: command.args,
            precommit: true,
            reporters: config.reporter,
            resultsPath: config.results,
            silent: config.silent,
            tsconfigPath: config.tsconfig,
            workers: config.workers
        };
        try {
            // And then cast to BettererOptionsStart. This is possibly invalid,
            // but it's nicer to do the options validation in @betterer/betterer
            const suiteSummary = await (0, betterer_1.betterer)(options);
            if (suiteSummary.worse.length > 0 || suiteSummary.failed.length > 0) {
                process.exitCode = 1;
            }
        }
        catch (_a) {
            process.exitCode = 1;
        }
    });
    return command;
}
exports.precommit = precommit;
//# sourceMappingURL=precommit.js.map