// Code generated by Wire. DO NOT EDIT.

//go:generate go run github.com/google/wire/cmd/wire gen -tags "oss"
//go:build !wireinject
// +build !wireinject

package server

import (
	"github.com/google/wire"
	httpclient2 "github.com/grafana/grafana-plugin-sdk-go/backend/httpclient"
	"github.com/grafana/grafana/pkg/api"
	"github.com/grafana/grafana/pkg/api/avatar"
	"github.com/grafana/grafana/pkg/api/routing"
	"github.com/grafana/grafana/pkg/bus"
	"github.com/grafana/grafana/pkg/cuectx"
	"github.com/grafana/grafana/pkg/expr"
	registry2 "github.com/grafana/grafana/pkg/framework/coremodel/registry"
	"github.com/grafana/grafana/pkg/infra/httpclient"
	"github.com/grafana/grafana/pkg/infra/httpclient/httpclientprovider"
	"github.com/grafana/grafana/pkg/infra/kvstore"
	"github.com/grafana/grafana/pkg/infra/localcache"
	metrics2 "github.com/grafana/grafana/pkg/infra/metrics"
	"github.com/grafana/grafana/pkg/infra/remotecache"
	"github.com/grafana/grafana/pkg/infra/serverlock"
	"github.com/grafana/grafana/pkg/infra/tracing"
	"github.com/grafana/grafana/pkg/infra/usagestats"
	"github.com/grafana/grafana/pkg/infra/usagestats/service"
	"github.com/grafana/grafana/pkg/infra/usagestats/statscollector"
	"github.com/grafana/grafana/pkg/login"
	"github.com/grafana/grafana/pkg/login/social"
	"github.com/grafana/grafana/pkg/middleware/csrf"
	"github.com/grafana/grafana/pkg/models"
	"github.com/grafana/grafana/pkg/plugins"
	"github.com/grafana/grafana/pkg/plugins/backendplugin/coreplugin"
	provider2 "github.com/grafana/grafana/pkg/plugins/backendplugin/provider"
	"github.com/grafana/grafana/pkg/plugins/config"
	manager3 "github.com/grafana/grafana/pkg/plugins/manager"
	"github.com/grafana/grafana/pkg/plugins/manager/client"
	"github.com/grafana/grafana/pkg/plugins/manager/dashboards"
	"github.com/grafana/grafana/pkg/plugins/manager/loader"
	"github.com/grafana/grafana/pkg/plugins/manager/process"
	"github.com/grafana/grafana/pkg/plugins/manager/registry"
	"github.com/grafana/grafana/pkg/plugins/manager/signature"
	store2 "github.com/grafana/grafana/pkg/plugins/manager/store"
	"github.com/grafana/grafana/pkg/plugins/plugincontext"
	"github.com/grafana/grafana/pkg/plugins/repo"
	"github.com/grafana/grafana/pkg/server/backgroundsvcs"
	"github.com/grafana/grafana/pkg/server/usagestatssvcs"
	"github.com/grafana/grafana/pkg/services/accesscontrol"
	"github.com/grafana/grafana/pkg/services/accesscontrol/acimpl"
	"github.com/grafana/grafana/pkg/services/accesscontrol/ossaccesscontrol"
	"github.com/grafana/grafana/pkg/services/alerting"
	"github.com/grafana/grafana/pkg/services/annotations"
	"github.com/grafana/grafana/pkg/services/annotations/annotationsimpl"
	"github.com/grafana/grafana/pkg/services/apikey/apikeyimpl"
	"github.com/grafana/grafana/pkg/services/auth"
	"github.com/grafana/grafana/pkg/services/auth/jwt"
	"github.com/grafana/grafana/pkg/services/cleanup"
	"github.com/grafana/grafana/pkg/services/comments"
	"github.com/grafana/grafana/pkg/services/contexthandler"
	"github.com/grafana/grafana/pkg/services/contexthandler/authproxy"
	"github.com/grafana/grafana/pkg/services/correlations"
	"github.com/grafana/grafana/pkg/services/dashboard_thumbs/dashboardthumbsimpl"
	"github.com/grafana/grafana/pkg/services/dashboardimport"
	service10 "github.com/grafana/grafana/pkg/services/dashboardimport/service"
	dashboards2 "github.com/grafana/grafana/pkg/services/dashboards"
	database2 "github.com/grafana/grafana/pkg/services/dashboards/database"
	service4 "github.com/grafana/grafana/pkg/services/dashboards/service"
	"github.com/grafana/grafana/pkg/services/dashboardsnapshots"
	database5 "github.com/grafana/grafana/pkg/services/dashboardsnapshots/database"
	service7 "github.com/grafana/grafana/pkg/services/dashboardsnapshots/service"
	"github.com/grafana/grafana/pkg/services/dashboardversion/dashverimpl"
	"github.com/grafana/grafana/pkg/services/datasourceproxy"
	"github.com/grafana/grafana/pkg/services/datasources"
	"github.com/grafana/grafana/pkg/services/datasources/permissions"
	service3 "github.com/grafana/grafana/pkg/services/datasources/service"
	"github.com/grafana/grafana/pkg/services/encryption"
	"github.com/grafana/grafana/pkg/services/encryption/provider"
	service2 "github.com/grafana/grafana/pkg/services/encryption/service"
	"github.com/grafana/grafana/pkg/services/export"
	"github.com/grafana/grafana/pkg/services/featuremgmt"
	"github.com/grafana/grafana/pkg/services/guardian"
	"github.com/grafana/grafana/pkg/services/hooks"
	"github.com/grafana/grafana/pkg/services/kmsproviders/osskmsproviders"
	"github.com/grafana/grafana/pkg/services/ldap"
	"github.com/grafana/grafana/pkg/services/libraryelements"
	"github.com/grafana/grafana/pkg/services/librarypanels"
	"github.com/grafana/grafana/pkg/services/licensing"
	"github.com/grafana/grafana/pkg/services/live"
	"github.com/grafana/grafana/pkg/services/live/pushhttp"
	login2 "github.com/grafana/grafana/pkg/services/login"
	"github.com/grafana/grafana/pkg/services/login/authinfoservice"
	database4 "github.com/grafana/grafana/pkg/services/login/authinfoservice/database"
	"github.com/grafana/grafana/pkg/services/login/loginservice"
	"github.com/grafana/grafana/pkg/services/loginattempt/loginattemptimpl"
	"github.com/grafana/grafana/pkg/services/navtree/navtreeimpl"
	"github.com/grafana/grafana/pkg/services/ngalert"
	"github.com/grafana/grafana/pkg/services/ngalert/image"
	"github.com/grafana/grafana/pkg/services/ngalert/metrics"
	store3 "github.com/grafana/grafana/pkg/services/ngalert/store"
	"github.com/grafana/grafana/pkg/services/notifications"
	"github.com/grafana/grafana/pkg/services/oauthtoken"
	"github.com/grafana/grafana/pkg/services/org/orgimpl"
	"github.com/grafana/grafana/pkg/services/playlist/playlistimpl"
	"github.com/grafana/grafana/pkg/services/plugindashboards"
	service6 "github.com/grafana/grafana/pkg/services/plugindashboards/service"
	"github.com/grafana/grafana/pkg/services/pluginsettings"
	service8 "github.com/grafana/grafana/pkg/services/pluginsettings/service"
	"github.com/grafana/grafana/pkg/services/preference/prefimpl"
	"github.com/grafana/grafana/pkg/services/provisioning"
	"github.com/grafana/grafana/pkg/services/publicdashboards"
	api2 "github.com/grafana/grafana/pkg/services/publicdashboards/api"
	database7 "github.com/grafana/grafana/pkg/services/publicdashboards/database"
	service9 "github.com/grafana/grafana/pkg/services/publicdashboards/service"
	"github.com/grafana/grafana/pkg/services/query"
	"github.com/grafana/grafana/pkg/services/queryhistory"
	"github.com/grafana/grafana/pkg/services/quota/quotaimpl"
	"github.com/grafana/grafana/pkg/services/rendering"
	"github.com/grafana/grafana/pkg/services/search"
	"github.com/grafana/grafana/pkg/services/searchV2"
	"github.com/grafana/grafana/pkg/services/searchusers"
	"github.com/grafana/grafana/pkg/services/searchusers/filters"
	"github.com/grafana/grafana/pkg/services/secrets"
	"github.com/grafana/grafana/pkg/services/secrets/database"
	kvstore2 "github.com/grafana/grafana/pkg/services/secrets/kvstore"
	migrations2 "github.com/grafana/grafana/pkg/services/secrets/kvstore/migrations"
	"github.com/grafana/grafana/pkg/services/secrets/manager"
	"github.com/grafana/grafana/pkg/services/secrets/migrator"
	"github.com/grafana/grafana/pkg/services/serviceaccounts"
	database6 "github.com/grafana/grafana/pkg/services/serviceaccounts/database"
	manager4 "github.com/grafana/grafana/pkg/services/serviceaccounts/manager"
	"github.com/grafana/grafana/pkg/services/shorturls"
	"github.com/grafana/grafana/pkg/services/sqlstore"
	"github.com/grafana/grafana/pkg/services/sqlstore/db"
	"github.com/grafana/grafana/pkg/services/sqlstore/migrations"
	"github.com/grafana/grafana/pkg/services/sqlstore/mockstore"
	"github.com/grafana/grafana/pkg/services/star/starimpl"
	"github.com/grafana/grafana/pkg/services/store"
	"github.com/grafana/grafana/pkg/services/store/sanitizer"
	"github.com/grafana/grafana/pkg/services/tag"
	"github.com/grafana/grafana/pkg/services/tag/tagimpl"
	"github.com/grafana/grafana/pkg/services/team/teamimpl"
	"github.com/grafana/grafana/pkg/services/teamguardian"
	database3 "github.com/grafana/grafana/pkg/services/teamguardian/database"
	manager2 "github.com/grafana/grafana/pkg/services/teamguardian/manager"
	"github.com/grafana/grafana/pkg/services/temp_user"
	"github.com/grafana/grafana/pkg/services/temp_user/tempuserimpl"
	"github.com/grafana/grafana/pkg/services/thumbs"
	"github.com/grafana/grafana/pkg/services/updatechecker"
	"github.com/grafana/grafana/pkg/services/user/userimpl"
	"github.com/grafana/grafana/pkg/services/userauth/userauthimpl"
	"github.com/grafana/grafana/pkg/services/validations"
	"github.com/grafana/grafana/pkg/setting"
	"github.com/grafana/grafana/pkg/tsdb/azuremonitor"
	"github.com/grafana/grafana/pkg/tsdb/cloudmonitoring"
	"github.com/grafana/grafana/pkg/tsdb/cloudwatch"
	"github.com/grafana/grafana/pkg/tsdb/elasticsearch"
	"github.com/grafana/grafana/pkg/tsdb/grafanads"
	"github.com/grafana/grafana/pkg/tsdb/graphite"
	"github.com/grafana/grafana/pkg/tsdb/influxdb"
	"github.com/grafana/grafana/pkg/tsdb/legacydata"
	service5 "github.com/grafana/grafana/pkg/tsdb/legacydata/service"
	"github.com/grafana/grafana/pkg/tsdb/loki"
	"github.com/grafana/grafana/pkg/tsdb/mssql"
	"github.com/grafana/grafana/pkg/tsdb/mysql"
	"github.com/grafana/grafana/pkg/tsdb/opentsdb"
	"github.com/grafana/grafana/pkg/tsdb/postgres"
	"github.com/grafana/grafana/pkg/tsdb/prometheus"
	"github.com/grafana/grafana/pkg/tsdb/tempo"
	"github.com/grafana/grafana/pkg/tsdb/testdatasource"
)

import (
	_ "github.com/grafana/grafana/pkg/extensions"
)

// Injectors from wire.go:

func Initialize(cla setting.CommandLineArgs, opts Options, apiOpts api.ServerOptions) (*Server, error) {
	cfg, err := setting.NewCfgFromArgs(cla)
	if err != nil {
		return nil, err
	}
	routeRegisterImpl := routing.ProvideRegister()
	tracer, err := tracing.ProvideService(cfg)
	if err != nil {
		return nil, err
	}
	inProcBus := bus.ProvideBus(tracer)
	cacheService := localcache.ProvideService()
	ossMigrations := migrations.ProvideOSSMigrations()
	sqlStore, err := sqlstore.ProvideService(cfg, cacheService, ossMigrations, inProcBus, tracer)
	if err != nil {
		return nil, err
	}
	secretsStoreImpl := database.ProvideSecretsStore(sqlStore)
	providerProvider := provider.ProvideEncryptionProvider()
	ossImpl := setting.ProvideProvider(cfg)
	configCfg := config.ProvideConfig(ossImpl, cfg)
	inMemory := registry.ProvideService()
	hooksService := hooks.ProvideService()
	ossLicensingService := licensing.ProvideService(cfg, hooksService)
	unsignedPluginAuthorizer := signature.ProvideOSSAuthorizer(configCfg)
	ossPluginRequestValidator := validations.ProvideValidator()
	httpclientProvider := httpclientprovider.New(cfg, ossPluginRequestValidator, tracer)
	azuremonitorService := azuremonitor.ProvideService(cfg, httpclientProvider, tracer)
	featureManager, err := featuremgmt.ProvideManagerService(cfg, ossLicensingService)
	if err != nil {
		return nil, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	cloudWatchService := cloudwatch.ProvideService(cfg, httpclientProvider, featureToggles)
	cloudmonitoringService := cloudmonitoring.ProvideService(httpclientProvider, tracer)
	elasticsearchService := elasticsearch.ProvideService(httpclientProvider)
	graphiteService := graphite.ProvideService(httpclientProvider, tracer)
	influxdbService := influxdb.ProvideService(httpclientProvider)
	lokiService := loki.ProvideService(httpclientProvider, featureToggles, tracer)
	opentsdbService := opentsdb.ProvideService(httpclientProvider)
	prometheusService := prometheus.ProvideService(httpclientProvider, cfg, featureToggles, tracer)
	tempoService := tempo.ProvideService(httpclientProvider)
	testdatasourceService := testdatasource.ProvideService(cfg, featureToggles)
	postgresService := postgres.ProvideService(cfg)
	mysqlService := mysql.ProvideService(cfg, httpclientProvider)
	mssqlService := mssql.ProvideService(cfg)
	entityEventsService := store.ProvideEntityEventsService(cfg, sqlStore, featureToggles)
	acimplService, err := acimpl.ProvideService(cfg, sqlStore, routeRegisterImpl, cacheService)
	if err != nil {
		return nil, err
	}
	orgService := orgimpl.ProvideService(sqlStore, cfg)
	searchService := searchV2.ProvideService(cfg, sqlStore, entityEventsService, acimplService, tracer, featureToggles, orgService)
	activeAuthTokenService := auth.ProvideActiveAuthTokenService(cfg, sqlStore)
	quotaService := quotaimpl.ProvideService(sqlStore, cfg, activeAuthTokenService, sqlStore)
	storageService := store.ProvideService(sqlStore, featureToggles, cfg, quotaService)
	grafanadsService := grafanads.ProvideService(cfg, searchService, storageService)
	corepluginRegistry := coreplugin.ProvideCoreRegistry(azuremonitorService, cloudWatchService, cloudmonitoringService, elasticsearchService, graphiteService, influxdbService, lokiService, opentsdbService, prometheusService, tempoService, testdatasourceService, postgresService, mysqlService, mssqlService, grafanadsService)
	providerService := provider2.ProvideService(corepluginRegistry)
	loaderLoader := loader.ProvideService(configCfg, ossLicensingService, unsignedPluginAuthorizer, inMemory, providerService)
	storeService, err := store2.ProvideService(cfg, configCfg, inMemory, loaderLoader)
	if err != nil {
		return nil, err
	}
	kvStore := kvstore.ProvideService(sqlStore)
	usageStats := service.ProvideService(cfg, storeService, kvStore, routeRegisterImpl)
	serviceService, err := service2.ProvideEncryptionService(providerProvider, usageStats, ossImpl)
	if err != nil {
		return nil, err
	}
	osskmsprovidersService := osskmsproviders.ProvideService(serviceService, ossImpl, featureToggles)
	secretsService, err := manager.ProvideSecretsService(secretsStoreImpl, osskmsprovidersService, serviceService, ossImpl, featureToggles, usageStats)
	if err != nil {
		return nil, err
	}
	remoteCache, err := remotecache.ProvideService(cfg, sqlStore, secretsService)
	if err != nil {
		return nil, err
	}
	renderingService, err := rendering.ProvideService(cfg, remoteCache, storeService)
	if err != nil {
		return nil, err
	}
	clientService := client.ProvideService(inMemory, configCfg)
	socialService := social.ProvideService(cfg)
	ossUserProtectionImpl := authinfoservice.ProvideOSSUserProtectionService()
	starService := starimpl.ProvideService(sqlStore, cfg)
	tagimplService := tagimpl.ProvideService(sqlStore)
	dashboardStore := database2.ProvideDashboardStore(sqlStore, featureToggles, tagimplService)
	ossDatasourcePermissionsService := permissions.ProvideDatasourcePermissionsService()
	secretsKVStore, err := kvstore2.ProvideService(sqlStore, secretsService, storeService, kvStore, featureToggles, cfg)
	if err != nil {
		return nil, err
	}
	accessControl := acimpl.ProvideAccessControl(cfg)
	datasourcePermissionsService := ossaccesscontrol.ProvideDatasourcePermissionsService()
	service11 := service3.ProvideService(sqlStore, secretsService, secretsKVStore, cfg, featureToggles, accessControl, datasourcePermissionsService)
	alertStore := alerting.ProvideAlertStore(sqlStore, cacheService, cfg, tagimplService)
	dashAlertExtractorService := alerting.ProvideDashAlertExtractorService(ossDatasourcePermissionsService, service11, alertStore)
	teamService := teamimpl.ProvideService(sqlStore, cfg)
	folderPermissionsService, err := ossaccesscontrol.ProvideFolderPermissions(cfg, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, dashboardStore, acimplService, teamService)
	if err != nil {
		return nil, err
	}
	dashboardPermissionsService, err := ossaccesscontrol.ProvideDashboardPermissions(cfg, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, dashboardStore, acimplService, teamService)
	if err != nil {
		return nil, err
	}
	dashboardServiceImpl := service4.ProvideDashboardService(cfg, dashboardStore, dashAlertExtractorService, featureToggles, folderPermissionsService, dashboardPermissionsService, accessControl)
	prefService := prefimpl.ProvideService(sqlStore, cfg, featureManager)
	teamGuardianStoreImpl := database3.ProvideTeamGuardianStore(sqlStore, teamService)
	teamGuardian := manager2.ProvideService(teamGuardianStoreImpl)
	userauthService := userauthimpl.ProvideService(sqlStore)
	userService := userimpl.ProvideService(sqlStore, orgService, starService, dashboardServiceImpl, prefService, teamGuardian, userauthService, quotaService, acimplService, cfg, sqlStore, remoteCache, featureManager)
	loginStore := database4.ProvideAuthInfoStore(sqlStore, secretsService, userService)
	implementation := authinfoservice.ProvideAuthInfoService(ossUserProtectionImpl, loginStore, usageStats)
	oauthtokenService := oauthtoken.ProvideService(socialService, implementation)
	service12 := service5.ProvideService(clientService, oauthtokenService, service11)
	mailer, err := notifications.ProvideSmtpService(cfg)
	if err != nil {
		return nil, err
	}
	tempuserService := tempuserimpl.ProvideService(sqlStore)
	notificationService, err := notifications.ProvideService(inProcBus, cfg, mailer, tempuserService)
	if err != nil {
		return nil, err
	}
	repositoryImpl := annotationsimpl.ProvideService(sqlStore, cfg, tagimplService)
	alertEngine := alerting.ProvideAlertEngine(renderingService, ossPluginRequestValidator, service12, usageStats, serviceService, notificationService, tracer, alertStore, cfg, dashAlertExtractorService, dashboardServiceImpl, cacheService, service11, repositoryImpl)
	fileStoreManager := dashboards.ProvideFileStoreManager(storeService)
	service13 := service6.ProvideService(fileStoreManager, dashboardServiceImpl)
	repoManager := repo.ProvideService()
	pluginInstaller := manager3.ProvideInstaller(configCfg, inMemory, loaderLoader, repoManager)
	cacheServiceImpl := service3.ProvideCacheService(cacheService, sqlStore)
	serverLockService := serverlock.ProvideService(sqlStore, tracer)
	userAuthTokenService := auth.ProvideUserAuthTokenService(sqlStore, serverLockService, remoteCache, featureManager, cfg)
	shortURLService := shorturls.ProvideService(sqlStore)
	queryHistoryService := queryhistory.ProvideService(cfg, sqlStore, routeRegisterImpl)
	dashverService := dashverimpl.ProvideService(sqlStore)
	dashboardSnapshotStore := database5.ProvideStore(sqlStore)
	serviceImpl := service7.ProvideService(dashboardSnapshotStore, secretsService)
	searchSearchService := search.ProvideService(cfg, sqlStore, starService, dashboardServiceImpl)
	folderServiceImpl := service4.ProvideFolderService(cfg, dashboardServiceImpl, dashboardStore, searchSearchService, featureToggles, folderPermissionsService, accessControl, inProcBus)
	dBstore := store3.ProvideDBStore(cfg, sqlStore, folderServiceImpl, accessControl, dashboardServiceImpl)
	deleteExpiredService := image.ProvideDeleteExpiredService(dBstore)
	loginattemptService := loginattemptimpl.ProvideService(sqlStore)
	cleanupServiceImpl := annotationsimpl.ProvideCleanupService(sqlStore, cfg)
	cleanUpService := cleanup.ProvideService(cfg, serverLockService, shortURLService, sqlStore, queryHistoryService, dashverService, serviceImpl, deleteExpiredService, loginattemptService, tempuserService, tracer, cleanupServiceImpl)
	correlationsService := correlations.ProvideService(sqlStore, routeRegisterImpl, service11, accessControl, inProcBus)
	service14 := service8.ProvideService(sqlStore, secretsService)
	plugincontextProvider := plugincontext.ProvideService(cacheService, storeService, cacheServiceImpl, service11, service14)
	exprService := expr.ProvideService(cfg, clientService, service11)
	queryService := query.ProvideService(cfg, cacheServiceImpl, exprService, ossPluginRequestValidator, service11, clientService, oauthtokenService)
	grafanaLive, err := live.ProvideService(plugincontextProvider, cfg, routeRegisterImpl, storeService, cacheService, cacheServiceImpl, sqlStore, secretsService, usageStats, queryService, featureToggles, accessControl, dashboardServiceImpl, repositoryImpl, orgService)
	if err != nil {
		return nil, err
	}
	apikeyService := apikeyimpl.ProvideService(sqlStore, cfg)
	serviceAccountsStoreImpl := database6.ProvideServiceAccountsStore(sqlStore, apikeyService, kvStore, orgService)
	serviceAccountPermissionsService, err := ossaccesscontrol.ProvideServiceAccountPermissions(cfg, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, serviceAccountsStoreImpl, acimplService, teamService)
	if err != nil {
		return nil, err
	}
	serviceAccountsService, err := manager4.ProvideServiceAccountsService(cfg, accessControl, routeRegisterImpl, usageStats, serviceAccountsStoreImpl, serviceAccountPermissionsService, acimplService)
	if err != nil {
		return nil, err
	}
	ossCrawlerAuthSetupService := thumbs.ProvideCrawlerAuthSetupService(serviceAccountsService, serviceAccountsStoreImpl, sqlStore, orgService)
	dashboardthumbsService := dashboardthumbsimpl.ProvideService(sqlStore)
	thumbsService := thumbs.ProvideService(cfg, featureToggles, serverLockService, renderingService, grafanaLive, sqlStore, ossCrawlerAuthSetupService, dashboardServiceImpl, dashboardthumbsService, searchService, ossDatasourcePermissionsService, ossLicensingService)
	alertNotificationService := alerting.ProvideService(sqlStore, serviceService, notificationService)
	provisioningServiceImpl, err := provisioning.ProvideService(accessControl, cfg, sqlStore, storeService, serviceService, notificationService, dashboardServiceImpl, service11, correlationsService, dashboardServiceImpl, folderServiceImpl, alertNotificationService, service14, searchService, quotaService, secretsService)
	if err != nil {
		return nil, err
	}
	loginserviceImplementation := loginservice.ProvideService(sqlStore, userService, quotaService, implementation, acimplService, orgService)
	authenticatorService := login.ProvideService(sqlStore, loginserviceImplementation, loginattemptService, userService)
	dataSourceProxyService := datasourceproxy.ProvideService(cacheServiceImpl, ossPluginRequestValidator, storeService, cfg, httpclientProvider, oauthtokenService, service11, tracer, secretsService)
	gateway := pushhttp.ProvideService(cfg, grafanaLive)
	authService, err := jwt.ProvideService(cfg, remoteCache)
	if err != nil {
		return nil, err
	}
	authProxy := authproxy.ProvideAuthProxy(cfg, remoteCache, loginserviceImplementation, sqlStore)
	contextHandler := contexthandler.ProvideService(cfg, userAuthTokenService, authService, remoteCache, renderingService, sqlStore, tracer, authProxy, loginserviceImplementation, apikeyService, authenticatorService, userService)
	ngAlert := metrics.ProvideService()
	alertNG, err := ngalert.ProvideService(cfg, cacheServiceImpl, service11, routeRegisterImpl, sqlStore, kvStore, exprService, dataSourceProxyService, quotaService, secretsService, notificationService, ngAlert, folderServiceImpl, accessControl, dashboardServiceImpl, renderingService, inProcBus, acimplService, repositoryImpl)
	if err != nil {
		return nil, err
	}
	libraryElementService := libraryelements.ProvideService(cfg, sqlStore, routeRegisterImpl, folderServiceImpl)
	libraryPanelService := librarypanels.ProvideService(cfg, sqlStore, routeRegisterImpl, libraryElementService)
	playlistService := playlistimpl.ProvideService(sqlStore, cfg)
	exportService := export.ProvideService(sqlStore, featureToggles, grafanaLive, cfg, serviceImpl, playlistService, orgService, service11)
	grafanaService := updatechecker.ProvideGrafanaService(cfg)
	pluginsService := updatechecker.ProvidePluginsService(cfg, storeService)
	ossSearchUserFilter := filters.ProvideOSSSearchUserFilter()
	ossService := searchusers.ProvideUsersService(ossSearchUserFilter, userService)
	ossGroups := ldap.ProvideGroupsService()
	commentsService := comments.ProvideService(cfg, sqlStore, grafanaLive, featureToggles, accessControl, dashboardServiceImpl, userService, repositoryImpl)
	avatarCacheServer := avatar.ProvideAvatarCacheServer(cfg)
	teamPermissionsService, err := ossaccesscontrol.ProvideTeamPermissions(cfg, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, acimplService, teamService)
	if err != nil {
		return nil, err
	}
	csrfService := csrf.ProvideCSRFFilter(cfg)
	base := registry2.NewBase()
	secretsMigrator := migrator.ProvideSecretsMigrator(serviceService, secretsService, sqlStore, ossImpl, featureToggles)
	dataSourceSecretMigrationService := migrations2.ProvideDataSourceMigrationService(service11, kvStore, featureToggles)
	migrateToPluginService := migrations2.ProvideMigrateToPluginService(secretsKVStore, cfg, sqlStore, secretsService, kvStore, storeService)
	migrateFromPluginService := migrations2.ProvideMigrateFromPluginService(cfg, sqlStore, secretsService, storeService, kvStore)
	secretMigrationProviderImpl := migrations2.ProvideSecretMigrationProvider(cfg, serverLockService, dataSourceSecretMigrationService, migrateToPluginService, migrateFromPluginService)
	publicDashboardStoreImpl := database7.ProvideStore(sqlStore)
	publicDashboardServiceImpl := service9.ProvideService(cfg, publicDashboardStoreImpl, queryService)
	apiApi := api2.ProvideApi(publicDashboardServiceImpl, routeRegisterImpl, accessControl, featureManager)
	navtreeService := navtreeimpl.ProvideService(cfg, accessControl, storeService, service14, starService, featureManager, dashboardServiceImpl, acimplService, kvStore, apikeyService)
	searchHTTPService := searchV2.ProvideSearchHTTPService(searchService)
	httpServer, err := api.ProvideHTTPServer(apiOpts, cfg, routeRegisterImpl, inProcBus, renderingService, ossLicensingService, hooksService, cacheService, sqlStore, alertEngine, ossPluginRequestValidator, storeService, service13, storeService, clientService, loaderLoader, pluginInstaller, ossImpl, cacheServiceImpl, userAuthTokenService, cleanUpService, shortURLService, queryHistoryService, correlationsService, thumbsService, remoteCache, provisioningServiceImpl, loginserviceImplementation, authenticatorService, accessControl, dataSourceProxyService, searchSearchService, grafanaLive, gateway, plugincontextProvider, contextHandler, featureManager, alertNG, libraryPanelService, libraryElementService, quotaService, socialService, tracer, exportService, serviceService, grafanaService, pluginsService, ossService, service11, queryService, ossGroups, teamGuardian, serviceAccountsService, implementation, storageService, notificationService, dashboardServiceImpl, dashboardServiceImpl, folderServiceImpl, ossDatasourcePermissionsService, alertNotificationService, serviceImpl, commentsService, service14, avatarCacheServer, prefService, teamPermissionsService, folderPermissionsService, dashboardPermissionsService, dashverService, starService, csrfService, base, playlistService, apikeyService, kvStore, secretsMigrator, storeService, secretsService, secretMigrationProviderImpl, secretsKVStore, apiApi, userService, tempuserService, loginattemptService, orgService, teamService, acimplService, dashboardthumbsService, navtreeService, repositoryImpl, tagimplService, searchHTTPService)
	if err != nil {
		return nil, err
	}
	processManager := process.ProvideService(inMemory)
	statscollectorService := statscollector.ProvideService(usageStats, cfg, sqlStore, socialService, storeService, featureManager, service11, httpclientProvider)
	internalMetricsService, err := metrics2.ProvideService(cfg)
	if err != nil {
		return nil, err
	}
	guardianProvider := guardian.ProvideService(sqlStore, accessControl, folderPermissionsService, dashboardPermissionsService, dashboardServiceImpl, teamService)
	importDashboardService := service10.ProvideService(routeRegisterImpl, quotaService, service13, storeService, libraryPanelService, dashboardServiceImpl, accessControl)
	dashboardUpdater := service6.ProvideDashboardUpdater(inProcBus, storeService, service13, importDashboardService, service14, dashboardServiceImpl, dashboardServiceImpl)
	sanitizerProvider := sanitizer.ProvideService(renderingService)
	backgroundServiceRegistry := backgroundsvcs.ProvideBackgroundServiceRegistry(httpServer, alertNG, cleanUpService, grafanaLive, gateway, notificationService, processManager, renderingService, userAuthTokenService, tracer, provisioningServiceImpl, alertEngine, usageStats, statscollectorService, grafanaService, pluginsService, internalMetricsService, secretsService, remoteCache, thumbsService, storageService, searchService, entityEventsService, serviceAccountsService, implementation, secretMigrationProviderImpl, serviceImpl, alertNotificationService, serviceAccountsService, guardianProvider, dashboardUpdater, sanitizerProvider)
	usageStatsProvidersRegistry := usagestatssvcs.ProvideUsageStatsProvidersRegistry(thumbsService, acimplService)
	server, err := New(opts, cfg, httpServer, acimplService, provisioningServiceImpl, backgroundServiceRegistry, usageStatsProvidersRegistry, statscollectorService, userService, loginattemptService)
	if err != nil {
		return nil, err
	}
	return server, nil
}

func InitializeForTest(cla setting.CommandLineArgs, opts Options, apiOpts api.ServerOptions) (*TestEnv, error) {
	cfg, err := setting.NewCfgFromArgs(cla)
	if err != nil {
		return nil, err
	}
	routeRegisterImpl := routing.ProvideRegister()
	tracer, err := tracing.ProvideService(cfg)
	if err != nil {
		return nil, err
	}
	inProcBus := bus.ProvideBus(tracer)
	ossMigrations := migrations.ProvideOSSMigrations()
	sqlStore, err := sqlstore.ProvideServiceForTests(ossMigrations)
	if err != nil {
		return nil, err
	}
	secretsStoreImpl := database.ProvideSecretsStore(sqlStore)
	providerProvider := provider.ProvideEncryptionProvider()
	ossImpl := setting.ProvideProvider(cfg)
	configCfg := config.ProvideConfig(ossImpl, cfg)
	inMemory := registry.ProvideService()
	hooksService := hooks.ProvideService()
	ossLicensingService := licensing.ProvideService(cfg, hooksService)
	unsignedPluginAuthorizer := signature.ProvideOSSAuthorizer(configCfg)
	ossPluginRequestValidator := validations.ProvideValidator()
	httpclientProvider := httpclientprovider.New(cfg, ossPluginRequestValidator, tracer)
	azuremonitorService := azuremonitor.ProvideService(cfg, httpclientProvider, tracer)
	featureManager, err := featuremgmt.ProvideManagerService(cfg, ossLicensingService)
	if err != nil {
		return nil, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	cloudWatchService := cloudwatch.ProvideService(cfg, httpclientProvider, featureToggles)
	cloudmonitoringService := cloudmonitoring.ProvideService(httpclientProvider, tracer)
	elasticsearchService := elasticsearch.ProvideService(httpclientProvider)
	graphiteService := graphite.ProvideService(httpclientProvider, tracer)
	influxdbService := influxdb.ProvideService(httpclientProvider)
	lokiService := loki.ProvideService(httpclientProvider, featureToggles, tracer)
	opentsdbService := opentsdb.ProvideService(httpclientProvider)
	prometheusService := prometheus.ProvideService(httpclientProvider, cfg, featureToggles, tracer)
	tempoService := tempo.ProvideService(httpclientProvider)
	testdatasourceService := testdatasource.ProvideService(cfg, featureToggles)
	postgresService := postgres.ProvideService(cfg)
	mysqlService := mysql.ProvideService(cfg, httpclientProvider)
	mssqlService := mssql.ProvideService(cfg)
	entityEventsService := store.ProvideEntityEventsService(cfg, sqlStore, featureToggles)
	cacheService := localcache.ProvideService()
	acimplService, err := acimpl.ProvideService(cfg, sqlStore, routeRegisterImpl, cacheService)
	if err != nil {
		return nil, err
	}
	orgService := orgimpl.ProvideService(sqlStore, cfg)
	searchService := searchV2.ProvideService(cfg, sqlStore, entityEventsService, acimplService, tracer, featureToggles, orgService)
	activeAuthTokenService := auth.ProvideActiveAuthTokenService(cfg, sqlStore)
	quotaService := quotaimpl.ProvideService(sqlStore, cfg, activeAuthTokenService, sqlStore)
	storageService := store.ProvideService(sqlStore, featureToggles, cfg, quotaService)
	grafanadsService := grafanads.ProvideService(cfg, searchService, storageService)
	corepluginRegistry := coreplugin.ProvideCoreRegistry(azuremonitorService, cloudWatchService, cloudmonitoringService, elasticsearchService, graphiteService, influxdbService, lokiService, opentsdbService, prometheusService, tempoService, testdatasourceService, postgresService, mysqlService, mssqlService, grafanadsService)
	providerService := provider2.ProvideService(corepluginRegistry)
	loaderLoader := loader.ProvideService(configCfg, ossLicensingService, unsignedPluginAuthorizer, inMemory, providerService)
	storeService, err := store2.ProvideService(cfg, configCfg, inMemory, loaderLoader)
	if err != nil {
		return nil, err
	}
	kvStore := kvstore.ProvideService(sqlStore)
	usageStats := service.ProvideService(cfg, storeService, kvStore, routeRegisterImpl)
	serviceService, err := service2.ProvideEncryptionService(providerProvider, usageStats, ossImpl)
	if err != nil {
		return nil, err
	}
	osskmsprovidersService := osskmsproviders.ProvideService(serviceService, ossImpl, featureToggles)
	secretsService, err := manager.ProvideSecretsService(secretsStoreImpl, osskmsprovidersService, serviceService, ossImpl, featureToggles, usageStats)
	if err != nil {
		return nil, err
	}
	remoteCache, err := remotecache.ProvideService(cfg, sqlStore, secretsService)
	if err != nil {
		return nil, err
	}
	renderingService, err := rendering.ProvideService(cfg, remoteCache, storeService)
	if err != nil {
		return nil, err
	}
	clientService := client.ProvideService(inMemory, configCfg)
	socialService := social.ProvideService(cfg)
	ossUserProtectionImpl := authinfoservice.ProvideOSSUserProtectionService()
	starService := starimpl.ProvideService(sqlStore, cfg)
	tagimplService := tagimpl.ProvideService(sqlStore)
	dashboardStore := database2.ProvideDashboardStore(sqlStore, featureToggles, tagimplService)
	ossDatasourcePermissionsService := permissions.ProvideDatasourcePermissionsService()
	secretsKVStore, err := kvstore2.ProvideService(sqlStore, secretsService, storeService, kvStore, featureToggles, cfg)
	if err != nil {
		return nil, err
	}
	accessControl := acimpl.ProvideAccessControl(cfg)
	datasourcePermissionsService := ossaccesscontrol.ProvideDatasourcePermissionsService()
	service11 := service3.ProvideService(sqlStore, secretsService, secretsKVStore, cfg, featureToggles, accessControl, datasourcePermissionsService)
	alertStore := alerting.ProvideAlertStore(sqlStore, cacheService, cfg, tagimplService)
	dashAlertExtractorService := alerting.ProvideDashAlertExtractorService(ossDatasourcePermissionsService, service11, alertStore)
	teamService := teamimpl.ProvideService(sqlStore, cfg)
	folderPermissionsService, err := ossaccesscontrol.ProvideFolderPermissions(cfg, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, dashboardStore, acimplService, teamService)
	if err != nil {
		return nil, err
	}
	dashboardPermissionsService, err := ossaccesscontrol.ProvideDashboardPermissions(cfg, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, dashboardStore, acimplService, teamService)
	if err != nil {
		return nil, err
	}
	dashboardServiceImpl := service4.ProvideDashboardService(cfg, dashboardStore, dashAlertExtractorService, featureToggles, folderPermissionsService, dashboardPermissionsService, accessControl)
	prefService := prefimpl.ProvideService(sqlStore, cfg, featureManager)
	teamGuardianStoreImpl := database3.ProvideTeamGuardianStore(sqlStore, teamService)
	teamGuardian := manager2.ProvideService(teamGuardianStoreImpl)
	userauthService := userauthimpl.ProvideService(sqlStore)
	userService := userimpl.ProvideService(sqlStore, orgService, starService, dashboardServiceImpl, prefService, teamGuardian, userauthService, quotaService, acimplService, cfg, sqlStore, remoteCache, featureManager)
	loginStore := database4.ProvideAuthInfoStore(sqlStore, secretsService, userService)
	implementation := authinfoservice.ProvideAuthInfoService(ossUserProtectionImpl, loginStore, usageStats)
	oauthtokenService := oauthtoken.ProvideService(socialService, implementation)
	service12 := service5.ProvideService(clientService, oauthtokenService, service11)
	mailer, err := notifications.ProvideSmtpService(cfg)
	if err != nil {
		return nil, err
	}
	tempuserService := tempuserimpl.ProvideService(sqlStore)
	notificationService, err := notifications.ProvideService(inProcBus, cfg, mailer, tempuserService)
	if err != nil {
		return nil, err
	}
	repositoryImpl := annotationsimpl.ProvideService(sqlStore, cfg, tagimplService)
	alertEngine := alerting.ProvideAlertEngine(renderingService, ossPluginRequestValidator, service12, usageStats, serviceService, notificationService, tracer, alertStore, cfg, dashAlertExtractorService, dashboardServiceImpl, cacheService, service11, repositoryImpl)
	fileStoreManager := dashboards.ProvideFileStoreManager(storeService)
	service13 := service6.ProvideService(fileStoreManager, dashboardServiceImpl)
	repoManager := repo.ProvideService()
	pluginInstaller := manager3.ProvideInstaller(configCfg, inMemory, loaderLoader, repoManager)
	cacheServiceImpl := service3.ProvideCacheService(cacheService, sqlStore)
	serverLockService := serverlock.ProvideService(sqlStore, tracer)
	userAuthTokenService := auth.ProvideUserAuthTokenService(sqlStore, serverLockService, remoteCache, featureManager, cfg)
	shortURLService := shorturls.ProvideService(sqlStore)
	queryHistoryService := queryhistory.ProvideService(cfg, sqlStore, routeRegisterImpl)
	dashverService := dashverimpl.ProvideService(sqlStore)
	dashboardSnapshotStore := database5.ProvideStore(sqlStore)
	serviceImpl := service7.ProvideService(dashboardSnapshotStore, secretsService)
	searchSearchService := search.ProvideService(cfg, sqlStore, starService, dashboardServiceImpl)
	folderServiceImpl := service4.ProvideFolderService(cfg, dashboardServiceImpl, dashboardStore, searchSearchService, featureToggles, folderPermissionsService, accessControl, inProcBus)
	dBstore := store3.ProvideDBStore(cfg, sqlStore, folderServiceImpl, accessControl, dashboardServiceImpl)
	deleteExpiredService := image.ProvideDeleteExpiredService(dBstore)
	loginattemptService := loginattemptimpl.ProvideService(sqlStore)
	cleanupServiceImpl := annotationsimpl.ProvideCleanupService(sqlStore, cfg)
	cleanUpService := cleanup.ProvideService(cfg, serverLockService, shortURLService, sqlStore, queryHistoryService, dashverService, serviceImpl, deleteExpiredService, loginattemptService, tempuserService, tracer, cleanupServiceImpl)
	correlationsService := correlations.ProvideService(sqlStore, routeRegisterImpl, service11, accessControl, inProcBus)
	service14 := service8.ProvideService(sqlStore, secretsService)
	plugincontextProvider := plugincontext.ProvideService(cacheService, storeService, cacheServiceImpl, service11, service14)
	exprService := expr.ProvideService(cfg, clientService, service11)
	queryService := query.ProvideService(cfg, cacheServiceImpl, exprService, ossPluginRequestValidator, service11, clientService, oauthtokenService)
	grafanaLive, err := live.ProvideService(plugincontextProvider, cfg, routeRegisterImpl, storeService, cacheService, cacheServiceImpl, sqlStore, secretsService, usageStats, queryService, featureToggles, accessControl, dashboardServiceImpl, repositoryImpl, orgService)
	if err != nil {
		return nil, err
	}
	apikeyService := apikeyimpl.ProvideService(sqlStore, cfg)
	serviceAccountsStoreImpl := database6.ProvideServiceAccountsStore(sqlStore, apikeyService, kvStore, orgService)
	serviceAccountPermissionsService, err := ossaccesscontrol.ProvideServiceAccountPermissions(cfg, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, serviceAccountsStoreImpl, acimplService, teamService)
	if err != nil {
		return nil, err
	}
	serviceAccountsService, err := manager4.ProvideServiceAccountsService(cfg, accessControl, routeRegisterImpl, usageStats, serviceAccountsStoreImpl, serviceAccountPermissionsService, acimplService)
	if err != nil {
		return nil, err
	}
	ossCrawlerAuthSetupService := thumbs.ProvideCrawlerAuthSetupService(serviceAccountsService, serviceAccountsStoreImpl, sqlStore, orgService)
	dashboardthumbsService := dashboardthumbsimpl.ProvideService(sqlStore)
	thumbsService := thumbs.ProvideService(cfg, featureToggles, serverLockService, renderingService, grafanaLive, sqlStore, ossCrawlerAuthSetupService, dashboardServiceImpl, dashboardthumbsService, searchService, ossDatasourcePermissionsService, ossLicensingService)
	alertNotificationService := alerting.ProvideService(sqlStore, serviceService, notificationService)
	provisioningServiceImpl, err := provisioning.ProvideService(accessControl, cfg, sqlStore, storeService, serviceService, notificationService, dashboardServiceImpl, service11, correlationsService, dashboardServiceImpl, folderServiceImpl, alertNotificationService, service14, searchService, quotaService, secretsService)
	if err != nil {
		return nil, err
	}
	loginserviceImplementation := loginservice.ProvideService(sqlStore, userService, quotaService, implementation, acimplService, orgService)
	authenticatorService := login.ProvideService(sqlStore, loginserviceImplementation, loginattemptService, userService)
	dataSourceProxyService := datasourceproxy.ProvideService(cacheServiceImpl, ossPluginRequestValidator, storeService, cfg, httpclientProvider, oauthtokenService, service11, tracer, secretsService)
	gateway := pushhttp.ProvideService(cfg, grafanaLive)
	authService, err := jwt.ProvideService(cfg, remoteCache)
	if err != nil {
		return nil, err
	}
	authProxy := authproxy.ProvideAuthProxy(cfg, remoteCache, loginserviceImplementation, sqlStore)
	contextHandler := contexthandler.ProvideService(cfg, userAuthTokenService, authService, remoteCache, renderingService, sqlStore, tracer, authProxy, loginserviceImplementation, apikeyService, authenticatorService, userService)
	notificationServiceMock := notifications.MockNotificationService()
	ngAlert := metrics.ProvideServiceForTest()
	alertNG, err := ngalert.ProvideService(cfg, cacheServiceImpl, service11, routeRegisterImpl, sqlStore, kvStore, exprService, dataSourceProxyService, quotaService, secretsService, notificationServiceMock, ngAlert, folderServiceImpl, accessControl, dashboardServiceImpl, renderingService, inProcBus, acimplService, repositoryImpl)
	if err != nil {
		return nil, err
	}
	libraryElementService := libraryelements.ProvideService(cfg, sqlStore, routeRegisterImpl, folderServiceImpl)
	libraryPanelService := librarypanels.ProvideService(cfg, sqlStore, routeRegisterImpl, libraryElementService)
	playlistService := playlistimpl.ProvideService(sqlStore, cfg)
	exportService := export.ProvideService(sqlStore, featureToggles, grafanaLive, cfg, serviceImpl, playlistService, orgService, service11)
	grafanaService := updatechecker.ProvideGrafanaService(cfg)
	pluginsService := updatechecker.ProvidePluginsService(cfg, storeService)
	ossSearchUserFilter := filters.ProvideOSSSearchUserFilter()
	ossService := searchusers.ProvideUsersService(ossSearchUserFilter, userService)
	ossGroups := ldap.ProvideGroupsService()
	commentsService := comments.ProvideService(cfg, sqlStore, grafanaLive, featureToggles, accessControl, dashboardServiceImpl, userService, repositoryImpl)
	avatarCacheServer := avatar.ProvideAvatarCacheServer(cfg)
	teamPermissionsService, err := ossaccesscontrol.ProvideTeamPermissions(cfg, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, acimplService, teamService)
	if err != nil {
		return nil, err
	}
	csrfService := csrf.ProvideCSRFFilter(cfg)
	base := registry2.NewBase()
	secretsMigrator := migrator.ProvideSecretsMigrator(serviceService, secretsService, sqlStore, ossImpl, featureToggles)
	dataSourceSecretMigrationService := migrations2.ProvideDataSourceMigrationService(service11, kvStore, featureToggles)
	migrateToPluginService := migrations2.ProvideMigrateToPluginService(secretsKVStore, cfg, sqlStore, secretsService, kvStore, storeService)
	migrateFromPluginService := migrations2.ProvideMigrateFromPluginService(cfg, sqlStore, secretsService, storeService, kvStore)
	secretMigrationProviderImpl := migrations2.ProvideSecretMigrationProvider(cfg, serverLockService, dataSourceSecretMigrationService, migrateToPluginService, migrateFromPluginService)
	publicDashboardStoreImpl := database7.ProvideStore(sqlStore)
	publicDashboardServiceImpl := service9.ProvideService(cfg, publicDashboardStoreImpl, queryService)
	apiApi := api2.ProvideApi(publicDashboardServiceImpl, routeRegisterImpl, accessControl, featureManager)
	navtreeService := navtreeimpl.ProvideService(cfg, accessControl, storeService, service14, starService, featureManager, dashboardServiceImpl, acimplService, kvStore, apikeyService)
	searchHTTPService := searchV2.ProvideSearchHTTPService(searchService)
	httpServer, err := api.ProvideHTTPServer(apiOpts, cfg, routeRegisterImpl, inProcBus, renderingService, ossLicensingService, hooksService, cacheService, sqlStore, alertEngine, ossPluginRequestValidator, storeService, service13, storeService, clientService, loaderLoader, pluginInstaller, ossImpl, cacheServiceImpl, userAuthTokenService, cleanUpService, shortURLService, queryHistoryService, correlationsService, thumbsService, remoteCache, provisioningServiceImpl, loginserviceImplementation, authenticatorService, accessControl, dataSourceProxyService, searchSearchService, grafanaLive, gateway, plugincontextProvider, contextHandler, featureManager, alertNG, libraryPanelService, libraryElementService, quotaService, socialService, tracer, exportService, serviceService, grafanaService, pluginsService, ossService, service11, queryService, ossGroups, teamGuardian, serviceAccountsService, implementation, storageService, notificationService, dashboardServiceImpl, dashboardServiceImpl, folderServiceImpl, ossDatasourcePermissionsService, alertNotificationService, serviceImpl, commentsService, service14, avatarCacheServer, prefService, teamPermissionsService, folderPermissionsService, dashboardPermissionsService, dashverService, starService, csrfService, base, playlistService, apikeyService, kvStore, secretsMigrator, storeService, secretsService, secretMigrationProviderImpl, secretsKVStore, apiApi, userService, tempuserService, loginattemptService, orgService, teamService, acimplService, dashboardthumbsService, navtreeService, repositoryImpl, tagimplService, searchHTTPService)
	if err != nil {
		return nil, err
	}
	processManager := process.ProvideService(inMemory)
	statscollectorService := statscollector.ProvideService(usageStats, cfg, sqlStore, socialService, storeService, featureManager, service11, httpclientProvider)
	internalMetricsService, err := metrics2.ProvideService(cfg)
	if err != nil {
		return nil, err
	}
	guardianProvider := guardian.ProvideService(sqlStore, accessControl, folderPermissionsService, dashboardPermissionsService, dashboardServiceImpl, teamService)
	importDashboardService := service10.ProvideService(routeRegisterImpl, quotaService, service13, storeService, libraryPanelService, dashboardServiceImpl, accessControl)
	dashboardUpdater := service6.ProvideDashboardUpdater(inProcBus, storeService, service13, importDashboardService, service14, dashboardServiceImpl, dashboardServiceImpl)
	sanitizerProvider := sanitizer.ProvideService(renderingService)
	backgroundServiceRegistry := backgroundsvcs.ProvideBackgroundServiceRegistry(httpServer, alertNG, cleanUpService, grafanaLive, gateway, notificationService, processManager, renderingService, userAuthTokenService, tracer, provisioningServiceImpl, alertEngine, usageStats, statscollectorService, grafanaService, pluginsService, internalMetricsService, secretsService, remoteCache, thumbsService, storageService, searchService, entityEventsService, serviceAccountsService, implementation, secretMigrationProviderImpl, serviceImpl, alertNotificationService, serviceAccountsService, guardianProvider, dashboardUpdater, sanitizerProvider)
	usageStatsProvidersRegistry := usagestatssvcs.ProvideUsageStatsProvidersRegistry(thumbsService, acimplService)
	server, err := New(opts, cfg, httpServer, acimplService, provisioningServiceImpl, backgroundServiceRegistry, usageStatsProvidersRegistry, statscollectorService, userService, loginattemptService)
	if err != nil {
		return nil, err
	}
	testEnv, err := ProvideTestEnv(server, sqlStore, notificationServiceMock)
	if err != nil {
		return nil, err
	}
	return testEnv, nil
}

// wire.go:

var wireBasicSet = wire.NewSet(service5.ProvideService, wire.Bind(new(legacydata.RequestHandler), new(*service5.Service)), annotationsimpl.ProvideService, wire.Bind(new(annotations.Repository), new(*annotationsimpl.RepositoryImpl)), alerting.ProvideAlertStore, alerting.ProvideAlertEngine, wire.Bind(new(alerting.UsageStatsQuerier), new(*alerting.AlertEngine)), setting.NewCfgFromArgs, New, api.ProvideHTTPServer, query.ProvideService, bus.ProvideBus, wire.Bind(new(bus.Bus), new(*bus.InProcBus)), thumbs.ProvideService, rendering.ProvideService, wire.Bind(new(rendering.Service), new(*rendering.RenderingService)), routing.ProvideRegister, wire.Bind(new(routing.RouteRegister), new(*routing.RouteRegisterImpl)), hooks.ProvideService, kvstore.ProvideService, localcache.ProvideService, updatechecker.ProvideGrafanaService, updatechecker.ProvidePluginsService, service.ProvideService, wire.Bind(new(usagestats.Service), new(*service.UsageStats)), registry.ProvideService, wire.Bind(new(registry.Service), new(*registry.InMemory)), config.ProvideConfig, repo.ProvideService, wire.Bind(new(repo.Service), new(*repo.Manager)), manager3.ProvideInstaller, wire.Bind(new(plugins.Installer), new(*manager3.PluginInstaller)), client.ProvideService, wire.Bind(new(plugins.Client), new(*client.Service)), store2.ProvideService, wire.Bind(new(plugins.Store), new(*store2.Service)), wire.Bind(new(plugins.RendererManager), new(*store2.Service)), wire.Bind(new(plugins.SecretsPluginManager), new(*store2.Service)), wire.Bind(new(plugins.StaticRouteResolver), new(*store2.Service)), dashboards.ProvideFileStoreManager, wire.Bind(new(dashboards.FileStore), new(*dashboards.FileStoreManager)), process.ProvideService, wire.Bind(new(process.Service), new(*process.Manager)), coreplugin.ProvideCoreRegistry, loader.ProvideService, wire.Bind(new(loader.Service), new(*loader.Loader)), wire.Bind(new(plugins.ErrorResolver), new(*loader.Loader)), cloudwatch.ProvideService, cloudmonitoring.ProvideService, azuremonitor.ProvideService, postgres.ProvideService, mysql.ProvideService, mssql.ProvideService, store.ProvideEntityEventsService, httpclientprovider.New, wire.Bind(new(httpclient.Provider), new(*httpclient2.Provider)), serverlock.ProvideService, annotationsimpl.ProvideCleanupService, wire.Bind(new(annotations.Cleaner), new(*annotationsimpl.CleanupServiceImpl)), cleanup.ProvideService, shorturls.ProvideService, wire.Bind(new(shorturls.Service), new(*shorturls.ShortURLService)), queryhistory.ProvideService, wire.Bind(new(queryhistory.Service), new(*queryhistory.QueryHistoryService)), correlations.ProvideService, wire.Bind(new(correlations.Service), new(*correlations.CorrelationsService)), quotaimpl.ProvideService, remotecache.ProvideService, loginservice.ProvideService, wire.Bind(new(login2.Service), new(*loginservice.Implementation)), authinfoservice.ProvideAuthInfoService, wire.Bind(new(login2.AuthInfoService), new(*authinfoservice.Implementation)), database4.ProvideAuthInfoStore, login.ProvideService, wire.Bind(new(login.Authenticator), new(*login.AuthenticatorService)), datasourceproxy.ProvideService, search.ProvideService, searchV2.ProvideService, searchV2.ProvideSearchHTTPService, store.ProvideService, export.ProvideService, live.ProvideService, pushhttp.ProvideService, plugincontext.ProvideService, contexthandler.ProvideService, jwt.ProvideService, wire.Bind(new(models.JWTService), new(*jwt.AuthService)), store3.ProvideDBStore, image.ProvideDeleteExpiredService, ngalert.ProvideService, librarypanels.ProvideService, wire.Bind(new(librarypanels.Service), new(*librarypanels.LibraryPanelService)), libraryelements.ProvideService, wire.Bind(new(libraryelements.Service), new(*libraryelements.LibraryElementService)), notifications.ProvideService, notifications.ProvideSmtpService, tracing.ProvideService, metrics2.ProvideService, testdatasource.ProvideService, opentsdb.ProvideService, social.ProvideService, influxdb.ProvideService, wire.Bind(new(social.Service), new(*social.SocialService)), oauthtoken.ProvideService, auth.ProvideActiveAuthTokenService, wire.Bind(new(models.ActiveTokenService), new(*auth.ActiveAuthTokenService)), wire.Bind(new(oauthtoken.OAuthTokenService), new(*oauthtoken.Service)), tempo.ProvideService, loki.ProvideService, graphite.ProvideService, prometheus.ProvideService, elasticsearch.ProvideService, service2.ProvideEncryptionService, wire.Bind(new(encryption.Internal), new(*service2.Service)), manager.ProvideSecretsService, wire.Bind(new(secrets.Service), new(*manager.SecretsService)), database.ProvideSecretsStore, wire.Bind(new(secrets.Store), new(*database.SecretsStoreImpl)), migrator.ProvideSecretsMigrator, wire.Bind(new(secrets.Migrator), new(*migrator.SecretsMigrator)), grafanads.ProvideService, wire.Bind(new(dashboardsnapshots.Store), new(*database5.DashboardSnapshotStore)), database5.ProvideStore, wire.Bind(new(dashboardsnapshots.Service), new(*service7.ServiceImpl)), service7.ProvideService, service3.ProvideService, wire.Bind(new(datasources.DataSourceService), new(*service3.Service)), service8.ProvideService, wire.Bind(new(pluginsettings.Service), new(*service8.Service)), alerting.ProvideService, database6.ProvideServiceAccountsStore, wire.Bind(new(serviceaccounts.Store), new(*database6.ServiceAccountsStoreImpl)), ossaccesscontrol.ProvideServiceAccountPermissions, wire.Bind(new(accesscontrol.ServiceAccountPermissionsService), new(*ossaccesscontrol.ServiceAccountPermissionsService)), manager4.ProvideServiceAccountsService, wire.Bind(new(serviceaccounts.Service), new(*manager4.ServiceAccountsService)), expr.ProvideService, database3.ProvideTeamGuardianStore, wire.Bind(new(teamguardian.Store), new(*database3.TeamGuardianStoreImpl)), manager2.ProvideService, featuremgmt.ProvideManagerService, featuremgmt.ProvideToggles, service4.ProvideDashboardService, service4.ProvideFolderService, database2.ProvideDashboardStore, wire.Bind(new(dashboards2.DashboardService), new(*service4.DashboardServiceImpl)), wire.Bind(new(dashboards2.DashboardProvisioningService), new(*service4.DashboardServiceImpl)), wire.Bind(new(dashboards2.PluginService), new(*service4.DashboardServiceImpl)), wire.Bind(new(dashboards2.FolderService), new(*service4.FolderServiceImpl)), wire.Bind(new(dashboards2.Store), new(*database2.DashboardStore)), service10.ProvideService, wire.Bind(new(dashboardimport.Service), new(*service10.ImportDashboardService)), service6.ProvideService, wire.Bind(new(plugindashboards.Service), new(*service6.Service)), service6.ProvideDashboardUpdater, alerting.ProvideDashAlertExtractorService, wire.Bind(new(alerting.DashAlertExtractor), new(*alerting.DashAlertExtractorService)), comments.ProvideService, guardian.ProvideService, sanitizer.ProvideService, kvstore2.ProvideService, avatar.ProvideAvatarCacheServer, authproxy.ProvideAuthProxy, statscollector.ProvideService, registry2.CoremodelSet, cuectx.ProvideCUEContext, cuectx.ProvideThemaLibrary, csrf.ProvideCSRFFilter, ossaccesscontrol.ProvideTeamPermissions, wire.Bind(new(accesscontrol.TeamPermissionsService), new(*ossaccesscontrol.TeamPermissionsService)), ossaccesscontrol.ProvideFolderPermissions, wire.Bind(new(accesscontrol.FolderPermissionsService), new(*ossaccesscontrol.FolderPermissionsService)), ossaccesscontrol.ProvideDashboardPermissions, wire.Bind(new(accesscontrol.DashboardPermissionsService), new(*ossaccesscontrol.DashboardPermissionsService)), starimpl.ProvideService, playlistimpl.ProvideService, apikeyimpl.ProvideService, dashverimpl.ProvideService, service9.ProvideService, wire.Bind(new(publicdashboards.Service), new(*service9.PublicDashboardServiceImpl)), database7.ProvideStore, wire.Bind(new(publicdashboards.Store), new(*database7.PublicDashboardStoreImpl)), api2.ProvideApi, userimpl.ProvideService, orgimpl.ProvideService, teamimpl.ProvideService, tempuserimpl.ProvideService, dashboardthumbsimpl.ProvideService, loginattemptimpl.ProvideService, migrations2.ProvideDataSourceMigrationService, migrations2.ProvideMigrateToPluginService, migrations2.ProvideMigrateFromPluginService, migrations2.ProvideSecretMigrationProvider, wire.Bind(new(migrations2.SecretMigrationProvider), new(*migrations2.SecretMigrationProviderImpl)), userauthimpl.ProvideService, acimpl.ProvideAccessControl, navtreeimpl.ProvideService, wire.Bind(new(accesscontrol.AccessControl), new(*acimpl.AccessControl)), wire.Bind(new(notifications.TempUserStore), new(tempuser.Service)), tagimpl.ProvideService, wire.Bind(new(tag.Service), new(*tagimpl.Service)))

var wireSet = wire.NewSet(
	wireBasicSet, sqlstore.ProvideService, metrics.ProvideService, wire.Bind(new(notifications.Service), new(*notifications.NotificationService)), wire.Bind(new(notifications.WebhookSender), new(*notifications.NotificationService)), wire.Bind(new(notifications.EmailSender), new(*notifications.NotificationService)), wire.Bind(new(sqlstore.Store), new(*sqlstore.SQLStore)), wire.Bind(new(db.DB), new(*sqlstore.SQLStore)), prefimpl.ProvideService,
)

var wireTestSet = wire.NewSet(
	wireBasicSet,
	ProvideTestEnv, sqlstore.ProvideServiceForTests, metrics.ProvideServiceForTest, notifications.MockNotificationService, wire.Bind(new(notifications.Service), new(*notifications.NotificationServiceMock)), wire.Bind(new(notifications.WebhookSender), new(*notifications.NotificationServiceMock)), wire.Bind(new(notifications.EmailSender), new(*notifications.NotificationServiceMock)), mockstore.NewSQLStoreMock, wire.Bind(new(sqlstore.Store), new(*sqlstore.SQLStore)), wire.Bind(new(db.DB), new(*sqlstore.SQLStore)), prefimpl.ProvideService,
)
