"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditConfig = void 0;
const render_1 = require("@betterer/render");
function EditConfig(props) {
    const { children, name, onChange, onSubmit, value } = props;
    const [error, setError] = (0, render_1.useState)(null);
    const [valid, setValid] = (0, render_1.useState)(null);
    function change(newValue) {
        const [valid, error] = onChange(newValue);
        setValid(valid);
        setError(error);
    }
    async function submit() {
        if (valid) {
            await onSubmit(valid);
        }
    }
    return (render_1.React.createElement(render_1.Box, { flexDirection: "column" },
        render_1.React.createElement(render_1.Text, { color: "grey" },
            children,
            " Press \"enter\" to confirm."),
        render_1.React.createElement(render_1.Box, null,
            render_1.React.createElement(render_1.Text, { color: error ? 'redBright' : 'yellowBright' },
                name,
                ": "),
            render_1.React.createElement(render_1.TextInput, { value: value, onChange: change, onSubmit: submit })),
        render_1.React.createElement(render_1.Box, null, error && render_1.React.createElement(render_1.Text, null, error.message))));
}
exports.EditConfig = EditConfig;
//# sourceMappingURL=EditConfig.js.map