/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * monaco-kusto version: 5.2.0(undefined)
 * Released under the MIT license
 * https://https://github.com/Azure/monaco-kusto/blob/master/README.md
 *-----------------------------------------------------------------------------*/
var __rest=this&&this.__rest||function(n,t){var e={};for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&t.indexOf(r)<0&&(e[r]=n[r]);if(null!=n&&"function"==typeof Object.getOwnPropertySymbols){var i=0;for(r=Object.getOwnPropertySymbols(n);i<r.length;i++)t.indexOf(r[i])<0&&Object.prototype.propertyIsEnumerable.call(n,r[i])&&(e[r[i]]=n[r[i]])}return e};define("vs/language/kusto/workerManager",["require","exports"],(function(n,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.WorkerManager=void 0;var e=function(){function n(n,t){var e=this;this._monacoInstance=n,this._defaults=t,this._worker=null,this._idleCheckInterval=self.setInterval((function(){return e._checkIfIdle()}),3e4),this._lastUsedTime=0,this._configChangeListener=this._defaults.onDidChange((function(){return e._saveStateAndStopWorker()}))}return n.prototype._stopWorker=function(){this._worker&&(this._worker.dispose(),this._worker=null),this._client=null},n.prototype._saveStateAndStopWorker=function(){var n=this;this._worker&&this._worker.getProxy().then((function(t){t.getSchema().then((function(t){n._storedState={schema:t},n._stopWorker()}))}))},n.prototype.dispose=function(){clearInterval(this._idleCheckInterval),this._configChangeListener.dispose(),this._stopWorker()},n.prototype._checkIfIdle=function(){if(this._worker){var n=this._defaults.getWorkerMaxIdleTime(),t=Date.now()-this._lastUsedTime;n>0&&t>n&&this._saveStateAndStopWorker()}},n.prototype._getClient=function(){var n=this;this._lastUsedTime=Date.now();var t=this._defaults.languageSettings,e=(t.onDidProvideCompletionItems,__rest(t,["onDidProvideCompletionItems"]));return this._client||(this._worker=this._monacoInstance.editor.createWebWorker({moduleId:"vs/language/kusto/kustoWorker",label:"kusto",createData:{languageSettings:e,languageId:"kusto"}}),this._client=this._worker.getProxy().then((function(t){return n._storedState?t.setSchema(n._storedState.schema).then((function(){return t})):t}))),this._client},n.prototype.getLanguageServiceWorker=function(){for(var n,t=this,e=[],r=0;r<arguments.length;r++)e[r]=arguments[r];return this._getClient().then((function(t){n=t})).then((function(n){return t._worker.withSyncedResources(e)})).then((function(t){return n}))},n}();t.WorkerManager=e})),define("vs/language/kusto/languageService/kustoMonarchLanguageDefinition",["require","exports"],(function(n,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.KustoLanguageDefinition=void 0,t.KustoLanguageDefinition={name:"kusto",mimeTypes:["text/kusto"],displayName:"Kusto",defaultToken:"invalid",brackets:[["[","]","delimiter.square"],["(",")","delimiter.parenthesis"]],wordDefinition:/(-?\d*\.\d\w*)|([^\`\~\!\#\%\^\&\*\(\)\-\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,promotedOperatorCommandTokens:Kusto.Data.IntelliSense.CslCommandParser.PromotedOperatorCommandTokens.slice(0),operatorCommandTokens:Kusto.Data.IntelliSense.CslCommandParser.OperatorCommandTokens.slice(0),keywords:["by","on","contains","notcontains","containscs","notcontainscs","startswith","has","matches","regex","true","false","and","or","typeof","int","string","date","datetime","time","long","real","​boolean","bool"],operators:["+","-","*","/",">","<","==","<>","<=",">=","~","!~"],builtinFunctions:["countof","bin","extentid","extract","extractjson","floor","iif","isnull","isnotnull","notnull","isempty","isnotempty","notempty","now","re2","strcat","strlen","toupper","tostring","count","cnt","sum","min","max","avg"],tokenizer:{root:[{include:"@whitespace"},{include:"@numbers"},{include:"@strings"},{include:"@dqstrings"},{include:"@literals"},{include:"@comments"},[/[;,.]/,"delimiter"],[/[()\[\]]/,"@brackets"],[/[<>=!%&+\-*/|~^]/,"operator"],[/[\w@#\-$]+/,{cases:{"@keywords":"keyword","@promotedOperatorCommandTokens":"operator.sql","@operatorCommandTokens":"keyword","@operators":"operator","@builtinFunctions":"predefined","@default":"identifier"}}]],whitespace:[[/\s+/,"white"]],comments:[["\\/\\/+.*","comment"]],numbers:[[/0[xX][0-9a-fA-F]*/,"number"],[/[$][+-]*\d*(\.\d*)?/,"number"],[/((\d+(\.\d*)?)|(\.\d+))([eE][\-+]?\d+)?/,"number"]],strings:[[/H'/,{token:"string.quote",bracket:"@open",next:"@string"}],[/h'/,{token:"string.quote",bracket:"@open",next:"@string"}],[/'/,{token:"string.quote",bracket:"@open",next:"@string"}]],string:[[/[^']+/,"string"],[/''/,"string"],[/'/,{token:"string.quote",bracket:"@close",next:"@pop"}]],dqstrings:[[/H"/,{token:"string.quote",bracket:"@open",next:"@dqstring"}],[/h"/,{token:"string.quote",bracket:"@open",next:"@dqstring"}],[/"/,{token:"string.quote",bracket:"@open",next:"@dqstring"}]],dqstring:[[/[^"]+/,"string"],[/""/,"string"],[/"/,{token:"string.quote",bracket:"@close",next:"@pop"}]],literals:[[/datetime\(\d{4}-\d{2}-\d{2}(\s+\d{2}:\d{2}(:\d{2}(\.\d{0,3})?)?)?\)/,"number"],[/time\((\d+(s(ec(onds?)?)?|m(in(utes?)?)?|h(ours?)?|d(ays?)?)|(\s*(('[^']+')|("[^"]+"))\s*))\)/,"number"],[/guid\([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}\)/,"number"],[/typeof\((int|string|date|datetime|time|long|real|boolean|bool)\)/,"number"]]}}})),function(n){if("object"==typeof module&&"object"==typeof module.exports){var t=n(require,exports);void 0!==t&&(module.exports=t)}else"function"==typeof define&&define.amd&&define("vscode-languageserver-types/main",["require","exports"],n)}((function(n,t){"use strict";var e,r,i,o,u,a,c,s,f,l,d,h,g,p,v,_,m;Object.defineProperty(t,"__esModule",{value:!0}),t.TextDocument=t.EOL=t.SelectionRange=t.DocumentLink=t.FormattingOptions=t.CodeLens=t.CodeAction=t.CodeActionContext=t.CodeActionKind=t.DocumentSymbol=t.SymbolInformation=t.SymbolTag=t.SymbolKind=t.DocumentHighlight=t.DocumentHighlightKind=t.SignatureInformation=t.ParameterInformation=t.Hover=t.MarkedString=t.CompletionList=t.CompletionItem=t.InsertTextMode=t.InsertReplaceEdit=t.CompletionItemTag=t.InsertTextFormat=t.CompletionItemKind=t.MarkupContent=t.MarkupKind=t.TextDocumentItem=t.OptionalVersionedTextDocumentIdentifier=t.VersionedTextDocumentIdentifier=t.TextDocumentIdentifier=t.WorkspaceChange=t.WorkspaceEdit=t.DeleteFile=t.RenameFile=t.CreateFile=t.TextDocumentEdit=t.AnnotatedTextEdit=t.ChangeAnnotationIdentifier=t.ChangeAnnotation=t.TextEdit=t.Command=t.Diagnostic=t.CodeDescription=t.DiagnosticTag=t.DiagnosticSeverity=t.DiagnosticRelatedInformation=t.FoldingRange=t.FoldingRangeKind=t.ColorPresentation=t.ColorInformation=t.Color=t.LocationLink=t.Location=t.Range=t.Position=t.uinteger=t.integer=void 0,function(n){n.MIN_VALUE=-2147483648,n.MAX_VALUE=2147483647}(t.integer||(t.integer={})),function(n){n.MIN_VALUE=0,n.MAX_VALUE=2147483647}(e=t.uinteger||(t.uinteger={})),function(n){n.create=function(n,t){return n===Number.MAX_VALUE&&(n=e.MAX_VALUE),t===Number.MAX_VALUE&&(t=e.MAX_VALUE),{line:n,character:t}},n.is=function(n){var t=n;return A.objectLiteral(t)&&A.uinteger(t.line)&&A.uinteger(t.character)}}(r=t.Position||(t.Position={})),function(n){n.create=function(n,t,e,i){if(A.uinteger(n)&&A.uinteger(t)&&A.uinteger(e)&&A.uinteger(i))return{start:r.create(n,t),end:r.create(e,i)};if(r.is(n)&&r.is(t))return{start:n,end:t};throw new Error("Range#create called with invalid arguments["+n+", "+t+", "+e+", "+i+"]")},n.is=function(n){var t=n;return A.objectLiteral(t)&&r.is(t.start)&&r.is(t.end)}}(i=t.Range||(t.Range={})),function(n){n.create=function(n,t){return{uri:n,range:t}},n.is=function(n){var t=n;return A.defined(t)&&i.is(t.range)&&(A.string(t.uri)||A.undefined(t.uri))}}(o=t.Location||(t.Location={})),function(n){n.create=function(n,t,e,r){return{targetUri:n,targetRange:t,targetSelectionRange:e,originSelectionRange:r}},n.is=function(n){var t=n;return A.defined(t)&&i.is(t.targetRange)&&A.string(t.targetUri)&&(i.is(t.targetSelectionRange)||A.undefined(t.targetSelectionRange))&&(i.is(t.originSelectionRange)||A.undefined(t.originSelectionRange))}}(t.LocationLink||(t.LocationLink={})),function(n){n.create=function(n,t,e,r){return{red:n,green:t,blue:e,alpha:r}},n.is=function(n){var t=n;return A.numberRange(t.red,0,1)&&A.numberRange(t.green,0,1)&&A.numberRange(t.blue,0,1)&&A.numberRange(t.alpha,0,1)}}(u=t.Color||(t.Color={})),function(n){n.create=function(n,t){return{range:n,color:t}},n.is=function(n){var t=n;return i.is(t.range)&&u.is(t.color)}}(t.ColorInformation||(t.ColorInformation={})),function(n){n.create=function(n,t,e){return{label:n,textEdit:t,additionalTextEdits:e}},n.is=function(n){var t=n;return A.string(t.label)&&(A.undefined(t.textEdit)||f.is(t))&&(A.undefined(t.additionalTextEdits)||A.typedArray(t.additionalTextEdits,f.is))}}(t.ColorPresentation||(t.ColorPresentation={})),function(n){n.Comment="comment",n.Imports="imports",n.Region="region"}(t.FoldingRangeKind||(t.FoldingRangeKind={})),function(n){n.create=function(n,t,e,r,i){var o={startLine:n,endLine:t};return A.defined(e)&&(o.startCharacter=e),A.defined(r)&&(o.endCharacter=r),A.defined(i)&&(o.kind=i),o},n.is=function(n){var t=n;return A.uinteger(t.startLine)&&A.uinteger(t.startLine)&&(A.undefined(t.startCharacter)||A.uinteger(t.startCharacter))&&(A.undefined(t.endCharacter)||A.uinteger(t.endCharacter))&&(A.undefined(t.kind)||A.string(t.kind))}}(t.FoldingRange||(t.FoldingRange={})),function(n){n.create=function(n,t){return{location:n,message:t}},n.is=function(n){var t=n;return A.defined(t)&&o.is(t.location)&&A.string(t.message)}}(a=t.DiagnosticRelatedInformation||(t.DiagnosticRelatedInformation={})),function(n){n.Error=1,n.Warning=2,n.Information=3,n.Hint=4}(t.DiagnosticSeverity||(t.DiagnosticSeverity={})),function(n){n.Unnecessary=1,n.Deprecated=2}(t.DiagnosticTag||(t.DiagnosticTag={})),function(n){n.is=function(n){var t=n;return null!=t&&A.string(t.href)}}(t.CodeDescription||(t.CodeDescription={})),function(n){n.create=function(n,t,e,r,i,o){var u={range:n,message:t};return A.defined(e)&&(u.severity=e),A.defined(r)&&(u.code=r),A.defined(i)&&(u.source=i),A.defined(o)&&(u.relatedInformation=o),u},n.is=function(n){var t,e=n;return A.defined(e)&&i.is(e.range)&&A.string(e.message)&&(A.number(e.severity)||A.undefined(e.severity))&&(A.integer(e.code)||A.string(e.code)||A.undefined(e.code))&&(A.undefined(e.codeDescription)||A.string(null===(t=e.codeDescription)||void 0===t?void 0:t.href))&&(A.string(e.source)||A.undefined(e.source))&&(A.undefined(e.relatedInformation)||A.typedArray(e.relatedInformation,a.is))}}(c=t.Diagnostic||(t.Diagnostic={})),function(n){n.create=function(n,t){for(var e=[],r=2;r<arguments.length;r++)e[r-2]=arguments[r];var i={title:n,command:t};return A.defined(e)&&e.length>0&&(i.arguments=e),i},n.is=function(n){var t=n;return A.defined(t)&&A.string(t.title)&&A.string(t.command)}}(s=t.Command||(t.Command={})),function(n){n.replace=function(n,t){return{range:n,newText:t}},n.insert=function(n,t){return{range:{start:n,end:n},newText:t}},n.del=function(n){return{range:n,newText:""}},n.is=function(n){var t=n;return A.objectLiteral(t)&&A.string(t.newText)&&i.is(t.range)}}(f=t.TextEdit||(t.TextEdit={})),function(n){n.create=function(n,t,e){var r={label:n};return void 0!==t&&(r.needsConfirmation=t),void 0!==e&&(r.description=e),r},n.is=function(n){var t=n;return void 0!==t&&A.objectLiteral(t)&&A.string(t.label)&&(A.boolean(t.needsConfirmation)||void 0===t.needsConfirmation)&&(A.string(t.description)||void 0===t.description)}}(l=t.ChangeAnnotation||(t.ChangeAnnotation={})),function(n){n.is=function(n){return"string"==typeof n}}(d=t.ChangeAnnotationIdentifier||(t.ChangeAnnotationIdentifier={})),function(n){n.replace=function(n,t,e){return{range:n,newText:t,annotationId:e}},n.insert=function(n,t,e){return{range:{start:n,end:n},newText:t,annotationId:e}},n.del=function(n,t){return{range:n,newText:"",annotationId:t}},n.is=function(n){var t=n;return f.is(t)&&(l.is(t.annotationId)||d.is(t.annotationId))}}(h=t.AnnotatedTextEdit||(t.AnnotatedTextEdit={})),function(n){n.create=function(n,t){return{textDocument:n,edits:t}},n.is=function(n){var t=n;return A.defined(t)&&y.is(t.textDocument)&&Array.isArray(t.edits)}}(g=t.TextDocumentEdit||(t.TextDocumentEdit={})),function(n){n.create=function(n,t,e){var r={kind:"create",uri:n};return void 0===t||void 0===t.overwrite&&void 0===t.ignoreIfExists||(r.options=t),void 0!==e&&(r.annotationId=e),r},n.is=function(n){var t=n;return t&&"create"===t.kind&&A.string(t.uri)&&(void 0===t.options||(void 0===t.options.overwrite||A.boolean(t.options.overwrite))&&(void 0===t.options.ignoreIfExists||A.boolean(t.options.ignoreIfExists)))&&(void 0===t.annotationId||d.is(t.annotationId))}}(p=t.CreateFile||(t.CreateFile={})),function(n){n.create=function(n,t,e,r){var i={kind:"rename",oldUri:n,newUri:t};return void 0===e||void 0===e.overwrite&&void 0===e.ignoreIfExists||(i.options=e),void 0!==r&&(i.annotationId=r),i},n.is=function(n){var t=n;return t&&"rename"===t.kind&&A.string(t.oldUri)&&A.string(t.newUri)&&(void 0===t.options||(void 0===t.options.overwrite||A.boolean(t.options.overwrite))&&(void 0===t.options.ignoreIfExists||A.boolean(t.options.ignoreIfExists)))&&(void 0===t.annotationId||d.is(t.annotationId))}}(v=t.RenameFile||(t.RenameFile={})),function(n){n.create=function(n,t,e){var r={kind:"delete",uri:n};return void 0===t||void 0===t.recursive&&void 0===t.ignoreIfNotExists||(r.options=t),void 0!==e&&(r.annotationId=e),r},n.is=function(n){var t=n;return t&&"delete"===t.kind&&A.string(t.uri)&&(void 0===t.options||(void 0===t.options.recursive||A.boolean(t.options.recursive))&&(void 0===t.options.ignoreIfNotExists||A.boolean(t.options.ignoreIfNotExists)))&&(void 0===t.annotationId||d.is(t.annotationId))}}(_=t.DeleteFile||(t.DeleteFile={})),function(n){n.is=function(n){var t=n;return t&&(void 0!==t.changes||void 0!==t.documentChanges)&&(void 0===t.documentChanges||t.documentChanges.every((function(n){return A.string(n.kind)?p.is(n)||v.is(n)||_.is(n):g.is(n)})))}}(m=t.WorkspaceEdit||(t.WorkspaceEdit={}));var y,b,w,k,x=function(){function n(n,t){this.edits=n,this.changeAnnotations=t}return n.prototype.insert=function(n,t,e){var r,i;if(void 0===e?r=f.insert(n,t):d.is(e)?(i=e,r=h.insert(n,t,e)):(this.assertChangeAnnotations(this.changeAnnotations),i=this.changeAnnotations.manage(e),r=h.insert(n,t,i)),this.edits.push(r),void 0!==i)return i},n.prototype.replace=function(n,t,e){var r,i;if(void 0===e?r=f.replace(n,t):d.is(e)?(i=e,r=h.replace(n,t,e)):(this.assertChangeAnnotations(this.changeAnnotations),i=this.changeAnnotations.manage(e),r=h.replace(n,t,i)),this.edits.push(r),void 0!==i)return i},n.prototype.delete=function(n,t){var e,r;if(void 0===t?e=f.del(n):d.is(t)?(r=t,e=h.del(n,t)):(this.assertChangeAnnotations(this.changeAnnotations),r=this.changeAnnotations.manage(t),e=h.del(n,r)),this.edits.push(e),void 0!==r)return r},n.prototype.add=function(n){this.edits.push(n)},n.prototype.all=function(){return this.edits},n.prototype.clear=function(){this.edits.splice(0,this.edits.length)},n.prototype.assertChangeAnnotations=function(n){if(void 0===n)throw new Error("Text edit change is not configured to manage change annotations.")},n}(),C=function(){function n(n){this._annotations=void 0===n?Object.create(null):n,this._counter=0,this._size=0}return n.prototype.all=function(){return this._annotations},Object.defineProperty(n.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),n.prototype.manage=function(n,t){var e;if(d.is(n)?e=n:(e=this.nextId(),t=n),void 0!==this._annotations[e])throw new Error("Id "+e+" is already in use.");if(void 0===t)throw new Error("No annotation provided for id "+e);return this._annotations[e]=t,this._size++,e},n.prototype.nextId=function(){return this._counter++,this._counter.toString()},n}(),I=function(){function n(n){var t=this;this._textEditChanges=Object.create(null),void 0!==n?(this._workspaceEdit=n,n.documentChanges?(this._changeAnnotations=new C(n.changeAnnotations),n.changeAnnotations=this._changeAnnotations.all(),n.documentChanges.forEach((function(n){if(g.is(n)){var e=new x(n.edits,t._changeAnnotations);t._textEditChanges[n.textDocument.uri]=e}}))):n.changes&&Object.keys(n.changes).forEach((function(e){var r=new x(n.changes[e]);t._textEditChanges[e]=r}))):this._workspaceEdit={}}return Object.defineProperty(n.prototype,"edit",{get:function(){return this.initDocumentChanges(),void 0!==this._changeAnnotations&&(0===this._changeAnnotations.size?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),n.prototype.getTextEditChange=function(n){if(y.is(n)){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var t={uri:n.uri,version:n.version};if(!(r=this._textEditChanges[t.uri])){var e={textDocument:t,edits:i=[]};this._workspaceEdit.documentChanges.push(e),r=new x(i,this._changeAnnotations),this._textEditChanges[t.uri]=r}return r}if(this.initChanges(),void 0===this._workspaceEdit.changes)throw new Error("Workspace edit is not configured for normal text edit changes.");var r;if(!(r=this._textEditChanges[n])){var i=[];this._workspaceEdit.changes[n]=i,r=new x(i),this._textEditChanges[n]=r}return r},n.prototype.initDocumentChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._changeAnnotations=new C,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},n.prototype.initChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._workspaceEdit.changes=Object.create(null))},n.prototype.createFile=function(n,t,e){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var r,i,o;if(l.is(t)||d.is(t)?r=t:e=t,void 0===r?i=p.create(n,e):(o=d.is(r)?r:this._changeAnnotations.manage(r),i=p.create(n,e,o)),this._workspaceEdit.documentChanges.push(i),void 0!==o)return o},n.prototype.renameFile=function(n,t,e,r){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var i,o,u;if(l.is(e)||d.is(e)?i=e:r=e,void 0===i?o=v.create(n,t,r):(u=d.is(i)?i:this._changeAnnotations.manage(i),o=v.create(n,t,r,u)),this._workspaceEdit.documentChanges.push(o),void 0!==u)return u},n.prototype.deleteFile=function(n,t,e){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var r,i,o;if(l.is(t)||d.is(t)?r=t:e=t,void 0===r?i=_.create(n,e):(o=d.is(r)?r:this._changeAnnotations.manage(r),i=_.create(n,e,o)),this._workspaceEdit.documentChanges.push(i),void 0!==o)return o},n}();t.WorkspaceChange=I,function(n){n.create=function(n){return{uri:n}},n.is=function(n){var t=n;return A.defined(t)&&A.string(t.uri)}}(t.TextDocumentIdentifier||(t.TextDocumentIdentifier={})),function(n){n.create=function(n,t){return{uri:n,version:t}},n.is=function(n){var t=n;return A.defined(t)&&A.string(t.uri)&&A.integer(t.version)}}(t.VersionedTextDocumentIdentifier||(t.VersionedTextDocumentIdentifier={})),function(n){n.create=function(n,t){return{uri:n,version:t}},n.is=function(n){var t=n;return A.defined(t)&&A.string(t.uri)&&(null===t.version||A.integer(t.version))}}(y=t.OptionalVersionedTextDocumentIdentifier||(t.OptionalVersionedTextDocumentIdentifier={})),function(n){n.create=function(n,t,e,r){return{uri:n,languageId:t,version:e,text:r}},n.is=function(n){var t=n;return A.defined(t)&&A.string(t.uri)&&A.string(t.languageId)&&A.integer(t.version)&&A.string(t.text)}}(t.TextDocumentItem||(t.TextDocumentItem={})),function(n){n.PlainText="plaintext",n.Markdown="markdown"}(b=t.MarkupKind||(t.MarkupKind={})),function(n){n.is=function(t){var e=t;return e===n.PlainText||e===n.Markdown}}(b=t.MarkupKind||(t.MarkupKind={})),function(n){n.is=function(n){var t=n;return A.objectLiteral(n)&&b.is(t.kind)&&A.string(t.value)}}(w=t.MarkupContent||(t.MarkupContent={})),function(n){n.Text=1,n.Method=2,n.Function=3,n.Constructor=4,n.Field=5,n.Variable=6,n.Class=7,n.Interface=8,n.Module=9,n.Property=10,n.Unit=11,n.Value=12,n.Enum=13,n.Keyword=14,n.Snippet=15,n.Color=16,n.File=17,n.Reference=18,n.Folder=19,n.EnumMember=20,n.Constant=21,n.Struct=22,n.Event=23,n.Operator=24,n.TypeParameter=25}(t.CompletionItemKind||(t.CompletionItemKind={})),function(n){n.PlainText=1,n.Snippet=2}(t.InsertTextFormat||(t.InsertTextFormat={})),function(n){n.Deprecated=1}(t.CompletionItemTag||(t.CompletionItemTag={})),function(n){n.create=function(n,t,e){return{newText:n,insert:t,replace:e}},n.is=function(n){var t=n;return t&&A.string(t.newText)&&i.is(t.insert)&&i.is(t.replace)}}(t.InsertReplaceEdit||(t.InsertReplaceEdit={})),function(n){n.asIs=1,n.adjustIndentation=2}(t.InsertTextMode||(t.InsertTextMode={})),function(n){n.create=function(n){return{label:n}}}(t.CompletionItem||(t.CompletionItem={})),function(n){n.create=function(n,t){return{items:n||[],isIncomplete:!!t}}}(t.CompletionList||(t.CompletionList={})),function(n){n.fromPlainText=function(n){return n.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")},n.is=function(n){var t=n;return A.string(t)||A.objectLiteral(t)&&A.string(t.language)&&A.string(t.value)}}(k=t.MarkedString||(t.MarkedString={})),function(n){n.is=function(n){var t=n;return!!t&&A.objectLiteral(t)&&(w.is(t.contents)||k.is(t.contents)||A.typedArray(t.contents,k.is))&&(void 0===n.range||i.is(n.range))}}(t.Hover||(t.Hover={})),function(n){n.create=function(n,t){return t?{label:n,documentation:t}:{label:n}}}(t.ParameterInformation||(t.ParameterInformation={})),function(n){n.create=function(n,t){for(var e=[],r=2;r<arguments.length;r++)e[r-2]=arguments[r];var i={label:n};return A.defined(t)&&(i.documentation=t),A.defined(e)?i.parameters=e:i.parameters=[],i}}(t.SignatureInformation||(t.SignatureInformation={})),function(n){n.Text=1,n.Read=2,n.Write=3}(t.DocumentHighlightKind||(t.DocumentHighlightKind={})),function(n){n.create=function(n,t){var e={range:n};return A.number(t)&&(e.kind=t),e}}(t.DocumentHighlight||(t.DocumentHighlight={})),function(n){n.File=1,n.Module=2,n.Namespace=3,n.Package=4,n.Class=5,n.Method=6,n.Property=7,n.Field=8,n.Constructor=9,n.Enum=10,n.Interface=11,n.Function=12,n.Variable=13,n.Constant=14,n.String=15,n.Number=16,n.Boolean=17,n.Array=18,n.Object=19,n.Key=20,n.Null=21,n.EnumMember=22,n.Struct=23,n.Event=24,n.Operator=25,n.TypeParameter=26}(t.SymbolKind||(t.SymbolKind={})),function(n){n.Deprecated=1}(t.SymbolTag||(t.SymbolTag={})),function(n){n.create=function(n,t,e,r,i){var o={name:n,kind:t,location:{uri:r,range:e}};return i&&(o.containerName=i),o}}(t.SymbolInformation||(t.SymbolInformation={})),function(n){n.create=function(n,t,e,r,i,o){var u={name:n,detail:t,kind:e,range:r,selectionRange:i};return void 0!==o&&(u.children=o),u},n.is=function(n){var t=n;return t&&A.string(t.name)&&A.number(t.kind)&&i.is(t.range)&&i.is(t.selectionRange)&&(void 0===t.detail||A.string(t.detail))&&(void 0===t.deprecated||A.boolean(t.deprecated))&&(void 0===t.children||Array.isArray(t.children))&&(void 0===t.tags||Array.isArray(t.tags))}}(t.DocumentSymbol||(t.DocumentSymbol={})),function(n){n.Empty="",n.QuickFix="quickfix",n.Refactor="refactor",n.RefactorExtract="refactor.extract",n.RefactorInline="refactor.inline",n.RefactorRewrite="refactor.rewrite",n.Source="source",n.SourceOrganizeImports="source.organizeImports",n.SourceFixAll="source.fixAll"}(t.CodeActionKind||(t.CodeActionKind={})),function(n){n.create=function(n,t){var e={diagnostics:n};return null!=t&&(e.only=t),e},n.is=function(n){var t=n;return A.defined(t)&&A.typedArray(t.diagnostics,c.is)&&(void 0===t.only||A.typedArray(t.only,A.string))}}(t.CodeActionContext||(t.CodeActionContext={})),function(n){n.create=function(n,t,e){var r={title:n},i=!0;return"string"==typeof t?(i=!1,r.kind=t):s.is(t)?r.command=t:r.edit=t,i&&void 0!==e&&(r.kind=e),r},n.is=function(n){var t=n;return t&&A.string(t.title)&&(void 0===t.diagnostics||A.typedArray(t.diagnostics,c.is))&&(void 0===t.kind||A.string(t.kind))&&(void 0!==t.edit||void 0!==t.command)&&(void 0===t.command||s.is(t.command))&&(void 0===t.isPreferred||A.boolean(t.isPreferred))&&(void 0===t.edit||m.is(t.edit))}}(t.CodeAction||(t.CodeAction={})),function(n){n.create=function(n,t){var e={range:n};return A.defined(t)&&(e.data=t),e},n.is=function(n){var t=n;return A.defined(t)&&i.is(t.range)&&(A.undefined(t.command)||s.is(t.command))}}(t.CodeLens||(t.CodeLens={})),function(n){n.create=function(n,t){return{tabSize:n,insertSpaces:t}},n.is=function(n){var t=n;return A.defined(t)&&A.uinteger(t.tabSize)&&A.boolean(t.insertSpaces)}}(t.FormattingOptions||(t.FormattingOptions={})),function(n){n.create=function(n,t,e){return{range:n,target:t,data:e}},n.is=function(n){var t=n;return A.defined(t)&&i.is(t.range)&&(A.undefined(t.target)||A.string(t.target))}}(t.DocumentLink||(t.DocumentLink={})),function(n){n.create=function(n,t){return{range:n,parent:t}},n.is=function(t){var e=t;return void 0!==e&&i.is(e.range)&&(void 0===e.parent||n.is(e.parent))}}(t.SelectionRange||(t.SelectionRange={})),t.EOL=["\n","\r\n","\r"],function(n){n.create=function(n,t,e,r){return new S(n,t,e,r)},n.is=function(n){var t=n;return!!(A.defined(t)&&A.string(t.uri)&&(A.undefined(t.languageId)||A.string(t.languageId))&&A.uinteger(t.lineCount)&&A.func(t.getText)&&A.func(t.positionAt)&&A.func(t.offsetAt))},n.applyEdits=function(n,t){for(var e=n.getText(),r=function n(t,e){if(t.length<=1)return t;var r=t.length/2|0,i=t.slice(0,r),o=t.slice(r);n(i,e),n(o,e);var u=0,a=0,c=0;for(;u<i.length&&a<o.length;){var s=e(i[u],o[a]);t[c++]=s<=0?i[u++]:o[a++]}for(;u<i.length;)t[c++]=i[u++];for(;a<o.length;)t[c++]=o[a++];return t}(t,(function(n,t){var e=n.range.start.line-t.range.start.line;return 0===e?n.range.start.character-t.range.start.character:e})),i=e.length,o=r.length-1;o>=0;o--){var u=r[o],a=n.offsetAt(u.range.start),c=n.offsetAt(u.range.end);if(!(c<=i))throw new Error("Overlapping edit");e=e.substring(0,a)+u.newText+e.substring(c,e.length),i=a}return e}}(t.TextDocument||(t.TextDocument={}));var A,S=function(){function n(n,t,e,r){this._uri=n,this._languageId=t,this._version=e,this._content=r,this._lineOffsets=void 0}return Object.defineProperty(n.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),n.prototype.getText=function(n){if(n){var t=this.offsetAt(n.start),e=this.offsetAt(n.end);return this._content.substring(t,e)}return this._content},n.prototype.update=function(n,t){this._content=n.text,this._version=t,this._lineOffsets=void 0},n.prototype.getLineOffsets=function(){if(void 0===this._lineOffsets){for(var n=[],t=this._content,e=!0,r=0;r<t.length;r++){e&&(n.push(r),e=!1);var i=t.charAt(r);e="\r"===i||"\n"===i,"\r"===i&&r+1<t.length&&"\n"===t.charAt(r+1)&&r++}e&&t.length>0&&n.push(t.length),this._lineOffsets=n}return this._lineOffsets},n.prototype.positionAt=function(n){n=Math.max(Math.min(n,this._content.length),0);var t=this.getLineOffsets(),e=0,i=t.length;if(0===i)return r.create(0,n);for(;e<i;){var o=Math.floor((e+i)/2);t[o]>n?i=o:e=o+1}var u=e-1;return r.create(u,n-t[u])},n.prototype.offsetAt=function(n){var t=this.getLineOffsets();if(n.line>=t.length)return this._content.length;if(n.line<0)return 0;var e=t[n.line],r=n.line+1<t.length?t[n.line+1]:this._content.length;return Math.max(Math.min(e+n.character,r),e)},Object.defineProperty(n.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),n}();!function(n){var t=Object.prototype.toString;n.defined=function(n){return void 0!==n},n.undefined=function(n){return void 0===n},n.boolean=function(n){return!0===n||!1===n},n.string=function(n){return"[object String]"===t.call(n)},n.number=function(n){return"[object Number]"===t.call(n)},n.numberRange=function(n,e,r){return"[object Number]"===t.call(n)&&e<=n&&n<=r},n.integer=function(n){return"[object Number]"===t.call(n)&&-2147483648<=n&&n<=2147483647},n.uinteger=function(n){return"[object Number]"===t.call(n)&&0<=n&&n<=2147483647},n.func=function(n){return"[object Function]"===t.call(n)},n.objectLiteral=function(n){return null!==n&&"object"==typeof n},n.typedArray=function(n,t){return Array.isArray(n)&&n.every(t)}}(A||(A={}))})),define("vscode-languageserver-types",["vscode-languageserver-types/main"],(function(n){return n})),
/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */
function(){function n(n,t,e){switch(e.length){case 0:return n.call(t);case 1:return n.call(t,e[0]);case 2:return n.call(t,e[0],e[1]);case 3:return n.call(t,e[0],e[1],e[2])}return n.apply(t,e)}function t(n,t,e,r){for(var i=-1,o=null==n?0:n.length;++i<o;){var u=n[i];t(r,u,e(u),n)}return r}function e(n,t){for(var e=-1,r=null==n?0:n.length;++e<r&&!1!==t(n[e],e,n););return n}function r(n,t){for(var e=null==n?0:n.length;e--&&!1!==t(n[e],e,n););return n}function i(n,t){for(var e=-1,r=null==n?0:n.length;++e<r;)if(!t(n[e],e,n))return!1;return!0}function o(n,t){for(var e=-1,r=null==n?0:n.length,i=0,o=[];++e<r;){var u=n[e];t(u,e,n)&&(o[i++]=u)}return o}function u(n,t){return!(null==n||!n.length)&&v(n,t,0)>-1}function a(n,t,e){for(var r=-1,i=null==n?0:n.length;++r<i;)if(e(t,n[r]))return!0;return!1}function c(n,t){for(var e=-1,r=null==n?0:n.length,i=Array(r);++e<r;)i[e]=t(n[e],e,n);return i}function s(n,t){for(var e=-1,r=t.length,i=n.length;++e<r;)n[i+e]=t[e];return n}function f(n,t,e,r){var i=-1,o=null==n?0:n.length;for(r&&o&&(e=n[++i]);++i<o;)e=t(e,n[i],i,n);return e}function l(n,t,e,r){var i=null==n?0:n.length;for(r&&i&&(e=n[--i]);i--;)e=t(e,n[i],i,n);return e}function d(n,t){for(var e=-1,r=null==n?0:n.length;++e<r;)if(t(n[e],e,n))return!0;return!1}function h(n){return n.match($n)||[]}function g(n,t,e){var r;return e(n,(function(n,e,i){if(t(n,e,i))return r=e,!1})),r}function p(n,t,e,r){for(var i=n.length,o=e+(r?1:-1);r?o--:++o<i;)if(t(n[o],o,n))return o;return-1}function v(n,t,e){return t==t?function(n,t,e){for(var r=e-1,i=n.length;++r<i;)if(n[r]===t)return r;return-1}(n,t,e):p(n,m,e)}function _(n,t,e,r){for(var i=e-1,o=n.length;++i<o;)if(r(n[i],t))return i;return-1}function m(n){return n!=n}function y(n,t){var e=null==n?0:n.length;return e?x(n,t)/e:X}function b(n){return function(t){return null==t?q:t[n]}}function w(n){return function(t){return null==n?q:n[t]}}function k(n,t,e,r,i){return i(n,(function(n,i,o){e=r?(r=!1,n):t(e,n,i,o)})),e}function x(n,t){for(var e,r=-1,i=n.length;++r<i;){var o=t(n[r]);o!==q&&(e=e===q?o:e+o)}return e}function C(n,t){for(var e=-1,r=Array(n);++e<n;)r[e]=t(e);return r}function I(n){return n?n.slice(0,N(n)+1).replace(Nn,""):n}function A(n){return function(t){return n(t)}}function S(n,t){return c(t,(function(t){return n[t]}))}function E(n,t){return n.has(t)}function D(n,t){for(var e=-1,r=n.length;++e<r&&v(t,n[e],0)>-1;);return e}function L(n,t){for(var e=n.length;e--&&v(t,n[e],0)>-1;);return e}function T(n,t){for(var e=n.length,r=0;e--;)n[e]===t&&++r;return r}function j(n){return"\\"+Bt[n]}function O(n){return zt.test(n)}function R(n){return Wt.test(n)}function M(n){var t=-1,e=Array(n.size);return n.forEach((function(n,r){e[++t]=[r,n]})),e}function F(n,t){return function(e){return n(t(e))}}function P(n,t){for(var e=-1,r=n.length,i=0,o=[];++e<r;){var u=n[e];u!==t&&u!==$||(n[e]=$,o[i++]=e)}return o}function z(n){var t=-1,e=Array(n.size);return n.forEach((function(n){e[++t]=n})),e}function W(n){return O(n)?function(n){for(var t=Ft.lastIndex=0;Ft.test(n);)++t;return t}(n):ae(n)}function K(n){return O(n)?function(n){return n.match(Ft)||[]}(n):function(n){return n.split("")}(n)}function N(n){for(var t=n.length;t--&&Un.test(n.charAt(t)););return t}function U(n){return n.match(Pt)||[]}var q,B="Expected a function",V="__lodash_hash_undefined__",$="__lodash_placeholder__",H=128,Z=9007199254740991,X=NaN,G=4294967295,Q=[["ary",H],["bind",1],["bindKey",2],["curry",8],["curryRight",16],["flip",512],["partial",32],["partialRight",64],["rearg",256]],J="[object Arguments]",Y="[object Array]",nn="[object Boolean]",tn="[object Date]",en="[object Error]",rn="[object Function]",on="[object GeneratorFunction]",un="[object Map]",an="[object Number]",cn="[object Object]",sn="[object Promise]",fn="[object RegExp]",ln="[object Set]",dn="[object String]",hn="[object Symbol]",gn="[object WeakMap]",pn="[object ArrayBuffer]",vn="[object DataView]",_n="[object Float32Array]",mn="[object Float64Array]",yn="[object Int8Array]",bn="[object Int16Array]",wn="[object Int32Array]",kn="[object Uint8Array]",xn="[object Uint8ClampedArray]",Cn="[object Uint16Array]",In="[object Uint32Array]",An=/\b__p \+= '';/g,Sn=/\b(__p \+=) '' \+/g,En=/(__e\(.*?\)|\b__t\)) \+\n'';/g,Dn=/&(?:amp|lt|gt|quot|#39);/g,Ln=/[&<>"']/g,Tn=RegExp(Dn.source),jn=RegExp(Ln.source),On=/<%-([\s\S]+?)%>/g,Rn=/<%([\s\S]+?)%>/g,Mn=/<%=([\s\S]+?)%>/g,Fn=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,Pn=/^\w*$/,zn=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,Wn=/[\\^$.*+?()[\]{}|]/g,Kn=RegExp(Wn.source),Nn=/^\s+/,Un=/\s/,qn=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,Bn=/\{\n\/\* \[wrapped with (.+)\] \*/,Vn=/,? & /,$n=/[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g,Hn=/[()=,{}\[\]\/\s]/,Zn=/\\(\\)?/g,Xn=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,Gn=/\w*$/,Qn=/^[-+]0x[0-9a-f]+$/i,Jn=/^0b[01]+$/i,Yn=/^\[object .+?Constructor\]$/,nt=/^0o[0-7]+$/i,tt=/^(?:0|[1-9]\d*)$/,et=/[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g,rt=/($^)/,it=/['\n\r\u2028\u2029\\]/g,ot="\\ud800-\\udfff",ut="\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff",at="\\u2700-\\u27bf",ct="a-z\\xdf-\\xf6\\xf8-\\xff",st="A-Z\\xc0-\\xd6\\xd8-\\xde",ft="\\ufe0e\\ufe0f",lt="\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2000-\\u206f \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",dt="['’]",ht="["+ot+"]",gt="["+lt+"]",pt="["+ut+"]",vt="\\d+",_t="["+at+"]",mt="["+ct+"]",yt="[^"+ot+lt+vt+at+ct+st+"]",bt="\\ud83c[\\udffb-\\udfff]",wt="[^"+ot+"]",kt="(?:\\ud83c[\\udde6-\\uddff]){2}",xt="[\\ud800-\\udbff][\\udc00-\\udfff]",Ct="["+st+"]",It="(?:"+mt+"|"+yt+")",At="(?:"+Ct+"|"+yt+")",St="(?:['’](?:d|ll|m|re|s|t|ve))?",Et="(?:['’](?:D|LL|M|RE|S|T|VE))?",Dt="(?:"+pt+"|"+bt+")"+"?",Lt="["+ft+"]?",Tt=Lt+Dt+("(?:\\u200d(?:"+[wt,kt,xt].join("|")+")"+Lt+Dt+")*"),jt="(?:"+[_t,kt,xt].join("|")+")"+Tt,Ot="(?:"+[wt+pt+"?",pt,kt,xt,ht].join("|")+")",Rt=RegExp(dt,"g"),Mt=RegExp(pt,"g"),Ft=RegExp(bt+"(?="+bt+")|"+Ot+Tt,"g"),Pt=RegExp([Ct+"?"+mt+"+"+St+"(?="+[gt,Ct,"$"].join("|")+")",At+"+"+Et+"(?="+[gt,Ct+It,"$"].join("|")+")",Ct+"?"+It+"+"+St,Ct+"+"+Et,"\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])","\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",vt,jt].join("|"),"g"),zt=RegExp("[\\u200d"+ot+ut+ft+"]"),Wt=/[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,Kt=["Array","Buffer","DataView","Date","Error","Float32Array","Float64Array","Function","Int8Array","Int16Array","Int32Array","Map","Math","Object","Promise","RegExp","Set","String","Symbol","TypeError","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","WeakMap","_","clearTimeout","isFinite","parseInt","setTimeout"],Nt=-1,Ut={};Ut[_n]=Ut[mn]=Ut[yn]=Ut[bn]=Ut[wn]=Ut[kn]=Ut[xn]=Ut[Cn]=Ut[In]=!0,Ut[J]=Ut[Y]=Ut[pn]=Ut[nn]=Ut[vn]=Ut[tn]=Ut[en]=Ut[rn]=Ut[un]=Ut[an]=Ut[cn]=Ut[fn]=Ut[ln]=Ut[dn]=Ut[gn]=!1;var qt={};qt[J]=qt[Y]=qt[pn]=qt[vn]=qt[nn]=qt[tn]=qt[_n]=qt[mn]=qt[yn]=qt[bn]=qt[wn]=qt[un]=qt[an]=qt[cn]=qt[fn]=qt[ln]=qt[dn]=qt[hn]=qt[kn]=qt[xn]=qt[Cn]=qt[In]=!0,qt[en]=qt[rn]=qt[gn]=!1;var Bt={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"},Vt=parseFloat,$t=parseInt,Ht="object"==typeof global&&global&&global.Object===Object&&global,Zt="object"==typeof self&&self&&self.Object===Object&&self,Xt=Ht||Zt||Function("return this")(),Gt="object"==typeof exports&&exports&&!exports.nodeType&&exports,Qt=Gt&&"object"==typeof module&&module&&!module.nodeType&&module,Jt=Qt&&Qt.exports===Gt,Yt=Jt&&Ht.process,ne=function(){try{var n=Qt&&Qt.require&&Qt.require("util").types;return n||Yt&&Yt.binding&&Yt.binding("util")}catch(n){}}(),te=ne&&ne.isArrayBuffer,ee=ne&&ne.isDate,re=ne&&ne.isMap,ie=ne&&ne.isRegExp,oe=ne&&ne.isSet,ue=ne&&ne.isTypedArray,ae=b("length"),ce=w({"À":"A","Á":"A","Â":"A","Ã":"A","Ä":"A","Å":"A","à":"a","á":"a","â":"a","ã":"a","ä":"a","å":"a","Ç":"C","ç":"c","Ð":"D","ð":"d","È":"E","É":"E","Ê":"E","Ë":"E","è":"e","é":"e","ê":"e","ë":"e","Ì":"I","Í":"I","Î":"I","Ï":"I","ì":"i","í":"i","î":"i","ï":"i","Ñ":"N","ñ":"n","Ò":"O","Ó":"O","Ô":"O","Õ":"O","Ö":"O","Ø":"O","ò":"o","ó":"o","ô":"o","õ":"o","ö":"o","ø":"o","Ù":"U","Ú":"U","Û":"U","Ü":"U","ù":"u","ú":"u","û":"u","ü":"u","Ý":"Y","ý":"y","ÿ":"y","Æ":"Ae","æ":"ae","Þ":"Th","þ":"th","ß":"ss","Ā":"A","Ă":"A","Ą":"A","ā":"a","ă":"a","ą":"a","Ć":"C","Ĉ":"C","Ċ":"C","Č":"C","ć":"c","ĉ":"c","ċ":"c","č":"c","Ď":"D","Đ":"D","ď":"d","đ":"d","Ē":"E","Ĕ":"E","Ė":"E","Ę":"E","Ě":"E","ē":"e","ĕ":"e","ė":"e","ę":"e","ě":"e","Ĝ":"G","Ğ":"G","Ġ":"G","Ģ":"G","ĝ":"g","ğ":"g","ġ":"g","ģ":"g","Ĥ":"H","Ħ":"H","ĥ":"h","ħ":"h","Ĩ":"I","Ī":"I","Ĭ":"I","Į":"I","İ":"I","ĩ":"i","ī":"i","ĭ":"i","į":"i","ı":"i","Ĵ":"J","ĵ":"j","Ķ":"K","ķ":"k","ĸ":"k","Ĺ":"L","Ļ":"L","Ľ":"L","Ŀ":"L","Ł":"L","ĺ":"l","ļ":"l","ľ":"l","ŀ":"l","ł":"l","Ń":"N","Ņ":"N","Ň":"N","Ŋ":"N","ń":"n","ņ":"n","ň":"n","ŋ":"n","Ō":"O","Ŏ":"O","Ő":"O","ō":"o","ŏ":"o","ő":"o","Ŕ":"R","Ŗ":"R","Ř":"R","ŕ":"r","ŗ":"r","ř":"r","Ś":"S","Ŝ":"S","Ş":"S","Š":"S","ś":"s","ŝ":"s","ş":"s","š":"s","Ţ":"T","Ť":"T","Ŧ":"T","ţ":"t","ť":"t","ŧ":"t","Ũ":"U","Ū":"U","Ŭ":"U","Ů":"U","Ű":"U","Ų":"U","ũ":"u","ū":"u","ŭ":"u","ů":"u","ű":"u","ų":"u","Ŵ":"W","ŵ":"w","Ŷ":"Y","ŷ":"y","Ÿ":"Y","Ź":"Z","Ż":"Z","Ž":"Z","ź":"z","ż":"z","ž":"z","Ĳ":"IJ","ĳ":"ij","Œ":"Oe","œ":"oe","ŉ":"'n","ſ":"s"}),se=w({"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"}),fe=w({"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'"}),le=function w(Un){function $n(n){if(Mi(n)&&!Ia(n)&&!(n instanceof at)){if(n instanceof ut)return n;if(Io.call(n,"__wrapped__"))return ai(n)}return new ut(n)}function ot(){}function ut(n,t){this.__wrapped__=n,this.__actions__=[],this.__chain__=!!t,this.__index__=0,this.__values__=q}function at(n){this.__wrapped__=n,this.__actions__=[],this.__dir__=1,this.__filtered__=!1,this.__iteratees__=[],this.__takeCount__=G,this.__views__=[]}function ct(n){var t=-1,e=null==n?0:n.length;for(this.clear();++t<e;){var r=n[t];this.set(r[0],r[1])}}function st(n){var t=-1,e=null==n?0:n.length;for(this.clear();++t<e;){var r=n[t];this.set(r[0],r[1])}}function ft(n){var t=-1,e=null==n?0:n.length;for(this.clear();++t<e;){var r=n[t];this.set(r[0],r[1])}}function lt(n){var t=-1,e=null==n?0:n.length;for(this.__data__=new ft;++t<e;)this.add(n[t])}function dt(n){this.size=(this.__data__=new st(n)).size}function ht(n,t){var e=Ia(n),r=!e&&Ca(n),i=!e&&!r&&Sa(n),o=!e&&!r&&!i&&ja(n),u=e||r||i||o,a=u?C(n.length,mo):[],c=a.length;for(var s in n)!t&&!Io.call(n,s)||u&&("length"==s||i&&("offset"==s||"parent"==s)||o&&("buffer"==s||"byteLength"==s||"byteOffset"==s)||Br(s,c))||a.push(s);return a}function gt(n){var t=n.length;return t?n[Se(0,t-1)]:q}function pt(n,t){return ri(ir(n),Ct(t,0,n.length))}function vt(n){return ri(ir(n))}function _t(n,t,e){(e===q||Si(n[t],e))&&(e!==q||t in n)||kt(n,t,e)}function mt(n,t,e){var r=n[t];Io.call(n,t)&&Si(r,e)&&(e!==q||t in n)||kt(n,t,e)}function yt(n,t){for(var e=n.length;e--;)if(Si(n[e][0],t))return e;return-1}function bt(n,t,e,r){return xu(n,(function(n,i,o){t(r,n,e(n),o)})),r}function wt(n,t){return n&&or(t,Xi(t),n)}function kt(n,t,e){"__proto__"==t&&qo?qo(n,t,{configurable:!0,enumerable:!0,value:e,writable:!0}):n[t]=e}function xt(n,t){for(var e=-1,r=t.length,i=fo(r),o=null==n;++e<r;)i[e]=o?q:Hi(n,t[e]);return i}function Ct(n,t,e){return n==n&&(e!==q&&(n=n<=e?n:e),t!==q&&(n=n>=t?n:t)),n}function It(n,t,r,i,o,u){var a,c=1&t,s=2&t,f=4&t;if(r&&(a=o?r(n,i,o,u):r(n)),a!==q)return a;if(!Ri(n))return n;var l=Ia(n);if(l){if(a=function(n){var t=n.length,e=new n.constructor(t);return t&&"string"==typeof n[0]&&Io.call(n,"index")&&(e.index=n.index,e.input=n.input),e}(n),!c)return ir(n,a)}else{var d=Mu(n),h=d==rn||d==on;if(Sa(n))return Je(n,c);if(d==cn||d==J||h&&!o){if(a=s||h?{}:Ur(n),!c)return s?function(n,t){return or(n,Ru(n),t)}(n,function(n,t){return n&&or(t,Gi(t),n)}(a,n)):function(n,t){return or(n,Ou(n),t)}(n,wt(a,n))}else{if(!qt[d])return o?n:{};a=function(n,t,e){var r=n.constructor;switch(t){case pn:return Ye(n);case nn:case tn:return new r(+n);case vn:return function(n,t){return new n.constructor(t?Ye(n.buffer):n.buffer,n.byteOffset,n.byteLength)}(n,e);case _n:case mn:case yn:case bn:case wn:case kn:case xn:case Cn:case In:return nr(n,e);case un:return new r;case an:case dn:return new r(n);case fn:return function(n){var t=new n.constructor(n.source,Gn.exec(n));return t.lastIndex=n.lastIndex,t}(n);case ln:return new r;case hn:return function(n){return bu?vo(bu.call(n)):{}}(n)}}(n,d,c)}}u||(u=new dt);var g=u.get(n);if(g)return g;u.set(n,a),Ta(n)?n.forEach((function(e){a.add(It(e,t,r,e,n,u))})):Da(n)&&n.forEach((function(e,i){a.set(i,It(e,t,r,i,n,u))}));var p=l?q:(f?s?Rr:Or:s?Gi:Xi)(n);return e(p||n,(function(e,i){p&&(e=n[i=e]),mt(a,i,It(e,t,r,i,n,u))})),a}function At(n,t,e){var r=e.length;if(null==n)return!r;for(n=vo(n);r--;){var i=e[r],o=t[i],u=n[i];if(u===q&&!(i in n)||!o(u))return!1}return!0}function St(n,t,e){if("function"!=typeof n)throw new yo(B);return zu((function(){n.apply(q,e)}),t)}function Et(n,t,e,r){var i=-1,o=u,s=!0,f=n.length,l=[],d=t.length;if(!f)return l;e&&(t=c(t,A(e))),r?(o=a,s=!1):t.length>=200&&(o=E,s=!1,t=new lt(t));n:for(;++i<f;){var h=n[i],g=null==e?h:e(h);if(h=r||0!==h?h:0,s&&g==g){for(var p=d;p--;)if(t[p]===g)continue n;l.push(h)}else o(t,g,r)||l.push(h)}return l}function Dt(n,t){var e=!0;return xu(n,(function(n,r,i){return e=!!t(n,r,i)})),e}function Lt(n,t,e){for(var r=-1,i=n.length;++r<i;){var o=n[r],u=t(o);if(null!=u&&(a===q?u==u&&!Wi(u):e(u,a)))var a=u,c=o}return c}function Tt(n,t){var e=[];return xu(n,(function(n,r,i){t(n,r,i)&&e.push(n)})),e}function jt(n,t,e,r,i){var o=-1,u=n.length;for(e||(e=qr),i||(i=[]);++o<u;){var a=n[o];t>0&&e(a)?t>1?jt(a,t-1,e,r,i):s(i,a):r||(i[i.length]=a)}return i}function Ot(n,t){return n&&Iu(n,t,Xi)}function Ft(n,t){return n&&Au(n,t,Xi)}function Pt(n,t){return o(t,(function(t){return Ti(n[t])}))}function zt(n,t){for(var e=0,r=(t=Ge(t,n)).length;null!=n&&e<r;)n=n[ii(t[e++])];return e&&e==r?n:q}function Wt(n,t,e){var r=t(n);return Ia(n)?r:s(r,e(n))}function Bt(n){return null==n?n===q?"[object Undefined]":"[object Null]":Uo&&Uo in vo(n)?function(n){var t=Io.call(n,Uo),e=n[Uo];try{n[Uo]=q;var r=!0}catch(n){}var i=Eo.call(n);return r&&(t?n[Uo]=e:delete n[Uo]),i}(n):function(n){return Eo.call(n)}(n)}function Ht(n,t){return n>t}function Zt(n,t){return null!=n&&Io.call(n,t)}function Gt(n,t){return null!=n&&t in vo(n)}function Qt(n,t,e){for(var r=e?a:u,i=n[0].length,o=n.length,s=o,f=fo(o),l=1/0,d=[];s--;){var h=n[s];s&&t&&(h=c(h,A(t))),l=tu(h.length,l),f[s]=!e&&(t||i>=120&&h.length>=120)?new lt(s&&h):q}h=n[0];var g=-1,p=f[0];n:for(;++g<i&&d.length<l;){var v=h[g],_=t?t(v):v;if(v=e||0!==v?v:0,!(p?E(p,_):r(d,_,e))){for(s=o;--s;){var m=f[s];if(!(m?E(m,_):r(n[s],_,e)))continue n}p&&p.push(_),d.push(v)}}return d}function Yt(t,e,r){var i=null==(t=Jr(t,e=Ge(e,t)))?t:t[ii(di(e))];return null==i?q:n(i,t,r)}function ne(n){return Mi(n)&&Bt(n)==J}function ae(n,t,e,r,i){return n===t||(null==n||null==t||!Mi(n)&&!Mi(t)?n!=n&&t!=t:function(n,t,e,r,i,o){var u=Ia(n),a=Ia(t),c=u?Y:Mu(n),s=a?Y:Mu(t),f=(c=c==J?cn:c)==cn,l=(s=s==J?cn:s)==cn,d=c==s;if(d&&Sa(n)){if(!Sa(t))return!1;u=!0,f=!1}if(d&&!f)return o||(o=new dt),u||ja(n)?Tr(n,t,e,r,i,o):function(n,t,e,r,i,o,u){switch(e){case vn:if(n.byteLength!=t.byteLength||n.byteOffset!=t.byteOffset)return!1;n=n.buffer,t=t.buffer;case pn:return!(n.byteLength!=t.byteLength||!o(new Ro(n),new Ro(t)));case nn:case tn:case an:return Si(+n,+t);case en:return n.name==t.name&&n.message==t.message;case fn:case dn:return n==t+"";case un:var a=M;case ln:var c=1&r;if(a||(a=z),n.size!=t.size&&!c)return!1;var s=u.get(n);if(s)return s==t;r|=2,u.set(n,t);var f=Tr(a(n),a(t),r,i,o,u);return u.delete(n),f;case hn:if(bu)return bu.call(n)==bu.call(t)}return!1}(n,t,c,e,r,i,o);if(!(1&e)){var h=f&&Io.call(n,"__wrapped__"),g=l&&Io.call(t,"__wrapped__");if(h||g){var p=h?n.value():n,v=g?t.value():t;return o||(o=new dt),i(p,v,e,r,o)}}return!!d&&(o||(o=new dt),function(n,t,e,r,i,o){var u=1&e,a=Or(n),c=a.length;if(c!=Or(t).length&&!u)return!1;for(var s=c;s--;){var f=a[s];if(!(u?f in t:Io.call(t,f)))return!1}var l=o.get(n),d=o.get(t);if(l&&d)return l==t&&d==n;var h=!0;o.set(n,t),o.set(t,n);for(var g=u;++s<c;){f=a[s];var p=n[f],v=t[f];if(r)var _=u?r(v,p,f,t,n,o):r(p,v,f,n,t,o);if(!(_===q?p===v||i(p,v,e,r,o):_)){h=!1;break}g||(g="constructor"==f)}if(h&&!g){var m=n.constructor,y=t.constructor;m!=y&&"constructor"in n&&"constructor"in t&&!("function"==typeof m&&m instanceof m&&"function"==typeof y&&y instanceof y)&&(h=!1)}return o.delete(n),o.delete(t),h}(n,t,e,r,i,o))}(n,t,e,r,ae,i))}function de(n,t,e,r){var i=e.length,o=i,u=!r;if(null==n)return!o;for(n=vo(n);i--;){var a=e[i];if(u&&a[2]?a[1]!==n[a[0]]:!(a[0]in n))return!1}for(;++i<o;){var c=(a=e[i])[0],s=n[c],f=a[1];if(u&&a[2]){if(s===q&&!(c in n))return!1}else{var l=new dt;if(r)var d=r(s,f,c,n,t,l);if(!(d===q?ae(f,s,3,r,l):d))return!1}}return!0}function he(n){return!(!Ri(n)||function(n){return!!So&&So in n}(n))&&(Ti(n)?To:Yn).test(oi(n))}function ge(n){return"function"==typeof n?n:null==n?ro:"object"==typeof n?Ia(n)?be(n[0],n[1]):ye(n):ao(n)}function pe(n){if(!Zr(n))return Yo(n);var t=[];for(var e in vo(n))Io.call(n,e)&&"constructor"!=e&&t.push(e);return t}function ve(n){if(!Ri(n))return function(n){var t=[];if(null!=n)for(var e in vo(n))t.push(e);return t}(n);var t=Zr(n),e=[];for(var r in n)("constructor"!=r||!t&&Io.call(n,r))&&e.push(r);return e}function _e(n,t){return n<t}function me(n,t){var e=-1,r=Ei(n)?fo(n.length):[];return xu(n,(function(n,i,o){r[++e]=t(n,i,o)})),r}function ye(n){var t=Wr(n);return 1==t.length&&t[0][2]?Gr(t[0][0],t[0][1]):function(e){return e===n||de(e,n,t)}}function be(n,t){return $r(n)&&Xr(t)?Gr(ii(n),t):function(e){var r=Hi(e,n);return r===q&&r===t?Zi(e,n):ae(t,r,3)}}function we(n,t,e,r,i){n!==t&&Iu(t,(function(o,u){if(i||(i=new dt),Ri(o))!function(n,t,e,r,i,o,u){var a=ni(n,e),c=ni(t,e),s=u.get(c);if(s)return _t(n,e,s),q;var f=o?o(a,c,e+"",n,t,u):q,l=f===q;if(l){var d=Ia(c),h=!d&&Sa(c),g=!d&&!h&&ja(c);f=c,d||h||g?Ia(a)?f=a:Di(a)?f=ir(a):h?(l=!1,f=Je(c,!0)):g?(l=!1,f=nr(c,!0)):f=[]:Pi(c)||Ca(c)?(f=a,Ca(a)?f=Vi(a):Ri(a)&&!Ti(a)||(f=Ur(c))):l=!1}l&&(u.set(c,f),i(f,c,r,o,u),u.delete(c)),_t(n,e,f)}(n,t,u,e,we,r,i);else{var a=r?r(ni(n,u),o,u+"",n,t,i):q;a===q&&(a=o),_t(n,u,a)}}),Gi)}function ke(n,t){var e=n.length;if(e)return Br(t+=t<0?e:0,e)?n[t]:q}function xe(n,t,e){t=t.length?c(t,(function(n){return Ia(n)?function(t){return zt(t,1===n.length?n[0]:n)}:n})):[ro];var r=-1;return t=c(t,A(Pr())),function(n,t){var e=n.length;for(n.sort(t);e--;)n[e]=n[e].value;return n}(me(n,(function(n,e,i){return{criteria:c(t,(function(t){return t(n)})),index:++r,value:n}})),(function(n,t){return function(n,t,e){for(var r=-1,i=n.criteria,o=t.criteria,u=i.length,a=e.length;++r<u;){var c=tr(i[r],o[r]);if(c)return r>=a?c:c*("desc"==e[r]?-1:1)}return n.index-t.index}(n,t,e)}))}function Ce(n,t,e){for(var r=-1,i=t.length,o={};++r<i;){var u=t[r],a=zt(n,u);e(a,u)&&je(o,Ge(u,n),a)}return o}function Ie(n,t,e,r){var i=r?_:v,o=-1,u=t.length,a=n;for(n===t&&(t=ir(t)),e&&(a=c(n,A(e)));++o<u;)for(var s=0,f=t[o],l=e?e(f):f;(s=i(a,l,s,r))>-1;)a!==n&&Wo.call(a,s,1),Wo.call(n,s,1);return n}function Ae(n,t){for(var e=n?t.length:0,r=e-1;e--;){var i=t[e];if(e==r||i!==o){var o=i;Br(i)?Wo.call(n,i,1):Ue(n,i)}}return n}function Se(n,t){return n+Zo(iu()*(t-n+1))}function Ee(n,t){var e="";if(!n||t<1||t>Z)return e;do{t%2&&(e+=n),(t=Zo(t/2))&&(n+=n)}while(t);return e}function De(n,t){return Wu(Qr(n,t,ro),n+"")}function Le(n){return gt(Ji(n))}function Te(n,t){var e=Ji(n);return ri(e,Ct(t,0,e.length))}function je(n,t,e,r){if(!Ri(n))return n;for(var i=-1,o=(t=Ge(t,n)).length,u=o-1,a=n;null!=a&&++i<o;){var c=ii(t[i]),s=e;if("__proto__"===c||"constructor"===c||"prototype"===c)return n;if(i!=u){var f=a[c];(s=r?r(f,c,a):q)===q&&(s=Ri(f)?f:Br(t[i+1])?[]:{})}mt(a,c,s),a=a[c]}return n}function Oe(n){return ri(Ji(n))}function Re(n,t,e){var r=-1,i=n.length;t<0&&(t=-t>i?0:i+t),(e=e>i?i:e)<0&&(e+=i),i=t>e?0:e-t>>>0,t>>>=0;for(var o=fo(i);++r<i;)o[r]=n[r+t];return o}function Me(n,t){var e;return xu(n,(function(n,r,i){return!(e=t(n,r,i))})),!!e}function Fe(n,t,e){var r=0,i=null==n?r:n.length;if("number"==typeof t&&t==t&&i<=2147483647){for(;r<i;){var o=r+i>>>1,u=n[o];null!==u&&!Wi(u)&&(e?u<=t:u<t)?r=o+1:i=o}return i}return Pe(n,t,ro,e)}function Pe(n,t,e,r){var i=0,o=null==n?0:n.length;if(0===o)return 0;for(var u=(t=e(t))!=t,a=null===t,c=Wi(t),s=t===q;i<o;){var f=Zo((i+o)/2),l=e(n[f]),d=l!==q,h=null===l,g=l==l,p=Wi(l);if(u)var v=r||g;else v=s?g&&(r||d):a?g&&d&&(r||!h):c?g&&d&&!h&&(r||!p):!h&&!p&&(r?l<=t:l<t);v?i=f+1:o=f}return tu(o,4294967294)}function ze(n,t){for(var e=-1,r=n.length,i=0,o=[];++e<r;){var u=n[e],a=t?t(u):u;if(!e||!Si(a,c)){var c=a;o[i++]=0===u?0:u}}return o}function We(n){return"number"==typeof n?n:Wi(n)?X:+n}function Ke(n){if("string"==typeof n)return n;if(Ia(n))return c(n,Ke)+"";if(Wi(n))return wu?wu.call(n):"";var t=n+"";return"0"==t&&1/n==-1/0?"-0":t}function Ne(n,t,e){var r=-1,i=u,o=n.length,c=!0,s=[],f=s;if(e)c=!1,i=a;else if(o>=200){var l=t?null:Tu(n);if(l)return z(l);c=!1,i=E,f=new lt}else f=t?[]:s;n:for(;++r<o;){var d=n[r],h=t?t(d):d;if(d=e||0!==d?d:0,c&&h==h){for(var g=f.length;g--;)if(f[g]===h)continue n;t&&f.push(h),s.push(d)}else i(f,h,e)||(f!==s&&f.push(h),s.push(d))}return s}function Ue(n,t){return null==(n=Jr(n,t=Ge(t,n)))||delete n[ii(di(t))]}function qe(n,t,e,r){return je(n,t,e(zt(n,t)),r)}function Be(n,t,e,r){for(var i=n.length,o=r?i:-1;(r?o--:++o<i)&&t(n[o],o,n););return e?Re(n,r?0:o,r?o+1:i):Re(n,r?o+1:0,r?i:o)}function Ve(n,t){var e=n;return e instanceof at&&(e=e.value()),f(t,(function(n,t){return t.func.apply(t.thisArg,s([n],t.args))}),e)}function $e(n,t,e){var r=n.length;if(r<2)return r?Ne(n[0]):[];for(var i=-1,o=fo(r);++i<r;)for(var u=n[i],a=-1;++a<r;)a!=i&&(o[i]=Et(o[i]||u,n[a],t,e));return Ne(jt(o,1),t,e)}function He(n,t,e){for(var r=-1,i=n.length,o=t.length,u={};++r<i;)e(u,n[r],r<o?t[r]:q);return u}function Ze(n){return Di(n)?n:[]}function Xe(n){return"function"==typeof n?n:ro}function Ge(n,t){return Ia(n)?n:$r(n,t)?[n]:Ku($i(n))}function Qe(n,t,e){var r=n.length;return e=e===q?r:e,!t&&e>=r?n:Re(n,t,e)}function Je(n,t){if(t)return n.slice();var e=n.length,r=Mo?Mo(e):new n.constructor(e);return n.copy(r),r}function Ye(n){var t=new n.constructor(n.byteLength);return new Ro(t).set(new Ro(n)),t}function nr(n,t){return new n.constructor(t?Ye(n.buffer):n.buffer,n.byteOffset,n.length)}function tr(n,t){if(n!==t){var e=n!==q,r=null===n,i=n==n,o=Wi(n),u=t!==q,a=null===t,c=t==t,s=Wi(t);if(!a&&!s&&!o&&n>t||o&&u&&c&&!a&&!s||r&&u&&c||!e&&c||!i)return 1;if(!r&&!o&&!s&&n<t||s&&e&&i&&!r&&!o||a&&e&&i||!u&&i||!c)return-1}return 0}function er(n,t,e,r){for(var i=-1,o=n.length,u=e.length,a=-1,c=t.length,s=nu(o-u,0),f=fo(c+s),l=!r;++a<c;)f[a]=t[a];for(;++i<u;)(l||i<o)&&(f[e[i]]=n[i]);for(;s--;)f[a++]=n[i++];return f}function rr(n,t,e,r){for(var i=-1,o=n.length,u=-1,a=e.length,c=-1,s=t.length,f=nu(o-a,0),l=fo(f+s),d=!r;++i<f;)l[i]=n[i];for(var h=i;++c<s;)l[h+c]=t[c];for(;++u<a;)(d||i<o)&&(l[h+e[u]]=n[i++]);return l}function ir(n,t){var e=-1,r=n.length;for(t||(t=fo(r));++e<r;)t[e]=n[e];return t}function or(n,t,e,r){var i=!e;e||(e={});for(var o=-1,u=t.length;++o<u;){var a=t[o],c=r?r(e[a],n[a],a,e,n):q;c===q&&(c=n[a]),i?kt(e,a,c):mt(e,a,c)}return e}function ur(n,e){return function(r,i){var o=Ia(r)?t:bt,u=e?e():{};return o(r,n,Pr(i,2),u)}}function ar(n){return De((function(t,e){var r=-1,i=e.length,o=i>1?e[i-1]:q,u=i>2?e[2]:q;for(o=n.length>3&&"function"==typeof o?(i--,o):q,u&&Vr(e[0],e[1],u)&&(o=i<3?q:o,i=1),t=vo(t);++r<i;){var a=e[r];a&&n(t,a,r,o)}return t}))}function cr(n,t){return function(e,r){if(null==e)return e;if(!Ei(e))return n(e,r);for(var i=e.length,o=t?i:-1,u=vo(e);(t?o--:++o<i)&&!1!==r(u[o],o,u););return e}}function sr(n){return function(t,e,r){for(var i=-1,o=vo(t),u=r(t),a=u.length;a--;){var c=u[n?a:++i];if(!1===e(o[c],c,o))break}return t}}function fr(n){return function(t){var e=O(t=$i(t))?K(t):q,r=e?e[0]:t.charAt(0),i=e?Qe(e,1).join(""):t.slice(1);return r[n]()+i}}function lr(n){return function(t){return f(to(no(t).replace(Rt,"")),n,"")}}function dr(n){return function(){var t=arguments;switch(t.length){case 0:return new n;case 1:return new n(t[0]);case 2:return new n(t[0],t[1]);case 3:return new n(t[0],t[1],t[2]);case 4:return new n(t[0],t[1],t[2],t[3]);case 5:return new n(t[0],t[1],t[2],t[3],t[4]);case 6:return new n(t[0],t[1],t[2],t[3],t[4],t[5]);case 7:return new n(t[0],t[1],t[2],t[3],t[4],t[5],t[6])}var e=ku(n.prototype),r=n.apply(e,t);return Ri(r)?r:e}}function hr(t,e,r){var i=dr(t);return function o(){for(var u=arguments.length,a=fo(u),c=u,s=Fr(o);c--;)a[c]=arguments[c];var f=u<3&&a[0]!==s&&a[u-1]!==s?[]:P(a,s);return(u-=f.length)<r?Cr(t,e,vr,o.placeholder,q,a,f,q,q,r-u):n(this&&this!==Xt&&this instanceof o?i:t,this,a)}}function gr(n){return function(t,e,r){var i=vo(t);if(!Ei(t)){var o=Pr(e,3);t=Xi(t),e=function(n){return o(i[n],n,i)}}var u=n(t,e,r);return u>-1?i[o?t[u]:u]:q}}function pr(n){return jr((function(t){var e=t.length,r=e,i=ut.prototype.thru;for(n&&t.reverse();r--;){var o=t[r];if("function"!=typeof o)throw new yo(B);if(i&&!u&&"wrapper"==Mr(o))var u=new ut([],!0)}for(r=u?r:e;++r<e;){var a=Mr(o=t[r]),c="wrapper"==a?ju(o):q;u=c&&Hr(c[0])&&424==c[1]&&!c[4].length&&1==c[9]?u[Mr(c[0])].apply(u,c[3]):1==o.length&&Hr(o)?u[a]():u.thru(o)}return function(){var n=arguments,r=n[0];if(u&&1==n.length&&Ia(r))return u.plant(r).value();for(var i=0,o=e?t[i].apply(this,n):r;++i<e;)o=t[i].call(this,o);return o}}))}function vr(n,t,e,r,i,o,u,a,c,s){var f=t&H,l=1&t,d=2&t,h=24&t,g=512&t,p=d?q:dr(n);return function v(){for(var _=arguments.length,m=fo(_),y=_;y--;)m[y]=arguments[y];if(h)var b=Fr(v),w=T(m,b);if(r&&(m=er(m,r,i,h)),o&&(m=rr(m,o,u,h)),_-=w,h&&_<s)return Cr(n,t,vr,v.placeholder,e,m,P(m,b),a,c,s-_);var k=l?e:this,x=d?k[n]:n;return _=m.length,a?m=Yr(m,a):g&&_>1&&m.reverse(),f&&c<_&&(m.length=c),this&&this!==Xt&&this instanceof v&&(x=p||dr(x)),x.apply(k,m)}}function _r(n,t){return function(e,r){return function(n,t,e,r){return Ot(n,(function(n,i,o){t(r,e(n),i,o)})),r}(e,n,t(r),{})}}function mr(n,t){return function(e,r){var i;if(e===q&&r===q)return t;if(e!==q&&(i=e),r!==q){if(i===q)return r;"string"==typeof e||"string"==typeof r?(e=Ke(e),r=Ke(r)):(e=We(e),r=We(r)),i=n(e,r)}return i}}function yr(t){return jr((function(e){return e=c(e,A(Pr())),De((function(r){var i=this;return t(e,(function(t){return n(t,i,r)}))}))}))}function br(n,t){var e=(t=t===q?" ":Ke(t)).length;if(e<2)return e?Ee(t,n):t;var r=Ee(t,Ho(n/W(t)));return O(t)?Qe(K(r),0,n).join(""):r.slice(0,n)}function wr(t,e,r,i){var o=1&e,u=dr(t);return function e(){for(var a=-1,c=arguments.length,s=-1,f=i.length,l=fo(f+c),d=this&&this!==Xt&&this instanceof e?u:t;++s<f;)l[s]=i[s];for(;c--;)l[s++]=arguments[++a];return n(d,o?r:this,l)}}function kr(n){return function(t,e,r){return r&&"number"!=typeof r&&Vr(t,e,r)&&(e=r=q),t=Ni(t),e===q?(e=t,t=0):e=Ni(e),function(n,t,e,r){for(var i=-1,o=nu(Ho((t-n)/(e||1)),0),u=fo(o);o--;)u[r?o:++i]=n,n+=e;return u}(t,e,r=r===q?t<e?1:-1:Ni(r),n)}}function xr(n){return function(t,e){return"string"==typeof t&&"string"==typeof e||(t=Bi(t),e=Bi(e)),n(t,e)}}function Cr(n,t,e,r,i,o,u,a,c,s){var f=8&t;t|=f?32:64,4&(t&=~(f?64:32))||(t&=-4);var l=[n,t,i,f?o:q,f?u:q,f?q:o,f?q:u,a,c,s],d=e.apply(q,l);return Hr(n)&&Pu(d,l),d.placeholder=r,ti(d,n,t)}function Ir(n){var t=po[n];return function(n,e){if(n=Bi(n),(e=null==e?0:tu(Ui(e),292))&&Qo(n)){var r=($i(n)+"e").split("e");return+((r=($i(t(r[0]+"e"+(+r[1]+e)))+"e").split("e"))[0]+"e"+(+r[1]-e))}return t(n)}}function Ar(n){return function(t){var e=Mu(t);return e==un?M(t):e==ln?function(n){var t=-1,e=Array(n.size);return n.forEach((function(n){e[++t]=[n,n]})),e}(t):function(n,t){return c(t,(function(t){return[t,n[t]]}))}(t,n(t))}}function Sr(n,t,e,r,i,o,u,a){var c=2&t;if(!c&&"function"!=typeof n)throw new yo(B);var s=r?r.length:0;if(s||(t&=-97,r=i=q),u=u===q?u:nu(Ui(u),0),a=a===q?a:Ui(a),s-=i?i.length:0,64&t){var f=r,l=i;r=i=q}var d=c?q:ju(n),h=[n,t,e,r,i,f,l,o,u,a];if(d&&function(n,t){var e=n[1],r=t[1],i=e|r,o=i<131,u=r==H&&8==e||r==H&&256==e&&n[7].length<=t[8]||384==r&&t[7].length<=t[8]&&8==e;if(!o&&!u)return n;1&r&&(n[2]=t[2],i|=1&e?0:4);var a=t[3];if(a){var c=n[3];n[3]=c?er(c,a,t[4]):a,n[4]=c?P(n[3],$):t[4]}(a=t[5])&&(c=n[5],n[5]=c?rr(c,a,t[6]):a,n[6]=c?P(n[5],$):t[6]),(a=t[7])&&(n[7]=a),r&H&&(n[8]=null==n[8]?t[8]:tu(n[8],t[8])),null==n[9]&&(n[9]=t[9]),n[0]=t[0],n[1]=i}(h,d),n=h[0],t=h[1],e=h[2],r=h[3],i=h[4],!(a=h[9]=h[9]===q?c?0:n.length:nu(h[9]-s,0))&&24&t&&(t&=-25),t&&1!=t)g=8==t||16==t?hr(n,t,a):32!=t&&33!=t||i.length?vr.apply(q,h):wr(n,t,e,r);else var g=function(n,t,e){var r=1&t,i=dr(n);return function t(){return(this&&this!==Xt&&this instanceof t?i:n).apply(r?e:this,arguments)}}(n,t,e);return ti((d?Su:Pu)(g,h),n,t)}function Er(n,t,e,r){return n===q||Si(n,ko[e])&&!Io.call(r,e)?t:n}function Dr(n,t,e,r,i,o){return Ri(n)&&Ri(t)&&(o.set(t,n),we(n,t,q,Dr,o),o.delete(t)),n}function Lr(n){return Pi(n)?q:n}function Tr(n,t,e,r,i,o){var u=1&e,a=n.length,c=t.length;if(a!=c&&!(u&&c>a))return!1;var s=o.get(n),f=o.get(t);if(s&&f)return s==t&&f==n;var l=-1,h=!0,g=2&e?new lt:q;for(o.set(n,t),o.set(t,n);++l<a;){var p=n[l],v=t[l];if(r)var _=u?r(v,p,l,t,n,o):r(p,v,l,n,t,o);if(_!==q){if(_)continue;h=!1;break}if(g){if(!d(t,(function(n,t){if(!E(g,t)&&(p===n||i(p,n,e,r,o)))return g.push(t)}))){h=!1;break}}else if(p!==v&&!i(p,v,e,r,o)){h=!1;break}}return o.delete(n),o.delete(t),h}function jr(n){return Wu(Qr(n,q,fi),n+"")}function Or(n){return Wt(n,Xi,Ou)}function Rr(n){return Wt(n,Gi,Ru)}function Mr(n){for(var t=n.name+"",e=hu[t],r=Io.call(hu,t)?e.length:0;r--;){var i=e[r],o=i.func;if(null==o||o==n)return i.name}return t}function Fr(n){return(Io.call($n,"placeholder")?$n:n).placeholder}function Pr(){var n=$n.iteratee||io;return n=n===io?ge:n,arguments.length?n(arguments[0],arguments[1]):n}function zr(n,t){var e=n.__data__;return function(n){var t=typeof n;return"string"==t||"number"==t||"symbol"==t||"boolean"==t?"__proto__"!==n:null===n}(t)?e["string"==typeof t?"string":"hash"]:e.map}function Wr(n){for(var t=Xi(n),e=t.length;e--;){var r=t[e],i=n[r];t[e]=[r,i,Xr(i)]}return t}function Kr(n,t){var e=function(n,t){return null==n?q:n[t]}(n,t);return he(e)?e:q}function Nr(n,t,e){for(var r=-1,i=(t=Ge(t,n)).length,o=!1;++r<i;){var u=ii(t[r]);if(!(o=null!=n&&e(n,u)))break;n=n[u]}return o||++r!=i?o:!!(i=null==n?0:n.length)&&Oi(i)&&Br(u,i)&&(Ia(n)||Ca(n))}function Ur(n){return"function"!=typeof n.constructor||Zr(n)?{}:ku(Fo(n))}function qr(n){return Ia(n)||Ca(n)||!!(Ko&&n&&n[Ko])}function Br(n,t){var e=typeof n;return!!(t=null==t?Z:t)&&("number"==e||"symbol"!=e&&tt.test(n))&&n>-1&&n%1==0&&n<t}function Vr(n,t,e){if(!Ri(e))return!1;var r=typeof t;return!!("number"==r?Ei(e)&&Br(t,e.length):"string"==r&&t in e)&&Si(e[t],n)}function $r(n,t){if(Ia(n))return!1;var e=typeof n;return!("number"!=e&&"symbol"!=e&&"boolean"!=e&&null!=n&&!Wi(n))||Pn.test(n)||!Fn.test(n)||null!=t&&n in vo(t)}function Hr(n){var t=Mr(n),e=$n[t];if("function"!=typeof e||!(t in at.prototype))return!1;if(n===e)return!0;var r=ju(e);return!!r&&n===r[0]}function Zr(n){var t=n&&n.constructor;return n===("function"==typeof t&&t.prototype||ko)}function Xr(n){return n==n&&!Ri(n)}function Gr(n,t){return function(e){return null!=e&&e[n]===t&&(t!==q||n in vo(e))}}function Qr(t,e,r){return e=nu(e===q?t.length-1:e,0),function(){for(var i=arguments,o=-1,u=nu(i.length-e,0),a=fo(u);++o<u;)a[o]=i[e+o];o=-1;for(var c=fo(e+1);++o<e;)c[o]=i[o];return c[e]=r(a),n(t,this,c)}}function Jr(n,t){return t.length<2?n:zt(n,Re(t,0,-1))}function Yr(n,t){for(var e=n.length,r=tu(t.length,e),i=ir(n);r--;){var o=t[r];n[r]=Br(o,e)?i[o]:q}return n}function ni(n,t){if(("constructor"!==t||"function"!=typeof n[t])&&"__proto__"!=t)return n[t]}function ti(n,t,e){var r=t+"";return Wu(n,function(n,t){var e=t.length;if(!e)return n;var r=e-1;return t[r]=(e>1?"& ":"")+t[r],t=t.join(e>2?", ":" "),n.replace(qn,"{\n/* [wrapped with "+t+"] */\n")}(r,ui(function(n){var t=n.match(Bn);return t?t[1].split(Vn):[]}(r),e)))}function ei(n){var t=0,e=0;return function(){var r=eu(),i=16-(r-e);if(e=r,i>0){if(++t>=800)return arguments[0]}else t=0;return n.apply(q,arguments)}}function ri(n,t){var e=-1,r=n.length,i=r-1;for(t=t===q?r:t;++e<t;){var o=Se(e,i),u=n[o];n[o]=n[e],n[e]=u}return n.length=t,n}function ii(n){if("string"==typeof n||Wi(n))return n;var t=n+"";return"0"==t&&1/n==-1/0?"-0":t}function oi(n){if(null!=n){try{return Co.call(n)}catch(n){}try{return n+""}catch(n){}}return""}function ui(n,t){return e(Q,(function(e){var r="_."+e[0];t&e[1]&&!u(n,r)&&n.push(r)})),n.sort()}function ai(n){if(n instanceof at)return n.clone();var t=new ut(n.__wrapped__,n.__chain__);return t.__actions__=ir(n.__actions__),t.__index__=n.__index__,t.__values__=n.__values__,t}function ci(n,t,e){var r=null==n?0:n.length;if(!r)return-1;var i=null==e?0:Ui(e);return i<0&&(i=nu(r+i,0)),p(n,Pr(t,3),i)}function si(n,t,e){var r=null==n?0:n.length;if(!r)return-1;var i=r-1;return e!==q&&(i=Ui(e),i=e<0?nu(r+i,0):tu(i,r-1)),p(n,Pr(t,3),i,!0)}function fi(n){return null!=n&&n.length?jt(n,1):[]}function li(n){return n&&n.length?n[0]:q}function di(n){var t=null==n?0:n.length;return t?n[t-1]:q}function hi(n,t){return n&&n.length&&t&&t.length?Ie(n,t):n}function gi(n){return null==n?n:ou.call(n)}function pi(n){if(!n||!n.length)return[];var t=0;return n=o(n,(function(n){if(Di(n))return t=nu(n.length,t),!0})),C(t,(function(t){return c(n,b(t))}))}function vi(t,e){if(!t||!t.length)return[];var r=pi(t);return null==e?r:c(r,(function(t){return n(e,q,t)}))}function _i(n){var t=$n(n);return t.__chain__=!0,t}function mi(n,t){return t(n)}function yi(n,t){return(Ia(n)?e:xu)(n,Pr(t,3))}function bi(n,t){return(Ia(n)?r:Cu)(n,Pr(t,3))}function wi(n,t){return(Ia(n)?c:me)(n,Pr(t,3))}function ki(n,t,e){return t=e?q:t,t=n&&null==t?n.length:t,Sr(n,H,q,q,q,q,t)}function xi(n,t){var e;if("function"!=typeof t)throw new yo(B);return n=Ui(n),function(){return--n>0&&(e=t.apply(this,arguments)),n<=1&&(t=q),e}}function Ci(n,t,e){function r(t){var e=s,r=f;return s=f=q,p=t,d=n.apply(r,e)}function i(n){return p=n,h=zu(u,t),v?r(n):d}function o(n){var e=n-g;return g===q||e>=t||e<0||_&&n-p>=l}function u(){var n=ha();return o(n)?a(n):(h=zu(u,function(n){var e=t-(n-g);return _?tu(e,l-(n-p)):e}(n)),q)}function a(n){return h=q,m&&s?r(n):(s=f=q,d)}function c(){var n=ha(),e=o(n);if(s=arguments,f=this,g=n,e){if(h===q)return i(g);if(_)return Lu(h),h=zu(u,t),r(g)}return h===q&&(h=zu(u,t)),d}var s,f,l,d,h,g,p=0,v=!1,_=!1,m=!0;if("function"!=typeof n)throw new yo(B);return t=Bi(t)||0,Ri(e)&&(v=!!e.leading,l=(_="maxWait"in e)?nu(Bi(e.maxWait)||0,t):l,m="trailing"in e?!!e.trailing:m),c.cancel=function(){h!==q&&Lu(h),p=0,s=g=f=h=q},c.flush=function(){return h===q?d:a(ha())},c}function Ii(n,t){if("function"!=typeof n||null!=t&&"function"!=typeof t)throw new yo(B);var e=function(){var r=arguments,i=t?t.apply(this,r):r[0],o=e.cache;if(o.has(i))return o.get(i);var u=n.apply(this,r);return e.cache=o.set(i,u)||o,u};return e.cache=new(Ii.Cache||ft),e}function Ai(n){if("function"!=typeof n)throw new yo(B);return function(){var t=arguments;switch(t.length){case 0:return!n.call(this);case 1:return!n.call(this,t[0]);case 2:return!n.call(this,t[0],t[1]);case 3:return!n.call(this,t[0],t[1],t[2])}return!n.apply(this,t)}}function Si(n,t){return n===t||n!=n&&t!=t}function Ei(n){return null!=n&&Oi(n.length)&&!Ti(n)}function Di(n){return Mi(n)&&Ei(n)}function Li(n){if(!Mi(n))return!1;var t=Bt(n);return t==en||"[object DOMException]"==t||"string"==typeof n.message&&"string"==typeof n.name&&!Pi(n)}function Ti(n){if(!Ri(n))return!1;var t=Bt(n);return t==rn||t==on||"[object AsyncFunction]"==t||"[object Proxy]"==t}function ji(n){return"number"==typeof n&&n==Ui(n)}function Oi(n){return"number"==typeof n&&n>-1&&n%1==0&&n<=Z}function Ri(n){var t=typeof n;return null!=n&&("object"==t||"function"==t)}function Mi(n){return null!=n&&"object"==typeof n}function Fi(n){return"number"==typeof n||Mi(n)&&Bt(n)==an}function Pi(n){if(!Mi(n)||Bt(n)!=cn)return!1;var t=Fo(n);if(null===t)return!0;var e=Io.call(t,"constructor")&&t.constructor;return"function"==typeof e&&e instanceof e&&Co.call(e)==Do}function zi(n){return"string"==typeof n||!Ia(n)&&Mi(n)&&Bt(n)==dn}function Wi(n){return"symbol"==typeof n||Mi(n)&&Bt(n)==hn}function Ki(n){if(!n)return[];if(Ei(n))return zi(n)?K(n):ir(n);if(No&&n[No])return function(n){for(var t,e=[];!(t=n.next()).done;)e.push(t.value);return e}(n[No]());var t=Mu(n);return(t==un?M:t==ln?z:Ji)(n)}function Ni(n){return n?(n=Bi(n))===1/0||n===-1/0?17976931348623157e292*(n<0?-1:1):n==n?n:0:0===n?n:0}function Ui(n){var t=Ni(n),e=t%1;return t==t?e?t-e:t:0}function qi(n){return n?Ct(Ui(n),0,G):0}function Bi(n){if("number"==typeof n)return n;if(Wi(n))return X;if(Ri(n)){var t="function"==typeof n.valueOf?n.valueOf():n;n=Ri(t)?t+"":t}if("string"!=typeof n)return 0===n?n:+n;n=I(n);var e=Jn.test(n);return e||nt.test(n)?$t(n.slice(2),e?2:8):Qn.test(n)?X:+n}function Vi(n){return or(n,Gi(n))}function $i(n){return null==n?"":Ke(n)}function Hi(n,t,e){var r=null==n?q:zt(n,t);return r===q?e:r}function Zi(n,t){return null!=n&&Nr(n,t,Gt)}function Xi(n){return Ei(n)?ht(n):pe(n)}function Gi(n){return Ei(n)?ht(n,!0):ve(n)}function Qi(n,t){if(null==n)return{};var e=c(Rr(n),(function(n){return[n]}));return t=Pr(t),Ce(n,e,(function(n,e){return t(n,e[0])}))}function Ji(n){return null==n?[]:S(n,Xi(n))}function Yi(n){return ic($i(n).toLowerCase())}function no(n){return(n=$i(n))&&n.replace(et,ce).replace(Mt,"")}function to(n,t,e){return n=$i(n),(t=e?q:t)===q?R(n)?U(n):h(n):n.match(t)||[]}function eo(n){return function(){return n}}function ro(n){return n}function io(n){return ge("function"==typeof n?n:It(n,1))}function oo(n,t,r){var i=Xi(t),o=Pt(t,i);null!=r||Ri(t)&&(o.length||!i.length)||(r=t,t=n,n=this,o=Pt(t,Xi(t)));var u=!(Ri(r)&&"chain"in r&&!r.chain),a=Ti(n);return e(o,(function(e){var r=t[e];n[e]=r,a&&(n.prototype[e]=function(){var t=this.__chain__;if(u||t){var e=n(this.__wrapped__);return(e.__actions__=ir(this.__actions__)).push({func:r,args:arguments,thisArg:n}),e.__chain__=t,e}return r.apply(n,s([this.value()],arguments))})})),n}function uo(){}function ao(n){return $r(n)?b(ii(n)):function(n){return function(t){return zt(t,n)}}(n)}function co(){return[]}function so(){return!1}var fo=(Un=null==Un?Xt:le.defaults(Xt.Object(),Un,le.pick(Xt,Kt))).Array,lo=Un.Date,ho=Un.Error,go=Un.Function,po=Un.Math,vo=Un.Object,_o=Un.RegExp,mo=Un.String,yo=Un.TypeError,bo=fo.prototype,wo=go.prototype,ko=vo.prototype,xo=Un["__core-js_shared__"],Co=wo.toString,Io=ko.hasOwnProperty,Ao=0,So=function(){var n=/[^.]+$/.exec(xo&&xo.keys&&xo.keys.IE_PROTO||"");return n?"Symbol(src)_1."+n:""}(),Eo=ko.toString,Do=Co.call(vo),Lo=Xt._,To=_o("^"+Co.call(Io).replace(Wn,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),jo=Jt?Un.Buffer:q,Oo=Un.Symbol,Ro=Un.Uint8Array,Mo=jo?jo.allocUnsafe:q,Fo=F(vo.getPrototypeOf,vo),Po=vo.create,zo=ko.propertyIsEnumerable,Wo=bo.splice,Ko=Oo?Oo.isConcatSpreadable:q,No=Oo?Oo.iterator:q,Uo=Oo?Oo.toStringTag:q,qo=function(){try{var n=Kr(vo,"defineProperty");return n({},"",{}),n}catch(n){}}(),Bo=Un.clearTimeout!==Xt.clearTimeout&&Un.clearTimeout,Vo=lo&&lo.now!==Xt.Date.now&&lo.now,$o=Un.setTimeout!==Xt.setTimeout&&Un.setTimeout,Ho=po.ceil,Zo=po.floor,Xo=vo.getOwnPropertySymbols,Go=jo?jo.isBuffer:q,Qo=Un.isFinite,Jo=bo.join,Yo=F(vo.keys,vo),nu=po.max,tu=po.min,eu=lo.now,ru=Un.parseInt,iu=po.random,ou=bo.reverse,uu=Kr(Un,"DataView"),au=Kr(Un,"Map"),cu=Kr(Un,"Promise"),su=Kr(Un,"Set"),fu=Kr(Un,"WeakMap"),lu=Kr(vo,"create"),du=fu&&new fu,hu={},gu=oi(uu),pu=oi(au),vu=oi(cu),_u=oi(su),mu=oi(fu),yu=Oo?Oo.prototype:q,bu=yu?yu.valueOf:q,wu=yu?yu.toString:q,ku=function(){function n(){}return function(t){if(!Ri(t))return{};if(Po)return Po(t);n.prototype=t;var e=new n;return n.prototype=q,e}}();$n.templateSettings={escape:On,evaluate:Rn,interpolate:Mn,variable:"",imports:{_:$n}},$n.prototype=ot.prototype,$n.prototype.constructor=$n,ut.prototype=ku(ot.prototype),ut.prototype.constructor=ut,at.prototype=ku(ot.prototype),at.prototype.constructor=at,ct.prototype.clear=function(){this.__data__=lu?lu(null):{},this.size=0},ct.prototype.delete=function(n){var t=this.has(n)&&delete this.__data__[n];return this.size-=t?1:0,t},ct.prototype.get=function(n){var t=this.__data__;if(lu){var e=t[n];return e===V?q:e}return Io.call(t,n)?t[n]:q},ct.prototype.has=function(n){var t=this.__data__;return lu?t[n]!==q:Io.call(t,n)},ct.prototype.set=function(n,t){var e=this.__data__;return this.size+=this.has(n)?0:1,e[n]=lu&&t===q?V:t,this},st.prototype.clear=function(){this.__data__=[],this.size=0},st.prototype.delete=function(n){var t=this.__data__,e=yt(t,n);return!(e<0||(e==t.length-1?t.pop():Wo.call(t,e,1),--this.size,0))},st.prototype.get=function(n){var t=this.__data__,e=yt(t,n);return e<0?q:t[e][1]},st.prototype.has=function(n){return yt(this.__data__,n)>-1},st.prototype.set=function(n,t){var e=this.__data__,r=yt(e,n);return r<0?(++this.size,e.push([n,t])):e[r][1]=t,this},ft.prototype.clear=function(){this.size=0,this.__data__={hash:new ct,map:new(au||st),string:new ct}},ft.prototype.delete=function(n){var t=zr(this,n).delete(n);return this.size-=t?1:0,t},ft.prototype.get=function(n){return zr(this,n).get(n)},ft.prototype.has=function(n){return zr(this,n).has(n)},ft.prototype.set=function(n,t){var e=zr(this,n),r=e.size;return e.set(n,t),this.size+=e.size==r?0:1,this},lt.prototype.add=lt.prototype.push=function(n){return this.__data__.set(n,V),this},lt.prototype.has=function(n){return this.__data__.has(n)},dt.prototype.clear=function(){this.__data__=new st,this.size=0},dt.prototype.delete=function(n){var t=this.__data__,e=t.delete(n);return this.size=t.size,e},dt.prototype.get=function(n){return this.__data__.get(n)},dt.prototype.has=function(n){return this.__data__.has(n)},dt.prototype.set=function(n,t){var e=this.__data__;if(e instanceof st){var r=e.__data__;if(!au||r.length<199)return r.push([n,t]),this.size=++e.size,this;e=this.__data__=new ft(r)}return e.set(n,t),this.size=e.size,this};var xu=cr(Ot),Cu=cr(Ft,!0),Iu=sr(),Au=sr(!0),Su=du?function(n,t){return du.set(n,t),n}:ro,Eu=qo?function(n,t){return qo(n,"toString",{configurable:!0,enumerable:!1,value:eo(t),writable:!0})}:ro,Du=De,Lu=Bo||function(n){return Xt.clearTimeout(n)},Tu=su&&1/z(new su([,-0]))[1]==1/0?function(n){return new su(n)}:uo,ju=du?function(n){return du.get(n)}:uo,Ou=Xo?function(n){return null==n?[]:(n=vo(n),o(Xo(n),(function(t){return zo.call(n,t)})))}:co,Ru=Xo?function(n){for(var t=[];n;)s(t,Ou(n)),n=Fo(n);return t}:co,Mu=Bt;(uu&&Mu(new uu(new ArrayBuffer(1)))!=vn||au&&Mu(new au)!=un||cu&&Mu(cu.resolve())!=sn||su&&Mu(new su)!=ln||fu&&Mu(new fu)!=gn)&&(Mu=function(n){var t=Bt(n),e=t==cn?n.constructor:q,r=e?oi(e):"";if(r)switch(r){case gu:return vn;case pu:return un;case vu:return sn;case _u:return ln;case mu:return gn}return t});var Fu=xo?Ti:so,Pu=ei(Su),zu=$o||function(n,t){return Xt.setTimeout(n,t)},Wu=ei(Eu),Ku=function(n){var t=Ii(n,(function(n){return 500===e.size&&e.clear(),n})),e=t.cache;return t}((function(n){var t=[];return 46===n.charCodeAt(0)&&t.push(""),n.replace(zn,(function(n,e,r,i){t.push(r?i.replace(Zn,"$1"):e||n)})),t})),Nu=De((function(n,t){return Di(n)?Et(n,jt(t,1,Di,!0)):[]})),Uu=De((function(n,t){var e=di(t);return Di(e)&&(e=q),Di(n)?Et(n,jt(t,1,Di,!0),Pr(e,2)):[]})),qu=De((function(n,t){var e=di(t);return Di(e)&&(e=q),Di(n)?Et(n,jt(t,1,Di,!0),q,e):[]})),Bu=De((function(n){var t=c(n,Ze);return t.length&&t[0]===n[0]?Qt(t):[]})),Vu=De((function(n){var t=di(n),e=c(n,Ze);return t===di(e)?t=q:e.pop(),e.length&&e[0]===n[0]?Qt(e,Pr(t,2)):[]})),$u=De((function(n){var t=di(n),e=c(n,Ze);return(t="function"==typeof t?t:q)&&e.pop(),e.length&&e[0]===n[0]?Qt(e,q,t):[]})),Hu=De(hi),Zu=jr((function(n,t){var e=null==n?0:n.length,r=xt(n,t);return Ae(n,c(t,(function(n){return Br(n,e)?+n:n})).sort(tr)),r})),Xu=De((function(n){return Ne(jt(n,1,Di,!0))})),Gu=De((function(n){var t=di(n);return Di(t)&&(t=q),Ne(jt(n,1,Di,!0),Pr(t,2))})),Qu=De((function(n){var t=di(n);return t="function"==typeof t?t:q,Ne(jt(n,1,Di,!0),q,t)})),Ju=De((function(n,t){return Di(n)?Et(n,t):[]})),Yu=De((function(n){return $e(o(n,Di))})),na=De((function(n){var t=di(n);return Di(t)&&(t=q),$e(o(n,Di),Pr(t,2))})),ta=De((function(n){var t=di(n);return t="function"==typeof t?t:q,$e(o(n,Di),q,t)})),ea=De(pi),ra=De((function(n){var t=n.length,e=t>1?n[t-1]:q;return e="function"==typeof e?(n.pop(),e):q,vi(n,e)})),ia=jr((function(n){var t=n.length,e=t?n[0]:0,r=this.__wrapped__,i=function(t){return xt(t,n)};return!(t>1||this.__actions__.length)&&r instanceof at&&Br(e)?((r=r.slice(e,+e+(t?1:0))).__actions__.push({func:mi,args:[i],thisArg:q}),new ut(r,this.__chain__).thru((function(n){return t&&!n.length&&n.push(q),n}))):this.thru(i)})),oa=ur((function(n,t,e){Io.call(n,e)?++n[e]:kt(n,e,1)})),ua=gr(ci),aa=gr(si),ca=ur((function(n,t,e){Io.call(n,e)?n[e].push(t):kt(n,e,[t])})),sa=De((function(t,e,r){var i=-1,o="function"==typeof e,u=Ei(t)?fo(t.length):[];return xu(t,(function(t){u[++i]=o?n(e,t,r):Yt(t,e,r)})),u})),fa=ur((function(n,t,e){kt(n,e,t)})),la=ur((function(n,t,e){n[e?0:1].push(t)}),(function(){return[[],[]]})),da=De((function(n,t){if(null==n)return[];var e=t.length;return e>1&&Vr(n,t[0],t[1])?t=[]:e>2&&Vr(t[0],t[1],t[2])&&(t=[t[0]]),xe(n,jt(t,1),[])})),ha=Vo||function(){return Xt.Date.now()},ga=De((function(n,t,e){var r=1;if(e.length){var i=P(e,Fr(ga));r|=32}return Sr(n,r,t,e,i)})),pa=De((function(n,t,e){var r=3;if(e.length){var i=P(e,Fr(pa));r|=32}return Sr(t,r,n,e,i)})),va=De((function(n,t){return St(n,1,t)})),_a=De((function(n,t,e){return St(n,Bi(t)||0,e)}));Ii.Cache=ft;var ma=Du((function(t,e){var r=(e=1==e.length&&Ia(e[0])?c(e[0],A(Pr())):c(jt(e,1),A(Pr()))).length;return De((function(i){for(var o=-1,u=tu(i.length,r);++o<u;)i[o]=e[o].call(this,i[o]);return n(t,this,i)}))})),ya=De((function(n,t){return Sr(n,32,q,t,P(t,Fr(ya)))})),ba=De((function(n,t){return Sr(n,64,q,t,P(t,Fr(ba)))})),wa=jr((function(n,t){return Sr(n,256,q,q,q,t)})),ka=xr(Ht),xa=xr((function(n,t){return n>=t})),Ca=ne(function(){return arguments}())?ne:function(n){return Mi(n)&&Io.call(n,"callee")&&!zo.call(n,"callee")},Ia=fo.isArray,Aa=te?A(te):function(n){return Mi(n)&&Bt(n)==pn},Sa=Go||so,Ea=ee?A(ee):function(n){return Mi(n)&&Bt(n)==tn},Da=re?A(re):function(n){return Mi(n)&&Mu(n)==un},La=ie?A(ie):function(n){return Mi(n)&&Bt(n)==fn},Ta=oe?A(oe):function(n){return Mi(n)&&Mu(n)==ln},ja=ue?A(ue):function(n){return Mi(n)&&Oi(n.length)&&!!Ut[Bt(n)]},Oa=xr(_e),Ra=xr((function(n,t){return n<=t})),Ma=ar((function(n,t){if(Zr(t)||Ei(t))return or(t,Xi(t),n),q;for(var e in t)Io.call(t,e)&&mt(n,e,t[e])})),Fa=ar((function(n,t){or(t,Gi(t),n)})),Pa=ar((function(n,t,e,r){or(t,Gi(t),n,r)})),za=ar((function(n,t,e,r){or(t,Xi(t),n,r)})),Wa=jr(xt),Ka=De((function(n,t){n=vo(n);var e=-1,r=t.length,i=r>2?t[2]:q;for(i&&Vr(t[0],t[1],i)&&(r=1);++e<r;)for(var o=t[e],u=Gi(o),a=-1,c=u.length;++a<c;){var s=u[a],f=n[s];(f===q||Si(f,ko[s])&&!Io.call(n,s))&&(n[s]=o[s])}return n})),Na=De((function(t){return t.push(q,Dr),n($a,q,t)})),Ua=_r((function(n,t,e){null!=t&&"function"!=typeof t.toString&&(t=Eo.call(t)),n[t]=e}),eo(ro)),qa=_r((function(n,t,e){null!=t&&"function"!=typeof t.toString&&(t=Eo.call(t)),Io.call(n,t)?n[t].push(e):n[t]=[e]}),Pr),Ba=De(Yt),Va=ar((function(n,t,e){we(n,t,e)})),$a=ar((function(n,t,e,r){we(n,t,e,r)})),Ha=jr((function(n,t){var e={};if(null==n)return e;var r=!1;t=c(t,(function(t){return t=Ge(t,n),r||(r=t.length>1),t})),or(n,Rr(n),e),r&&(e=It(e,7,Lr));for(var i=t.length;i--;)Ue(e,t[i]);return e})),Za=jr((function(n,t){return null==n?{}:function(n,t){return Ce(n,t,(function(t,e){return Zi(n,e)}))}(n,t)})),Xa=Ar(Xi),Ga=Ar(Gi),Qa=lr((function(n,t,e){return t=t.toLowerCase(),n+(e?Yi(t):t)})),Ja=lr((function(n,t,e){return n+(e?"-":"")+t.toLowerCase()})),Ya=lr((function(n,t,e){return n+(e?" ":"")+t.toLowerCase()})),nc=fr("toLowerCase"),tc=lr((function(n,t,e){return n+(e?"_":"")+t.toLowerCase()})),ec=lr((function(n,t,e){return n+(e?" ":"")+ic(t)})),rc=lr((function(n,t,e){return n+(e?" ":"")+t.toUpperCase()})),ic=fr("toUpperCase"),oc=De((function(t,e){try{return n(t,q,e)}catch(n){return Li(n)?n:new ho(n)}})),uc=jr((function(n,t){return e(t,(function(t){t=ii(t),kt(n,t,ga(n[t],n))})),n})),ac=pr(),cc=pr(!0),sc=De((function(n,t){return function(e){return Yt(e,n,t)}})),fc=De((function(n,t){return function(e){return Yt(n,e,t)}})),lc=yr(c),dc=yr(i),hc=yr(d),gc=kr(),pc=kr(!0),vc=mr((function(n,t){return n+t}),0),_c=Ir("ceil"),mc=mr((function(n,t){return n/t}),1),yc=Ir("floor"),bc=mr((function(n,t){return n*t}),1),wc=Ir("round"),kc=mr((function(n,t){return n-t}),0);return $n.after=function(n,t){if("function"!=typeof t)throw new yo(B);return n=Ui(n),function(){if(--n<1)return t.apply(this,arguments)}},$n.ary=ki,$n.assign=Ma,$n.assignIn=Fa,$n.assignInWith=Pa,$n.assignWith=za,$n.at=Wa,$n.before=xi,$n.bind=ga,$n.bindAll=uc,$n.bindKey=pa,$n.castArray=function(){if(!arguments.length)return[];var n=arguments[0];return Ia(n)?n:[n]},$n.chain=_i,$n.chunk=function(n,t,e){t=(e?Vr(n,t,e):t===q)?1:nu(Ui(t),0);var r=null==n?0:n.length;if(!r||t<1)return[];for(var i=0,o=0,u=fo(Ho(r/t));i<r;)u[o++]=Re(n,i,i+=t);return u},$n.compact=function(n){for(var t=-1,e=null==n?0:n.length,r=0,i=[];++t<e;){var o=n[t];o&&(i[r++]=o)}return i},$n.concat=function(){var n=arguments.length;if(!n)return[];for(var t=fo(n-1),e=arguments[0],r=n;r--;)t[r-1]=arguments[r];return s(Ia(e)?ir(e):[e],jt(t,1))},$n.cond=function(t){var e=null==t?0:t.length,r=Pr();return t=e?c(t,(function(n){if("function"!=typeof n[1])throw new yo(B);return[r(n[0]),n[1]]})):[],De((function(r){for(var i=-1;++i<e;){var o=t[i];if(n(o[0],this,r))return n(o[1],this,r)}}))},$n.conforms=function(n){return function(n){var t=Xi(n);return function(e){return At(e,n,t)}}(It(n,1))},$n.constant=eo,$n.countBy=oa,$n.create=function(n,t){var e=ku(n);return null==t?e:wt(e,t)},$n.curry=function n(t,e,r){var i=Sr(t,8,q,q,q,q,q,e=r?q:e);return i.placeholder=n.placeholder,i},$n.curryRight=function n(t,e,r){var i=Sr(t,16,q,q,q,q,q,e=r?q:e);return i.placeholder=n.placeholder,i},$n.debounce=Ci,$n.defaults=Ka,$n.defaultsDeep=Na,$n.defer=va,$n.delay=_a,$n.difference=Nu,$n.differenceBy=Uu,$n.differenceWith=qu,$n.drop=function(n,t,e){var r=null==n?0:n.length;return r?Re(n,(t=e||t===q?1:Ui(t))<0?0:t,r):[]},$n.dropRight=function(n,t,e){var r=null==n?0:n.length;return r?Re(n,0,(t=r-(t=e||t===q?1:Ui(t)))<0?0:t):[]},$n.dropRightWhile=function(n,t){return n&&n.length?Be(n,Pr(t,3),!0,!0):[]},$n.dropWhile=function(n,t){return n&&n.length?Be(n,Pr(t,3),!0):[]},$n.fill=function(n,t,e,r){var i=null==n?0:n.length;return i?(e&&"number"!=typeof e&&Vr(n,t,e)&&(e=0,r=i),function(n,t,e,r){var i=n.length;for((e=Ui(e))<0&&(e=-e>i?0:i+e),(r=r===q||r>i?i:Ui(r))<0&&(r+=i),r=e>r?0:qi(r);e<r;)n[e++]=t;return n}(n,t,e,r)):[]},$n.filter=function(n,t){return(Ia(n)?o:Tt)(n,Pr(t,3))},$n.flatMap=function(n,t){return jt(wi(n,t),1)},$n.flatMapDeep=function(n,t){return jt(wi(n,t),1/0)},$n.flatMapDepth=function(n,t,e){return e=e===q?1:Ui(e),jt(wi(n,t),e)},$n.flatten=fi,$n.flattenDeep=function(n){return null!=n&&n.length?jt(n,1/0):[]},$n.flattenDepth=function(n,t){return null!=n&&n.length?jt(n,t=t===q?1:Ui(t)):[]},$n.flip=function(n){return Sr(n,512)},$n.flow=ac,$n.flowRight=cc,$n.fromPairs=function(n){for(var t=-1,e=null==n?0:n.length,r={};++t<e;){var i=n[t];r[i[0]]=i[1]}return r},$n.functions=function(n){return null==n?[]:Pt(n,Xi(n))},$n.functionsIn=function(n){return null==n?[]:Pt(n,Gi(n))},$n.groupBy=ca,$n.initial=function(n){return null!=n&&n.length?Re(n,0,-1):[]},$n.intersection=Bu,$n.intersectionBy=Vu,$n.intersectionWith=$u,$n.invert=Ua,$n.invertBy=qa,$n.invokeMap=sa,$n.iteratee=io,$n.keyBy=fa,$n.keys=Xi,$n.keysIn=Gi,$n.map=wi,$n.mapKeys=function(n,t){var e={};return t=Pr(t,3),Ot(n,(function(n,r,i){kt(e,t(n,r,i),n)})),e},$n.mapValues=function(n,t){var e={};return t=Pr(t,3),Ot(n,(function(n,r,i){kt(e,r,t(n,r,i))})),e},$n.matches=function(n){return ye(It(n,1))},$n.matchesProperty=function(n,t){return be(n,It(t,1))},$n.memoize=Ii,$n.merge=Va,$n.mergeWith=$a,$n.method=sc,$n.methodOf=fc,$n.mixin=oo,$n.negate=Ai,$n.nthArg=function(n){return n=Ui(n),De((function(t){return ke(t,n)}))},$n.omit=Ha,$n.omitBy=function(n,t){return Qi(n,Ai(Pr(t)))},$n.once=function(n){return xi(2,n)},$n.orderBy=function(n,t,e,r){return null==n?[]:(Ia(t)||(t=null==t?[]:[t]),Ia(e=r?q:e)||(e=null==e?[]:[e]),xe(n,t,e))},$n.over=lc,$n.overArgs=ma,$n.overEvery=dc,$n.overSome=hc,$n.partial=ya,$n.partialRight=ba,$n.partition=la,$n.pick=Za,$n.pickBy=Qi,$n.property=ao,$n.propertyOf=function(n){return function(t){return null==n?q:zt(n,t)}},$n.pull=Hu,$n.pullAll=hi,$n.pullAllBy=function(n,t,e){return n&&n.length&&t&&t.length?Ie(n,t,Pr(e,2)):n},$n.pullAllWith=function(n,t,e){return n&&n.length&&t&&t.length?Ie(n,t,q,e):n},$n.pullAt=Zu,$n.range=gc,$n.rangeRight=pc,$n.rearg=wa,$n.reject=function(n,t){return(Ia(n)?o:Tt)(n,Ai(Pr(t,3)))},$n.remove=function(n,t){var e=[];if(!n||!n.length)return e;var r=-1,i=[],o=n.length;for(t=Pr(t,3);++r<o;){var u=n[r];t(u,r,n)&&(e.push(u),i.push(r))}return Ae(n,i),e},$n.rest=function(n,t){if("function"!=typeof n)throw new yo(B);return De(n,t=t===q?t:Ui(t))},$n.reverse=gi,$n.sampleSize=function(n,t,e){return t=(e?Vr(n,t,e):t===q)?1:Ui(t),(Ia(n)?pt:Te)(n,t)},$n.set=function(n,t,e){return null==n?n:je(n,t,e)},$n.setWith=function(n,t,e,r){return r="function"==typeof r?r:q,null==n?n:je(n,t,e,r)},$n.shuffle=function(n){return(Ia(n)?vt:Oe)(n)},$n.slice=function(n,t,e){var r=null==n?0:n.length;return r?(e&&"number"!=typeof e&&Vr(n,t,e)?(t=0,e=r):(t=null==t?0:Ui(t),e=e===q?r:Ui(e)),Re(n,t,e)):[]},$n.sortBy=da,$n.sortedUniq=function(n){return n&&n.length?ze(n):[]},$n.sortedUniqBy=function(n,t){return n&&n.length?ze(n,Pr(t,2)):[]},$n.split=function(n,t,e){return e&&"number"!=typeof e&&Vr(n,t,e)&&(t=e=q),(e=e===q?G:e>>>0)?(n=$i(n))&&("string"==typeof t||null!=t&&!La(t))&&(!(t=Ke(t))&&O(n))?Qe(K(n),0,e):n.split(t,e):[]},$n.spread=function(t,e){if("function"!=typeof t)throw new yo(B);return e=null==e?0:nu(Ui(e),0),De((function(r){var i=r[e],o=Qe(r,0,e);return i&&s(o,i),n(t,this,o)}))},$n.tail=function(n){var t=null==n?0:n.length;return t?Re(n,1,t):[]},$n.take=function(n,t,e){return n&&n.length?Re(n,0,(t=e||t===q?1:Ui(t))<0?0:t):[]},$n.takeRight=function(n,t,e){var r=null==n?0:n.length;return r?Re(n,(t=r-(t=e||t===q?1:Ui(t)))<0?0:t,r):[]},$n.takeRightWhile=function(n,t){return n&&n.length?Be(n,Pr(t,3),!1,!0):[]},$n.takeWhile=function(n,t){return n&&n.length?Be(n,Pr(t,3)):[]},$n.tap=function(n,t){return t(n),n},$n.throttle=function(n,t,e){var r=!0,i=!0;if("function"!=typeof n)throw new yo(B);return Ri(e)&&(r="leading"in e?!!e.leading:r,i="trailing"in e?!!e.trailing:i),Ci(n,t,{leading:r,maxWait:t,trailing:i})},$n.thru=mi,$n.toArray=Ki,$n.toPairs=Xa,$n.toPairsIn=Ga,$n.toPath=function(n){return Ia(n)?c(n,ii):Wi(n)?[n]:ir(Ku($i(n)))},$n.toPlainObject=Vi,$n.transform=function(n,t,r){var i=Ia(n),o=i||Sa(n)||ja(n);if(t=Pr(t,4),null==r){var u=n&&n.constructor;r=o?i?new u:[]:Ri(n)&&Ti(u)?ku(Fo(n)):{}}return(o?e:Ot)(n,(function(n,e,i){return t(r,n,e,i)})),r},$n.unary=function(n){return ki(n,1)},$n.union=Xu,$n.unionBy=Gu,$n.unionWith=Qu,$n.uniq=function(n){return n&&n.length?Ne(n):[]},$n.uniqBy=function(n,t){return n&&n.length?Ne(n,Pr(t,2)):[]},$n.uniqWith=function(n,t){return t="function"==typeof t?t:q,n&&n.length?Ne(n,q,t):[]},$n.unset=function(n,t){return null==n||Ue(n,t)},$n.unzip=pi,$n.unzipWith=vi,$n.update=function(n,t,e){return null==n?n:qe(n,t,Xe(e))},$n.updateWith=function(n,t,e,r){return r="function"==typeof r?r:q,null==n?n:qe(n,t,Xe(e),r)},$n.values=Ji,$n.valuesIn=function(n){return null==n?[]:S(n,Gi(n))},$n.without=Ju,$n.words=to,$n.wrap=function(n,t){return ya(Xe(t),n)},$n.xor=Yu,$n.xorBy=na,$n.xorWith=ta,$n.zip=ea,$n.zipObject=function(n,t){return He(n||[],t||[],mt)},$n.zipObjectDeep=function(n,t){return He(n||[],t||[],je)},$n.zipWith=ra,$n.entries=Xa,$n.entriesIn=Ga,$n.extend=Fa,$n.extendWith=Pa,oo($n,$n),$n.add=vc,$n.attempt=oc,$n.camelCase=Qa,$n.capitalize=Yi,$n.ceil=_c,$n.clamp=function(n,t,e){return e===q&&(e=t,t=q),e!==q&&(e=(e=Bi(e))==e?e:0),t!==q&&(t=(t=Bi(t))==t?t:0),Ct(Bi(n),t,e)},$n.clone=function(n){return It(n,4)},$n.cloneDeep=function(n){return It(n,5)},$n.cloneDeepWith=function(n,t){return It(n,5,t="function"==typeof t?t:q)},$n.cloneWith=function(n,t){return It(n,4,t="function"==typeof t?t:q)},$n.conformsTo=function(n,t){return null==t||At(n,t,Xi(t))},$n.deburr=no,$n.defaultTo=function(n,t){return null==n||n!=n?t:n},$n.divide=mc,$n.endsWith=function(n,t,e){n=$i(n),t=Ke(t);var r=n.length,i=e=e===q?r:Ct(Ui(e),0,r);return(e-=t.length)>=0&&n.slice(e,i)==t},$n.eq=Si,$n.escape=function(n){return(n=$i(n))&&jn.test(n)?n.replace(Ln,se):n},$n.escapeRegExp=function(n){return(n=$i(n))&&Kn.test(n)?n.replace(Wn,"\\$&"):n},$n.every=function(n,t,e){var r=Ia(n)?i:Dt;return e&&Vr(n,t,e)&&(t=q),r(n,Pr(t,3))},$n.find=ua,$n.findIndex=ci,$n.findKey=function(n,t){return g(n,Pr(t,3),Ot)},$n.findLast=aa,$n.findLastIndex=si,$n.findLastKey=function(n,t){return g(n,Pr(t,3),Ft)},$n.floor=yc,$n.forEach=yi,$n.forEachRight=bi,$n.forIn=function(n,t){return null==n?n:Iu(n,Pr(t,3),Gi)},$n.forInRight=function(n,t){return null==n?n:Au(n,Pr(t,3),Gi)},$n.forOwn=function(n,t){return n&&Ot(n,Pr(t,3))},$n.forOwnRight=function(n,t){return n&&Ft(n,Pr(t,3))},$n.get=Hi,$n.gt=ka,$n.gte=xa,$n.has=function(n,t){return null!=n&&Nr(n,t,Zt)},$n.hasIn=Zi,$n.head=li,$n.identity=ro,$n.includes=function(n,t,e,r){n=Ei(n)?n:Ji(n),e=e&&!r?Ui(e):0;var i=n.length;return e<0&&(e=nu(i+e,0)),zi(n)?e<=i&&n.indexOf(t,e)>-1:!!i&&v(n,t,e)>-1},$n.indexOf=function(n,t,e){var r=null==n?0:n.length;if(!r)return-1;var i=null==e?0:Ui(e);return i<0&&(i=nu(r+i,0)),v(n,t,i)},$n.inRange=function(n,t,e){return t=Ni(t),e===q?(e=t,t=0):e=Ni(e),function(n,t,e){return n>=tu(t,e)&&n<nu(t,e)}(n=Bi(n),t,e)},$n.invoke=Ba,$n.isArguments=Ca,$n.isArray=Ia,$n.isArrayBuffer=Aa,$n.isArrayLike=Ei,$n.isArrayLikeObject=Di,$n.isBoolean=function(n){return!0===n||!1===n||Mi(n)&&Bt(n)==nn},$n.isBuffer=Sa,$n.isDate=Ea,$n.isElement=function(n){return Mi(n)&&1===n.nodeType&&!Pi(n)},$n.isEmpty=function(n){if(null==n)return!0;if(Ei(n)&&(Ia(n)||"string"==typeof n||"function"==typeof n.splice||Sa(n)||ja(n)||Ca(n)))return!n.length;var t=Mu(n);if(t==un||t==ln)return!n.size;if(Zr(n))return!pe(n).length;for(var e in n)if(Io.call(n,e))return!1;return!0},$n.isEqual=function(n,t){return ae(n,t)},$n.isEqualWith=function(n,t,e){var r=(e="function"==typeof e?e:q)?e(n,t):q;return r===q?ae(n,t,q,e):!!r},$n.isError=Li,$n.isFinite=function(n){return"number"==typeof n&&Qo(n)},$n.isFunction=Ti,$n.isInteger=ji,$n.isLength=Oi,$n.isMap=Da,$n.isMatch=function(n,t){return n===t||de(n,t,Wr(t))},$n.isMatchWith=function(n,t,e){return e="function"==typeof e?e:q,de(n,t,Wr(t),e)},$n.isNaN=function(n){return Fi(n)&&n!=+n},$n.isNative=function(n){if(Fu(n))throw new ho("Unsupported core-js use. Try https://npms.io/search?q=ponyfill.");return he(n)},$n.isNil=function(n){return null==n},$n.isNull=function(n){return null===n},$n.isNumber=Fi,$n.isObject=Ri,$n.isObjectLike=Mi,$n.isPlainObject=Pi,$n.isRegExp=La,$n.isSafeInteger=function(n){return ji(n)&&n>=-Z&&n<=Z},$n.isSet=Ta,$n.isString=zi,$n.isSymbol=Wi,$n.isTypedArray=ja,$n.isUndefined=function(n){return n===q},$n.isWeakMap=function(n){return Mi(n)&&Mu(n)==gn},$n.isWeakSet=function(n){return Mi(n)&&"[object WeakSet]"==Bt(n)},$n.join=function(n,t){return null==n?"":Jo.call(n,t)},$n.kebabCase=Ja,$n.last=di,$n.lastIndexOf=function(n,t,e){var r=null==n?0:n.length;if(!r)return-1;var i=r;return e!==q&&(i=(i=Ui(e))<0?nu(r+i,0):tu(i,r-1)),t==t?function(n,t,e){for(var r=e+1;r--;)if(n[r]===t)return r;return r}(n,t,i):p(n,m,i,!0)},$n.lowerCase=Ya,$n.lowerFirst=nc,$n.lt=Oa,$n.lte=Ra,$n.max=function(n){return n&&n.length?Lt(n,ro,Ht):q},$n.maxBy=function(n,t){return n&&n.length?Lt(n,Pr(t,2),Ht):q},$n.mean=function(n){return y(n,ro)},$n.meanBy=function(n,t){return y(n,Pr(t,2))},$n.min=function(n){return n&&n.length?Lt(n,ro,_e):q},$n.minBy=function(n,t){return n&&n.length?Lt(n,Pr(t,2),_e):q},$n.stubArray=co,$n.stubFalse=so,$n.stubObject=function(){return{}},$n.stubString=function(){return""},$n.stubTrue=function(){return!0},$n.multiply=bc,$n.nth=function(n,t){return n&&n.length?ke(n,Ui(t)):q},$n.noConflict=function(){return Xt._===this&&(Xt._=Lo),this},$n.noop=uo,$n.now=ha,$n.pad=function(n,t,e){n=$i(n);var r=(t=Ui(t))?W(n):0;if(!t||r>=t)return n;var i=(t-r)/2;return br(Zo(i),e)+n+br(Ho(i),e)},$n.padEnd=function(n,t,e){n=$i(n);var r=(t=Ui(t))?W(n):0;return t&&r<t?n+br(t-r,e):n},$n.padStart=function(n,t,e){n=$i(n);var r=(t=Ui(t))?W(n):0;return t&&r<t?br(t-r,e)+n:n},$n.parseInt=function(n,t,e){return e||null==t?t=0:t&&(t=+t),ru($i(n).replace(Nn,""),t||0)},$n.random=function(n,t,e){if(e&&"boolean"!=typeof e&&Vr(n,t,e)&&(t=e=q),e===q&&("boolean"==typeof t?(e=t,t=q):"boolean"==typeof n&&(e=n,n=q)),n===q&&t===q?(n=0,t=1):(n=Ni(n),t===q?(t=n,n=0):t=Ni(t)),n>t){var r=n;n=t,t=r}if(e||n%1||t%1){var i=iu();return tu(n+i*(t-n+Vt("1e-"+((i+"").length-1))),t)}return Se(n,t)},$n.reduce=function(n,t,e){var r=Ia(n)?f:k,i=arguments.length<3;return r(n,Pr(t,4),e,i,xu)},$n.reduceRight=function(n,t,e){var r=Ia(n)?l:k,i=arguments.length<3;return r(n,Pr(t,4),e,i,Cu)},$n.repeat=function(n,t,e){return t=(e?Vr(n,t,e):t===q)?1:Ui(t),Ee($i(n),t)},$n.replace=function(){var n=arguments,t=$i(n[0]);return n.length<3?t:t.replace(n[1],n[2])},$n.result=function(n,t,e){var r=-1,i=(t=Ge(t,n)).length;for(i||(i=1,n=q);++r<i;){var o=null==n?q:n[ii(t[r])];o===q&&(r=i,o=e),n=Ti(o)?o.call(n):o}return n},$n.round=wc,$n.runInContext=w,$n.sample=function(n){return(Ia(n)?gt:Le)(n)},$n.size=function(n){if(null==n)return 0;if(Ei(n))return zi(n)?W(n):n.length;var t=Mu(n);return t==un||t==ln?n.size:pe(n).length},$n.snakeCase=tc,$n.some=function(n,t,e){var r=Ia(n)?d:Me;return e&&Vr(n,t,e)&&(t=q),r(n,Pr(t,3))},$n.sortedIndex=function(n,t){return Fe(n,t)},$n.sortedIndexBy=function(n,t,e){return Pe(n,t,Pr(e,2))},$n.sortedIndexOf=function(n,t){var e=null==n?0:n.length;if(e){var r=Fe(n,t);if(r<e&&Si(n[r],t))return r}return-1},$n.sortedLastIndex=function(n,t){return Fe(n,t,!0)},$n.sortedLastIndexBy=function(n,t,e){return Pe(n,t,Pr(e,2),!0)},$n.sortedLastIndexOf=function(n,t){if(null!=n&&n.length){var e=Fe(n,t,!0)-1;if(Si(n[e],t))return e}return-1},$n.startCase=ec,$n.startsWith=function(n,t,e){return n=$i(n),e=null==e?0:Ct(Ui(e),0,n.length),t=Ke(t),n.slice(e,e+t.length)==t},$n.subtract=kc,$n.sum=function(n){return n&&n.length?x(n,ro):0},$n.sumBy=function(n,t){return n&&n.length?x(n,Pr(t,2)):0},$n.template=function(n,t,e){var r=$n.templateSettings;e&&Vr(n,t,e)&&(t=q),n=$i(n),t=Pa({},t,r,Er);var i,o,u=Pa({},t.imports,r.imports,Er),a=Xi(u),c=S(u,a),s=0,f=t.interpolate||rt,l="__p += '",d=_o((t.escape||rt).source+"|"+f.source+"|"+(f===Mn?Xn:rt).source+"|"+(t.evaluate||rt).source+"|$","g"),h="//# sourceURL="+(Io.call(t,"sourceURL")?(t.sourceURL+"").replace(/\s/g," "):"lodash.templateSources["+ ++Nt+"]")+"\n";n.replace(d,(function(t,e,r,u,a,c){return r||(r=u),l+=n.slice(s,c).replace(it,j),e&&(i=!0,l+="' +\n__e("+e+") +\n'"),a&&(o=!0,l+="';\n"+a+";\n__p += '"),r&&(l+="' +\n((__t = ("+r+")) == null ? '' : __t) +\n'"),s=c+t.length,t})),l+="';\n";var g=Io.call(t,"variable")&&t.variable;if(g){if(Hn.test(g))throw new ho("Invalid `variable` option passed into `_.template`")}else l="with (obj) {\n"+l+"\n}\n";l=(o?l.replace(An,""):l).replace(Sn,"$1").replace(En,"$1;"),l="function("+(g||"obj")+") {\n"+(g?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(i?", __e = _.escape":"")+(o?", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n":";\n")+l+"return __p\n}";var p=oc((function(){return go(a,h+"return "+l).apply(q,c)}));if(p.source=l,Li(p))throw p;return p},$n.times=function(n,t){if((n=Ui(n))<1||n>Z)return[];var e=G,r=tu(n,G);t=Pr(t),n-=G;for(var i=C(r,t);++e<n;)t(e);return i},$n.toFinite=Ni,$n.toInteger=Ui,$n.toLength=qi,$n.toLower=function(n){return $i(n).toLowerCase()},$n.toNumber=Bi,$n.toSafeInteger=function(n){return n?Ct(Ui(n),-Z,Z):0===n?n:0},$n.toString=$i,$n.toUpper=function(n){return $i(n).toUpperCase()},$n.trim=function(n,t,e){if((n=$i(n))&&(e||t===q))return I(n);if(!n||!(t=Ke(t)))return n;var r=K(n),i=K(t);return Qe(r,D(r,i),L(r,i)+1).join("")},$n.trimEnd=function(n,t,e){if((n=$i(n))&&(e||t===q))return n.slice(0,N(n)+1);if(!n||!(t=Ke(t)))return n;var r=K(n);return Qe(r,0,L(r,K(t))+1).join("")},$n.trimStart=function(n,t,e){if((n=$i(n))&&(e||t===q))return n.replace(Nn,"");if(!n||!(t=Ke(t)))return n;var r=K(n);return Qe(r,D(r,K(t))).join("")},$n.truncate=function(n,t){var e=30,r="...";if(Ri(t)){var i="separator"in t?t.separator:i;e="length"in t?Ui(t.length):e,r="omission"in t?Ke(t.omission):r}var o=(n=$i(n)).length;if(O(n)){var u=K(n);o=u.length}if(e>=o)return n;var a=e-W(r);if(a<1)return r;var c=u?Qe(u,0,a).join(""):n.slice(0,a);if(i===q)return c+r;if(u&&(a+=c.length-a),La(i)){if(n.slice(a).search(i)){var s,f=c;for(i.global||(i=_o(i.source,$i(Gn.exec(i))+"g")),i.lastIndex=0;s=i.exec(f);)var l=s.index;c=c.slice(0,l===q?a:l)}}else if(n.indexOf(Ke(i),a)!=a){var d=c.lastIndexOf(i);d>-1&&(c=c.slice(0,d))}return c+r},$n.unescape=function(n){return(n=$i(n))&&Tn.test(n)?n.replace(Dn,fe):n},$n.uniqueId=function(n){var t=++Ao;return $i(n)+t},$n.upperCase=rc,$n.upperFirst=ic,$n.each=yi,$n.eachRight=bi,$n.first=li,oo($n,function(){var n={};return Ot($n,(function(t,e){Io.call($n.prototype,e)||(n[e]=t)})),n}(),{chain:!1}),$n.VERSION="4.17.21",e(["bind","bindKey","curry","curryRight","partial","partialRight"],(function(n){$n[n].placeholder=$n})),e(["drop","take"],(function(n,t){at.prototype[n]=function(e){e=e===q?1:nu(Ui(e),0);var r=this.__filtered__&&!t?new at(this):this.clone();return r.__filtered__?r.__takeCount__=tu(e,r.__takeCount__):r.__views__.push({size:tu(e,G),type:n+(r.__dir__<0?"Right":"")}),r},at.prototype[n+"Right"]=function(t){return this.reverse()[n](t).reverse()}})),e(["filter","map","takeWhile"],(function(n,t){var e=t+1,r=1==e||3==e;at.prototype[n]=function(n){var t=this.clone();return t.__iteratees__.push({iteratee:Pr(n,3),type:e}),t.__filtered__=t.__filtered__||r,t}})),e(["head","last"],(function(n,t){var e="take"+(t?"Right":"");at.prototype[n]=function(){return this[e](1).value()[0]}})),e(["initial","tail"],(function(n,t){var e="drop"+(t?"":"Right");at.prototype[n]=function(){return this.__filtered__?new at(this):this[e](1)}})),at.prototype.compact=function(){return this.filter(ro)},at.prototype.find=function(n){return this.filter(n).head()},at.prototype.findLast=function(n){return this.reverse().find(n)},at.prototype.invokeMap=De((function(n,t){return"function"==typeof n?new at(this):this.map((function(e){return Yt(e,n,t)}))})),at.prototype.reject=function(n){return this.filter(Ai(Pr(n)))},at.prototype.slice=function(n,t){n=Ui(n);var e=this;return e.__filtered__&&(n>0||t<0)?new at(e):(n<0?e=e.takeRight(-n):n&&(e=e.drop(n)),t!==q&&(e=(t=Ui(t))<0?e.dropRight(-t):e.take(t-n)),e)},at.prototype.takeRightWhile=function(n){return this.reverse().takeWhile(n).reverse()},at.prototype.toArray=function(){return this.take(G)},Ot(at.prototype,(function(n,t){var e=/^(?:filter|find|map|reject)|While$/.test(t),r=/^(?:head|last)$/.test(t),i=$n[r?"take"+("last"==t?"Right":""):t],o=r||/^find/.test(t);i&&($n.prototype[t]=function(){var t=this.__wrapped__,u=r?[1]:arguments,a=t instanceof at,c=u[0],f=a||Ia(t),l=function(n){var t=i.apply($n,s([n],u));return r&&d?t[0]:t};f&&e&&"function"==typeof c&&1!=c.length&&(a=f=!1);var d=this.__chain__,h=!!this.__actions__.length,g=o&&!d,p=a&&!h;if(!o&&f){t=p?t:new at(this);var v=n.apply(t,u);return v.__actions__.push({func:mi,args:[l],thisArg:q}),new ut(v,d)}return g&&p?n.apply(this,u):(v=this.thru(l),g?r?v.value()[0]:v.value():v)})})),e(["pop","push","shift","sort","splice","unshift"],(function(n){var t=bo[n],e=/^(?:push|sort|unshift)$/.test(n)?"tap":"thru",r=/^(?:pop|shift)$/.test(n);$n.prototype[n]=function(){var n=arguments;if(r&&!this.__chain__){var i=this.value();return t.apply(Ia(i)?i:[],n)}return this[e]((function(e){return t.apply(Ia(e)?e:[],n)}))}})),Ot(at.prototype,(function(n,t){var e=$n[t];if(e){var r=e.name+"";Io.call(hu,r)||(hu[r]=[]),hu[r].push({name:t,func:e})}})),hu[vr(q,2).name]=[{name:"wrapper",func:q}],at.prototype.clone=function(){var n=new at(this.__wrapped__);return n.__actions__=ir(this.__actions__),n.__dir__=this.__dir__,n.__filtered__=this.__filtered__,n.__iteratees__=ir(this.__iteratees__),n.__takeCount__=this.__takeCount__,n.__views__=ir(this.__views__),n},at.prototype.reverse=function(){if(this.__filtered__){var n=new at(this);n.__dir__=-1,n.__filtered__=!0}else(n=this.clone()).__dir__*=-1;return n},at.prototype.value=function(){var n=this.__wrapped__.value(),t=this.__dir__,e=Ia(n),r=t<0,i=e?n.length:0,o=function(n,t,e){for(var r=-1,i=e.length;++r<i;){var o=e[r],u=o.size;switch(o.type){case"drop":n+=u;break;case"dropRight":t-=u;break;case"take":t=tu(t,n+u);break;case"takeRight":n=nu(n,t-u)}}return{start:n,end:t}}(0,i,this.__views__),u=o.start,a=o.end,c=a-u,s=r?a:u-1,f=this.__iteratees__,l=f.length,d=0,h=tu(c,this.__takeCount__);if(!e||!r&&i==c&&h==c)return Ve(n,this.__actions__);var g=[];n:for(;c--&&d<h;){for(var p=-1,v=n[s+=t];++p<l;){var _=f[p],m=_.iteratee,y=_.type,b=m(v);if(2==y)v=b;else if(!b){if(1==y)continue n;break n}}g[d++]=v}return g},$n.prototype.at=ia,$n.prototype.chain=function(){return _i(this)},$n.prototype.commit=function(){return new ut(this.value(),this.__chain__)},$n.prototype.next=function(){this.__values__===q&&(this.__values__=Ki(this.value()));var n=this.__index__>=this.__values__.length;return{done:n,value:n?q:this.__values__[this.__index__++]}},$n.prototype.plant=function(n){for(var t,e=this;e instanceof ot;){var r=ai(e);r.__index__=0,r.__values__=q,t?i.__wrapped__=r:t=r;var i=r;e=e.__wrapped__}return i.__wrapped__=n,t},$n.prototype.reverse=function(){var n=this.__wrapped__;if(n instanceof at){var t=n;return this.__actions__.length&&(t=new at(this)),(t=t.reverse()).__actions__.push({func:mi,args:[gi],thisArg:q}),new ut(t,this.__chain__)}return this.thru(gi)},$n.prototype.toJSON=$n.prototype.valueOf=$n.prototype.value=function(){return Ve(this.__wrapped__,this.__actions__)},$n.prototype.first=$n.prototype.head,No&&($n.prototype[No]=function(){return this}),$n}();"function"==typeof define&&"object"==typeof define.amd&&define.amd?(Xt._=le,define("lodash/lodash.min",[],(function(){return le}))):Qt?((Qt.exports=le)._=le,Gt._=le):Xt._=le}.call(this),define("lodash",["lodash/lodash.min"],(function(n){return n})),define("vs/language/kusto/languageFeatures",["require","exports","vscode-languageserver-types","lodash"],(function(n,t,e,r){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.HoverAdapter=t.FoldingAdapter=t.FormatAdapter=t.DocumentFormatAdapter=t.RenameAdapter=t.ReferenceAdapter=t.DefinitionAdapter=t.CompletionAdapter=t.ColorizationAdapter=t.DiagnosticsAdapter=void 0;var i=monaco.Uri,o=monaco.Range,u=Kusto.Language.Editor.ClassificationKind,a=function(){function n(n,t,e,i,o){var u=this;this._monacoInstance=n,this._languageId=t,this._worker=e,this.defaults=i,this._disposables=[],this._contentListener=Object.create(null),this._configurationListener=Object.create(null),this._schemaListener=Object.create(null);var a=function(n){var t=n.getLanguageId();if(t===u._languageId){var e=r.debounce((function(e){return u._doValidate(n,t,e)}),500);u._contentListener[n.uri.toString()]=n.onDidChangeContent((function(n){var t=c(n);e(t)})),u._configurationListener[n.uri.toString()]=u.defaults.onDidChange((function(){self.setTimeout((function(){return u._doValidate(n,t,[])}),0)})),u._schemaListener[n.uri.toString()]=o((function(){self.setTimeout((function(){return u._doValidate(n,t,[])}),0)}))}},s=function(n){u._monacoInstance.editor.setModelMarkers(n,u._languageId,[]);var t=n.uri.toString(),e=u._contentListener[t];e&&(e.dispose(),delete u._contentListener[t]);var r=u._configurationListener[t];r&&(r.dispose(),delete u._configurationListener[t]);var i=u._schemaListener[t];i&&(i.dispose(),delete u._schemaListener[t])};this._disposables.push(this._monacoInstance.editor.onDidCreateModel(a)),this._disposables.push(this._monacoInstance.editor.onWillDisposeModel(s)),this._disposables.push(this._monacoInstance.editor.onDidChangeModelLanguage((function(n){s(n.model),a(n.model)}))),this._disposables.push({dispose:function(){for(var n in u._contentListener)u._contentListener[n].dispose()}}),this._monacoInstance.editor.getModels().forEach(a)}return n.prototype.dispose=function(){this._disposables.forEach((function(n){return n&&n.dispose()})),this._disposables=[]},n.prototype._doValidate=function(n,t,e){var r=this;if(!n.isDisposed()){var i=n.uri,o=n.getVersionId();this._worker(i).then((function(n){return n.doValidation(i.toString(),e)})).then((function(n){if(r._monacoInstance.editor.getModel(i).getVersionId()===o){var e=n.map((function(n){return e="number"==typeof(t=n).code?String(t.code):t.code,{severity:s(t.severity),startLineNumber:t.range.start.line+1,startColumn:t.range.start.character+1,endLineNumber:t.range.end.line+1,endColumn:t.range.end.character+1,message:t.message,code:e,source:t.source};var t,e})),u=r._monacoInstance.editor.getModel(i),a=u.getAllDecorations().filter((function(n){return"squiggly-error"==n.options.className})).map((function(n){return n.id}));if(u&&u.getLanguageId()===t){var c=r.defaults.languageSettings.syntaxErrorAsMarkDown;if(c&&c.enableSyntaxErrorAsMarkDown){var f=c.header?"**"+c.header+"** \n\n":"",l=(c.icon?"![]("+c.icon+")":"")+" "+f,d=e.map((function(n){return{range:{startLineNumber:n.startLineNumber,startColumn:n.startColumn,endLineNumber:n.endLineNumber,endColumn:n.endColumn},options:{hoverMessage:{value:l+n.message},className:"squiggly-error",zIndex:100,overviewRuler:{color:"rgb(255, 18, 18, 0.7)",position:monaco.editor.OverviewRulerLane.Right},minimap:{color:"rgb(255, 18, 18, 0.7)",position:monaco.editor.MinimapPosition.Inline}}}})),h=monaco.editor.getModelMarkers({owner:t,resource:i});h&&h.length>0&&(a=[],r._monacoInstance.editor.setModelMarkers(u,t,[])),u.deltaDecorations(a,d)}else u.deltaDecorations(a,[]),r._monacoInstance.editor.setModelMarkers(u,t,e)}}})).then(void 0,(function(n){console.error(n)}))}},n}();function c(n){return n.changes.map((function(n){return{start:n.rangeOffset,end:n.rangeOffset+n.text.length}}))}function s(n){switch(n){case e.DiagnosticSeverity.Error:return monaco.MarkerSeverity.Error;case e.DiagnosticSeverity.Warning:return monaco.MarkerSeverity.Warning;case e.DiagnosticSeverity.Information:return monaco.MarkerSeverity.Info;case e.DiagnosticSeverity.Hint:return monaco.MarkerSeverity.Hint;default:return monaco.MarkerSeverity.Info}}t.DiagnosticsAdapter=a;var f={Column:"C71585",Comment:"008000",Database:"C71585",Function:"0000FF",Identifier:"000000",Keyword:"0000FF",Literal:"B22222",ScalarOperator:"0000FF",MaterializedView:"C71585",MathOperator:"000000",Command:"0000FF",Parameter:"2B91AF",PlainText:"000000",Punctuation:"000000",QueryOperator:"CC3700",QueryParameter:"CC3700",StringLiteral:"B22222",Table:"C71585",Type:"0000FF",Variable:"191970",Directive:"9400D3",ClientParameter:"b5cea8",SchemaMember:"C71585",SignatureParameter:"2B91AF",Option:"000000"},l={Column:"4ec9b0",Comment:"608B4E",Database:"c586c0",Function:"dcdcaa",Identifier:"d4d4d4",Keyword:"569cd6",Literal:"ce9178",ScalarOperator:"569cd6",MaterializedView:"c586c0",MathOperator:"d4d4d4",Command:"d4d4d4",Parameter:"2B91AF",PlainText:"d4d4d4",Punctuation:"d4d4d4",QueryOperator:"9cdcfe",QueryParameter:"9cdcfe",StringLiteral:"ce9178",Table:"c586c0",Type:"569cd6",Variable:"d7ba7d",Directive:"b5cea8",ClientParameter:"b5cea8",SchemaMember:"4ec9b0",SignatureParameter:"2B91AF",Option:"d4d4d4"},d=function(){function n(n,t,e,i,o){var a,s,d,h=this;this._monacoInstance=n,this._languageId=t,this._worker=e,this._disposables=[],this._contentListener=Object.create(null),this._configurationListener=Object.create(null),this._schemaListener=Object.create(null),this.decorations=[],a=document.getElementsByTagName("head")[0],(s=document.createElement("style")).type="text/css",s.media="screen",a.appendChild(s),s.innerHTML=(d=u,Object.keys(d).filter((function(n){return"number"==typeof d[n]}))).map((function(n){return{classification:n,colorLight:f[n],colorDark:l[n]}})).map((function(n){return".vs ."+n.classification+" {color: #"+n.colorLight+";} .vs-dark ."+n.classification+" {color: #"+n.colorDark+";}"})).join("\n");var g=function(n){var t=n.getLanguageId();if(t===h._languageId){var e=r.debounce((function(e){return h._doColorization(n,t,e)}),500);h._contentListener[n.uri.toString()]=n.onDidChangeContent((function(n){var t=c(n);e(t)})),h._configurationListener[n.uri.toString()]=i.onDidChange((function(){self.setTimeout((function(){return h._doColorization(n,t,[])}),0)})),h._schemaListener[n.uri.toString()]=o((function(){self.setTimeout((function(){return h._doColorization(n,t,[])}),0)}))}},p=function(n){n.deltaDecorations(h.decorations,[]);var t=n.uri.toString(),e=h._contentListener[t];e&&(e.dispose(),delete h._contentListener[t]);var r=h._configurationListener[t];r&&(r.dispose(),delete h._configurationListener[t]);var i=h._configurationListener[t];i&&(i.dispose(),delete h._schemaListener[t])};this._disposables.push(this._monacoInstance.editor.onDidCreateModel(g)),this._disposables.push(this._monacoInstance.editor.onWillDisposeModel(p)),this._disposables.push(this._monacoInstance.editor.onDidChangeModelLanguage((function(n){p(n.model),g(n.model)}))),this._disposables.push({dispose:function(){for(var n in h._contentListener)h._contentListener[n].dispose()}}),this._monacoInstance.editor.getModels().forEach(g)}return n.prototype.dispose=function(){this._disposables.forEach((function(n){return n&&n.dispose()})),this._disposables=[]},n.prototype._rangeDoesNotIntersectAny=function(n,t){return t.every((function(t){return n.startLineNumber>t.lastImpactedLine||n.endLineNumber<t.firstImpactedLine}))},n.prototype._doColorization=function(n,t,e){var r=this;if(!n.isDisposed()){var i=n.uri,a=n.getVersionId();this._worker(i).then((function(n){return n.doColorization(i.toString(),e)})).then((function(e){if(r._monacoInstance.editor.getModel(n.uri).getVersionId()===a){var i=e.map((function(t){var e=t.classifications.map((function(t){return function(n,t){var e=n.getPositionAt(t.start),r=n.getPositionAt(t.start+t.length),i=new o(e.lineNumber,e.column,r.lineNumber,r.column),a=u.$names[t.kind];return{range:i,options:{inlineClassName:a,stickiness:monaco.editor.TrackedRangeStickiness.NeverGrowsWhenTypingAtEdges}}}(n,t)})).filter((function(n){return"PlainText"!==n.options.inlineClassName&&"Identifier"!=n.options.inlineClassName})),r=n.getPositionAt(t.absoluteStart).lineNumber,i=n.getPositionAt(t.absoluteEnd);return{decorations:e,firstImpactedLine:r,lastImpactedLine:1==i.column&&i.lineNumber>1?i.lineNumber-1:i.lineNumber}})),c=i.map((function(t){return n.getLinesDecorations(t.firstImpactedLine,t.lastImpactedLine).filter((function(n){return f[n.options.inlineClassName]})).map((function(n){return n.id}))})).reduce((function(n,t){return n.concat(t)}),[]),s=i.reduce((function(n,t){return n.concat(t.decorations)}),[]);n&&n.getLanguageId()===t&&(r.decorations=n.deltaDecorations(c,s))}})).then(void 0,(function(n){console.error(n)}))}},n}();function h(n){if(n)return{character:n.column-1,line:n.lineNumber-1}}function g(n){if(n)return new o(n.start.line+1,n.start.character+1,n.end.line+1,n.end.character+1)}function p(n){var t=monaco.languages.CompletionItemKind;switch(n){case e.CompletionItemKind.Text:return t.Text;case e.CompletionItemKind.Method:return t.Method;case e.CompletionItemKind.Function:return t.Function;case e.CompletionItemKind.Constructor:return t.Constructor;case e.CompletionItemKind.Field:return t.Field;case e.CompletionItemKind.Variable:return t.Variable;case e.CompletionItemKind.Class:return t.Class;case e.CompletionItemKind.Interface:return t.Interface;case e.CompletionItemKind.Module:return t.Module;case e.CompletionItemKind.Property:return t.Property;case e.CompletionItemKind.Unit:return t.Unit;case e.CompletionItemKind.Value:return t.Value;case e.CompletionItemKind.Enum:return t.Enum;case e.CompletionItemKind.Keyword:return t.Keyword;case e.CompletionItemKind.Snippet:return t.Snippet;case e.CompletionItemKind.Color:return t.Color;case e.CompletionItemKind.File:return t.File;case e.CompletionItemKind.Reference:return t.Reference}return t.Property}function v(n){if(n)return{range:g(n.range),text:n.newText}}t.ColorizationAdapter=d;var _=function(){function n(n,t){this._worker=n,this.languageSettings=t}return Object.defineProperty(n.prototype,"triggerCharacters",{get:function(){return[" "]},enumerable:!1,configurable:!0}),n.prototype.provideCompletionItems=function(n,t,r,i){var u=n.getWordUntilPosition(t),a=new o(t.lineNumber,u.startColumn,t.lineNumber,u.endColumn),c=n.uri,s=this.languageSettings.onDidProvideCompletionItems;return this._worker(c).then((function(n){return n.doComplete(c.toString(),h(t))})).then((function(n){return s?s(n):n})).then((function(n){if(n){var t=n.items.map((function(n){var t={label:n.label,insertText:n.insertText,sortText:n.sortText,filterText:n.filterText,documentation:n.documentation,detail:n.detail,range:a,kind:p(n.kind)};return n.textEdit&&(t.range=g(n.textEdit.range),t.insertText=n.textEdit.newText),n.insertTextFormat===e.InsertTextFormat.Snippet&&(t.insertTextRules=monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet),t}));return{isIncomplete:n.isIncomplete,suggestions:t}}}))},n}();function m(n){return"string"==typeof n?{value:n}:(t=n)&&"object"==typeof t&&"string"==typeof t.kind?"plaintext"===n.kind?{value:n.value.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}:{value:n.value}:{value:"```"+n.value+"\n"+n.value+"\n```\n"};var t}function y(n){if(n)return Array.isArray(n)?n.map(m):[m(n)]}function b(n){return{uri:i.parse(n.uri),range:g(n.range)}}t.CompletionAdapter=_;var w=function(){function n(n){this._worker=n}return n.prototype.provideDefinition=function(n,t,e){var r=n.uri;return this._worker(r).then((function(n){return n.findDefinition(r.toString(),h(t))})).then((function(n){if(n&&0!=n.length)return[b(n[0])]}))},n}();t.DefinitionAdapter=w;var k=function(){function n(n){this._worker=n}return n.prototype.provideReferences=function(n,t,e,r){var i=n.uri;return this._worker(i).then((function(n){return n.findReferences(i.toString(),h(t))})).then((function(n){if(n)return n.map(b)}))},n}();t.ReferenceAdapter=k;var x=function(){function n(n){this._worker=n}return n.prototype.provideRenameEdits=function(n,t,e,r){var o=n.uri;return this._worker(o).then((function(n){return n.doRename(o.toString(),h(t),e)})).then((function(n){return function(n){if(n&&n.changes){var t=[];for(var e in n.changes)for(var r=i.parse(e),o=0,u=n.changes[e];o<u.length;o++){var a=u[o];t.push({resource:r,edit:{range:g(a.range),text:a.newText}})}return{edits:t}}}(n)}))},n}();t.RenameAdapter=x;var C=function(){function n(n){this._worker=n}return n.prototype.provideDocumentFormattingEdits=function(n,t,e){var r=n.uri;return this._worker(r).then((function(n){return n.doDocumentFormat(r.toString()).then((function(n){return n.map((function(n){return v(n)}))}))}))},n}();t.DocumentFormatAdapter=C;var I=function(){function n(n){this._worker=n}return n.prototype.provideDocumentRangeFormattingEdits=function(n,t,e,r){var i=n.uri;return this._worker(i).then((function(n){return n.doRangeFormat(i.toString(),function(n){if(n)return{start:h(n.getStartPosition()),end:h(n.getEndPosition())}}(t)).then((function(n){return n.map((function(n){return v(n)}))}))}))},n}();t.FormatAdapter=I;var A=function(){function n(n){this._worker=n}return n.prototype.provideFoldingRanges=function(n,t,e){var r=n.uri;return this._worker(r).then((function(n){return n.doFolding(r.toString()).then((function(n){return n.map((function(n){return function(n){return{start:n.startLine+1,end:n.endLine+1,kind:monaco.languages.FoldingRangeKind.Region}}(n)}))}))}))},n}();t.FoldingAdapter=A;var S=function(){function n(n){this._worker=n}return n.prototype.provideHover=function(n,t,e){var r=n.uri;return this._worker(r).then((function(n){return n.doHover(r.toString(),h(t))})).then((function(n){if(n)return{range:g(n.range),contents:y(n.contents)}}))},n}();t.HoverAdapter=S}));var __assign=this&&this.__assign||function(){return(__assign=Object.assign||function(n){for(var t,e=1,r=arguments.length;e<r;e++)for(var i in t=arguments[e])Object.prototype.hasOwnProperty.call(t,i)&&(n[i]=t[i]);return n}).apply(this,arguments)};define("vs/language/kusto/kustoMode",["require","exports","./workerManager","./languageService/kustoMonarchLanguageDefinition","./languageFeatures"],(function(n,t,e,r,i){"use strict";var o,u;Object.defineProperty(t,"__esModule",{value:!0}),t.getKustoWorker=t.setupMode=void 0;var a=new Promise((function(n,t){u=n,t}));t.setupMode=function(n,t){var a,c=new monaco.Emitter,s=[],f=new e.WorkerManager(t,n);s.push(f);var l=function(n){for(var t=[],e=1;e<arguments.length;e++)t[e-1]=arguments[e];var r=function(n,t,e){t.setSchema(n).then((function(){c.fire(n)}))},i=f.getLanguageServiceWorker.apply(f,[n].concat(t));return i.then((function(n){return __assign(__assign({},n),{setSchema:function(t){return r(t,n)},setSchemaFromShowSchema:function(t,e,i,o){n.normalizeSchema(t,e,i).then((function(n){return o?__assign(__assign({},n),{globalParameters:o}):n})).then((function(t){return r(t,n)}))}})}))};return s.push(t.languages.registerCompletionItemProvider("kusto",new i.CompletionAdapter(l,n.languageSettings))),n.languageSettings.useTokenColorization&&(a=t.languages.setMonarchTokensProvider("kusto",r.KustoLanguageDefinition)),n.onDidChange((function(n){n.languageSettings.useTokenColorization||void 0===a||(a.dispose(),a=void 0),n.languageSettings.useTokenColorization&&null==a&&(a=t.languages.setMonarchTokensProvider("kusto",r.KustoLanguageDefinition))})),s.push(new i.DiagnosticsAdapter(t,"kusto",l,n,c.event)),s.push(new i.ColorizationAdapter(t,"kusto",l,n,c.event)),s.push(t.languages.registerDocumentRangeFormattingEditProvider("kusto",new i.FormatAdapter(l))),s.push(t.languages.registerFoldingRangeProvider("kusto",new i.FoldingAdapter(l))),s.push(t.languages.registerDefinitionProvider("kusto",new i.DefinitionAdapter(l))),s.push(t.languages.registerRenameProvider("kusto",new i.RenameAdapter(l))),s.push(t.languages.registerReferenceProvider("kusto",new i.ReferenceAdapter(l))),n.languageSettings.enableHover&&s.push(t.languages.registerHoverProvider("kusto",new i.HoverAdapter(l))),t.languages.registerDocumentFormattingEditProvider("kusto",new i.DocumentFormatAdapter(l)),o=l,u(l),t.languages.setLanguageConfiguration("kusto",{folding:{offSide:!1,markers:{start:/^\s*[\r\n]/gm,end:/^\s*[\r\n]/gm}},comments:{lineComment:"//",blockComment:null}}),o},t.getKustoWorker=function(){return a.then((function(){return o}))}}));