import * as React from "react";
import { Able, MoveableInterface, GroupableProps, MoveableDefaultProps, IndividualGroupableProps, MoveableManagerInterface } from "./types";
import MoveableManager from "./MoveableManager";
import MoveableGroup from "./MoveableGroup";
import { IObject } from "@daybrush/utils";
import MoveableIndividualGroup from "./MoveableIndividualGroup";
export declare class InitialMoveable<T = {}> extends React.PureComponent<MoveableDefaultProps & GroupableProps & IndividualGroupableProps & T> {
    static defaultAbles: Able[];
    static customStyledMap: Record<string, any>;
    static defaultStyled: any;
    static makeStyled(): void;
    static getTotalAbles(): Able[];
    moveable: MoveableManager | MoveableGroup | MoveableIndividualGroup;
    refTargets: Array<HTMLElement | SVGElement | string | undefined | null>;
    selectorMap: IObject<Array<HTMLElement | SVGElement>>;
    private _differ;
    private _elementTargets;
    private _onChangetarget;
    render(): JSX.Element;
    componentDidMount(): void;
    componentDidUpdate(): void;
    componentWillUnmount(): void;
    /**
     * User changes target and waits for target to change.
     * @method Moveable#waitToChangeTarget
     * @example
     * import Moveable from "moveable";
     *
     * const moveable = new Moveable(document.body);
     *
     * document.querySelector(".target").addEventListener("mousedown", e => {
     *   moveable.waitToChangeTarget().then(() => {
     *      moveable.dragStart(e.currentTarget);
     *   });
     *   moveable.target = e.currentTarget;
     * });
     */
    waitToChangeTarget(): Promise<void>;
    getManager(): MoveableManagerInterface<any, any>;
    private _updateRefs;
}
export interface InitialMoveable<T = {}> extends React.PureComponent<MoveableDefaultProps & GroupableProps & IndividualGroupableProps & T>, MoveableInterface {
    setState(state: any, callback?: () => any): any;
    forceUpdate(callback?: () => any): any;
}
