import { TransportItemType } from '../../transports';
export function initializeTraces(_transports, _metas) {
  var otel = undefined;
  var initOTEL = function (trace, context) {
    otel = {
      trace: trace,
      context: context,
    };
  };
  var getTraceContext = function () {
    if (otel) {
      var ctx = otel.trace.getSpanContext(otel.context.active());
      if (ctx) {
        return {
          trace_id: ctx.traceId,
          span_id: ctx.spanId,
        };
      }
    }
    return undefined;
  };
  var pushTraces = function (request) {
    try {
      var item = {
        type: TransportItemType.TRACE,
        payload: request,
        meta: _metas.value,
      };
      _transports.execute(item);
    } catch (err) {
      // TODO: Add proper logging when debug is enabled
    }
  };
  var getOTEL = function () {
    return otel;
  };
  var bag = {
    initOTEL: initOTEL,
    pushTraces: pushTraces,
    getTraceContext: getTraceContext,
    getOTEL: getOTEL,
  };
  return bag;
}
//# sourceMappingURL=initialize.js.map
