/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SVGIO_INC_SVGTREFNODE_HXX
#define INCLUDED_SVGIO_INC_SVGTREFNODE_HXX

#include <svgnode.hxx>
#include <svgstyleattributes.hxx>
#include <svgtextnode.hxx>

namespace svgio
{
    namespace svgreader
    {
        class SvgTrefNode : public SvgNode
        {
        private:
            /// use styles
            SvgStyleAttributes      maSvgStyleAttributes;

            /// link to text content. If maXLink
            /// is set, the node can be fetched on demand
            OUString               maXLink;

        public:
            SvgTrefNode(
                SvgDocument& rDocument,
                SvgNode* pParent);
            virtual ~SvgTrefNode() override;

            virtual const SvgStyleAttributes* getSvgStyleAttributes() const override;
            virtual void parseAttribute(const OUString& rTokenName, SVGToken aSVGToken, const OUString& aContent) override;

            /// access to referenced SvgTextNode
            const SvgTextNode* getReferencedSvgTextNode() const;
        };
    } // end of namespace svgreader
} // end of namespace svgio

#endif // INCLUDED_SVGIO_INC_SVGTREFNODE_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
