/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __PS3_HTP_NVME_SPEC_H__
#define __PS3_HTP_NVME_SPEC_H__


enum NvmeGenCmdSC {
	NVME_SC_SUCCESS = 0x00,
	NVME_SC_INVALID_OPCODE = 0x01,
	NVME_SC_INVALID_FIELD = 0x02,
	NVME_SC_COMMAND_ID_CONFLICT = 0x03,
	NVME_SC_DATA_TRANSFER_ERROR = 0x04,
	NVME_SC_ABORTED_POWER_LOSS = 0x05,
	NVME_SC_INTERNAL_DEVICE_ERROR = 0x06,
	NVME_SC_ABORTED_BY_REQUEST = 0x07,
	NVME_SC_ABORTED_SQ_DELETION = 0x08,
	NVME_SC_ABORTED_FAILED_FUSED = 0x09,
	NVME_SC_ABORTED_MISSING_FUSED = 0x0a,
	NVME_SC_INVALID_NAMESPACE_OR_FORMAT = 0x0b,
	NVME_SC_COMMAND_SEQUENCE_ERROR = 0x0c,
	NVME_SC_INVALID_SGL_SEG_DESCRIPTOR = 0x0d,
	NVME_SC_INVALID_NUM_SGL_DESCIRPTORS = 0x0e,
	NVME_SC_DATA_SGL_LENGTH_INVALID = 0x0f,
	NVME_SC_METADATA_SGL_LENGTH_INVALID = 0x10,
	NVME_SC_SGL_DESCRIPTOR_TYPE_INVALID = 0x11,
	NVME_SC_INVALID_CONTROLLER_MEM_BUF = 0x12,
	NVME_SC_INVALID_PRP_OFFSET = 0x13,
	NVME_SC_ATOMIC_WRITE_UNIT_EXCEEDED = 0x14,
	NVME_SC_OPERATION_DENIED = 0x15,
	NVME_SC_INVALID_SGL_OFFSET = 0x16,

	NVME_SC_HOSTID_INCONSISTENT_FORMAT = 0x18,
	NVME_SC_KEEP_ALIVE_EXPIRED = 0x19,
	NVME_SC_KEEP_ALIVE_INVALID = 0x1a,
	NVME_SC_ABORTED_PREEMPT = 0x1b,
	NVME_SC_SANITIZE_FAILED = 0x1c,
	NVME_SC_SANITIZE_IN_PROGRESS = 0x1d,
	NVME_SC_SGL_DATA_BLOCK_GRANULARITY_INVALID = 0x1e,
	NVME_SC_COMMAND_INVALID_IN_CMB = 0x1f,
	NVME_SC_NAMESPACE_IS_WRITE_PROTECTED = 0x20,
	NVME_SC_COMMAND_INTERRUPTED = 0x21,
	NVME_SC_TRANSIENT_TRANSPORT_ERROR = 0x22,

	NVME_SC_LBA_OUT_OF_RANGE = 0x80,
	NVME_SC_CAPACITY_EXCEEDED = 0x81,
	NVME_SC_NAMESPACE_NOT_READY = 0x82,
	NVME_SC_RESERVATION_CONFLICT = 0x83,
	NVME_SC_FORMAT_IN_PROGRESS = 0x84,
};


enum NvmeCmdSpecSC {
	NVME_CSC_COMPLETION_QUEUE_INVALID = 0x00,
	NVME_CSC_INVALID_QUEUE_IDENTIFIER = 0x01,
	NVME_CSC_MAXIMUM_QUEUE_SIZE_EXCEEDED = 0x02,
	NVME_CSC_ABORT_COMMAND_LIMIT_EXCEEDED = 0x03,

	NVME_CSC_ASYNC_EVENT_REQUEST_LIMIT_EXCEEDED = 0x05,
	NVME_CSC_INVALID_FIRMWARE_SLOT = 0x06,
	NVME_CSC_INVALID_FIRMWARE_IMAGE = 0x07,
	NVME_CSC_INVALID_INTERRUPT_VECTOR = 0x08,
	NVME_CSC_INVALID_LOG_PAGE = 0x09,
	NVME_CSC_INVALID_FORMAT = 0x0a,
	NVME_CSC_FIRMWARE_REQ_CONVENTIONAL_RESET = 0x0b,
	NVME_CSC_INVALID_QUEUE_DELETION = 0x0c,
	NVME_CSC_FEATURE_ID_NOT_SAVEABLE = 0x0d,
	NVME_CSC_FEATURE_NOT_CHANGEABLE = 0x0e,
	NVME_CSC_FEATURE_NOT_NAMESPACE_SPECIFIC = 0x0f,
	NVME_CSC_FIRMWARE_REQ_NVM_RESET = 0x10,
	NVME_CSC_FIRMWARE_REQ_RESET = 0x11,
	NVME_CSC_FIRMWARE_REQ_MAX_TIME_VIOLATION = 0x12,
	NVME_CSC_FIRMWARE_ACTIVATION_PROHIBITED = 0x13,
	NVME_CSC_OVERLAPPING_RANGE = 0x14,
	NVME_CSC_NAMESPACE_INSUFFICIENT_CAPACITY = 0x15,
	NVME_CSC_NAMESPACE_ID_UNAVAILABLE = 0x16,

	NVME_CSC_NAMESPACE_ALREADY_ATTACHED = 0x18,
	NVME_CSC_NAMESPACE_IS_PRIVATE = 0x19,
	NVME_CSC_NAMESPACE_NOT_ATTACHED = 0x1a,
	NVME_CSC_THINPROVISIONING_NOT_SUPPORTED = 0x1b,
	NVME_CSC_CONTROLLER_LIST_INVALID = 0x1c,
	NVME_CSC_DEVICE_SELF_TEST_IN_PROGRESS = 0x1d,
	NVME_CSC_BOOT_PARTITION_WRITE_PROHIBITED = 0x1e,
	NVME_CSC_INVALID_CTRLR_ID = 0x1f,
	NVME_CSC_INVALID_SECONDARY_CTRLR_STATE = 0x20,
	NVME_CSC_INVALID_NUM_CTRLR_RESOURCES = 0x21,
	NVME_CSC_INVALID_RESOURCE_ID = 0x22,

	NVME_CSC_CONFLICTING_ATTRIBUTES = 0x80,
	NVME_CSC_INVALID_PROTECTION_INFO = 0x81,
	NVME_CSC_ATTEMPTED_WRITE_TO_RO_RANGE = 0x82,
};


enum NvmeMediaErrSC {
	NVME_MSC_WRITE_FAULTS = 0x80,
	NVME_MSC_UNRECOVERED_READ_ERROR = 0x81,
	NVME_MSC_GUARD_CHECK_ERROR = 0x82,
	NVME_MSC_APPLICATION_TAG_CHECK_ERROR = 0x83,
	NVME_MSC_REFERENCE_TAG_CHECK_ERROR = 0x84,
	NVME_MSC_COMPARE_FAILURE = 0x85,
	NVME_MSC_ACCESS_DENIED = 0x86,
	NVME_MSC_DEALLOCATED_OR_UNWRITTEN_BLOCK = 0x87,
};

enum NvmeStatusCodes {
	NVME_SUCCESS = 0x0000,
	NVME_INVALID_OPCODE = 0x0001,
	NVME_INVALID_FIELD = 0x0002,
	NVME_CID_CONFLICT = 0x0003,
	NVME_DATA_TRAS_ERROR = 0x0004,
	NVME_POWER_LOSS_ABORT = 0x0005,
	NVME_INTERNAL_DEV_ERROR = 0x0006,
	NVME_CMD_ABORT_REQ = 0x0007,
	NVME_CMD_ABORT_SQ_DEL = 0x0008,
	NVME_CMD_ABORT_FAILED_FUSE = 0x0009,
	NVME_CMD_ABORT_MISSING_FUSE = 0x000a,
	NVME_INVALID_NSID = 0x000b,
	NVME_CMD_SEQ_ERROR = 0x000c,
	NVME_INVALID_SGL_SEG_DESCR = 0x000d,
	NVME_INVALID_NUM_SGL_DESCRS = 0x000e,
	NVME_DATA_SGL_LEN_INVALID = 0x000f,
	NVME_MD_SGL_LEN_INVALID = 0x0010,
	NVME_SGL_DESCR_TYPE_INVALID = 0x0011,
	NVME_INVALID_USE_OF_CMB = 0x0012,
	NVME_INVALID_PRP_OFFSET = 0x0013,
	NVME_CMD_SET_CMB_REJECTED = 0x002b,
	NVME_INVALID_CMD_SET = 0x002c,
	NVME_LBA_RANGE = 0x0080,
	NVME_CAP_EXCEEDED = 0x0081,
	NVME_NS_NOT_READY = 0x0082,
	NVME_NS_RESV_CONFLICT = 0x0083,
	NVME_FORMAT_IN_PROGRESS = 0x0084,
	NVME_INVALID_CQID = 0x0100,
	NVME_INVALID_QID = 0x0101,
	NVME_MAX_QSIZE_EXCEEDED = 0x0102,
	NVME_ACL_EXCEEDED = 0x0103,
	NVME_RESERVED = 0x0104,
	NVME_AER_LIMIT_EXCEEDED = 0x0105,
	NVME_INVALID_FW_SLOT = 0x0106,
	NVME_INVALID_FW_IMAGE = 0x0107,
	NVME_INVALID_IRQ_VECTOR = 0x0108,
	NVME_INVALID_LOG_ID = 0x0109,
	NVME_INVALID_FORMAT = 0x010a,
	NVME_FW_REQ_RESET = 0x010b,
	NVME_INVALID_QUEUE_DEL = 0x010c,
	NVME_FID_NOT_SAVEABLE = 0x010d,
	NVME_FEAT_NOT_CHANGEABLE = 0x010e,
	NVME_FEAT_NOT_NS_SPEC = 0x010f,
	NVME_FW_REQ_SUSYSTEM_RESET = 0x0110,
	NVME_NS_ALREADY_ATTACHED = 0x0118,
	NVME_NS_PRIVATE = 0x0119,
	NVME_NS_NOT_ATTACHED = 0x011A,
	NVME_NS_CTRL_LIST_INVALID = 0x011C,
	NVME_CONFLICTING_ATTRS = 0x0180,
	NVME_INVALID_PROT_INFO = 0x0181,
	NVME_WRITE_TO_RO = 0x0182,
	NVME_CMD_SIZE_LIMIT = 0x0183,
	NVME_ZONE_BOUNDARY_ERROR = 0x01b8,
	NVME_ZONE_FULL = 0x01b9,
	NVME_ZONE_READ_ONLY = 0x01ba,
	NVME_ZONE_OFFLINE = 0x01bb,
	NVME_ZONE_INVALID_WRITE = 0x01bc,
	NVME_ZONE_TOO_MANY_ACTIVE = 0x01bd,
	NVME_ZONE_TOO_MANY_OPEN = 0x01be,
	NVME_ZONE_INVAL_TRANSITION = 0x01bf,
	NVME_WRITE_FAULT = 0x0280,
	NVME_UNRECOVERED_READ = 0x0281,
	NVME_E2E_GUARD_ERROR = 0x0282,
	NVME_E2E_APP_ERROR = 0x0283,
	NVME_E2E_REF_ERROR = 0x0284,
	NVME_CMP_FAILURE = 0x0285,
	NVME_ACCESS_DENIED = 0x0286,
	NVME_DULB = 0x0287,
	NVME_MORE = 0x2000,
	NVME_DNR = 0x4000,
	NVME_NO_COMPLETE = 0xffff,
};


enum NvmeStatusCodeType {
	NVME_SCT_GENERIC = 0x0,
	NVME_SCT_COMMAND_SPECIFIC = 0x1,
	NVME_SCT_MEDIA_ERROR = 0x2,
	NVME_SCT_PATH = 0x3,

	NVME_SCT_VENDOR_SPECIFIC = 0x7,
};

#endif
