; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve %s -o - | FileCheck %s

define arm_aapcs_vfpcc <16 x i8> @vabd_v16s8(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: vabd_v16s8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vabd.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
  %sextsrc1 = sext <16 x i8> %src1 to <16 x i16>
  %sextsrc2 = sext <16 x i8> %src2 to <16 x i16>
  %add1 = sub <16 x i16> %sextsrc1, %sextsrc2
  %add2 = sub <16 x i16> zeroinitializer, %add1
  %c = icmp sge <16 x i16> %add1, zeroinitializer
  %s = select <16 x i1> %c, <16 x i16> %add1, <16 x i16> %add2
  %result = trunc <16 x i16> %s to <16 x i8>
  ret <16 x i8> %result
}

define arm_aapcs_vfpcc <8 x i8> @vabd_v8s8(<8 x i8> %src1, <8 x i8> %src2) {
; CHECK-LABEL: vabd_v8s8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.s8 q1, q1
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    vabd.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %sextsrc1 = sext <8 x i8> %src1 to <8 x i16>
  %sextsrc2 = sext <8 x i8> %src2 to <8 x i16>
  %add1 = sub <8 x i16> %sextsrc1, %sextsrc2
  %add2 = sub <8 x i16> zeroinitializer, %add1
  %c = icmp sge <8 x i16> %add1, zeroinitializer
  %s = select <8 x i1> %c, <8 x i16> %add1, <8 x i16> %add2
  %result = trunc <8 x i16> %s to <8 x i8>
  ret <8 x i8> %result
}

define arm_aapcs_vfpcc <4 x i8> @vabd_v4s8(<4 x i8> %src1, <4 x i8> %src2) {
; CHECK-LABEL: vabd_v4s8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.s8 q1, q1
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    vmovlb.s16 q1, q1
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    vsub.i32 q0, q0, q1
; CHECK-NEXT:    vabs.s32 q0, q0
; CHECK-NEXT:    bx lr
  %sextsrc1 = sext <4 x i8> %src1 to <4 x i16>
  %sextsrc2 = sext <4 x i8> %src2 to <4 x i16>
  %add1 = sub <4 x i16> %sextsrc1, %sextsrc2
  %add2 = sub <4 x i16> zeroinitializer, %add1
  %c = icmp sge <4 x i16> %add1, zeroinitializer
  %s = select <4 x i1> %c, <4 x i16> %add1, <4 x i16> %add2
  %result = trunc <4 x i16> %s to <4 x i8>
  ret <4 x i8> %result
}

define arm_aapcs_vfpcc <8 x i16> @vabd_v8s16(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: vabd_v8s16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vabd.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %sextsrc1 = sext <8 x i16> %src1 to <8 x i32>
  %sextsrc2 = sext <8 x i16> %src2 to <8 x i32>
  %add1 = sub <8 x i32> %sextsrc1, %sextsrc2
  %add2 = sub <8 x i32> zeroinitializer, %add1
  %c = icmp sge <8 x i32> %add1, zeroinitializer
  %s = select <8 x i1> %c, <8 x i32> %add1, <8 x i32> %add2
  %result = trunc <8 x i32> %s to <8 x i16>
  ret <8 x i16> %result
}

define arm_aapcs_vfpcc <4 x i16> @vabd_v4s16(<4 x i16> %src1, <4 x i16> %src2) {
; CHECK-LABEL: vabd_v4s16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.s16 q1, q1
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    vabd.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %sextsrc1 = sext <4 x i16> %src1 to <4 x i32>
  %sextsrc2 = sext <4 x i16> %src2 to <4 x i32>
  %add1 = sub <4 x i32> %sextsrc1, %sextsrc2
  %add2 = sub <4 x i32> zeroinitializer, %add1
  %c = icmp sge <4 x i32> %add1, zeroinitializer
  %s = select <4 x i1> %c, <4 x i32> %add1, <4 x i32> %add2
  %result = trunc <4 x i32> %s to <4 x i16>
  ret <4 x i16> %result
}

define arm_aapcs_vfpcc <4 x i32> @vabd_v4s32(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: vabd_v4s32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vabd.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %sextsrc1 = sext <4 x i32> %src1 to <4 x i64>
  %sextsrc2 = sext <4 x i32> %src2 to <4 x i64>
  %add1 = sub <4 x i64> %sextsrc1, %sextsrc2
  %add2 = sub <4 x i64> zeroinitializer, %add1
  %c = icmp sge <4 x i64> %add1, zeroinitializer
  %s = select <4 x i1> %c, <4 x i64> %add1, <4 x i64> %add2
  %result = trunc <4 x i64> %s to <4 x i32>
  ret <4 x i32> %result
}

define arm_aapcs_vfpcc <2 x i32> @vabd_v2s32(<2 x i32> %src1, <2 x i32> %src2) {
; CHECK-LABEL: vabd_v2s32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    asrs r1, r0, #31
; CHECK-NEXT:    subs r0, r0, r2
; CHECK-NEXT:    sbc.w r1, r1, r2, asr #31
; CHECK-NEXT:    eor.w r0, r0, r1, asr #31
; CHECK-NEXT:    eor.w r2, r1, r1, asr #31
; CHECK-NEXT:    subs.w r0, r0, r1, asr #31
; CHECK-NEXT:    sbc.w r12, r2, r1, asr #31
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmov r1, s4
; CHECK-NEXT:    asrs r3, r2, #31
; CHECK-NEXT:    subs r2, r2, r1
; CHECK-NEXT:    sbc.w r1, r3, r1, asr #31
; CHECK-NEXT:    eor.w r2, r2, r1, asr #31
; CHECK-NEXT:    subs.w r2, r2, r1, asr #31
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r0
; CHECK-NEXT:    eor.w r0, r1, r1, asr #31
; CHECK-NEXT:    sbc.w r0, r0, r1, asr #31
; CHECK-NEXT:    vmov q0[3], q0[1], r0, r12
; CHECK-NEXT:    bx lr
  %sextsrc1 = sext <2 x i32> %src1 to <2 x i64>
  %sextsrc2 = sext <2 x i32> %src2 to <2 x i64>
  %add1 = sub <2 x i64> %sextsrc1, %sextsrc2
  %add2 = sub <2 x i64> zeroinitializer, %add1
  %c = icmp sge <2 x i64> %add1, zeroinitializer
  %s = select <2 x i1> %c, <2 x i64> %add1, <2 x i64> %add2
  %result = trunc <2 x i64> %s to <2 x i32>
  ret <2 x i32> %result
}

define arm_aapcs_vfpcc <16 x i8> @vabd_v16u8(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: vabd_v16u8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vabd.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
  %zextsrc1 = zext <16 x i8> %src1 to <16 x i16>
  %zextsrc2 = zext <16 x i8> %src2 to <16 x i16>
  %add1 = sub <16 x i16> %zextsrc1, %zextsrc2
  %add2 = sub <16 x i16> zeroinitializer, %add1
  %c = icmp sge <16 x i16> %add1, zeroinitializer
  %s = select <16 x i1> %c, <16 x i16> %add1, <16 x i16> %add2
  %result = trunc <16 x i16> %s to <16 x i8>
  ret <16 x i8> %result
}

define arm_aapcs_vfpcc <8 x i8> @vabd_v8u8(<8 x i8> %src1, <8 x i8> %src2) {
; CHECK-LABEL: vabd_v8u8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmovlb.u8 q0, q0
; CHECK-NEXT:    vabd.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %zextsrc1 = zext <8 x i8> %src1 to <8 x i16>
  %zextsrc2 = zext <8 x i8> %src2 to <8 x i16>
  %add1 = sub <8 x i16> %zextsrc1, %zextsrc2
  %add2 = sub <8 x i16> zeroinitializer, %add1
  %c = icmp sge <8 x i16> %add1, zeroinitializer
  %s = select <8 x i1> %c, <8 x i16> %add1, <8 x i16> %add2
  %result = trunc <8 x i16> %s to <8 x i8>
  ret <8 x i8> %result
}

define arm_aapcs_vfpcc <4 x i8> @vabd_v4u8(<4 x i8> %src1, <4 x i8> %src2) {
; CHECK-LABEL: vabd_v4u8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i32 q2, #0xff
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vsub.i32 q0, q0, q1
; CHECK-NEXT:    vabs.s32 q0, q0
; CHECK-NEXT:    bx lr
  %zextsrc1 = zext <4 x i8> %src1 to <4 x i16>
  %zextsrc2 = zext <4 x i8> %src2 to <4 x i16>
  %add1 = sub <4 x i16> %zextsrc1, %zextsrc2
  %add2 = sub <4 x i16> zeroinitializer, %add1
  %c = icmp sge <4 x i16> %add1, zeroinitializer
  %s = select <4 x i1> %c, <4 x i16> %add1, <4 x i16> %add2
  %result = trunc <4 x i16> %s to <4 x i8>
  ret <4 x i8> %result
}

define arm_aapcs_vfpcc <8 x i16> @vabd_v8u16(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: vabd_v8u16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vabd.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %zextsrc1 = zext <8 x i16> %src1 to <8 x i32>
  %zextsrc2 = zext <8 x i16> %src2 to <8 x i32>
  %add1 = sub <8 x i32> %zextsrc1, %zextsrc2
  %add2 = sub <8 x i32> zeroinitializer, %add1
  %c = icmp sge <8 x i32> %add1, zeroinitializer
  %s = select <8 x i1> %c, <8 x i32> %add1, <8 x i32> %add2
  %result = trunc <8 x i32> %s to <8 x i16>
  ret <8 x i16> %result
}

define arm_aapcs_vfpcc <4 x i16> @vabd_v4u16(<4 x i16> %src1, <4 x i16> %src2) {
; CHECK-LABEL: vabd_v4u16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.u16 q1, q1
; CHECK-NEXT:    vmovlb.u16 q0, q0
; CHECK-NEXT:    vabd.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %zextsrc1 = zext <4 x i16> %src1 to <4 x i32>
  %zextsrc2 = zext <4 x i16> %src2 to <4 x i32>
  %add1 = sub <4 x i32> %zextsrc1, %zextsrc2
  %add2 = sub <4 x i32> zeroinitializer, %add1
  %c = icmp sge <4 x i32> %add1, zeroinitializer
  %s = select <4 x i1> %c, <4 x i32> %add1, <4 x i32> %add2
  %result = trunc <4 x i32> %s to <4 x i16>
  ret <4 x i16> %result
}

define arm_aapcs_vfpcc <4 x i32> @vabd_u32(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: vabd_u32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vabd.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %zextsrc1 = zext <4 x i32> %src1 to <4 x i64>
  %zextsrc2 = zext <4 x i32> %src2 to <4 x i64>
  %add1 = sub <4 x i64> %zextsrc1, %zextsrc2
  %add2 = sub <4 x i64> zeroinitializer, %add1
  %c = icmp sge <4 x i64> %add1, zeroinitializer
  %s = select <4 x i1> %c, <4 x i64> %add1, <4 x i64> %add2
  %result = trunc <4 x i64> %s to <4 x i32>
  ret <4 x i32> %result
}

define arm_aapcs_vfpcc <4 x i32> @vabd_v4u32(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: vabd_v4u32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vabd.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %zextsrc1 = zext <4 x i32> %src1 to <4 x i64>
  %zextsrc2 = zext <4 x i32> %src2 to <4 x i64>
  %add1 = sub <4 x i64> %zextsrc1, %zextsrc2
  %add2 = sub <4 x i64> zeroinitializer, %add1
  %c = icmp sge <4 x i64> %add1, zeroinitializer
  %s = select <4 x i1> %c, <4 x i64> %add1, <4 x i64> %add2
  %result = trunc <4 x i64> %s to <4 x i32>
  ret <4 x i32> %result
}

define arm_aapcs_vfpcc <2 x i32> @vabd_v2u32(<2 x i32> %src1, <2 x i32> %src2) {
; CHECK-LABEL: vabd_v2u32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov.i64 q2, #0xffffffff
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vmov r0, r1, d3
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    sbc.w r1, r3, r1
; CHECK-NEXT:    eor.w r0, r0, r1, asr #31
; CHECK-NEXT:    eor.w r2, r1, r1, asr #31
; CHECK-NEXT:    subs.w lr, r0, r1, asr #31
; CHECK-NEXT:    sbc.w r12, r2, r1, asr #31
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    vmov r1, r0, d0
; CHECK-NEXT:    subs r1, r1, r2
; CHECK-NEXT:    sbcs r0, r3
; CHECK-NEXT:    eor.w r1, r1, r0, asr #31
; CHECK-NEXT:    subs.w r1, r1, r0, asr #31
; CHECK-NEXT:    vmov q0[2], q0[0], r1, lr
; CHECK-NEXT:    eor.w r1, r0, r0, asr #31
; CHECK-NEXT:    sbc.w r0, r1, r0, asr #31
; CHECK-NEXT:    vmov q0[3], q0[1], r0, r12
; CHECK-NEXT:    pop {r7, pc}
  %zextsrc1 = zext <2 x i32> %src1 to <2 x i64>
  %zextsrc2 = zext <2 x i32> %src2 to <2 x i64>
  %add1 = sub <2 x i64> %zextsrc1, %zextsrc2
  %add2 = sub <2 x i64> zeroinitializer, %add1
  %c = icmp sge <2 x i64> %add1, zeroinitializer
  %s = select <2 x i1> %c, <2 x i64> %add1, <2 x i64> %add2
  %result = trunc <2 x i64> %s to <2 x i32>
  ret <2 x i32> %result
}

define void @vabd_loop_s8(ptr nocapture readonly %x, ptr nocapture readonly %y, ptr noalias nocapture %z, i32 %n) {
; CHECK-LABEL: vabd_loop_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    mov.w lr, #64
; CHECK-NEXT:  .LBB15_1: @ %vector.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    vldrb.u8 q0, [r1], #16
; CHECK-NEXT:    vldrb.u8 q1, [r0], #16
; CHECK-NEXT:    vabd.s8 q0, q1, q0
; CHECK-NEXT:    vstrb.8 q0, [r2], #16
; CHECK-NEXT:    le lr, .LBB15_1
; CHECK-NEXT:  @ %bb.2: @ %for.cond.cleanup
; CHECK-NEXT:    pop {r7, pc}
entry:
  br label %vector.body

vector.body:                                      ; preds = %vector.body, %entry
  %index = phi i32 [ 0, %entry ], [ %index.next, %vector.body ]
  %0 = getelementptr inbounds i8, ptr %x, i32 %index
  %wide.load = load <16 x i8>, ptr %0, align 1
  %1 = sext <16 x i8> %wide.load to <16 x i32>
  %2 = getelementptr inbounds i8, ptr %y, i32 %index
  %wide.load22 = load <16 x i8>, ptr %2, align 1
  %3 = sext <16 x i8> %wide.load22 to <16 x i32>
  %4 = sub nsw <16 x i32> %1, %3
  %5 = icmp slt <16 x i32> %4, zeroinitializer
  %6 = sub nsw <16 x i32> zeroinitializer, %4
  %7 = select <16 x i1> %5, <16 x i32> %6, <16 x i32> %4
  %8 = trunc <16 x i32> %7 to <16 x i8>
  %9 = getelementptr inbounds i8, ptr %z, i32 %index
  store <16 x i8> %8, ptr %9, align 1
  %index.next = add i32 %index, 16
  %10 = icmp eq i32 %index.next, 1024
  br i1 %10, label %for.cond.cleanup, label %vector.body

for.cond.cleanup:                                 ; preds = %vector.body
  ret void
}

define void @vabd_loop_s16(ptr nocapture readonly %x, ptr nocapture readonly %y, ptr noalias nocapture %z, i32 %n) {
; CHECK-LABEL: vabd_loop_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    mov.w lr, #128
; CHECK-NEXT:  .LBB16_1: @ %vector.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    vldrh.u16 q0, [r1], #16
; CHECK-NEXT:    vldrh.u16 q1, [r0], #16
; CHECK-NEXT:    vabd.s16 q0, q1, q0
; CHECK-NEXT:    vstrb.8 q0, [r2], #16
; CHECK-NEXT:    le lr, .LBB16_1
; CHECK-NEXT:  @ %bb.2: @ %for.cond.cleanup
; CHECK-NEXT:    pop {r7, pc}
entry:
  br label %vector.body

vector.body:                                      ; preds = %vector.body, %entry
  %index = phi i32 [ 0, %entry ], [ %index.next, %vector.body ]
  %0 = getelementptr inbounds i16, ptr %x, i32 %index
  %wide.load = load <8 x i16>, ptr %0, align 2
  %1 = sext <8 x i16> %wide.load to <8 x i32>
  %2 = getelementptr inbounds i16, ptr %y, i32 %index
  %wide.load22 = load <8 x i16>, ptr %2, align 2
  %3 = sext <8 x i16> %wide.load22 to <8 x i32>
  %4 = sub nsw <8 x i32> %1, %3
  %5 = icmp slt <8 x i32> %4, zeroinitializer
  %6 = sub nsw <8 x i32> zeroinitializer, %4
  %7 = select <8 x i1> %5, <8 x i32> %6, <8 x i32> %4
  %8 = trunc <8 x i32> %7 to <8 x i16>
  %9 = getelementptr inbounds i16, ptr %z, i32 %index
  store <8 x i16> %8, ptr %9, align 2
  %index.next = add i32 %index, 8
  %10 = icmp eq i32 %index.next, 1024
  br i1 %10, label %for.cond.cleanup, label %vector.body

for.cond.cleanup:                                 ; preds = %vector.body
  ret void
}

define void @vabd_loop_s32(ptr nocapture readonly %x, ptr nocapture readonly %y, ptr noalias nocapture %z, i32 %n) {
; CHECK-LABEL: vabd_loop_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, r7, r8, r9, lr}
; CHECK-NEXT:    push.w {r4, r5, r6, r7, r8, r9, lr}
; CHECK-NEXT:    mov.w lr, #256
; CHECK-NEXT:    vmov.i32 q0, #0x0
; CHECK-NEXT:  .LBB17_1: @ %vector.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    vldrw.u32 q1, [r0], #16
; CHECK-NEXT:    vmov.f32 s8, s6
; CHECK-NEXT:    vmov r7, s4
; CHECK-NEXT:    vmov.f32 s6, s7
; CHECK-NEXT:    vmov r3, s8
; CHECK-NEXT:    vldrw.u32 q2, [r1], #16
; CHECK-NEXT:    vmov.f32 s12, s10
; CHECK-NEXT:    vmov.f32 s10, s5
; CHECK-NEXT:    vmov.f32 s14, s11
; CHECK-NEXT:    vmov r4, s12
; CHECK-NEXT:    asr.w r12, r3, #31
; CHECK-NEXT:    subs.w r8, r3, r4
; CHECK-NEXT:    sbc.w r12, r12, r4, asr #31
; CHECK-NEXT:    vmov r4, s10
; CHECK-NEXT:    vmov.f32 s10, s9
; CHECK-NEXT:    vmov r6, s10
; CHECK-NEXT:    asrs r3, r4, #31
; CHECK-NEXT:    subs r4, r4, r6
; CHECK-NEXT:    sbc.w r9, r3, r6, asr #31
; CHECK-NEXT:    vmov r6, s8
; CHECK-NEXT:    vmov r3, s6
; CHECK-NEXT:    subs r5, r7, r6
; CHECK-NEXT:    asr.w r7, r7, #31
; CHECK-NEXT:    vmov q2[2], q2[0], r5, r8
; CHECK-NEXT:    vmov r5, s14
; CHECK-NEXT:    sbc.w r6, r7, r6, asr #31
; CHECK-NEXT:    asrs r6, r6, #31
; CHECK-NEXT:    subs r7, r3, r5
; CHECK-NEXT:    asr.w r3, r3, #31
; CHECK-NEXT:    vmov q2[3], q2[1], r4, r7
; CHECK-NEXT:    mov.w r7, #0
; CHECK-NEXT:    sbc.w r3, r3, r5, asr #31
; CHECK-NEXT:    bfi r7, r6, #0, #4
; CHECK-NEXT:    asr.w r4, r9, #31
; CHECK-NEXT:    asr.w r6, r12, #31
; CHECK-NEXT:    bfi r7, r4, #4, #4
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    bfi r7, r6, #8, #4
; CHECK-NEXT:    bfi r7, r3, #12, #4
; CHECK-NEXT:    vmsr p0, r7
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vsubt.i32 q2, q0, q2
; CHECK-NEXT:    vstrb.8 q2, [r2], #16
; CHECK-NEXT:    le lr, .LBB17_1
; CHECK-NEXT:  @ %bb.2: @ %for.cond.cleanup
; CHECK-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, pc}
entry:
  br label %vector.body

vector.body:                                      ; preds = %vector.body, %entry
  %index = phi i32 [ 0, %entry ], [ %index.next, %vector.body ]
  %0 = getelementptr inbounds i32, ptr %x, i32 %index
  %wide.load = load <4 x i32>, ptr %0, align 4
  %1 = sext <4 x i32> %wide.load to <4 x i64>
  %2 = getelementptr inbounds i32, ptr %y, i32 %index
  %wide.load23 = load <4 x i32>, ptr %2, align 4
  %3 = sext <4 x i32> %wide.load23 to <4 x i64>
  %4 = sub nsw <4 x i64> %1, %3
  %5 = icmp slt <4 x i64> %4, zeroinitializer
  %6 = trunc <4 x i64> %4 to <4 x i32>
  %7 = sub <4 x i32> zeroinitializer, %6
  %8 = select <4 x i1> %5, <4 x i32> %7, <4 x i32> %6
  %9 = getelementptr inbounds i32, ptr %z, i32 %index
  store <4 x i32> %8, ptr %9, align 4
  %index.next = add i32 %index, 4
  %10 = icmp eq i32 %index.next, 1024
  br i1 %10, label %for.cond.cleanup, label %vector.body

for.cond.cleanup:                                 ; preds = %vector.body
  ret void
}

define void @vabd_loop_u8(ptr nocapture readonly %x, ptr nocapture readonly %y, ptr noalias nocapture %z, i32 %n) {
; CHECK-LABEL: vabd_loop_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    mov.w lr, #64
; CHECK-NEXT:  .LBB18_1: @ %vector.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    vldrb.u8 q0, [r1], #16
; CHECK-NEXT:    vldrb.u8 q1, [r0], #16
; CHECK-NEXT:    vabd.u8 q0, q1, q0
; CHECK-NEXT:    vstrb.8 q0, [r2], #16
; CHECK-NEXT:    le lr, .LBB18_1
; CHECK-NEXT:  @ %bb.2: @ %for.cond.cleanup
; CHECK-NEXT:    pop {r7, pc}
entry:
  br label %vector.body

vector.body:                                      ; preds = %vector.body, %entry
  %index = phi i32 [ 0, %entry ], [ %index.next, %vector.body ]
  %0 = getelementptr inbounds i8, ptr %x, i32 %index
  %wide.load = load <16 x i8>, ptr %0, align 1
  %1 = zext <16 x i8> %wide.load to <16 x i32>
  %2 = getelementptr inbounds i8, ptr %y, i32 %index
  %wide.load22 = load <16 x i8>, ptr %2, align 1
  %3 = zext <16 x i8> %wide.load22 to <16 x i32>
  %4 = sub nsw <16 x i32> %1, %3
  %5 = icmp slt <16 x i32> %4, zeroinitializer
  %6 = sub nsw <16 x i32> zeroinitializer, %4
  %7 = select <16 x i1> %5, <16 x i32> %6, <16 x i32> %4
  %8 = trunc <16 x i32> %7 to <16 x i8>
  %9 = getelementptr inbounds i8, ptr %z, i32 %index
  store <16 x i8> %8, ptr %9, align 1
  %index.next = add i32 %index, 16
  %10 = icmp eq i32 %index.next, 1024
  br i1 %10, label %for.cond.cleanup, label %vector.body

for.cond.cleanup:                                 ; preds = %vector.body
  ret void
}

define void @vabd_loop_u16(ptr nocapture readonly %x, ptr nocapture readonly %y, ptr noalias nocapture %z, i32 %n) {
; CHECK-LABEL: vabd_loop_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    mov.w lr, #128
; CHECK-NEXT:  .LBB19_1: @ %vector.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    vldrh.u16 q0, [r1], #16
; CHECK-NEXT:    vldrh.u16 q1, [r0], #16
; CHECK-NEXT:    vabd.u16 q0, q1, q0
; CHECK-NEXT:    vstrb.8 q0, [r2], #16
; CHECK-NEXT:    le lr, .LBB19_1
; CHECK-NEXT:  @ %bb.2: @ %for.cond.cleanup
; CHECK-NEXT:    pop {r7, pc}
entry:
  br label %vector.body

vector.body:                                      ; preds = %vector.body, %entry
  %index = phi i32 [ 0, %entry ], [ %index.next, %vector.body ]
  %0 = getelementptr inbounds i16, ptr %x, i32 %index
  %wide.load = load <8 x i16>, ptr %0, align 2
  %1 = zext <8 x i16> %wide.load to <8 x i32>
  %2 = getelementptr inbounds i16, ptr %y, i32 %index
  %wide.load22 = load <8 x i16>, ptr %2, align 2
  %3 = zext <8 x i16> %wide.load22 to <8 x i32>
  %4 = sub nsw <8 x i32> %1, %3
  %5 = icmp slt <8 x i32> %4, zeroinitializer
  %6 = sub nsw <8 x i32> zeroinitializer, %4
  %7 = select <8 x i1> %5, <8 x i32> %6, <8 x i32> %4
  %8 = trunc <8 x i32> %7 to <8 x i16>
  %9 = getelementptr inbounds i16, ptr %z, i32 %index
  store <8 x i16> %8, ptr %9, align 2
  %index.next = add i32 %index, 8
  %10 = icmp eq i32 %index.next, 1024
  br i1 %10, label %for.cond.cleanup, label %vector.body

for.cond.cleanup:                                 ; preds = %vector.body
  ret void
}

define void @vabd_loop_u32(ptr nocapture readonly %x, ptr nocapture readonly %y, ptr noalias nocapture %z, i32 %n) {
; CHECK-LABEL: vabd_loop_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, r7, r8, r9, r10, lr}
; CHECK-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    mov.w lr, #256
; CHECK-NEXT:    vmov.i64 q0, #0xffffffff
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:  .LBB20_1: @ %vector.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    vldrw.u32 q4, [r1], #16
; CHECK-NEXT:    vldrw.u32 q5, [r0], #16
; CHECK-NEXT:    vmov.f32 s8, s18
; CHECK-NEXT:    vmov.f32 s10, s19
; CHECK-NEXT:    vmov.f32 s12, s22
; CHECK-NEXT:    vand q2, q2, q0
; CHECK-NEXT:    vmov.f32 s14, s23
; CHECK-NEXT:    vand q3, q3, q0
; CHECK-NEXT:    vmov r3, r12, d4
; CHECK-NEXT:    vmov r4, r5, d6
; CHECK-NEXT:    vmov.f32 s18, s17
; CHECK-NEXT:    vmov.f32 s22, s21
; CHECK-NEXT:    vand q4, q4, q0
; CHECK-NEXT:    vand q5, q5, q0
; CHECK-NEXT:    vmov r6, r7, d11
; CHECK-NEXT:    subs.w r8, r4, r3
; CHECK-NEXT:    sbc.w r12, r5, r12
; CHECK-NEXT:    vmov r5, r3, d9
; CHECK-NEXT:    subs.w r10, r6, r5
; CHECK-NEXT:    sbc.w r9, r7, r3
; CHECK-NEXT:    vmov r6, r7, d8
; CHECK-NEXT:    vmov r4, r3, d10
; CHECK-NEXT:    subs r4, r4, r6
; CHECK-NEXT:    sbcs r3, r7
; CHECK-NEXT:    vmov q4[2], q4[0], r4, r8
; CHECK-NEXT:    vmov r4, r6, d5
; CHECK-NEXT:    vmov r7, r5, d7
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    subs r4, r7, r4
; CHECK-NEXT:    vmov q4[3], q4[1], r10, r4
; CHECK-NEXT:    mov.w r4, #0
; CHECK-NEXT:    bfi r4, r3, #0, #4
; CHECK-NEXT:    asr.w r3, r9, #31
; CHECK-NEXT:    bfi r4, r3, #4, #4
; CHECK-NEXT:    asr.w r3, r12, #31
; CHECK-NEXT:    bfi r4, r3, #8, #4
; CHECK-NEXT:    sbc.w r3, r5, r6
; CHECK-NEXT:    asrs r3, r3, #31
; CHECK-NEXT:    bfi r4, r3, #12, #4
; CHECK-NEXT:    vmsr p0, r4
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vsubt.i32 q4, q1, q4
; CHECK-NEXT:    vstrb.8 q4, [r2], #16
; CHECK-NEXT:    le lr, .LBB20_1
; CHECK-NEXT:  @ %bb.2: @ %for.cond.cleanup
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, pc}
entry:
  br label %vector.body

vector.body:                                      ; preds = %vector.body, %entry
  %index = phi i32 [ 0, %entry ], [ %index.next, %vector.body ]
  %0 = getelementptr inbounds i32, ptr %x, i32 %index
  %wide.load = load <4 x i32>, ptr %0, align 4
  %1 = zext <4 x i32> %wide.load to <4 x i64>
  %2 = getelementptr inbounds i32, ptr %y, i32 %index
  %wide.load23 = load <4 x i32>, ptr %2, align 4
  %3 = zext <4 x i32> %wide.load23 to <4 x i64>
  %4 = sub nsw <4 x i64> %1, %3
  %5 = icmp slt <4 x i64> %4, zeroinitializer
  %6 = trunc <4 x i64> %4 to <4 x i32>
  %7 = sub <4 x i32> zeroinitializer, %6
  %8 = select <4 x i1> %5, <4 x i32> %7, <4 x i32> %6
  %9 = getelementptr inbounds i32, ptr %z, i32 %index
  store <4 x i32> %8, ptr %9, align 4
  %index.next = add i32 %index, 4
  %10 = icmp eq i32 %index.next, 1024
  br i1 %10, label %for.cond.cleanup, label %vector.body

for.cond.cleanup:                                 ; preds = %vector.body
  ret void
}

define arm_aapcs_vfpcc <4 x i32> @vabd_v4u32_commutative(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: vabd_v4u32_commutative:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vabd.u32 q0, q1, q0
; CHECK-NEXT:    vadd.i32 q0, q0, q0
; CHECK-NEXT:    bx lr
  %azextsrc1 = zext <4 x i32> %src1 to <4 x i64>
  %azextsrc2 = zext <4 x i32> %src2 to <4 x i64>
  %aadd1 = sub <4 x i64> %azextsrc1, %azextsrc2
  %aadd2 = sub <4 x i64> zeroinitializer, %aadd1
  %ac = icmp sge <4 x i64> %aadd1, zeroinitializer
  %as = select <4 x i1> %ac, <4 x i64> %aadd1, <4 x i64> %aadd2
  %aresult = trunc <4 x i64> %as to <4 x i32>
  %bzextsrc1 = zext <4 x i32> %src2 to <4 x i64>
  %bzextsrc2 = zext <4 x i32> %src1 to <4 x i64>
  %badd1 = sub <4 x i64> %bzextsrc1, %bzextsrc2
  %badd2 = sub <4 x i64> zeroinitializer, %badd1
  %bc = icmp sge <4 x i64> %badd1, zeroinitializer
  %bs = select <4 x i1> %bc, <4 x i64> %badd1, <4 x i64> %badd2
  %bresult = trunc <4 x i64> %bs to <4 x i32>
  %r = add <4 x i32> %aresult, %bresult
  ret <4 x i32> %r
}

define arm_aapcs_vfpcc <4 x i32> @vabd_v4u32_shuffle(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: vabd_v4u32_shuffle:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vabd.u32 q1, q0, q1
; CHECK-NEXT:    vmov.f32 s0, s7
; CHECK-NEXT:    vmov.f32 s1, s6
; CHECK-NEXT:    vmov.f32 s2, s5
; CHECK-NEXT:    vmov.f32 s3, s4
; CHECK-NEXT:    bx lr
  %s1 = shufflevector <4 x i32> %src1, <4 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %s2 = shufflevector <4 x i32> %src2, <4 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %azextsrc1 = zext <4 x i32> %s1 to <4 x i64>
  %azextsrc2 = zext <4 x i32> %s2 to <4 x i64>
  %aadd1 = sub <4 x i64> %azextsrc1, %azextsrc2
  %aadd2 = sub <4 x i64> zeroinitializer, %aadd1
  %ac = icmp sge <4 x i64> %aadd1, zeroinitializer
  %as = select <4 x i1> %ac, <4 x i64> %aadd1, <4 x i64> %aadd2
  %aresult = trunc <4 x i64> %as to <4 x i32>
  ret <4 x i32> %aresult
}


define arm_aapcs_vfpcc i16 @vabds_reduce_v16i8(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-LABEL: vabds_reduce_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vabd.s8 q0, q0, q1
; CHECK-NEXT:    vaddv.u8 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %sextsrc1 = sext <16 x i8> %s0 to <16 x i16>
  %sextsrc2 = sext <16 x i8> %s1 to <16 x i16>
  %add1 = sub <16 x i16> %sextsrc1, %sextsrc2
  %add2 = sub <16 x i16> zeroinitializer, %add1
  %c = icmp sge <16 x i16> %add1, zeroinitializer
  %s = select <16 x i1> %c, <16 x i16> %add1, <16 x i16> %add2
  %result = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s)
  ret i16 %result
}

define arm_aapcs_vfpcc i16 @vabdu_reduce_v16i8(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-LABEL: vabdu_reduce_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vabd.u8 q0, q0, q1
; CHECK-NEXT:    vaddv.u8 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %sextsrc1 = zext <16 x i8> %s0 to <16 x i16>
  %sextsrc2 = zext <16 x i8> %s1 to <16 x i16>
  %add1 = sub <16 x i16> %sextsrc1, %sextsrc2
  %add2 = sub <16 x i16> zeroinitializer, %add1
  %c = icmp sge <16 x i16> %add1, zeroinitializer
  %s = select <16 x i1> %c, <16 x i16> %add1, <16 x i16> %add2
  %result = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s)
  ret i16 %result
}

declare i16 @llvm.vector.reduce.add.v16i16(<16 x i16>)
