# -*- coding: utf-8 -*-
# Copyright 2010 - 2020 Alibaba Inc. All Rights Reserved.
# Author:
#
# OB use disjoint table_id ranges to define different kinds of tables:
# - (0, 100)         : Core Table
# - (0, 10000)       : System Table
# - (10000, 15000)   : MySQL Virtual Table
# - (15000, 20000)   : Oracle Virtual Table
# - (20000, 25000)   : MySQL System View
# - (25000, 30000)   : Oracle System View
# - (50000, 60000)   : Lob meta table
# - (60000, 70000)   : Lob piece table
# - (100000, 200000) : System table Index
# - (15305, <20000)  : Oracle Real Agent table Index
# - (500000, ~)      : User Table
#
# Here are some table_name definition principles.
# 1. Be defined by simple present tense, first person.
# 2. Be active and singular.
# 3. System table's table_name should be started with '__all_'.
# 4. Virtual table's table_name should be started with '__all_virtual' or '__tenant_virtual'.
#    Virtual table started with '__all_virtual' can be directly queried by SQL.
#    Virtual table started with '__tenant_virtual' is used for special cmd(such as show cmd), which can't be queried by SQL.
# 5. System view's table_name should be referred from MySQL/Oracle.
# 6. Definition of Oracle Virtual Table/Oracle System View can be referred from document:
#
# 7. Difference between REAL_AGENT and SYS_AGENT:
#     sys_agent access tables belong to sys tenant only
#     real_agent access tables belong to current tenant
# 8. Virtual table system design summary:
#
# 9. For compatibility, when add new column for system table, new column's definition should be "not null + default value" or "nullable".
#    Specially, when column types are as follows:
#    1. double、number：default value is not supported, so new column definition should be "nullable".
#    2. longtext、timestamp：mysql can't cast default value to specified column type, so new column definition should be "nullable".
#
# 添加内部表编码指引详见：
################################################################################

################################################################################
# Column definition:
# - Use [column_name, column_type, nullable, default_value] to specify column definition.
# - Use lowercase to define column names.
# - Define primary keys in rowkey_columns, and define other columns in normal_columns.
#
# Partition definition:
# - Defined by partition_expr and partition_columns.
# - Use [partition_type, expr, partition_num] to define partition_expr.
# - Use [col1, col2, ...] to define partition_columns.
# - Two different partition_type are supported: hash/key
#   - hash: expr means expression.
#   - key: expr means list of partition columns.
# - Distributed virtual table's partition_columns should be [`svr_ip`, `svr_port`].
# - rowkey_columns must contains columns defined in partition_columns.
################################################################################

################################### 占位须知 ###################################
# 占位示例: 顶格写注释，说明要占用哪个TABLE_ID，对应的名字是什么
# TABLE_ID: TABLE_NAME
#
# FARM 会基于占位校验开发分支TABLE_ID和TABLE_NAME是否匹配，如果不匹配，FARM就会拦截报错
#
# 注意：
# 0. 在‘余留位置’之前占位
# 1. 始终先在master占位，保证master分支是其他所有分支的超集，避免NAME和ID冲突
# 2. master占位之后，开发分支上不要变更NAME，否则FARM会认为ID占位冲突，如果有这种场景，需要先修改master占位
# 3. 默认建议采用准确的TABLE_NAME进行占位，TABLE_ID和TABLE_NAME在系统内部是一一对应的
# 4. 部分表是基于其他基表的schema定义的(例如：gen_xx_table_def())，其真实表名比较复杂，为了方便占位，建议采用基表表名进行占位
#    - 示例1：def_table_schema(**gen_mysql_sys_agent_virtual_table_def('12393', all_def_keywords['__all_virtual_long_ops_status']))
#      * 基表表名占位：# 12393: __all_virtual_long_ops_status
#      * 真实表名占位：# 12393: __all_virtual_virtual_long_ops_status_mysql_sys_agent
#    - 示例2：def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15009', all_def_keywords['__all_virtual_sql_audit'])))
#      * 基表表名占位：# 15009: __all_virtual_sql_audit
#      * 真实表名占位：# 15009: ALL_VIRTUAL_SQL_AUDIT
#    - 示例3：def_table_schema(**gen_sys_agent_virtual_table_def('15111', all_def_keywords['__all_routine_param']))
#      * 基表表名占位：# 15111: __all_routine_param
#      * 真实表名占位：# 15111: ALL_VIRTUAL_ROUTINE_PARAM_SYS_AGENT
# 5. 索引表占位要求TABLE_NAME采用以下方式：基表（数据表）表名、索引名(index_name)、真实的索引表表名
#    例如：100001 索引表占位方式可以为：
#       * # 100001: __idx_3_idx_data_table_id
#       * # 100001: idx_data_table_id
#       * # 100001: __all_table
################################################################################

global fields
fields = [
    'tenant_id',
    'tablegroup_id',
    'database_id',
    'table_id',
    'rowkey_split_pos',
    'is_use_bloomfilter',
    'progressive_merge_num',
    'rowkey_column_num', # This field will be calculated by rowkey_columns automatically.
    'load_type',
    'table_type',
    'index_type',
    'def_type',
    'table_name',
    'compress_func_name',
    'part_level',
    'charset_type',
    'collation_type',
    'gm_columns',
    'rowkey_columns',
    'normal_columns',
    'partition_columns',
    'in_tenant_space',
    'view_definition',
    'partition_expr',
    'index',
    'index_using_type',
    'name_postfix',
    'row_store_type',
    'store_format',
    'progressive_merge_round',
    'storage_format_version',
    'is_cluster_private',
    'is_real_virtual_table',
    'owner',
    'vtable_route_policy', # value: only_rs, distributed, local(default)
    'tablet_id',
    'micro_index_clustered'
]

global index_only_fields
index_only_fields = ['index_name', 'index_columns', 'index_status', 'index_type', 'data_table_id', 'storing_columns']

global lob_fields
lob_fields = ['data_table_id']

global default_filed_values
default_filed_values = {
    'tenant_id' : 'OB_SYS_TENANT_ID',
    'tablegroup_id' : 'OB_SYS_TABLEGROUP_ID',
    'database_id' : 'OB_SYS_DATABASE_ID',
    'table_type' : 'MAX_TABLE_TYPE',
    'index_type' : 'INDEX_TYPE_IS_NOT',
    'load_type' : 'TABLE_LOAD_TYPE_IN_DISK',
    'def_type' : 'TABLE_DEF_TYPE_INTERNAL',
    'rowkey_split_pos' : '0',
    'compress_func_name' : 'OB_DEFAULT_COMPRESS_FUNC_NAME',
    'part_level' : 'PARTITION_LEVEL_ZERO',
    'is_use_bloomfilter' : 'false',
    'progressive_merge_num' : '0',
    'charset_type' : 'ObCharset::get_default_charset()',
    'collation_type' : 'ObCharset::get_default_collation(ObCharset::get_default_charset())',
    'in_tenant_space' : False,
    'view_definition' : '',
    'partition_expr' : [],
    'partition_columns' : [],
    'index' : [],
    'index_using_type' : 'USING_BTREE',
    'name_postfix': '',
    'row_store_type': 'ENCODING_ROW_STORE',
    'store_format': 'OB_STORE_FORMAT_DYNAMIC_MYSQL',
    'progressive_merge_round' : '1',
    'storage_format_version' : '3',
    'is_cluster_private': False,
    'is_real_virtual_table': False,
    'owner' : '',
    'vtable_route_policy' : 'local',
    'tablet_id' : '0',
    'micro_index_clustered' : 'false'
}

################################################################################
# System Table(0,10000]
################################################################################

global lob_aux_data_def
lob_aux_data_def = dict (
  owner = 'luohongdi.lhd',
  gm_columns = [],
  rowkey_columns = [
    ('piece_id', 'uint'),
  ],
  normal_columns = [
    ('data_len', 'uint32'),
    ('lob_data', 'varbinary:32'),
  ],
)

global lob_aux_meta_def
lob_aux_meta_def = dict (
  owner = 'luohongdi.lhd',
  gm_columns = [],
  rowkey_columns = [
    ('lob_id', 'varbinary:16'),
    ('seq_id', 'varbinary:8192'),
  ],

  normal_columns = [
    ('binary_len', 'uint32'),
    ('char_len', 'uint32'),
    ('piece_id', 'uint'),
    ('lob_data', 'varbinary:262144'),
  ],
)

#
# Core Table (0, 100]
#
def_table_schema(
    owner = 'yanmu.ztl',
    table_name    = '__all_core_table',
    table_id      = '1',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('table_name', 'varchar:OB_MAX_CORE_TALBE_NAME_LENGTH'),
        ('row_id', 'int'),
        ('column_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
    ],
    in_tenant_space = True,

  normal_columns = [
      ('column_value', 'varchar:OB_OLD_MAX_VARCHAR_LENGTH', 'true'),
  ],
)

# 2: __all_root_table # abandoned in 4.0.

all_table_def = dict(
    owner = 'yanmu.ztl',
    table_name    = '__all_table',
    table_id      = '3',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('table_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH', 'false', ''),
      ('database_id', 'int'),
      ('table_type', 'int'),
      ('load_type', 'int'),
      ('def_type', 'int'),
      ('rowkey_column_num', 'int'),
      ('index_column_num', 'int'),
      ('max_used_column_id', 'int'),
      ('autoinc_column_id', 'int'),
      ('auto_increment', 'uint', 'true', '1'),
      ('read_only', 'int'),
      ('rowkey_split_pos', 'int'),
      ('compress_func_name', 'varchar:OB_MAX_COMPRESSOR_NAME_LENGTH'),
      ('expire_condition', 'varchar:OB_MAX_EXPIRE_INFO_STRING_LENGTH'),
      ('is_use_bloomfilter', 'int'),
      ('comment', 'varchar:MAX_TABLE_COMMENT_LENGTH', 'false', ''),
      ('block_size', 'int'),
      ('collation_type', 'int'),
      ('data_table_id', 'int', 'true'),
      ('index_status', 'int'),
      ('tablegroup_id', 'int'),
      ('progressive_merge_num', 'int'),
      ('index_type', 'int'),
      ('part_level', 'int'),
      ('part_func_type', 'int'),
      ('part_func_expr', 'varchar:OB_MAX_PART_FUNC_EXPR_LENGTH'),
      ('part_num', 'int'),
      ('sub_part_func_type', 'int'),
      ('sub_part_func_expr', 'varchar:OB_MAX_PART_FUNC_EXPR_LENGTH'),
      ('sub_part_num', 'int'),
      ('schema_version', 'int'),
      ('view_definition', 'longtext'),
      ('view_check_option', 'int'),
      ('view_is_updatable', 'int'),
      ('index_using_type', 'int', 'false', 'USING_BTREE'),
      ('parser_name', 'varchar:OB_MAX_PARSER_NAME_LENGTH', 'true'),
      ('index_attributes_set', 'int', 'true', 0),
      ('tablet_size', 'int', 'false', 'OB_DEFAULT_TABLET_SIZE'),
      ('pctfree', 'int', 'false', 'OB_DEFAULT_PCTFREE'),
      ('partition_status', 'int', 'true', '0'),
      ('partition_schema_version', 'int', 'true', '0'),
      ('session_id', 'int', 'true', '0'),
      ('pk_comment', 'varchar:MAX_TABLE_COMMENT_LENGTH', 'false', ''),
      ('sess_active_time', 'int', 'true', '0'),
      ('row_store_type', 'varchar:OB_MAX_STORE_FORMAT_NAME_LENGTH', 'true', 'encoding_row_store'),
      ('store_format', 'varchar:OB_MAX_STORE_FORMAT_NAME_LENGTH', 'true', ''),
      ('duplicate_scope', 'int', 'true', '0'),
      ('progressive_merge_round', 'int', 'true', '0'),
      ('storage_format_version', 'int', 'true', '2'),
      ('table_mode', 'int', 'false', '0'),
      ('encryption', 'varchar:OB_MAX_ENCRYPTION_NAME_LENGTH', 'true', ''),
      ('tablespace_id', 'int', 'false', '-1'),
      ('sub_part_template_flags', 'int', 'false', '0'),
      ("dop", 'int', 'false', '1'),
      ('character_set_client', 'int', 'false', '0'),
      ('collation_connection', 'int', 'false', '0'),
      ('auto_part_size', 'int', 'false', '-1'),
      ('auto_part', 'bool', 'false', 'false'),
      ('association_table_id', 'int', 'false', '-1'),
      ('tablet_id', 'bigint', 'false', 'ObTabletID::INVALID_TABLET_ID'),
      ('max_dependency_version', 'int', 'false', '-1'),
      ('define_user_id', 'int', 'false', '-1'),
      ('transition_point', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('b_transition_point', 'varchar:OB_MAX_B_HIGH_BOUND_VAL_LENGTH', 'true'),
      ('interval_range', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('b_interval_range', 'varchar:OB_MAX_B_HIGH_BOUND_VAL_LENGTH', 'true'),
      ('object_status', 'int', 'false', '1'),
      ('table_flags', 'int', 'false', '0'),
      ('truncate_version', 'int', 'false', '-1'),
      ('external_file_location', 'varbinary:OB_MAX_VARCHAR_LENGTH', 'true'),
      ('external_file_location_access_info', 'varbinary:OB_MAX_VARCHAR_LENGTH', 'true'),
      ('external_file_format', 'varbinary:OB_MAX_VARCHAR_LENGTH', 'true'),
      ('external_file_pattern', 'varbinary:OB_MAX_VARCHAR_LENGTH', 'true'),
      ('ttl_definition', 'varchar:OB_MAX_DEFAULT_VALUE_LENGTH', 'false', ''),
      ('kv_attributes', 'varchar:OB_MAX_DEFAULT_VALUE_LENGTH', 'false', ''),
      ('name_generated_type', 'int', 'false', '0'),
      ('lob_inrow_threshold', 'int', 'false', 'OB_DEFAULT_LOB_INROW_THRESHOLD'),
      ('max_used_column_group_id', 'int', 'false', '1000'),
      ('column_store', 'int', 'false', '0'),
      ('auto_increment_cache_size', 'int', 'false', '0'),
      ('external_properties', 'varbinary:OB_MAX_VARCHAR_LENGTH', 'true'),
      ('local_session_vars', 'longtext', 'true'),
      ('duplicate_read_consistency', 'int', 'false', '0'),
      ('index_params', 'varchar:OB_MAX_INDEX_PARAMS_LENGTH', 'false', ''),
      ('micro_index_clustered', 'bool', 'false', 'false'),
      ('mv_mode', 'int', 'false', '0'),
      ('parser_properties', 'longtext', 'false', ''),
      ('enable_macro_block_bloom_filter', 'bool', 'false', 'false')
    ],
)

def_table_schema(**all_table_def)

all_column_def = dict(
    owner = 'bin.lb',
    table_name    = '__all_column',
    table_id      = '4',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('table_id', 'int'),
        ('column_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('column_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH', 'false', ''),
      ('rowkey_position', 'int', 'false', '0'),
      ('index_position', 'int'),
      ('order_in_rowkey', 'int'),
      ('partition_key_position', 'int'),
      ('data_type', 'int'),
      ('data_length', 'int'),
      ('data_precision', 'int', 'true'),
      ('data_scale', 'int', 'true'),
      ('zero_fill', 'int'),
      ('nullable', 'int'),
      ('on_update_current_timestamp', 'int'),
      ('autoincrement', 'int'),
      ('is_hidden', 'int', 'false', '0'),
      ('collation_type', 'int'),
      ('orig_default_value', 'varchar:OB_MAX_DEFAULT_VALUE_LENGTH', 'true'),
      ('cur_default_value', 'varchar:OB_MAX_DEFAULT_VALUE_LENGTH', 'true'),
      ('comment', 'longtext', 'true'),
      ('schema_version', 'int'),
      ('column_flags', 'int', 'false', '0'),
      ('prev_column_id', 'int', 'false', '-1'),
      ('extended_type_info', 'varbinary:OB_MAX_VARBINARY_LENGTH', 'true'),
      ('orig_default_value_v2', 'varbinary:OB_MAX_DEFAULT_VALUE_LENGTH', 'true'),
      ('cur_default_value_v2', 'varbinary:OB_MAX_DEFAULT_VALUE_LENGTH', 'true'),
      ('srs_id', 'int', 'false', 'OB_DEFAULT_COLUMN_SRS_ID'),
      ('udt_set_id', 'int', 'false', '0'),
      ('sub_data_type', 'int', 'false', '0'),
      ('skip_index_attr', 'int', 'false', '0'),
      ('lob_chunk_size', 'int', 'false', 'OB_DEFAULT_LOB_CHUNK_SIZE'),
      ('local_session_vars', 'longtext', 'true'),
    ],
)

def_table_schema(**all_column_def)

def_table_schema(
    owner = 'yanmu.ztl',
    table_name    = '__all_ddl_operation',
    table_id      = '5',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('schema_version', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('tenant_id', 'int'),
      ('user_id', 'int'),
      ('database_id', 'int'),
      ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
      ('tablegroup_id', 'int'),
      ('table_id', 'int'),
      ('table_name', 'varchar:OB_MAX_CORE_TALBE_NAME_LENGTH'),
      ('operation_type', 'int'),
      ('ddl_stmt_str', 'longtext'),
      ('exec_tenant_id', 'int', 'false', '1'),
    ],

)

# 6: __all_freeze_info  # abandoned in 4.0
# 7: __all_table_v2 # abandoned in 4.0

#
# System Table (100, 1000]
#

# 101: __all_meta_table # abandoned in 4.0

all_user_def = dict(
    owner = 'sean.yyj',
    table_name    = '__all_user',
    table_id      = '102',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('user_id', 'int'),
    ],
    in_tenant_space = True,
    normal_columns = [
      ('user_name', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE'),
      ('host', 'varchar:OB_MAX_HOST_NAME_LENGTH', 'false', '%'),
      ('passwd', 'varchar:OB_MAX_PASSWORD_LENGTH'),
      ('info', 'varchar:OB_MAX_USER_INFO_LENGTH'),
      ('priv_alter', 'int', 'false', '0'),
      ('priv_create', 'int', 'false', '0'),
      ('priv_delete', 'int', 'false', '0'),
      ('priv_drop', 'int', 'false', '0'),
      ('priv_grant_option', 'int', 'false', '0'),
      ('priv_insert', 'int', 'false', '0'),
      ('priv_update', 'int', 'false', '0'),
      ('priv_select', 'int', 'false', '0'),
      ('priv_index', 'int', 'false', '0'),
      ('priv_create_view', 'int', 'false', '0'),
      ('priv_show_view', 'int', 'false', '0'),
      ('priv_show_db', 'int', 'false', '0'),
      ('priv_create_user', 'int', 'false', '0'),
      ('priv_super', 'int', 'false', '0'),
      ('is_locked', 'int'),
      ('priv_process', 'int', 'false', '0'),
      ('priv_create_synonym', 'int', 'false', '0'),
      ('ssl_type', 'int', 'false', '0'),
      ('ssl_cipher', 'varchar:1024', 'false', ''),
      ('x509_issuer', 'varchar:1024', 'false', ''),
      ('x509_subject', 'varchar:1024', 'false', ''),
      ('type', 'int', 'true', 0), #0: user; 1: role
      ('profile_id', 'int', 'false', 'OB_INVALID_ID'),
      ('password_last_changed', 'timestamp', 'true'),
      ('priv_file', 'int', 'false', '0'),
      ('priv_alter_tenant', 'int', 'false', '0'),
      ('priv_alter_system', 'int', 'false', '0'),
      ('priv_create_resource_pool', 'int', 'false', '0'),
      ('priv_create_resource_unit', 'int', 'false', '0'),
      ('max_connections', 'int', 'false', '0'),
      ('max_user_connections', 'int', 'false', '0'),
      ('priv_repl_slave', 'int', 'false', '0'),
      ('priv_repl_client', 'int', 'false', '0'),
      ('priv_drop_database_link', 'int', 'false', '0'),
      ('priv_create_database_link', 'int', 'false', '0'),
      ('priv_others', 'int', 'false', '0'),
      ('flags', 'int', 'false', '0'),
    ],
)

def_table_schema(**all_user_def)

def_table_schema(**gen_history_table_def(103, all_user_def))

all_database_def = dict(
    owner = 'yanmu.ztl',
    table_name    = '__all_database',
    table_id      = '104',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('database_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false', ''),
      ('collation_type', 'int'),
      ('comment', 'varchar:MAX_DATABASE_COMMENT_LENGTH'),
      ('read_only', 'int'),
      ('default_tablegroup_id', 'int', 'false', 'OB_INVALID_ID'),
      ('in_recyclebin', 'int', 'false', '0'),
    ],
)

def_table_schema(**all_database_def)

def_table_schema(**gen_history_table_def(105, all_database_def))

all_tablegroup_def = dict(
    owner = 'yanmu.ztl',
    table_name    = '__all_tablegroup',
    table_id      = '106',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('tablegroup_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('tablegroup_name', 'varchar:OB_MAX_TABLEGROUP_NAME_LENGTH'),
      ('comment', 'varchar:MAX_TABLEGROUP_COMMENT_LENGTH'),
      ('part_level', 'int', 'false', '0'),
      ('part_func_type', 'int', 'false', '0'),
      ('part_func_expr_num', 'int', 'false', '0'),
      ('part_num', 'int', 'false', '0'),
      ('sub_part_func_type', 'int', 'false', '0'),
      ('sub_part_func_expr_num', 'int', 'false', '0'),
      ('sub_part_num', 'int', 'false', '0'),
      ('schema_version', 'int'),
      ('partition_status', 'int', 'true', '0'),
      ('partition_schema_version', 'int', 'true', '0'),
      ('sub_part_template_flags', 'int', 'false', '0'),
      ('sharding', 'varchar:OB_MAX_PARTITION_SHARDING_LENGTH', 'false', 'ADAPTIVE'),
    ],
)

def_table_schema(**all_tablegroup_def)

def_table_schema(**gen_history_table_def(107, all_tablegroup_def))

all_tenant_def = dict(
    owner = 'yanmu.ztl',
    table_name    = '__all_tenant',
    table_type = 'SYSTEM_TABLE',
    table_id      = '108',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
    ],

  normal_columns = [
      ('tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE'),
      ('zone_list', 'varchar:MAX_ZONE_LIST_LENGTH'),
      ('primary_zone', 'varchar:MAX_ZONE_LIST_LENGTH', 'true'),
      ('locked', 'int'),
      ('collation_type', 'int'),
      ('info', 'varchar:OB_MAX_TENANT_INFO_LENGTH'),
      ('locality', 'varchar:MAX_LOCALITY_LENGTH', 'false', ''),
      ('previous_locality', 'varchar:MAX_LOCALITY_LENGTH', 'false', ''),
      ('default_tablegroup_id', 'int', 'false', 'OB_INVALID_ID'),
      ('compatibility_mode', 'int', 'false', '0'),
      ('drop_tenant_time', 'int', 'false', 'OB_INVALID_TIMESTAMP'),
      ('status', 'varchar:MAX_TENANT_STATUS_LENGTH', 'false', 'NORMAL'),
      ('in_recyclebin', 'int', 'false', '0'),
      ('arbitration_service_status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false', 'DISABLED'),
  ],
)

def_table_schema(**all_tenant_def)

def_table_schema(**gen_history_table_def(109, all_tenant_def))

all_table_privilege_def = dict(
    owner = 'sean.yyj',
    table_name    = '__all_table_privilege',
    table_id      = '110',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('user_id', 'int'),
        ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
        ('table_name', 'varchar:OB_MAX_CORE_TALBE_NAME_LENGTH'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('priv_alter', 'int', 'false', '0'),
      ('priv_create', 'int', 'false', '0'),
      ('priv_delete', 'int', 'false', '0'),
      ('priv_drop', 'int', 'false', '0'),
      ('priv_grant_option', 'int', 'false', '0'),
      ('priv_insert', 'int', 'false', '0'),
      ('priv_update', 'int', 'false', '0'),
      ('priv_select', 'int', 'false', '0'),
      ('priv_index', 'int', 'false', '0'),
      ('priv_create_view', 'int', 'false', '0'),
      ('priv_show_view', 'int', 'false', '0'),
      ('priv_others', 'int', 'false', '0'),
      ('grantor', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE', 'true'),
      ('grantor_host', 'varchar:OB_MAX_HOST_NAME_LENGTH', 'true'),
    ],
)

def_table_schema(**all_table_privilege_def)

def_table_schema(**gen_history_table_def(111, all_table_privilege_def))

all_database_privilege_def = dict(
    owner = 'sean.yyj',
    table_name    = '__all_database_privilege',
    table_id      = '112',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('user_id', 'int'),
        ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('priv_alter', 'int', 'false', '0'),
      ('priv_create', 'int', 'false', '0'),
      ('priv_delete', 'int', 'false', '0'),
      ('priv_drop', 'int', 'false', '0'),
      ('priv_grant_option', 'int', 'false', '0'),
      ('priv_insert', 'int', 'false', '0'),
      ('priv_update', 'int', 'false', '0'),
      ('priv_select', 'int', 'false', '0'),
      ('priv_index', 'int', 'false', '0'),
      ('priv_create_view', 'int', 'false', '0'),
      ('priv_show_view', 'int', 'false', '0'),
      ('priv_others', 'int', 'false', '0'),
    ],
)

def_table_schema(**all_database_privilege_def)

def_table_schema(**gen_history_table_def(113, all_database_privilege_def))

def_table_schema(**gen_history_table_def(114, all_table_def))

def_table_schema(**gen_history_table_def(115, all_column_def))

def_table_schema(
    owner = 'quanwei.wqw',
    table_name    = '__all_zone',
    table_id      = '116',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('zone', 'varchar:MAX_ZONE_LENGTH'),
        ('name', 'varchar:TABLE_MAX_KEY_LENGTH'),
    ],

  normal_columns = [
      ('value', 'int'),
      ('info', 'varchar:MAX_ZONE_INFO_LENGTH'),
  ],
)

def_table_schema(
    owner = 'wanhong.wwh',
    table_name    = '__all_server',
    table_id      = '117',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
    ],

  normal_columns = [
      ('id', 'int'),
      ('zone', 'varchar:MAX_ZONE_LENGTH'),
      ('inner_port', 'int'),
      ('with_rootserver', 'int'),
      ('status', 'varchar:OB_SERVER_STATUS_LENGTH'),
      ('block_migrate_in_time', 'int'),
      ('build_version', 'varchar:OB_SERVER_VERSION_LENGTH'),
      ('stop_time', 'int', 'false', '0'),
      ('start_service_time', 'int'),
      ('first_sessid', 'int', 'false', '0'),
      ('with_partition', 'int', 'false', '0'),
      ('last_offline_time', 'int', 'false', '0'),
  ],
)

def_table_schema(
    owner = 'fyy280124',
    table_name    = '__all_sys_parameter',
    table_id      = '118',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('zone', 'varchar:MAX_ZONE_LENGTH'),
        ('svr_type', 'varchar:SERVER_TYPE_LENGTH'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
        ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN'),
    ],

  normal_columns = [
      ('data_type', 'varchar:OB_MAX_CONFIG_TYPE_LENGTH', 'true'),
      ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN'),
      ('value_strict', 'varchar:OB_MAX_EXTRA_CONFIG_LENGTH', 'true'),
      ('info', 'varchar:OB_MAX_CONFIG_INFO_LEN'),
      ('need_reboot', 'int', 'true'),
      ('section', 'varchar:OB_MAX_CONFIG_SECTION_LEN', 'true'),
      ('visible_level', 'varchar:OB_MAX_CONFIG_VISIBLE_LEVEL_LEN', 'true'),
      ('config_version', 'int'),
      ('scope', 'varchar:OB_MAX_CONFIG_SCOPE_LEN', 'true'),
      ('source', 'varchar:OB_MAX_CONFIG_SOURCE_LEN', 'true'),
      ('edit_level', 'varchar:OB_MAX_CONFIG_EDIT_LEVEL_LEN', 'true'),
  ],
)

def_table_schema(
    owner = 'fyy280124',
    table_name = '__tenant_parameter',
    table_id   = '119',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('zone', 'varchar:MAX_ZONE_LENGTH'),
        ('svr_type', 'varchar:SERVER_TYPE_LENGTH'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
        ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN'),
    ],
    in_tenant_space = True,
    is_cluster_private = True,
    meta_record_in_sys = False,
    normal_columns = [
        ('data_type', 'varchar:OB_MAX_CONFIG_TYPE_LENGTH', 'true'),
        ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN'),
        ('info', 'varchar:OB_MAX_CONFIG_INFO_LEN'),
        ('section', 'varchar:OB_MAX_CONFIG_SECTION_LEN', 'true'),
        ('scope', 'varchar:OB_MAX_CONFIG_SCOPE_LEN', 'true'),
        ('source', 'varchar:OB_MAX_CONFIG_SOURCE_LEN', 'true'),
        ('edit_level', 'varchar:OB_MAX_CONFIG_EDIT_LEVEL_LEN', 'true'),
        ('config_version', 'int'),
    ],
)

all_sys_variable_def= dict(
    owner = 'xiaochu.yh',
    table_name     = '__all_sys_variable',
    table_id       = '120',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('zone', 'varchar:MAX_ZONE_LENGTH'),
        ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN', 'false', ''),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('data_type', 'int'),
      ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN', 'true'),
      ('info', 'varchar:OB_MAX_CONFIG_INFO_LEN'),
      ('flags', 'int'),
      ('min_val', 'varchar:OB_MAX_CONFIG_VALUE_LEN', 'false', ''),
      ('max_val', 'varchar:OB_MAX_CONFIG_VALUE_LEN', 'false', ''),
    ],
)
def_table_schema(**all_sys_variable_def)

def_table_schema(
    owner = 'yanmu.ztl',
    table_name     = '__all_sys_stat',
    table_id       = '121',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('zone', 'varchar:MAX_ZONE_LENGTH'),
        ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('data_type', 'int'),
      ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN'),
      ('info', 'varchar:OB_MAX_CONFIG_INFO_LEN'),
    ],
)

# 122: __all_column_statistic # abandoned in 4.0

def_table_schema(
    owner = 'wanhong.wwh',
    table_name    = '__all_unit',
    table_id      = '123',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('unit_id', 'int'),
    ],
    normal_columns = [
        ('resource_pool_id', 'int'),
        ('unit_group_id', 'int'),
        ('zone', 'varchar:MAX_ZONE_LENGTH'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
        ('migrate_from_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('migrate_from_svr_port', 'int'),
        ('manual_migrate', 'bool', 'true', '0'),
        ('status', 'varchar:MAX_UNIT_STATUS_LENGTH', 'false', 'ACTIVE'),
    ],
)

def_table_schema(
    owner = 'wanhong.wwh',
    table_name    = '__all_unit_config',
    table_id      = '124',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('unit_config_id', 'int'),
    ],
    normal_columns = [
        ('name', 'varchar:MAX_UNIT_CONFIG_LENGTH'),
        ('max_cpu', 'double'),
        ('min_cpu', 'double'),
        ('memory_size', 'int'),
        ('log_disk_size', 'int'),
        ('max_iops', 'int'),
        ('min_iops', 'int'),
        ('iops_weight', 'int'),
        ('data_disk_size', 'int', 'false', '-1'),
        ('max_net_bandwidth', 'int', 'false', '9223372036854775807'), # INT64_MAX
        ('net_bandwidth_weight', 'int', 'false', '0'),
    ],
)

def_table_schema(
    owner = 'wanhong.wwh',
    table_name    = '__all_resource_pool',
    table_id      = '125',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('resource_pool_id', 'int'),
    ],
    normal_columns = [
        ('name', 'varchar:MAX_RESOURCE_POOL_LENGTH'),
        ('unit_count', 'int'),
        ('unit_config_id', 'int'),
        ('zone_list', 'varchar:MAX_ZONE_LIST_LENGTH'),
        ('tenant_id', 'int'),
        ('replica_type', 'int', 'false', '0'),
        ('is_tenant_sys_pool', 'bool', 'false', 'false')
    ],
)

def_table_schema(
    owner = 'jim.wjh',
    table_name = '__all_charset',
    table_id = '128',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
        ('charset', 'varchar:MAX_CHARSET_LENGTH', 'false', ''),
    ],
    normal_columns = [
        ('description', 'varchar:MAX_CHARSET_DESCRIPTION_LENGTH', 'false', ''),
        ('default_collation', 'varchar:MAX_COLLATION_LENGTH', 'false', ''),
        ('max_length', 'int', 'false', '0'),
    ]
)

def_table_schema(
    owner = 'jim.wjh',
    table_name = '__all_collation',
    table_id = '129',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
        ('collation', 'varchar:MAX_COLLATION_LENGTH', 'false', ''),
    ],
    normal_columns = [
        ('charset', 'varchar:MAX_CHARSET_LENGTH', 'false', ''),
        ('id', 'int', 'false', '0'),
        ('is_default', 'varchar:MAX_BOOL_STR_LENGTH', 'false', ''),
        ('is_compiled', 'varchar:MAX_BOOL_STR_LENGTH', 'false', ''),
        ('sortlen', 'int', 'false', '0'),
    ]
)

def_table_schema(
  owner = 'bin.lb',
  database_id    = 'OB_MYSQL_SCHEMA_ID',
  table_name     = 'help_topic',
  table_id       = '130',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('help_topic_id', 'int','false'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('name', 'varchar:64','false'),
  ('help_category_id', 'int','false'),
  ('description', 'varchar:65535','false'),
  ('example', 'varchar:65535','false'),
  ('url', 'varchar:65535','false'),
  ],
)

def_table_schema(
  owner = 'bin.lb',
  database_id    = 'OB_MYSQL_SCHEMA_ID',
  table_name     = 'help_category',
  table_id       = '131',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('help_category_id', 'int','false'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('name', 'varchar:64','false'),
  ('parent_category_id', 'int','true'),
  ('url', 'varchar:65535','false'),
  ],
)

def_table_schema(
  owner = 'bin.lb',
  database_id    = 'OB_MYSQL_SCHEMA_ID',
  table_name     = 'help_keyword',
  table_id       = '132',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('help_keyword_id', 'int','false'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('name', 'varchar:64','false'),
  ],
)

def_table_schema(
  owner = 'bin.lb',
  database_id    = 'OB_MYSQL_SCHEMA_ID',
  table_name     = 'help_relation',
  table_id       = '133',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('help_topic_id', 'int','false'),
  ('help_keyword_id', 'int','false'),
  ],
  in_tenant_space = True,

  normal_columns = [],
)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name     = '__all_dummy',
  table_id       = '135',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('key', 'int')
  ],
  in_tenant_space = True,

  normal_columns = [],
)

# 137: __all_clog_history_info # abandoned in 4.0

# 139: __all_clog_history_info_v2 # abandoned in 4.0

def_table_schema(
    owner = 'msy164651',
    table_name = '__all_rootservice_event_history',
    table_id = '140',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
      ('gmt_create', 'timestamp:6', 'false')
    ],
    normal_columns = [
      ('module', 'varchar:MAX_ROOTSERVICE_EVENT_DESC_LENGTH', 'false'),
      ('event', 'varchar:MAX_ROOTSERVICE_EVENT_DESC_LENGTH', 'false'),
      ('name1', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value1', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('name2', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value2', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('name3', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value3', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('name4', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value4', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('name5', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value5', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('name6', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value6', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('extra_info', 'varchar:MAX_ROOTSERVICE_EVENT_EXTRA_INFO_LENGTH', 'true', ''),
      ('rs_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true', ''),
      ('rs_svr_port', 'int', 'true', '0'),
    ],
)

def_table_schema(
  owner = 'sean.yyj',
  table_name = '__all_privilege',
  table_id = '141',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
    ('Privilege', 'varchar:MAX_COLUMN_PRIVILEGE_LENGTH'),
  ],
  normal_columns = [
    ('Context', 'varchar:MAX_PRIVILEGE_CONTEXT_LENGTH'),
    ('Comment', 'varchar:MAX_COLUMN_COMMENT_LENGTH'),
  ]
)

all_outline_def = dict(
    owner = 'xiaoyi.xy',
    table_name    = '__all_outline',
    table_id      = '142',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('outline_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('database_id', 'int'),
      ('schema_version', 'int'),
      ('name', 'varchar:OB_MAX_OUTLINE_NAME_LENGTH', 'false', ''),
      ('signature', 'varbinary:OB_MAX_OUTLINE_SIGNATURE_LENGTH', 'false', ''),
      ('outline_content', 'longtext', 'false'),
      ('sql_text', 'longtext', 'false'),
      ('owner', 'varchar:OB_MAX_USERNAME_LENGTH', 'false', ''),
      ('used', 'int', 'false', '0'),
      ('version', 'varchar:OB_SERVER_VERSION_LENGTH', 'false', ''),
      ('compatible', 'int', 'false', '1'),
      ('enabled', 'int', 'false', '1'),
      ('format', 'int', 'false', '0'),
      ('outline_params', 'varbinary:OB_MAX_OUTLINE_PARAMS_LENGTH', 'false', ''),
      ('outline_target', 'longtext', 'false'),
      ('sql_id', 'varbinary:OB_MAX_SQL_ID_LENGTH', 'false', ''),
      ('owner_id', 'int', 'true'),
      ('format_sql_text', 'longtext', 'true'),
      ('format_sql_id', 'varbinary:OB_MAX_SQL_ID_LENGTH', 'false', ''),
      ('format_outline', 'int', 'false', '0')
    ],
)

def_table_schema(**all_outline_def)

def_table_schema(**gen_history_table_def(143, all_outline_def))

# 144: __all_election_event_history # abandoned in 4.0

def_table_schema(
  owner = 'bin.lb',
  table_name = '__all_recyclebin',
  table_id = '145',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create'],
  in_tenant_space = True,
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('object_name', 'varchar:OB_MAX_OBJECT_NAME_LENGTH'),
    ('type', 'int'),
  ],

  normal_columns = [
    ('database_id', 'int'),
    ('table_id', 'int'),
    ('tablegroup_id', 'int'),
    ('original_name', 'varchar:OB_MAX_ORIGINAL_NANE_LENGTH'),
  ],
)

all_part_def = dict(
    owner = 'yanmu.ztl',
    table_name    = '__all_part',
    table_id      = '146',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('table_id', 'int'),
        ('part_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('part_name', 'varchar:OB_MAX_PARTITION_NAME_LENGTH', 'false', ''),
      ('schema_version', 'int'),
      ('high_bound_val', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('b_high_bound_val', 'varchar:OB_MAX_B_HIGH_BOUND_VAL_LENGTH', 'true'),
      ('sub_part_num', 'int', 'true'),
      ('sub_part_space', 'int', 'true'),
      ('new_sub_part_space', 'int', 'true'),
      ('sub_part_interval', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('sub_interval_start', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('new_sub_part_interval', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('new_sub_interval_start', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('block_size', 'int', 'true'),
      ('compress_func_name', 'varchar:OB_MAX_COMPRESSOR_NAME_LENGTH', 'true'),
      ('status', 'int', 'true'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'varchar:OB_OLD_MAX_VARCHAR_LENGTH', 'true'),
      ('comment', 'varchar:OB_MAX_PARTITION_COMMENT_LENGTH', 'true'),
      ('list_val', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('b_list_val', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH', 'true'),
      ('part_idx', 'int', 'true'),
      ('source_partition_id', 'varchar:MAX_VALUE_LENGTH', 'true', ''),
      ('tablespace_id', 'int', 'false', '-1'),
      ('partition_type', 'int', 'false', '0'),
      ('tablet_id', 'bigint', 'false', 'ObTabletID::INVALID_TABLET_ID'),
      ('external_location', 'varbinary:OB_MAX_VARBINARY_LENGTH', 'true'),
    ],
)

def_table_schema(**all_part_def)

def_table_schema(**gen_history_table_def(147, all_part_def))

all_sub_part_def = dict(
    owner = 'yanmu.ztl',
    table_name    = '__all_sub_part',
    table_id      = '148',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('table_id', 'int'),
        ('part_id', 'int'),
        ('sub_part_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('sub_part_name', 'varchar:OB_MAX_PARTITION_NAME_LENGTH', 'false', ''),
      ('schema_version', 'int'),
      ('high_bound_val', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('b_high_bound_val', 'varchar:OB_MAX_B_HIGH_BOUND_VAL_LENGTH', 'true'),
      ('block_size', 'int', 'true'),
      ('compress_func_name', 'varchar:OB_MAX_COMPRESSOR_NAME_LENGTH', 'true'),
      ('status', 'int', 'true'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'varchar:OB_OLD_MAX_VARCHAR_LENGTH', 'true'),
      ('comment', 'varchar:OB_MAX_PARTITION_COMMENT_LENGTH', 'true'),
      ('list_val', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('b_list_val', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH', 'true'),
      ('tablespace_id', 'int', 'false', '-1'),
      ('sub_part_idx', 'int', 'false', '-1'),
      ('source_partition_id', 'varchar:MAX_VALUE_LENGTH', 'false', ''),
      ('partition_type', 'int', 'false', '0'),
      ('tablet_id', 'bigint', 'false', 'ObTabletID::INVALID_TABLET_ID')
    ],
)

def_table_schema(**all_sub_part_def)

def_table_schema(**gen_history_table_def(149, all_sub_part_def))

all_part_info_def = dict(
    owner = 'yanmu.ztl',
    table_name    = '__all_part_info',
    table_id      = '150',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('table_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('part_type', 'int', 'false'),
      ('schema_version', 'int'),
      ('part_num', 'int', 'false'),
      ('part_space', 'int', 'false'),
      ('new_part_space', 'int', 'true'),
      ('sub_part_type', 'int', 'true'),
      ('def_sub_part_num', 'int', 'true'),
      ('part_expr', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('sub_part_expr', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('part_interval', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('interval_start', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('new_part_interval', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('new_interval_start', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('def_sub_part_interval', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('def_sub_interval_start', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('new_def_sub_part_interval', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('new_def_sub_interval_start', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('block_size', 'int', 'true'),
      ('compress_func_name', 'varchar:OB_MAX_COMPRESSOR_NAME_LENGTH', 'true'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'varchar:OB_OLD_MAX_VARCHAR_LENGTH', 'true'),
    ],
)

def_table_schema(**all_part_info_def)

def_table_schema(**gen_history_table_def(151, all_part_info_def))

# TODO: abandoned
all_def_sub_part_def = dict(
    owner = 'yanmu.ztl',
    table_name    = '__all_def_sub_part',
    table_id      = '152',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('table_id', 'int'),
        ('sub_part_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('sub_part_name', 'varchar:OB_MAX_PARTITION_NAME_LENGTH', 'false', ''),
      ('schema_version', 'int'),
      ('high_bound_val', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('b_high_bound_val', 'varchar:OB_MAX_B_HIGH_BOUND_VAL_LENGTH', 'true'),
      ('block_size', 'int', 'true'),
      ('compress_func_name', 'varchar:OB_MAX_COMPRESSOR_NAME_LENGTH', 'true'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'varchar:OB_OLD_MAX_VARCHAR_LENGTH', 'true'),
      ('comment', 'varchar:OB_MAX_PARTITION_COMMENT_LENGTH', 'true'),
      ('list_val', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH', 'true'),
      ('b_list_val', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH', 'true'),
      ('sub_part_idx', 'int', 'true'),
      ('source_partition_id', 'varchar:MAX_VALUE_LENGTH', 'true', ''),
      ('tablespace_id', 'int', 'false', '-1')
    ],
)

def_table_schema(**all_def_sub_part_def)

def_table_schema(**gen_history_table_def(153, all_def_sub_part_def))

def_table_schema(
    owner = 'msy164651',
    table_name = '__all_server_event_history',
    table_id = '154',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
        ('gmt_create', 'timestamp:6', 'false'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
    ],

    normal_columns = [
      ('module', 'varchar:MAX_ROOTSERVICE_EVENT_DESC_LENGTH', 'false'),
      ('event', 'varchar:MAX_ROOTSERVICE_EVENT_DESC_LENGTH', 'false'),
      ('name1', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value1', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('name2', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value2', 'longtext', 'true'),
      ('name3', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value3', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('name4', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value4', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('name5', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value5', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('name6', 'varchar:MAX_ROOTSERVICE_EVENT_NAME_LENGTH', 'true', ''),
      ('value6', 'varchar:MAX_ROOTSERVICE_EVENT_VALUE_LENGTH', 'true', ''),
      ('extra_info', 'varchar:MAX_ROOTSERVICE_EVENT_EXTRA_INFO_LENGTH', 'true', ''),
    ],
)

def_table_schema(
    owner = 'msy164651',
    table_name = '__all_rootservice_job',
    table_id = '155',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('job_id', 'int')
    ],
    normal_columns = [
        ('job_type', 'varchar:128', 'false'),
        ('job_status', 'varchar:128', 'false'),
        ('result_code', 'int', 'true'),
        ('progress', 'int', 'false', '0'),
        ('tenant_id', 'int', 'true'),
        ('tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE', 'true'),
        ('database_id', 'int', 'true'),
        ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true'),
        ('table_id', 'int', 'true'),
        ('table_name', 'varchar:OB_MAX_CORE_TALBE_NAME_LENGTH', 'true'),
        ('partition_id', 'int', 'true'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
        ('svr_port', 'int', 'true'),
        ('unit_id', 'int', 'true'),
        ('rs_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
        ('rs_svr_port', 'int', 'false'),
        ('sql_text', 'longtext', 'true'),
        ('extra_info', 'varchar:MAX_ROOTSERVICE_JOB_EXTRA_INFO_LENGTH', 'true'),
        ('resource_pool_id', 'int', 'true'),
        ('tablegroup_id', 'int', 'true'),
        ('tablegroup_name', 'varchar:OB_MAX_TABLEGROUP_NAME_LENGTH', 'true'),
    ],
)

# 156: __all_unit_load_history # abandoned in 4.0.

all_sys_variable_history_def= dict(
    owner = 'xiaochu.yh',
    table_name     = '__all_sys_variable_history',
    table_id       = '157',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('zone', 'varchar:MAX_ZONE_LENGTH'),
        ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN', 'false', ''),
        ('schema_version', 'int')
    ],
    in_tenant_space = True,
    normal_columns = [
      ('is_deleted', 'int', 'false'),
      ('data_type', 'int'),
      ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN', 'true'),
      ('info', 'varchar:OB_MAX_CONFIG_INFO_LEN'),
      ('flags', 'int'),
      ('min_val', 'varchar:OB_MAX_CONFIG_VALUE_LEN', 'false', ''),
      ('max_val', 'varchar:OB_MAX_CONFIG_VALUE_LEN', 'false', ''),
    ],
)
def_table_schema(**all_sys_variable_history_def)

def_table_schema(
    owner = 'yanmu.ztl',
    table_name = '__all_restore_job',
    table_id = '158',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
      ('tenant_id', 'int'),
      ('job_id', 'int'),
      ('name', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
      ],

    in_tenant_space = True,
    is_cluster_private = True,
    meta_record_in_sys = False,

    normal_columns = [
      ('value', 'longtext', 'true', ''),
      ],
)

# 159: __all_restore_task # abandoned in 4.0

# __all_restore_job_history
all_restore_job_history_def = dict(
  owner = 'wangxiaohui.wxh',
  table_name    = '__all_restore_job_history',
  table_id      = '160',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_id', 'int'),
  ],

  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('initiator_job_id', 'int'),
    ('initiator_tenant_id', 'int'),
    ('restore_type', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'false', ''),
    ('restore_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE', 'false', ''),
    ('restore_tenant_id', 'int', 'false', '-1'),
    ('backup_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE', 'false', ''),
    ('backup_tenant_id', 'int', 'false', '-1'),
    ('backup_cluster_name', 'varchar:OB_MAX_CLUSTER_NAME_LENGTH', 'false', ''),
    ('backup_dest', 'longtext'),
    ('restore_scn', 'uint'),
    ('restore_option', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('table_list', 'longtext', 'true'),
    ('remap_table_list', 'longtext', 'true'),
    ('database_list', 'longtext', 'true'),
    ('remap_database_list', 'longtext', 'true'),
    ('start_time', 'timestamp', 'true'),
    ('finish_time', 'timestamp', 'true'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false', 'INVALID'),
    ('backup_piece_list', 'longtext'),
    ('backup_set_list', 'longtext'),
    ('backup_cluster_version', 'int'),
    ('ls_count', 'int'),
    ('finish_ls_count', 'int'),
    ('tablet_count', 'int'),
    ('finish_tablet_count', 'int'),
    ('total_bytes', 'int'),
    ('finish_bytes', 'int'),
    ('description', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH', 'true'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH', 'true'),
  ],
)
def_table_schema(**all_restore_job_history_def)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name     = '__all_ddl_id',
  table_id       = '165',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int', 'false'),
      ('ddl_id_str', 'varchar:OB_MAX_DDL_ID_STR_LENGTH', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('ddl_stmt_str', 'longtext'),
  ],
)

all_foreign_key_def = dict(
  owner = 'webber.wb',
  table_name    = '__all_foreign_key',
  table_id      = '166',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('foreign_key_id', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('foreign_key_name', 'varchar:OB_MAX_CONSTRAINT_NAME_LENGTH_ORACLE', 'false', ''),
    ('child_table_id', 'int'),
    ('parent_table_id', 'int'),
    ('update_action', 'int'),
    ('delete_action', 'int'),
    ('ref_cst_type', 'int', 'false', '0'),
    ('ref_cst_id', 'int', 'false', '-1'),
    ('rely_flag', 'bool', 'false', 'false'),
    ('enable_flag', 'bool', 'false', 'true'),
    ('validate_flag', 'int', 'false', '1'),
    ('is_parent_table_mock', 'bool', 'false', 'false'),
    ('name_generated_type', 'int', 'false', '0'),
  ],
)

def_table_schema(**all_foreign_key_def)

def_table_schema(**gen_history_table_def(167, all_foreign_key_def))

all_foreign_key_column_def = dict(
  owner = 'webber.wb',
  table_name    = '__all_foreign_key_column',
  table_id      = '168',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('foreign_key_id', 'int'),
    ('child_column_id', 'int'),
    ('parent_column_id', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
   ('position', 'int', 'false', '0'),
  ],
)

def_table_schema(**all_foreign_key_column_def)

def_table_schema(**gen_history_table_def(169, all_foreign_key_column_def))

all_synonym_def = dict(
  owner = 'xiaoyi.xy',
  table_name    = '__all_synonym',
  table_id      = '180',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
  ('tenant_id', 'int'),
  ('synonym_id', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('database_id', 'int'),
  ('schema_version', 'int'),
  ('synonym_name', 'varchar:OB_MAX_SYNONYM_NAME_LENGTH', 'false', ''),
  ('object_name', 'varchar:OB_MAX_SYNONYM_NAME_LENGTH', 'false', ''),
  ('object_database_id', 'int'),
  ('status', 'int', 'false', '1'),
  ],
)

def_table_schema(**all_synonym_def)

def_table_schema(**gen_history_table_def(181, all_synonym_def))

def_table_schema(
    owner = 'xiaochu.yh',
    table_name     = '__all_auto_increment',
    table_id       = '182',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('sequence_key', 'int'),
        ('column_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('tenant_id', 'int'),
      ('sequence_name', 'varchar:OB_MAX_SEQUENCE_NAME_LENGTH', 'true'),
      ('sequence_value', 'uint', 'true'),
      ('sync_value', 'uint'),
      ('truncate_version', 'int', 'false', '-1'),
    ],
)

# 183: __all_tenant_meta_table # abandoned in 4.0.

def_table_schema(
  owner = 'zhenjiang.xzj',
  table_name     = '__all_ddl_checksum',
  table_id       = '188',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
  ('tenant_id', 'int'),
  ('table_id', 'int'),
  ('execution_id', 'int'),
  ('ddl_task_id', 'int'),
  ('column_id', 'int'),
  ('task_id', 'int'),
  ],

  is_cluster_private = False,
  in_tenant_space = True,

  normal_columns = [
  ('checksum', 'int'),
  ('tablet_id', 'int', 'false', 0),
  ],
)

all_routine_def = dict(
    owner = 'linlin.xll',
    table_name    = '__all_routine',
    table_id      = '189',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('routine_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('database_id', 'int', 'false'),
      ('package_id', 'int', 'false'),
      ('routine_name', 'varchar:OB_MAX_ROUTINE_NAME_LENGTH'),
      ('overload', 'int'),
      ('subprogram_id', 'int', 'false'),
      ('schema_version', 'int'),
      ('routine_type', 'int', 'false'),
      ('flag', 'int', 'false'),
      ('owner_id', 'int', 'false'),
      ('priv_user', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE', 'true'),
      ('comp_flag', 'int', 'true'),
      ('exec_env', 'varchar:OB_MAX_PROC_ENV_LENGTH', 'true'),
      ('routine_body', 'longtext', 'true'),
      ('comment', 'varchar:MAX_TENANT_COMMENT_LENGTH', 'true'),
      ('route_sql', 'longtext', 'true'),
      ('type_id', 'int', 'true', 'OB_INVALID_ID')
    ],
)

def_table_schema(**all_routine_def)

def_table_schema(**gen_history_table_def(190, all_routine_def))

all_routine_param_def = dict(
    owner = 'linlin.xll',
    table_name    = '__all_routine_param',
    table_id      = '191',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('routine_id', 'int'),
        ('sequence', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('subprogram_id', 'int', 'false'),
      ('param_position', 'int', 'false'),
      ('param_level', 'int', 'false'),
      ('param_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH', 'true', ''),
      ('schema_version', 'int'),
      ('param_type', 'int', 'false'),
      ('param_length', 'int'),
      ('param_precision', 'int', 'true'),
      ('param_scale', 'int', 'true'),
      ('param_zero_fill', 'int'),
      ('param_charset', 'int', 'true'),
      ('param_coll_type', 'int'),
      ('flag', 'int', 'false'),
      ('default_value', 'varchar:OB_MAX_DEFAULT_VALUE_LENGTH', 'true'),
      ('type_owner', 'int', 'true'),
      ('type_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH', 'true', ''),
      ('type_subname', 'varchar:OB_MAX_COLUMN_NAME_LENGTH', 'true', ''),
      ('extended_type_info', "varbinary:OB_MAX_VARBINARY_LENGTH", 'true', '')
    ],
)

def_table_schema(**all_routine_param_def)
def_table_schema(**gen_history_table_def(192, all_routine_param_def))

all_package_def = dict(
    owner = 'linlin.xll',
    table_name    = '__all_package',
    table_id      = '196',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('package_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('database_id', 'int', 'false'),
      ('package_name', 'varchar:OB_MAX_PACKAGE_NAME_LENGTH', 'false', ''),
      ('schema_version', 'int', 'false'),
      ('type', 'int', 'false'),
      ('flag', 'int', 'false'),
      ('owner_id', 'int', 'false'),
      ('comp_flag', 'int', 'true'),
      ('exec_env', 'varchar:OB_MAX_PROC_ENV_LENGTH', 'true'),
      ('source', 'longtext', 'true'),
      ('comment', 'varchar:MAX_TENANT_COMMENT_LENGTH', 'true'),
      ('route_sql', 'longtext', 'true')
    ],
)

def_table_schema(**all_package_def)
def_table_schema(**gen_history_table_def(197, all_package_def))

def_table_schema(
  owner = 'jingyan.kfy',
  table_name     = '__all_acquired_snapshot',
  table_id       = '202',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
    ('tenant_id', 'int', 'true'),
    ('gmt_create', 'timestamp:6', 'false')
    ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    ('snapshot_type', 'int'),
    ('snapshot_scn', 'uint'),
    ('schema_version', 'int', 'true'),
    ('tablet_id', 'int', 'true'),
    ('extra_info', 'varchar:MAX_ROOTSERVICE_EVENT_EXTRA_INFO_LENGTH', 'true', ''),
  ],
)

# 205: __all_tenant_gc_partition_info # abandoned in 4.0

all_constraint_def = dict(
    owner = 'bin.lb',
    table_name    = '__all_constraint',
    table_id      = '206',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('table_id', 'int'),
        ('constraint_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('constraint_name', 'varchar:OB_MAX_CONSTRAINT_NAME_LENGTH_ORACLE', 'false'),
      ('check_expr', 'varchar:OB_MAX_CONSTRAINT_EXPR_LENGTH', 'false'),
      ('schema_version', 'int'),
      ('constraint_type', 'int'),
      ('rely_flag', 'bool', 'false', 'false'),
      ('enable_flag', 'bool', 'false', 'true'),
      ('validate_flag', 'int', 'false', '1'),
      ('name_generated_type', 'int', 'false', '0'),
    ],
)

def_table_schema(**all_constraint_def)

def_table_schema(**gen_history_table_def(207, all_constraint_def))

def_table_schema(
  owner = 'yanmu.ztl',
  table_name     = '__all_ori_schema_version',
  table_id       = '208',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int', 'false'),
      ('table_id', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('ori_schema_version', 'int'),
  ],
)

all_func_def = dict(
    owner = 'bin.lb',
    table_name    = '__all_func',
    table_id      = '209',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('name', 'varchar:OB_MAX_UDF_NAME_LENGTH', 'false'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('ret', 'int'),
      ('dl', 'varchar:OB_MAX_DL_NAME_LENGTH', 'false'),
      #TODO muhang.zb the inner table python generator do not support enum at this time
      #('type', 'enum(\'function\',\'aggregate\')'),
      ('udf_id', 'int'),
      # 1 for normal function; 2 for aggregate function.
      ('type', 'int'),
    ],
)

def_table_schema(**all_func_def)

def_table_schema(**gen_history_table_def(210, all_func_def))


def_table_schema(
  owner = 'jim.wjh',
  table_name     = '__all_temp_table',
  table_id       = '211',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
      ('tenant_id', 'int', 'false'),
      ('table_id', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('create_host', 'varchar:OB_MAX_HOST_NAME_LENGTH', 'false', ''),
  ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name    = '__all_sequence_object',
  table_id      = '213',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
  ('tenant_id', 'int', 'false'),
  ('sequence_id', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('schema_version', 'int', 'false'),
  ('database_id', 'int', 'false'),
  ('sequence_name', 'varchar:OB_MAX_SEQUENCE_NAME_LENGTH', 'false'),
  ('min_value', 'number:28:0', 'false'),
  ('max_value', 'number:28:0', 'false'),
  ('increment_by', 'number:28:0', 'false'),
  ('start_with', 'number:28:0', 'false'),
  ('cache_size', 'number:28:0', 'false'),
  ('order_flag', 'bool', 'false'),
  ('cycle_flag', 'bool', 'false'),
  ('is_system_generated', 'bool', 'false', 'false'),
  ('flag', 'int', 'false', 0),
  ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name    = '__all_sequence_object_history',
  table_id      = '214',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
  ('tenant_id', 'int', 'false'),
  ('sequence_id', 'int', 'false'),
  ('schema_version', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('is_deleted', 'int', 'false'),
  ('database_id', 'int', 'true'),
  ('sequence_name', 'varchar:OB_MAX_SEQUENCE_NAME_LENGTH', 'true'),
  ('min_value', 'number:28:0', 'true'),
  ('max_value', 'number:28:0', 'true'),
  ('increment_by', 'number:28:0', 'true'),
  ('start_with', 'number:28:0', 'true'),
  ('cache_size', 'number:28:0', 'true'),
  ('order_flag', 'bool', 'true'),
  ('cycle_flag', 'bool', 'true'),
  ('is_system_generated', 'bool', 'true'),
  ('flag', 'int', 'false', 0),
  ],
)


def_table_schema(
    owner = 'xiaochu.yh',
    table_name     = '__all_sequence_value',
    table_id       = '215',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('sequence_id', 'int', 'false'),
    ],
    in_tenant_space = True,

  normal_columns = [
      ('next_value', 'number:38:0', 'false')
  ],
)

# 216: __all_tenant_plan_baseline # abandoned in 4.0
# 217: __all_tenant_plan_baseline_history

# 218: __all_ddl_helper # abandoned in 4.0

# TODO: abandoned
def_table_schema(
	  owner = 'quanwei.wqw',
    table_name     = '__all_freeze_schema_version',
    table_id       = '219',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('frozen_version', 'int', 'false'),
        ('tenant_id', 'int', 'false'),
    ],

    normal_columns = [
      ('schema_version', 'int', 'false'),
  ],
)

all_type_def = dict(
  owner = 'linlin.xll',
  table_name = '__all_type',
  table_id   = '220',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('type_id', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('database_id', 'int'),
    ('schema_version', 'int'),
    ('typecode', 'int'),
    ('properties', 'int'),
    ('attributes', 'int'),
    ('methods', 'int'),
    ('hiddenmethods', 'int'),
    ('supertypes', 'int'),
    ('subtypes', 'int'),
    ('externtype', 'int'),
    ('externname', 'varchar:OB_MAX_TABLE_TYPE_LENGTH', 'true', ''),
    ('helperclassname', 'varchar:OB_MAX_TABLE_TYPE_LENGTH', 'true', ''),
    ('local_attrs', 'int'),
    ('local_methods', 'int'),
    ('supertypeid', 'int'),
    ('type_name', 'varchar:OB_MAX_TABLE_TYPE_LENGTH'),
    ('package_id', 'int'),
  ],
)

def_table_schema(**all_type_def)

def_table_schema(**gen_history_table_def(221, all_type_def))

all_type_attr_def = dict (
  owner = 'linlin.xll',
  table_name = '__all_type_attr',
  table_id = '222',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('type_id', 'int', 'false'),
    ('attribute', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('schema_version', 'int'),
    ('type_attr_id', 'int'),
    ('name', 'varchar:OB_MAX_TABLE_TYPE_LENGTH'),
    ('properties', 'int', 'false'),
    ('charset_id', 'int'),
    ('charset_form', 'int'),
    ('length', 'int'),
    ('number_precision', 'int'),
    ('scale', 'int'),
    ('zero_fill', 'int'),
    ('coll_type', 'int'),
    ('externname', 'varchar:OB_MAX_TABLE_TYPE_LENGTH', 'true', ''),
    ('xflags', 'int'),
    ('setter', 'int'),
    ('getter', 'int'),
  ],
)

def_table_schema(**all_type_attr_def)

def_table_schema(**gen_history_table_def(223, all_type_attr_def))

all_coll_type_def = dict(
  owner = 'linlin.xll',
  table_name = '__all_coll_type',
  table_id = '224',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('coll_type_id', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('schema_version', 'int'),
    ('elem_type_id', 'int'),
    ('elem_schema_version', 'int'),
    ('properties', 'int'),
    ('charset_id', 'int'),
    ('charset_form', 'int'),
    ('length', 'int'),
    ('number_precision', 'int'),
    ('scale', 'int'),
    ('zero_fill', 'int'),
    ('coll_type', 'int'),
    ('upper_bound', 'int'),
    ('package_id', 'int'),
    ('coll_name', 'varchar:OB_MAX_TABLE_TYPE_LENGTH'),
  ],
)

def_table_schema(**all_coll_type_def)

def_table_schema(**gen_history_table_def(225, all_coll_type_def))

def_table_schema(
    owner = 'wanhong.wwh',
    table_name    = '__all_weak_read_service',
    table_id      = '226',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('level_id', 'int'),
        ('level_value', 'varchar:OB_WRS_LEVEL_VALUE_LENGTH'),
    ],

    in_tenant_space = True,
    is_cluster_private = True,
    meta_record_in_sys = False,

  normal_columns = [
      ('level_name', 'varchar:OB_WRS_LEVEL_NAME_LENGTH', 'false'),
      ('min_version', 'uint', 'true'),
      ('max_version', 'uint', 'true'),
  ],
)

# 228: __all_cluster # abandoned in 4.0

# 229: __all_gts # abandoned in 4.0

# 230: __all_tenant_gts # abandoned in 4.0

# 231: __all_partition_member_list # abandoned in 4.0

all_dblink_def = dict(
  owner = 'longzhong.wlz',
  table_name    = '__all_dblink',
  table_id      = '232',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('dblink_id', 'int'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('dblink_name', 'varchar:OB_MAX_DBLINK_NAME_LENGTH', 'false'),
    ('owner_id', 'int', 'false'),
    ('host_ip', 'varchar:OB_MAX_DOMIN_NAME_LENGTH', 'false'),
    ('host_port', 'int', 'false'),
    ('cluster_name', 'varchar:OB_MAX_CLUSTER_NAME_LENGTH', 'true'),
    ('tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE', 'false'),
    ('user_name', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE', 'false'),
    ('password', 'varchar:OB_MAX_PASSWORD_LENGTH', 'false'),
    ('driver_proto', 'int', 'false', 0),
    ('flag', 'int', 'false', 0),
    ('conn_string', 'varchar:DEFAULT_BUF_LENGTH', 'true', ''),
    ('service_name', 'varchar:OB_MAX_DBLINK_NAME_LENGTH', 'true', ''),
    ('authusr', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE', 'true', ''),
    ('authpwd', 'varchar:OB_MAX_PASSWORD_LENGTH', 'true', ''),
    ('passwordx', 'varbinary:OB_MAX_PASSWORD_LENGTH', 'true', ''),
    ('authpwdx', 'varbinary:OB_MAX_PASSWORD_LENGTH', 'true', ''),
    ('encrypted_password', 'varchar:OB_MAX_ENCRYPTED_PASSWORD_LENGTH', 'true'),
    ('reverse_host_ip', 'varchar:OB_MAX_DOMIN_NAME_LENGTH', 'true'),
    ('reverse_host_port', 'int', 'true'),
    ('reverse_cluster_name', 'varchar:OB_MAX_CLUSTER_NAME_LENGTH', 'true'),
    ('reverse_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE', 'true'),
    ('reverse_user_name', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE', 'true'),
    ('reverse_password', 'varchar:OB_MAX_ENCRYPTED_PASSWORD_LENGTH', 'true'),
    ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true'),
  ],
)

def_table_schema(**all_dblink_def)
def_table_schema(**gen_history_table_def(233, all_dblink_def))

# 234: __all_tenant_partition_meta_table # abandoned in 4.0.

all_tenant_role_grantee_map_def = dict(
  owner = 'sean.yyj',
  table_name = '__all_tenant_role_grantee_map',
  table_id = '235',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('grantee_id', 'int', 'false'),
    ('role_id', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('admin_option', 'int', 'false', '0'),
    ('disable_flag', 'int', 'false', '0')
  ],
)
def_table_schema(**all_tenant_role_grantee_map_def)
def_table_schema(**gen_history_table_def(236, all_tenant_role_grantee_map_def))

all_tenant_keystore_def = dict(
  owner = 'mingdou.tmd',
  table_name = '__all_tenant_keystore',
  table_id = '237',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('keystore_id', 'int', 'false'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('keystore_name', 'varchar:OB_MAX_KEYSTORE_NAME_LENGTH'),
    ('password', 'varchar:OB_MAX_PASSWORD_LENGTH'),
    ('status', 'int', 'false', 0),
    ('master_key_id', 'int'),
    ('master_key', 'varchar:OB_INTERNAL_MASTER_KEY_LENGTH'),
    ('encrypted_key', 'varbinary:OB_MAX_ENCRYPTED_KEY_LENGTH', 'false', ''),
  ],
)
def_table_schema(**all_tenant_keystore_def)
def_table_schema(**gen_history_table_def(238, all_tenant_keystore_def))

all_ols_policy_def = dict(
    owner = 'jim.wjh',
    table_name = '__all_tenant_ols_policy',
    table_id = '239',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
    ('tenant_id', 'int'),
    ('label_se_policy_id', 'int'),
    ],

    in_tenant_space = True,

    normal_columns = [
      ('policy_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
      ('column_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
      ('default_options', 'int'),
      ('flag', 'int'),
    ],
)

def_table_schema(**all_ols_policy_def)
def_table_schema(**gen_history_table_def(240, all_ols_policy_def))

all_ols_component_def = dict(
    owner = 'jim.wjh',
    table_name = '__all_tenant_ols_component',
    table_id = '241',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
    ('tenant_id', 'int'),
    ('label_se_component_id', 'int'),
    ],

    in_tenant_space = True,

    normal_columns = [
      ('label_se_policy_id', 'int'),
      ('comp_type', 'int'),
      ('comp_num', 'int'),  # [0-9999]
      ('short_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
      ('long_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
      ('parent_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'), # for group
    ],
)

def_table_schema(**all_ols_component_def)
def_table_schema(**gen_history_table_def(242, all_ols_component_def))

all_ols_label_def = dict(
    owner = 'jim.wjh',
    table_name = '__all_tenant_ols_label',
    table_id = '243',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
    ('tenant_id', 'int'),
    ('label_se_label_id', 'int'),
    ],

    in_tenant_space = True,

    normal_columns = [
      ('label_se_policy_id', 'int'),
      ('label_tag', 'int'),
      ('label', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
      ('flag', 'int'),
    ],
)

def_table_schema(**all_ols_label_def)
def_table_schema(**gen_history_table_def(244, all_ols_label_def))

all_ols_user_level_def = dict(
    owner = 'jim.wjh',
    table_name = '__all_tenant_ols_user_level',
    table_id = '245',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
    ('tenant_id', 'int'),
    ('label_se_user_level_id', 'int'),
    ],

    in_tenant_space = True,

    normal_columns = [
      ('user_id', 'int'),
      ('label_se_policy_id', 'int'),
      ('maximum_level', 'int'),
      ('minimum_level', 'int'),
      ('default_level', 'int'),
      ('row_level', 'int'),
    ],
)

def_table_schema(**all_ols_user_level_def)
def_table_schema(**gen_history_table_def(246, all_ols_user_level_def))

all_tenant_tablespace_def = dict(
  owner = 'mingdou.tmd',
  table_name = '__all_tenant_tablespace',
  table_id = '247',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('tablespace_id', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('tablespace_name', 'varchar:MAX_ORACLE_NAME_LENGTH'),
    ('encryption_name', 'varchar:MAX_ORACLE_NAME_LENGTH'),
    ('encrypt_key', 'varbinary:OB_ENCRYPTED_TABLE_KEY_LEN'),
    ('master_key_id', 'uint'),
  ],
)
def_table_schema(**all_tenant_tablespace_def)
def_table_schema(**gen_history_table_def(248, all_tenant_tablespace_def))

def_table_schema(
  owner = 'jim.wjh',
  table_name    = '__all_tenant_user_failed_login_stat',
  table_id      = '249',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('user_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('user_name', 'varchar:OB_MAX_USER_NAME_LENGTH'),
    ('failed_login_attempts', 'int'),
    ('last_failed_login_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true', ''),
  ],
)

all_profile_def = dict(
  owner = 'jim.wjh',
  table_name    = '__all_tenant_profile',
  table_id      = '250',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('profile_id', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('profile_name', 'varchar:MAX_ORACLE_NAME_LENGTH'),
    ('failed_login_attempts', 'int'),
    ('password_lock_time', 'int'),
    ('password_verify_function', 'varchar:MAX_ORACLE_NAME_LENGTH', 'true'),
    ('password_life_time', 'int', 'false', '-1'),
    ('password_grace_time', 'int', 'false', '-1'),
    ('password_reuse_time', 'int', 'false', '-1'),
    ('password_reuse_max', 'int', 'false', '-1'),
    ('inactive_account_time', 'int', 'false', '-1'),
  ],
)
def_table_schema(**all_profile_def)
def_table_schema(**gen_history_table_def(251,  all_profile_def))

all_tenant_security_audit_def = dict(
    owner = 'sean.yyj',
    table_name = '__all_tenant_security_audit',
    table_id = '252',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
                      ('tenant_id', 'int', 'false'),
                      ('audit_id', 'int', 'false'),
                     ],
    in_tenant_space = True,
    normal_columns = [
      ('audit_type', 'uint', 'false'),
      ('owner_id', 'uint', 'false'),
      ('operation_type', 'uint', 'false'),
      ('in_success', 'uint'),
      ('in_failure', 'uint'),
    ],
)
def_table_schema(**all_tenant_security_audit_def)
def_table_schema(**gen_history_table_def(253, all_tenant_security_audit_def))

all_trigger_def = dict(
  owner = 'webber.wb',
  table_name    = '__all_tenant_trigger',
  table_id      = '254',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('trigger_id', 'int'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('trigger_name', 'varchar:OB_MAX_TRIGGER_NAME_LENGTH', 'false'),
    ('database_id', 'int', 'false'),
    ('owner_id', 'int', 'false'),
    ('schema_version', 'int', 'false'),
    ('trigger_type', 'int', 'false'),
    ('trigger_events', 'int', 'false'),
    ('timing_points', 'int', 'false'),
    ('base_object_type', 'int', 'false'),
    ('base_object_id', 'int', 'false'),
    ('trigger_flags', 'int', 'false'),
    ('update_columns', 'varchar:OB_MAX_UPDATE_COLUMNS_LENGTH', 'true'),
    ('ref_old_name', 'varchar:OB_MAX_TRIGGER_NAME_LENGTH', 'false'),
    ('ref_new_name', 'varchar:OB_MAX_TRIGGER_NAME_LENGTH', 'false'),
    ('ref_parent_name', 'varchar:OB_MAX_TRIGGER_NAME_LENGTH', 'false'),
    ('when_condition', 'varchar:OB_MAX_WHEN_CONDITION_LENGTH', 'true'),
    ('trigger_body', 'varchar:OB_MAX_TRIGGER_BODY_LENGTH', 'true'),
    ('package_spec_source', 'varchar:OB_MAX_TRIGGER_BODY_LENGTH', 'true'),
    ('package_body_source', 'varchar:OB_MAX_TRIGGER_BODY_LENGTH', 'true'),
    ('package_flag', 'int', 'false'),
    ('package_comp_flag', 'int', 'false'),
    ('package_exec_env', 'varchar:OB_MAX_PROC_ENV_LENGTH', 'true'),
    ('sql_mode', 'int', 'false'),
    ('trigger_priv_user', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE', 'true'),
    ('order_type', 'int', 'false'),
    ('ref_trg_db_name', 'varchar:OB_MAX_TRIGGER_NAME_LENGTH', 'true'),
    ('ref_trg_name', 'varchar:OB_MAX_TRIGGER_NAME_LENGTH', 'true'),
    ('action_order', 'int', 'false'),
    ('analyze_flag', 'int', 'false', 0),
    ('trigger_body_v2', 'longtext', 'false', ''),
  ],
)

def_table_schema(**all_trigger_def)
def_table_schema(**gen_history_table_def(255, all_trigger_def))

def_table_schema(
    owner = 'fyy280124',
    table_name = '__all_seed_parameter',
    table_id   = '256',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('zone', 'varchar:MAX_ZONE_LENGTH'),
        ('svr_type', 'varchar:SERVER_TYPE_LENGTH'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
        ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN'),
    ],
    normal_columns = [
        ('data_type', 'varchar:OB_MAX_CONFIG_TYPE_LENGTH', 'true'),
        ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN'),
        ('info', 'varchar:OB_MAX_CONFIG_INFO_LEN'),
        ('section', 'varchar:OB_MAX_CONFIG_SECTION_LEN', 'true'),
        ('scope', 'varchar:OB_MAX_CONFIG_SCOPE_LEN', 'true'),
        ('source', 'varchar:OB_MAX_CONFIG_SOURCE_LEN', 'true'),
        ('edit_level', 'varchar:OB_MAX_CONFIG_EDIT_LEVEL_LEN', 'true'),
        ('config_version', 'int'),
    ],
)

# 257: __all_failover_scn # abandoned in 4.0

# 258: __all_tenant_sstable_column_checksum # abandoned in 4.0

all_tenant_security_audit_record_def = dict(
    owner = 'sean.yyj',
    table_name = '__all_tenant_security_audit_record',
    table_id = '259',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
                      ('tenant_id', 'int', 'false'),
                      ('record_timestamp_us', 'timestamp', 'false'),
                      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
                      ('svr_port', 'int', 'false'),
                      ],
    normal_columns = [
      ('user_id', 'uint'),
      ('user_name', 'varchar:OB_MAX_USER_NAME_LENGTH'),
      ('effective_user_id', 'uint'),
      ('effective_user_name', 'varchar:OB_MAX_USER_NAME_LENGTH'),
      ('client_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('user_client_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('proxy_session_id', 'uint'),
      ('session_id', 'uint'),
      ('entry_id', 'uint'),
      ('statement_id', 'uint'),
      ('trans_id', 'varchar:512'),
      ('commit_version', 'int'),
      ('trace_id', 'varchar:64'),
      ('db_id', 'uint'),
      ('cur_db_id', 'uint'),
      ('sql_timestamp_us', 'timestamp'),
      ('audit_id', 'uint'),
      ('audit_type', 'uint'),
      ('operation_type', 'uint'),
      ('action_id', 'uint'),
      ('return_code', 'int'),
      ('obj_owner_name', 'varchar:OB_MAX_USER_NAME_LENGTH', 'true'),
      ('obj_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH', 'true'),
      ('new_obj_owner_name', 'varchar:OB_MAX_USER_NAME_LENGTH', 'true'),
      ('new_obj_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH', 'true'),
      ('auth_privileges', 'varchar:OB_MAX_TABLE_NAME_LENGTH', 'true'),
      ('auth_grantee', 'varchar:OB_MAX_TABLE_NAME_LENGTH', 'true'),
      ('logoff_logical_read', 'uint'),
      ('logoff_physical_read', 'uint'),
      ('logoff_logical_write', 'uint'),
      ('logoff_lock_count', 'uint'),
      ('logoff_dead_lock', 'varchar:40', 'true'),
      ('logoff_cpu_time_us', 'uint'),
      ('logoff_exec_time_us', 'uint'),
      ('logoff_alive_time_us', 'uint'),
      ('comment_text', 'longtext', 'true'),
      ('sql_bind', 'longtext', 'true'),
      ('sql_text', 'longtext', 'true'),
    ],
    in_tenant_space = True,
)

def_table_schema(**all_tenant_security_audit_record_def)

all_sysauth_def = dict(
    owner = 'sean.yyj',
    table_name     = '__all_tenant_sysauth',
    table_id       = '260',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    in_tenant_space = True,

    rowkey_columns = [
        ('tenant_id', 'int', 'false'),
        ('grantee_id', 'int', 'false'),
        ('priv_id', 'int', 'false'),

    ],
    normal_columns = [
      ('priv_option', 'int', 'false'),
  ],
)

def_table_schema(**all_sysauth_def)
def_table_schema(**gen_history_table_def(261, all_sysauth_def))

all_objauth_def = dict(
    owner = 'sean.yyj',
    table_name     = '__all_tenant_objauth',
    table_id       = '262',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    in_tenant_space = True,

    rowkey_columns = [
        ('tenant_id', 'int', 'false'),
        ('obj_id', 'int', 'false'),
        ('objtype', 'int', 'false'),
        ('col_id', 'int', 'false'),
        ('grantor_id', 'int', 'false'),
        ('grantee_id', 'int', 'false'),
        ('priv_id', 'int', 'false'),

    ],
    normal_columns = [
      ('priv_option', 'int', 'false'),
  ],
)

def_table_schema(**all_objauth_def)
def_table_schema(**gen_history_table_def(263, all_objauth_def))


# 264: __all_tenant_backup_info # abandoned in 4.0

# __all_restore_info
all_restore_info_def = dict(
  owner = 'wangxiaohui.wxh',
  table_name    = '__all_restore_info',
  table_id      = '265',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('name', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
  ],

  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('value', 'longtext'),
  ],
)
def_table_schema(**all_restore_info_def)

# 266: __all_tenant_backup_log_archive_status # abandoned in 4.0
# 267: __all_backup_log_archive_status_history # abandoned in 4.0
# 268: __all_tenant_backup_task # abandoned in 4.0
# 269: __all_backup_task_history # abandoned in 4.0
# 270: __all_tenant_pg_backup_task # abandoned in 4.0
# 271:__all_failover_info # abandoned in 4.0

all_tenant_error_def = dict(
    owner = 'lj229669',
    table_name = '__all_tenant_error',
    table_id = '272',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
                      ('tenant_id', 'int', 'false'),
                      ('obj_id', 'int', 'false'),
                      ('obj_seq', 'int', 'false'),
                      ('obj_type', 'int', 'false'),
                     ],
    in_tenant_space = True,
    is_cluster_private = False,
    normal_columns = [
      ('line', 'int', 'false'),
      ('position', 'int', 'false'),
      ('text_length', 'int', 'false'),
      ('text', 'varchar:MAX_ORACLE_COMMENT_LENGTH'),
      ('property', 'int', 'true'),
      ('error_number', 'int', 'true'),
      ('schema_version', 'int', 'false')
    ],
)
def_table_schema(**all_tenant_error_def)

# 273: __all_server_recovery_status # abandoned in 4.0
# 274: __all_datafile_recovery_status # abandoned in 4.0

# 276: all_tenant_backup_clean_info # abandoned in 4.0
# 277: __all_backup_clean_info_history # abandoned in 4.0
# 278: __all_backup_task_clean_history # abandoned in 4.0

# __all_restore_progress
all_restore_progress_def = dict(
  owner = 'wangxiaohui.wxh',
  table_name    = '__all_restore_progress',
  table_id      = '279',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_id', 'int'),
  ],

  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('restore_scn', 'uint'),
    ('ls_count', 'int'),
    ('finish_ls_count', 'int'),
    ('tablet_count', 'int'),
    ('finish_tablet_count', 'int'),
    ('total_bytes', 'int'),
    ('finish_bytes', 'int'),
  ],
)
def_table_schema(**all_restore_progress_def)

# 280: __all_restore_history # abandoned in 4.0
# 281: __all_tenant_restore_pg_info # abandoned in 4.0
# 282: __all_table_v2_history # abandoned in 4.0

all_tenant_object_type_def = dict(
  owner = 'lj229669',
  table_name = '__all_tenant_object_type',
  table_id = '283',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('object_type_id', 'int', 'false'),
    ('type', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('schema_version', 'int'),
    ('properties', 'int'),
    ('charset_id', 'int'),
    ('charset_form', 'int'),
    ('length', 'int'),
    ('number_precision', 'int'),
    ('scale', 'int'),
    ('zero_fill', 'int'),
    ('coll_type', 'int'),
    ('database_id', 'int'),
    ('flag', 'int', 'false'),
    ('owner_id', 'int', 'false'),
    ('comp_flag', 'int', 'true'),
    ('object_name', 'varchar:OB_MAX_TABLE_TYPE_LENGTH', 'false'),
    ('exec_env', 'varchar:OB_MAX_PROC_ENV_LENGTH', 'true'),
    ('source', 'longtext', 'true'),
    ('comment', 'varchar:MAX_TENANT_COMMENT_LENGTH', 'true'),
    ('route_sql', 'longtext', 'true')
  ],
)

def_table_schema(**all_tenant_object_type_def)

def_table_schema(**gen_history_table_def(284, all_tenant_object_type_def))

# 285: __all_backup_validation_job # abandoned in 4.0
# 286: __all_backup_validation_job_history # abandoned in 4.0
# 287: __all_tenant_backup_validation_task # abandoned in 4.0
# 288: __all_backup_validation_task_history # abandoned in 4.0
# 289: __all_tenant_pg_backup_validation_task # abandoned in 4.0

def_table_schema(
  owner = 'dachuan.sdc',
  table_name     = '__all_tenant_time_zone',
  table_id       = '290',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
    ('tenant_id', 'int', 'false', '-1'),
    ('time_zone_id', 'int', 'false', 'NULL')
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
  ('use_leap_seconds', 'varchar:8', 'false', 'N'),
  ('version', 'int', 'true'),
  ],
)

def_table_schema(
  owner = 'dachuan.sdc',
  table_name     = '__all_tenant_time_zone_name',
  table_id       = '291',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
    ('tenant_id', 'int', 'false', '-1'),
    ('name', 'varchar:64', 'false', 'NULL')
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
  ('time_zone_id', 'int', 'false', 'NULL'),
  ('version', 'int', 'true'),
  ],
)

def_table_schema(
  owner = 'dachuan.sdc',
  table_name     = '__all_tenant_time_zone_transition',
  table_id       = '292',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
    ('tenant_id', 'int', 'false', '-1'),
    ('time_zone_id', 'int', 'false', 'NULL'),
    ('transition_time', 'int', 'false', 'NULL')
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
  ('transition_type_id', 'int', 'false', 'NULL'),
  ('version', 'int', 'true'),
  ],
)

def_table_schema(
  owner = 'dachuan.sdc',
  table_name     = '__all_tenant_time_zone_transition_type',
  table_id       = '293',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
    ('tenant_id', 'int', 'false', '-1'),
    ('time_zone_id', 'int', 'false', 'NULL'),
    ('transition_type_id', 'int', 'false', 'NULL')
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
  ('offset', 'int', 'false', '0'),
  ('is_dst', 'int', 'false', '0'),
  ('abbreviation', 'varchar:8', 'false', ''),
  ('version', 'int', 'true'),
  ],
)

all_tenant_constraint_column_def = dict(
  owner = 'bin.lb',
  table_name    = '__all_tenant_constraint_column',
  table_id      = '294',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('table_id', 'int', 'false'),
    ('constraint_id', 'int', 'false'),
    ('column_id', 'int', 'false'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('schema_version', 'int', 'false'),
  ],
)
def_table_schema(**all_tenant_constraint_column_def)
def_table_schema(**gen_history_table_def(295,  all_tenant_constraint_column_def))

def_table_schema(
  owner = 'gjw228474',
  table_name    = '__all_tenant_global_transaction',
  table_id      = '296',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('gtrid', 'varbinary:128'),
    ('bqual', 'varbinary:128'),
    ('format_id', 'int', 'false', '1'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('trans_id', 'int'),
    ('coordinator', 'int', 'true'),
    ('scheduler_ip', 'varchar:OB_MAX_SERVER_ADDR_SIZE'),
    ('scheduler_port', 'int'),
    ('is_readonly', 'bool', 'false', '0'),
    ('state', 'int'),
    ('flag', 'int'),
  ],
)

all_tenant_dependency_def = dict(
  owner = 'lj229669',
  table_name = '__all_tenant_dependency',
  table_id = '297',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('dep_obj_type', 'int'),
    ('dep_obj_id', 'int'),
    ('dep_order', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('schema_version', 'int'),
    ('dep_timestamp', 'int'),
    ('ref_obj_type', 'int'),
    ('ref_obj_id', 'int'),
    ('ref_timestamp', 'int'),
    ('dep_obj_owner_id', 'int', 'true'),
    ('property', 'int'),
    ('dep_attrs', 'varbinary:OB_MAX_ORACLE_RAW_SQL_COL_LENGTH', 'true'),
    ('dep_reason', 'varbinary:OB_MAX_ORACLE_RAW_SQL_COL_LENGTH', 'true'),
    ('ref_obj_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH', 'true')
  ],
)

def_table_schema(**all_tenant_dependency_def)

# 298: __all_backup_backupset_job # abandoned in 4.0
# 299: __all_backup_backupset_job_history # abandoned in 4.0
# 300: __all_tenant_backup_backupset_task # abandoned in 4.0
# 301: __all_backup_backupset_task_history # abandoned in 4.0
# 302: __all_tenant_pg_backup_backupset_task # abandoned in 4.0
# 303: __all_tenant_backup_backup_log_archive_status # abandoned in 4.0
# 304: __all_backup_backup_log_archive_status_history # abandoned in 4.0


def_table_schema(
# sys index schema def, only for compatible
  owner = 'xiaochu.yh',
  table_name    = '__all_res_mgr_plan',
  table_id      = '305',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('plan', 'varchar:128', 'false')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('comments', 'varchar:2000', 'true')
  ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name     = '__all_res_mgr_directive',
  table_id       = '306',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('plan', 'varchar:OB_MAX_RESOURCE_PLAN_NAME_LENGTH', 'false'),
    ('group_or_subplan', 'varchar:OB_MAX_RESOURCE_PLAN_NAME_LENGTH', 'false')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('comments', 'varchar:2000', 'true'),
    ('mgmt_p1', 'int', 'false', 100),
    ('utilization_limit', 'int', 'false', 100),
    ('min_iops', 'int', 'false', 0),
    ('max_iops', 'int', 'false', 100),
    ('weight_iops', 'int', 'false', 0),
    ('max_net_bandwidth', 'int', 'false', 100),
    ('net_bandwidth_weight', 'int', 'false', 0)
  ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name     = '__all_res_mgr_mapping_rule',
  table_id       = '307',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('attribute', 'varchar:OB_MAX_RESOURCE_PLAN_NAME_LENGTH', 'false'),
    ('value', 'varbinary:OB_MAX_RESOURCE_PLAN_NAME_LENGTH', 'false')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('consumer_group', 'varchar:OB_MAX_RESOURCE_PLAN_NAME_LENGTH', 'true'),
    ('status', 'int', 'true')
  ],
)

def_table_schema(
    owner = 'zhenjiang.xzj',
    table_name    = '__all_ddl_error_message',
    table_id      = '308',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('task_id', 'int'),
        ('target_object_id', 'int'),
        ('object_id', 'int'),
        ('schema_version', 'int'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
    ],
    is_cluster_private = False,
    in_tenant_space = True,

    normal_columns = [
      ('ret_code', 'int'),
      ('ddl_type', 'int'),
      ('affected_rows', 'int'),
      ('user_message', 'longtext', 'true'),
      ('dba_message', 'varchar:OB_MAX_ERROR_MSG_LEN', 'true'),
      ('parent_task_id', 'int', 'false', 0),
      ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true'),
      ('consensus_schema_version', 'int', 'false', '-1')
    ],
)

def_table_schema(
    owner = 'jiahua.cjh',
    table_name    = '__all_space_usage',
    table_id       = '309',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
        ('start_seq', 'int'),
        ('file_type', 'varchar:32'),
    ],

    normal_columns = [
        ('data_size', 'bigint'),
        ('used_size', 'bigint'),
    ],
    is_cluster_private = True,
)

# 310: __all_backup_backuppiece_job # abandoned in 4.0
# 311: __all_backup_backuppiece_job_history # abandoned in 4.0
# 312: __all_backup_backuppiece_task # abandoned in 4.0
# 313: __all_backup_backuppiece_task_history # abandoned in 4.0
# 314: __all_backup_piece_files # abandoned in 4.0

all_backup_set_files_def = dict(
  owner = 'chongrong.th',
  table_name = '__all_backup_set_files',
  table_id   = '315',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('backup_set_id', 'int'),
    ('dest_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('incarnation', 'int'),
    ('backup_type', 'varchar:OB_INNER_TABLE_BACKUP_TYPE_LENTH'),
    ('prev_full_backup_set_id', 'int'),
    ('prev_inc_backup_set_id', 'int'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
    ('file_status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
    ('plus_archivelog', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'false', 'OFF'),
    ('start_replay_scn', 'uint'),
    ('min_restore_scn', 'uint'),
    ('input_bytes', 'int', 'true', '0'),
    ('output_bytes', 'int', 'true', '0'),
    ('extra_bytes', 'int', 'true', '0'),
    ('tablet_count', 'int', 'true', '0'),
    ('finish_tablet_count', 'int', 'true', '0'),
    ('macro_block_count', 'int', 'true', '0'),
    ('finish_macro_block_count', 'int', 'true', '0'),
    ('file_count', 'int', 'true', '0'),
    ('meta_turn_id', 'int', 'true', '0'),
    ('data_turn_id', 'int', 'true', '0'),
    ('result', 'int'),
    ('comment', 'varchar:MAX_TABLE_COMMENT_LENGTH', 'true', ''),
    ('encryption_mode', 'varchar:OB_MAX_ENCRYPTION_MODE_LENGTH', 'true', 'None'),
    ('passwd', 'varchar:OB_MAX_PASSWORD_LENGTH', 'true', ''),
    ('tenant_compatible', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('backup_compatible', 'int'),
    ('path', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('cluster_version', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'false', ''),
    ('consistent_scn', 'uint', 'false', '0'),
    ('minor_turn_id', 'int', 'false', '0'),
    ('major_turn_id', 'int', 'false', '0'),
    ('min_restore_scn_display', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'false', ''),
  ],
)
def_table_schema(**all_backup_set_files_def)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name    = '__all_res_mgr_consumer_group',
  table_id      = '316',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('consumer_group', 'varchar:OB_MAX_RESOURCE_PLAN_NAME_LENGTH')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('consumer_group_id', 'int'),
    ('comments', 'varchar:2000', 'true')
  ],
)

# __all_backup_info
all_backup_info_def = dict(
  owner = 'chongrong.th',
  table_name    = '__all_backup_info',
  table_id      = '317',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('name', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('value', 'longtext'),
  ],
)
def_table_schema(**all_backup_info_def)

# 318: __all_backup_log_archive_status_v2 # abandoned in 4.0

def_table_schema(
  owner = 'zhenjiang.xzj',
  table_name = '__all_ddl_task_status',
  table_id = '319',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('task_id', 'int'),
  ],
  is_cluster_private = False,
  in_tenant_space = True,

  normal_columns = [
    ('tenant_id', 'int'),
    ('object_id', 'int'),
    ('target_object_id', 'int'),
    ('ddl_type', 'int'),
    ('schema_version', 'int'),
    ('parent_task_id', 'int'),
    ('trace_id', 'varchar:256'),
    ('status', 'int'),
    ('snapshot_version', 'uint', 'false', '0'),
    ('task_version', 'int', 'false', '0'),
    ('execution_id', 'int', 'false', '0'),
    ('ddl_stmt_str', 'longtext', 'true'),
    ('ret_code', 'int', 'false', '0'),
    ('message', 'longtext', 'true'),
    ('consensus_schema_version', 'int', 'false', '-1'),
    ('schedule_info', 'longtext', 'true'),
  ],
)

def_table_schema(
  owner = 'lichangqing',
  table_name    = '__all_region_network_bandwidth_limit',
  table_id       = '320',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('src_region', 'varchar:TABLE_MAX_KEY_LENGTH'),
    ('dst_region', 'varchar:TABLE_MAX_KEY_LENGTH'),
  ],

  normal_columns = [
    ('max_bw', 'bigint'),
  ],
)

# 321: __all_backup_backup_log_archive_status_v2 # abandoned in 4.0

def_table_schema(
  owner = 'xuwang.txw',
  table_name    = '__all_deadlock_event_history',
  table_id      = '322',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('event_id', 'uint'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'uint'),
    ('detector_id', 'uint')
  ],
  normal_columns = [
    ('report_time', 'timestamp'),
    ('cycle_idx', 'int'),
    ('cycle_size', 'int'),
    ('role', 'longtext'),
    ('priority_level', 'longtext'),
    ('priority', 'uint'),
    ('create_time', 'timestamp'),
    ('start_delay', 'uint'),
    ('module', 'longtext'),
    ('visitor', 'longtext'),
    ('object', 'longtext'),
    ('extra_name1', 'longtext', 'true'),
    ('extra_value1', 'longtext', 'true'),
    ('extra_name2', 'longtext', 'true'),
    ('extra_value2', 'longtext', 'true'),
    ('extra_name3', 'longtext', 'true'),
    ('extra_value3', 'longtext', 'true')
  ],
)

all_column_usage_def = dict(
    owner = 'yibo.tyf',
    table_name    = '__all_column_usage',
    table_id      = '323',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('table_id', 'int'),
        ('column_id', 'int'),
    ],
    in_tenant_space = True,
    is_cluster_private = False,

    normal_columns = [
      ('equality_preds', 'int', 'false', '0'),
      ('equijoin_preds', 'int', 'false', '0'),
      ('nonequijion_preds', 'int', 'false', '0'),
      ('range_preds', 'int', 'false', '0'),
      ('like_preds', 'int', 'false', '0'),
      ('null_preds', 'int', 'false', '0'),
      ('distinct_member', 'int', 'false', '0'),
      ('groupby_member', 'int', 'false', '0'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'int', 'true'),
      ('spare4', 'int', 'true'),
      ('spare5', 'int', 'true'),
      ('spare6', 'int', 'true'),
      ('flags', 'int', 'false', '0')
    ],
)

def_table_schema(**all_column_usage_def)

def_table_schema(
  owner = 'linlin.xll',
  table_name     = '__all_job',
  table_id       = '324',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job', 'int', 'false'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('lowner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false'),
    ('powner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false'),
    ('cowner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false'),
    ('last_date', 'timestamp', 'true'),
    ('this_date', 'timestamp', 'true'),
    ('next_date', 'timestamp', 'false'),
    ('total', 'int', 'true', '0'),
    ('interval#', 'varchar:200', 'false'),
    ('failures', 'int', 'true', '0'),
    ('flag', 'int', 'false'),
    ('what', 'varchar:4000', 'true'),
    ('nlsenv', 'varchar:4000', 'true'),
    ('charenv', 'varchar:4000', 'true'),
    ('field1', 'varchar:MAX_ZONE_LENGTH', 'true'),
    ('scheduler_flags', 'int', 'true', '0'),
    ('exec_env', 'varchar:OB_MAX_PROC_ENV_LENGTH', 'true'),
  ],
)

def_table_schema(
  owner = 'linlin.xll',
  table_name     = '__all_job_log',
  table_id       = '325',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job', 'int', 'false'),
    ('time', 'timestamp', 'false'),
    ('exec_addr', 'varchar:MAX_IP_PORT_LENGTH', 'false')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('code', 'int', 'true', '0'),
    ('message', 'varchar:4000')
  ],
)

all_tenant_directory_def = dict(
    owner = 'jiahua.cjh',
    table_name     = '__all_tenant_directory',
    table_id       = '326',
    table_type     = 'SYSTEM_TABLE',
    gm_columns     = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('directory_id', 'int'),
    ],
    normal_columns = [
        ('directory_name', 'varchar:128'),
        ('directory_path', 'varchar:4000'),
    ],
    in_tenant_space = True,
)

def_table_schema(**all_tenant_directory_def)
def_table_schema(**gen_history_table_def(327, all_tenant_directory_def))

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name = '__all_table_stat',
  table_id = '328',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('table_id', 'int'),
      ('partition_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
      ('object_type', 'int'),
      ('last_analyzed', 'timestamp'),
      ('sstable_row_cnt', 'int'),
      ('sstable_avg_row_len', 'double'),
      ('macro_blk_cnt', 'int'),
      ('micro_blk_cnt', 'int'),
      ('memtable_row_cnt', 'int'),
      ('memtable_avg_row_len', 'double'),
      ('row_cnt', 'int'),
      ('avg_row_len', 'double'),
      ('global_stats', 'int', 'true', '0'),
      ('user_stats', 'int', 'true', '0'),
      ('stattype_locked', 'int', 'true', '0'),
      ('stale_stats', 'int', 'true', '0'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'int', 'true'),
      ('spare4', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare5', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare6', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('index_type', 'bool')
  ],
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name = '__all_column_stat',
  table_id = '329',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('table_id', 'int'),
      ('partition_id', 'int'),
      ('column_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
      ('object_type', 'int'),
      ('last_analyzed', 'timestamp'),
      ('distinct_cnt', 'int'),
      ('null_cnt', 'int'),
      ('max_value', 'varchar:MAX_VALUE_LENGTH'),
      ('b_max_value', 'varchar:MAX_VALUE_LENGTH'),
      ('min_value', 'varchar:MAX_VALUE_LENGTH'),
      ('b_min_value', 'varchar:MAX_VALUE_LENGTH'),
      ('avg_len', 'double'),
      ('distinct_cnt_synopsis','varchar:MAX_LLC_BITMAP_LENGTH'),
      ('distinct_cnt_synopsis_size', 'int'),
      ('sample_size', 'int'),
      ('density', 'double'),
      ('bucket_cnt', 'int'),
      ('histogram_type', 'int'),
      ('global_stats', 'int', 'true', '0'),
      ('user_stats', 'int', 'true', '0'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'int', 'true'),
      ('spare4', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare5', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare6', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('cg_macro_blk_cnt', 'int', 'false', '0'),
      ('cg_micro_blk_cnt', 'int', 'false', '0')
  ],
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name = '__all_histogram_stat',
  table_id = '330',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('table_id', 'int'),
      ('partition_id', 'int'),
      ('column_id', 'int'),
      ('endpoint_num', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
      ('object_type', 'int'),
      ('endpoint_normalized_value', 'double'),
      ('endpoint_value', 'varchar:MAX_VALUE_LENGTH'),
      ('b_endpoint_value', 'varchar:MAX_VALUE_LENGTH'),
      ('endpoint_repeat_cnt', 'int'),
  ],
)

def_table_schema(
  owner = 'yibo.tyf',
  table_name = '__all_monitor_modified',
  table_id = '331',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('table_id', 'int'),
      ('tablet_id', 'int')
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
      ('last_inserts', 'int', 'true', '0'),
      ('last_updates', 'int', 'true', '0'),
      ('last_deletes', 'int', 'true', '0'),
      ('inserts', 'int', 'true', '0'),
      ('updates', 'int', 'true', '0'),
      ('deletes', 'int', 'true', '0'),
      ('flags', 'int', 'true', 'NULL'),
  ],
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name = '__all_table_stat_history',
  table_id = '332',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('table_id', 'int'),
      ('partition_id', 'int'),
      ('savtime', 'timestamp'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
      ('object_type', 'int'),
      ('flags', 'int'),
      ('last_analyzed', 'timestamp'),
      ('sstable_row_cnt', 'int'),
      ('sstable_avg_row_len', 'double'),
      ('macro_blk_cnt', 'int'),
      ('micro_blk_cnt', 'int'),
      ('memtable_row_cnt', 'int'),
      ('memtable_avg_row_len', 'double'),
      ('row_cnt', 'int'),
      ('avg_row_len', 'double'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'int', 'true'),
      ('spare4', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare5', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare6', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('index_type', 'bool'),
      ('stattype_locked', 'int', 'true', '0')
  ],
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name = '__all_column_stat_history',
  table_id = '333',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('table_id', 'int'),
      ('partition_id', 'int'),
      ('column_id', 'int'),
      ('savtime', 'timestamp'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
      ('object_type', 'int'),
      ('flags', 'int'),
      ('last_analyzed', 'timestamp'),
      ('distinct_cnt', 'int'),
      ('null_cnt', 'int'),
      ('max_value', 'varchar:MAX_VALUE_LENGTH'),
      ('b_max_value', 'varchar:MAX_VALUE_LENGTH'),
      ('min_value', 'varchar:MAX_VALUE_LENGTH'),
      ('b_min_value', 'varchar:MAX_VALUE_LENGTH'),
      ('avg_len', 'double'),
      ('distinct_cnt_synopsis','varchar:MAX_LLC_BITMAP_LENGTH'),
      ('distinct_cnt_synopsis_size', 'int'),
      ('sample_size', 'int'),
      ('density', 'double'),
      ('bucket_cnt', 'int'),
      ('histogram_type', 'int'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'int', 'true'),
      ('spare4', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare5', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare6', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('cg_macro_blk_cnt', 'int', 'false', '0'),
      ('cg_micro_blk_cnt', 'int', 'false', '0')
  ],
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name = '__all_histogram_stat_history',
  table_id = '334',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('table_id', 'int'),
      ('partition_id', 'int'),
      ('column_id', 'int'),
      ('endpoint_num', 'int'),
      ('savtime', 'timestamp'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
      ('object_type', 'int'),
      ('endpoint_normalized_value', 'double'),
      ('endpoint_value', 'varchar:MAX_VALUE_LENGTH'),
      ('b_endpoint_value', 'varchar:MAX_VALUE_LENGTH'),
      ('endpoint_repeat_cnt', 'int'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'int', 'true'),
      ('spare4', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare5', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare6', 'varchar:MAX_VALUE_LENGTH', 'true')
  ],
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name = '__all_optstat_global_prefs',
  table_id = '335',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('sname', 'varchar:30'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
      ('sval1', 'number:38:0', 'true'),
      ('sval2', 'timestamp', 'true'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'int', 'true'),
      ('spare4', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare5', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare6', 'timestamp', 'true')
  ],
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name = '__all_optstat_user_prefs',
  table_id = '336',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('table_id', 'int'),
      ('pname', 'varchar:30'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
      ('valnum', 'int', 'true'),
      ('valchar', 'varchar:4000', 'true'),
      ('chgtime', 'timestamp', 'true'),
      ('spare1', 'int', 'true')
  ],
)

# __all_ls_meta_table
def_table_schema(
    owner = 'wangzhennan.wzn',
    table_name = '__all_ls_meta_table',
    table_id = '342',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('ls_id', 'int'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
    ],
    in_tenant_space = True,
    is_cluster_private = True,
    meta_record_in_sys = True,
    normal_columns = [
        # location related
        ('sql_port', 'int'),
        ('role', 'int'),
        ('member_list', 'varchar:MAX_MEMBER_LIST_LENGTH'),
        ('proposal_id', 'int', 'false', '0'),
        ('replica_type', 'int', 'false', '0'),
        ('replica_status', 'varchar:MAX_REPLICA_STATUS_LENGTH', 'false', 'NORMAL'),
        ('restore_status', 'int', 'false', '0'),
        ('memstore_percent', 'int', 'false', '100'),
        # meta related
        ('unit_id', 'int'),
        ('zone', 'varchar:MAX_ZONE_LENGTH'),
        ('paxos_replica_number', 'int', 'false', '-1'),
        ('data_size', 'int'),
        ('required_size', 'int', 'false', '0'),
        ('learner_list', 'longtext', 'true'),
        ('rebuild', 'int', 'false', '0'),
    ],
)

def_table_schema(
    owner = 'yanmu.ztl',
    table_name = '__all_tablet_to_ls',
    table_id = '343',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tablet_id', 'int'),
    ],
    in_tenant_space = True,
    is_cluster_private = False,
    normal_columns = [
        ('ls_id', 'int'),
        ('table_id', 'int'),
        ('transfer_seq', 'int', 'false', '0'),
    ],
)

def_table_schema(
    owner = 'fengjingkun.fjk',
    table_name = '__all_tablet_meta_table',
    table_id = '344',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('tablet_id', 'int'),
        ('ls_id', 'int'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
    ],
    in_tenant_space = True,
    is_cluster_private = True,
    meta_record_in_sys = False,
    normal_columns = [
        # check merge finish
        ('compaction_scn', 'uint'),
        # load balancing releated
        ('data_size', 'int'),
        ('required_size', 'int', 'false', '0'),
        ('report_scn', 'uint', 'false', '0'),
        ('status', 'int', 'false', '0'),
    ],
)

def_table_schema(
  owner = 'msy164651',
  table_name    = '__all_ls_status',
  table_id      = '345',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ],

  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = True,

  normal_columns = [
    ('init_member_list', 'longtext', 'true'),
    ('b_init_member_list', 'longtext', 'true'),
    ('status', 'varchar:100'),
    ('ls_group_id', 'int'),
    ('unit_group_id', 'int'),
    ('primary_zone', 'varchar:MAX_ZONE_LENGTH', 'true'),
    ('init_learner_list', 'longtext', 'true'),
    ('b_init_learner_list', 'longtext', 'true'),
    ('flag', 'varchar:OB_MAX_LS_FLAG_LENGTH', 'false', ''),
    ],
)

# 346: __all_zone_v2 # abandoned in 4.0

# __all_log_archive_progress
all_log_archive_progress_def = dict(
  owner = 'wangxiaohui.wxh',
  table_name    = '__all_log_archive_progress',
  table_id      = '348',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('dest_no', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('incarnation', 'int', 'false', '1'),
    ('dest_id', 'int', 'false', '0'),
    ('round_id', 'int', 'false', '0'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false', 'INVALID'),
    ('start_scn', 'uint', 'false', '0'),
    ('checkpoint_scn', 'uint', 'false', '0'),
    ('max_scn', 'uint', 'false', '0'),
    ('compatible', 'int', 'false', '0'),
    ('base_piece_id', 'int', 'false', '0'),
    ('used_piece_id', 'int', 'false', '0'),
    ('piece_switch_interval', 'int', 'false', '0'),
    ('unit_size', 'int', 'false', '1'),
    ('compression', 'varchar:OB_MAX_COMPRESSOR_NAME_LENGTH', 'false', 'none'),
    ('frozen_input_bytes', 'int', 'false', '0'),
    ('frozen_output_bytes', 'int', 'false', '0'),
    ('active_input_bytes', 'int', 'false', '0'),
    ('active_output_bytes', 'int', 'false', '0'),
    ('deleted_input_bytes', 'int', 'false', '0'),
    ('deleted_output_bytes', 'int', 'false', '0'),
    ('path', 'varchar:OB_MAX_BACKUP_DEST_LENGTH', 'false', ''),
    ('comment', 'varchar:OB_MAX_DEFAULT_VALUE_LENGTH', 'false', ''),
  ],
)
def_table_schema(**all_log_archive_progress_def)

# __all_log_archive_history
all_log_archive_progress_history_def = dict(
  owner = 'wangxiaohui.wxh',
  table_name    = '__all_log_archive_history',
  table_id      = '349',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('dest_no', 'int'),
    ('round_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('incarnation', 'int', 'false', '1'),
    ('dest_id', 'int', 'false', '0'),
    ('start_scn', 'uint', 'false', '0'),
    ('checkpoint_scn', 'uint', 'false', '0'),
    ('max_scn', 'uint', 'false', '0'),
    ('compatible', 'int', 'false', '0'),
    ('base_piece_id', 'int', 'false', '0'),
    ('used_piece_id', 'int', 'false', '0'),
    ('piece_switch_interval', 'int', 'false', '0'),
    ('unit_size', 'int', 'false', '1'),
    ('compression', 'varchar:OB_MAX_COMPRESSOR_NAME_LENGTH', 'false', 'none'),
    ('input_bytes', 'int', 'false', '0'),
    ('output_bytes', 'int', 'false', '0'),
    ('deleted_input_bytes', 'int', 'false', '0'),
    ('deleted_output_bytes', 'int', 'false', '0'),
    ('path', 'varchar:OB_MAX_BACKUP_DEST_LENGTH', 'false', ''),
    ('comment', 'varchar:OB_MAX_DEFAULT_VALUE_LENGTH', 'false', ''),
  ],
)
def_table_schema(**all_log_archive_progress_history_def)

# __all_log_archive_piece_files
all_log_archive_piece_files_def = dict(
  owner = 'wangxiaohui.wxh',
  table_name    = '__all_log_archive_piece_files',
  table_id      = '350',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('dest_id', 'int'),
    ('round_id', 'int'),
    ('piece_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('incarnation', 'int', 'false', '1'),
    ('dest_no', 'int', 'false', '0'),
    ('file_count', 'int', 'false', '0'),
    ('start_scn', 'uint', 'false', '0'),
    ('checkpoint_scn', 'uint', 'false', '0'),
    ('max_scn', 'uint', 'false', '0'),
    ('end_scn', 'uint', 'false', '0'),
    ('compatible', 'int', 'false', '0'),
    ('unit_size', 'int', 'false', '1'),
    ('compression', 'varchar:OB_MAX_COMPRESSOR_NAME_LENGTH', 'false', 'none'),
    ('input_bytes', 'int', 'false', '0'),
    ('output_bytes', 'int', 'false', '0'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false', 'INVALID'),
    ('file_status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false', 'INVALID'),
    ('cp_file_id', 'int', 'false', '0'),
    ('cp_file_offset', 'int', 'false', '0'),
    ('path', 'varchar:OB_MAX_BACKUP_DEST_LENGTH', 'false', ''),
  ],
)
def_table_schema(**all_log_archive_piece_files_def)

# __all_ls_log_archive_progress
def_table_schema(
    owner = 'wangxiaohui.wxh',
    table_name    = '__all_ls_log_archive_progress',
    table_id      = '351',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('dest_id', 'int'),
        ('round_id', 'int'),
        ('piece_id', 'int'),
        ('ls_id', 'int'),
    ],

  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
      ('incarnation', 'int', 'false', '1'),
      ('start_scn', 'uint', 'false', '0'),
      ('min_lsn', 'uint', 'false', '0'),
      ('max_lsn', 'uint', 'false', '0'),
      ('checkpoint_scn', 'uint', 'false', '0'),
      ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false', 'INVALID'),
      ('file_id', 'int', 'false', '0'),
      ('file_offset', 'int', 'false', '0'),
      ('input_bytes', 'int', 'false', '0'),
      ('output_bytes', 'int', 'false', '0'),
  ],
)

def_table_schema(
  owner = 'msy164651',
  table_name    = '__all_ls',
  table_id = '352',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('ls_id', 'int'),
  ],

  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
    ('ls_group_id', 'int'),
    ('status', 'varchar:100'),
    ('flag', 'varchar:OB_MAX_LS_FLAG_LENGTH'),
    ('create_scn', 'uint'),
  ],
)

# 353: abandoned

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name = '__all_backup_storage_info',
  table_id = '354',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('path', 'varchar:OB_MAX_BACKUP_PATH_LENGTH'),
    ('endpoint', 'varchar:OB_MAX_BACKUP_ENDPOINT_LENGTH'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('dest_id', 'int', 'true', '0'),
    ('dest_type', 'varchar:OB_DEFAULT_OUTPUT_DEVICE_TYPE_LENTH', 'true', ''),
    ('authorization', 'varchar:OB_MAX_BACKUP_AUTHORIZATION_LENGTH'),
    ('extension', 'varchar:OB_MAX_BACKUP_EXTENSION_LENGTH'),
    ('check_file_name', 'varchar:OB_MAX_BACKUP_CHECK_FILE_NAME_LENGTH', 'true', ''),
    ('last_check_time', 'int', 'true', '0'),
    ('max_iops', 'int', 'false', '0'),
    ('max_bandwidth', 'int', 'false', '0'),
  ],
)

def_table_schema(
  owner = 'lj229669',
  table_name     = '__all_dam_last_arch_ts',
  table_id       = '355',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('audit_trail_type', 'int'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('last_arch_ts', 'timestamp', 'false'),
    ('flag', 'int', 'false', 0),
  ],
)

def_table_schema(
  owner = 'lj229669',
  table_name     = '__all_dam_cleanup_jobs',
  table_id       = '356',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_name', 'varchar:100', 'false', ''),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('job_id', 'int'),
    ('job_status', 'int'),
    ('audit_trail_type', 'int', 'false', 1),
    ('job_interval', 'int', 'false', 1),
    ('job_frequency', 'varchar:100'),
    ('job_flags', 'int')
  ],
)
def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_backup_job',
  table_id      = '357',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('incarnation', 'int'),
    ('backup_set_id', 'int', 'true', '0'),
    ('initiator_tenant_id', 'int'),
    ('initiator_job_id', 'int'),
    ('executor_tenant_id', 'varchar:OB_MAX_EXECUTOR_TENANT_LENGTH','false', ''),
    ('plus_archivelog', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'false', 'OFF'),
    ('backup_type', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('job_level', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('encryption_mode', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('passwd', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('status', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('result', 'int'),
    ('retry_count', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('description', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('path', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ],
)
def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_backup_job_history',
  table_id      = '358',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('incarnation', 'int'),
    ('backup_set_id', 'int', 'true', '0'),
    ('initiator_tenant_id', 'int'),
    ('initiator_job_id', 'int'),
    ('executor_tenant_id', 'varchar:OB_MAX_EXECUTOR_TENANT_LENGTH','false', ''),
    ('plus_archivelog', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'false', 'OFF'),
    ('backup_type', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('job_level', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('encryption_mode', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('passwd', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('status', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('result', 'int'),
    ('retry_count', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('description', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('path', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ],
)

def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_backup_task',
  table_id      = '359',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('job_id', 'int'),
    ('incarnation', 'int'),
    ('backup_set_id', 'int'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('status', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('start_scn', 'uint'),
    ('end_scn', 'uint'),
    ('user_ls_start_scn', 'uint'),
    ('encryption_mode', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('passwd', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('input_bytes', 'int', 'true', '0'),
    ('output_bytes', 'int', 'true', '0'),
    ('extra_bytes', 'int', 'true', '0'),
    ('tablet_count', 'int', 'true', '0'),
    ('finish_tablet_count', 'int', 'true', '0'),
    ('macro_block_count', 'int', 'true', '0'),
    ('finish_macro_block_count', 'int', 'true', '0'),
    ('file_count', 'int', 'true', '0'),
    ('meta_turn_id', 'int', 'true', '0'),
    ('data_turn_id', 'int', 'true', '0'),
    ('result', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('path', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('minor_turn_id', 'int', 'false', '0'),
    ('major_turn_id', 'int', 'false', '0'),
    ('log_file_count', 'int', 'false', '0'),
    ('finish_log_file_count', 'int', 'false', '0'),
    ],
)
def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_backup_task_history',
  table_id      = '360',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('job_id', 'int'),
    ('incarnation', 'int'),
    ('backup_set_id', 'int'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('status', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('start_scn', 'uint'),
    ('end_scn', 'uint'),
    ('user_ls_start_scn', 'uint'),
    ('encryption_mode', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('passwd', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('input_bytes', 'int', 'true', '0'),
    ('output_bytes', 'int', 'true', '0'),
    ('extra_bytes', 'int', 'true', '0'),
    ('tablet_count', 'int', 'true', '0'),
    ('finish_tablet_count', 'int', 'true', '0'),
    ('macro_block_count', 'int', 'true', '0'),
    ('finish_macro_block_count', 'int', 'true', '0'),
    ('file_count', 'int', 'true', '0'),
    ('meta_turn_id', 'int', 'true', '0'),
    ('data_turn_id', 'int', 'true', '0'),
    ('result', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('path', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('minor_turn_id', 'int', 'false', '0'),
    ('major_turn_id', 'int', 'false', '0'),
    ('log_file_count', 'int', 'false', '0'),
    ('finish_log_file_count', 'int', 'false', '0'),
    ],
)
def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_backup_ls_task',
  table_id      = '361',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ('ls_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('job_id', 'int'),
    ('backup_set_id', 'int'),
    ('backup_type', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('task_type','varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('status', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('date', 'int'),
    ('black_list', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('svr_ip', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('svr_port', 'int', 'true', '0'),
    ('task_trace_id', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('input_bytes', 'int', 'true', '0'),
    ('output_bytes', 'int', 'true', '0'),
    ('tablet_count', 'int', 'true', '0'),
    ('finish_tablet_count', 'int', 'true', '0'),
    ('macro_block_count', 'int', 'true', '0'),
    ('finish_macro_block_count', 'int', 'true', '0'),
    ('extra_bytes', 'int', 'true', '0'),
    ('file_count', 'int', 'true', '0'),
    ('start_turn_id', 'int'),
    ('turn_id', 'int'),
    ('retry_id', 'int', 'true', '0'),
    ('result', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('max_tablet_checkpoint_scn', 'uint'),
    ('log_file_count', 'int', 'false', '0'),
    ('finish_log_file_count', 'int', 'false', '0'),
    ],
)
def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_backup_ls_task_history',
  table_id      = '362',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ('ls_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('job_id', 'int'),
    ('backup_set_id', 'int'),
    ('backup_type', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('task_type','varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('status', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('date', 'int'),
    ('black_list', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('svr_ip', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('svr_port', 'int', 'true', '0'),
    ('task_trace_id', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('input_bytes', 'int', 'true', '0'),
    ('output_bytes', 'int', 'true', '0'),
    ('tablet_count', 'int', 'true', '0'),
    ('finish_tablet_count', 'int', 'true', '0'),
    ('macro_block_count', 'int', 'true', '0'),
    ('finish_macro_block_count', 'int', 'true', '0'),
    ('extra_bytes', 'int', 'true', '0'),
    ('file_count', 'int', 'true', '0'),
    ('start_turn_id', 'int'),
    ('turn_id', 'int'),
    ('retry_id', 'int', 'true', '0'),
    ('result', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('max_tablet_checkpoint_scn', 'uint'),
    ('log_file_count', 'int', 'false', '0'),
    ('finish_log_file_count', 'int', 'false', '0'),
    ],
)
def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_backup_ls_task_info',
  table_id      = '363',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ('ls_id', 'int'),
    ('turn_id', 'int'),
    ('retry_id', 'int'),
    ('data_type', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('backup_set_id', 'int'),
    ('input_bytes', 'int'),
    ('output_bytes', 'int'),
    ('tablet_count', 'int'),
    ('finish_tablet_count', 'int'),
    ('macro_block_count', 'int'),
    ('finish_macro_block_count', 'int'),
    ('extra_bytes', 'int', 'true', '0'),
    ('file_count', 'int', 'true', '0'),
    ('max_file_id', 'int'),
    ('final', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', 'False'),
    ],
)
def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_backup_skipped_tablet',
  table_id      = '364',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ('turn_id', 'int'),
    ('retry_id', 'int'),
    ('tablet_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('ls_id', 'int'),
    ('backup_set_id', 'int'),
    ('skipped_type', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ],
)
def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_backup_skipped_tablet_history',
  table_id      = '365',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ('turn_id', 'int'),
    ('retry_id', 'int'),
    ('tablet_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('ls_id', 'int'),
    ('backup_set_id', 'int'),
    ('skipped_type', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ],
)

def_table_schema(
  owner = 'msy164651',
  table_name    = '__all_tenant_info',
  table_id = '366',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('tenant_role', 'varchar:100'),
    ('switchover_status', 'varchar:100'),
    ('switchover_epoch', 'int'),
    ('sync_scn', 'uint'),
    ('replayable_scn', 'uint'),
    ('readable_scn', 'uint'),
    ('recovery_until_scn', 'uint', 'false', 'OB_MAX_SCN_TS_NS'),
    ('log_mode', 'varchar:100', 'false', 'NOARCHIVELOG'),
    ('max_ls_id', 'int', 'false', '0'),
    ('restore_data_mode', 'varchar:128', 'false', 'NORMAL'),
  ],
)

# 367: __all_cluster_info # abandoned in 4.0
# 368: __all_cluster_config # abandoned in 4.0

def_table_schema(
  owner = 'yanmu.ztl',
  table_name    = '__all_tablet_to_table_history',
  table_id      = '369',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('tablet_id', 'int'),
      ('schema_version', 'int')
  ],
  in_tenant_space = True,

  normal_columns = [
    ('table_id', 'int'),
    ('is_deleted', 'int'),
  ],
)

def_table_schema(
  owner = 'msy164651',
  table_name    = '__all_ls_recovery_stat',
  table_id = '370',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = True,

  normal_columns = [
    ('create_scn', 'uint', 'false', '0'),
    ('readable_scn', 'uint', 'false', '0'),
    ('sync_scn', 'uint', 'false', '0'),
    ('drop_scn', 'uint', 'false', '0'),
    ('config_version', 'varchar:128', "false", ""),
    ('bconfig_version', 'varchar:1024', "false", ""),
  ],
)



def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_backup_ls_task_info_history',
  table_id      = '371',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ('ls_id', 'int'),
    ('turn_id', 'int'),
    ('retry_id', 'int'),
    ('data_type', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('backup_set_id', 'int'),
    ('input_bytes', 'int'),
    ('output_bytes', 'int'),
    ('tablet_count', 'int'),
    ('finish_tablet_count', 'int'),
    ('macro_block_count', 'int'),
    ('finish_macro_block_count', 'int'),
    ('extra_bytes', 'int', 'true', '0'),
    ('file_count', 'int', 'true', '0'),
    ('max_file_id', 'int'),
    ('final', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', 'False'),
    ],
)

def_table_schema(
  owner = 'quanwei.wqw',
  table_name = '__all_tablet_replica_checksum',
  table_id = '372',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('tablet_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('ls_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    # used for validating replica, main-standby database, data-index tablet
    ('compaction_scn', 'uint'),
    ('row_count', 'int'),
    ('data_checksum', 'int'),
    ('column_checksums', 'longtext', 'true'),
    ('b_column_checksums', 'varbinary:OB_MAX_VARBINARY_LENGTH', 'true'),
    ('data_checksum_type', 'int', 'false', 0)
  ],
)

# do checksum(user tenant) between primary cluster and standby cluster
# differ from __all_tablet_replica_checksum, it is tablet level
def_table_schema(
    owner = 'quanwei.wqw',
    table_name = '__all_tablet_checksum',
    table_id   = '373',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('compaction_scn', 'uint'),
        ('tablet_id', 'int'),
        ('ls_id', 'int'),
    ],
    in_tenant_space = True,
    is_cluster_private = False,
    normal_columns = [
        ('data_checksum', 'int'),
        ('row_count', 'int'),
        ('column_checksums', 'varbinary:OB_MAX_VARBINARY_LENGTH', 'true'),
    ],
)

def_table_schema(
  owner = 'jingyu.cr',
  table_name    = '__all_ls_replica_task',
  table_id = '374',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('task_type', 'varchar:MAX_DISASTER_RECOVERY_TASK_TYPE_LENGTH'),
    ('task_id', 'varchar:OB_TRACE_STAT_BUFFER_SIZE'),
  ],

  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('task_status', 'varchar:MAX_COLUMN_COMMENT_LENGTH', 'true'),
    ('priority', 'int', 'false', 1),
    ('target_replica_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('target_replica_svr_port', 'int', 'true'),
    ('target_paxos_replica_number', 'int', 'true'),
    ('target_replica_type', 'varchar:MAX_REPLICA_TYPE_LENGTH', 'true'),
    ('source_replica_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('source_replica_svr_port', 'int', 'true'),
    ('source_paxos_replica_number', 'int', 'true'),
    ('source_replica_type', 'varchar:MAX_REPLICA_TYPE_LENGTH', 'true'),
    ('task_exec_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('task_exec_svr_port', 'int', 'true'),
    ('generate_time', 'timestamp:6', 'false', 0),
    ('schedule_time', 'timestamp:6', 'false', 0),
    ('comment', 'varchar:MAX_COLUMN_COMMENT_LENGTH', 'true'),
    ('data_source_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('data_source_svr_port', 'int', 'true'),
    ('is_manual', 'bool', 'true', '0'),
  ],
)

def_table_schema(
  owner = 'lixinze.lxz',
  table_name    = '__all_pending_transaction',
  table_id      = '375',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('trans_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    ('gtrid', 'varbinary:128'),
    ('bqual', 'varbinary:128'),
    ('format_id', 'int', 'false', '1'),
    ('coordinator', 'int'),
    ('scheduler_ip', 'varchar:OB_MAX_SERVER_ADDR_SIZE'),
    ('scheduler_port', 'int'),
    ('state', 'int'),
    ('spare1', 'int', 'true'),
    ('spare2', 'int', 'true'),
    ('spare3', 'varchar:128', 'true'),
    ('spare4', 'varchar:128', 'true'),
  ],
)

def_table_schema(
  owner = 'wanhong.wwh',
  table_name    = '__all_balance_group_ls_stat',
  table_id = '376',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('balance_group_id_high', 'int'),
    ('balance_group_id_low', 'int'),
    ('ls_id', 'int'),
  ],

  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('tablet_group_count', 'int', 'false', '0'),
    ('balance_group_name', 'varchar:OB_MAX_BALANCE_GROUP_NAME_LENGTH', 'false', ''),
  ],
)

def_table_schema(
  owner = 'fyy280124',
  table_name     = '__all_tenant_scheduler_job',
  table_id       = '377',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_name', 'varchar:128', 'false'),
    ('job', 'int', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    ('lowner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false'),
    ('powner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false'),
    ('cowner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false'),
    ('last_date', 'timestamp', 'true'),
    ('this_date', 'timestamp', 'true'),
    ('next_date', 'timestamp', 'false'),
    ('total', 'int', 'true', '0'),
    ('interval#', 'varchar:4000', 'false'),
    ('failures', 'int', 'true', '0'),
    ('flag', 'int', 'false'),
    ('what', 'varchar:65536', 'true'),
    ('nlsenv', 'varchar:4000', 'true'),
    ('charenv', 'varchar:4000', 'true'),
    ('field1', 'varchar:MAX_ZONE_LENGTH', 'true'),
    ('scheduler_flags', 'int', 'true', '0'),
    ('exec_env', 'varchar:OB_MAX_PROC_ENV_LENGTH', 'true'),
    ('job_style', 'varchar:128', 'true'),
    ('program_name', 'varchar:128', 'true'),
    ('job_type', 'varchar:128', 'true'),
    ('job_action', 'varchar:65536', 'true'),
    ('number_of_argument', 'int', 'true'),
    ('start_date', 'timestamp', 'true'),
    ('repeat_interval', 'varchar:4000', 'true'),
    ('end_date', 'timestamp', 'true'),
    ('job_class', 'varchar:128', 'true'),
    ('enabled', 'bool', 'true'),
    ('auto_drop', 'bool', 'true'),
    ('state', 'varchar:128', 'true'),
    ('run_count', 'int', 'true'),
    ('retry_count', 'int', 'true'),
    ('last_run_duration', 'int', 'true'),
    ('max_run_duration', 'int', 'true'),
    ('comments', 'varchar:4096', 'true'),
    ('credential_name', 'varchar:128', 'true'),
    ('destination_name', 'varchar:128', 'true'),
    ('interval_ts', 'int', 'true'),
    ('user_id', 'int', 'true', 'OB_INVALID_ID'),
    ('database_id', 'int', 'true', 'OB_INVALID_ID'),
    ('max_failures', 'int', 'true', '0'),
    ('func_type', 'int', 'true', '0'),
    ('schedule_type', 'varchar:12', 'true')
  ],
)

def_table_schema(
  owner = 'fyy280124',
  table_name     = '__all_tenant_scheduler_job_run_detail',
  table_id       = '378',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job', 'int', 'false'),
    ('time', 'timestamp', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    ('code', 'int', 'true', '0'),
    ('message', 'varchar:4000'),
    ('job_class', 'varchar:30', 'true'),
  ],
)

def_table_schema(
  owner = 'fyy280124',
  table_name     = '__all_tenant_scheduler_program',
  table_id       = '379',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('program_name', 'varchar:30', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    ('program_type', 'varchar:16', 'true'),
    ('program_action', 'varchar:4000', 'true'),
    ('number_of_argument', 'int', 'true'),
    ('enabled', 'varchar:5', 'true'),
    ('detached', 'varchar:5', 'true'),
    ('schedule_limit', 'varchar:200', 'true'),
    ('priority', 'int', 'true'),
    ('weight', 'int', 'true'),
    ('max_runs', 'int', 'true'),
    ('max_failures', 'int', 'true'),
    ('max_run_duration', 'varchar:200', 'true'),
    ('nls_env', 'varchar:4000', 'true'),
    ('comments', 'varchar:240', 'true'),
    ('lowner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true'),
    ('powner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true'),
    ('cowner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true'),
  ],
)

def_table_schema(
  owner = 'fyy280124',
  table_name     = '__all_tenant_scheduler_program_argument',
  table_id       = '380',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('program_name', 'varchar:30'),
    ('job_name', 'varchar:30'),
    ('argument_position', 'int'),
    ('is_for_default', 'bool'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    ('argument_name', 'varchar:30', 'true'),
    ('argument_type', 'varchar:61', 'true'),
    ('metadata_attribute', 'varchar:19', 'true'),
    ('default_value', 'varchar:4000', 'true'),
    ('out_argument', 'varchar:5', 'true'),
  ],
)

all_context_def = dict(
  owner = 'peihan.dph',
  table_name    = '__all_context',
  table_id      = '381',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
  ('tenant_id', 'int'),
  ('context_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
  ('namespace', 'varchar:OB_MAX_CONTEXT_STRING_LENGTH', 'false', ''),
  ('schema_version', 'int', 'false', '-1'),
  ('database_name', 'varchar:OB_MAX_CONTEXT_STRING_LENGTH', 'false', ''),
  ('package', 'varchar:OB_MAX_CONTEXT_STRING_LENGTH', 'false', ''),
  ('type', 'int', 'false', '0'),
  ('origin_con_id', 'int', 'false', '-1'),
  ('tracking', 'int', 'false', '1'),
  ],
)
def_table_schema(**all_context_def)
def_table_schema(**gen_history_table_def(382, all_context_def))

all_global_context_value_def = dict(
  owner = 'peihan.dph',
  table_name    = '__all_global_context_value',
  table_id      = '383',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
  ('tenant_id', 'int'),
  ('context_id', 'int'),
  ('attribute', 'varchar:OB_MAX_CONTEXT_STRING_LENGTH'),
  ('client_identifier', 'varchar:OB_MAX_CONTEXT_CLIENT_IDENTIFIER_LENGTH'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
  ('namespace', 'varchar:OB_MAX_CONTEXT_STRING_LENGTH', 'false', ''),
  ('value', 'varchar:OB_MAX_CONTEXT_VALUE_LENGTH', 'false', ''),
  ('username', 'varchar:OB_MAX_CONTEXT_STRING_LENGTH', 'false', ''),
  ('con_id', 'int', 'false', '-1'),
  ],
)

def_table_schema(**all_global_context_value_def)

#384: __all_tablet_transfer_info

def_table_schema(
  owner = 'xuwang.txw',
  table_name    = '__all_ls_election_reference_info',
  table_id = '385',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = True,
  normal_columns = [
    ('zone_priority', 'longtext', 'true'),
    ('manual_leader_server', 'longtext', 'true'),
    ('blacklist', 'longtext', 'true'),
  ],
)

# backup clean inner table
def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name    = '__all_backup_delete_job',
  table_id      = '386',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('incarnation', 'int'),
    ('initiator_tenant_id', 'int'),
    ('initiator_job_id', 'int'),
    ('executor_tenant_id', 'varchar:OB_MAX_EXECUTOR_TENANT_LENGTH'),
    ('type', 'varchar:OB_INNER_TABLE_BACKUP_CLEAN_TYPE_LENGTH'),
    ('parameter', 'varchar:OB_MAX_BACKUP_PATH_LENGTH'),
    ('job_level', 'varchar:OB_INNER_TABLE_BACKUP_LEVEL_LENGTH'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
    ('task_count', 'int', 'true', '0'),
    ('success_task_count', 'int', 'true', '0'),
    ('result', 'int'),
    ('retry_count', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('data_backup_dest_id_list', 'varchar:OB_INNER_TABLE_BACKUP_DEFAULT_FIELD_LENGTH', 'true', ''),
    ('log_archive_dest_id_list', 'varchar:OB_INNER_TABLE_BACKUP_DEFAULT_FIELD_LENGTH', 'true', ''),
    ('data_backup_path_list', 'varchar:OB_MAX_BACKUP_PTAH_LIST_LENGTH', 'true', ''),
    ('log_archive_path_list', 'varchar:OB_MAX_BACKUP_PTAH_LIST_LENGTH', 'true', ''),
    ('description', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ],
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name    = '__all_backup_delete_job_history',
  table_id      = '387',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('incarnation', 'int'),
    ('initiator_tenant_id', 'int'),
    ('initiator_job_id', 'int'),
    ('executor_tenant_id', 'varchar:OB_MAX_EXECUTOR_TENANT_LENGTH'),
    ('type', 'varchar:OB_INNER_TABLE_BACKUP_CLEAN_TYPE_LENGTH'),
    ('parameter', 'varchar:OB_MAX_BACKUP_PATH_LENGTH'),
    ('job_level', 'varchar:OB_INNER_TABLE_BACKUP_LEVEL_LENGTH'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
    ('task_count', 'int', 'true', '0'),
    ('success_task_count', 'int', 'true', '0'),
    ('result', 'int'),
    ('retry_count', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('data_backup_dest_id_list', 'varchar:OB_INNER_TABLE_BACKUP_DEFAULT_FIELD_LENGTH', 'true', ''),
    ('log_archive_dest_id_list', 'varchar:OB_INNER_TABLE_BACKUP_DEFAULT_FIELD_LENGTH', 'true', ''),
    ('data_backup_path_list', 'varchar:OB_MAX_BACKUP_PTAH_LIST_LENGTH', 'true', ''),
    ('log_archive_path_list', 'varchar:OB_MAX_BACKUP_PTAH_LIST_LENGTH', 'true', ''),
    ('description', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ],
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name    = '__all_backup_delete_task',
  table_id      = '388',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('incarnation', 'int'),
    ('job_id', 'int'),
    ('task_type', 'varchar:OB_INNER_TABLE_BACKUP_CLEAN_TYPE_LENGTH'),
    ('id', 'int'),
    ('round_id', 'int'),
    ('dest_id', 'int'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
    ('total_ls_count', 'int', 'true', '0'),
    ('finish_ls_count', 'int', 'true', '0'),
    ('total_bytes', 'int', 'true', '0'),
    ('delete_bytes', 'int', 'true', '0'),
    ('total_files_count', 'int', 'true', '0'),
    ('delete_files_count', 'int', 'true', '0'),
    ('result', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('path', 'varchar:OB_MAX_BACKUP_PATH_LENGTH'),
    ],
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name    = '__all_backup_delete_task_history',
  table_id      = '389',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('incarnation', 'int'),
    ('job_id', 'int'),
    ('task_type', 'varchar:OB_INNER_TABLE_BACKUP_CLEAN_TYPE_LENGTH'),
    ('id', 'int'),
    ('round_id', 'int'),
    ('dest_id', 'int'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
    ('total_ls_count', 'int', 'true', '0'),
    ('finish_ls_count', 'int', 'true', '0'),
    ('total_bytes', 'int', 'true', '0'),
    ('delete_bytes', 'int', 'true', '0'),
    ('total_files_count', 'int', 'true', '0'),
    ('delete_files_count', 'int', 'true', '0'),
    ('result', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ('path', 'varchar:OB_MAX_BACKUP_PATH_LENGTH'),
    ],
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name    = '__all_backup_delete_ls_task',
  table_id      = '390',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ('ls_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('job_id', 'int'),
    ('task_type', 'varchar:OB_INNER_TABLE_BACKUP_CLEAN_TYPE_LENGTH'),
    ('id', 'int'),
    ('round_id', 'int'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true', ''),
    ('svr_port', 'int', 'true', '0'),
    ('task_trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true', ''),
    ('total_bytes', 'int', 'true', '0'),
    ('delete_bytes', 'int', 'true', '0'),
    ('total_files_count', 'int', 'true', '0'),
    ('delete_files_count', 'int', 'true', '0'),
    ('retry_id', 'int', 'true', '0'),
    ('result', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ],
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name    = '__all_backup_delete_ls_task_history',
  table_id      = '391',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('task_id', 'int'),
    ('ls_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('job_id', 'int'),
    ('task_type', 'varchar:OB_INNER_TABLE_BACKUP_CLEAN_TYPE_LENGTH'),
    ('id', 'int'),
    ('round_id', 'int'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true', ''),
    ('svr_port', 'int', 'true', '0'),
    ('task_trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true', ''),
    ('total_bytes', 'int', 'true', '0'),
    ('delete_bytes', 'int', 'true', '0'),
    ('total_files_count', 'int', 'true', '0'),
    ('delete_files_count', 'int', 'true', '0'),
    ('retry_id', 'int', 'true', '0'),
    ('result', 'int', 'true', '0'),
    ('comment', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
    ],
)

def_table_schema(
  owner = 'quanwei.wqw',
  table_name    = '__all_zone_merge_info',
  table_id      = '392',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('zone', 'varchar:MAX_ZONE_LENGTH'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
      ('all_merged_scn', 'uint'),
      ('broadcast_scn', 'uint'),
      ('frozen_scn', 'uint'),
      ('is_merging', 'int'),
      ('last_merged_time', 'int'),
      ('last_merged_scn', 'uint'),
      ('merge_start_time', 'int'),
      ('merge_status', 'int'),
  ],
)

# to store global zone merge info, which originally stored in __all_zone_merge_info
def_table_schema(
  owner = 'donglou.zl',
  table_name    = '__all_merge_info',
  table_id      = '393',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
      ('cluster', 'int'),
      ('frozen_scn', 'uint'),
      ('global_broadcast_scn', 'uint'),
      ('is_merge_error', 'int'),
      ('last_merged_scn', 'uint'),
      ('merge_status', 'int'),
      ('error_type', 'int'),
      ('suspend_merging', 'int'),
      ('merge_start_time', 'int'),
      ('last_merged_time', 'int'),
  ],
)

def_table_schema(
  owner = 'donglou.zl',
  table_name    = '__all_freeze_info',
  table_id      = '394',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('frozen_scn', 'uint'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
      ('cluster_version', 'int'),
      ('schema_version', 'int'),
  ],
)

def_table_schema(
  owner = 'jianyun.sjy',
  table_name    = '__all_disk_io_calibration',
  table_id      = '395',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('storage_name', 'varchar:1024'),
    ('mode', 'varchar:256'),
    ('size', 'int'),
  ],
  in_tenant_space = False,
  is_cluster_private = True,
  normal_columns = [
    ('latency', 'int', 'false'),
    ('iops', 'int', 'false'),
    ('addition_info', 'varchar:65536', 'false', ''),
  ],
)

def_table_schema(
  owner = 'yibo.tyf',
  table_name    = '__all_plan_baseline',
  table_id      = '396',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('database_id', 'uint'),
    ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH')
  ],

  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    ('constructed_sql', 'longtext', 'false')
  ],
)

def_table_schema(
  owner = 'yibo.tyf',
  table_name    = '__all_plan_baseline_item',
  table_id      = '397',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('database_id', 'uint'),
    ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
    ('plan_hash_value','uint')
  ],

  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    # for quick check
    ('sys_vars', 'varchar:OB_MAX_COMMAND_LENGTH', 'true', 'NULL'),
    ('plan_type', 'int'),
    # baseline infos
    ('description', 'varchar:500', 'true', 'NULL'),
    ('origin', 'int'),
    ('db_version', 'varchar:OB_SERVER_VERSION_LENGTH'),
    ('outline_data', 'longtext', 'false'),
    ('flags', 'int'),
    ('last_verified', 'int'),
    ('last_executed', 'int'),
    ('optimizer_cost', 'int'),
    ('executions', 'int'),
    ('elapsed_time', 'int'),
    ('cpu_time', 'int'),
    # extra info
    ('origin_sql', 'longtext', 'false')
  ],
)

def_table_schema(
  owner = 'yibo.tyf',
  table_name    = '__all_spm_config',
  table_id      = '398',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('name',  'varchar:OB_MAX_SQL_ID_LENGTH')
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    ('value', 'varchar:OB_MAX_SQL_ID_LENGTH', 'true', 'NULL'),
    ('modified_by', 'int', 'true', 'NULL')
  ],
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name = '__all_log_archive_dest_parameter',
  table_id = '399',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('dest_no', 'int'),
    ('name', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
  ],
  is_cluster_private = True,
  in_tenant_space = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('value', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
  ],
)

all_backup_parameter_def = dict(
  owner = 'wangxiaohui.wxh',
  table_name    = '__all_backup_parameter',
  table_id      = '400',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('name', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('value', 'longtext'),
  ],
)
def_table_schema(**all_backup_parameter_def)

all_ls_restore_progress_def = dict(
  owner = 'wangxiaohui.wxh',
  table_name    = '__all_ls_restore_progress',
  table_id      = '401',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_id', 'int'),
    ('ls_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('status', 'int'),
    ('restore_scn', 'uint'),
    ('start_replay_scn', 'uint'),
    ('last_replay_scn', 'uint'),
    ('tablet_count', 'int'),
    ('finish_tablet_count', 'int'),
    ('total_bytes', 'int'),
    ('finish_bytes', 'int'),
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true', ''),
    ('result', 'int', 'true', '0'),
    ('comment', 'varchar:MAX_TABLE_COMMENT_LENGTH', 'true', ''),
  ],
)
def_table_schema(**all_ls_restore_progress_def)

all_ls_restore_history_def = dict(
  owner = 'wangxiaohui.wxh',
  table_name    = '__all_ls_restore_history',
  table_id      = '402',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_id', 'int'),
    ('ls_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('restore_scn', 'uint'),
    ('start_replay_scn', 'uint'),
    ('last_replay_scn', 'uint'),
    ('tablet_count', 'int'),
    ('finish_tablet_count', 'int'),
    ('total_bytes', 'int'),
    ('finish_bytes', 'int'),
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true', ''),
    ('result', 'int', 'true', '0'),
    ('comment', 'varchar:MAX_TABLE_COMMENT_LENGTH'),
  ],
)
def_table_schema(**all_ls_restore_history_def)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name = '__all_backup_storage_info_history',
  table_id = '403',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('path', 'varchar:OB_MAX_BACKUP_PATH_LENGTH'),
    ('endpoint', 'varchar:OB_MAX_BACKUP_ENDPOINT_LENGTH'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('dest_id', 'int', 'true', '0'),
    ('dest_type', 'varchar:OB_DEFAULT_OUTPUT_DEVICE_TYPE_LENTH', 'true', ''),
    ('authorization', 'varchar:OB_MAX_BACKUP_AUTHORIZATION_LENGTH'),
    ('extension', 'varchar:OB_MAX_BACKUP_EXTENSION_LENGTH'),
    ('check_file_name', 'varchar:OB_MAX_BACKUP_CHECK_FILE_NAME_LENGTH', 'true', ''),
    ('last_check_time', 'int', 'true', '0'),
    ('max_iops', 'int', 'false', '0'),
    ('max_bandwidth', 'int', 'false', '0'),
  ],
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name    = '__all_backup_delete_policy',
  table_id      = '404',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('policy_name', 'varchar:OB_INNER_TABLE_BACKUP_DEFAULT_FIELD_LENGTH'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('recovery_window', 'varchar:OB_INNER_TABLE_BACKUP_CLEAN_TYPE_LENGTH'),
    ('redundancy', 'int'),
    ('backup_copies', 'int'),
    ('data_backup_dest_id_list', 'varchar:OB_INNER_TABLE_BACKUP_DEFAULT_FIELD_LENGTH', 'true', ''),
    ('log_archive_dest_id_list', 'varchar:OB_INNER_TABLE_BACKUP_DEFAULT_FIELD_LENGTH', 'true', ''),
    ('data_backup_path_list', 'varchar:OB_MAX_BACKUP_PTAH_LIST_LENGTH', 'true', ''),
    ('log_archive_path_list', 'varchar:OB_MAX_BACKUP_PTAH_LIST_LENGTH', 'true', ''),
  ],
)

all_mock_fk_parent_table_def = dict(
  owner = 'bin.lb',
  table_name    = '__all_mock_fk_parent_table',
  table_id      = '405',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('mock_fk_parent_table_id', 'int'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('database_id', 'int'),
    ('mock_fk_parent_table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH', 'false', ''),
    ('schema_version', 'int', 'false', '-1'),
  ],
)

def_table_schema(**all_mock_fk_parent_table_def)

def_table_schema(**gen_history_table_def(406, all_mock_fk_parent_table_def))

all_mock_fk_parent_table_column_def = dict(
  owner = 'bin.lb',
  table_name    = '__all_mock_fk_parent_table_column',
  table_id      = '407',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('mock_fk_parent_table_id', 'int'),
    ('parent_column_id', 'int'),
  ],
  in_tenant_space = True,
  normal_columns = [
   ('parent_column_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH', 'false', ''),
   ('schema_version', 'int', 'false', '-1'),
  ],
)

def_table_schema(**all_mock_fk_parent_table_column_def)

def_table_schema(**gen_history_table_def(408, all_mock_fk_parent_table_column_def))

def_table_schema(
    owner = 'shuning.tsn',
    table_name    = '__all_log_restore_source',
    table_id      = '409',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('id', 'int'),
    ],

  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
        ('type', 'varchar:32'),
        ('value', 'longtext'),
        ('recovery_until_scn', 'uint'),
  ],
)

all_kv_ttl_task_def = dict(
  owner = 'shenyunlong.syl',
  table_name = '__all_kv_ttl_task',
  table_id = '410',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('task_id', 'int'),
      ('table_id', 'int'),
      ('tablet_id', 'int')
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('task_start_time', 'int'),
    ('task_update_time', 'int'),
    ('trigger_type', 'int'),
    ('status', 'int'),
    ('ttl_del_cnt', 'int'),
    ('max_version_del_cnt', 'int'),
    ('scan_cnt', 'int'),
    ('row_key', 'varbinary:2048'),
    ('ret_code', 'varchar:OB_MAX_ERROR_MSG_LEN'),
    ('task_type', 'int', 'false', 0)
  ],
)

all_kv_ttl_task_history_def = dict(
  owner = 'shenyunlong.syl',
  table_name = '__all_kv_ttl_task_history',
  table_id = '411',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('task_id', 'int'),
      ('table_id', 'int'),
      ('tablet_id', 'int')
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('task_start_time', 'int'),
    ('task_update_time', 'int'),
    ('trigger_type', 'int'),
    ('status', 'int'),
    ('ttl_del_cnt', 'int'),
    ('max_version_del_cnt', 'int'),
    ('scan_cnt', 'int'),
    ('row_key', 'varbinary:2048'),
    ('ret_code', 'varchar:OB_MAX_ERROR_MSG_LEN'),
    ('task_type', 'int', 'false', 0)
  ],
)
def_table_schema(**all_kv_ttl_task_def)
def_table_schema(**all_kv_ttl_task_history_def)

def_table_schema(
  owner = 'donglou.zl',
  table_name    = '__all_service_epoch',
  table_id      = '412',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('name',  'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('value', 'int'),
  ],
)

def_table_schema(
  owner = 'tonghui.ht',
  table_name    = '__all_spatial_reference_systems',
  table_id      = '413',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('srs_id', 'uint'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
    ('srs_version', 'uint', 'false'),
    ('srs_name', 'varchar:128', 'false'),
    ('organization', 'varchar:256', 'true'),
    ('organization_coordsys_id', 'uint', 'true'),
    ('definition', 'varchar:4096', 'false'),
    ('minX', 'number:38:10', 'true'),
    ('maxX', 'number:38:10', 'true'),
    ('minY', 'number:38:10', 'true'),
    ('maxY', 'number:38:10', 'true'),
    ('proj4text', 'varchar:2048', 'true'),
    ('description', 'varchar:2048', 'true'),
  ],
)

# 414 : __all_tenant_datafile
# 415 : __all_tenant_datafile_history

def_table_schema(
  owner = 'donglou.zl',
  table_name    = '__all_column_checksum_error_info',
  table_id      = '416',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('frozen_scn', 'uint'),
      ('index_type', 'int'),
      ('data_table_id', 'int'),
      ('index_table_id', 'int'),
      ('data_tablet_id', 'int'),
      ('index_tablet_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
      ('column_id', 'int'),
      ('data_column_ckm', 'int'),
      ('index_column_ckm', 'int'),
  ],
)

# 417 : abandoned
# 418 : abandoned

all_column_group = dict(
    owner = 'donglou.zl',
    table_name    = '__all_column_group',
    table_id      = '419',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('table_id', 'int'),
        ('column_group_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('column_group_name', 'varchar:OB_MAX_COLUMN_GROUP_NAME_LENGTH', 'false', ''),
      ('column_group_type', 'int'),
      ('block_size', 'int'),
      ('compressor_type', 'int'),
      ('row_store_type', 'int'),
    ],
)

def_table_schema(**all_column_group)

def_table_schema(**gen_history_table_def(420, all_column_group))

all_column_group_mapping = dict(
    owner = 'donglou.zl',
    table_name    = '__all_column_group_mapping',
    table_id      = '421',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('table_id', 'int'),
        ('column_group_id', 'int'),
        ('column_id', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [],
)

def_table_schema(**all_column_group_mapping)

def_table_schema(**gen_history_table_def(422, all_column_group_mapping))

def_table_schema(
    owner = 'wangzhennan.wzn',
    table_name    = '__all_transfer_task',
    table_id = '423',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('task_id', 'int'),
    ],

    in_tenant_space = True,
    is_cluster_private = False,
    meta_record_in_sys = False,

    normal_columns = [
        ('src_ls', 'int', 'false'),
        ('dest_ls', 'int', 'false'),
        ('part_list', 'longtext', 'true'),
        ('part_count', 'int', 'true'),
        ('not_exist_part_list', 'longtext', 'true'),
        ('lock_conflict_part_list', 'longtext', 'true'),
        ('table_lock_tablet_list', 'longtext', 'true'),
        ('tablet_list', 'longtext', 'true'),
        ('tablet_count', 'int', 'true'),
        ('start_scn', 'uint', 'true'),
        ('finish_scn', 'uint', 'true'),
        ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
        ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'false'),
        ('result', 'int', 'true'),
        ('comment', 'longtext', 'true'),
        ('balance_task_id', 'int', 'false'),
        ('table_lock_owner_id', 'int', 'true'),
        ('data_version', 'varchar:OB_CLUSTER_VERSION_LENGTH', 'false', ''),
    ],
)

def_table_schema(
    owner = 'wangzhennan.wzn',
    table_name    = '__all_transfer_task_history',
    table_id = '424',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('task_id', 'int'),
    ],

    in_tenant_space = True,
    is_cluster_private = False,
    meta_record_in_sys = False,

    normal_columns = [
        ('src_ls', 'int', 'false'),
        ('dest_ls', 'int', 'false'),
        ('part_list', 'longtext', 'true'),
        ('part_count', 'int', 'true'),
        ('not_exist_part_list', 'longtext', 'true'),
        ('lock_conflict_part_list', 'longtext', 'true'),
        ('table_lock_tablet_list', 'longtext', 'true'),
        ('tablet_list', 'longtext', 'true'),
        ('tablet_count', 'int', 'true'),
        ('start_scn', 'uint', 'true'),
        ('finish_scn', 'uint', 'true'),
        ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
        ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'false'),
        ('result', 'int', 'true'),
        ('comment', 'longtext', 'true'),
        ('balance_task_id', 'int', 'false'),
        ('table_lock_owner_id', 'int', 'true'),
        ('create_time', 'timestamp', 'false'),
        ('finish_time', 'timestamp', 'false'),
        ('data_version', 'varchar:OB_CLUSTER_VERSION_LENGTH', 'false', ''),
    ],
)

def_table_schema(
  owner = 'msy164651',
  table_name    = '__all_balance_job',
  table_id = '425',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('job_id', 'int'),
  ],

  in_tenant_space = True,
  is_cluster_private = False,
  meta_record_in_sys = False,

  normal_columns = [
    ('balance_strategy_name', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
    ('job_type', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
    ('target_unit_num', 'int', 'false'),
    ('target_primary_zone_num', 'int', 'false'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
    ('comment', 'longtext', 'true'),
    ('max_end_time', 'timestamp', 'true'),
  ],
)

def_table_schema(
  owner = 'msy164651',
  table_name    = '__all_balance_job_history',
  table_id = '426',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('job_id', 'int'),
  ],

  in_tenant_space = True,
  is_cluster_private = False,
  meta_record_in_sys = False,

  normal_columns = [
    ('balance_strategy_name', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
    ('job_type', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
    ('target_unit_num', 'int', 'false'),
    ('target_primary_zone_num', 'int', 'false'),
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
    ('comment', 'longtext', 'true'),
    ('create_time', 'timestamp', 'false'),
    ('finish_time', 'timestamp', 'false'),
    ('max_end_time', 'timestamp', 'true'),
  ],
)

def_table_schema(
    owner = 'msy164651',
    table_name    = '__all_balance_task',
    table_id = '427',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('task_id', 'int'),
    ],

    in_tenant_space = True,
    is_cluster_private = False,
    meta_record_in_sys = False,

    normal_columns = [
        ('task_type', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
        ('src_ls', 'int', 'false'),
        ('dest_ls', 'int', 'false'),
        ('part_list', 'longtext', 'true'),
        ('finished_part_list', 'longtext', 'true'),
        ('part_count', 'int', 'true'),
        ('finished_part_count', 'int', 'true'),
        ('ls_group_id','int', 'false'),
        ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
        ('parent_list', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH', 'true'),
        ('child_list', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH', 'true'),
        ('current_transfer_task_id', 'int', 'false'),
        ('job_id', 'int', 'false'),
        ('comment', 'longtext', 'true'),
        ('balance_strategy', 'varchar:OB_DEFAULT_STATUS_LENTH', 'true'),
    ],
)

def_table_schema(
    owner = 'msy164651',
    table_name    = '__all_balance_task_history',
    table_id = '428',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('task_id', 'int'),
    ],

    in_tenant_space = True,
    is_cluster_private = False,
    meta_record_in_sys = False,

    normal_columns = [
        ('task_type', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
        ('src_ls', 'int', 'false'),
        ('dest_ls', 'int', 'false'),
        ('part_list', 'longtext', 'true'),
        ('finished_part_list', 'longtext', 'true'),
        ('part_count', 'int', 'true'),
        ('finished_part_count', 'int', 'true'),
        ('ls_group_id','int', 'false'),
        ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
        ('parent_list', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH', 'true'),
        ('child_list', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH', 'true'),
        ('current_transfer_task_id', 'int', 'false'),
        ('job_id', 'int', 'false'),
        ('comment', 'longtext', 'true'),
        ('create_time', 'timestamp', 'false'),
        ('finish_time', 'timestamp', 'false'),
        ('balance_strategy', 'varchar:OB_DEFAULT_STATUS_LENTH', 'true'),
    ],
)


def_table_schema(
    owner = 'jingyu.cr',
    table_name = '__all_arbitration_service',
    table_id = '429',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('arbitration_service_key', 'varchar:OB_MAX_ARBITRATION_SERVICE_NAME_LENGTH'),
    ],

    in_tenant_space = False,
    is_cluster_private = False,

    normal_columns = [
        ('arbitration_service', 'varchar:OB_MAX_ARBITRATION_SERVICE_LENGTH', 'false', '0.0.0.0:0'),
        ('previous_arbitration_service', 'varchar:OB_MAX_ARBITRATION_SERVICE_LENGTH', 'true'),
        ('type', 'varchar:64'),
    ],
)

def_table_schema(
  owner = 'jingyu.cr',
  table_name    = '__all_ls_arb_replica_task',
  table_id = '430',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('task_id', 'int'),
    ('trace_id', 'varchar:OB_TRACE_STAT_BUFFER_SIZE'),
    ('task_type', 'varchar:MAX_ARB_REPLICA_TASK_TYPE_LENGTH'),
    ('arbitration_service', 'varchar:OB_MAX_ARBITRATION_SERVICE_LENGTH', 'false', '0.0.0.0:0'),
    ('arbitration_service_type', 'varchar:64'),
    ('comment', 'varchar:MAX_COLUMN_COMMENT_LENGTH', 'true'),
  ],
)

def_table_schema(
    owner = 'bohou.ws',
    table_name    = '__all_data_dictionary_in_log',
    table_id      = '431',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('snapshot_scn', 'uint'),
    ],
    normal_columns = [
      ('start_lsn', 'uint'),
      ('end_lsn', 'uint')
    ],
    in_tenant_space = True,
    is_cluster_private = False,
)

def_table_schema(
  owner = 'jingyu.cr',
  table_name    = '__all_ls_arb_replica_task_history',
  table_id = '432',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('task_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('execute_result', 'varchar:MAX_COLUMN_COMMENT_LENGTH'),
    ('create_time', 'timestamp', 'false'),
    ('finish_time', 'timestamp', 'false'),
    ('trace_id', 'varchar:OB_TRACE_STAT_BUFFER_SIZE'),
    ('task_type', 'varchar:MAX_ARB_REPLICA_TASK_TYPE_LENGTH'),
    ('arbitration_service', 'varchar:OB_MAX_ARBITRATION_SERVICE_LENGTH', 'false', '0.0.0.0:0'),
    ('arbitration_service_type', 'varchar:64'),
    ('comment', 'varchar:MAX_COLUMN_COMMENT_LENGTH', 'true'),
  ],
)

all_rls_policy_def = dict(
  owner = 'sean.yyj',
  table_name = '__all_rls_policy',
  table_id = '433',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('rls_policy_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
    ('policy_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
    ('table_id', 'int'),
    ('rls_group_id', 'int'),
    ('stmt_type', 'int'),
    ('check_opt', 'bool', 'false', 'false'),
    ('enable_flag', 'bool', 'false', 'true'),
    ('policy_function_schema', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
    ('policy_package_name', 'varchar:OB_MAX_PACKAGE_NAME_LENGTH'),
    ('policy_function_name', 'varchar:OB_MAX_PACKAGE_NAME_LENGTH'),
  ],
)

def_table_schema(**all_rls_policy_def)
def_table_schema(**gen_history_table_def(434, all_rls_policy_def))

all_rls_column_def = dict(
  owner = 'sean.yyj',
  table_name = '__all_rls_security_column',
  table_id = '435',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('rls_policy_id', 'int'),
    ('column_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [],
)

def_table_schema(**all_rls_column_def)
def_table_schema(**gen_history_table_def(436, all_rls_column_def))

all_rls_group_def = dict(
  owner = 'sean.yyj',
  table_name = '__all_rls_group',
  table_id = '437',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('rls_group_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
    ('policy_group_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
    ('table_id', 'int'),
  ],
)

def_table_schema(**all_rls_group_def)
def_table_schema(**gen_history_table_def(438, all_rls_group_def))

all_rls_context_def = dict(
  owner = 'sean.yyj',
  table_name = '__all_rls_context',
  table_id = '439',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('rls_context_id', 'int'),
  ],

  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
    ('table_id', 'int'),
    ('context_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
    ('attribute', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
  ],
)

def_table_schema(**all_rls_context_def)
def_table_schema(**gen_history_table_def(440, all_rls_context_def))

all_rls_attribute_def = dict(
  owner = 'sean.yyj',
  table_name = '__all_rls_attribute',
  table_id = '441',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('rls_policy_id', 'int'),
    ('rls_attribute_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,

  normal_columns = [
    ('context_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
    ('attribute', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
  ],
)

def_table_schema(**all_rls_attribute_def)
def_table_schema(**gen_history_table_def(442, all_rls_attribute_def))

def_table_schema(
  owner = 'luofan.zp',
  table_name    = '__all_tenant_rewrite_rules',
  table_id      = '443',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('rule_name', 'varchar:OB_MAX_ORIGINAL_NANE_LENGTH'),
  ],

  in_tenant_space = True,
  is_cluster_private = False,
  meta_record_in_sys = False,

  normal_columns = [
    ('rule_id', 'int'),
    ('pattern', 'longtext'),
    ('db_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
    ('replacement', 'longtext'),
    ('normalized_pattern', 'longtext'),
    ('status', 'int'),
    ('version', 'int'),
    ('pattern_digest', 'uint'),
    ('fixed_param_infos', 'longtext', 'false', ''),
    ('dynamic_param_infos', 'longtext', 'false', ''),
    ('def_name_ctx_str', 'longtext', 'false', '')
  ],
)

def_table_schema(
  owner = 'handora.qc',
  table_name    = '__all_reserved_snapshot',
  table_id      = '444',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('snapshot_type', 'uint'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'uint'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('create_time', 'uint'),
    ('snapshot_version', 'uint'),
    ('status', 'uint'),
  ],
)

def_table_schema(
    owner = 'yanmu.ztl',
    table_name = '__all_cluster_event_history',
    table_id = '445',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
      ('gmt_create', 'timestamp:6', 'false')
    ],
    normal_columns = [
      ('module', 'varchar:MAX_CLUSTER_EVENT_NAME_LENGTH', 'false'),
      ('event', 'varchar:MAX_CLUSTER_EVENT_NAME_LENGTH', 'false'),
      ('name1', 'varchar:MAX_CLUSTER_EVENT_NAME_LENGTH', 'false', ''),
      ('value1', 'varchar:MAX_CLUSTER_EVENT_VALUE_LENGTH', 'false', ''),
      ('name2', 'varchar:MAX_CLUSTER_EVENT_NAME_LENGTH', 'false', ''),
      ('value2', 'varchar:MAX_CLUSTER_EVENT_VALUE_LENGTH', 'false', ''),
      ('name3', 'varchar:MAX_CLUSTER_EVENT_NAME_LENGTH', 'false', ''),
      ('value3', 'varchar:MAX_CLUSTER_EVENT_VALUE_LENGTH', 'false', ''),
      ('name4', 'varchar:MAX_CLUSTER_EVENT_NAME_LENGTH', 'false', ''),
      ('value4', 'varchar:MAX_CLUSTER_EVENT_VALUE_LENGTH', 'false', ''),
      ('name5', 'varchar:MAX_CLUSTER_EVENT_NAME_LENGTH', 'false', ''),
      ('value5', 'varchar:MAX_CLUSTER_EVENT_VALUE_LENGTH', 'false', ''),
      ('name6', 'varchar:MAX_CLUSTER_EVENT_NAME_LENGTH', 'false', ''),
      ('value6', 'varchar:MAX_CLUSTER_EVENT_VALUE_LENGTH', 'false', ''),
      ('extra_info', 'varchar:MAX_CLUSTER_EVENT_VALUE_LENGTH', 'false', '')
    ],
)

def_table_schema(
  owner = 'yangyi.yyy',
  table_name    = '__all_ls_transfer_member_list_lock_info',
  table_id      = '446',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('ls_id', 'int'),
    ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
      ('task_id', 'int'),
      ('status', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
      ('lock_owner', 'int'),
      ('comment', 'longtext', 'true'),
    ],
)
# 447 : __all_ls_log_restore_stat
# 448 : __all_backup_transferring_tablets
# 449 : __all_wait_for_partition_split_tablet

def_table_schema(
  owner = 'jim.wjh',
  table_name    = '__all_external_table_file',
  table_id      = '450',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
      ('table_id', 'int'),
      ('part_id', 'int'),
      ('file_id', 'int'),
  ],
  normal_columns = [
    ('file_url', 'varbinary:16384'),
    ('create_version', 'int'),
    ('delete_version', 'int'),
    ('file_size', 'int'),
  ],
  in_tenant_space = True,
)

def_table_schema(
    owner = 'jiangxiu.wt',
    table_name = '__all_task_opt_stat_gather_history',
    table_id = '451',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
      ('tenant_id', 'int'),
      ('task_id', 'varchar:36')
    ],
    in_tenant_space = True,
    is_cluster_private = True,
    meta_record_in_sys = False,
    normal_columns = [
      ('type', 'int', 'true'),
      ('ret_code', 'int', 'true'),
      ('table_count', 'int', 'true'),
      ('failed_count', 'int', 'true'),
      ('start_time', 'timestamp'),
      ('end_time', 'timestamp'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare4', 'varchar:MAX_VALUE_LENGTH', 'true'),
    ],
)

def_table_schema(
    owner = 'jiangxiu.wt',
    table_name = '__all_table_opt_stat_gather_history',
    table_id = '452',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
      ('tenant_id', 'int'),
      ('task_id', 'varchar:36'),
      ('table_id', 'int'),
    ],
    in_tenant_space = True,
    is_cluster_private = True,
    meta_record_in_sys = False,
    normal_columns = [
      ('ret_code', 'int', 'true'),
      ('start_time', 'timestamp', 'true'),
      ('end_time', 'timestamp', 'true'),
      ('memory_used', 'int', 'true'),
      ('stat_refresh_failed_list', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('properties', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare1', 'int', 'true'),
      ('spare2', 'int', 'true'),
      ('spare3', 'varchar:MAX_VALUE_LENGTH', 'true'),
      ('spare4', 'varchar:MAX_VALUE_LENGTH', 'true'),
    ],
)

def_table_schema(
  owner = 'xiaotao.ht',
  table_name    = '__all_zone_storage',
  table_id      = '453',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('zone', 'varchar:MAX_ZONE_LENGTH'),
    ('path', 'varchar:MAX_PATH_SIZE'),
    ('endpoint', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
    ('used_for', 'varchar:OB_MAX_CHAR_LENGTH'),
  ],
  in_tenant_space = False,
  is_cluster_private = True,
  normal_columns = [
    ('storage_id', 'int'),
    ('authorization', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
    ('encrypt_info', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH', 'true', ''),
    ('max_iops', 'int', 'true', -1),
    ('max_bandwidth', 'int', 'true', -1),
    ('state', 'varchar:OB_MAX_CHAR_LENGTH'),
    ('op_id', 'int'),
    ('extension', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', '')
  ],
)


def_table_schema(
  owner = 'xiaotao.ht',
  table_name    = '__all_zone_storage_operation',
  table_id      = '454',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('storage_id', 'bigint:20'),
    ('op_id', 'bigint:20'),
    ('sub_op_id', 'bigint:20'),
  ],
  in_tenant_space = False,
  is_cluster_private = True,
  normal_columns = [
    ('zone', 'varchar:MAX_ZONE_LENGTH'),
    ('op_type', 'varchar:OB_MAX_CHAR_LENGTH'),
    ('op_info', 'varchar:OB_MAX_STORAGE_OPERATION_INFO_LENGTH', 'true', '')
  ],
)
# 455 : __wr_active_session_history
def_table_schema(
  owner = 'roland.qk',
  table_name    = '__wr_active_session_history',
  table_id      = '455',
  table_type = 'SYSTEM_TABLE',
  gm_columns    = [],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('cluster_id', 'int'),
    ('snap_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('sample_id', 'int'),
    ('session_id', 'int'),
  ],
  in_tenant_space=True,
  is_cluster_private=True,
  meta_record_in_sys = False,
  normal_columns = [
    ('sample_time', 'timestamp'),
    ('user_id', 'int', 'true'),
    ('session_type', 'bool', 'true'),
    ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH', 'true'),
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true'),
    ('event_no', 'int', 'true'),
    ('time_waited', 'int', 'true'),
    ('p1', 'int', 'true'),
    ('p2', 'int', 'true'),
    ('p3', 'int', 'true'),
    ('sql_plan_line_id', 'int', 'true'),
    ('time_model', 'uint', 'true'),
    ('module', 'varchar:64', 'true'),
    ('action', 'varchar:64', 'true'),
    ('client_id', 'varchar:64', 'true'),
    ('backtrace', 'varchar:512', 'true'),
    ('plan_id', 'int', 'true'),
    ('program', 'varchar:64', 'true'),
    ('tm_delta_time', 'int', 'true'),
    ('tm_delta_cpu_time', 'int', 'true'),
    ('tm_delta_db_time', 'int', 'true'),
    ('top_level_sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH', 'true'),
    ('plsql_entry_object_id', 'int', 'true'),
    ('plsql_entry_subprogram_id', 'int', 'true'),
    ('plsql_entry_subprogram_name', 'varchar:32', 'true'),
    ('plsql_object_id', 'int', 'true'),
    ('plsql_subprogram_id', 'int', 'true'),
    ('plsql_subprogram_name', 'varchar:32', 'true'),
    ('event_id', 'int', 'true'),
    ('group_id', 'int', 'true'),
    ('tx_id', 'int', 'true'),
    ('blocking_session_id', 'int', 'true'),
    ('plan_hash', 'uint', 'true'),
    ('thread_id', 'int', 'true'),
    ('stmt_type', 'int', 'true'),
    ('tablet_id', 'int', 'true'),
    ('proxy_sid', 'int', 'true'),
    ('delta_read_io_requests', 'int', 'true', '0'),
    ('delta_read_io_bytes', 'int', 'true', '0'),
    ('delta_write_io_requests', 'int', 'true', '0'),
    ('delta_write_io_bytes', 'int', 'true', '0')
  ],
)

# 456 : __wr_snapshot
def_table_schema(
    owner = 'yuchen.wyc',
    table_id = 456,
    table_name = '__wr_snapshot',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
      ('tenant_id', 'int'),
      ('cluster_id', 'int'),
      ('snap_id', 'int'),
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
    ],

    in_tenant_space=True,
    is_cluster_private=True,
    meta_record_in_sys = False,

    normal_columns = [
        ('begin_interval_time', 'timestamp'),
        ('end_interval_time', 'timestamp'),
        ('snap_flag', 'int','true'),
        ('startup_time', 'timestamp','true'),
        ('status', 'int','true')
    ],
)

# 457 : __wr_statname
def_table_schema(
    owner = 'yuchen.wyc',
    table_id = 457,
    table_name = '__wr_statname',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('cluster_id', 'int'),
        ('stat_id', 'int'),
    ],

    in_tenant_space=True,
    is_cluster_private=True,
    meta_record_in_sys = False,

    normal_columns = [
        ('stat_name', 'varchar:64')
    ],
)

# 458 : __wr_sysstat
def_table_schema(
    owner = 'yuchen.wyc',
    table_id = 458,
    table_name = '__wr_sysstat',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('cluster_id', 'int'),
        ('snap_id', 'int'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
        ('stat_id', 'int'),
    ],

    in_tenant_space=True,
    is_cluster_private=True,
    meta_record_in_sys = False,

    normal_columns = [
        ('value', 'int','true')
    ],
)

def_table_schema(
  owner = 'msy164651',
  table_name    = '__all_balance_task_helper',
  table_id      = '459',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('operation_scn', 'uint', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('operation_type', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false', ''),
    ('src_ls', 'int', 'false'),
    ('dest_ls', 'int', 'false'),
    ('ls_group_id', 'int', 'false'),
  ],
)

def_table_schema(
  owner = 'chensen.cs',
  table_name    = '__all_tenant_snapshot',
  table_id      = '460',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('snapshot_id', 'int', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('snapshot_name', 'varchar:OB_MAX_TENANT_SNAPSHOT_NAME_LENGTH_STORE', 'false'),
    ('status', 'varchar:32', 'false'),
    ('snapshot_scn', 'uint', 'false'),
    ('clog_start_scn', 'uint', 'false'),
    ('type', 'varchar:16', 'false'),
    ('create_time', 'timestamp', 'false'),
    ('data_version', 'uint', 'false'),
    ('owner_job_id', 'int', 'false')
  ],
)

def_table_schema(
  owner = 'chensen.cs',
  table_name    = '__all_tenant_snapshot_ls',
  table_id      = '461',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('snapshot_id', 'int', 'false'),
    ('ls_id', 'int', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('ls_group_id', 'int', 'false'),
    ('status', 'varchar:100', 'false'),
    ('flag', 'varchar:OB_MAX_LS_FLAG_LENGTH', 'false'),
    ('create_scn', 'uint', 'false'),
  ],
)

def_table_schema(
  owner = 'chensen.cs',
  table_name    = '__all_tenant_snapshot_ls_replica',
  table_id      = '462',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('snapshot_id', 'int', 'false'),
    ('ls_id', 'int', 'false'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
    ('svr_port', 'int', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
    ('zone', 'varchar:MAX_ZONE_LENGTH', 'false'),
    ('unit_id', 'int', 'false'),
    ('begin_interval_scn', 'uint', 'false'),
    ('end_interval_scn', 'uint', 'false'),
    ('ls_meta_package', 'longtext', 'true')
  ],
)

def_table_schema(
  owner = 'suzhi.yt',
  table_name = '__all_mlog',
  table_id = '463',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('mlog_id', 'int')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('purge_mode', 'int'),
    ('purge_start', 'timestamp', 'true'),
    ('purge_next', 'varchar:OB_MAX_FUNC_EXPR_LENGTH', 'true'),
    ('purge_job', 'varchar:OB_MAX_SCHEDULER_JOB_NAME_LENGTH', 'true'),
    ('last_purge_scn', 'uint', 'true'),
    ('last_purge_date', 'timestamp', 'true'),
    ('last_purge_time', 'int', 'true'),
    ('last_purge_rows', 'int', 'true'),
    ('last_purge_trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true'),
    ('schema_version', 'int')
  ]
)

def_table_schema(
  owner = 'suzhi.yt',
  table_name = '__all_mview',
  table_id = '464',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('mview_id', 'int')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('build_mode', 'int'),
    ('refresh_mode', 'int'),
    ('refresh_method', 'int'),
    ('refresh_start', 'timestamp', 'true'),
    ('refresh_next', 'varchar:OB_MAX_FUNC_EXPR_LENGTH', 'true'),
    ('refresh_job', 'varchar:OB_MAX_SCHEDULER_JOB_NAME_LENGTH', 'true'),
    ('last_refresh_scn', 'uint', 'true'),
    ('last_refresh_type', 'int', 'true'),
    ('last_refresh_date', 'timestamp', 'true'),
    ('last_refresh_time', 'int', 'true'),
    ('last_refresh_trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true'),
    ('schema_version', 'int'),
    ('refresh_dop', 'int', 'false', '0')
  ]
)

def_table_schema(
  owner = 'suzhi.yt',
  table_name = '__all_mview_refresh_stats_sys_defaults',
  table_id = '465',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('collection_level', 'int'),
    ('retention_period', 'int')
  ]
)

def_table_schema(
  owner = 'suzhi.yt',
  table_name = '__all_mview_refresh_stats_params',
  table_id = '466',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('mview_id', 'int')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('collection_level', 'int'),
    ('retention_period', 'int')
  ]
)

def_table_schema(
  owner = 'suzhi.yt',
  table_name = '__all_mview_refresh_run_stats',
  table_id = '467',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('refresh_id', 'int')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('run_user_id', 'int'),
    ('num_mvs_total', 'int'),
    ('num_mvs_current', 'int'),
    ('mviews', 'varchar:4000'),
    ('base_tables', 'varchar:4000', 'true'),
    ('method', 'varchar:4000', 'true'),
    ('rollback_seg', 'varchar:4000', 'true'),
    ('push_deferred_rpc', 'bool'),
    ('refresh_after_errors', 'bool'),
    ('purge_option', 'int'),
    ('parallelism', 'int'),
    ('heap_size', 'int'),
    ('atomic_refresh', 'bool'),
    ('nested', 'bool'),
    ('out_of_place', 'bool'),
    ('number_of_failures', 'int'),
    ('start_time', 'timestamp'),
    ('end_time', 'timestamp'),
    ('elapsed_time', 'int'),
    ('log_purge_time', 'int'),
    ('complete_stats_avaliable', 'bool'),
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true')
  ]
)

def_table_schema(
  owner = 'suzhi.yt',
  table_name = '__all_mview_refresh_stats',
  table_id = '468',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('refresh_id', 'int'),
    ('mview_id', 'int'),
    ('retry_id', 'int')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('refresh_type', 'int'),
    ('start_time', 'timestamp'),
    ('end_time', 'timestamp'),
    ('elapsed_time', 'int'),
    ('log_purge_time', 'int'),
    ('initial_num_rows', 'int'),
    ('final_num_rows', 'int'),
    ('num_steps', 'int'),
    ('result', 'int')
  ]
)

def_table_schema(
  owner = 'suzhi.yt',
  table_name = '__all_mview_refresh_change_stats',
  table_id = '469',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('refresh_id', 'int'),
    ('mview_id', 'int'),
    ('retry_id', 'int'),
    ('detail_table_id', 'int')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('num_rows_ins', 'int', 'true'),
    ('num_rows_upd', 'int', 'true'),
    ('num_rows_del', 'int', 'true'),
    ('num_rows', 'int', 'true')
  ]
)

def_table_schema(
  owner = 'suzhi.yt',
  table_name = '__all_mview_refresh_stmt_stats',
  table_id = '470',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('refresh_id', 'int'),
    ('mview_id', 'int'),
    ('retry_id', 'int'),
    ('step', 'int')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('sqlid', 'varchar:OB_MAX_SQL_ID_LENGTH', 'true'),
    ('stmt', 'longtext'),
    ('execution_time', 'int'),
    ('execution_plan', 'longtext', 'true'),
    ('result', 'int')
  ]
)

# 471 : __all_dbms_lock_allocated
# 472 : __wr_control

def_table_schema(
    owner = 'yangyifei.yyf',
    table_name = '__all_dbms_lock_allocated',
    table_id = '471',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
      ('name', 'varchar:128', 'false'),
    ],
    in_tenant_space = True,
    is_cluster_private = False,
    meta_record_in_sys = False,
    normal_columns = [
      ('lockid', 'int'),
      ('lockhandle', 'varchar:128'),
      ('expiration', 'timestamp'),
    ],
)

def_table_schema(
    owner = 'yuchen.wyc',
    table_id = 472,
    table_name = '__wr_control',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
      ('tenant_id', 'int')
    ],

    in_tenant_space=True,
    is_cluster_private=True,
    meta_record_in_sys = False,

    normal_columns = [
      ('snap_interval', 'varchar:64'),
      ('snapint_num', 'int'),
      ('retention', 'varchar:64'),
      ('retention_num', 'int'),
      ('most_recent_snap_id', 'int', 'true'),
      ('most_recent_snap_time', 'timestamp', 'true'),
      ('mrct_baseline_id', 'int', 'true'),
      ('topnsql', 'int'),
      ('mrct_bltmpl_id', 'int', 'true'),
    ],
)

def_table_schema(
  owner = 'wanhong.wwh',
  table_name = '__all_tenant_event_history',
  table_id = '473',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
    ('tenant_id', 'int', 'false', 'OB_INVALID_TENANT_ID'),
    ('gmt_create', 'timestamp:6', 'false')
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('module', 'varchar:MAX_TENANT_EVENT_NAME_LENGTH', 'false', ''),
    ('event', 'varchar:MAX_TENANT_EVENT_NAME_LENGTH', 'false', ''),
    ('name1', 'varchar:MAX_TENANT_EVENT_NAME_LENGTH', 'true'),
    ('value1', 'longtext', 'true'),
    ('name2', 'varchar:MAX_TENANT_EVENT_NAME_LENGTH', 'true'),
    ('value2', 'longtext', 'true'),
    ('name3', 'varchar:MAX_TENANT_EVENT_NAME_LENGTH', 'true'),
    ('value3', 'longtext', 'true'),
    ('name4', 'varchar:MAX_TENANT_EVENT_NAME_LENGTH', 'true'),
    ('value4', 'longtext', 'true'),
    ('name5', 'varchar:MAX_TENANT_EVENT_NAME_LENGTH', 'true'),
    ('value5', 'longtext', 'true'),
    ('name6', 'varchar:MAX_TENANT_EVENT_NAME_LENGTH', 'true'),
    ('value6', 'longtext', 'true'),
    ('extra_info', 'longtext', 'true'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('svr_port', 'int', 'true'),
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true'),
    ('cost_time', 'int', 'true'),
    ('ret_code', 'int', 'true'),
    ('error_msg', 'varchar:OB_MAX_ERROR_MSG_LEN', 'true'),
  ],
)

def_table_schema(
  table_name     = '__all_tenant_scheduler_job_class',
  owner          = 'huangrenhuang.hrh',
  table_id       = '474',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_class_name', 'varchar:30', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    ('resource_consumer_group', 'varchar:30', 'true'),
    ('service', 'varchar:64', 'true'),
    ('logging_level', 'varchar:11', 'true'),
    ('log_history', 'number:38:0', 'true'),
    ('comments', 'varchar:240', 'true'),
  ],
)

def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_recover_table_job',
  table_id      = '475',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('job_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
      ('initiator_tenant_id', 'int'),
      ('initiator_job_id', 'int'),
      ('start_ts', 'int'),
      ('end_ts', 'int'),
      ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
      ('aux_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH'),
      ('target_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH'),
      ('target_tenant_id', 'int'),
      ('import_all', 'bool'),
      ('db_list', 'longtext', 'true', ''),
      ('hex_db_list', 'longtext', 'true', ''),
      ('table_list', 'longtext', 'true', ''),
      ('hex_table_list', 'longtext', 'true', ''),
      ('partition_list', 'longtext', 'true', ''),
      ('hex_partition_list', 'longtext', 'true', ''),
      ('restore_scn', 'uint'),
      ('restore_option', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
      ('backup_dest', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
      ('backup_set_list', 'longtext'),
      ('backup_piece_list', 'longtext'),
      ('backup_passwd', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
      ('external_kms_info', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
      ('remap_db_list', 'longtext', 'true', ''),
      ('hex_remap_db_list', 'longtext', 'true', ''),
      ('remap_table_list', 'longtext', 'true', ''),
      ('hex_remap_table_list', 'longtext', 'true', ''),
      ('remap_partition_list', 'longtext', 'true', ''),
      ('hex_remap_partition_list', 'longtext', 'true', ''),
      ('remap_tablegroup_list', 'longtext', 'true', ''),
      ('hex_remap_tablegroup_list', 'longtext', 'true', ''),
      ('remap_tablespace_list', 'longtext', 'true', ''),
      ('hex_remap_tablespace_list', 'longtext', 'true', ''),
      ('result', 'varchar:OB_DEFAULT_STATUS_LENTH', 'true', ''),
      ('comment', 'longtext', 'true', ''),
      ('description', 'longtext', 'true', ''),
  ],
)

def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_recover_table_job_history',
  table_id      = '476',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('job_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
      ('initiator_tenant_id', 'int'),
      ('initiator_job_id', 'int'),
      ('start_ts', 'int'),
      ('end_ts', 'int'),
      ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
      ('aux_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH'),
      ('target_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH'),
      ('target_tenant_id', 'int'),
      ('import_all', 'bool'),
      ('db_list', 'longtext', 'true', ''),
      ('hex_db_list', 'longtext', 'true', ''),
      ('table_list', 'longtext', 'true', ''),
      ('hex_table_list', 'longtext', 'true', ''),
      ('partition_list', 'longtext', 'true', ''),
      ('hex_partition_list', 'longtext', 'true', ''),
      ('restore_scn', 'uint'),
      ('restore_option', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
      ('backup_dest', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
      ('backup_set_list', 'longtext'),
      ('backup_piece_list', 'longtext'),
      ('backup_passwd', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
      ('external_kms_info', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH', 'true', ''),
      ('remap_db_list', 'longtext', 'true', ''),
      ('hex_remap_db_list', 'longtext', 'true', ''),
      ('remap_table_list', 'longtext', 'true', ''),
      ('hex_remap_table_list', 'longtext', 'true', ''),
      ('remap_partition_list', 'longtext', 'true', ''),
      ('hex_remap_partition_list', 'longtext', 'true', ''),
      ('remap_tablegroup_list', 'longtext', 'true', ''),
      ('hex_remap_tablegroup_list', 'longtext', 'true', ''),
      ('remap_tablespace_list', 'longtext', 'true', ''),
      ('hex_remap_tablespace_list', 'longtext', 'true', ''),
      ('result', 'varchar:OB_DEFAULT_STATUS_LENTH', 'true', ''),
      ('comment', 'longtext', 'true', ''),
      ('description', 'longtext', 'true', ''),
  ],
)

def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_import_table_job',
  table_id      = '477',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('job_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
      ('initiator_tenant_id', 'int'),
      ('initiator_job_id', 'int'),
      ('start_ts', 'int'),
      ('end_ts', 'int'),
      ('src_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH'),
      ('src_tenant_id', 'int'),
      ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
      ('import_all', 'bool'),
      ('db_list', 'longtext', 'true', ''),
      ('hex_db_list', 'longtext', 'true', ''),
      ('table_list', 'longtext', 'true', ''),
      ('hex_table_list', 'longtext', 'true', ''),
      ('partition_list', 'longtext', 'true', ''),
      ('hex_partition_list', 'longtext', 'true', ''),
      ('remap_db_list', 'longtext', 'true', ''),
      ('hex_remap_db_list', 'longtext', 'true', ''),
      ('remap_table_list', 'longtext', 'true', ''),
      ('hex_remap_table_list', 'longtext', 'true', ''),
      ('remap_partition_list', 'longtext', 'true', ''),
      ('hex_remap_partition_list', 'longtext', 'true', ''),
      ('remap_tablegroup_list', 'longtext', 'true', ''),
      ('hex_remap_tablegroup_list', 'longtext', 'true', ''),
      ('remap_tablespace_list', 'longtext', 'true', ''),
      ('hex_remap_tablespace_list', 'longtext', 'true', ''),
      ('total_table_count', 'int'),
      ('finished_table_count', 'int'),
      ('failed_table_count', 'int'),
      ('total_bytes', 'int'),
      ('finished_bytes', 'int'),
      ('failed_bytes', 'int'),
      ('result', 'varchar:OB_DEFAULT_STATUS_LENTH', 'true', ''),
      ('comment', 'longtext', 'true', ''),
      ('description', 'longtext', 'true', ''),
  ],
)

def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_import_table_job_history',
  table_id      = '478',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('job_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
      ('initiator_tenant_id', 'int'),
      ('initiator_job_id', 'int'),
      ('start_ts', 'int'),
      ('end_ts', 'int'),
      ('src_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH'),
      ('src_tenant_id', 'int'),
      ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
      ('import_all', 'bool'),
      ('db_list', 'longtext', 'true', ''),
      ('hex_db_list', 'longtext', 'true', ''),
      ('table_list', 'longtext', 'true', ''),
      ('hex_table_list', 'longtext', 'true', ''),
      ('partition_list', 'longtext', 'true', ''),
      ('hex_partition_list', 'longtext', 'true', ''),
      ('remap_db_list', 'longtext', 'true', ''),
      ('hex_remap_db_list', 'longtext', 'true', ''),
      ('remap_table_list', 'longtext', 'true', ''),
      ('hex_remap_table_list', 'longtext', 'true', ''),
      ('remap_partition_list', 'longtext', 'true', ''),
      ('hex_remap_partition_list', 'longtext', 'true', ''),
      ('remap_tablegroup_list', 'longtext', 'true', ''),
      ('hex_remap_tablegroup_list', 'longtext', 'true', ''),
      ('remap_tablespace_list', 'longtext', 'true', ''),
      ('hex_remap_tablespace_list', 'longtext', 'true', ''),
      ('total_table_count', 'int'),
      ('finished_table_count', 'int'),
      ('failed_table_count', 'int'),
      ('total_bytes', 'int'),
      ('finished_bytes', 'int'),
      ('failed_bytes', 'int'),
      ('result', 'varchar:OB_DEFAULT_STATUS_LENTH', 'true', ''),
      ('comment', 'longtext', 'true', ''),
      ('description', 'longtext', 'true', ''),
  ],
)

def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_import_table_task',
  table_id      = '479',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('task_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
      ('job_id', 'int'),
      ('src_tenant_id', 'int'),
      ('src_tablespace', 'varchar:OB_MAX_TABLESPACE_NAME_LENGTH', 'true', ''),
      ('src_tablegroup', 'varchar:OB_MAX_TABLEGROUP_NAME_LENGTH', 'true', ''),
      ('src_database', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true', ''),
      ('src_table', 'varchar:OB_MAX_USER_TABLE_NAME_LENGTH_ORACLE', 'true', ''),
      ('src_partition', 'varchar:OB_MAX_PARTITION_NAME_LENGTH', 'true', ''),
      ('target_tablespace', 'varchar:OB_MAX_TABLESPACE_NAME_LENGTH', 'true', ''),
      ('target_tablegroup', 'varchar:OB_MAX_TABLEGROUP_NAME_LENGTH', 'true', ''),
      ('target_database', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true', ''),
      ('target_table', 'varchar:OB_MAX_USER_TABLE_NAME_LENGTH_ORACLE', 'true', ''),
      ('table_column', 'int'),
      ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
      ('start_ts', 'int'),
      ('completion_ts', 'int'),
      ('cumulative_ts', 'int'),
      ('total_bytes', 'int'),
      ('total_rows', 'int'),
      ('imported_bytes', 'int'),
      ('imported_rows', 'int'),
      ('total_index_count', 'int'),
      ('imported_index_count', 'int'),
      ('failed_index_count', 'int'),
      ('total_constraint_count', 'int'),
      ('imported_constraint_count', 'int'),
      ('failed_constraint_count', 'int'),
      ('total_ref_constraint_count', 'int'),
      ('imported_ref_constraint_count', 'int'),
      ('failed_ref_constraint_count', 'int'),
      ('total_trigger_count', 'int'),
      ('imported_trigger_count', 'int'),
      ('failed_trigger_count', 'int'),
      ('result', 'varchar:OB_DEFAULT_STATUS_LENTH', 'true', ''),
      ('comment', 'longtext', 'true', ''),
  ],
)

def_table_schema(
  owner = 'chongrong.th',
  table_name    = '__all_import_table_task_history',
  table_id      = '480',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('task_id', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
      ('job_id', 'int'),
      ('src_tenant_id', 'int'),
      ('src_tablespace', 'varchar:OB_MAX_TABLESPACE_NAME_LENGTH', 'true', ''),
      ('src_tablegroup', 'varchar:OB_MAX_TABLEGROUP_NAME_LENGTH', 'true', ''),
      ('src_database', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true', ''),
      ('src_table', 'varchar:OB_MAX_USER_TABLE_NAME_LENGTH_ORACLE', 'true', ''),
      ('src_partition', 'varchar:OB_MAX_PARTITION_NAME_LENGTH', 'true', ''),
      ('target_tablespace', 'varchar:OB_MAX_TABLESPACE_NAME_LENGTH', 'true', ''),
      ('target_tablegroup', 'varchar:OB_MAX_TABLEGROUP_NAME_LENGTH', 'true', ''),
      ('target_database', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true', ''),
      ('target_table', 'varchar:OB_MAX_USER_TABLE_NAME_LENGTH_ORACLE', 'true', ''),
      ('table_column', 'int'),
      ('status', 'varchar:OB_DEFAULT_STATUS_LENTH'),
      ('start_ts', 'int'),
      ('completion_ts', 'int'),
      ('cumulative_ts', 'int'),
      ('total_bytes', 'int'),
      ('total_rows', 'int'),
      ('imported_bytes', 'int'),
      ('imported_rows', 'int'),
      ('total_index_count', 'int'),
      ('imported_index_count', 'int'),
      ('failed_index_count', 'int'),
      ('total_constraint_count', 'int'),
      ('imported_constraint_count', 'int'),
      ('failed_constraint_count', 'int'),
      ('total_ref_constraint_count', 'int'),
      ('imported_ref_constraint_count', 'int'),
      ('failed_ref_constraint_count', 'int'),
      ('total_trigger_count', 'int'),
      ('imported_trigger_count', 'int'),
      ('failed_trigger_count', 'int'),
      ('result', 'varchar:OB_DEFAULT_STATUS_LENTH', 'true', ''),
      ('comment', 'longtext', 'true', ''),
  ],
)


# 481 : __all_import_stmt_exec_history

def_table_schema(
    owner = 'hanxuan.gzh',
    table_name = '__all_tablet_reorganize_history',
    table_id      = '482',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('ls_id', 'int'),
        ('src_tablet_id', 'int'),
        ('dest_tablet_id', 'int'),
    ],
    is_cluster_private = False,
    in_tenant_space = True,

    normal_columns = [
      ('type', 'int'),
      ('create_time', 'timestamp'),
      ('finish_time', 'timestamp'),
    ],
)

def_table_schema(
  owner = 'zhixing.yh',
  table_name    = '__all_storage_ha_error_diagnose_history',
  table_id      = '483',
  table_type = 'SYSTEM_TABLE',
  in_tenant_space = False,
  gm_columns    = [],
  rowkey_columns = [
    ('gmt_create', 'timestamp', 'false'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int')
  ],
  normal_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('module', 'varchar:OB_MODULE_NAME_LENGTH'),
    ('type', 'varchar:OB_SYS_TASK_TYPE_LENGTH'),
    ('task_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
    ('retry_id', 'int'),
    ('create_time', 'timestamp'),
    ('result_code', 'int'),
    ('result_msg', 'varchar:OB_DIAGNOSE_INFO_LENGTH'),
    ('info', 'longtext')
  ],
)

def_table_schema(
  owner = 'zhixing.yh',
  table_name    = '__all_storage_ha_perf_diagnose_history',
  table_id      = '484',
  table_type = 'SYSTEM_TABLE',
  in_tenant_space = False,
  gm_columns    = [],
  rowkey_columns = [
    ('gmt_create', 'timestamp', 'false'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int')
  ],
  normal_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('module', 'varchar:OB_MODULE_NAME_LENGTH'),
    ('type', 'varchar:OB_SYS_TASK_TYPE_LENGTH'),
    ('task_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
    ('retry_id', 'int'),
    ('start_timestamp', 'timestamp'),
    ('end_timestamp', 'timestamp'),
    ('tablet_id', 'int'),
    ('tablet_count', 'int'),
    ('result_code', 'int'),
    ('result_msg', 'varchar:OB_DIAGNOSE_INFO_LENGTH'),
    ('info', 'longtext'),
  ],
)

def_table_schema(
  owner = 'chensen.cs',
  table_name    = '__all_clone_job',
  table_id      = '485',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'false'),
    ('source_tenant_id', 'int', 'false'),
    ('source_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE', 'false'),
    ('clone_tenant_id', 'int', 'false', 'OB_INVALID_TENANT_ID'),
    ('clone_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE', 'false'),
    ('tenant_snapshot_id', 'int', 'false'),
    ('tenant_snapshot_name', 'varchar:OB_MAX_TENANT_SNAPSHOT_NAME_LENGTH_STORE', 'false'),
    ('resource_pool_id', 'int', 'false'),
    ('resource_pool_name', 'varchar:MAX_RESOURCE_POOL_LENGTH', 'false'),
    ('unit_config_name', 'varchar:MAX_UNIT_CONFIG_LENGTH', 'false'),
    ('restore_scn', 'uint', 'false', '0'),
    ('status', 'varchar:64', 'false'),
    ('job_type', 'varchar:16', 'false'),
    ('clone_start_time', 'timestamp', 'false'),
    ('clone_finished_time', 'timestamp', 'true'),
    ('ret_code', 'int', 'true'),
    ('error_msg', 'varchar:OB_MAX_ERROR_MSG_LEN', 'true'),
    ('data_version', 'uint', 'false', '0'),
    ('min_cluster_version', 'uint', 'false', '0'),
  ],
)

all_clone_job_history_def = dict(
  owner = 'chensen.cs',
  table_name    = '__all_clone_job_history',
  table_id      = '486',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('job_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'false'),
    ('source_tenant_id', 'int', 'false'),
    ('source_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE', 'false'),
    ('clone_tenant_id', 'int', 'false', 'OB_INVALID_TENANT_ID'),
    ('clone_tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE', 'false'),
    ('tenant_snapshot_id', 'int', 'false'),
    ('tenant_snapshot_name', 'varchar:OB_MAX_TENANT_SNAPSHOT_NAME_LENGTH_STORE', 'false'),
    ('resource_pool_id', 'int', 'false'),
    ('resource_pool_name', 'varchar:MAX_RESOURCE_POOL_LENGTH', 'false'),
    ('unit_config_name', 'varchar:MAX_UNIT_CONFIG_LENGTH', 'false'),
    ('restore_scn', 'uint', 'false', '0'),
    ('status', 'varchar:64', 'false'),
    ('job_type', 'varchar:16', 'false'),
    ('clone_start_time', 'timestamp', 'false'),
    ('clone_finished_time', 'timestamp', 'false'),
    ('ret_code', 'int', 'true'),
    ('error_msg', 'varchar:OB_MAX_ERROR_MSG_LEN', 'true'),
    ('data_version', 'uint', 'false', '0'),
    ('min_cluster_version', 'uint', 'false', '0'),
  ],
)
def_table_schema(**all_clone_job_history_def)

def_table_schema(
    owner = 'roland.qk',
    table_id = 487,
    table_name = '__wr_system_event',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('cluster_id', 'int'),
        ('snap_id', 'int'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
        ('event_id', 'int'),
    ],

    in_tenant_space=True,
    is_cluster_private=True,
    meta_record_in_sys = False,

    normal_columns = [
        ('total_waits', 'int','true'),
        ('total_timeouts', 'int','true'),
        ('time_waited_micro', 'int','true'),
    ],
)

def_table_schema(
    owner = 'roland.qk',
    table_id = 488,
    table_name = '__wr_event_name',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('cluster_id', 'int'),
        ('event_id', 'int'),
    ],

    in_tenant_space=True,
    is_cluster_private=True,
    meta_record_in_sys = False,

    normal_columns = [
        ('event_name', 'varchar:64', 'true'),
        ('parameter1', 'varchar:64', 'true'),
        ('parameter2', 'varchar:64', 'true'),
        ('parameter3', 'varchar:64', 'true'),
        ('wait_class_id', 'int', 'true'),
        ('wait_class', 'varchar:64', 'true'),
    ],
)

# 489: __all_tenant_scheduler_running_job
all_routine_privilege_def = dict(
    owner = 'mingye.swj',
    table_name    = '__all_routine_privilege',
    table_id      = '490',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('user_id', 'int'),
        ('database_name', 'varbinary:OB_MAX_DATABASE_NAME_BINARY_LENGTH'),
        ('routine_name', 'varbinary:OB_MAX_ROUTINE_NAME_BINARY_LENGTH'),
        ('routine_type', 'int'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('all_priv', 'int', 'false', '0'),
      ('grantor', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE', 'true'),
      ('grantor_host', 'varchar:OB_MAX_HOST_NAME_LENGTH', 'true'),
    ],
)

def_table_schema(**all_routine_privilege_def)
def_table_schema(**gen_history_table_def(491, all_routine_privilege_def))

def_table_schema(
    owner = 'yuchen.wyc',
    table_id = 492,
    table_name = '__wr_sqlstat',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
      ('tenant_id', 'int'),
      ('cluster_id', 'int'),
      ('snap_id', 'int'),
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
      ('plan_hash', 'uint'),
      ('source_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('source_port', 'int'),
    ],
    in_tenant_space=True,
    is_cluster_private=True,
    meta_record_in_sys = False,
    normal_columns = [
        ('plan_type', 'int'),
        ('module', 'varchar:64', 'true'),
        ('action', 'varchar:64', 'true'),
        ('parsing_db_id', 'int'),
        ('parsing_db_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
        ('parsing_user_id', 'int'),
        ('executions_total', 'bigint', 'false', '0'),
        ('executions_delta', 'bigint', 'false', '0'),
        ('disk_reads_total', 'bigint', 'false', '0'),
        ('disk_reads_delta', 'bigint', 'false', '0'),
        ('buffer_gets_total', 'bigint', 'false', '0'),
        ('buffer_gets_delta', 'bigint', 'false', '0'),
        ('elapsed_time_total', 'bigint', 'false', '0'),
        ('elapsed_time_delta', 'bigint', 'false', '0'),
        ('cpu_time_total', 'bigint', 'false', '0'),
        ('cpu_time_delta', 'bigint', 'false', '0'),
        ('ccwait_total', 'bigint', 'false', '0'),
        ('ccwait_delta', 'bigint', 'false', '0'),
        ('userio_wait_total', 'bigint', 'false', '0'),
        ('userio_wait_delta', 'bigint', 'false', '0'),
        ('apwait_total', 'bigint', 'false', '0'),
        ('apwait_delta', 'bigint', 'false', '0'),
        ('physical_read_requests_total', 'bigint', 'false', '0'),
        ('physical_read_requests_delta', 'bigint', 'false', '0'),
        ('physical_read_bytes_total', 'bigint', 'false', '0'),
        ('physical_read_bytes_delta', 'bigint', 'false', '0'),
        ('write_throttle_total', 'bigint', 'false', '0'),
        ('write_throttle_delta', 'bigint', 'false', '0'),
        ('rows_processed_total', 'bigint', 'false', '0'),
        ('rows_processed_delta', 'bigint', 'false', '0'),
        ('memstore_read_rows_total', 'bigint', 'false', '0'),
        ('memstore_read_rows_delta', 'bigint', 'false', '0'),
        ('minor_ssstore_read_rows_total', 'bigint', 'false', '0'),
        ('minor_ssstore_read_rows_delta', 'bigint', 'false', '0'),
        ('major_ssstore_read_rows_total', 'bigint', 'false', '0'),
        ('major_ssstore_read_rows_delta', 'bigint', 'false', '0'),
        ('rpc_total', 'bigint', 'false', '0'),
        ('rpc_delta', 'bigint', 'false', '0'),
        ('fetches_total', 'bigint', 'false', '0'),
        ('fetches_delta', 'bigint', 'false', '0'),
        ('retry_total', 'bigint', 'false', '0'),
        ('retry_delta', 'bigint', 'false', '0'),
        ('partition_total', 'bigint', 'false', '0'),
        ('partition_delta', 'bigint', 'false', '0'),
        ('nested_sql_total', 'bigint', 'false', '0'),
        ('nested_sql_delta', 'bigint', 'false', '0'),
        ('route_miss_total', 'bigint', 'false', '0'),
        ('route_miss_delta', 'bigint', 'false', '0'),
        ('first_load_time', 'timestamp', 'true'),
        ('plan_cache_hit_total', 'bigint', 'false', '0'),
        ('plan_cache_hit_delta', 'bigint', 'false', '0'),
    ],
)

all_ncomp_dll = dict(
  owner = 'hr351303',
  table_name = '__all_ncomp_dll',
  table_id = '493',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('database_id', 'int', 'false'),
    ('key_id', 'int'),
    ('compile_db_id', 'int'),
    ('arch_type', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('merge_version', 'int'),
    ('dll', 'longblob', 'true',''),
  ],
)
def_table_schema(**all_ncomp_dll)

def_table_schema(
  owner = 'zhenling.zzg',
  table_name = '__all_aux_stat',
  table_id = '494',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'bigint'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
      ('last_analyzed', 'timestamp'),
      ('cpu_speed', 'bigint', 'true', '2500'),
      ('disk_seq_read_speed', 'bigint', 'true', '2000'),
      ('disk_rnd_read_speed', 'bigint', 'true', '150'),
      ('network_speed', 'bigint', '1000')
  ],
)

def_table_schema(
  owner = 'yangjiali.yjl',
  table_name     = '__all_index_usage_info',
  table_id       = '495',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'bigint'),
      ('object_id', 'bigint')
  ],
  in_tenant_space = True,
  normal_columns = [
      ('name', 'varchar:128'),
      ('owner', 'varchar:128'),
      ('total_access_count', 'bigint'),
      ('total_exec_count', 'bigint'),
      ('total_rows_returned', 'bigint'),
      ('bucket_0_access_count', 'bigint'),
      ('bucket_1_access_count', 'bigint'),
      ('bucket_2_10_access_count', 'bigint'),
      ('bucket_2_10_rows_returned', 'bigint'),
      ('bucket_11_100_access_count', 'bigint'),
      ('bucket_11_100_rows_returned', 'bigint'),
      ('bucket_101_1000_access_count', 'bigint'),
      ('bucket_101_1000_rows_returned', 'bigint'),
      ('bucket_1000_plus_access_count', 'bigint'),
      ('bucket_1000_plus_rows_returned', 'bigint'),
      ('last_used','timestamp'),
      ('last_flush_time', 'timestamp'),
  ],
)

def_table_schema(
  owner = 'yangyifei.yyf',
  table_name = '__all_detect_lock_info',
  table_id = '496',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('task_type', 'int'),
    ('obj_type', 'int'),
    ('obj_id', 'int'),
    ('lock_mode', 'int'),
    ('owner_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  meta_record_in_sys = False,
  normal_columns = [
    ('cnt', 'int'),
    ('detect_func_no', 'int'),
    ('detect_func_param', 'varbinary:MAX_LOCK_DETECT_PARAM_LENGTH', 'true', '')
  ],
)

def_table_schema(
  owner = 'yangyifei.yyf',
  table_name = '__all_client_to_server_session_info',
  table_id = '497',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('server_session_id', 'int')
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  meta_record_in_sys = False,
  normal_columns = [
    ('client_session_id', 'int'),
    ('client_session_create_ts', 'timestamp'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int')
  ],
)

all_transfer_partition_task_def= dict(
    owner = 'msy164651',
    table_name    = '__all_transfer_partition_task',
    table_id = '498',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    in_tenant_space = True,
    is_cluster_private = False,
    meta_record_in_sys = False,
    rowkey_columns = [
        ('task_id', 'int', 'false'),
    ],
    normal_columns = [
        ('table_id', 'int', 'false'),
        ('object_id', 'int', 'false'),
        ('dest_ls', 'int', 'false'),
        ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
        ('balance_job_id', 'int', 'false'),
        ('transfer_task_id', 'int', 'false'),
        ('comment', 'longtext', 'true'),
    ],
)
def_table_schema(**all_transfer_partition_task_def)
def_table_schema(**gen_history_table_def_of_task(499, all_transfer_partition_task_def))

def_table_schema(
  owner = 'chensen.cs',
  table_name    = '__all_tenant_snapshot_job',
  table_id      = '500',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('snapshot_id', 'int', 'false'),
    ('operation', 'varchar:32', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('job_start_time', 'timestamp', 'false'),
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'false'),
    ('majority_succ_time', 'timestamp', 'false'),
  ],
)

def_table_schema(
    owner = 'yuchen.wyc',
    table_id = 501,
    table_name = '__wr_sqltext',
    table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('cluster_id', 'int'),
        ('snap_id', 'int'),
        ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
    ],
    in_tenant_space=True,
    is_cluster_private=True,
    meta_record_in_sys = False,
    normal_columns = [
        ('query_sql', 'longtext'),
        ('sql_type', 'int'),
    ],
)

def_table_schema(
  owner = 'tony.wzh',
  table_name = '__all_trusted_root_certificate',
  table_id = '502',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('common_name', 'varchar:256'),
  ],
  normal_columns = [
    ('description', 'varchar:256'),
    ('content', 'longtext', 'false'),
  ],
)

def_table_schema(
  owner = 'sean.yyj',
  table_name = '__all_audit_log_filter',
  table_id = '503',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('filter_name', 'varbinary:MAX_AUDIT_FILTER_NAME_LENGTH_BYTE'),
  ],
  in_tenant_space = True,

  normal_columns = [
      ('definition', 'longtext'),
      ('is_deleted', 'int'),
  ],
)

def_table_schema(
  owner = 'sean.yyj',
  table_name = '__all_audit_log_user',
  table_id = '504',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('user_name', 'varbinary:MAX_AUDIT_USER_NAME_LENGTH_BYTE'),
      ('host', 'varchar:OB_MAX_HOST_NAME_LENGTH'),
  ],
  in_tenant_space = True,

  normal_columns = [
      ('filter_name', 'varbinary:MAX_AUDIT_FILTER_NAME_LENGTH_BYTE'),
      ('is_deleted', 'int'),
  ],
)

all_column_privilege_def = dict(
    owner = 'mingye.swj',
    table_name    = '__all_column_privilege',
    table_id      = '505',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('priv_id', 'int'),
    ],
    in_tenant_space = True,
    normal_columns =[
        ('user_id', 'int'),
        ('database_name', 'varbinary:1024'),
        ('table_name', 'varbinary:1024'),
        ('column_name', 'varbinary:1024'),
        ('all_priv', 'int', 'false', '0'),
    ],
)

def_table_schema(**all_column_privilege_def)

def_table_schema(**gen_history_table_def(506, all_column_privilege_def))

all_tenant_snapshot_ls_replica_history_def = dict(
  owner = 'chensen.cs',
  table_name    = '__all_tenant_snapshot_ls_replica_history',
  table_id      = '507',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('snapshot_id', 'int', 'false'),
    ('ls_id', 'int', 'false'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
    ('svr_port', 'int', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('status', 'varchar:OB_DEFAULT_STATUS_LENTH', 'false'),
    ('zone', 'varchar:MAX_ZONE_LENGTH', 'false'),
    ('unit_id', 'int', 'false'),
    ('begin_interval_scn', 'uint', 'false'),
    ('end_interval_scn', 'uint', 'false'),
    ('ls_meta_package', 'longtext', 'true')
  ],
)
def_table_schema(**all_tenant_snapshot_ls_replica_history_def)

def_table_schema(
  owner = 'jinqian.zzy',
  table_name    = '__all_ls_replica_task_history',
  table_id = '508',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('task_type', 'varchar:MAX_DISASTER_RECOVERY_TASK_TYPE_LENGTH'),
    ('task_id', 'varchar:OB_TRACE_STAT_BUFFER_SIZE'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('task_status', 'varchar:MAX_COLUMN_COMMENT_LENGTH', 'true'),
    ('priority', 'int', 'false', 1),
    ('target_replica_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('target_replica_svr_port', 'int', 'true'),
    ('target_paxos_replica_number', 'int', 'true'),
    ('target_replica_type', 'varchar:MAX_REPLICA_TYPE_LENGTH', 'true'),
    ('source_replica_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('source_replica_svr_port', 'int', 'true'),
    ('source_paxos_replica_number', 'int', 'true'),
    ('source_replica_type', 'varchar:MAX_REPLICA_TYPE_LENGTH', 'true'),
    ('data_source_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('data_source_svr_port', 'int', 'true'),
    ('is_manual', 'bool', 'true', '0'),
    ('task_exec_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('task_exec_svr_port', 'int', 'true'),
    ('generate_time', 'timestamp:6', 'false', 0),
    ('schedule_time', 'timestamp:6', 'false', 0),
    ('finish_time', 'timestamp:6', 'false', 0),
    ('execute_result', 'varchar:MAX_COLUMN_COMMENT_LENGTH', 'true'),
    ('comment', 'varchar:MAX_COLUMN_COMMENT_LENGTH', 'true'),
  ],
)

# 509 : __all_ls_compaction_status
# 510 : __all_tablet_compaction_status

def_table_schema(
  owner = 'lixia.yq',
  table_name = '__all_tablet_checksum_error_info',
  table_id = '511',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('shared_storage_path', 'varchar:OB_STORAGE_PATH_STR_LENGTH'),
    ('tablet_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('compaction_scn', 'uint'),
    ('check_error_info', 'varchar:OB_CKM_ERROR_INFO_STR_LENGTH')
  ],
)
# 516 : __all_service
# 517 : __all_storage_io_usage

all_user_proxy_info_def = dict(
    owner = 'mingye.swj',
    table_name    = '__all_user_proxy_info',
    table_id      = '512',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
	('tenant_id', 'int', 'false'),
        ('client_user_id', 'int', 'false'),
        ('proxy_user_id', 'int', 'false'),
    ],
    in_tenant_space = True,

    normal_columns = [
      ('credential_type', 'int', 'false', '0'),
      ('flags', 'int', 'false', '0')
    ],
)
def_table_schema(**all_user_proxy_info_def)
def_table_schema(**gen_history_table_def(513, all_user_proxy_info_def))

all_user_proxy_role_info_def = dict(
    owner = 'mingye.swj',
    table_name    = '__all_user_proxy_role_info',
    table_id      = '514',
    table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
	('tenant_id', 'int', 'false'),
        ('client_user_id', 'int', 'false'),
        ('proxy_user_id', 'int', 'false'),
        ('role_id', 'int', 'false'),
    ],
    in_tenant_space = True,

    normal_columns = [
    ],
)
def_table_schema(**all_user_proxy_role_info_def)
def_table_schema(**gen_history_table_def(515, all_user_proxy_role_info_def))

#
# 515 : __all_user_proxy_role_info_history

def_table_schema(
  owner = 'linqiucen.lqc',
  table_name    = '__all_service',
  table_id = '516',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('service_name_id', 'int'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,

  normal_columns = [
    ('service_name', 'varchar:OB_SERVICE_NAME_LENGTH'),
    ('service_status', 'varchar:64', 'false'),
  ],
)

def_table_schema(
  owner = 'wyh329796',
  table_name = '__all_storage_io_usage',
  table_id = '517',

  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('storage_id', 'int'),
    ('dest_id', 'int'),
    ('storage_mod', 'varchar:32'),
    ('type', 'varchar:128'),
  ],
  in_tenant_space = True,
  is_cluster_private = True,
  meta_record_in_sys = False,
  normal_columns = [
    ('total', 'int')
  ],
)

def_table_schema(
  owner = 'yuya.yu',
  table_name = '__all_mview_dep',
  table_id = '518',
  table_type = 'SYSTEM_TABLE',
    gm_columns = ['gmt_create', 'gmt_modified'],
    rowkey_columns = [
    ('tenant_id', 'int'),
    ('mview_id', 'int'),
    ('p_order', 'int')
  ],
  in_tenant_space = True,
  normal_columns = [
    ('p_obj', 'int'),
    ('p_type', 'int'),
    ('qbcid', 'int'),
    ('flags', 'int')
  ]
)

def_table_schema(
  owner = 'fyy280124',
  table_name     = '__all_scheduler_job_run_detail_v2',
  table_id       = '519',
  table_type     = 'SYSTEM_TABLE',
  gm_columns     = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('job_name', 'varchar:128', 'false'),
    ('time', 'timestamp', 'false'),
  ],
  in_tenant_space = True,
  is_cluster_private = False,
  normal_columns = [
    ('job', 'int', 'true', '0'),
    ('log_id', 'int', 'true', '0'),
    ('log_date', 'timestamp', 'true'),
    ('owner', 'varchar:128', 'true'),
    ('job_subname', 'varchar:128', 'true'),
    ('job_class', 'varchar:128', 'true'),
    ('operation', 'varchar:OB_MAX_SQL_LENGTH', 'true'),
    ('status', 'varchar:128', 'true'),
    ('code', 'int', 'true', '0'),
    ('req_start_date', 'timestamp', 'true'),
    ('actual_start_date', 'timestamp', 'true'),
    ('run_duration', 'int', 'true'),
    ('instance_id', 'varchar:128', 'true'),
    ('session_id', 'uint', 'true'),
    ('slave_pid', 'varchar:128', 'true'),
    ('cpu_used', 'int', 'true'),
    ('user_name', 'varchar:128', 'true'),
    ('client_id', 'varchar:128', 'true'),
    ('global_uid', 'varchar:128', 'true'),
    ('credential_owner', 'varchar:128', 'true'),
    ('credential_name', 'varchar:128', 'true'),
    ('destination_owner', 'varchar:128', 'true'),
    ('destination', 'varchar:128', 'true'),
    ('message', 'varchar:4000'),
    ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true'),
  ],
)

def_table_schema(
  owner = 'yibo.tyf',
  table_id = '520',
  table_name = '__all_spm_evo_result',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('record_time', 'timestamp'),
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
  ],
  in_tenant_space=True,
  is_cluster_private=True,
  meta_record_in_sys = False,
  normal_columns = [
      ('database_id', 'int'),
      ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
      ('type', 'int'),
      ('start_time', 'timestamp', 'true'),
      ('end_time', 'timestamp', 'true'),
      ('status', 'varchar:7', 'true'),
      ('new_plan_better', 'bool', 'true'),
      ('evo_plan_exec_count', 'int', 'true'),
      ('evo_plan_cpu_time', 'int', 'true'),
      ('baseline_exec_count', 'int', 'true'),
      ('baseline_cpu_time', 'int', 'true'),
  ],
)

# 521 : __all_detect_lock_info_v2

all_pkg_type_def = dict(
  owner = 'webber.wb',
  table_name = '__all_pkg_type',
  table_id   = '522',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('package_id', 'int', 'false'),
    ('type_id', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('database_id', 'int'),
    ('schema_version', 'int'),
    ('typecode', 'int'),
    ('properties', 'int'),
    ('attributes', 'int'),
    ('methods', 'int'),
    ('hiddenmethods', 'int'),
    ('supertypes', 'int'),
    ('subtypes', 'int'),
    ('externtype', 'int'),
    ('externname', 'varchar:OB_MAX_TABLE_TYPE_LENGTH', 'true', ''),
    ('helperclassname', 'varchar:OB_MAX_TABLE_TYPE_LENGTH', 'true', ''),
    ('local_attrs', 'int'),
    ('local_methods', 'int'),
    ('supertypeid', 'int'),
    ('type_name', 'varchar:OB_MAX_TABLE_TYPE_LENGTH'),
  ],
)
def_table_schema(**all_pkg_type_def)

all_pkg_type_attr_def = dict (
  owner = 'webber.wb',
  table_name = '__all_pkg_type_attr',
  table_id = '523',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('type_id', 'int', 'false'),
    ('attribute', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('schema_version', 'int'),
    ('attr_package_id', 'int'),
    ('type_attr_id', 'int'),
    ('name', 'varchar:OB_MAX_TABLE_TYPE_LENGTH'),
    ('properties', 'int', 'false'),
    ('charset_id', 'int'),
    ('charset_form', 'int'),
    ('length', 'int'),
    ('number_precision', 'int'),
    ('scale', 'int'),
    ('zero_fill', 'int'),
    ('coll_type', 'int'),
    ('externname', 'varchar:OB_MAX_TABLE_TYPE_LENGTH', 'true', ''),
    ('xflags', 'int'),
    ('setter', 'int'),
    ('getter', 'int'),
  ],
)
def_table_schema(**all_pkg_type_attr_def)

all_coll_type_def = dict(
  owner = 'webber.wb',
  table_name = '__all_pkg_coll_type',
  table_id = '524',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('tenant_id', 'int', 'false'),
    ('coll_type_id', 'int', 'false'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('schema_version', 'int'),
    ('elem_package_id', 'int'),
    ('elem_type_id', 'int'),
    ('elem_schema_version', 'int'),
    ('properties', 'int'),
    ('charset_id', 'int'),
    ('charset_form', 'int'),
    ('length', 'int'),
    ('number_precision', 'int'),
    ('scale', 'int'),
    ('zero_fill', 'int'),
    ('coll_type', 'int'),
    ('upper_bound', 'int'),
    ('package_id', 'int'),
    ('coll_name', 'varchar:OB_MAX_TABLE_TYPE_LENGTH'),
  ],
)
def_table_schema(**all_coll_type_def)

def_table_schema(
  owner = 'zhangyiqiang.zyq',
  table_id = 525,
  table_name = '__wr_sql_plan',
  table_type = 'SYSTEM_TABLE',
  gm_columns = [],
  rowkey_columns = [
      ('tenant_id', 'int'),
      ('cluster_id', 'int'),
      ('snap_id', 'int'),
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
      ('plan_hash', 'uint'),
      ('plan_id', 'int'),
      ('id', 'uint', 'false', '0'),
  ],
  in_tenant_space=True,
  is_cluster_private=True,
  meta_record_in_sys = False,
  normal_columns = [
      ('db_id', 'int'),
      ('gmt_create', 'timestamp'),
      ('operator', 'varchar:255'),
      ('options', 'varchar:255'),
      ('object_node', 'varchar:40'),
      ('object_id', 'int'),
      ('object_owner', 'varchar:128'),
      ('object_name', 'varchar:128'),
      ('object_alias', 'varchar:261'),
      ('object_type', 'varchar:20'),
      ('optimizer', 'varchar:4000'),
      ('parent_id', 'int'),
      ('depth', 'int'),
      ('position', 'int'),
      ('is_last_child', 'int'),
      ('cost', 'bigint'),
      ('real_cost', 'bigint'),
      ('cardinality', 'bigint'),
      ('real_cardinality', 'bigint'),
      ('bytes', 'bigint'),
      ('rowset', 'int'),
      ('other_tag', 'varchar:4000'),
      ('partition_start', 'varchar:4000'),
      ('other', 'varchar:4000'),
      ('cpu_cost', 'bigint'),
      ('io_cost', 'bigint'),
      ('access_predicates', 'varchar:4000'),
      ('filter_predicates', 'varchar:4000'),
      ('startup_predicates', 'varchar:4000'),
      ('projection', 'varchar:4000'),
      ('special_predicates', 'varchar:4000'),
      ('qblock_name','varchar:128'),
      ('remarks', 'varchar:4000'),
      ('other_xml', 'varchar:4000')
  ],
)

all_kv_redis_table_def = dict(
  owner = 'maochongxin.mcx',
  table_name = '__all_kv_redis_table',
  table_id = '527',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('command_name', 'varchar:1024', 'false'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH', 'false'),
  ],
)

def_table_schema(**all_kv_redis_table_def)

# 526: __wr_res_mgr_sysstat

all_ncomp_dll_v2 = dict(
  owner = 'hr351303',
  table_name = '__all_ncomp_dll_v2',
  table_id = '528',
  table_type = 'SYSTEM_TABLE',
  gm_columns = ['gmt_create', 'gmt_modified'],
  rowkey_columns = [
    ('database_id', 'int', 'false'),
    ('key_id', 'int'),
    ('compile_db_id', 'int'),
    ('arch_type', 'varchar:128'),
    ('build_version', 'varchar:OB_SERVER_VERSION_LENGTH'),
  ],
  in_tenant_space = True,

  normal_columns = [
    ('merge_version', 'int'),
    ('dll', 'longblob', 'false'),
  ],
)
def_table_schema(**all_ncomp_dll_v2)

# 529: __all_object_balance_weight
# 530: __wr_sql_plan_aux_key2snapshot

def_table_schema(
  owner = 'youchuan.yc',
  table_name = '__ft_dict_ik_utf8',
  table_id = '531',
  table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ('word', 'varchar:2048'),
  ],
  in_tenant_space = True,
  normal_columns = [],
)

def_table_schema(
  owner = 'youchuan.yc',
  table_name = '__ft_stopword_ik_utf8',
  table_id = '532',
  table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ('word', 'varchar:2048'),
  ],
  in_tenant_space = True,
  normal_columns = [],
)

def_table_schema(
  owner = 'youchuan.yc',
  table_name = '__ft_quantifier_ik_utf8',
  table_id = '533',
  table_type = 'SYSTEM_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ('word', 'varchar:2048'),
  ],
  in_tenant_space = True,
  normal_columns = [],
)

# 534: __ft_dict_ik_gbk
# 535: __ft_stopword_ik_gbk
# 536: __ft_quantifier_ik_gbk
# 537: __all_catalog
# 538: __all_catalog_history
# 539: __all_catalog_privilege
# 540: __all_catalog_privilege_history
# 541: __all_tenant_flashback_log_scn
# 542: __sslog_table
# 543: __all_license

# 余留位置（此行之前占位）
# 本区域占位建议：采用真实表名进行占位
################################################################################
# End of System Table(0,10000]
################################################################################

################################### 占位须知 ###################################
# 占位示例: 顶格写注释，说明要占用哪个TABLE_ID，对应的名字是什么
# TABLE_ID: TABLE_NAME
#
# FARM 会基于占位校验开发分支TABLE_ID和TABLE_NAME是否匹配，如果不匹配，FARM就会拦截报错
#
# 注意：
# 0. 在‘余留位置’之前占位
# 1. 始终先在master占位，保证master分支是其他所有分支的超集，避免NAME和ID冲突
# 2. master占位之后，开发分支上不要变更NAME，否则FARM会认为ID占位冲突，如果有这种场景，需要先修改master占位
# 3. 默认建议采用准确的TABLE_NAME进行占位，TABLE_ID和TABLE_NAME在系统内部是一一对应的
# 4. 部分表是基于其他基表的schema定义的(例如：gen_xx_table_def())，其真实表名比较复杂，为了方便占位，建议采用基表表名进行占位
#    - 示例1：def_table_schema(**gen_mysql_sys_agent_virtual_table_def('12393', all_def_keywords['__all_virtual_long_ops_status']))
#      * 基表表名占位：# 12393: __all_virtual_long_ops_status
#      * 真实表名占位：# 12393: __all_virtual_virtual_long_ops_status_mysql_sys_agent
#    - 示例2：def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15009', all_def_keywords['__all_virtual_sql_audit'])))
#      * 基表表名占位：# 15009: __all_virtual_sql_audit
#      * 真实表名占位：# 15009: ALL_VIRTUAL_SQL_AUDIT
#    - 示例3：def_table_schema(**gen_sys_agent_virtual_table_def('15111', all_def_keywords['__all_routine_param']))
#      * 基表表名占位：# 15111: __all_routine_param
#      * 真实表名占位：# 15111: ALL_VIRTUAL_ROUTINE_PARAM_SYS_AGENT
# 5. 索引表占位要求TABLE_NAME采用以下方式：基表（数据表）表名、索引名(index_name)、真实的索引表表名
#    例如：100001 索引表占位方式可以为：
#       * # 100001: __idx_3_idx_data_table_id
#       * # 100001: idx_data_table_id
#       * # 100001: __all_table
################################################################################


################################################################################

# 余留位置
################################################################################
# Virtual Table (10000, 20000]
# Normally, virtual table's index_using_type should be USING_HASH.
################################################################################

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__tenant_virtual_all_table',
  table_id       = '10001',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,

  rowkey_columns = [
  ('database_id', 'int'),
  ('table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH'),
  ],
  normal_columns = [
  ('table_type', 'varchar:OB_MAX_TABLE_TYPE_LENGTH'),
  ('engine', 'varchar:MAX_ENGINE_LENGTH'),
  ('version', 'uint'),
  ('row_format', 'varchar:ROW_FORMAT_LENGTH'),
  ('rows', 'int'),
  ('avg_row_length', 'int'),
  ('data_length', 'int'),
  ('max_data_length', 'int'),
  ('index_length', 'int'),
  ('data_free', 'int'),
  ('auto_increment', 'uint'),
  ('create_time', 'timestamp'),
  ('update_time', 'timestamp'),
  ('check_time', 'timestamp'),
  ('collation', 'varchar:MAX_COLLATION_LENGTH'),
  ('checksum', 'int'),
  ('create_options', 'varchar:MAX_TABLE_STATUS_CREATE_OPTION_LENGTH'),
  ('comment', 'varchar:MAX_TABLE_COMMENT_LENGTH'),
  ],
)

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__tenant_virtual_table_column',
  table_id       = '10002',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('table_id', 'int'),
  ('field', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('type', 'varchar:OB_MAX_VARCHAR_LENGTH'),
  ('collation', 'varchar:MAX_COLLATION_LENGTH', 'true'),
  ('null', 'varchar:COLUMN_NULLABLE_LENGTH'),
  ('key', 'varchar:COLUMN_KEY_LENGTH'),
  ('default', 'varchar:COLUMN_DEFAULT_LENGTH', 'true'),
  ('extra', 'varchar:COLUMN_EXTRA_LENGTH'),
  ('privileges', 'varchar:MAX_COLUMN_PRIVILEGE_LENGTH'),
  ('comment', 'varchar:MAX_COLUMN_COMMENT_LENGTH'),
  ('is_hidden', 'int', 'false', '0')
  ],
)

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__tenant_virtual_table_index',
  table_id       = '10003',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('table_id', 'int'),
  ('key_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH', 'false', ''),
  ('seq_in_index', 'int', 'false', '0'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('table_schema', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false', ''),
  ('table', 'varchar:OB_MAX_TABLE_NAME_LENGTH', 'false', ''),
  ('non_unique', 'int', 'false', '0'),
  ('index_schema', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false', ''),
  ('column_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH', 'false', ''),
  ('collation', 'varchar:MAX_COLLATION_LENGTH', 'true'),
  ('cardinality', 'int', 'true'),
  ('sub_part', 'varchar:INDEX_SUB_PART_LENGTH', 'true'),
  ('packed', 'varchar:INDEX_PACKED_LENGTH', 'true'),
  ('null', 'varchar:INDEX_NULL_LENGTH', 'false', ''),
  ('index_type', 'varchar:INDEX_NULL_LENGTH', 'false', ''),
  ('comment', 'varchar:MAX_TABLE_COMMENT_LENGTH', 'true'),
  ('index_comment', 'varchar:MAX_TABLE_COMMENT_LENGTH', 'false', ''),
  ('is_visible', 'varchar:MAX_COLUMN_YES_NO_LENGTH', 'false', ''),
  ('expression', 'varchar:OB_MAX_DEFAULT_VALUE_LENGTH', 'true'),
  ('is_column_visible', 'int', 'false', '0')
  ],
)

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__tenant_virtual_show_create_database',
  table_id       = '10004',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('database_id', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
  ('create_database', 'varchar:DATABASE_DEFINE_LENGTH'),
  ('create_database_with_if_not_exists', 'varchar:DATABASE_DEFINE_LENGTH'),
  ],
)

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__tenant_virtual_show_create_table',
  table_id       = '10005',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('table_id', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH'),
  ('create_table', 'longtext'),
  ('character_set_client', 'varchar:MAX_CHARSET_LENGTH'),
  ('collation_connection', 'varchar:MAX_CHARSET_LENGTH'),
  ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name     = '__tenant_virtual_session_variable',
  table_id       = '10006',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('variable_name', 'varchar:OB_MAX_CONFIG_NAME_LEN', 'false', ''),
  ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN', 'true'),
  ],
)

def_table_schema(
  owner = 'sean.yyj',
  table_name     = '__tenant_virtual_privilege_grant',
  table_id       = '10007',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('user_id', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('grants', 'varchar:MAX_GRANT_LENGTH'),
  ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name     = '__all_virtual_processlist',
  table_id       = '10008',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('id', 'uint', 'false', '0'),
  ('user', 'varchar:OB_MAX_USERNAME_LENGTH', 'false', ''),
  ('tenant', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE'),
  ('host', 'varchar:OB_MAX_HOST_NAME_LENGTH', 'false', ''),
  ('db', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true'),
  ('command', 'varchar:OB_MAX_COMMAND_LENGTH', 'false', ''),
  ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH', 'false', ''),
  ('time', 'double', 'false'),
  ('state', 'varchar:OB_MAX_SESSION_STATE_LENGTH', 'true'),
  ('info', 'varchar:MAX_COLUMN_VARCHAR_LENGTH', 'true'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('sql_port', 'int'),
  ('proxy_sessid', 'uint', 'true'),
  ('master_sessid', 'uint', 'true'),
  ('user_client_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
  ('user_host', 'varchar:OB_MAX_HOST_NAME_LENGTH', 'true'),
  ('trans_id', 'uint'),
  ('thread_id', 'uint'),
  ('ssl_cipher', 'varchar:OB_MAX_COMMAND_LENGTH', 'true'),
  ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true', ''),
  ('trans_state', 'varchar:OB_MAX_TRANS_STATE_LENGTH', 'true'),
  ('total_time', 'double', 'false'),
  ('retry_cnt', 'int', 'false', '0'),
  ('retry_info', 'int', 'false', '0'),
  ('action', 'varchar:MAX_VALUE_LENGTH', 'true', ''),
  ('module', 'varchar:MAX_VALUE_LENGTH', 'true', ''),
  ('client_info', 'varchar:MAX_VALUE_LENGTH', 'true', ''),
  ('sql_trace', 'bool'),
  ('plan_id', 'int'),
  ('tenant_id', 'int'),
  ('effective_tenant_id', 'int'),
  ('level', 'int'),
  ('sample_percentage', 'int'),
  ('record_policy', 'varchar:32'),
  ('lb_vid', 'bigint', 'true'),
  ('lb_vip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
  ('lb_vport', 'int', 'true'),
  ('in_bytes', 'bigint'),
  ('out_bytes', 'bigint'),
  ('user_client_port', 'int', 'false', '0'),
  ('proxy_user', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE', 'true'),
  ('service_name', 'varchar:64', 'true'),
  ('total_cpu_time', 'double', 'false'),
  ('top_info', 'varchar:MAX_COLUMN_VARCHAR_LENGTH', 'true'),
  ('memory_usage', 'bigint', 'true'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__tenant_virtual_warning',
  table_id       = '10009',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('level', 'varchar:32'),
  ('code', 'int'),
  ('message', 'varchar:512'),# the same as warning buffer length
  ('ori_code', 'int'),
  ('sql_state', 'varchar:6'),
  ],
)

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__tenant_virtual_current_tenant',
  table_id       = '10010',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('tenant_id', 'int'),
  ],
  in_tenant_space = True,
  normal_columns = [
  ('tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE'),
  ('create_stmt', 'varchar:TENANT_DEFINE_LENGTH'),
  ],
)

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__tenant_virtual_database_status',
  table_id       = '10011',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('db', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('read_only', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed'
)

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__tenant_virtual_tenant_status',
  table_id       = '10012',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('tenant', 'varchar:OB_MAX_TENANT_NAME_LENGTH'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('read_only', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed'
)

# 10013: __tenant_virtual_interm_result # abandoned in 4.0
# 10014: __tenant_virtual_partition_stat # abandoned in 4.0

def_table_schema(
  owner = 'yuzhong.zhao',
  table_name     = '__tenant_virtual_statname',
  table_id       = '10015',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],
  in_tenant_space = True,

  normal_columns = [
  ('tenant_id', 'int'),
  ('stat_id', 'int'),
  ('statistic#', 'int'),
  ('name', 'varchar:64'),
  ('display_name', 'varchar:64'),
  ('class','int'),
  ],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  table_name     = '__tenant_virtual_event_name',
  table_id       = '10016',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],
  in_tenant_space = True,

  normal_columns = [
  ('tenant_id', 'int'),
  ('event_id', 'int'),
  ('event#', 'int'),
  ('name', 'varchar:64'),
  ('display_name', 'varchar:64'),
  ('parameter1', 'varchar:64'),
  ('parameter2', 'varchar:64'),
  ('parameter3', 'varchar:64'),
  ('wait_class_id','int'),
  ('wait_class#','int'),
  ('wait_class','varchar:64'),
  ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name     = '__tenant_virtual_global_variable',
  table_id       = '10017',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('variable_name', 'varchar:OB_MAX_CONFIG_NAME_LEN', 'false', ''),
  ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN', 'true'),
  ],
)

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__tenant_virtual_show_tables',
  table_id       = '10018',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,

  rowkey_columns = [
  ('database_id', 'int'),
  ('table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH'),
  ],
  normal_columns = [
  ('table_type', 'varchar:OB_MAX_TABLE_TYPE_LENGTH'),
  ],
)

def_table_schema(
  owner = 'linlin.xll',
  table_name     = '__tenant_virtual_show_create_procedure',
  table_id       = '10019',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('routine_id', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('routine_name', 'varchar:OB_MAX_ROUTINE_NAME_LENGTH'),
  ('create_routine', 'longtext'),
  ('proc_type', 'int'),
  ('character_set_client', 'varchar:MAX_CHARSET_LENGTH'),
  ('collation_connection', 'varchar:MAX_CHARSET_LENGTH'),
  ('collation_database', 'varchar:MAX_CHARSET_LENGTH'),
  ('sql_mode', 'varchar:MAX_CHARSET_LENGTH'),
  ],
)

def_table_schema(
    owner = 'yanmu.ztl',
    table_name    = '__all_virtual_core_meta_table',
    table_id      = '11001',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ],
    vtable_route_policy = 'only_rs',
    in_tenant_space = True,

    normal_columns = [
      ('tenant_id', 'int'),
      ('ls_id', 'int'),
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      # location related
      ('sql_port', 'int'),
      ('role', 'int'),
      ('member_list', 'varchar:MAX_MEMBER_LIST_LENGTH'),
      ('proposal_id', 'int', 'false', '0'),
      ('replica_type', 'int', 'false', '0'),
      ('replica_status', 'varchar:MAX_REPLICA_STATUS_LENGTH', 'false', 'NORMAL'),
      ('restore_status', 'int', 'false', '0'),
      ('memstore_percent', 'int', 'false', '100'),
      # meta related
      ('unit_id', 'int'),
      ('zone', 'varchar:MAX_ZONE_LENGTH'),
      ('paxos_replica_number', 'int', 'false', '-1'),
      ('data_size', 'int'),
      ('required_size', 'int', 'false', '0'),
      ('learner_list', 'longtext', 'true'),
      ('rebuild', 'int', 'false', '0'),
    ],
)

# 11002: __all_virtual_zone_stat # abandoned in 4.0.

def_table_schema(
  owner = 'xiaoyi.xy',
  table_name     = '__all_virtual_plan_cache_stat',
  table_id       = '11003',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int')
  ],

  normal_columns = [
    ('sql_num', 'int'),
    ('mem_used', 'int'),
    ('mem_hold', 'int'),
    ('access_count', 'int'),
    ('hit_count', 'int'),
    ('hit_rate', 'int'),
    ('plan_num', 'int'),
    ('mem_limit', 'int'),
    ('hash_bucket', 'int'),
    ('stmtkey_num', 'int'),
    ('pc_ref_plan_local', 'int'),
    ('pc_ref_plan_remote', 'int'),
    ('pc_ref_plan_dist', 'int'),
    ('pc_ref_plan_arr', 'int'),
    ('pc_ref_plan_stat', 'int'),
    ('pc_ref_pl', 'int'),
    ('pc_ref_pl_stat', 'int'),
    ('plan_gen', 'int'),
    ('cli_query', 'int'),
    ('outline_exec', 'int'),
    ('plan_explain', 'int'),
    ('asyn_baseline', 'int'),
    ('load_baseline', 'int'),
    ('ps_exec', 'int'),
    ('gv_sql', 'int'),
    ('pl_anon', 'int'),
    ('pl_routine', 'int'),
    ('package_var', 'int'),
    ('package_type', 'int'),
    ('package_spec', 'int'),
    ('package_body', 'int'),
    ('package_resv', 'int'),
    ('get_pkg', 'int'),
    ('index_builder', 'int'),
    ('pcv_set', 'int'),
    ('pcv_rd', 'int'),
    ('pcv_wr', 'int'),
    ('pcv_get_plan_key', 'int'),
    ('pcv_get_pl_key', 'int'),
    ('pcv_expire_by_used', 'int'),
    ('pcv_expire_by_mem', 'int'),
    ('lc_ref_cache_node', 'int'),
    ('lc_node', 'int'),
    ('lc_node_rd', 'int'),
    ('lc_node_wr', 'int'),
    ('lc_ref_cache_obj_stat', 'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
  index = {'all_virtual_plan_cache_stat_i1' :  { 'index_columns' : ['tenant_id'],
                     'index_using_type' : 'USING_HASH'}},
)

def_table_schema(
    owner = 'xiaoyi.xy',
    table_name     = '__all_virtual_plan_stat',
    table_id       = '11004',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
      ],
    enable_column_def_enum = True,
    in_tenant_space = True,

  normal_columns = [
      ('tenant_id', 'int'),
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('plan_id', 'int'),
      ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
      ('type', 'int'),
      ('is_bind_sensitive', 'int'),
      ('is_bind_aware', 'int'),
      ('statement', 'longtext'),
      ('query_sql', 'longtext'),
      ('special_params', 'varchar:OB_MAX_COMMAND_LENGTH'),
      ('param_infos', 'longtext'),
      ('sys_vars', 'varchar:OB_MAX_COMMAND_LENGTH'),
      ('configs', 'varchar:OB_MAX_COMMAND_LENGTH'),
      ('plan_hash', 'uint'),
      ('first_load_time', 'timestamp'),
      ('schema_version', 'int'),
      ('last_active_time', 'timestamp'),
      ('avg_exe_usec', 'int'),
      ('slowest_exe_time', 'timestamp'),
      ('slowest_exe_usec', 'int'),
      ('slow_count', 'int'),
      ('hit_count', 'int'),
      ('plan_size', 'int'),
      ('executions', 'int'),
      ('disk_reads', 'int'),
      ('direct_writes', 'int'),
      ('buffer_gets', 'int'),
      ('application_wait_time', 'uint'),
      ('concurrency_wait_time', 'uint'),
      ('user_io_wait_time', 'uint'),
      ('rows_processed', 'int'),
      ('elapsed_time', 'uint'),
      ('cpu_time', 'uint'),
      ('large_querys', 'int'),
      ('delayed_large_querys', 'int'),
      ('outline_version', 'int'),
      ('outline_id', 'int'),
      ('outline_data', 'longtext', 'false'),
      ('acs_sel_info', 'longtext', 'false'),
      ('table_scan', 'bool'),
      ('db_id', 'uint'),
      ('evolution', 'bool'),
      ('evo_executions', 'int'),
      ('evo_cpu_time', 'uint'),
      ('timeout_count', 'int'),
      ('ps_stmt_id', 'int'),
      ('delayed_px_querys', 'int'),
      ('sessid', 'uint'),
      ('temp_tables', 'longtext', 'false'),
      ('is_use_jit', 'bool'),
      ('object_type', 'longtext', 'false'),
      ('enable_bf_cache', 'bool'),
      ('bf_filter_cnt', 'int'),
      ('bf_access_cnt', 'int'),
      ('enable_row_cache', 'bool'),
      ('row_cache_hit_cnt', 'int'),
      ('row_cache_miss_cnt', 'int'),
      ('enable_fuse_row_cache', 'bool'),
      ('fuse_row_cache_hit_cnt', 'int'),
      ('fuse_row_cache_miss_cnt', 'int'),
      ('hints_info', 'longtext', 'false'),
      ('hints_all_worked', 'bool'),
      ('pl_schema_id', 'uint'),
      ('is_batched_multi_stmt', 'bool'),
      ('object_status', 'int'),
      ('rule_name', 'varchar:256'),
      ('is_in_pc', 'bool'),
      ('erase_time', 'timestamp'),
      ('compile_time', 'uint'),
      ('pl_cg_mem_hold', 'int'),
      ('pl_evict_version', 'int'),
      ('plan_status', 'int'),
      ('adaptive_feedback_times', 'int'),
  ],
  vtable_route_policy = 'distributed',
  partition_columns = ['svr_ip', 'svr_port'],
)

def_table_schema(
  owner = 'nijia.nj',
  table_name    = '__all_virtual_mem_leak_checker_info',
  table_id      = '11006',
  table_type = 'VIRTUAL_TABLE',
  gm_columns    = [],
  rowkey_columns = [
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('mod_name', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('mod_type', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('alloc_count', 'int'),
  ('alloc_size', 'int'),
  ('back_trace', 'varchar:DEFAULT_BUF_LENGTH'),
  ],
  vtable_route_policy = 'distributed',
  partition_columns = ['svr_ip', 'svr_port'],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  table_name    = '__all_virtual_latch',
  table_id      = '11007',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [
  ],

  normal_columns = [
  ('tenant_id', 'int', 'false'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int'),
  ('latch_id', 'int', 'false'),
  ('name', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('addr', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('level', 'int'),
  ('hash', 'int'),
  ('gets', 'int'),
  ('misses', 'int'),
  ('sleeps', 'int'),
  ('immediate_gets', 'int'),
  ('immediate_misses', 'int'),
  ('spin_gets', 'int'),
  ('wait_time', 'int'),
  ],
  vtable_route_policy = 'distributed',
  partition_columns = ['svr_ip', 'svr_port'],
)

def_table_schema(
  owner = 'zhaoruizhe.zrz',
  tablegroup_id = 'OB_INVALID_ID',
  table_name     = '__all_virtual_kvcache_info',
  table_id       = '11008',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [
  ],

  normal_columns = [
  ('tenant_id', 'int', 'false'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int'),
  ('cache_name', 'varchar:OB_MAX_KVCACHE_NAME_LENGTH', 'false'),
  ('cache_id', 'int', 'false'),
  ('priority', 'int', 'false'),
  ('cache_size', 'int', 'false'),
  ('cache_store_size', 'int', 'false'),
  ('cache_map_size', 'int', 'false'),
  ('kv_cnt', 'int', 'false'),
  ('hit_ratio', 'number:38:3', 'false'),
  ('total_put_cnt', 'int', 'false'),
  ('total_hit_cnt', 'int', 'false'),
  ('total_miss_cnt', 'int', 'false'),
  ('hold_size', 'int', 'false'),
  ],
  vtable_route_policy = 'distributed',
  partition_columns = ['svr_ip', 'svr_port'],
)

def_table_schema(
  owner = 'nijia.nj',
  table_name    = '__all_virtual_data_type_class',
  table_id      = '11009',
  table_type = 'VIRTUAL_TABLE',
  gm_columns    = [],
  rowkey_columns = [
  ('data_type_class', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('data_type_class_str', 'varchar:OB_MAX_SYS_PARAM_NAME_LENGTH'),
  ],
)

def_table_schema(
  owner = 'nijia.nj',
  table_name    = '__all_virtual_data_type',
  table_id      = '11010',
  table_type = 'VIRTUAL_TABLE',
  gm_columns    = [],
  rowkey_columns = [
  ('data_type', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('data_type_str', 'varchar:OB_MAX_SYS_PARAM_NAME_LENGTH'),
  ('data_type_class', 'int'),
  ],
)

# 11011: __all_virtual_server_stat # abandoned in 4.0.
# 11012: __all_virtual_rebalance_task_stat # abandoned in 4.0

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id = 'OB_INVALID_ID',
  table_name     = '__all_virtual_session_event',
  table_id       = '11013',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [
  ('session_id', 'int', 'false'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int'),
  ('event_id', 'int', 'false'),
  ],

  normal_columns = [
  ('tenant_id', 'int', 'false'),
  ('event', 'varchar:OB_MAX_WAIT_EVENT_NAME_LENGTH', 'false'),
  ('wait_class_id', 'int', 'false'),
  ('wait_class#', 'int', 'false'),
  ('wait_class', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'false'),
  ('total_waits', 'int', 'false'),
  ('total_timeouts', 'int', 'false'),
  ('time_waited', 'double', 'false'),
  ('max_wait', 'double', 'false'),
  ('average_wait', 'double', 'false'),
  ('time_waited_micro', 'int', 'false'),
  ],
  vtable_route_policy = 'distributed',
  partition_columns = ['svr_ip', 'svr_port'],
  index = {'all_virtual_session_event_i1' : { 'index_columns' : ['session_id'],
                    'index_using_type' : 'USING_HASH'}},
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id = 'OB_INVALID_ID',
  table_name     = '__all_virtual_session_wait',
  table_id       = '11014',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [
  ('session_id', 'int', 'false'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int'),
  ],

  normal_columns = [
  ('tenant_id', 'int', 'false'),
  ('event', 'varchar:OB_MAX_WAIT_EVENT_NAME_LENGTH', 'false'),
  ('p1text', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'false'),
  ('p1', 'uint', 'false'),
  ('p2text', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'false'),
  ('p2', 'uint', 'false'),
  ('p3text', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'false'),
  ('p3', 'uint', 'false'),
  ('level', 'int', 'false'),
  ('wait_class_id', 'int', 'false'),
  ('wait_class#', 'int', 'false'),
  ('wait_class', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'false'),
  ('state', 'varchar:19', 'false'),
  ('wait_time_micro', 'int', 'false'),
  ('time_remaining_micro', 'int', 'false'),
  ('time_since_last_wait_micro', 'int', 'false'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
  index = {'all_virtual_session_wait_i1' : { 'index_columns' : ['session_id'],
                    'index_using_type' : 'USING_HASH'}},
)


def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id = 'OB_INVALID_ID',
  table_name     = '__all_virtual_session_wait_history',
  table_id       = '11015',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [
  ('session_id', 'int', 'false'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int'),
  ('seq#', 'int', 'false'),
],
normal_columns = [
  ('tenant_id', 'int', 'false'),
  ('event#', 'int', 'false'),
  ('event', 'varchar:OB_MAX_WAIT_EVENT_NAME_LENGTH', 'false'),
  ('p1text', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'false'),
  ('p1', 'uint', 'false'),
  ('p2text', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'false'),
  ('p2', 'uint', 'false'),
  ('p3text', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'false'),
  ('p3', 'uint', 'false'),
  ('level', 'int', 'false'),
  ('wait_time_micro', 'int', 'false'),
  ('time_since_last_wait_micro', 'int', 'false'),
  ('wait_time', 'double', 'false'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
  index = {'all_virtual_session_wait_history_i1' : { 'index_columns' : ['session_id'],
                    'index_using_type' : 'USING_HASH'}},
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = '__all_virtual_system_event',
  table_id       = '11017',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [
  ('tenant_id', 'int', 'false'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int'),
  ('event_id', 'int', 'false'),
  ],

  normal_columns = [
  ('event', 'varchar:OB_MAX_WAIT_EVENT_NAME_LENGTH', 'false'),
  ('wait_class_id', 'int', 'false'),
  ('wait_class#', 'int', 'false'),
  ('wait_class', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'false'),
  ('total_waits', 'int', 'false'),
  ('total_timeouts', 'int', 'false'),
  ('time_waited', 'double', 'false'),
  ('max_wait', 'double', 'false'),
  ('average_wait', 'double', 'false'),
  ('time_waited_micro', 'int', 'false'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
  index = {'all_virtual_system_event_i1' : { 'index_columns' : ['tenant_id'],
                    'index_using_type' : 'USING_HASH'}},
)


def_table_schema(
  owner = 'jingyan.kfy',
  table_name     = '__all_virtual_tenant_memstore_info',
  table_id       = '11018',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('active_span', 'int'),
  ('freeze_trigger', 'int'),
  ('freeze_cnt', 'int'),
  ('memstore_used', 'int'),
  ('memstore_limit', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'fengshuo.fs',
  table_name     = '__all_virtual_concurrency_object_pool',
  table_id       = '11019',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ],

  normal_columns = [
  ('free_list_name', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH'),
  ('allocated', 'int'),
  ('in_use', 'int'),
  ('count', 'int'),
  ('type_size', 'int'),
  ('chunk_count', 'int'),
  ('chunk_byte_size', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id = 'OB_INVALID_ID',
  table_name     = '__all_virtual_sesstat',
  table_id       = '11020',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [
  ('session_id', 'int', 'false'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int'),
  ('statistic#', 'int', 'false'),
  ],

  normal_columns = [
  ('tenant_id', 'int', 'false'),
  ('value', 'int', 'false'),
  ('can_visible', 'bool', 'false'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
  index = {'all_virtual_sesstat_i1' : { 'index_columns' : ['session_id'],
                    'index_using_type' : 'USING_HASH'}},
)



def_table_schema(
  owner = 'roland.qk',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = '__all_virtual_sysstat',
  table_id       = '11021',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [
  ('tenant_id', 'int', 'false'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int'),
  ('statistic#', 'int', 'false'),
  ],

  normal_columns = [
  ('value', 'int', 'false'),
  ('value_type', 'varchar:16', 'false'),
  ('stat_id', 'int', 'false'),
  ('name', 'varchar:64', 'false'),
  ('class', 'int', 'false'),
  ('can_visible', 'bool', 'false'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
  index = {'all_virtual_sysstat_i1' : { 'index_columns' : ['tenant_id'],
                    'index_using_type' : 'USING_HASH'}},
)

##11022:__all_virtual_storage_stat obsolated in 4.0

def_table_schema(
  owner = 'jiahua.cjh',
  tablegroup_id = 'OB_INVALID_ID',
  table_name     = '__all_virtual_disk_stat',
  table_id       = '11023',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int', 'false'),
  ('total_size', 'int', 'false'),
  ('used_size', 'int', 'false'),
  ('free_size', 'int', 'false'),
  ('is_disk_valid', 'int', 'false'),
  ('disk_error_begin_ts', 'int', 'false'),
  ('allocated_size', 'int', 'false'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'jingyan.kfy',
  table_name     = '__all_virtual_memstore_info',
  table_id       = '11024',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('tablet_id', 'int'),
  ('is_active', 'varchar:MAX_COLUMN_YES_NO_LENGTH'),
  ('start_scn', 'uint'),
  ('end_scn', 'uint'),
  ('logging_blocked', 'varchar:MAX_COLUMN_YES_NO_LENGTH'),
  ('freeze_clock', 'int'),
  ('unsubmitted_count', 'int'),
  ('max_end_scn', 'uint'),
  ('write_ref_count', 'int'),
  ('mem_used', 'int'),
  ('hash_item_count', 'int'),
  ('hash_mem_used', 'int'),
  ('btree_item_count', 'int'),
  ('btree_mem_used', 'int'),
  ('insert_row_count', 'int'),
  ('update_row_count', 'int'),
  ('delete_row_count', 'int'),
  ('freeze_ts', 'int'),
  ('freeze_state', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('freeze_time_dist', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('compaction_info_list', 'varchar:OB_COMPACTION_INFO_LENGTH'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name     = '__all_virtual_upgrade_inspection',
  table_id       = '11026',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],
  vtable_route_policy = 'only_rs',

  normal_columns = [
  ('name', 'varchar:TABLE_MAX_KEY_LENGTH'),
  ('info', 'varchar:MAX_ZONE_INFO_LENGTH'),
  ],
)

def_table_schema(
  owner = 'shanyan.g',
  table_name     = '__all_virtual_trans_stat',
  table_id       = '11027',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('tenant_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('trans_type', 'int'),
  ('trans_id', 'int'),
  ('session_id', 'int'),
  ('scheduler_addr', 'varchar:64'),
  ('is_decided', 'bool'),
  ('ls_id', 'int'),
  ('participants', 'varchar:1024'),
  ('ctx_create_time', 'timestamp', 'true'),
  ('expired_time', 'timestamp', 'true'),
  ('ref_cnt', 'int'),
  ('last_op_sn', 'int'),
  ('pending_write', 'int'),
  ('state', 'int'),
  ('part_trans_action', 'int'),
  ('trans_ctx_addr', 'varchar:20'),
  ('mem_ctx_id', 'int'),
  ('pending_log_size', 'int'),
  ('flushed_log_size', 'int'),
  ('role', 'int'),
  ('is_exiting', 'int'),
  ('coordinator', 'int'),
  ('last_request_time', 'timestamp', 'true'),
  ('gtrid', 'varbinary:128'),
  ('bqual', 'varbinary:128'),
  ('format_id', 'int', 'false', '1'),
  ('start_scn', 'uint'),
  ('end_scn', 'uint'),
  ('rec_scn', 'uint'),
  ('transfer_blocking', 'bool'),
  ('busy_cbs', 'int'),
  ('replay_complete', 'int'),
  ('serial_log_final_scn', 'int'),
  ('callback_list_stats', 'longtext'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'chensen.cs',
  table_name     = '__all_virtual_trans_ctx_mgr_stat',
  table_id       = '11028',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('ls_id', 'bigint:20'),
  ('is_master', 'int'),
  ('is_stopped', 'int'),
  ('state', 'int'),
  ('state_str', 'varchar:64'),
  ('total_trans_ctx_count', 'int'),
  ('mgr_addr', 'bigint:20'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'wuyuefei.wyf',
  table_name     = '__all_virtual_trans_scheduler',
  table_id       = '11029',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('tenant_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('session_id', 'int'),
  ('trans_id', 'int'),
  ('state', 'int'),
  ('cluster_id', 'int'),
  ('coordinator', 'int'),
  ('participants', 'varchar:1024', 'true'),
  ('isolation_level', 'int'),
  ('snapshot_version', 'uint', 'true'),
  ('access_mode', 'int'),
  ('tx_op_sn', 'int'),
  ('flag', 'int'),
  ('active_time', 'timestamp', 'true'),
  ('expire_time', 'timestamp', 'true'),
  ('timeout_us', 'int'),
  ('ref_cnt', 'int'),
  ('tx_desc_addr', 'varchar:20'),
  ('savepoints', 'varchar:1024', 'true'),
  ('savepoints_total_cnt', 'int'),
  ('internal_abort_cause', 'int'),
  ('can_early_lock_release', 'bool'),
  ('gtrid', 'varbinary:128', 'true'),
  ('bqual', 'varbinary:128', 'true'),
  ('format_id', 'int', 'false', '1'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'xiaoyi.xy',
  tablegroup_id = 'OB_INVALID_ID',
  table_name    = '__all_virtual_sql_audit',
  table_id      = '11031',
  table_type = 'VIRTUAL_TABLE',
  index_using_type = 'USING_BTREE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('request_id', 'int'),
  ],
  normal_columns = [
    ('trace_id', 'varchar:OB_MAX_HOST_NAME_LENGTH'),
    ('client_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('client_port', 'int'),
    ('tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH'),
    ('effective_tenant_id', 'int'),
    ('user_id', 'int'),
    ('user_name', 'varchar:OB_MAX_USER_NAME_LENGTH'),
    ('db_id', 'uint'),
    ('db_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
    ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
    ('query_sql', 'longtext'),
    ('plan_id', 'int'),
    ('affected_rows', 'int'),
    ('return_rows', 'int'),
    ('partition_cnt', 'int'),
    ('ret_code', 'int'),
    ('qc_id', 'uint'),
    ('dfo_id', 'int'),
    ('sqc_id', 'int'),
    ('worker_id', 'int'),

    ('event', 'varchar:OB_MAX_WAIT_EVENT_NAME_LENGTH', 'true'),
    ('p1text', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'true'),
    ('p1', 'uint', 'true'),
    ('p2text', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'true'),
    ('p2', 'uint', 'true'),
    ('p3text', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'true'),
    ('p3', 'uint', 'true'),
    ('level', 'int', 'true'),
    ('wait_class_id', 'int', 'true'),
    ('wait_class#', 'int', 'true'),
    ('wait_class', 'varchar:OB_MAX_WAIT_EVENT_PARAM_LENGTH', 'true'),
    ('state', 'varchar:19', 'true'),
    ('wait_time_micro', 'int', 'true'),
    ('total_wait_time_micro', 'int', 'true'),
    ('total_waits', 'int', 'true'),

    ('rpc_count', 'int', 'true'),
    ('plan_type', 'int'),

    ('is_inner_sql', 'bool'),
    ('is_executor_rpc', 'bool'),
    ('is_hit_plan', 'bool'),

    ('request_time', 'int'),
    ('elapsed_time', 'int'),
    ('net_time', 'int'),
    ('net_wait_time', 'int'),
    ('queue_time', 'int'),
    ('decode_time','int'),
    ('get_plan_time', 'int'),
    ('execute_time', 'int'),
    ('application_wait_time', 'uint', 'true'),
    ('concurrency_wait_time', 'uint', 'true'),
    ('user_io_wait_time', 'uint', 'true'),
    ('schedule_time', 'uint', 'true'),
    ('row_cache_hit', 'int', 'true'),
    ('bloom_filter_cache_hit', 'int', 'true'),
    ('block_cache_hit', 'int', 'true'),
    ('disk_reads', 'int', 'true'),
    ('execution_id', 'int'),
    ('session_id', 'uint'),
    ('retry_cnt', 'int'),
    ('table_scan', 'bool'),
    ('consistency_level', 'int'),
    ('memstore_read_row_count', 'int', 'true'),
    ('ssstore_read_row_count', 'int', 'true'),
    ('data_block_read_cnt', 'int', 'true'),
    ('data_block_cache_hit', 'int', 'true'),
    ('index_block_read_cnt', 'int', 'true'),
    ('index_block_cache_hit', 'int', 'true'),
    ('blockscan_block_cnt', 'int', 'true'),
    ('blockscan_row_cnt', 'int', 'true'),
    ('pushdown_storage_filter_row_cnt', 'int', 'true'),
    ('request_memory_used', 'bigint'),
    ('expected_worker_count', 'int'),
    ('used_worker_count', 'int'),
    ('sched_info', 'varchar:16384', 'true'),
    ('fuse_row_cache_hit', 'int', 'true'),

    ('user_client_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('ps_client_stmt_id', 'int'),
    ('ps_inner_stmt_id', 'int'),
    ('transaction_id', 'int'),
    ('snapshot_version', 'uint'),
    ('snapshot_source', 'varchar:128'),
    ('request_type', 'int'),
    ('is_batched_multi_stmt', 'bool'),
    ('ob_trace_info', 'varchar:4096'),
    ('plan_hash', 'uint'),
    ('user_group', 'int', 'true'),
    ('lock_for_read_time', 'bigint'),
    ('params_value', 'longtext'),
    ('rule_name', 'varchar:256'),
    ('proxy_session_id', 'uint'),
    ('tx_internal_route_flag', 'uint'),

    ('partition_hit', 'bool'),
    ('tx_internal_route_version', 'uint'),
    ('flt_trace_id', 'varchar:OB_MAX_SPAN_LENGTH'),
    ('pl_trace_id', 'varchar:OB_MAX_HOST_NAME_LENGTH', 'true'),
    ('plsql_exec_time', 'int'),
    ('network_wait_time', 'uint', 'true'),
    ('stmt_type', 'varchar:MAX_STMT_TYPE_NAME_LENGTH', 'true'),
    ('seq_num', 'int'),
    ('total_memstore_read_row_count', 'int'),
    ('total_ssstore_read_row_count', 'int'),
    ('proxy_user', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE', 'true'),
    ('format_sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
    ('user_client_port', 'int'),
    ('trans_status', 'varchar:256'),
    ('plsql_compile_time', 'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
  index = {'all_virtual_sql_audit_i1' :  { 'index_columns' : ['tenant_id', 'request_id'],
                     'index_using_type' : 'USING_BTREE'}},
)

# 11033: __all_virtual_partition_sstable_image_info # abandoned in 4.0

def_table_schema(**gen_iterate_core_inner_table_def(11035, '__all_virtual_core_all_table', 'VIRTUAL_TABLE', all_table_def))

def_table_schema(**gen_iterate_core_inner_table_def(11036, '__all_virtual_core_column_table', 'VIRTUAL_TABLE', all_column_def))

def_table_schema(
  owner = 'nijia.nj',
  table_name     = '__all_virtual_memory_info',
  table_id       = '11037',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  in_tenant_space = True,
  rowkey_columns = [
  ('tenant_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('ctx_id', 'int'),
  ('label', 'varchar:OB_MAX_CHAR_LENGTH'),
  ],

  normal_columns = [
  ('ctx_name', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('mod_type', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('mod_id', 'int'),
  ('mod_name', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('zone', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('hold', 'int'),
  ('used', 'int'),
  ('count', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'fyy280124',
    table_name     = '__all_virtual_sys_parameter_stat',
    table_id       = '11039',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ],

  normal_columns = [
      ('zone', 'varchar:MAX_ZONE_LENGTH'),
      ('svr_type', 'varchar:SERVER_TYPE_LENGTH'),
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN'),
      ('data_type', 'varchar:OB_MAX_CONFIG_TYPE_LENGTH', 'true'),
      ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN'),
      ('value_strict', 'varchar:OB_MAX_EXTRA_CONFIG_LENGTH', 'true'),
      ('info', 'varchar:OB_MAX_CONFIG_INFO_LEN'),
      ('need_reboot', 'int'),
      ('section', 'varchar:OB_MAX_CONFIG_SECTION_LEN'),
      ('visible_level', 'varchar:OB_MAX_CONFIG_VISIBLE_LEVEL_LEN'),
      ('scope', 'varchar:OB_MAX_CONFIG_SCOPE_LEN'),
      ('source', 'varchar:OB_MAX_CONFIG_SOURCE_LEN'),
      ('edit_level', 'varchar:OB_MAX_CONFIG_EDIT_LEVEL_LEN'),
      ('default_value', 'varchar:OB_MAX_CONFIG_VALUE_LEN'),
      ('isdefault', 'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 11040: __all_virtual_partition_replay_status # abandoned in 4.0

def_table_schema(
  owner = 'guoyun.lgy',
  table_name     = '__all_virtual_trace_span_info',
  table_id       = '11042',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('request_id', 'int')
  ],
  in_tenant_space = True,

  normal_columns = [
    ('trace_id', 'varchar:OB_MAX_SPAN_LENGTH'),
    ('span_id', 'varchar:OB_MAX_SPAN_LENGTH'),
    ('parent_span_id', 'varchar:OB_MAX_SPAN_LENGTH'),
    ('span_name', 'varchar:OB_MAX_SPAN_LENGTH'),
    ('ref_type', 'varchar:OB_MAX_REF_TYPE_LENGTH'),
    ('start_ts', 'int'),
    ('end_ts', 'int'),
    ('tags', 'longtext'),
    ('logs', 'longtext'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'nijia.nj',
  table_name     = '__all_virtual_engine',
  table_id       = '11043',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('ENGINE', 'varchar:MAX_ENGINE_LENGTH'),
  ('SUPPORT', 'varchar:MAX_BOOL_STR_LENGTH'),
  ('COMMENT', 'varchar:MAX_COLUMN_COMMENT_LENGTH'),
  ('TRANSACTIONS', 'varchar:MAX_BOOL_STR_LENGTH'),
  ('XA', 'varchar:MAX_BOOL_STR_LENGTH'),
  ('SAVEPOINTS', 'varchar:MAX_BOOL_STR_LENGTH'),
  ],
)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name     = '__all_virtual_proxy_server_stat',
  table_id       = '11045',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('zone', 'varchar:MAX_ZONE_LENGTH'),
      ('start_service_time', 'int'),
      ('stop_time', 'int'),
      ('status', 'varchar:OB_SERVER_STATUS_LENGTH'),
  ],
)

def_table_schema(
    owner = 'yanmu.ztl',
    table_name     = '__all_virtual_proxy_sys_variable',
    table_id       = '11046',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ],

  normal_columns = [
      ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN'),
      ('tenant_id', 'int'),
      ('data_type', 'int'),
      ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN'),
      ('flags', 'int'),
      ('modified_time','int'),
  ],
)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name     = '__all_virtual_proxy_schema',
  table_id       = '11047',
  table_type     = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
    ('tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE'),
    ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
    ('table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH'),
    ('tablet_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('sql_port', 'int'),
    ],
  in_tenant_space = True,
  normal_columns = [
  ('table_id', 'int'),
  ('role', 'int'),
  ('part_num', 'int'),
  ('replica_num', 'int'),
  ('table_type', 'int'),
  ('schema_version', 'int'),
  ('replica_type', 'int'),
  ('dup_replica_type', 'int'),
  ('memstore_percent', 'int'),
  ('spare1', 'int'),
  ('spare2', 'int'),
  ('spare3', 'int'),
  ('spare4', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
  ('spare5', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
  ('spare6', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
  ('complex_table_type', 'int'),
  ('level1_decoded_db_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
  ('level1_decoded_table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH'),
  ('level2_decoded_db_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
  ('level2_decoded_table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH'),
  ]
)

def_table_schema(
  owner = 'xiaoyi.xy',
  table_name     = '__all_virtual_plan_cache_plan_explain',
  table_id       = '11048',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('plan_id', 'int'),
  ],

  normal_columns = [
    ('operator', 'varchar:OB_MAX_OPERATOR_NAME_LENGTH'),
    ('name', 'varchar:OB_MAX_PLAN_EXPLAIN_NAME_LENGTH'),
    ('rows', 'int'),
    ('cost', 'int'),
    ('property', 'varchar:OB_MAX_OPERATOR_PROPERTY_LENGTH'),
    ('plan_depth', 'int'),
    ('plan_line_id', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'lichangqing',
    table_name     = '__all_virtual_obrpc_stat',
    table_id       = '11049',
    table_type = 'VIRTUAL_TABLE',
    in_tenant_space = True,
    gm_columns     = [],
    rowkey_columns = [
    ],

  normal_columns = [
      ('tenant_id', 'int'),
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('dest_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('dest_port', 'int'),
      ('index', 'int'),
      ('zone', 'varchar:OB_MAX_CHAR_LENGTH'),
      ('pcode', 'int'),
      ('pcode_name', 'varchar:OB_MAX_CHAR_LENGTH'),
      ('count', 'int'),
      ('total_time', 'int'),
      ('total_size', 'int'),
      ('max_time', 'int'),
      ('min_time', 'int'),
      ('max_size', 'int'),
      ('min_size', 'int'),
      ('failure', 'int'),
      ('timeout', 'int'),
      ('sync', 'int'),
      ('async', 'int'),
      ('last_timestamp', 'timestamp'),
      ('isize', 'int'),
      ('icount', 'int'),
      ('net_time', 'int'),
      ('wait_time', 'int'),
      ('queue_time', 'int'),
      ('process_time', 'int'),
      ('ilast_timestamp', 'timestamp'),
      ('dcount', 'int'),
  ],
    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)

# 11051: abandoned
# 11052: __all_virtual_sql_monitor # abandoned in 4.0

def_table_schema(
  owner = 'xiaoyi.xy',
  table_name     = '__tenant_virtual_outline',
  table_id       = '11053',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],
  in_tenant_space = True,

  normal_columns = [
      ('tenant_id', 'int'),
      ('database_id', 'int'),
      ('outline_id', 'int'),
      ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false', ''),
      ('outline_name', 'varchar:OB_MAX_OUTLINE_NAME_LENGTH', 'false', ''),
      ('visible_signature', 'longtext', 'false'),
      ('sql_text', 'longtext', 'false'),
      ('outline_target', 'longtext', 'false'),
      ('outline_sql', 'longtext', 'false'),
      ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH', 'false', ''),
      ('outline_content', 'longtext', 'false'),
      ('format_sql_text', 'longtext', 'true'),
      ('format_sql_id', 'varbinary:OB_MAX_SQL_ID_LENGTH', 'false', ''),
      ('format_outline', 'int', 'false', '0')
    ],
)

def_table_schema(
  owner = 'xiaoyi.xy',
  table_name     = '__tenant_virtual_concurrent_limit_sql',
  table_id       = '11054',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
      ('tenant_id', 'int'),
      ('database_id', 'int'),
      ('outline_id', 'int'),
      ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'false', ''),
      ('outline_name', 'varchar:OB_MAX_OUTLINE_NAME_LENGTH', 'false', ''),
      ('outline_content', 'longtext', 'false'),
      ('visible_signature', 'longtext', 'false'),
      ('sql_text', 'longtext', 'false'),
      ('concurrent_num', 'int', 'false', '-1'),
      ('limit_target', 'longtext', 'false'),
  ],
)

# 11055: __all_virtual_sql_plan_statistics # abandoned in 4.0

def_table_schema(
  owner = 'jiahua.cjh',
  table_name     = '__all_virtual_tablet_sstable_macro_info',
  table_id       = '11056',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('ls_id', 'int'),
      ('tablet_id', 'int'),
      ('end_log_scn', 'uint'),
      ('macro_idx_in_sstable', 'int'),
      ],
    normal_columns = [
      ('macro_logic_version', 'uint'),
      ('macro_block_idx', 'int'),
      ('data_seq', 'int'),
      ('row_count', 'int'),
      ('original_size', 'int'),
      ('encoding_size', 'int'),
      ('compressed_size', 'int'),
      ('occupy_size', 'int'),
      ('micro_block_count', 'int'),
      ('data_checksum', 'int'),
      ('start_key', 'varchar:OB_MAX_ROW_KEY_LENGTH'),
      ('end_key', 'varchar:OB_MAX_ROW_KEY_LENGTH'),
      ('macro_block_type', 'varchar:MAX_VALUE_LENGTH'),
      ('compressor_name', 'varchar:OB_MAX_COMPRESSOR_NAME_LENGTH'),
      ('row_store_type', 'varchar:OB_MAX_COMPRESSOR_NAME_LENGTH'),
      ('cg_idx', 'int'),
   ],
    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name     = '__all_virtual_proxy_partition_info',
  table_id       = '11057',
  table_type     = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
    ('tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE'),
    ('table_id', 'int'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('part_level', 'int'),
    ('all_part_num', 'int'),
    ('template_num', 'int'),
    ('part_id_rule_ver', 'int'),

    ('part_type', 'int'),
    ('part_num', 'int'),
    ('is_column_type', 'bool'),
    ('part_space', 'int'),
    ('part_expr', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('part_expr_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('part_range_type', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('part_interval', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('part_interval_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('interval_start', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('interval_start_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),

    ('sub_part_type', 'int'),
    ('sub_part_num', 'int'),
    ('is_sub_column_type', 'bool'),
    ('sub_part_space', 'int'),
    ('sub_part_expr', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('sub_part_expr_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('sub_part_range_type', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('def_sub_part_interval', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('def_sub_part_interval_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('def_sub_interval_start', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('def_sub_interval_start_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),

    ('part_key_num', 'int'),
    ('part_key_name', 'varchar:OB_MAX_COLUMN_NAME_LENGTH'),
    ('part_key_type', 'int'),
    ('part_key_idx', 'int'),
    ('part_key_level', 'int'),
    ('part_key_extra', 'varchar:COLUMN_EXTRA_LENGTH'),
    ('part_key_collation_type', 'int'),
    ('part_key_rowkey_idx', 'int'),
    ('part_key_expr', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('part_key_length', 'int'),
    ('part_key_precision', 'int'),
    ('part_key_scale', 'int'),

    ('spare1', 'int'),
    ('spare2', 'int'),
    ('spare3', 'int'),
    ('spare4', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('spare5', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('spare6', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('part_key_default_value', 'longtext'),
  ],
)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name     = '__all_virtual_proxy_partition',
  table_id       = '11058',
  table_type     = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
    ('tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE'),
    ('table_id', 'int'),
    ('part_id', 'int'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('part_name', 'varchar:OB_MAX_PARTITION_NAME_LENGTH'),
    ('status', 'int'),
    ('low_bound_val', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('low_bound_val_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('high_bound_val', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('high_bound_val_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('part_position', 'int'),
    ('tablet_id', 'int'),


    ('sub_part_num', 'int'),
    ('sub_part_space', 'int'),
    ('sub_part_interval', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('sub_part_interval_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('sub_interval_start', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('sub_interval_start_bin', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),

    ('spare1', 'int'),
    ('spare2', 'int'),
    ('spare3', 'int'),
    ('spare4', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('spare5', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('spare6', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
  ],
)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name    = '__all_virtual_proxy_sub_partition',
  table_id      = '11059',
  table_type    = 'VIRTUAL_TABLE',
  gm_columns    = [],
  rowkey_columns = [
    ('tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE'),
    ('table_id', 'int'),
    ('part_id', 'int'),
    ('sub_part_id', 'int'),
  ],
  in_tenant_space = True,
  normal_columns = [
    ('part_name', 'varchar:OB_MAX_PARTITION_NAME_LENGTH'),
    ('status', 'int'),
    ('low_bound_val', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('low_bound_val_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('high_bound_val', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('high_bound_val_bin', 'varchar:OB_MAX_B_PARTITION_EXPR_LENGTH'),
    ('sub_part_position', 'int'),
    ('tablet_id', 'int'),

    ('spare1', 'int'),
    ('spare2', 'int'),
    ('spare3', 'int'),
    ('spare4', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('spare5', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('spare6', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
  ],
)

# 11060: __all_virtual_proxy_route # abandoned in 4.0
# 11061: __all_virtual_rebalance_tenant_stat # abandoned in 4.0
# 11062: __all_virtual_rebalance_unit_stat # abandoned in 4.0.

# 11063: __all_virtual_rebalance_replica_stat # abandoned in 4.0
# 11067: __all_virtual_election_event_history # abandoned in 4.0

# 11069: __all_virtual_leader_stat # abandoned in 4.0

# 11070: __all_virtual_partition_migration_status # abandoned in 4.0


def_table_schema(
  owner = 'yongle.xh',
  table_name     = '__all_virtual_sys_task_status',
  table_id       = '11071',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  normal_columns = [
  ('start_time', 'timestamp'),
  ('task_type', 'varchar:OB_SYS_TASK_TYPE_LENGTH'),
  ('task_id', 'varchar:OB_TRACE_STAT_BUFFER_SIZE'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('comment', 'varchar:OB_MAX_TASK_COMMENT_LENGTH', 'false', ''),
  ('is_cancel', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'yongle.xh',
  table_name     = '__all_virtual_macro_block_marker_status',
  table_id       = '11072',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ],

  normal_columns = [
  ('total_count', 'int'),
  ('reserved_count', 'int'),
  ('meta_block_count', 'int'),
  ('shared_meta_block_count', 'int'),
  ('tmp_file_count', 'int'),
  ('data_block_count', 'int'),
  ('shared_data_block_count', 'int'),
  ('disk_block_count', 'int'),
  ('bloomfilter_count', 'int'),
  ('hold_count', 'int'),
  ('pending_free_count', 'int'),
  ('free_count', 'int'),
  ('mark_cost_time', 'int'),
  ('sweep_cost_time', 'int'),
  ('start_time', 'timestamp'),
  ('last_end_time', 'timestamp'),
  ('mark_finished', 'bool'),
  ('comment', 'varchar:MAX_TABLE_COMMENT_LENGTH', 'false', ''),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 11074: __all_virtual_rootservice_stat # abandoned in 4.0.

# 11076: __all_virtual_tenant_disk_stat # abandoned in 4.0
# 11078: __all_virtual_rebalance_map_stat # abandoned in 4.0.
# 11079: __all_virtual_rebalance_map_item_stat # abandoned in 4.0.

def_table_schema(
  owner = 'chaser.ch',
  table_name     = '__all_virtual_io_stat',
  table_id       = '11080',
  table_type     = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
      ],

  normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
      ('svr_port', 'int', 'false'),
      ('fd', 'int', 'false'),
      ('disk_type', 'varchar:OB_MAX_DISK_TYPE_LENGTH'),
      ('sys_io_up_limit_in_mb', 'int'),
      ('sys_io_bandwidth_in_mb', 'int'),
      ('sys_io_low_watermark_in_mb', 'int'),
      ('sys_io_high_watermark_in_mb', 'int'),
      ('io_bench_result', 'varchar:OB_MAX_IO_BENCH_RESULT_LENGTH'),
      ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)


def_table_schema(
    owner = 'zhenjiang.xzj',
    table_name     = '__all_virtual_long_ops_status',
    table_id       = '11081',
    table_type     = 'VIRTUAL_TABLE',
    gm_columns     = [],
    rowkey_columns = [
      ],

    normal_columns = [
      ('tenant_id', 'int'),
      ('sid', 'int'),
      ('op_name', 'varchar:MAX_LONG_OPS_NAME_LENGTH'),
      ('target', 'varchar:MAX_LONG_OPS_TARGET_LENGTH'),
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('start_time', 'int'),
      ('finish_time', 'int'),
      ('elapsed_time', 'int'),
      ('remaining_time', 'int'),
      ('last_update_time', 'int'),
      ('percentage', 'int'),
      ('message', 'varchar:MAX_LONG_OPS_MESSAGE_LENGTH'),
      ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
      ],
  vtable_route_policy = 'only_rs',
)

# 11082: __all_virtual_rebalance_unit_migrate_stat # abandoned in 4.0.
# 11083: __all_virtual_rebalance_unit_distribution_stat # abandoned in 4.0.

def_table_schema(
  owner = 'nijia.nj',
  table_name     = '__all_virtual_server_object_pool',
  table_id       = '11084',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('object_type', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH'),
      ('arena_id', 'int'),
  ],

  normal_columns = [
      ('lock', 'int'),
      ('borrow_count', 'int'),
      ('return_count', 'int'),
      ('miss_count', 'int'),
      ('miss_return_count', 'int'),
      ('free_num', 'int'),
      ('last_borrow_ts', 'int'),
      ('last_return_ts', 'int'),
      ('last_miss_ts', 'int'),
      ('last_miss_return_ts', 'int'),
      ('next', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'shanyan.g',
  table_name     = '__all_virtual_trans_lock_stat',
  table_id       = '11085',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  in_tenant_space = True,
  normal_columns = [
  ('tenant_id', 'int'),
  ('trans_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('ls_id', 'int'),
  ('table_id', 'int'),
  ('tablet_id', 'int'),
  ('rowkey', 'varchar:512', 'true'),
  ('session_id', 'int'),
  ('proxy_session_id', 'varchar:512'),
  ('ctx_create_time', 'timestamp', 'true'),
  ('expired_time', 'timestamp', 'true'),
  ('time_after_recv', 'int'),
  ('row_lock_addr', 'uint', 'true'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name     = '__tenant_virtual_show_create_tablegroup',
  table_id       = '11087',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('tablegroup_id', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('tablegroup_name', 'varchar:OB_MAX_TABLEGROUP_NAME_LENGTH'),
  ('create_tablegroup', 'longtext'),
  ],
)

def_table_schema(
  owner = 'debin.jdb',
  tablegroup_id = 'OB_INVALID_ID',
  table_name     = '__all_virtual_server_blacklist',
  table_id       = '11088',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int', 'false'),
  ('dst_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('dst_port', 'int', 'false'),
  ('is_in_blacklist', 'bool'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 11090: __all_virtual_trans_result_info_stat # abandoned in 4.0

# 11091: __all_virtual_duplicate_partition_mgr_stat # abandoned in 4.0

def_table_schema(
    owner = 'fyy280124',
    table_name     = '__all_virtual_tenant_parameter_stat',
    table_id       = '11092',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ],
    in_tenant_space = True,
    enable_column_def_enum = True,

  normal_columns = [
      ('zone', 'varchar:MAX_ZONE_LENGTH'),
      ('svr_type', 'varchar:SERVER_TYPE_LENGTH'),
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN'),
      ('data_type', 'varchar:OB_MAX_CONFIG_TYPE_LENGTH', 'true'),
      ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN'),
      ('info', 'varchar:OB_MAX_CONFIG_INFO_LEN'),
      ('section', 'varchar:OB_MAX_CONFIG_SECTION_LEN'),
      ('scope', 'varchar:OB_MAX_CONFIG_SCOPE_LEN'),
      ('source', 'varchar:OB_MAX_CONFIG_SOURCE_LEN'),
      ('edit_level', 'varchar:OB_MAX_CONFIG_EDIT_LEVEL_LEN'),
      ('tenant_id', 'int', 'true'),
      ('default_value', 'varchar:OB_MAX_CONFIG_VALUE_LEN'),
      ('isdefault', 'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name = '__all_virtual_server_schema_info',
  table_id = '11093',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],

  in_tenant_space = True,
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ("refreshed_schema_version", 'int'),
    ("received_schema_version", 'int'),
    ("schema_count", 'int'),
    ("schema_size", 'int'),
    ("min_sstable_schema_version", 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'nijia.nj',
  table_name     = '__all_virtual_memory_context_stat',
  table_id       = '11094',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],

  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('entity', 'varchar:128'),
    ('p_entity', 'varchar:128'),
    ('hold', 'bigint:20'),
    ('malloc_hold', 'bigint:20'),
    ('malloc_used', 'bigint:20'),
    ('arena_hold', 'bigint:20'),
    ('arena_used', 'bigint:20'),
    ('create_time', 'timestamp'),
    ('location', 'varchar:512'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'nijia.nj',
  table_name     = '__all_virtual_dump_tenant_info',
  table_id       = '11095',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'bigint:20'),
  ],

  normal_columns = [
    ('compat_mode', 'bigint:20'),
    ('unit_min_cpu', 'double'),
    ('unit_max_cpu', 'double'),
    ('slice', 'double'),
    ('remain_slice', 'double'),
    ('token_cnt', 'bigint:20'),
    ('ass_token_cnt', 'bigint:20'),
    ('lq_tokens', 'bigint:20'),
    ('used_lq_tokens', 'bigint:20'),
    ('stopped', 'bigint:20'),
    ('idle_us', 'bigint:20'),
    ('recv_hp_rpc_cnt', 'bigint:20'),
    ('recv_np_rpc_cnt', 'bigint:20'),
    ('recv_lp_rpc_cnt', 'bigint:20'),
    ('recv_mysql_cnt', 'bigint:20'),
    ('recv_task_cnt', 'bigint:20'),
    ('recv_large_req_cnt', 'bigint:20'),
    ('recv_large_queries', 'bigint:20'),
    ('actives', 'bigint:20'),
    ('workers', 'bigint:20'),
    ('lq_waiting_workers', 'bigint:20'),
    ('req_queue_total_size', 'bigint:20'),
    ('queue_0', 'bigint:20'),
    ('queue_1', 'bigint:20'),
    ('queue_2', 'bigint:20'),
    ('queue_3', 'bigint:20'),
    ('queue_4', 'bigint:20'),
    ('queue_5', 'bigint:20'),
    ('large_queued', 'bigint:20'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'fyy280124',
    table_name     = '__all_virtual_tenant_parameter_info',
    table_id       = '11096',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
        ('tenant_id', 'int'),
        ('zone', 'varchar:MAX_ZONE_LENGTH'),
        ('svr_type', 'varchar:SERVER_TYPE_LENGTH'),
        ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
        ('svr_port', 'int'),
        ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN'),
    ],
  normal_columns = [
      ('data_type', 'varchar:OB_MAX_CONFIG_TYPE_LENGTH', 'true'),
      ('value', 'varchar:OB_MAX_CONFIG_VALUE_LEN'),
      ('info', 'varchar:OB_MAX_CONFIG_INFO_LEN'),
      ('section', 'varchar:OB_MAX_CONFIG_SECTION_LEN'),
      ('scope', 'varchar:OB_MAX_CONFIG_SCOPE_LEN'),
      ('source', 'varchar:OB_MAX_CONFIG_SOURCE_LEN'),
      ('edit_level', 'varchar:OB_MAX_CONFIG_EDIT_LEVEL_LEN'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'sean.yyj',
  table_name    = '__all_virtual_audit_operation',
  table_id      = '11097',
  table_type = 'VIRTUAL_TABLE',
  gm_columns    = [],
  rowkey_columns = [
  ],
  in_tenant_space = True,

  normal_columns = [
  ('operation_type', 'int'),
  ('operation_name', 'varchar:OB_MAX_SYS_PARAM_NAME_LENGTH'),
  ('audit_type_name', 'varchar:OB_MAX_SYS_PARAM_NAME_LENGTH'),
  ],
)

def_table_schema(
  owner = 'sean.yyj',
  table_name    = '__all_virtual_audit_action',
  table_id      = '11098',
  table_type = 'VIRTUAL_TABLE',
  gm_columns    = [],
  rowkey_columns = [
  ],
  in_tenant_space = True,

  normal_columns = [
  ('action_id', 'int'),
  ('action_name', 'varchar:OB_MAX_SYS_PARAM_NAME_LENGTH'),
  ],
)

def_table_schema(
    owner = 'lixia.yq',
    table_name     = '__all_virtual_dag_warning_history',
    table_id       = '11099',
    table_type     = 'VIRTUAL_TABLE',
    gm_columns     = [],
    rowkey_columns = [],

    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('task_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
      ('module', 'varchar:OB_MODULE_NAME_LENGTH'),
      ('type', 'varchar:OB_SYS_TASK_TYPE_LENGTH'),
      ('ret', 'varchar:OB_RET_STR_LENGTH'),
      ('status', 'varchar:OB_STATUS_STR_LENGTH'),
      ('gmt_create', 'timestamp'),
      ('gmt_modified', 'timestamp'),
      ('retry_cnt', 'int'),
      ('warning_info', 'varchar:OB_DAG_WARNING_INFO_LENGTH'),
      ],

    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'sean.yyj',
    table_name     = '__all_virtual_tablet_encrypt_info',
    table_id       = '11100',
    table_type     = 'VIRTUAL_TABLE',
    gm_columns     = [],
    in_tenant_space = True,
    rowkey_columns = [
      ('tenant_id', 'int'),
      ('tablet_id', 'int'),
    ],

    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('macro_block_count', 'int'),
      ('encrypted_macro_block_count', 'int'),
    ],

    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'chongrong.th',
  table_name     = '__tenant_virtual_show_restore_preview',
  table_id       = '11102',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],

  normal_columns = [
    ('backup_type', 'varchar:20'),
    ('backup_id', 'int'),
    ('backup_dest', 'varchar:OB_MAX_BACKUP_DEST_LENGTH', 'true'),
    ('description', 'varchar:OB_MAX_BACKUP_DEST_LENGTH', 'true'),
  ],
)

def_table_schema(
  owner = 'sean.yyj',
  table_name    = '__all_virtual_master_key_version_info',
  table_id      = '11104',
  table_type = 'VIRTUAL_TABLE',
  gm_columns    = [],
  rowkey_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
  ],
  normal_columns = [
    ('max_active_version', 'int'),
    ('max_stored_version', 'int'),
    ('expect_version', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'lixia.yq',
    table_name     = '__all_virtual_dag',
    table_id       = '11105',
    table_type     = 'VIRTUAL_TABLE',
    gm_columns     = [],
    rowkey_columns = [],
    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('dag_type', 'varchar:OB_SYS_TASK_TYPE_LENGTH'),
      ('dag_key', 'varchar:OB_DAG_KEY_LENGTH'),
      ('dag_net_key', 'varchar:OB_DAG_KEY_LENGTH'),
      ('dag_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
      ('status', 'varchar:OB_STATUS_STR_LENGTH'),
      ('running_task_cnt', 'int'),
      ('add_time', 'timestamp'),
      ('start_time', 'timestamp'),
      ('indegree', 'int'),
      ('comment', 'varchar:OB_DAG_COMMET_LENGTH'),
    ],
    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'lixia.yq',
    table_name     = '__all_virtual_dag_scheduler',
    table_id       = '11106',
    table_type     = 'VIRTUAL_TABLE',
    gm_columns     = [],
    rowkey_columns = [],

    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('value_type', 'varchar:OB_SYS_TASK_TYPE_LENGTH'),
      ('key', 'varchar:OB_DAG_KEY_LENGTH'),
      ('value', 'int'),
    ],

    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'lixia.yq',
  table_name    = '__all_virtual_server_compaction_progress',
  table_id      = '11107',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('zone', 'varchar:MAX_ZONE_LENGTH'),
    ('tenant_id', 'int'),
    ('type', 'varchar:OB_MERGE_TYPE_STR_LENGTH'),
    ('compaction_scn', 'uint'),
    ('status', 'varchar:OB_MERGE_STATUS_STR_LENGTH'),
    ('total_tablet_count', 'int'),
    ('unfinished_tablet_count', 'int'),
    ('data_size', 'int'),
    ('unfinished_data_size', 'int'),
    ('compression_ratio', 'double'),
    ('start_time', 'timestamp'),
    ('estimated_finish_time', 'timestamp'),
    ('comments', 'varchar:OB_COMPACTION_EVENT_STR_LENGTH')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'lixia.yq',
  table_name    = '__all_virtual_tablet_compaction_progress',
  table_id      = '11108',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('type', 'varchar:OB_MERGE_TYPE_STR_LENGTH'),
    ('ls_id', 'int'),
    ('tablet_id', 'int'),
    ('compaction_scn', 'uint'),
    ('task_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
    ('status', 'varchar:OB_MERGE_STATUS_STR_LENGTH'),
    ('data_size', 'int'),
    ('unfinished_data_size', 'int'),
    ('progressive_compaction_round', 'int'),
    ('create_time', 'timestamp'),
    ('start_time', 'timestamp'),
    ('estimated_finish_time', 'timestamp'),
    ('start_cg_id', 'int'),
    ('end_cg_id', 'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'lixia.yq',
  table_name    = '__all_virtual_compaction_diagnose_info',
  table_id      = '11109',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('type', 'varchar:OB_MERGE_TYPE_STR_LENGTH'),
    ('ls_id', 'int'),
    ('tablet_id', 'int'),
    ('status', 'varchar:OB_MERGE_STATUS_STR_LENGTH'),
    ('create_time', 'timestamp'),
    ('diagnose_info', 'varchar:OB_DIAGNOSE_INFO_LENGTH'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'lixia.yq',
  table_name    = '__all_virtual_compaction_suggestion',
  table_id      = '11110',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('type', 'varchar:OB_MERGE_TYPE_STR_LENGTH'),
    ('ls_id', 'int'),
    ('tablet_id', 'int'),
    ('start_time', 'timestamp'),
    ('finish_time', 'timestamp'),
    ('suggestion', 'varchar:OB_DIAGNOSE_INFO_LENGTH'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name     = '__all_virtual_session_info',
  table_id       = '11111',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('id', 'uint', 'false', '0'),
  ('user', 'varchar:OB_MAX_USERNAME_LENGTH', 'false', ''),
  ('tenant', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE'),
  ('host', 'varchar:OB_MAX_HOST_NAME_LENGTH', 'false', ''),
  ('db', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true'),
  ('command', 'varchar:OB_MAX_COMMAND_LENGTH', 'false', ''),
  ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH', 'false', ''),
  ('time', 'double', 'false'),
  ('state', 'varchar:OB_MAX_SESSION_STATE_LENGTH', 'true'),
  ('info', 'varchar:MAX_COLUMN_VARCHAR_LENGTH', 'true'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('sql_port', 'int'),
  ('proxy_sessid', 'uint', 'true'),
  ('master_sessid', 'uint', 'true'),
  ('user_client_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
  ('user_host', 'varchar:OB_MAX_HOST_NAME_LENGTH', 'true'),
  ('trans_id', 'uint'),
  ('thread_id', 'uint'),
  ('ssl_cipher', 'varchar:OB_MAX_COMMAND_LENGTH', 'true'),
  ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'true', ''),
  ('ref_count', 'int'),
  ('backtrace', 'varchar:16384', 'true', ''),
  ('trans_state', 'varchar:OB_MAX_TRANS_STATE_LENGTH', 'true'),
  ('user_client_port', 'int', 'false', '0'),
  ('total_cpu_time', 'double', 'false'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'lixia.yq',
    table_name     = '__all_virtual_tablet_compaction_history',
    table_id       = '11112',
    table_type     = 'VIRTUAL_TABLE',
    in_tenant_space = True,
    gm_columns     = [],
    rowkey_columns = [],

    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('ls_id', 'int'),
      ('tablet_id', 'int'),
      ('type', 'varchar:OB_SYS_TASK_TYPE_LENGTH'),
      ('compaction_scn', 'uint'),
      ('start_time', 'timestamp'),
      ('finish_time', 'timestamp'),
      ('task_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
      ('occupy_size', 'int'),
      ('macro_block_count', 'int'),
      ('multiplexed_macro_block_count', 'int'),
      ('new_micro_count_in_new_macro', 'int'),
      ('multiplexed_micro_count_in_new_macro', 'int'),
      ('total_row_count', 'int'),
      ('incremental_row_count', 'int'),
      ('compression_ratio', 'double'),
      ('new_flush_data_rate', 'int'),
      ('progressive_compaction_round', 'int'),
      ('progressive_compaction_num', 'int'),
      ('parallel_degree', 'int'),
      ('parallel_info', 'varchar:OB_PARALLEL_MERGE_INFO_LENGTH'),
      ('participant_table', 'varchar:OB_PART_TABLE_INFO_LENGTH'),
      ('macro_id_list', 'varchar:OB_MACRO_ID_INFO_LENGTH'),
      ('comments', 'varchar:OB_COMPACTION_COMMENT_STR_LENGTH'),
      ('start_cg_id', 'int'),
      ('end_cg_id', 'int'),
      ('kept_snapshot', 'varchar:OB_COMPACTION_INFO_LENGTH'),
      ('merge_level', 'varchar:OB_MERGE_LEVEL_STR_LENGTH'),
      ('exec_mode', 'varchar:OB_MERGE_TYPE_STR_LENGTH'),
      ('is_full_merge', 'bool'),
      ('io_cost_time_percentage', 'int'),
      ('merge_reason', 'varchar:OB_MERGE_REASON_STR_LENGTH'),
      ('base_major_status', 'varchar:OB_MERGE_TYPE_STR_LENGTH'),
      ('co_merge_type', 'varchar:OB_MERGE_TYPE_STR_LENGTH'),
      ('mds_filter_info', 'varchar:OB_COMPACTION_COMMENT_STR_LENGTH')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
    owner             = 'jianyun.sjy',
    table_name        = '__all_virtual_io_calibration_status',
    table_id          = '11113',
    table_type        = 'VIRTUAL_TABLE',
    gm_columns        = [],
    rowkey_columns    = [],
    normal_columns    = [
      ('svr_ip',        'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port',      'int'),
      ('storage_name',  'varchar:1024'),
      ('status',        'varchar:256'),
      ('start_time',    'timestamp'),
      ('finish_time',   'timestamp'),
    ],
    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)

def_table_schema(
    owner             = 'jianyun.sjy',
    table_name        = '__all_virtual_io_benchmark',
    table_id          = '11114',
    table_type        = 'VIRTUAL_TABLE',
    gm_columns        = [],
    rowkey_columns    = [],
    normal_columns    = [
      ('svr_ip',        'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port',      'int'),
      ('storage_name',  'varchar:1024'),
      ('mode',          'varchar:256'),
      ('size',          'int'),
      ('iops',          'int'),
      ('mbps',          'int'),
      ('latency',       'int'),
    ],
    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)


def_table_schema(
    owner             = 'jianyun.sjy',
    table_name        = '__all_virtual_io_quota',
    table_id          = '11115',
    table_type        = 'VIRTUAL_TABLE',
    gm_columns        = [],
    rowkey_columns    = [],
    normal_columns    = [
      ('svr_ip',        'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port',      'int'),
      ('tenant_id',     'int'),
      ('group_id',      'int'),
      ('mode',          'varchar:256'),
      ('size',          'int'),
      ('min_iops',      'int'),
      ('max_iops',      'int'),
      ('real_iops',     'int'),
      ('min_mbps',      'int'),
      ('max_mbps',      'int'),
      ('real_mbps',     'int'),
      ('schedule_us',   'int'),
      ('io_delay_us',   'int'),
      ('total_us',      'int')
    ],
    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'lixia.yq',
  table_name    = '__all_virtual_server_compaction_event_history',
  table_id      = '11116',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('zone', 'varchar:MAX_ZONE_LENGTH'),
    ('tenant_id', 'int'),
    ('type', 'varchar:OB_MERGE_TYPE_STR_LENGTH'),
    ('compaction_scn', 'uint'),
    ('event_timestamp', 'timestamp'),
    ('event', 'varchar:OB_COMPACTION_EVENT_STR_LENGTH'),
    ('role', 'varchar:OB_MERGE_ROLE_STR_LENGTH'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'fengjingkun.fjk',
    table_name     = '__all_virtual_tablet_stat',
    table_id       = '11117',
    table_type     = 'VIRTUAL_TABLE',
    in_tenant_space = True,
    gm_columns     = [],
    rowkey_columns = [],
    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('ls_id', 'int'),
      ('tablet_id', 'int'),
      ('query_cnt', 'int'),
      ('mini_merge_cnt', 'int'),
      ('scan_output_row_cnt', 'int'),
      ('scan_total_row_cnt', 'int'),
      ('pushdown_micro_block_cnt', 'int'),
      ('total_micro_block_cnt', 'int'),
      ('exist_iter_table_cnt', 'int'),
      ('exist_total_table_cnt', 'int'),
      ('insert_row_cnt', 'int'),
      ('update_row_cnt', 'int'),
      ('delete_row_cnt', 'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'jianyun.sjy',
  table_name = '__all_virtual_ddl_sim_point',
  table_id = '11118',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  normal_columns = [
    ('sim_point_id', 'int'),
    ('sim_point_name', 'varchar:1024'),
    ('sim_point_description', 'varchar:OB_MAX_CHAR_LENGTH'),
    ('sim_point_action', 'varchar:OB_MAX_CHAR_LENGTH'),
  ],
  vtable_route_policy = 'local',
)

def_table_schema(
  owner = 'jianyun.sjy',
  table_name = '__all_virtual_ddl_sim_point_stat',
  table_id = '11119',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('ddl_task_id', 'int'),
    ('sim_point_id', 'int'),
    ('trigger_count', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'roland.qk',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = '__all_virtual_res_mgr_sysstat',
  table_id       = '11120',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [
  ('tenant_id', 'int', 'false'),
  ('group_id', 'int', 'false'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
  ('svr_port', 'int'),
  ('statistic#', 'int', 'false'),
  ],

  normal_columns = [
  ('value', 'int', 'false'),
  ('value_type', 'varchar:16', 'false'),
  ('stat_id', 'int', 'false'),
  ('name', 'varchar:64', 'false'),
  ('class', 'int', 'false'),
  ('can_visible', 'bool', 'false'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 11121: abandoned # __all_virtual_ddl_diagnose_info, which is moved to 12514

# 11122: __all_virtual_ss_tablet_upload_stat
# 11123: __all_virtual_ss_tablet_compact_stat

################################################################
# INFORMATION SCHEMA
################################################################
def_table_schema(
  owner = 'xiaochu.yh',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'SESSION_VARIABLES',
  table_id       = '12001',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('VARIABLE_NAME', 'varchar:OB_MAX_SYS_PARAM_NAME_LENGTH', 'false', ''),
  ('VARIABLE_VALUE', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH', 'true', 'NULL'),
  ],
)

# 12002: TABLE_PRIVILEGES # abandoned in 4.0
# 12003: USER_PRIVILEGES # abandoned in 4.0
# 12004: SCHEMA_PRIVILEGES # abandoned in 4.0
# 12005: TABLE_CONSTRAINTS # abandoned in 4.0

def_table_schema(
  owner = 'xiaochu.yh',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'GLOBAL_STATUS',
  table_id       = '12006',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('VARIABLE_NAME', 'varchar:OB_MAX_SYS_PARAM_NAME_LENGTH', 'false', ''),
  ('VARIABLE_VALUE', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH', 'true', 'NULL'),
  ],
)

# 12007: PARTITIONS # abandoned in 4.0

def_table_schema(
  owner = 'xiaochu.yh',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'SESSION_STATUS',
  tablegroup_id = 'OB_INVALID_ID',
  table_id       = '12008',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('VARIABLE_NAME', 'varchar:OB_MAX_SYS_PARAM_NAME_LENGTH', 'false', ''),
  ('VARIABLE_VALUE', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH', 'true', 'NULL'),
  ],
)

def_table_schema(
  owner = 'sean.yyj',
  database_id    = 'OB_MYSQL_SCHEMA_ID',
  table_name    = 'user',
  table_id      = '12009',
  table_type    = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],
  in_tenant_space = True,

  normal_columns = [
  ('host', 'varchar:OB_MAX_HOST_NAME_LENGTH'),
  ('user', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE'),
  ('password', 'varchar:OB_MAX_PASSWORD_LENGTH'),
  ('select_priv', 'varchar:1'),
  ('insert_priv', 'varchar:1'),
  ('update_priv', 'varchar:1'),
  ('delete_priv', 'varchar:1'),
  ('create_priv', 'varchar:1'),
  ('drop_priv', 'varchar:1'),
  ('reload_priv', 'varchar:1'),
  ('shutdown_priv', 'varchar:1'),
  ('process_priv', 'varchar:1'),
  ('file_priv', 'varchar:1'),
  ('grant_priv', 'varchar:1'),
  ('references_priv', 'varchar:1'),
  ('index_priv', 'varchar:1'),
  ('alter_priv', 'varchar:1'),
  ('show_db_priv', 'varchar:1'),
  ('super_priv', 'varchar:1'),
  ('create_tmp_table_priv', 'varchar:1'),
  ('lock_tables_priv', 'varchar:1'),
  ('execute_priv', 'varchar:1'),
  ('repl_slave_priv', 'varchar:1'),
  ('repl_client_priv', 'varchar:1'),
  ('create_view_priv', 'varchar:1'),
  ('show_view_priv', 'varchar:1'),
  ('create_routine_priv', 'varchar:1'),
  ('alter_routine_priv', 'varchar:1'),
  ('create_user_priv', 'varchar:1'),
  ('event_priv', 'varchar:1'),
  ('trigger_priv', 'varchar:1'),
  ('create_tablespace_priv', 'varchar:1'),
  ('ssl_type', 'varchar:10', 'false', ''),
  ('ssl_cipher', 'varchar:1024', 'false', ''),
  ('x509_issuer', 'varchar:1024', 'false', ''),
  ('x509_subject', 'varchar:1024', 'false', ''),
  ('max_questions', 'int', 'false', '0'),
  ('max_updates', 'int', 'false', '0'),
  ('max_connections', 'int', 'false', '0'),
  ('max_user_connections', 'int', 'false', '0'),
  ('plugin', 'varchar:1024'),
  ('authentication_string', 'varchar:1024'),
  ('password_expired', 'varchar:1'),
  ('account_locked', 'varchar:1'),
  ('drop_database_link_priv', 'varchar:1'),
  ('create_database_link_priv', 'varchar:1'),
  ('create_role_priv', 'varchar:1'),
  ('drop_role_priv', 'varchar:1'),
  ],
)

def_table_schema(
  owner = 'sean.yyj',
  database_id    = 'OB_MYSQL_SCHEMA_ID',
  table_name    = 'db',
  table_id      = '12010',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],
  in_tenant_space = True,

  normal_columns = [
  ('host', 'varchar:OB_MAX_HOST_NAME_LENGTH'),
  ('db', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
  ('user', 'varchar:OB_MAX_USER_NAME_LENGTH_STORE'),
  ('select_priv', 'varchar:1'),
  ('insert_priv', 'varchar:1'),
  ('update_priv', 'varchar:1'),
  ('delete_priv', 'varchar:1'),
  ('create_priv', 'varchar:1'),
  ('drop_priv', 'varchar:1'),
  ('grant_priv', 'varchar:1'),
  ('references_priv', 'varchar:1'),
  ('index_priv', 'varchar:1'),
  ('alter_priv', 'varchar:1'),
  ('create_tmp_table_priv', 'varchar:1'),
  ('lock_tables_priv', 'varchar:1'),
  ('create_view_priv', 'varchar:1'),
  ('show_view_priv', 'varchar:1'),
  ('create_routine_priv', 'varchar:1'),
  ('alter_routine_priv', 'varchar:1'),
  ('execute_priv', 'varchar:1'),
  ('event_priv', 'varchar:1'),
  ('trigger_priv', 'varchar:1'),
  ],
)

# 12012: __all_virtual_partition_table # abandoned in 4.0

def_table_schema(
  owner = 'shanyan.g',
  table_name = '__all_virtual_lock_wait_stat',
  table_id = '12013',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('tablet_id', 'int'),
  ('rowkey', 'varchar:MAX_LOCK_ROWKEY_BUF_LENGTH'),
  ('addr', 'uint'),
  ('need_wait', 'bool'),
  ('recv_ts', 'int'),
  ('lock_ts', 'int'),
  ('abs_timeout', 'int'),
  ('try_lock_times', 'int'),
  ('time_after_recv', 'int'),
  ('session_id', 'int'),
  ('block_session_id', 'int'),
  ('type', 'int'),
  ('lock_mode', 'varchar:MAX_LOCK_MODE_BUF_LENGTH'),
  ('last_compact_cnt', 'int'),
  ('total_update_cnt', 'int'),
  ('trans_id', 'int'),
  ('holder_trans_id', 'int'),
  ('holder_session_id', 'int'),
  ('ls_id', 'int'),
  ('assoc_session_id', 'int'),
  ('wait_timeout', 'int'),
  ('tx_active_ts', 'int'),
  ('node_id', 'int'),
  ('node_type', 'int'),
  ('remote_addr', 'varchar:MAX_LOCK_REMOTE_ADDR_BUF_LENGTH'),
  ('is_placeholder', 'int')
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12014: __all_virtual_partition_item # abandoned in 4.0

# 12015: __all_virtual_replica_task # abandoned in 4.0
# 12016: __all_virtual_partition_location # abandoned in 4.0

# 12030: proc  # abandoned in 4.2.5.1, replaced by 21628



def_table_schema(
    owner = 'jim.wjh',
    table_name    = '__tenant_virtual_collation',
    table_id      = '12031',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [
    ],
    normal_columns = [
        ('collation_type', 'int', 'false', '0'),
        ('collation', 'varchar:MAX_COLLATION_LENGTH', 'false', ''),
        ('charset', 'varchar:MAX_CHARSET_LENGTH', 'false', ''),
        ('id', 'int', 'false', '0'),
        ('is_default', 'varchar:MAX_BOOL_STR_LENGTH', 'false', ''),
        ('is_compiled', 'varchar:MAX_BOOL_STR_LENGTH', 'false', ''),
        ('sortlen', 'int', 'false', '0'),
  ],
)

def_table_schema(
    owner = 'jim.wjh',
    table_name    = '__tenant_virtual_charset',
    table_id      = '12032',
    table_type = 'VIRTUAL_TABLE',
    in_tenant_space = True,
    gm_columns = [],
    rowkey_columns = [
    ],
    normal_columns = [
        ('charset', 'varchar:MAX_CHARSET_LENGTH', 'false', ''),
        ('description', 'varchar:MAX_CHARSET_DESCRIPTION_LENGTH', 'false', ''),
        ('default_collation', 'varchar:MAX_COLLATION_LENGTH', 'false', ''),
        ('max_length', 'int', 'false', '0'),
  ],
)

def_table_schema(
  owner = 'jingyan.kfy',
  table_name = '__all_virtual_tenant_memstore_allocator_info',
  table_id = '12033',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('tablet_id', 'int'),
  ('start_scn', 'uint'),
  ('end_scn', 'uint'),
  ('is_active', 'varchar:MAX_COLUMN_YES_NO_LENGTH'),
  ('retire_clock', 'int'),
  ('mt_protection_clock', 'int'),
  ('address', 'varchar:OB_MAX_POINTER_ADDR_LEN'),
  ('ref_count', 'int')
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'baichangmin.bcm',
    table_name    = '__all_virtual_table_mgr',
    table_id      = '12034',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ],
    in_tenant_space=True,
    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('ls_id', 'int'),
      ('table_type', 'int'),
      ('tablet_id', 'int'),
      ('start_log_scn', 'uint'),
      ('end_log_scn', 'uint'),
      ('upper_trans_version', 'uint'),
      ('size', 'int'),
      ('data_block_count', 'int'),
      ('index_block_count', 'int'),
      ('linked_block_count', 'int'),
      ('ref', 'int'),
      ('is_active', 'varchar:MAX_COLUMN_YES_NO_LENGTH'),
      ('contain_uncommitted_row', 'varchar:MAX_COLUMN_YES_NO_LENGTH'),
      ('nested_offset', 'int'),
      ('nested_size', 'int'),
      ('cg_idx', 'int'),
      ('data_checksum', 'int'),
      ('table_flag', 'int'),
    ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12036',
  table_name = '__all_virtual_freeze_info',
  keywords = all_def_keywords['__all_freeze_info'],
  in_tenant_space = True))

# 12037: PARAMETERS # abandoned in 4.0

def_table_schema(
  owner = 'jianyun.sjy',
  tablegroup_id = 'OB_INVALID_ID',
  table_name      = '__all_virtual_bad_block_table',
  table_id        = '12038',
  table_type      = 'VIRTUAL_TABLE',
  gm_columns      = [],

  rowkey_columns  = [
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('disk_id', 'int'),
  ('store_file_path', 'varchar:MAX_PATH_SIZE'),
  ('macro_block_index', 'int'),
  ('error_type', 'int'),
  ('error_msg', 'varchar:OB_MAX_ERROR_MSG_LEN'),
  ('check_time', 'timestamp'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name      = '__all_virtual_px_worker_stat',
  table_id        = '12039',
  table_type      = 'VIRTUAL_TABLE',
  gm_columns      = [],
  in_tenant_space = True,
  rowkey_columns  = [
  ],
  normal_columns = [
  ('session_id', 'int'),
  ('tenant_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('trace_id', 'varchar:OB_MAX_HOST_NAME_LENGTH'),
  ('qc_id', 'int'),
  ('sqc_id', 'int'),
  ('worker_id', 'int'),
  ('dfo_id', 'int'),
  ('start_time', 'timestamp'),
  ('thread_id', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12042: __all_virtual_weak_read_stat # abandoned in 4.0

# 12054: __all_virtual_partition_audit # abandoned in 4.0

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12055',
  table_name = '__all_virtual_auto_increment',
  keywords = all_def_keywords['__all_auto_increment']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12056',
  table_name = '__all_virtual_sequence_value',
  keywords = all_def_keywords['__all_sequence_value']))

# 12057: __all_virtual_cluster # abandoned in 4.0

def_table_schema(
  owner = 'yht146493',
  table_name     = '__all_virtual_tablet_store_stat',
  table_id       = '12058',
  table_type     = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
    ],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('table_id', 'int'),
    ('tablet_id', 'int'),
    ('row_cache_hit_count', 'int'),
    ('row_cache_miss_count', 'int'),
    ('row_cache_put_count', 'int'),
    ('bf_filter_count', 'int'),
    ('bf_empty_read_count', 'int'),
    ('bf_access_count', 'int'),
    ('block_cache_hit_count', 'int'),
    ('block_cache_miss_count', 'int'),
    ('access_row_count', 'int'),
    ('output_row_count', 'int'),
    ('fuse_row_cache_hit_count', 'int'),
    ('fuse_row_cache_miss_count', 'int'),
    ('fuse_row_cache_put_count', 'int'),
    ('single_get_call_count', 'int'),
    ('single_get_output_row_count', 'int'),
    ('multi_get_call_count', 'int'),
    ('multi_get_output_row_count', 'int'),
    ('index_back_call_count', 'int'),
    ('index_back_output_row_count', 'int'),
    ('single_scan_call_count', 'int'),
    ('single_scan_output_row_count', 'int'),
    ('multi_scan_call_count', 'int'),
    ('multi_scan_output_row_count', 'int'),
    ('exist_row_effect_read_count', 'int'),
    ('exist_row_empty_read_count', 'int'),
    ('get_row_effect_read_count', 'int'),
    ('get_row_empty_read_count', 'int'),
    ('scan_row_effect_read_count', 'int'),
    ('scan_row_empty_read_count', 'int'),
    ('macro_access_count', 'int'),
    ('micro_access_count', 'int'),
    ('pushdown_micro_access_count', 'int'),
    ('pushdown_row_access_count', 'int'),
    ('pushdown_row_select_count', 'int'),
    ('rowkey_prefix_access_info', 'varchar:COLUMN_DEFAULT_LENGTH'),
    ('index_block_cache_hit_count', 'int'),
    ('index_block_cache_miss_count', 'int'),
    ('logical_read_count', 'int'),
    ('physical_read_count', 'int'),
    ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# Because of implementation problems, tenant schema's ddl operations can't be found in __all_virtual_ddl_operation.
def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12059',
  table_name = '__all_virtual_ddl_operation',
  keywords = all_def_keywords['__all_ddl_operation']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12060',
  table_name = '__all_virtual_outline',
  keywords = all_def_keywords['__all_outline']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12061',
  table_name = '__all_virtual_outline_history',
  keywords = all_def_keywords['__all_outline_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12062',
  table_name = '__all_virtual_synonym',
  keywords = all_def_keywords['__all_synonym']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12063',
  table_name = '__all_virtual_synonym_history',
  keywords = all_def_keywords['__all_synonym_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12064',
  table_name = '__all_virtual_database_privilege',
  keywords = all_def_keywords['__all_database_privilege']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12065',
  table_name = '__all_virtual_database_privilege_history',
  keywords = all_def_keywords['__all_database_privilege_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12066',
  table_name = '__all_virtual_table_privilege',
  keywords = all_def_keywords['__all_table_privilege']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12067',
  table_name = '__all_virtual_table_privilege_history',
  keywords = all_def_keywords['__all_table_privilege_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12068',
  table_name = '__all_virtual_database',
  keywords = all_def_keywords['__all_database']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12069',
  table_name = '__all_virtual_database_history',
  keywords = all_def_keywords['__all_database_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12070',
  table_name = '__all_virtual_tablegroup',
  keywords = all_def_keywords['__all_tablegroup']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12071',
  table_name = '__all_virtual_tablegroup_history',
  keywords = all_def_keywords['__all_tablegroup_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12072',
  table_name = '__all_virtual_table',
  keywords = all_def_keywords['__all_table'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12073',
  table_name = '__all_virtual_table_history',
  keywords = all_def_keywords['__all_table_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12074',
  table_name = '__all_virtual_column',
  keywords = all_def_keywords['__all_column']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12075',
  table_name = '__all_virtual_column_history',
  keywords = all_def_keywords['__all_column_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12076',
  table_name = '__all_virtual_part',
  keywords = all_def_keywords['__all_part']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12077',
  table_name = '__all_virtual_part_history',
  keywords = all_def_keywords['__all_part_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12078',
  table_name = '__all_virtual_part_info',
  keywords = all_def_keywords['__all_part_info']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12079',
  table_name = '__all_virtual_part_info_history',
  keywords = all_def_keywords['__all_part_info_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12080',
  table_name = '__all_virtual_def_sub_part',
  keywords = all_def_keywords['__all_def_sub_part']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12081',
  table_name = '__all_virtual_def_sub_part_history',
  keywords = all_def_keywords['__all_def_sub_part_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12082',
  table_name = '__all_virtual_sub_part',
  keywords = all_def_keywords['__all_sub_part']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12083',
  table_name = '__all_virtual_sub_part_history',
  keywords = all_def_keywords['__all_sub_part_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12084',
  table_name = '__all_virtual_constraint',
  keywords = all_def_keywords['__all_constraint']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12085',
  table_name = '__all_virtual_constraint_history',
  keywords = all_def_keywords['__all_constraint_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12086',
  table_name = '__all_virtual_foreign_key',
  keywords = all_def_keywords['__all_foreign_key']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12087',
  table_name = '__all_virtual_foreign_key_history',
  keywords = all_def_keywords['__all_foreign_key_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12088',
  table_name = '__all_virtual_foreign_key_column',
  keywords = all_def_keywords['__all_foreign_key_column']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12089',
  table_name = '__all_virtual_foreign_key_column_history',
  keywords = all_def_keywords['__all_foreign_key_column_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12090',
  table_name = '__all_virtual_temp_table',
  keywords = all_def_keywords['__all_temp_table']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12091',
  table_name = '__all_virtual_ori_schema_version',
  keywords = all_def_keywords['__all_ori_schema_version']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12092',
  table_name = '__all_virtual_sys_stat',
  keywords = all_def_keywords['__all_sys_stat']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12093',
  table_name = '__all_virtual_user',
  keywords = all_def_keywords['__all_user'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12094',
  table_name = '__all_virtual_user_history',
  keywords = all_def_keywords['__all_user_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12095',
  table_name = '__all_virtual_sys_variable',
  keywords = all_def_keywords['__all_sys_variable']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12096',
  table_name = '__all_virtual_sys_variable_history',
  keywords = all_def_keywords['__all_sys_variable_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12097',
  table_name = '__all_virtual_func',
  keywords = all_def_keywords['__all_func']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12098',
  table_name = '__all_virtual_func_history',
  keywords = all_def_keywords['__all_func_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12099',
  table_name = '__all_virtual_package',
  keywords = all_def_keywords['__all_package']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12100',
  table_name = '__all_virtual_package_history',
  keywords = all_def_keywords['__all_package_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12101',
  table_name = '__all_virtual_routine',
  keywords = all_def_keywords['__all_routine']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12102',
  table_name = '__all_virtual_routine_history',
  keywords = all_def_keywords['__all_routine_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12103',
  table_name = '__all_virtual_routine_param',
  keywords = all_def_keywords['__all_routine_param']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12104',
  table_name = '__all_virtual_routine_param_history',
  keywords = all_def_keywords['__all_routine_param_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12105',
  table_name = '__all_virtual_type',
  keywords = all_def_keywords['__all_type']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12106',
  table_name = '__all_virtual_type_history',
  keywords = all_def_keywords['__all_type_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12107',
  table_name = '__all_virtual_type_attr',
  keywords = all_def_keywords['__all_type_attr']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12108',
  table_name = '__all_virtual_type_attr_history',
  keywords = all_def_keywords['__all_type_attr_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12109',
  table_name = '__all_virtual_coll_type',
  keywords = all_def_keywords['__all_coll_type']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12110',
  table_name = '__all_virtual_coll_type_history',
  keywords = all_def_keywords['__all_coll_type_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12115',
  table_name = '__all_virtual_recyclebin',
  keywords = all_def_keywords['__all_recyclebin']))

# 12116: __all_virtual_tenant_gc_partition_info # abandoned in 4.0

# 12117: __all_virtual_tenant_plan_baseline # abandoned in 4.0
# 12118: __all_virtual_tenant_plan_baseline_history # abandoned in 4.0

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12119',
  table_name = '__all_virtual_sequence_object',
  keywords = all_def_keywords['__all_sequence_object']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12120',
  table_name = '__all_virtual_sequence_object_history',
  keywords = all_def_keywords['__all_sequence_object_history']))

def_table_schema(
    owner = 'yongle.xh',
    table_name    = '__all_virtual_raid_stat',
    table_id      = '12121',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ],
    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('disk_idx', 'int'),
      ('install_seq', 'int'),
      ('data_num', 'int'),
      ('parity_num', 'int'),
      ('create_ts', 'int'),
      ('finish_ts', 'int'),
      ('alias_name', 'varchar:MAX_PATH_SIZE'),
      ('status', 'varchar:OB_STATUS_LENGTH'),
      ('percent', 'int'),
    ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12122: __all_virtual_server_log_meta # abandoned in 4.0

# start for DTL
def_table_schema(
    owner = 'longzhong.wlz',
    table_name    = '__all_virtual_dtl_channel',
    table_id      = '12123',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
    ],
    normal_columns = [
      ('channel_id', 'int'),
      ('op_id', 'int'),
      ('peer_id', 'int'),
      ('tenant_id', 'int'),
      ('is_local', 'bool'),
      ('is_data', 'bool'),
      ('is_transmit', 'bool'),
      ('alloc_buffer_cnt', 'int'),
      ('free_buffer_cnt', 'int'),
      ('send_buffer_cnt', 'int'),
      ('recv_buffer_cnt', 'int'),
      ('processed_buffer_cnt', 'int'),
      ('send_buffer_size', 'int'),
      ('hash_val', 'int'),
      ('buffer_pool_id', 'int'),
      ('pins', 'int'),
      ('first_in_ts', 'timestamp'),
      ('first_out_ts', 'timestamp'),
      ('last_in_ts', 'timestamp'),
      ('last_out_ts', 'timestamp'),
      ('status', 'int'),
      ('thread_id', 'int'),
      ('owner_mod', 'int'),
      ('peer_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('peer_port', 'int'),
      ('eof', 'bool'),
    ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'longzhong.wlz',
    table_name    = '__all_virtual_dtl_memory',
    table_id      = '12124',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
    ],
    normal_columns = [
      ('tenant_id', 'int'),
      ('channel_total_cnt', 'int'),
      ('channel_block_cnt', 'int'),
      ('max_parallel_cnt', 'int'),
      ('max_blocked_buffer_size', 'int'),
      ('accumulated_blocked_cnt', 'int'),
      ('current_buffer_used', 'int'),
      ('seqno', 'int'),
      ('alloc_cnt', 'int'),
      ('free_cnt', 'int'),
      ('free_queue_len', 'int'),
      ('total_memory_size', 'int'),
      ('real_alloc_cnt', 'int'),
      ('real_free_cnt', 'int'),
    ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12125: abandoned

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12126',
  table_name = '__all_virtual_dblink',
  keywords = all_def_keywords['__all_dblink']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12127',
  table_name = '__all_virtual_dblink_history',
  keywords = all_def_keywords['__all_dblink_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12129',
  table_name = '__all_virtual_tenant_role_grantee_map',
  keywords = all_def_keywords['__all_tenant_role_grantee_map']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12130',
  table_name = '__all_virtual_tenant_role_grantee_map_history',
  keywords = all_def_keywords['__all_tenant_role_grantee_map_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12131',
  table_name = '__all_virtual_tenant_keystore',
  keywords = all_def_keywords['__all_tenant_keystore']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12132',
  table_name = '__all_virtual_tenant_keystore_history',
  keywords = all_def_keywords['__all_tenant_keystore_history']))

# label security
def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12133',
  table_name = '__all_virtual_tenant_ols_policy',
  keywords = all_def_keywords['__all_tenant_ols_policy']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12134',
  table_name = '__all_virtual_tenant_ols_policy_history',
  keywords = all_def_keywords['__all_tenant_ols_policy_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12135',
  table_name = '__all_virtual_tenant_ols_component',
  keywords = all_def_keywords['__all_tenant_ols_component']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12136',
  table_name = '__all_virtual_tenant_ols_component_history',
  keywords = all_def_keywords['__all_tenant_ols_component_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12137',
  table_name = '__all_virtual_tenant_ols_label',
  keywords = all_def_keywords['__all_tenant_ols_label']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12138',
  table_name = '__all_virtual_tenant_ols_label_history',
  keywords = all_def_keywords['__all_tenant_ols_label_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12139',
  table_name = '__all_virtual_tenant_ols_user_level',
  keywords = all_def_keywords['__all_tenant_ols_user_level']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12140',
  table_name = '__all_virtual_tenant_ols_user_level_history',
  keywords = all_def_keywords['__all_tenant_ols_user_level_history']))

# end label security

# 12141: __all_virtual_deadlock_stat # abandoned in 4.0

# tablespace begin
def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12142',
  table_name = '__all_virtual_tenant_tablespace',
  keywords = all_def_keywords['__all_tenant_tablespace'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12143',
  table_name = '__all_virtual_tenant_tablespace_history',
  keywords = all_def_keywords['__all_tenant_tablespace_history']))

#tablespace end

def_table_schema(
  owner = 'bin.lb',
  table_name     = '__ALL_VIRTUAL_INFORMATION_COLUMNS',
  table_id       = '12144',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
  ('TABLE_SCHEMA', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
  ('TABLE_NAME', 'varchar:OB_MAX_TABLE_NAME_LENGTH'),
  ],

  normal_columns = [
  ('TABLE_CATALOG', 'varchar:MAX_TABLE_CATALOG_LENGTH', 'false', ''),
  ('COLUMN_NAME', 'varchar:OB_MAX_COLUMN_NAME_LENGTH', 'false', ''),
  ('ORDINAL_POSITION', 'uint', 'false', '0'),
  ('COLUMN_DEFAULT', 'longtext', 'true'),
  ('IS_NULLABLE', 'varchar:COLUMN_NULLABLE_LENGTH',  'false', ''),
  ('DATA_TYPE', 'longtext',  'false', ''),
  ('CHARACTER_MAXIMUM_LENGTH', 'uint', 'true'),
  ('CHARACTER_OCTET_LENGTH', 'uint', 'true'),
  ('NUMERIC_PRECISION', 'uint', 'true'),
  ('NUMERIC_SCALE','uint', 'true'),
  ('DATETIME_PRECISION', 'uint', 'true'),
  ('CHARACTER_SET_NAME', 'varchar:MAX_CHARSET_LENGTH', 'true'),
  ('COLLATION_NAME', 'varchar:MAX_COLLATION_LENGTH', 'true'),
  ('COLUMN_TYPE', 'longtext'),
  ('COLUMN_KEY', 'varchar:MAX_COLUMN_KEY_LENGTH', 'false', ''),
  ('EXTRA', 'varchar:COLUMN_EXTRA_LENGTH', 'false', ''),
  ('PRIVILEGES', 'varchar:MAX_COLUMN_PRIVILEGE_LENGTH', 'false', ''),
  ('COLUMN_COMMENT', 'longtext', 'false', ''),
  ('GENERATION_EXPRESSION', 'longtext', 'false', ''),
  ('SRS_ID', 'uint32', 'true')
  ],
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12146',
  table_name = '__all_virtual_tenant_user_failed_login_stat',
  keywords = all_def_keywords['__all_tenant_user_failed_login_stat'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12147',
  table_name = '__all_virtual_tenant_profile',
  keywords = all_def_keywords['__all_tenant_profile']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12148',
  table_name = '__all_virtual_tenant_profile_history',
  keywords = all_def_keywords['__all_tenant_profile_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12149',
  table_name = '__all_virtual_security_audit',
  keywords = all_def_keywords['__all_tenant_security_audit']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12150',
  table_name = '__all_virtual_security_audit_history',
  keywords = all_def_keywords['__all_tenant_security_audit_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12151',
  table_name = '__all_virtual_trigger',
  keywords = all_def_keywords['__all_tenant_trigger']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12152',
  table_name = '__all_virtual_trigger_history',
  keywords = all_def_keywords['__all_tenant_trigger_history']))

# 12153: __all_virtual_cluster_stats # abandoned in 4.0

# 12154: __all_tenant_sstable_column_checksum # abandoned in 4.0

def_table_schema(
  owner = 'xiaoyi.xy',
  table_name     = '__all_virtual_ps_stat',
  table_id       = '12155',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [],
  enable_column_def_enum = True,

  normal_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('stmt_count', 'int'),
    ('hit_count', 'int'),
    ('access_count', 'int'),
    ('mem_hold', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'xiaoyi.xy',
  table_name     = '__all_virtual_ps_item_info',
  table_id       = '12156',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  enable_column_def_enum = True,
  in_tenant_space = True,

  normal_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('stmt_id', 'int'),
    ('db_id', 'int'),
    ('ps_sql', 'longtext'),
    ('param_count', 'int'),
    ('stmt_item_ref_count', 'int'),
    ('stmt_info_ref_count', 'int'),
    ('mem_hold', 'int'),
    ('stmt_type', 'int'),
    ('checksum', 'int'),
    ('expired', 'bool')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12157: __all_virtual_standby_status # abandoned in 4.0

def_table_schema(
  owner = 'longzhong.wlz',
  table_name     = '__all_virtual_sql_workarea_history_stat',
  table_id       = '12158',
  table_type     = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns     = [],
  rowkey_columns = [],
  normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('plan_id', 'int'),
      ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
      ('operation_type', 'varchar:40'),
      ('operation_id', 'int'),
      ('estimated_optimal_size', 'int'),
      ('estimated_onepass_size', 'int'),
      ('last_memory_used', 'int'),
      ('last_execution', 'varchar:10'),
      ('last_degree', 'int'),
      ('total_executions', 'int'),
      ('optimal_executions', 'int'),
      ('onepass_executions', 'int'),
      ('multipasses_executions', 'int'),
      ('active_time', 'int'),
      ('max_tempseg_size', 'int'),
      ('last_tempseg_size', 'int'),
      ('tenant_id', 'int'),
      ('policy', 'varchar:10'),
      ('db_id', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'longzhong.wlz',
  table_name     = '__all_virtual_sql_workarea_active',
  table_id       = '12159',
  table_type     = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns     = [],
  rowkey_columns = [],
  normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('plan_id', 'int'),
      ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
      ('sql_exec_id', 'int'),
      ('operation_type', 'varchar:40'),
      ('operation_id', 'int'),
      ('sid', 'int'),
      ('active_time', 'int'),
      ('work_area_size', 'int'),
      ('expect_size', 'int'),
      ('actual_mem_used', 'int'),
      ('max_mem_used', 'int'),
      ('number_passes', 'int'),
      ('tempseg_size', 'int'),
      ('tenant_id', 'int'),
      ('policy', 'varchar:6'),
      ('db_id', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'longzhong.wlz',
  table_name     = '__all_virtual_sql_workarea_histogram',
  table_id       = '12160',
  table_type     = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns     = [],
  rowkey_columns = [],
  normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('low_optimal_size', 'int'),
      ('high_optimal_size', 'int'),
      ('optimal_executions', 'int'),
      ('onepass_executions', 'int'),
      ('multipasses_executions', 'int'),
      ('total_executions', 'int'),
      ('tenant_id', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'longzhong.wlz',
  table_name     = '__all_virtual_sql_workarea_memory_info',
  in_tenant_space = True,
  table_id       = '12161',
  table_type     = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [],
  normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('max_workarea_size', 'int'),
      ('workarea_hold_size', 'int'),
      ('max_auto_workarea_size', 'int'),
      ('mem_target', 'int'),
      ('total_mem_used', 'int'),
      ('global_mem_bound', 'int'),
      ('drift_size', 'int'),
      ('workarea_count', 'int'),
      ('manual_calc_count', 'int'),
      ('tenant_id', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12162',
  table_name = '__all_virtual_security_audit_record',
  keywords = all_def_keywords['__all_tenant_security_audit_record']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12163',
  table_name = '__all_virtual_sysauth',
  keywords = all_def_keywords['__all_tenant_sysauth']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12164',
  table_name = '__all_virtual_sysauth_history',
  keywords = all_def_keywords['__all_tenant_sysauth_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12165',
  table_name = '__all_virtual_objauth',
  keywords = all_def_keywords['__all_tenant_objauth']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12166',
  table_name = '__all_virtual_objauth_history',
  keywords = all_def_keywords['__all_tenant_objauth_history']))
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12167',
  table_name = '__all_virtual_backup_info',
  keywords = all_def_keywords['__all_backup_info'],
  in_tenant_space = True))

# 12168: __all_virtual_backup_log_archive_status # abandoned in 4.0
# 12170: __all_virtual_backup_task # abandoned in 4.0
# 12171: __all_virtual_pg_backup_task # abandoned in 4.0

# 12173: __all_virtual_pg_backup_log_archive_status # abandoned in 4.0
# 12174: __all_virtual_server_backup_log_archive_status # abandoned in 4.0

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12175',
  table_name = '__all_virtual_error',
  keywords = all_def_keywords['__all_tenant_error']))

def_table_schema(
  owner = 'lixinze.lxz',
  table_name     = '__all_virtual_id_service',
  table_id       = '12176',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  normal_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('id_service_type', 'int'),
    ('last_id', 'int'),
    ('limit_id', 'int'),
    ('rec_log_scn', 'uint'),
    ('latest_log_scn', 'uint'),
    ('pre_allocated_range', 'int'),
    ('submit_log_ts', 'int'),
    ('is_master', 'bool'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12177: REFERENTIAL_CONSTRAINTS # abandoned in 4.0
# 12179: __all_virtual_table_modifications # abandoned in 4.0
# 12180: __all_virtual_backup_clean_info # abandoned in 4.0

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12182',
  table_name = '__all_virtual_object_type',
  keywords = all_def_keywords['__all_tenant_object_type']))

# 12184: __all_virtual_pg_log_archive_stat # abandoned in 4.0

def_table_schema(
  owner = 'xiaochu.yh',
  tablegroup_id = 'OB_INVALID_ID',
  table_name    = '__all_virtual_sql_plan_monitor',
  table_id      = '12185',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  index_using_type = 'USING_BTREE',
  gm_columns    = [],
  rowkey_columns = [
    ('SVR_IP', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('SVR_PORT', 'int'),
    ('TENANT_ID', 'int'),
    ('REQUEST_ID', 'int'),
  ],
  normal_columns = [
    ('TRACE_ID', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
    ('FIRST_REFRESH_TIME', 'timestamp', 'true'),
    ('LAST_REFRESH_TIME' ,'timestamp', 'true'),
    ('FIRST_CHANGE_TIME','timestamp', 'true'),
    ('LAST_CHANGE_TIME','timestamp', 'true'),
    ('OTHERSTAT_1_ID', 'int'),
    ('OTHERSTAT_1_VALUE', 'int'),
    ('OTHERSTAT_2_ID', 'int'),
    ('OTHERSTAT_2_VALUE', 'int'),
    ('OTHERSTAT_3_ID', 'int'),
    ('OTHERSTAT_3_VALUE', 'int'),
    ('OTHERSTAT_4_ID', 'int'),
    ('OTHERSTAT_4_VALUE', 'int'),
    ('OTHERSTAT_5_ID', 'int'),
    ('OTHERSTAT_5_VALUE', 'int'),
    ('OTHERSTAT_6_ID', 'int'),
    ('OTHERSTAT_6_VALUE', 'int'),
    ('OTHERSTAT_7_ID', 'int'),
    ('OTHERSTAT_7_VALUE', 'int'),
    ('OTHERSTAT_8_ID', 'int'),
    ('OTHERSTAT_8_VALUE', 'int'),
    ('OTHERSTAT_9_ID', 'int'),
    ('OTHERSTAT_9_VALUE', 'int'),
    ('OTHERSTAT_10_ID', 'int'),
    ('OTHERSTAT_10_VALUE', 'int'),
    ('THREAD_ID', 'int'),
    ('PLAN_OPERATION', 'varchar:OB_MAX_OPERATOR_NAME_LENGTH'),
    ('STARTS', 'int'),
    ('OUTPUT_ROWS', 'int'),
    ('PLAN_LINE_ID', 'int'),
    ('PLAN_DEPTH', 'int'),
    ('OUTPUT_BATCHES', 'int'),
    ('SKIPPED_ROWS_COUNT', 'int'),
    ('DB_TIME', 'int'),
    ('USER_IO_WAIT_TIME', 'int'),
    ('WORKAREA_MEM', 'int'),
    ('WORKAREA_MAX_MEM', 'int'),
    ('WORKAREA_TEMPSEG', 'int'),
    ('WORKAREA_MAX_TEMPSEG', 'int'),
    ('SQL_ID', 'varchar:OB_MAX_SQL_ID_LENGTH'),
    ('PLAN_HASH_VALUE', 'uint'),
  ],
  partition_columns = ['SVR_IP', 'SVR_PORT'],
  vtable_route_policy = 'distributed',
  index = {'all_virtual_sql_plan_monitor_i1' :  { 'index_columns' : ['TENANT_ID', 'REQUEST_ID'],
                     'index_using_type' : 'USING_BTREE'}},
)


def_table_schema(
  owner = 'xiaochu.yh',
  table_name    = '__all_virtual_sql_monitor_statname',
  table_id      = '12186',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [
  ],
  normal_columns = [
    ('ID', 'int'),
    ('GROUP_ID', 'int'),
    ('NAME', 'varchar:40'),
    ('DESCRIPTION', 'varchar:200'),
    ('TYPE', 'int')
  ]
)

def_table_schema(
  owner = 'adou.ly',
  table_name    = '__all_virtual_open_cursor',
  table_id      = '12187',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [
  ],
  normal_columns = [
    ('TENANT_ID', 'int'),
    ('SVR_IP', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('SVR_PORT', 'int'),
    ('SADDR', 'varchar:8'),
    ('SID', 'int'),
    ('USER_NAME', 'varchar:30'),
    ('ADDRESS', 'varchar:8'),
    ('HASH_VALUE', 'int'),
    ('SQL_ID', 'varchar:OB_MAX_SQL_ID_LENGTH'),
    ('SQL_TEXT', 'varchar:60'),
    ('LAST_SQL_ACTIVE_TIME', 'timestamp'),
    ('SQL_EXEC_ID', 'int'),
    ('CURSOR_TYPE', 'varchar:30'),
    ('CHILD_ADDRESS', 'varchar:30'),
    ('CON_ID', 'int'),
  ],
  partition_columns = ['SVR_IP', 'SVR_PORT'],
  vtable_route_policy = 'distributed',
)

# 12188: __all_virtual_backup_validation_task # abandoned in 4.0
# 12189: __all_virtual_pg_backup_validation_task # abandoned in 4.0

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12190',
  table_name = '__all_virtual_time_zone',
  keywords = all_def_keywords['__all_tenant_time_zone']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12191',
  table_name = '__all_virtual_time_zone_name',
  keywords = all_def_keywords['__all_tenant_time_zone_name']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12192',
  table_name = '__all_virtual_time_zone_transition',
  keywords = all_def_keywords['__all_tenant_time_zone_transition']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12193',
  table_name = '__all_virtual_time_zone_transition_type',
  keywords = all_def_keywords['__all_tenant_time_zone_transition_type']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12194',
  table_name = '__all_virtual_constraint_column',
  keywords = all_def_keywords['__all_tenant_constraint_column']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12195',
  table_name = '__all_virtual_constraint_column_history',
  keywords = all_def_keywords['__all_tenant_constraint_column_history']))


def_table_schema(
  owner = 'xiaochu.yh',
  table_name     = '__all_virtual_files',
  table_id       = '12196',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,
  normal_columns = [
    ('FILE_ID','bigint:4','false','0'),
    ('FILE_NAME','varchar:64','true','NULL'),
    ('FILE_TYPE','varchar:20','false',''),
    ('TABLESPACE_NAME','varchar:64','true','NULL'),
    ('TABLE_CATALOG','varchar:64','false',''),
    ('TABLE_SCHEMA','varchar:64','true','NULL'),
    ('TABLE_NAME','varchar:64','true','NULL'),
    ('LOGFILE_GROUP_NAME','varchar:64','true','NULL'),
    ('LOGFILE_GROUP_NUMBER','bigint:4','true','NULL'),
    ('ENGINE','varchar:64','false',''),
    ('FULLTEXT_KEYS','varchar:64','true','NULL'),
    ('DELETED_ROWS','bigint:4','true','NULL'),
    ('UPDATE_COUNT','bigint:4','true','NULL'),
    ('FREE_EXTENTS','bigint:4','true','NULL'),
    ('TOTAL_EXTENTS','bigint:4','true','NULL'),
    ('EXTENT_SIZE','bigint:4','false','0'),
    ('INITIAL_SIZE','uint','true','NULL'),
    ('MAXIMUM_SIZE','uint','true','NULL'),
    ('AUTOEXTEND_SIZE','uint','true','NULL'),
    ('CREATION_TIME','timestamp','true','NULL'),
    ('LAST_UPDATE_TIME','timestamp','true','NULL'),
    ('LAST_ACCESS_TIME','timestamp','true','NULL'),
    ('RECOVER_TIME','bigint:4','true','NULL'),
    ('TRANSACTION_COUNTER','bigint:4','true','NULL'),
    ('VERSION','uint','true','NULL'),
    ('ROW_FORMAT','varchar:10','true','NULL'),
    ('TABLE_ROWS','uint','true','NULL'),
    ('AVG_ROW_LENGTH','uint','true','NULL'),
    ('DATA_LENGTH','uint','true','NULL'),
    ('MAX_DATA_LENGTH','uint','true','NULL'),
    ('INDEX_LENGTH','uint','true','NULL'),
    ('DATA_FREE','uint','true','NULL'),
    ('CREATE_TIME','timestamp','true','NULL'),
    ('UPDATE_TIME','timestamp','true','NULL'),
    ('CHECK_TIME','timestamp','true','NULL'),
    ('CHECKSUM','uint','true','NULL'),
    ('STATUS','varchar:20','false',''),
    ('EXTRA','varchar:255','true','NULL')
  ],
)

# 12197: abandoned # INFORMATION_SCHEMA.FILES, which is moved to 21157

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12198',
  table_name = '__all_virtual_dependency',
  keywords = all_def_keywords['__all_tenant_dependency']))

def_table_schema(
  owner = 'dachuan.sdc',
  table_name     = '__tenant_virtual_object_definition',
  table_id       = '12199',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('object_type', 'int'),
  ('object_name', 'varchar:OB_MAX_ORIGINAL_NANE_LENGTH'),
  ('schema', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
  ('version', 'varchar:10'),
  ('model', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
  ('transform', 'varchar:8'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('definition', 'longtext'),
  ('create_database_with_if_not_exists', 'varchar:DATABASE_DEFINE_LENGTH'),
  ('character_set_client', 'varchar:MAX_CHARSET_LENGTH'),
  ('collation_connection', 'varchar:MAX_CHARSET_LENGTH'),
  ('proc_type', 'int'),
  ('collation_database', 'varchar:MAX_CHARSET_LENGTH'),
  ('sql_mode', 'varchar:MAX_CHARSET_LENGTH'),
  ],
)

# 12200: __all_virtual_reserved_table_mgr # abandoned in 4.0
# 12201: __all_virtual_backupset_history_mgr # abandoned in 4.0
# 12202: __all_virtual_backup_backupset_task # abandoned in 4.0
# 12203: __all_virtual_pg_backup_backupset_task # abandoned in 4.0

# 12205: __all_virtual_cluster_failover_info # abandoned in 4.0

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12206',
  table_name = '__all_virtual_global_transaction',
  keywords = all_def_keywords['__all_tenant_global_transaction'],
  in_tenant_space = True))

# 12207: __all_virtual_all_clusters # abandoned in 4.0

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12208',
  table_name = '__all_virtual_ddl_task_status',
  keywords = all_def_keywords['__all_ddl_task_status']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12209',
  table_name = '__all_virtual_deadlock_event_history',
  keywords = all_def_keywords['__all_deadlock_event_history'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12210',
  table_name = '__all_virtual_column_usage',
  keywords = all_def_keywords['__all_column_usage']))


def_table_schema(
  owner = 'fengshuo.fs',
  table_name     = '__all_virtual_tenant_ctx_memory_info',
  table_id       = '12211',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ('tenant_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('ctx_id', 'int'),
  ],

  normal_columns = [
  ('ctx_name', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('hold', 'int'),
  ('used', 'int'),
  ('limit', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12212: __all_virtual_clog_agency_info # abandoned in 4.0

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12213',
  table_name = '__all_virtual_job',
  keywords = all_def_keywords['__all_job']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12214',
  table_name = '__all_virtual_job_log',
  keywords = all_def_keywords['__all_job_log']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12215',
  table_name = '__all_virtual_tenant_directory',
  keywords = all_def_keywords['__all_tenant_directory']))
def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12216',
  table_name = '__all_virtual_tenant_directory_history',
  keywords = all_def_keywords['__all_tenant_directory_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12217',
  table_name = '__all_virtual_table_stat',
  keywords = all_def_keywords['__all_table_stat']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12218',
  table_name = '__all_virtual_column_stat',
  keywords = all_def_keywords['__all_column_stat']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12219',
  table_name = '__all_virtual_histogram_stat',
  keywords = all_def_keywords['__all_histogram_stat']))

def_table_schema(
  owner = 'fengshuo.fs',
  table_name     = '__all_virtual_tenant_memory_info',
  table_id       = '12220',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  in_tenant_space = True,
  rowkey_columns = [
  ('tenant_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ],

  normal_columns = [
  ('hold', 'int'),
  ('limit', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12221: TRIGGERS # abandoned in 4.0

def_table_schema(
  owner = 'webber.wb',
  table_name     = '__tenant_virtual_show_create_trigger',
  table_id       = '12222',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('trigger_id', 'int'),
  ],
  in_tenant_space = True,

  normal_columns = [
  ('trigger_name', 'varchar:OB_MAX_ROUTINE_NAME_LENGTH'),
  ('sql_mode', 'varchar:MAX_CHARSET_LENGTH'),
  ('create_trigger', 'longtext'),
  ('character_set_client', 'varchar:MAX_CHARSET_LENGTH'),
  ('collation_connection', 'varchar:MAX_CHARSET_LENGTH'),
  ('collation_database', 'varchar:MAX_CHARSET_LENGTH'),

  ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name = '__all_virtual_px_target_monitor',
  table_id = '12223',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],

  in_tenant_space = True,

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('is_leader', 'bool'),
  ('version','uint'),
  ('peer_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('peer_port', 'int'),
  ('peer_target', 'int'),
  ('peer_target_used', 'int'),
  ('local_target_used', 'int'),
  ('local_parallel_session_count', 'int'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12224',
  table_name = '__all_virtual_monitor_modified',
  keywords = all_def_keywords['__all_monitor_modified']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12225',
  table_name = '__all_virtual_table_stat_history',
  keywords = all_def_keywords['__all_table_stat_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12226',
  table_name = '__all_virtual_column_stat_history',
  keywords = all_def_keywords['__all_column_stat_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12227',
  table_name = '__all_virtual_histogram_stat_history',
  keywords = all_def_keywords['__all_histogram_stat_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12228',
  table_name = '__all_virtual_optstat_global_prefs',
  keywords = all_def_keywords['__all_optstat_global_prefs']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12229',
  table_name = '__all_virtual_optstat_user_prefs',
  keywords = all_def_keywords['__all_optstat_user_prefs']))

def_table_schema(
  owner = 'longzhong.wlz',
  table_name     = '__all_virtual_dblink_info',
  table_id       = '12230',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
  ],
  normal_columns = [
    ('link_id', 'int', 'false', 0),
    ('logged_on', 'int', 'false', 1), # Whether the database link is currently logged on
    ('heterogeneous', 'int', 'false', 1), # Communication protocol for the database link
    ('protocol', 'int', 'false', 1), # Communication protocol for the database link, 0:ob, 1:oci
    ('open_cursors', 'int', 'false', 0), # Whether there are open cursors for the database link
    ('in_transaction', 'int', 'false', 0), # Whether the database link is currently in a transaction
    ('update_sent', 'int', 'false', 0), # Whether there has been an update on the database link
    ('commit_point_strength', 'int', 'false', 0), # Commit point strength of the transactions on the database link
    ('link_tenant_id', 'int', 'false', 0), # this dblink belongs to which tenant
    ('oci_conn_opened', 'int', 'false', 0),
    ('oci_conn_closed', 'int', 'false', 0),
    ('oci_stmt_queried', 'int', 'false', 0),
    ('oci_env_charset', 'int', 'false', 0),
    ('oci_env_ncharset', 'int', 'false', 0),
    ('extra_info', 'varchar:OB_MAX_ORACLE_VARCHAR_LENGTH', 'true', 'NULL')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12231',
  table_name = '__all_virtual_log_archive_progress',
  keywords = all_def_keywords['__all_log_archive_progress'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12232',
  table_name = '__all_virtual_log_archive_history',
  keywords = all_def_keywords['__all_log_archive_history'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12233',
  table_name = '__all_virtual_log_archive_piece_files',
  keywords = all_def_keywords['__all_log_archive_piece_files'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12234',
  table_name = '__all_virtual_ls_log_archive_progress',
  keywords = all_def_keywords['__all_ls_log_archive_progress'],
  in_tenant_space = True))

# 12235: CHECK_CONSTRAINTS # abandoned in 4.0

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12236',
  table_name = '__all_virtual_backup_storage_info',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_backup_storage_info']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12237',
  table_name = '__all_virtual_ls_status',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_ls_status']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12238',
  table_name = '__all_virtual_ls',
  keywords = all_def_keywords['__all_ls']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12239',
  table_name = '__all_virtual_ls_meta_table',
  keywords = all_def_keywords['__all_ls_meta_table'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12240',
  table_name = '__all_virtual_tablet_meta_table',
  keywords = all_def_keywords['__all_tablet_meta_table'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12241',
  table_name = '__all_virtual_tablet_to_ls',
  keywords = all_def_keywords['__all_tablet_to_ls']))

def_table_schema(
  owner = 'yuya.yu',
  table_name = '__all_virtual_load_data_stat',
  table_id = '12242',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],

  normal_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('job_id', 'int'),
    ('job_type', 'varchar:OB_MAX_PARAMETERS_NAME_LENGTH'),
    ('table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH'),
    ('file_path', 'varchar:MAX_PATH_SIZE'),
    ('table_column', 'int'),
    ('file_column', 'int'),
    ('batch_size', 'int'),
    ('parallel', 'int'),
    ('load_mode', 'int'),
    ('load_time', 'int'),
    ('estimated_remaining_time', 'int'),
    ('total_bytes', 'int'),
    ('read_bytes', 'int'),
    ('parsed_bytes', 'int'),
    ('parsed_rows', 'int'),
    ('total_shuffle_task', 'int'),
    ('total_insert_task', 'int'),
    ('shuffle_rt_sum', 'int'),
    ('insert_rt_sum', 'int'),
    ('total_wait_secs', 'int'),
    ('max_allowed_error_rows', 'int'),
    ('detected_error_rows', 'int'),
    ('coordinator_received_rows', 'int'),
    ('coordinator_last_commit_segment_id', 'int'),
    ('coordinator_status', 'varchar:OB_MAX_PARAMETERS_NAME_LENGTH'),
    ('coordinator_trans_status', 'varchar:OB_MAX_PARAMETERS_NAME_LENGTH'),
    ('store_processed_rows', 'int'),
    ('store_last_commit_segment_id', 'int'),
    ('store_status', 'varchar:OB_MAX_PARAMETERS_NAME_LENGTH'),
    ('store_trans_status', 'varchar:OB_MAX_PARAMETERS_NAME_LENGTH'),
    ('message', 'varchar:MAX_LOAD_DATA_MESSAGE_LENGTH')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12243',
  table_name = '__all_virtual_dam_last_arch_ts',
  keywords = all_def_keywords['__all_dam_last_arch_ts']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12244',
  table_name = '__all_virtual_dam_cleanup_jobs',
  keywords = all_def_keywords['__all_dam_cleanup_jobs']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12245',
  table_name = '__all_virtual_backup_task',
  keywords = all_def_keywords['__all_backup_task'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12246',
  table_name = '__all_virtual_backup_task_history',
  keywords = all_def_keywords['__all_backup_task_history'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12247',
  table_name = '__all_virtual_backup_ls_task',
  keywords = all_def_keywords['__all_backup_ls_task']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12248',
  table_name = '__all_virtual_backup_ls_task_history',
  keywords = all_def_keywords['__all_backup_ls_task_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12249',
  table_name = '__all_virtual_backup_ls_task_info',
  keywords = all_def_keywords['__all_backup_ls_task_info']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12250',
  table_name = '__all_virtual_backup_skipped_tablet',
  keywords = all_def_keywords['__all_backup_skipped_tablet']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12251',
  table_name = '__all_virtual_backup_skipped_tablet_history',
  keywords = all_def_keywords['__all_backup_skipped_tablet_history']))

def_table_schema(
  owner = 'chongrong.th',
  table_name = '__all_virtual_backup_schedule_task',
  table_id = '12252',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],

  normal_columns = [
  ('tenant_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('job_id', 'int'),
  ('task_id', 'int'),
  ('ls_id', 'int'),
  ('type', 'int'),
  ('trace_id', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
  ('destination', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
  ('is_schedule', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH'),
  ('generate_ts', 'int'),
  ('schedule_ts', 'int'),
  ('executor_ts', 'int'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12253',
  table_name = '__all_virtual_tablet_to_table_history',
  keywords = all_def_keywords['__all_tablet_to_table_history']))

def_table_schema(
  owner = 'zjf225077',
  table_name = '__all_virtual_log_stat',
  table_id = '12254',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],

  normal_columns = [
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('role', 'varchar:32'),
  ('proposal_id', 'int'),
  ('config_version', 'varchar:128'),
  ('access_mode', 'varchar:32'),
  ('paxos_member_list', 'varchar:1024'),
  ('paxos_replica_num', 'int'),
  ('in_sync', 'bool'),
  ('base_lsn', 'uint'),
  ('begin_lsn', 'uint'),
  ('begin_scn', 'uint'),
  ('end_lsn', 'uint'),
  ('end_scn', 'uint'),
  ('max_lsn', 'uint'),
  ('max_scn', 'uint'),
  ('arbitration_member', 'varchar:128'),
  ('degraded_list', 'varchar:1024'),
  ('learner_list', 'longtext')
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12255',
  table_name = '__all_virtual_tenant_info',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_tenant_info']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12256',
  table_name = '__all_virtual_ls_recovery_stat',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_ls_recovery_stat']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12257',
  table_name = '__all_virtual_backup_ls_task_info_history',
  keywords = all_def_keywords['__all_backup_ls_task_info_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12258',
  table_name = '__all_virtual_tablet_replica_checksum',
  keywords = all_def_keywords['__all_tablet_replica_checksum']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12259',
  table_name = '__all_virtual_ddl_checksum',
  keywords = all_def_keywords['__all_ddl_checksum']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12260',
  table_name = '__all_virtual_ddl_error_message',
  keywords = all_def_keywords['__all_ddl_error_message']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12261',
  table_name = '__all_virtual_ls_replica_task',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_ls_replica_task']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12262',
  table_name = '__all_virtual_pending_transaction',
  keywords = all_def_keywords['__all_pending_transaction']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12263',
  table_name = '__all_virtual_tenant_scheduler_job',
  keywords = all_def_keywords['__all_tenant_scheduler_job']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12264',
  table_name = '__all_virtual_tenant_scheduler_job_run_detail',
  keywords = all_def_keywords['__all_tenant_scheduler_job_run_detail']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12265',
  table_name = '__all_virtual_tenant_scheduler_program',
  keywords = all_def_keywords['__all_tenant_scheduler_program']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12266',
  table_name = '__all_virtual_tenant_scheduler_program_argument',
  keywords = all_def_keywords['__all_tenant_scheduler_program_argument']))

# 12267: __all_virtual_backup_validation_task_v2
# 12268: __all_virtual_pg_backup_validation_task_v2

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12269',
  table_name = '__all_virtual_tenant_context',
  keywords = all_def_keywords['__all_context']))
def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12270',
  table_name = '__all_virtual_tenant_context_history',
  keywords = all_def_keywords['__all_context_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12271',
  table_name = '__all_virtual_global_context_value',
  keywords = all_def_keywords['__all_global_context_value']))

# 12272: __all_virtual_external_storage_session
# 12273: __all_virtual_external_storage_info

def_table_schema(
    owner = 'fenggu.yh',
    table_name    = '__all_virtual_unit',
    table_id      = '12274',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ],
    in_tenant_space=True,
    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('unit_id', 'int'),
      ('tenant_id', 'int'),
      ('zone', 'varchar:MAX_ZONE_LENGTH'),
      ('min_cpu', 'double'),
      ('max_cpu', 'double'),
      ('memory_size', 'int'),
      ('min_iops', 'int'),
      ('max_iops', 'int'),
      ('iops_weight', 'int'),
      ('log_disk_size', 'int'),
      ('log_disk_in_use', 'int'),
      ('data_disk_in_use', 'int'),
      ('status', 'varchar:64'),
      ('create_time', 'int'),
      ('zone_type', 'varchar:MAX_ZONE_TYPE_LENGTH'),
      ('region', 'varchar:MAX_REGION_LENGTH'),
      ('data_disk_size', 'int', 'true'),
      ('max_net_bandwidth', 'int', 'true'),
      ('net_bandwidth_weight', 'int', 'true'),
    ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12275: __all_virtual_tablet_transfer_info

def_table_schema(
    owner = 'wanhong.wwh',
    table_name    = '__all_virtual_server',
    table_id      = '12276',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ],
    in_tenant_space=False,
    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('zone', 'varchar:MAX_ZONE_LENGTH'),
      ('sql_port', 'int'),
      ('cpu_capacity', 'int'),
      ('cpu_capacity_max', 'double'),
      ('cpu_assigned', 'double'),
      ('cpu_assigned_max', 'double'),
      ('mem_capacity', 'int'),
      ('mem_assigned', 'int'),
      ('data_disk_capacity', 'int'),
      ('data_disk_in_use', 'int'),
      ('data_disk_health_status', 'varchar:OB_MAX_DEVICE_HEALTH_STATUS_STR_LENGTH'),
      ('data_disk_abnormal_time', 'int'),
      ('log_disk_capacity', 'int'),
      ('log_disk_assigned', 'int'),
      ('log_disk_in_use', 'int'),
      ('ssl_cert_expired_time', 'int'),
      ('memory_limit', 'int'),
      ('data_disk_allocated', 'int'),
      ('data_disk_assigned', 'int', 'true'),
      ('data_disk_suggested_operation', 'varchar:MAX_OPERATOR_NAME_LENGTH', 'true'),
      ('data_disk_suggested_size', 'int', 'true'),
    ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12277',
  table_name = '__all_virtual_ls_election_reference_info',
  in_tenant_space=True,
  keywords = all_def_keywords['__all_ls_election_reference_info']))

def_table_schema(
  owner = 'dachuan.sdc',
  tablegroup_id = 'OB_INVALID_ID',
  table_name    = '__all_virtual_dtl_interm_result_monitor',
  table_id      = '12278',
  table_type = 'VIRTUAL_TABLE',
  gm_columns    = [],
  in_tenant_space = True,
  rowkey_columns = [],

  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
    ('owner', 'varchar:OB_MODULE_NAME_LENGTH'),
    ('start_time' ,'timestamp'),
    ('expire_time','timestamp'),
    ('hold_memory', 'int'),
    ('dump_size', 'int'),
    ('dump_cost', 'int'),
    ('dump_time', 'timestamp', 'true'),
    ('dump_fd', 'int'),
    ('dump_dir_id', 'int'),
    ('channel_id', 'int'),
    ('qc_id', 'int'),
    ('dfo_id', 'int'),
    ('sqc_id', 'int'),
    ('batch_id', 'int'),
    ('max_hold_memory', 'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'shuning.tsn',
  table_name     = '__all_virtual_archive_stat',
  table_id       = '12279',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],
  normal_columns = [
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('dest_id', 'int'),
  ('incarnation', 'int'),
  ('round_id', 'int'),
  ('dest_type', 'varchar:128'),
  ('dest_value', 'varchar:2048'),
  ('lease_id', 'int'),
  ('round_start_scn', 'uint'),
  ('max_issued_log_lsn', 'uint'),
  ('issued_task_count', 'int'),
  ('issued_task_size', 'int'),
  ('max_prepared_piece_id', 'int'),
  ('max_prepared_lsn', 'uint'),
  ('max_prepared_scn', 'uint'),
  ('wait_send_task_count', 'int'),
  ('archive_piece_id', 'int'),
  ('archive_lsn', 'uint'),
  ('archive_scn', 'uint'),
  ('archive_file_id', 'int'),
  ('archive_file_offset', 'int'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'keqing.llt',
  table_name = '__all_virtual_apply_stat',
  table_id = '12280',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],

  normal_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('role', 'varchar:32'),
    ('end_lsn', 'uint'),
    ('proposal_id', 'int'),
    ('pending_cnt', 'int'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'keqing.llt',
  table_name = '__all_virtual_replay_stat',
  table_id = '12281',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],

  normal_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('role', 'varchar:32'),
    ('end_lsn', 'uint'),
    ('enabled', 'bool'),
    ('unsubmitted_lsn', 'uint'),
    ('unsubmitted_log_scn', 'uint'),
    ('pending_cnt', 'int'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'wangzhennan.wzn',
  table_name     = '__all_virtual_proxy_routine',
  table_id       = '12282',
  table_type     = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
    ('tenant_name', 'varchar:OB_MAX_TENANT_NAME_LENGTH_STORE'),
    ('database_name', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
    ('package_name', 'varchar:OB_MAX_PACKAGE_NAME_LENGTH'),
    ('routine_name', 'varchar:OB_MAX_ROUTINE_NAME_LENGTH'),
  ],
  normal_columns = [
    ('routine_id', 'int'),
    ('routine_type', 'int'),
    ('schema_version', 'int'),
    ('routine_sql', 'longtext'),
    ('spare1', 'int'),
    ('spare2', 'int'),
    ('spare3', 'int'),
    ('spare4', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('spare5', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
    ('spare6', 'varchar:OB_MAX_PARTITION_EXPR_LENGTH'),
  ]
)

# backup clean virtual table
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12283',
  table_name = '__all_virtual_backup_delete_task',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_backup_delete_task']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12284',
  table_name = '__all_virtual_backup_delete_task_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_backup_delete_task_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12285',
  table_name = '__all_virtual_backup_delete_ls_task',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_backup_delete_ls_task']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12286',
  table_name = '__all_virtual_backup_delete_ls_task_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_backup_delete_ls_task_history']))

def_table_schema(
  owner = 'yanyuan.cxf',
  table_name     = '__all_virtual_ls_info',
  table_id       = '12287',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  in_tenant_space = True,
  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('replica_type', 'varchar:MAX_REPLICA_TYPE_LENGTH'),
  ('ls_state', 'varchar:MAX_LS_STATE_LENGTH'),
  ('tablet_count', 'int'),
  ('weak_read_scn', 'uint'),
  ('need_rebuild', 'varchar:MAX_COLUMN_YES_NO_LENGTH'),
  ('checkpoint_scn', 'uint'),
  ('checkpoint_lsn', 'uint'),
  ('migrate_status', 'int'),
  ('rebuild_seq', 'int'),
  ('tablet_change_checkpoint_scn', 'uint'),
  ('transfer_scn', 'uint'),
  ('tx_blocked', 'int'),
  ('required_data_disk_size', 'int', 'false', 0),
  ('mv_major_merge_scn', 'uint', 'false', 0),
  ('mv_publish_scn', 'uint', 'false', 0),
  ('mv_safe_scn', 'uint', 'false', 0),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'yanyuan.cxf',
  table_name     = '__all_virtual_tablet_info',
  table_id       = '12288',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('tablet_id', 'int'),
  ('data_tablet_id', 'int'),
  ('ref_tablet_id', 'int'),
  ('checkpoint_scn', 'uint'),
  ('compaction_scn', 'uint'),
  ('multi_version_start', 'uint'),
  ('transfer_start_scn', 'uint'),
  ('transfer_seq', 'int'),
  ('has_transfer_table', 'int'),
  ('restore_status', 'int'),
  ('tablet_status', 'int'),
  ('is_committed', 'int'),
  ('is_empty_shell', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'yanyuan.cxf',
  table_name     = '__all_virtual_obj_lock',
  table_id       = '12289',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  in_tenant_space = True,
  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('lock_id', 'varchar:MAX_LOCK_ID_BUF_LENGTH'),
  ('lock_mode', 'varchar:MAX_LOCK_MODE_BUF_LENGTH'),
  ('owner_id', 'int'),
  ('create_trans_id', 'int'),
  ('op_type', 'varchar:MAX_LOCK_OP_TYPE_BUF_LENGTH'),
  ('op_status', 'varchar:MAX_LOCK_OP_STATUS_BUF_LENGTH'),
  ('trans_version', 'uint'),
  ('create_timestamp', 'int'),
  ('create_schema_version', 'int'),
  ('extra_info', 'varchar:MAX_LOCK_OP_EXTRA_INFO_LENGTH'),
  ('time_after_create', 'int'),
  ('obj_type', 'varchar:MAX_LOCK_OBJ_TYPE_BUF_LENGTH'),
  ('obj_id', 'int'),
  ('owner_type', 'int'),
  ('priority', 'varchar:MAX_LOCK_OP_PRIORITY_BUF_LENGTH'),
  ('wait_seq', 'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12290',
  table_name = '__all_virtual_zone_merge_info',
  keywords = all_def_keywords['__all_zone_merge_info'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12291',
  table_name = '__all_virtual_merge_info',
  keywords = all_def_keywords['__all_merge_info'],
  in_tenant_space = True))

def_table_schema(
  owner = 'gengli.wzy',
  table_name     = '__all_virtual_tx_data_table',
  table_id       = '12292',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('state', 'varchar:MAX_TX_DATA_TABLE_STATE_LENGTH'),
  ('start_scn', 'uint'),
  ('end_scn', 'uint'),
  ('tx_data_count', 'int'),
  ('min_tx_log_scn', 'uint'),
  ('max_tx_log_scn', 'uint')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'chunrun.ct',
  table_name     = '__all_virtual_transaction_freeze_checkpoint',
  table_id       = '12293',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  in_tenant_space=True,
  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('tablet_id', 'int'),
  ('rec_log_scn', 'uint'),
  ('location', 'varchar:MAX_FREEZE_CHECKPOINT_LOCATION_BUF_LENGTH'),
  ('rec_log_scn_is_stable', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'chunrun.ct',
  table_name     = '__all_virtual_transaction_checkpoint',
  table_id       = '12294',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  in_tenant_space=True,
  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('tablet_id', 'int'),
  ('rec_log_scn', 'uint'),
  ('checkpoint_type', 'varchar:MAX_CHECKPOINT_TYPE_BUF_LENGTH'),
  ('is_flushing', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'chunrun.ct',
  table_name     = '__all_virtual_checkpoint',
  table_id       = '12295',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  in_tenant_space=True,
  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('service_type', 'varchar:MAX_SERVICE_TYPE_BUF_LENGTH'),
  ('rec_log_scn', 'uint'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12296',
  table_name = '__all_virtual_backup_set_files',
  keywords = all_def_keywords['__all_backup_set_files'],
  in_tenant_space = True))
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12297',
  table_name = '__all_virtual_backup_job',
  keywords = all_def_keywords['__all_backup_job'],
  in_tenant_space = True))
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12298',
  table_name = '__all_virtual_backup_job_history',
  keywords = all_def_keywords['__all_backup_job_history'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12299',
  table_name = '__all_virtual_plan_baseline',
  keywords = all_def_keywords['__all_plan_baseline']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12300',
  table_name = '__all_virtual_plan_baseline_item',
  keywords = all_def_keywords['__all_plan_baseline_item']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12301',
  table_name = '__all_virtual_spm_config',
  keywords = all_def_keywords['__all_spm_config']))

def_table_schema(
  owner = 'roland.qk',
  tablegroup_id = 'OB_INVALID_ID',
  table_name    = '__all_virtual_ash',
  table_id      = '12302',
  table_type = 'VIRTUAL_TABLE',
  gm_columns    = [],
  rowkey_columns = [],
  in_tenant_space=True,
  normal_columns = [
    ('SVR_IP', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('SVR_PORT', 'int'),
    ('SAMPLE_ID', 'int'),
    ('SAMPLE_TIME', 'timestamp'),
    ('TENANT_ID', 'int'),
    ('USER_ID', 'int'),
    ('SESSION_ID', 'int'),
    ('SESSION_TYPE', 'bool'),
    ('SQL_ID', 'varchar:OB_MAX_SQL_ID_LENGTH', 'false', ''),
    ('TRACE_ID', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE', 'false', ''),
    ('EVENT_NO', 'int'),
    ('TIME_WAITED', 'int'),
    ('P1', 'int'),
    ('P2', 'int'),
    ('P3', 'int'),
    ('SQL_PLAN_LINE_ID', 'int', 'true'),
    ('IN_PARSE', 'bool'),
    ('IN_PL_PARSE', 'bool'),
    ('IN_PLAN_CACHE', 'bool'),
    ('IN_SQL_OPTIMIZE', 'bool'),
    ('IN_SQL_EXECUTION', 'bool'),
    ('IN_PX_EXECUTION', 'bool'),
    ('IN_SEQUENCE_LOAD', 'bool'),
    ('MODULE', 'varchar:64', 'true'),
    ('ACTION', 'varchar:64', 'true'),
    ('CLIENT_ID', 'varchar:64', 'true'),
    ('BACKTRACE', 'varchar:512', 'true'),
    ('PLAN_ID', 'int'),
    ('IS_WR_SAMPLE', 'bool', 'false', 'false'),
    ('TIME_MODEL', 'uint', 'false', '0'),
    ('IN_COMMITTING', 'bool'),
    ('IN_STORAGE_READ', 'bool'),
    ('IN_STORAGE_WRITE', 'bool'),
    ('IN_REMOTE_DAS_EXECUTION', 'bool'),
    ('PROGRAM','varchar:64', 'true'),
    ('TM_DELTA_TIME', 'int', 'true'),
    ('TM_DELTA_CPU_TIME', 'int', 'true'),
    ('TM_DELTA_DB_TIME', 'int', 'true'),
    ('TOP_LEVEL_SQL_ID', 'varchar:OB_MAX_SQL_ID_LENGTH', 'true'),
    ('IN_PLSQL_COMPILATION', 'bool', 'false', 'false'),
    ('IN_PLSQL_EXECUTION', 'bool', 'false', 'false'),
    ('PLSQL_ENTRY_OBJECT_ID', 'int', 'true'),
    ('PLSQL_ENTRY_SUBPROGRAM_ID', 'int', 'true'),
    ('PLSQL_ENTRY_SUBPROGRAM_NAME', 'varchar:32', 'true'),
    ('PLSQL_OBJECT_ID', 'int', 'true'),
    ('PLSQL_SUBPROGRAM_ID', 'int', 'true'),
    ('PLSQL_SUBPROGRAM_NAME', 'varchar:32', 'true'),
    ('EVENT_ID', 'int', 'true'),
    ('IN_FILTER_ROWS', 'bool', 'false', 'false'),
    ('GROUP_ID', 'int', 'true'),
    ('TX_ID', 'int', 'true'),
    ('BLOCKING_SESSION_ID', 'int', 'true'),
    ('PLAN_HASH', 'uint', 'true'),
    ('THREAD_ID', 'int', 'true'),
    ('STMT_TYPE', 'int', 'true'),
    ('TABLET_ID', 'int', 'true'),
    ('PROXY_SID', 'int', 'true'),
    ('DELTA_READ_IO_REQUESTS', 'int', 'false', '0'),
    ('DELTA_READ_IO_BYTES', 'int', 'false', '0'),
    ('DELTA_WRITE_IO_REQUESTS', 'int', 'false', '0'),
    ('DELTA_WRITE_IO_BYTES', 'int', 'false', '0')
  ],
  partition_columns = ['SVR_IP', 'SVR_PORT'],
  vtable_route_policy = 'distributed',
  index = {'all_virtual_ash_i1' : { 'index_columns' : ['SAMPLE_TIME'],
                    'index_using_type' : 'USING_BTREE'}},
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name     = '__all_virtual_dml_stats',
  table_id       = '12303',
  table_type     = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],
  in_tenant_space = True,
  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('table_id', 'int'),
  ('tablet_id', 'int'),
  ('insert_row_count', 'int'),
  ('update_row_count', 'int'),
  ('delete_row_count', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12304',
  table_name = '__all_virtual_log_archive_dest_parameter',
  keywords = all_def_keywords['__all_log_archive_dest_parameter'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12305',
  table_name = '__all_virtual_backup_parameter',
  keywords = all_def_keywords['__all_backup_parameter'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12306',
  table_name = '__all_virtual_restore_job',
  keywords = all_def_keywords['__all_restore_job'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12307',
  table_name = '__all_virtual_restore_job_history',
  keywords = all_def_keywords['__all_restore_job_history'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12308',
  table_name = '__all_virtual_restore_progress',
  keywords = all_def_keywords['__all_restore_progress'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12309',
  table_name = '__all_virtual_ls_restore_progress',
  keywords = all_def_keywords['__all_ls_restore_progress'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12310',
  table_name = '__all_virtual_ls_restore_history',
  keywords = all_def_keywords['__all_ls_restore_history'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12311',
  table_name = '__all_virtual_backup_storage_info_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_backup_storage_info_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12312',
  table_name = '__all_virtual_backup_delete_job',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_backup_delete_job']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12313',
  table_name = '__all_virtual_backup_delete_job_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_backup_delete_job_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12314',
  table_name = '__all_virtual_backup_delete_policy',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_backup_delete_policy']))

def_table_schema(
  owner = 'lihongqin.lhq',
  table_name     = '__all_virtual_tablet_ddl_kv_info',
  table_id       = '12315',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('tablet_id', 'int'),
    ('freeze_log_scn', 'uint'),
    ('start_log_scn', 'uint'),
    ('min_log_scn', 'uint'),
    ('macro_block_cnt', 'int'),
    ('ref_cnt', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
    owner = 'liuqifan.lqf',
    table_name    = '__all_virtual_privilege',
    table_id      = '12316',
    table_type = 'VIRTUAL_TABLE',
    in_tenant_space = True,
    gm_columns = [],
    rowkey_columns = [
    ],
    normal_columns = [
      ('Privilege', 'varchar:MAX_COLUMN_PRIVILEGE_LENGTH'),
      ('Context', 'varchar:MAX_PRIVILEGE_CONTEXT_LENGTH'),
      ('Comment', 'varchar:MAX_COLUMN_COMMENT_LENGTH'),
    ],
)

def_table_schema(
    owner = 'yunshan.tys',
    table_name = '__all_virtual_tablet_pointer_status',
    table_id   = '12317',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ],
    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('ls_id', 'int'),
      ('tablet_id', 'int'),
      ('address', 'varchar:256'),
      ('pointer_ref', 'int'),
      ('in_memory', 'bool'),
      ('tablet_ref', 'int'),
      ('wash_score', 'int'),
      ('tablet_ptr', 'varchar:128'),
      ('initial_state', 'bool'),
      ('old_chain', 'varchar:128'),
      ('occupy_size', 'bigint', 'false', '0'),
      ('required_size', 'bigint', 'false', '0'),
    ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
  in_tenant_space = True,
)

def_table_schema(
    owner = 'yunshan.tys',
    table_name = '__all_virtual_storage_meta_memory_status',
    table_id   = '12318',
    table_type = 'VIRTUAL_TABLE',
    gm_columns = [],
    rowkey_columns = [
    ],
    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('name', 'varchar:128'),
      ('used_size', 'int'),
      ('total_size', 'int'),
      ('used_obj_cnt', 'int'),
      ('free_obj_cnt', 'int'),
      ('each_obj_size', 'int'),
    ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'zhaoruizhe.zrz',
  table_name = '__all_virtual_kvcache_store_memblock',
  table_id = '12319',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('cache_id', 'int'),
    ('cache_name', 'varchar:OB_MAX_KVCACHE_NAME_LENGTH'),
    ('memblock_ptr', 'varchar:32'),
    ('ref_count', 'int'),
    ('status', 'int'),
    ('policy', 'int'),
    ('kv_cnt', 'int'),
    ('get_cnt', 'int'),
    ('recent_get_cnt', 'int'),
    ('priority', 'int'),
    ('score', 'number:38:3'),
    ('align_size', 'int'),
  ],
  vtable_route_policy = 'distributed',
  partition_columns = ['svr_ip', 'svr_port'],
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12320',
  table_name = '__all_virtual_mock_fk_parent_table',
  keywords = all_def_keywords['__all_mock_fk_parent_table']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12321',
  table_name = '__all_virtual_mock_fk_parent_table_history',
  keywords = all_def_keywords['__all_mock_fk_parent_table_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12322',
  table_name = '__all_virtual_mock_fk_parent_table_column',
  keywords = all_def_keywords['__all_mock_fk_parent_table_column']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12323',
  table_name = '__all_virtual_mock_fk_parent_table_column_history',
  keywords = all_def_keywords['__all_mock_fk_parent_table_column_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12324',
  table_name = '__all_virtual_log_restore_source',
  keywords = all_def_keywords['__all_log_restore_source'],
  in_tenant_space = True))

def_table_schema(
  owner = 'wangzelin.wzl',
  tablegroup_id='OB_INVALID_ID',
  table_name='__all_virtual_query_response_time',
  table_id='12325',
  table_type='VIRTUAL_TABLE',
  gm_columns=[],
  in_tenant_space=True,
  rowkey_columns=[
  ],
  normal_columns=[
    ('tenant_id', 'int', 'false'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
    ('svr_port', 'int'),
    ('response_time', 'bigint', 'false', '0'),
    ('count',  'bigint', 'false', '0'),
    ('total',  'bigint', 'false', '0'),
    ('sql_type', 'varchar:128', 'false', '')
  ],
  partition_columns=['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12326',
  table_name = '__all_virtual_kv_ttl_task',
  keywords = all_def_keywords['__all_kv_ttl_task'],
  in_tenant_space=True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12327',
  table_name = '__all_virtual_kv_ttl_task_history',
  keywords = all_def_keywords['__all_kv_ttl_task_history'],
  in_tenant_space=True))

# 12328: __all_virtual_tenant_datafile
# 12329: __all_virtual_tenant_datafile_history

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12330',
  table_name = '__all_virtual_column_checksum_error_info',
  keywords = all_def_keywords['__all_column_checksum_error_info']))

# 12331: __all_virtual_kvcache_handle_leak_info
# 12332: abandoned
# 12333: abandoned

def_table_schema(
    owner = 'lixia.yq',
    table_name     = '__all_virtual_tablet_compaction_info',
    table_id       = '12334',
    table_type     = 'VIRTUAL_TABLE',
    in_tenant_space = True,
    gm_columns     = [],
    rowkey_columns = [],

    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('ls_id', 'int'),
      ('tablet_id', 'int'),
      ('finished_scn', 'int'),
      ('wait_check_scn', 'int'),
      ('max_received_scn', 'int'),
      ('serialize_scn_list', 'varchar:OB_MAX_VARCHAR_LENGTH'),
      ('validated_scn', 'int')
    ],
    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'jingyu.cr',
  table_name    = '__all_virtual_ls_replica_task_plan',
  table_id      = '12335',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],
  in_tenant_space = True,
  normal_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('task_type', 'varchar:MAX_DISASTER_RECOVERY_TASK_TYPE_LENGTH'),
    ('priority', 'int', 'false', 1),
    ('target_replica_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('target_replica_svr_port', 'int', 'true'),
    ('target_paxos_replica_number', 'int', 'true'),
    ('target_replica_type', 'varchar:MAX_REPLICA_TYPE_LENGTH', 'true'),
    ('source_replica_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('source_replica_svr_port', 'int', 'true'),
    ('source_paxos_replica_number', 'int', 'true'),
    ('source_replica_type', 'varchar:MAX_REPLICA_TYPE_LENGTH', 'true'),
    ('task_exec_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'true'),
    ('task_exec_svr_port', 'int', 'true'),
    ('comment', 'varchar:MAX_COLUMN_COMMENT_LENGTH', 'true'),
  ],
  vtable_route_policy = 'local',
)

def_table_schema(
  owner = 'xingrui.cwh',
  table_name = '__all_virtual_schema_memory',
  table_id = '12336',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],

  in_tenant_space = False,
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('type', 'varchar:128'),
    ('used_schema_mgr_cnt', 'int'),
    ('free_schema_mgr_cnt', 'int'),
    ('mem_used', 'int'),
    ('mem_total', 'int'),
    ('allocator_idx', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'xingrui.cwh',
  table_name = '__all_virtual_schema_slot',
  table_id = '12337',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],

  in_tenant_space = False,
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('slot_id', 'int'),
    ('schema_version', 'int'),
    ('schema_count', 'int'),
    ('total_ref_cnt', 'int'),
    ('ref_info','varchar:OB_MAX_SCHEMA_REF_INFO'),
    ('allocator_idx', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'handora.qc',
  table_name     = '__all_virtual_minor_freeze_info',
  table_id       = '12338',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('tablet_id', 'int'),
  ('is_force', 'varchar:MAX_COLUMN_YES_NO_LENGTH'),
  ('freeze_clock', 'int'),
  ('freeze_snapshot_version', 'int'),
  ('start_time', 'timestamp', 'true'),
  ('end_time', 'timestamp', 'true'),
  ('ret_code', 'int'),
  ('state', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('diagnose_info', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('memtables_info', 'varchar:OB_MAX_CHAR_LENGTH')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'guoyun.lgy',
  table_name     = '__all_virtual_show_trace',
  table_id       = '12339',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ],
  in_tenant_space = True,

  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('trace_id', 'varchar:OB_MAX_SPAN_LENGTH'),
    ('request_id', 'int'),
    ('rec_svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('rec_svr_port', 'int'),
    ('span_id', 'varchar:OB_MAX_SPAN_LENGTH'),
    ('parent_span_id', 'varchar:OB_MAX_SPAN_LENGTH'),
    ('span_name', 'varchar:OB_MAX_SPAN_LENGTH'),
    ('ref_type', 'varchar:OB_MAX_REF_TYPE_LENGTH'),
    ('start_ts', 'timestamp'),
    ('end_ts', 'timestamp'),
    ('elapse', 'int'),
    ('tags', 'longtext'),
    ('logs', 'longtext'),
  ],
)

def_table_schema(
  owner = 'keqing.llt',
  table_name = '__all_virtual_ha_diagnose',
  table_id = '12340',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = False,
  rowkey_columns = [
  ],

  normal_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('election_role', 'varchar:32'),
    ('election_epoch', 'int'),
    ('palf_role', 'varchar:32'),
    ('palf_state', 'varchar:32'),
    ('palf_proposal_id', 'int'),
    ('log_handler_role', 'varchar:32'),
    ('log_handler_proposal_id', 'int'),
    ('log_handler_takeover_state', 'varchar:32'),
    ('log_handler_takeover_log_type', 'varchar:32'),
    ('max_applied_scn', 'uint'),
    ('max_replayed_lsn', 'uint'),
    ('max_replayed_scn', 'uint'),
    ('replay_diagnose_info', 'varchar:1024'),
    ('gc_state', 'varchar:32'),
    ('gc_start_ts', 'int'),
    ('archive_scn', 'uint'),
    ('checkpoint_scn', 'uint'),
    ('min_rec_scn', 'uint'),
    ('min_rec_scn_log_type', 'varchar:32'),
    ('restore_handler_role', 'varchar:32'),
    ('restore_proposal_id', 'int'),
    ('restore_context_info', 'varchar:1024'),
    ('restore_err_context_info', 'varchar:1024'),
    ('enable_sync', 'bool'),
    ('enable_vote', 'bool'),
    ('arb_srv_info', 'varchar:1024'),
    ('parent', 'varchar:1024'),
    ('readonly_tx', 'varchar:1024'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12341',
  table_name = '__all_virtual_data_dictionary_in_log',
  keywords = all_def_keywords['__all_data_dictionary_in_log']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12342',
  table_name = '__all_virtual_transfer_task',
  keywords = all_def_keywords['__all_transfer_task']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12343',
  table_name = '__all_virtual_transfer_task_history',
  keywords = all_def_keywords['__all_transfer_task_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12344',
  table_name = '__all_virtual_balance_job',
  keywords = all_def_keywords['__all_balance_job']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12345',
  table_name = '__all_virtual_balance_job_history',
  keywords = all_def_keywords['__all_balance_job_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12346',
  table_name = '__all_virtual_balance_task',
  keywords = all_def_keywords['__all_balance_task']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12347',
  table_name = '__all_virtual_balance_task_history',
  keywords = all_def_keywords['__all_balance_task_history']))


def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12348',
  table_name = '__all_virtual_rls_policy',
  keywords = all_def_keywords['__all_rls_policy']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12349',
  table_name = '__all_virtual_rls_policy_history',
  keywords = all_def_keywords['__all_rls_policy_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12350',
  table_name = '__all_virtual_rls_security_column',
  keywords = all_def_keywords['__all_rls_security_column']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12351',
  table_name = '__all_virtual_rls_security_column_history',
  keywords = all_def_keywords['__all_rls_security_column_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12352',
  table_name = '__all_virtual_rls_group',
  keywords = all_def_keywords['__all_rls_group']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12353',
  table_name = '__all_virtual_rls_group_history',
  keywords = all_def_keywords['__all_rls_group_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12354',
  table_name = '__all_virtual_rls_context',
  keywords = all_def_keywords['__all_rls_context']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12355',
  table_name = '__all_virtual_rls_context_history',
  keywords = all_def_keywords['__all_rls_context_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12356',
  table_name = '__all_virtual_rls_attribute',
  keywords = all_def_keywords['__all_rls_attribute']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12357',
  table_name = '__all_virtual_rls_attribute_history',
  keywords = all_def_keywords['__all_rls_attribute_history']))

def_table_schema(**gen_mysql_sys_agent_virtual_table_def('12358', all_def_keywords['__all_tenant']))

def_table_schema(
  owner = 'zhenling.zzg',
  tablegroup_id = 'OB_INVALID_ID',
  table_name    = '__all_virtual_sql_plan',
  table_id      = 12359,
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('plan_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
  ],
  normal_columns = [
    ('sql_id', 'varchar:OB_MAX_SQL_ID_LENGTH'),
    ('db_id', 'int'),
    ('plan_hash', 'uint'),
    ('gmt_create', 'timestamp'),

    ('operator', 'varchar:255'),
    ('options', 'varchar:255'),
    ('object_node', 'varchar:40'),
    ('object_id', 'int'),
    ('object_owner', 'varchar:128'),
    ('object_name', 'varchar:128'),
    ('object_alias', 'varchar:261'),
    ('object_type', 'varchar:20'),
    ('optimizer', 'varchar:4000'),

    ('id', 'int'),
    ('parent_id', 'int'),
    ('depth', 'int'),
    ('position', 'int'),
    ('search_columns', 'int'),
    ('is_last_child', 'int'),
    ('cost', 'bigint'),
    ('real_cost', 'bigint'),
    ('cardinality', 'bigint'),
    ('real_cardinality', 'bigint'),
    ('bytes', 'bigint'),
    ('rowset', 'int'),

    ('other_tag', 'varchar:4000'),
    ('partition_start', 'varchar:4000'),
    ('partition_stop', 'varchar:4000'),
    ('partition_id', 'int'),
    ('other', 'varchar:4000'),
    ('distribution', 'varchar:64'),
    ('cpu_cost', 'bigint'),
    ('io_cost', 'bigint'),
    ('temp_space', 'bigint'),
    ('access_predicates', 'varchar:4000'),
    ('filter_predicates', 'varchar:4000'),
    ('startup_predicates', 'varchar:4000'),
    ('projection', 'varchar:4000'),
    ('special_predicates', 'varchar:4000'),
    ('time', 'int'),
    ('qblock_name','varchar:128'),
    ('remarks', 'varchar:4000'),
    ('other_xml', 'varchar:4000')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed'
)
# 12360: abandoned
# 12361: abandoned

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12362',
  table_name = '__all_virtual_core_table',
  keywords = all_def_keywords['__all_core_table']))

def_table_schema(
  owner = 'tushicheng.tsc',
  table_name     = '__all_virtual_malloc_sample_info',
  table_id       = '12363',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  in_tenant_space = True,
  rowkey_columns = [],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('ctx_id', 'int'),
  ('mod_name', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('back_trace', 'varchar:DEFAULT_BUF_LENGTH'),
  ('ctx_name', 'varchar:OB_MAX_CHAR_LENGTH'),
  ('alloc_count', 'int'),
  ('alloc_bytes', 'int'),
  ],
  vtable_route_policy = 'distributed',
  partition_columns = ['svr_ip', 'svr_port'],
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12364',
  table_name = '__all_virtual_ls_arb_replica_task',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_ls_arb_replica_task']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12365',
  table_name = '__all_virtual_ls_arb_replica_task_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_ls_arb_replica_task_history']))

def_table_schema(
  owner = 'zhaoyongheng.zyh',
  table_name = '__all_virtual_archive_dest_status',
  table_id = '12366',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,
  normal_columns = [
    ('tenant_id', 'int'),
    ('dest_id', 'int'),
    ('path', 'varchar:4096'),
    ('status', 'varchar:64'),
    ('checkpoint_scn', 'uint'),
    ('synchronized', 'varchar:32'),
    ('comment', 'varchar:262144')
  ],
)

# 12367: __all_virtual_kv_hotkey_stat
# 12368: __all_virtual_backup_transferring_tablets

def_table_schema(
  owner             = 'renju.rj',
  table_name        = '__all_virtual_io_scheduler',
  table_id          = '12369',
  table_type        = 'VIRTUAL_TABLE',
  in_tenant_space   = False,
  gm_columns        = [],
  rowkey_columns    = [],
  normal_columns    = [
    ('svr_ip',              'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port',            'int'),
    ('thread_id',           'int'),
    ('tenant_id',           'int'),
    ('group_id',            'int'),
    ('queuing_count',       'int'),
    ('reservation_ts',      'timestamp'),
    ('category_limit_ts',   'timestamp'),
    ('tenant_limit_ts',     'timestamp'),
    ('proportion_ts',       'timestamp'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12370: __all_virtual_wait_for_partition_split_tablet

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12371',
  table_name = '__all_virtual_external_table_file',
  keywords = all_def_keywords['__all_external_table_file']))

# 12372: __all_virtual_io_tracer

def_table_schema(
  owner             = 'xuwang.txw',
  table_name        = '__all_virtual_mds_node_stat',
  table_id          = '12373',
  table_type        = 'VIRTUAL_TABLE',
  in_tenant_space   = True,
  gm_columns        = [],
  rowkey_columns    = [
    ('tenant_id',     'int'),
    ('ls_id',         'bigint'),
    ('tablet_id',     'bigint'),
  ],
  normal_columns    = [
    ('svr_ip',        'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port',      'int'),
    ('unit_id',       'bigint'),
    ('user_key',      'longtext'),
    ('version_idx',   'bigint'),
    ('writer_type',   'longtext'),
    ('writer_id',     'bigint'),
    ('seq_no',        'bigint'),
    ('redo_scn',      'uint'),
    ('end_scn',       'uint'),
    ('trans_version', 'uint'),
    ('node_type',     'longtext'),
    ('state',         'longtext'),
    ('position',      'longtext'),
    ('user_data',     'longtext')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner             = 'xuwang.txw',
  table_name        = '__all_virtual_mds_event_history',
  table_id          = '12374',
  table_type        = 'VIRTUAL_TABLE',
  in_tenant_space   = True,
  gm_columns        = [],
  rowkey_columns    = [
    ('tenant_id',     'int'),
    ('ls_id',         'bigint'),
    ('tablet_id',     'bigint'),
  ],
  normal_columns    = [
    ('svr_ip',        'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port',      'int'),
    ('tid',           'int'),# common info
    ('tname',         'longtext'),# common info
    ('trace',         'longtext'),# common info
    ('timestamp',     'timestamp'),# common info
    ('event',         'longtext'),# common info
    ('info',          'longtext'),# common info
    ('unit_id',       'bigint'),# unit info
    ('user_key',      'longtext'),# row info
    ('writer_type',   'longtext'),# node info
    ('writer_id',     'bigint'),# node info
    ('seq_no',        'bigint'),# node info
    ('redo_scn',      'uint'),# node info
    ('end_scn',       'uint'),# node info
    ('trans_version', 'uint'),# node info
    ('node_type',     'longtext'),# node info
    ('state',         'longtext')# node info
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)
# 12375: __all_virtual_time_guard_slow_history
def_table_schema(
  owner = 'wyh329796',
  table_name = '__all_virtual_dup_ls_lease_mgr',
  table_id = '12376',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('follower_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('follower_port', 'int'),
  ],

  normal_columns = [
    ('grant_timestamp', 'timestamp'),
    ('expired_timestamp', 'timestamp'),
    ('remain_us', 'int'),
    ('lease_interval_us', 'int'),
    ('grant_req_ts', 'int'),
    ('cached_req_ts', 'int'),
    ('max_replayed_scn', 'int'),
    ('max_read_version', 'int'),
    ('max_commit_version', 'int'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12377: __all_virtual_dup_ls_follower_lease_info

def_table_schema(
  owner = 'wyh329796',
  table_name = '__all_virtual_dup_ls_tablet_set',
  table_id = '12378',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('ls_state', 'varchar:MAX_LS_STATE_LENGTH'),
    ('unique_id', 'int'),
  ],

  normal_columns = [
    ('attribute', 'varchar:OB_MAX_DUP_TABLE_TABLET_SET_ATTR_LENGTH'), # length:16
    ('count', 'int'),
    ('readbale_scn', 'int'),
    ('change_scn', 'int'),
    ('need_confirm_scn', 'int'),
    ('state', 'varchar:OB_MAX_DUP_TABLE_TABLET_SET_STATE_LENGTH'), # length:16
    ('trx_ref', 'int'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)
def_table_schema(
  owner = 'wyh329796',
  table_name = '__all_virtual_dup_ls_tablets',
  table_id = '12379',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('ls_state', 'varchar:MAX_LS_STATE_LENGTH'),
    ('tablet_id', 'uint'),
  ],

  normal_columns = [
    ('unique_id', 'int'),
    ('attribute', 'varchar:OB_MAX_DUP_TABLE_TABLET_SET_ATTR_LENGTH'),
    ('refresh_schema_timestamp', 'timestamp'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'gengli.wzy',
  table_name     = '__all_virtual_tx_data',
  table_id       = '12380',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('tx_id', 'int'),
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('state', 'varchar:MAX_TX_DATA_STATE_LENGTH'),
  ('start_scn', 'uint'),
  ('end_scn', 'uint'),
  ('commit_version', 'uint'),
  ('undo_status', 'varchar:MAX_UNDO_LIST_CHAR_LENGTH'),
  ('tx_op', 'varchar:MAX_TX_OP_CHAR_LENGTH'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12381',
  table_name = '__all_virtual_task_opt_stat_gather_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_task_opt_stat_gather_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12382',
  table_name = '__all_virtual_table_opt_stat_gather_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_table_opt_stat_gather_history']))

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name     = '__all_virtual_opt_stat_gather_monitor',
  table_id       = '12383',
  table_type     = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,
  normal_columns = [
  ('tenant_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('session_id', 'int'),
  ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
  ('task_id', 'varchar:36'),
  ('type', 'int'),
  ('task_start_time', 'timestamp'),
  ('task_table_count', 'int'),
  ('task_duration_time', 'int'),
  ('completed_table_count', 'int'),
  ('running_table_owner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
  ('running_table_name', 'varchar:OB_MAX_TABLE_NAME_LENGTH'),
  ('running_table_duration_time', 'int'),
  ('spare1', 'int', 'true'),
  ('spare2', 'varchar:MAX_VALUE_LENGTH', 'true'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner             = 'fengshuo.fs',
  table_name        = '__all_virtual_thread',
  table_id          = '12384',
  table_type        = 'VIRTUAL_TABLE',
  in_tenant_space   = True,
  gm_columns        = [],
  rowkey_columns    = [],
  normal_columns    = [
    ('svr_ip',              'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port',            'int'),
    ('tenant_id',           'int'),
    ('tid',                 'int'),
    ('tname',               'varchar:16'),
    ('status',              'varchar:32'),
    ('wait_event',          'varchar:96'),
    ('latch_wait',          'varchar:16'),
    ('latch_hold',          'varchar:256'),
    ('trace_id',            'varchar:40'),
    ('loop_ts',             'timestamp'),
    ('cgroup_path',         'varchar:256')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'debin.jdb',
  table_name = '__all_virtual_arbitration_member_info',
  table_id = '12385',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],

  normal_columns = [
  ('tenant_id', 'int'),
  ('ls_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('proposal_id', 'int'),
  ('config_version', 'varchar:128'),
  ('access_mode', 'varchar:32'),
  ('paxos_member_list', 'varchar:1024'),
  ('paxos_replica_num', 'int'),
  ('arbitration_member', 'varchar:128'),
  ('degraded_list', 'varchar:1024'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'xiaotao.ht',
  table_name = '__all_virtual_server_storage',
  table_id = '12386',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = False,
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('path', 'varchar:MAX_PATH_SIZE'),
    ('endpoint', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
    ('used_for', 'varchar:OB_MAX_CHAR_LENGTH'),
    ('zone', 'varchar:MAX_ZONE_LENGTH'),
    ('storage_id', 'bigint:20'),
    ('max_iops', 'bigint:20'),
    ('max_bandwidth', 'bigint:20'),
    ('create_time', 'timestamp'),
    ('op_id', 'bigint:20'),
    ('sub_op_id', 'bigint:20'),
    ('authorization', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
    ('encrypt_info', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
    ('state', 'varchar:OB_MAX_CHAR_LENGTH'),
    ('state_info', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH'),
    ('last_check_timestamp', 'timestamp'),
    ('extension', 'varchar:OB_INNER_TABLE_DEFAULT_VALUE_LENTH')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'debin.jdb',
  table_name = '__all_virtual_arbitration_service_status',
  table_id = '12387',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],

  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('arbitration_service_address', 'varchar:512'),
  ('status', 'varchar:64'),
  ],

  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)


# 12388: __all_virtual_wr_active_session_history
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12388',
  table_name = '__all_virtual_wr_active_session_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__wr_active_session_history']))
# 12389: __all_virtual_wr_snapshot
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12389',
  table_name = '__all_virtual_wr_snapshot',
  in_tenant_space = True,
  keywords = all_def_keywords['__wr_snapshot']))
# 12390: __all_virtual_wr_statname
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12390',
  table_name = '__all_virtual_wr_statname',
  in_tenant_space = True,
  keywords = all_def_keywords['__wr_statname']))
# 12391: __all_virtual_wr_sysstat
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12391',
  table_name = '__all_virtual_wr_sysstat',
  in_tenant_space = True,
  keywords = all_def_keywords['__wr_sysstat']))
# 12392: __all_virtual_kv_connection
def_table_schema(
  owner      = 'shenyunlong.syl',
  table_name = '__all_virtual_kv_connection',
  table_id = '12392',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  in_tenant_space = True,
  rowkey_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('client_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('client_port', 'int'),
  ],
  normal_columns = [
    ('tenant_id', 'int'),
    ('user_id', 'int'),
    ('db_id', 'int'),
    ('first_active_time', 'timestamp'),
    ('last_active_time', 'timestamp')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)
def_table_schema(**gen_mysql_sys_agent_virtual_table_def('12393', all_def_keywords['__all_virtual_long_ops_status']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12394',
  table_name = '__all_virtual_ls_transfer_member_list_lock_info',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_ls_transfer_member_list_lock_info']))

def_table_schema(
  owner             = 'lixinze.lxz',
  table_name        = '__all_virtual_timestamp_service',
  table_id          = '12395',
  table_type        = 'VIRTUAL_TABLE',
  in_tenant_space   = True,
  gm_columns        = [],
  rowkey_columns    = [],
  normal_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('ts_value', 'int'),
    ('ts_type', 'varchar:100'),
    ('service_role', 'varchar:100'),
    ('role', 'varchar:100'),
    ('service_epoch', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_mysql_sys_agent_virtual_table_def('12396', all_def_keywords['__all_resource_pool']))

def_table_schema(
  owner = 'mingdou.tmd',
  table_name    = '__all_virtual_px_p2p_datahub',
  table_id      = '12397',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
    ('datahub_id', 'bigint'),
    ('message_type', 'varchar:256'),
    ('tenant_id', 'int'),
    ('hold_size', 'bigint'),
    ('timeout_ts', 'timestamp'),
    ('start_time', 'timestamp')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
    table_id = '12398',
    table_name = '__all_virtual_column_group',
    keywords = all_def_keywords['__all_column_group']))

def_table_schema(
  owner = 'huronghui.hrh',
  table_name = '__all_virtual_storage_leak_info',
  table_type = 'VIRTUAL_TABLE',
  table_id='12399',
  gm_columns = [],
  rowkey_columns = [
  ],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH', 'false'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('check_id', 'int'),
    ('check_mod', 'varchar:OB_MAX_KVCACHE_NAME_LENGTH'),
    ('hold_count', 'int'),
    ('backtrace', 'varchar:DEFAULT_BUF_LENGTH'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'zhaoyongheng.zyh',
  table_name = '__all_virtual_ls_log_restore_status',
  table_id = '12400',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],
  normal_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('ls_id', 'int'),
    ('sync_lsn', 'uint'),
    ('sync_scn', 'uint'),
    ('sync_status', 'varchar:128'),
    ('err_code', 'int'),
    ('comment', 'varchar:MAX_COLUMN_COMMENT_LENGTH'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12401',
  table_name = '__all_virtual_tenant_parameter',
  in_tenant_space = True,
  keywords = all_def_keywords['__tenant_parameter']))
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12402',
  table_name = '__all_virtual_tenant_snapshot',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_tenant_snapshot']))
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12403',
  table_name = '__all_virtual_tenant_snapshot_ls',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_tenant_snapshot_ls']))
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12404',
  table_name = '__all_virtual_tenant_snapshot_ls_replica',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_tenant_snapshot_ls_replica']))

def_table_schema(
  owner = 'yunshan.tys',
  table_name = '__all_virtual_tablet_buffer_info',
  table_id = '12405',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('tablet_buffer', 'varchar:128'),
  ],

  normal_columns = [
  ('tablet', 'varchar:128'),
	('pool_type', 'varchar:128'),
  ('ls_id', 'int'),
  ('tablet_id', 'int'),
  ('in_map', 'bool'),
  ('last_access_time', 'timestamp'),
  ]
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12406',
  table_name = '__all_virtual_mlog',
  keywords = all_def_keywords['__all_mlog'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12407',
  table_name = '__all_virtual_mview',
  keywords = all_def_keywords['__all_mview'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12408',
  table_name = '__all_virtual_mview_refresh_stats_sys_defaults',
  keywords = all_def_keywords['__all_mview_refresh_stats_sys_defaults'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12409',
  table_name = '__all_virtual_mview_refresh_stats_params',
  keywords = all_def_keywords['__all_mview_refresh_stats_params'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12410',
  table_name = '__all_virtual_mview_refresh_run_stats',
  keywords = all_def_keywords['__all_mview_refresh_run_stats'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12411',
  table_name = '__all_virtual_mview_refresh_stats',
  keywords = all_def_keywords['__all_mview_refresh_stats'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12412',
  table_name = '__all_virtual_mview_refresh_change_stats',
  keywords = all_def_keywords['__all_mview_refresh_change_stats'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12413',
  table_name = '__all_virtual_mview_refresh_stmt_stats',
  keywords = all_def_keywords['__all_mview_refresh_stmt_stats'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12414',
  table_name = '__all_virtual_wr_control',
  in_tenant_space = True,
  keywords = all_def_keywords['__wr_control']))
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12415',
  table_name = '__all_virtual_tenant_event_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_tenant_event_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12416',
  table_name = '__all_virtual_balance_task_helper',
  keywords = all_def_keywords['__all_balance_task_helper']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12417',
  table_name = '__all_virtual_balance_group_ls_stat',
  keywords = all_def_keywords['__all_balance_group_ls_stat']))

# 12418: __all_virtual_cgroup_info
def_table_schema(
  owner             = 'fengshuo.fs',
  table_name        = '__all_virtual_cgroup_config',
  table_id          = '12419',
  table_type        = 'VIRTUAL_TABLE',
  in_tenant_space   = True,
  gm_columns        = [],
  rowkey_columns    = [],
  normal_columns    = [
    ('svr_ip',              'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port',            'int'),
    ('cfs_quota_us',        'int'),
    ('cfs_period_us',       'int'),
    ('shares',              'int'),
    ('cgroup_path',         'varchar:256')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'guoyun.lgy',
  table_name = '__all_virtual_flt_config',
  table_id = '12420',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],
  normal_columns = [
  ('tenant_id', 'int'),
  ('type', 'varchar:16'),
  ('module_name', 'varchar:MAX_VALUE_LENGTH'),
  ('action_name', 'varchar:MAX_VALUE_LENGTH'),
  ('client_identifier', 'varchar:OB_MAX_CONTEXT_CLIENT_IDENTIFIER_LENGTH'),
  ('level', 'int'),
  ('sample_percentage', 'int'),
  ('record_policy', 'varchar:32')
  ]
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12421',
  table_name = '__all_virtual_tenant_scheduler_job_class',
  keywords = all_def_keywords['__all_tenant_scheduler_job_class']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12422',
  table_name = '__all_virtual_recover_table_job',
  keywords = all_def_keywords['__all_recover_table_job'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12423',
  table_name = '__all_virtual_recover_table_job_history',
  keywords = all_def_keywords['__all_recover_table_job_history'],
  in_tenant_space = True))
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12424',
  table_name = '__all_virtual_import_table_job',
  keywords = all_def_keywords['__all_import_table_job'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12425',
  table_name = '__all_virtual_import_table_job_history',
  keywords = all_def_keywords['__all_import_table_job_history'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12426',
  table_name = '__all_virtual_import_table_task',
  keywords = all_def_keywords['__all_import_table_task'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12427',
  table_name = '__all_virtual_import_table_task_history',
  keywords = all_def_keywords['__all_import_table_task_history'],
  in_tenant_space = True))

# 12428: __all_virtual_import_stmt_exec_history

def_table_schema(
  owner = 'handora.qc',
  table_name = '__all_virtual_data_activity_metrics',
  table_id = '12429',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('activity_timestamp', 'timestamp'),
  ],

  normal_columns = [
  ('modification_size', 'int'),
  ('freeze_times', 'int'),
  ('mini_merge_cost', 'int'),
  ('mini_merge_times', 'int'),
  ('minor_merge_cost', 'int'),
  ('minor_merge_times', 'int'),
  ('major_merge_cost', 'int'),
  ('major_merge_times', 'int'),
  ]
)

def_table_schema(**gen_iterate_virtual_table_def(
    table_id = '12430',
    table_name = '__all_virtual_column_group_mapping',
    keywords = all_def_keywords['__all_column_group_mapping'],
    in_tenant_space = True))
def_table_schema(**gen_iterate_virtual_table_def(
    table_id = '12431',
    table_name = '__all_virtual_column_group_history',
    keywords = all_def_keywords['__all_column_group_history'],
    in_tenant_space = True))
def_table_schema(**gen_iterate_virtual_table_def(
    table_id = '12432',
    table_name = '__all_virtual_column_group_mapping_history',
    keywords = all_def_keywords['__all_column_group_mapping_history'],
    in_tenant_space = True))

def_table_schema(
  owner = 'zhixing.yh',
  table_name    = '__all_virtual_storage_ha_error_diagnose',
  table_id      = '12433',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = False,
  gm_columns    = [],
  rowkey_columns = [],
  normal_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('module', 'varchar:OB_MODULE_NAME_LENGTH'),
    ('type', 'varchar:OB_SYS_TASK_TYPE_LENGTH'),
    ('task_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('retry_id', 'int'),
    ('create_time', 'timestamp'),
    ('result_code', 'int'),
    ('result_msg', 'varchar:OB_DIAGNOSE_INFO_LENGTH'),
    ('info', 'longtext')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'zhixing.yh',
  table_name    = '__all_virtual_storage_ha_perf_diagnose',
  table_id      = '12434',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = False,
  gm_columns    = [],
  rowkey_columns = [],
  normal_columns = [
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('module', 'varchar:OB_MODULE_NAME_LENGTH'),
    ('type', 'varchar:OB_SYS_TASK_TYPE_LENGTH'),
    ('task_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('retry_id', 'int'),
    ('start_timestamp', 'timestamp'),
    ('end_timestamp', 'timestamp'),
    ('tablet_id', 'int'),
    ('tablet_count', 'int'),
    ('result_code', 'int'),
    ('result_msg', 'varchar:OB_DIAGNOSE_INFO_LENGTH'),
    ('info', 'longtext'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12435',
  table_name = '__all_virtual_clone_job',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_clone_job']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12436',
  table_name = '__all_virtual_clone_job_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_clone_job_history']))

def_table_schema(
  owner = 'zk250686',
  table_name    = '__all_virtual_checkpoint_diagnose_memtable_info',
  table_id      = '12437',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('trace_id', 'int'),
  ],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('ls_id', 'int'),
    ('checkpoint_thread_name', 'varchar:OB_THREAD_NAME_BUF_LEN'),
    ('checkpoint_start_time', 'timestamp'),
    ('tablet_id', 'int'),
    ('ptr', 'varchar:128'),
    ('start_scn', 'uint'),
    ('end_scn', 'uint'),
    ('rec_scn', 'uint'),
    ('create_flush_dag_time', 'timestamp'),
    ('merge_finish_time', 'timestamp'),
    ('release_time', 'timestamp'),
    ('frozen_finish_time', 'timestamp'),
    ('merge_start_time', 'timestamp'),
    ('start_gc_time', 'timestamp'),
    ('memtable_occupy_size', 'int'),
    ('occupy_size', 'int'),
    ('concurrent_cnt', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'zk250686',
  table_name    = '__all_virtual_checkpoint_diagnose_checkpoint_unit_info',
  table_id      = '12438',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('trace_id', 'int'),
  ],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('ls_id', 'int'),
    ('checkpoint_thread_name', 'varchar:OB_THREAD_NAME_BUF_LEN'),
    ('checkpoint_start_time', 'timestamp'),
    ('tablet_id', 'int'),
    ('ptr', 'varchar:128'),
    ('start_scn', 'uint'),
    ('end_scn', 'uint'),
    ('rec_scn', 'uint'),
    ('create_flush_dag_time', 'timestamp'),
    ('merge_finish_time', 'timestamp'),
    ('start_gc_time', 'timestamp'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'zk250686',
  table_name    = '__all_virtual_checkpoint_diagnose_info',
  table_id      = '12439',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [
  ],
  normal_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('ls_id', 'int'),
    ('trace_id', 'int'),
    ('freeze_clock', 'uint32'),
    ('checkpoint_thread_name', 'varchar:OB_THREAD_NAME_BUF_LEN'),
    ('checkpoint_start_time', 'timestamp'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12440',
  table_name = '__all_virtual_wr_system_event',
  in_tenant_space = True,
  keywords = all_def_keywords['__wr_system_event']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12441',
  table_name = '__all_virtual_wr_event_name',
  in_tenant_space = True,
  keywords = all_def_keywords['__wr_event_name']))

def_table_schema(
  owner = 'fyy280124',
  table_name     = '__all_virtual_tenant_scheduler_running_job',
  table_id       = '12442',
  table_type     = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('owner', 'varchar:OB_MAX_DATABASE_NAME_LENGTH', 'true'),
    ('job_name', 'varchar:128'),
    ('job_subname', 'varchar:30', 'true'),
    ('job_style', 'varchar:11', 'true'),
    ('detached', 'varchar:5', 'true'),
    ('session_id', 'uint', 'true'),
    ('slave_process_id', 'uint', 'true'),
    ('slave_os_process_id', 'uint', 'true'),
    ('resource_consumer_group', 'varchar:30', 'true'),
    ('running_instance', 'varchar:30', 'true'),
    ('elapsed_time', 'int', 'true'),
    ('cpu_used', 'int', 'true'),
    ('destination_owner', 'varchar:128', 'true'),
    ('destination', 'varchar:128', 'true'),
    ('credential_owner', 'varchar:30', 'true'),
    ('credential_name', 'varchar:30', 'true'),
    ('job_class', 'varchar:128', 'true'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12443',
  table_name = '__all_virtual_routine_privilege',
  keywords = all_def_keywords['__all_routine_privilege']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12444',
  table_name = '__all_virtual_routine_privilege_history',
  keywords = all_def_keywords['__all_routine_privilege_history']))
def_table_schema(
  owner = 'yuchen.wyc',
  table_name    = '__all_virtual_sqlstat',
  table_id      = '12445',
  table_type = 'VIRTUAL_TABLE',
  gm_columns    = [],
  rowkey_columns = [],
  in_tenant_space=True,
  normal_columns = [
    ('SVR_IP', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('SVR_PORT', 'int'),
    ('TENANT_ID', 'int'),
    ('SQL_ID', 'varchar:OB_MAX_SQL_ID_LENGTH'),
    ('PLAN_ID', 'int'),
    ('PLAN_HASH', 'uint'),
    ('PLAN_TYPE', 'int'),
    ('QUERY_SQL', 'longtext'),
    ("SQL_TYPE", 'int'),
    ('MODULE', 'varchar:64', 'true'),
    ('ACTION', 'varchar:64', 'true'),
    ('PARSING_DB_ID', 'int'),
    ('PARSING_DB_NAME', 'varchar:OB_MAX_DATABASE_NAME_LENGTH'),
    ('PARSING_USER_ID', 'int'),
    ('EXECUTIONS_TOTAL', 'bigint', 'false',  '0'),
    ('EXECUTIONS_DELTA', 'bigint', 'false',  '0'),
    ('DISK_READS_TOTAL', 'bigint', 'false',  '0'),
    ('DISK_READS_DELTA', 'bigint', 'false',  '0'),
    ('BUFFER_GETS_TOTAL', 'bigint', 'false',  '0'),
    ('BUFFER_GETS_DELTA', 'bigint', 'false',  '0'),
    ('ELAPSED_TIME_TOTAL', 'bigint', 'false',  '0'),
    ('ELAPSED_TIME_DELTA', 'bigint', 'false',  '0'),
    ('CPU_TIME_TOTAL', 'bigint', 'false',  '0'),
    ('CPU_TIME_DELTA', 'bigint', 'false',  '0'),
    ('CCWAIT_TOTAL', 'bigint', 'false',  '0'),
    ('CCWAIT_DELTA', 'bigint', 'false',  '0'),
    ('USERIO_WAIT_TOTAL', 'bigint', 'false',  '0'),
    ('USERIO_WAIT_DELTA', 'bigint', 'false',  '0'),
    ('APWAIT_TOTAL', 'bigint', 'false',  '0'),
    ('APWAIT_DELTA', 'bigint', 'false',  '0'),
    ('PHYSICAL_READ_REQUESTS_TOTAL', 'bigint', 'false',  '0'),
    ('PHYSICAL_READ_REQUESTS_DELTA', 'bigint', 'false',  '0'),
    ('PHYSICAL_READ_BYTES_TOTAL', 'bigint', 'false',  '0'),
    ('PHYSICAL_READ_BYTES_DELTA', 'bigint', 'false',  '0'),
    ('WRITE_THROTTLE_TOTAL', 'bigint', 'false',  '0'),
    ('WRITE_THROTTLE_DELTA', 'bigint', 'false',  '0'),
    ('ROWS_PROCESSED_TOTAL', 'bigint', 'false',  '0'),
    ('ROWS_PROCESSED_DELTA', 'bigint', 'false',  '0'),
    ('MEMSTORE_READ_ROWS_TOTAL', 'bigint', 'false',  '0'),
    ('MEMSTORE_READ_ROWS_DELTA', 'bigint', 'false',  '0'),
    ('MINOR_SSSTORE_READ_ROWS_TOTAL', 'bigint', 'false',  '0'),
    ('MINOR_SSSTORE_READ_ROWS_DELTA', 'bigint', 'false',  '0'),
    ('MAJOR_SSSTORE_READ_ROWS_TOTAL', 'bigint', 'false',  '0'),
    ('MAJOR_SSSTORE_READ_ROWS_DELTA', 'bigint', 'false',  '0'),
    ('RPC_TOTAL', 'bigint', 'false',  '0'),
    ('RPC_DELTA', 'bigint', 'false',  '0'),
    ('FETCHES_TOTAL', 'bigint', 'false',  '0'),
    ('FETCHES_DELTA', 'bigint', 'false',  '0'),
    ('RETRY_TOTAL', 'bigint', 'false',  '0'),
    ('RETRY_DELTA', 'bigint', 'false',  '0'),
    ('PARTITION_TOTAL', 'bigint', 'false',  '0'),
    ('PARTITION_DELTA', 'bigint', 'false',  '0'),
    ('NESTED_SQL_TOTAL', 'bigint', 'false',  '0'),
    ('NESTED_SQL_DELTA', 'bigint', 'false',  '0'),
    ('SOURCE_IP', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('SOURCE_PORT', 'int'),
    ('ROUTE_MISS_TOTAL', 'bigint', 'false',  '0'),
    ('ROUTE_MISS_DELTA', 'bigint', 'false',  '0'),
    ('FIRST_LOAD_TIME', 'timestamp', 'true'),
    ('PLAN_CACHE_HIT_TOTAL', 'bigint', 'false', '0'),
    ('PLAN_CACHE_HIT_DELTA', 'bigint', 'false', '0'),
  ],
  partition_columns = ['SVR_IP', 'SVR_PORT'],
  vtable_route_policy = 'distributed',
)
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12446',
  table_name = '__all_virtual_wr_sqlstat',
  in_tenant_space = True,
  keywords = all_def_keywords['__wr_sqlstat']))
def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12447',
  table_name = '__all_virtual_aux_stat',
  keywords = all_def_keywords['__all_aux_stat']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12448',
  table_name = '__all_virtual_detect_lock_info',
  keywords = all_def_keywords['__all_detect_lock_info'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12449',
  table_name = '__all_virtual_client_to_server_session_info',
  keywords = all_def_keywords['__all_client_to_server_session_info'],
  in_tenant_space = True))

def_table_schema(
  owner = 'linzhigang.lzg',
  table_name     = '__all_virtual_sys_variable_default_value',
  table_id       = '12450',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,
  normal_columns = [
  ('variable_name', 'varchar:OB_MAX_CONFIG_NAME_LEN', 'false', ''),
  ('default_value', 'varchar:OB_MAX_CONFIG_VALUE_LEN', 'true')
  ],
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12451',
  table_name = '__all_virtual_transfer_partition_task',
  keywords = all_def_keywords['__all_transfer_partition_task']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12452',
  table_name = '__all_virtual_transfer_partition_task_history',
  keywords = all_def_keywords['__all_transfer_partition_task_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12453',
  table_name = '__all_virtual_tenant_snapshot_job',
  keywords = all_def_keywords['__all_tenant_snapshot_job'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12454',
  table_name = '__all_virtual_wr_sqltext',
  in_tenant_space = True,
  keywords = all_def_keywords['__wr_sqltext']))

# 12455: __all_virtual_trusted_root_certificate_info
# 12456: __all_virtual_dbms_lock_allocated
# 12457: __all_virtual_shared_storage_compaction_info

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12456',
  table_name = '__all_virtual_dbms_lock_allocated',
  keywords = all_def_keywords['__all_dbms_lock_allocated']))

def_table_schema(
    owner = 'lixia.yq',
    table_name     = '__all_virtual_shared_storage_compaction_info',
    table_id       = '12457',
    table_type     = 'VIRTUAL_TABLE',
    gm_columns     = [],
    rowkey_columns = [],

    normal_columns = [
      ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
      ('svr_port', 'int'),
      ('tenant_id', 'int'),
      ('ls_id', 'int'),
      ('tablet_id', 'int'),
      ('obj_type', 'varchar:OB_MERGE_TYPE_STR_LENGTH'),
      ('last_refresh_time', 'timestamp'),
      ('info', 'varchar:OB_MAX_VARCHAR_LENGTH')
    ],
    partition_columns = ['svr_ip', 'svr_port'],
    vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'wendongbodongbo.wd',
  table_name     = '__all_virtual_ls_snapshot',
  table_id       = '12458',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [],
  in_tenant_space = True,
  normal_columns = [
    ('tenant_id', 'int'),
    ('snapshot_id', 'int'),
    ('ls_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('meta_existed', 'bool'),
    ('build_status', 'varchar:32', 'true'),
    ('rebuild_seq_start', 'int', 'true'),
    ('rebuild_seq_end', 'int', 'true'),
    ('end_interval_scn', 'int', 'true'),
    ('ls_meta_package', 'longtext', 'true'),
    ('tsnap_is_running', 'bool', 'true'),
    ('tsnap_has_unfinished_create_dag', 'bool', 'true'),
    ('tsnap_has_unfinished_gc_dag', 'bool', 'true'),
    ('tsnap_clone_ref', 'int', 'true'),
    ('tsnap_meta_existed', 'bool', 'true'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed'
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12459',
  table_name = '__all_virtual_index_usage_info',
  keywords = all_def_keywords['__all_index_usage_info']))

# 12460: __all_virtual_audit_log_filter
# 12461: __all_virtual_audit_log_user
def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12460',
  table_name = '__all_virtual_audit_log_filter',
  keywords = all_def_keywords['__all_audit_log_filter']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12461',
  table_name = '__all_virtual_audit_log_user',
  keywords = all_def_keywords['__all_audit_log_user']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12462',
  table_name = '__all_virtual_column_privilege',
  keywords = all_def_keywords['__all_column_privilege']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12463',
  table_name = '__all_virtual_column_privilege_history',
  keywords = all_def_keywords['__all_column_privilege_history']))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12464',
  table_name = '__all_virtual_tenant_snapshot_ls_replica_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_tenant_snapshot_ls_replica_history']))

# 12466: enabled_roles

def_table_schema(
  owner             = 'zz412656',
  table_name        = '__all_virtual_shared_storage_quota',
  table_id          = '12465',
  table_type        = 'VIRTUAL_TABLE',
  gm_columns        = [],
  rowkey_columns    = [
    ('svr_ip',              'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port',            'int'),
    ('module',              'varchar:32'),
    ('class_id',            'int'),
    ('storage_id',          'int'),
    ('type',                'varchar:32')
  ],
  in_tenant_space   = True,
  normal_columns    = [
    ('requirement',         'int'),
    ('assign',              'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'jim.wjh',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'ENABLED_ROLES',
  table_id       = '12466',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
  ('ROLE_NAME', 'varchar:OB_MAX_SYS_PARAM_NAME_LENGTH', 'true', 'NULL'),
  ('ROLE_HOST', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH', 'true', 'NULL'),
  ('IS_DEFAULT', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH', 'true', 'NULL'),
  ('IS_MANDATORY', 'varchar:OB_MAX_SYS_PARAM_VALUE_LENGTH', 'false', ''),
  ],
)

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12467',
  table_name = '__all_virtual_ls_replica_task_history',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_ls_replica_task_history']))

def_table_schema(
  owner = 'gongyusen.gys',
  table_name     = '__all_virtual_session_ps_info',
  table_id       = '12468',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  enable_column_def_enum = True,
  in_tenant_space = True,
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('proxy_session_id', 'uint'),
    ('session_id', 'uint'),
    ('ps_client_stmt_id', 'int'),
    ('ps_inner_stmt_id', 'int'),
    ('stmt_type', 'varchar:256'),
    ('param_count', 'int'),
    ('param_types', 'longtext'),
    ('ref_count', 'int'),
    ('checksum', 'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'fy373789',
  tablegroup_id = 'OB_INVALID_ID',
  table_name    = '__all_virtual_tracepoint_info',
  table_id      = '12469',
  table_type = 'VIRTUAL_TABLE',
  gm_columns    = [],
  in_tenant_space = True,
  rowkey_columns = [],

  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tp_no', 'int'),
    ('tp_name', 'varchar:OB_MAX_TRACEPOINT_NAME_LEN'),
    ('tp_describe', 'varchar:OB_MAX_TRACEPOINT_DESCRIBE_LEN'),
    ('tp_frequency', 'int'),
    ('tp_error_code', 'int'),
    ('tp_occur', 'int'),
    ('tp_match', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12470: __all_virtual_ls_compaction_status
# 12471: __all_virtual_tablet_compaction_status

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12472',
  table_name = '__all_virtual_tablet_checksum_error_info',
  keywords = all_def_keywords['__all_tablet_checksum_error_info'],
  in_tenant_space = True))


def_table_schema(
  owner = 'sean.yyj',
  table_name = '__all_virtual_compatibility_control',
  table_id = '12473',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [],
  normal_columns = [
    ('tenant_id', 'int'),
    ('name', 'varchar:OB_MAX_CONFIG_NAME_LEN'),
    ('description', 'varchar:OB_MAX_CONFIG_INFO_LEN'),
    ('is_enable', 'bool'),
    ('enable_versions', 'longtext'),
  ],
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12474',
  table_name = '__all_virtual_user_proxy_info',
  keywords = all_def_keywords['__all_user_proxy_info']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12475',
  table_name = '__all_virtual_user_proxy_info_history',
  keywords = all_def_keywords['__all_user_proxy_info_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12476',
  table_name = '__all_virtual_user_proxy_role_info',
  keywords = all_def_keywords['__all_user_proxy_role_info']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12477',
  table_name = '__all_virtual_user_proxy_role_info_history',
  keywords = all_def_keywords['__all_user_proxy_role_info_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12478',
  table_name = '__all_virtual_tablet_reorganize_history',
  keywords = all_def_keywords['__all_tablet_reorganize_history']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12479',
  table_name = '__all_virtual_res_mgr_directive',
  keywords = all_def_keywords['__all_res_mgr_directive'],
  in_tenant_space = True))

def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12480',
  table_name = '__all_virtual_service',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_service']))

def_table_schema(
  owner = 'yanyuan.cxf',
  table_name     = '__all_virtual_tenant_resource_limit',
  table_id       = '12481',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  in_tenant_space = True,
  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('zone', 'varchar:MAX_ZONE_LENGTH'),
  ('resource_name', 'varchar:MAX_RESOURCE_NAME_LEN'),
  ('current_utilization', 'bigint'),
  ('max_utilization', 'bigint'),
  ('reserved_value', 'bigint'),
  ('limit_value', 'bigint'),
  ('effective_limit_type', 'varchar:MAX_CONSTRAINT_NAME_LEN'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner = 'yanyuan.cxf',
  table_name     = '__all_virtual_tenant_resource_limit_detail',
  table_id       = '12482',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  in_tenant_space = True,
  normal_columns = [
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('tenant_id', 'int'),
  ('resource_name', 'varchar:MAX_RESOURCE_NAME_LEN'),
  ('limit_type', 'varchar:MAX_CONSTRAINT_NAME_LEN'),
  ('limit_value', 'bigint'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner      = 'wyh329796',
  table_name = '__all_virtual_group_io_stat',
  table_id = '12483',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  in_tenant_space = True,
  rowkey_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('group_id', 'int')
  ],
  normal_columns = [
    ('group_name', 'varchar:OB_MAX_RESOURCE_PLAN_NAME_LENGTH'),
    ('mode', 'varchar:OB_MAX_RESOURCE_PLAN_NAME_LENGTH'),
    ('min_iops', 'int'),
    ('max_iops', 'int'),
    ('real_iops', 'int'),
    ('max_net_bandwidth', 'int'),
    ('max_net_bandwidth_display', 'varchar:128'),
    ('real_net_bandwidth', 'int'),
    ('real_net_bandwidth_display', 'varchar:128'),
    ('norm_iops', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12484: __all_virtual_res_mgr_consumer_group
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12485',
  table_name = '__all_virtual_storage_io_usage',
  keywords = all_def_keywords['__all_storage_io_usage'],
  in_tenant_space = True))
def_table_schema(**gen_mysql_sys_agent_virtual_table_def('12486', all_def_keywords['__all_zone_storage']))

def_table_schema(
  owner             = 'gengfu.zpc',
  table_name        = '__all_virtual_nic_info',
  table_id          = '12487',
  table_type        = 'VIRTUAL_TABLE',
  in_tenant_space   = True,
  gm_columns        = [],
  rowkey_columns    = [],
  normal_columns    = [
    ('svr_ip',    'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port',  'int'),
    ('devname',   'varchar:MAX_IFNAME_LENGTH'),
    ('speed_Mbps', 'int')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12488',
  table_name = '__all_virtual_scheduler_job_run_detail_v2',
  keywords = all_def_keywords['__all_scheduler_job_run_detail_v2']))

# 12489: __all_virtual_deadlock_detector_stat
def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12490',
  table_name = '__all_virtual_spatial_reference_systems',
  keywords = all_def_keywords['__all_spatial_reference_systems']))

def_table_schema(
  owner = 'wenyue.zxl',
  table_name     = '__all_virtual_log_transport_dest_stat',
  table_id       = '12491',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [
  ],

  in_tenant_space = True,
  normal_columns = [
  ('tenant_id', 'int'),
  ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('svr_port', 'int'),
  ('ls_id', 'int'),
  ('client_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
  ('client_pid', 'int'),
  ('client_tenant_id', 'int'),
  ('client_type', 'int'),
  ('start_serve_time', 'timestamp'),
  ('last_serve_time', 'timestamp'),
  ('last_read_source', 'int'),
  ('last_request_type', 'int'),
  ('last_request_log_lsn', 'uint'),
  ('last_request_log_scn', 'uint'),
  ('last_failed_request', 'longtext'),
  ('avg_request_process_time', 'int'),
  ('avg_request_queue_time', 'int'),
  ('avg_request_read_log_time', 'int'),
  ('avg_request_read_log_size', 'int'),
  ('avg_log_transport_bandwidth', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner             = 'donglou.zl',
  table_name        = '__all_virtual_ss_local_cache_info',
  table_id          = '12492',
  table_type        = 'VIRTUAL_TABLE',
  in_tenant_space   = True,
  gm_columns        = [],
  rowkey_columns    = [],
  normal_columns    = [
    ('svr_ip',    'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port',  'int'),
    ('tenant_id', 'int'),
    ('cache_name', 'varchar:128'),
    ('priority', 'bigint'),
    ('hit_ratio', 'number:38:3'),
    ('total_hit_cnt', 'bigint'),
    ('total_hit_bytes', 'bigint'),
    ('total_miss_cnt', 'bigint'),
    ('total_miss_bytes', 'bigint'),
    ('hold_size', 'bigint'),
    ('alloc_disk_size', 'bigint'),
    ('used_disk_size', 'bigint'),
    ('used_mem_size', 'bigint'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(
  owner      = 'wuguangxin.wgx',
  table_name = '__all_virtual_kv_group_commit_status',
  table_id = '12493',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('group_type', 'varchar:32'),
    ('ls_id', 'int'),
    ('table_id', 'int'),
    ('schema_version', 'int'),
    ('queue_size', 'int'),
    ('batch_size', 'int'),
    ('create_time', 'timestamp'),
    ('update_time', 'timestamp'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)
# 12494: __all_virtual_session_sys_variable
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12495',
  table_name = '__all_virtual_spm_evo_result',
  in_tenant_space = True,
  keywords = all_def_keywords['__all_spm_evo_result']))

def_table_schema(
  owner = 'huhaosheng.hhs',
  table_name     = '__all_virtual_vector_index_info',
  table_id       = '12496',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  in_tenant_space = True,
  rowkey_columns = [
  ],

  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('ls_id', 'int'),
    ('rowkey_vid_table_id', 'int'),
    ('vid_rowkey_table_id', 'int'),
    ('inc_index_table_id', 'int'),
    ('vbitmap_table_id', 'int'),
    ('snapshot_index_table_id', 'int'),
    ('data_table_id', 'int'),
    ('rowkey_vid_tablet_id', 'int'),
    ('vid_rowkey_tablet_id', 'int'),
    ('inc_index_tablet_id', 'int'),
    ('vbitmap_tablet_id', 'int'),
    ('snapshot_index_tablet_id', 'int'),
    ('data_tablet_id', 'int'),
    # memory usage, status..., logic_version
    ('statistics', 'varchar:MAX_COLUMN_COMMENT_LENGTH'),
    # sync snapshot...
    ('sync_info', 'varchar:OB_INNER_TABLE_DEFAULT_KEY_LENTH')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12497',
  table_name = '__all_virtual_pkg_type',
  keywords = all_def_keywords['__all_pkg_type']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12498',
  table_name = '__all_virtual_pkg_type_attr',
  keywords = all_def_keywords['__all_pkg_type_attr']))

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12499',
  table_name = '__all_virtual_pkg_coll_type',
  keywords = all_def_keywords['__all_pkg_coll_type']))

def_table_schema(
  owner      = 'wuguangxin.wgx',
  table_name = '__all_virtual_kv_client_info',
  table_id = '12500',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  in_tenant_space = True,
  rowkey_columns = [],
  normal_columns = [
    ('client_id', 'uint'),
    ('client_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('client_port', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('tenant_id', 'int'),
    ('user_name', 'varchar:OB_MAX_USER_NAME_LENGTH'),
    ('first_login_ts', 'timestamp'),
    ('last_login_ts', 'timestamp'),
    ('client_info', 'varchar:2048')
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)
def_table_schema(**gen_iterate_private_virtual_table_def(
  table_id = '12501',
  table_name = '__all_virtual_wr_sql_plan',
  in_tenant_space = True,
  keywords = all_def_keywords['__wr_sql_plan']))
# 12502: __all_virtual_wr_res_mgr_sysstat

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12503',
  table_name = '__all_virtual_kv_redis_table',
  keywords = all_def_keywords['__all_kv_redis_table']))

def_table_schema(
  owner             = 'zz412656',
  table_name        = '__all_virtual_function_io_stat',
  table_id          = '12504',
  table_type        = 'VIRTUAL_TABLE',
  gm_columns        = [],
  rowkey_columns    = [
    ('svr_ip',              'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port',            'int'),
    ('tenant_id',           'int'),
    ('function_name',       'varchar:32'),
    ('mode',                'varchar:32')
  ],
  in_tenant_space   = True,
  normal_columns    = [
    ('size',                'int'),
    ('real_iops',           'int'),
    ('real_mbps',           'int'),
    ('schedule_us',         'int'),
    ('io_delay_us',         'int'),
    ('total_us',            'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)


def_table_schema(
  owner = 'wuyuefei.wyf',
  table_name     = '__all_virtual_temp_file',
  table_id       = '12505',
  table_type = 'VIRTUAL_TABLE',
  gm_columns     = [],
  rowkey_columns = [],
  in_tenant_space = True,

  normal_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('file_id', 'int'),
    ('trace_id', 'varchar:OB_MAX_TRACE_ID_BUFFER_SIZE',  'true', ''),
    ('dir_id', 'int'),
    ('data_bytes', 'int'),
    ('start_offset', 'int'),
    ('is_deleting', 'bool'),
    ('cached_data_page_num', 'int'),
    ('write_back_data_page_num', 'int'),
    ('flushed_data_page_num', 'int'),
    ('ref_cnt', 'int'),
    ('total_writes', 'int'),
    ('unaligned_writes', 'int'),
    ('total_reads', 'int'),
    ('unaligned_reads', 'int'),
    ('total_read_bytes', 'int'),
    ('last_access_time', 'timestamp'),
    ('last_modify_time', 'timestamp'),
    ('birth_time', 'timestamp'),
    ('file_ptr', 'varchar:20'),
    ('file_label', 'varchar:16', 'true', ''),
    ('meta_tree_epoch', 'int'),
    ('meta_tree_levels', 'int'),
    ('meta_bytes', 'int'),
    ('cached_meta_page_num', 'int'),
    ('write_back_meta_page_num', 'int'),
    ('page_flush_cnt', 'int'),
    ('type', 'int'),
    ('compressible_fd', 'int'),
    ('persisted_tail_page_writes', 'int'),
    ('lack_page_cnt', 'int'),
    ('total_truncated_page_read_cnt', 'int'),
    ('truncated_page_hits', 'int'),
    ('total_kv_cache_page_read_cnt', 'int'),
    ('kv_cache_page_read_hits', 'int'),
    ('total_uncached_page_read_cnt', 'int'),
    ('uncached_page_hits', 'int'),
    ('aggregate_read_io_cnt', 'int'),
    ('total_wbp_page_read_cnt', 'int'),
    ('wbp_page_hits', 'int'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

def_table_schema(**gen_iterate_virtual_table_def(
  table_id = '12506',
  table_name = '__all_virtual_ncomp_dll_v2',
  keywords = all_def_keywords['__all_ncomp_dll_v2']))
# 12507: __all_virtual_logstore_service_status
# 12508: __all_virtual_logstore_service_info
# 12509: __all_virtual_object_balance_weight
# 12510: __all_virtual_standby_log_transport_stat
# 12511: __all_virtual_wr_sql_plan_aux_key2snapshot
# 12512: __all_virtual_tablet_mds_info

def_table_schema(
  owner = 'ouyanghongrong.oyh',
  table_name    = '__all_virtual_cs_replica_tablet_stats',
  table_id      = '12513',
  table_type = 'VIRTUAL_TABLE',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space=True,
  normal_columns = [
    ('tenant_id', 'int'),
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('ls_id', 'int'),
    ('tablet_id', 'int'),
    ('macro_block_cnt', 'int'),
    ('is_cs', 'bool'),
    ('is_cs_replica', 'bool'),
    ('available', 'bool'),
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed',
)

# 12514: __all_virtual_ddl_diagnose_info
def_table_schema(
  owner = 'buming.lj',
  table_name    = '__all_virtual_ddl_diagnose_info',
  table_id      = '12514',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns    = [],
  rowkey_columns = [],
  normal_columns = [
    ('tenant_id', 'int'),
    ('ddl_task_id','int'),
    ('object_table_id','int'),
    ('opname', 'varchar:OB_MAX_DDL_ID_STR_LENGTH'),
    ('create_time', 'timestamp'),
    ('finish_time', 'timestamp'),
    ('diagnose_info', 'varchar:OB_DIAGNOSE_INFO_LENGTH'),
  ],
  vtable_route_policy = 'only_rs',
  index = {'all_virtual_ddl_diagnose_info_i1' : { 'index_columns' : ['ddl_task_id'],
                    'index_using_type' : 'USING_HASH'}},
)

# 12515: __all_virtual_plugin_info
def_table_schema(
  owner = 'wangyunlai.wyl',
  table_name = '__all_virtual_plugin_info',
  table_id   = '12515',
  table_type = 'VIRTUAL_TABLE',
  in_tenant_space = True,
  gm_columns = [],
  rowkey_columns = [
  ],
  normal_columns = [
    ('svr_ip', 'varchar:MAX_IP_ADDR_LENGTH'),
    ('svr_port', 'int'),
    ('name', 'varchar:64', 'true', 'NULL'),               # true means nullable and NULL is the default value
    ('status', 'varchar:64', 'true', 'NULL'),             # 插件状态：READY, UNINIT, DEAD
    ('type', 'varchar:80', 'true', 'NULL'),               # 插件类型，比如分词器
    ('library', 'varchar:128', 'true', 'NULL'),           # 插件动态链接库名称（内置插件没有对应链接库）
    ('library_version', 'varchar:80', 'true', 'NULL'),    # 插件库自身的版本
    ('library_revision', 'varchar:80', 'true', 'NULL'),   # 插件库修订版本，比如 git commit id
    ('interface_version', 'varchar:80', 'true', 'NULL'),  # 该插件实现的具体接口API版本
    ('author', 'varchar:64', 'true', 'NULL'),             # 插件作者信息
    ('license', 'varchar:64', 'true', 'NULL'),            # 插件LICENSE
    ('description', 'varchar:65535', 'true', 'NULL')      # 插件描述信息
  ],
  partition_columns = ['svr_ip', 'svr_port'],
  vtable_route_policy = 'distributed'
)

# 12516: __all_virtual_catalog
# 12517: __all_virtual_catalog_history
# 12518: __all_virtual_catalog_privilege
# 12519: __all_virtual_catalog_privilege_history

# 12520: __all_virtual_sswriter_group_stat
# 12521: __all_virtual_sswriter_lease_mgr

# 12522: __all_virtual_tenant_flashback_log_scn

# 余留位置（此行之前占位）
# 本区域占位建议：采用真实表名进行占位
################################################################################
# End of Mysql Virtual Table (10000, 15000]
################################################################################

################################### 占位须知 ###################################
# 占位示例: 顶格写注释，说明要占用哪个TABLE_ID，对应的名字是什么
# TABLE_ID: TABLE_NAME
#
# FARM 会基于占位校验开发分支TABLE_ID和TABLE_NAME是否匹配，如果不匹配，FARM就会拦截报错
#
# 注意：
# 0. 在‘余留位置’之前占位
# 1. 始终先在master占位，保证master分支是其他所有分支的超集，避免NAME和ID冲突
# 2. master占位之后，开发分支上不要变更NAME，否则FARM会认为ID占位冲突，如果有这种场景，需要先修改master占位
# 3. 默认建议采用准确的TABLE_NAME进行占位，TABLE_ID和TABLE_NAME在系统内部是一一对应的
# 4. 部分表是基于其他基表的schema定义的(例如：gen_xx_table_def())，其真实表名比较复杂，为了方便占位，建议采用基表表名进行占位
#    - 示例1：def_table_schema(**gen_mysql_sys_agent_virtual_table_def('12393', all_def_keywords['__all_virtual_long_ops_status']))
#      * 基表表名占位：# 12393: __all_virtual_long_ops_status
#      * 真实表名占位：# 12393: __all_virtual_virtual_long_ops_status_mysql_sys_agent
#    - 示例2：def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15009', all_def_keywords['__all_virtual_sql_audit'])))
#      * 基表表名占位：# 15009: __all_virtual_sql_audit
#      * 真实表名占位：# 15009: ALL_VIRTUAL_SQL_AUDIT
#    - 示例3：def_table_schema(**gen_sys_agent_virtual_table_def('15111', all_def_keywords['__all_routine_param']))
#      * 基表表名占位：# 15111: __all_routine_param
#      * 真实表名占位：# 15111: ALL_VIRTUAL_ROUTINE_PARAM_SYS_AGENT
# 5. 索引表占位要求TABLE_NAME采用以下方式：基表（数据表）表名、索引名(index_name)、真实的索引表表名
#    例如：100001 索引表占位方式可以为：
#       * # 100001: __idx_3_idx_data_table_id
#       * # 100001: idx_data_table_id
#       * # 100001: __all_table
################################################################################


################################################################################
# Oracle Virtual Table(15000,20000]
################################################################################
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15009', all_def_keywords['__all_virtual_sql_audit'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15010', all_def_keywords['__all_virtual_plan_stat'])))
# 15011: __all_virtual_sql_plan_statistics
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15012', all_def_keywords['__all_virtual_plan_cache_plan_explain'])))
def_table_schema(**gen_agent_virtual_table_def('15023', all_def_keywords['__tenant_virtual_outline']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15026', all_def_keywords['__all_virtual_privilege'])))
def_table_schema(**gen_agent_virtual_table_def('15027', all_def_keywords['__all_virtual_sys_parameter_stat']))
def_table_schema(**gen_agent_virtual_table_def('15028', all_def_keywords['__tenant_virtual_table_index']))
def_table_schema(**gen_agent_virtual_table_def('15029', all_def_keywords['__tenant_virtual_charset']))
def_table_schema(**gen_agent_virtual_table_def('15030', all_def_keywords['__tenant_virtual_all_table']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15031', all_def_keywords['__tenant_virtual_collation'])))
def_table_schema(**gen_agent_virtual_table_def('15033', all_def_keywords['__all_server']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15034', all_def_keywords['__all_virtual_plan_cache_stat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15035', all_def_keywords['__all_virtual_processlist'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15036', all_def_keywords['__all_virtual_session_wait'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15037', all_def_keywords['__all_virtual_session_wait_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15038', all_def_keywords['__all_virtual_memory_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15039', all_def_keywords['__all_virtual_tenant_memstore_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15040', all_def_keywords['__all_virtual_memstore_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15042', all_def_keywords['__all_virtual_sesstat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15043', all_def_keywords['__all_virtual_sysstat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15044', all_def_keywords['__all_virtual_system_event'])))

def_table_schema(**gen_oracle_mapping_virtual_table_def('15046', all_def_keywords['__tenant_virtual_session_variable']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15047', all_def_keywords['__tenant_virtual_global_variable']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15048', all_def_keywords['__tenant_virtual_show_create_table']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15049', all_def_keywords['__tenant_virtual_show_create_procedure']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15050', all_def_keywords['__tenant_virtual_show_create_tablegroup']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15051', all_def_keywords['__tenant_virtual_privilege_grant']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15052', all_def_keywords['__tenant_virtual_table_column']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15053', all_def_keywords['__all_virtual_trace_span_info']))

def_table_schema(**gen_agent_virtual_table_def('15054',all_def_keywords['__tenant_virtual_concurrent_limit_sql']))

def_table_schema(**gen_oracle_mapping_virtual_table_def('15060', all_def_keywords['__all_virtual_data_type']))

def_table_schema(**gen_oracle_mapping_virtual_table_def('15077', all_def_keywords['__all_virtual_audit_operation']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15078', all_def_keywords['__all_virtual_audit_action']))

def_table_schema(**gen_oracle_mapping_virtual_table_def('15080', all_def_keywords['__all_virtual_px_worker_stat']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15081', all_def_keywords['__all_virtual_ps_stat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15082', all_def_keywords['__all_virtual_ps_item_info'])))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15083', all_def_keywords['__all_virtual_tenant_parameter_stat']))

## sql workarea
def_table_schema(**gen_oracle_mapping_virtual_table_def('15084', all_def_keywords['__all_virtual_sql_workarea_history_stat']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15085', all_def_keywords['__all_virtual_sql_workarea_active']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15086', all_def_keywords['__all_virtual_sql_workarea_histogram']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15087', all_def_keywords['__all_virtual_sql_workarea_memory_info']))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15094', all_def_keywords['__all_virtual_table_mgr'])))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15097', all_def_keywords['__all_virtual_server_schema_info'])))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15100', all_def_keywords['__all_virtual_sql_plan_monitor'])))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15101', all_def_keywords['__all_virtual_sql_monitor_statname']))

def_table_schema(**gen_oracle_mapping_virtual_table_def('15102', all_def_keywords['__all_virtual_lock_wait_stat']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15103', all_def_keywords['__all_virtual_open_cursor']))

def_table_schema(**gen_oracle_mapping_virtual_table_def('15110', all_def_keywords['__tenant_virtual_object_definition']))

def_table_schema(**gen_sys_agent_virtual_table_def('15111', all_def_keywords['__all_routine_param']))
def_table_schema(**gen_sys_agent_virtual_table_def('15112', all_def_keywords['__all_type']))
def_table_schema(**gen_sys_agent_virtual_table_def('15113', all_def_keywords['__all_type_attr']))
def_table_schema(**gen_sys_agent_virtual_table_def('15114', all_def_keywords['__all_coll_type']))
def_table_schema(**gen_sys_agent_virtual_table_def('15115', all_def_keywords['__all_package']))
def_table_schema(**gen_sys_agent_virtual_table_def('15116', all_def_keywords['__all_tenant_trigger']))
def_table_schema(**gen_sys_agent_virtual_table_def('15117', all_def_keywords['__all_routine']))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15118', all_def_keywords['__all_virtual_global_transaction'])))
# 15119: __all_acquired_snapshot

## define oracle virtual table that is mapping real table
## real table must has in_tenant_space=True if use gen_oracle_mapping_real_virtual_table_def
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15120', all_def_keywords['__all_table']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15121', all_def_keywords['__all_column']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15122', all_def_keywords['__all_database']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15123', all_def_keywords['__all_auto_increment']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15124', all_def_keywords['__all_part']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15125', all_def_keywords['__all_sub_part']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15126', all_def_keywords['__all_package']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15127', all_def_keywords['__all_sequence_value']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15128', all_def_keywords['__all_sequence_object']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15129', all_def_keywords['__all_user']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15130', all_def_keywords['__all_synonym']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15131', all_def_keywords['__all_foreign_key']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15135', all_def_keywords['__all_recyclebin']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15136', all_def_keywords['__all_routine']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15137', all_def_keywords['__all_tablegroup']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15138', all_def_keywords['__all_foreign_key_column']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15139', all_def_keywords['__all_constraint']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15140', all_def_keywords['__all_type']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15141', all_def_keywords['__all_type_attr']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15142', all_def_keywords['__all_coll_type']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15143', all_def_keywords['__all_routine_param']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15145', all_def_keywords['__all_tenant_keystore']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15146', all_def_keywords['__all_tenant_ols_policy']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15147', all_def_keywords['__all_tenant_ols_component']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15148', all_def_keywords['__all_tenant_ols_label']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15149', all_def_keywords['__all_tenant_ols_user_level']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15150', all_def_keywords['__all_tenant_tablespace']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15151', all_def_keywords['__all_tenant_profile']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15152', all_def_keywords['__all_tenant_role_grantee_map']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15153', all_def_keywords['__all_table_privilege']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15154', all_def_keywords['__all_tenant_security_audit']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15156', all_def_keywords['__all_tenant_trigger']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15157', all_def_keywords['__all_tenant_security_audit_record']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15158', all_def_keywords['__all_tenant_sysauth']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15160', all_def_keywords['__all_tenant_objauth']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15162', all_def_keywords['__all_tenant_error']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15163', all_def_keywords['__all_def_sub_part']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15164', all_def_keywords['__all_tenant_object_type']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15165', all_def_keywords['__all_dblink']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15167', all_def_keywords['__all_tenant_constraint_column']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15168', all_def_keywords['__all_tenant_dependency']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15170', all_def_keywords['__all_tenant_time_zone']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15171', all_def_keywords['__all_tenant_time_zone_name']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15172', all_def_keywords['__all_tenant_time_zone_transition']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15173', all_def_keywords['__all_tenant_time_zone_transition_type']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15174', all_def_keywords['__all_res_mgr_plan']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15175', all_def_keywords['__all_res_mgr_directive']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15176', all_def_keywords['__all_virtual_trans_lock_stat']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15177', all_def_keywords['__all_res_mgr_mapping_rule']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15178', all_def_keywords['__all_virtual_tablet_encrypt_info'])))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15179', all_def_keywords['__all_res_mgr_consumer_group']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15181', all_def_keywords['__all_column_usage']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15183', all_def_keywords['__all_job']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15184', all_def_keywords['__all_job_log']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15185', all_def_keywords['__all_tenant_directory']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15186', all_def_keywords['__all_table_stat']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15187', all_def_keywords['__all_column_stat']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15188', all_def_keywords['__all_histogram_stat']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15189', all_def_keywords['__all_virtual_tenant_memory_info'])))
# 15190: __all_virtual_partition_item # abandoned in 4.0
def_table_schema(**gen_oracle_mapping_virtual_table_def('15191', all_def_keywords['__tenant_virtual_show_create_trigger']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15192', all_def_keywords['__all_virtual_px_target_monitor'])))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15193', all_def_keywords['__all_monitor_modified']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15194', all_def_keywords['__all_table_stat_history']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15195', all_def_keywords['__all_column_stat_history']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15196', all_def_keywords['__all_histogram_stat_history']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15197', all_def_keywords['__all_optstat_global_prefs']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15198', all_def_keywords['__all_optstat_user_prefs']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15199', all_def_keywords['__all_virtual_dblink_info']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15200', all_def_keywords['__all_dam_last_arch_ts']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15201', all_def_keywords['__all_dam_cleanup_jobs']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15202', all_def_keywords['__all_tenant_scheduler_job']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15203', all_def_keywords['__all_tenant_scheduler_program']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15204', all_def_keywords['__all_context']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15205', all_def_keywords['__all_virtual_global_context_value'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15206', all_def_keywords['__all_virtual_trans_stat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15207', all_def_keywords['__all_virtual_unit'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15208', all_def_keywords['__all_virtual_kvcache_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15209', all_def_keywords['__all_virtual_server_compaction_progress'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15210', all_def_keywords['__all_virtual_tablet_compaction_progress'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15211', all_def_keywords['__all_virtual_compaction_diagnose_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15212', all_def_keywords['__all_virtual_compaction_suggestion'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15213', all_def_keywords['__all_virtual_tablet_compaction_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15214', all_def_keywords['__all_virtual_ls_meta_table'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15215', all_def_keywords['__all_tablet_to_ls'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15216', all_def_keywords['__all_virtual_tablet_meta_table'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15217', all_def_keywords['__all_virtual_core_all_table'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15218', all_def_keywords['__all_virtual_core_column_table'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15219', all_def_keywords['__all_virtual_dtl_interm_result_monitor'])))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15220', all_def_keywords['__all_virtual_proxy_schema']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15221', all_def_keywords['__all_virtual_proxy_partition']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15222', all_def_keywords['__all_virtual_proxy_partition_info']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15223', all_def_keywords['__all_virtual_proxy_sub_partition']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15224', all_def_keywords['__all_virtual_zone_merge_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15225', all_def_keywords['__all_virtual_merge_info'])))
def_table_schema(**no_direct_access(gen_sys_agent_virtual_table_def('15226', all_def_keywords['__all_tenant_object_type'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15227', all_def_keywords['__all_virtual_backup_job'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15228', all_def_keywords['__all_virtual_backup_job_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15229', all_def_keywords['__all_virtual_backup_task'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15230', all_def_keywords['__all_virtual_backup_task_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15231', all_def_keywords['__all_virtual_backup_set_files'])))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15232', all_def_keywords['__all_plan_baseline']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15233', all_def_keywords['__all_plan_baseline_item']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15234', all_def_keywords['__all_spm_config']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15235', all_def_keywords['__tenant_virtual_event_name'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15236', all_def_keywords['__all_virtual_ash'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15237', all_def_keywords['__all_virtual_dml_stats'])))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15238', all_def_keywords['__all_virtual_log_archive_dest_parameter'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15239', all_def_keywords['__all_virtual_log_archive_progress'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15240', all_def_keywords['__all_virtual_log_archive_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15241', all_def_keywords['__all_virtual_log_archive_piece_files'])))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15242', all_def_keywords['__all_virtual_ls_log_archive_progress']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15243', all_def_keywords['__all_virtual_backup_parameter'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15244', all_def_keywords['__all_virtual_restore_job'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15245', all_def_keywords['__all_virtual_restore_job_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15246', all_def_keywords['__all_virtual_restore_progress'])))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15247', all_def_keywords['__all_virtual_ls_restore_progress']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15248', all_def_keywords['__all_virtual_ls_restore_history']))

def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15249', all_def_keywords['__all_outline'])))

def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15250', all_def_keywords['__all_outline_history'])))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15251', all_def_keywords['__all_virtual_backup_storage_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15252', all_def_keywords['__all_virtual_backup_storage_info_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15253', all_def_keywords['__all_virtual_backup_delete_job'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15254', all_def_keywords['__all_virtual_backup_delete_job_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15255', all_def_keywords['__all_virtual_backup_delete_task'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15256', all_def_keywords['__all_virtual_backup_delete_task_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15257', all_def_keywords['__all_virtual_backup_delete_policy'])))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15258', all_def_keywords['__all_virtual_deadlock_event_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15259', all_def_keywords['__all_virtual_log_stat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15260', all_def_keywords['__all_virtual_replay_stat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15261', all_def_keywords['__all_virtual_apply_stat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15262', all_def_keywords['__all_virtual_archive_stat'])))

# 15263: __all_virtual_kv_ttl_task
# 15264: __all_virtual_kv_ttl_task_history
# 15265: __all_tenant_datafile
def_table_schema(**gen_oracle_mapping_virtual_table_def('15266', all_def_keywords['__all_virtual_ls_status']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15267', all_def_keywords['__all_virtual_ls_recovery_stat']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15268', all_def_keywords['__all_virtual_ls_election_reference_info']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15269', all_def_keywords['__all_virtual_tenant_info']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15270', all_def_keywords['__all_freeze_info']))
# 15271: abandoned
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15272', all_def_keywords['__all_virtual_ls_replica_task'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15273', all_def_keywords['__all_virtual_ls_replica_task_plan'])))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15274', all_def_keywords['__all_virtual_show_trace']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15275', all_def_keywords['__all_database_privilege']))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15276', all_def_keywords['__all_rls_policy'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15277', all_def_keywords['__all_rls_security_column'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15278', all_def_keywords['__all_rls_group'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15279', all_def_keywords['__all_rls_context'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15280', all_def_keywords['__all_rls_attribute'])))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15281', all_def_keywords['__all_tenant_rewrite_rules']))
def_table_schema(**no_direct_access(gen_sys_agent_virtual_table_def('15282', all_def_keywords['__all_tenant'])))

# 15283: abandoned

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15284', all_def_keywords['__all_virtual_sql_plan'])))
# 15285: abandoned
# 15286: abandoned
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15287', all_def_keywords['__all_virtual_trans_scheduler'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15288', all_def_keywords['__all_virtual_ls_arb_replica_task'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15289', all_def_keywords['__all_virtual_ls_arb_replica_task_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15290', all_def_keywords['__all_virtual_archive_dest_status'])))
# 15291: __all_virtual_backup_transferring_tablets

def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15292', all_def_keywords['__all_external_table_file']))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15293', all_def_keywords['__all_data_dictionary_in_log'])))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15294', all_def_keywords['__all_virtual_task_opt_stat_gather_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15295', all_def_keywords['__all_virtual_table_opt_stat_gather_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15296', all_def_keywords['__all_virtual_opt_stat_gather_monitor'])))
def_table_schema(**gen_sys_agent_virtual_table_def('15297', all_def_keywords['__all_virtual_long_ops_status']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15298', all_def_keywords['__all_virtual_thread'])))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15299', all_def_keywords['__all_virtual_wr_active_session_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15300', all_def_keywords['__all_virtual_wr_snapshot'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15301', all_def_keywords['__all_virtual_wr_statname'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15302', all_def_keywords['__all_virtual_wr_sysstat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15303', all_def_keywords['__all_virtual_arbitration_member_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15304', all_def_keywords['__all_virtual_arbitration_service_status'])))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15305', all_def_keywords['__all_virtual_obj_lock']))
#######################################################################
# oracle agent table index is defined after the System table Index area
#######################################################################
# 15306: idx_data_table_id_real_agent
# 15307: idx_db_tb_name_real_agent
# 15308: idx_tb_name_real_agent
# 15309: idx_tb_column_name_real_agent
# 15310: idx_column_name_real_agent
# 15311: idx_ur_name_real_agent
# 15312: idx_db_name_real_agent
# 15313: idx_tg_name_real_agent
# 15314: idx_recyclebin_db_type_real_agent
# 15315: idx_part_name_real_agent
# 15316: idx_sub_part_name_real_agent
# 15317: idx_def_sub_part_name_real_agent
# 15318: idx_fk_child_tid_real_agent
# 15319: idx_fk_parent_tid_real_agent
# 15320: idx_fk_name_real_agent
# 15321: idx_db_synonym_name_real_agent
# 15322: idx_synonym_name_real_agent
# 15323: idx_db_routine_name_real_agent
# 15324: idx_routine_name_real_agent
# 15325: idx_routine_pkg_id_real_agent
# 15326: idx_routine_param_name_real_agent
# 15327: idx_db_pkg_name_real_agent
# 15328: idx_pkg_name_real_agent
# 15329: idx_cst_name_real_agent
# 15330: idx_db_type_name_real_agent
# 15331: idx_type_name_real_agent
# 15332: idx_type_attr_name_real_agent
# 15333: idx_coll_name_type_real_agent
# 15334: idx_owner_dblink_name_real_agent
# 15335: idx_dblink_name_real_agent
# 15336: idx_grantee_role_id_real_agent
# 15337: idx_keystore_master_key_id_real_agent
# 15338: idx_ols_policy_name_real_agent
# 15339: idx_ols_policy_col_name_real_agent
# 15340: idx_ols_com_policy_id_real_agent
# 15341: idx_ols_lab_policy_id_real_agent
# 15342: idx_ols_lab_tag_real_agent
# 15343: idx_ols_lab_real_agent
# 15344: idx_ols_level_uid_real_agent
# 15345: idx_ols_level_policy_id_real_agent
# 15346: idx_profile_name_real_agent
# 15347: idx_audit_type_real_agent
# 15348: idx_trigger_base_obj_id_real_agent
# 15349: idx_db_trigger_name_real_agent
# 15350: idx_trigger_name_real_agent
# 15351: idx_objauth_grantor_real_agent
# 15352: idx_objauth_grantee_real_agent
# 15353: idx_obj_type_db_obj_name_real_agent
# 15354: idx_obj_type_obj_name_real_agent
# 15355: idx_dependency_ref_obj_real_agent
# 15356: idx_table_stat_his_savtime_real_agent
# 15357: idx_column_stat_his_savtime_real_agent
# 15358: idx_histogram_stat_his_savtime_real_agent
# 15359: idx_tablet_to_ls_id_real_agent
# 15360: idx_tablet_to_table_id_real_agent
# 15361: idx_ctx_namespace_real_agent
# 15362: idx_spm_item_sql_id_real_agent
# 15363: idx_spm_item_value_real_agent
# 15364: idx_directory_name_real_agent
# 15365: idx_job_powner_real_agent
# 15366: idx_seq_obj_db_name_real_agent
# 15367: idx_seq_obj_name_real_agent
# 15368: idx_recyclebin_ori_name_real_agent
# 15369: idx_tb_priv_db_name_real_agent
# 15370: idx_tb_priv_tb_name_real_agent
# 15371: idx_db_priv_db_name_real_agent
# 15372: idx_rls_policy_table_id_real_agent
# 15373: idx_rls_policy_group_id_real_agent
# 15374: idx_rls_group_table_id_real_agent
# 15375: idx_rls_context_table_id_real_agent


#######################################################################
# end for oracle agent table index
#######################################################################

def_table_schema(**gen_oracle_mapping_virtual_table_def('15376', all_def_keywords['__all_virtual_log_restore_source']))


def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15377', all_def_keywords['__all_balance_job'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15378', all_def_keywords['__all_balance_job_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15379', all_def_keywords['__all_balance_task'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15380', all_def_keywords['__all_balance_task_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15381', all_def_keywords['__all_transfer_task'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15382', all_def_keywords['__all_transfer_task_history'])))
def_table_schema(**no_direct_access(gen_sys_agent_virtual_table_def('15383', all_def_keywords['__all_resource_pool'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15384', all_def_keywords['__all_virtual_px_p2p_datahub'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15385', all_def_keywords['__all_virtual_timestamp_service'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15387', all_def_keywords['__all_virtual_ls_log_restore_status'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15388', all_def_keywords['__all_virtual_tenant_parameter'])))

def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15389', all_def_keywords['__all_mlog']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15390', all_def_keywords['__all_mview']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15391', all_def_keywords['__all_mview_refresh_stats_sys_defaults']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15392', all_def_keywords['__all_mview_refresh_stats_params']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15393', all_def_keywords['__all_mview_refresh_run_stats']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15394', all_def_keywords['__all_mview_refresh_stats']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15395', all_def_keywords['__all_mview_refresh_change_stats']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15396', all_def_keywords['__all_mview_refresh_stmt_stats']))

def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15397', all_def_keywords['__all_dbms_lock_allocated'])))
# 15397: __all_dbms_lock_allocated
# 15398: __all_virtual_wr_control
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15398', all_def_keywords['__all_virtual_wr_control'])))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15399', all_def_keywords['__all_virtual_tenant_event_history']))

# 15400: __all_virtual_balance_task_helper

# 15401: __all_virtual_data_activity_metrics

def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15402', all_def_keywords['__all_ls']))
# 15403: __all_virtual_flt_config
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15403', all_def_keywords['__all_virtual_flt_config'])))

def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15404', all_def_keywords['__all_tenant_scheduler_job_run_detail']))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15405', all_def_keywords['__all_virtual_session_info'])))

def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15406', all_def_keywords['__all_tenant_scheduler_job_class']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15407', all_def_keywords['__all_virtual_recover_table_job'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15408', all_def_keywords['__all_virtual_recover_table_job_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15409', all_def_keywords['__all_virtual_import_table_job'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15410', all_def_keywords['__all_virtual_import_table_job_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15411', all_def_keywords['__all_virtual_import_table_task'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15412', all_def_keywords['__all_virtual_import_table_task_history'])))
# 15413: __all_virtual_import_stmt_exec_history
def_table_schema(**gen_oracle_mapping_virtual_table_def('15414', all_def_keywords['__all_virtual_ls_info']))
# 15415: idx_dbms_lock_allocated_lockhandle_real_agent
# 15416: idx_dbms_lock_allocated_expiration_real_agent

# 15417: abandoned

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15418', all_def_keywords['__all_virtual_cgroup_config'])))

# 15419: abandoned
# 15420: abandoned
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15421', all_def_keywords['__all_virtual_wr_system_event'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15422', all_def_keywords['__all_virtual_wr_event_name'])))
# 15423: __all_virtual_tenant_scheduler_running_job
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15424', all_def_keywords['__all_virtual_sqlstat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15425', all_def_keywords['__all_virtual_wr_sqlstat'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15426', all_def_keywords['__tenant_virtual_statname'])))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15427', all_def_keywords['__all_aux_stat']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15428', all_def_keywords['__all_sys_variable']))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15429', all_def_keywords['__all_virtual_sys_variable_default_value']))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15430', all_def_keywords['__all_transfer_partition_task'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15431', all_def_keywords['__all_transfer_partition_task_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15432', all_def_keywords['__all_virtual_wr_sqltext'])))
# 15433: abandoned
# 15434: abandoned
# 15435: abandoned
# 15436: abandoned
# 15437: abandoned
# 15438: abandoned
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15439', all_def_keywords['__all_virtual_ls_snapshot'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15440', all_def_keywords['__all_index_usage_info'])))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15441', all_def_keywords['__all_virtual_shared_storage_quota'])))

# 余留位置
# 15442: __all_virtual_column_group
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15443', all_def_keywords['__all_virtual_ls_replica_task_history'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15444', all_def_keywords['__all_virtual_session_ps_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15445', all_def_keywords['__all_virtual_tracepoint_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15446', all_def_keywords['__all_user_proxy_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15447', all_def_keywords['__all_user_proxy_role_info'])))
# 15448: idx_user_proxy_info_proxy_user_id_real_agent
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15449', all_def_keywords['__all_virtual_service'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15450', all_def_keywords['__all_virtual_tenant_resource_limit'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15451', all_def_keywords['__all_virtual_tenant_resource_limit_detail'])))

# 15452: __all_virtual_group_io_stat
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15452', all_def_keywords['__all_virtual_group_io_stat'])))
# 15453: __all_storage_io_usage
# 15454: __all_virtual_storage_io_usage
# 15455: __all_zone_storage
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15454', all_def_keywords['__all_virtual_storage_io_usage'])))
def_table_schema(**no_direct_access(gen_sys_agent_virtual_table_def('15455', all_def_keywords['__all_zone_storage'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15456', all_def_keywords['__all_virtual_nic_info'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15457', all_def_keywords['__all_virtual_query_response_time'])))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15458', all_def_keywords['__all_scheduler_job_run_detail_v2']))
def_table_schema(**no_direct_access(gen_oracle_mapping_real_virtual_table_def('15459', all_def_keywords['__all_spatial_reference_systems'])))
# 15460: idx_scheduler_job_run_detail_v2_time_real_agent
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15461', all_def_keywords['__all_virtual_log_transport_dest_stat'])))

def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15462', all_def_keywords['__all_virtual_ss_local_cache_info'])))

# 15463: idx_scheduler_job_run_detail_v2_job_class_time_real_agent
# 15464: __all_virtual_kv_group_commit_status

# 15465: __all_virtual_session_sys_variable
def_table_schema(**gen_oracle_mapping_virtual_table_def('15466', all_def_keywords['__all_virtual_spm_evo_result']))
# 15467: __all_virtual_vector_index_info

# 15468: __all_pkg_type
# 15469: __all_pkg_type_attr
# 15470: __all_pkg_coll_type
# 15471: __all_pkg_type
# 15472: __all_pkg_type_attr
# 15473: __all_pkg_coll_type
# 15474: __all_pkg_type
# 15475: __all_pkg_type
# 15476: __all_pkg_type_attr
# 15477: __all_pkg_type_attr
# 15478: __all_pkg_coll_type
# 15479: __all_pkg_coll_type
# 15480: __all_virtual_kv_client_info
#
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15467', all_def_keywords['__all_virtual_vector_index_info'])))
def_table_schema(**gen_sys_agent_virtual_table_def('15468', all_def_keywords['__all_pkg_type']))
def_table_schema(**gen_sys_agent_virtual_table_def('15469', all_def_keywords['__all_pkg_type_attr']))
def_table_schema(**gen_sys_agent_virtual_table_def('15470', all_def_keywords['__all_pkg_coll_type']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15471', all_def_keywords['__all_pkg_type']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15472', all_def_keywords['__all_pkg_type_attr']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15473', all_def_keywords['__all_pkg_coll_type']))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15481', all_def_keywords['__all_virtual_wr_sql_plan'])))
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15482', all_def_keywords['__all_virtual_res_mgr_sysstat'])))
# 15483: __all_virtual_wr_res_mgr_sysstat
def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15484', all_def_keywords['__all_virtual_function_io_stat'])))
def_table_schema(**gen_oracle_mapping_virtual_table_def('15485', all_def_keywords['__all_virtual_temp_file']))
def_table_schema(**gen_oracle_mapping_real_virtual_table_def('15486', all_def_keywords['__all_ncomp_dll_v2']))
# 15487: __all_virtual_logstore_service_status
# 15488: __all_virtual_logstore_service_info
def_table_schema(**gen_oracle_mapping_virtual_table_def('15489', all_def_keywords['__all_virtual_tablet_pointer_status']))
# 15490: __all_object_balance_weight
# 15491: __all_virtual_standby_log_transport_stat
# 15492: __all_virtual_wr_sql_plan_aux_key2snapshot
def_table_schema(**gen_oracle_mapping_virtual_table_def('15493', all_def_keywords['__all_virtual_cs_replica_tablet_stats']))
# 15494: __all_catalog
# 15495: __all_catalog_privilege
# 15496: __all_virtual_ss_tablet_upload_stat
# 15497: __all_virtual_ss_tablet_compact_stat
# 15498: __all_virtual_sswriter_group_stat
# 15499: __all_virtual_sswriter_lease_mgr
# 15500: __idx_15494_idx_catalog_name_real_agent
# 15501: __idx_15495_idx_catalog_priv_catalog_name_real_agent
# 15502: __all_virtual_tenant_flashback_log_scn

# 余留位置（此行之前占位）
# 本区域定义的Oracle表名比较复杂，一般都采用gen_xxx_table_def()方式定义，占位建议采用基表表名占位
# - 示例：def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15009', all_def_keywords['__all_virtual_sql_audit'])))
#   * 基表表名占位：# 15009: __all_virtual_sql_audit
#   * 真实表名占位：# 15009: ALL_VIRTUAL_SQL_AUDIT
################################################################################
# End of Oracle Virtual Table(15000,20000]
################################################################################

################################### 占位须知 ###################################
# 占位示例: 顶格写注释，说明要占用哪个TABLE_ID，对应的名字是什么
# TABLE_ID: TABLE_NAME
#
# FARM 会基于占位校验开发分支TABLE_ID和TABLE_NAME是否匹配，如果不匹配，FARM就会拦截报错
#
# 注意：
# 0. 在‘余留位置’之前占位
# 1. 始终先在master占位，保证master分支是其他所有分支的超集，避免NAME和ID冲突
# 2. master占位之后，开发分支上不要变更NAME，否则FARM会认为ID占位冲突，如果有这种场景，需要先修改master占位
# 3. 默认建议采用准确的TABLE_NAME进行占位，TABLE_ID和TABLE_NAME在系统内部是一一对应的
# 4. 部分表是基于其他基表的schema定义的(例如：gen_xx_table_def())，其真实表名比较复杂，为了方便占位，建议采用基表表名进行占位
#    - 示例1：def_table_schema(**gen_mysql_sys_agent_virtual_table_def('12393', all_def_keywords['__all_virtual_long_ops_status']))
#      * 基表表名占位：# 12393: __all_virtual_long_ops_status
#      * 真实表名占位：# 12393: __all_virtual_virtual_long_ops_status_mysql_sys_agent
#    - 示例2：def_table_schema(**no_direct_access(gen_oracle_mapping_virtual_table_def('15009', all_def_keywords['__all_virtual_sql_audit'])))
#      * 基表表名占位：# 15009: __all_virtual_sql_audit
#      * 真实表名占位：# 15009: ALL_VIRTUAL_SQL_AUDIT
#    - 示例3：def_table_schema(**gen_sys_agent_virtual_table_def('15111', all_def_keywords['__all_routine_param']))
#      * 基表表名占位：# 15111: __all_routine_param
#      * 真实表名占位：# 15111: ALL_VIRTUAL_ROUTINE_PARAM_SYS_AGENT
# 5. 索引表占位要求TABLE_NAME采用以下方式：基表（数据表）表名、索引名(index_name)、真实的索引表表名
#    例如：100001 索引表占位方式可以为：
#       * # 100001: __idx_3_idx_data_table_id
#       * # 100001: idx_data_table_id
#       * # 100001: __all_table
################################################################################

################################################################################
# System View (20000,30000]
# MySQL System View (20000, 25000]
# Oracle System View (25000, 30000]
################################################################################

def_table_schema(
  owner = 'xiaoyi.xy',
  table_name     = 'GV$OB_PLAN_CACHE_STAT',
  table_id       = '20001',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [],
  view_definition = """
  SELECT TENANT_ID,SVR_IP,SVR_PORT,SQL_NUM,MEM_USED,MEM_HOLD,ACCESS_COUNT,
  HIT_COUNT,HIT_RATE,PLAN_NUM,MEM_LIMIT,HASH_BUCKET,STMTKEY_NUM
  FROM oceanbase.__all_virtual_plan_cache_stat
""".replace("\n", " "),


  normal_columns = [
  ],
)

def_table_schema(
    owner = 'xiaoyi.xy',
    table_name     = 'GV$OB_PLAN_CACHE_PLAN_STAT',
    table_id       = '20002',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
    SELECT TENANT_ID,SVR_IP,SVR_PORT,PLAN_ID,SQL_ID,TYPE,IS_BIND_SENSITIVE,IS_BIND_AWARE,
    DB_ID,STATEMENT,QUERY_SQL,SPECIAL_PARAMS,PARAM_INFOS, SYS_VARS, CONFIGS, PLAN_HASH,
    FIRST_LOAD_TIME,SCHEMA_VERSION,LAST_ACTIVE_TIME,AVG_EXE_USEC,SLOWEST_EXE_TIME,SLOWEST_EXE_USEC,
    SLOW_COUNT,HIT_COUNT,PLAN_SIZE,EXECUTIONS,DISK_READS,DIRECT_WRITES,BUFFER_GETS,APPLICATION_WAIT_TIME,
    CONCURRENCY_WAIT_TIME,USER_IO_WAIT_TIME,ROWS_PROCESSED,ELAPSED_TIME,CPU_TIME,LARGE_QUERYS,
    DELAYED_LARGE_QUERYS,DELAYED_PX_QUERYS,OUTLINE_VERSION,OUTLINE_ID,OUTLINE_DATA,ACS_SEL_INFO,
    TABLE_SCAN,EVOLUTION, EVO_EXECUTIONS, EVO_CPU_TIME, TIMEOUT_COUNT, PS_STMT_ID, SESSID,
    TEMP_TABLES, IS_USE_JIT,OBJECT_TYPE,HINTS_INFO,HINTS_ALL_WORKED, PL_SCHEMA_ID,
    IS_BATCHED_MULTI_STMT, RULE_NAME,
    (CASE PLAN_STATUS WHEN 0 THEN 'ACTIVE' ELSE 'INACTIVE' END) AS PLAN_STATUS,
    ADAPTIVE_FEEDBACK_TIMES
    FROM oceanbase.__all_virtual_plan_stat WHERE OBJECT_STATUS = 0 AND is_in_pc=true
""".replace("\n", " "),


    normal_columns = [
    ],
)

def_table_schema(
  owner = 'bin.lb',
  tablegroup_id  = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'SCHEMATA',
  table_id       = '20003',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  view_definition = """
  SELECT 'def' AS CATALOG_NAME,
         DATABASE_NAME collate utf8mb4_name_case AS SCHEMA_NAME,
         b.charset AS DEFAULT_CHARACTER_SET_NAME,
         b.collation AS DEFAULT_COLLATION_NAME,
         CAST(NULL AS CHAR(512)) as SQL_PATH,
         'NO' as DEFAULT_ENCRYPTION
  FROM oceanbase.__all_database a inner join oceanbase.__tenant_virtual_collation b ON a.collation_type = b.collation_type
  WHERE a.tenant_id = 0
    and in_recyclebin = 0
    and a.database_name not in ('__recyclebin', '__public')
    and 0 = sys_privilege_check('db_acc', 0, a.database_name)
  ORDER BY a.database_id
""".replace("\n", " "),

  in_tenant_space = True,

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'jim.wjh',
  tablegroup_id  = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'CHARACTER_SETS',
  table_id       = '20004',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  view_definition = """
  SELECT CHARSET AS CHARACTER_SET_NAME, DEFAULT_COLLATION AS DEFAULT_COLLATE_NAME, DESCRIPTION, max_length AS MAXLEN FROM oceanbase.__tenant_virtual_charset
""".replace("\n", " "),

  in_tenant_space = True,

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  tablegroup_id  = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'GLOBAL_VARIABLES',
  table_id       = '20005',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  view_definition = """
  SELECT `variable_name` as VARIABLE_NAME, `value` as VARIABLE_VALUE  FROM oceanbase.__tenant_virtual_global_variable
""".replace("\n", " "),

  in_tenant_space = True,

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'jiangxiu.wt',
  tablegroup_id = 'OB_INVALID_ID',
  database_id   = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'STATISTICS',
  table_id       = '20006',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,
  view_definition = """
  SELECT CAST('def' AS             CHAR(512))    AS TABLE_CATALOG,
         V.TABLE_SCHEMA collate utf8mb4_name_case AS TABLE_SCHEMA,
         V.TABLE_NAME collate utf8mb4_name_case  AS TABLE_NAME,
         CAST(V.NON_UNIQUE AS      SIGNED)       AS NON_UNIQUE,
         V.INDEX_SCHEMA collate utf8mb4_name_case AS INDEX_SCHEMA,
         V.INDEX_NAME collate utf8mb4_name_case  AS INDEX_NAME,
         CAST(V.SEQ_IN_INDEX AS    UNSIGNED)     AS SEQ_IN_INDEX,
         V.COLUMN_NAME                           AS COLUMN_NAME,
         CAST('A' AS               CHAR(1))      AS COLLATION,
         CAST(NULL AS              SIGNED)       AS CARDINALITY,
         CAST(V.SUB_PART AS        SIGNED)       AS SUB_PART,
         CAST(NULL AS              CHAR(10))     AS PACKED,
         CAST(V.NULLABLE AS        CHAR(3))      AS NULLABLE,
         CAST(V.INDEX_TYPE AS      CHAR(16))     AS INDEX_TYPE,
         CAST(V.COMMENT AS         CHAR(16))     AS COMMENT,
         CAST(V.INDEX_COMMENT AS   CHAR(1024))   AS INDEX_COMMENT,
         CAST(V.IS_VISIBLE AS      CHAR(3))      AS IS_VISIBLE,
         V.EXPRESSION                            AS EXPRESSION
  FROM   (SELECT db.database_name                                              AS TABLE_SCHEMA,
                 t.table_name                                                  AS TABLE_NAME,
                 CASE WHEN i.index_type IN (2,4,8,41) THEN 0 ELSE 1 END        AS NON_UNIQUE,
                 db.database_name                                              AS INDEX_SCHEMA,
                 CASE WHEN i.index_type = 41 THEN 'PRIMARY' ELSE
                 substr(i.table_name, 7 + instr(substr(i.table_name, 7), '_')) END AS INDEX_NAME,
                 c.index_position                                              AS SEQ_IN_INDEX,
                 CASE WHEN d_col.column_name IS NOT NULL THEN d_col.column_name ELSE c.column_name END AS COLUMN_NAME,
                 CASE WHEN d_col.column_name IS NOT NULL THEN c.data_length ELSE NULL END AS SUB_PART,
                 CASE WHEN c.nullable = 1 THEN 'YES' ELSE '' END               AS NULLABLE,
                 CASE WHEN i.index_type in (15, 18, 21) THEN 'FULLTEXT'
                      WHEN i.index_using_type = 0 THEN 'BTREE'
                      WHEN i.index_using_type = 1 THEN 'HASH'
                      ELSE 'UNKOWN' END      AS INDEX_TYPE,
                 CASE i.index_status
                 WHEN 2 THEN 'VALID'
                 WHEN 3 THEN 'CHECKING'
                 WHEN 4 THEN 'INELEGIBLE'
                 WHEN 5 THEN 'ERROR'
                 ELSE 'UNUSABLE' END                                                  AS COMMENT,
                 i.comment                                                     AS INDEX_COMMENT,
                 CASE WHEN (i.index_attributes_set & 1) THEN 'NO' ELSE 'YES' END AS IS_VISIBLE,
                 d_col2.cur_default_value_v2                                     AS EXPRESSION
          FROM   oceanbase.__all_table i
          JOIN   oceanbase.__all_table t
          ON     i.data_table_id=t.table_id
          AND    i.tenant_id = t.tenant_id
          AND    i.database_id = t.database_id
          AND    i.table_type = 5
          AND    i.index_type NOT IN (13, 14, 16, 17, 19, 20, 22)
          AND    i.table_mode >> 12 & 15 in (0,1)
          AND    i.index_attributes_set & 16 = 0
          AND    t.table_type in (0,3)
          JOIN   oceanbase.__all_column c
          ON     i.table_id=c.table_id
          AND    i.tenant_id = c.tenant_id
          AND    c.index_position > 0
          JOIN   oceanbase.__all_database db
          ON     i.tenant_id = db.tenant_id
          AND    i.database_id = db.database_id
          AND    db.in_recyclebin = 0
          AND    db.database_name != '__recyclebin'
          LEFT JOIN oceanbase.__all_column d_col
          ON    i.data_table_id = d_col.table_id
          AND   i.tenant_id = d_col.tenant_id
          AND   (case when (c.is_hidden = 1 and substr(c.column_name, 1, 8) = '__substr') then
                   substr(c.column_name, 8 + instr(substr(c.column_name, 8), '_')) else 0 end) = d_col.column_id
          LEFT JOIN oceanbase.__all_column d_col2
          ON    i.data_table_id = d_col2.table_id
          AND   i.tenant_id = d_col2.tenant_id
          AND   c.column_id = d_col2.column_id
          AND   d_col2.cur_default_value_v2 is not null
          AND   d_col2.is_hidden = 1
          AND   (d_col2.column_flags & (0x1 << 0) = 1 or d_col2.column_flags & (0x1 << 1) = 1)
          AND   substr(d_col2.column_name, 1, 6) = 'SYS_NC'
        UNION ALL
          SELECT  db.database_name  AS TABLE_SCHEMA,
                  t.table_name      AS TABLE_NAME,
                  0                 AS NON_UNIQUE,
                  db.database_name  AS INDEX_SCHEMA,
                  'PRIMARY'         AS INDEX_NAME,
                  c.rowkey_position AS SEQ_IN_INDEX,
                  c.column_name     AS COLUMN_NAME,
                  NULL              AS SUB_PART,
                  ''                AS NULLABLE,
                  CASE WHEN t.index_using_type = 0 THEN 'BTREE' ELSE (
                    CASE WHEN t.index_using_type = 1 THEN 'HASH' ELSE 'UNKOWN' END) END AS INDEX_TYPE,
                  'VALID'          AS COMMENT,
                  t.comment        AS INDEX_COMMENT,
                  'YES'            AS IS_VISIBLE,
                  NULL             AS EXPRESSION
          FROM   oceanbase.__all_table t
          JOIN   oceanbase.__all_column c
          ON     t.table_id=c.table_id
          AND    t.tenant_id = c.tenant_id
          AND    c.rowkey_position > 0
          AND    c.is_hidden = 0
          AND    t.table_type in (0,3)
          JOIN   oceanbase.__all_database db
          ON     t.tenant_id = db.tenant_id
          AND    t.database_id = db.database_id
          AND    db.in_recyclebin = 0
          AND    db.database_name != '__recyclebin'
        UNION ALL
          SELECT db.database_name                                           AS TABLE_SCHEMA,
              t.table_name                                                  AS TABLE_NAME,
              CASE WHEN i.index_type IN (2,4,8,41) THEN 0 ELSE 1 END        AS NON_UNIQUE,
              db.database_name                                              AS INDEX_SCHEMA,
              substr(i.table_name, 7 + instr(substr(i.table_name, 7), '_')) AS INDEX_NAME,
              c.index_position                                              AS SEQ_IN_INDEX,
              CASE WHEN d_col.column_name IS NOT NULL THEN d_col.column_name ELSE c.column_name END AS COLUMN_NAME,
              CASE WHEN d_col.column_name IS NOT NULL THEN c.data_length ELSE NULL END AS SUB_PART,
              CASE WHEN c.nullable = 1 THEN 'YES' ELSE '' END               AS NULLABLE,
              CASE WHEN i.index_type in (15, 18, 21) THEN 'FULLTEXT'
                   WHEN i.index_using_type = 0 THEN 'BTREE'
                   WHEN i.index_using_type = 1 THEN 'HASH'
                   ELSE 'UNKOWN' END      AS INDEX_TYPE,
              CASE i.index_status
              WHEN 2 THEN 'VALID'
              WHEN 3 THEN 'CHECKING'
              WHEN 4 THEN 'INELEGIBLE'
              WHEN 5 THEN 'ERROR'
              ELSE 'UNUSABLE' END                                           AS COMMENT,
              i.comment                                                     AS INDEX_COMMENT,
              CASE WHEN (i.index_attributes_set & 1) THEN 'NO' ELSE 'YES' END AS IS_VISIBLE,
              d_col2.cur_default_value_v2                                   AS EXPRESSION
          FROM   oceanbase.__ALL_VIRTUAL_CORE_ALL_TABLE i
          JOIN   oceanbase.__ALL_VIRTUAL_CORE_ALL_TABLE t
          ON     i.data_table_id=t.table_id
          AND    i.tenant_id = t.tenant_id
          AND    i.database_id = t.database_id
          AND    i.table_type = 5
          AND    i.index_type NOT IN (13, 14, 16, 17, 19, 20, 22)
          AND    t.table_type in (0,3)
          AND    t.tenant_id = EFFECTIVE_TENANT_ID()
          JOIN   oceanbase.__ALL_VIRTUAL_CORE_COLUMN_TABLE c
          ON     i.table_id=c.table_id
          AND    i.tenant_id = c.tenant_id
          AND    c.index_position > 0
          JOIN   oceanbase.__all_database db
          ON     i.database_id = db.database_id
          LEFT JOIN oceanbase.__ALL_VIRTUAL_CORE_COLUMN_TABLE d_col
          ON    i.data_table_id = d_col.table_id
          AND   i.tenant_id = d_col.tenant_id
          AND   (case when (c.is_hidden = 1 and substr(c.column_name, 1, 8) = '__substr') then
                   substr(c.column_name, 8 + instr(substr(c.column_name, 8), '_')) else 0 end) = d_col.column_id
          LEFT JOIN oceanbase.__ALL_VIRTUAL_CORE_COLUMN_TABLE d_col2
          ON    i.data_table_id = d_col2.table_id
          AND   i.tenant_id = d_col2.tenant_id
          AND   c.column_id = d_col2.column_id
          AND   d_col2.cur_default_value_v2 is not null
          AND   d_col2.is_hidden = 1
          AND   (d_col2.column_flags & (0x1 << 0) = 1 or d_col2.column_flags & (0x1 << 1) = 1)
          AND   substr(d_col2.column_name, 1, 6) = 'SYS_NC'
        UNION ALL
          SELECT db.database_name  AS TABLE_SCHEMA,
                  t.table_name      AS TABLE_NAME,
                  0                 AS NON_UNIQUE,
                  db.database_name  AS INDEX_SCHEMA,
                  'PRIMARY'         AS INDEX_NAME,
                  c.rowkey_position AS SEQ_IN_INDEX,
                  c.column_name     AS COLUMN_NAME,
                  NULL              AS SUB_PART,
                  ''                AS NULLABLE,
                  CASE WHEN t.index_using_type = 0 THEN 'BTREE' ELSE (
                    CASE WHEN t.index_using_type = 1 THEN 'HASH' ELSE 'UNKOWN' END) END AS INDEX_TYPE,
                  'VALID'          AS COMMENT,
                  t.comment        AS INDEX_COMMENT,
                  'YES'            AS IS_VISIBLE,
                  NULL             AS EXPRESSION
          FROM   oceanbase.__ALL_VIRTUAL_CORE_ALL_TABLE t
          JOIN   oceanbase.__ALL_VIRTUAL_CORE_COLUMN_TABLE c
          ON     t.table_id=c.table_id
          AND    t.tenant_id = c.tenant_id
          AND    t.tenant_id = EFFECTIVE_TENANT_ID()
          AND    c.rowkey_position > 0
          AND    c.is_hidden = 0
          AND    t.table_type in (0,3)
          JOIN   oceanbase.__all_database db
          ON     t.database_id = db.database_id)V
          WHERE 0 = sys_privilege_check('table_acc', effective_tenant_id())
                OR 0 = sys_privilege_check('table_acc', effective_tenant_id(), V.TABLE_SCHEMA, V.TABLE_NAME)
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'bin.lb',
  tablegroup_id = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'VIEWS',
  table_id       = '20007',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  view_definition = """select
                   cast('def' as CHAR(64)) AS TABLE_CATALOG,
                   d.database_name collate utf8mb4_name_case as TABLE_SCHEMA,
                   t.table_name collate utf8mb4_name_case as TABLE_NAME,
                   t.view_definition as VIEW_DEFINITION,
                   case t.view_check_option when 1 then 'LOCAL' when 2 then 'CASCADED' else 'NONE' end as CHECK_OPTION,
                   case t.view_is_updatable when 1 then 'YES' else 'NO' end as IS_UPDATABLE,
                   cast((case t.define_user_id
                         when -1 then 'NONE'
                         else concat(u.user_name, '@', u.host) end) as CHAR(288)) as DEFINER,
                   cast('NONE' as CHAR(7)) AS SECURITY_TYPE,
                   cast((case t.collation_type
                         when 45 then 'utf8mb4'
                         else 'NONE' end) as CHAR(64)) AS CHARACTER_SET_CLIENT,
                   cast((case t.collation_type
                         when 45 then 'utf8mb4_general_ci'
                         else 'NONE' end) as CHAR(64)) AS COLLATION_CONNECTION
                   from oceanbase.__all_table as t
                   join oceanbase.__all_database as d
                     on t.tenant_id = d.tenant_id and t.database_id = d.database_id
                   left join oceanbase.__all_user as u
                     on t.tenant_id = u.tenant_id and t.define_user_id = u.user_id and t.define_user_id != -1
                   where t.tenant_id = 0
                     and t.table_type in (1, 4)
                     and t.table_mode >> 12 & 15 in (0,1)
                     and t.index_attributes_set & 16 = 0
                     and d.in_recyclebin = 0
                     and d.database_name != '__recyclebin'
                     and d.database_name != 'information_schema'
                     and d.database_name != 'oceanbase'
                     and 0 = sys_privilege_check('table_acc', effective_tenant_id(), d.database_name, t.table_name)
""".replace("\n", " "),


  normal_columns = [
  ],
)

def_table_schema(
  owner = 'bin.lb',
  tablegroup_id  = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'TABLES',
  table_id       = '20008',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  view_definition = """
                    select /*+ leading(a) no_use_nl(ts)*/
                    cast('def' as char(512)) as TABLE_CATALOG,
                    cast(b.database_name as char(64)) collate utf8mb4_name_case as TABLE_SCHEMA,
                    cast(a.table_name as char(64)) collate utf8mb4_name_case as TABLE_NAME,
                    cast(case when (a.database_id = 201002 or a.table_type = 1) then 'SYSTEM VIEW'
                         when a.table_type in (0, 2) then 'SYSTEM TABLE'
                         when a.table_type = 4 then 'VIEW'
                         when a.table_type = 14 then 'EXTERNAL TABLE'
                         else 'BASE TABLE' end as char(64)) as TABLE_TYPE,
                    cast(case when a.table_type in (0,3,5,6,7,11,12,13,15) then 'InnoDB'
                        else 'MEMORY' end as char(64)) as ENGINE,
                    cast(NULL as unsigned) as VERSION,
                    cast(a.store_format as char(10)) as ROW_FORMAT,
                    cast( coalesce(ts.row_cnt,0) as unsigned) as TABLE_ROWS,
                    cast( coalesce(ts.avg_row_len,0) as unsigned) as AVG_ROW_LENGTH,
                    cast( coalesce(ts.data_size,0) as unsigned) as DATA_LENGTH,
                    cast(NULL as unsigned) as MAX_DATA_LENGTH,
                    cast( coalesce(idx_stat.index_length, 0) as unsigned) as INDEX_LENGTH,
                    cast(NULL as unsigned) as DATA_FREE,
                    cast(NULL as unsigned) as AUTO_INCREMENT,
                    cast(a.gmt_create as datetime) as CREATE_TIME,
                    cast(a.gmt_modified as datetime) as UPDATE_TIME,
                    cast(NULL as datetime) as CHECK_TIME,
                    cast(d.collation as char(32)) as TABLE_COLLATION,
                    cast(NULL as unsigned) as CHECKSUM,
                    cast(NULL as char(255)) as CREATE_OPTIONS,
                    cast(case when a.table_type = 4 then 'VIEW'
                             else a.comment end as char(2048)) as TABLE_COMMENT,
                    cast(case when a.auto_part = 1 then 'TRUE'
                              else 'FALSE' end as char(16)) as AUTO_SPLIT,
                    cast(case when a.auto_part = 1 then a.auto_part_size
                              else 0 end as unsigned) as AUTO_SPLIT_TABLET_SIZE,
                    cast(case when a.table_mode >> 30 = 1 then 'HEAP'
                              else 'INDEX' end as char(12)) as ORGANIZATION
                    from
                    (
                    select cast(0 as signed) as tenant_id,
                           c.database_id,
                           c.table_id,
                           c.table_name,
                           c.collation_type,
                           c.table_type,
                           usec_to_time(d.schema_version) as gmt_create,
                           usec_to_time(c.schema_version) as gmt_modified,
                           c.comment,
                           c.store_format,
                           c.auto_part,
                           c.auto_part_size,
                           c.table_mode
                    from oceanbase.__all_virtual_core_all_table c
                    join oceanbase.__all_virtual_core_all_table d
                      on c.tenant_id = d.tenant_id and d.table_name = '__all_core_table'
                    where c.tenant_id = effective_tenant_id()
                    union all
                    select tenant_id,
                           database_id,
                           table_id,
                           table_name,
                           collation_type,
                           table_type,
                           gmt_create,
                           gmt_modified,
                           comment,
                           store_format,
                           auto_part,
                           auto_part_size,
                           table_mode
                    from oceanbase.__all_table where table_mode >> 12 & 15 in (0,1) and index_attributes_set & 16 = 0) a
                    join oceanbase.__all_database b
                    on a.database_id = b.database_id
                    and a.tenant_id = b.tenant_id
                    join oceanbase.__tenant_virtual_collation d
                    on a.collation_type = d.collation_type
                    left join (
                      select tenant_id,
                             table_id,
                             row_cnt,
                             avg_row_len,
                             (macro_blk_cnt * 2 * 1024 * 1024) as data_size
                      from oceanbase.__all_table_stat
                      where partition_id = -1 or partition_id = table_id) ts
                    on a.table_id = ts.table_id
                    and a.tenant_id = ts.tenant_id
                    left join (
                      select e.tenant_id as tenant_id,
                             e.data_table_id as data_table_id,
                             SUM(f.macro_blk_cnt * 2 * 1024 * 1024) AS index_length
                      FROM oceanbase.__all_table e JOIN oceanbase.__all_table_stat f
                            ON e.tenant_id = f.tenant_id and e.table_id = f.table_id and (f.partition_id = -1 or f.partition_id = e.table_id)
                      WHERE e.index_type in (1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 41) and e.table_type = 5
                            group by tenant_id, data_table_id
                    ) idx_stat on idx_stat.tenant_id = a.tenant_id and idx_stat.data_table_id = a.table_id
                    where a.tenant_id = 0
                    and a.table_type in (0, 1, 2, 3, 4, 14, 15)
                    and b.database_name != '__recyclebin'
                    and b.in_recyclebin = 0
                    and 0 = sys_privilege_check('table_acc', effective_tenant_id(), b.database_name, a.table_name)
""".replace("\n", " "),


  normal_columns = [
  ],
)

def_table_schema(
  owner = 'jim.wjh',
  tablegroup_id = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'COLLATIONS',
  table_id       = '20009',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  view_definition = """select collation as COLLATION_NAME, charset as CHARACTER_SET_NAME, id as ID, `is_default` as IS_DEFAULT, is_compiled as IS_COMPILED, sortlen as SORTLEN from oceanbase.__tenant_virtual_collation
""".replace("\n", " "),

  in_tenant_space = True,

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'jim.wjh',
  tablegroup_id = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'COLLATION_CHARACTER_SET_APPLICABILITY',
  table_id       = '20010',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  view_definition = """select collation as COLLATION_NAME, charset as CHARACTER_SET_NAME from oceanbase.__tenant_virtual_collation
""".replace("\n", " "),

  in_tenant_space = True,

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  tablegroup_id  = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'PROCESSLIST',
  table_id       = '20011',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  view_definition = """SELECT id AS ID, user AS USER, concat(user_client_ip, ':', user_client_port) AS HOST, db AS DB, command AS COMMAND, cast(time as SIGNED) AS TIME, state AS STATE, info AS INFO FROM oceanbase.__all_virtual_processlist WHERE  is_serving_tenant(svr_ip, svr_port, effective_tenant_id())
""".replace("\n", " "),

  in_tenant_space = True,

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'bin.lb',
  tablegroup_id  = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'KEY_COLUMN_USAGE',
  table_id       = '20012',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  view_definition = """
                    (select 'def' as CONSTRAINT_CATALOG,
                    c.database_name collate utf8mb4_name_case as  CONSTRAINT_SCHEMA,
                    'PRIMARY' as CONSTRAINT_NAME, 'def' as TABLE_CATALOG,
                    c.database_name collate utf8mb4_name_case as TABLE_SCHEMA,
                    a.table_name collate utf8mb4_name_case as TABLE_NAME,
                    b.column_name as COLUMN_NAME,
                    b.rowkey_position as ORDINAL_POSITION,
                    CAST(NULL AS UNSIGNED) as POSITION_IN_UNIQUE_CONSTRAINT,
                    CAST(NULL AS CHAR(64)) as REFERENCED_TABLE_SCHEMA,
                    CAST(NULL AS CHAR(64)) as REFERENCED_TABLE_NAME,
                    CAST(NULL AS CHAR(64)) as REFERENCED_COLUMN_NAME
                    from oceanbase.__all_table a
                    join oceanbase.__all_column b
                      on a.tenant_id = b.tenant_id and a.table_id = b.table_id
                    join oceanbase.__all_database c
                      on a.tenant_id = c.tenant_id and a.database_id = c.database_id
                    where a.tenant_id = 0
                      and a.table_mode >> 12 & 15 in (0,1)
                      and a.index_attributes_set & 16 = 0
                      and c.in_recyclebin = 0
                      and c.database_name != '__recyclebin'
                      and b.rowkey_position > 0
                      and b.column_id >= 16
                      and a.table_type != 5 and a.table_type != 12 and a.table_type != 13
                      and b.column_flags & (0x1 << 8) = 0
                      and (0 = sys_privilege_check('table_acc', effective_tenant_id())
                           or 0 = sys_privilege_check('table_acc', effective_tenant_id(), c.database_name, a.table_name)))

                    union all
                    (select 'def' as CONSTRAINT_CATALOG,
                    d.database_name collate utf8mb4_name_case as CONSTRAINT_SCHEMA,
                    substr(a.table_name, 2 + length(substring_index(a.table_name,'_',4))) as CONSTRAINT_NAME,
                    'def' as TABLE_CATALOG,
                    d.database_name collate utf8mb4_name_case as TABLE_SCHEMA,
                    c.table_name collate utf8mb4_name_case as TABLE_NAME,
                    b.column_name as COLUMN_NAME,
                    b.index_position as ORDINAL_POSITION,
                    CAST(NULL AS UNSIGNED) as POSITION_IN_UNIQUE_CONSTRAINT,
                    CAST(NULL AS CHAR(64)) as REFERENCED_TABLE_SCHEMA,
                    CAST(NULL AS CHAR(64)) as REFERENCED_TABLE_NAME,
                    CAST(NULL AS CHAR(64)) as REFERENCED_COLUMN_NAME
                    from oceanbase.__all_table a
                    join oceanbase.__all_column b
                      on a.tenant_id = b.tenant_id and a.table_id = b.table_id
                    join oceanbase.__all_table c
                      on a.tenant_id = c.tenant_id and a.data_table_id = c.table_id
                    join oceanbase.__all_database d
                      on a.tenant_id = d.tenant_id and c.database_id = d.database_id
                    where a.tenant_id = 0
                      and d.in_recyclebin = 0
                      and d.database_name != '__recyclebin'
                      and a.table_type = 5
                      and a.index_type in (2, 4, 8, 41)
                      and b.index_position > 0
                      and (0 = sys_privilege_check('table_acc', effective_tenant_id())
                           or 0 = sys_privilege_check('table_acc', effective_tenant_id(), d.database_name, c.table_name))

                    union all
                    (select 'def' as CONSTRAINT_CATALOG,
                    d.database_name collate utf8mb4_name_case as CONSTRAINT_SCHEMA,
                    f.foreign_key_name as CONSTRAINT_NAME,
                    'def' as TABLE_CATALOG,
                    d.database_name collate utf8mb4_name_case as TABLE_SCHEMA,
                    t.table_name collate utf8mb4_name_case as TABLE_NAME,
                    c.column_name as COLUMN_NAME,
                    fc.position as ORDINAL_POSITION,
                    CAST(fc.position AS UNSIGNED) as POSITION_IN_UNIQUE_CONSTRAINT,
                    d2.database_name as REFERENCED_TABLE_SCHEMA,
                    t2.table_name as REFERENCED_TABLE_NAME,
                    c2.column_name as REFERENCED_COLUMN_NAME
                    from
                    oceanbase.__all_foreign_key f
                    join oceanbase.__all_table t
                      on f.tenant_id = t.tenant_id and f.child_table_id = t.table_id
                    join oceanbase.__all_database d
                      on f.tenant_id = d.tenant_id and t.database_id = d.database_id
                    join oceanbase.__all_foreign_key_column fc
                      on f.tenant_id = fc.tenant_id and f.foreign_key_id = fc.foreign_key_id
                    join oceanbase.__all_column c
                      on f.tenant_id = c.tenant_id and fc.child_column_id = c.column_id and t.table_id = c.table_id
                    join oceanbase.__all_table t2
                      on f.tenant_id = t2.tenant_id and f.parent_table_id = t2.table_id
                    join oceanbase.__all_database d2
                      on f.tenant_id = d2.tenant_id and t2.database_id = d2.database_id
                    join oceanbase.__all_column c2
                      on f.tenant_id = c2.tenant_id and fc.parent_column_id = c2.column_id and t2.table_id = c2.table_id
                    where f.tenant_id = 0
                      and (0 = sys_privilege_check('table_acc', effective_tenant_id())
                           or 0 = sys_privilege_check('table_acc', effective_tenant_id(), d.database_name, t.table_name))

                    union all
                    (select 'def' as CONSTRAINT_CATALOG,
                    d.database_name collate utf8mb4_name_case as CONSTRAINT_SCHEMA,
                    f.foreign_key_name as CONSTRAINT_NAME,
                    'def' as TABLE_CATALOG,
                    d.database_name collate utf8mb4_name_case as TABLE_SCHEMA,
                    t.table_name collate utf8mb4_name_case as TABLE_NAME,
                    c.column_name as COLUMN_NAME,
                    fc.position as ORDINAL_POSITION,
                    CAST(fc.position AS UNSIGNED) as POSITION_IN_UNIQUE_CONSTRAINT,
                    d.database_name as REFERENCED_TABLE_SCHEMA,
                    t2.mock_fk_parent_table_name as REFERENCED_TABLE_NAME,
                    c2.parent_column_name as REFERENCED_COLUMN_NAME
                    from oceanbase.__all_foreign_key f
                    join oceanbase.__all_table t
                      on f.tenant_id = t.tenant_id and f.child_table_id = t.table_id
                    join oceanbase.__all_database d
                      on f.tenant_id = d.tenant_id and t.database_id = d.database_id
                    join oceanbase.__all_foreign_key_column fc
                      on f.tenant_id = fc.tenant_id and f.foreign_key_id = fc.foreign_key_id
                    join oceanbase.__all_column c
                      on f.tenant_id = c.tenant_id and fc.child_column_id = c.column_id and t.table_id = c.table_id
                    join oceanbase.__all_mock_fk_parent_table t2
                      on f.tenant_id = t2.tenant_id and f.parent_table_id = t2.mock_fk_parent_table_id
                    join oceanbase.__all_mock_fk_parent_table_column c2
                      on f.tenant_id = c2.tenant_id and fc.parent_column_id = c2.parent_column_id and t2.mock_fk_parent_table_id = c2.mock_fk_parent_table_id
                    where f.tenant_id = 0
                      and (0 = sys_privilege_check('table_acc', effective_tenant_id())
                           or 0 = sys_privilege_check('table_acc', effective_tenant_id(), d.database_name, t.table_name)))))
                    """.replace("\n", " "),

  in_tenant_space = True,

  normal_columns = [
  ],
)

# 20013: DBA_OB_OUTLINES # abandoned in 4.0

def_table_schema(
  owner = 'jiangxiu.wt',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'ENGINES',
  table_id        = '20014',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT CAST('InnoDB' as CHAR(64)) as ENGINE,
           CAST('YES' AS CHAR(8)) as SUPPORT,
           CAST('Supports transactions' as CHAR(80)) as COMMENT,
           CAST('YES' as CHAR(3)) as TRANSACTIONS,
           CAST('NO' as CHAR(3)) as XA,
           CAST('YES' as CHAR(3)) as SAVEPOINTS
    FROM DUAL;
""".replace("\n", " ")
)

def_table_schema(
  owner = 'linlin.xll',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'ROUTINES',
  table_id        = '20015',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """select
                      CAST(mp.specific_name AS CHAR(64)) AS SPECIFIC_NAME,
                      CAST('def' AS CHAR(512)) as ROUTINE_CATALOG,
                      CAST(mp.db AS CHAR(64)) collate utf8mb4_name_case as ROUTINE_SCHEMA,
                      CAST(mp.name AS CHAR(64)) as ROUTINE_NAME,
                      CAST(mp.type AS CHAR(9)) as ROUTINE_TYPE,
                      CAST(lower(v.data_type_str) AS CHAR(64)) AS DATA_TYPE,
                      CAST(
                        CASE
                        WHEN mp.type = 'FUNCTION' THEN CASE
                        WHEN rp.param_type IN (22, 23, 27, 28, 29, 30) THEN rp.param_length
                        ELSE NULL
                        END
                          ELSE NULL
                        END
                          AS SIGNED
                      ) as CHARACTER_MAXIMUM_LENGTH,
                      CASE
                      WHEN rp.param_type IN (22, 23, 27, 28, 29, 30, 43, 44, 46) THEN CAST(
                        rp.param_length * CASE rp.param_coll_type
                        WHEN 63 THEN 1
                        WHEN 249 THEN 4
                        WHEN 248 THEN 4
                        WHEN 87 THEN 2
                        WHEN 28 THEN 2
                        WHEN 55 THEN 4
                        WHEN 54 THEN 4
                        WHEN 101 THEN 2
                        WHEN 46 THEN 4
                        WHEN 45 THEN 4
                        WHEN 224 THEN 4
                        ELSE 1
                        END
                          AS SIGNED
                      )
                      ELSE CAST(NULL AS SIGNED)
                    END
                      AS CHARACTER_OCTET_LENGTH,
                      CASE
                      WHEN rp.param_type IN (1, 2, 3, 4, 5, 15, 16, 50) THEN CAST(rp.param_precision AS UNSIGNED)
                      ELSE CAST(NULL AS UNSIGNED)
                    END
                      AS NUMERIC_PRECISION,
                      CASE
                      WHEN rp.param_type IN (15, 16, 50) THEN CAST(rp.param_scale AS SIGNED)
                      WHEN rp.param_type IN (1, 2, 3, 4, 5, 11, 12, 13, 14) THEN CAST(0 AS SIGNED)
                      ELSE CAST(NULL AS SIGNED)
                    END
                      AS NUMERIC_SCALE,
                      CASE
                      WHEN rp.param_type IN (17, 18, 20, 53) THEN CAST(rp.param_scale AS UNSIGNED)
                      ELSE CAST(NULL AS UNSIGNED)
                    END
                      AS DATETIME_PRECISION,
                      CAST(
                        CASE rp.param_charset
                        WHEN 1 THEN 'binary'
                        WHEN 2 THEN 'utf8mb4'
                        WHEN 3 THEN 'gbk'
                        WHEN 4 THEN 'utf16'
                        WHEN 5 THEN 'gb18030'
                        WHEN 6 THEN 'latin1'
                        WHEN 7 THEN 'gb18030_2022'
                        WHEN 8 THEN 'ascii'
                        WHEN 9 THEN 'tis620'
                        ELSE NULL
                        END
                          AS CHAR(64)
                      ) AS CHARACTER_SET_NAME,
                      CAST(
                        CASE rp.param_coll_type
                        WHEN 45 THEN 'utf8mb4_general_ci'
                        WHEN 46 THEN 'utf8mb4_bin'
                        WHEN 63 THEN 'binary'
                        ELSE NULL
                        END
                          AS CHAR(64)
                      ) AS COLLATION_NAME,
                      CAST(
                        CASE
                        WHEN rp.param_type IN (1, 2, 3, 4, 5) THEN CONCAT(
                          lower(v.data_type_str),
                          '(',
                          rp.param_precision,
                          ')'
                        )
                        WHEN rp.param_type IN (15, 16, 50) THEN CONCAT(
                          lower(v.data_type_str),
                          '(',
                          rp.param_precision,
                          ',',
                          rp.param_scale,
                          ')'
                        )
                        WHEN rp.param_type IN (18, 20) THEN CONCAT(lower(v.data_type_str), '(', rp.param_scale, ')')
                        WHEN rp.param_type IN (22, 23) and rp.param_length > 0 THEN CONCAT(lower(v.data_type_str), '(', rp.param_length, ')')
                        WHEN rp.param_type IN (32, 33)
                        THEN get_mysql_routine_parameter_type_str(rp.routine_id, rp.param_position)
                        WHEN rp.param_type = 52 THEN lower('DATE')
                        WHEN rp.param_type = 53 THEN lower('DATETIME')
                        ELSE lower(v.data_type_str)
                        END
                          AS CHAR(4194304)
                      ) AS DTD_IDENTIFIER,
                      CAST('SQL' AS CHAR(8)) as ROUTINE_BODY,
                      CAST(mp.body AS CHAR(4194304)) as ROUTINE_DEFINITION,
                      CAST(NULL AS CHAR(64)) as EXTERNAL_NAME,
                      CAST(NULL AS CHAR(64)) as EXTERNAL_LANGUAGE,
                      CAST('SQL' AS CHAR(8)) as PARAMETER_STYLE,
                      CAST(mp.IS_DETERMINISTIC AS CHAR(3)) AS IS_DETERMINISTIC,
                      CAST(mp.SQL_DATA_ACCESS AS CHAR(64)) AS SQL_DATA_ACCESS,
                      CAST(NULL AS CHAR(64)) as SQL_PATH,
                      CAST(mp.SECURITY_TYPE AS CHAR(7)) as SECURITY_TYPE,
                      CAST(r.gmt_create AS datetime) as CREATED,
                      CAST(r.gmt_modified AS datetime) as LAST_ALTERED,
                      CAST(mp.SQL_MODE AS CHAR(8192)) as SQL_MODE,
                      CAST(mp.comment AS CHAR(4194304)) as ROUTINE_COMMENT,
                      CAST(mp.DEFINER AS CHAR(93)) as DEFINER,
                      CAST(mp.CHARACTER_SET_CLIENT AS CHAR(32)) as CHARACTER_SET_CLIENT,
                      CAST(mp.COLLATION_CONNECTION AS CHAR(32)) as COLLATION_CONNECTION,
                      CAST(mp.db_collation AS CHAR(32)) as DATABASE_COLLATION
                    from
                      mysql.proc as mp
                      join oceanbase.__all_database a
                      on mp.DB = a.DATABASE_NAME
                      and  a.in_recyclebin = 0
                      join oceanbase.__all_routine as r on mp.specific_name = r.routine_name
                      and r.DATABASE_ID = a.DATABASE_ID
                      and
                      CAST(
                        CASE r.routine_type
                        WHEN 1 THEN 'PROCEDURE'
                        WHEN 2 THEN 'FUNCTION'
                        ELSE NULL
                        END
                          AS CHAR(9)
                      ) = mp.type
                      left join oceanbase.__all_routine_param as rp on rp.subprogram_id = r.subprogram_id
                      and rp.tenant_id = r.tenant_id
                      and rp.routine_id = r.routine_id
                      and rp.param_position = 0
                      left join oceanbase.__all_virtual_data_type v on rp.param_type = v.data_type
                    where (0 = sys_privilege_check('routine_acc', effective_tenant_id())
                           or 0 = sys_privilege_check('routine_acc', effective_tenant_id(), mp.DB, r.routine_name, r.routine_type))
                    """.replace("\n", " ")
)

# 20016: PROFILING
# 20017: OPTIMIZER_TRACE
# 20018: PLUGINS
# 20019: INNODB_SYS_COLUMNS

def_table_schema(
  owner = 'ailing.lcq',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'PROFILING',
  table_id        = '20016',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT  CAST(00000000000000000000 as SIGNED) as QUERY_ID,
            CAST(00000000000000000000 as SIGNED) as SEQ,
            CAST('' as CHAR(30)) as STATE,
            CAST(0.000000 as DECIMAL(9, 6)) as DURATION,
            CAST(NULL as DECIMAL(9, 6)) as CPU_USER,
            CAST(NULL as DECIMAL(9, 6)) as CPU_SYSTEM,
            CAST(00000000000000000000 as SIGNED) as CONTEXT_VOLUNTARY,
            CAST(00000000000000000000 as SIGNED) as CONTEXT_INVOLUNTARY,
            CAST(00000000000000000000 as SIGNED) as BLOCK_OPS_IN,
            CAST(00000000000000000000 as SIGNED) as BLOCK_OPS_OUT,
            CAST(00000000000000000000 as SIGNED) as MESSAGES_SENT,
            CAST(00000000000000000000 as SIGNED) as MESSAGES_RECEIVED,
            CAST(00000000000000000000 as SIGNED) as PAGE_FAULTS_MAJOR,
            CAST(00000000000000000000 as SIGNED) as PAGE_FAULTS_MINOR,
            CAST(00000000000000000000 as SIGNED) as SWAPS,
            CAST(NULL as CHAR(30)) as SOURCE_FUNCTION,
            CAST(NULL as CHAR(20)) as SOURCE_FILE,
            CAST(00000000000000000000 as SIGNED) as SOURCE_LINE
    FROM DUAL limit 0;
""".replace("\n", " ")
)


def_table_schema(
  owner           = 'sanquan.qz',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'OPTIMIZER_TRACE',
  table_id        = '20017',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT CAST('query'              as CHAR(200)) as QUERY,
           CAST('trace'              as CHAR(200)) as TRACE,
           CAST(00000000000000000000 as SIGNED) as MISSING_BYTES_MAX_MEM_SIZE,
           CAST(0 as SIGNED) as INSUFFICIENT_PRIVILEGES
    FROM DUAL limit 0;
  """.replace("\n", " ")
)

def_table_schema(
  owner         = 'sanquan.qz',
  tablegroup_id = 'OB_INVALID_ID',
  database_id   = 'OB_INFORMATION_SCHEMA_ID',
  table_name    = 'PLUGINS',
  table_id      = '20018',
  table_type    = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT CAST('plugin name'    as CHAR(64)) as PLUGIN_NAME,
           CAST('version'        as CHAR(20)) as PLUGIN,
           CAST('plugin status'  as CHAR(10)) as PLUGIN_STATUS,
           CAST('type'           as CHAR(80)) as PLUGIN_TYPE,
           CAST('version'        as CHAR(20)) as PLUGIN_TYPE_VERSION,
           CAST('library'        as CHAR(64)) as PLUGIN_LIBRARY,
           CAST('lib version'    as CHAR(20)) as PLUGIN_LIBRARY_VERSION,
           CAST('author'         as CHAR(64)) as PLUGIN_AUTHOR,
           CAST('description'    as CHAR(200)) as PLUGIN_DESCRIPTION,
           CAST('license'        as CHAR(80)) as PLUGIN_LICENSE,
           CAST('load option'    as CHAR(64)) as LOAD_OPTION
    FROM DUAL limit 0;
  """.replace("\n", " ")
)

def_table_schema(
  owner         = 'sanquan.qz',
  tablegroup_id = 'OB_INVALID_ID',
  database_id   = 'OB_INFORMATION_SCHEMA_ID',
  table_name    = 'INNODB_SYS_COLUMNS',
  table_id      = '20019',
  table_type    = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT CAST(000000000000000000000 as UNSIGNED) AS TABLE_ID,
           CAST('name'               as CHAR(193)) AS NAME,
           CAST(000000000000000000000 as UNSIGNED) AS POS,
           CAST(00000000000 as SIGNED) AS MTYPE,
           CAST(00000000000 as SIGNED) AS PRTYPE,
           CAST(00000000000 as SIGNED) AS LEN
    FROM DUAL limit 0;
  """.replace("\n", " ")
)


def_table_schema(
  owner           = 'sanquan.qz',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'INNODB_FT_BEING_DELETED',
  table_id        = '20020',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT CAST(000000000000000000000 as UNSIGNED) AS DOC_ID
    FROM DUAL limit 0;
  """.replace("\n", " ")
)

def_table_schema(
  owner           = 'sanquan.qz',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'INNODB_FT_CONFIG',
  table_id        = '20021',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT CAST('key'               as CHAR(100)) AS FT_CONFIG_KEY,
           CAST('value'             as CHAR(100)) AS VALUE
    FROM DUAL limit 0;
  """.replace("\n", " ")
)

def_table_schema(
  owner           = 'sanquan.qz',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'INNODB_FT_DELETED',
  table_id        = '20022',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT CAST(000000000000000000000 as UNSIGNED) AS DOC_ID
    FROM DUAL limit 0;
  """.replace("\n", " ")
)

def_table_schema(
  owner           = 'sanquan.qz',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'INNODB_FT_INDEX_CACHE',
  table_id        = '20023',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT CAST('word'               as CHAR(193)) AS WORD,
           CAST(000000000000000000000 as UNSIGNED) AS FIRST_DOC_ID,
           CAST(000000000000000000000 as UNSIGNED) AS LAST_DOC_ID,
           CAST(000000000000000000000 as UNSIGNED) AS DOC_COUNT,
           CAST(000000000000000000000 as UNSIGNED) AS DOC_ID,
           CAST(000000000000000000000 as UNSIGNED) AS POSITION
    FROM DUAL limit 0;
  """.replace("\n", " ")
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = 'GV$SESSION_EVENT',
  table_id       = '21000',
  gm_columns = [],
  rowkey_columns = [],
  table_type = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """
  select tenant_id as CON_ID,
         svr_ip as SVR_IP,
         svr_port as SVR_PORT,
         session_id as SID,
         event as EVENT,
         total_waits as TOTAL_WAITS,
         total_timeouts as TOTAL_TIMEOUTS,
         time_waited as TIME_WAITED,
         average_wait as AVERAGE_WAIT,
         max_wait as MAX_WAIT,
         time_waited_micro as TIME_WAITED_MICRO,
         cast(null as UNSIGNED) as CPU,
         event_id as EVENT_ID,
         wait_class_id as WAIT_CLASS_ID,
         `wait_class#` as `WAIT_CLASS#`,
         wait_class as WAIT_CLASS
  from oceanbase.__all_virtual_session_event
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = 'GV$SESSION_WAIT',
  table_id       = '21001',
  gm_columns = [],
  rowkey_columns = [],
  table_type = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """select session_id as SID,
                   tenant_id as CON_ID,
                   svr_ip as SVR_IP,
                   svr_port as SVR_PORT,
                   event as EVENT,
                   p1text as P1TEXT,
                   p1 as P1,
                   p2text as P2TEXT,
                   p2 as P2,
                   p3text as P3TEXT,
                   p3 as P3,
                   wait_class_id as WAIT_CLASS_ID,
                   `wait_class#` as `WAIT_CLASS#`,
                   wait_class as WAIT_CLASS,
                   state as STATE,
                   wait_time_micro as WAIT_TIME_MICRO,
                   time_remaining_micro as TIME_REMAINING_MICRO,
                   time_since_last_wait_micro as TIME_SINCE_LAST_WAIT_MICRO
                   from oceanbase.__all_virtual_session_wait
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = 'GV$SESSION_WAIT_HISTORY',
  table_id       = '21002',
  gm_columns = [],
  rowkey_columns = [],
  table_type = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """select session_id as SID,
                   tenant_id as CON_ID,
                   svr_ip as SVR_IP,
                   svr_port as SVR_PORT,
                   `seq#` as `SEQ#`,
                   `event#` as `EVENT#`,
                   event as EVENT,
                   p1text as P1TEXT,
                   p1 as P1,
                   p2text as P2TEXT,
                   p2 as P2,
                   p3text as P3TEXT,
                   p3 as P3,
                   wait_time as WAIT_TIME,
                   wait_time_micro as WAIT_TIME_MICRO,
                   time_since_last_wait_micro as TIME_SINCE_LAST_WAIT_MICRO
                   from oceanbase.__all_virtual_session_wait_history
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = 'GV$SYSTEM_EVENT',
  table_id       = '21003',
  gm_columns = [],
  rowkey_columns = [],
  table_type = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """select tenant_id as CON_ID,
                   svr_ip as SVR_IP,
                   svr_port as SVR_PORT,
                   event_id as EVENT_ID,
                   event as EVENT,
                   wait_class_id as WAIT_CLASS_ID,
                   `wait_class#` as `WAIT_CLASS#`,
                   wait_class as WAIT_CLASS,
                   total_waits as TOTAL_WAITS,
                   total_timeouts as TOTAL_TIMEOUTS,
                   time_waited as TIME_WAITED,
                   average_wait as AVERAGE_WAIT,
                   time_waited_micro as TIME_WAITED_MICRO
                   from oceanbase.__all_virtual_system_event
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = 'GV$SESSTAT',
  table_id       = '21004',
  gm_columns = [],
  rowkey_columns = [],
  table_type = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """select session_id as SID,
                   tenant_id as CON_ID,
                   svr_ip as SVR_IP,
                   svr_port as SVR_PORT,
                   `statistic#` as `STATISTIC#`,
                   value as VALUE
                   from oceanbase.__all_virtual_sesstat
                   where can_visible = true
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'roland.qk',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = 'GV$SYSSTAT',
  table_id       = '21005',
  gm_columns = [],
  rowkey_columns = [],
  table_type = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """
  select tenant_id as CON_ID,
         svr_ip as SVR_IP,
         svr_port as SVR_PORT,
         `statistic#` as `STATISTIC#`,
         name as NAME,
         class as CLASS,
         value as VALUE,
         value_type as VALUE_TYPE,
         stat_id as STAT_ID
         from oceanbase.__all_virtual_sysstat
   where can_visible = true
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = 'V$STATNAME',
  table_id       = '21006',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,
  table_type = 'SYSTEM_VIEW',
  view_definition = """
  select tenant_id as CON_ID,
         stat_id as STAT_ID,
         `statistic#` as `STATISTIC#`,
         name as NAME,
         display_name as DISPLAY_NAME,
         class as CLASS
  from oceanbase.__tenant_virtual_statname
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id  = 'OB_INVALID_ID',
  table_name     = 'V$EVENT_NAME',
  table_id       = '21007',
  gm_columns = [],
  rowkey_columns = [],
  table_type = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """select tenant_id as CON_ID,
  event_id as EVENT_ID,
  `event#` as `EVENT#`,
  name as NAME,
  display_name as DISPLAY_NAME,
  parameter1 as PARAMETER1,
  parameter2 as PARAMETER2,
  parameter3 as PARAMETER3,
  wait_class_id as WAIT_CLASS_ID,
  `wait_class#` as `WAIT_CLASS#`,
  wait_class as WAIT_CLASS
from oceanbase.__tenant_virtual_event_name
""".replace("\n", " "),

  normal_columns = [],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'V$SESSION_EVENT',
  table_id        = '21008',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """
  SELECT CON_ID,
         SVR_IP,
         SVR_PORT,
         SID,
         EVENT,
         TOTAL_WAITS,
         TOTAL_TIMEOUTS,
         TIME_WAITED,
         AVERAGE_WAIT,
         MAX_WAIT,
         TIME_WAITED_MICRO,
         CPU,
         EVENT_ID,
         WAIT_CLASS_ID,
         `WAIT_CLASS#`,
         WAIT_CLASS FROM OCEANBASE.GV$SESSION_EVENT
  WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " "),

  normal_columns  = [],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'V$SESSION_WAIT',
  table_id        = '21009',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """
   SELECT SID,
          CON_ID,
          SVR_IP,
          SVR_PORT,
          EVENT,
          P1TEXT,
          P1,
          P2TEXT,
          P2,
          P3TEXT,
          P3,
          WAIT_CLASS_ID,
          `WAIT_CLASS#`,
          WAIT_CLASS,
          STATE,
          WAIT_TIME_MICRO,
          TIME_REMAINING_MICRO,
          TIME_SINCE_LAST_WAIT_MICRO FROM OCEANBASE.GV$SESSION_WAIT
                     WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " "),

  normal_columns  = [],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'V$SESSION_WAIT_HISTORY',
  table_id        = '21010',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """SELECT
    SID,
    CON_ID,
    SVR_IP,
    SVR_PORT,
    `SEQ#`,
    `EVENT#`,
    EVENT,
    P1TEXT,
    P1,
    P2TEXT,
    P2,
    P3TEXT,
    P3,
    WAIT_TIME,
    WAIT_TIME_MICRO,
    TIME_SINCE_LAST_WAIT_MICRO FROM OCEANBASE.GV$SESSION_WAIT_HISTORY
                     WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " "),

  normal_columns  = [],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'V$SESSTAT',
  table_id        = '21011',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """SELECT SID,
    CON_ID,
    SVR_IP,
    SVR_PORT,
    `STATISTIC#`,
    VALUE FROM OCEANBASE.GV$SESSTAT
                     WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " "),

  normal_columns  = [],
)

def_table_schema(
  owner = 'roland.qk',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'V$SYSSTAT',
  table_id        = '21012',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """SELECT CON_ID,
    SVR_IP,
    SVR_PORT,
    `STATISTIC#`,
    NAME,
    CLASS,
    VALUE,
    VALUE_TYPE,
    STAT_ID FROM OCEANBASE.GV$SYSSTAT
                     WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " "),

  normal_columns  = [],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'V$SYSTEM_EVENT',
  table_id        = '21013',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """SELECT CON_ID,
    SVR_IP,
    SVR_PORT,
    EVENT_ID,
    EVENT,
    WAIT_CLASS_ID,
    `WAIT_CLASS#`,
    WAIT_CLASS,
    TOTAL_WAITS,
    TOTAL_TIMEOUTS,
    TIME_WAITED,
    AVERAGE_WAIT,
    TIME_WAITED_MICRO FROM OCEANBASE.GV$SYSTEM_EVENT
                     WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " "),

  normal_columns  = [],
)

def_table_schema(
  owner = 'xiaoyi.xy',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'GV$OB_SQL_AUDIT',
  table_id        = '21014',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """select
                         svr_ip as SVR_IP,
                         svr_port as SVR_PORT,
                         request_id as REQUEST_ID,
                         execution_id as SQL_EXEC_ID,
                         trace_id as TRACE_ID,
                         session_id as SID,
                         client_ip as CLIENT_IP,
                         client_port as CLIENT_PORT,
                         tenant_id as TENANT_ID,
                         tenant_name as TENANT_NAME,
                         effective_tenant_id as EFFECTIVE_TENANT_ID,
                         user_id as USER_ID,
                         user_name as USER_NAME,
                         user_group as USER_GROUP,
                         user_client_ip as USER_CLIENT_IP,
                         db_id as DB_ID,
                         db_name as DB_NAME,
                         sql_id as SQL_ID,
                         query_sql as QUERY_SQL,
                         plan_id as PLAN_ID,
                         affected_rows as AFFECTED_ROWS,
                         return_rows as RETURN_ROWS,
                         partition_cnt as PARTITION_CNT,
                         ret_code as RET_CODE,
                         qc_id as QC_ID,
                         dfo_id as DFO_ID,
                         sqc_id as SQC_ID,
                         worker_id as WORKER_ID,
                         event as EVENT,
                         p1text as P1TEXT,
                         p1 as P1,
                         p2text as P2TEXT,
                         p2 as P2,
                         p3text as P3TEXT,
                         p3 as P3,
                         `level` as `LEVEL`,
                         wait_class_id as WAIT_CLASS_ID,
                         `wait_class#` as `WAIT_CLASS#`,
                         wait_class as WAIT_CLASS,
                         state as STATE,
                         wait_time_micro as WAIT_TIME_MICRO,
                         total_wait_time_micro as TOTAL_WAIT_TIME_MICRO,
                         total_waits as TOTAL_WAITS,
                         rpc_count as RPC_COUNT,
                         plan_type as PLAN_TYPE,
                         is_inner_sql as IS_INNER_SQL,
                         is_executor_rpc as IS_EXECUTOR_RPC,
                         is_hit_plan as IS_HIT_PLAN,
                         request_time as REQUEST_TIME,
                         elapsed_time as ELAPSED_TIME,
                         net_time as NET_TIME,
                         net_wait_time as NET_WAIT_TIME,
                         queue_time as QUEUE_TIME,
                         decode_time as DECODE_TIME,
                         get_plan_time as GET_PLAN_TIME,
                         execute_time as EXECUTE_TIME,
                         application_wait_time as APPLICATION_WAIT_TIME,
                         concurrency_wait_time as CONCURRENCY_WAIT_TIME,
                         user_io_wait_time as USER_IO_WAIT_TIME,
                         schedule_time as SCHEDULE_TIME,
                         row_cache_hit as ROW_CACHE_HIT,
                         bloom_filter_cache_hit as BLOOM_FILTER_CACHE_HIT,
                         block_cache_hit as BLOCK_CACHE_HIT,
                         disk_reads as DISK_READS,
                         retry_cnt as RETRY_CNT,
                         table_scan as TABLE_SCAN,
                         consistency_level as CONSISTENCY_LEVEL,
                         memstore_read_row_count as MEMSTORE_READ_ROW_COUNT,
                         ssstore_read_row_count as SSSTORE_READ_ROW_COUNT,
                         data_block_read_cnt as DATA_BLOCK_READ_CNT,
                         data_block_cache_hit as DATA_BLOCK_CACHE_HIT,
                         index_block_read_cnt as INDEX_BLOCK_READ_CNT,
                         index_block_cache_hit as INDEX_BLOCK_CACHE_HIT,
                         blockscan_block_cnt as BLOCKSCAN_BLOCK_CNT,
                         blockscan_row_cnt as BLOCKSCAN_ROW_CNT,
                         pushdown_storage_filter_row_cnt as PUSHDOWN_STORAGE_FILTER_ROW_CNT,
                         request_memory_used as REQUEST_MEMORY_USED,
                         expected_worker_count as EXPECTED_WORKER_COUNT,
                         used_worker_count as USED_WORKER_COUNT,
                         sched_info as SCHED_INFO,
                         fuse_row_cache_hit as FUSE_ROW_CACHE_HIT,
                         ps_client_stmt_id as PS_CLIENT_STMT_ID,
                         ps_inner_stmt_id as PS_INNER_STMT_ID,
                         transaction_id as TX_ID,
                         snapshot_version as SNAPSHOT_VERSION,
                         request_type as REQUEST_TYPE,
                         is_batched_multi_stmt as IS_BATCHED_MULTI_STMT,
                         ob_trace_info as OB_TRACE_INFO,
                         plan_hash as PLAN_HASH,
                         lock_for_read_time as LOCK_FOR_READ_TIME,
                         params_value as PARAMS_VALUE,
                         rule_name as RULE_NAME,
                         partition_hit as PARTITION_HIT,
                         case when tx_internal_route_flag & 96 = 32 then 1 else 0 end
                           as TX_INTERNAL_ROUTING,
                         tx_internal_route_version as TX_STATE_VERSION,
                         flt_trace_id as FLT_TRACE_ID,
                         pl_trace_id as PL_TRACE_ID,
                         plsql_exec_time as PLSQL_EXEC_TIME,
                         format_sql_id as FORMAT_SQL_ID,
                         stmt_type as STMT_TYPE,
                         total_memstore_read_row_count as TOTAL_MEMSTORE_READ_ROW_COUNT,
                         total_ssstore_read_row_count as TOTAL_SSSTORE_READ_ROW_COUNT,
                         proxy_user as PROXY_USER,
                         seq_num as SEQ_NUM,
                         network_wait_time as NETWORK_WAIT_TIME,
                         plsql_compile_time as PLSQL_COMPILE_TIME
                     from oceanbase.__all_virtual_sql_audit
""".replace("\n", " "),

  normal_columns  = [],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'GV$LATCH',
  table_id        = '21015',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """select tenant_id as CON_ID,
                     svr_ip as SVR_IP,
                     svr_port as SVR_PORT,
                     addr as ADDR,
                     latch_id as `LATCH#`,
                     `level` as `LEVEL#`,
                     name as NAME,
                     hash as HASH,
                     gets as GETS,
                     misses as MISSES,
                     sleeps as SLEEPS,
                     immediate_gets as IMMEDIATE_GETS,
                     immediate_misses as IMMEDIATE_MISSES,
                     spin_gets as SPIN_GETS,
                     wait_time as WAIT_TIME from oceanbase.__all_virtual_latch
""".replace("\n", " "),

  normal_columns  = [],
)

def_table_schema(
  owner = 'nijia.nj',
  table_name      = 'GV$OB_MEMORY',
  table_id        = '21016',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
     TENANT_ID,
     svr_ip AS SVR_IP,
     svr_port AS SVR_PORT,
     ctx_name AS CTX_NAME,
     mod_name AS MOD_NAME,
     sum(COUNT) AS COUNT,
     sum(hold) AS HOLD,
     sum(USED) AS USED
FROM
    oceanbase.__all_virtual_memory_info
WHERE
        mod_type='user'
GROUP BY tenant_id, svr_ip, svr_port, ctx_name, mod_name
ORDER BY tenant_id, svr_ip, svr_port, ctx_name, mod_name
""".replace("\n", " "),

)

def_table_schema(
  owner = 'nijia.nj',
  table_name      = 'V$OB_MEMORY',
  table_id        = '21017',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
  TENANT_ID,
    SVR_IP,
    SVR_PORT,
    CTX_NAME,
    MOD_NAME,
    COUNT,
    HOLD,
    USED
FROM
    oceanbase.GV$OB_MEMORY
WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'jingyan.kfy',
  table_name      = 'GV$OB_MEMSTORE',
  table_id        = '21018',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
    SVR_IP,
    SVR_PORT,
    TENANT_ID,
    ACTIVE_SPAN,
    FREEZE_TRIGGER,
    FREEZE_CNT,
    MEMSTORE_USED,
    MEMSTORE_LIMIT
FROM
    oceanbase.__all_virtual_tenant_memstore_info
""".replace("\n", " "),

)

def_table_schema(
  owner = 'jingyan.kfy',
  table_name      = 'V$OB_MEMSTORE',
  table_id        = '21019',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
    SVR_IP,
    SVR_PORT,
    TENANT_ID,
    ACTIVE_SPAN,
    FREEZE_TRIGGER,
    FREEZE_CNT,
    MEMSTORE_USED,
    MEMSTORE_LIMIT
FROM
    OCEANBASE.GV$OB_MEMSTORE
WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " "),

)

def_table_schema(
  owner = 'jingyan.kfy',
  table_name      = 'GV$OB_MEMSTORE_INFO',
  table_id        = '21020',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
    SVR_IP,
    SVR_PORT,
    TENANT_ID,
    LS_ID,
    TABLET_ID,
    IS_ACTIVE,
    START_SCN,
    END_SCN,
    FREEZE_TS
FROM
    oceanbase.__all_virtual_memstore_info
""".replace("\n", " "),

)

def_table_schema(
  owner = 'jingyan.kfy',
  table_name      = 'V$OB_MEMSTORE_INFO',
  table_id        = '21021',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
    SVR_IP,
    SVR_PORT,
    TENANT_ID,
    LS_ID,
    TABLET_ID,
    IS_ACTIVE,
    START_SCN,
    END_SCN,
    FREEZE_TS
FROM
    OCEANBASE.GV$OB_MEMSTORE_INFO
WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " "),

)

def_table_schema(
  owner = 'xiaoyi.xy',
  table_name     = 'V$OB_PLAN_CACHE_STAT',
  table_id       = '21022',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [],
  view_definition = """
  SELECT TENANT_ID,SVR_IP,SVR_PORT,SQL_NUM,MEM_USED,MEM_HOLD,ACCESS_COUNT,
  HIT_COUNT,HIT_RATE,PLAN_NUM,MEM_LIMIT,HASH_BUCKET,STMTKEY_NUM
  FROM oceanbase.GV$OB_PLAN_CACHE_STAT WHERE svr_ip=HOST_IP() AND svr_port=RPC_PORT()
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
    owner = 'xiaoyi.xy',
    table_name     = 'V$OB_PLAN_CACHE_PLAN_STAT',
    table_id       = '21023',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
  SELECT TENANT_ID,SVR_IP,SVR_PORT,PLAN_ID,SQL_ID,TYPE,IS_BIND_SENSITIVE,IS_BIND_AWARE,
    DB_ID,STATEMENT,QUERY_SQL,SPECIAL_PARAMS,PARAM_INFOS, SYS_VARS, CONFIGS, PLAN_HASH,
    FIRST_LOAD_TIME,SCHEMA_VERSION,LAST_ACTIVE_TIME,AVG_EXE_USEC,SLOWEST_EXE_TIME,SLOWEST_EXE_USEC,
    SLOW_COUNT,HIT_COUNT,PLAN_SIZE,EXECUTIONS,DISK_READS,DIRECT_WRITES,BUFFER_GETS,APPLICATION_WAIT_TIME,
    CONCURRENCY_WAIT_TIME,USER_IO_WAIT_TIME,ROWS_PROCESSED,ELAPSED_TIME,CPU_TIME,LARGE_QUERYS,
    DELAYED_LARGE_QUERYS,DELAYED_PX_QUERYS,OUTLINE_VERSION,OUTLINE_ID,OUTLINE_DATA,ACS_SEL_INFO,
    TABLE_SCAN,EVOLUTION, EVO_EXECUTIONS, EVO_CPU_TIME, TIMEOUT_COUNT, PS_STMT_ID, SESSID,
    TEMP_TABLES, IS_USE_JIT,OBJECT_TYPE,HINTS_INFO,HINTS_ALL_WORKED, PL_SCHEMA_ID,
    IS_BATCHED_MULTI_STMT, RULE_NAME, PLAN_STATUS, ADAPTIVE_FEEDBACK_TIMES
  FROM oceanbase.GV$OB_PLAN_CACHE_PLAN_STAT WHERE svr_ip=HOST_IP() AND svr_port=RPC_PORT()
""".replace("\n", " "),


    normal_columns = [
    ],
)

def_table_schema(
    owner = 'xiaoyi.xy',
    table_name     = 'GV$OB_PLAN_CACHE_PLAN_EXPLAIN',
    table_id       = '21024',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
    SELECT TENANT_ID,
           SVR_IP,
           SVR_PORT,
           PLAN_ID,
           PLAN_DEPTH,
           PLAN_LINE_ID,
           OPERATOR,
           NAME,
           ROWS,
           COST,
           PROPERTY
   FROM oceanbase.__all_virtual_plan_cache_plan_explain
""".replace("\n", " "),
    normal_columns = [
    ],
)

def_table_schema(
    owner = 'xiaoyi.xy',
    table_name     = 'V$OB_PLAN_CACHE_PLAN_EXPLAIN',
    table_id       = '21025',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
    SELECT TENANT_ID,
           SVR_IP,
           SVR_PORT,
           PLAN_ID,
           PLAN_DEPTH,
           PLAN_LINE_ID,
           OPERATOR,
           NAME,
           ROWS,
           COST,
           PROPERTY FROM oceanbase.GV$OB_PLAN_CACHE_PLAN_EXPLAIN WHERE SVR_IP =HOST_IP() AND SVR_PORT = RPC_PORT()
""".replace("\n", " "),


    normal_columns = [
    ],
)

def_table_schema(
    owner = 'xiaoyi.xy',
    tablegroup_id  = 'OB_INVALID_ID',
    table_name     = 'V$OB_SQL_AUDIT',
    table_id       = '21026',
    gm_columns     = [],
    rowkey_columns = [],
    table_type     = 'SYSTEM_VIEW',
    in_tenant_space = True,
    view_definition = """SELECT SVR_IP,
    SVR_PORT,
    REQUEST_ID,
    SQL_EXEC_ID,
    TRACE_ID,
    SID,
    CLIENT_IP,
    CLIENT_PORT,
    TENANT_ID,
    TENANT_NAME,
    EFFECTIVE_TENANT_ID,
    USER_ID,
    USER_NAME,
    USER_GROUP,
    USER_CLIENT_IP,
    DB_ID,
    DB_NAME,
    SQL_ID,
    QUERY_SQL,
    PLAN_ID,
    AFFECTED_ROWS,
    RETURN_ROWS,
    PARTITION_CNT,
    RET_CODE,
    QC_ID,
    DFO_ID,
    SQC_ID,
    WORKER_ID,
    EVENT,
    P1TEXT,
    P1,
    P2TEXT,
    P2,
    P3TEXT,
    P3,
    `LEVEL`,
    WAIT_CLASS_ID,
    `WAIT_CLASS#`,
    WAIT_CLASS,
    STATE,
    WAIT_TIME_MICRO,
    TOTAL_WAIT_TIME_MICRO,
    TOTAL_WAITS,
    RPC_COUNT,
    PLAN_TYPE,
    IS_INNER_SQL,
    IS_EXECUTOR_RPC,
    IS_HIT_PLAN,
    REQUEST_TIME,
    ELAPSED_TIME,
    NET_TIME,
    NET_WAIT_TIME,
    QUEUE_TIME,
    DECODE_TIME,
    GET_PLAN_TIME,
    EXECUTE_TIME,
    APPLICATION_WAIT_TIME,
    CONCURRENCY_WAIT_TIME,
    USER_IO_WAIT_TIME,
    SCHEDULE_TIME,
    ROW_CACHE_HIT,
    BLOOM_FILTER_CACHE_HIT,
    BLOCK_CACHE_HIT,
    DISK_READS,
    RETRY_CNT,
    TABLE_SCAN,
    CONSISTENCY_LEVEL,
    MEMSTORE_READ_ROW_COUNT,
    SSSTORE_READ_ROW_COUNT,
    DATA_BLOCK_READ_CNT,
    DATA_BLOCK_CACHE_HIT,
    INDEX_BLOCK_READ_CNT,
    INDEX_BLOCK_CACHE_HIT,
    BLOCKSCAN_BLOCK_CNT,
    BLOCKSCAN_ROW_CNT,
    PUSHDOWN_STORAGE_FILTER_ROW_CNT,
    REQUEST_MEMORY_USED,
    EXPECTED_WORKER_COUNT,
    USED_WORKER_COUNT,
    SCHED_INFO,
    FUSE_ROW_CACHE_HIT,
    PS_CLIENT_STMT_ID,
    PS_INNER_STMT_ID,
    TX_ID,
    SNAPSHOT_VERSION,
    REQUEST_TYPE,
    IS_BATCHED_MULTI_STMT,
    OB_TRACE_INFO,
    PLAN_HASH,
    LOCK_FOR_READ_TIME,
    PARAMS_VALUE,
    RULE_NAME,
    PARTITION_HIT,
    TX_INTERNAL_ROUTING,
    TX_STATE_VERSION,
    FLT_TRACE_ID,
    PL_TRACE_ID,
    PLSQL_EXEC_TIME,
    FORMAT_SQL_ID,
    stmt_type as STMT_TYPE,
    TOTAL_MEMSTORE_READ_ROW_COUNT,
    TOTAL_SSSTORE_READ_ROW_COUNT,
    PROXY_USER,
    SEQ_NUM,
    NETWORK_WAIT_TIME,
    PLSQL_COMPILE_TIME
  FROM oceanbase.GV$OB_SQL_AUDIT WHERE svr_ip=HOST_IP() AND svr_port=RPC_PORT()
""".replace("\n", " "),

    normal_columns = [
    ],
)

def_table_schema(
  owner = 'yuzhong.zhao',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'V$LATCH',
  table_id        = '21027',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """
  SELECT CON_ID,
    SVR_IP,
    SVR_PORT,
    ADDR,
    `LATCH#`,
    `LEVEL#`,
    NAME,
    HASH,
    GETS,
    MISSES,
    SLEEPS,
    IMMEDIATE_GETS,
    IMMEDIATE_MISSES,
    SPIN_GETS,
    WAIT_TIME FROM OCEANBASE.GV$LATCH WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " "),

  normal_columns  = [],
)

def_table_schema(
  owner = 'yuanqi.xhf',
  table_name      = 'GV$OB_RPC_OUTGOING',
  table_id        = '21028',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
    TENANT_ID,
    SVR_IP,
    SVR_PORT,
    PCODE,
    PCODE_NAME,
    COUNT,
    TOTAL_TIME,
    TOTAL_SIZE,
    FAILURE,
    TIMEOUT,
    SYNC,
    ASYNC,
    LAST_TIMESTAMP
FROM
    oceanbase.__all_virtual_obrpc_stat
""".replace("\n", " "),

)

def_table_schema(
  owner = 'yuanqi.xhf',
  table_name      = 'V$OB_RPC_OUTGOING',
  table_id        = '21029',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
    TENANT_ID,
    SVR_IP,
    SVR_PORT,
    PCODE,
    PCODE_NAME,
    COUNT,
    TOTAL_TIME,
    TOTAL_SIZE,
    FAILURE,
    TIMEOUT,
    SYNC,
    ASYNC,
    LAST_TIMESTAMP
FROM
    oceanbase.GV$OB_RPC_OUTGOING
WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " "),

)

def_table_schema(
  owner = 'yuanqi.xhf',
  table_name      = 'GV$OB_RPC_INCOMING',
  table_id        = '21030',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
    TENANT_ID,
    SVR_IP,
    SVR_PORT,
    PCODE,
    PCODE_NAME,
    ICOUNT AS COUNT,
    ISIZE AS TOTAL_SIZE,
    NET_TIME,
    WAIT_TIME,
    QUEUE_TIME,
    PROCESS_TIME,
    ILAST_TIMESTAMP AS LAST_TIMESTAMP,
    DCOUNT
FROM
    oceanbase.__all_virtual_obrpc_stat
""".replace("\n", " "),

)


def_table_schema(
  owner = 'yuanqi.xhf',
  table_name      = 'V$OB_RPC_INCOMING',
  table_id        = '21031',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
    TENANT_ID,
    SVR_IP,
    SVR_PORT,
    PCODE,
    PCODE_NAME,
    COUNT,
    TOTAL_SIZE,
    NET_TIME,
    WAIT_TIME,
    QUEUE_TIME,
    PROCESS_TIME,
    LAST_TIMESTAMP,
    DCOUNT
FROM
    oceanbase.GV$OB_RPC_INCOMING
WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " "),

)

# 21032: GV$SQL # abandoned in 4.0
# 21033: V$SQL # abandoned in 4.0
# 21034: GV$SQL_MONITOR # abandoned in 4.0
# 21035: V$SQL_MONITOR # abandoned in 4.0

def_table_schema(
    owner = 'xiaochu.yh',
    table_name     = 'GV$SQL_PLAN_MONITOR',
    table_id       = '21036',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
          SELECT
          TENANT_ID as CON_ID,
          REQUEST_ID,
          CAST(NULL as UNSIGNED) AS `KEY`,
          CAST(NULL AS CHAR(19)) as STATUS,
          SVR_IP,
          SVR_PORT,
          TRACE_ID,
          DB_TIME,
          USER_IO_WAIT_TIME,
          CAST(NULL AS UNSIGNED) AS OTHER_WAIT_TIME,
          FIRST_REFRESH_TIME,
          LAST_REFRESH_TIME,
          FIRST_CHANGE_TIME,
          LAST_CHANGE_TIME,
          CAST(NULL AS UNSIGNED) AS REFRESH_COUNT,
          CAST(NULL AS UNSIGNED) AS SID,
          THREAD_ID  PROCESS_NAME,
          SQL_ID,
          CAST(NULL AS UNSIGNED) AS SQL_EXEC_START,
          CAST(NULL AS UNSIGNED) AS SQL_EXEC_ID,
          PLAN_HASH_VALUE AS SQL_PLAN_HASH_VALUE,
          CAST(NULL AS BINARY(8)) AS SQL_CHILD_ADDRESS,
          CAST(NULL AS UNSIGNED) AS PLAN_PARENT_ID,
          PLAN_LINE_ID,
          PLAN_OPERATION,
          CAST(NULL AS CHAR(30)) PLAN_OPTIONS,
          CAST(NULL AS CHAR(128)) PLAN_OBJECT_OWNER,
          CAST(NULL AS CHAR(128)) PLAN_OBJECT_NAME,
          CAST(NULL AS CHAR(80)) PLAN_OBJECT_TYPE,
          PLAN_DEPTH,
          CAST( NULL AS UNSIGNED) AS PLAN_POSITION,
          CAST( NULL AS UNSIGNED) AS PLAN_COST,
          CAST( NULL AS UNSIGNED) AS PLAN_CARDINALITY,
          CAST( NULL AS UNSIGNED) AS PLAN_BYTES,
          CAST( NULL AS UNSIGNED) AS PLAN_TIME,
          CAST( NULL AS UNSIGNED) AS PLAN_PARTITION_START,
          CAST( NULL AS UNSIGNED) AS PLAN_PARTITION_STOP,
          CAST( NULL AS UNSIGNED) AS PLAN_CPU_COST,
          CAST( NULL AS UNSIGNED) AS PLAN_IO_COST,
          CAST( NULL AS UNSIGNED) AS PLAN_TEMP_SPACE,
          STARTS,
          OUTPUT_ROWS,
          CAST( NULL AS UNSIGNED) AS IO_INTERCONNECT_BYTES,
          CAST( NULL AS UNSIGNED) AS PHYSICAL_READ_REQUESTS,
          CAST( NULL AS UNSIGNED) AS PHYSICAL_READ_BYTES,
          CAST( NULL AS UNSIGNED) AS PHYSICAL_WRITE_REQUESTS,
          CAST( NULL AS UNSIGNED) AS PHYSICAL_WRITE_BYTES,
          CAST( WORKAREA_MEM AS UNSIGNED) AS WORKAREA_MEM,
          CAST( WORKAREA_MAX_MEM AS UNSIGNED) AS WORKAREA_MAX_MEM,
          CAST( WORKAREA_TEMPSEG AS UNSIGNED) AS WORKAREA_TEMPSEG,
          CAST( WORKAREA_MAX_TEMPSEG AS UNSIGNED) AS WORKAREA_MAX_TEMPSEG,
          CAST( NULL AS UNSIGNED) AS OTHERSTAT_GROUP_ID,
          OTHERSTAT_1_ID,
          CAST(NULL AS UNSIGNED) AS OTHERSTAT_1_TYPE,
          OTHERSTAT_1_VALUE,
          OTHERSTAT_2_ID,
          CAST(NULL AS UNSIGNED) OTHERSTAT_2_TYPE,
          OTHERSTAT_2_VALUE,
          OTHERSTAT_3_ID,
          CAST(NULL AS UNSIGNED) OTHERSTAT_3_TYPE,
          OTHERSTAT_3_VALUE,
          OTHERSTAT_4_ID,
          CAST(NULL AS UNSIGNED) OTHERSTAT_4_TYPE,
          OTHERSTAT_4_VALUE,
          OTHERSTAT_5_ID,
          CAST(NULL AS UNSIGNED) OTHERSTAT_5_TYPE,
          OTHERSTAT_5_VALUE,
          OTHERSTAT_6_ID,
          CAST(NULL AS UNSIGNED) OTHERSTAT_6_TYPE,
          OTHERSTAT_6_VALUE,
          OTHERSTAT_7_ID,
          CAST(NULL AS UNSIGNED) OTHERSTAT_7_TYPE,
          OTHERSTAT_7_VALUE,
          OTHERSTAT_8_ID,
          CAST(NULL AS UNSIGNED) OTHERSTAT_8_TYPE,
          OTHERSTAT_8_VALUE,
          OTHERSTAT_9_ID,
          CAST(NULL AS UNSIGNED) OTHERSTAT_9_TYPE,
          OTHERSTAT_9_VALUE,
          OTHERSTAT_10_ID,
          CAST(NULL AS UNSIGNED) OTHERSTAT_10_TYPE,
          OTHERSTAT_10_VALUE,
          CAST(NULL AS CHAR(255)) AS OTHER_XML,
          CAST(NULL AS UNSIGNED) AS PLAN_OPERATION_INACTIVE,
          OUTPUT_BATCHES,
          SKIPPED_ROWS_COUNT
        FROM oceanbase.__all_virtual_sql_plan_monitor
""".replace("\n", " "),

    normal_columns = [
    ],
)

def_table_schema(
    owner = 'xiaochu.yh',
    table_name     = 'V$SQL_PLAN_MONITOR',
    table_id       = '21037',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
    SELECT  CON_ID,
    REQUEST_ID,
    `KEY`,
    STATUS,
    SVR_IP,
    SVR_PORT,
    TRACE_ID,
    DB_TIME,
    USER_IO_WAIT_TIME,
    OTHER_WAIT_TIME,
    FIRST_REFRESH_TIME,
    LAST_REFRESH_TIME,
    FIRST_CHANGE_TIME,
    LAST_CHANGE_TIME,
    REFRESH_COUNT,
    SID,
    PROCESS_NAME,
    SQL_ID,
    SQL_EXEC_START,
    SQL_EXEC_ID,
    SQL_PLAN_HASH_VALUE,
    SQL_CHILD_ADDRESS,
    PLAN_PARENT_ID,
    PLAN_LINE_ID,
    PLAN_OPERATION,
    PLAN_OPTIONS,
    PLAN_OBJECT_OWNER,
    PLAN_OBJECT_NAME,
    PLAN_OBJECT_TYPE,
    PLAN_DEPTH,
    PLAN_POSITION,
    PLAN_COST,
    PLAN_CARDINALITY,
    PLAN_BYTES,
    PLAN_TIME,
    PLAN_PARTITION_START,
    PLAN_PARTITION_STOP,
    PLAN_CPU_COST,
    PLAN_IO_COST,
    PLAN_TEMP_SPACE,
    STARTS,
    OUTPUT_ROWS,
    IO_INTERCONNECT_BYTES,
    PHYSICAL_READ_REQUESTS,
    PHYSICAL_READ_BYTES,
    PHYSICAL_WRITE_REQUESTS,
    PHYSICAL_WRITE_BYTES,
    WORKAREA_MEM,
    WORKAREA_MAX_MEM,
    WORKAREA_TEMPSEG,
    WORKAREA_MAX_TEMPSEG,
    OTHERSTAT_GROUP_ID,
    OTHERSTAT_1_ID,
    OTHERSTAT_1_TYPE,
    OTHERSTAT_1_VALUE,
    OTHERSTAT_2_ID,
    OTHERSTAT_2_TYPE,
    OTHERSTAT_2_VALUE,
    OTHERSTAT_3_ID,
    OTHERSTAT_3_TYPE,
    OTHERSTAT_3_VALUE,
    OTHERSTAT_4_ID,
    OTHERSTAT_4_TYPE,
    OTHERSTAT_4_VALUE,
    OTHERSTAT_5_ID,
    OTHERSTAT_5_TYPE,
    OTHERSTAT_5_VALUE,
    OTHERSTAT_6_ID,
    OTHERSTAT_6_TYPE,
    OTHERSTAT_6_VALUE,
    OTHERSTAT_7_ID,
    OTHERSTAT_7_TYPE,
    OTHERSTAT_7_VALUE,
    OTHERSTAT_8_ID,
    OTHERSTAT_8_TYPE,
    OTHERSTAT_8_VALUE,
    OTHERSTAT_9_ID,
    OTHERSTAT_9_TYPE,
    OTHERSTAT_9_VALUE,
    OTHERSTAT_10_ID,
    OTHERSTAT_10_TYPE,
    OTHERSTAT_10_VALUE,
    OTHER_XML,
    PLAN_OPERATION_INACTIVE,
    OUTPUT_BATCHES,
    SKIPPED_ROWS_COUNT  FROM OCEANBASE.GV$SQL_PLAN_MONITOR
    WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " "),

    normal_columns = [
    ],
),

# rename to DBA_RECYCLEBIN
def_table_schema(
  owner = 'bin.lb',
  table_name      = 'DBA_RECYCLEBIN',
  table_id        = '21038',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  SELECT
  CAST(B.DATABASE_NAME AS CHAR(128)) AS OWNER,
  CAST(A.OBJECT_NAME AS CHAR(128)) AS OBJECT_NAME,
  CAST(A.ORIGINAL_NAME AS CHAR(128)) AS ORIGINAL_NAME,
  CAST(NULL AS CHAR(9)) AS OPERATION,
  CAST(CASE A.TYPE
       WHEN 1 THEN 'TABLE'
       WHEN 2 THEN 'NORMAL INDEX'
       WHEN 3 THEN 'VIEW'
       ELSE NULL END AS CHAR(25)) AS TYPE,
  CAST(CASE WHEN TP.TABLESPACE_ID IS NULL THEN NULL ELSE TP.TABLESPACE_NAME END AS CHAR(30)) AS TS_NAME,
  CAST(C.GMT_CREATE AS DATE) AS CREATETIME,
  CAST(C.GMT_MODIFIED AS DATE) AS DROPTIME,
  CAST(NULL AS SIGNED) AS DROPSCN,
  CAST(NULL AS CHAR(128)) AS PARTITION_NAME,
  CAST('YES' AS CHAR(3)) AS CAN_UNDROP,
  CAST('YES' AS CHAR(3)) AS CAN_PURGE,
  CAST(NULL AS SIGNED) AS RELATED,
  CAST(NULL AS SIGNED) AS BASE_OBJECT,
  CAST(NULL AS SIGNED) AS PURGE_OBJECT,
  CAST(NULL AS SIGNED) AS SPACE
  FROM OCEANBASE.__ALL_RECYCLEBIN A
  JOIN OCEANBASE.__ALL_DATABASE B
    ON A.TENANT_ID = B.TENANT_ID
       AND A.DATABASE_ID = B.DATABASE_ID
  JOIN OCEANBASE.__ALL_TABLE C
    ON A.TENANT_ID = C.TENANT_ID
       AND A.TABLE_ID = C.TABLE_ID
  LEFT JOIN OCEANBASE.__ALL_TENANT_TABLESPACE TP
    ON C.TENANT_ID = TP.TENANT_ID
       AND C.TABLESPACE_ID = TP.TABLESPACE_ID
  WHERE A.TENANT_ID = 0
    AND A.TYPE IN (1, 2, 3)
    AND C.TABLE_MODE >> 12 & 15 in (0,1)
    AND C.INDEX_ATTRIBUTES_SET & 16 = 0

  UNION ALL

  SELECT
  CAST(A.ORIGINAL_NAME AS CHAR(128)) AS OWNER,
  CAST(A.OBJECT_NAME AS CHAR(128)) AS OBJECT_NAME,
  CAST(A.ORIGINAL_NAME AS CHAR(128)) AS ORIGINAL_NAME,
  CAST(NULL AS CHAR(9)) AS OPERATION,
  CAST('DATABASE' AS CHAR(25)) AS TYPE,
  CAST(NULL AS CHAR(30)) AS TS_NAME,
  CAST(B.GMT_CREATE AS DATE) AS CREATETIME,
  CAST(B.GMT_MODIFIED AS DATE) AS DROPTIME,
  CAST(NULL AS SIGNED) AS DROPSCN,
  CAST(NULL AS CHAR(128)) AS PARTITION_NAME,
  CAST('YES' AS CHAR(3)) AS CAN_UNDROP,
  CAST('YES' AS CHAR(3)) AS CAN_PURGE,
  CAST(NULL AS SIGNED) AS RELATED,
  CAST(NULL AS SIGNED) AS BASE_OBJECT,
  CAST(NULL AS SIGNED) AS PURGE_OBJECT,
  CAST(NULL AS SIGNED) AS SPACE
  FROM OCEANBASE.__ALL_RECYCLEBIN A
  JOIN OCEANBASE.__ALL_DATABASE B
    ON A.TENANT_ID = B.TENANT_ID
       AND A.DATABASE_ID = B.DATABASE_ID
  WHERE A.TENANT_ID = 0
    AND A.TYPE = 4

  UNION ALL

  SELECT
  CAST(B.DATABASE_NAME AS CHAR(128)) AS OWNER,
  CAST(A.OBJECT_NAME AS CHAR(128)) AS OBJECT_NAME,
  CAST(A.ORIGINAL_NAME AS CHAR(128)) AS ORIGINAL_NAME,
  CAST(NULL AS CHAR(9)) AS OPERATION,
  CAST('TRIGGER' AS CHAR(25)) AS TYPE,
  CAST(NULL AS CHAR(30)) AS TS_NAME,
  CAST(C.GMT_CREATE AS DATE) AS CREATETIME,
  CAST(C.GMT_MODIFIED AS DATE) AS DROPTIME,
  CAST(NULL AS SIGNED) AS DROPSCN,
  CAST(NULL AS CHAR(128)) AS PARTITION_NAME,
  CAST('YES' AS CHAR(3)) AS CAN_UNDROP,
  CAST('YES' AS CHAR(3)) AS CAN_PURGE,
  CAST(NULL AS SIGNED) AS RELATED,
  CAST(NULL AS SIGNED) AS BASE_OBJECT,
  CAST(NULL AS SIGNED) AS PURGE_OBJECT,
  CAST(NULL AS SIGNED) AS SPACE
  FROM OCEANBASE.__ALL_RECYCLEBIN A
  JOIN OCEANBASE.__ALL_DATABASE B
    ON A.TENANT_ID = B.TENANT_ID
       AND A.DATABASE_ID = B.DATABASE_ID
  JOIN OCEANBASE.__ALL_TENANT_TRIGGER C
    ON A.TENANT_ID = C.TENANT_ID
       AND A.TABLE_ID = C.TRIGGER_ID
  WHERE A.TENANT_ID = 0
    AND A.TYPE = 6

  UNION ALL

  SELECT
  CAST(NULL AS CHAR(128)) AS OWNER,
  CAST(A.OBJECT_NAME AS CHAR(128)) AS OBJECT_NAME,
  CAST(A.ORIGINAL_NAME AS CHAR(128)) AS ORIGINAL_NAME,
  CAST(NULL AS CHAR(9)) AS OPERATION,
  CAST('TENANT' AS CHAR(25)) AS TYPE,
  CAST(NULL AS CHAR(30)) AS TS_NAME,
  CAST(USEC_TO_TIME(B.SCHEMA_VERSION) AS DATE) AS CREATETIME,
  CAST(A.GMT_CREATE AS DATE) AS DROPTIME,
  CAST(NULL AS SIGNED) AS DROPSCN,
  CAST(NULL AS CHAR(128)) AS PARTITION_NAME,
  CAST('YES' AS CHAR(3)) AS CAN_UNDROP,
  CAST('YES' AS CHAR(3)) AS CAN_PURGE,
  CAST(NULL AS SIGNED) AS RELATED,
  CAST(NULL AS SIGNED) AS BASE_OBJECT,
  CAST(NULL AS SIGNED) AS PURGE_OBJECT,
  CAST(NULL AS SIGNED) AS SPACE
  FROM OCEANBASE.__ALL_RECYCLEBIN A
  JOIN OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE B
    ON A.TABLE_ID = B.TENANT_ID
       AND B.TABLE_NAME = '__all_core_table'
  WHERE A.TYPE = 7
""".replace("\n", " "),

)

# 21039: GV$OB_OUTLINES # abandoned in 4.0
# 21040: GV$OB_CONCURRENT_LIMIT_SQL # abandoned in 4.0
# 21041: GV$SQL_PLAN_STATISTICS # abandoned in 4.0
# 21042: V$SQL_PLAN_STATISTICS # abandoned in 4.0

def_table_schema(
  owner = 'dachuan.sdc',
  database_id    = 'OB_MYSQL_SCHEMA_ID',
  table_name      = 'time_zone',
  table_id        = '21054',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT time_zone_id as Time_zone_id,
           use_leap_seconds as Use_leap_seconds
    FROM oceanbase.__all_tenant_time_zone
""".replace("\n", " ")

)

def_table_schema(
  owner = 'dachuan.sdc',
  database_id    = 'OB_MYSQL_SCHEMA_ID',
  table_name      = 'time_zone_name',
  table_id        = '21055',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT name as Name,
           time_zone_id as Time_zone_id
    FROM oceanbase.__all_tenant_time_zone_name
""".replace("\n", " ")
)

def_table_schema(
  owner = 'dachuan.sdc',
  database_id    = 'OB_MYSQL_SCHEMA_ID',
  table_name      = 'time_zone_transition',
  table_id        = '21056',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT time_zone_id as Time_zone_id,
           transition_time as Transition_time,
           transition_type_id as Transition_type_id
    FROM oceanbase.__all_tenant_time_zone_transition
""".replace("\n", " ")
)

def_table_schema(
  owner = 'dachuan.sdc',
  database_id    = 'OB_MYSQL_SCHEMA_ID',
  table_name      = 'time_zone_transition_type',
  table_id        = '21057',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT time_zone_id as Time_zone_id,
           transition_type_id as Transition_type_id,
           offset as Offset,
           is_dst as Is_DST,
           abbreviation as Abbreviation
    FROM oceanbase.__all_tenant_time_zone_transition_type
""".replace("\n", " ")
)

def_table_schema(
  owner = 'zhenjiang.xzj',
  table_name      = 'GV$SESSION_LONGOPS',
  table_id        = '21059',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT CAST(sid AS SIGNED) AS SID,
           CAST(trace_id AS CHAR(64)) AS TRACE_ID,
           CAST(op_name AS CHAR(64)) AS OPNAME,
           CAST(TARGET AS CHAR(64)) AS TARGET,
           CAST(SVR_IP AS CHAR(46)) AS SVR_IP,
           CAST(SVR_PORT AS SIGNED) AS SVR_PORT,
           CAST(USEC_TO_TIME(START_TIME) AS DATETIME) AS START_TIME,
           CAST(ELAPSED_TIME/1000000 AS SIGNED) AS ELAPSED_SECONDS,
           CAST(REMAINING_TIME AS SIGNED) AS TIME_REMAINING,
           CAST(USEC_TO_TIME(LAST_UPDATE_TIME) AS DATETIME) AS LAST_UPDATE_TIME,
           CAST(MESSAGE AS CHAR(512)) AS MESSAGE
    FROM oceanbase.__all_virtual_virtual_long_ops_status_mysql_sys_agent
""".replace("\n", " ")
)

def_table_schema(
  owner = 'zhenjiang.xzj',
  table_name      = 'V$SESSION_LONGOPS',
  table_id        = '21060',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SID,
    TRACE_ID,
    OPNAME,
    TARGET,
    SVR_IP,
    SVR_PORT,
    START_TIME,
    ELAPSED_SECONDS,
    TIME_REMAINING,
    LAST_UPDATE_TIME,
    MESSAGE FROM OCEANBASE.GV$SESSION_LONGOPS
    WHERE SVR_IP = HOST_IP() AND SVR_PORT = RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name      = 'DBA_OB_SEQUENCE_OBJECTS',
  table_id        = '21066',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      SEQUENCE_ID,
      SCHEMA_VERSION,
      DATABASE_ID,
      SEQUENCE_NAME,
      MIN_VALUE,
      MAX_VALUE,
      INCREMENT_BY,
      START_WITH,
      CACHE_SIZE,
      ORDER_FLAG,
      CYCLE_FLAG,
      IS_SYSTEM_GENERATED
    FROM oceanbase.__all_sequence_object
""".replace("\n", " ")
)

# 21067: abandoned

def_table_schema(
  owner = 'bin.lb',
  tablegroup_id = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'COLUMNS',
  table_id       = '21068',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  view_definition = """SELECT TABLE_CATALOG,
                    TABLE_SCHEMA collate utf8mb4_name_case as TABLE_SCHEMA,
                    TABLE_NAME collate utf8mb4_name_case as TABLE_NAME,
                    COLUMN_NAME,
                    ORDINAL_POSITION,
                    COLUMN_DEFAULT,
                    IS_NULLABLE,
                    DATA_TYPE,
                    CHARACTER_MAXIMUM_LENGTH,
                    CHARACTER_OCTET_LENGTH,
                    NUMERIC_PRECISION,
                    NUMERIC_SCALE,
                    DATETIME_PRECISION,
                    CHARACTER_SET_NAME,
                    COLLATION_NAME,
                    COLUMN_TYPE,
                    COLUMN_KEY,
                    EXTRA,
                    PRIVILEGES,
                    COLUMN_COMMENT,
                    GENERATION_EXPRESSION,
                    SRS_ID
  		    FROM OCEANBASE.__ALL_VIRTUAL_INFORMATION_COLUMNS where 0 = sys_privilege_check('table_acc', effective_tenant_id(), table_schema, table_name)""",
  in_tenant_space = True,
  normal_columns = [ ],
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name      = 'GV$OB_PX_WORKER_STAT',
  table_id        = '21071',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      SESSION_ID,
      TENANT_ID,
      SVR_IP,
      SVR_PORT,
      TRACE_ID,
      QC_ID,
      SQC_ID,
      WORKER_ID,
      DFO_ID,
      START_TIME
    FROM oceanbase.__all_virtual_px_worker_stat
    order by session_id, svr_ip, svr_port
""".replace("\n", " ")
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name      = 'V$OB_PX_WORKER_STAT',
  table_id        = '21072',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SESSION_ID,
      TENANT_ID,
      SVR_IP,
      SVR_PORT,
      TRACE_ID,
      QC_ID,
      SQC_ID,
      WORKER_ID,
      DFO_ID,
      START_TIME
    FROM oceanbase.GV$OB_PX_WORKER_STAT
    where svr_ip = host_ip() AND svr_port = rpc_port()
""".replace("\n", " ")
)

# 21073: gv$partition_audit # abandoned in 4.0
# 21074: v$partition_audit # abandoned in 4.0
# 21075: V$OB_CLUSTER # abandoned in 4.0
# 21076: v$ob_standby_status # abandoned in 4.0
# 21077: v$ob_cluster_stats # abandoned in 4.0
# 21078: V$OB_CLUSTER_EVENT_HISTORY # abandoned in 4.0

def_table_schema(
  owner = 'xiaoyi.xy',
  table_name     = 'GV$OB_PS_STAT',
  table_id       = '21079',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [],
  view_definition = """
  SELECT
    TENANT_ID,
    SVR_IP,
    SVR_PORT,
    STMT_COUNT,
    HIT_COUNT,
    ACCESS_COUNT,
    MEM_HOLD
  FROM oceanbase.__all_virtual_ps_stat
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
    owner = 'xiaoyi.xy',
    table_name     = 'V$OB_PS_STAT',
    table_id       = '21080',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
  SELECT TENANT_ID,
    SVR_IP,
    SVR_PORT,
    STMT_COUNT,
    HIT_COUNT,
    ACCESS_COUNT,
    MEM_HOLD
  FROM oceanbase.GV$OB_PS_STAT
  WHERE svr_ip=HOST_IP() AND svr_port=RPC_PORT()
""".replace("\n", " "),


    normal_columns = [
    ],
)

def_table_schema(
  owner = 'xiaoyi.xy',
  table_name     = 'GV$OB_PS_ITEM_INFO',
  table_id       = '21081',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  in_tenant_space = True,
  rowkey_columns = [],
  view_definition = """
  SELECT TENANT_ID, SVR_IP, SVR_PORT, STMT_ID,
         DB_ID, PS_SQL, PARAM_COUNT, STMT_ITEM_REF_COUNT,
         STMT_INFO_REF_COUNT, MEM_HOLD, STMT_TYPE, CHECKSUM, EXPIRED
  FROM oceanbase.__all_virtual_ps_item_info
""".replace("\n", " "),

  normal_columns = [
  ],
)

def_table_schema(
    owner = 'xiaoyi.xy',
    table_name     = 'V$OB_PS_ITEM_INFO',
    table_id       = '21082',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
  SELECT TENANT_ID, SVR_IP, SVR_PORT, STMT_ID,
         DB_ID, PS_SQL, PARAM_COUNT, STMT_ITEM_REF_COUNT,
         STMT_INFO_REF_COUNT, MEM_HOLD, STMT_TYPE, CHECKSUM, EXPIRED
  FROM oceanbase.GV$OB_PS_ITEM_INFO
  WHERE svr_ip=HOST_IP() AND svr_port=RPC_PORT()
""".replace("\n", " "),


    normal_columns = [
    ],
)


def_table_schema(
  owner = 'longzhong.wlz',
  table_name      = 'GV$SQL_WORKAREA',
  table_id        = '21083',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      CAST(NULL AS BINARY(8)) AS ADDRESS,
      CAST(NULL AS SIGNED) AS HASH_VALUE,
      DB_ID,
      SQL_ID,
      CAST(PLAN_ID AS SIGNED) AS CHILD_NUMBER,
      CAST(NULL AS BINARY(8)) AS WORKAREA_ADDRESS,
      OPERATION_TYPE,
      OPERATION_ID,
      POLICY,
      ESTIMATED_OPTIMAL_SIZE,
      ESTIMATED_ONEPASS_SIZE,
      LAST_MEMORY_USED,
      LAST_EXECUTION,
      LAST_DEGREE,
      TOTAL_EXECUTIONS,
      OPTIMAL_EXECUTIONS,
      ONEPASS_EXECUTIONS,
      MULTIPASSES_EXECUTIONS,
      ACTIVE_TIME,
      MAX_TEMPSEG_SIZE,
      LAST_TEMPSEG_SIZE,
      TENANT_ID AS CON_ID,
      SVR_IP,
      SVR_PORT
    FROM OCEANBASE.__ALL_VIRTUAL_SQL_WORKAREA_HISTORY_STAT
""".replace("\n", " ")
)

def_table_schema(
  owner = 'longzhong.wlz',
  table_name      = 'V$SQL_WORKAREA',
  table_id        = '21084',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT ADDRESS,
    HASH_VALUE,
    DB_ID,
    SQL_ID,
    CHILD_NUMBER,
    WORKAREA_ADDRESS,
    OPERATION_TYPE,
    OPERATION_ID,
    POLICY,
    ESTIMATED_OPTIMAL_SIZE,
    ESTIMATED_ONEPASS_SIZE,
    LAST_MEMORY_USED,
    LAST_EXECUTION,
    LAST_DEGREE,
    TOTAL_EXECUTIONS,
    OPTIMAL_EXECUTIONS,
    ONEPASS_EXECUTIONS,
    MULTIPASSES_EXECUTIONS,
    ACTIVE_TIME,
    MAX_TEMPSEG_SIZE,
    LAST_TEMPSEG_SIZE,
    CON_ID,
    SVR_IP,
    SVR_PORT FROM OCEANBASE.GV$SQL_WORKAREA
    WHERE SVR_IP = HOST_IP() AND SVR_PORT = RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'longzhong.wlz',
  table_name      = 'GV$SQL_WORKAREA_ACTIVE',
  table_id        = '21085',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      CAST(NULL AS SIGNED) AS SQL_HASH_VALUE,
      DB_ID,
      SQL_ID,
      CAST(NULL AS DATE) AS SQL_EXEC_START,
      SQL_EXEC_ID,
      CAST(NULL AS BINARY(8)) AS WORKAREA_ADDRESS,
      OPERATION_TYPE,
      OPERATION_ID,
      POLICY,
      SID,
      CAST(NULL AS SIGNED) AS QCINST_ID,
      CAST(NULL AS SIGNED) AS QCSID,
      ACTIVE_TIME,
      WORK_AREA_SIZE,
      EXPECT_SIZE,
      ACTUAL_MEM_USED,
      MAX_MEM_USED,
      NUMBER_PASSES,
      TEMPSEG_SIZE,
      CAST(NULL AS CHAR(20)) AS TABLESPACE,
      CAST(NULL AS SIGNED) AS `SEGRFNO#`,
      CAST(NULL AS SIGNED) AS `SEGBLK#`,
      TENANT_ID AS CON_ID,
      SVR_IP,
      SVR_PORT
    FROM OCEANBASE.__ALL_VIRTUAL_SQL_WORKAREA_ACTIVE
""".replace("\n", " ")
)

def_table_schema(
  owner = 'longzhong.wlz',
  table_name      = 'V$SQL_WORKAREA_ACTIVE',
  table_id        = '21086',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SQL_HASH_VALUE,
    DB_ID,
    SQL_ID,
    SQL_EXEC_START,
    SQL_EXEC_ID,
    WORKAREA_ADDRESS,
    OPERATION_TYPE,
    OPERATION_ID,
    POLICY,
    SID,
    QCINST_ID,
    QCSID,
    ACTIVE_TIME,
    WORK_AREA_SIZE,
    EXPECT_SIZE,
    ACTUAL_MEM_USED,
    MAX_MEM_USED,
    NUMBER_PASSES,
    TEMPSEG_SIZE,
    TABLESPACE,
    `SEGRFNO#`,
    `SEGBLK#`,
    CON_ID,
    SVR_IP,
    SVR_PORT FROM OCEANBASE.GV$SQL_WORKAREA_ACTIVE
    WHERE SVR_IP = HOST_IP() AND SVR_PORT = RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'longzhong.wlz',
  table_name      = 'GV$SQL_WORKAREA_HISTOGRAM',
  table_id        = '21087',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      LOW_OPTIMAL_SIZE,
      HIGH_OPTIMAL_SIZE,
      OPTIMAL_EXECUTIONS,
      ONEPASS_EXECUTIONS,
      MULTIPASSES_EXECUTIONS,
      TOTAL_EXECUTIONS,
      TENANT_ID AS CON_ID,
      SVR_IP,
      SVR_PORT
    FROM OCEANBASE.__ALL_VIRTUAL_SQL_WORKAREA_HISTOGRAM
""".replace("\n", " ")
)

def_table_schema(
  owner = 'longzhong.wlz',
  table_name      = 'V$SQL_WORKAREA_HISTOGRAM',
  table_id        = '21088',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT LOW_OPTIMAL_SIZE,
      HIGH_OPTIMAL_SIZE,
      OPTIMAL_EXECUTIONS,
      ONEPASS_EXECUTIONS,
      MULTIPASSES_EXECUTIONS,
      TOTAL_EXECUTIONS,
      CON_ID,
      SVR_IP,
      SVR_PORT FROM OCEANBASE.GV$SQL_WORKAREA_HISTOGRAM
    WHERE SVR_IP = HOST_IP() AND SVR_PORT = RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'longzhong.wlz',
  table_name      = 'GV$OB_SQL_WORKAREA_MEMORY_INFO',
  table_id        = '21089',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      MAX_WORKAREA_SIZE,
      WORKAREA_HOLD_SIZE,
      MAX_AUTO_WORKAREA_SIZE,
      MEM_TARGET,
      TOTAL_MEM_USED,
      GLOBAL_MEM_BOUND,
      DRIFT_SIZE,
      WORKAREA_COUNT,
      MANUAL_CALC_COUNT,
      TENANT_ID,
      SVR_IP,
      SVR_PORT
    FROM OCEANBASE.__ALL_VIRTUAL_SQL_WORKAREA_MEMORY_INFO
""".replace("\n", " ")
)

def_table_schema(
  owner = 'longzhong.wlz',
  table_name      = 'V$OB_SQL_WORKAREA_MEMORY_INFO',
  table_id        = '21090',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT MAX_WORKAREA_SIZE,
      WORKAREA_HOLD_SIZE,
      MAX_AUTO_WORKAREA_SIZE,
      MEM_TARGET,
      TOTAL_MEM_USED,
      GLOBAL_MEM_BOUND,
      DRIFT_SIZE,
      WORKAREA_COUNT,
      MANUAL_CALC_COUNT,
      TENANT_ID,
      SVR_IP,
      SVR_PORT
    FROM OCEANBASE.GV$OB_SQL_WORKAREA_MEMORY_INFO
    WHERE SVR_IP = HOST_IP() AND SVR_PORT = RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
owner = 'xiaoyi.xy',
table_name      = 'GV$OB_PLAN_CACHE_REFERENCE_INFO',
table_id        = '21097',
table_type      = 'SYSTEM_VIEW',
rowkey_columns  = [],
normal_columns  = [],
gm_columns      = [],
in_tenant_space = True,
view_definition = """
SELECT SVR_IP,
SVR_PORT,
TENANT_ID,
PC_REF_PLAN_LOCAL,
PC_REF_PLAN_REMOTE,
PC_REF_PLAN_DIST,
PC_REF_PLAN_ARR,
PC_REF_PL,
PC_REF_PL_STAT,
PLAN_GEN,
CLI_QUERY,
OUTLINE_EXEC,
PLAN_EXPLAIN,
ASYN_BASELINE,
LOAD_BASELINE,
PS_EXEC,
GV_SQL,
PL_ANON,
PL_ROUTINE,
PACKAGE_VAR,
PACKAGE_TYPE,
PACKAGE_SPEC,
PACKAGE_BODY,
PACKAGE_RESV,
GET_PKG,
INDEX_BUILDER,
PCV_SET,
PCV_RD,
PCV_WR,
PCV_GET_PLAN_KEY,
PCV_GET_PL_KEY,
PCV_EXPIRE_BY_USED,
PCV_EXPIRE_BY_MEM,
LC_REF_CACHE_NODE,
LC_NODE,
LC_NODE_RD,
LC_NODE_WR,
LC_REF_CACHE_OBJ_STAT
FROM oceanbase.__all_virtual_plan_cache_stat
""".replace("\n", " ")
)

def_table_schema(
owner = 'xiaoyi.xy',
table_name      = 'V$OB_PLAN_CACHE_REFERENCE_INFO',
table_id        = '21098',
table_type      = 'SYSTEM_VIEW',
rowkey_columns  = [],
normal_columns  = [],
gm_columns      = [],
in_tenant_space = True,
view_definition = """
SELECT SVR_IP,
SVR_PORT,
TENANT_ID,
PC_REF_PLAN_LOCAL,
PC_REF_PLAN_REMOTE,
PC_REF_PLAN_DIST,
PC_REF_PLAN_ARR,
PC_REF_PL,
PC_REF_PL_STAT,
PLAN_GEN,
CLI_QUERY,
OUTLINE_EXEC,
PLAN_EXPLAIN,
ASYN_BASELINE,
LOAD_BASELINE,
PS_EXEC,
GV_SQL,
PL_ANON,
PL_ROUTINE,
PACKAGE_VAR,
PACKAGE_TYPE,
PACKAGE_SPEC,
PACKAGE_BODY,
PACKAGE_RESV,
GET_PKG,
INDEX_BUILDER,
PCV_SET,
PCV_RD,
PCV_WR,
PCV_GET_PLAN_KEY,
PCV_GET_PL_KEY,
PCV_EXPIRE_BY_USED,
PCV_EXPIRE_BY_MEM,
LC_REF_CACHE_NODE,
LC_NODE,
LC_NODE_RD,
LC_NODE_WR,
LC_REF_CACHE_OBJ_STAT
FROM oceanbase.GV$OB_PLAN_CACHE_REFERENCE_INFO
WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
"""
)

def_table_schema(
owner = 'baichangmin.bcm',
table_name      = 'GV$OB_SSTABLES',
table_id        = '21100',
table_type      = 'SYSTEM_VIEW',
rowkey_columns  = [],
normal_columns  = [],
gm_columns      = [],
in_tenant_space = True,
view_definition = """
SELECT
 M.SVR_IP,
 M.SVR_PORT,
 (case M.TABLE_TYPE
    when 0 then 'MEMTABLE' when 1 then 'TX_DATA_MEMTABLE' when 2 then 'TX_CTX_MEMTABLE'
    when 3 then 'LOCK_MEMTABLE' when 4 then 'DIRECT_LOAD_MEMTABLE' when 10 then 'MAJOR' when 11 then 'MINOR'
    when 12 then 'MINI' when 13 then 'META'
    when 14 then 'DDL_DUMP' when 15 then 'REMOTE_LOGICAL_MINOR' when 16 then 'DDL_MEM'
    when 17 then 'CO_MAJOR' when 18 then 'NORMAL_CG' when 19 then 'ROWKEY_CG' when 20 then 'COL_ORIENTED_META'
    when 21 then 'DDL_MERGE_CO' when 22 then 'DDL_MERGE_CG' when 23 then 'DDL_MEM_CO'
    when 24 then 'DDL_MEM_CG' when 25 then 'DDL_MEM_MINI_SSTABLE'
    when 26 then 'MDS_MINI' when 27 then 'MDS_MINOR'
    else 'INVALID'
  end) as TABLE_TYPE,
 M.TENANT_ID,
 M.LS_ID,
 M.TABLET_ID,
 M.CG_IDX,
 M.START_LOG_SCN,
 M.END_LOG_SCN,
 M.DATA_CHECKSUM,
 M.SIZE,
 M.REF,
 M.UPPER_TRANS_VERSION,
 M.IS_ACTIVE,
 M.CONTAIN_UNCOMMITTED_ROW
FROM
 oceanbase.__all_virtual_table_mgr M
""".replace("\n", " ")
)

def_table_schema(
owner = 'baichangmin.bcm',
table_name      = 'V$OB_SSTABLES',
table_id        = '21101',
table_type      = 'SYSTEM_VIEW',
rowkey_columns  = [],
normal_columns  = [],
gm_columns      = [],
in_tenant_space = True,
view_definition = """
SELECT M.SVR_IP,
 M.SVR_PORT,
 M.TABLE_TYPE,
 M.TENANT_ID,
 M.LS_ID,
 M.TABLET_ID,
 M.CG_IDX,
 M.START_LOG_SCN,
 M.END_LOG_SCN,
 M.DATA_CHECKSUM,
 M.SIZE,
 M.REF,
 M.UPPER_TRANS_VERSION,
 M.IS_ACTIVE,
 M.CONTAIN_UNCOMMITTED_ROW
FROM OCEANBASE.GV$OB_SSTABLES M
WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

# 21102: CDB_OB_BACKUP_ARCHIVELOG_SUMMARY # abandoned in 4.0
# 21103: CDB_OB_BACKUP_JOB_DETAILS # abandoned in 4.0
# 21104: CDB_OB_BACKUP_SET_DETAILS # abandoned in 4.0
# 21105: CDB_OB_BACKUP_SET_EXPIRED # abandoned in 4.0
# 21106: CDB_OB_BACKUP_PROGRESS # abandoned in 4.0
# 21107: CDB_OB_BACKUP_ARCHIVELOG_PROGRESS # abandoned in 4.0
# 21108: CDB_OB_BACKUP_CLEAN_HISTORY # abandoned in 4.0
# 21109: CDB_OB_BACKUP_TASK_CLEAN_HISTORY # abandoned in 4.0

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'CDB_OB_RESTORE_PROGRESS',
  table_id        = '21110',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    P.TENANT_ID AS TENANT_ID,
    P.JOB_ID AS JOB_ID,
    RESTORE_TENANT_NAME,
    RESTORE_TENANT_ID,
    BACKUP_TENANT_NAME,
    BACKUP_TENANT_ID,
    BACKUP_CLUSTER_NAME,
    BACKUP_DEST,
    RESTORE_OPTION,
    RESTORE_TYPE,
    RESTORE_SCN,
    CASE
      WHEN RESTORE_SCN IS NULL
        THEN NULL
      WHEN RESTORE_SCN=0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(RESTORE_SCN)
      END AS RESTORE_SCN_DISPLAY,
    CASE
      WHEN STATUS = 'RESTORE_PRE'
        THEN 'RESTORING'
      WHEN STATUS = 'RESTORE_CREATE_INIT_LS'
        THEN 'RESTORING'
      WHEN STATUS = 'PHYSICAL_RESTORE_WAIT_RESTORE_TO_CONSISTENT_SCN'
        THEN 'RESTORING'
      WHEN STATUS = 'RESTORE_WAIT_LS'
        THEN 'RESTORING'
      WHEN STATUS = 'POST_CHECK'
        THEN 'RESTORING'
      ELSE STATUS
      END AS STATUS,
    CASE
      WHEN START_TIMESTAMP IS NULL
        THEN NULL
      WHEN START_TIMESTAMP=''
        THEN NULL
      WHEN START_TIMESTAMP='0'
        THEN NULL
      ELSE
        USEC_TO_TIME(START_TIMESTAMP)
      END AS START_TIMESTAMP,
    BACKUP_SET_LIST,
    BACKUP_PIECE_LIST,
    RECOVER_SCN,
    CASE
      WHEN RECOVER_SCN IS NULL
        THEN NULL
      WHEN RECOVER_SCN <= 1
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(RECOVER_SCN)
      END AS RECOVER_SCN_DISPLAY,
    CASE
      WHEN RECOVER_SCN IS NULL
        THEN NULL
      WHEN STATUS IN ('RESTORE_PRE', 'RESTORE_CREATE_INIT_LS', 'PHYSICAL_RESTORE_WAIT_RESTORE_TO_CONSISTENT_SCN')
        THEN CAST(0 AS DECIMAL(6, 2))
      WHEN RESTORE_SCN = RECOVER_START_SCN
        THEN CAST(100 AS DECIMAL(6, 2))
      ELSE CAST(TRUNCATE((RECOVER_SCN - RECOVER_START_SCN) / (RESTORE_SCN - RECOVER_START_SCN) * 100, 2) AS DECIMAL(6, 2))
      END AS RECOVER_PROGRESS,
    TABLET_COUNT,
    FINISH_TABLET_COUNT,
    CASE PROGRESS_DISPLAY_MODE
      WHEN 'BYTES' THEN
        CASE
          WHEN FINISH_BYTES IS NULL THEN NULL
          ELSE CAST(TRUNCATE((FINISH_BYTES / TOTAL_BYTES) * 100, 2) AS DECIMAL(6, 2))
          END
      WHEN 'TABLET_CNT' THEN
        CASE
          WHEN FINISH_TABLET_COUNT IS NULL THEN NULL
          ELSE CAST(TRUNCATE((FINISH_TABLET_COUNT / TABLET_COUNT) * 100, 2) AS DECIMAL(6, 2))
          END
      END AS RESTORE_PROGRESS,
    TOTAL_BYTES,
    CASE
      WHEN TOTAL_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN TOTAL_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN TOTAL_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(TOTAL_BYTES/1024/1024,2), 'MB')
      END AS TOTAL_BYTES_DISPLAY,
    FINISH_BYTES,
    CASE
      WHEN FINISH_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN FINISH_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN FINISH_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(FINISH_BYTES/1024/1024,2), 'MB')
      END AS FINISH_BYTES_DISPLAY,
    DESCRIPTION
    FROM
  (
      SELECT
      TENANT_ID,
      JOB_ID,
      MAX(CASE NAME WHEN 'tenant_name' THEN VALUE ELSE '' END) AS RESTORE_TENANT_NAME,
      MAX(CASE NAME WHEN 'tenant_id' THEN VALUE ELSE '' END) AS RESTORE_TENANT_ID,
      MAX(CASE NAME WHEN 'backup_tenant_name' THEN VALUE ELSE '' END) AS BACKUP_TENANT_NAME,
      MAX(CASE NAME WHEN 'backup_tenant_id' THEN VALUE ELSE '' END) AS BACKUP_TENANT_ID,
      MAX(CASE NAME WHEN 'backup_cluster_name' THEN VALUE ELSE '' END) AS BACKUP_CLUSTER_NAME,
      MAX(CASE NAME WHEN 'target_tenant_role' THEN VALUE ELSE '' END) AS TENANT_ROLE,
      MAX(CASE NAME WHEN 'backup_dest' THEN VALUE ELSE '' END) AS BACKUP_DEST,
      MAX(CASE NAME WHEN 'restore_option' THEN VALUE ELSE '' END) AS RESTORE_OPTION,
      MAX(CASE NAME WHEN 'status' THEN VALUE ELSE '' END) AS STATUS,
      MAX(CASE NAME WHEN 'consistent_scn' THEN VALUE ELSE '' END) AS RECOVER_START_SCN,
      MAX(CASE NAME WHEN 'restore_scn' THEN VALUE ELSE '' END) AS RESTORE_SCN,
      MAX(CASE NAME WHEN 'restore_start_ts' THEN VALUE ELSE '' END) AS START_TIMESTAMP,
      MAX(CASE NAME WHEN 'backup_set_list' THEN VALUE ELSE '' END) AS BACKUP_SET_LIST,
      MAX(CASE NAME WHEN 'backup_piece_list' THEN VALUE ELSE '' END) AS BACKUP_PIECE_LIST,
      MAX(CASE NAME WHEN 'description' THEN VALUE ELSE '' END) AS DESCRIPTION,
      MAX(CASE NAME WHEN 'restore_type' THEN VALUE ELSE '' END) AS RESTORE_TYPE,
      MAX(CASE NAME WHEN 'progress_display_mode' THEN VALUE ELSE '' END) AS PROGRESS_DISPLAY_MODE
      FROM OCEANBASE.__ALL_VIRTUAL_RESTORE_JOB GROUP BY TENANT_ID, JOB_ID
  ) P LEFT JOIN
  (
      SELECT
      TENANT_ID,
      JOB_ID,
      TABLET_COUNT,
      FINISH_TABLET_COUNT,
      TOTAL_BYTES,
      FINISH_BYTES
      FROM OCEANBASE.__ALL_VIRTUAL_RESTORE_PROGRESS
  ) J
    ON P.TENANT_ID=J.TENANT_ID AND P.JOB_ID=J.JOB_ID
    LEFT JOIN
  (
      SELECT
      TENANT_ID,
      READABLE_SCN AS RECOVER_SCN
      FROM OCEANBASE.__ALL_VIRTUAL_TENANT_INFO
  ) Q
    ON P.TENANT_ID=Q.TENANT_ID
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'CDB_OB_RESTORE_HISTORY',
  table_id        = '21111',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    JOB_ID,
    RESTORE_TENANT_NAME,
    RESTORE_TENANT_ID,
    BACKUP_TENANT_NAME,
    BACKUP_TENANT_ID,
    BACKUP_CLUSTER_NAME,
    BACKUP_DEST,
    RESTORE_SCN,
    CASE
      WHEN RESTORE_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(RESTORE_SCN)
      END AS RESTORE_SCN_DISPLAY,
    RESTORE_OPTION,
    RESTORE_TYPE,
    START_TIME AS START_TIMESTAMP,
    FINISH_TIME AS FINISH_TIMESTAMP,
    STATUS,
    BACKUP_PIECE_LIST,
    BACKUP_SET_LIST,
    BACKUP_CLUSTER_VERSION,
    LS_COUNT,
    FINISH_LS_COUNT,
    TABLET_COUNT,
    FINISH_TABLET_COUNT,
    TOTAL_BYTES,
    CASE
      WHEN TOTAL_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN TOTAL_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN TOTAL_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(TOTAL_BYTES/1024/1024,2), 'MB')
      END AS TOTAL_BYTES_DISPLAY,
    FINISH_BYTES,
    CASE
      WHEN FINISH_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN FINISH_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN FINISH_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(FINISH_BYTES/1024/1024,2), 'MB')
      END AS FINISH_BYTES_DISPLAY,
    DESCRIPTION,
    COMMENT
    FROM OCEANBASE.__ALL_VIRTUAL_RESTORE_JOB_HISTORY
""".replace("\n", " ")
)

def_table_schema(
 owner = 'yanmu.ztl',
 table_name      = 'GV$OB_SERVER_SCHEMA_INFO',
 table_id        = '21112',
 table_type      = 'SYSTEM_VIEW',
 rowkey_columns  = [],
 normal_columns  = [],
 gm_columns      = [],
 in_tenant_space = True,
 view_definition = """
SELECT
  SVR_IP,
  SVR_PORT,
  TENANT_ID,
  REFRESHED_SCHEMA_VERSION,
  RECEIVED_SCHEMA_VERSION,
  SCHEMA_COUNT,
  SCHEMA_SIZE,
  MIN_SSTABLE_SCHEMA_VERSION
FROM
  oceanbase.__all_virtual_server_schema_info
""".replace("\n", " ")
)

def_table_schema(
 owner = 'yanmu.ztl',
 table_name      = 'V$OB_SERVER_SCHEMA_INFO',
 table_id        = '21113',
 table_type      = 'SYSTEM_VIEW',
 rowkey_columns  = [],
 normal_columns  = [],
 gm_columns      = [],
 in_tenant_space = True,
 view_definition = """
SELECT
  SVR_IP,
  SVR_PORT,
  TENANT_ID,
  REFRESHED_SCHEMA_VERSION,
  RECEIVED_SCHEMA_VERSION,
  SCHEMA_COUNT,
  SCHEMA_SIZE,
  MIN_SSTABLE_SCHEMA_VERSION
FROM
  oceanbase.GV$OB_SERVER_SCHEMA_INFO
WHERE
  SVR_IP=HOST_IP()
AND
  SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

# 21114: CDB_CKPT_HISTORY # abandoned in 4.0
# 21115: gv$ob_trans_table_status # abandoned in 4.0
# 21116: v$ob_trans_table_status # abandoned in 4.0

def_table_schema(
    owner = 'xiaochu.yh',
    table_name     = 'V$SQL_MONITOR_STATNAME',
    table_id       = '21117',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    normal_columns = [],
    view_definition = """
    SELECT
      CAST(NULL AS UNSIGNED) AS CON_ID,
      ID,
      GROUP_ID,
      NAME,
      DESCRIPTION,
      TYPE,
      0 FLAGS
    FROM oceanbase.__all_virtual_sql_monitor_statname
""".replace("\n", " "),
)

def_table_schema(
 owner = 'lixia.yq',
 table_name      = 'GV$OB_MERGE_INFO',
 table_id        = '21118',
 table_type      = 'SYSTEM_VIEW',
 rowkey_columns  = [],
 normal_columns  = [],
 gm_columns      = [],
 in_tenant_space = True,
 view_definition = """
    SELECT
        SVR_IP,
        SVR_PORT,
        TENANT_ID,
        LS_ID,
        TABLET_ID,
        TYPE AS ACTION,
        COMPACTION_SCN,
        START_TIME,
        FINISH_TIME AS END_TIME,
        MACRO_BLOCK_COUNT,
        CASE MACRO_BLOCK_COUNT WHEN 0 THEN 0.00 ELSE ROUND(MULTIPLEXED_MACRO_BLOCK_COUNT/MACRO_BLOCK_COUNT*100, 2) END AS REUSE_PCT,
        PARALLEL_DEGREE
    FROM oceanbase.__ALL_VIRTUAL_TABLET_COMPACTION_HISTORY
""".replace("\n", " ")
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'V$OB_MERGE_INFO',
  table_id        = '21119',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
        SVR_IP,
        SVR_PORT,
        TENANT_ID,
        LS_ID,
        TABLET_ID,
        ACTION,
        COMPACTION_SCN,
        START_TIME,
        END_TIME,
        MACRO_BLOCK_COUNT,
        REUSE_PCT,
        PARALLEL_DEGREE
    FROM OCEANBASE.GV$OB_MERGE_INFO
    WHERE SVR_IP = HOST_IP() AND SVR_PORT = RPC_PORT()
""".replace("\n", " ")
)

# 21122: CDB_OB_BACKUP_VALIDATION_JOB # abandoned in 4.0
# 21123: CDB_OB_BACKUP_VALIDATION_JOB_HISTORY # abandoned in 4.0
# 21124: CDB_OB_TENANT_BACKUP_VALIDATION_TASK # abandoned in 4.0
# 21125: CDB_OB_BACKUP_VALIDATION_TASK_HISTORY # abandoned in 4.0
# 21126: v$restore_point # abandoned in 4.0
# 21127: CDB_OB_BACKUP_SET_OBSOLETE # abandoned in 4.0
# 21128: CDB_OB_BACKUP_BACKUPSET_JOB # abandoned in 4.0
# 21129: CDB_OB_BACKUP_BACKUPSET_JOB_HISTORY # abandoned in 4.0
# 21130: CDB_OB_BACKUP_BACKUPSET_TASK # abandoned in 4.0
# 21131: CDB_OB_BACKUP_BACKUPSET_TASK_HISTORY # abandoned in 4.0
# 21132: CDB_OB_BACKUP_BACKUP_ARCHIVELOG_SUMMARY # abandoned in 4.0
# 21133: v$ob_cluster_failover_info # abandoned in 4.0

def_table_schema(
  owner = 'sean.yyj',
  table_name      = 'V$OB_ENCRYPTED_TABLES',
  table_id        = '21134',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      A.table_id AS TABLE_ID,
      A.table_name AS TABLE_NAME,
      B.tablespace_id AS TABLESPACE_ID,
      B.encryption_name AS ENCRYPTIONALG,
      CASE WHEN B.encryption_name != '' AND sum(encrypted_macro_block_count) = sum(macro_block_count) THEN 'YES'
           ELSE 'NO' END AS ENCRYPTED,
      hex(B.encrypt_key) AS ENCRYPTEDKEY,
      B.master_key_id AS MASTERKEYID,
      sum(encrypted_macro_block_count) AS BLOCKS_ENCRYPTED,
      (sum(macro_block_count) - sum(encrypted_macro_block_count)) AS BLOCKS_DECRYPTED,
      CASE WHEN (B.encryption_name != '' AND sum(encrypted_macro_block_count) < sum(macro_block_count)) THEN 'ENCRYPTING'
           WHEN (B.encryption_name = '' AND sum(encrypted_macro_block_count) > 0) THEN 'DECRYPTING'
           ELSE 'NORMAL' END AS STATUS,
      A.tenant_id as CON_ID
    FROM
      (SELECT T.tenant_id, T.table_id, T.table_name, T.table_type, T.tablespace_id, T.tablet_id
       FROM oceanbase.__all_table T where T.part_level = 0 and T.table_mode >> 12 & 15 in (0,1) and T.index_attributes_set & 16 = 0
       UNION ALL
       SELECT T.tenant_id, T.table_id, T.table_name, T.table_type, T.tablespace_id, P.tablet_id
       FROM oceanbase.__all_table T, oceanbase.__all_part P
       WHERE T.part_level = 1 and T.tenant_id = P.tenant_id and T.table_id = P.table_id
       UNION ALL
       SELECT T.tenant_id, T.table_id, T.table_name, T.table_type, T.tablespace_id, SP.tablet_id
       FROM oceanbase.__all_table T, oceanbase.__all_sub_part SP
       WHERE T.part_level = 2 and T.tenant_id = SP.tenant_id and T.table_id = SP.table_id
      ) A
      JOIN oceanbase.__all_tenant_tablespace B
      ON A.tenant_id = B.tenant_id AND A.tablespace_id = B.tablespace_id
      JOIN oceanbase.__all_virtual_tablet_encrypt_info E
      ON E.tenant_id = effective_tenant_id() and E.tablet_id = A.tablet_id
    WHERE A.tenant_id = 0 AND A.table_type != 12 AND A.table_type != 13
    GROUP BY A.tenant_id, A.table_id, A.table_name, B.tablespace_id, B.encryption_name, B.encrypt_key, B.master_key_id
  """.replace("\n", " ")
)

def_table_schema(
  owner = 'sean.yyj',
  table_name      = 'V$ENCRYPTED_TABLESPACES',
  table_id        = '21135',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      tablespace_id AS TABLESPACE_ID,
      encryptionalg AS ENCRYPTIONALG,
      CASE WHEN encryptionalg != '' AND sum(blocks_decrypted) = 0 THEN 'YES'
          ELSE 'NO' END AS ENCRYPTED,
      encryptedkey AS ENCRYPTEDKEY,
      masterkeyid AS MASTERKEYID,
      sum(blocks_encrypted) AS BLOCKS_ENCRYPTED,
      sum(blocks_decrypted) AS BLOCKS_DECRYPTED,
      CASE WHEN (encryptionalg != '' AND sum(blocks_decrypted) > 0) THEN 'ENCRYPTING'
           WHEN (encryptionalg = '' AND sum(blocks_encrypted) > 0) THEN 'DECRYPTING'
        ELSE 'NORMAL' END AS STATUS,
      con_id AS CON_ID
    FROM
      oceanbase.V$OB_ENCRYPTED_TABLES
    GROUP BY con_id, tablespace_id, encryptionalg, encryptedkey, masterkeyid
  """.replace("\n", " ")
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'CDB_OB_ARCHIVELOG_PIECE_FILES',
  table_id        = '21136 ',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    DEST_ID,
    ROUND_ID,
    PIECE_ID,
    INCARNATION,
    DEST_NO,
    STATUS,
    START_SCN,
    CASE
      WHEN START_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(START_SCN)
      END AS START_SCN_DISPLAY,
    CHECKPOINT_SCN,
    CASE
      WHEN CHECKPOINT_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(CHECKPOINT_SCN)
      END AS CHECKPOINT_SCN_DISPLAY,
    MAX_SCN,
    END_SCN,
    CASE
      WHEN END_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(END_SCN)
      END AS END_SCN_DISPLAY,
    COMPATIBLE,
    UNIT_SIZE,
    COMPRESSION,
    INPUT_BYTES,
    CASE
      WHEN INPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN INPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN INPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(INPUT_BYTES/1024/1024,2), 'MB')
      END AS INPUT_BYTES_DISPLAY,
    OUTPUT_BYTES,
    CASE
      WHEN OUTPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN OUTPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN OUTPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(OUTPUT_BYTES/1024/1024,2), 'MB')
      END AS OUTPUT_BYTES_DISPLAY,
    CASE
      WHEN INPUT_BYTES = 0
        THEN 0
      ELSE
        ROUND(OUTPUT_BYTES / INPUT_BYTES, 2)
      END AS COMPRESSION_RATIO,
    FILE_STATUS,
    PATH
    FROM OCEANBASE.__ALL_VIRTUAL_LOG_ARCHIVE_PIECE_FILES
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chongrong.th',
  table_name      = 'CDB_OB_BACKUP_SET_FILES',
  table_id        = '21137',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    BACKUP_SET_ID,
    DEST_ID,
    INCARNATION,
    BACKUP_TYPE,
    PREV_FULL_BACKUP_SET_ID,
    PREV_INC_BACKUP_SET_ID,
    USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
    CASE
      WHEN END_TS = 0
          THEN NULL
      ELSE
          USEC_TO_TIME(END_TS)
      END AS END_TIMESTAMP,
    STATUS,
    FILE_STATUS,
    CASE
      WHEN END_TS = 0
        THEN 0
      ELSE
        ROUND((END_TS - START_TS)/1000/1000,0)
      END AS ELAPSED_SECONDES,
    PLUS_ARCHIVELOG,
    START_REPLAY_SCN,
    CASE
      WHEN START_REPLAY_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(START_REPLAY_SCN)
      END AS START_REPLAY_SCN_DISPLAY,
    MIN_RESTORE_SCN,
    CASE
      WHEN MIN_RESTORE_SCN_DISPLAY != ''
        THEN MIN_RESTORE_SCN_DISPLAY
      WHEN MIN_RESTORE_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(MIN_RESTORE_SCN)
      END AS MIN_RESTORE_SCN_DISPLAY,
    INPUT_BYTES,
    OUTPUT_BYTES,
    CASE
      WHEN END_TS = 0
        THEN 0
      ELSE
        OUTPUT_BYTES / ((END_TS - START_TS)/1000/1000)
      END AS OUTPUT_RATE_BYTES,
    EXTRA_BYTES AS EXTRA_META_BYTES,
    TABLET_COUNT,
    FINISH_TABLET_COUNT,
    MACRO_BLOCK_COUNT,
    FINISH_MACRO_BLOCK_COUNT,
    FILE_COUNT,
    META_TURN_ID,
    DATA_TURN_ID,
    RESULT,
    COMMENT,
    ENCRYPTION_MODE,
    PASSWD,
    TENANT_COMPATIBLE,
    BACKUP_COMPATIBLE,
    PATH,
    CLUSTER_VERSION,
    CONSISTENT_SCN,
    MINOR_TURN_ID,
    MAJOR_TURN_ID
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_SET_FILES
""".replace("\n", " ")
)

# 21138: CDB_OB_BACKUP_BACKUPPIECE_JOB # abandoned in 4.0
# 21139: CDB_OB_BACKUP_BACKUPPIECE_JOB_HISTORY # abandoned in 4.0
# 21140: CDB_OB_BACKUP_BACKUPPIECE_TASK # abandoned in 4.0
# 21141: CDB_OB_BACKUP_BACKUPPIECE_TASK_HISTORY # abandoned in 4.0
# 21142: v$ob_all_clusters # abandoned in 4.0
# 21143: CDB_OB_BACKUP_ARCHIVELOG # abandoned in 4.0
# 21144: CDB_OB_BACKUP_BACKUP_ARCHIVELOG # abandoned in 4.0

def_table_schema(
  owner = 'jim.wjh',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'CONNECTION_CONTROL_FAILED_LOGIN_ATTEMPTS',
  table_id        = '21145',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  select
    concat('''',u.user_name,'''@''',u.host,'''') as USERHOST,
    s.failed_login_attempts as FAILED_ATTEMPTS
  from oceanbase.__all_virtual_tenant_user_failed_login_stat s
  join oceanbase.__all_virtual_user u
  on s.tenant_id = u.tenant_id and s.user_id = u.user_id
  where s.tenant_id = effective_tenant_id()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'fengshuo.fs',
  table_name      = 'GV$OB_TENANT_MEMORY',
  table_id        = '21146',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
     TENANT_ID,
     svr_ip AS SVR_IP,
     svr_port AS SVR_PORT,
     hold AS HOLD,
     CASE WHEN `limit` - hold > 0 THEN `limit` - hold ELSE 0 END AS FREE
FROM
    oceanbase.__all_virtual_tenant_memory_info
ORDER BY tenant_id, svr_ip, svr_port
""".replace("\n", " "),
)

def_table_schema(
  owner = 'fengshuo.fs',
  table_name      = 'V$OB_TENANT_MEMORY',
  table_id        = '21147',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT TENANT_ID,
       SVR_IP,
       SVR_PORT,
       HOLD,
       FREE
FROM
    oceanbase.GV$OB_TENANT_MEMORY
WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
    owner = 'xiaochu.yh',
    table_name     = 'GV$OB_PX_TARGET_MONITOR',
    table_id       = '21148',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """SELECT
          SVR_IP,
          SVR_PORT,
          TENANT_ID,
          CASE is_leader WHEN 1 THEN 'Y'
                         ELSE 'N' END AS IS_LEADER,
          VERSION,
          PEER_IP,
          PEER_PORT,
          PEER_TARGET,
          PEER_TARGET_USED,
          LOCAL_TARGET_USED,
          LOCAL_PARALLEL_SESSION_COUNT
        FROM oceanbase.__all_virtual_px_target_monitor
""".replace("\n", " ")
)

def_table_schema(
    owner = 'xiaochu.yh',
    table_name     = 'V$OB_PX_TARGET_MONITOR',
    table_id       = '21149',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """SELECT
                          SVR_IP,
                          SVR_PORT,
                          TENANT_ID,
                          IS_LEADER,
                          VERSION,
                          PEER_IP,
                          PEER_PORT,
                          PEER_TARGET,
                          PEER_TARGET_USED,
                          LOCAL_TARGET_USED,
                          LOCAL_PARALLEL_SESSION_COUNT
        FROM oceanbase.GV$OB_PX_TARGET_MONITOR
        WHERE svr_ip=HOST_IP() AND svr_port=RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'sean.yyj',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'COLUMN_PRIVILEGES',
  table_id        = '21150',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  WITH DB_PRIV AS (
    select A.tenant_id TENANT_ID,
           A.user_id USER_ID,
           A.database_name DATABASE_NAME,
           A.priv_alter PRIV_ALTER,
           A.priv_create PRIV_CREATE,
           A.priv_delete PRIV_DELETE,
           A.priv_drop PRIV_DROP,
           A.priv_grant_option PRIV_GRANT_OPTION,
           A.priv_insert PRIV_INSERT,
           A.priv_update PRIV_UPDATE,
           A.priv_select PRIV_SELECT,
           A.priv_index PRIV_INDEX,
           A.priv_create_view PRIV_CREATE_VIEW,
           A.priv_show_view PRIV_SHOW_VIEW,
           A.GMT_CREATE GMT_CREATE,
           A.GMT_MODIFIED GMT_MODIFIED,
           A.PRIV_OTHERS PRIV_OTHERS
    from oceanbase.__all_database_privilege_history A,
        (select tenant_id, user_id, database_name, max(schema_version) schema_version from oceanbase.__all_database_privilege_history group by tenant_id, user_id, database_name, database_name collate utf8mb4_bin) B
    where A.tenant_id = B.tenant_id and A.user_id = B.user_id and A.database_name collate utf8mb4_bin = B.database_name collate utf8mb4_bin and A.schema_version = B.schema_version and A.is_deleted = 0
  )
  SELECT cast(concat('''', B.user_name, '''', '@', '''', B.host, '''') as char(292)) as GRANTEE,
         cast('def' as char(512)) AS TABLE_CATALOG,
         cast(DATABASE_NAME as char(64)) AS TABLE_SCHEMA,
         cast(TABLE_NAME as char(64)) AS TABLE_NAME,
         cast(COLUMN_NAME as char(64)) AS COLUMN_NAME,
         cast(CASE WHEN V1.C1 = 0  AND (CP.all_priv & 1) != 0 THEN 'SELECT'
               WHEN V1.C1 = 1  AND (CP.all_priv & 2) != 0 THEN 'INSERT'
               WHEN V1.C1 = 2  AND (CP.all_priv & 4) != 0 THEN 'UPDATE'
               WHEN V1.C1 = 3  AND (CP.all_priv & 8) != 0 THEN 'REFERENCES'
               END AS char(64)) AS PRIVILEGE_TYPE,
         cast(case when priv_grant_option = 1 then 'YES' ELSE 'NO' END as char(3)) AS IS_GRANTABLE
  FROM oceanbase.__all_column_privilege CP, oceanbase.__all_user B,
      (SELECT 0 AS C1
        UNION ALL SELECT 1 AS C1
        UNION ALL SELECT 2 AS C1
        UNION ALL SELECT 3 AS C1) V1,
      (SELECT USER_ID
        FROM oceanbase.__all_user
        WHERE TENANT_ID = 0
          AND CONCAT(USER_NAME, '@', HOST) = CURRENT_USER()) CURR
      LEFT JOIN
      (SELECT USER_ID
        FROM DB_PRIV
        WHERE TENANT_ID = 0
          AND DATABASE_NAME = 'mysql'
          AND PRIV_SELECT = 1) DB ON CURR.USER_ID = DB.USER_ID
  WHERE CP.tenant_id = B.tenant_id
    and CP.tenant_id = 0
    and CP.user_id = B.user_id
    AND ((V1.C1 = 0 AND (CP.all_priv & 1) != 0)
         OR (V1.C1 = 1 AND (CP.all_priv & 2) != 0)
         OR (V1.C1 = 2 AND (CP.all_priv & 4) != 0)
         OR (V1.C1 = 0 AND (CP.all_priv & 8) != 0))
    AND (DB.USER_ID IS NOT NULL
          OR 512 & CURRENT_USER_PRIV() = 512
          OR CP.user_id = CURR.USER_ID)
""".replace("\n", " "),
)

def_table_schema(
  owner = 'luofan.zp',
  tablegroup_id = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'VIEW_TABLE_USAGE',
  table_id       = '21151',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,

  view_definition = """
    select
    cast('def' as CHAR(64)) AS VIEW_CATALOG,
    v.VIEW_SCHEMA collate utf8mb4_name_case as VIEW_SCHEMA,
    v.VIEW_NAME collate utf8mb4_name_case as VIEW_NAME,
    t.TABLE_SCHEMA collate utf8mb4_name_case as TABLE_SCHEMA,
    t.TABLE_NAME collate utf8mb4_name_case as TABLE_NAME,
    cast('def' as CHAR(64)) AS TABLE_CATALOG
    from
    (select o.tenant_id,
            o.database_name as VIEW_SCHEMA,
            o.table_name as VIEW_NAME,
            d.dep_obj_id as DEP_OBJ_ID,
            d.ref_obj_id as REF_OBJ_ID
     from (select t.tenant_id,
                  d.database_name as database_name,
                  t.table_name as table_name,
                  t.table_id as table_id
           from oceanbase.__all_table as t
           join oceanbase.__all_database as d
           on t.tenant_id = d.tenant_id and t.database_id = d.database_id
           where t.table_mode >> 12 & 15 in (0,1) and t.index_attributes_set & 16 = 0) o
           join oceanbase.__all_tenant_dependency d
           on o.tenant_id = d.tenant_id and d.dep_obj_id = o.table_id) v

     join

     (select o.tenant_id,
             o.database_name as TABLE_SCHEMA,
             o.table_name as TABLE_NAME,
             d.dep_obj_id as DEP_OBJ_ID,
             d.ref_obj_id as REF_OBJ_ID
      from (select t.tenant_id,
                   d.database_name as database_name,
                   t.table_name as table_name,
                   t.table_id as table_id
            from oceanbase.__all_table as t
            join oceanbase.__all_database as d
            on t.tenant_id = d.tenant_id and t.database_id = d.database_id) o
            join oceanbase.__all_tenant_dependency d
            on o.tenant_id = d.tenant_id and d.ref_obj_id = o.table_id) t

    on t.tenant_id = v.tenant_id and v.dep_obj_id = t.dep_obj_id and v.ref_obj_id = t.ref_obj_id
    where v.tenant_id = 0
      and (0 = sys_privilege_check('table_acc', effective_tenant_id())
            or 0 = sys_privilege_check('table_acc', effective_tenant_id(), t.table_schema, v.view_name))
""".replace("\n", " "),


  normal_columns = [
  ],
)

def_table_schema(
  owner = 'chongrong.th',
  table_name      = 'CDB_OB_BACKUP_JOBS',
  table_id        = '21152',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    JOB_ID,
    INCARNATION,
    BACKUP_SET_ID,
    INITIATOR_TENANT_ID,
    INITIATOR_JOB_ID,
    EXECUTOR_TENANT_ID,
    PLUS_ARCHIVELOG,
    BACKUP_TYPE,
    JOB_LEVEL,
    ENCRYPTION_MODE,
    PASSWD,
    USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
    CASE
      WHEN END_TS = 0
        THEN NULL
      ELSE
        USEC_TO_TIME(END_TS)
      END AS END_TIMESTAMP,
    STATUS,
    RESULT,
    COMMENT,
    DESCRIPTION,
    PATH
    FROM OCEANBASE.__all_virtual_backup_job
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chongrong.th',
  table_name      = 'CDB_OB_BACKUP_JOB_HISTORY',
  table_id        = '21153',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    JOB_ID,
    INCARNATION,
    BACKUP_SET_ID,
    INITIATOR_TENANT_ID,
    INITIATOR_JOB_ID,
    EXECUTOR_TENANT_ID,
    PLUS_ARCHIVELOG,
    BACKUP_TYPE,
    JOB_LEVEL,
    ENCRYPTION_MODE,
    PASSWD,
    USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
    CASE
      WHEN END_TS = 0
        THEN NULL
      ELSE
        USEC_TO_TIME(END_TS)
      END AS END_TIMESTAMP,
    STATUS,
    RESULT,
    COMMENT,
    DESCRIPTION,
    PATH
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_JOB_HISTORY
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chongrong.th',
  table_name      = 'CDB_OB_BACKUP_TASKS',
  table_id        = '21154',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    TASK_ID,
    JOB_ID,
    INCARNATION,
    BACKUP_SET_ID,
    USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
    CASE
      WHEN END_TS = 0
        THEN NULL
      ELSE
        USEC_TO_TIME(END_TS)
      END AS END_TIMESTAMP,
    STATUS,
    START_SCN,
    END_SCN,
    USER_LS_START_SCN,
    ENCRYPTION_MODE,
    PASSWD,
    INPUT_BYTES,
    OUTPUT_BYTES,
    CASE
      WHEN END_TS = 0
        THEN 0
      ELSE
        OUTPUT_BYTES / ((END_TS - START_TS)/1000/1000)
      END AS OUTPUT_RATE_BYTES,
    EXTRA_BYTES AS EXTRA_META_BYTES,
    TABLET_COUNT,
    FINISH_TABLET_COUNT,
    MACRO_BLOCK_COUNT,
    FINISH_MACRO_BLOCK_COUNT,
    FILE_COUNT,
    META_TURN_ID,
    DATA_TURN_ID,
    RESULT,
    COMMENT,
    PATH,
    MINOR_TURN_ID,
    MAJOR_TURN_ID,
    CASE
        WHEN MACRO_BLOCK_COUNT = 0 THEN 0.00
        WHEN FINISH_MACRO_BLOCK_COUNT > MACRO_BLOCK_COUNT THEN 99.99
        ELSE ROUND((FINISH_MACRO_BLOCK_COUNT / MACRO_BLOCK_COUNT) * 100, 2)
    END AS DATA_PROGRESS,
    LOG_FILE_COUNT,
    FINISH_LOG_FILE_COUNT,
    CASE
        WHEN LOG_FILE_COUNT = 0 THEN 0.00
        WHEN FINISH_LOG_FILE_COUNT > LOG_FILE_COUNT THEN 99.99
        ELSE ROUND((FINISH_LOG_FILE_COUNT / LOG_FILE_COUNT) * 100, 2)
    END AS LOG_PROGRESS
    FROM OCEANBASE.__all_virtual_backup_task
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chongrong.th',
  table_name      = 'CDB_OB_BACKUP_TASK_HISTORY',
  table_id        = '21155',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    TASK_ID,
    JOB_ID,
    INCARNATION,
    BACKUP_SET_ID,
    USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
    CASE
      WHEN END_TS = 0
        THEN NULL
      ELSE
        USEC_TO_TIME(END_TS)
      END AS END_TIMESTAMP,
    STATUS,
    START_SCN,
    END_SCN,
    USER_LS_START_SCN,
    ENCRYPTION_MODE,
    PASSWD,
    INPUT_BYTES,
    OUTPUT_BYTES,
    CASE
      WHEN END_TS = 0
        THEN 0
      ELSE
        OUTPUT_BYTES / ((END_TS - START_TS)/1000/1000)
      END AS OUTPUT_RATE_BYTES,
    EXTRA_BYTES AS EXTRA_META_BYTES,
    TABLET_COUNT,
    FINISH_TABLET_COUNT,
    MACRO_BLOCK_COUNT,
    FINISH_MACRO_BLOCK_COUNT,
    FILE_COUNT,
    META_TURN_ID,
    DATA_TURN_ID,
    RESULT,
    COMMENT,
    PATH,
    MINOR_TURN_ID,
    MAJOR_TURN_ID
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_TASK_HISTORY
""".replace("\n", " ")
)

# 21156: CDB_OB_LOG_ARCHIVE_LS_SUMMARY

def_table_schema(
  owner = 'xiaochu.yh',
  tablegroup_id  = 'OB_INVALID_ID',
  database_id    = 'OB_INFORMATION_SCHEMA_ID',
  table_name     = 'FILES',
  table_id       = '21157',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  in_tenant_space = True,
  view_definition = """SELECT FILE_ID,
                              FILE_NAME,
                              FILE_TYPE,
                              TABLESPACE_NAME,
                              TABLE_CATALOG,
                              TABLE_SCHEMA,
                              TABLE_NAME,
                              LOGFILE_GROUP_NAME,
                              LOGFILE_GROUP_NUMBER,
                              ENGINE,
                              FULLTEXT_KEYS,
                              DELETED_ROWS,
                              UPDATE_COUNT,
                              FREE_EXTENTS,
                              TOTAL_EXTENTS,
                              EXTENT_SIZE,
                              INITIAL_SIZE,
                              MAXIMUM_SIZE,
                              AUTOEXTEND_SIZE,
                              CREATION_TIME,
                              LAST_UPDATE_TIME,
                              LAST_ACCESS_TIME,
                              RECOVER_TIME,
                              TRANSACTION_COUNTER,
                              VERSION,
                              ROW_FORMAT,
                              TABLE_ROWS,
                              AVG_ROW_LENGTH,
                              DATA_LENGTH,
                              MAX_DATA_LENGTH,
                              INDEX_LENGTH,
                              DATA_FREE,
                              CREATE_TIME,
                              UPDATE_TIME,
                              CHECK_TIME,
                              CHECKSUM,
                              STATUS,
                              EXTRA
                   FROM oceanbase.__all_virtual_files""".replace("\n", " "),
  normal_columns = [
  ],
)

def_table_schema(
    owner = 'wanhong.wwh',
    table_name     = 'DBA_OB_TENANTS',
    table_id       = '21158',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """
SELECT A.TENANT_ID,
       TENANT_NAME,
       (CASE
            WHEN A.TENANT_ID = 1 THEN 'SYS'
            WHEN (A.TENANT_ID & 0x1) = 1 THEN 'META'
            ELSE 'USER'
        END) AS TENANT_TYPE,
       A.gmt_create AS CREATE_TIME,
       A.gmt_modified AS MODIFY_TIME,
       PRIMARY_ZONE,
       LOCALITY,
       CASE previous_locality
          WHEN "" THEN NULL
          ELSE previous_locality
       END AS PREVIOUS_LOCALITY,
       CASE compatibility_mode
          WHEN 0 THEN 'MYSQL'
          WHEN 1 THEN 'ORACLE'
          ELSE NULL
       END AS COMPATIBILITY_MODE,
       STATUS,
       CASE in_recyclebin
          WHEN 0 THEN 'NO'
          ELSE 'YES'
       END AS IN_RECYCLEBIN,

       CASE locked
          WHEN 0 THEN 'NO'
          ELSE 'YES'
       END AS LOCKED,

       (CASE
            WHEN A.TENANT_ID = 1 THEN 'PRIMARY'
            WHEN (A.TENANT_ID & 0x1) = 1 THEN 'PRIMARY'
            ELSE TENANT_ROLE
        END) AS TENANT_ROLE,

       (CASE
            WHEN A.TENANT_ID = 1 THEN 'NORMAL'
            WHEN (A.TENANT_ID & 0x1) = 1 THEN 'NORMAL'
            ELSE SWITCHOVER_STATUS
        END) AS SWITCHOVER_STATUS,

       (CASE
            WHEN A.TENANT_ID = 1 THEN 0
            WHEN (A.TENANT_ID & 0x1) = 1 THEN 0
            ELSE SWITCHOVER_EPOCH
        END) AS SWITCHOVER_EPOCH,

       (CASE
            WHEN A.TENANT_ID = 1 THEN NULL
            WHEN (A.TENANT_ID & 0x1) = 1 THEN NULL
            ELSE SYNC_SCN
        END) AS SYNC_SCN,

       (CASE
            WHEN A.TENANT_ID = 1 THEN NULL
            WHEN (A.TENANT_ID & 0x1) = 1 THEN NULL
            ELSE REPLAYABLE_SCN
        END) AS REPLAYABLE_SCN,

       (CASE
            WHEN A.TENANT_ID = 1 THEN NULL
            WHEN (A.TENANT_ID & 0x1) = 1 THEN NULL
            ELSE READABLE_SCN
        END) AS READABLE_SCN,

       (CASE
            WHEN A.TENANT_ID = 1 THEN NULL
            WHEN (A.TENANT_ID & 0x1) = 1 THEN NULL
            ELSE RECOVERY_UNTIL_SCN
        END) AS RECOVERY_UNTIL_SCN,

       (CASE
            WHEN A.TENANT_ID = 1 THEN 'NOARCHIVELOG'
            WHEN (A.TENANT_ID & 0x1) = 1 THEN 'NOARCHIVELOG'
            ELSE LOG_MODE
        END) AS LOG_MODE,
       ARBITRATION_SERVICE_STATUS,
       UNIT_NUM,
       COMPATIBLE,
       (CASE
            WHEN (MOD(A.TENANT_ID, 2)) = 1 THEN 1
            ELSE B.MAX_LS_ID END) AS MAX_LS_ID,
       (CASE
            WHEN A.TENANT_ID = 1 THEN 'NORMAL'
            WHEN (A.TENANT_ID & 0x1) = 1 THEN 'NORMAL'
            ELSE RESTORE_DATA_MODE
        END) AS RESTORE_DATA_MODE
FROM OCEANBASE.__ALL_VIRTUAL_TENANT_MYSQL_SYS_AGENT AS A
LEFT JOIN OCEANBASE.__ALL_VIRTUAL_TENANT_INFO AS B
    ON A.TENANT_ID = B.TENANT_ID
LEFT JOIN
    (SELECT TENANT_ID,
            (CASE
                 WHEN TENANT_ID < 1 THEN NULL
                 WHEN TENANT_ID != 1 THEN TENANT_ID - 1
                 ELSE NULL
             END) AS META_TENANT_ID,
            MIN(UNIT_COUNT) AS UNIT_NUM
     FROM OCEANBASE.__ALL_VIRTUAL_RESOURCE_POOL_MYSQL_SYS_AGENT
     GROUP BY TENANT_ID) AS C
    ON A.TENANT_ID = C.TENANT_ID OR A.TENANT_ID = C.META_TENANT_ID
LEFT JOIN
    (SELECT TENANT_ID,
            MIN(VALUE) AS COMPATIBLE
     FROM OCEANBASE.__ALL_VIRTUAL_TENANT_PARAMETER
     WHERE NAME = 'compatible'
     GROUP BY TENANT_ID) AS D
    ON A.TENANT_ID = D.TENANT_ID
""".replace("\n", " ")
)

#### sys tenant only view
def_table_schema(
    owner = 'wanhong.wwh',
    table_name     = 'DBA_OB_UNITS',
    table_id       = '21159',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = False,
    view_definition = """
SELECT T.unit_id AS UNIT_ID,

       CASE R.tenant_id
           WHEN -1 THEN NULL
           ELSE R.tenant_id
       END AS TENANT_ID,

       T.status AS STATUS,
       T.resource_pool_id AS RESOURCE_POOL_ID,
       UNIT_GROUP_ID,
       T.gmt_create AS CREATE_TIME,
       T.gmt_modified AS MODIFY_TIME,
       ZONE,
       SVR_IP,
       SVR_PORT,

       CASE migrate_from_svr_ip
           WHEN "" THEN NULL
           ELSE migrate_from_svr_ip
       END AS MIGRATE_FROM_SVR_IP,

       CASE migrate_from_svr_ip
           WHEN "" THEN NULL
           ELSE migrate_from_svr_port
       END AS MIGRATE_FROM_SVR_PORT,

       CASE migrate_from_svr_ip
           WHEN "" THEN NULL
           ELSE (CASE manual_migrate WHEN 0 THEN 'NO' ELSE 'YES' END)
       END AS MANUAL_MIGRATE,

       R.unit_config_id AS UNIT_CONFIG_ID,

       U.MAX_CPU AS MAX_CPU,
       U.MIN_CPU AS MIN_CPU,
       U.MEMORY_SIZE AS MEMORY_SIZE,
       U.LOG_DISK_SIZE AS LOG_DISK_SIZE,
       CASE DATA_DISK_SIZE
           WHEN 0 THEN NULL
           WHEN -1 THEN NULL
           ELSE DATA_DISK_SIZE
       END AS DATA_DISK_SIZE,
       U.MAX_IOPS AS MAX_IOPS,
       U.MIN_IOPS AS MIN_IOPS,
       U.IOPS_WEIGHT AS IOPS_WEIGHT,
       U.MAX_NET_BANDWIDTH AS MAX_NET_BANDWIDTH,
       U.NET_BANDWIDTH_WEIGHT AS NET_BANDWIDTH_WEIGHT
FROM
  oceanbase.__all_unit T,
  oceanbase.__all_resource_pool R,
  oceanbase.__all_unit_config U
WHERE
  T.resource_pool_id = R.resource_pool_id and R.unit_config_id = U.unit_config_id
""".replace("\n", " ")
)

#### sys tenant only view
def_table_schema(
    owner = 'wanhong.wwh',
    table_name     = 'DBA_OB_UNIT_CONFIGS',
    table_id       = '21160',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = False,
    view_definition = """
SELECT UNIT_CONFIG_ID,
       NAME,
       gmt_create AS CREATE_TIME,
       gmt_modified AS MODIFY_TIME,
       MAX_CPU,
       MIN_CPU,
       MEMORY_SIZE,
       LOG_DISK_SIZE,
       CASE DATA_DISK_SIZE
           WHEN 0 THEN NULL
           WHEN -1 THEN NULL
           ELSE DATA_DISK_SIZE
       END AS DATA_DISK_SIZE,
       MAX_IOPS,
       MIN_IOPS,
       IOPS_WEIGHT,
       MAX_NET_BANDWIDTH,
       NET_BANDWIDTH_WEIGHT
FROM oceanbase.__all_unit_config
""".replace("\n", " ")
)

#### sys tenant only view
def_table_schema(
    owner = 'wanhong.wwh',
    table_name     = 'DBA_OB_RESOURCE_POOLS',
    table_id       = '21161',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = False,
    view_definition = """
SELECT RESOURCE_POOL_ID,
       NAME,
       CASE TENANT_ID WHEN -1 THEN NULL ELSE TENANT_ID END AS TENANT_ID,
       gmt_create AS CREATE_TIME,
       gmt_modified AS MODIFY_TIME,
       UNIT_COUNT,
       UNIT_CONFIG_ID,
       ZONE_LIST,
       CASE replica_type
          WHEN 0 THEN "FULL"
          ELSE NULL
       END AS REPLICA_TYPE
FROM oceanbase.__all_resource_pool
""".replace("\n", " ")
)

#### sys tenant only view
def_table_schema(
    owner = 'wanhong.wwh',
    table_name     = 'DBA_OB_SERVERS',
    table_id       = '21162',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = False,
    view_definition = """
SELECT SVR_IP,
       SVR_PORT,
       ID,
       ZONE,
       inner_port AS SQL_PORT,

       CASE with_rootserver
          WHEN 1 THEN 'YES'
          ELSE 'NO' END
       AS WITH_ROOTSERVER,

       STATUS,

       CASE start_service_time
          WHEN 0 THEN NULL
          ELSE usec_to_time(start_service_time) END
       AS START_SERVICE_TIME,

       CASE stop_time
          WHEN 0 THEN NULL
          ELSE usec_to_time(stop_time) END
       AS STOP_TIME,

       CASE block_migrate_in_time
          WHEN 0 THEN NULL
          ELSE usec_to_time(block_migrate_in_time)  END
       AS BLOCK_MIGRATE_IN_TIME,

       gmt_create AS CREATE_TIME,
       gmt_modified AS MODIFY_TIME,

       BUILD_VERSION,

       CASE last_offline_time
          WHEN 0 THEN NULL
          ELSE usec_to_time(last_offline_time) END
       AS LAST_OFFLINE_TIME
FROM oceanbase.__all_server
""".replace("\n", " ")
)

#### sys tenant only view
def_table_schema(
    owner = 'wanhong.wwh',
    table_name     = 'DBA_OB_ZONES',
    table_id       = '21163',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = False,
    view_definition = """
SELECT
  S.zone as ZONE,
  S.create_time AS CREATE_TIME,
  M.modify_time AS MODIFY_TIME,
  STATUS,
  IDC,
  REGION,
  TYPE
FROM
  (SELECT zone, info AS status, gmt_create AS create_time FROM oceanbase.__all_zone WHERE name = 'status') S,
  (SELECT zone, info AS idc FROM oceanbase.__all_zone WHERE name = 'idc') I,
  (SELECT zone, info AS region FROM oceanbase.__all_zone WHERE name = 'region') R,
  (SELECT zone, info AS type FROM oceanbase.__all_zone WHERE name = 'zone_type') T,
  (SELECT zone, max(gmt_modified) AS modify_time FROM oceanbase.__all_zone where zone != '' group by zone) M
WHERE S.zone = I.zone and S.zone = R.zone and S.zone = T.zone and S.zone = M.zone
""".replace("\n", " ")
)

#### sys tenant only view
def_table_schema(
    owner = 'wanhong.wwh',
    table_name     = 'DBA_OB_ROOTSERVICE_EVENT_HISTORY',
    table_id       = '21164',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = False,
    view_definition = """
SELECT
  gmt_create AS `TIMESTAMP`,
  MODULE,
  EVENT,
  NAME1, VALUE1,
  NAME2, VALUE2,
  NAME3, VALUE3,
  NAME4, VALUE4,
  NAME5, VALUE5,
  NAME6, VALUE6,
  EXTRA_INFO,
  RS_SVR_IP,
  RS_SVR_PORT
FROM oceanbase.__all_rootservice_event_history
""".replace("\n", " ")
)

#### sys tenant only view
def_table_schema(
    owner = 'wanhong.wwh',
    table_name     = 'DBA_OB_TENANT_JOBS',
    table_id       = '21165',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = False,
    view_definition = """
SELECT
  JOB_ID,
  JOB_TYPE,
  JOB_STATUS,
  RESULT_CODE,
  PROGRESS,
  gmt_create AS START_TIME,
  gmt_modified AS MODIFY_TIME,
  TENANT_ID,
  SQL_TEXT,
  EXTRA_INFO,
  RS_SVR_IP,
  RS_SVR_PORT
FROM oceanbase.__all_rootservice_job
WHERE
  JOB_TYPE in (
    'ALTER_TENANT_LOCALITY',
    'ROLLBACK_ALTER_TENANT_LOCALITY',
    'SHRINK_RESOURCE_TENANT_UNIT_NUM',
    'ALTER_TENANT_PRIMARY_ZONE',
    'ALTER_RESOURCE_TENANT_UNIT_NUM',
    'UPGRADE_POST_ACTION',
    'UPGRADE_SYSTEM_VARIABLE',
    'UPGRADE_SYSTEM_TABLE',
    'UPGRADE_BEGIN',
    'UPGRADE_VIRTUAL_SCHEMA',
    'UPGRADE_SYSTEM_PACKAGE',
    'UPGRADE_ALL_POST_ACTION',
    'UPGRADE_INSPECTION',
    'UPGRADE_END',
    'UPGRADE_ALL'
  )
  AND TENANT_ID != 0
""".replace("\n", " ")
)

#### sys tenant only view
def_table_schema(
    owner = 'wanhong.wwh',
    table_name     = 'DBA_OB_UNIT_JOBS',
    table_id       = '21166',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = False,
    view_definition = """
SELECT
  JOB_ID,
  JOB_TYPE,
  JOB_STATUS,
  RESULT_CODE,
  PROGRESS,
  gmt_create AS START_TIME,
  gmt_modified AS MODIFY_TIME,
  CASE tenant_id WHEN -1 THEN NULL ELSE tenant_id END AS TENANT_ID,
  UNIT_ID,
  SQL_TEXT,
  EXTRA_INFO,
  RS_SVR_IP,
  RS_SVR_PORT
FROM oceanbase.__all_rootservice_job
WHERE
  JOB_TYPE in (
    'MIGRATE_UNIT'
  )
""".replace("\n", " ")
)

#### sys tenant only view
def_table_schema(
    owner = 'wanhong.wwh',
    table_name     = 'DBA_OB_SERVER_JOBS',
    table_id       = '21167',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = False,
    view_definition = """
SELECT
  JOB_ID,
  JOB_TYPE,
  JOB_STATUS,
  RESULT_CODE,
  PROGRESS,
  gmt_create AS START_TIME,
  gmt_modified AS MODIFY_TIME,
  SVR_IP,
  SVR_PORT,
  SQL_TEXT,
  EXTRA_INFO,
  RS_SVR_IP,
  RS_SVR_PORT
FROM oceanbase.__all_rootservice_job
WHERE
  JOB_TYPE in (
    'DELETE_SERVER'
  )
""".replace("\n", " ")
)

# FIXME:(yanmu.ztl) sys、mysql tenant should have different definition, sys won't should its own data now.
def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_OB_LS_LOCATIONS',
  table_id        = '21168',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  (
  SELECT NOW(6) AS CREATE_TIME,
         NOW(6) AS MODIFY_TIME,
         LS_ID,
         SVR_IP,
         SVR_PORT,
         SQL_PORT,
         ZONE,
         (CASE ROLE WHEN 1 THEN "LEADER" ELSE "FOLLOWER" END) AS ROLE,
         (CASE ROLE WHEN 1 THEN MEMBER_LIST ELSE NULL END) AS MEMBER_LIST,
         (CASE ROLE WHEN 1 THEN PAXOS_REPLICA_NUMBER ELSE NULL END) AS PAXOS_REPLICA_NUMBER,
         (CASE REPLICA_TYPE
          WHEN 0   THEN "FULL"
          WHEN 5   THEN "LOGONLY"
          WHEN 16  THEN "READONLY"
          WHEN 261 THEN "ENCRYPTION LOGONLY"
          WHEN 1040 THEN "COLUMNSTORE"
          ELSE NULL END) AS REPLICA_TYPE,
         (CASE ROLE WHEN 1 THEN LEARNER_LIST ELSE "" END) AS LEARNER_LIST,
         (CASE REBUILD
           WHEN 0  THEN "FALSE"
           ELSE "TRUE" END) AS REBUILD
  FROM OCEANBASE.__ALL_VIRTUAL_CORE_META_TABLE
  WHERE
    EFFECTIVE_TENANT_ID() = 1
  )
  UNION ALL
  (
  SELECT GMT_CREATE AS CREATE_TIME,
         GMT_MODIFIED AS MODIFY_TIME,
         LS_ID,
         SVR_IP,
         SVR_PORT,
         SQL_PORT,
         ZONE,
         (CASE ROLE WHEN 1 THEN "LEADER" ELSE "FOLLOWER" END) AS ROLE,
         (CASE ROLE WHEN 1 THEN MEMBER_LIST ELSE NULL END) AS MEMBER_LIST,
         (CASE ROLE WHEN 1 THEN PAXOS_REPLICA_NUMBER ELSE NULL END) AS PAXOS_REPLICA_NUMBER,
         (CASE REPLICA_TYPE
          WHEN 0   THEN "FULL"
          WHEN 5   THEN "LOGONLY"
          WHEN 16  THEN "READONLY"
          WHEN 261 THEN "ENCRYPTION LOGONLY"
          WHEN 1040  THEN "COLUMNSTORE"
          ELSE NULL END) AS REPLICA_TYPE,
         (CASE ROLE WHEN 1 THEN LEARNER_LIST ELSE "" END) AS LEARNER_LIST,
         (CASE REBUILD
           WHEN 0  THEN "FALSE"
           ELSE "TRUE" END) AS REBUILD
  FROM OCEANBASE.__ALL_VIRTUAL_LS_META_TABLE
  WHERE
    TENANT_ID = EFFECTIVE_TENANT_ID() AND TENANT_ID != 1
  )
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_OB_LS_LOCATIONS',
  table_id        = '21169',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  (
  SELECT NOW(6) AS CREATE_TIME,
         NOW(6) AS MODIFY_TIME,
         TENANT_ID,
         LS_ID,
         SVR_IP,
         SVR_PORT,
         SQL_PORT,
         ZONE,
         (CASE ROLE WHEN 1 THEN "LEADER" ELSE "FOLLOWER" END) AS ROLE,
         (CASE ROLE WHEN 1 THEN MEMBER_LIST ELSE NULL END) AS MEMBER_LIST,
         (CASE ROLE WHEN 1 THEN PAXOS_REPLICA_NUMBER ELSE NULL END) AS PAXOS_REPLICA_NUMBER,
         (CASE REPLICA_TYPE
          WHEN 0   THEN "FULL"
          WHEN 5   THEN "LOGONLY"
          WHEN 16  THEN "READONLY"
          WHEN 261 THEN "ENCRYPTION LOGONLY"
          WHEN 1040  THEN "COLUMNSTORE"
          ELSE NULL END) AS REPLICA_TYPE,
         (CASE ROLE WHEN 1 THEN LEARNER_LIST ELSE "" END) AS LEARNER_LIST,
         (CASE REBUILD
           WHEN 0  THEN "FALSE"
           ELSE "TRUE" END) AS REBUILD
  FROM OCEANBASE.__ALL_VIRTUAL_CORE_META_TABLE
  )
  UNION ALL
  (
  SELECT GMT_CREATE AS CREATE_TIME,
         GMT_MODIFIED AS MODIFY_TIME,
         TENANT_ID,
         LS_ID,
         SVR_IP,
         SVR_PORT,
         SQL_PORT,
         ZONE,
         (CASE ROLE WHEN 1 THEN "LEADER" ELSE "FOLLOWER" END) AS ROLE,
         (CASE ROLE WHEN 1 THEN MEMBER_LIST ELSE NULL END) AS MEMBER_LIST,
         (CASE ROLE WHEN 1 THEN PAXOS_REPLICA_NUMBER ELSE NULL END) AS PAXOS_REPLICA_NUMBER,
         (CASE REPLICA_TYPE
          WHEN 0   THEN "FULL"
          WHEN 5   THEN "LOGONLY"
          WHEN 16  THEN "READONLY"
          WHEN 261 THEN "ENCRYPTION LOGONLY"
          WHEN 1040  THEN "COLUMNSTORE"
          ELSE NULL END) AS REPLICA_TYPE,
         (CASE ROLE WHEN 1 THEN LEARNER_LIST ELSE "" END) AS LEARNER_LIST,
         (CASE REBUILD
           WHEN 0  THEN "FALSE"
           ELSE "TRUE" END) AS REBUILD
  FROM OCEANBASE.__ALL_VIRTUAL_LS_META_TABLE
  WHERE TENANT_ID != 1
  )
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_OB_TABLET_TO_LS',
  table_id        = '21170',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  (
  SELECT CAST(TABLE_ID AS SIGNED) AS TABLET_ID,
         CAST(1 AS SIGNED) AS LS_ID
  FROM OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE
  WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
  )
  UNION ALL
  (
  SELECT CAST(TABLE_ID AS SIGNED) AS TABLET_ID,
         CAST(1 AS SIGNED) AS LS_ID
  FROM OCEANBASE.__ALL_TABLE
  WHERE TENANT_ID = 0
     AND ((TABLE_ID > 0 AND TABLE_ID < 10000)
          OR (TABLE_ID > 50000 AND TABLE_ID < 70000)
          OR (TABLE_ID > 100000 AND TABLE_ID < 200000))
  )
  UNION ALL
  (
  SELECT TABLET_ID,
         LS_ID
  FROM OCEANBASE.__ALL_TABLET_TO_LS
  )
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_OB_TABLET_TO_LS',
  table_id        = '21171',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  (
  SELECT TENANT_ID,
         CAST(TABLE_ID AS SIGNED) AS TABLET_ID,
         CAST(1 AS SIGNED) AS LS_ID
  FROM OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE
  )
  UNION ALL
  (
  SELECT TENANT_ID,
         CAST(TABLE_ID AS SIGNED) AS TABLET_ID,
         CAST(1 AS SIGNED) AS LS_ID
  FROM OCEANBASE.__ALL_VIRTUAL_TABLE
  WHERE (TABLE_ID > 0 AND TABLE_ID < 10000)
         OR (TABLE_ID > 50000 AND TABLE_ID < 70000)
         OR (TABLE_ID > 100000 AND TABLE_ID < 200000)
  )
  UNION ALL
  (
  SELECT TENANT_ID,
         TABLET_ID,
         LS_ID
  FROM OCEANBASE.__ALL_VIRTUAL_TABLET_TO_LS
  )
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_OB_TABLET_REPLICAS',
  table_id        = '21172',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  SELECT gmt_create AS CREATE_TIME,
         gmt_modified AS MODIFY_TIME,
         TABLET_ID,
         SVR_IP,
         SVR_PORT,
         LS_ID,
         COMPACTION_SCN,
         DATA_SIZE,
         REQUIRED_SIZE
  FROM OCEANBASE.__ALL_VIRTUAL_TABLET_META_TABLE
  WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_OB_TABLET_REPLICAS',
  table_id        = '21173',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT gmt_create AS CREATE_TIME,
         gmt_modified AS MODIFY_TIME,
         TENANT_ID,
         TABLET_ID,
         SVR_IP,
         SVR_PORT,
         LS_ID,
         COMPACTION_SCN,
         DATA_SIZE,
         REQUIRED_SIZE
  FROM OCEANBASE.__ALL_VIRTUAL_TABLET_META_TABLE
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_OB_TABLEGROUPS',
  table_id        = '21174',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  SELECT TABLEGROUP_NAME,

         CAST("NONE" AS CHAR(13)) AS PARTITIONING_TYPE,

         CAST("NONE" AS CHAR(13)) AS SUBPARTITIONING_TYPE,

         CAST(NULL AS SIGNED) AS PARTITION_COUNT,

         CAST(NULL AS SIGNED) AS DEF_SUBPARTITION_COUNT,

         CAST(NULL AS SIGNED) AS PARTITIONING_KEY_COUNT,

         CAST(NULL AS SIGNED) AS SUBPARTITIONING_KEY_COUNT,

         SHARDING

  FROM OCEANBASE.__ALL_TABLEGROUP
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_OB_TABLEGROUPS',
  table_id        = '21175',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT TENANT_ID,

         TABLEGROUP_NAME,

         CAST("NONE" AS CHAR(13)) AS PARTITIONING_TYPE,

         CAST("NONE" AS CHAR(13)) AS SUBPARTITIONING_TYPE,

         CAST(NULL AS SIGNED) AS PARTITION_COUNT,

         CAST(NULL AS SIGNED)  AS DEF_SUBPARTITION_COUNT,

         CAST(NULL AS SIGNED) AS PARTITIONING_KEY_COUNT,

         CAST(NULL AS SIGNED) AS SUBPARTITIONING_KEY_COUNT,

         SHARDING

  FROM OCEANBASE.__ALL_VIRTUAL_TABLEGROUP
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_OB_TABLEGROUP_PARTITIONS',
  table_id        = '21176',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  SELECT CAST("" AS CHAR(128)) AS TABLEGROUP_NAME,

         CAST("NO" AS CHAR(3)) AS COMPOSITE,

         CAST("" AS CHAR(64)) AS PARTITION_NAME,

         CAST(NULL AS SIGNED) AS SUBPARTITION_COUNT,

         CAST(NULL AS CHAR(4096)) AS HIGH_VALUE,

         CAST(NULL AS SIGNED) AS HIGH_VALUE_LENGTH,

         CAST(NULL AS UNSIGNED) AS PARTITION_POSITION
  FROM
    DUAL
  WHERE
    0 = 1
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_OB_TABLEGROUP_PARTITIONS',
  table_id        = '21177',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT CAST(NULL AS SIGNED) AS TENANT_ID,

         CAST('' AS CHAR(128)) AS TABLEGROUP_NAME,

         CAST('NO' AS CHAR(3)) AS COMPOSITE,

         CAST('' AS CHAR(64)) AS PARTITION_NAME,

         CAST(NULL AS SIGNED) AS SUBPARTITION_COUNT,

         CAST(NULL AS CHAR(4096)) AS HIGH_VALUE,

         CAST(NULL AS SIGNED) AS HIGH_VALUE_LENGTH,

         CAST(NULL AS UNSIGNED) AS PARTITION_POSITION
  FROM
      DUAL
  WHERE
      0 = 1
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_OB_TABLEGROUP_SUBPARTITIONS',
  table_id        = '21178',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  SELECT CAST("" AS CHAR(128)) AS TABLEGROUP_NAME,

         CAST("" AS CHAR(64)) AS PARTITION_NAME,

         CAST("" AS CHAR(64)) AS SUBPARTITION_NAME,

         CAST(NULL AS CHAR(4096)) AS HIGH_VALUE,

         CAST(NULL AS SIGNED) AS HIGH_VALUE_LENGTH,

         CAST(NULL AS UNSIGNED) AS PARTITION_POSITION,

         CAST(NULL AS UNSIGNED) AS SUBPARTITION_POSITION
   FROM
      DUAL
   WHERE
      0 = 1
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_OB_TABLEGROUP_SUBPARTITIONS',
  table_id        = '21179',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT CAST(NULL AS SIGNED) AS TENANT_ID,

         CAST("" AS CHAR(128)) AS TABLEGROUP_NAME,

         CAST("" AS CHAR(64)) AS PARTITION_NAME,

         CAST("" AS CHAR(64)) AS SUBPARTITION_NAME,

         CAST(NULL AS CHAR(4096)) AS HIGH_VALUE,

         CAST(NULL AS SIGNED) AS HIGH_VALUE_LENGTH,

         CAST(NULL AS UNSIGNED) AS PARTITION_POSITION,

         CAST(NULL AS UNSIGNED) AS SUBPARTITION_POSITION

   FROM
        DUAL
   WHERE
        0 = 1
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_OB_DATABASES',
  table_id        = '21180',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  SELECT D.DATABASE_NAME AS DATABASE_NAME,
         (CASE D.IN_RECYCLEBIN WHEN 0 THEN 'NO' ELSE 'YES' END) AS IN_RECYCLEBIN,
         C.COLLATION AS COLLATION,
         (CASE D.READ_ONLY WHEN 0 THEN 'NO' ELSE 'YES' END) AS READ_ONLY,
         D.COMMENT AS COMMENT
  FROM OCEANBASE.__ALL_DATABASE AS D
  LEFT JOIN OCEANBASE.__TENANT_VIRTUAL_COLLATION AS C
  ON D.COLLATION_TYPE = C.COLLATION_TYPE
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_OB_DATABASES',
  table_id        = '21181',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT D.TENANT_ID,
         D.DATABASE_NAME AS DATABASE_NAME,
         (CASE D.IN_RECYCLEBIN WHEN 0 THEN 'NO' ELSE 'YES' END) AS IN_RECYCLEBIN,
         C.COLLATION AS COLLATION,
         (CASE D.READ_ONLY WHEN 0 THEN 'NO' ELSE 'YES' END) AS READ_ONLY,
         D.COMMENT AS COMMENT
  FROM OCEANBASE.__ALL_VIRTUAL_DATABASE AS D
  LEFT JOIN OCEANBASE.__TENANT_VIRTUAL_COLLATION AS C
  ON D.COLLATION_TYPE = C.COLLATION_TYPE
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_OB_TABLEGROUP_TABLES',
  table_id        = '21182',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  SELECT TG.TABLEGROUP_NAME AS TABLEGROUP_NAME,
         D.DATABASE_NAME AS OWNER,
         T.TABLE_NAME AS TABLE_NAME,
         TG.SHARDING AS SHARDING
  FROM OCEANBASE.__ALL_TABLE AS T
  JOIN OCEANBASE.__ALL_DATABASE AS D
  ON T.TENANT_ID = D.TENANT_ID AND T.DATABASE_ID = D.DATABASE_ID
  JOIN OCEANBASE.__ALL_TABLEGROUP AS TG
  ON T.TENANT_ID = TG.TENANT_ID AND T.TABLEGROUP_ID = TG.TABLEGROUP_ID
  WHERE T.TABLE_TYPE in (0, 3, 6)
  AND T.TABLE_MODE >> 12 & 15 in (0,1)
  AND T.INDEX_ATTRIBUTES_SET & 16 = 0
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_OB_TABLEGROUP_TABLES',
  table_id        = '21183',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT T.TENANT_ID AS TENANT_ID,
         TG.TABLEGROUP_NAME AS TABLEGROUP_NAME,
         D.DATABASE_NAME AS OWNER,
         T.TABLE_NAME AS TABLE_NAME,
         TG.SHARDING AS SHARDING
  FROM OCEANBASE.__ALL_VIRTUAL_TABLE AS T
  JOIN OCEANBASE.__ALL_VIRTUAL_DATABASE AS D
  ON T.TENANT_ID = D.TENANT_ID AND T.DATABASE_ID = D.DATABASE_ID
  JOIN OCEANBASE.__ALL_VIRTUAL_TABLEGROUP AS TG
  ON T.TENANT_ID = TG.TENANT_ID AND T.TABLEGROUP_ID = TG.TABLEGROUP_ID
  WHERE T.TABLE_TYPE in (0, 3, 6)
  AND T.TABLE_MODE >> 12 & 15 in (0,1)
  AND T.INDEX_ATTRIBUTES_SET & 16 = 0
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'donglou.zl',
  table_name      = 'DBA_OB_ZONE_MAJOR_COMPACTION',
  table_id        = '21184',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  SELECT ZONE,
         BROADCAST_SCN,
         LAST_MERGED_SCN AS LAST_SCN,
         USEC_TO_TIME(LAST_MERGED_TIME) AS LAST_FINISH_TIME,
         USEC_TO_TIME(MERGE_START_TIME) AS START_TIME,
         (CASE MERGE_STATUS
                WHEN 0 THEN 'IDLE'
                WHEN 1 THEN 'COMPACTING'
                ELSE 'UNKNOWN' END) AS STATUS
  FROM OCEANBASE.__ALL_VIRTUAL_ZONE_MERGE_INFO
  WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'donglou.zl',
  table_name      = 'CDB_OB_ZONE_MAJOR_COMPACTION',
  table_id        = '21185',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT TENANT_ID,
         ZONE,
         BROADCAST_SCN,
         LAST_MERGED_SCN AS LAST_SCN,
         USEC_TO_TIME(LAST_MERGED_TIME) AS LAST_FINISH_TIME,
         USEC_TO_TIME(MERGE_START_TIME) AS START_TIME,
         (CASE MERGE_STATUS
                WHEN 0 THEN 'IDLE'
                WHEN 1 THEN 'COMPACTING'
                ELSE 'UNKNOWN' END) AS STATUS
  FROM OCEANBASE.__ALL_VIRTUAL_ZONE_MERGE_INFO
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'donglou.zl',
  table_name      = 'DBA_OB_MAJOR_COMPACTION',
  table_id        = '21186',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  SELECT FROZEN_SCN,
         USEC_TO_TIME(FROZEN_SCN/1000) AS FROZEN_TIME,
         GLOBAL_BROADCAST_SCN,
         LAST_MERGED_SCN AS LAST_SCN,
         USEC_TO_TIME(LAST_MERGED_TIME) AS LAST_FINISH_TIME,
         USEC_TO_TIME(MERGE_START_TIME) AS START_TIME,
         (CASE MERGE_STATUS
                WHEN 0 THEN 'IDLE'
                WHEN 1 THEN 'COMPACTING'
                WHEN 2 THEN 'VERIFYING'
                ELSE 'UNKNOWN' END) AS STATUS,
         (CASE IS_MERGE_ERROR WHEN 0 THEN 'NO' ELSE 'YES' END) AS IS_ERROR,
         (CASE SUSPEND_MERGING WHEN 0 THEN 'NO' ELSE 'YES' END) AS IS_SUSPENDED,
         (CASE ERROR_TYPE
                WHEN 0 THEN ''
                WHEN 1 THEN 'CHECKSUM_ERROR'
                ELSE 'UNKNOWN' END) AS INFO
  FROM OCEANBASE.__ALL_VIRTUAL_MERGE_INFO
  WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'donglou.zl',
  table_name      = 'CDB_OB_MAJOR_COMPACTION',
  table_id        = '21187',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT TENANT_ID,
         FROZEN_SCN,
         USEC_TO_TIME(FROZEN_SCN/1000) AS FROZEN_TIME,
         GLOBAL_BROADCAST_SCN,
         LAST_MERGED_SCN AS LAST_SCN,
         USEC_TO_TIME(LAST_MERGED_TIME) AS LAST_FINISH_TIME,
         USEC_TO_TIME(MERGE_START_TIME) AS START_TIME,
         (CASE MERGE_STATUS
                WHEN 0 THEN 'IDLE'
                WHEN 1 THEN 'COMPACTING'
                WHEN 2 THEN 'VERIFYING'
                ELSE 'UNKNOWN' END) AS STATUS,
         (CASE IS_MERGE_ERROR WHEN 0 THEN 'NO' ELSE 'YES' END) AS IS_ERROR,
         (CASE SUSPEND_MERGING WHEN 0 THEN 'NO' ELSE 'YES' END) AS IS_SUSPENDED,
         (CASE ERROR_TYPE
                WHEN 0 THEN ''
                WHEN 1 THEN 'CHECKSUM_ERROR'
                ELSE 'UNKNOWN' END) AS INFO
  FROM OCEANBASE.__ALL_VIRTUAL_MERGE_INFO
  """.replace("\n", " "),
)

# TODO:(yanmu.ztl)
# tablespace/constraint is not supported yet.
def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_OBJECTS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21188',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
        SELECT
      CAST(A.TENANT_ID AS SIGNED) AS CON_ID,
      CAST(B.DATABASE_NAME AS CHAR(128)) AS OWNER,
      CAST(A.OBJECT_NAME AS CHAR(128)) AS OBJECT_NAME,
      CAST(A.SUBOBJECT_NAME AS CHAR(128)) AS SUBOBJECT_NAME,
      CAST(A.OBJECT_ID AS SIGNED) AS OBJECT_ID,
      CAST(A.DATA_OBJECT_ID AS SIGNED) AS DATA_OBJECT_ID,
      CAST(A.OBJECT_TYPE AS CHAR(23)) AS OBJECT_TYPE,
      CAST(A.GMT_CREATE AS DATETIME) AS CREATED,
      CAST(A.GMT_MODIFIED AS DATETIME) AS LAST_DDL_TIME,
      CAST(A.GMT_CREATE AS DATETIME) AS TIMESTAMP,
      CAST(A.STATUS AS CHAR(7)) AS STATUS,
      CAST(A.TEMPORARY AS CHAR(1)) AS TEMPORARY,
      CAST(A.`GENERATED` AS CHAR(1)) AS "GENERATED",
      CAST(A.SECONDARY AS CHAR(1)) AS SECONDARY,
      CAST(A.NAMESPACE AS SIGNED) AS NAMESPACE,
      CAST(A.EDITION_NAME AS CHAR(128)) AS EDITION_NAME,
      CAST(NULL AS CHAR(18)) AS SHARING,
      CAST(NULL AS CHAR(1)) AS EDITIONABLE,
      CAST(NULL AS CHAR(1)) AS ORACLE_MAINTAINED,
      CAST(NULL AS CHAR(1)) AS APPLICATION,
      CAST(NULL AS CHAR(1)) AS DEFAULT_COLLATION,
      CAST(NULL AS CHAR(1)) AS DUPLICATED,
      CAST(NULL AS CHAR(1)) AS SHARDED,
      CAST(NULL AS CHAR(1)) AS IMPORTED_OBJECT,
      CAST(NULL AS SIGNED) AS CREATED_APPID,
      CAST(NULL AS SIGNED) AS CREATED_VSNID,
      CAST(NULL AS SIGNED) AS MODIFIED_APPID,
      CAST(NULL AS SIGNED) AS MODIFIED_VSNID
    FROM (

      SELECT A.TENANT_ID,
             USEC_TO_TIME(B.SCHEMA_VERSION) AS GMT_CREATE,
             USEC_TO_TIME(A.SCHEMA_VERSION) AS GMT_MODIFIED,
             A.DATABASE_ID,
             A.TABLE_NAME AS OBJECT_NAME,
             NULL AS SUBOBJECT_NAME,
             CAST(A.TABLE_ID AS SIGNED) AS OBJECT_ID,
             A.TABLET_ID AS DATA_OBJECT_ID,
             'TABLE' AS OBJECT_TYPE,
             'VALID' AS STATUS,
             'N' AS TEMPORARY,
             'N' AS "GENERATED",
             'N' AS SECONDARY,
             0 AS NAMESPACE,
             NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE A
      JOIN OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE B
        ON A.TENANT_ID = B.TENANT_ID AND B.TABLE_NAME = '__all_core_table'

      UNION ALL

      SELECT
      TENANT_ID
      ,GMT_CREATE
      ,GMT_MODIFIED
      ,DATABASE_ID
      ,CAST((CASE
             WHEN DATABASE_ID = 201004 THEN TABLE_NAME
             WHEN TABLE_TYPE = 5 THEN SUBSTR(TABLE_NAME, 7 + POSITION('_' IN SUBSTR(TABLE_NAME, 7)))
             ELSE TABLE_NAME END) AS CHAR(128)) AS OBJECT_NAME
      ,NULL SUBOBJECT_NAME
      ,TABLE_ID OBJECT_ID
      ,(CASE WHEN TABLET_ID != 0 THEN TABLET_ID ELSE NULL END) DATA_OBJECT_ID
      ,CASE WHEN TABLE_TYPE IN (0,3,6,8,9,14) THEN 'TABLE'
            WHEN TABLE_TYPE IN (2) THEN 'VIRTUAL TABLE'
            WHEN TABLE_TYPE IN (1,4) THEN 'VIEW'
            WHEN TABLE_TYPE IN (5) THEN 'INDEX'
            WHEN TABLE_TYPE IN (7) THEN 'MATERIALIZED VIEW'
            WHEN TABLE_TYPE IN (15) THEN 'MATERIALIZED VIEW LOG'
            ELSE NULL END AS OBJECT_TYPE
      ,CAST(CASE WHEN TABLE_TYPE IN (5,15) THEN CASE WHEN INDEX_STATUS = 2 THEN 'VALID'
              WHEN INDEX_STATUS = 3 THEN 'CHECKING'
              WHEN INDEX_STATUS = 4 THEN 'INELEGIBLE'
              WHEN INDEX_STATUS = 5 THEN 'ERROR'
              ELSE 'UNUSABLE' END
            ELSE  CASE WHEN OBJECT_STATUS = 1 THEN 'VALID' ELSE 'INVALID' END END AS CHAR(10)) AS STATUS
      ,CASE WHEN TABLE_TYPE IN (6,8,9) THEN 'Y'
          ELSE 'N' END AS TEMPORARY
      ,CASE WHEN TABLE_TYPE IN (0,1) THEN 'Y'
          ELSE 'N' END AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM
      OCEANBASE.__ALL_VIRTUAL_TABLE
      WHERE TABLE_TYPE != 12 AND TABLE_TYPE != 13
      AND TABLE_MODE >> 12 & 15 in (0,1)
      AND INDEX_ATTRIBUTES_SET & 16 = 0

      UNION ALL

      SELECT
         CST.TENANT_ID
         ,CST.GMT_CREATE
         ,CST.GMT_MODIFIED
         ,DB.DATABASE_ID
         ,CST.constraint_name AS OBJECT_NAME
         ,NULL AS SUBOBJECT_NAME
         ,TBL.TABLE_ID AS OBJECT_ID
         ,NULL AS DATA_OBJECT_ID
         ,'INDEX' AS OBJECT_TYPE
         ,'VALID' AS STATUS
         ,'N' AS TEMPORARY
         ,'N' AS "GENERATED"
         ,'N' AS SECONDARY
         ,0 AS NAMESPACE
         ,NULL AS EDITION_NAME
         FROM OCEANBASE.__ALL_VIRTUAL_CONSTRAINT CST, OCEANBASE.__ALL_VIRTUAL_TABLE TBL, OCEANBASE.__ALL_VIRTUAL_DATABASE DB
         WHERE CST.TENANT_ID = TBL.TENANT_ID AND TBL.TENANT_ID = DB.TENANT_ID AND DB.DATABASE_ID = TBL.DATABASE_ID AND TBL.TABLE_ID = CST.TABLE_ID and CST.CONSTRAINT_TYPE = 1
         AND TBL.TABLE_MODE >> 12 & 15 in (0,1)
         AND TBL.INDEX_ATTRIBUTES_SET & 16 = 0

      UNION ALL

      SELECT
      P.TENANT_ID
      ,P.GMT_CREATE
      ,P.GMT_MODIFIED
      ,T.DATABASE_ID
      ,CAST((CASE
             WHEN T.DATABASE_ID = 201004 THEN T.TABLE_NAME
             WHEN T.TABLE_TYPE = 5 THEN SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7)))
             ELSE T.TABLE_NAME END) AS CHAR(128)) AS OBJECT_NAME
      ,P.PART_NAME SUBOBJECT_NAME
      ,P.PART_ID OBJECT_ID
      ,CASE WHEN P.TABLET_ID != 0 THEN P.TABLET_ID ELSE NULL END AS DATA_OBJECT_ID
      ,(CASE WHEN T.TABLE_TYPE = 5 THEN 'INDEX PARTITION' ELSE 'TABLE PARTITION' END) AS OBJECT_TYPE
      ,'VALID' AS STATUS
      ,'N' AS TEMPORARY
      , NULL AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_TABLE T JOIN OCEANBASE.__ALL_VIRTUAL_PART P ON T.TABLE_ID = P.TABLE_ID
      WHERE T.TENANT_ID = P.TENANT_ID AND T.TABLE_MODE >> 12 & 15 in (0,1) AND P.PARTITION_TYPE = 0
            AND T.INDEX_ATTRIBUTES_SET & 16 = 0

      UNION ALL

      SELECT
      SUBP.TENANT_ID
      ,SUBP.GMT_CREATE
      ,SUBP.GMT_MODIFIED
      ,T.DATABASE_ID
      ,CAST((CASE
             WHEN T.DATABASE_ID = 201004 THEN T.TABLE_NAME
             WHEN T.TABLE_TYPE = 5 THEN SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7)))
             ELSE T.TABLE_NAME END) AS CHAR(128)) AS OBJECT_NAME
      ,SUBP.SUB_PART_NAME SUBOBJECT_NAME
      ,SUBP.SUB_PART_ID OBJECT_ID
      ,SUBP.TABLET_ID AS DATA_OBJECT_ID
      ,(CASE WHEN T.TABLE_TYPE = 5 THEN 'INDEX SUBPARTITION' ELSE 'TABLE SUBPARTITION' END) AS OBJECT_TYPE
      ,'VALID' AS STATUS
      ,'N' AS TEMPORARY
      ,'Y' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_TABLE T, OCEANBASE.__ALL_VIRTUAL_PART P,OCEANBASE.__ALL_VIRTUAL_SUB_PART SUBP
      WHERE T.TABLE_ID =P.TABLE_ID AND P.TABLE_ID=SUBP.TABLE_ID AND P.PART_ID =SUBP.PART_ID
      AND T.TENANT_ID = P.TENANT_ID AND P.TENANT_ID = SUBP.TENANT_ID AND T.TABLE_MODE >> 12 & 15 in (0,1)
      AND P.PARTITION_TYPE = 0
      AND SUBP.PARTITION_TYPE = 0
      AND T.INDEX_ATTRIBUTES_SET & 16 = 0

      UNION ALL

      SELECT
      P.TENANT_ID
      ,P.GMT_CREATE
      ,P.GMT_MODIFIED
      ,P.DATABASE_ID
      ,P.PACKAGE_NAME AS OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,P.PACKAGE_ID OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,CASE WHEN TYPE = 1 THEN 'PACKAGE'
            WHEN TYPE = 2 THEN 'PACKAGE BODY'
            ELSE NULL END AS OBJECT_TYPE
      ,CASE WHEN EXISTS
                  (SELECT OBJ_ID FROM OCEANBASE.__ALL_VIRTUAL_ERROR E
                    WHERE P.TENANT_ID = E.TENANT_ID AND P.PACKAGE_ID = E.OBJ_ID AND (E.OBJ_TYPE = 3 OR E.OBJ_TYPE = 5))
                 THEN 'INVALID'
            WHEN TYPE = 2 AND EXISTS
                  (SELECT OBJ_ID FROM OCEANBASE.__ALL_VIRTUAL_ERROR Eb
                    WHERE OBJ_ID IN
                            (SELECT PACKAGE_ID FROM OCEANBASE.__ALL_VIRTUAL_PACKAGE Pb
                              WHERE Pb.PACKAGE_NAME = P.PACKAGE_NAME AND Pb.DATABASE_ID = P.DATABASE_ID AND Pb.TENANT_ID = P.TENANT_ID AND TYPE = 1)
                          AND Eb.OBJ_TYPE = 3)
              THEN 'INVALID'
            ELSE 'VALID' END AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_PACKAGE P

      UNION ALL

      SELECT
      R.TENANT_ID
      ,R.GMT_CREATE
      ,R.GMT_MODIFIED
      ,R.DATABASE_ID
      ,R.ROUTINE_NAME AS OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,R.ROUTINE_ID OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,CASE WHEN ROUTINE_TYPE = 1 THEN 'PROCEDURE'
            WHEN ROUTINE_TYPE = 2 THEN 'FUNCTION'
            ELSE NULL END AS OBJECT_TYPE
      ,CASE WHEN EXISTS
                  (SELECT OBJ_ID FROM OCEANBASE.__ALL_VIRTUAL_ERROR E
                    WHERE R.TENANT_ID = E.TENANT_ID AND R.ROUTINE_ID = E.OBJ_ID AND (E.OBJ_TYPE = 9 OR E.OBJ_TYPE = 12))
                 THEN 'INVALID'
            ELSE 'VALID' END AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_ROUTINE R
      WHERE (ROUTINE_TYPE = 1 OR ROUTINE_TYPE = 2)

      UNION ALL

      SELECT
      TENANT_ID
      ,GMT_CREATE
      ,GMT_MODIFIED
      ,DATABASE_ID
      ,TYPE_NAME AS OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,TYPE_ID OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,'TYPE' AS OBJECT_TYPE
      ,'VALID' AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_TYPE

      UNION ALL

      SELECT
      TENANT_ID
      ,GMT_CREATE
      ,GMT_MODIFIED
      ,DATABASE_ID
      ,OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,OBJECT_TYPE_ID OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,'TYPE BODY' AS OBJECT_TYPE
      ,'VALID' AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_OBJECT_TYPE
      WHERE TYPE = 2

      UNION ALL

      SELECT
      T.TENANT_ID
      ,T.GMT_CREATE
      ,T.GMT_MODIFIED
      ,T.DATABASE_ID
      ,T.TRIGGER_NAME AS OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,T.TRIGGER_ID OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,'TRIGGER' OBJECT_TYPE
      ,CASE WHEN EXISTS
                  (SELECT OBJ_ID FROM OCEANBASE.__ALL_VIRTUAL_ERROR E
                    WHERE T.TENANT_ID = E.TENANT_ID AND T.TRIGGER_ID = E.OBJ_ID AND (E.OBJ_TYPE = 7))
                 THEN 'INVALID'
            ELSE 'VALID' END AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_TRIGGER T

      UNION ALL

      SELECT
      TENANT_ID
      ,GMT_CREATE
      ,GMT_MODIFIED
      ,DATABASE_ID
      ,SEQUENCE_NAME AS OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,SEQUENCE_ID OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,'SEQUENCE' AS OBJECT_TYPE
      ,'VALID' AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_SEQUENCE_OBJECT

      UNION ALL

      SELECT
      TENANT_ID
      ,GMT_CREATE
      ,GMT_MODIFIED
      ,DATABASE_ID
      ,SYNONYM_NAME AS OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,SYNONYM_ID OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,'SYNONYM' AS OBJECT_TYPE
      ,'VALID' AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_SYNONYM

      UNION ALL

      SELECT
        TENANT_ID
        ,GMT_CREATE
        ,GMT_MODIFIED
        ,CAST(201006 AS SIGNED) AS DATABASE_ID
        ,NAMESPACE AS OBJECT_NAME
        ,NULL AS SUBOBJECT_NAME
        ,CONTEXT_ID OBJECT_ID
        ,NULL AS DATA_OBJECT_ID
        ,'CONTEXT' AS OBJECT_TYPE
        ,'VALID' AS STATUS
        ,'N' AS TEMPORARY
        ,'N' AS "GENERATED"
        ,'N' AS SECONDARY
        ,21 AS NAMESPACE
        ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_TENANT_CONTEXT


      UNION ALL

      SELECT
        TENANT_ID,
        GMT_CREATE,
        GMT_MODIFIED,
        DATABASE_ID,
        DATABASE_NAME AS OBJECT_NAME,
        NULL AS SUBOBJECT_NAME,
        DATABASE_ID AS OBJECT_ID,
        NULL AS DATA_OBJECT_ID,
        'DATABASE' AS OBJECT_TYPE,
        'VALID' AS STATUS,
        'N' AS TEMPORARY,
        'N' AS "GENERATED",
        'N' AS SECONDARY,
        0 AS NAMESPACE,
        NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_DATABASE

      UNION ALL

      SELECT
        TENANT_ID,
        GMT_CREATE,
        GMT_MODIFIED,
        CAST(201001 AS SIGNED) AS DATABASE_ID,
        TABLEGROUP_NAME AS OBJECT_NAME,
        NULL AS SUBOBJECT_NAME,
        TABLEGROUP_ID AS OBJECT_ID,
        NULL AS DATA_OBJECT_ID,
        'TABLEGROUP' AS OBJECT_TYPE,
        'VALID' AS STATUS,
        'N' AS TEMPORARY,
        'N' AS "GENERATED",
        'N' AS SECONDARY,
        0 AS NAMESPACE,
        NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_TABLEGROUP
    ) A
    JOIN OCEANBASE.__ALL_VIRTUAL_DATABASE B
    ON A.TENANT_ID = B.TENANT_ID
    AND A.DATABASE_ID = B.DATABASE_ID
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_TABLES',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21189',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
SELECT
  CAST(DB.TENANT_ID AS SIGNED) AS CON_ID,
  CAST(DB.DATABASE_NAME AS CHAR(128)) AS OWNER,
  CAST(T.TABLE_NAME AS CHAR(128)) AS TABLE_NAME,
  CAST(TP.TABLESPACE_NAME AS CHAR(30)) AS TABLESPACE_NAME,
  CAST(NULL AS CHAR(128)) AS CLUSTER_NAME,
  CAST(NULL AS CHAR(128)) AS IOT_NAME,
  CAST('VALID' AS CHAR(8)) AS STATUS,
  CAST(T.PCTFREE AS SIGNED) AS PCT_FREE,
  CAST(NULL AS SIGNED) AS PCT_USED,
  CAST(NULL AS SIGNED) AS INI_TRANS,
  CAST(NULL AS SIGNED) AS MAX_TRANS,
  CAST(NULL AS SIGNED) AS INITIAL_EXTENT,
  CAST(NULL AS SIGNED) AS NEXT_EXTENT,
  CAST(NULL AS SIGNED) AS MIN_EXTENTS,
  CAST(NULL AS SIGNED) AS MAX_EXTENTS,
  CAST(NULL AS SIGNED) AS PCT_INCREASE,
  CAST(NULL AS SIGNED) AS FREELISTS,
  CAST(NULL AS SIGNED) AS FREELIST_GROUPS,
  CAST(NULL AS CHAR(3)) AS LOGGING,
  CAST(NULL AS CHAR(1)) AS BACKED_UP,
  CAST(INFO.ROW_COUNT AS SIGNED) AS NUM_ROWS,
  CAST(NULL AS SIGNED) AS BLOCKS,
  CAST(NULL AS SIGNED) AS EMPTY_BLOCKS,
  CAST(NULL AS SIGNED) AS AVG_SPACE,
  CAST(NULL AS SIGNED) AS CHAIN_CNT,
  CAST(NULL AS SIGNED) AS AVG_ROW_LEN,
  CAST(NULL AS SIGNED) AS AVG_SPACE_FREELIST_BLOCKS,
  CAST(NULL AS SIGNED) AS NUM_FREELIST_BLOCKS,
  CAST(NULL AS CHAR(10)) AS DEGREE,
  CAST(NULL AS CHAR(10)) AS INSTANCES,
  CAST(NULL AS CHAR(5)) AS CACHE,
  CAST(NULL AS CHAR(8)) AS TABLE_LOCK,
  CAST(NULL AS SIGNED) AS SAMPLE_SIZE,
  CAST(NULL AS DATE) AS LAST_ANALYZED,
  CAST(
  CASE
    WHEN
      T.PART_LEVEL = 0
    THEN
      'NO'
    ELSE
      'YES'
  END
  AS CHAR(3)) AS PARTITIONED,
  CAST(CASE
    WHEN
      T.TABLE_MODE >> 30 = 0
    THEN
      'IOT'
    ELSE
      NULL
  END
  AS CHAR(12)) AS IOT_TYPE,
  CAST(CASE WHEN T.TABLE_TYPE IN (6, 8, 9) THEN 'Y' ELSE 'N' END AS CHAR(1)) AS TEMPORARY,
  CAST(NULL AS CHAR(1)) AS SECONDARY,
  CAST('NO' AS CHAR(3)) AS NESTED,
  CAST(NULL AS CHAR(7)) AS BUFFER_POOL,
  CAST(NULL AS CHAR(7)) AS FLASH_CACHE,
  CAST(NULL AS CHAR(7)) AS CELL_FLASH_CACHE,
  CAST(NULL AS CHAR(8)) AS ROW_MOVEMENT,
  CAST(NULL AS CHAR(3)) AS GLOBAL_STATS,
  CAST(NULL AS CHAR(3)) AS USER_STATS,
  CAST(CASE WHEN T.TABLE_TYPE IN (6, 8) THEN 'SYS$SESSION'
            WHEN T.TABLE_TYPE IN (9) THEN 'SYS$TRANSACTION'
            ELSE NULL END AS CHAR(15)) AS DURATION,
  CAST(NULL AS CHAR(8)) AS SKIP_CORRUPT,
  CAST(NULL AS CHAR(3)) AS MONITORING,
  CAST(NULL AS CHAR(128)) AS CLUSTER_OWNER,
  CAST(NULL AS CHAR(8)) AS DEPENDENCIES,
  CAST(NULL AS CHAR(8)) AS COMPRESSION,
  CAST(NULL AS CHAR(30)) AS COMPRESS_FOR,
  CAST(CASE WHEN DB.IN_RECYCLEBIN = 1 THEN 'YES' ELSE 'NO' END AS CHAR(3)) AS DROPPED,
  CAST(NULL AS CHAR(3)) AS READ_ONLY,
  CAST(NULL AS CHAR(3)) AS SEGMENT_CREATED,
  CAST(NULL AS CHAR(7)) AS RESULT_CACHE,
  CAST(NULL AS CHAR(3)) AS CLUSTERING,
  CAST(NULL AS CHAR(23)) AS ACTIVITY_TRACKING,
  CAST(NULL AS CHAR(25)) AS DML_TIMESTAMP,
  CAST(NULL AS CHAR(3)) AS HAS_IDENTITY,
  CAST(NULL AS CHAR(3)) AS CONTAINER_DATA,
  CAST(NULL AS CHAR(8)) AS INMEMORY,
  CAST(NULL AS CHAR(8)) AS INMEMORY_PRIORITY,
  CAST(NULL AS CHAR(15)) AS INMEMORY_DISTRIBUTE,
  CAST(NULL AS CHAR(17)) AS INMEMORY_COMPRESSION,
  CAST(NULL AS CHAR(13)) AS INMEMORY_DUPLICATE,
  CAST(NULL AS CHAR(100)) AS DEFAULT_COLLATION,
  CAST(NULL AS CHAR(1)) AS DUPLICATED,
  CAST(NULL AS CHAR(1)) AS SHARDED,
  CAST(NULL AS CHAR(1)) AS EXTERNALLY_SHARDED,
  CAST(NULL AS CHAR(1)) AS EXTERNALLY_DUPLICATED,
  CAST(CASE WHEN T.TABLE_TYPE IN (14) THEN 'YES' ELSE 'NO' END AS CHAR(3)) AS EXTERNAL,
  CAST(NULL AS CHAR(3)) AS HYBRID,
  CAST(NULL AS CHAR(24)) AS CELLMEMORY,
  CAST(NULL AS CHAR(3)) AS CONTAINERS_DEFAULT,
  CAST(NULL AS CHAR(3)) AS CONTAINER_MAP,
  CAST(NULL AS CHAR(3)) AS EXTENDED_DATA_LINK,
  CAST(NULL AS CHAR(3)) AS EXTENDED_DATA_LINK_MAP,
  CAST(NULL AS CHAR(12)) AS INMEMORY_SERVICE,
  CAST(NULL AS CHAR(1000)) AS INMEMORY_SERVICE_NAME,
  CAST(NULL AS CHAR(3)) AS CONTAINER_MAP_OBJECT,
  CAST(NULL AS CHAR(8)) AS MEMOPTIMIZE_READ,
  CAST(NULL AS CHAR(8)) AS MEMOPTIMIZE_WRITE,
  CAST(NULL AS CHAR(3)) AS HAS_SENSITIVE_COLUMN,
  CAST(NULL AS CHAR(3)) AS ADMIT_NULL,
  CAST(NULL AS CHAR(3)) AS DATA_LINK_DML_ENABLED,
  CAST(NULL AS CHAR(8)) AS LOGICAL_REPLICATION,
  CAST(CASE WHEN T.AUTO_PART = 1 THEN 'TRUE' ELSE 'FALSE' END AS CHAR(16)) AS AUTO_SPLIT,
  CAST(CASE WHEN T.AUTO_PART = 1 THEN T.AUTO_PART_SIZE ELSE 0 END AS SIGNED) AS AUTO_SPLIT_TABLET_SIZE
FROM
  (SELECT
     TENANT_ID,
     TABLE_ID,
     ROW_CNT AS ROW_COUNT
   FROM
     OCEANBASE.__ALL_VIRTUAL_TABLE_STAT TS
   WHERE
    PARTITION_ID = -1 OR PARTITION_ID = TABLE_ID
  ) INFO

  RIGHT JOIN
  (SELECT
     TENANT_ID,
     TABLE_ID,
     TABLE_NAME,
     DATABASE_ID,
     PCTFREE,
     PART_LEVEL,
     TABLE_TYPE,
     TABLESPACE_ID,
     AUTO_PART,
     AUTO_PART_SIZE,
     TABLE_MODE
   FROM
     OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE

   UNION ALL

   SELECT
     TENANT_ID,
     TABLE_ID,
     TABLE_NAME,
     DATABASE_ID,
     PCTFREE,
     PART_LEVEL,
     TABLE_TYPE,
     TABLESPACE_ID,
     AUTO_PART,
     AUTO_PART_SIZE,
     TABLE_MODE
   FROM OCEANBASE.__ALL_VIRTUAL_TABLE
   WHERE TABLE_MODE >> 12 & 15 in (0,1) AND INDEX_ATTRIBUTES_SET & 16 = 0) T
  ON
    T.TENANT_ID = INFO.TENANT_ID
    AND T.TABLE_ID = INFO.TABLE_ID

  JOIN
    OCEANBASE.__ALL_VIRTUAL_DATABASE DB
  ON
    DB.TENANT_ID = T.TENANT_ID
    AND DB.DATABASE_ID = T.DATABASE_ID
    AND T.TABLE_TYPE IN (0, 3, 6, 8, 9, 14, 15)
    AND DB.DATABASE_NAME != '__recyclebin'

  LEFT JOIN
    OCEANBASE.__ALL_VIRTUAL_TENANT_TABLESPACE TP
  ON
    TP.TABLESPACE_ID = T.TABLESPACE_ID
    AND T.TENANT_ID = TP.TENANT_ID
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_TAB_COLS_V$',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21190',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
SELECT/*+leading(DB,TC,STAT)*/
  CAST(DB.TENANT_ID AS SIGNED) AS CON_ID,
  CAST(DB.DATABASE_NAME AS CHAR(128)) AS OWNER,
  CAST(TC.TABLE_NAME AS CHAR(128)) AS  TABLE_NAME,
  CAST(TC.COLUMN_NAME AS CHAR(128)) AS  COLUMN_NAME,
  CAST(CASE TC.DATA_TYPE
        WHEN 0 THEN 'VARCHAR2'

        WHEN 1 THEN 'NUMBER'
        WHEN 2 THEN 'NUMBER'
        WHEN 3 THEN 'NUMBER'
        WHEN 4 THEN 'NUMBER'
        WHEN 5 THEN 'NUMBER'

        WHEN 6 THEN 'NUMBER'
        WHEN 7 THEN 'NUMBER'
        WHEN 8 THEN 'NUMBER'
        WHEN 9 THEN 'NUMBER'
        WHEN 10 THEN 'NUMBER'

        WHEN 11 THEN 'BINARY_FLOAT'
        WHEN 12 THEN 'BINARY_DOUBLE'

        WHEN 13 THEN 'NUMBER'
        WHEN 14 THEN 'NUMBER'

        WHEN 15 THEN 'NUMBER'
        WHEN 16 THEN 'NUMBER'

        WHEN 17 THEN 'DATE'
        WHEN 18 THEN 'TIMESTAMP'
        WHEN 19 THEN 'DATE'
        WHEN 20 THEN 'TIME'
        WHEN 21 THEN 'YEAR'

        WHEN 22 THEN 'VARCHAR2'
        WHEN 23 THEN 'CHAR'
        WHEN 24 THEN 'HEX_STRING'

        WHEN 25 THEN 'UNDEFINED'
        WHEN 26 THEN 'UNKNOWN'

        WHEN 27 THEN 'TINYTEXT'
        WHEN 28 THEN 'TEXT'
        WHEN 29 THEN (CASE WHEN TC.COLUMN_FLAGS & (1<<29) > 0 THEN 'STRING' ELSE 'MEDIUMTEXT' END)
        WHEN 30 THEN (CASE TC.COLLATION_TYPE WHEN 63 THEN 'BLOB' ELSE 'CLOB' END)
        WHEN 31 THEN 'BIT'
        WHEN 32 THEN 'ENUM'
        WHEN 33 THEN 'SET'
        WHEN 34 THEN 'ENUM_INNER'
        WHEN 35 THEN 'SET_INNER'
        WHEN 36 THEN CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ') WITH TIME ZONE'))
        WHEN 37 THEN CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ') WITH LOCAL TIME ZONE'))
        WHEN 38 THEN CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ')'))
        WHEN 39 THEN 'RAW'
        WHEN 40 THEN CONCAT('INTERVAL YEAR(', CONCAT(TC.DATA_SCALE, ') TO MONTH'))
        WHEN 41 THEN CONCAT('INTERVAL DAY(', CONCAT(FLOOR(TC.DATA_SCALE/10), CONCAT(') TO SECOND(', CONCAT(MOD(TC.DATA_SCALE, 10), ')'))))
        WHEN 42 THEN 'FLOAT'
        WHEN 43 THEN 'NVARCHAR2'
        WHEN 44 THEN 'NCHAR'
        WHEN 45 THEN 'UROWID'
        WHEN 46 THEN (CASE TC.COLLATION_TYPE WHEN 63 THEN 'BLOB' ELSE 'CLOB' END)
        WHEN 47 THEN 'JSON'
        WHEN 50 THEN 'NUMBER'
        WHEN 52 THEN 'MYSQL_DATE'
        WHEN 53 THEN 'MYSQL_DATETIME'
        WHEN 54 THEN 'ROARINGBITMAP'
        ELSE 'UNDEFINED' END AS CHAR(128)) AS  DATA_TYPE,
  CAST(NULL AS CHAR(3)) AS  DATA_TYPE_MOD,
  CAST(NULL AS CHAR(128)) AS  DATA_TYPE_OWNER,
  CAST(TC.DATA_LENGTH * CASE WHEN TC.DATA_TYPE IN (22,23,30,43,44,46) AND TC.DATA_PRECISION = 1
                            THEN (CASE TC.COLLATION_TYPE
                                  WHEN 63  THEN 1
                                  WHEN 249 THEN 4
                                  WHEN 248 THEN 4
                                  WHEN 87  THEN 2
                                  WHEN 28  THEN 2
                                  WHEN 55  THEN 4
                                  WHEN 54  THEN 4
                                  WHEN 101 THEN 2
                                  WHEN 46  THEN 4
                                  WHEN 45  THEN 4
                                  WHEN 224 THEN 4
                                  ELSE 1 END)
                            ELSE 1 END
                            AS SIGNED) AS  DATA_LENGTH,
  CAST(CASE WHEN TC.DATA_TYPE IN (0,11,12,17,18,19,22,23,27,28,29,30,36,37,38,43,44,52,53,54)
            THEN NULL
            ELSE CASE WHEN TC.DATA_PRECISION < 0 THEN NULL ELSE TC.DATA_PRECISION END
       END AS SIGNED) AS  DATA_PRECISION,
  CAST(CASE WHEN TC.DATA_TYPE IN (0,11,12,17,19,22,23,27,28,29,30,42,43,44,52,53,54)
            THEN NULL
            ELSE CASE WHEN TC.DATA_SCALE < -84 THEN NULL ELSE TC.DATA_SCALE END
       END AS SIGNED) AS  DATA_SCALE,
  CAST((CASE
        WHEN TC.NULLABLE = 0 THEN 'N'
        WHEN (TC.COLUMN_FLAGS & (5 * POWER(2, 13))) = 5 * POWER(2, 13) THEN 'N'
        ELSE 'Y' END) AS CHAR(1)) AS  NULLABLE,
  CAST(CASE WHEN (TC.COLUMN_FLAGS & 64) = 0 THEN TC.COLUMN_ID ELSE NULL END AS SIGNED) AS  COLUMN_ID,
  CAST(LENGTH(TC.CUR_DEFAULT_VALUE_V2) AS SIGNED) AS  DEFAULT_LENGTH,
  CAST(TC.CUR_DEFAULT_VALUE_V2 AS /* TODO: LONG() */ CHAR(262144)) AS  DATA_DEFAULT,
  CAST(STAT.DISTINCT_CNT AS SIGNED) AS  NUM_DISTINCT,
  CAST(STAT.MIN_VALUE AS /* TODO: RAW */ CHAR(128)) AS  LOW_VALUE,
  CAST(STAT.MAX_VALUE AS /* TODO: RAW */ CHAR(128)) AS  HIGH_VALUE,
  CAST(STAT.DENSITY AS SIGNED) AS  DENSITY,
  CAST(STAT.NULL_CNT AS SIGNED) AS  NUM_NULLS,
  CAST(STAT.BUCKET_CNT AS SIGNED) AS  NUM_BUCKETS,
  CAST(STAT.LAST_ANALYZED AS DATE) AS  LAST_ANALYZED,
  CAST(STAT.SAMPLE_SIZE AS SIGNED) AS  SAMPLE_SIZE,
  CAST(CASE TC.DATA_TYPE
       WHEN 22 THEN 'CHAR_CS'
       WHEN 23 THEN 'CHAR_CS'
       WHEN 30 THEN (CASE WHEN TC.COLLATION_TYPE = 63 THEN 'NULL' ELSE 'CHAR_CS' END)
       WHEN 43 THEN 'NCHAR_CS'
       WHEN 44 THEN 'NCHAR_CS'
       ELSE '' END AS CHAR(44)) AS  CHARACTER_SET_NAME,
  CAST(NULL AS SIGNED) AS  CHAR_COL_DECL_LENGTH,
  CAST(CASE STAT.GLOBAL_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END AS CHAR(3)) AS GLOBAL_STATS,
  CAST(CASE STAT.USER_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END AS CHAR(3)) AS USER_STATS,
  CAST(NULL AS CHAR(80)) AS  NOTES,
  CAST(STAT.AVG_LEN AS SIGNED) AS  AVG_COL_LEN,
  CAST(CASE WHEN TC.DATA_TYPE IN (22,23,43,44) THEN TC.DATA_LENGTH ELSE 0 END AS SIGNED) AS  CHAR_LENGTH,
  CAST(CASE TC.DATA_TYPE
       WHEN 22 THEN (CASE WHEN TC.DATA_PRECISION = 1 THEN 'C' ELSE 'B' END)
       WHEN 23 THEN (CASE WHEN TC.DATA_PRECISION = 1 THEN 'C' ELSE 'B' END)
       WHEN 43 THEN (CASE WHEN TC.DATA_PRECISION = 1 THEN 'C' ELSE 'B' END)
       WHEN 44 THEN (CASE WHEN TC.DATA_PRECISION = 1 THEN 'C' ELSE 'B' END)
       ELSE NULL END AS CHAR(1)) AS  CHAR_USED,
  CAST(NULL AS CHAR(3)) AS  V80_FMT_IMAGE,
  CAST(NULL AS CHAR(3)) AS  DATA_UPGRADED,
  CAST(CASE WHEN (TC.COLUMN_FLAGS & 64) = 0 THEN 'NO'  ELSE 'YES' END AS CHAR(3)) AS HIDDEN_COLUMN,
  CAST(CASE WHEN (TC.COLUMN_FLAGS & 1)  = 1 THEN 'YES' ELSE 'NO'  END AS CHAR(3)) AS  VIRTUAL_COLUMN,
  CAST(NULL AS SIGNED) AS  SEGMENT_COLUMN_ID,
  CAST(NULL AS SIGNED) AS  INTERNAL_COLUMN_ID,
  CAST((CASE WHEN STAT.HISTOGRAM_TYPE = 1 THEN 'FREQUENCY'
        WHEN STAT.HISTOGRAM_TYPE = 3 THEN 'TOP-FREQUENCY'
        WHEN STAT.HISTOGRAM_TYPE = 4 THEN 'HYBRID'
        ELSE NULL END) AS CHAR(15)) AS HISTOGRAM,
  CAST(TC.COLUMN_NAME AS CHAR(4000)) AS  QUALIFIED_COL_NAME,
  CAST(CASE WHEN (TC.COLUMN_FLAGS & 2097152) = 0 THEN 'YES'  ELSE 'NO' END AS CHAR(3)) AS USER_GENERATED,
  CAST(NULL AS CHAR(3)) AS  DEFAULT_ON_NULL,
  CAST(NULL AS CHAR(3)) AS  IDENTITY_COLUMN,
  CAST(NULL AS CHAR(128)) AS  EVALUATION_EDITION,
  CAST(NULL AS CHAR(128)) AS  UNUSABLE_BEFORE,
  CAST(NULL AS CHAR(128)) AS  UNUSABLE_BEGINNING,
  CAST(NULL AS CHAR(100)) AS  COLLATION,
  CAST(NULL AS SIGNED) AS  COLLATED_COLUMN_ID
FROM
    (SELECT T.TENANT_ID,
            T.TABLE_ID,
            T.DATABASE_ID,
            T.TABLE_NAME,
            T.TABLE_TYPE,
            C.COLUMN_ID,
            C.COLUMN_NAME,
            C.DATA_TYPE,
            C.COLLATION_TYPE,
            C.DATA_SCALE,
            C.DATA_LENGTH,
            C.DATA_PRECISION,
            C.NULLABLE,
            C.COLUMN_FLAGS,
            C.CUR_DEFAULT_VALUE_V2
     FROM OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE T
     JOIN OCEANBASE.__ALL_VIRTUAL_CORE_COLUMN_TABLE C
       ON C.TENANT_ID = T.TENANT_ID
      AND C.TABLE_ID = T.TABLE_ID
      AND C.IS_HIDDEN = 0
     UNION ALL
     SELECT T.TENANT_ID,
            T.TABLE_ID,
            T.DATABASE_ID,
            T.TABLE_NAME,
            T.TABLE_TYPE,
            C.COLUMN_ID,
            C.COLUMN_NAME,
            C.DATA_TYPE,
            C.COLLATION_TYPE,
            C.DATA_SCALE,
            C.DATA_LENGTH,
            C.DATA_PRECISION,
            C.NULLABLE,
            C.COLUMN_FLAGS,
            C.CUR_DEFAULT_VALUE_V2
     FROM OCEANBASE.__ALL_VIRTUAL_TABLE T
     JOIN OCEANBASE.__ALL_VIRTUAL_COLUMN C
       ON C.TENANT_ID = T.TENANT_ID
      AND C.TABLE_ID = T.TABLE_ID
     WHERE TABLE_MODE >> 12 & 15 in (0,1)
       AND INDEX_ATTRIBUTES_SET & 16 = 0
       AND C.IS_HIDDEN = 0) TC
  JOIN
    OCEANBASE.__ALL_VIRTUAL_DATABASE DB
  ON
    DB.TENANT_ID = TC.TENANT_ID
    AND DB.DATABASE_ID = TC.DATABASE_ID
  LEFT JOIN
    OCEANBASE.__ALL_VIRTUAL_COLUMN_STAT STAT
   ON
     TC.TENANT_ID = STAT.TENANT_ID
     AND TC.TABLE_ID = STAT.TABLE_ID
     AND TC.COLUMN_ID = STAT.COLUMN_ID
     AND STAT.OBJECT_TYPE = 1
WHERE
  TC.TABLE_TYPE IN (0,1,3,4,6,7,8,9,14,15)
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_TAB_COLS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21191',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
SELECT
  CON_ID,
  OWNER,
  TABLE_NAME,
  COLUMN_NAME,
  DATA_TYPE,
  DATA_TYPE_MOD,
  DATA_TYPE_OWNER,
  DATA_LENGTH,
  DATA_PRECISION,
  DATA_SCALE,
  NULLABLE,
  COLUMN_ID,
  DEFAULT_LENGTH,
  DATA_DEFAULT,
  NUM_DISTINCT,
  LOW_VALUE,
  HIGH_VALUE,
  DENSITY,
  NUM_NULLS,
  NUM_BUCKETS,
  LAST_ANALYZED,
  SAMPLE_SIZE,
  CHARACTER_SET_NAME,
  CHAR_COL_DECL_LENGTH,
  GLOBAL_STATS,
  USER_STATS,
  AVG_COL_LEN,
  CHAR_LENGTH,
  CHAR_USED,
  V80_FMT_IMAGE,
  DATA_UPGRADED,
  HIDDEN_COLUMN,
  VIRTUAL_COLUMN,
  SEGMENT_COLUMN_ID,
  INTERNAL_COLUMN_ID,
  HISTOGRAM,
  QUALIFIED_COL_NAME,
  USER_GENERATED,
  DEFAULT_ON_NULL,
  IDENTITY_COLUMN,
  EVALUATION_EDITION,
  UNUSABLE_BEFORE,
  UNUSABLE_BEGINNING,
  COLLATION,
  COLLATED_COLUMN_ID
FROM OCEANBASE.CDB_TAB_COLS_V$
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_INDEXES',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21192',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
      CAST(C.TENANT_ID AS SIGNED) AS CON_ID,
      CAST(INDEX_OWNER AS CHAR(128)) AS OWNER,
      CAST(INDEX_NAME AS CHAR(128)) AS INDEX_NAME,
      CAST(INDEX_TYPE_NAME AS CHAR(27)) AS INDEX_TYPE,
      CAST(TABLE_OWNER AS CHAR(128)) AS TABLE_OWNER,
      CAST(NEW_TABLE_NAME AS CHAR(128)) AS TABLE_NAME,
      CAST('TABLE' AS CHAR(5)) AS TABLE_TYPE,
      CAST(UNIQUENESS AS CHAR(9)) AS UNIQUENESS,
      CAST(COMPRESSION AS CHAR(13)) AS COMPRESSION,
      CAST(NULL AS NUMBER) AS PREFIX_LENGTH,
      CAST(TABLESPACE_NAME AS CHAR(30)) AS TABLESPACE_NAME,
      CAST(NULL AS NUMBER) AS INI_TRANS,
      CAST(NULL AS NUMBER) AS MAX_TRANS,
      CAST(NULL AS NUMBER) AS INITIAL_EXTENT,
      CAST(NULL AS NUMBER) AS NEXT_EXTENT,
      CAST(NULL AS NUMBER) AS MIN_EXTENTS,
      CAST(NULL AS NUMBER) AS MAX_EXTENTS,
      CAST(NULL AS NUMBER) AS PCT_INCREASE,
      CAST(NULL AS NUMBER) AS PCT_THRESHOLD,
      CAST(NULL AS NUMBER) AS INCLUDE_COLUMN,
      CAST(NULL AS NUMBER) AS FREELISTS,
      CAST(NULL AS NUMBER) AS FREELIST_GROUPS,
      CAST(NULL AS NUMBER) AS PCT_FREE,
      CAST(NULL AS CHAR(3)) AS LOGGING,
      CAST(NULL AS NUMBER) AS BLEVEL,
      CAST(NULL AS NUMBER) AS LEAF_BLOCKS,
      CAST(NULL AS NUMBER) AS DISTINCT_KEYS,
      CAST(NULL AS NUMBER) AS AVG_LEAF_BLOCKS_PER_KEY,
      CAST(NULL AS NUMBER) AS AVG_DATA_BLOCKS_PER_KEY,
      CAST(NULL AS NUMBER) AS CLUSTERING_FACTOR,
      CAST(STATUS AS CHAR(8)) AS STATUS,
      CAST(NULL AS NUMBER) AS NUM_ROWS,
      CAST(NULL AS NUMBER) AS SAMPLE_SIZE,
      CAST(NULL AS DATE) AS LAST_ANALYZED,
      CAST(DOP_DEGREE AS CHAR(40)) AS DEGREE,
      CAST(NULL AS CHAR(40)) AS INSTANCES,
      CAST(CASE WHEN A_PART_LEVEL = 0 THEN 'NO' ELSE 'YES' END AS CHAR(3)) AS PARTITIONED,
      CAST(NULL AS CHAR(1)) AS TEMPORARY,
      CAST(NULL AS CHAR(1)) AS "GENERATED",
      CAST(NULL AS CHAR(1)) AS SECONDARY,
      CAST(NULL AS CHAR(7)) AS BUFFER_POOL,
      CAST(NULL AS CHAR(7)) AS FLASH_CACHE,
      CAST(NULL AS CHAR(7)) AS CELL_FLASH_CACHE,
      CAST(NULL AS CHAR(3)) AS USER_STATS,
      CAST(NULL AS CHAR(15)) AS DURATION,
      CAST(NULL AS NUMBER) AS PCT_DIRECT_ACCESS,
      CAST(NULL AS CHAR(128)) AS ITYP_OWNER,
      CAST(INDEX_ITYP_NAME AS CHAR(128)) AS ITYP_NAME,
      CAST(NULL AS CHAR(1000)) AS PARAMETERS,
      CAST(NULL AS CHAR(3)) AS GLOBAL_STATS,
      CAST(NULL AS CHAR(12)) AS DOMIDX_STATUS,
      CAST(NULL AS CHAR(6)) AS DOMIDX_OPSTATUS,
      CAST(FUNCIDX_STATUS AS CHAR(8)) AS FUNCIDX_STATUS,
      CAST('NO' AS CHAR(3)) AS JOIN_INDEX,
      CAST(NULL AS CHAR(3)) AS IOT_REDUNDANT_PKEY_ELIM,
      CAST(DROPPED AS CHAR(3)) AS DROPPED,
      CAST(VISIBILITY AS CHAR(9)) AS VISIBILITY,
      CAST(NULL AS CHAR(14)) AS DOMIDX_MANAGEMENT,
      CAST(NULL AS CHAR(3)) AS SEGMENT_CREATED,
      CAST(NULL AS CHAR(3)) AS ORPHANED_ENTRIES,
      CAST(NULL AS CHAR(7)) AS INDEXING,
      CAST(NULL AS CHAR(3)) AS AUTO
      FROM
        (SELECT
        A.TENANT_ID AS TENANT_ID,
        DATABASE_NAME AS INDEX_OWNER,

        CASE WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME !=  '__recyclebin')
             THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))
             WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME =  '__recyclebin')
             THEN TABLE_NAME
             WHEN (TABLE_TYPE = 3 AND CONS_TAB.CONSTRAINT_NAME IS NULL)
             THEN CONCAT('t_pk_obpk_', A.TABLE_ID)
             ELSE (CONS_TAB.CONSTRAINT_NAME) END AS INDEX_NAME,

        CASE
          WHEN A.TABLE_TYPE = 5 AND A.INDEX_TYPE IN (10, 11, 12, 15, 18, 21) THEN 'DOMAIN'
          WHEN A.TABLE_TYPE = 5 AND EXISTS (
            SELECT 1
            FROM OCEANBASE.__ALL_VIRTUAL_COLUMN T_COL_INDEX,
                 OCEANBASE.__ALL_VIRTUAL_COLUMN T_COL_BASE
            WHERE T_COL_BASE.TABLE_ID = A.DATA_TABLE_ID
              AND T_COL_BASE.COLUMN_NAME = T_COL_INDEX.COLUMN_NAME
              AND T_COL_INDEX.TABLE_ID = A.TABLE_ID
              AND T_COL_BASE.TENANT_ID = A.TENANT_ID
              AND T_COL_INDEX.TENANT_ID = A.TENANT_ID
              AND (T_COL_BASE.COLUMN_FLAGS & 3) > 0
              AND T_COL_INDEX.INDEX_POSITION != 0
          ) THEN 'FUNCTION-BASED NORMAL'
          ELSE 'NORMAL'
        END AS INDEX_TYPE_NAME,

        CASE
          WHEN A.TABLE_TYPE = 5 AND A.INDEX_TYPE IN (10, 11, 12) THEN 'SPATIAL_INDEX'
          ELSE 'NULL'
        END AS INDEX_ITYP_NAME,

        DATABASE_NAME AS TABLE_OWNER,

        CASE WHEN (TABLE_TYPE = 3) THEN A.TABLE_ID
             ELSE A.DATA_TABLE_ID END AS TABLE_ID,

        A.TABLE_ID AS INDEX_ID,

        CASE WHEN TABLE_TYPE = 3 THEN 'UNIQUE'
             WHEN A.INDEX_TYPE IN (2, 4, 8, 41) THEN 'UNIQUE'
             ELSE 'NONUNIQUE' END AS UNIQUENESS,

        CASE WHEN A.COMPRESS_FUNC_NAME = NULL THEN 'DISABLED'
             ELSE 'ENABLED' END AS COMPRESSION,

        CASE WHEN TABLE_TYPE = 3 THEN 'VALID'
             WHEN A.INDEX_STATUS = 1 THEN 'UNAVAILABLE'
             WHEN A.INDEX_STATUS = 2 THEN 'VALID'
             WHEN A.INDEX_STATUS = 3 THEN 'CHECKING'
             WHEN A.INDEX_STATUS = 4 THEN 'INELEGIBLE'
             WHEN A.INDEX_STATUS = 5 THEN 'ERROR'
             ELSE 'UNUSABLE' END AS STATUS,

        A.INDEX_TYPE AS A_INDEX_TYPE,
        A.PART_LEVEL AS A_PART_LEVEL,
        A.TABLE_TYPE AS A_TABLE_TYPE,

        CASE WHEN 0 = (SELECT COUNT(1) FROM OCEANBASE.__ALL_VIRTUAL_COLUMN
                       WHERE TABLE_ID = A.TABLE_ID AND IS_HIDDEN = 0) THEN 'ENABLED'
             ELSE 'NULL' END AS FUNCIDX_STATUS,

        CASE WHEN B.IN_RECYCLEBIN = 1 THEN 'YES' ELSE 'NO' END AS DROPPED,

        CASE WHEN (A.INDEX_ATTRIBUTES_SET & 1) = 0 THEN 'VISIBLE'
             ELSE 'INVISIBLE' END AS VISIBILITY,

        A.TABLESPACE_ID,
        A.DOP AS DOP_DEGREE

        FROM
          OCEANBASE.__ALL_VIRTUAL_TABLE A
          JOIN OCEANBASE.__ALL_VIRTUAL_DATABASE B
          ON A.DATABASE_ID = B.DATABASE_ID
             AND A.TENANT_ID = B.TENANT_ID
             AND B.DATABASE_NAME != '__recyclebin'
             AND A.TABLE_MODE >> 12 & 15 in (0,1)
             AND A.INDEX_ATTRIBUTES_SET & 16 = 0

          LEFT JOIN OCEANBASE.__ALL_VIRTUAL_CONSTRAINT CONS_TAB
          ON CONS_TAB.TABLE_ID = A.TABLE_ID
             AND CONS_TAB.TENANT_ID = A.TENANT_ID
             AND CONS_TAB.CONSTRAINT_TYPE = 1
        WHERE
          (A.TABLE_TYPE = 3 AND A.TABLE_MODE & 66048 = 0) OR (A.TABLE_TYPE = 5 AND A.INDEX_TYPE NOT IN (13, 14, 16, 17, 19, 20, 22))
        ) C
      JOIN
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_virtual_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_virtual_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
              and mv_table.tenant_id = container_table.tenant_id
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_virtual_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			)) D
        ON C.TABLE_ID = D.TABLE_ID
           AND C.TENANT_ID = D.TENANT_ID

      LEFT JOIN OCEANBASE.__ALL_VIRTUAL_TENANT_TABLESPACE TP
      ON C.TABLESPACE_ID = TP.TABLESPACE_ID
         AND TP.TENANT_ID = C.TENANT_ID
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_IND_COLUMNS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21193',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT/*+leading(E,D,F)*/
      CAST(E.TENANT_ID AS NUMBER) AS CON_ID,
      CAST(INDEX_OWNER AS CHAR(128)) AS INDEX_OWNER,
      CAST(INDEX_NAME AS CHAR(128)) AS INDEX_NAME,
      CAST(TABLE_OWNER AS CHAR(128)) AS TABLE_OWNER,
      CAST(NEW_TABLE_NAME AS CHAR(128)) AS TABLE_NAME,
      CAST(COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
      CAST(ROWKEY_POSITION AS SIGNED) AS COLUMN_POSITION,

      CASE WHEN DATA_TYPE >= 1 AND DATA_TYPE <= 16 OR DATA_TYPE = 50 THEN CAST(22 AS SIGNED)
           WHEN DATA_TYPE = 17 THEN CAST(7 AS SIGNED)
           WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 2 THEN CAST(DATA_LENGTH AS SIGNED)
           WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 1 AND F.COLLATION_TYPE IN (45, 46, 224, 54, 55, 101) THEN CAST(DATA_LENGTH * 4 AS SIGNED)
           WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 1 AND F.COLLATION_TYPE IN (28, 87) THEN CAST(DATA_LENGTH * 2 AS SIGNED)
           WHEN DATA_TYPE = 36 THEN CAST(12 AS SIGNED)
           WHEN DATA_TYPE IN (37, 38) THEN CAST(11 AS SIGNED)
           WHEN DATA_TYPE = 39 THEN CAST(DATA_LENGTH AS SIGNED)
           WHEN DATA_TYPE = 40 THEN CAST(5 AS SIGNED)
           WHEN DATA_TYPE = 41 THEN CAST(11 AS SIGNED)
           ELSE CAST(0 AS SIGNED) END AS COLUMN_LENGTH,

      CASE WHEN DATA_TYPE IN (22, 23) THEN CAST(DATA_LENGTH AS SIGNED)
           ELSE CAST(0 AS SIGNED) END AS CHAR_LENGTH,

      CAST('ASC' AS CHAR(4)) AS DESCEND,
      CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID

      FROM
        (SELECT
            A.TENANT_ID,
            DATABASE_NAME AS INDEX_OWNER,
            CASE WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME !=  '__recyclebin')
                 THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))
                 WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME =  '__recyclebin')
                 THEN TABLE_NAME
                 WHEN (TABLE_TYPE = 3 AND CONS_TAB.CONSTRAINT_NAME IS NULL)
                 THEN CONCAT('t_pk_obpk_', A.TABLE_ID)
                 ELSE (CONS_TAB.CONSTRAINT_NAME) END AS INDEX_NAME,
            DATABASE_NAME AS TABLE_OWNER,
            CASE WHEN (TABLE_TYPE = 3) THEN A.TABLE_ID
                 ELSE A.DATA_TABLE_ID END AS TABLE_ID,
            A.TABLE_ID AS INDEX_ID,
            TABLE_TYPE AS IDX_TYPE
          FROM
            OCEANBASE.__ALL_VIRTUAL_TABLE A
            JOIN OCEANBASE.__ALL_VIRTUAL_DATABASE B
            ON A.DATABASE_ID = B.DATABASE_ID
               AND A.TENANT_ID = B.TENANT_ID AND A.TENANT_ID = B.TENANT_ID
               AND A.TABLE_MODE >> 12 & 15 in (0,1)
               AND A.INDEX_ATTRIBUTES_SET & 16 = 0

            LEFT JOIN OCEANBASE.__ALL_VIRTUAL_CONSTRAINT CONS_TAB
            ON CONS_TAB.TABLE_ID = A.TABLE_ID
               AND A.TENANT_ID = CONS_TAB.TENANT_ID
               AND CONS_TAB.CONSTRAINT_TYPE = 1

          WHERE
            (A.TABLE_TYPE = 3 AND A.TABLE_MODE & 66048 = 0) OR (A.TABLE_TYPE = 5)
        ) E
        JOIN
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_virtual_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_virtual_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
              and mv_table.tenant_id = container_table.tenant_id
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_virtual_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			)) D
          ON E.TENANT_ID = D.TENANT_ID
             AND E.TABLE_ID = D.TABLE_ID

        JOIN OCEANBASE.__ALL_VIRTUAL_COLUMN F
          ON E.INDEX_ID = F.TABLE_ID
             AND F.TENANT_ID = E.TENANT_ID
      WHERE
        F.ROWKEY_POSITION != 0
        AND (CASE WHEN IDX_TYPE = 5 THEN INDEX_POSITION ELSE 1 END) != 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_PART_TABLES',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21194',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
  SELECT CAST(DB.TENANT_ID AS SIGNED) CON_ID,
         CAST(DB.DATABASE_NAME AS CHAR(128)) OWNER,
         CAST(TB.NEW_TABLE_NAME AS CHAR(128)) TABLE_NAME,
         CAST((CASE TB.PART_FUNC_TYPE
              WHEN 0 THEN 'HASH'
              WHEN 1 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'HASH' ELSE 'KEY' END)
              WHEN 2 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'HASH' ELSE 'KEY' END)
              WHEN 3 THEN 'RANGE'
              WHEN 4 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'RANGE' ELSE 'RANGE COLUMNS' END)
              WHEN 5 THEN 'LIST'
              WHEN 6 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'LIST' ELSE 'LIST COLUMNS' END)
              WHEN 7 THEN 'RANGE' END)
              AS CHAR(13)) PARTITIONING_TYPE,
         CAST((CASE TB.PART_LEVEL
               WHEN 1 THEN 'NONE'
               WHEN 2 THEN
               (CASE TB.SUB_PART_FUNC_TYPE
                WHEN 0 THEN 'HASH'
                WHEN 1 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'HASH' ELSE 'KEY' END)
                WHEN 2 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'HASH' ELSE 'KEY' END)
                WHEN 3 THEN 'RANGE'
                WHEN 4 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'RANGE' ELSE 'RANGE COLUMNS' END)
                WHEN 5 THEN 'LIST'
                WHEN 6 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'LIST' ELSE 'LIST COLUMNS' END)
                WHEN 7 THEN 'RANGE' END) END)
              AS CHAR(13)) SUBPARTITIONING_TYPE,
         CAST((CASE TB.PART_FUNC_TYPE
               WHEN 7 THEN 1048575
               ELSE TB.PART_NUM END) AS SIGNED) PARTITION_COUNT,
         CAST ((CASE TB.PART_LEVEL
                WHEN 1 THEN 0
                WHEN 2 THEN (CASE WHEN TB.SUB_PART_TEMPLATE_FLAGS > 0 THEN TB.SUB_PART_NUM ELSE 1 END)
                END) AS SIGNED) DEF_SUBPARTITION_COUNT,
         CAST(PART_INFO.PART_KEY_COUNT AS SIGNED) PARTITIONING_KEY_COUNT,
         CAST((CASE TB.PART_LEVEL
              WHEN 1 THEN 0
              WHEN 2 THEN PART_INFO.SUBPART_KEY_COUNT END)
              AS SIGNED) SUBPARTITIONING_KEY_COUNT,
         CAST(NULL AS CHAR(8)) STATUS,
         CAST(TP.TABLESPACE_NAME AS CHAR(30)) DEF_TABLESPACE_NAME,
         CAST(NULL AS SIGNED) DEF_PCT_FREE,
         CAST(NULL AS SIGNED) DEF_PCT_USED,
         CAST(NULL AS SIGNED) DEF_INI_TRANS,
         CAST(NULL AS SIGNED) DEF_MAX_TRANS,
         CAST(NULL AS CHAR(40)) DEF_INITIAL_EXTENT,
         CAST(NULL AS CHAR(40)) DEF_NEXT_EXTENT,
         CAST(NULL AS CHAR(40)) DEF_MIN_EXTENTS,
         CAST(NULL AS CHAR(40)) DEF_MAX_EXTENTS,
         CAST(NULL AS CHAR(40)) DEF_MAX_SIZE,
         CAST(NULL AS CHAR(40)) DEF_PCT_INCREASE,
         CAST(NULL AS SIGNED) DEF_FREELISTS,
         CAST(NULL AS SIGNED) DEF_FREELIST_GROUPS,
         CAST(NULL AS CHAR(7)) DEF_LOGGING,
         CAST(CASE WHEN TB.COMPRESS_FUNC_NAME IS NULL THEN 'DISABLED'
              ELSE 'ENABLED' END AS CHAR(8)) DEF_COMPRESSION,
         CAST(TB.COMPRESS_FUNC_NAME AS CHAR(12)) DEF_COMPRESS_FOR,
         CAST(NULL AS CHAR(7)) DEF_BUFFER_POOL,
         CAST(NULL AS CHAR(7)) DEF_FLASH_CACHE,
         CAST(NULL AS CHAR(7)) DEF_CELL_FLASH_CACHE,
         CAST(NULL AS CHAR(128)) REF_PTN_CONSTRAINT_NAME,
         CAST(TB.INTERVAL_RANGE AS CHAR(1000)) "INTERVAL",
         CAST('NO' AS CHAR(3)) AUTOLIST,
         CAST(NULL AS CHAR(1000)) INTERVAL_SUBPARTITION,
         CAST('NO' AS CHAR(3)) AUTOLIST_SUBPARTITION,
         CAST(NULL AS CHAR(3)) IS_NESTED,
         CAST(NULL AS CHAR(4)) DEF_SEGMENT_CREATED,
         CAST(NULL AS CHAR(3)) DEF_INDEXING,
         CAST(NULL AS CHAR(8)) DEF_INMEMORY,
         CAST(NULL AS CHAR(8)) DEF_INMEMORY_PRIORITY,
         CAST(NULL AS CHAR(15)) DEF_INMEMORY_DISTRIBUTE,
         CAST(NULL AS CHAR(17)) DEF_INMEMORY_COMPRESSION,
         CAST(NULL AS CHAR(13)) DEF_INMEMORY_DUPLICATE,
         CAST(NULL AS CHAR(3)) DEF_READ_ONLY,
         CAST(NULL AS CHAR(24)) DEF_CELLMEMORY,
         CAST(NULL AS CHAR(12)) DEF_INMEMORY_SERVICE,
         CAST(NULL AS CHAR(1000)) DEF_INMEMORY_SERVICE_NAME,
         CAST('NO' AS CHAR(3)) AUTO
      FROM
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_virtual_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_virtual_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
              and mv_table.tenant_id = container_table.tenant_id
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_virtual_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			)) TB
      JOIN OCEANBASE.__ALL_TENANT T
      ON TB.TENANT_ID = T.TENANT_ID
      AND TB.TABLE_MODE >> 12 & 15 in (0,1)
      AND TB.INDEX_ATTRIBUTES_SET & 16 = 0
      JOIN OCEANBASE.__ALL_VIRTUAL_DATABASE DB
      ON TB.TENANT_ID = DB.TENANT_ID AND TB.DATABASE_ID = DB.DATABASE_ID
      JOIN
        (SELECT
         TENANT_ID,
         TABLE_ID,
         SUM(CASE WHEN (PARTITION_KEY_POSITION & 255) > 0 THEN 1 ELSE 0 END) AS PART_KEY_COUNT,
         SUM(CASE WHEN (PARTITION_KEY_POSITION & 65280) > 0 THEN 1 ELSE 0 END) AS SUBPART_KEY_COUNT
         FROM OCEANBASE.__ALL_VIRTUAL_COLUMN
         WHERE PARTITION_KEY_POSITION > 0
         GROUP BY TENANT_ID, TABLE_ID) PART_INFO
      ON TB.TENANT_ID = PART_INFO.TENANT_ID AND TB.TABLE_ID = PART_INFO.TABLE_ID
      LEFT JOIN OCEANBASE.__ALL_VIRTUAL_TENANT_TABLESPACE TP
      ON TB.TENANT_ID = TP.TENANT_ID AND TP.TABLESPACE_ID = TB.TABLESPACE_ID
      WHERE TB.TABLE_TYPE IN (3, 6, 8, 9, 15)
        AND TB.PART_LEVEL != 0
  """.replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_TAB_PARTITIONS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21195',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
  SELECT
      CAST(DB_TB.TENANT_ID AS SIGNED) CON_ID,
      CAST(DB_TB.DATABASE_NAME AS CHAR(128)) TABLE_OWNER,
      CAST(DB_TB.TABLE_NAME AS CHAR(128)) TABLE_NAME,

      CAST(CASE DB_TB.PART_LEVEL
           WHEN 2 THEN 'YES'
           ELSE 'NO' END AS CHAR(3)) COMPOSITE,

      CAST(PART.PART_NAME AS CHAR(128)) PARTITION_NAME,

      CAST(CASE DB_TB.PART_LEVEL
           WHEN 2 THEN PART.SUB_PART_NUM
           ELSE 0 END AS SIGNED)  SUBPARTITION_COUNT,

      CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN PART.HIGH_BOUND_VAL
           ELSE PART.LIST_VAL END AS CHAR(262144)) HIGH_VALUE,

      CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN length(PART.HIGH_BOUND_VAL)
           ELSE length(PART.LIST_VAL) END AS SIGNED) HIGH_VALUE_LENGTH,

      CAST(PART.PARTITION_POSITION AS SIGNED) PARTITION_POSITION,
      CAST(TP.TABLESPACE_NAME AS CHAR(30)) TABLESPACE_NAME,
      CAST(NULL AS SIGNED) PCT_FREE,
      CAST(NULL AS SIGNED) PCT_USED,
      CAST(NULL AS SIGNED) INI_TRANS,
      CAST(NULL AS SIGNED) MAX_TRANS,
      CAST(NULL AS SIGNED) INITIAL_EXTENT,
      CAST(NULL AS SIGNED) NEXT_EXTENT,
      CAST(NULL AS SIGNED) MIN_EXTENT,
      CAST(NULL AS SIGNED) MAX_EXTENT,
      CAST(NULL AS SIGNED) MAX_SIZE,
      CAST(NULL AS SIGNED) PCT_INCREASE,
      CAST(NULL AS SIGNED) FREELISTS,
      CAST(NULL AS SIGNED) FREELIST_GROUPS,
      CAST(NULL AS CHAR(7)) LOGGING,

      CAST(CASE WHEN PART.COMPRESS_FUNC_NAME IS NULL THEN 'DISABLED'
           ELSE 'ENABLED' END AS CHAR(8)) COMPRESSION,

      CAST(PART.COMPRESS_FUNC_NAME AS CHAR(30)) COMPRESS_FOR,
      CAST(NULL AS SIGNED) NUM_ROWS,
      CAST(NULL AS SIGNED) BLOCKS,
      CAST(NULL AS SIGNED) EMPTY_BLOCKS,
      CAST(NULL AS SIGNED) AVG_SPACE,
      CAST(NULL AS SIGNED) CHAIN_CNT,
      CAST(NULL AS SIGNED) AVG_ROW_LEN,
      CAST(NULL AS SIGNED) SAMPLE_SIZE,
      CAST(NULL AS DATE) LAST_ANALYZED,
      CAST(NULL AS CHAR(7)) BUFFER_POOL,
      CAST(NULL AS CHAR(7)) FLASH_CACHE,
      CAST(NULL AS CHAR(7)) CELL_FLASH_CACHE,
      CAST(NULL AS CHAR(3)) GLOBAL_STATS,
      CAST(NULL AS CHAR(3)) USER_STATS,
      CAST(NULL AS CHAR(3)) IS_NESTED,
      CAST(NULL AS CHAR(128)) PARENT_TABLE_PARTITION,

      CAST (CASE WHEN PART.PARTITION_POSITION >
            MAX (CASE WHEN PART.HIGH_BOUND_VAL = DB_TB.B_TRANSITION_POINT
                 THEN PART.PARTITION_POSITION ELSE NULL END)
            OVER(PARTITION BY DB_TB.TABLE_ID)
            THEN 'YES' ELSE 'NO' END AS CHAR(3)) "INTERVAL",

      CAST(NULL AS CHAR(4)) SEGMENT_CREATED,
      CAST(NULL AS CHAR(4)) INDEXING,
      CAST(NULL AS CHAR(4)) READ_ONLY,
      CAST(NULL AS CHAR(8)) INMEMORY,
      CAST(NULL AS CHAR(8)) INMEMORY_PRIORITY,
      CAST(NULL AS CHAR(15)) INMEMORY_DISTRIBUTE,
      CAST(NULL AS CHAR(17)) INMEMORY_COMPRESSION,
      CAST(NULL AS CHAR(13)) INMEMORY_DUPLICATE,
      CAST(NULL AS CHAR(24)) CELLMEMORY,
      CAST(NULL AS CHAR(12)) INMEMORY_SERVICE,
      CAST(NULL AS CHAR(100)) INMEMORY_SERVICE_NAME,
      CAST(NULL AS CHAR(8)) MEMOPTIMIZE_READ,
      CAST(NULL AS CHAR(8)) MEMOPTIMIZE_WRITE

      FROM (SELECT DB.TENANT_ID,
                   DB.DATABASE_NAME,
                   DB.DATABASE_ID,
                   TB.TABLE_ID,
                   TB.NEW_TABLE_NAME AS TABLE_NAME,
                   TB.B_TRANSITION_POINT,
                   TB.PART_LEVEL
            FROM
			      ((
			          SELECT
			              mv_table.table_name AS new_table_name,
			              container_table.*
			          FROM
			              oceanbase.__all_virtual_table AS mv_table,
			              (
			                  SELECT * FROM
			                      oceanbase.__all_virtual_table
			                  WHERE
			                      (table_mode & 1 << 24) = 1 << 24
			              ) AS container_table
			          WHERE
			              mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
                    and mv_table.tenant_id = container_table.tenant_id
			      )

			      UNION ALL

			      (
			          SELECT
			              table_name as new_table_name,
			              *
			          FROM
			              oceanbase.__all_virtual_table
			          WHERE
			              (table_mode & 1 << 24) = 0
			      )) TB,
                 OCEANBASE.__ALL_VIRTUAL_DATABASE DB
            WHERE TB.DATABASE_ID = DB.DATABASE_ID
              AND TB.TENANT_ID = DB.TENANT_ID
              AND TB.TABLE_TYPE IN (3, 6, 8, 9, 15)
              AND TB.TABLE_MODE >> 12 & 15 in (0,1)
              AND TB.INDEX_ATTRIBUTES_SET & 16 = 0
           ) DB_TB
      JOIN (SELECT TENANT_ID,
                   TABLE_ID,
                   PART_NAME,
                   SUB_PART_NUM,
                   HIGH_BOUND_VAL,
                   LIST_VAL,
                   COMPRESS_FUNC_NAME,
                   TABLESPACE_ID,
                   PARTITION_TYPE,
                   ROW_NUMBER() OVER (
                     PARTITION BY TENANT_ID, TABLE_ID
                     ORDER BY PART_IDX, PART_ID ASC
                   ) PARTITION_POSITION
            FROM OCEANBASE.__ALL_VIRTUAL_PART) PART
      ON DB_TB.TABLE_ID = PART.TABLE_ID AND PART.TENANT_ID = DB_TB.TENANT_ID

      LEFT JOIN OCEANBASE.__ALL_VIRTUAL_TENANT_TABLESPACE TP
      ON TP.TABLESPACE_ID = PART.TABLESPACE_ID AND TP.TENANT_ID = PART.TENANT_ID

      WHERE PART.PARTITION_TYPE = 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_TAB_SUBPARTITIONS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21196',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
  SELECT
      CAST(DB_TB.TENANT_ID AS SIGNED) CON_ID,
      CAST(DB_TB.DATABASE_NAME AS CHAR(128)) TABLE_OWNER,
      CAST(DB_TB.TABLE_NAME AS CHAR(128)) TABLE_NAME,
      CAST(PART.PART_NAME AS CHAR(128)) PARTITION_NAME,
      CAST(PART.SUB_PART_NAME AS CHAR(128))  SUBPARTITION_NAME,
      CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN PART.HIGH_BOUND_VAL
           ELSE PART.LIST_VAL END AS CHAR(262144)) HIGH_VALUE,
      CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN length(PART.HIGH_BOUND_VAL)
           ELSE length(PART.LIST_VAL) END AS SIGNED) HIGH_VALUE_LENGTH,
      CAST(PART.PARTITION_POSITION AS SIGNED) PARTITION_POSITION,
      CAST(PART.SUBPARTITION_POSITION AS SIGNED) SUBPARTITION_POSITION,
      CAST(TP.TABLESPACE_NAME AS CHAR(30)) TABLESPACE_NAME,
      CAST(NULL AS SIGNED) PCT_FREE,
      CAST(NULL AS SIGNED) PCT_USED,
      CAST(NULL AS SIGNED) INI_TRANS,
      CAST(NULL AS SIGNED) MAX_TRANS,
      CAST(NULL AS SIGNED) INITIAL_EXTENT,
      CAST(NULL AS SIGNED) NEXT_EXTENT,
      CAST(NULL AS SIGNED) MIN_EXTENT,
      CAST(NULL AS SIGNED) MAX_EXTENT,
      CAST(NULL AS SIGNED) MAX_SIZE,
      CAST(NULL AS SIGNED) PCT_INCREASE,
      CAST(NULL AS SIGNED) FREELISTS,
      CAST(NULL AS SIGNED) FREELIST_GROUPS,
      CAST(NULL AS CHAR(3)) LOGGING,
      CAST(CASE WHEN
      PART.COMPRESS_FUNC_NAME IS NULL THEN
      'DISABLED' ELSE 'ENABLED' END AS CHAR(8)) COMPRESSION,
      CAST(PART.COMPRESS_FUNC_NAME AS CHAR(30)) COMPRESS_FOR,
      CAST(NULL AS SIGNED) NUM_ROWS,
      CAST(NULL AS SIGNED) BLOCKS,
      CAST(NULL AS SIGNED) EMPTY_BLOCKS,
      CAST(NULL AS SIGNED) AVG_SPACE,
      CAST(NULL AS SIGNED) CHAIN_CNT,
      CAST(NULL AS SIGNED) AVG_ROW_LEN,
      CAST(NULL AS SIGNED) SAMPLE_SIZE,
      CAST(NULL AS DATE) LAST_ANALYZED,
      CAST(NULL AS CHAR(7)) BUFFER_POOL,
      CAST(NULL AS CHAR(7)) FLASH_CACHE,
      CAST(NULL AS CHAR(7)) CELL_FLASH_CACHE,
      CAST(NULL AS CHAR(3)) GLOBAL_STATS,
      CAST(NULL AS CHAR(3)) USER_STATS,
      CAST('NO' AS CHAR(3)) "INTERVAL",
      CAST(NULL AS CHAR(3)) SEGMENT_CREATED,
      CAST(NULL AS CHAR(3)) INDEXING,
      CAST(NULL AS CHAR(3)) READ_ONLY,
      CAST(NULL AS CHAR(8)) INMEMORY,
      CAST(NULL AS CHAR(8)) INMEMORY_PRIORITY,
      CAST(NULL AS CHAR(15)) INMEMORY_DISTRIBUTE,
      CAST(NULL AS CHAR(17)) INMEMORY_COMPRESSION,
      CAST(NULL AS CHAR(13)) INMEMORY_DUPLICATE,
      CAST(NULL AS CHAR(12)) INMEMORY_SERVICE,
      CAST(NULL AS CHAR(1000)) INMEMORY_SERVICE_NAME,
      CAST(NULL AS CHAR(24)) CELLMEMORY,
      CAST(NULL AS CHAR(8)) MEMOPTIMIZE_READ,
      CAST(NULL AS CHAR(8)) MEMOPTIMIZE_WRITE
      FROM
      (SELECT DB.TENANT_ID,
              DB.DATABASE_NAME,
              DB.DATABASE_ID,
              TB.TABLE_ID,
              TB.NEW_TABLE_NAME AS TABLE_NAME
       FROM
			 ((
			     SELECT
			         mv_table.table_name AS new_table_name,
			         container_table.*
			     FROM
			         oceanbase.__all_virtual_table AS mv_table,
			         (
			             SELECT * FROM
			                 oceanbase.__all_virtual_table
			             WHERE
			                 (table_mode & 1 << 24) = 1 << 24
			         ) AS container_table
			     WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
              and mv_table.tenant_id = container_table.tenant_id
			 )

			 UNION ALL

			 (
			     SELECT
			         table_name as new_table_name,
			         *
			     FROM
			         oceanbase.__all_virtual_table
			     WHERE
			         (table_mode & 1 << 24) = 0
			 )) TB,
             OCEANBASE.__ALL_VIRTUAL_DATABASE DB
       WHERE TB.DATABASE_ID = DB.DATABASE_ID
         AND TB.TENANT_ID = DB.TENANT_ID
         AND TB.TABLE_TYPE IN (3, 6, 8, 9, 15)
         AND TB.TABLE_MODE >> 12 & 15 in (0,1)
         AND TB.INDEX_ATTRIBUTES_SET & 16 = 0) DB_TB
      JOIN
      (SELECT P_PART.TENANT_ID,
              P_PART.TABLE_ID,
              P_PART.PART_NAME,
              P_PART.PARTITION_POSITION,
              S_PART.SUB_PART_NAME,
              S_PART.HIGH_BOUND_VAL,
              S_PART.LIST_VAL,
              S_PART.COMPRESS_FUNC_NAME,
              S_PART.TABLESPACE_ID,
              S_PART.SUBPARTITION_POSITION
       FROM (SELECT
               TENANT_ID,
               TABLE_ID,
               PART_ID,
               PART_NAME,
               PARTITION_TYPE,
               ROW_NUMBER() OVER (
                 PARTITION BY TENANT_ID, TABLE_ID
                 ORDER BY PART_IDX, PART_ID ASC
               ) AS PARTITION_POSITION
             FROM OCEANBASE.__ALL_VIRTUAL_PART) P_PART,
            (SELECT
               TENANT_ID,
               TABLE_ID,
               PART_ID,
               SUB_PART_NAME,
               HIGH_BOUND_VAL,
               LIST_VAL,
               COMPRESS_FUNC_NAME,
               TABLESPACE_ID,
               PARTITION_TYPE,
               ROW_NUMBER() OVER (
                 PARTITION BY TENANT_ID, TABLE_ID, PART_ID
                 ORDER BY SUB_PART_IDX, SUB_PART_ID ASC
               ) AS SUBPARTITION_POSITION
             FROM OCEANBASE.__ALL_VIRTUAL_SUB_PART) S_PART
       WHERE P_PART.PART_ID = S_PART.PART_ID
             AND P_PART.TABLE_ID = S_PART.TABLE_ID
             AND P_PART.TENANT_ID = S_PART.TENANT_ID
             AND P_PART.PARTITION_TYPE = 0
             AND S_PART.PARTITION_TYPE = 0) PART
      ON DB_TB.TABLE_ID = PART.TABLE_ID AND DB_TB.TENANT_ID = PART.TENANT_ID

      LEFT JOIN
        OCEANBASE.__ALL_VIRTUAL_TENANT_TABLESPACE TP
      ON TP.TABLESPACE_ID = PART.TABLESPACE_ID AND TP.TENANT_ID = PART.TENANT_ID

""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_SUBPARTITION_TEMPLATES',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21197',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
  SELECT
      CAST(DB.TENANT_ID AS NUMBER) CON_ID,
      CAST(DB.DATABASE_NAME AS CHAR(128)) USER_NAME,
      CAST(TB.TABLE_NAME AS CHAR(128)) TABLE_NAME,
      CAST(SP.SUB_PART_NAME AS CHAR(132)) SUBPARTITION_NAME,
      CAST(SP.SUB_PART_ID + 1 AS SIGNED) SUBPARTITION_POSITION,
      CAST(TP.TABLESPACE_NAME AS CHAR(30)) TABLESPACE_NAME,
      CAST(CASE WHEN SP.HIGH_BOUND_VAL IS NULL THEN SP.LIST_VAL
           ELSE SP.HIGH_BOUND_VAL END AS CHAR(262144)) HIGH_BOUND,
      CAST(NULL AS CHAR(4)) COMPRESSION,
      CAST(NULL AS CHAR(4)) INDEXING,
      CAST(NULL AS CHAR(4)) READ_ONLY

      FROM OCEANBASE.__ALL_VIRTUAL_DATABASE DB

      JOIN OCEANBASE.__ALL_VIRTUAL_TABLE TB
      ON DB.DATABASE_ID = TB.DATABASE_ID AND DB.TENANT_ID = TB.TENANT_ID
         AND TB.TABLE_TYPE IN (3, 6, 8, 9)
         AND TB.TABLE_MODE >> 12 & 15 in (0,1)
         AND TB.INDEX_ATTRIBUTES_SET & 16 = 0

      JOIN OCEANBASE.__ALL_VIRTUAL_DEF_SUB_PART SP
      ON TB.TABLE_ID = SP.TABLE_ID AND SP.TENANT_ID = TB.TENANT_ID

      LEFT JOIN OCEANBASE.__ALL_VIRTUAL_TENANT_TABLESPACE TP
      ON TP.TABLESPACE_ID = SP.TABLESPACE_ID AND TP.TENANT_ID = SP.TENANT_ID
      """.replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_PART_KEY_COLUMNS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21198',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT  CAST(D.TENANT_ID AS SIGNED) AS CON_ID,
            CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(T.TABLE_NAME AS CHAR(128)) AS NAME,
            CAST('TABLE' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 255) AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_VIRTUAL_COLUMN C, OCEANBASE.__ALL_VIRTUAL_TABLE T, OCEANBASE.__ALL_VIRTUAL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND C.TABLE_ID = T.TABLE_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND (C.PARTITION_KEY_POSITION & 255) > 0
          AND T.TABLE_TYPE IN (3, 6, 8, 9)
          AND T.TABLE_MODE >> 12 & 15 in (0,1)
          AND T.INDEX_ATTRIBUTES_SET & 16 = 0
    UNION
    SELECT  CAST(D.TENANT_ID AS SIGNED) AS CON_ID,
            CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(CASE WHEN D.DATABASE_NAME = '__recyclebin' THEN T.TABLE_NAME
                ELSE SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7))) END AS CHAR(128)) AS NAME,
            CAST('INDEX' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 255) AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_VIRTUAL_COLUMN C, OCEANBASE.__ALL_VIRTUAL_TABLE T, OCEANBASE.__ALL_VIRTUAL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND C.TABLE_ID = T.TABLE_ID
          AND T.TABLE_TYPE = 5
          AND T.INDEX_TYPE NOT IN (17,19,20,22)
          AND (C.PARTITION_KEY_POSITION & 255) > 0
    UNION
    SELECT  CAST(D.TENANT_ID AS SIGNED) AS CON_ID,
            CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(CASE WHEN D.DATABASE_NAME =  '__recyclebin' THEN T.TABLE_NAME
                ELSE SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7))) END AS CHAR(128)) AS NAME,
            CAST('INDEX' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 255) AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_VIRTUAL_COLUMN C, OCEANBASE.__ALL_VIRTUAL_TABLE T, OCEANBASE.__ALL_VIRTUAL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND C.TABLE_ID = T.DATA_TABLE_ID
          AND T.TABLE_TYPE = 5
          AND T.INDEX_TYPE IN (1,2,10,15,23,24,41)
          AND (C.PARTITION_KEY_POSITION & 255) > 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_SUBPART_KEY_COLUMNS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21199',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT  CAST(D.TENANT_ID AS SIGNED) AS CON_ID,
            CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(T.TABLE_NAME AS CHAR(128)) AS NAME,
            CAST('TABLE' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 65280)/256 AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_VIRTUAL_COLUMN C, OCEANBASE.__ALL_VIRTUAL_TABLE T, OCEANBASE.__ALL_VIRTUAL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND C.TABLE_ID = T.TABLE_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND (C.PARTITION_KEY_POSITION & 65280) > 0
          AND T.TABLE_TYPE IN (3, 6, 8, 9)
          AND T.TABLE_MODE >> 12 & 15 in (0,1)
          AND T.INDEX_ATTRIBUTES_SET & 16 = 0
    UNION
    SELECT  CAST(D.TENANT_ID AS SIGNED) AS CON_ID,
            CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(CASE WHEN D.DATABASE_NAME = '__recyclebin' THEN T.TABLE_NAME
                ELSE SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7))) END AS CHAR(128)) AS NAME,
            CAST('INDEX' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 65280)/256 AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_VIRTUAL_COLUMN C, OCEANBASE.__ALL_VIRTUAL_TABLE T, OCEANBASE.__ALL_VIRTUAL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND C.TABLE_ID = T.TABLE_ID
          AND T.TABLE_TYPE = 5
          AND T.INDEX_TYPE NOT IN (17,19,20,22)
          AND (C.PARTITION_KEY_POSITION & 65280) > 0
    UNION
    SELECT  CAST(D.TENANT_ID AS SIGNED) AS CON_ID,
            CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(CASE WHEN D.DATABASE_NAME =  '__recyclebin' THEN T.TABLE_NAME
                ELSE SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7))) END AS CHAR(128)) AS NAME,
            CAST('INDEX' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 65280)/256 AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_VIRTUAL_COLUMN C, OCEANBASE.__ALL_VIRTUAL_TABLE T, OCEANBASE.__ALL_VIRTUAL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND C.TABLE_ID = T.DATA_TABLE_ID
          AND T.TABLE_TYPE = 5
          AND T.INDEX_TYPE IN (1,2,10,15,23,24,41)
          AND (C.PARTITION_KEY_POSITION & 65280) > 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_PART_INDEXES',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21200',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition =
    """
SELECT /*+NO_USE_NL(I_T PKC)*/
CAST(I_T.TENANT_ID AS NUMBER) AS CON_ID,
CAST(I_T.OWNER AS CHAR(128)) AS OWNER,
CAST(I_T.INDEX_NAME AS CHAR(128)) AS INDEX_NAME,
CAST(I_T.TABLE_NAME AS CHAR(128)) AS TABLE_NAME,

CAST(CASE I_T.PART_FUNC_TYPE
     WHEN 0 THEN 'HASH'
     WHEN 1 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'HASH' ELSE 'KEY' END)
     WHEN 2 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'HASH' ELSE 'KEY' END)
     WHEN 3 THEN 'RANGE'
     WHEN 4 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'RANGE' ELSE 'RANGE COLUMNS' END)
     WHEN 5 THEN 'LIST'
     WHEN 6 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'LIST' ELSE 'LIST COLUMNS' END)
     WHEN 7 THEN 'RANGE' END AS CHAR(13)) AS PARTITIONING_TYPE,

CAST(CASE WHEN I_T.PART_LEVEL < 2 THEN 'NONE'
     ELSE (CASE I_T.SUB_PART_FUNC_TYPE
           WHEN 0 THEN 'HASH'
           WHEN 1 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'HASH' ELSE 'KEY' END)
           WHEN 2 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'HASH' ELSE 'KEY' END)
           WHEN 3 THEN 'RANGE'
           WHEN 4 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'RANGE' ELSE 'RANGE COLUMNS' END)
           WHEN 5 THEN 'LIST'
           WHEN 6 THEN (CASE COMPATIBILITY_MODE WHEN 1 THEN 'LIST' ELSE 'LIST COLUMNS' END)
           WHEN 7 THEN 'RANGE' END)
     END AS CHAR(13)) AS SUBPARTITIONING_TYPE,

CAST(I_T.PART_NUM AS SIGNED) AS PARTITION_COUNT,

CAST(CASE WHEN (I_T.PART_LEVEL < 2 OR I_T.SUB_PART_TEMPLATE_FLAGS = 0) THEN 0
     ELSE I_T.SUB_PART_NUM END AS SIGNED) AS DEF_SUBPARTITION_COUNT,

CAST(PKC.PARTITIONING_KEY_COUNT AS SIGNED) AS PARTITIONING_KEY_COUNT,
CAST(PKC.SUBPARTITIONING_KEY_COUNT AS SIGNED) AS SUBPARTITIONING_KEY_COUNT,

CAST(CASE I_T.IS_LOCAL WHEN 1 THEN 'LOCAL'
     ELSE 'GLOBAL' END AS CHAR(6)) AS LOCALITY,

CAST(CASE WHEN I_T.IS_LOCAL = 0 THEN 'PREFIXED'
          WHEN (I_T.IS_LOCAL = 1 AND LOCAL_PARTITIONED_PREFIX_INDEX.IS_PREFIXED = 1) THEN 'PREFIXED'
                    ELSE 'NON_PREFIXED' END AS CHAR(12)) AS ALIGNMENT,

CAST(TP.TABLESPACE_NAME AS CHAR(30)) AS DEF_TABLESPACE_NAME,
CAST(0 AS SIGNED) AS DEF_PCT_FREE,
CAST(0 AS SIGNED) AS DEF_INI_TRANS,
CAST(0 AS SIGNED) AS DEF_MAX_TRANS,
CAST(NULL AS CHAR(40)) AS DEF_INITIAL_EXTENT,
CAST(NULL AS CHAR(40)) AS DEF_NEXT_EXTENT,
CAST(NULL AS CHAR(40)) AS DEF_MIN_EXTENTS,
CAST(NULL AS CHAR(40)) AS DEF_MAX_EXTENTS,
CAST(NULL AS CHAR(40)) AS DEF_MAX_SIZE,
CAST(NULL AS CHAR(40)) AS DEF_PCT_INCREASE,
CAST(0 AS SIGNED) AS DEF_FREELISTS,
CAST(0 AS SIGNED) AS DEF_FREELIST_GROUPS,
CAST(NULL AS CHAR(7)) AS DEF_LOGGING,
CAST(NULL AS CHAR(7)) AS DEF_BUFFER_POOL,
CAST(NULL AS CHAR(7)) AS DEF_FLASH_CACHE,
CAST(NULL AS CHAR(7)) AS DEF_CELL_FLASH_CACHE,
CAST(NULL AS CHAR(1000)) AS DEF_PARAMETERS,
CAST('NO' AS CHAR(1000)) AS "INTERVAL",
CAST('NO' AS CHAR(3)) AS AUTOLIST,
CAST(NULL AS CHAR(1000)) AS INTERVAL_SUBPARTITION,
CAST(NULL AS CHAR(1000)) AS AUTOLIST_SUBPARTITION

FROM
(SELECT D.TENANT_ID,
        D.DATABASE_NAME AS OWNER,
        I.TABLE_ID AS INDEX_ID,
        CAST(CASE WHEN D.DATABASE_NAME = '__recyclebin' THEN I.TABLE_NAME
            ELSE SUBSTR(I.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(I.TABLE_NAME, 7)))
            END AS CHAR(128)) AS INDEX_NAME,
        I.PART_LEVEL,
        I.PART_FUNC_TYPE,
        I.PART_NUM,
        I.SUB_PART_FUNC_TYPE,
        T.NEW_TABLE_NAME AS TABLE_NAME,
        T.SUB_PART_NUM,
        T.SUB_PART_TEMPLATE_FLAGS,
        T.TABLESPACE_ID,
        (CASE I.INDEX_TYPE
         WHEN 1 THEN 1
         WHEN 2 THEN 1
         WHEN 10 THEN 1
         WHEN 15 THEN 1
         WHEN 23 THEN 1
         WHEN 24 THEN 1
         WHEN 41 THEN 1
         ELSE 0 END) AS IS_LOCAL,
        (CASE I.INDEX_TYPE
         WHEN 1 THEN T.TABLE_ID
         WHEN 2 THEN T.TABLE_ID
         WHEN 10 THEN T.TABLE_ID
         WHEN 15 THEN T.TABLE_ID
         WHEN 23 THEN T.TABLE_ID
         WHEN 24 THEN T.TABLE_ID
         ELSE I.TABLE_ID END) AS JOIN_TABLE_ID
 FROM OCEANBASE.__ALL_VIRTUAL_TABLE I
 JOIN
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_virtual_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_virtual_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
              and mv_table.tenant_id = container_table.tenant_id
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_virtual_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			)) T
 ON I.TENANT_ID = T.TENANT_ID AND I.DATA_TABLE_ID = T.TABLE_ID
 JOIN OCEANBASE.__ALL_VIRTUAL_DATABASE D
 ON T.TENANT_ID = D.TENANT_ID AND T.DATABASE_ID = D.DATABASE_ID
 WHERE I.TABLE_TYPE = 5 AND I.INDEX_TYPE NOT IN (13, 14, 16, 17, 19, 20, 22) AND I.PART_LEVEL != 0
 AND T.TABLE_MODE >> 12 & 15 in (0,1)
 AND T.INDEX_ATTRIBUTES_SET & 16 = 0
) I_T

JOIN OCEANBASE.__ALL_TENANT T
ON I_T.TENANT_ID = T.TENANT_ID

LEFT JOIN
(
 SELECT I.TENANT_ID,
                I.TABLE_ID AS INDEX_ID,
                1 AS IS_PREFIXED
 FROM OCEANBASE.__ALL_VIRTUAL_TABLE I
 WHERE I.TABLE_TYPE = 5
   AND I.INDEX_TYPE IN (1, 2, 10, 15, 23, 24, 41)
   AND I.PART_LEVEL != 0
 AND NOT EXISTS
 (SELECT /*+NO_USE_NL(PART_COLUMNS INDEX_COLUMNS)*/ *
  FROM
   (SELECT *
    FROM OCEANBASE.__ALL_VIRTUAL_COLUMN C
    WHERE C.TABLE_ID = I.DATA_TABLE_ID
          AND C.TENANT_ID = I.TENANT_ID
          AND C.PARTITION_KEY_POSITION != 0
   ) PART_COLUMNS
   LEFT JOIN
   (SELECT *
    FROM OCEANBASE.__ALL_VIRTUAL_COLUMN C
    WHERE C.TABLE_ID = I.TABLE_ID
          AND C.TENANT_ID = I.TENANT_ID
          AND C.INDEX_POSITION != 0
   ) INDEX_COLUMNS
   ON PART_COLUMNS.COLUMN_ID = INDEX_COLUMNS.COLUMN_ID
   WHERE
   ((PART_COLUMNS.PARTITION_KEY_POSITION & 255) != 0
    AND
    (INDEX_COLUMNS.INDEX_POSITION IS NULL
     OR (PART_COLUMNS.PARTITION_KEY_POSITION & 255) != INDEX_COLUMNS.INDEX_POSITION)
   )
   OR
   ((PART_COLUMNS.PARTITION_KEY_POSITION & 65280)/256 != 0
    AND (INDEX_COLUMNS.INDEX_POSITION IS NULL)
   )
 )
) LOCAL_PARTITIONED_PREFIX_INDEX
ON I_T.TENANT_ID = LOCAL_PARTITIONED_PREFIX_INDEX.TENANT_ID
   AND I_T.INDEX_ID = LOCAL_PARTITIONED_PREFIX_INDEX.INDEX_ID

JOIN
(SELECT
   TENANT_ID,
   TABLE_ID,
   SUM(CASE WHEN (PARTITION_KEY_POSITION & 255) != 0 THEN 1 ELSE 0 END) AS PARTITIONING_KEY_COUNT,
   SUM(CASE WHEN (PARTITION_KEY_POSITION & 65280)/256 != 0 THEN 1 ELSE 0 END) AS SUBPARTITIONING_KEY_COUNT
   FROM OCEANBASE.__ALL_VIRTUAL_COLUMN
   GROUP BY TENANT_ID, TABLE_ID) PKC
ON I_T.TENANT_ID = PKC.TENANT_ID AND I_T.JOIN_TABLE_ID = PKC.TABLE_ID

LEFT JOIN OCEANBASE.__ALL_VIRTUAL_TENANT_TABLESPACE TP
ON I_T.TENANT_ID = TP.TENANT_ID AND I_T.TABLESPACE_ID = TP.TABLESPACE_ID

    """
 .replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_IND_PARTITIONS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21201',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
  SELECT
    CAST(D.TENANT_ID AS SIGNED) AS CON_ID,
    CAST(D.DATABASE_NAME AS CHAR(128)) AS INDEX_OWNER,
    CAST(CASE WHEN D.DATABASE_NAME = '__recyclebin' THEN I.TABLE_NAME
        ELSE SUBSTR(I.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(I.TABLE_NAME, 7)))
        END AS CHAR(128)) AS INDEX_NAME,
    CAST(DT.TABLE_NAME AS CHAR(128)) AS TABLE_NAME,

    CAST(CASE I.PART_LEVEL
         WHEN 2 THEN 'YES'
         ELSE 'NO' END AS CHAR(3)) COMPOSITE,

    CAST(PART.PART_NAME AS CHAR(128)) AS PARTITION_NAME,

    CAST(CASE I.PART_LEVEL
         WHEN 2 THEN PART.SUB_PART_NUM
         ELSE 0 END AS SIGNED)  SUBPARTITION_COUNT,

    CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN PART.HIGH_BOUND_VAL
         ELSE PART.LIST_VAL END AS CHAR(262144)) HIGH_VALUE,

    CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN length(PART.HIGH_BOUND_VAL)
         ELSE length(PART.LIST_VAL) END AS SIGNED) HIGH_VALUE_LENGTH,

    CAST(PART.PARTITION_POSITION AS SIGNED) PARTITION_POSITION,
    CAST(NULL AS CHAR(8)) AS STATUS,
    CAST(NULL AS CHAR(30)) AS TABLESPACE_NAME,
    CAST(NULL AS SIGNED) AS PCT_FREE,
    CAST(NULL AS SIGNED) AS INI_TRANS,
    CAST(NULL AS SIGNED) AS MAX_TRANS,
    CAST(NULL AS SIGNED) AS INITIAL_EXTENT,
    CAST(NULL AS SIGNED) AS NEXT_EXTENT,
    CAST(NULL AS SIGNED) AS MIN_EXTENT,
    CAST(NULL AS SIGNED) AS MAX_EXTENT,
    CAST(NULL AS SIGNED) AS MAX_SIZE,
    CAST(NULL AS SIGNED) AS PCT_INCREASE,
    CAST(NULL AS SIGNED) AS FREELISTS,
    CAST(NULL AS SIGNED) AS FREELIST_GROUPS,
    CAST(NULL AS CHAR(7)) AS LOGGING,
    CAST(CASE WHEN PART.COMPRESS_FUNC_NAME IS NULL THEN 'DISABLED' ELSE 'ENABLED' END AS CHAR(13)) AS COMPRESSION,
    CAST(NULL AS SIGNED) AS BLEVEL,
    CAST(NULL AS SIGNED) AS LEAF_BLOCKS,
    CAST(NULL AS SIGNED) AS DISTINCT_KEYS,
    CAST(NULL AS SIGNED) AS AVG_LEAF_BLOCKS_PER_KEY,
    CAST(NULL AS SIGNED) AS AVG_DATA_BLOCKS_PER_KEY,
    CAST(NULL AS SIGNED) AS CLUSTERING_FACTOR,
    CAST(NULL AS SIGNED) AS NUM_ROWS,
    CAST(NULL AS SIGNED) AS SAMPLE_SIZE,
    CAST(NULL AS DATE) AS LAST_ANALYZED,
    CAST(NULL AS CHAR(7)) AS BUFFER_POOL,
    CAST(NULL AS CHAR(7)) AS FLASH_CACHE,
    CAST(NULL AS CHAR(7)) AS CELL_FLASH_CACHE,
    CAST(NULL AS CHAR(3)) AS USER_STATS,
    CAST(NULL AS SIGNED) AS PCT_DIRECT_ACCESS,
    CAST(NULL AS CHAR(3)) AS GLOBAL_STATS,
    CAST(NULL AS CHAR(6)) AS DOMIDX_OPSTATUS,
    CAST(NULL AS CHAR(1000)) AS PARAMETERS,
    CAST('NO' AS CHAR(3)) AS "INTERVAL",
    CAST(NULL AS CHAR(3)) AS SEGMENT_CREATED,
    CAST(NULL AS CHAR(3)) AS ORPHANED_ENTRIES
    FROM
    OCEANBASE.__ALL_VIRTUAL_TABLE I
    JOIN OCEANBASE.__ALL_VIRTUAL_TABLE DT
    ON I.TENANT_ID = DT.TENANT_ID AND I.DATA_TABLE_ID = DT.TABLE_ID
    JOIN OCEANBASE.__ALL_VIRTUAL_DATABASE D
    ON I.TENANT_ID = D.TENANT_ID
       AND I.DATABASE_ID = D.DATABASE_ID
       AND I.TABLE_TYPE = 5
       AND I.TABLE_MODE >> 12 & 15 in (0,1)
       AND I.INDEX_ATTRIBUTES_SET & 16 = 0

    JOIN (SELECT TENANT_ID,
                 TABLE_ID,
                 PART_NAME,
                 SUB_PART_NUM,
                 HIGH_BOUND_VAL,
                 LIST_VAL,
                 COMPRESS_FUNC_NAME,
                 PARTITION_TYPE,
                 ROW_NUMBER() OVER (
                   PARTITION BY TENANT_ID, TABLE_ID
                   ORDER BY PART_IDX, PART_ID ASC
                 ) PARTITION_POSITION
          FROM OCEANBASE.__ALL_VIRTUAL_PART) PART
    ON I.TENANT_ID = PART.TENANT_ID
       AND I.TABLE_ID = PART.TABLE_ID
    WHERE PART.PARTITION_TYPE = 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_IND_SUBPARTITIONS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21202',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
  SELECT
    CAST(D.TENANT_ID AS NUMBER) AS CON_ID,
    CAST(D.DATABASE_NAME AS CHAR(128)) AS INDEX_OWNER,
    CAST(CASE WHEN D.DATABASE_NAME = '__recyclebin' THEN I.TABLE_NAME
        ELSE SUBSTR(I.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(I.TABLE_NAME, 7)))
        END AS CHAR(128)) AS INDEX_NAME,
    CAST(DT.TABLE_NAME AS CHAR(128)) AS TABLE_NAME,
    CAST(PART.PART_NAME AS CHAR(128)) PARTITION_NAME,
    CAST(PART.SUB_PART_NAME AS CHAR(128))  SUBPARTITION_NAME,
    CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN PART.HIGH_BOUND_VAL
         ELSE PART.LIST_VAL END AS CHAR(262144)) HIGH_VALUE,
    CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN length(PART.HIGH_BOUND_VAL)
         ELSE length(PART.LIST_VAL) END AS SIGNED) HIGH_VALUE_LENGTH,
    CAST(PART.PARTITION_POSITION AS SIGNED) PARTITION_POSITION,
    CAST(PART.SUBPARTITION_POSITION AS SIGNED) SUBPARTITION_POSITION,
    CAST(NULL AS CHAR(8)) AS STATUS,
    CAST(NULL AS CHAR(30)) AS TABLESPACE_NAME,
    CAST(NULL AS SIGNED) AS PCT_FREE,
    CAST(NULL AS SIGNED) AS INI_TRANS,
    CAST(NULL AS SIGNED) AS MAX_TRANS,
    CAST(NULL AS SIGNED) AS INITIAL_EXTENT,
    CAST(NULL AS SIGNED) AS NEXT_EXTENT,
    CAST(NULL AS SIGNED) AS MIN_EXTENT,
    CAST(NULL AS SIGNED) AS MAX_EXTENT,
    CAST(NULL AS SIGNED) AS MAX_SIZE,
    CAST(NULL AS SIGNED) AS PCT_INCREASE,
    CAST(NULL AS SIGNED) AS FREELISTS,
    CAST(NULL AS SIGNED) AS FREELIST_GROUPS,
    CAST(NULL AS CHAR(3)) AS LOGGING,
    CAST(CASE WHEN PART.COMPRESS_FUNC_NAME IS NULL THEN 'DISABLED' ELSE 'ENABLED' END AS CHAR(13)) AS COMPRESSION,
    CAST(NULL AS SIGNED) AS BLEVEL,
    CAST(NULL AS SIGNED) AS LEAF_BLOCKS,
    CAST(NULL AS SIGNED) AS DISTINCT_KEYS,
    CAST(NULL AS SIGNED) AS AVG_LEAF_BLOCKS_PER_KEY,
    CAST(NULL AS SIGNED) AS AVG_DATA_BLOCKS_PER_KEY,
    CAST(NULL AS SIGNED) AS CLUSTERING_FACTOR,
    CAST(NULL AS SIGNED) AS NUM_ROWS,
    CAST(NULL AS SIGNED) AS SAMPLE_SIZE,
    CAST(NULL AS DATE) AS LAST_ANALYZED,
    CAST(NULL AS CHAR(7)) AS BUFFER_POOL,
    CAST(NULL AS CHAR(7)) AS FLASH_CACHE,
    CAST(NULL AS CHAR(7)) AS CELL_FLASH_CACHE,
    CAST(NULL AS CHAR(3)) AS USER_STATS,
    CAST(NULL AS CHAR(3)) AS GLOBAL_STATS,
    CAST('NO' AS CHAR(3)) AS "INTERVAL",
    CAST(NULL AS CHAR(3)) AS SEGMENT_CREATED,
    CAST(NULL AS CHAR(6)) AS DOMIDX_OPSTATUS,
    CAST(NULL AS CHAR(1000)) AS PARAMETERS
    FROM OCEANBASE.__ALL_VIRTUAL_TABLE I
    JOIN OCEANBASE.__ALL_VIRTUAL_TABLE DT
    ON I.TENANT_ID = DT.TENANT_ID AND I.DATA_TABLE_ID = DT.TABLE_ID
    JOIN OCEANBASE.__ALL_VIRTUAL_DATABASE D
    ON I.TENANT_ID = D.TENANT_ID
       AND I.DATABASE_ID = D.DATABASE_ID
       AND I.TABLE_TYPE = 5
       AND I.TABLE_MODE >> 12 & 15 in (0,1)
       AND I.INDEX_ATTRIBUTES_SET & 16 = 0
    JOIN
    (SELECT P_PART.TENANT_ID,
            P_PART.TABLE_ID,
            P_PART.PART_NAME,
            P_PART.PARTITION_POSITION,
            S_PART.SUB_PART_NAME,
            S_PART.HIGH_BOUND_VAL,
            S_PART.LIST_VAL,
            S_PART.COMPRESS_FUNC_NAME,
            S_PART.SUBPARTITION_POSITION
     FROM (SELECT
             TENANT_ID,
             TABLE_ID,
             PART_ID,
             PART_NAME,
             PARTITION_TYPE,
             ROW_NUMBER() OVER (
               PARTITION BY TENANT_ID, TABLE_ID
               ORDER BY PART_IDX, PART_ID ASC
             ) AS PARTITION_POSITION
           FROM OCEANBASE.__ALL_VIRTUAL_PART) P_PART,
          (SELECT
             TENANT_ID,
             TABLE_ID,
             PART_ID,
             SUB_PART_NAME,
             HIGH_BOUND_VAL,
             LIST_VAL,
             COMPRESS_FUNC_NAME,
             PARTITION_TYPE,
             ROW_NUMBER() OVER (
               PARTITION BY TENANT_ID, TABLE_ID, PART_ID
               ORDER BY SUB_PART_IDX, SUB_PART_ID ASC
             ) AS SUBPARTITION_POSITION
           FROM OCEANBASE.__ALL_VIRTUAL_SUB_PART) S_PART
     WHERE P_PART.PART_ID = S_PART.PART_ID AND
           P_PART.TABLE_ID = S_PART.TABLE_ID
           AND P_PART.TENANT_ID = S_PART.TENANT_ID
           AND P_PART.PARTITION_TYPE = 0
           AND S_PART.PARTITION_TYPE = 0) PART
    ON I.TABLE_ID = PART.TABLE_ID AND I.TENANT_ID = PART.TENANT_ID
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'CDB_TAB_COL_STATISTICS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21203',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = False,
  view_definition = """
SELECT
  CON_ID,
  OWNER,
  TABLE_NAME,
  COLUMN_NAME,
  NUM_DISTINCT,
  LOW_VALUE,
  HIGH_VALUE,
  DENSITY,
  NUM_NULLS,
  NUM_BUCKETS,
  LAST_ANALYZED,
  SAMPLE_SIZE,
  GLOBAL_STATS,
  USER_STATS,
  NOTES,
  AVG_COL_LEN,
  HISTOGRAM,
  CAST(NULL AS CHAR(7)) SCOPE
FROM OCEANBASE.CDB_TAB_COLS_V$
  WHERE USER_GENERATED = 'YES'
""".replace("\n", " ")
)

# TODO:(yanmu.ztl)
# 1. sys package is not visible in user tenant.
# 2. tablespace/constraint are not supported yet.
# 3. sequence_object/synonym/context is only exist in oracle tenant.
def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_OBJECTS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21204',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      CAST(B.DATABASE_NAME AS CHAR(128)) AS OWNER,
      CAST(A.OBJECT_NAME AS CHAR(128)) AS OBJECT_NAME,
      CAST(A.SUBOBJECT_NAME AS CHAR(128)) AS SUBOBJECT_NAME,
      CAST(A.OBJECT_ID AS SIGNED) AS OBJECT_ID,
      CAST(A.DATA_OBJECT_ID AS SIGNED) AS DATA_OBJECT_ID,
      CAST(A.OBJECT_TYPE AS CHAR(23)) AS OBJECT_TYPE,
      CAST(A.GMT_CREATE AS DATETIME) AS CREATED,
      CAST(A.GMT_MODIFIED AS DATETIME) AS LAST_DDL_TIME,
      CAST(A.GMT_CREATE AS DATETIME) AS TIMESTAMP,
      CAST(A.STATUS AS CHAR(7)) AS STATUS,
      CAST(A.TEMPORARY AS CHAR(1)) AS TEMPORARY,
      CAST(A.`GENERATED` AS CHAR(1)) AS "GENERATED",
      CAST(A.SECONDARY AS CHAR(1)) AS SECONDARY,
      CAST(A.NAMESPACE AS SIGNED) AS NAMESPACE,
      CAST(A.EDITION_NAME AS CHAR(128)) AS EDITION_NAME,
      CAST(NULL AS CHAR(18)) AS SHARING,
      CAST(NULL AS CHAR(1)) AS EDITIONABLE,
      CAST(NULL AS CHAR(1)) AS ORACLE_MAINTAINED,
      CAST(NULL AS CHAR(1)) AS APPLICATION,
      CAST(NULL AS CHAR(1)) AS DEFAULT_COLLATION,
      CAST(NULL AS CHAR(1)) AS DUPLICATED,
      CAST(NULL AS CHAR(1)) AS SHARDED,
      CAST(NULL AS CHAR(1)) AS IMPORTED_OBJECT,
      CAST(NULL AS SIGNED) AS CREATED_APPID,
      CAST(NULL AS SIGNED) AS CREATED_VSNID,
      CAST(NULL AS SIGNED) AS MODIFIED_APPID,
      CAST(NULL AS SIGNED) AS MODIFIED_VSNID
    FROM (
      SELECT CAST(0 AS SIGNED) AS TENANT_ID,
             USEC_TO_TIME(B.SCHEMA_VERSION) AS GMT_CREATE,
             USEC_TO_TIME(A.SCHEMA_VERSION) AS GMT_MODIFIED,
             A.DATABASE_ID,
             A.TABLE_NAME AS OBJECT_NAME,
             NULL AS SUBOBJECT_NAME,
             CAST(A.TABLE_ID AS SIGNED) AS OBJECT_ID,
             A.TABLET_ID AS DATA_OBJECT_ID,
             'TABLE' AS OBJECT_TYPE,
             'VALID' AS STATUS,
             'N' AS TEMPORARY,
             'N' AS "GENERATED",
             'N' AS SECONDARY,
             0 AS NAMESPACE,
             NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE A
      JOIN OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE B
        ON A.TENANT_ID = B.TENANT_ID AND B.TABLE_NAME = '__all_core_table'
      WHERE A.TENANT_ID = EFFECTIVE_TENANT_ID()

      UNION ALL

      SELECT
      TENANT_ID
      ,GMT_CREATE
      ,GMT_MODIFIED
      ,DATABASE_ID
      ,CAST((CASE
             WHEN DATABASE_ID = 201004 THEN TABLE_NAME
             WHEN TABLE_TYPE = 5 THEN SUBSTR(TABLE_NAME, 7 + POSITION('_' IN SUBSTR(TABLE_NAME, 7)))
             ELSE TABLE_NAME END) AS CHAR(128)) AS OBJECT_NAME
      ,NULL SUBOBJECT_NAME
      ,CAST(TABLE_ID AS SIGNED) AS OBJECT_ID
      ,(CASE WHEN TABLET_ID != 0 THEN TABLET_ID ELSE NULL END) DATA_OBJECT_ID
      ,CASE WHEN TABLE_TYPE IN (0,3,6,8,9,14) THEN 'TABLE'
            WHEN TABLE_TYPE IN (2) THEN 'VIRTUAL TABLE'
            WHEN TABLE_TYPE IN (1,4) THEN 'VIEW'
            WHEN TABLE_TYPE IN (5) THEN 'INDEX'
            WHEN TABLE_TYPE IN (7) THEN 'MATERIALIZED VIEW'
            WHEN TABLE_TYPE IN (15) THEN 'MATERIALIZED VIEW LOG'
            ELSE NULL END AS OBJECT_TYPE
      ,CAST(CASE WHEN TABLE_TYPE IN (5,15) THEN CASE WHEN INDEX_STATUS = 2 THEN 'VALID'
              WHEN INDEX_STATUS = 3 THEN 'CHECKING'
              WHEN INDEX_STATUS = 4 THEN 'INELEGIBLE'
              WHEN INDEX_STATUS = 5 THEN 'ERROR'
              ELSE 'UNUSABLE' END
            ELSE  CASE WHEN OBJECT_STATUS = 1 THEN 'VALID' ELSE 'INVALID' END END AS CHAR(10)) AS STATUS
      ,CASE WHEN TABLE_TYPE IN (6,8,9) THEN 'Y'
          ELSE 'N' END AS TEMPORARY
      ,CASE WHEN TABLE_TYPE IN (0,1) THEN 'Y'
          ELSE 'N' END AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM
      OCEANBASE.__ALL_TABLE
      WHERE TENANT_ID = 0 AND TABLE_TYPE != 12 AND TABLE_TYPE != 13
        AND TABLE_MODE >> 12 & 15 in (0,1)
        AND INDEX_ATTRIBUTES_SET & 16 = 0

      UNION ALL

      SELECT
          CST.TENANT_ID
         ,CST.GMT_CREATE
         ,CST.GMT_MODIFIED
         ,DB.DATABASE_ID
         ,CST.constraint_name AS OBJECT_NAME
         ,NULL AS SUBOBJECT_NAME
         ,CAST(TBL.TABLE_ID AS SIGNED) AS OBJECT_ID
         ,NULL AS DATA_OBJECT_ID
         ,'INDEX' AS OBJECT_TYPE
         ,'VALID' AS STATUS
         ,'N' AS TEMPORARY
         ,'N' AS "GENERATED"
         ,'N' AS SECONDARY
         ,0 AS NAMESPACE
         ,NULL AS EDITION_NAME
         FROM OCEANBASE.__ALL_CONSTRAINT CST, OCEANBASE.__ALL_TABLE TBL, OCEANBASE.__ALL_DATABASE DB
         WHERE CST.TENANT_ID = 0 AND DB.DATABASE_ID = TBL.DATABASE_ID AND TBL.TABLE_ID = CST.TABLE_ID and CST.CONSTRAINT_TYPE = 1
          AND TBL.TABLE_MODE >> 12 & 15 in (0,1)
          AND TBL.INDEX_ATTRIBUTES_SET & 16 = 0

      UNION ALL

      SELECT
      P.TENANT_ID
      ,P.GMT_CREATE
      ,P.GMT_MODIFIED
      ,T.DATABASE_ID
      ,CAST((CASE
             WHEN T.DATABASE_ID = 201004 THEN T.TABLE_NAME
             WHEN T.TABLE_TYPE = 5 THEN SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7)))
             ELSE T.TABLE_NAME END) AS CHAR(128)) AS OBJECT_NAME
      ,P.PART_NAME SUBOBJECT_NAME
      ,P.PART_ID OBJECT_ID
      ,CASE WHEN P.TABLET_ID != 0 THEN P.TABLET_ID ELSE NULL END AS DATA_OBJECT_ID
      ,(CASE WHEN T.TABLE_TYPE = 5 THEN 'INDEX PARTITION' ELSE 'TABLE PARTITION' END) AS OBJECT_TYPE
      ,'VALID' AS STATUS
      ,'N' AS TEMPORARY
      , NULL AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_TABLE T JOIN OCEANBASE.__ALL_PART P ON T.TABLE_ID = P.TABLE_ID
      WHERE T.TENANT_ID = 0 AND T.TENANT_ID = P.TENANT_ID AND T.TABLE_MODE >> 12 & 15 in (0,1)
      AND P.PARTITION_TYPE = 0 AND T.INDEX_ATTRIBUTES_SET & 16 = 0

      UNION ALL

      SELECT
      SUBP.TENANT_ID
      ,SUBP.GMT_CREATE
      ,SUBP.GMT_MODIFIED
      ,T.DATABASE_ID
      ,CAST((CASE
             WHEN T.DATABASE_ID = 201004 THEN T.TABLE_NAME
             WHEN T.TABLE_TYPE = 5 THEN SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7)))
             ELSE T.TABLE_NAME END) AS CHAR(128)) AS OBJECT_NAME
      ,SUBP.SUB_PART_NAME SUBOBJECT_NAME
      ,SUBP.SUB_PART_ID OBJECT_ID
      ,SUBP.TABLET_ID AS DATA_OBJECT_ID
      ,(CASE WHEN T.TABLE_TYPE = 5 THEN 'INDEX SUBPARTITION' ELSE 'TABLE SUBPARTITION' END) AS OBJECT_TYPE
      ,'VALID' AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_TABLE T, OCEANBASE.__ALL_PART P,OCEANBASE.__ALL_SUB_PART SUBP
      WHERE T.TABLE_ID =P.TABLE_ID AND P.TABLE_ID=SUBP.TABLE_ID AND P.PART_ID =SUBP.PART_ID
      AND T.TENANT_ID = 0 AND T.TENANT_ID = P.TENANT_ID AND P.TENANT_ID = SUBP.TENANT_ID AND T.TABLE_MODE >> 12 & 15 in (0,1)
      AND SUBP.PARTITION_TYPE = 0 AND P.PARTITION_TYPE = 0 AND T.INDEX_ATTRIBUTES_SET & 16 = 0

      UNION ALL

      SELECT
      P.TENANT_ID
      ,P.GMT_CREATE
      ,P.GMT_MODIFIED
      ,P.DATABASE_ID
      ,P.PACKAGE_NAME AS OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,CAST(P.PACKAGE_ID AS SIGNED) AS OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,CASE WHEN TYPE = 1 THEN 'PACKAGE'
            WHEN TYPE = 2 THEN 'PACKAGE BODY'
            ELSE NULL END AS OBJECT_TYPE
      ,CASE WHEN EXISTS
                  (SELECT OBJ_ID FROM OCEANBASE.__ALL_TENANT_ERROR E
                    WHERE P.TENANT_ID = E.TENANT_ID AND P.PACKAGE_ID = E.OBJ_ID AND (E.OBJ_TYPE = 3 OR E.OBJ_TYPE = 5))
                 THEN 'INVALID'
            WHEN TYPE = 2 AND EXISTS
                  (SELECT OBJ_ID FROM OCEANBASE.__ALL_TENANT_ERROR Eb
                    WHERE OBJ_ID IN
                            (SELECT PACKAGE_ID FROM OCEANBASE.__ALL_PACKAGE Pb
                              WHERE Pb.PACKAGE_NAME = P.PACKAGE_NAME AND Pb.DATABASE_ID = P.DATABASE_ID AND Pb.TENANT_ID = P.TENANT_ID AND TYPE = 1)
                          AND Eb.OBJ_TYPE = 3)
              THEN 'INVALID'
            ELSE 'VALID' END AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_PACKAGE P
      WHERE P.TENANT_ID = 0

      UNION ALL

      SELECT
      R.TENANT_ID
      ,R.GMT_CREATE
      ,R.GMT_MODIFIED
      ,R.DATABASE_ID
      ,R.ROUTINE_NAME AS OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,CAST(R.ROUTINE_ID AS SIGNED) AS OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,CASE WHEN ROUTINE_TYPE = 1 THEN 'PROCEDURE'
            WHEN ROUTINE_TYPE = 2 THEN 'FUNCTION'
            ELSE NULL END AS OBJECT_TYPE
      ,CASE WHEN EXISTS
                  (SELECT OBJ_ID FROM OCEANBASE.__ALL_TENANT_ERROR E
                    WHERE R.TENANT_ID = E.TENANT_ID AND R.ROUTINE_ID = E.OBJ_ID AND (E.OBJ_TYPE = 9 OR E.OBJ_TYPE = 12))
                 THEN 'INVALID'
            ELSE 'VALID' END AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_ROUTINE R
      WHERE (ROUTINE_TYPE = 1 OR ROUTINE_TYPE = 2) AND R.TENANT_ID = 0

      UNION ALL

      SELECT
      TENANT_ID
      ,GMT_CREATE
      ,GMT_MODIFIED
      ,DATABASE_ID
      ,TYPE_NAME AS OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,CAST(TYPE_ID AS SIGNED) AS OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,'TYPE' AS OBJECT_TYPE
      ,'VALID' AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_TYPE
      WHERE TENANT_ID = 0

      UNION ALL

      SELECT
      TENANT_ID
      ,GMT_CREATE
      ,GMT_MODIFIED
      ,DATABASE_ID
      ,OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,CAST(OBJECT_TYPE_ID AS SIGNED) AS OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,'TYPE BODY' AS OBJECT_TYPE
      ,'VALID' AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_TENANT_OBJECT_TYPE
      WHERE TENANT_ID = 0 AND TYPE = 2

      UNION ALL

      SELECT
      TENANT_ID
      ,T.GMT_CREATE
      ,T.GMT_MODIFIED
      ,T.DATABASE_ID
      ,T.TRIGGER_NAME AS OBJECT_NAME
      ,NULL AS SUBOBJECT_NAME
      ,CAST(T.TRIGGER_ID AS SIGNED) AS OBJECT_ID
      ,NULL AS DATA_OBJECT_ID
      ,'TRIGGER' OBJECT_TYPE
      ,CASE WHEN EXISTS
                  (SELECT OBJ_ID FROM OCEANBASE.__ALL_TENANT_ERROR E
                    WHERE T.TENANT_ID = E.TENANT_ID AND T.TRIGGER_ID = E.OBJ_ID AND (E.OBJ_TYPE = 7))
                 THEN 'INVALID'
            ELSE 'VALID' END AS STATUS
      ,'N' AS TEMPORARY
      ,'N' AS "GENERATED"
      ,'N' AS SECONDARY
      , 0 AS NAMESPACE
      ,NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_TENANT_TRIGGER T
      WHERE T.TENANT_ID = 0

      UNION ALL

      SELECT
        TENANT_ID,
        GMT_CREATE,
        GMT_MODIFIED,
        DATABASE_ID,
        DATABASE_NAME AS OBJECT_NAME,
        NULL AS SUBOBJECT_NAME,
        CAST(DATABASE_ID AS SIGNED) AS OBJECT_ID,
        NULL AS DATA_OBJECT_ID,
        'DATABASE' AS OBJECT_TYPE,
        'VALID' AS STATUS,
        'N' AS TEMPORARY,
        'N' AS "GENERATED",
        'N' AS SECONDARY,
        0 AS NAMESPACE,
        NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_DATABASE
      WHERE TENANT_ID = 0

      UNION ALL

      SELECT
        TENANT_ID,
        GMT_CREATE,
        GMT_MODIFIED,
        CAST(201001 AS SIGNED) AS DATABASE_ID,
        TABLEGROUP_NAME AS OBJECT_NAME,
        NULL AS SUBOBJECT_NAME,
        CAST(TABLEGROUP_ID AS SIGNED) AS OBJECT_ID,
        NULL AS DATA_OBJECT_ID,
        'TABLEGROUP' AS OBJECT_TYPE,
        'VALID' AS STATUS,
        'N' AS TEMPORARY,
        'N' AS "GENERATED",
        'N' AS SECONDARY,
        0 AS NAMESPACE,
        NULL AS EDITION_NAME
      FROM OCEANBASE.__ALL_TABLEGROUP
      WHERE TENANT_ID = 0
    ) A
    JOIN OCEANBASE.__ALL_DATABASE B
    ON A.TENANT_ID = B.TENANT_ID
       AND A.DATABASE_ID = B.DATABASE_ID
       AND B.TENANT_ID = 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_PART_TABLES',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21205',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  SELECT CAST(DB.DATABASE_NAME AS CHAR(128)) OWNER,
         CAST(TB.NEW_TABLE_NAME AS CHAR(128)) TABLE_NAME,
         CAST((CASE TB.PART_FUNC_TYPE
              WHEN 0 THEN 'HASH'
              WHEN 1 THEN 'KEY'
              WHEN 2 THEN 'KEY'
              WHEN 3 THEN 'RANGE'
              WHEN 4 THEN 'RANGE COLUMNS'
              WHEN 5 THEN 'LIST'
              WHEN 6 THEN 'LIST COLUMNS'
              WHEN 7 THEN 'RANGE' END)
              AS CHAR(13)) PARTITIONING_TYPE,
         CAST((CASE TB.PART_LEVEL
               WHEN 1 THEN 'NONE'
               WHEN 2 THEN
               (CASE TB.SUB_PART_FUNC_TYPE
                WHEN 0 THEN 'HASH'
                WHEN 1 THEN 'KEY'
                WHEN 2 THEN 'KEY'
                WHEN 3 THEN 'RANGE'
                WHEN 4 THEN 'RANGE COLUMNS'
                WHEN 5 THEN 'LIST'
                WHEN 6 THEN 'LIST COLUMNS'
                WHEN 7 THEN 'RANGE' END) END)
              AS CHAR(13)) SUBPARTITIONING_TYPE,
         CAST((CASE TB.PART_FUNC_TYPE
               WHEN 7 THEN 1048575
               ELSE TB.PART_NUM END) AS SIGNED) PARTITION_COUNT,
         CAST ((CASE TB.PART_LEVEL
                WHEN 1 THEN 0
                WHEN 2 THEN (CASE WHEN TB.SUB_PART_TEMPLATE_FLAGS > 0 THEN TB.SUB_PART_NUM ELSE 1 END)
                END) AS SIGNED) DEF_SUBPARTITION_COUNT,
         CAST(PART_INFO.PART_KEY_COUNT AS SIGNED) PARTITIONING_KEY_COUNT,
         CAST((CASE TB.PART_LEVEL
              WHEN 1 THEN 0
              WHEN 2 THEN PART_INFO.SUBPART_KEY_COUNT END)
              AS SIGNED) SUBPARTITIONING_KEY_COUNT,
         CAST(NULL AS CHAR(8)) STATUS,
         CAST(TP.TABLESPACE_NAME AS CHAR(30)) DEF_TABLESPACE_NAME,
         CAST(NULL AS SIGNED) DEF_PCT_FREE,
         CAST(NULL AS SIGNED) DEF_PCT_USED,
         CAST(NULL AS SIGNED) DEF_INI_TRANS,
         CAST(NULL AS SIGNED) DEF_MAX_TRANS,
         CAST(NULL AS CHAR(40)) DEF_INITIAL_EXTENT,
         CAST(NULL AS CHAR(40)) DEF_NEXT_EXTENT,
         CAST(NULL AS CHAR(40)) DEF_MIN_EXTENTS,
         CAST(NULL AS CHAR(40)) DEF_MAX_EXTENTS,
         CAST(NULL AS CHAR(40)) DEF_MAX_SIZE,
         CAST(NULL AS CHAR(40)) DEF_PCT_INCREASE,
         CAST(NULL AS SIGNED) DEF_FREELISTS,
         CAST(NULL AS SIGNED) DEF_FREELIST_GROUPS,
         CAST(NULL AS CHAR(7)) DEF_LOGGING,
         CAST(CASE WHEN TB.COMPRESS_FUNC_NAME IS NULL THEN 'DISABLED'
              ELSE 'ENABLED' END AS CHAR(8)) DEF_COMPRESSION,
         CAST(TB.COMPRESS_FUNC_NAME AS CHAR(12)) DEF_COMPRESS_FOR,
         CAST(NULL AS CHAR(7)) DEF_BUFFER_POOL,
         CAST(NULL AS CHAR(7)) DEF_FLASH_CACHE,
         CAST(NULL AS CHAR(7)) DEF_CELL_FLASH_CACHE,
         CAST(NULL AS CHAR(30)) REF_PTN_CONSTRAINT_NAME,
         CAST(TB.INTERVAL_RANGE AS CHAR(1000)) "INTERVAL",
         CAST('NO' AS CHAR(3)) AUTOLIST,
         CAST(NULL AS CHAR(1000)) INTERVAL_SUBPARTITION,
         CAST('NO' AS CHAR(3)) AUTOLIST_SUBPARTITION,
         CAST(NULL AS CHAR(3)) IS_NESTED,
         CAST(NULL AS CHAR(4)) DEF_SEGMENT_CREATED,
         CAST(NULL AS CHAR(3)) DEF_INDEXING,
         CAST(NULL AS CHAR(8)) DEF_INMEMORY,
         CAST(NULL AS CHAR(8)) DEF_INMEMORY_PRIORITY,
         CAST(NULL AS CHAR(15)) DEF_INMEMORY_DISTRIBUTE,
         CAST(NULL AS CHAR(17)) DEF_INMEMORY_COMPRESSION,
         CAST(NULL AS CHAR(13)) DEF_INMEMORY_DUPLICATE,
         CAST(NULL AS CHAR(3)) DEF_READ_ONLY,
         CAST(NULL AS CHAR(24)) DEF_CELLMEMORY,
         CAST(NULL AS CHAR(12)) DEF_INMEMORY_SERVICE,
         CAST(NULL AS CHAR(1000)) DEF_INMEMORY_SERVICE_NAME,
         CAST('NO' AS CHAR(3)) AUTO
      FROM
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			)) TB
      JOIN OCEANBASE.__ALL_DATABASE DB
      ON TB.TENANT_ID = DB.TENANT_ID AND TB.DATABASE_ID = DB.DATABASE_ID
      JOIN
        (SELECT
         TENANT_ID,
         TABLE_ID,
         SUM(CASE WHEN (PARTITION_KEY_POSITION & 255) > 0 THEN 1 ELSE 0 END) AS PART_KEY_COUNT,
         SUM(CASE WHEN (PARTITION_KEY_POSITION & 65280) > 0 THEN 1 ELSE 0 END) AS SUBPART_KEY_COUNT
         FROM OCEANBASE.__ALL_COLUMN
         WHERE PARTITION_KEY_POSITION > 0
         GROUP BY TENANT_ID, TABLE_ID) PART_INFO
      ON TB.TENANT_ID = PART_INFO.TENANT_ID AND TB.TABLE_ID = PART_INFO.TABLE_ID
      LEFT JOIN OCEANBASE.__ALL_TENANT_TABLESPACE TP
      ON TB.TENANT_ID = TP.TENANT_ID AND TP.TABLESPACE_ID = TB.TABLESPACE_ID
      WHERE TB.TENANT_ID = 0
            AND TB.TABLE_TYPE IN (3, 6)
            AND TB.PART_LEVEL != 0
            AND TB.TABLE_MODE >> 12 & 15 in (0,1)
            AND TB.INDEX_ATTRIBUTES_SET & 16 = 0
  """.replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_PART_KEY_COLUMNS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21206',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT  CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(T.TABLE_NAME AS CHAR(128)) AS NAME,
            CAST('TABLE' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 255) AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_COLUMN C, OCEANBASE.__ALL_TABLE T, OCEANBASE.__ALL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND C.TABLE_ID = T.TABLE_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND (C.PARTITION_KEY_POSITION & 255) > 0
          AND T.TABLE_TYPE IN (3, 6)
          AND T.TABLE_MODE >> 12 & 15 in (0,1)
          AND T.INDEX_ATTRIBUTES_SET & 16 = 0
          AND C.TENANT_ID = 0
    UNION
    SELECT  CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(CASE WHEN D.DATABASE_NAME = '__recyclebin' THEN T.TABLE_NAME
                ELSE SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7))) END AS CHAR(128)) AS NAME,
            CAST('INDEX' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 255) AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_COLUMN C, OCEANBASE.__ALL_TABLE T, OCEANBASE.__ALL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND C.TABLE_ID = T.TABLE_ID
          AND T.TABLE_TYPE = 5
          AND T.INDEX_TYPE NOT IN (17,19,20,22)
          AND (C.PARTITION_KEY_POSITION & 255) > 0
          AND C.TENANT_ID = 0
    UNION
    SELECT  CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(CASE WHEN D.DATABASE_NAME =  '__recyclebin' THEN T.TABLE_NAME
                ELSE SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7))) END AS CHAR(128)) AS NAME,
            CAST('INDEX' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 255) AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_COLUMN C, OCEANBASE.__ALL_TABLE T, OCEANBASE.__ALL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND C.TABLE_ID = T.DATA_TABLE_ID
          AND T.TABLE_TYPE = 5
          AND T.INDEX_TYPE IN (1,2,10,15,23,24,41)
          AND (C.PARTITION_KEY_POSITION & 255) > 0
          AND C.TENANT_ID = 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_SUBPART_KEY_COLUMNS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21207',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT  CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(T.TABLE_NAME AS CHAR(128)) AS NAME,
            CAST('TABLE' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 65280)/256 AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_COLUMN C, OCEANBASE.__ALL_TABLE T, OCEANBASE.__ALL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND C.TABLE_ID = T.TABLE_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND (C.PARTITION_KEY_POSITION & 65280) > 0
          AND T.TABLE_TYPE IN (3, 6)
          AND T.TABLE_MODE >> 12 & 15 in (0,1)
          AND T.INDEX_ATTRIBUTES_SET & 16 = 0
          AND C.TENANT_ID = 0
    UNION
    SELECT  CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(CASE WHEN D.DATABASE_NAME = '__recyclebin' THEN T.TABLE_NAME
                ELSE SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7))) END AS CHAR(128)) AS NAME,
            CAST('INDEX' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 65280)/256 AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_COLUMN C, OCEANBASE.__ALL_TABLE T, OCEANBASE.__ALL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND C.TABLE_ID = T.TABLE_ID
          AND T.TABLE_TYPE = 5
          AND T.INDEX_TYPE NOT IN (17,19,20,22)
          AND (C.PARTITION_KEY_POSITION & 65280) > 0
          AND C.TENANT_ID = 0
    UNION
    SELECT  CAST(D.DATABASE_NAME AS CHAR(128)) AS OWNER,
            CAST(CASE WHEN D.DATABASE_NAME =  '__recyclebin' THEN T.TABLE_NAME
                ELSE SUBSTR(T.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(T.TABLE_NAME, 7))) END AS CHAR(128)) AS NAME,
            CAST('INDEX' AS CHAR(5)) AS OBJECT_TYPE,
            CAST(C.COLUMN_NAME AS CHAR(4000)) AS COLUMN_NAME,
            CAST((C.PARTITION_KEY_POSITION & 65280)/256 AS SIGNED) AS COLUMN_POSITION,
            CAST(NULL AS SIGNED) AS COLLATED_COLUMN_ID
    FROM OCEANBASE.__ALL_COLUMN C, OCEANBASE.__ALL_TABLE T, OCEANBASE.__ALL_DATABASE D
    WHERE C.TENANT_ID = T.TENANT_ID
          AND T.TENANT_ID = D.TENANT_ID
          AND T.DATABASE_ID = D.DATABASE_ID
          AND C.TABLE_ID = T.DATA_TABLE_ID
          AND T.TABLE_TYPE = 5
          AND T.INDEX_TYPE IN (1,2,10,15,23,24,41)
          AND (C.PARTITION_KEY_POSITION & 65280) > 0
          AND C.TENANT_ID = 0
""".replace("\n", " ")
)

def_table_schema(
  owner = 'yanmu.ztl',
  table_name      = 'DBA_TAB_PARTITIONS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21208',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  SELECT
      CAST(DB_TB.DATABASE_NAME AS CHAR(128)) TABLE_OWNER,
      CAST(DB_TB.TABLE_NAME AS CHAR(128)) TABLE_NAME,

      CAST(CASE DB_TB.PART_LEVEL
           WHEN 2 THEN 'YES'
           ELSE 'NO' END AS CHAR(3)) COMPOSITE,

      CAST(PART.PART_NAME AS CHAR(128)) PARTITION_NAME,

      CAST(CASE DB_TB.PART_LEVEL
           WHEN 2 THEN PART.SUB_PART_NUM
           ELSE 0 END AS SIGNED)  SUBPARTITION_COUNT,

      CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN PART.HIGH_BOUND_VAL
           ELSE PART.LIST_VAL END AS CHAR(262144)) HIGH_VALUE,

      CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN length(PART.HIGH_BOUND_VAL)
           ELSE length(PART.LIST_VAL) END AS SIGNED) HIGH_VALUE_LENGTH,

      CAST(PART.PARTITION_POSITION AS SIGNED) PARTITION_POSITION,
      CAST(TP.TABLESPACE_NAME AS CHAR(30)) TABLESPACE_NAME,
      CAST(NULL AS SIGNED) PCT_FREE,
      CAST(NULL AS SIGNED) PCT_USED,
      CAST(NULL AS SIGNED) INI_TRANS,
      CAST(NULL AS SIGNED) MAX_TRANS,
      CAST(NULL AS SIGNED) INITIAL_EXTENT,
      CAST(NULL AS SIGNED) NEXT_EXTENT,
      CAST(NULL AS SIGNED) MIN_EXTENT,
      CAST(NULL AS SIGNED) MAX_EXTENT,
      CAST(NULL AS SIGNED) MAX_SIZE,
      CAST(NULL AS SIGNED) PCT_INCREASE,
      CAST(NULL AS SIGNED) FREELISTS,
      CAST(NULL AS SIGNED) FREELIST_GROUPS,
      CAST(NULL AS CHAR(7)) LOGGING,

      CAST(CASE WHEN PART.COMPRESS_FUNC_NAME IS NULL THEN 'DISABLED'
           ELSE 'ENABLED' END AS CHAR(8)) COMPRESSION,

      CAST(PART.COMPRESS_FUNC_NAME AS CHAR(30)) COMPRESS_FOR,
      CAST(NULL AS SIGNED) NUM_ROWS,
      CAST(NULL AS SIGNED) BLOCKS,
      CAST(NULL AS SIGNED) EMPTY_BLOCKS,
      CAST(NULL AS SIGNED) AVG_SPACE,
      CAST(NULL AS SIGNED) CHAIN_CNT,
      CAST(NULL AS SIGNED) AVG_ROW_LEN,
      CAST(NULL AS SIGNED) SAMPLE_SIZE,
      CAST(NULL AS DATE) LAST_ANALYZED,
      CAST(NULL AS CHAR(7)) BUFFER_POOL,
      CAST(NULL AS CHAR(7)) FLASH_CACHE,
      CAST(NULL AS CHAR(7)) CELL_FLASH_CACHE,
      CAST(NULL AS CHAR(3)) GLOBAL_STATS,
      CAST(NULL AS CHAR(3)) USER_STATS,
      CAST(NULL AS CHAR(3)) IS_NESTED,
      CAST(NULL AS CHAR(128)) PARENT_TABLE_PARTITION,

      CAST (CASE WHEN PART.PARTITION_POSITION >
            MAX (CASE WHEN PART.HIGH_BOUND_VAL = DB_TB.B_TRANSITION_POINT
                 THEN PART.PARTITION_POSITION ELSE NULL END)
            OVER(PARTITION BY DB_TB.TABLE_ID)
            THEN 'YES' ELSE 'NO' END AS CHAR(3)) "INTERVAL",

      CAST(NULL AS CHAR(4)) SEGMENT_CREATED,
      CAST(NULL AS CHAR(4)) INDEXING,
      CAST(NULL AS CHAR(4)) READ_ONLY,
      CAST(NULL AS CHAR(8)) INMEMORY,
      CAST(NULL AS CHAR(8)) INMEMORY_PRIORITY,
      CAST(NULL AS CHAR(15)) INMEMORY_DISTRIBUTE,
      CAST(NULL AS CHAR(17)) INMEMORY_COMPRESSION,
      CAST(NULL AS CHAR(13)) INMEMORY_DUPLICATE,
      CAST(NULL AS CHAR(24)) CELLMEMORY,
      CAST(NULL AS CHAR(12)) INMEMORY_SERVICE,
      CAST(NULL AS CHAR(100)) INMEMORY_SERVICE_NAME,
      CAST(NULL AS CHAR(8)) MEMOPTIMIZE_READ,
      CAST(NULL AS CHAR(8)) MEMOPTIMIZE_WRITE

      FROM (SELECT DB.TENANT_ID,
                   DB.DATABASE_NAME,
                   DB.DATABASE_ID,
                   TB.TABLE_ID,
                   TB.NEW_TABLE_NAME AS TABLE_NAME,
                   TB.B_TRANSITION_POINT,
                   TB.PART_LEVEL
            FROM
			      ((
			          SELECT
			              mv_table.table_name AS new_table_name,
			              container_table.*
			          FROM
			              oceanbase.__all_table AS mv_table,
			              (
			                  SELECT * FROM
			                      oceanbase.__all_table
			                  WHERE
			                      (table_mode & 1 << 24) = 1 << 24
			              ) AS container_table
			          WHERE
			              mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
			      )

			      UNION ALL

			      (
			          SELECT
			              table_name as new_table_name,
			              *
			          FROM
			              oceanbase.__all_table
			          WHERE
			              (table_mode & 1 << 24) = 0
			      )) TB,
                 OCEANBASE.__ALL_DATABASE DB
            WHERE TB.DATABASE_ID = DB.DATABASE_ID
              AND TB.TENANT_ID = DB.TENANT_ID
              AND TB.TABLE_TYPE in (3, 6)
              AND TB.TABLE_MODE >> 12 & 15 in (0,1)
              AND TB.INDEX_ATTRIBUTES_SET & 16 = 0
           ) DB_TB
      JOIN (SELECT TENANT_ID,
                   TABLE_ID,
                   PART_NAME,
                   SUB_PART_NUM,
                   HIGH_BOUND_VAL,
                   LIST_VAL,
                   COMPRESS_FUNC_NAME,
                   TABLESPACE_ID,
                   PARTITION_TYPE,
                   ROW_NUMBER() OVER (
                     PARTITION BY TENANT_ID, TABLE_ID
                     ORDER BY PART_IDX, PART_ID ASC
                   ) PARTITION_POSITION
            FROM OCEANBASE.__ALL_PART) PART
      ON DB_TB.TABLE_ID = PART.TABLE_ID AND PART.TENANT_ID = DB_TB.TENANT_ID

      LEFT JOIN OCEANBASE.__ALL_TENANT_TABLESPACE TP
      ON TP.TABLESPACE_ID = PART.TABLESPACE_ID AND TP.TENANT_ID = PART.TENANT_ID

      WHERE DB_TB.TENANT_ID = 0
            AND PART.PARTITION_TYPE = 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_TAB_SUBPARTITIONS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21209',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  SELECT
      CAST(DB_TB.DATABASE_NAME AS CHAR(128)) TABLE_OWNER,
      CAST(DB_TB.TABLE_NAME AS CHAR(128)) TABLE_NAME,
      CAST(PART.PART_NAME AS CHAR(128)) PARTITION_NAME,
      CAST(PART.SUB_PART_NAME AS CHAR(128))  SUBPARTITION_NAME,
      CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN PART.HIGH_BOUND_VAL
           ELSE PART.LIST_VAL END AS CHAR(262144)) HIGH_VALUE,
      CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN length(PART.HIGH_BOUND_VAL)
           ELSE length(PART.LIST_VAL) END AS SIGNED) HIGH_VALUE_LENGTH,
      CAST(PART.PARTITION_POSITION AS SIGNED) PARTITION_POSITION,
      CAST(PART.SUBPARTITION_POSITION AS SIGNED) SUBPARTITION_POSITION,
      CAST(TP.TABLESPACE_NAME AS CHAR(30)) TABLESPACE_NAME,
      CAST(NULL AS SIGNED) PCT_FREE,
      CAST(NULL AS SIGNED) PCT_USED,
      CAST(NULL AS SIGNED) INI_TRANS,
      CAST(NULL AS SIGNED) MAX_TRANS,
      CAST(NULL AS SIGNED) INITIAL_EXTENT,
      CAST(NULL AS SIGNED) NEXT_EXTENT,
      CAST(NULL AS SIGNED) MIN_EXTENT,
      CAST(NULL AS SIGNED) MAX_EXTENT,
      CAST(NULL AS SIGNED) MAX_SIZE,
      CAST(NULL AS SIGNED) PCT_INCREASE,
      CAST(NULL AS SIGNED) FREELISTS,
      CAST(NULL AS SIGNED) FREELIST_GROUPS,
      CAST(NULL AS CHAR(3)) LOGGING,
      CAST(CASE WHEN
      PART.COMPRESS_FUNC_NAME IS NULL THEN
      'DISABLED' ELSE 'ENABLED' END AS CHAR(8)) COMPRESSION,
      CAST(PART.COMPRESS_FUNC_NAME AS CHAR(30)) COMPRESS_FOR,
      CAST(NULL AS SIGNED) NUM_ROWS,
      CAST(NULL AS SIGNED) BLOCKS,
      CAST(NULL AS SIGNED) EMPTY_BLOCKS,
      CAST(NULL AS SIGNED) AVG_SPACE,
      CAST(NULL AS SIGNED) CHAIN_CNT,
      CAST(NULL AS SIGNED) AVG_ROW_LEN,
      CAST(NULL AS SIGNED) SAMPLE_SIZE,
      CAST(NULL AS DATE) LAST_ANALYZED,
      CAST(NULL AS CHAR(7)) BUFFER_POOL,
      CAST(NULL AS CHAR(7)) FLASH_CACHE,
      CAST(NULL AS CHAR(7)) CELL_FLASH_CACHE,
      CAST(NULL AS CHAR(3)) GLOBAL_STATS,
      CAST(NULL AS CHAR(3)) USER_STATS,
      CAST('NO' AS CHAR(3)) "INTERVAL",
      CAST(NULL AS CHAR(3)) SEGMENT_CREATED,
      CAST(NULL AS CHAR(3)) INDEXING,
      CAST(NULL AS CHAR(3)) READ_ONLY,
      CAST(NULL AS CHAR(8)) INMEMORY,
      CAST(NULL AS CHAR(8)) INMEMORY_PRIORITY,
      CAST(NULL AS CHAR(15)) INMEMORY_DISTRIBUTE,
      CAST(NULL AS CHAR(17)) INMEMORY_COMPRESSION,
      CAST(NULL AS CHAR(13)) INMEMORY_DUPLICATE,
      CAST(NULL AS CHAR(12)) INMEMORY_SERVICE,
      CAST(NULL AS CHAR(1000)) INMEMORY_SERVICE_NAME,
      CAST(NULL AS CHAR(24)) CELLMEMORY,
      CAST(NULL AS CHAR(8)) MEMOPTIMIZE_READ,
      CAST(NULL AS CHAR(8)) MEMOPTIMIZE_WRITE
      FROM
      (SELECT DB.TENANT_ID,
              DB.DATABASE_NAME,
              DB.DATABASE_ID,
              TB.TABLE_ID,
              TB.NEW_TABLE_NAME AS TABLE_NAME
       FROM
			 ((
			     SELECT
			         mv_table.table_name AS new_table_name,
			         container_table.*
			     FROM
			         oceanbase.__all_table AS mv_table,
			         (
			             SELECT * FROM
			                 oceanbase.__all_table
			             WHERE
			                 (table_mode & 1 << 24) = 1 << 24
			         ) AS container_table
			     WHERE
			         mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
			 )

			 UNION ALL

			 (
			     SELECT
			         table_name as new_table_name,
			         *
			     FROM
			         oceanbase.__all_table
			     WHERE
			         (table_mode & 1 << 24) = 0
			 )) TB,
             OCEANBASE.__ALL_DATABASE DB
       WHERE TB.DATABASE_ID = DB.DATABASE_ID
         AND TB.TABLE_MODE >> 12 & 15 in (0,1)
         AND TB.INDEX_ATTRIBUTES_SET & 16 = 0
         AND TB.TENANT_ID = DB.TENANT_ID
         AND TB.TABLE_TYPE IN (3, 6)) DB_TB
      JOIN
      (SELECT P_PART.TENANT_ID,
              P_PART.TABLE_ID,
              P_PART.PART_NAME,
              P_PART.PARTITION_POSITION,
              S_PART.SUB_PART_NAME,
              S_PART.HIGH_BOUND_VAL,
              S_PART.LIST_VAL,
              S_PART.COMPRESS_FUNC_NAME,
              S_PART.TABLESPACE_ID,
              S_PART.SUBPARTITION_POSITION
       FROM (SELECT
               TENANT_ID,
               TABLE_ID,
               PART_ID,
               PART_NAME,
               PARTITION_TYPE,
               ROW_NUMBER() OVER (
                 PARTITION BY TENANT_ID, TABLE_ID
                 ORDER BY PART_IDX, PART_ID ASC
               ) AS PARTITION_POSITION
             FROM OCEANBASE.__ALL_PART) P_PART,
            (SELECT
               TENANT_ID,
               TABLE_ID,
               PART_ID,
               SUB_PART_NAME,
               HIGH_BOUND_VAL,
               LIST_VAL,
               COMPRESS_FUNC_NAME,
               TABLESPACE_ID,
               PARTITION_TYPE,
               ROW_NUMBER() OVER (
                 PARTITION BY TENANT_ID, TABLE_ID, PART_ID
                 ORDER BY SUB_PART_IDX, SUB_PART_ID ASC
               ) AS SUBPARTITION_POSITION
             FROM OCEANBASE.__ALL_SUB_PART) S_PART
       WHERE P_PART.PART_ID = S_PART.PART_ID AND
             P_PART.TABLE_ID = S_PART.TABLE_ID
             AND P_PART.TENANT_ID = S_PART.TENANT_ID
             AND P_PART.PARTITION_TYPE = 0
             AND S_PART.PARTITION_TYPE = 0) PART
      ON DB_TB.TABLE_ID = PART.TABLE_ID AND DB_TB.TENANT_ID = PART.TENANT_ID

      LEFT JOIN
        OCEANBASE.__ALL_TENANT_TABLESPACE TP
      ON TP.TABLESPACE_ID = PART.TABLESPACE_ID AND TP.TENANT_ID = PART.TENANT_ID

      WHERE DB_TB.TENANT_ID = 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_SUBPARTITION_TEMPLATES',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21210',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  SELECT
      CAST(DB.DATABASE_NAME AS CHAR(128)) USER_NAME,
      CAST(TB.TABLE_NAME AS CHAR(128)) TABLE_NAME,
      CAST(SP.SUB_PART_NAME AS CHAR(132)) SUBPARTITION_NAME,
      CAST(SP.SUB_PART_ID + 1 AS SIGNED) SUBPARTITION_POSITION,
      CAST(TP.TABLESPACE_NAME AS CHAR(30)) TABLESPACE_NAME,
      CAST(CASE WHEN SP.HIGH_BOUND_VAL IS NULL THEN SP.LIST_VAL
           ELSE SP.HIGH_BOUND_VAL END AS CHAR(262144)) HIGH_BOUND,
      CAST(NULL AS CHAR(4)) COMPRESSION,
      CAST(NULL AS CHAR(4)) INDEXING,
      CAST(NULL AS CHAR(4)) READ_ONLY

      FROM OCEANBASE.__ALL_DATABASE DB

      JOIN OCEANBASE.__ALL_TABLE TB
      ON DB.DATABASE_ID = TB.DATABASE_ID AND DB.TENANT_ID = TB.TENANT_ID
         AND TB.TABLE_TYPE IN (3, 6)
         AND TB.TABLE_MODE >> 12 & 15 in (0,1)
         AND TB.INDEX_ATTRIBUTES_SET & 16 = 0

      JOIN OCEANBASE.__ALL_DEF_SUB_PART SP
      ON TB.TABLE_ID = SP.TABLE_ID AND SP.TENANT_ID = TB.TENANT_ID

      LEFT JOIN OCEANBASE.__ALL_TENANT_TABLESPACE TP
      ON TP.TABLESPACE_ID = SP.TABLESPACE_ID AND TP.TENANT_ID = SP.TENANT_ID

      WHERE DB.TENANT_ID = 0
      """.replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_PART_INDEXES',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21211',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition =
    """
SELECT
CAST(I_T.OWNER AS CHAR(128)) AS OWNER,
CAST(I_T.INDEX_NAME AS CHAR(128)) AS INDEX_NAME,
CAST(I_T.TABLE_NAME AS CHAR(128)) AS TABLE_NAME,

CAST(CASE I_T.PART_FUNC_TYPE
     WHEN 0 THEN 'HASH'
     WHEN 1 THEN 'KEY'
     WHEN 2 THEN 'KEY'
     WHEN 3 THEN 'RANGE'
     WHEN 4 THEN 'RANGE COLUMNS'
     WHEN 5 THEN 'LIST'
     WHEN 6 THEN 'LIST COLUMNS'
     WHEN 7 THEN 'RANGE' END AS CHAR(13)) AS PARTITIONING_TYPE,

CAST(CASE WHEN I_T.PART_LEVEL < 2 THEN 'NONE'
     ELSE (CASE I_T.SUB_PART_FUNC_TYPE
           WHEN 0 THEN 'HASH'
           WHEN 1 THEN 'KEY'
           WHEN 2 THEN 'KEY'
           WHEN 3 THEN 'RANGE'
           WHEN 4 THEN 'RANGE COLUMNS'
           WHEN 5 THEN 'LIST'
           WHEN 6 THEN 'LIST COLUMNS'
           WHEN 7 THEN 'RANGE' END)
     END AS CHAR(13)) AS SUBPARTITIONING_TYPE,

CAST(I_T.PART_NUM AS SIGNED) AS PARTITION_COUNT,

CAST(CASE WHEN (I_T.PART_LEVEL < 2 OR I_T.SUB_PART_TEMPLATE_FLAGS = 0) THEN 0
     ELSE I_T.SUB_PART_NUM END AS SIGNED) AS DEF_SUBPARTITION_COUNT,

CAST(PKC.PARTITIONING_KEY_COUNT AS SIGNED) AS PARTITIONING_KEY_COUNT,
CAST(PKC.SUBPARTITIONING_KEY_COUNT AS SIGNED) AS SUBPARTITIONING_KEY_COUNT,

CAST(CASE I_T.IS_LOCAL WHEN 1 THEN 'LOCAL'
     ELSE 'GLOBAL' END AS CHAR(6)) AS LOCALITY,

CAST(CASE WHEN I_T.IS_LOCAL = 0 THEN 'PREFIXED'
          WHEN (I_T.IS_LOCAL = 1 AND LOCAL_PARTITIONED_PREFIX_INDEX.IS_PREFIXED = 1) THEN 'PREFIXED'
          ELSE 'NON_PREFIXED' END AS CHAR(12)) AS ALIGNMENT,

CAST(TP.TABLESPACE_NAME AS CHAR(30)) AS DEF_TABLESPACE_NAME,
CAST(0 AS SIGNED) AS DEF_PCT_FREE,
CAST(0 AS SIGNED) AS DEF_INI_TRANS,
CAST(0 AS SIGNED) AS DEF_MAX_TRANS,
CAST(NULL AS CHAR(40)) AS DEF_INITIAL_EXTENT,
CAST(NULL AS CHAR(40)) AS DEF_NEXT_EXTENT,
CAST(NULL AS CHAR(40)) AS DEF_MIN_EXTENTS,
CAST(NULL AS CHAR(40)) AS DEF_MAX_EXTENTS,
CAST(NULL AS CHAR(40)) AS DEF_MAX_SIZE,
CAST(NULL AS CHAR(40)) AS DEF_PCT_INCREASE,
CAST(0 AS SIGNED) AS DEF_FREELISTS,
CAST(0 AS SIGNED) AS DEF_FREELIST_GROUPS,
CAST(NULL AS CHAR(7)) AS DEF_LOGGING,
CAST(NULL AS CHAR(7)) AS DEF_BUFFER_POOL,
CAST(NULL AS CHAR(7)) AS DEF_FLASH_CACHE,
CAST(NULL AS CHAR(7)) AS DEF_CELL_FLASH_CACHE,
CAST(NULL AS CHAR(1000)) AS DEF_PARAMETERS,
CAST('NO' AS CHAR(1000)) AS "INTERVAL",
CAST('NO' AS CHAR(3)) AS AUTOLIST,
CAST(NULL AS CHAR(1000)) AS INTERVAL_SUBPARTITION,
CAST(NULL AS CHAR(1000)) AS AUTOLIST_SUBPARTITION

FROM
(SELECT D.TENANT_ID,
        D.DATABASE_NAME AS OWNER,
        I.TABLE_ID AS INDEX_ID,
        CAST(CASE WHEN D.DATABASE_NAME = '__recyclebin' THEN I.TABLE_NAME
            ELSE SUBSTR(I.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(I.TABLE_NAME, 7)))
            END AS CHAR(128)) AS INDEX_NAME,
        I.PART_LEVEL,
        I.PART_FUNC_TYPE,
        I.PART_NUM,
        I.SUB_PART_FUNC_TYPE,
        T.NEW_TABLE_NAME AS TABLE_NAME,
        T.SUB_PART_NUM,
        T.SUB_PART_TEMPLATE_FLAGS,
        T.TABLESPACE_ID,
        (CASE I.INDEX_TYPE
         WHEN 1 THEN 1
         WHEN 2 THEN 1
         WHEN 10 THEN 1
         WHEN 15 THEN 1
         WHEN 23 THEN 1
         WHEN 24 THEN 1
         WHEN 41 THEN 1
         ELSE 0 END) AS IS_LOCAL,
        (CASE I.INDEX_TYPE
         WHEN 1 THEN T.TABLE_ID
         WHEN 2 THEN T.TABLE_ID
         WHEN 10 THEN T.TABLE_ID
         WHEN 15 THEN T.TABLE_ID
         WHEN 23 THEN T.TABLE_ID
         WHEN 24 THEN T.TABLE_ID
         ELSE I.TABLE_ID END) AS JOIN_TABLE_ID
 FROM OCEANBASE.__ALL_TABLE I
 JOIN
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			)) T
 ON I.TENANT_ID = T.TENANT_ID AND I.DATA_TABLE_ID = T.TABLE_ID
 JOIN OCEANBASE.__ALL_DATABASE D
 ON T.TENANT_ID = D.TENANT_ID AND T.DATABASE_ID = D.DATABASE_ID
 WHERE I.TABLE_TYPE = 5 AND I.INDEX_TYPE NOT IN (13, 14, 16, 17, 19, 20, 22) AND I.PART_LEVEL != 0
 AND I.TABLE_MODE >> 12 & 15 in (0,1)
 AND I.INDEX_ATTRIBUTES_SET & 16 = 0
) I_T

JOIN
(SELECT
   TENANT_ID,
   TABLE_ID,
   SUM(CASE WHEN (PARTITION_KEY_POSITION & 255) != 0 THEN 1 ELSE 0 END) AS PARTITIONING_KEY_COUNT,
   SUM(CASE WHEN (PARTITION_KEY_POSITION & 65280)/256 != 0 THEN 1 ELSE 0 END) AS SUBPARTITIONING_KEY_COUNT
   FROM OCEANBASE.__ALL_COLUMN
   GROUP BY TENANT_ID, TABLE_ID) PKC
ON I_T.TENANT_ID = PKC.TENANT_ID AND I_T.JOIN_TABLE_ID = PKC.TABLE_ID

LEFT JOIN
(
 SELECT I.TENANT_ID,
        I.TABLE_ID AS INDEX_ID,
        1 AS IS_PREFIXED
 FROM OCEANBASE.__ALL_TABLE I
 WHERE I.TABLE_TYPE = 5
   AND I.INDEX_TYPE IN (1, 2, 10, 15, 23, 24, 41)
   AND I.PART_LEVEL != 0
   AND I.TENANT_ID = 0
 AND NOT EXISTS
 (SELECT *
  FROM
   (SELECT *
    FROM OCEANBASE.__ALL_COLUMN C
    WHERE C.TABLE_ID = I.DATA_TABLE_ID
      AND C.PARTITION_KEY_POSITION != 0
      AND C.TENANT_ID = 0
   ) PART_COLUMNS
   LEFT JOIN
   (SELECT *
    FROM OCEANBASE.__ALL_COLUMN C
    WHERE C.TABLE_ID = I.TABLE_ID
    AND C.TENANT_ID = 0
    AND C.INDEX_POSITION != 0
   ) INDEX_COLUMNS
   ON PART_COLUMNS.COLUMN_ID = INDEX_COLUMNS.COLUMN_ID
   WHERE
   ((PART_COLUMNS.PARTITION_KEY_POSITION & 255) != 0
    AND
    (INDEX_COLUMNS.INDEX_POSITION IS NULL
     OR (PART_COLUMNS.PARTITION_KEY_POSITION & 255) != INDEX_COLUMNS.INDEX_POSITION)
   )
   OR
   ((PART_COLUMNS.PARTITION_KEY_POSITION & 65280)/256 != 0
    AND (INDEX_COLUMNS.INDEX_POSITION IS NULL)
   )
 )
) LOCAL_PARTITIONED_PREFIX_INDEX
ON I_T.TENANT_ID = LOCAL_PARTITIONED_PREFIX_INDEX.TENANT_ID AND I_T.INDEX_ID = LOCAL_PARTITIONED_PREFIX_INDEX.INDEX_ID

LEFT JOIN OCEANBASE.__ALL_TENANT_TABLESPACE TP
ON I_T.TENANT_ID = TP.TENANT_ID AND I_T.TABLESPACE_ID = TP.TABLESPACE_ID

WHERE I_T.TENANT_ID = 0
    """
 .replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_IND_PARTITIONS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21212',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  SELECT
    CAST(D.DATABASE_NAME AS CHAR(128)) AS INDEX_OWNER,
    CAST(CASE WHEN D.DATABASE_NAME = '__recyclebin' THEN I.TABLE_NAME
        ELSE SUBSTR(I.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(I.TABLE_NAME, 7)))
        END AS CHAR(128)) AS INDEX_NAME,
    CAST(DT.TABLE_NAME AS CHAR(128)) AS TABLE_NAME,

    CAST(CASE I.PART_LEVEL
         WHEN 2 THEN 'YES'
         ELSE 'NO' END AS CHAR(3)) COMPOSITE,

    CAST(PART.PART_NAME AS CHAR(128)) AS PARTITION_NAME,

    CAST(CASE I.PART_LEVEL
         WHEN 2 THEN PART.SUB_PART_NUM
         ELSE 0 END AS SIGNED)  SUBPARTITION_COUNT,

    CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN PART.HIGH_BOUND_VAL
         ELSE PART.LIST_VAL END AS CHAR(262144)) HIGH_VALUE,

    CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN length(PART.HIGH_BOUND_VAL)
         ELSE length(PART.LIST_VAL) END AS SIGNED) HIGH_VALUE_LENGTH,

    CAST(PART.PARTITION_POSITION AS SIGNED) PARTITION_POSITION,
    CAST(NULL AS CHAR(8)) AS STATUS,
    CAST(NULL AS CHAR(30)) AS TABLESPACE_NAME,
    CAST(NULL AS SIGNED) AS PCT_FREE,
    CAST(NULL AS SIGNED) AS INI_TRANS,
    CAST(NULL AS SIGNED) AS MAX_TRANS,
    CAST(NULL AS SIGNED) AS INITIAL_EXTENT,
    CAST(NULL AS SIGNED) AS NEXT_EXTENT,
    CAST(NULL AS SIGNED) AS MIN_EXTENT,
    CAST(NULL AS SIGNED) AS MAX_EXTENT,
    CAST(NULL AS SIGNED) AS MAX_SIZE,
    CAST(NULL AS SIGNED) AS PCT_INCREASE,
    CAST(NULL AS SIGNED) AS FREELISTS,
    CAST(NULL AS SIGNED) AS FREELIST_GROUPS,
    CAST(NULL AS CHAR(7)) AS LOGGING,
    CAST(CASE WHEN PART.COMPRESS_FUNC_NAME IS NULL THEN 'DISABLED' ELSE 'ENABLED' END AS CHAR(13)) AS COMPRESSION,
    CAST(NULL AS SIGNED) AS BLEVEL,
    CAST(NULL AS SIGNED) AS LEAF_BLOCKS,
    CAST(NULL AS SIGNED) AS DISTINCT_KEYS,
    CAST(NULL AS SIGNED) AS AVG_LEAF_BLOCKS_PER_KEY,
    CAST(NULL AS SIGNED) AS AVG_DATA_BLOCKS_PER_KEY,
    CAST(NULL AS SIGNED) AS CLUSTERING_FACTOR,
    CAST(NULL AS SIGNED) AS NUM_ROWS,
    CAST(NULL AS SIGNED) AS SAMPLE_SIZE,
    CAST(NULL AS DATE) AS LAST_ANALYZED,
    CAST(NULL AS CHAR(7)) AS BUFFER_POOL,
    CAST(NULL AS CHAR(7)) AS FLASH_CACHE,
    CAST(NULL AS CHAR(7)) AS CELL_FLASH_CACHE,
    CAST(NULL AS CHAR(3)) AS USER_STATS,
    CAST(NULL AS SIGNED) AS PCT_DIRECT_ACCESS,
    CAST(NULL AS CHAR(3)) AS GLOBAL_STATS,
    CAST(NULL AS CHAR(6)) AS DOMIDX_OPSTATUS,
    CAST(NULL AS CHAR(1000)) AS PARAMETERS,
    CAST('NO' AS CHAR(3)) AS "INTERVAL",
    CAST(NULL AS CHAR(3)) AS SEGMENT_CREATED,
    CAST(NULL AS CHAR(3)) AS ORPHANED_ENTRIES
    FROM
    OCEANBASE.__ALL_TABLE I
    JOIN OCEANBASE.__ALL_TABLE DT
    ON I.TENANT_ID = DT.TENANT_ID AND I.DATA_TABLE_ID = DT.TABLE_ID
    JOIN OCEANBASE.__ALL_DATABASE D
    ON I.TENANT_ID = D.TENANT_ID
       AND I.DATABASE_ID = D.DATABASE_ID
       AND I.TABLE_TYPE = 5

    JOIN (SELECT TENANT_ID,
                 TABLE_ID,
                 PART_NAME,
                 SUB_PART_NUM,
                 HIGH_BOUND_VAL,
                 LIST_VAL,
                 COMPRESS_FUNC_NAME,
                 PARTITION_TYPE,
                 ROW_NUMBER() OVER (
                   PARTITION BY TENANT_ID, TABLE_ID
                   ORDER BY PART_IDX, PART_ID ASC
                 ) PARTITION_POSITION
          FROM OCEANBASE.__ALL_PART) PART
    ON I.TENANT_ID = PART.TENANT_ID
       AND I.TABLE_ID = PART.TABLE_ID

    WHERE I.TENANT_ID = 0
        AND I.TABLE_MODE >> 12 & 15 in (0,1)
        AND PART.PARTITION_TYPE = 0 AND I.INDEX_ATTRIBUTES_SET & 16 = 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'yanmu.ztl',
  table_name      = 'DBA_IND_SUBPARTITIONS',
  database_id     = 'OB_SYS_DATABASE_ID',
  table_id        = '21213',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  SELECT
    CAST(D.DATABASE_NAME AS CHAR(128)) AS INDEX_OWNER,
    CAST(CASE WHEN D.DATABASE_NAME = '__recyclebin' THEN I.TABLE_NAME
        ELSE SUBSTR(I.TABLE_NAME, 7 + POSITION('_' IN SUBSTR(I.TABLE_NAME, 7)))
        END AS CHAR(128)) AS INDEX_NAME,
    CAST(DT.TABLE_NAME AS CHAR(128)) AS TABLE_NAME,
    CAST(PART.PART_NAME AS CHAR(128)) PARTITION_NAME,
    CAST(PART.SUB_PART_NAME AS CHAR(128))  SUBPARTITION_NAME,
    CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN PART.HIGH_BOUND_VAL
         ELSE PART.LIST_VAL END AS CHAR(262144)) HIGH_VALUE,
    CAST(CASE WHEN length(PART.HIGH_BOUND_VAL) > 0 THEN length(PART.HIGH_BOUND_VAL)
         ELSE length(PART.LIST_VAL) END AS SIGNED) HIGH_VALUE_LENGTH,
    CAST(PART.PARTITION_POSITION AS SIGNED) PARTITION_POSITION,
    CAST(PART.SUBPARTITION_POSITION AS SIGNED) SUBPARTITION_POSITION,
    CAST(NULL AS CHAR(8)) AS STATUS,
    CAST(NULL AS CHAR(30)) AS TABLESPACE_NAME,
    CAST(NULL AS SIGNED) AS PCT_FREE,
    CAST(NULL AS SIGNED) AS INI_TRANS,
    CAST(NULL AS SIGNED) AS MAX_TRANS,
    CAST(NULL AS SIGNED) AS INITIAL_EXTENT,
    CAST(NULL AS SIGNED) AS NEXT_EXTENT,
    CAST(NULL AS SIGNED) AS MIN_EXTENT,
    CAST(NULL AS SIGNED) AS MAX_EXTENT,
    CAST(NULL AS SIGNED) AS MAX_SIZE,
    CAST(NULL AS SIGNED) AS PCT_INCREASE,
    CAST(NULL AS SIGNED) AS FREELISTS,
    CAST(NULL AS SIGNED) AS FREELIST_GROUPS,
    CAST(NULL AS CHAR(3)) AS LOGGING,
    CAST(CASE WHEN PART.COMPRESS_FUNC_NAME IS NULL THEN 'DISABLED' ELSE 'ENABLED' END AS CHAR(13)) AS COMPRESSION,
    CAST(NULL AS SIGNED) AS BLEVEL,
    CAST(NULL AS SIGNED) AS LEAF_BLOCKS,
    CAST(NULL AS SIGNED) AS DISTINCT_KEYS,
    CAST(NULL AS SIGNED) AS AVG_LEAF_BLOCKS_PER_KEY,
    CAST(NULL AS SIGNED) AS AVG_DATA_BLOCKS_PER_KEY,
    CAST(NULL AS SIGNED) AS CLUSTERING_FACTOR,
    CAST(NULL AS SIGNED) AS NUM_ROWS,
    CAST(NULL AS SIGNED) AS SAMPLE_SIZE,
    CAST(NULL AS DATE) AS LAST_ANALYZED,
    CAST(NULL AS CHAR(7)) AS BUFFER_POOL,
    CAST(NULL AS CHAR(7)) AS FLASH_CACHE,
    CAST(NULL AS CHAR(7)) AS CELL_FLASH_CACHE,
    CAST(NULL AS CHAR(3)) AS USER_STATS,
    CAST(NULL AS CHAR(3)) AS GLOBAL_STATS,
    CAST('NO' AS CHAR(3)) AS "INTERVAL",
    CAST(NULL AS CHAR(3)) AS SEGMENT_CREATED,
    CAST(NULL AS CHAR(6)) AS DOMIDX_OPSTATUS,
    CAST(NULL AS CHAR(1000)) AS PARAMETERS
    FROM OCEANBASE.__ALL_TABLE I
    JOIN OCEANBASE.__ALL_TABLE DT
    ON I.TENANT_ID = DT.TENANT_ID AND I.DATA_TABLE_ID = DT.TABLE_ID
    JOIN OCEANBASE.__ALL_DATABASE D
    ON I.TENANT_ID = D.TENANT_ID
       AND I.DATABASE_ID = D.DATABASE_ID
       AND I.TABLE_TYPE = 5
    JOIN
    (SELECT P_PART.TENANT_ID,
            P_PART.TABLE_ID,
            P_PART.PART_NAME,
            P_PART.PARTITION_POSITION,
            S_PART.SUB_PART_NAME,
            S_PART.HIGH_BOUND_VAL,
            S_PART.LIST_VAL,
            S_PART.COMPRESS_FUNC_NAME,
            S_PART.SUBPARTITION_POSITION
     FROM (SELECT
             TENANT_ID,
             TABLE_ID,
             PART_ID,
             PART_NAME,
             PARTITION_TYPE,
             ROW_NUMBER() OVER (
               PARTITION BY TENANT_ID, TABLE_ID
               ORDER BY PART_IDX, PART_ID ASC
             ) AS PARTITION_POSITION
           FROM OCEANBASE.__ALL_PART) P_PART,
          (SELECT
             TENANT_ID,
             TABLE_ID,
             PART_ID,
             SUB_PART_NAME,
             HIGH_BOUND_VAL,
             LIST_VAL,
             COMPRESS_FUNC_NAME,
             PARTITION_TYPE,
             ROW_NUMBER() OVER (
               PARTITION BY TENANT_ID, TABLE_ID, PART_ID
               ORDER BY SUB_PART_IDX, SUB_PART_ID ASC
             ) AS SUBPARTITION_POSITION
           FROM OCEANBASE.__ALL_SUB_PART) S_PART
     WHERE P_PART.PART_ID = S_PART.PART_ID AND
           P_PART.TABLE_ID = S_PART.TABLE_ID
           AND P_PART.TENANT_ID = S_PART.TENANT_ID
           AND P_PART.PARTITION_TYPE = 0
           AND S_PART.PARTITION_TYPE = 0) PART
    ON I.TABLE_ID = PART.TABLE_ID AND I.TENANT_ID = PART.TENANT_ID
    WHERE I.TENANT_ID = 0
    AND I.TABLE_MODE >> 12 & 15 in (0,1)
    AND I.INDEX_ATTRIBUTES_SET & 16 = 0
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wanhong.wwh',
  table_name      = 'GV$OB_SERVERS',
  table_id        = '21214',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = False,  # sys tenant only
  view_definition = """
SELECT
  SVR_IP,
  SVR_PORT,
  ZONE,
  SQL_PORT,
  CPU_CAPACITY,
  CPU_CAPACITY_MAX,
  CPU_ASSIGNED,
  CPU_ASSIGNED_MAX,
  MEM_CAPACITY,
  MEM_ASSIGNED,
  LOG_DISK_CAPACITY,
  LOG_DISK_ASSIGNED,
  LOG_DISK_IN_USE,
  DATA_DISK_CAPACITY,
  DATA_DISK_ASSIGNED,
  DATA_DISK_IN_USE,
  DATA_DISK_HEALTH_STATUS,
  MEMORY_LIMIT,
  DATA_DISK_ALLOCATED,
  (CASE
      WHEN data_disk_abnormal_time > 0 THEN usec_to_time(data_disk_abnormal_time)
      ELSE NULL
   END) AS DATA_DISK_ABNORMAL_TIME,
  (CASE
      WHEN ssl_cert_expired_time > 0 THEN usec_to_time(ssl_cert_expired_time)
      ELSE NULL
   END) AS SSL_CERT_EXPIRED_TIME
FROM oceanbase.__all_virtual_server
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wanhong.wwh',
  table_name      = 'V$OB_SERVERS',
  table_id        = '21215',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = False, # sys tenant only
  view_definition = """
    SELECT SVR_IP,
  SVR_PORT,
  ZONE,
  SQL_PORT,
  CPU_CAPACITY,
  CPU_CAPACITY_MAX,
  CPU_ASSIGNED,
  CPU_ASSIGNED_MAX,
  MEM_CAPACITY,
  MEM_ASSIGNED,
  LOG_DISK_CAPACITY,
  LOG_DISK_ASSIGNED,
  LOG_DISK_IN_USE,
  DATA_DISK_CAPACITY,
  DATA_DISK_ASSIGNED,
  DATA_DISK_IN_USE,
  DATA_DISK_HEALTH_STATUS,
  MEMORY_LIMIT,
  DATA_DISK_ALLOCATED,
  DATA_DISK_ABNORMAL_TIME,
  SSL_CERT_EXPIRED_TIME
    FROM oceanbase.GV$OB_SERVERS
    WHERE SVR_IP = host_ip() AND SVR_PORT = rpc_port()
""".replace("\n", " ")
)

# 21216: abandoned

def_table_schema(
  owner = 'fenggu.yh',
  table_name      = 'GV$OB_UNITS',
  table_id        = '21217',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SVR_IP,
           SVR_PORT,
           UNIT_ID,
           TENANT_ID,
           ZONE,
           ZONE_TYPE,
           REGION,
           MAX_CPU,
           MIN_CPU,
           MEMORY_SIZE,
           MAX_IOPS,
           MIN_IOPS,
           IOPS_WEIGHT,
           MAX_NET_BANDWIDTH,
           NET_BANDWIDTH_WEIGHT,
           LOG_DISK_SIZE,
           LOG_DISK_IN_USE,
           DATA_DISK_SIZE,
           DATA_DISK_IN_USE,
           STATUS,
           usec_to_time(create_time) AS CREATE_TIME
    FROM oceanbase.__all_virtual_unit
""".replace("\n", " ")
)

def_table_schema(
  owner = 'fenggu.yh',
  table_name      = 'V$OB_UNITS',
  table_id        = '21218',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SVR_IP,
           SVR_PORT,
           UNIT_ID,
           TENANT_ID,
           ZONE,
           ZONE_TYPE,
           REGION,
           MAX_CPU,
           MIN_CPU,
           MEMORY_SIZE,
           MAX_IOPS,
           MIN_IOPS,
           IOPS_WEIGHT,
           MAX_NET_BANDWIDTH,
           NET_BANDWIDTH_WEIGHT,
           LOG_DISK_SIZE,
           LOG_DISK_IN_USE,
           DATA_DISK_SIZE,
           DATA_DISK_IN_USE,
           STATUS,
           CREATE_TIME
    FROM oceanbase.GV$OB_UNITS
    WHERE SVR_IP = host_ip() AND SVR_PORT = rpc_port()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'fyy280124',
  table_name      = 'GV$OB_PARAMETERS',
  table_id        = '21219',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
  SVR_IP,
  SVR_PORT,
  ZONE,
  SCOPE,
  TENANT_ID,
  NAME,
  DATA_TYPE,
  VALUE,
  INFO,
  SECTION,
  EDIT_LEVEL,
  DEFAULT_VALUE,
  CAST (CASE ISDEFAULT
        WHEN 1
        THEN 'YES'
        ELSE 'NO'
        END AS CHAR(3)) AS ISDEFAULT
FROM oceanbase.__all_virtual_tenant_parameter_stat
""".replace("\n", " ")
)

def_table_schema(
  owner = 'fyy280124',
  table_name      = 'V$OB_PARAMETERS',
  table_id        = '21220',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SVR_IP,
    SVR_PORT,
    ZONE,
    SCOPE,
    TENANT_ID,
    NAME,
    DATA_TYPE,
    VALUE,
    INFO,
    SECTION,
    EDIT_LEVEL,
    DEFAULT_VALUE,
    CAST (CASE ISDEFAULT
          WHEN 1
          THEN 'YES'
          ELSE 'NO'
          END AS CHAR(3)) AS ISDEFAULT
    FROM oceanbase.GV$OB_PARAMETERS
    WHERE SVR_IP = host_ip() AND SVR_PORT = rpc_port()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name      = 'GV$OB_PROCESSLIST',
  table_id        = '21221',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
  SVR_IP, SVR_PORT, SQL_PORT,
  ID,
  USER,
  HOST,
  DB,
  TENANT,
  COMMAND,
  TIME,
  TOTAL_TIME,
  STATE,
  INFO,
  PROXY_SESSID,
  MASTER_SESSID,
  USER_CLIENT_IP,
  USER_HOST,
  RETRY_CNT,
  RETRY_INFO,
  SQL_ID,
  TRANS_ID,
  THREAD_ID,
  SSL_CIPHER,
  TRACE_ID,
  TRANS_STATE,
  ACTION,
  MODULE,
  CLIENT_INFO,
  LEVEL,
  SAMPLE_PERCENTAGE,
  RECORD_POLICY,
  LB_VID,
  LB_VIP,
  LB_VPORT,
  IN_BYTES,
  OUT_BYTES,
  USER_CLIENT_PORT,
  PROXY_USER,
  SERVICE_NAME,
  cast(total_cpu_time as SIGNED) as TOTAL_CPU_TIME,
  TOP_INFO,
  MEMORY_USAGE
FROM oceanbase.__all_virtual_processlist
""".replace("\n", " ")
)

def_table_schema(
  owner = 'xiaochu.yh',
  table_name      = 'V$OB_PROCESSLIST',
  table_id        = '21222',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SVR_IP, SVR_PORT, SQL_PORT,
    ID,
    USER,
    HOST,
    DB,
    TENANT,
    COMMAND,
    TIME,
    TOTAL_TIME,
    STATE,
    INFO,
    PROXY_SESSID,
    MASTER_SESSID,
    USER_CLIENT_IP,
    USER_HOST,
    RETRY_CNT,
    RETRY_INFO,
    SQL_ID,
    TRANS_ID,
    THREAD_ID,
    SSL_CIPHER,
    TRACE_ID,
    TRANS_STATE,
    ACTION,
    MODULE,
    CLIENT_INFO,
    LEVEL,
    SAMPLE_PERCENTAGE,
    RECORD_POLICY,
    LB_VID,
    LB_VIP,
    LB_VPORT,
    IN_BYTES,
    OUT_BYTES,
    USER_CLIENT_PORT,
    PROXY_USER,
    SERVICE_NAME,
    cast(total_cpu_time as SIGNED) as TOTAL_CPU_TIME,
    TOP_INFO,
    MEMORY_USAGE
    FROM oceanbase.GV$OB_PROCESSLIST
    WHERE SVR_IP = host_ip() AND SVR_PORT = rpc_port()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chaser.ch',
  table_name      = 'GV$OB_KVCACHE',
  table_id        = '21223',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
SELECT
  SVR_IP,
  SVR_PORT,
  TENANT_ID,
  CACHE_NAME,
  PRIORITY,
  CACHE_SIZE,
  HIT_RATIO,
  TOTAL_PUT_CNT,
  TOTAL_HIT_CNT,
  TOTAL_MISS_CNT
FROM oceanbase.__all_virtual_kvcache_info
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chaser.ch',
  table_name      = 'V$OB_KVCACHE',
  table_id        = '21224',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SVR_IP,
    SVR_PORT,
    TENANT_ID,
    CACHE_NAME,
    PRIORITY,
    CACHE_SIZE,
    HIT_RATIO,
    TOTAL_PUT_CNT,
    TOTAL_HIT_CNT,
    TOTAL_MISS_CNT
    FROM oceanbase.GV$OB_KVCACHE
    WHERE SVR_IP = host_ip() AND SVR_PORT = rpc_port()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'gjw228474',
  table_name      = 'GV$OB_TRANSACTION_PARTICIPANTS',
  table_id        = '21225',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """SELECT
      tenant_id AS TENANT_ID,
      svr_ip AS SVR_IP,
      svr_port AS SVR_PORT,
      session_id AS SESSION_ID,
      scheduler_addr AS SCHEDULER_ADDR,
      CASE
        WHEN part_trans_action >= 3 AND trans_type = 0
          THEN 'LOCAL'
        WHEN part_trans_action >= 3 AND trans_type = 2
          THEN 'DISTRIBUTED'
        WHEN trans_type = 0 and state = 10
          THEN 'UNDECIDED'
        WHEN trans_type = 0
          THEN 'LOCAL'
        ELSE 'DISTRIBUTED'
        END AS TX_TYPE,
      trans_id AS TX_ID,
      ls_id AS LS_ID,
      participants AS PARTICIPANTS,
      ctx_create_time AS CTX_CREATE_TIME,
      expired_time AS TX_EXPIRED_TIME,
      CASE
        WHEN state = 0 THEN 'UNKNOWN'
        WHEN state = 10 THEN 'ACTIVE'
        WHEN state = 20 THEN 'REDO COMPLETE'
        WHEN state = 30 THEN 'PREPARE'
        WHEN state = 40 THEN 'PRECOMMIT'
        WHEN state = 50 THEN 'COMMIT'
        WHEN state = 60 THEN 'ABORT'
        WHEN state = 70 THEN 'CLEAR'
        ELSE 'UNDEFINED'
        END AS STATE,
      CAST (CASE
        WHEN part_trans_action = 1 THEN 'NULL'
        WHEN part_trans_action = 2 THEN 'START'
        WHEN part_trans_action = 3 THEN 'COMMIT'
        WHEN part_trans_action = 4 THEN 'ABORT'
        WHEN part_trans_action = 5 THEN 'DIED'
        WHEN part_trans_action = 6 THEN 'END'
        ELSE 'UNKNOWN'
        END AS CHAR(10)) AS ACTION,
      pending_log_size AS PENDING_LOG_SIZE,
      flushed_log_size AS FLUSHED_LOG_SIZE,
      CASE
        WHEN role = 0 THEN 'LEADER'
        ELSE 'FOLLOWER'
      END AS ROLE,
      COORDINATOR AS COORD,
      LAST_REQUEST_TIME,
      FORMAT_ID AS FORMATID,
      HEX(GTRID) AS GLOBALID,
      HEX(BQUAL) AS BRANCHID
    FROM oceanbase.__all_virtual_trans_stat
    WHERE is_exiting = 0
""".replace("\n", " "),
)

def_table_schema(
  owner = 'gjw228474',
  table_name      = 'V$OB_TRANSACTION_PARTICIPANTS',
  table_id        = '21226',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """SELECT TENANT_ID,
    SVR_IP,
    SVR_PORT,
    SESSION_ID,
    SCHEDULER_ADDR,
    TX_TYPE,
    TX_ID,
    LS_ID,
    PARTICIPANTS,
    CTX_CREATE_TIME,
    TX_EXPIRED_TIME,
    STATE,
    ACTION,
    PENDING_LOG_SIZE,
    FLUSHED_LOG_SIZE,
    ROLE,
    COORD,
    LAST_REQUEST_TIME,
    FORMATID,
    GLOBALID,
    BRANCHID
    FROM OCEANBASE.GV$OB_TRANSACTION_PARTICIPANTS
    WHERE SVR_IP = HOST_IP() AND SVR_PORT = RPC_PORT()
""".replace("\n", " "),
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'GV$OB_COMPACTION_PROGRESS',
  table_id        = '21227',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      SVR_IP,
      SVR_PORT,
      TENANT_ID,
      TYPE,
      ZONE,
      COMPACTION_SCN,
      STATUS,
      TOTAL_TABLET_COUNT,
      UNFINISHED_TABLET_COUNT,
      DATA_SIZE,
      UNFINISHED_DATA_SIZE,
      COMPRESSION_RATIO,
      START_TIME,
      ESTIMATED_FINISH_TIME,
      COMMENTS
    FROM oceanbase.__all_virtual_server_compaction_progress
""".replace("\n", " ")
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'V$OB_COMPACTION_PROGRESS',
  table_id        = '21228',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SVR_IP,
      SVR_PORT,
      TENANT_ID,
      TYPE,
      ZONE,
      COMPACTION_SCN,
      STATUS,
      TOTAL_TABLET_COUNT,
      UNFINISHED_TABLET_COUNT,
      DATA_SIZE,
      UNFINISHED_DATA_SIZE,
      COMPRESSION_RATIO,
      START_TIME,
      ESTIMATED_FINISH_TIME,
      COMMENTS
    FROM oceanbase.GV$OB_COMPACTION_PROGRESS
    WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'GV$OB_TABLET_COMPACTION_PROGRESS',
  table_id        = '21229',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      SVR_IP,
      SVR_PORT,
      TENANT_ID,
      TYPE,
      LS_ID,
      TABLET_ID,
      COMPACTION_SCN,
      TASK_ID,
      STATUS,
      DATA_SIZE,
      UNFINISHED_DATA_SIZE,
      PROGRESSIVE_COMPACTION_ROUND,
      CREATE_TIME,
      START_TIME,
      ESTIMATED_FINISH_TIME,
      START_CG_ID,
      END_CG_ID
    FROM oceanbase.__all_virtual_tablet_compaction_progress
""".replace("\n", " ")
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'V$OB_TABLET_COMPACTION_PROGRESS',
  table_id        = '21230',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SVR_IP,
      SVR_PORT,
      TENANT_ID,
      TYPE,
      LS_ID,
      TABLET_ID,
      COMPACTION_SCN,
      TASK_ID,
      STATUS,
      DATA_SIZE,
      UNFINISHED_DATA_SIZE,
      PROGRESSIVE_COMPACTION_ROUND,
      CREATE_TIME,
      START_TIME,
      ESTIMATED_FINISH_TIME,
      START_CG_ID,
      END_CG_ID
    FROM oceanbase.GV$OB_TABLET_COMPACTION_PROGRESS
    WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'GV$OB_TABLET_COMPACTION_HISTORY',
  table_id        = '21231',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      SVR_IP,
      SVR_PORT,
      TENANT_ID,
      LS_ID,
      TABLET_ID,
      TYPE,
      COMPACTION_SCN,
      START_TIME,
      FINISH_TIME,
      TASK_ID,
      OCCUPY_SIZE,
      MACRO_BLOCK_COUNT,
      MULTIPLEXED_MACRO_BLOCK_COUNT,
      NEW_MICRO_COUNT_IN_NEW_MACRO,
      MULTIPLEXED_MICRO_COUNT_IN_NEW_MACRO,
      TOTAL_ROW_COUNT,
      INCREMENTAL_ROW_COUNT,
      COMPRESSION_RATIO,
      NEW_FLUSH_DATA_RATE,
      PROGRESSIVE_COMPACTION_ROUND,
      PROGRESSIVE_COMPACTION_NUM,
      PARALLEL_DEGREE,
      PARALLEL_INFO,
      PARTICIPANT_TABLE,
      MACRO_ID_LIST,
      COMMENTS,
      START_CG_ID,
      END_CG_ID,
      KEPT_SNAPSHOT,
      MERGE_LEVEL,
      EXEC_MODE,
      (CASE IS_FULL_MERGE
           WHEN false THEN "FALSE"
           ELSE "TRUE" END) AS IS_FULL_MERGE,
      IO_COST_TIME_PERCENTAGE,
      MERGE_REASON,
      BASE_MAJOR_STATUS,
      CO_MERGE_TYPE,
      MDS_FILTER_INFO
    FROM oceanbase.__all_virtual_tablet_compaction_history
""".replace("\n", " ")
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'V$OB_TABLET_COMPACTION_HISTORY',
  table_id        = '21232',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SVR_IP,
      SVR_PORT,
      TENANT_ID,
      LS_ID,
      TABLET_ID,
      TYPE,
      COMPACTION_SCN,
      START_TIME,
      FINISH_TIME,
      TASK_ID,
      OCCUPY_SIZE,
      MACRO_BLOCK_COUNT,
      MULTIPLEXED_MACRO_BLOCK_COUNT,
      NEW_MICRO_COUNT_IN_NEW_MACRO,
      MULTIPLEXED_MICRO_COUNT_IN_NEW_MACRO,
      TOTAL_ROW_COUNT,
      INCREMENTAL_ROW_COUNT,
      COMPRESSION_RATIO,
      NEW_FLUSH_DATA_RATE,
      PROGRESSIVE_COMPACTION_ROUND,
      PROGRESSIVE_COMPACTION_NUM,
      PARALLEL_DEGREE,
      PARALLEL_INFO,
      PARTICIPANT_TABLE,
      MACRO_ID_LIST,
      COMMENTS,
      START_CG_ID,
      END_CG_ID,
      KEPT_SNAPSHOT,
      MERGE_LEVEL,
      EXEC_MODE,
      IS_FULL_MERGE,
      IO_COST_TIME_PERCENTAGE,
      MERGE_REASON,
      BASE_MAJOR_STATUS,
      CO_MERGE_TYPE,
      MDS_FILTER_INFO
    FROM oceanbase.GV$OB_TABLET_COMPACTION_HISTORY
    WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'GV$OB_COMPACTION_DIAGNOSE_INFO',
  table_id        = '21233',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      SVR_IP,
      SVR_PORT,
      TENANT_ID,
      TYPE,
      LS_ID,
      TABLET_ID,
      STATUS,
      CREATE_TIME,
      DIAGNOSE_INFO
    FROM oceanbase.__all_virtual_compaction_diagnose_info
    WHERE
      STATUS != "RS_UNCOMPACTED"
    AND
      STATUS != "NOT_SCHEDULE"
    AND
      STATUS != "SPECIAL"
""".replace("\n", " ")
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'V$OB_COMPACTION_DIAGNOSE_INFO',
  table_id        = '21234',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SVR_IP,
      SVR_PORT,
      TENANT_ID,
      TYPE,
      LS_ID,
      TABLET_ID,
      STATUS,
      CREATE_TIME,
      DIAGNOSE_INFO
    FROM oceanbase.GV$OB_COMPACTION_DIAGNOSE_INFO
    WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'GV$OB_COMPACTION_SUGGESTIONS',
  table_id        = '21235',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      SVR_IP,
      SVR_PORT,
      TENANT_ID,
      TYPE,
      LS_ID,
      TABLET_ID,
      START_TIME,
      FINISH_TIME,
      SUGGESTION
    FROM oceanbase.__all_virtual_compaction_suggestion
""".replace("\n", " ")
)

def_table_schema(
  owner = 'lixia.yq',
  table_name      = 'V$OB_COMPACTION_SUGGESTIONS',
  table_id        = '21236',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT SVR_IP,
      SVR_PORT,
      TENANT_ID,
      TYPE,
      LS_ID,
      TABLET_ID,
      START_TIME,
      FINISH_TIME,
      SUGGESTION
    FROM oceanbase.GV$OB_COMPACTION_SUGGESTIONS
    WHERE
        SVR_IP=HOST_IP()
    AND
        SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
    owner = 'dachuan.sdc',
    table_name     = 'GV$OB_DTL_INTERM_RESULT_MONITOR',
    table_id       = '21237',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """SELECT
          SVR_IP,
          SVR_PORT,
          TENANT_ID,
          TRACE_ID,
          OWNER,
          START_TIME,
          EXPIRE_TIME,
          HOLD_MEMORY,
          DUMP_SIZE,
          DUMP_COST,
          DUMP_TIME,
          DUMP_FD,
          DUMP_DIR_ID,
          CHANNEL_ID,
          QC_ID,
          DFO_ID,
          SQC_ID,
          BATCH_ID,
          MAX_HOLD_MEMORY
        FROM oceanbase.__all_virtual_dtl_interm_result_monitor
""".replace("\n", " ")
)

def_table_schema(
    owner = 'dachuan.sdc',
    table_name     = 'V$OB_DTL_INTERM_RESULT_MONITOR',
    table_id       = '21238',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """
    SELECT SVR_IP,
          SVR_PORT,
          TENANT_ID,
          TRACE_ID,
          OWNER,
          START_TIME,
          EXPIRE_TIME,
          HOLD_MEMORY,
          DUMP_SIZE,
          DUMP_COST,
          DUMP_TIME,
          DUMP_FD,
          DUMP_DIR_ID,
          CHANNEL_ID,
          QC_ID,
          DFO_ID,
          SQC_ID,
          BATCH_ID,
          MAX_HOLD_MEMORY FROM OCEANBASE.GV$OB_DTL_INTERM_RESULT_MONITOR
    WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner             = 'jianyun.sjy',
  table_name        = 'GV$OB_IO_CALIBRATION_STATUS',
  table_id          = '21239',
  table_type        = 'SYSTEM_VIEW',
  in_tenant_space   = False,
  gm_columns        = [],
  rowkey_columns    = [],
  normal_columns    = [],
  view_definition   = """
    SELECT
        SVR_IP,
        SVR_PORT,
        STORAGE_NAME,
        STATUS,
        START_TIME,
        FINISH_TIME
    FROM oceanbase.__all_virtual_io_calibration_status
  """.replace("\n", " "),
)

def_table_schema(
  owner             = 'jianyun.sjy',
  table_name        = 'V$OB_IO_CALIBRATION_STATUS',
  table_id          = '21240',
  table_type        = 'SYSTEM_VIEW',
  in_tenant_space   = False,
  gm_columns        = [],
  rowkey_columns    = [],
  normal_columns    = [],
  view_definition   = """
    SELECT SVR_IP,
        SVR_PORT,
        STORAGE_NAME,
        STATUS,
        START_TIME,
        FINISH_TIME FROM oceanbase.GV$OB_IO_CALIBRATION_STATUS
    WHERE svr_ip=HOST_IP() AND svr_port=RPC_PORT()
  """.replace("\n", " "),
)

def_table_schema(
  owner             = 'jianyun.sjy',
  table_name        = 'GV$OB_IO_BENCHMARK',
  table_id          = '21241',
  table_type        = 'SYSTEM_VIEW',
  in_tenant_space   = False,
  gm_columns        = [],
  rowkey_columns    = [],
  normal_columns    = [],
  view_definition   = """
    SELECT
        SVR_IP,
        SVR_PORT,
        STORAGE_NAME,
        MODE,
        SIZE,
        IOPS,
        MBPS,
        LATENCY
    FROM oceanbase.__all_virtual_io_benchmark
  """.replace("\n", " "),
)

def_table_schema(
  owner             = 'jianyun.sjy',
  table_name        = 'V$OB_IO_BENCHMARK',
  table_id          = '21242',
  table_type        = 'SYSTEM_VIEW',
  in_tenant_space   = False,
  gm_columns        = [],
  rowkey_columns    = [],
  normal_columns    = [],
  view_definition   = """
    SELECT SVR_IP,
        SVR_PORT,
        STORAGE_NAME,
        MODE,
        SIZE,
        IOPS,
        MBPS,
        LATENCY FROM oceanbase.GV$OB_IO_BENCHMARK
    WHERE svr_ip=HOST_IP() AND svr_port=RPC_PORT()
  """.replace("\n", " "),
)

# 21243: GV$OB_IO_QUOTA
# 21244: V$OB_IO_QUOTA


# 4.0 backup clean view
def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'CDB_OB_BACKUP_DELETE_JOBS',
  table_id        = '21245',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
      TENANT_ID,
      JOB_ID,
      INCARNATION,
      INITIATOR_TENANT_ID,
      INITIATOR_JOB_ID,
      EXECUTOR_TENANT_ID,
      TYPE,
      USEC_TO_TIME(PARAMETER) AS PARAMETER,
      JOB_LEVEL,
      USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
      CASE
        WHEN END_TS = 0
          THEN NULL
        ELSE
          USEC_TO_TIME(END_TS)
        END AS END_TIMESTAMP,
      STATUS,
      TASK_COUNT,
      SUCCESS_TASK_COUNT,
      RESULT,
      COMMENT
    FROM oceanbase.__all_virtual_backup_delete_job
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'CDB_OB_BACKUP_DELETE_JOB_HISTORY',
  table_id        = '21246',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
      TENANT_ID,
      JOB_ID,
      INCARNATION,
      INITIATOR_TENANT_ID,
      INITIATOR_JOB_ID,
      EXECUTOR_TENANT_ID,
      TYPE,
      USEC_TO_TIME(PARAMETER) AS PARAMETER,
      JOB_LEVEL,
      USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
      CASE
        WHEN END_TS = 0
          THEN NULL
        ELSE
          USEC_TO_TIME(END_TS)
        END AS END_TIMESTAMP,
      STATUS,
      TASK_COUNT,
      SUCCESS_TASK_COUNT,
      RESULT,
      COMMENT
    FROM oceanbase.__all_virtual_backup_delete_job_history
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'CDB_OB_BACKUP_DELETE_TASKS',
  table_id        = '21247',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
      TENANT_ID,
      TASK_ID,
      INCARNATION,
      JOB_ID,
      TASK_TYPE,
      ID,
      ROUND_ID,
      DEST_ID,
      USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
      CASE
        WHEN END_TS = 0
          THEN NULL
        ELSE
          USEC_TO_TIME(END_TS)
        END AS END_TIMESTAMP,
      STATUS,
      TOTAL_LS_COUNT,
      FINISH_LS_COUNT,
      RESULT,
      COMMENT,
      PATH
    FROM oceanbase.__all_virtual_backup_delete_task
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'CDB_OB_BACKUP_DELETE_TASK_HISTORY',
  table_id        = '21248',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
      TENANT_ID,
      TASK_ID,
      INCARNATION,
      JOB_ID,
      TASK_TYPE,
      ID,
      ROUND_ID,
      DEST_ID,
      USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
      CASE
        WHEN END_TS = 0
          THEN NULL
        ELSE
          USEC_TO_TIME(END_TS)
        END AS END_TIMESTAMP,
      STATUS,
      TOTAL_LS_COUNT,
      FINISH_LS_COUNT,
      RESULT,
      COMMENT,
      PATH
    FROM oceanbase.__all_virtual_backup_delete_task_history
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'CDB_OB_BACKUP_DELETE_POLICY',
  table_id        = '21249',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
      TENANT_ID,
      POLICY_NAME,
      RECOVERY_WINDOW
    FROM oceanbase.__all_virtual_backup_delete_policy
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'CDB_OB_BACKUP_STORAGE_INFO',
  table_id        = '21250',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    PATH,
    ENDPOINT,
    DEST_ID,
    DEST_TYPE,
    AUTHORIZATION,
    EXTENSION,
    CHECK_FILE_NAME,
    USEC_TO_TIME(LAST_CHECK_TIME) AS LAST_CHECK_TIMESTAMP,
    MAX_IOPS,
    MAX_BANDWIDTH,
    CASE
      WHEN MAX_BANDWIDTH = 0
        THEN "UNLIMITED"
      WHEN MAX_BANDWIDTH >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024/1024/1024,2), 'PB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024/1024,2), 'TB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024,2), 'GB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024,2), 'MB/s')
      WHEN MAX_BANDWIDTH >= 1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024,2), 'KB/s')
      ELSE
        CONCAT(ROUND(MAX_BANDWIDTH,2), 'B/s')
    END AS MAX_BANDWIDTH_DISPLAY
    FROM oceanbase.__all_virtual_backup_storage_info
""".replace("\n", " ")
)

def_table_schema(
    owner = 'jiangxiu.wt',
    table_name     = 'DBA_TAB_STATISTICS',
    table_id       = '21251',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """SELECT
    CAST(DB.DATABASE_NAME AS     CHAR(128)) AS OWNER,
    CAST(V.TABLE_NAME       AS  CHAR(128)) AS TABLE_NAME,
    CAST(V.PARTITION_NAME   AS  CHAR(128)) AS PARTITION_NAME,
    CAST(V.PARTITION_POSITION AS    NUMBER) AS PARTITION_POSITION,
    CAST(V.SUBPARTITION_NAME  AS    CHAR(128)) AS SUBPARTITION_NAME,
    CAST(V.SUBPARTITION_POSITION AS NUMBER) AS SUBPARTITION_POSITION,
    CAST(V.OBJECT_TYPE AS   CHAR(12)) AS OBJECT_TYPE,
    CAST(STAT.ROW_CNT AS    NUMBER) AS NUM_ROWS,
    CAST(NULL AS    NUMBER) AS BLOCKS,
    CAST(NULL AS    NUMBER) AS EMPTY_BLOCKS,
    CAST(NULL AS    NUMBER) AS AVG_SPACE,
    CAST(NULL AS    NUMBER) AS CHAIN_CNT,
    CAST(STAT.AVG_ROW_LEN AS    NUMBER) AS AVG_ROW_LEN,
    CAST(NULL AS    NUMBER) AS AVG_SPACE_FREELIST_BLOCKS,
    CAST(NULL AS    NUMBER) AS NUM_FREELIST_BLOCKS,
    CAST(NULL AS    NUMBER) AS AVG_CACHED_BLOCKS,
    CAST(NULL AS    NUMBER) AS AVG_CACHE_HIT_RATIO,
    CAST(NULL AS    NUMBER) AS IM_IMCU_COUNT,
    CAST(NULL AS    NUMBER) AS IM_BLOCK_COUNT,
    CAST(NULL AS    DATETIME) AS IM_STAT_UPDATE_TIME,
    CAST(NULL AS    NUMBER) AS SCAN_RATE,
    CAST(STAT.SPARE1 AS    DECIMAL(20, 0)) AS SAMPLE_SIZE,
    CAST(STAT.LAST_ANALYZED AS DATETIME(6)) AS LAST_ANALYZED,
    CAST((CASE STAT.GLOBAL_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS GLOBAL_STATS,
    CAST((CASE STAT.USER_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS USER_STATS,
    CAST((CASE WHEN STAT.STATTYPE_LOCKED & 15 IS NULL THEN NULL ELSE (CASE STAT.STATTYPE_LOCKED & 15 WHEN 0 THEN NULL WHEN 1 THEN 'DATA' WHEN 2 THEN 'CACHE' ELSE 'ALL' END) END) AS CHAR(5)) AS STATTYPE_LOCKED,
    CAST((CASE STAT.STALE_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS STALE_STATS,
    CAST(NULL AS    CHAR(7)) AS SCOPE
    FROM
    (
      (SELECT CAST(0 AS SIGNED) AS TENANT_ID,
              DATABASE_ID,
              TABLE_ID,
              -2 AS PARTITION_ID,
              TABLE_NAME,
              NULL AS PARTITION_NAME,
              NULL AS SUBPARTITION_NAME,
              NULL AS PARTITION_POSITION,
              NULL AS SUBPARTITION_POSITION,
              'TABLE' AS OBJECT_TYPE
          FROM
            OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE
          WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
          AND TABLE_TYPE IN (0,2,3,6,14,15)
        UNION ALL
        SELECT TENANT_ID,
               DATABASE_ID,
               TABLE_ID,
               CASE WHEN PART_LEVEL = 0 THEN -2 ELSE -1 END AS PARTITION_ID,
               TABLE_NAME,
               NULL AS PARTITION_NAME,
               NULL AS SUBPARTITION_NAME,
               NULL AS PARTITION_POSITION,
               NULL AS SUBPARTITION_POSITION,
               'TABLE' AS OBJECT_TYPE
        FROM
            oceanbase.__all_table T
        WHERE T.TABLE_TYPE IN (0,2,3,6,14,15)
        AND T.TABLE_MODE >> 12 & 15 in (0,1)
        AND T.INDEX_ATTRIBUTES_SET & 16 = 0)
    UNION ALL
        SELECT T.TENANT_ID,
                T.DATABASE_ID,
                T.TABLE_ID,
                P.PART_ID,
                T.TABLE_NAME,
                P.PART_NAME,
                NULL,
                P.PART_IDX + 1,
                NULL,
                'PARTITION'
        FROM
            oceanbase.__all_table T
          JOIN
            oceanbase.__all_part P
            ON T.TENANT_ID = P.TENANT_ID
            AND T.TABLE_ID = P.TABLE_ID
        WHERE T.TABLE_TYPE IN (0,2,3,6,14,15)
              AND T.TABLE_MODE >> 12 & 15 in (0,1)
              AND (P.PARTITION_TYPE = 0 OR P.PARTITION_TYPE IS NULL)
              AND T.INDEX_ATTRIBUTES_SET & 16 = 0
    UNION ALL
        SELECT T.TENANT_ID,
               T.DATABASE_ID,
               T.TABLE_ID,
               SP.SUB_PART_ID AS PARTITION_ID,
               T.TABLE_NAME,
                 P.PART_NAME,
                 SP.SUB_PART_NAME,
                 P.PART_IDX + 1,
                 SP.SUB_PART_IDX + 1,
                 'SUBPARTITION'
        FROM
            oceanbase.__all_table T
        JOIN
            oceanbase.__all_part P
            ON T.TENANT_ID = P.TENANT_ID
            AND T.TABLE_ID = P.TABLE_ID
        JOIN
            oceanbase.__all_sub_part SP
            ON T.TENANT_ID = SP.TENANT_ID
            AND T.TABLE_ID = SP.TABLE_ID
            AND P.PART_ID = SP.PART_ID
        WHERE T.TABLE_TYPE IN (0,2,3,6,14,15)
              AND T.TABLE_MODE >> 12 & 15 in (0,1)
              AND (P.PARTITION_TYPE = 0 OR P.PARTITION_TYPE IS NULL)
              AND (SP.PARTITION_TYPE = 0 OR SP.PARTITION_TYPE IS NULL)
              AND T.INDEX_ATTRIBUTES_SET & 16 = 0
    ) V
    JOIN
        oceanbase.__all_database DB
        ON DB.TENANT_ID = V.TENANT_ID
        AND DB.DATABASE_ID = V.DATABASE_ID
        AND V.TENANT_ID = 0
    LEFT JOIN
        oceanbase.__all_table_stat STAT
        ON V.TENANT_ID = STAT.TENANT_ID
        AND V.TABLE_ID = STAT.TABLE_ID
        AND (V.PARTITION_ID = STAT.PARTITION_ID OR V.PARTITION_ID = -2)
        AND STAT.INDEX_TYPE = 0
""".replace("\n", " ")
)

def_table_schema(
    owner = 'jiangxiu.wt',
    table_name     = 'DBA_TAB_COL_STATISTICS',
    table_id       = '21252',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """SELECT
  cast(db.database_name as CHAR(128)) as OWNER,
  cast(tc.table_name as CHAR(128)) as  TABLE_NAME,
  cast(tc.column_name as CHAR(128)) as  COLUMN_NAME,
  cast(stat.distinct_cnt as NUMBER) as  NUM_DISTINCT,
  cast(stat.min_value as CHAR(128)) as  LOW_VALUE,
  cast(stat.max_value as CHAR(128)) as  HIGH_VALUE,
  cast(stat.density as NUMBER) as  DENSITY,
  cast(stat.null_cnt as NUMBER) as  NUM_NULLS,
  cast(stat.bucket_cnt as NUMBER) as  NUM_BUCKETS,
  cast(stat.last_analyzed as DATETIME(6)) as  LAST_ANALYZED,
  cast(stat.sample_size as NUMBER) as  SAMPLE_SIZE,
  CAST((CASE stat.GLOBAL_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS GLOBAL_STATS,
  CAST((CASE stat.USER_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS USER_STATS,
  cast(NULL as CHAR(80)) as  NOTES,
  cast(stat.avg_len as NUMBER) as  AVG_COL_LEN,
  cast((case when stat.histogram_type = 1 then 'FREQUENCY'
        when stat.histogram_type = 3 then 'TOP-FREQUENCY'
        when stat.histogram_type = 4 then 'HYBRID'
        else NULL end) as CHAR(15)) as HISTOGRAM,
  cast(NULL as CHAR(7)) SCOPE
    FROM
    (SELECT CAST(0 AS SIGNED) AS TENANT_ID,
            t.DATABASE_ID,
            t.TABLE_ID,
            t.TABLE_NAME,
            c.COLUMN_ID,
            c.COLUMN_NAME,
            c.IS_HIDDEN
          FROM
            oceanbase.__all_virtual_core_all_table t,
            oceanbase.__all_virtual_core_column_table c
          WHERE t.TENANT_ID = EFFECTIVE_TENANT_ID()
            and c.TENANT_ID = EFFECTIVE_TENANT_ID()
            and c.tenant_id = t.tenant_id
            AND c.table_id = t.table_id
     UNION ALL
     SELECT t.TENANT_ID,
            t.database_id,
            t.table_id,
            t.table_name,
            c.COLUMN_ID,
            c.COLUMN_NAME,
            c.IS_HIDDEN
      FROM oceanbase.__all_table t,
           oceanbase.__all_column c
      where t.table_type in (0,2,3,6,14)
        and t.table_mode >> 12 & 15 in (0,1)
        and t.index_attributes_set & 16 = 0
        and c.tenant_id = t.tenant_id
        and c.table_id = t.table_id) tc
  JOIN
    oceanbase.__all_database db
    ON db.tenant_id = tc.tenant_id
    AND db.database_id = tc.database_id
    and tc.tenant_id = 0
  left join
    oceanbase.__all_column_stat stat
    ON tc.table_id = stat.table_id
    AND tc.column_id = stat.column_id
    AND stat.object_type = 1
WHERE
  tc.is_hidden = 0
""".replace("\n", " ")
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name      = 'DBA_PART_COL_STATISTICS',
  table_id        = '21253',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """SELECT
  cast(db.database_name as CHAR(128)) as OWNER,
  cast(t.table_name as CHAR(128)) as  TABLE_NAME,
  cast (part.part_name as CHAR(128)) as PARTITION_NAME,
  cast(c.column_name as CHAR(128)) as  COLUMN_NAME,
  cast(stat.distinct_cnt as NUMBER) as  NUM_DISTINCT,
  cast(stat.min_value as CHAR(128)) as  LOW_VALUE,
  cast(stat.max_value as CHAR(128)) as  HIGH_VALUE,
  cast(stat.density as NUMBER) as  DENSITY,
  cast(stat.null_cnt as NUMBER) as  NUM_NULLS,
  cast(stat.bucket_cnt as NUMBER) as  NUM_BUCKETS,
  cast(stat.last_analyzed as DATETIME(6)) as  LAST_ANALYZED,
  cast(stat.sample_size as NUMBER) as  SAMPLE_SIZE,
  CAST((CASE stat.GLOBAL_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS GLOBAL_STATS,
  CAST((CASE stat.USER_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS USER_STATS,
  cast(NULL as CHAR(80)) as  NOTES,
  cast(stat.avg_len as NUMBER) as  AVG_COL_LEN,
  cast((case when stat.histogram_type = 1 then 'FREQUENCY'
        when stat.histogram_type = 3 then 'TOP-FREQUENCY'
        when stat.histogram_type = 4 then 'HYBRID'
        else NULL end) as CHAR(15)) as HISTOGRAM
    FROM
    oceanbase.__all_table t
  JOIN
    oceanbase.__all_database db
    ON db.tenant_id = t.tenant_id
    AND db.database_id = t.database_id
    and t.tenant_id = 0
  JOIN
    oceanbase.__all_column c
    ON c.tenant_id = t.tenant_id
    AND c.table_id = t.table_id
  JOIN
    oceanbase.__all_part part
    on t.tenant_id = part.tenant_id
    and t.table_id = part.table_id
  left join
    oceanbase.__all_column_stat stat
    ON c.table_id = stat.table_id
    AND c.column_id = stat.column_id
    AND part.part_id = stat.partition_id
    AND stat.object_type = 2
WHERE
  c.is_hidden = 0
  AND t.table_type in (0,3,6,14)
  AND t.table_mode >> 12 & 15 in (0,1)
  AND part.partition_type = 0
  AND t.index_attributes_set & 16 = 0
""".replace("\n", " ")
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name      = 'DBA_SUBPART_COL_STATISTICS',
  table_id        = '21254',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """SELECT
  cast(db.database_name as CHAR(128)) as OWNER,
  cast(t.table_name as CHAR(128)) as  TABLE_NAME,
  cast (subpart.sub_part_name as CHAR(128)) as SUBPARTITION_NAME,
  cast(c.column_name as CHAR(128)) as  COLUMN_NAME,
  cast(stat.distinct_cnt as NUMBER) as  NUM_DISTINCT,
  cast(stat.min_value as CHAR(128)) as  LOW_VALUE,
  cast(stat.max_value as CHAR(128)) as  HIGH_VALUE,
  cast(stat.density as NUMBER) as  DENSITY,
  cast(stat.null_cnt as NUMBER) as  NUM_NULLS,
  cast(stat.bucket_cnt as NUMBER) as  NUM_BUCKETS,
  cast(stat.last_analyzed as DATETIME(6)) as  LAST_ANALYZED,
  cast(stat.sample_size as NUMBER) as  SAMPLE_SIZE,
  CAST((CASE stat.GLOBAL_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS GLOBAL_STATS,
  CAST((CASE stat.USER_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS USER_STATS,
  cast(NULL as CHAR(80)) as  NOTES,
  cast(stat.avg_len as NUMBER) as  AVG_COL_LEN,
  cast((case when stat.histogram_type = 1 then 'FREQUENCY'
        when stat.histogram_type = 3 then 'TOP-FREQUENCY'
        when stat.histogram_type = 4 then 'HYBRID'
        else NULL end) as CHAR(15)) as HISTOGRAM
    FROM
    oceanbase.__all_table t
  JOIN
    oceanbase.__all_database db
    ON db.tenant_id = t.tenant_id
    AND db.database_id = t.database_id
    and t.tenant_id = 0
  JOIN
    oceanbase.__all_column c
    ON c.tenant_id = t.tenant_id
    AND c.table_id = t.table_id
  JOIN
    oceanbase.__all_sub_part subpart
    on t.tenant_id = subpart.tenant_id
    and t.table_id = subpart.table_id
  left join
    oceanbase.__all_column_stat stat
    ON c.table_id = stat.table_id
    AND c.column_id = stat.column_id
    AND stat.partition_id = subpart.sub_part_id
    AND stat.object_type = 3
WHERE
  c.is_hidden = 0
  AND t.table_type in (0,3,6,14)
  AND t.table_mode >> 12 & 15 in (0,1)
  AND subpart.partition_type = 0
  AND t.index_attributes_set & 16 = 0
""".replace("\n", " ")
)

def_table_schema(
    owner = 'jiangxiu.wt',
    table_name     = 'DBA_TAB_HISTOGRAMS',
    table_id       = '21255',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """select
  cast(db.database_name as CHAR(128)) as OWNER,
  cast(t.table_name as CHAR(128)) as  TABLE_NAME,
  cast(c.column_name as CHAR(128)) as  COLUMN_NAME,
  cast(hist.endpoint_num as NUMBER) as  ENDPOINT_NUMBER,
  cast(NULL as NUMBER) as  ENDPOINT_VALUE,
  cast(hist.endpoint_value as CHAR(4000)) as ENDPOINT_ACTUAL_VALUE,
  cast(hist.b_endpoint_value as CHAR(4000)) as ENDPOINT_ACTUAL_VALUE_RAW,
  cast(hist.endpoint_repeat_cnt as NUMBER) as ENDPOINT_REPEAT_COUNT,
  cast(NULL as CHAR(7)) as SCOPE
    FROM
    (SELECT CAST(0 AS SIGNED) AS TENANT_ID,
            DATABASE_ID,
            TABLE_ID,
            TABLE_NAME
          FROM
            oceanbase.__all_virtual_core_all_table
     UNION ALL
     SELECT TENANT_ID,
            database_id,
            table_id,
            table_name
      FROM oceanbase.__all_table where table_type in (0,3,6,14)
      and table_mode >> 12 & 15 in (0,1)
      and index_attributes_set & 16 = 0) t
  JOIN
    oceanbase.__all_database db
    ON db.tenant_id = t.tenant_id
    AND db.database_id = t.database_id
    and t.tenant_id = 0
  JOIN
    oceanbase.__all_column c
    ON c.tenant_id = t.tenant_id
    AND c.table_id = t.table_id
  JOIN
    oceanbase.__all_histogram_stat hist
    ON c.table_id = hist.table_id
    AND c.column_id = hist.column_id
    AND hist.object_type = 1
WHERE
  c.is_hidden = 0
""".replace("\n", " ")
)

def_table_schema(
    owner = 'jiangxiu.wt',
    table_name      = 'DBA_PART_HISTOGRAMS',
    table_id        = '21256',
    table_type      = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """select
    cast(db.database_name as CHAR(128)) as OWNER,
    cast(t.table_name as CHAR(128)) as  TABLE_NAME,
    cast(part.part_name as CHAR(128)) as PARTITION_NAME,
    cast(c.column_name as CHAR(128)) as  COLUMN_NAME,
    cast(hist.endpoint_num as NUMBER) as  ENDPOINT_NUMBER,
    cast(NULL as NUMBER) as  ENDPOINT_VALUE,
    cast(hist.endpoint_value as CHAR(4000)) as ENDPOINT_ACTUAL_VALUE,
    cast(hist.b_endpoint_value as CHAR(4000)) as ENDPOINT_ACTUAL_VALUE_RAW,
    cast(hist.endpoint_repeat_cnt as NUMBER) as ENDPOINT_REPEAT_COUNT
    FROM
      oceanbase.__all_table t
    JOIN
      oceanbase.__all_database db
      ON db.tenant_id = t.tenant_id
      AND db.database_id = t.database_id
      and t.tenant_id = 0
    JOIN
      oceanbase.__all_column c
      ON c.tenant_id = t.tenant_id
      AND c.table_id = t.table_id
    JOIN
      oceanbase.__all_part part
      on t.tenant_id = part.tenant_id
      and t.table_id = part.table_id
    JOIN
      oceanbase.__all_histogram_stat hist
      ON c.table_id = hist.table_id
      AND c.column_id = hist.column_id
      AND part.part_id = hist.partition_id
      AND hist.object_type = 2
  WHERE
    c.is_hidden = 0
    AND t.table_type in (0,3,6,14)
    AND t.table_mode >> 12 & 15 in (0,1)
    AND part.partition_type = 0
    AND t.index_attributes_set & 16 = 0
  """.replace("\n", " ")
)

def_table_schema(
    owner = 'jiangxiu.wt',
    table_name      = 'DBA_SUBPART_HISTOGRAMS',
    table_id        = '21257',
    table_type      = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """select
    cast(db.database_name as CHAR(128)) as OWNER,
    cast(t.table_name as CHAR(128)) as  TABLE_NAME,
    cast(subpart.sub_part_name as CHAR(128)) as SUBPARTITION_NAME,
    cast(c.column_name as CHAR(128)) as  COLUMN_NAME,
    cast(hist.endpoint_num as NUMBER) as  ENDPOINT_NUMBER,
    cast(NULL as NUMBER) as  ENDPOINT_VALUE,
    cast(hist.endpoint_value as CHAR(4000)) as ENDPOINT_ACTUAL_VALUE,
    cast(hist.b_endpoint_value as CHAR(4000)) as ENDPOINT_ACTUAL_VALUE_RAW,
    cast(hist.endpoint_repeat_cnt as NUMBER) as ENDPOINT_REPEAT_COUNT
    FROM
      oceanbase.__all_table t
    JOIN
      oceanbase.__all_database db
      ON db.tenant_id = t.tenant_id
      AND db.database_id = t.database_id
      and t.tenant_id = 0
    JOIN
      oceanbase.__all_column c
      ON c.tenant_id = t.tenant_id
      AND c.table_id = t.table_id
    JOIN
      oceanbase.__all_sub_part subpart
      on t.tenant_id = subpart.tenant_id
      and t.table_id = subpart.table_id
    JOIN
      oceanbase.__all_histogram_stat hist
      ON c.table_id = hist.table_id
      AND c.column_id = hist.column_id
      AND hist.partition_id = subpart.sub_part_id
      AND hist.object_type = 3
  WHERE
    c.is_hidden = 0
    AND t.table_type in (0,3,6,14)
    AND t.table_mode >> 12 & 15 in (0,1)
    AND subpart.partition_type = 0
    AND t.index_attributes_set & 16 = 0
  """.replace("\n", " ")
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name      = 'DBA_TAB_STATS_HISTORY',
  table_id        = '21258',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  SELECT
    CAST(DB.DATABASE_NAME AS     CHAR(128)) AS OWNER,
    CAST(V.TABLE_NAME       AS  CHAR(128)) AS TABLE_NAME,
    CAST(V.PARTITION_NAME   AS  CHAR(128)) AS PARTITION_NAME,
    CAST(V.SUBPARTITION_NAME  AS    CHAR(128)) AS SUBPARTITION_NAME,
    CAST(STAT.SAVTIME AS DATETIME(6)) AS STATS_UPDATE_TIME
    FROM
    (
      (SELECT CAST(0 AS SIGNED) AS TENANT_ID,
              DATABASE_ID,
              TABLE_ID,
              -2 AS PARTITION_ID,
              TABLE_NAME,
              NULL AS PARTITION_NAME,
              NULL AS SUBPARTITION_NAME,
              NULL AS PARTITION_POSITION,
              NULL AS SUBPARTITION_POSITION,
              'TABLE' AS OBJECT_TYPE
          FROM
            OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE
          WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
      UNION ALL
        SELECT TENANT_ID,
               DATABASE_ID,
               TABLE_ID,
               CASE WHEN PART_LEVEL = 0 THEN -2 ELSE -1 END AS PARTITION_ID,
               TABLE_NAME,
               NULL AS PARTITION_NAME,
               NULL AS SUBPARTITION_NAME,
               NULL AS PARTITION_POSITION,
                NULL AS SUBPARTITION_POSITION,
               'TABLE' AS OBJECT_TYPE
        FROM
            oceanbase.__all_table T
        WHERE T.TABLE_TYPE IN (0,3,6,14)
        AND T.TABLE_MODE >> 12 & 15 in (0,1)
        AND T.INDEX_ATTRIBUTES_SET & 16 = 0)
    UNION ALL
        SELECT T.TENANT_ID,
                T.DATABASE_ID,
                T.TABLE_ID,
                P.PART_ID,
                T.TABLE_NAME,
                P.PART_NAME,
                NULL,
                P.PART_IDX + 1,
                NULL,
                'PARTITION'
        FROM
            oceanbase.__all_table T
          JOIN
            oceanbase.__all_part P
            ON T.TENANT_ID = P.TENANT_ID
            AND T.TABLE_ID = P.TABLE_ID
            AND T.TABLE_MODE >> 12 & 15 in (0,1)
            AND T.INDEX_ATTRIBUTES_SET & 16 = 0
        WHERE T.TABLE_TYPE IN (0,3,6,14)
    UNION ALL
        SELECT T.TENANT_ID,
               T.DATABASE_ID,
               T.TABLE_ID,
               SP.SUB_PART_ID AS PARTITION_ID,
               T.TABLE_NAME,
                 P.PART_NAME,
                 SP.SUB_PART_NAME,
                 P.PART_IDX + 1,
                 SP.SUB_PART_IDX + 1,
                 'SUBPARTITION'
        FROM
            oceanbase.__all_table T
        JOIN
            oceanbase.__all_part P
            ON T.TENANT_ID = P.TENANT_ID
            AND T.TABLE_ID = P.TABLE_ID
            AND T.TABLE_MODE >> 12 & 15 in (0,1)
            AND T.INDEX_ATTRIBUTES_SET & 16 = 0
        JOIN
            oceanbase.__all_sub_part SP
            ON T.TENANT_ID = SP.TENANT_ID
            AND T.TABLE_ID = SP.TABLE_ID
            AND P.PART_ID = SP.PART_ID
        WHERE T.TABLE_TYPE IN (0,3,6,14)
    ) V
    JOIN
        oceanbase.__all_database DB
        ON DB.TENANT_ID = V.TENANT_ID
        AND DB.DATABASE_ID = V.DATABASE_ID
        AND V.TENANT_ID = 0
    LEFT JOIN
        oceanbase.__all_table_stat_history STAT
        ON V.TENANT_ID = STAT.TENANT_ID
        AND V.TABLE_ID = STAT.TABLE_ID
        AND (V.PARTITION_ID = STAT.PARTITION_ID OR V.PARTITION_ID = -2)
        AND STAT.INDEX_TYPE = 0
""".replace("\n", " ")
)

def_table_schema(
    owner = 'jiangxiu.wt',
    table_name     = 'DBA_IND_STATISTICS',
    table_id       = '21259',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """SELECT
    CAST(DB.DATABASE_NAME AS     CHAR(128)) AS OWNER,
    CAST(V.INDEX_NAME AS     CHAR(128)) AS INDEX_NAME,
    CAST(DB.DATABASE_NAME AS     CHAR(128)) AS TABLE_OWNER,
    CAST(T.TABLE_NAME       AS  CHAR(128)) AS TABLE_NAME,
    CAST(V.PARTITION_NAME   AS  CHAR(128)) AS PARTITION_NAME,
    CAST(V.PARTITION_POSITION AS    NUMBER) AS PARTITION_POSITION,
    CAST(V.SUBPARTITION_NAME  AS    CHAR(128)) AS SUBPARTITION_NAME,
    CAST(V.SUBPARTITION_POSITION AS NUMBER) AS SUBPARTITION_POSITION,
    CAST(V.OBJECT_TYPE AS   CHAR(12)) AS OBJECT_TYPE,
    CAST(NULL AS    NUMBER) AS BLEVEL,
    CAST(NULL AS    NUMBER) AS LEAF_BLOCKS,
    CAST(NULL AS    NUMBER) AS DISTINCT_KEYS,
    CAST(NULL AS    NUMBER) AS AVG_LEAF_BLOCKS_PER_KEY,
    CAST(NULL AS    NUMBER) AS AVG_DATA_BLOCKS_PER_KEY,
    CAST(NULL AS    NUMBER) AS CLUSTERING_FACTOR,
    CAST(STAT.ROW_CNT AS    NUMBER) AS NUM_ROWS,
    CAST(NULL AS    NUMBER) AS AVG_CACHED_BLOCKS,
    CAST(NULL AS    NUMBER) AS AVG_CACHE_HIT_RATIO,
    CAST(NULL AS    NUMBER) AS SAMPLE_SIZE,
    CAST(STAT.LAST_ANALYZED AS DATETIME(6)) AS LAST_ANALYZED,
    CAST((CASE STAT.GLOBAL_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS GLOBAL_STATS,
    CAST((CASE STAT.USER_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS USER_STATS,
    CAST((CASE WHEN STAT.STATTYPE_LOCKED & 15 IS NULL THEN NULL ELSE (CASE STAT.STATTYPE_LOCKED & 15 WHEN 0 THEN NULL WHEN 1 THEN 'DATA' WHEN 2 THEN 'CACHE' ELSE 'ALL' END) END) AS CHAR(5)) AS STATTYPE_LOCKED,
    CAST((CASE STAT.STALE_STATS WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END) AS CHAR(3)) AS STALE_STATS,
    CAST(NULL AS    CHAR(7)) AS SCOPE
    FROM
    (
        (SELECT CAST(0 AS SIGNED) AS TENANT_ID,
                DATABASE_ID,
                TABLE_ID,
                DATA_TABLE_ID,
                -2 AS PARTITION_ID,
                SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_')) AS INDEX_NAME,
                NULL AS PARTITION_NAME,
                NULL AS SUBPARTITION_NAME,
                NULL AS PARTITION_POSITION,
                NULL AS SUBPARTITION_POSITION,
                'INDEX' AS OBJECT_TYPE
          FROM
            OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE T
          WHERE T.TABLE_TYPE = 5 AND T.INDEX_TYPE NOT IN (13, 14, 16, 17, 19, 20, 22) AND T.TENANT_ID = EFFECTIVE_TENANT_ID()
        UNION ALL
         SELECT TENANT_ID,
                DATABASE_ID,
                TABLE_ID,
                DATA_TABLE_ID,
                CASE WHEN PART_LEVEL = 0 THEN -2 ELSE -1 END AS PARTITION_ID,
                SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_')) AS INDEX_NAME,
                NULL AS PARTITION_NAME,
                NULL AS SUBPARTITION_NAME,
                NULL AS PARTITION_POSITION,
                NULL AS SUBPARTITION_POSITION,
                'INDEX' AS OBJECT_TYPE
        FROM
            oceanbase.__all_table T
        WHERE T.TABLE_TYPE = 5 AND T.INDEX_TYPE NOT IN (13, 14, 16, 17, 19, 20, 22)
        AND T.TABLE_MODE >> 12 & 15 in (0,1)
        AND T.INDEX_ATTRIBUTES_SET & 16 = 0)
    UNION ALL
        SELECT T.TENANT_ID,
                T.DATABASE_ID,
                T.TABLE_ID,
                T.DATA_TABLE_ID,
                P.PART_ID,
                SUBSTR(T.TABLE_NAME, 7 + INSTR(SUBSTR(T.TABLE_NAME, 7), '_')) AS INDEX_NAME,
                P.PART_NAME,
                NULL,
                P.PART_IDX + 1,
                NULL,
                'PARTITION'
        FROM
            oceanbase.__all_table T
          JOIN
            oceanbase.__all_part P
            ON T.TENANT_ID = P.TENANT_ID
            AND T.TABLE_ID = P.TABLE_ID
        WHERE T.TABLE_TYPE = 5
              AND P.PARTITION_TYPE = 0
              AND T.INDEX_TYPE NOT IN (13, 14, 16, 17, 19, 20, 22)
    UNION ALL
        SELECT T.TENANT_ID,
               T.DATABASE_ID,
               T.TABLE_ID,
               T.DATA_TABLE_ID,
               SP.SUB_PART_ID AS PARTITION_ID,
               SUBSTR(T.TABLE_NAME, 7 + INSTR(SUBSTR(T.TABLE_NAME, 7), '_')) AS INDEX_NAME,
               P.PART_NAME,
               SP.SUB_PART_NAME,
               P.PART_IDX + 1,
               SP.SUB_PART_IDX + 1,
               'SUBPARTITION'
        FROM
            oceanbase.__all_table T
        JOIN
            oceanbase.__all_part P
            ON T.TENANT_ID = P.TENANT_ID
            AND T.TABLE_ID = P.TABLE_ID
        JOIN
            oceanbase.__all_sub_part SP
            ON T.TENANT_ID = SP.TENANT_ID
            AND T.TABLE_ID = SP.TABLE_ID
            AND P.PART_ID = SP.PART_ID
        WHERE T.TABLE_TYPE = 5
              AND P.PARTITION_TYPE = 0
              AND SP.PARTITION_TYPE = 0
              AND T.INDEX_TYPE NOT IN (13, 14, 16, 17, 19, 20, 22)
    ) V
    JOIN oceanbase.__all_table T
         ON T.TABLE_ID = V.DATA_TABLE_ID
         AND T.TENANT_ID = V.TENANT_ID
         AND T.DATABASE_ID = V.DATABASE_ID
    JOIN
        oceanbase.__all_database DB
        ON DB.TENANT_ID = V.TENANT_ID
        AND DB.DATABASE_ID = V.DATABASE_ID
        AND V.TENANT_ID = 0
    LEFT JOIN
        oceanbase.__all_table_stat STAT
        ON V.TENANT_ID = STAT.TENANT_ID
        AND V.TABLE_ID = STAT.TABLE_ID
        AND (V.PARTITION_ID = STAT.PARTITION_ID OR V.PARTITION_ID = -2)
        AND STAT.INDEX_TYPE = 1
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chongrong.th',
  table_name      = 'DBA_OB_BACKUP_JOBS',
  table_id        = '21260',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    JOB_ID,
    INCARNATION,
    BACKUP_SET_ID,
    INITIATOR_TENANT_ID,
    INITIATOR_JOB_ID,
    EXECUTOR_TENANT_ID,
    PLUS_ARCHIVELOG,
    BACKUP_TYPE,
    JOB_LEVEL,
    ENCRYPTION_MODE,
    PASSWD,
    USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
    CASE
      WHEN END_TS = 0
        THEN NULL
      ELSE
        USEC_TO_TIME(END_TS)
      END AS END_TIMESTAMP,
    STATUS,
    RESULT,
    COMMENT,
    DESCRIPTION,
    PATH
    FROM OCEANBASE.__all_virtual_backup_job
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chongrong.th',
  table_name      = 'DBA_OB_BACKUP_JOB_HISTORY',
  table_id        = '21261',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    JOB_ID,
    INCARNATION,
    BACKUP_SET_ID,
    INITIATOR_TENANT_ID,
    INITIATOR_JOB_ID,
    EXECUTOR_TENANT_ID,
    PLUS_ARCHIVELOG,
    BACKUP_TYPE,
    JOB_LEVEL,
    ENCRYPTION_MODE,
    PASSWD,
    USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
    CASE
      WHEN END_TS = 0
        THEN NULL
      ELSE
        USEC_TO_TIME(END_TS)
      END AS END_TIMESTAMP,
    STATUS,
    RESULT,
    COMMENT,
    DESCRIPTION,
    PATH
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_JOB_HISTORY
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chongrong.th',
  table_name      = 'DBA_OB_BACKUP_TASKS',
  table_id        = '21262',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    TASK_ID,
    JOB_ID,
    INCARNATION,
    BACKUP_SET_ID,
    USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
    CASE
      WHEN END_TS = 0
        THEN NULL
      ELSE
        USEC_TO_TIME(END_TS)
      END AS END_TIMESTAMP,
    STATUS,
    START_SCN,
    END_SCN,
    USER_LS_START_SCN,
    ENCRYPTION_MODE,
    PASSWD,
    INPUT_BYTES,
    OUTPUT_BYTES,
    CASE
      WHEN END_TS = 0
        THEN 0
      ELSE
        OUTPUT_BYTES / ((END_TS - START_TS)/1000/1000)
      END AS OUTPUT_RATE_BYTES,
    EXTRA_BYTES AS EXTRA_META_BYTES,
    TABLET_COUNT,
    FINISH_TABLET_COUNT,
    MACRO_BLOCK_COUNT,
    FINISH_MACRO_BLOCK_COUNT,
    FILE_COUNT,
    META_TURN_ID,
    DATA_TURN_ID,
    RESULT,
    COMMENT,
    PATH,
    MINOR_TURN_ID,
    MAJOR_TURN_ID,
    CASE
        WHEN MACRO_BLOCK_COUNT = 0 THEN 0.00
        WHEN FINISH_MACRO_BLOCK_COUNT > MACRO_BLOCK_COUNT THEN 99.99
        ELSE ROUND((FINISH_MACRO_BLOCK_COUNT / MACRO_BLOCK_COUNT) * 100, 2)
    END AS DATA_PROGRESS,
    LOG_FILE_COUNT,
    FINISH_LOG_FILE_COUNT,
    CASE
        WHEN LOG_FILE_COUNT = 0 THEN 0.00
        WHEN FINISH_LOG_FILE_COUNT > LOG_FILE_COUNT THEN 99.99
        ELSE ROUND((FINISH_LOG_FILE_COUNT / LOG_FILE_COUNT) * 100, 2)
    END AS LOG_PROGRESS
    FROM OCEANBASE.__all_virtual_backup_task
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chongrong.th',
  table_name      = 'DBA_OB_BACKUP_TASK_HISTORY',
  table_id        = '21263',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    TASK_ID,
    JOB_ID,
    INCARNATION,
    BACKUP_SET_ID,
    USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
    CASE
      WHEN END_TS = 0
        THEN NULL
      ELSE
        USEC_TO_TIME(END_TS)
      END AS END_TIMESTAMP,
    STATUS,
    START_SCN,
    END_SCN,
    USER_LS_START_SCN,
    ENCRYPTION_MODE,
    PASSWD,
    INPUT_BYTES,
    OUTPUT_BYTES,
    CASE
      WHEN END_TS = 0
        THEN 0
      ELSE
        OUTPUT_BYTES / ((END_TS - START_TS)/1000/1000)
      END AS OUTPUT_RATE_BYTES,
    EXTRA_BYTES AS EXTRA_META_BYTES,
    TABLET_COUNT,
    FINISH_TABLET_COUNT,
    MACRO_BLOCK_COUNT,
    FINISH_MACRO_BLOCK_COUNT,
    FILE_COUNT,
    META_TURN_ID,
    DATA_TURN_ID,
    RESULT,
    COMMENT,
    PATH,
    MINOR_TURN_ID,
    MAJOR_TURN_ID
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_TASK_HISTORY
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'chongrong.th',
  table_name      = 'DBA_OB_BACKUP_SET_FILES',
  table_id        = '21264',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    BACKUP_SET_ID,
    DEST_ID,
    INCARNATION,
    BACKUP_TYPE,
    PREV_FULL_BACKUP_SET_ID,
    PREV_INC_BACKUP_SET_ID,
    USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
    CASE
      WHEN END_TS = 0
          THEN NULL
      ELSE
          USEC_TO_TIME(END_TS)
      END AS END_TIMESTAMP,
    STATUS,
    FILE_STATUS,
    CASE
      WHEN END_TS = 0
        THEN 0
      ELSE
        ROUND((END_TS - START_TS)/1000/1000,0)
      END AS ELAPSED_SECONDES,
    PLUS_ARCHIVELOG,
    START_REPLAY_SCN,
    CASE
      WHEN START_REPLAY_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(START_REPLAY_SCN)
      END AS START_REPLAY_SCN_DISPLAY,
    MIN_RESTORE_SCN,
    CASE
      WHEN MIN_RESTORE_SCN_DISPLAY != ''
        THEN MIN_RESTORE_SCN_DISPLAY
      WHEN MIN_RESTORE_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(MIN_RESTORE_SCN)
      END AS MIN_RESTORE_SCN_DISPLAY,
    INPUT_BYTES,
    OUTPUT_BYTES,
    CASE
      WHEN END_TS = 0
        THEN 0
      ELSE
        OUTPUT_BYTES / ((END_TS - START_TS)/1000/1000)
      END AS OUTPUT_RATE_BYTES,
    EXTRA_BYTES AS EXTRA_META_BYTES,
    TABLET_COUNT,
    FINISH_TABLET_COUNT,
    MACRO_BLOCK_COUNT,
    FINISH_MACRO_BLOCK_COUNT,
    FILE_COUNT,
    META_TURN_ID,
    DATA_TURN_ID,
    RESULT,
    COMMENT,
    ENCRYPTION_MODE,
    PASSWD,
    TENANT_COMPATIBLE,
    BACKUP_COMPATIBLE,
    PATH,
    CLUSTER_VERSION,
    CONSISTENT_SCN,
    MINOR_TURN_ID,
    MAJOR_TURN_ID
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_SET_FILES
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
    owner = 'yibo.tyf',
    table_name     = 'DBA_SQL_PLAN_BASELINES',
    table_id       = '21265',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """SELECT
    CAST(ITEM.PLAN_HASH_VALUE     AS UNSIGNED) AS SIGNATURE,
    CAST(ITEM.SQL_ID              AS CHAR(32)) AS SQL_HANDLE,
    ITEM.ORIGIN_SQL AS SQL_TEXT,
    CAST(ITEM.PLAN_HASH_VALUE     AS CHAR(128)) AS PLAN_NAME,
    CAST(DB.DATABASE_NAME         AS CHAR(128)) AS CREATOR,
    CAST((CASE ITEM.ORIGIN WHEN 1 THEN 'AUTO-CAPTURE' WHEN 2 THEN 'MANUAL-LOAD' ELSE NULL END) AS CHAR(29)) AS ORIGIN,
    CAST(NULL                     AS CHAR(128)) AS PARSING_SCHEMA_NAME,
    CAST(ITEM.DESCRIPTION         AS CHAR(500)) AS DESCRIPTION,
    CAST(ITEM.DB_VERSION          AS CHAR(256)) AS VERSION,
    ITEM.GMT_CREATE AS CREATED,
    ITEM.GMT_MODIFIED AS LAST_MODIFIED,
    CAST(ITEM.LAST_EXECUTED       AS SIGNED) AS LAST_EXECUTED,
    CAST(ITEM.LAST_VERIFIED       AS SIGNED) AS LAST_VERIFIED,
    CAST(CASE WHEN (ITEM.FLAGS & 1) > 0 THEN 'YES' ELSE 'NO' END  AS CHAR(3)) AS ENABLED,
    CAST(CASE WHEN (ITEM.FLAGS & 2) > 0 THEN 'YES' ELSE 'NO' END  AS CHAR(3)) AS ACCEPTED,
    CAST(CASE WHEN (ITEM.FLAGS & 4) > 0 THEN 'YES' ELSE 'NO' END  AS CHAR(3)) AS FIXED,
    CAST(CASE WHEN (ITEM.FLAGS & 16) > 0 THEN 'YES' ELSE 'NO' END  AS CHAR(3)) AS REPRODUCED,
    CAST(CASE WHEN (ITEM.FLAGS & 8) > 0 THEN 'YES' ELSE 'NO' END  AS CHAR(3)) AS AUTOPURGE,
    CAST('NO'                     AS CHAR(3)) AS ADAPTIVE,
    CAST(ITEM.OPTIMIZER_COST      AS SIGNED) AS OPTIMIZER_COST,
    CAST(NULL                     AS CHAR(64)) AS MODULE,
    CAST(NULL                     AS CHAR(64)) AS ACTION,
    CAST(ITEM.EXECUTIONS          AS SIGNED) AS EXECUTIONS,
    CAST(ITEM.ELAPSED_TIME        AS SIGNED) AS ELAPSED_TIME,
    CAST(ITEM.CPU_TIME            AS SIGNED) AS CPU_TIME,
    CAST(NULL                     AS SIGNED) AS BUFFER_GETS,
    CAST(NULL                     AS SIGNED) AS DISK_READS,
    CAST(NULL                     AS SIGNED) AS DIRECT_WRITES,
    CAST(NULL                     AS SIGNED) AS ROWS_PROCESSED,
    CAST(NULL                     AS SIGNED) AS FETCHES,
    CAST(NULL                     AS SIGNED) AS END_OF_FETCH_COUNT
    FROM
      oceanbase.__all_plan_baseline_item ITEM,
      oceanbase.__all_database DB
    WHERE ITEM.DATABASE_ID = DB.DATABASE_ID
""".replace("\n", " ")
)

def_table_schema(
    owner = 'yibo.tyf',
    table_name     = 'DBA_SQL_MANAGEMENT_CONFIG',
    table_id       = '21266',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """SELECT
    CAST(CONFIG.NAME          AS CHAR(128)) AS PARAMETER_NAME,
    CAST(CONFIG.VALUE         AS CHAR(4000)) AS PARAMETER_VALUE,
    CONFIG.GMT_MODIFIED  AS LAST_MODIFIED,
    CAST(DB.DATABASE_NAME     AS CHAR(128)) AS MODIFIED_BY
    FROM
      oceanbase.__all_spm_config CONFIG
      LEFT JOIN oceanbase.__all_database DB
      ON CONFIG.MODIFIED_BY = DB.DATABASE_ID
""".replace("\n", " ")
)

def_table_schema(
  owner = 'roland.qk',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'GV$ACTIVE_SESSION_HISTORY',
  table_id        = '21267',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """SELECT SVR_IP,
SVR_PORT,
SAMPLE_ID,
SAMPLE_TIME,
CON_ID,
USER_ID,
SESSION_ID,
SESSION_TYPE,
SESSION_STATE,
SQL_ID,
PLAN_ID,
TRACE_ID,
EVENT,
EVENT_NO,
EVENT_ID,
P1TEXT,
P1,
P2TEXT,
P2,
P3TEXT,
P3,
WAIT_CLASS,
WAIT_CLASS_ID,
TIME_WAITED,
SQL_PLAN_LINE_ID,
GROUP_ID,
PLAN_HASH,
THREAD_ID,
STMT_TYPE,
TIME_MODEL,
IN_PARSE,
IN_PL_PARSE,
IN_PLAN_CACHE,
IN_SQL_OPTIMIZE,
IN_SQL_EXECUTION,
IN_PX_EXECUTION,
IN_SEQUENCE_LOAD,
IN_COMMITTING,
IN_STORAGE_READ,
IN_STORAGE_WRITE,
IN_REMOTE_DAS_EXECUTION,
IN_FILTER_ROWS,
IN_RPC_ENCODE,
IN_RPC_DECODE,
IN_CONNECTION_MGR,
PROGRAM,
MODULE,
ACTION,
CLIENT_ID,
BACKTRACE,
TM_DELTA_TIME,
TM_DELTA_CPU_TIME,
TM_DELTA_DB_TIME,
TOP_LEVEL_SQL_ID,
IN_PLSQL_COMPILATION,
IN_PLSQL_EXECUTION,
PLSQL_ENTRY_OBJECT_ID,
PLSQL_ENTRY_SUBPROGRAM_ID,
PLSQL_ENTRY_SUBPROGRAM_NAME,
PLSQL_OBJECT_ID,
PLSQL_SUBPROGRAM_ID,
PLSQL_SUBPROGRAM_NAME,
TX_ID,
BLOCKING_SESSION_ID,
TABLET_ID,
PROXY_SID FROM oceanbase.GV$OB_ACTIVE_SESSION_HISTORY
""".replace("\n", " "),
  normal_columns  = [],
)

def_table_schema(
  owner = 'xiaochu.yh',
  tablegroup_id   = 'OB_INVALID_ID',
  table_name      = 'V$ACTIVE_SESSION_HISTORY',
  table_id        = '21268',
  gm_columns      = [],
  rowkey_columns  = [],
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  view_definition = """SELECT SVR_IP,
SVR_PORT,
SAMPLE_ID,
SAMPLE_TIME,
CON_ID,
USER_ID,
SESSION_ID,
SESSION_TYPE,
SESSION_STATE,
SQL_ID,
PLAN_ID,
TRACE_ID,
EVENT,
EVENT_NO,
EVENT_ID,
P1TEXT,
P1,
P2TEXT,
P2,
P3TEXT,
P3,
WAIT_CLASS,
WAIT_CLASS_ID,
TIME_WAITED,
SQL_PLAN_LINE_ID,
GROUP_ID,
PLAN_HASH,
THREAD_ID,
STMT_TYPE,
TIME_MODEL,
IN_PARSE,
IN_PL_PARSE,
IN_PLAN_CACHE,
IN_SQL_OPTIMIZE,
IN_SQL_EXECUTION,
IN_PX_EXECUTION,
IN_SEQUENCE_LOAD,
IN_COMMITTING,
IN_STORAGE_READ,
IN_STORAGE_WRITE,
IN_REMOTE_DAS_EXECUTION,
IN_FILTER_ROWS,
IN_RPC_ENCODE,
IN_RPC_DECODE,
IN_CONNECTION_MGR,
PROGRAM,
MODULE,
ACTION,
CLIENT_ID,
BACKTRACE,
TM_DELTA_TIME,
TM_DELTA_CPU_TIME,
TM_DELTA_DB_TIME,
TOP_LEVEL_SQL_ID,
IN_PLSQL_COMPILATION,
IN_PLSQL_EXECUTION,
PLSQL_ENTRY_OBJECT_ID,
PLSQL_ENTRY_SUBPROGRAM_ID,
PLSQL_ENTRY_SUBPROGRAM_NAME,
PLSQL_OBJECT_ID,
PLSQL_SUBPROGRAM_ID,
PLSQL_SUBPROGRAM_NAME,
TX_ID,
BLOCKING_SESSION_ID,
TABLET_ID,
PROXY_SID
FROM oceanbase.gv$active_session_history WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " "),
  normal_columns  = [],
)

def_table_schema(
    owner = 'jiangxiu.wt',
    table_name     = 'GV$DML_STATS',
    table_id       = '21269',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """SELECT
          CAST(SVR_IP AS CHAR(46)) AS SVR_IP,
          CAST(SVR_PORT AS SIGNED) AS SVR_PORT,
          CAST(TENANT_ID AS SIGNED) AS INST_ID,
          CAST(TABLE_ID AS SIGNED) AS OBJN,
          CAST(INSERT_ROW_COUNT AS SIGNED) AS INS,
          CAST(UPDATE_ROW_COUNT AS SIGNED) AS UPD,
          CAST(DELETE_ROW_COUNT AS SIGNED) AS DEL,
          CAST(NULL AS SIGNED) AS DROPSEG,
          CAST(NULL AS SIGNED) AS CURROWS,
          CAST(TABLET_ID AS SIGNED) AS PAROBJN,
          CAST(NULL AS SIGNED) AS LASTUSED,
          CAST(NULL AS SIGNED) AS FLAGS,
          CAST(NULL AS SIGNED) AS CON_ID
          FROM oceanbase.__all_virtual_dml_stats
""".replace("\n", " ")
)

def_table_schema(
    owner = 'jiangxiu.wt',
    table_name     = 'V$DML_STATS',
    table_id       = '21270',
    table_type = 'SYSTEM_VIEW',
    rowkey_columns  = [],
    normal_columns  = [],
    gm_columns      = [],
    in_tenant_space = True,
    view_definition = """
    SELECT SVR_IP,
    SVR_PORT,
    INST_ID,
    OBJN,
    INS,
    UPD,
    DEL,
    DROPSEG,
    CURROWS,
    PAROBJN,
    LASTUSED,
    FLAGS,
    CON_ID FROM oceanbase.GV$DML_STATS WHERE SVR_IP=HOST_IP() AND SVR_PORT=RPC_PORT()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'jiangxiu.wt',
  table_name      = 'DBA_TAB_MODIFICATIONS',
  table_id        = '21271',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """SELECT
  CAST(DB.DATABASE_NAME AS     CHAR(128)) AS TABLE_OWNER,
  CAST(T.TABLE_NAME AS         CHAR(128)) AS TABLE_NAME,
  CAST(P.PART_NAME AS     CHAR(128)) AS PARTITION_NAME,
  CAST(SP.SUB_PART_NAME AS CHAR(128)) AS SUBPARTITION_NAME,
  CAST(V.INSERTS AS     SIGNED) AS INSERTS,
  CAST(V.UPDATES AS     SIGNED) AS UPDATES,
  CAST(V.DELETES AS     SIGNED) AS DELETES,
  CAST(V.MODIFIED_TIME AS DATE) AS TIMESTAMP,
  CAST(NULL AS     CHAR(3)) AS TRUNCATED,
  CAST(NULL AS     SIGNED) AS DROP_SEGMENTS
  FROM
    (SELECT
     CASE WHEN T.TENANT_ID IS NOT NULL THEN T.TENANT_ID ELSE 0 END AS TENANT_ID,
     CASE WHEN T.TABLE_ID IS NOT NULL THEN T.TABLE_ID ELSE VT.TABLE_ID END AS TABLE_ID,
     CASE WHEN T.TABLET_ID IS NOT NULL THEN T.TABLET_ID ELSE VT.TABLET_ID END AS TABLET_ID,

     CASE WHEN T.TABLET_ID IS NOT NULL AND VT.TABLET_ID IS NOT NULL THEN T.INSERTS + VT.INSERT_ROW_COUNT - T.LAST_INSERTS ELSE
       (CASE WHEN T.TABLET_ID IS NOT NULL THEN T.INSERTS - T.LAST_INSERTS ELSE VT.INSERT_ROW_COUNT END) END AS INSERTS,

     CASE WHEN T.TABLET_ID IS NOT NULL AND VT.TABLET_ID IS NOT NULL THEN T.UPDATES + VT.UPDATE_ROW_COUNT - T.LAST_UPDATES  ELSE
       (CASE WHEN T.TABLET_ID IS NOT NULL THEN T.UPDATES - T.LAST_UPDATES  ELSE VT.UPDATE_ROW_COUNT END) END AS UPDATES,

     CASE WHEN T.TABLET_ID IS NOT NULL AND VT.TABLET_ID IS NOT NULL THEN T.DELETES + VT.DELETE_ROW_COUNT - T.LAST_DELETES ELSE
       (CASE WHEN T.TABLET_ID IS NOT NULL THEN T.DELETES - T.LAST_DELETES ELSE VT.DELETE_ROW_COUNT END) END AS DELETES,

     CASE WHEN T.GMT_MODIFIED IS NOT NULL THEN T.GMT_MODIFIED ELSE NULL END AS MODIFIED_TIME
     FROM
     OCEANBASE.__ALL_MONITOR_MODIFIED T
     FULL JOIN
     OCEANBASE.__ALL_VIRTUAL_DML_STATS VT
     ON T.TABLET_ID = VT.TABLET_ID AND VT.TENANT_ID = EFFECTIVE_TENANT_ID()
    )V
    JOIN OCEANBASE.__ALL_TABLE T
         ON V.TENANT_ID = T.TENANT_ID
         AND V.TABLE_ID = T.TABLE_ID
         AND T.TABLE_TYPE in (0, 3, 6)
         AND T.TABLE_MODE >> 12 & 15 in (0,1)
         AND T.INDEX_ATTRIBUTES_SET & 16 = 0
    JOIN
        OCEANBASE.__ALL_DATABASE DB
        ON T.TENANT_ID = DB.TENANT_ID
        AND DB.DATABASE_ID = T.DATABASE_ID
    LEFT JOIN
        OCEANBASE.__ALL_PART P
        ON V.TENANT_ID = P.TENANT_ID
        AND V.TABLE_ID = P.TABLE_ID
        AND V.TABLET_ID = P.TABLET_ID
    LEFT JOIN
        OCEANBASE.__ALL_SUB_PART SP
        ON V.TENANT_ID = SP.TENANT_ID
        AND V.TABLE_ID = SP.TABLE_ID
        AND V.TABLET_ID = SP.TABLET_ID
  """.replace("\n", " ")
)

def_table_schema(
  owner = 'fyy280124',
  table_name      = 'DBA_SCHEDULER_JOBS',
  table_id        = '21272',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """SELECT
    CAST(T.POWNER AS CHAR(128)) AS OWNER,
    CAST(T.JOB_NAME AS CHAR(128)) AS JOB_NAME,
    CAST(NULL AS CHAR(128)) AS JOB_SUBNAME,
    CAST(T.JOB_STYLE AS CHAR(17)) AS JOB_STYLE,
    CAST(NULL AS CHAR(128)) AS JOB_CREATOR,
    CAST(NULL AS CHAR(65)) AS CLIENT_ID,
    CAST(NULL AS CHAR(33)) AS GLOBAL_UID,
    CAST(T.POWNER AS CHAR(4000)) AS PROGRAM_OWNER,
    CAST(T.PROGRAM_NAME AS CHAR(4000)) AS PROGRAM_NAME,
    CAST(T.JOB_TYPE AS CHAR(16)) AS JOB_TYPE,
    CAST(T.JOB_ACTION AS CHAR(4000)) AS JOB_ACTION,
    CAST(T.NUMBER_OF_ARGUMENT AS SIGNED) AS NUMBER_OF_ARGUMENTS,
    CAST(NULL AS CHAR(4000)) AS SCHEDULE_OWNER,
    CAST(NULL AS CHAR(4000)) AS SCHEDULE_NAME,
    CAST(NULL AS CHAR(12)) AS SCHEDULE_TYPE,
    CAST(T.START_DATE AS DATETIME(6)) AS START_DATE,
    CAST(T.REPEAT_INTERVAL AS CHAR(4000)) AS REPEAT_INTERVAL,
    CAST(NULL AS CHAR(128)) AS EVENT_QUEUE_OWNER,
    CAST(NULL AS CHAR(128)) AS EVENT_QUEUE_NAME,
    CAST(NULL AS CHAR(523)) AS EVENT_QUEUE_AGENT,
    CAST(NULL AS CHAR(4000)) AS EVENT_CONDITION,
    CAST(NULL AS CHAR(261)) AS EVENT_RULE,
    CAST(NULL AS CHAR(261)) AS FILE_WATCHER_OWNER,
    CAST(NULL AS CHAR(261)) AS FILE_WATCHER_NAME,
    CAST(T.END_DATE AS DATETIME(6)) AS END_DATE,
    CAST(T.JOB_CLASS AS CHAR(128)) AS JOB_CLASS,
    CAST(T.ENABLED AS CHAR(5)) AS ENABLED,
    CAST(T.AUTO_DROP AS CHAR(5)) AS AUTO_DROP,
    CAST(NULL AS CHAR(5)) AS RESTART_ON_RECOVERY,
    CAST(NULL AS CHAR(5)) AS RESTART_ON_FAILURE,
    CAST(T.STATE AS CHAR(15)) AS STATE,
    CAST(NULL AS SIGNED) AS JOB_PRIORITY,
    CAST(T.RUN_COUNT AS SIGNED) AS RUN_COUNT,
    CAST(NULL AS SIGNED) AS MAX_RUNS,
    CAST(T.FAILURES AS SIGNED) AS FAILURE_COUNT,
    CAST(NULL AS SIGNED) AS MAX_FAILURES,
    CAST(T.RETRY_COUNT AS SIGNED) AS RETRY_COUNT,
    CAST(T.LAST_DATE AS DATETIME(6)) AS LAST_START_DATE,
    CAST(T.LAST_RUN_DURATION AS SIGNED) AS LAST_RUN_DURATION,
    CAST(T.NEXT_DATE AS DATETIME(6)) AS NEXT_RUN_DATE,
    CAST(NULL AS SIGNED) AS SCHEDULE_LIMIT,
    CAST(T.MAX_RUN_DURATION AS SIGNED) AS MAX_RUN_DURATION,
    CAST(NULL AS CHAR(11)) AS LOGGING_LEVEL,
    CAST(NULL AS CHAR(5)) AS STORE_OUTPUT,
    CAST(NULL AS CHAR(5)) AS STOP_ON_WINDOW_CLOSE,
    CAST(NULL AS CHAR(5)) AS INSTANCE_STICKINESS,
    CAST(NULL AS CHAR(4000)) AS RAISE_EVENTS,
    CAST(NULL AS CHAR(5)) AS SYSTEM,
    CAST(NULL AS SIGNED) AS JOB_WEIGHT,
    CAST(T.NLSENV AS CHAR(4000)) AS NLS_ENV,
    CAST(NULL AS CHAR(128)) AS SOURCE,
    CAST(NULL AS SIGNED) AS NUMBER_OF_DESTINATIONS,
    CAST(NULL AS CHAR(261)) AS DESTINATION_OWNER,
    CAST(NULL AS CHAR(261)) AS DESTINATION,
    CAST(NULL AS CHAR(128)) AS CREDENTIAL_OWNER,
    CAST(NULL AS CHAR(128)) AS CREDENTIAL_NAME,
    CAST(T.FIELD1 AS CHAR(128)) AS INSTANCE_ID,
    CAST(NULL AS CHAR(5)) AS DEFERRED_DROP,
    CAST(NULL AS CHAR(5)) AS ALLOW_RUNS_IN_RESTRICTED_MODE,
    CAST(T.COMMENTS AS CHAR(4000)) AS COMMENTS,
    CAST(T.FLAG AS SIGNED) AS FLAGS,
    CAST(NULL AS CHAR(5)) AS RESTARTABLE,
    CAST(NULL AS CHAR(128)) AS CONNECT_CREDENTIAL_OWNER,
    CAST(NULL AS CHAR(128)) AS CONNECT_CREDENTIAL_NAME
  FROM oceanbase.__all_tenant_scheduler_job T WHERE T.JOB_NAME != '__dummy_guard' and T.JOB > 0
""".replace("\n", " ")
)

def_table_schema(
    owner = 'guoyun.lgy',
    table_name     = 'DBA_OB_OUTLINE_CONCURRENT_HISTORY',
    table_id       = '21273',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
    SELECT
      GMT_CREATE AS CREATE_TIME,
      GMT_MODIFIED AS MODIFY_TIME,
      CAST(EFFECTIVE_TENANT_ID() AS SIGNED) AS TENANT_ID,
      DATABASE_ID,
      OUTLINE_ID,
      NAME AS OUTLINE_NAME,
      SQL_TEXT,
      OUTLINE_PARAMS,
      OUTLINE_TARGET,
      CAST(SQL_ID AS CHAR(32)) AS SQL_ID,
      OUTLINE_CONTENT,
      CASE WHEN IS_DELETED = 1 THEN 'YES' ELSE 'NO' END AS IS_DELETED,
      CASE WHEN ENABLED = 1 THEN 'YES' ELSE 'NO' END AS ENABLED
    FROM oceanbase.__all_outline_history
""".replace("\n", " "),

    normal_columns = [
    ],
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'CDB_OB_BACKUP_STORAGE_INFO_HISTORY',
  table_id        = '21274',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    PATH,
    ENDPOINT,
    DEST_ID,
    DEST_TYPE,
    AUTHORIZATION,
    EXTENSION,
    CHECK_FILE_NAME,
    USEC_TO_TIME(LAST_CHECK_TIME) AS LAST_CHECK_TIMESTAMP,
    MAX_IOPS,
    MAX_BANDWIDTH,
    CASE
      WHEN MAX_BANDWIDTH = 0
        THEN "UNLIMITED"
      WHEN MAX_BANDWIDTH >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024/1024/1024,2), 'PB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024/1024,2), 'TB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024,2), 'GB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024,2), 'MB/s')
      WHEN MAX_BANDWIDTH >= 1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024,2), 'KB/s')
      ELSE
        CONCAT(ROUND(MAX_BANDWIDTH,2), 'B/s')
    END AS MAX_BANDWIDTH_DISPLAY
    FROM oceanbase.__all_virtual_backup_storage_info_history
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'DBA_OB_BACKUP_STORAGE_INFO',
  table_id        = '21275',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    TENANT_ID,
    PATH,
    ENDPOINT,
    DEST_ID,
    DEST_TYPE,
    AUTHORIZATION,
    EXTENSION,
    CHECK_FILE_NAME,
    USEC_TO_TIME(LAST_CHECK_TIME) AS LAST_CHECK_TIMESTAMP,
    MAX_IOPS,
    MAX_BANDWIDTH,
    CASE
      WHEN MAX_BANDWIDTH = 0
        THEN "UNLIMITED"
      WHEN MAX_BANDWIDTH >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024/1024/1024,2), 'PB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024/1024,2), 'TB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024,2), 'GB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024,2), 'MB/s')
      WHEN MAX_BANDWIDTH >= 1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024,2), 'KB/s')
      ELSE
        CONCAT(ROUND(MAX_BANDWIDTH,2), 'B/s')
    END AS MAX_BANDWIDTH_DISPLAY
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_STORAGE_INFO
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'DBA_OB_BACKUP_STORAGE_INFO_HISTORY',
  table_id        = '21276',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    TENANT_ID,
    PATH,
    ENDPOINT,
    DEST_ID,
    DEST_TYPE,
    AUTHORIZATION,
    EXTENSION,
    CHECK_FILE_NAME,
    USEC_TO_TIME(LAST_CHECK_TIME) AS LAST_CHECK_TIMESTAMP,
    MAX_IOPS,
    MAX_BANDWIDTH,
    CASE
      WHEN MAX_BANDWIDTH = 0
        THEN "UNLIMITED"
      WHEN MAX_BANDWIDTH >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024/1024/1024,2), 'PB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024/1024,2), 'TB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024/1024,2), 'GB/s')
      WHEN MAX_BANDWIDTH >= 1024*1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024/1024,2), 'MB/s')
      WHEN MAX_BANDWIDTH >= 1024
        THEN CONCAT(ROUND(MAX_BANDWIDTH/1024,2), 'KB/s')
      ELSE
        CONCAT(ROUND(MAX_BANDWIDTH,2), 'B/s')
    END AS MAX_BANDWIDTH_DISPLAY
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_STORAGE_INFO_HISTORY
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'DBA_OB_BACKUP_DELETE_POLICY',
  table_id        = '21277',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      POLICY_NAME,
      RECOVERY_WINDOW
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_DELETE_POLICY
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'DBA_OB_BACKUP_DELETE_JOBS',
  table_id        = '21278',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      JOB_ID,
      INCARNATION,
      INITIATOR_TENANT_ID,
      INITIATOR_JOB_ID,
      EXECUTOR_TENANT_ID,
      TYPE,
      USEC_TO_TIME(PARAMETER) AS PARAMETER,
      JOB_LEVEL,
      USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
      CASE
        WHEN END_TS = 0
          THEN NULL
        ELSE
          USEC_TO_TIME(END_TS)
        END AS END_TIMESTAMP,
      STATUS,
      TASK_COUNT,
      SUCCESS_TASK_COUNT,
      RESULT,
      COMMENT
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_DELETE_JOB
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'DBA_OB_BACKUP_DELETE_JOB_HISTORY',
  table_id        = '21279',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      JOB_ID,
      INCARNATION,
      INITIATOR_TENANT_ID,
      INITIATOR_JOB_ID,
      EXECUTOR_TENANT_ID,
      TYPE,
      USEC_TO_TIME(PARAMETER) AS PARAMETER,
      JOB_LEVEL,
      USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
      CASE
        WHEN END_TS = 0
          THEN NULL
        ELSE
          USEC_TO_TIME(END_TS)
        END AS END_TIMESTAMP,
      STATUS,
      TASK_COUNT,
      SUCCESS_TASK_COUNT,
      RESULT,
      COMMENT
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_DELETE_JOB_HISTORY
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'DBA_OB_BACKUP_DELETE_TASKS',
  table_id        = '21280',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      TASK_ID,
      INCARNATION,
      JOB_ID,
      TASK_TYPE,
      ID,
      ROUND_ID,
      DEST_ID,
      USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
      CASE
        WHEN END_TS = 0
          THEN NULL
        ELSE
          USEC_TO_TIME(END_TS)
        END AS END_TIMESTAMP,
      STATUS,
      TOTAL_LS_COUNT,
      FINISH_LS_COUNT,
      RESULT,
      COMMENT,
      PATH
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_DELETE_TASK
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wenjinyu.wjy',
  table_name      = 'DBA_OB_BACKUP_DELETE_TASK_HISTORY',
  table_id        = '21281',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      TASK_ID,
      INCARNATION,
      JOB_ID,
      TASK_TYPE,
      ID,
      ROUND_ID,
      DEST_ID,
      USEC_TO_TIME(START_TS) AS START_TIMESTAMP,
      CASE
        WHEN END_TS = 0
          THEN NULL
        ELSE
          USEC_TO_TIME(END_TS)
        END AS END_TIMESTAMP,
      STATUS,
      TOTAL_LS_COUNT,
      FINISH_LS_COUNT,
      RESULT,
      COMMENT,
      PATH
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_DELETE_TASK_HISTORY
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)


def_table_schema(
    owner = 'xiaoyi.xy',
    table_name     = 'DBA_OB_OUTLINES',
    table_id       = '21282',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
    SELECT
      B.GMT_CREATE AS CREATE_TIME,
      B.GMT_MODIFIED AS MODIFY_TIME,
      A.TENANT_ID,
      A.DATABASE_ID,
      A.OUTLINE_ID,
      A.DATABASE_NAME,
      A.OUTLINE_NAME,
      A.VISIBLE_SIGNATURE,
      A.SQL_TEXT,
      A.OUTLINE_TARGET,
      A.OUTLINE_SQL,
      A.SQL_ID,
      A.OUTLINE_CONTENT
    FROM oceanbase.__tenant_virtual_outline A, oceanbase.__all_outline B
    WHERE A.OUTLINE_ID = B.OUTLINE_ID AND B.FORMAT_OUTLINE = 0
""".replace("\n", " "),

    normal_columns = [
    ],
)

def_table_schema(
    owner = 'xiaoyi.xy',
    table_name     = 'DBA_OB_CONCURRENT_LIMIT_SQL',
    table_id       = '21283',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    view_definition = """
    SELECT
      B.GMT_CREATE AS CREATE_TIME,
      B.GMT_MODIFIED AS MODIFY_TIME,
      A.TENANT_ID,
      A.DATABASE_ID,
      A.OUTLINE_ID,
      A.DATABASE_NAME,
      A.OUTLINE_NAME,
      A.OUTLINE_CONTENT,
      A.VISIBLE_SIGNATURE,
      A.SQL_TEXT,
      A.CONCURRENT_NUM,
      A.LIMIT_TARGET
    FROM oceanbase.__tenant_virtual_concurrent_limit_sql A, oceanbase.__all_outline B
    WHERE A.OUTLINE_ID = B.OUTLINE_ID
""".replace("\n", " "),

    normal_columns = [
    ],
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'DBA_OB_RESTORE_PROGRESS',
  table_id        = '21284',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    P.JOB_ID AS JOB_ID,
    RESTORE_TENANT_NAME,
    RESTORE_TENANT_ID,
    BACKUP_TENANT_NAME,
    BACKUP_TENANT_ID,
    BACKUP_CLUSTER_NAME,
    BACKUP_DEST,
    RESTORE_OPTION,
    RESTORE_TYPE,
    RESTORE_SCN,
    CASE
      WHEN RESTORE_SCN IS NULL
        THEN NULL
      WHEN RESTORE_SCN=0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(RESTORE_SCN)
      END AS RESTORE_SCN_DISPLAY,
    CASE
      WHEN STATUS = 'RESTORE_PRE'
        THEN 'RESTORING'
      WHEN STATUS = 'RESTORE_CREATE_INIT_LS'
        THEN 'RESTORING'
      WHEN STATUS = 'RESTORE_WAIT_LS'
        THEN 'RESTORING'
      WHEN STATUS = 'POST_CHECK'
        THEN 'RESTORING'
      ELSE STATUS
      END AS STATUS,
    CASE
      WHEN START_TIMESTAMP IS NULL
        THEN NULL
      WHEN START_TIMESTAMP=''
        THEN NULL
      WHEN START_TIMESTAMP='0'
        THEN NULL
      ELSE
        USEC_TO_TIME(START_TIMESTAMP)
      END AS START_TIMESTAMP,
    BACKUP_SET_LIST,
    BACKUP_PIECE_LIST,
    RECOVER_SCN,
    CASE
      WHEN RECOVER_SCN IS NULL
        THEN NULL
      WHEN RECOVER_SCN <= 1
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(RECOVER_SCN)
      END AS RECOVER_SCN_DISPLAY,
    CASE
      WHEN RECOVER_SCN IS NULL
        THEN NULL
      WHEN STATUS IN ('RESTORE_PRE', 'RESTORE_CREATE_INIT_LS', 'PHYSICAL_RESTORE_WAIT_RESTORE_TO_CONSISTENT_SCN')
        THEN CAST(0 AS DECIMAL(6, 2))
      WHEN RESTORE_SCN = RECOVER_START_SCN
        THEN CAST(100 AS DECIMAL(6, 2))
      ELSE CAST(TRUNCATE((RECOVER_SCN - RECOVER_START_SCN) / (RESTORE_SCN - RECOVER_START_SCN) * 100, 2) AS DECIMAL(6, 2))
      END AS RECOVER_PROGRESS,
    TABLET_COUNT,
    FINISH_TABLET_COUNT,
    CASE PROGRESS_DISPLAY_MODE
      WHEN 'BYTES' THEN
        CASE
          WHEN FINISH_BYTES IS NULL THEN NULL
          ELSE CAST(TRUNCATE((FINISH_BYTES / TOTAL_BYTES) * 100, 2) AS DECIMAL(6, 2))
          END
      WHEN 'TABLET_CNT' THEN
        CASE
          WHEN FINISH_TABLET_COUNT IS NULL THEN NULL
          ELSE CAST(TRUNCATE((FINISH_TABLET_COUNT / TABLET_COUNT) * 100, 2) AS DECIMAL(6, 2))
          END
      END AS RESTORE_PROGRESS,
    TOTAL_BYTES,
    CASE
      WHEN TOTAL_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN TOTAL_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN TOTAL_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(TOTAL_BYTES/1024/1024,2), 'MB')
      END AS TOTAL_BYTES_DISPLAY,
    FINISH_BYTES,
    CASE
      WHEN FINISH_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN FINISH_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN FINISH_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(FINISH_BYTES/1024/1024,2), 'MB')
      END AS FINISH_BYTES_DISPLAY,
    DESCRIPTION
    FROM
  (
      SELECT
      TENANT_ID,
      JOB_ID,
      MAX(CASE NAME WHEN 'tenant_name' THEN VALUE ELSE '' END) AS RESTORE_TENANT_NAME,
      MAX(CASE NAME WHEN 'tenant_id' THEN VALUE ELSE '' END) AS RESTORE_TENANT_ID,
      MAX(CASE NAME WHEN 'backup_tenant_name' THEN VALUE ELSE '' END) AS BACKUP_TENANT_NAME,
      MAX(CASE NAME WHEN 'backup_tenant_id' THEN VALUE ELSE '' END) AS BACKUP_TENANT_ID,
      MAX(CASE NAME WHEN 'backup_cluster_name' THEN VALUE ELSE '' END) AS BACKUP_CLUSTER_NAME,
      MAX(CASE NAME WHEN 'target_tenant_role' THEN VALUE ELSE '' END) AS TENANT_ROLE,
      MAX(CASE NAME WHEN 'backup_dest' THEN VALUE ELSE '' END) AS BACKUP_DEST,
      MAX(CASE NAME WHEN 'restore_option' THEN VALUE ELSE '' END) AS RESTORE_OPTION,
      MAX(CASE NAME WHEN 'status' THEN VALUE ELSE '' END) AS STATUS,
      MAX(CASE NAME WHEN 'consistent_scn' THEN VALUE ELSE '' END) AS RECOVER_START_SCN,
      MAX(CASE NAME WHEN 'restore_scn' THEN VALUE ELSE '' END) AS RESTORE_SCN,
      MAX(CASE NAME WHEN 'restore_start_ts' THEN VALUE ELSE '' END) AS START_TIMESTAMP,
      MAX(CASE NAME WHEN 'backup_set_list' THEN VALUE ELSE '' END) AS BACKUP_SET_LIST,
      MAX(CASE NAME WHEN 'backup_piece_list' THEN VALUE ELSE '' END) AS BACKUP_PIECE_LIST,
      MAX(CASE NAME WHEN 'description' THEN VALUE ELSE '' END) AS DESCRIPTION,
      MAX(CASE NAME WHEN 'restore_type' THEN VALUE ELSE '' END) AS RESTORE_TYPE,
      MAX(CASE NAME WHEN 'progress_display_mode' THEN VALUE ELSE '' END) AS PROGRESS_DISPLAY_MODE
      FROM OCEANBASE.__ALL_VIRTUAL_RESTORE_JOB GROUP BY TENANT_ID, JOB_ID
  ) P LEFT JOIN
  (
      SELECT
      TENANT_ID,
      JOB_ID,
      TABLET_COUNT,
      FINISH_TABLET_COUNT,
      TOTAL_BYTES,
      FINISH_BYTES
      FROM OCEANBASE.__ALL_VIRTUAL_RESTORE_PROGRESS
  ) J
    ON P.TENANT_ID=J.TENANT_ID AND P.JOB_ID=J.JOB_ID
    LEFT JOIN
  (
      SELECT
      TENANT_ID,
      READABLE_SCN AS RECOVER_SCN
      FROM OCEANBASE.__ALL_VIRTUAL_TENANT_INFO
  ) Q
    ON P.TENANT_ID=Q.TENANT_ID
    WHERE P.TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'DBA_OB_RESTORE_HISTORY',
  table_id        = '21285',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    JOB_ID,
    RESTORE_TENANT_NAME,
    RESTORE_TENANT_ID,
    BACKUP_TENANT_NAME,
    BACKUP_TENANT_ID,
    BACKUP_CLUSTER_NAME,
    BACKUP_DEST,
    RESTORE_SCN,
    CASE
      WHEN RESTORE_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(RESTORE_SCN)
      END AS RESTORE_SCN_DISPLAY,
    RESTORE_OPTION,
    RESTORE_TYPE,
    START_TIME AS START_TIMESTAMP,
    FINISH_TIME AS FINISH_TIMESTAMP,
    STATUS,
    BACKUP_PIECE_LIST,
    BACKUP_SET_LIST,
    BACKUP_CLUSTER_VERSION,
    LS_COUNT,
    FINISH_LS_COUNT,
    TABLET_COUNT,
    FINISH_TABLET_COUNT,
    TOTAL_BYTES,
    CASE
      WHEN TOTAL_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN TOTAL_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN TOTAL_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(TOTAL_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(TOTAL_BYTES/1024/1024,2), 'MB')
      END AS TOTAL_BYTES_DISPLAY,
    FINISH_BYTES,
    CASE
      WHEN FINISH_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN FINISH_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN FINISH_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(FINISH_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(FINISH_BYTES/1024/1024,2), 'MB')
      END AS FINISH_BYTES_DISPLAY,
    DESCRIPTION,
    COMMENT
    FROM OCEANBASE.__ALL_VIRTUAL_RESTORE_JOB_HISTORY
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

# 21286: DBA_OB_ARCHIVE_MODE

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'DBA_OB_ARCHIVE_DEST',
  table_id        = '21287',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    DEST_NO,
    NAME,
    VALUE
    FROM OCEANBASE.__ALL_VIRTUAL_LOG_ARCHIVE_DEST_PARAMETER
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'DBA_OB_ARCHIVELOG',
  table_id        = '21288',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    DEST_ID,
    ROUND_ID,
    INCARNATION,
    DEST_NO,
    STATUS,
    START_SCN,
    CASE
      WHEN START_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(START_SCN)
      END AS START_SCN_DISPLAY,
    CHECKPOINT_SCN,
    CASE
      WHEN CHECKPOINT_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(CHECKPOINT_SCN)
      END AS CHECKPOINT_SCN_DISPLAY,
    COMPATIBLE,
    BASE_PIECE_ID,
    USED_PIECE_ID,
    PIECE_SWITCH_INTERVAL,
    UNIT_SIZE,
    COMPRESSION,
    (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) AS INPUT_BYTES,
    CASE
      WHEN (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES)/1024/1024/1024/1024/1024,2), 'PB')
      WHEN (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) >= 1024*1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES)/1024/1024/1024/1024,2), 'TB')
      WHEN (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) >= 1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES)/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND((FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES)/1024/1024,2), 'MB')
      END AS INPUT_BYTES_DISPLAY,
    (FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) AS OUTPUT_BYTES,
    CASE
      WHEN (FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES)/1024/1024/1024/1024/1024,2), 'PB')
      WHEN (FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) >= 1024*1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES)/1024/1024/1024/1024,2), 'TB')
      WHEN (FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) >= 1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES)/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND((FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES)/1024/1024,2), 'MB')
      END AS OUTPUT_BYTES_DISPLAY,
    CASE
      WHEN (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) = 0
        THEN 0
      ELSE
        ROUND((FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) / (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES), 2)
      END AS COMPRESSION_RATIO,
    DELETED_INPUT_BYTES,
    CASE
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024,2), 'MB')
      END AS DELETED_INPUT_BYTES_DISPLAY,
    DELETED_OUTPUT_BYTES,
    CASE
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024,2), 'MB')
      END AS DELETED_OUTPUT_BYTES_DISPLAY,
    COMMENT,
    PATH
    FROM OCEANBASE.__ALL_VIRTUAL_LOG_ARCHIVE_PROGRESS
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'DBA_OB_ARCHIVELOG_SUMMARY',
  table_id        = '21289',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    DEST_ID,
    ROUND_ID,
    INCARNATION,
    DEST_NO,
    STATUS,
    START_SCN,
    CASE
      WHEN START_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(START_SCN)
      END AS START_SCN_DISPLAY,
    CHECKPOINT_SCN,
    CASE
      WHEN CHECKPOINT_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(CHECKPOINT_SCN)
      END AS CHECKPOINT_SCN_DISPLAY,
    COMPATIBLE,
    BASE_PIECE_ID,
    USED_PIECE_ID,
    PIECE_SWITCH_INTERVAL,
    UNIT_SIZE,
    COMPRESSION,
    INPUT_BYTES,
    CASE
      WHEN INPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN INPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN INPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(INPUT_BYTES/1024/1024,2), 'MB')
      END AS INPUT_BYTES_DISPLAY,
    OUTPUT_BYTES,
    CASE
      WHEN OUTPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN OUTPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN OUTPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(OUTPUT_BYTES/1024/1024,2), 'MB')
      END AS OUTPUT_BYTES_DISPLAY,
    CASE
      WHEN INPUT_BYTES = 0
        THEN 0
      ELSE
        ROUND(OUTPUT_BYTES / INPUT_BYTES, 2)
      END AS COMPRESSION_RATIO,
    DELETED_INPUT_BYTES,
    CASE
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024,2), 'MB')
      END AS DELETED_INPUT_BYTES_DISPLAY,
    DELETED_OUTPUT_BYTES,
    CASE
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024,2), 'MB')
      END AS DELETED_OUTPUT_BYTES_DISPLAY,
    PATH,
    COMMENT
    FROM
(
SELECT DEST_ID,
       ROUND_ID,
       INCARNATION,
       DEST_NO,
       STATUS,
       START_SCN,
       CHECKPOINT_SCN,
       COMPATIBLE,
       BASE_PIECE_ID,
       USED_PIECE_ID,
       PIECE_SWITCH_INTERVAL,
       UNIT_SIZE,
       COMPRESSION,
       (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) AS INPUT_BYTES,
       (FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) AS OUTPUT_BYTES,
       DELETED_INPUT_BYTES,
       DELETED_OUTPUT_BYTES,
       PATH,
       COMMENT
       FROM OCEANBASE.__ALL_VIRTUAL_LOG_ARCHIVE_PROGRESS
       WHERE TENANT_ID = EFFECTIVE_TENANT_ID() AND STATUS != 'STOP'
UNION
SELECT DEST_ID,
       ROUND_ID,
       INCARNATION,
       DEST_NO,
       'STOP' AS STATUS,
       START_SCN,
       CHECKPOINT_SCN,
       COMPATIBLE,
       BASE_PIECE_ID,
       USED_PIECE_ID,
       PIECE_SWITCH_INTERVAL,
       UNIT_SIZE,
       COMPRESSION,
       INPUT_BYTES,
       OUTPUT_BYTES,
       DELETED_INPUT_BYTES,
       DELETED_OUTPUT_BYTES,
       PATH,
       COMMENT
       FROM OCEANBASE.__ALL_VIRTUAL_LOG_ARCHIVE_HISTORY
       WHERE TENANT_ID = EFFECTIVE_TENANT_ID())
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'DBA_OB_ARCHIVELOG_PIECE_FILES',
  table_id        = '21290',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    DEST_ID,
    ROUND_ID,
    PIECE_ID,
    INCARNATION,
    DEST_NO,
    STATUS,
    START_SCN,
    CASE
      WHEN START_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(START_SCN)
      END AS START_SCN_DISPLAY,
    CHECKPOINT_SCN,
    CASE
      WHEN CHECKPOINT_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(CHECKPOINT_SCN)
      END AS CHECKPOINT_SCN_DISPLAY,
    MAX_SCN,
    END_SCN,
    CASE
      WHEN END_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(END_SCN)
      END AS END_SCN_DISPLAY,
    COMPATIBLE,
    UNIT_SIZE,
    COMPRESSION,
    INPUT_BYTES,
    CASE
      WHEN INPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN INPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN INPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(INPUT_BYTES/1024/1024,2), 'MB')
      END AS INPUT_BYTES_DISPLAY,
    OUTPUT_BYTES,
    CASE
      WHEN OUTPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN OUTPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN OUTPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(OUTPUT_BYTES/1024/1024,2), 'MB')
      END AS OUTPUT_BYTES_DISPLAY,
    CASE
      WHEN INPUT_BYTES = 0
        THEN 0
      ELSE
        ROUND(OUTPUT_BYTES / INPUT_BYTES, 2)
      END AS COMPRESSION_RATIO,
    FILE_STATUS,
    PATH
    FROM OCEANBASE.__ALL_VIRTUAL_LOG_ARCHIVE_PIECE_FILES
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'DBA_OB_BACKUP_PARAMETER',
  table_id        = '21291',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
    NAME,
    VALUE
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_PARAMETER
    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
""".replace("\n", " ")
)

# 21292: CDB_OB_ARCHIVE_MODE

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'CDB_OB_ARCHIVE_DEST',
  table_id        = '21293',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    DEST_NO,
    NAME,
    VALUE
    FROM OCEANBASE.__ALL_VIRTUAL_LOG_ARCHIVE_DEST_PARAMETER
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'CDB_OB_ARCHIVELOG',
  table_id        = '21294',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    DEST_ID,
    ROUND_ID,
    INCARNATION,
    DEST_NO,
    STATUS,
    START_SCN,
    CASE
      WHEN START_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(START_SCN)
      END AS START_SCN_DISPLAY,
    CHECKPOINT_SCN,
    CASE
      WHEN CHECKPOINT_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(CHECKPOINT_SCN)
      END AS CHECKPOINT_SCN_DISPLAY,
    COMPATIBLE,
    BASE_PIECE_ID,
    USED_PIECE_ID,
    PIECE_SWITCH_INTERVAL,
    UNIT_SIZE,
    COMPRESSION,
    (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) AS INPUT_BYTES,
    CASE
      WHEN (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES)/1024/1024/1024/1024/1024,2), 'PB')
      WHEN (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) >= 1024*1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES)/1024/1024/1024/1024,2), 'TB')
      WHEN (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) >= 1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES)/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND((FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES)/1024/1024,2), 'MB')
      END AS INPUT_BYTES_DISPLAY,
    (FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) AS OUTPUT_BYTES,
    CASE
      WHEN (FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES)/1024/1024/1024/1024/1024,2), 'PB')
      WHEN (FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) >= 1024*1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES)/1024/1024/1024/1024,2), 'TB')
      WHEN (FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) >= 1024*1024*1024
        THEN CONCAT(ROUND((FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES)/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND((FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES)/1024/1024,2), 'MB')
      END AS OUTPUT_BYTES_DISPLAY,
    CASE
      WHEN (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) = 0
        THEN 0
      ELSE
        ROUND((FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) / (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES), 2)
      END AS COMPRESSION_RATIO,
    DELETED_INPUT_BYTES,
    CASE
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024,2), 'MB')
      END AS DELETED_INPUT_BYTES_DISPLAY,
    DELETED_OUTPUT_BYTES,
    CASE
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024,2), 'MB')
      END AS DELETED_OUTPUT_BYTES_DISPLAY,
    COMMENT,
    PATH
    FROM OCEANBASE.__ALL_VIRTUAL_LOG_ARCHIVE_PROGRESS
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'CDB_OB_ARCHIVELOG_SUMMARY',
  table_id        = '21295',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    DEST_ID,
    ROUND_ID,
    INCARNATION,
    DEST_NO,
    STATUS,
    START_SCN,
    CASE
      WHEN START_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(START_SCN)
      END AS START_SCN_DISPLAY,
    CHECKPOINT_SCN,
    CASE
      WHEN CHECKPOINT_SCN = 0
        THEN NULL
      ELSE
        SCN_TO_TIMESTAMP(CHECKPOINT_SCN)
      END AS CHECKPOINT_SCN_DISPLAY,
    COMPATIBLE,
    BASE_PIECE_ID,
    USED_PIECE_ID,
    PIECE_SWITCH_INTERVAL,
    UNIT_SIZE,
    COMPRESSION,
    INPUT_BYTES,
    CASE
      WHEN INPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN INPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN INPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(INPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(INPUT_BYTES/1024/1024,2), 'MB')
      END AS INPUT_BYTES_DISPLAY,
    OUTPUT_BYTES,
    CASE
      WHEN OUTPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN OUTPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN OUTPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(OUTPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(OUTPUT_BYTES/1024/1024,2), 'MB')
      END AS OUTPUT_BYTES_DISPLAY,
    CASE
      WHEN INPUT_BYTES = 0
        THEN 0
      ELSE
        ROUND(OUTPUT_BYTES / INPUT_BYTES, 2)
      END AS COMPRESSION_RATIO,
    DELETED_INPUT_BYTES,
    CASE
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN DELETED_INPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(DELETED_INPUT_BYTES/1024/1024,2), 'MB')
      END AS DELETED_INPUT_BYTES_DISPLAY,
    DELETED_OUTPUT_BYTES,
    CASE
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024/1024/1024,2), 'PB')
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024/1024,2), 'TB')
      WHEN DELETED_OUTPUT_BYTES >= 1024*1024*1024
        THEN CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024/1024,2), 'GB')
      ELSE
        CONCAT(ROUND(DELETED_OUTPUT_BYTES/1024/1024,2), 'MB')
      END AS DELETED_OUTPUT_BYTES_DISPLAY,
    PATH,
    COMMENT
    FROM
(
SELECT TENANT_ID,
       DEST_ID,
       ROUND_ID,
       INCARNATION,
       DEST_NO,
       STATUS,
       START_SCN,
       CHECKPOINT_SCN,
       COMPATIBLE,
       BASE_PIECE_ID,
       USED_PIECE_ID,
       PIECE_SWITCH_INTERVAL,
       UNIT_SIZE,
       COMPRESSION,
       (FROZEN_INPUT_BYTES + ACTIVE_INPUT_BYTES) AS INPUT_BYTES,
       (FROZEN_OUTPUT_BYTES + ACTIVE_OUTPUT_BYTES) AS OUTPUT_BYTES,
       DELETED_INPUT_BYTES,
       DELETED_OUTPUT_BYTES,
       PATH,
       COMMENT
       FROM OCEANBASE.__ALL_VIRTUAL_LOG_ARCHIVE_PROGRESS
       WHERE STATUS != 'STOP'
UNION
SELECT TENANT_ID,
       DEST_ID,
       ROUND_ID,
       INCARNATION,
       DEST_NO,
       'STOP' AS STATUS,
       START_SCN,
       CHECKPOINT_SCN,
       COMPATIBLE,
       BASE_PIECE_ID,
       USED_PIECE_ID,
       PIECE_SWITCH_INTERVAL,
       UNIT_SIZE,
       COMPRESSION,
       INPUT_BYTES,
       OUTPUT_BYTES,
       DELETED_INPUT_BYTES,
       DELETED_OUTPUT_BYTES,
       PATH,
       COMMENT
       FROM OCEANBASE.__ALL_VIRTUAL_LOG_ARCHIVE_HISTORY)
""".replace("\n", " ")
)

def_table_schema(
  owner = 'wangxiaohui.wxh',
  table_name      = 'CDB_OB_BACKUP_PARAMETER',
  table_id        = '21296',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
    SELECT
    TENANT_ID,
    NAME,
    VALUE
    FROM OCEANBASE.__ALL_VIRTUAL_BACKUP_PARAMETER
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'xuwang.txw',
  table_name      = 'DBA_OB_DEADLOCK_EVENT_HISTORY',
  table_id        = '21297',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
  SELECT EVENT_ID,
         SVR_IP,
         SVR_PORT,
         DETECTOR_ID,
         REPORT_TIME,
         CYCLE_IDX,
         CYCLE_SIZE,
         ROLE,
         PRIORITY_LEVEL,
         PRIORITY,
         CREATE_TIME,
         START_DELAY AS START_DELAY_US,
         MODULE,
         VISITOR,
         OBJECT,
         EXTRA_NAME1,
         EXTRA_VALUE1,
         EXTRA_NAME2,
         EXTRA_VALUE2,
         EXTRA_NAME3,
         EXTRA_VALUE3
  FROM OCEANBASE.__ALL_VIRTUAL_DEADLOCK_EVENT_HISTORY
  WHERE TENANT_ID = EFFECTIVE_TENANT_ID()
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'xuwang.txw',
  table_name      = 'CDB_OB_DEADLOCK_EVENT_HISTORY',
  table_id        = '21298',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT TENANT_ID,
         EVENT_ID,
         SVR_IP,
         SVR_PORT,
         DETECTOR_ID,
         REPORT_TIME,
         CYCLE_IDX,
         CYCLE_SIZE,
         ROLE,
         PRIORITY_LEVEL,
         PRIORITY,
         CREATE_TIME,
         START_DELAY AS START_DELAY_US,
         MODULE,
         VISITOR,
         OBJECT,
         EXTRA_NAME1,
         EXTRA_VALUE1,
         EXTRA_NAME2,
         EXTRA_VALUE2,
         EXTRA_NAME3,
         EXTRA_VALUE3
  FROM OCEANBASE.__ALL_VIRTUAL_DEADLOCK_EVENT_HISTORY
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'xiaochu.yh',
  table_name      = 'CDB_OB_SYS_VARIABLES',
  table_id        = '21299',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT
    a.GMT_CREATE AS CREATE_TIME,
    a.GMT_MODIFIED AS MODIFY_TIME,
    a.TENANT_ID as TENANT_ID,
    a.NAME as NAME,
    a.VALUE as VALUE,
    a.MIN_VAL as MIN_VALUE,
    a.MAX_VAL as MAX_VALUE,
    CASE a.FLAGS & 0x3
        WHEN 1 THEN "GLOBAL_ONLY"
        WHEN 2 THEN "SESSION_ONLY"
        WHEN 3 THEN "GLOBAL | SESSION"
        ELSE NULL
    END as SCOPE,
    a.INFO as INFO,
    b.DEFAULT_VALUE as DEFAULT_VALUE,
    CAST (CASE WHEN a.VALUE = b.DEFAULT_VALUE
          THEN 'YES'
          ELSE 'NO'
          END AS CHAR(3)) AS ISDEFAULT
  FROM oceanbase.__all_virtual_sys_variable a
  join oceanbase.__all_virtual_sys_variable_default_value b
  where a.name = b.variable_name;
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'shenyunlong.syl',
  table_name      = 'DBA_OB_KV_TTL_TASKS',
  table_id        = '21300',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  SELECT
      b.table_name as TABLE_NAME,
      a.table_id as TABLE_ID,
      a.tablet_id as TABLET_ID,
      a.task_id as TASK_ID,
      usec_to_time(a.task_start_time) as START_TIME,
      usec_to_time(a.task_update_time) as END_TIME,
      case a.trigger_type
        when 0 then "PERIODIC"
        when 1 then "USER"
        else "INVALID" END AS TRIGGER_TYPE,
      case a.status
        when 0 then "PREPARED"
        when 1 then "RUNNING"
        when 2 then "PENDING"
        when 3 then "CANCELED"
        when 4 then "FINISHED"
        when 5 then "MOVED"
        when 15 then "RS_TRIGGERING"
        when 16 then "RS_SUSPENDING"
        when 17 then "RS_CANCELING"
        when 18 then "RS_MOVING"
        when 47 then "RS_TRIGGERD"
        when 48 then "RS_SUSPENDED"
        when 49 then "RS_CANCELED"
        when 50 then "RS_MOVED"
        else "INVALID" END AS STATUS,
      a.ttl_del_cnt as TTL_DEL_CNT,
      a.max_version_del_cnt as MAX_VERSION_DEL_CNT,
      a.scan_cnt as SCAN_CNT,
      a.ret_code as RET_CODE,
      case a.task_type
        when 0 then "NORMAL"
        when 1 then "HBASE ROWKEY"
        else "INVALID" END AS TASK_TYPE
      FROM oceanbase.__all_virtual_kv_ttl_task a left outer JOIN oceanbase.__all_table b on
          a.table_id = b.table_id and a.tenant_id = effective_tenant_id()
          and b.table_mode >> 12 & 15 in (0,1)
          and b.index_attributes_set & 16 = 0
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'shenyunlong.syl',
  table_name      = 'DBA_OB_KV_TTL_TASK_HISTORY',
  table_id        = '21301',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  SELECT
      b.table_name as TABLE_NAME,
      a.table_id as TABLE_ID,
      a.tablet_id as TABLET_ID,
      a.task_id as TASK_ID,
      usec_to_time(a.task_start_time) as START_TIME,
      usec_to_time(a.task_update_time) as END_TIME,
      case a.trigger_type
        when 0 then "PERIODIC"
        when 1 then "USER"
        else "INVALID" END AS TRIGGER_TYPE,
      case a.status
        when 0 then "PREPARED"
        when 1 then "RUNNING"
        when 2 then "PENDING"
        when 3 then "CANCELED"
        when 4 then "FINISHED"
        when 5 then "MOVED"
        else "INVALID" END AS STATUS,
      a.ttl_del_cnt as TTL_DEL_CNT,
      a.max_version_del_cnt as MAX_VERSION_DEL_CNT,
      a.scan_cnt as SCAN_CNT,
      a.ret_code as RET_CODE,
      case a.task_type
        when 0 then "NORMAL"
        when 1 then "HBASE ROWKEY"
        else "INVALID" END AS TASK_TYPE
      FROM oceanbase.__all_virtual_kv_ttl_task_history a left outer JOIN oceanbase.__all_table b on
          a.table_id = b.table_id and a.tenant_id = effective_tenant_id()
          and b.table_mode >> 12 & 15 in (0,1)
          and b.index_attributes_set & 16 = 0
""".replace("\n", " ")
)

def_table_schema(
  owner = 'xianlin.lh',
  table_name     = 'GV$OB_LOG_STAT',
  table_id       = '21302',
  table_type = 'SYSTEM_VIEW',
  gm_columns = [],
  rowkey_columns = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition = """
  SELECT
    TENANT_ID,
    LS_ID,
    SVR_IP,
    SVR_PORT,
    ROLE,
    PROPOSAL_ID,
    CONFIG_VERSION,
    ACCESS_MODE,
    PAXOS_MEMBER_LIST,
    PAXOS_REPLICA_NUM,
    CASE in_sync
      WHEN 1 THEN 'YES'
      ELSE 'NO' END
    AS IN_SYNC,
    BASE_LSN,
    BEGIN_LSN,
    BEGIN_SCN,
    END_LSN,
    END_SCN,
    MAX_LSN,
    MAX_SCN,
    ARBITRATION_MEMBER,
    DEGRADED_LIST,
    LEARNER_LIST
  FROM oceanbase.__all_virtual_log_stat
""".replace("\n", " "),
)

def_table_schema(
    owner = 'xianlin.lh',
    table_name     = 'V$OB_LOG_STAT',
    table_id       = '21303',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    rowkey_columns = [],
    normal_columns  = [],
    in_tenant_space = True,
    view_definition = """
  SELECT TENANT_ID,
    LS_ID,
    SVR_IP,
    SVR_PORT,
    ROLE,
    PROPOSAL_ID,
    CONFIG_VERSION,
    ACCESS_MODE,
    PAXOS_MEMBER_LIST,
    PAXOS_REPLICA_NUM,
    IN_SYNC,
    BASE_LSN,
    BEGIN_LSN,
    BEGIN_SCN,
    END_LSN,
    END_SCN,
    MAX_LSN,
    MAX_SCN,
    ARBITRATION_MEMBER,
    DEGRADED_LIST,
    LEARNER_LIST
  FROM oceanbase.GV$OB_LOG_STAT
  WHERE svr_ip=HOST_IP() AND svr_port=RPC_PORT()
""".replace("\n", " "),
)

def_table_schema(
  owner = 'tonghui.ht',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'ST_GEOMETRY_COLUMNS',
  table_id        = '21304',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  select CAST(db.database_name AS CHAR(128)) collate utf8mb4_name_case as TABLE_SCHEMA,
         CAST(tbl.table_name AS CHAR(256)) collate utf8mb4_name_case as TABLE_NAME,
         CAST(col.column_name AS CHAR(128)) as COLUMN_NAME,
         CAST(srs.srs_name AS CHAR(128)) as SRS_NAME,
         CAST(if ((col.srs_id >> 32) = 4294967295, NULL, col.srs_id >> 32) AS UNSIGNED) as SRS_ID,
         CAST(case (col.srs_id & 31)
                when 0 then 'geometry'
                when 1 then 'point'
                when 2 then 'linestring'
                when 3 then 'polygon'
                when 4 then 'multipoint'
                when 5 then 'multilinestring'
                when 6 then 'multipolygon'
                when 7 then 'geomcollection'
                else 'invalid'
          end AS CHAR(128))as GEOMETRY_TYPE_NAME
  from
      oceanbase.__all_column col left join oceanbase.__all_spatial_reference_systems srs on (col.srs_id >> 32) = srs.srs_id
      join oceanbase.__all_table tbl on (tbl.table_id = col.table_id and tbl.tenant_id = col.tenant_id)
      join oceanbase.__all_database db on (db.database_id = tbl.database_id and db.tenant_id = tbl.tenant_id)
      and db.database_name != '__recyclebin'
  where col.data_type  = 48
    and tbl.table_mode >> 12 & 15 in (0,1)
    and tbl.index_attributes_set & 16 = 0
    and (0 = sys_privilege_check('table_acc', effective_tenant_id())
         or 0 = sys_privilege_check('table_acc', effective_tenant_id(), db.database_name, tbl.table_name));
""".replace("\n", " ")
)

def_table_schema(
  owner = 'tonghui.ht',
  tablegroup_id   = 'OB_INVALID_ID',
  database_id     = 'OB_INFORMATION_SCHEMA_ID',
  table_name      = 'ST_SPATIAL_REFERENCE_SYSTEMS',
  table_id        = '21305',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
  select CAST(srs_name AS CHAR(128)) as SRS_NAME,
         CAST(srs_id AS UNSIGNED) as SRS_ID,
         CAST(organization AS CHAR(256)) as ORGANIZATION,
         CAST(organization_coordsys_id AS UNSIGNED) as ORGANIZATION_COORDSYS_ID,
         CAST(definition AS CHAR(4096)) as DEFINITION,
         CAST(description AS CHAR(2048)) as DESCRIPTION
  from oceanbase.__all_spatial_reference_systems; """
)


def_table_schema(
  owner = 'wangzelin.wzl',
  database_id='OB_INFORMATION_SCHEMA_ID',
  table_name='QUERY_RESPONSE_TIME',
  table_id='21306',
  table_type='SYSTEM_VIEW',
  gm_columns=[],
  rowkey_columns=[],
  normal_columns=[],
  in_tenant_space=True,
  view_definition="""select
                   svr_ip as SVR_IP,
                   svr_port as SVR_PORT,
                   response_time as RESPONSE_TIME,
                   sum(count) as COUNT,
                   sum(total) as TOTAL
                   from oceanbase.__all_virtual_query_response_time
                   where tenant_id = effective_tenant_id()
                   group by svr_ip, svr_port, response_time
""".replace("\n", " "),
)

def_table_schema(
  owner = 'shenyunlong.syl',
  table_name      = 'CDB_OB_KV_TTL_TASKS',
  table_id        = '21307',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
  SELECT
      a.tenant_id as TENANT_ID,
      b.table_name as TABLE_NAME,
      a.table_id as TABLE_ID,
      a.tablet_id as TABLET_ID,
      a.task_id as TASK_ID,
      usec_to_time(a.task_start_time) as START_TIME,
      usec_to_time(a.task_update_time) as END_TIME,
      case a.trigger_type
        when 0 then "PERIODIC"
        when 1 then "USER"
        else "INVALID" END AS TRIGGER_TYPE,
      case a.status
        when 0 then "PREPARED"
        when 1 then "RUNNING"
        when 2 then "PENDING"
        when 3 then "CANCELED"
        when 4 then "FINISHED"
        when 5 then "MOVED"
        when 15 then "RS_TRIGGERING"
        when 16 then "RS_SUSPENDING"
        when 17 then "RS_CANCELING"
        when 18 then "RS_MOVING"
        when 47 then "RS_TRIGGERD"
        when 48 then "RS_SUSPENDED"
        when 49 then "RS_CANCELED"
        when 50 then "RS_MOVED"
        else "INVALID" END AS STATUS,
      a.ttl_del_cnt as TTL_DEL_CNT,
      a.max_version_del_cnt as MAX_VERSION_DEL_CNT,
      a.scan_cnt as SCAN_CNT,
      a.ret_code as RET_CODE,
      case a.task_type
        when 0 then "NORMAL"
        when 1 then "HBASE ROWKEY"
        else "INVALID" END AS TASK_TYPE
      FROM oceanbase.__all_virtual_kv_ttl_task a left outer JOIN oceanbase.__all_virtual_table b on
          a.table_id = b.table_id and a.tenant_id = b.tenant_id
          and b.table_mode >> 12 & 15 in (0,1)
          and b.index_attributes_set & 16 = 0
""".replace("\n", " ")
)

def_table_schema(
  owner = 'shenyunlong.syl',
  table_name      = 'CDB_OB_KV_TTL_TASK_HISTORY',
  table_id        = '21308',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  view_definition = """
  SELECT
      a.tenant_id as TENANT_ID,
      b.table_name as TABLE_NAME,
      a.table_id as TABLE_ID,
      a.tablet_id as TABLET_ID,
      a.task_id as TASK_ID,
      usec_to_time(a.task_start_time) as START_TIME,
      usec_to_time(a.task_update_time) as END_TIME,
      case a.trigger_type
        when 0 then "PERIODIC"
        when 1 then "USER"
        else "INVALID" END AS TRIGGER_TYPE,
      case a.status
        when 0 then "PREPARED"
        when 1 then "RUNNING"
        when 2 then "PENDING"
        when 3 then "CANCELED"
        when 4 then "FINISHED"
        when 5 then "MOVED"
        else "INVALID" END AS STATUS,
      a.ttl_del_cnt as TTL_DEL_CNT,
      a.max_version_del_cnt as MAX_VERSION_DEL_CNT,
      a.scan_cnt as SCAN_CNT,
      a.ret_code as RET_CODE,
      case a.task_type
        when 0 then "NORMAL"
        when 1 then "HBASE ROWKEY"
        else "INVALID" END AS TASK_TYPE
      FROM oceanbase.__all_virtual_kv_ttl_task_history a left outer JOIN oceanbase.__all_virtual_table b on
          a.table_id = b.table_id and a.tenant_id = b.tenant_id
          and b.table_mode >> 12 & 15 in (0,1)
          and b.index_attributes_set & 16 = 0
""".replace("\n", " ")
)

# 21309: CDB_OB_DATAFILE
# 21310: DBA_OB_DATAFILE

def_table_schema(
  owner           = 'dachuan.sdc',
  table_name      = 'DBA_RSRC_PLANS',
  table_id        = '21311',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      CAST(NULL AS NUMBER) AS PLAN_ID,
      PLAN,
      CAST(NULL AS NUMBER) AS NUM_PLAN_DIRECTIVES,
      CAST(NULL AS CHAR(128)) AS CPU_METHOD,
      CAST(NULL AS CHAR(128)) AS MGMT_METHOD,
      CAST(NULL AS CHAR(128)) AS ACTIVE_SESS_POOL_MTH,
      CAST(NULL AS CHAR(128)) AS PARALLEL_DEGREE_LIMIT_MTH,
      CAST(NULL AS CHAR(128)) AS QUEUING_MTH,
      CAST(NULL AS CHAR(3)) AS SUB_PLAN,
      COMMENTS,
      CAST(NULL AS CHAR(128)) AS STATUS,
      CAST(NULL AS CHAR(3)) AS MANDATORY
    FROM
       oceanbase.__all_res_mgr_plan
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'dachuan.sdc',
  table_name      = 'DBA_RSRC_PLAN_DIRECTIVES',
  table_id        = '21312',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      PLAN,
      GROUP_OR_SUBPLAN,
      CAST(NULL AS CHAR(14)) AS TYPE,
      CAST(NULL AS NUMBER) AS CPU_P1,
      CAST(NULL AS NUMBER) AS CPU_P2,
      CAST(NULL AS NUMBER) AS CPU_P3,
      CAST(NULL AS NUMBER) AS CPU_P4,
      CAST(NULL AS NUMBER) AS CPU_P5,
      CAST(NULL AS NUMBER) AS CPU_P6,
      CAST(NULL AS NUMBER) AS CPU_P7,
      CAST(NULL AS NUMBER) AS CPU_P8,
      MGMT_P1,
      CAST(NULL AS NUMBER) AS MGMT_P2,
      CAST(NULL AS NUMBER) AS MGMT_P3,
      CAST(NULL AS NUMBER) AS MGMT_P4,
      CAST(NULL AS NUMBER) AS MGMT_P5,
      CAST(NULL AS NUMBER) AS MGMT_P6,
      CAST(NULL AS NUMBER) AS MGMT_P7,
      CAST(NULL AS NUMBER) AS MGMT_P8,
      CAST(NULL AS NUMBER) AS ACTIVE_SESS_POOL_P1,
      CAST(NULL AS NUMBER) AS QUEUEING_P1,
      CAST(NULL AS NUMBER) AS PARALLEL_TARGET_PERCENTAGE,
      CAST(NULL AS NUMBER) AS PARALLEL_DEGREE_LIMIT_P1,
      CAST(NULL AS CHAR(128)) AS SWITCH_GROUP,
      CAST(NULL AS CHAR(5)) AS SWITCH_FOR_CALL,
      CAST(NULL AS NUMBER) AS SWITCH_TIME,
      CAST(NULL AS NUMBER) AS SWITCH_IO_MEGABYTES,
      CAST(NULL AS NUMBER) AS SWITCH_IO_REQS,
      CAST(NULL AS CHAR(5)) AS SWITCH_ESTIMATE,
      CAST(NULL AS NUMBER) AS MAX_EST_EXEC_TIME,
      CAST(NULL AS NUMBER) AS UNDO_POOL,
      CAST(NULL AS NUMBER) AS MAX_IDLE_TIME,
      CAST(NULL AS NUMBER) AS MAX_IDLE_BLOCKER_TIME,
      CAST(NULL AS NUMBER) AS MAX_UTILIZATION_LIMIT,
      CAST(NULL AS NUMBER) AS PARALLEL_QUEUE_TIMEOUT,
      CAST(NULL AS NUMBER) AS SWITCH_TIME_IN_CALL,
      CAST(NULL AS NUMBER) AS SWITCH_IO_LOGICAL,
      CAST(NULL AS NUMBER) AS SWITCH_ELAPSED_TIME,
      CAST(NULL AS NUMBER) AS PARALLEL_SERVER_LIMIT,
      UTILIZATION_LIMIT,
      CAST(NULL AS CHAR(12)) AS PARALLEL_STMT_CRITICAL,
      CAST(NULL AS NUMBER) AS SESSION_PGA_LIMIT,
      CAST(NULL AS CHAR(6)) AS PQ_TIMEOUT_ACTION,
      COMMENTS,
      CAST(NULL AS CHAR(128)) AS STATUS,
      CAST('YES' AS CHAR(3)) AS MANDATORY
    FROM
       oceanbase.__all_res_mgr_directive
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'dachuan.sdc',
  table_name      = 'DBA_RSRC_GROUP_MAPPINGS',
  table_id        = '21313',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      ATTRIBUTE,
      VALUE,
      CONSUMER_GROUP,
      CAST(NULL AS CHAR(128)) AS STATUS
    FROM
       oceanbase.__all_res_mgr_mapping_rule
""".replace("\n", " ")
)

def_table_schema(
  owner           = 'dachuan.sdc',
  table_name      = 'DBA_RSRC_CONSUMER_GROUPS',
  table_id        = '21314',
  table_type      = 'SYSTEM_VIEW',
  rowkey_columns  = [],
  normal_columns  = [],
  gm_columns      = [],
  in_tenant_space = True,
  view_definition = """
    SELECT
      CONSUMER_GROUP_ID,
      CONSUMER_GROUP,
      CAST(NULL AS CHAR(128)) AS CPU_METHOD,
      CAST(NULL AS CHAR(128)) AS MGMT_METHOD,
      CAST(NULL AS CHAR(3)) AS INTERNAL_USE,
      COMMENTS,
      CAST(NULL AS CHAR(128)) AS CATEGORY,
      CAST(NULL AS CHAR(128)) AS STATUS,
      CAST(NULL AS CHAR(3)) AS MANDATORY
    FROM
       oceanbase.__all_res_mgr_consumer_group
""".replace("\n", " ")
)

def_table_schema(
    owner          = 'dachuan.sdc',
    table_name     = 'V$RSRC_PLAN',
    table_id       = '21315',
    table_type = 'SYSTEM_VIEW',
    gm_columns = [],
    in_tenant_space = True,
    rowkey_columns = [],
    normal_columns = [],
    view_definition = """SELECT
          CAST(NULL as NUMBER) AS ID,
          B.plan NAME,
          CAST('TRUE' AS CHAR(5)) AS IS_TOP_PLAN,
          CAST('ON' AS CHAR(3)) AS CPU_MANAGED,
          CAST(NULL AS CHAR(3)) AS INSTANCE_CAGING,
          CAST(NULL AS NUMBER) AS PARALLEL_SERVERS_ACTIVE,
          CAST(NULL AS NUMBER) AS PARALLEL_SERVERS_TOTAL,
          CAST(NULL AS CHAR(32)) AS PARALLEL_EXECUTION_MANAGED
        FROM oceanbase.__tenant_virtual_global_variable A, oceanbase.dba_rsrc_plans B
        WHERE A.variable_name = 'resource_manager_plan' AND UPPER(A.value) = UPPER(B.plan)
""".replace("\n", " "),
)

def_table_schema(
  owner           = 'donglou.zl',
  table_name      = 'CDB_OB_COLUMN_CHECKSUM_ERROR_INFO',
  table_id        = '21316',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT TENANT_ID,
         FROZEN_SCN,
         (CASE index_type
               WHEN 0 THEN 'LOCAL_INDEX'
               WHEN 1 THEN 'GLOBAL_INDEX'
               ELSE 'UNKNOWN' END) AS INDEX_TYPE,
          DATA_TABLE_ID,
          INDEX_TABLE_ID,
          DATA_TABLET_ID,
          INDEX_TABLET_ID,
          COLUMN_ID,
          DATA_COLUMN_CKM AS DATA_COLUMN_CHECKSUM,
          INDEX_COLUMN_CKM AS INDEX_COLUMN_CHECKSUM
  FROM OCEANBASE.__ALL_VIRTUAL_COLUMN_CHECKSUM_ERROR_INFO
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'donglou.zl',
  table_name      = 'CDB_OB_TABLET_CHECKSUM_ERROR_INFO',
  table_id        = '21317',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
  SELECT TENANT_ID,
         TABLET_ID
  FROM
    (
      SELECT CKM.TENANT_ID,
             CKM.TABLET_ID,
             CKM.ROW_COUNT,
             CKM.DATA_CHECKSUM,
             CKM.B_COLUMN_CHECKSUMS,
             CKM.COMPACTION_SCN,
             M.REPLICA_TYPE
      FROM OCEANBASE.__ALL_VIRTUAL_TABLET_REPLICA_CHECKSUM CKM
      JOIN OCEANBASE.__ALL_VIRTUAL_LS_META_TABLE M
      ON CKM.TENANT_ID = M.TENANT_ID AND CKM.LS_ID = M.LS_ID AND CKM.SVR_IP = M.SVR_IP AND CKM.SVR_PORT = M.SVR_PORT
    ) J
  GROUP BY J.TENANT_ID, J.TABLET_ID, J.COMPACTION_SCN, J.REPLICA_TYPE
  HAVING MIN(J.DATA_CHECKSUM) != MAX(J.DATA_CHECKSUM)
         OR MIN(J.ROW_COUNT) != MAX(J.ROW_COUNT)
         OR MIN(J.B_COLUMN_CHECKSUMS) != MAX(J.B_COLUMN_CHECKSUMS)
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'msy164651',
  table_name      = 'DBA_OB_LS',
  table_id        = '21318',
  table_type      = 'SYSTEM_VIEW',
  in_tenant_space = True,
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
    SELECT A.LS_ID,
           A.STATUS,
           C.ZONE_PRIORITY AS PRIMARY_ZONE,
           A.UNIT_GROUP_ID,
           A.LS_GROUP_ID,

           /* SYS LS's CREATE_SCN always is NULL, it means nothing */
           (CASE A.LS_ID
                WHEN 1 THEN NULL
                ELSE B.CREATE_SCN
           END) AS CREATE_SCN,

           /* show NULL if not dropped */
           (CASE B.DROP_SCN
                WHEN 1 THEN NULL
                ELSE B.DROP_SCN
           END) AS DROP_SCN,

           /* SYS tenant and Meta tenant always show NULL */
           (CASE
                WHEN A.TENANT_ID = 1 THEN NULL
                WHEN (A.TENANT_ID & 0x1) = 1 THEN NULL
                ELSE B.SYNC_SCN
            END) AS SYNC_SCN,

           /* SYS tenant and Meta tenant always show NULL */
           (CASE
                WHEN A.TENANT_ID = 1 THEN NULL
                WHEN (A.TENANT_ID & 0x1) = 1 THEN NULL
                ELSE B.READABLE_SCN
            END) AS READABLE_SCN,
            FLAG
    FROM OCEANBASE.__ALL_VIRTUAL_LS_STATUS AS A
         JOIN OCEANBASE.__ALL_VIRTUAL_LS_RECOVERY_STAT AS B
         JOIN OCEANBASE.__ALL_VIRTUAL_LS_ELECTION_REFERENCE_INFO AS C
              ON A.TENANT_ID = B.TENANT_ID AND A.LS_ID = B.LS_ID
              AND A.TENANT_ID = C.TENANT_ID AND A.LS_ID = C.LS_ID
    WHERE A.TENANT_ID = EFFECTIVE_TENANT_ID()
  """.replace("\n", " "),
)
def_table_schema(
  owner           = 'msy164651',
  table_name      = 'CDB_OB_LS',
  table_id        = '21319',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
    SELECT A.TENANT_ID,
           A.LS_ID,
           A.STATUS,
           C.ZONE_PRIORITY AS PRIMARY_ZONE,
           A.UNIT_GROUP_ID,
           A.LS_GROUP_ID,

           /* SYS LS's CREATE_SCN always is NULL, it means nothing */
           (CASE A.LS_ID
                WHEN 1 THEN NULL
                ELSE B.CREATE_SCN
           END) AS CREATE_SCN,

           /* show NULL if not dropped */
           (CASE B.DROP_SCN
                WHEN 1 THEN NULL
                ELSE B.DROP_SCN
           END) AS DROP_SCN,

           /* SYS tenant and Meta tenant always show NULL */
           (CASE
                WHEN A.TENANT_ID = 1 THEN NULL
                WHEN (A.TENANT_ID & 0x1) = 1 THEN NULL
                ELSE B.SYNC_SCN
            END) AS SYNC_SCN,

           /* SYS tenant and Meta tenant always show NULL */
           (CASE
                WHEN A.TENANT_ID = 1 THEN NULL
                WHEN (A.TENANT_ID & 0x1) = 1 THEN NULL
                ELSE B.READABLE_SCN
            END) AS READABLE_SCN,
            FLAG
    FROM OCEANBASE.__ALL_VIRTUAL_LS_STATUS AS A
         JOIN OCEANBASE.__ALL_VIRTUAL_LS_RECOVERY_STAT AS B
         JOIN OCEANBASE.__ALL_VIRTUAL_LS_ELECTION_REFERENCE_INFO AS C
              ON A.TENANT_ID = B.TENANT_ID AND A.LS_ID = B.LS_ID
              AND A.TENANT_ID = C.TENANT_ID AND A.LS_ID = C.LS_ID
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'msy164651',
  table_name      = 'DBA_OB_TABLE_LOCATIONS',
  table_id        = '21320',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  in_tenant_space = True,
  view_definition =
  """
SELECT
    D.DATABASE_NAME,
    A.TABLE_NAME,
    A.TABLE_ID,

    CASE WHEN A.TABLE_TYPE IN (0) THEN 'SYSTEM TABLE'
         WHEN A.TABLE_TYPE IN (3,6,8,9) THEN 'USER TABLE'
         WHEN A.TABLE_TYPE IN (5) THEN 'INDEX'
         WHEN A.TABLE_TYPE IN (12,13) THEN 'LOB AUX TABLE'
         WHEN A.TABLE_TYPE IN (15) THEN 'MATERIALIZED VIEW LOG'
         ELSE NULL
    END AS TABLE_TYPE,

    A.PARTITION_NAME,
    A.SUBPARTITION_NAME,

    /* INDEX_NAME is valid when table is index */
    CASE WHEN A.TABLE_TYPE != 5 THEN NULL
         WHEN D.DATABASE_NAME != '__recyclebin'
              THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))
         ELSE TABLE_NAME
    END AS INDEX_NAME,

    CASE WHEN DATA_TABLE_ID = 0 THEN NULL
         ELSE DATA_TABLE_ID
    END AS DATA_TABLE_ID,

    A.TABLET_ID,
    C.LS_ID,
    C.ZONE,
    C.SVR_IP AS SVR_IP,
    C.SVR_PORT AS SVR_PORT,
    C.ROLE,
    C.REPLICA_TYPE,
    CASE WHEN A.DUPLICATE_SCOPE = 1 THEN 'CLUSTER'
         ELSE 'NONE'
    END AS DUPLICATE_SCOPE,
    CASE WHEN A.DUPLICATE_SCOPE = 1 AND A.DUPLICATE_READ_CONSISTENCY = 0 THEN 'STRONG'
         WHEN A.DUPLICATE_SCOPE = 1 AND A.DUPLICATE_READ_CONSISTENCY = 1 THEN 'WEAK'
         ELSE 'NONE'
    END AS DUPLICATE_READ_CONSISTENCY,
    A.OBJECT_ID,
    TG.TABLEGROUP_NAME,
    TG.TABLEGROUP_ID,
    TG.SHARDING
FROM (
      SELECT DATABASE_ID,
             TABLE_NAME,
             TABLE_ID,
             'NULL' AS PARTITION_NAME,
             'NULL' AS SUBPARTITION_NAME,
             TABLE_ID AS OBJECT_ID,
             TABLET_ID AS TABLET_ID,
             TABLE_TYPE,
             DATA_TABLE_ID,
             DUPLICATE_SCOPE,
             DUPLICATE_READ_CONSISTENCY,
             TABLEGROUP_ID
      FROM OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE
      WHERE TABLET_ID != 0 AND TENANT_ID = EFFECTIVE_TENANT_ID()

      UNION ALL

      SELECT
      DATABASE_ID,
      NEW_TABLE_NAME AS TABLE_NAME,
      TABLE_ID,
      'NULL' AS PARTITION_NAME,
      'NULL' AS SUBPARTITION_NAME,
      TABLE_ID AS OBJECT_ID,
      TABLET_ID AS TABLET_ID,
      TABLE_TYPE,
      DATA_TABLE_ID,
      DUPLICATE_SCOPE,
      DUPLICATE_READ_CONSISTENCY,
      TABLEGROUP_ID
      FROM
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			))

      WHERE TABLET_ID != 0 AND PART_LEVEL = 0 AND TENANT_ID = 0

      UNION ALL

      SELECT
      T.DATABASE_ID AS DATABASE_ID,
      T.NEW_TABLE_NAME AS TABLE_NAME,
      T.TABLE_ID AS TABLE_ID,
      P.PART_NAME AS PARTITION_NAME,
      'NULL' AS SUBPARTITION_NAME,
      P.PART_ID AS OBJECT_ID,
      P.TABLET_ID AS TABLET_ID,
      TABLE_TYPE,
      DATA_TABLE_ID,
      DUPLICATE_SCOPE,
      DUPLICATE_READ_CONSISTENCY,
      TABLEGROUP_ID
      FROM
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			)) T JOIN OCEANBASE.__ALL_PART P
           ON T.TABLE_ID = P.TABLE_ID AND T.TENANT_ID = P.TENANT_ID
      WHERE T.PART_LEVEL = 1 AND T.TENANT_ID = 0
            AND P.PARTITION_TYPE = 0

      UNION ALL

      SELECT
      T.DATABASE_ID AS DATABASE_ID,
      T.NEW_TABLE_NAME AS TABLE_NAME,
      T.TABLE_ID AS TABLE_ID,
      P.PART_NAME AS PARTITION_NAME,
      Q.SUB_PART_NAME AS SUBPARTITION_NAME,
      Q.SUB_PART_ID AS OBJECT_ID,
      Q.TABLET_ID AS TABLET_ID,
      TABLE_TYPE,
      DATA_TABLE_ID,
      DUPLICATE_SCOPE,
      DUPLICATE_READ_CONSISTENCY,
      TABLEGROUP_ID
      FROM
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			)) T, OCEANBASE.__ALL_PART P,OCEANBASE.__ALL_SUB_PART Q
      WHERE T.TABLE_ID =P.TABLE_ID AND P.TABLE_ID=Q.TABLE_ID AND P.PART_ID = Q.PART_ID
      AND T.TENANT_ID = P.TENANT_ID AND P.TENANT_ID = Q.TENANT_ID AND T.PART_LEVEL = 2
      AND T.TENANT_ID = 0
      AND P.PARTITION_TYPE = 0
      AND Q.PARTITION_TYPE = 0
    ) A
    JOIN OCEANBASE.DBA_OB_TABLET_TO_LS B ON A.TABLET_ID = B.TABLET_ID
    JOIN OCEANBASE.DBA_OB_LS_LOCATIONS C ON B.LS_ID = C.LS_ID
    JOIN OCEANBASE.__ALL_DATABASE D ON A.DATABASE_ID = D.DATABASE_ID
    LEFT JOIN OCEANBASE.__ALL_TABLEGROUP TG ON A.TABLEGROUP_ID = TG.TABLEGROUP_ID
    WHERE D.TENANT_ID = 0
    ORDER BY A.TABLE_ID, A.TABLET_ID, C.ZONE, SVR_IP, SVR_PORT
  """.replace("\n", " "),
)

def_table_schema(
  owner           = 'msy164651',
  table_name      = 'CDB_OB_TABLE_LOCATIONS',
  table_id        = '21321',
  table_type      = 'SYSTEM_VIEW',
  gm_columns      = [],
  rowkey_columns  = [],
  normal_columns  = [],
  view_definition =
  """
SELECT
    A.TENANT_ID,
    D.DATABASE_NAME,
    A.TABLE_NAME,
    A.TABLE_ID,

    CASE WHEN A.TABLE_TYPE IN (0) THEN 'SYSTEM TABLE'
         WHEN A.TABLE_TYPE IN (3,6,8,9) THEN 'USER TABLE'
         WHEN A.TABLE_TYPE IN (5) THEN 'INDEX'
         WHEN A.TABLE_TYPE IN (12,13) THEN 'LOB AUX TABLE'
         WHEN A.TABLE_TYPE IN (15) THEN 'MATERIALIZED VIEW LOG'
         ELSE NULL
    END AS TABLE_TYPE,

    A.PARTITION_NAME,
    A.SUBPARTITION_NAME,

    /* INDEX_NAME is valid when table is index */
    CASE WHEN A.TABLE_TYPE != 5 THEN NULL
         WHEN D.DATABASE_NAME != '__recyclebin'
              THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))
         ELSE TABLE_NAME
    END AS INDEX_NAME,

    CASE WHEN DATA_TABLE_ID = 0 THEN NULL
         ELSE DATA_TABLE_ID
    END AS DATA_TABLE_ID,

    A.TABLET_ID,
    C.LS_ID,
    C.ZONE,
    C.SVR_IP AS SVR_IP,
    C.SVR_PORT AS SVR_PORT,
    C.ROLE,
    C.REPLICA_TYPE,
    CASE WHEN A.DUPLICATE_SCOPE = 1 THEN 'CLUSTER'
         ELSE 'NONE'
    END AS DUPLICATE_SCOPE,

    CASE WHEN A.DUPLICATE_SCOPE = 1 AND A.DUPLICATE_READ_CONSISTENCY = 0 THEN 'STRONG'
         WHEN A.DUPLICATE_SCOPE = 1 AND A.DUPLICATE_READ_CONSISTENCY = 1 THEN 'WEAK'
         ELSE 'NONE'
    END AS DUPLICATE_READ_CONSISTENCY,

    A.OBJECT_ID,
    TG.TABLEGROUP_NAME,
    TG.TABLEGROUP_ID,
    TG.SHARDING
FROM (
      SELECT TENANT_ID,
             DATABASE_ID,
             TABLE_NAME,
             TABLE_ID,
             'NULL' AS PARTITION_NAME,
             'NULL' AS SUBPARTITION_NAME,
             TABLE_ID AS OBJECT_ID,
             TABLET_ID AS TABLET_ID,
             TABLE_TYPE,
             DATA_TABLE_ID,
             DUPLICATE_SCOPE,
             DUPLICATE_READ_CONSISTENCY,
             TABLEGROUP_ID
      FROM OCEANBASE.__ALL_VIRTUAL_CORE_ALL_TABLE
      WHERE TABLET_ID != 0

      UNION ALL

      SELECT
      TENANT_ID,
      DATABASE_ID,
      NEW_TABLE_NAME AS TABLE_NAME,
      TABLE_ID,
      'NULL' AS PARTITION_NAME,
      'NULL' AS SUBPARTITION_NAME,
      TABLE_ID AS OBJECT_ID,
      TABLET_ID AS TABLET_ID,
      TABLE_TYPE,
      DATA_TABLE_ID,
      DUPLICATE_SCOPE,
      DUPLICATE_READ_CONSISTENCY,
      TABLEGROUP_ID
      FROM
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_virtual_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_virtual_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
              and mv_table.tenant_id = container_table.tenant_id
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_virtual_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			))

      WHERE TABLET_ID != 0 AND PART_LEVEL = 0

      UNION ALL

      SELECT
      P.TENANT_ID AS TENANT_ID,
      T.DATABASE_ID AS DATABASE_ID,
      T.NEW_TABLE_NAME AS TABLE_NAME,
      T.TABLE_ID AS TABLE_ID,
      P.PART_NAME AS PARTITION_NAME,
      'NULL' AS SUBPARTITION_NAME,
      P.PART_ID AS OBJECT_ID,
      P.TABLET_ID AS TABLET_ID,
      TABLE_TYPE,
      DATA_TABLE_ID,
      DUPLICATE_SCOPE,
      DUPLICATE_READ_CONSISTENCY,
      TABLEGROUP_ID
      FROM
			((
			    SELECT
			        mv_table.table_name AS new_table_name,
			        container_table.*
			    FROM
			        oceanbase.__all_virtual_table AS mv_table,
			        (
			            SELECT * FROM
			                oceanbase.__all_virtual_table
			            WHERE
			                (table_mode & 1 << 24) = 1 << 24
			        ) AS container_table
			    WHERE
			        mv_table.data_table_id = container_table.table_id
							and mv_table.table_type = 7
              and mv_table.tenant_id = container_table.tenant_id
			)

			UNION ALL

			(
			    SELECT
			        table_name as new_table_name,
			        *
			    FROM
			        oceanbase.__all_virtual_table
			    WHERE
			        (table_mode & 1 << 24) = 0
			)) T JOIN OCEANBASE.__ALL_VIRTUAL_PART P ON T.TABLE_ID = P.TABLE_ID
      WHERE T.TENANT_ID = P.TENANT_ID AND T.PART_LEVEL = 1
            AND P.PARTITION_TYPE = 0
      UNION ALL

      SELECT
      T.TENANT_ID AS TENANT_ID,
      T.DATABASE_ID AS DATABASE_ID,
      T.NEW_TABLE_NAME AS TABLE_NAME,
      T.TABLE_ID AS TABLE_ID,
      P.PART_NAME AS PARTITION_NAME,
      Q.SUB_PART_NAME AS SUBPARTITION_NAME,
      Q.SUB_PART_ID AS OBJECT_ID,
      Q.TABLET_ID AS TABLET_ID,
      TABLE_TYPE,
      DATA_TABLE_ID,
      DUPLICATE_SCOPE,
      DUPLICATE_READ_CONSISTENCY,
      TABLEGROUP_ID
      FROM
			((
			    SELECT
			        mv_table.table_name AS new_table_n