/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef _OB_INNER_TABLE_SCHEMA_CONSTANTS_H_
#define _OB_INNER_TABLE_SCHEMA_CONSTANTS_H_

#include "share/ob_define.h"

namespace oceanbase
{
namespace share
{
namespace schema
{
class ObTableSchema;
}
}

namespace share
{
const uint64_t OB_ALL_CORE_TABLE_TID = 1; // "__all_core_table"
const uint64_t OB_ALL_TABLE_TID = 3; // "__all_table"
const uint64_t OB_ALL_COLUMN_TID = 4; // "__all_column"
const uint64_t OB_ALL_DDL_OPERATION_TID = 5; // "__all_ddl_operation"
const uint64_t OB_ALL_USER_TID = 102; // "__all_user"
const uint64_t OB_ALL_USER_HISTORY_TID = 103; // "__all_user_history"
const uint64_t OB_ALL_DATABASE_TID = 104; // "__all_database"
const uint64_t OB_ALL_DATABASE_HISTORY_TID = 105; // "__all_database_history"
const uint64_t OB_ALL_TABLEGROUP_TID = 106; // "__all_tablegroup"
const uint64_t OB_ALL_TABLEGROUP_HISTORY_TID = 107; // "__all_tablegroup_history"
const uint64_t OB_ALL_TENANT_TID = 108; // "__all_tenant"
const uint64_t OB_ALL_TENANT_HISTORY_TID = 109; // "__all_tenant_history"
const uint64_t OB_ALL_TABLE_PRIVILEGE_TID = 110; // "__all_table_privilege"
const uint64_t OB_ALL_TABLE_PRIVILEGE_HISTORY_TID = 111; // "__all_table_privilege_history"
const uint64_t OB_ALL_DATABASE_PRIVILEGE_TID = 112; // "__all_database_privilege"
const uint64_t OB_ALL_DATABASE_PRIVILEGE_HISTORY_TID = 113; // "__all_database_privilege_history"
const uint64_t OB_ALL_TABLE_HISTORY_TID = 114; // "__all_table_history"
const uint64_t OB_ALL_COLUMN_HISTORY_TID = 115; // "__all_column_history"
const uint64_t OB_ALL_ZONE_TID = 116; // "__all_zone"
const uint64_t OB_ALL_SERVER_TID = 117; // "__all_server"
const uint64_t OB_ALL_SYS_PARAMETER_TID = 118; // "__all_sys_parameter"
const uint64_t OB_TENANT_PARAMETER_TID = 119; // "__tenant_parameter"
const uint64_t OB_ALL_SYS_VARIABLE_TID = 120; // "__all_sys_variable"
const uint64_t OB_ALL_SYS_STAT_TID = 121; // "__all_sys_stat"
const uint64_t OB_ALL_UNIT_TID = 123; // "__all_unit"
const uint64_t OB_ALL_UNIT_CONFIG_TID = 124; // "__all_unit_config"
const uint64_t OB_ALL_RESOURCE_POOL_TID = 125; // "__all_resource_pool"
const uint64_t OB_ALL_CHARSET_TID = 128; // "__all_charset"
const uint64_t OB_ALL_COLLATION_TID = 129; // "__all_collation"
const uint64_t OB_HELP_TOPIC_TID = 130; // "help_topic"
const uint64_t OB_HELP_CATEGORY_TID = 131; // "help_category"
const uint64_t OB_HELP_KEYWORD_TID = 132; // "help_keyword"
const uint64_t OB_HELP_RELATION_TID = 133; // "help_relation"
const uint64_t OB_ALL_DUMMY_TID = 135; // "__all_dummy"
const uint64_t OB_ALL_ROOTSERVICE_EVENT_HISTORY_TID = 140; // "__all_rootservice_event_history"
const uint64_t OB_ALL_PRIVILEGE_TID = 141; // "__all_privilege"
const uint64_t OB_ALL_OUTLINE_TID = 142; // "__all_outline"
const uint64_t OB_ALL_OUTLINE_HISTORY_TID = 143; // "__all_outline_history"
const uint64_t OB_ALL_RECYCLEBIN_TID = 145; // "__all_recyclebin"
const uint64_t OB_ALL_PART_TID = 146; // "__all_part"
const uint64_t OB_ALL_PART_HISTORY_TID = 147; // "__all_part_history"
const uint64_t OB_ALL_SUB_PART_TID = 148; // "__all_sub_part"
const uint64_t OB_ALL_SUB_PART_HISTORY_TID = 149; // "__all_sub_part_history"
const uint64_t OB_ALL_PART_INFO_TID = 150; // "__all_part_info"
const uint64_t OB_ALL_PART_INFO_HISTORY_TID = 151; // "__all_part_info_history"
const uint64_t OB_ALL_DEF_SUB_PART_TID = 152; // "__all_def_sub_part"
const uint64_t OB_ALL_DEF_SUB_PART_HISTORY_TID = 153; // "__all_def_sub_part_history"
const uint64_t OB_ALL_SERVER_EVENT_HISTORY_TID = 154; // "__all_server_event_history"
const uint64_t OB_ALL_ROOTSERVICE_JOB_TID = 155; // "__all_rootservice_job"
const uint64_t OB_ALL_SYS_VARIABLE_HISTORY_TID = 157; // "__all_sys_variable_history"
const uint64_t OB_ALL_RESTORE_JOB_TID = 158; // "__all_restore_job"
const uint64_t OB_ALL_RESTORE_JOB_HISTORY_TID = 160; // "__all_restore_job_history"
const uint64_t OB_ALL_DDL_ID_TID = 165; // "__all_ddl_id"
const uint64_t OB_ALL_FOREIGN_KEY_TID = 166; // "__all_foreign_key"
const uint64_t OB_ALL_FOREIGN_KEY_HISTORY_TID = 167; // "__all_foreign_key_history"
const uint64_t OB_ALL_FOREIGN_KEY_COLUMN_TID = 168; // "__all_foreign_key_column"
const uint64_t OB_ALL_FOREIGN_KEY_COLUMN_HISTORY_TID = 169; // "__all_foreign_key_column_history"
const uint64_t OB_ALL_SYNONYM_TID = 180; // "__all_synonym"
const uint64_t OB_ALL_SYNONYM_HISTORY_TID = 181; // "__all_synonym_history"
const uint64_t OB_ALL_AUTO_INCREMENT_TID = 182; // "__all_auto_increment"
const uint64_t OB_ALL_DDL_CHECKSUM_TID = 188; // "__all_ddl_checksum"
const uint64_t OB_ALL_ROUTINE_TID = 189; // "__all_routine"
const uint64_t OB_ALL_ROUTINE_HISTORY_TID = 190; // "__all_routine_history"
const uint64_t OB_ALL_ROUTINE_PARAM_TID = 191; // "__all_routine_param"
const uint64_t OB_ALL_ROUTINE_PARAM_HISTORY_TID = 192; // "__all_routine_param_history"
const uint64_t OB_ALL_PACKAGE_TID = 196; // "__all_package"
const uint64_t OB_ALL_PACKAGE_HISTORY_TID = 197; // "__all_package_history"
const uint64_t OB_ALL_ACQUIRED_SNAPSHOT_TID = 202; // "__all_acquired_snapshot"
const uint64_t OB_ALL_CONSTRAINT_TID = 206; // "__all_constraint"
const uint64_t OB_ALL_CONSTRAINT_HISTORY_TID = 207; // "__all_constraint_history"
const uint64_t OB_ALL_ORI_SCHEMA_VERSION_TID = 208; // "__all_ori_schema_version"
const uint64_t OB_ALL_FUNC_TID = 209; // "__all_func"
const uint64_t OB_ALL_FUNC_HISTORY_TID = 210; // "__all_func_history"
const uint64_t OB_ALL_TEMP_TABLE_TID = 211; // "__all_temp_table"
const uint64_t OB_ALL_SEQUENCE_OBJECT_TID = 213; // "__all_sequence_object"
const uint64_t OB_ALL_SEQUENCE_OBJECT_HISTORY_TID = 214; // "__all_sequence_object_history"
const uint64_t OB_ALL_SEQUENCE_VALUE_TID = 215; // "__all_sequence_value"
const uint64_t OB_ALL_FREEZE_SCHEMA_VERSION_TID = 219; // "__all_freeze_schema_version"
const uint64_t OB_ALL_TYPE_TID = 220; // "__all_type"
const uint64_t OB_ALL_TYPE_HISTORY_TID = 221; // "__all_type_history"
const uint64_t OB_ALL_TYPE_ATTR_TID = 222; // "__all_type_attr"
const uint64_t OB_ALL_TYPE_ATTR_HISTORY_TID = 223; // "__all_type_attr_history"
const uint64_t OB_ALL_COLL_TYPE_TID = 224; // "__all_coll_type"
const uint64_t OB_ALL_COLL_TYPE_HISTORY_TID = 225; // "__all_coll_type_history"
const uint64_t OB_ALL_WEAK_READ_SERVICE_TID = 226; // "__all_weak_read_service"
const uint64_t OB_ALL_DBLINK_TID = 232; // "__all_dblink"
const uint64_t OB_ALL_DBLINK_HISTORY_TID = 233; // "__all_dblink_history"
const uint64_t OB_ALL_TENANT_ROLE_GRANTEE_MAP_TID = 235; // "__all_tenant_role_grantee_map"
const uint64_t OB_ALL_TENANT_ROLE_GRANTEE_MAP_HISTORY_TID = 236; // "__all_tenant_role_grantee_map_history"
const uint64_t OB_ALL_TENANT_KEYSTORE_TID = 237; // "__all_tenant_keystore"
const uint64_t OB_ALL_TENANT_KEYSTORE_HISTORY_TID = 238; // "__all_tenant_keystore_history"
const uint64_t OB_ALL_TENANT_OLS_POLICY_TID = 239; // "__all_tenant_ols_policy"
const uint64_t OB_ALL_TENANT_OLS_POLICY_HISTORY_TID = 240; // "__all_tenant_ols_policy_history"
const uint64_t OB_ALL_TENANT_OLS_COMPONENT_TID = 241; // "__all_tenant_ols_component"
const uint64_t OB_ALL_TENANT_OLS_COMPONENT_HISTORY_TID = 242; // "__all_tenant_ols_component_history"
const uint64_t OB_ALL_TENANT_OLS_LABEL_TID = 243; // "__all_tenant_ols_label"
const uint64_t OB_ALL_TENANT_OLS_LABEL_HISTORY_TID = 244; // "__all_tenant_ols_label_history"
const uint64_t OB_ALL_TENANT_OLS_USER_LEVEL_TID = 245; // "__all_tenant_ols_user_level"
const uint64_t OB_ALL_TENANT_OLS_USER_LEVEL_HISTORY_TID = 246; // "__all_tenant_ols_user_level_history"
const uint64_t OB_ALL_TENANT_TABLESPACE_TID = 247; // "__all_tenant_tablespace"
const uint64_t OB_ALL_TENANT_TABLESPACE_HISTORY_TID = 248; // "__all_tenant_tablespace_history"
const uint64_t OB_ALL_TENANT_USER_FAILED_LOGIN_STAT_TID = 249; // "__all_tenant_user_failed_login_stat"
const uint64_t OB_ALL_TENANT_PROFILE_TID = 250; // "__all_tenant_profile"
const uint64_t OB_ALL_TENANT_PROFILE_HISTORY_TID = 251; // "__all_tenant_profile_history"
const uint64_t OB_ALL_TENANT_SECURITY_AUDIT_TID = 252; // "__all_tenant_security_audit"
const uint64_t OB_ALL_TENANT_SECURITY_AUDIT_HISTORY_TID = 253; // "__all_tenant_security_audit_history"
const uint64_t OB_ALL_TENANT_TRIGGER_TID = 254; // "__all_tenant_trigger"
const uint64_t OB_ALL_TENANT_TRIGGER_HISTORY_TID = 255; // "__all_tenant_trigger_history"
const uint64_t OB_ALL_SEED_PARAMETER_TID = 256; // "__all_seed_parameter"
const uint64_t OB_ALL_TENANT_SECURITY_AUDIT_RECORD_TID = 259; // "__all_tenant_security_audit_record"
const uint64_t OB_ALL_TENANT_SYSAUTH_TID = 260; // "__all_tenant_sysauth"
const uint64_t OB_ALL_TENANT_SYSAUTH_HISTORY_TID = 261; // "__all_tenant_sysauth_history"
const uint64_t OB_ALL_TENANT_OBJAUTH_TID = 262; // "__all_tenant_objauth"
const uint64_t OB_ALL_TENANT_OBJAUTH_HISTORY_TID = 263; // "__all_tenant_objauth_history"
const uint64_t OB_ALL_RESTORE_INFO_TID = 265; // "__all_restore_info"
const uint64_t OB_ALL_TENANT_ERROR_TID = 272; // "__all_tenant_error"
const uint64_t OB_ALL_RESTORE_PROGRESS_TID = 279; // "__all_restore_progress"
const uint64_t OB_ALL_TENANT_OBJECT_TYPE_TID = 283; // "__all_tenant_object_type"
const uint64_t OB_ALL_TENANT_OBJECT_TYPE_HISTORY_TID = 284; // "__all_tenant_object_type_history"
const uint64_t OB_ALL_TENANT_TIME_ZONE_TID = 290; // "__all_tenant_time_zone"
const uint64_t OB_ALL_TENANT_TIME_ZONE_NAME_TID = 291; // "__all_tenant_time_zone_name"
const uint64_t OB_ALL_TENANT_TIME_ZONE_TRANSITION_TID = 292; // "__all_tenant_time_zone_transition"
const uint64_t OB_ALL_TENANT_TIME_ZONE_TRANSITION_TYPE_TID = 293; // "__all_tenant_time_zone_transition_type"
const uint64_t OB_ALL_TENANT_CONSTRAINT_COLUMN_TID = 294; // "__all_tenant_constraint_column"
const uint64_t OB_ALL_TENANT_CONSTRAINT_COLUMN_HISTORY_TID = 295; // "__all_tenant_constraint_column_history"
const uint64_t OB_ALL_TENANT_GLOBAL_TRANSACTION_TID = 296; // "__all_tenant_global_transaction"
const uint64_t OB_ALL_TENANT_DEPENDENCY_TID = 297; // "__all_tenant_dependency"
const uint64_t OB_ALL_RES_MGR_PLAN_TID = 305; // "__all_res_mgr_plan"
const uint64_t OB_ALL_RES_MGR_DIRECTIVE_TID = 306; // "__all_res_mgr_directive"
const uint64_t OB_ALL_RES_MGR_MAPPING_RULE_TID = 307; // "__all_res_mgr_mapping_rule"
const uint64_t OB_ALL_DDL_ERROR_MESSAGE_TID = 308; // "__all_ddl_error_message"
const uint64_t OB_ALL_SPACE_USAGE_TID = 309; // "__all_space_usage"
const uint64_t OB_ALL_BACKUP_SET_FILES_TID = 315; // "__all_backup_set_files"
const uint64_t OB_ALL_RES_MGR_CONSUMER_GROUP_TID = 316; // "__all_res_mgr_consumer_group"
const uint64_t OB_ALL_BACKUP_INFO_TID = 317; // "__all_backup_info"
const uint64_t OB_ALL_DDL_TASK_STATUS_TID = 319; // "__all_ddl_task_status"
const uint64_t OB_ALL_REGION_NETWORK_BANDWIDTH_LIMIT_TID = 320; // "__all_region_network_bandwidth_limit"
const uint64_t OB_ALL_DEADLOCK_EVENT_HISTORY_TID = 322; // "__all_deadlock_event_history"
const uint64_t OB_ALL_COLUMN_USAGE_TID = 323; // "__all_column_usage"
const uint64_t OB_ALL_JOB_TID = 324; // "__all_job"
const uint64_t OB_ALL_JOB_LOG_TID = 325; // "__all_job_log"
const uint64_t OB_ALL_TENANT_DIRECTORY_TID = 326; // "__all_tenant_directory"
const uint64_t OB_ALL_TENANT_DIRECTORY_HISTORY_TID = 327; // "__all_tenant_directory_history"
const uint64_t OB_ALL_TABLE_STAT_TID = 328; // "__all_table_stat"
const uint64_t OB_ALL_COLUMN_STAT_TID = 329; // "__all_column_stat"
const uint64_t OB_ALL_HISTOGRAM_STAT_TID = 330; // "__all_histogram_stat"
const uint64_t OB_ALL_MONITOR_MODIFIED_TID = 331; // "__all_monitor_modified"
const uint64_t OB_ALL_TABLE_STAT_HISTORY_TID = 332; // "__all_table_stat_history"
const uint64_t OB_ALL_COLUMN_STAT_HISTORY_TID = 333; // "__all_column_stat_history"
const uint64_t OB_ALL_HISTOGRAM_STAT_HISTORY_TID = 334; // "__all_histogram_stat_history"
const uint64_t OB_ALL_OPTSTAT_GLOBAL_PREFS_TID = 335; // "__all_optstat_global_prefs"
const uint64_t OB_ALL_OPTSTAT_USER_PREFS_TID = 336; // "__all_optstat_user_prefs"
const uint64_t OB_ALL_LS_META_TABLE_TID = 342; // "__all_ls_meta_table"
const uint64_t OB_ALL_TABLET_TO_LS_TID = 343; // "__all_tablet_to_ls"
const uint64_t OB_ALL_TABLET_META_TABLE_TID = 344; // "__all_tablet_meta_table"
const uint64_t OB_ALL_LS_STATUS_TID = 345; // "__all_ls_status"
const uint64_t OB_ALL_LOG_ARCHIVE_PROGRESS_TID = 348; // "__all_log_archive_progress"
const uint64_t OB_ALL_LOG_ARCHIVE_HISTORY_TID = 349; // "__all_log_archive_history"
const uint64_t OB_ALL_LOG_ARCHIVE_PIECE_FILES_TID = 350; // "__all_log_archive_piece_files"
const uint64_t OB_ALL_LS_LOG_ARCHIVE_PROGRESS_TID = 351; // "__all_ls_log_archive_progress"
const uint64_t OB_ALL_LS_TID = 352; // "__all_ls"
const uint64_t OB_ALL_BACKUP_STORAGE_INFO_TID = 354; // "__all_backup_storage_info"
const uint64_t OB_ALL_DAM_LAST_ARCH_TS_TID = 355; // "__all_dam_last_arch_ts"
const uint64_t OB_ALL_DAM_CLEANUP_JOBS_TID = 356; // "__all_dam_cleanup_jobs"
const uint64_t OB_ALL_BACKUP_JOB_TID = 357; // "__all_backup_job"
const uint64_t OB_ALL_BACKUP_JOB_HISTORY_TID = 358; // "__all_backup_job_history"
const uint64_t OB_ALL_BACKUP_TASK_TID = 359; // "__all_backup_task"
const uint64_t OB_ALL_BACKUP_TASK_HISTORY_TID = 360; // "__all_backup_task_history"
const uint64_t OB_ALL_BACKUP_LS_TASK_TID = 361; // "__all_backup_ls_task"
const uint64_t OB_ALL_BACKUP_LS_TASK_HISTORY_TID = 362; // "__all_backup_ls_task_history"
const uint64_t OB_ALL_BACKUP_LS_TASK_INFO_TID = 363; // "__all_backup_ls_task_info"
const uint64_t OB_ALL_BACKUP_SKIPPED_TABLET_TID = 364; // "__all_backup_skipped_tablet"
const uint64_t OB_ALL_BACKUP_SKIPPED_TABLET_HISTORY_TID = 365; // "__all_backup_skipped_tablet_history"
const uint64_t OB_ALL_TENANT_INFO_TID = 366; // "__all_tenant_info"
const uint64_t OB_ALL_TABLET_TO_TABLE_HISTORY_TID = 369; // "__all_tablet_to_table_history"
const uint64_t OB_ALL_LS_RECOVERY_STAT_TID = 370; // "__all_ls_recovery_stat"
const uint64_t OB_ALL_BACKUP_LS_TASK_INFO_HISTORY_TID = 371; // "__all_backup_ls_task_info_history"
const uint64_t OB_ALL_TABLET_REPLICA_CHECKSUM_TID = 372; // "__all_tablet_replica_checksum"
const uint64_t OB_ALL_TABLET_CHECKSUM_TID = 373; // "__all_tablet_checksum"
const uint64_t OB_ALL_LS_REPLICA_TASK_TID = 374; // "__all_ls_replica_task"
const uint64_t OB_ALL_PENDING_TRANSACTION_TID = 375; // "__all_pending_transaction"
const uint64_t OB_ALL_BALANCE_GROUP_LS_STAT_TID = 376; // "__all_balance_group_ls_stat"
const uint64_t OB_ALL_TENANT_SCHEDULER_JOB_TID = 377; // "__all_tenant_scheduler_job"
const uint64_t OB_ALL_TENANT_SCHEDULER_JOB_RUN_DETAIL_TID = 378; // "__all_tenant_scheduler_job_run_detail"
const uint64_t OB_ALL_TENANT_SCHEDULER_PROGRAM_TID = 379; // "__all_tenant_scheduler_program"
const uint64_t OB_ALL_TENANT_SCHEDULER_PROGRAM_ARGUMENT_TID = 380; // "__all_tenant_scheduler_program_argument"
const uint64_t OB_ALL_CONTEXT_TID = 381; // "__all_context"
const uint64_t OB_ALL_CONTEXT_HISTORY_TID = 382; // "__all_context_history"
const uint64_t OB_ALL_GLOBAL_CONTEXT_VALUE_TID = 383; // "__all_global_context_value"
const uint64_t OB_ALL_LS_ELECTION_REFERENCE_INFO_TID = 385; // "__all_ls_election_reference_info"
const uint64_t OB_ALL_BACKUP_DELETE_JOB_TID = 386; // "__all_backup_delete_job"
const uint64_t OB_ALL_BACKUP_DELETE_JOB_HISTORY_TID = 387; // "__all_backup_delete_job_history"
const uint64_t OB_ALL_BACKUP_DELETE_TASK_TID = 388; // "__all_backup_delete_task"
const uint64_t OB_ALL_BACKUP_DELETE_TASK_HISTORY_TID = 389; // "__all_backup_delete_task_history"
const uint64_t OB_ALL_BACKUP_DELETE_LS_TASK_TID = 390; // "__all_backup_delete_ls_task"
const uint64_t OB_ALL_BACKUP_DELETE_LS_TASK_HISTORY_TID = 391; // "__all_backup_delete_ls_task_history"
const uint64_t OB_ALL_ZONE_MERGE_INFO_TID = 392; // "__all_zone_merge_info"
const uint64_t OB_ALL_MERGE_INFO_TID = 393; // "__all_merge_info"
const uint64_t OB_ALL_FREEZE_INFO_TID = 394; // "__all_freeze_info"
const uint64_t OB_ALL_DISK_IO_CALIBRATION_TID = 395; // "__all_disk_io_calibration"
const uint64_t OB_ALL_PLAN_BASELINE_TID = 396; // "__all_plan_baseline"
const uint64_t OB_ALL_PLAN_BASELINE_ITEM_TID = 397; // "__all_plan_baseline_item"
const uint64_t OB_ALL_SPM_CONFIG_TID = 398; // "__all_spm_config"
const uint64_t OB_ALL_LOG_ARCHIVE_DEST_PARAMETER_TID = 399; // "__all_log_archive_dest_parameter"
const uint64_t OB_ALL_BACKUP_PARAMETER_TID = 400; // "__all_backup_parameter"
const uint64_t OB_ALL_LS_RESTORE_PROGRESS_TID = 401; // "__all_ls_restore_progress"
const uint64_t OB_ALL_LS_RESTORE_HISTORY_TID = 402; // "__all_ls_restore_history"
const uint64_t OB_ALL_BACKUP_STORAGE_INFO_HISTORY_TID = 403; // "__all_backup_storage_info_history"
const uint64_t OB_ALL_BACKUP_DELETE_POLICY_TID = 404; // "__all_backup_delete_policy"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_TID = 405; // "__all_mock_fk_parent_table"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_HISTORY_TID = 406; // "__all_mock_fk_parent_table_history"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_TID = 407; // "__all_mock_fk_parent_table_column"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_HISTORY_TID = 408; // "__all_mock_fk_parent_table_column_history"
const uint64_t OB_ALL_LOG_RESTORE_SOURCE_TID = 409; // "__all_log_restore_source"
const uint64_t OB_ALL_KV_TTL_TASK_TID = 410; // "__all_kv_ttl_task"
const uint64_t OB_ALL_KV_TTL_TASK_HISTORY_TID = 411; // "__all_kv_ttl_task_history"
const uint64_t OB_ALL_SERVICE_EPOCH_TID = 412; // "__all_service_epoch"
const uint64_t OB_ALL_SPATIAL_REFERENCE_SYSTEMS_TID = 413; // "__all_spatial_reference_systems"
const uint64_t OB_ALL_COLUMN_CHECKSUM_ERROR_INFO_TID = 416; // "__all_column_checksum_error_info"
const uint64_t OB_ALL_COLUMN_GROUP_TID = 419; // "__all_column_group"
const uint64_t OB_ALL_COLUMN_GROUP_HISTORY_TID = 420; // "__all_column_group_history"
const uint64_t OB_ALL_COLUMN_GROUP_MAPPING_TID = 421; // "__all_column_group_mapping"
const uint64_t OB_ALL_COLUMN_GROUP_MAPPING_HISTORY_TID = 422; // "__all_column_group_mapping_history"
const uint64_t OB_ALL_TRANSFER_TASK_TID = 423; // "__all_transfer_task"
const uint64_t OB_ALL_TRANSFER_TASK_HISTORY_TID = 424; // "__all_transfer_task_history"
const uint64_t OB_ALL_BALANCE_JOB_TID = 425; // "__all_balance_job"
const uint64_t OB_ALL_BALANCE_JOB_HISTORY_TID = 426; // "__all_balance_job_history"
const uint64_t OB_ALL_BALANCE_TASK_TID = 427; // "__all_balance_task"
const uint64_t OB_ALL_BALANCE_TASK_HISTORY_TID = 428; // "__all_balance_task_history"
const uint64_t OB_ALL_ARBITRATION_SERVICE_TID = 429; // "__all_arbitration_service"
const uint64_t OB_ALL_LS_ARB_REPLICA_TASK_TID = 430; // "__all_ls_arb_replica_task"
const uint64_t OB_ALL_DATA_DICTIONARY_IN_LOG_TID = 431; // "__all_data_dictionary_in_log"
const uint64_t OB_ALL_LS_ARB_REPLICA_TASK_HISTORY_TID = 432; // "__all_ls_arb_replica_task_history"
const uint64_t OB_ALL_RLS_POLICY_TID = 433; // "__all_rls_policy"
const uint64_t OB_ALL_RLS_POLICY_HISTORY_TID = 434; // "__all_rls_policy_history"
const uint64_t OB_ALL_RLS_SECURITY_COLUMN_TID = 435; // "__all_rls_security_column"
const uint64_t OB_ALL_RLS_SECURITY_COLUMN_HISTORY_TID = 436; // "__all_rls_security_column_history"
const uint64_t OB_ALL_RLS_GROUP_TID = 437; // "__all_rls_group"
const uint64_t OB_ALL_RLS_GROUP_HISTORY_TID = 438; // "__all_rls_group_history"
const uint64_t OB_ALL_RLS_CONTEXT_TID = 439; // "__all_rls_context"
const uint64_t OB_ALL_RLS_CONTEXT_HISTORY_TID = 440; // "__all_rls_context_history"
const uint64_t OB_ALL_RLS_ATTRIBUTE_TID = 441; // "__all_rls_attribute"
const uint64_t OB_ALL_RLS_ATTRIBUTE_HISTORY_TID = 442; // "__all_rls_attribute_history"
const uint64_t OB_ALL_TENANT_REWRITE_RULES_TID = 443; // "__all_tenant_rewrite_rules"
const uint64_t OB_ALL_RESERVED_SNAPSHOT_TID = 444; // "__all_reserved_snapshot"
const uint64_t OB_ALL_CLUSTER_EVENT_HISTORY_TID = 445; // "__all_cluster_event_history"
const uint64_t OB_ALL_LS_TRANSFER_MEMBER_LIST_LOCK_INFO_TID = 446; // "__all_ls_transfer_member_list_lock_info"
const uint64_t OB_ALL_EXTERNAL_TABLE_FILE_TID = 450; // "__all_external_table_file"
const uint64_t OB_ALL_TASK_OPT_STAT_GATHER_HISTORY_TID = 451; // "__all_task_opt_stat_gather_history"
const uint64_t OB_ALL_TABLE_OPT_STAT_GATHER_HISTORY_TID = 452; // "__all_table_opt_stat_gather_history"
const uint64_t OB_ALL_ZONE_STORAGE_TID = 453; // "__all_zone_storage"
const uint64_t OB_ALL_ZONE_STORAGE_OPERATION_TID = 454; // "__all_zone_storage_operation"
const uint64_t OB_WR_ACTIVE_SESSION_HISTORY_TID = 455; // "__wr_active_session_history"
const uint64_t OB_WR_SNAPSHOT_TID = 456; // "__wr_snapshot"
const uint64_t OB_WR_STATNAME_TID = 457; // "__wr_statname"
const uint64_t OB_WR_SYSSTAT_TID = 458; // "__wr_sysstat"
const uint64_t OB_ALL_BALANCE_TASK_HELPER_TID = 459; // "__all_balance_task_helper"
const uint64_t OB_ALL_TENANT_SNAPSHOT_TID = 460; // "__all_tenant_snapshot"
const uint64_t OB_ALL_TENANT_SNAPSHOT_LS_TID = 461; // "__all_tenant_snapshot_ls"
const uint64_t OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_TID = 462; // "__all_tenant_snapshot_ls_replica"
const uint64_t OB_ALL_MLOG_TID = 463; // "__all_mlog"
const uint64_t OB_ALL_MVIEW_TID = 464; // "__all_mview"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_TID = 465; // "__all_mview_refresh_stats_sys_defaults"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_PARAMS_TID = 466; // "__all_mview_refresh_stats_params"
const uint64_t OB_ALL_MVIEW_REFRESH_RUN_STATS_TID = 467; // "__all_mview_refresh_run_stats"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_TID = 468; // "__all_mview_refresh_stats"
const uint64_t OB_ALL_MVIEW_REFRESH_CHANGE_STATS_TID = 469; // "__all_mview_refresh_change_stats"
const uint64_t OB_ALL_MVIEW_REFRESH_STMT_STATS_TID = 470; // "__all_mview_refresh_stmt_stats"
const uint64_t OB_ALL_DBMS_LOCK_ALLOCATED_TID = 471; // "__all_dbms_lock_allocated"
const uint64_t OB_WR_CONTROL_TID = 472; // "__wr_control"
const uint64_t OB_ALL_TENANT_EVENT_HISTORY_TID = 473; // "__all_tenant_event_history"
const uint64_t OB_ALL_TENANT_SCHEDULER_JOB_CLASS_TID = 474; // "__all_tenant_scheduler_job_class"
const uint64_t OB_ALL_RECOVER_TABLE_JOB_TID = 475; // "__all_recover_table_job"
const uint64_t OB_ALL_RECOVER_TABLE_JOB_HISTORY_TID = 476; // "__all_recover_table_job_history"
const uint64_t OB_ALL_IMPORT_TABLE_JOB_TID = 477; // "__all_import_table_job"
const uint64_t OB_ALL_IMPORT_TABLE_JOB_HISTORY_TID = 478; // "__all_import_table_job_history"
const uint64_t OB_ALL_IMPORT_TABLE_TASK_TID = 479; // "__all_import_table_task"
const uint64_t OB_ALL_IMPORT_TABLE_TASK_HISTORY_TID = 480; // "__all_import_table_task_history"
const uint64_t OB_ALL_TABLET_REORGANIZE_HISTORY_TID = 482; // "__all_tablet_reorganize_history"
const uint64_t OB_ALL_STORAGE_HA_ERROR_DIAGNOSE_HISTORY_TID = 483; // "__all_storage_ha_error_diagnose_history"
const uint64_t OB_ALL_STORAGE_HA_PERF_DIAGNOSE_HISTORY_TID = 484; // "__all_storage_ha_perf_diagnose_history"
const uint64_t OB_ALL_CLONE_JOB_TID = 485; // "__all_clone_job"
const uint64_t OB_ALL_CLONE_JOB_HISTORY_TID = 486; // "__all_clone_job_history"
const uint64_t OB_WR_SYSTEM_EVENT_TID = 487; // "__wr_system_event"
const uint64_t OB_WR_EVENT_NAME_TID = 488; // "__wr_event_name"
const uint64_t OB_ALL_ROUTINE_PRIVILEGE_TID = 490; // "__all_routine_privilege"
const uint64_t OB_ALL_ROUTINE_PRIVILEGE_HISTORY_TID = 491; // "__all_routine_privilege_history"
const uint64_t OB_WR_SQLSTAT_TID = 492; // "__wr_sqlstat"
const uint64_t OB_ALL_NCOMP_DLL_TID = 493; // "__all_ncomp_dll"
const uint64_t OB_ALL_AUX_STAT_TID = 494; // "__all_aux_stat"
const uint64_t OB_ALL_INDEX_USAGE_INFO_TID = 495; // "__all_index_usage_info"
const uint64_t OB_ALL_DETECT_LOCK_INFO_TID = 496; // "__all_detect_lock_info"
const uint64_t OB_ALL_CLIENT_TO_SERVER_SESSION_INFO_TID = 497; // "__all_client_to_server_session_info"
const uint64_t OB_ALL_TRANSFER_PARTITION_TASK_TID = 498; // "__all_transfer_partition_task"
const uint64_t OB_ALL_TRANSFER_PARTITION_TASK_HISTORY_TID = 499; // "__all_transfer_partition_task_history"
const uint64_t OB_ALL_TENANT_SNAPSHOT_JOB_TID = 500; // "__all_tenant_snapshot_job"
const uint64_t OB_WR_SQLTEXT_TID = 501; // "__wr_sqltext"
const uint64_t OB_ALL_TRUSTED_ROOT_CERTIFICATE_TID = 502; // "__all_trusted_root_certificate"
const uint64_t OB_ALL_AUDIT_LOG_FILTER_TID = 503; // "__all_audit_log_filter"
const uint64_t OB_ALL_AUDIT_LOG_USER_TID = 504; // "__all_audit_log_user"
const uint64_t OB_ALL_COLUMN_PRIVILEGE_TID = 505; // "__all_column_privilege"
const uint64_t OB_ALL_COLUMN_PRIVILEGE_HISTORY_TID = 506; // "__all_column_privilege_history"
const uint64_t OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_HISTORY_TID = 507; // "__all_tenant_snapshot_ls_replica_history"
const uint64_t OB_ALL_LS_REPLICA_TASK_HISTORY_TID = 508; // "__all_ls_replica_task_history"
const uint64_t OB_ALL_TABLET_CHECKSUM_ERROR_INFO_TID = 511; // "__all_tablet_checksum_error_info"
const uint64_t OB_ALL_USER_PROXY_INFO_TID = 512; // "__all_user_proxy_info"
const uint64_t OB_ALL_USER_PROXY_INFO_HISTORY_TID = 513; // "__all_user_proxy_info_history"
const uint64_t OB_ALL_USER_PROXY_ROLE_INFO_TID = 514; // "__all_user_proxy_role_info"
const uint64_t OB_ALL_USER_PROXY_ROLE_INFO_HISTORY_TID = 515; // "__all_user_proxy_role_info_history"
const uint64_t OB_ALL_SERVICE_TID = 516; // "__all_service"
const uint64_t OB_ALL_STORAGE_IO_USAGE_TID = 517; // "__all_storage_io_usage"
const uint64_t OB_ALL_MVIEW_DEP_TID = 518; // "__all_mview_dep"
const uint64_t OB_ALL_SCHEDULER_JOB_RUN_DETAIL_V2_TID = 519; // "__all_scheduler_job_run_detail_v2"
const uint64_t OB_ALL_SPM_EVO_RESULT_TID = 520; // "__all_spm_evo_result"
const uint64_t OB_ALL_PKG_TYPE_TID = 522; // "__all_pkg_type"
const uint64_t OB_ALL_PKG_TYPE_ATTR_TID = 523; // "__all_pkg_type_attr"
const uint64_t OB_ALL_PKG_COLL_TYPE_TID = 524; // "__all_pkg_coll_type"
const uint64_t OB_WR_SQL_PLAN_TID = 525; // "__wr_sql_plan"
const uint64_t OB_ALL_KV_REDIS_TABLE_TID = 527; // "__all_kv_redis_table"
const uint64_t OB_ALL_NCOMP_DLL_V2_TID = 528; // "__all_ncomp_dll_v2"
const uint64_t OB_FT_DICT_IK_UTF8_TID = 531; // "__ft_dict_ik_utf8"
const uint64_t OB_FT_STOPWORD_IK_UTF8_TID = 532; // "__ft_stopword_ik_utf8"
const uint64_t OB_FT_QUANTIFIER_IK_UTF8_TID = 533; // "__ft_quantifier_ik_utf8"
const uint64_t OB_TENANT_VIRTUAL_ALL_TABLE_TID = 10001; // "__tenant_virtual_all_table"
const uint64_t OB_TENANT_VIRTUAL_TABLE_COLUMN_TID = 10002; // "__tenant_virtual_table_column"
const uint64_t OB_TENANT_VIRTUAL_TABLE_INDEX_TID = 10003; // "__tenant_virtual_table_index"
const uint64_t OB_TENANT_VIRTUAL_SHOW_CREATE_DATABASE_TID = 10004; // "__tenant_virtual_show_create_database"
const uint64_t OB_TENANT_VIRTUAL_SHOW_CREATE_TABLE_TID = 10005; // "__tenant_virtual_show_create_table"
const uint64_t OB_TENANT_VIRTUAL_SESSION_VARIABLE_TID = 10006; // "__tenant_virtual_session_variable"
const uint64_t OB_TENANT_VIRTUAL_PRIVILEGE_GRANT_TID = 10007; // "__tenant_virtual_privilege_grant"
const uint64_t OB_ALL_VIRTUAL_PROCESSLIST_TID = 10008; // "__all_virtual_processlist"
const uint64_t OB_TENANT_VIRTUAL_WARNING_TID = 10009; // "__tenant_virtual_warning"
const uint64_t OB_TENANT_VIRTUAL_CURRENT_TENANT_TID = 10010; // "__tenant_virtual_current_tenant"
const uint64_t OB_TENANT_VIRTUAL_DATABASE_STATUS_TID = 10011; // "__tenant_virtual_database_status"
const uint64_t OB_TENANT_VIRTUAL_TENANT_STATUS_TID = 10012; // "__tenant_virtual_tenant_status"
const uint64_t OB_TENANT_VIRTUAL_STATNAME_TID = 10015; // "__tenant_virtual_statname"
const uint64_t OB_TENANT_VIRTUAL_EVENT_NAME_TID = 10016; // "__tenant_virtual_event_name"
const uint64_t OB_TENANT_VIRTUAL_GLOBAL_VARIABLE_TID = 10017; // "__tenant_virtual_global_variable"
const uint64_t OB_TENANT_VIRTUAL_SHOW_TABLES_TID = 10018; // "__tenant_virtual_show_tables"
const uint64_t OB_TENANT_VIRTUAL_SHOW_CREATE_PROCEDURE_TID = 10019; // "__tenant_virtual_show_create_procedure"
const uint64_t OB_ALL_VIRTUAL_CORE_META_TABLE_TID = 11001; // "__all_virtual_core_meta_table"
const uint64_t OB_ALL_VIRTUAL_PLAN_CACHE_STAT_TID = 11003; // "__all_virtual_plan_cache_stat"
const uint64_t OB_ALL_VIRTUAL_PLAN_STAT_TID = 11004; // "__all_virtual_plan_stat"
const uint64_t OB_ALL_VIRTUAL_MEM_LEAK_CHECKER_INFO_TID = 11006; // "__all_virtual_mem_leak_checker_info"
const uint64_t OB_ALL_VIRTUAL_LATCH_TID = 11007; // "__all_virtual_latch"
const uint64_t OB_ALL_VIRTUAL_KVCACHE_INFO_TID = 11008; // "__all_virtual_kvcache_info"
const uint64_t OB_ALL_VIRTUAL_DATA_TYPE_CLASS_TID = 11009; // "__all_virtual_data_type_class"
const uint64_t OB_ALL_VIRTUAL_DATA_TYPE_TID = 11010; // "__all_virtual_data_type"
const uint64_t OB_ALL_VIRTUAL_SESSION_EVENT_TID = 11013; // "__all_virtual_session_event"
const uint64_t OB_ALL_VIRTUAL_SESSION_WAIT_TID = 11014; // "__all_virtual_session_wait"
const uint64_t OB_ALL_VIRTUAL_SESSION_WAIT_HISTORY_TID = 11015; // "__all_virtual_session_wait_history"
const uint64_t OB_ALL_VIRTUAL_SYSTEM_EVENT_TID = 11017; // "__all_virtual_system_event"
const uint64_t OB_ALL_VIRTUAL_TENANT_MEMSTORE_INFO_TID = 11018; // "__all_virtual_tenant_memstore_info"
const uint64_t OB_ALL_VIRTUAL_CONCURRENCY_OBJECT_POOL_TID = 11019; // "__all_virtual_concurrency_object_pool"
const uint64_t OB_ALL_VIRTUAL_SESSTAT_TID = 11020; // "__all_virtual_sesstat"
const uint64_t OB_ALL_VIRTUAL_SYSSTAT_TID = 11021; // "__all_virtual_sysstat"
const uint64_t OB_ALL_VIRTUAL_DISK_STAT_TID = 11023; // "__all_virtual_disk_stat"
const uint64_t OB_ALL_VIRTUAL_MEMSTORE_INFO_TID = 11024; // "__all_virtual_memstore_info"
const uint64_t OB_ALL_VIRTUAL_UPGRADE_INSPECTION_TID = 11026; // "__all_virtual_upgrade_inspection"
const uint64_t OB_ALL_VIRTUAL_TRANS_STAT_TID = 11027; // "__all_virtual_trans_stat"
const uint64_t OB_ALL_VIRTUAL_TRANS_CTX_MGR_STAT_TID = 11028; // "__all_virtual_trans_ctx_mgr_stat"
const uint64_t OB_ALL_VIRTUAL_TRANS_SCHEDULER_TID = 11029; // "__all_virtual_trans_scheduler"
const uint64_t OB_ALL_VIRTUAL_SQL_AUDIT_TID = 11031; // "__all_virtual_sql_audit"
const uint64_t OB_ALL_VIRTUAL_CORE_ALL_TABLE_TID = 11035; // "__all_virtual_core_all_table"
const uint64_t OB_ALL_VIRTUAL_CORE_COLUMN_TABLE_TID = 11036; // "__all_virtual_core_column_table"
const uint64_t OB_ALL_VIRTUAL_MEMORY_INFO_TID = 11037; // "__all_virtual_memory_info"
const uint64_t OB_ALL_VIRTUAL_SYS_PARAMETER_STAT_TID = 11039; // "__all_virtual_sys_parameter_stat"
const uint64_t OB_ALL_VIRTUAL_TRACE_SPAN_INFO_TID = 11042; // "__all_virtual_trace_span_info"
const uint64_t OB_ALL_VIRTUAL_ENGINE_TID = 11043; // "__all_virtual_engine"
const uint64_t OB_ALL_VIRTUAL_PROXY_SERVER_STAT_TID = 11045; // "__all_virtual_proxy_server_stat"
const uint64_t OB_ALL_VIRTUAL_PROXY_SYS_VARIABLE_TID = 11046; // "__all_virtual_proxy_sys_variable"
const uint64_t OB_ALL_VIRTUAL_PROXY_SCHEMA_TID = 11047; // "__all_virtual_proxy_schema"
const uint64_t OB_ALL_VIRTUAL_PLAN_CACHE_PLAN_EXPLAIN_TID = 11048; // "__all_virtual_plan_cache_plan_explain"
const uint64_t OB_ALL_VIRTUAL_OBRPC_STAT_TID = 11049; // "__all_virtual_obrpc_stat"
const uint64_t OB_TENANT_VIRTUAL_OUTLINE_TID = 11053; // "__tenant_virtual_outline"
const uint64_t OB_TENANT_VIRTUAL_CONCURRENT_LIMIT_SQL_TID = 11054; // "__tenant_virtual_concurrent_limit_sql"
const uint64_t OB_ALL_VIRTUAL_TABLET_SSTABLE_MACRO_INFO_TID = 11056; // "__all_virtual_tablet_sstable_macro_info"
const uint64_t OB_ALL_VIRTUAL_PROXY_PARTITION_INFO_TID = 11057; // "__all_virtual_proxy_partition_info"
const uint64_t OB_ALL_VIRTUAL_PROXY_PARTITION_TID = 11058; // "__all_virtual_proxy_partition"
const uint64_t OB_ALL_VIRTUAL_PROXY_SUB_PARTITION_TID = 11059; // "__all_virtual_proxy_sub_partition"
const uint64_t OB_ALL_VIRTUAL_SYS_TASK_STATUS_TID = 11071; // "__all_virtual_sys_task_status"
const uint64_t OB_ALL_VIRTUAL_MACRO_BLOCK_MARKER_STATUS_TID = 11072; // "__all_virtual_macro_block_marker_status"
const uint64_t OB_ALL_VIRTUAL_IO_STAT_TID = 11080; // "__all_virtual_io_stat"
const uint64_t OB_ALL_VIRTUAL_LONG_OPS_STATUS_TID = 11081; // "__all_virtual_long_ops_status"
const uint64_t OB_ALL_VIRTUAL_SERVER_OBJECT_POOL_TID = 11084; // "__all_virtual_server_object_pool"
const uint64_t OB_ALL_VIRTUAL_TRANS_LOCK_STAT_TID = 11085; // "__all_virtual_trans_lock_stat"
const uint64_t OB_TENANT_VIRTUAL_SHOW_CREATE_TABLEGROUP_TID = 11087; // "__tenant_virtual_show_create_tablegroup"
const uint64_t OB_ALL_VIRTUAL_SERVER_BLACKLIST_TID = 11088; // "__all_virtual_server_blacklist"
const uint64_t OB_ALL_VIRTUAL_TENANT_PARAMETER_STAT_TID = 11092; // "__all_virtual_tenant_parameter_stat"
const uint64_t OB_ALL_VIRTUAL_SERVER_SCHEMA_INFO_TID = 11093; // "__all_virtual_server_schema_info"
const uint64_t OB_ALL_VIRTUAL_MEMORY_CONTEXT_STAT_TID = 11094; // "__all_virtual_memory_context_stat"
const uint64_t OB_ALL_VIRTUAL_DUMP_TENANT_INFO_TID = 11095; // "__all_virtual_dump_tenant_info"
const uint64_t OB_ALL_VIRTUAL_TENANT_PARAMETER_INFO_TID = 11096; // "__all_virtual_tenant_parameter_info"
const uint64_t OB_ALL_VIRTUAL_AUDIT_OPERATION_TID = 11097; // "__all_virtual_audit_operation"
const uint64_t OB_ALL_VIRTUAL_AUDIT_ACTION_TID = 11098; // "__all_virtual_audit_action"
const uint64_t OB_ALL_VIRTUAL_DAG_WARNING_HISTORY_TID = 11099; // "__all_virtual_dag_warning_history"
const uint64_t OB_ALL_VIRTUAL_TABLET_ENCRYPT_INFO_TID = 11100; // "__all_virtual_tablet_encrypt_info"
const uint64_t OB_TENANT_VIRTUAL_SHOW_RESTORE_PREVIEW_TID = 11102; // "__tenant_virtual_show_restore_preview"
const uint64_t OB_ALL_VIRTUAL_MASTER_KEY_VERSION_INFO_TID = 11104; // "__all_virtual_master_key_version_info"
const uint64_t OB_ALL_VIRTUAL_DAG_TID = 11105; // "__all_virtual_dag"
const uint64_t OB_ALL_VIRTUAL_DAG_SCHEDULER_TID = 11106; // "__all_virtual_dag_scheduler"
const uint64_t OB_ALL_VIRTUAL_SERVER_COMPACTION_PROGRESS_TID = 11107; // "__all_virtual_server_compaction_progress"
const uint64_t OB_ALL_VIRTUAL_TABLET_COMPACTION_PROGRESS_TID = 11108; // "__all_virtual_tablet_compaction_progress"
const uint64_t OB_ALL_VIRTUAL_COMPACTION_DIAGNOSE_INFO_TID = 11109; // "__all_virtual_compaction_diagnose_info"
const uint64_t OB_ALL_VIRTUAL_COMPACTION_SUGGESTION_TID = 11110; // "__all_virtual_compaction_suggestion"
const uint64_t OB_ALL_VIRTUAL_SESSION_INFO_TID = 11111; // "__all_virtual_session_info"
const uint64_t OB_ALL_VIRTUAL_TABLET_COMPACTION_HISTORY_TID = 11112; // "__all_virtual_tablet_compaction_history"
const uint64_t OB_ALL_VIRTUAL_IO_CALIBRATION_STATUS_TID = 11113; // "__all_virtual_io_calibration_status"
const uint64_t OB_ALL_VIRTUAL_IO_BENCHMARK_TID = 11114; // "__all_virtual_io_benchmark"
const uint64_t OB_ALL_VIRTUAL_IO_QUOTA_TID = 11115; // "__all_virtual_io_quota"
const uint64_t OB_ALL_VIRTUAL_SERVER_COMPACTION_EVENT_HISTORY_TID = 11116; // "__all_virtual_server_compaction_event_history"
const uint64_t OB_ALL_VIRTUAL_TABLET_STAT_TID = 11117; // "__all_virtual_tablet_stat"
const uint64_t OB_ALL_VIRTUAL_DDL_SIM_POINT_TID = 11118; // "__all_virtual_ddl_sim_point"
const uint64_t OB_ALL_VIRTUAL_DDL_SIM_POINT_STAT_TID = 11119; // "__all_virtual_ddl_sim_point_stat"
const uint64_t OB_ALL_VIRTUAL_RES_MGR_SYSSTAT_TID = 11120; // "__all_virtual_res_mgr_sysstat"
const uint64_t OB_SESSION_VARIABLES_TID = 12001; // "SESSION_VARIABLES"
const uint64_t OB_GLOBAL_STATUS_TID = 12006; // "GLOBAL_STATUS"
const uint64_t OB_SESSION_STATUS_TID = 12008; // "SESSION_STATUS"
const uint64_t OB_USER_TID = 12009; // "user"
const uint64_t OB_DB_TID = 12010; // "db"
const uint64_t OB_ALL_VIRTUAL_LOCK_WAIT_STAT_TID = 12013; // "__all_virtual_lock_wait_stat"
const uint64_t OB_TENANT_VIRTUAL_COLLATION_TID = 12031; // "__tenant_virtual_collation"
const uint64_t OB_TENANT_VIRTUAL_CHARSET_TID = 12032; // "__tenant_virtual_charset"
const uint64_t OB_ALL_VIRTUAL_TENANT_MEMSTORE_ALLOCATOR_INFO_TID = 12033; // "__all_virtual_tenant_memstore_allocator_info"
const uint64_t OB_ALL_VIRTUAL_TABLE_MGR_TID = 12034; // "__all_virtual_table_mgr"
const uint64_t OB_ALL_VIRTUAL_FREEZE_INFO_TID = 12036; // "__all_virtual_freeze_info"
const uint64_t OB_ALL_VIRTUAL_BAD_BLOCK_TABLE_TID = 12038; // "__all_virtual_bad_block_table"
const uint64_t OB_ALL_VIRTUAL_PX_WORKER_STAT_TID = 12039; // "__all_virtual_px_worker_stat"
const uint64_t OB_ALL_VIRTUAL_AUTO_INCREMENT_TID = 12055; // "__all_virtual_auto_increment"
const uint64_t OB_ALL_VIRTUAL_SEQUENCE_VALUE_TID = 12056; // "__all_virtual_sequence_value"
const uint64_t OB_ALL_VIRTUAL_TABLET_STORE_STAT_TID = 12058; // "__all_virtual_tablet_store_stat"
const uint64_t OB_ALL_VIRTUAL_DDL_OPERATION_TID = 12059; // "__all_virtual_ddl_operation"
const uint64_t OB_ALL_VIRTUAL_OUTLINE_TID = 12060; // "__all_virtual_outline"
const uint64_t OB_ALL_VIRTUAL_OUTLINE_HISTORY_TID = 12061; // "__all_virtual_outline_history"
const uint64_t OB_ALL_VIRTUAL_SYNONYM_TID = 12062; // "__all_virtual_synonym"
const uint64_t OB_ALL_VIRTUAL_SYNONYM_HISTORY_TID = 12063; // "__all_virtual_synonym_history"
const uint64_t OB_ALL_VIRTUAL_DATABASE_PRIVILEGE_TID = 12064; // "__all_virtual_database_privilege"
const uint64_t OB_ALL_VIRTUAL_DATABASE_PRIVILEGE_HISTORY_TID = 12065; // "__all_virtual_database_privilege_history"
const uint64_t OB_ALL_VIRTUAL_TABLE_PRIVILEGE_TID = 12066; // "__all_virtual_table_privilege"
const uint64_t OB_ALL_VIRTUAL_TABLE_PRIVILEGE_HISTORY_TID = 12067; // "__all_virtual_table_privilege_history"
const uint64_t OB_ALL_VIRTUAL_DATABASE_TID = 12068; // "__all_virtual_database"
const uint64_t OB_ALL_VIRTUAL_DATABASE_HISTORY_TID = 12069; // "__all_virtual_database_history"
const uint64_t OB_ALL_VIRTUAL_TABLEGROUP_TID = 12070; // "__all_virtual_tablegroup"
const uint64_t OB_ALL_VIRTUAL_TABLEGROUP_HISTORY_TID = 12071; // "__all_virtual_tablegroup_history"
const uint64_t OB_ALL_VIRTUAL_TABLE_TID = 12072; // "__all_virtual_table"
const uint64_t OB_ALL_VIRTUAL_TABLE_HISTORY_TID = 12073; // "__all_virtual_table_history"
const uint64_t OB_ALL_VIRTUAL_COLUMN_TID = 12074; // "__all_virtual_column"
const uint64_t OB_ALL_VIRTUAL_COLUMN_HISTORY_TID = 12075; // "__all_virtual_column_history"
const uint64_t OB_ALL_VIRTUAL_PART_TID = 12076; // "__all_virtual_part"
const uint64_t OB_ALL_VIRTUAL_PART_HISTORY_TID = 12077; // "__all_virtual_part_history"
const uint64_t OB_ALL_VIRTUAL_PART_INFO_TID = 12078; // "__all_virtual_part_info"
const uint64_t OB_ALL_VIRTUAL_PART_INFO_HISTORY_TID = 12079; // "__all_virtual_part_info_history"
const uint64_t OB_ALL_VIRTUAL_DEF_SUB_PART_TID = 12080; // "__all_virtual_def_sub_part"
const uint64_t OB_ALL_VIRTUAL_DEF_SUB_PART_HISTORY_TID = 12081; // "__all_virtual_def_sub_part_history"
const uint64_t OB_ALL_VIRTUAL_SUB_PART_TID = 12082; // "__all_virtual_sub_part"
const uint64_t OB_ALL_VIRTUAL_SUB_PART_HISTORY_TID = 12083; // "__all_virtual_sub_part_history"
const uint64_t OB_ALL_VIRTUAL_CONSTRAINT_TID = 12084; // "__all_virtual_constraint"
const uint64_t OB_ALL_VIRTUAL_CONSTRAINT_HISTORY_TID = 12085; // "__all_virtual_constraint_history"
const uint64_t OB_ALL_VIRTUAL_FOREIGN_KEY_TID = 12086; // "__all_virtual_foreign_key"
const uint64_t OB_ALL_VIRTUAL_FOREIGN_KEY_HISTORY_TID = 12087; // "__all_virtual_foreign_key_history"
const uint64_t OB_ALL_VIRTUAL_FOREIGN_KEY_COLUMN_TID = 12088; // "__all_virtual_foreign_key_column"
const uint64_t OB_ALL_VIRTUAL_FOREIGN_KEY_COLUMN_HISTORY_TID = 12089; // "__all_virtual_foreign_key_column_history"
const uint64_t OB_ALL_VIRTUAL_TEMP_TABLE_TID = 12090; // "__all_virtual_temp_table"
const uint64_t OB_ALL_VIRTUAL_ORI_SCHEMA_VERSION_TID = 12091; // "__all_virtual_ori_schema_version"
const uint64_t OB_ALL_VIRTUAL_SYS_STAT_TID = 12092; // "__all_virtual_sys_stat"
const uint64_t OB_ALL_VIRTUAL_USER_TID = 12093; // "__all_virtual_user"
const uint64_t OB_ALL_VIRTUAL_USER_HISTORY_TID = 12094; // "__all_virtual_user_history"
const uint64_t OB_ALL_VIRTUAL_SYS_VARIABLE_TID = 12095; // "__all_virtual_sys_variable"
const uint64_t OB_ALL_VIRTUAL_SYS_VARIABLE_HISTORY_TID = 12096; // "__all_virtual_sys_variable_history"
const uint64_t OB_ALL_VIRTUAL_FUNC_TID = 12097; // "__all_virtual_func"
const uint64_t OB_ALL_VIRTUAL_FUNC_HISTORY_TID = 12098; // "__all_virtual_func_history"
const uint64_t OB_ALL_VIRTUAL_PACKAGE_TID = 12099; // "__all_virtual_package"
const uint64_t OB_ALL_VIRTUAL_PACKAGE_HISTORY_TID = 12100; // "__all_virtual_package_history"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_TID = 12101; // "__all_virtual_routine"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_HISTORY_TID = 12102; // "__all_virtual_routine_history"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_PARAM_TID = 12103; // "__all_virtual_routine_param"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_PARAM_HISTORY_TID = 12104; // "__all_virtual_routine_param_history"
const uint64_t OB_ALL_VIRTUAL_TYPE_TID = 12105; // "__all_virtual_type"
const uint64_t OB_ALL_VIRTUAL_TYPE_HISTORY_TID = 12106; // "__all_virtual_type_history"
const uint64_t OB_ALL_VIRTUAL_TYPE_ATTR_TID = 12107; // "__all_virtual_type_attr"
const uint64_t OB_ALL_VIRTUAL_TYPE_ATTR_HISTORY_TID = 12108; // "__all_virtual_type_attr_history"
const uint64_t OB_ALL_VIRTUAL_COLL_TYPE_TID = 12109; // "__all_virtual_coll_type"
const uint64_t OB_ALL_VIRTUAL_COLL_TYPE_HISTORY_TID = 12110; // "__all_virtual_coll_type_history"
const uint64_t OB_ALL_VIRTUAL_RECYCLEBIN_TID = 12115; // "__all_virtual_recyclebin"
const uint64_t OB_ALL_VIRTUAL_SEQUENCE_OBJECT_TID = 12119; // "__all_virtual_sequence_object"
const uint64_t OB_ALL_VIRTUAL_SEQUENCE_OBJECT_HISTORY_TID = 12120; // "__all_virtual_sequence_object_history"
const uint64_t OB_ALL_VIRTUAL_RAID_STAT_TID = 12121; // "__all_virtual_raid_stat"
const uint64_t OB_ALL_VIRTUAL_DTL_CHANNEL_TID = 12123; // "__all_virtual_dtl_channel"
const uint64_t OB_ALL_VIRTUAL_DTL_MEMORY_TID = 12124; // "__all_virtual_dtl_memory"
const uint64_t OB_ALL_VIRTUAL_DBLINK_TID = 12126; // "__all_virtual_dblink"
const uint64_t OB_ALL_VIRTUAL_DBLINK_HISTORY_TID = 12127; // "__all_virtual_dblink_history"
const uint64_t OB_ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_TID = 12129; // "__all_virtual_tenant_role_grantee_map"
const uint64_t OB_ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_HISTORY_TID = 12130; // "__all_virtual_tenant_role_grantee_map_history"
const uint64_t OB_ALL_VIRTUAL_TENANT_KEYSTORE_TID = 12131; // "__all_virtual_tenant_keystore"
const uint64_t OB_ALL_VIRTUAL_TENANT_KEYSTORE_HISTORY_TID = 12132; // "__all_virtual_tenant_keystore_history"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_POLICY_TID = 12133; // "__all_virtual_tenant_ols_policy"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_POLICY_HISTORY_TID = 12134; // "__all_virtual_tenant_ols_policy_history"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_COMPONENT_TID = 12135; // "__all_virtual_tenant_ols_component"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_COMPONENT_HISTORY_TID = 12136; // "__all_virtual_tenant_ols_component_history"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_LABEL_TID = 12137; // "__all_virtual_tenant_ols_label"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_LABEL_HISTORY_TID = 12138; // "__all_virtual_tenant_ols_label_history"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_TID = 12139; // "__all_virtual_tenant_ols_user_level"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_HISTORY_TID = 12140; // "__all_virtual_tenant_ols_user_level_history"
const uint64_t OB_ALL_VIRTUAL_TENANT_TABLESPACE_TID = 12142; // "__all_virtual_tenant_tablespace"
const uint64_t OB_ALL_VIRTUAL_TENANT_TABLESPACE_HISTORY_TID = 12143; // "__all_virtual_tenant_tablespace_history"
const uint64_t OB_ALL_VIRTUAL_INFORMATION_COLUMNS_TID = 12144; // "__ALL_VIRTUAL_INFORMATION_COLUMNS"
const uint64_t OB_ALL_VIRTUAL_TENANT_USER_FAILED_LOGIN_STAT_TID = 12146; // "__all_virtual_tenant_user_failed_login_stat"
const uint64_t OB_ALL_VIRTUAL_TENANT_PROFILE_TID = 12147; // "__all_virtual_tenant_profile"
const uint64_t OB_ALL_VIRTUAL_TENANT_PROFILE_HISTORY_TID = 12148; // "__all_virtual_tenant_profile_history"
const uint64_t OB_ALL_VIRTUAL_SECURITY_AUDIT_TID = 12149; // "__all_virtual_security_audit"
const uint64_t OB_ALL_VIRTUAL_SECURITY_AUDIT_HISTORY_TID = 12150; // "__all_virtual_security_audit_history"
const uint64_t OB_ALL_VIRTUAL_TRIGGER_TID = 12151; // "__all_virtual_trigger"
const uint64_t OB_ALL_VIRTUAL_TRIGGER_HISTORY_TID = 12152; // "__all_virtual_trigger_history"
const uint64_t OB_ALL_VIRTUAL_PS_STAT_TID = 12155; // "__all_virtual_ps_stat"
const uint64_t OB_ALL_VIRTUAL_PS_ITEM_INFO_TID = 12156; // "__all_virtual_ps_item_info"
const uint64_t OB_ALL_VIRTUAL_SQL_WORKAREA_HISTORY_STAT_TID = 12158; // "__all_virtual_sql_workarea_history_stat"
const uint64_t OB_ALL_VIRTUAL_SQL_WORKAREA_ACTIVE_TID = 12159; // "__all_virtual_sql_workarea_active"
const uint64_t OB_ALL_VIRTUAL_SQL_WORKAREA_HISTOGRAM_TID = 12160; // "__all_virtual_sql_workarea_histogram"
const uint64_t OB_ALL_VIRTUAL_SQL_WORKAREA_MEMORY_INFO_TID = 12161; // "__all_virtual_sql_workarea_memory_info"
const uint64_t OB_ALL_VIRTUAL_SECURITY_AUDIT_RECORD_TID = 12162; // "__all_virtual_security_audit_record"
const uint64_t OB_ALL_VIRTUAL_SYSAUTH_TID = 12163; // "__all_virtual_sysauth"
const uint64_t OB_ALL_VIRTUAL_SYSAUTH_HISTORY_TID = 12164; // "__all_virtual_sysauth_history"
const uint64_t OB_ALL_VIRTUAL_OBJAUTH_TID = 12165; // "__all_virtual_objauth"
const uint64_t OB_ALL_VIRTUAL_OBJAUTH_HISTORY_TID = 12166; // "__all_virtual_objauth_history"
const uint64_t OB_ALL_VIRTUAL_BACKUP_INFO_TID = 12167; // "__all_virtual_backup_info"
const uint64_t OB_ALL_VIRTUAL_ERROR_TID = 12175; // "__all_virtual_error"
const uint64_t OB_ALL_VIRTUAL_ID_SERVICE_TID = 12176; // "__all_virtual_id_service"
const uint64_t OB_ALL_VIRTUAL_OBJECT_TYPE_TID = 12182; // "__all_virtual_object_type"
const uint64_t OB_ALL_VIRTUAL_SQL_PLAN_MONITOR_TID = 12185; // "__all_virtual_sql_plan_monitor"
const uint64_t OB_ALL_VIRTUAL_SQL_MONITOR_STATNAME_TID = 12186; // "__all_virtual_sql_monitor_statname"
const uint64_t OB_ALL_VIRTUAL_OPEN_CURSOR_TID = 12187; // "__all_virtual_open_cursor"
const uint64_t OB_ALL_VIRTUAL_TIME_ZONE_TID = 12190; // "__all_virtual_time_zone"
const uint64_t OB_ALL_VIRTUAL_TIME_ZONE_NAME_TID = 12191; // "__all_virtual_time_zone_name"
const uint64_t OB_ALL_VIRTUAL_TIME_ZONE_TRANSITION_TID = 12192; // "__all_virtual_time_zone_transition"
const uint64_t OB_ALL_VIRTUAL_TIME_ZONE_TRANSITION_TYPE_TID = 12193; // "__all_virtual_time_zone_transition_type"
const uint64_t OB_ALL_VIRTUAL_CONSTRAINT_COLUMN_TID = 12194; // "__all_virtual_constraint_column"
const uint64_t OB_ALL_VIRTUAL_CONSTRAINT_COLUMN_HISTORY_TID = 12195; // "__all_virtual_constraint_column_history"
const uint64_t OB_ALL_VIRTUAL_FILES_TID = 12196; // "__all_virtual_files"
const uint64_t OB_ALL_VIRTUAL_DEPENDENCY_TID = 12198; // "__all_virtual_dependency"
const uint64_t OB_TENANT_VIRTUAL_OBJECT_DEFINITION_TID = 12199; // "__tenant_virtual_object_definition"
const uint64_t OB_ALL_VIRTUAL_GLOBAL_TRANSACTION_TID = 12206; // "__all_virtual_global_transaction"
const uint64_t OB_ALL_VIRTUAL_DDL_TASK_STATUS_TID = 12208; // "__all_virtual_ddl_task_status"
const uint64_t OB_ALL_VIRTUAL_DEADLOCK_EVENT_HISTORY_TID = 12209; // "__all_virtual_deadlock_event_history"
const uint64_t OB_ALL_VIRTUAL_COLUMN_USAGE_TID = 12210; // "__all_virtual_column_usage"
const uint64_t OB_ALL_VIRTUAL_TENANT_CTX_MEMORY_INFO_TID = 12211; // "__all_virtual_tenant_ctx_memory_info"
const uint64_t OB_ALL_VIRTUAL_JOB_TID = 12213; // "__all_virtual_job"
const uint64_t OB_ALL_VIRTUAL_JOB_LOG_TID = 12214; // "__all_virtual_job_log"
const uint64_t OB_ALL_VIRTUAL_TENANT_DIRECTORY_TID = 12215; // "__all_virtual_tenant_directory"
const uint64_t OB_ALL_VIRTUAL_TENANT_DIRECTORY_HISTORY_TID = 12216; // "__all_virtual_tenant_directory_history"
const uint64_t OB_ALL_VIRTUAL_TABLE_STAT_TID = 12217; // "__all_virtual_table_stat"
const uint64_t OB_ALL_VIRTUAL_COLUMN_STAT_TID = 12218; // "__all_virtual_column_stat"
const uint64_t OB_ALL_VIRTUAL_HISTOGRAM_STAT_TID = 12219; // "__all_virtual_histogram_stat"
const uint64_t OB_ALL_VIRTUAL_TENANT_MEMORY_INFO_TID = 12220; // "__all_virtual_tenant_memory_info"
const uint64_t OB_TENANT_VIRTUAL_SHOW_CREATE_TRIGGER_TID = 12222; // "__tenant_virtual_show_create_trigger"
const uint64_t OB_ALL_VIRTUAL_PX_TARGET_MONITOR_TID = 12223; // "__all_virtual_px_target_monitor"
const uint64_t OB_ALL_VIRTUAL_MONITOR_MODIFIED_TID = 12224; // "__all_virtual_monitor_modified"
const uint64_t OB_ALL_VIRTUAL_TABLE_STAT_HISTORY_TID = 12225; // "__all_virtual_table_stat_history"
const uint64_t OB_ALL_VIRTUAL_COLUMN_STAT_HISTORY_TID = 12226; // "__all_virtual_column_stat_history"
const uint64_t OB_ALL_VIRTUAL_HISTOGRAM_STAT_HISTORY_TID = 12227; // "__all_virtual_histogram_stat_history"
const uint64_t OB_ALL_VIRTUAL_OPTSTAT_GLOBAL_PREFS_TID = 12228; // "__all_virtual_optstat_global_prefs"
const uint64_t OB_ALL_VIRTUAL_OPTSTAT_USER_PREFS_TID = 12229; // "__all_virtual_optstat_user_prefs"
const uint64_t OB_ALL_VIRTUAL_DBLINK_INFO_TID = 12230; // "__all_virtual_dblink_info"
const uint64_t OB_ALL_VIRTUAL_LOG_ARCHIVE_PROGRESS_TID = 12231; // "__all_virtual_log_archive_progress"
const uint64_t OB_ALL_VIRTUAL_LOG_ARCHIVE_HISTORY_TID = 12232; // "__all_virtual_log_archive_history"
const uint64_t OB_ALL_VIRTUAL_LOG_ARCHIVE_PIECE_FILES_TID = 12233; // "__all_virtual_log_archive_piece_files"
const uint64_t OB_ALL_VIRTUAL_LS_LOG_ARCHIVE_PROGRESS_TID = 12234; // "__all_virtual_ls_log_archive_progress"
const uint64_t OB_ALL_VIRTUAL_BACKUP_STORAGE_INFO_TID = 12236; // "__all_virtual_backup_storage_info"
const uint64_t OB_ALL_VIRTUAL_LS_STATUS_TID = 12237; // "__all_virtual_ls_status"
const uint64_t OB_ALL_VIRTUAL_LS_TID = 12238; // "__all_virtual_ls"
const uint64_t OB_ALL_VIRTUAL_LS_META_TABLE_TID = 12239; // "__all_virtual_ls_meta_table"
const uint64_t OB_ALL_VIRTUAL_TABLET_META_TABLE_TID = 12240; // "__all_virtual_tablet_meta_table"
const uint64_t OB_ALL_VIRTUAL_TABLET_TO_LS_TID = 12241; // "__all_virtual_tablet_to_ls"
const uint64_t OB_ALL_VIRTUAL_LOAD_DATA_STAT_TID = 12242; // "__all_virtual_load_data_stat"
const uint64_t OB_ALL_VIRTUAL_DAM_LAST_ARCH_TS_TID = 12243; // "__all_virtual_dam_last_arch_ts"
const uint64_t OB_ALL_VIRTUAL_DAM_CLEANUP_JOBS_TID = 12244; // "__all_virtual_dam_cleanup_jobs"
const uint64_t OB_ALL_VIRTUAL_BACKUP_TASK_TID = 12245; // "__all_virtual_backup_task"
const uint64_t OB_ALL_VIRTUAL_BACKUP_TASK_HISTORY_TID = 12246; // "__all_virtual_backup_task_history"
const uint64_t OB_ALL_VIRTUAL_BACKUP_LS_TASK_TID = 12247; // "__all_virtual_backup_ls_task"
const uint64_t OB_ALL_VIRTUAL_BACKUP_LS_TASK_HISTORY_TID = 12248; // "__all_virtual_backup_ls_task_history"
const uint64_t OB_ALL_VIRTUAL_BACKUP_LS_TASK_INFO_TID = 12249; // "__all_virtual_backup_ls_task_info"
const uint64_t OB_ALL_VIRTUAL_BACKUP_SKIPPED_TABLET_TID = 12250; // "__all_virtual_backup_skipped_tablet"
const uint64_t OB_ALL_VIRTUAL_BACKUP_SKIPPED_TABLET_HISTORY_TID = 12251; // "__all_virtual_backup_skipped_tablet_history"
const uint64_t OB_ALL_VIRTUAL_BACKUP_SCHEDULE_TASK_TID = 12252; // "__all_virtual_backup_schedule_task"
const uint64_t OB_ALL_VIRTUAL_TABLET_TO_TABLE_HISTORY_TID = 12253; // "__all_virtual_tablet_to_table_history"
const uint64_t OB_ALL_VIRTUAL_LOG_STAT_TID = 12254; // "__all_virtual_log_stat"
const uint64_t OB_ALL_VIRTUAL_TENANT_INFO_TID = 12255; // "__all_virtual_tenant_info"
const uint64_t OB_ALL_VIRTUAL_LS_RECOVERY_STAT_TID = 12256; // "__all_virtual_ls_recovery_stat"
const uint64_t OB_ALL_VIRTUAL_BACKUP_LS_TASK_INFO_HISTORY_TID = 12257; // "__all_virtual_backup_ls_task_info_history"
const uint64_t OB_ALL_VIRTUAL_TABLET_REPLICA_CHECKSUM_TID = 12258; // "__all_virtual_tablet_replica_checksum"
const uint64_t OB_ALL_VIRTUAL_DDL_CHECKSUM_TID = 12259; // "__all_virtual_ddl_checksum"
const uint64_t OB_ALL_VIRTUAL_DDL_ERROR_MESSAGE_TID = 12260; // "__all_virtual_ddl_error_message"
const uint64_t OB_ALL_VIRTUAL_LS_REPLICA_TASK_TID = 12261; // "__all_virtual_ls_replica_task"
const uint64_t OB_ALL_VIRTUAL_PENDING_TRANSACTION_TID = 12262; // "__all_virtual_pending_transaction"
const uint64_t OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_TID = 12263; // "__all_virtual_tenant_scheduler_job"
const uint64_t OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_RUN_DETAIL_TID = 12264; // "__all_virtual_tenant_scheduler_job_run_detail"
const uint64_t OB_ALL_VIRTUAL_TENANT_SCHEDULER_PROGRAM_TID = 12265; // "__all_virtual_tenant_scheduler_program"
const uint64_t OB_ALL_VIRTUAL_TENANT_SCHEDULER_PROGRAM_ARGUMENT_TID = 12266; // "__all_virtual_tenant_scheduler_program_argument"
const uint64_t OB_ALL_VIRTUAL_TENANT_CONTEXT_TID = 12269; // "__all_virtual_tenant_context"
const uint64_t OB_ALL_VIRTUAL_TENANT_CONTEXT_HISTORY_TID = 12270; // "__all_virtual_tenant_context_history"
const uint64_t OB_ALL_VIRTUAL_GLOBAL_CONTEXT_VALUE_TID = 12271; // "__all_virtual_global_context_value"
const uint64_t OB_ALL_VIRTUAL_UNIT_TID = 12274; // "__all_virtual_unit"
const uint64_t OB_ALL_VIRTUAL_SERVER_TID = 12276; // "__all_virtual_server"
const uint64_t OB_ALL_VIRTUAL_LS_ELECTION_REFERENCE_INFO_TID = 12277; // "__all_virtual_ls_election_reference_info"
const uint64_t OB_ALL_VIRTUAL_DTL_INTERM_RESULT_MONITOR_TID = 12278; // "__all_virtual_dtl_interm_result_monitor"
const uint64_t OB_ALL_VIRTUAL_ARCHIVE_STAT_TID = 12279; // "__all_virtual_archive_stat"
const uint64_t OB_ALL_VIRTUAL_APPLY_STAT_TID = 12280; // "__all_virtual_apply_stat"
const uint64_t OB_ALL_VIRTUAL_REPLAY_STAT_TID = 12281; // "__all_virtual_replay_stat"
const uint64_t OB_ALL_VIRTUAL_PROXY_ROUTINE_TID = 12282; // "__all_virtual_proxy_routine"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_TASK_TID = 12283; // "__all_virtual_backup_delete_task"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_TASK_HISTORY_TID = 12284; // "__all_virtual_backup_delete_task_history"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_LS_TASK_TID = 12285; // "__all_virtual_backup_delete_ls_task"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_LS_TASK_HISTORY_TID = 12286; // "__all_virtual_backup_delete_ls_task_history"
const uint64_t OB_ALL_VIRTUAL_LS_INFO_TID = 12287; // "__all_virtual_ls_info"
const uint64_t OB_ALL_VIRTUAL_TABLET_INFO_TID = 12288; // "__all_virtual_tablet_info"
const uint64_t OB_ALL_VIRTUAL_OBJ_LOCK_TID = 12289; // "__all_virtual_obj_lock"
const uint64_t OB_ALL_VIRTUAL_ZONE_MERGE_INFO_TID = 12290; // "__all_virtual_zone_merge_info"
const uint64_t OB_ALL_VIRTUAL_MERGE_INFO_TID = 12291; // "__all_virtual_merge_info"
const uint64_t OB_ALL_VIRTUAL_TX_DATA_TABLE_TID = 12292; // "__all_virtual_tx_data_table"
const uint64_t OB_ALL_VIRTUAL_TRANSACTION_FREEZE_CHECKPOINT_TID = 12293; // "__all_virtual_transaction_freeze_checkpoint"
const uint64_t OB_ALL_VIRTUAL_TRANSACTION_CHECKPOINT_TID = 12294; // "__all_virtual_transaction_checkpoint"
const uint64_t OB_ALL_VIRTUAL_CHECKPOINT_TID = 12295; // "__all_virtual_checkpoint"
const uint64_t OB_ALL_VIRTUAL_BACKUP_SET_FILES_TID = 12296; // "__all_virtual_backup_set_files"
const uint64_t OB_ALL_VIRTUAL_BACKUP_JOB_TID = 12297; // "__all_virtual_backup_job"
const uint64_t OB_ALL_VIRTUAL_BACKUP_JOB_HISTORY_TID = 12298; // "__all_virtual_backup_job_history"
const uint64_t OB_ALL_VIRTUAL_PLAN_BASELINE_TID = 12299; // "__all_virtual_plan_baseline"
const uint64_t OB_ALL_VIRTUAL_PLAN_BASELINE_ITEM_TID = 12300; // "__all_virtual_plan_baseline_item"
const uint64_t OB_ALL_VIRTUAL_SPM_CONFIG_TID = 12301; // "__all_virtual_spm_config"
const uint64_t OB_ALL_VIRTUAL_ASH_TID = 12302; // "__all_virtual_ash"
const uint64_t OB_ALL_VIRTUAL_DML_STATS_TID = 12303; // "__all_virtual_dml_stats"
const uint64_t OB_ALL_VIRTUAL_LOG_ARCHIVE_DEST_PARAMETER_TID = 12304; // "__all_virtual_log_archive_dest_parameter"
const uint64_t OB_ALL_VIRTUAL_BACKUP_PARAMETER_TID = 12305; // "__all_virtual_backup_parameter"
const uint64_t OB_ALL_VIRTUAL_RESTORE_JOB_TID = 12306; // "__all_virtual_restore_job"
const uint64_t OB_ALL_VIRTUAL_RESTORE_JOB_HISTORY_TID = 12307; // "__all_virtual_restore_job_history"
const uint64_t OB_ALL_VIRTUAL_RESTORE_PROGRESS_TID = 12308; // "__all_virtual_restore_progress"
const uint64_t OB_ALL_VIRTUAL_LS_RESTORE_PROGRESS_TID = 12309; // "__all_virtual_ls_restore_progress"
const uint64_t OB_ALL_VIRTUAL_LS_RESTORE_HISTORY_TID = 12310; // "__all_virtual_ls_restore_history"
const uint64_t OB_ALL_VIRTUAL_BACKUP_STORAGE_INFO_HISTORY_TID = 12311; // "__all_virtual_backup_storage_info_history"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_JOB_TID = 12312; // "__all_virtual_backup_delete_job"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_JOB_HISTORY_TID = 12313; // "__all_virtual_backup_delete_job_history"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_POLICY_TID = 12314; // "__all_virtual_backup_delete_policy"
const uint64_t OB_ALL_VIRTUAL_TABLET_DDL_KV_INFO_TID = 12315; // "__all_virtual_tablet_ddl_kv_info"
const uint64_t OB_ALL_VIRTUAL_PRIVILEGE_TID = 12316; // "__all_virtual_privilege"
const uint64_t OB_ALL_VIRTUAL_TABLET_POINTER_STATUS_TID = 12317; // "__all_virtual_tablet_pointer_status"
const uint64_t OB_ALL_VIRTUAL_STORAGE_META_MEMORY_STATUS_TID = 12318; // "__all_virtual_storage_meta_memory_status"
const uint64_t OB_ALL_VIRTUAL_KVCACHE_STORE_MEMBLOCK_TID = 12319; // "__all_virtual_kvcache_store_memblock"
const uint64_t OB_ALL_VIRTUAL_MOCK_FK_PARENT_TABLE_TID = 12320; // "__all_virtual_mock_fk_parent_table"
const uint64_t OB_ALL_VIRTUAL_MOCK_FK_PARENT_TABLE_HISTORY_TID = 12321; // "__all_virtual_mock_fk_parent_table_history"
const uint64_t OB_ALL_VIRTUAL_MOCK_FK_PARENT_TABLE_COLUMN_TID = 12322; // "__all_virtual_mock_fk_parent_table_column"
const uint64_t OB_ALL_VIRTUAL_MOCK_FK_PARENT_TABLE_COLUMN_HISTORY_TID = 12323; // "__all_virtual_mock_fk_parent_table_column_history"
const uint64_t OB_ALL_VIRTUAL_LOG_RESTORE_SOURCE_TID = 12324; // "__all_virtual_log_restore_source"
const uint64_t OB_ALL_VIRTUAL_QUERY_RESPONSE_TIME_TID = 12325; // "__all_virtual_query_response_time"
const uint64_t OB_ALL_VIRTUAL_KV_TTL_TASK_TID = 12326; // "__all_virtual_kv_ttl_task"
const uint64_t OB_ALL_VIRTUAL_KV_TTL_TASK_HISTORY_TID = 12327; // "__all_virtual_kv_ttl_task_history"
const uint64_t OB_ALL_VIRTUAL_COLUMN_CHECKSUM_ERROR_INFO_TID = 12330; // "__all_virtual_column_checksum_error_info"
const uint64_t OB_ALL_VIRTUAL_TABLET_COMPACTION_INFO_TID = 12334; // "__all_virtual_tablet_compaction_info"
const uint64_t OB_ALL_VIRTUAL_LS_REPLICA_TASK_PLAN_TID = 12335; // "__all_virtual_ls_replica_task_plan"
const uint64_t OB_ALL_VIRTUAL_SCHEMA_MEMORY_TID = 12336; // "__all_virtual_schema_memory"
const uint64_t OB_ALL_VIRTUAL_SCHEMA_SLOT_TID = 12337; // "__all_virtual_schema_slot"
const uint64_t OB_ALL_VIRTUAL_MINOR_FREEZE_INFO_TID = 12338; // "__all_virtual_minor_freeze_info"
const uint64_t OB_ALL_VIRTUAL_SHOW_TRACE_TID = 12339; // "__all_virtual_show_trace"
const uint64_t OB_ALL_VIRTUAL_HA_DIAGNOSE_TID = 12340; // "__all_virtual_ha_diagnose"
const uint64_t OB_ALL_VIRTUAL_DATA_DICTIONARY_IN_LOG_TID = 12341; // "__all_virtual_data_dictionary_in_log"
const uint64_t OB_ALL_VIRTUAL_TRANSFER_TASK_TID = 12342; // "__all_virtual_transfer_task"
const uint64_t OB_ALL_VIRTUAL_TRANSFER_TASK_HISTORY_TID = 12343; // "__all_virtual_transfer_task_history"
const uint64_t OB_ALL_VIRTUAL_BALANCE_JOB_TID = 12344; // "__all_virtual_balance_job"
const uint64_t OB_ALL_VIRTUAL_BALANCE_JOB_HISTORY_TID = 12345; // "__all_virtual_balance_job_history"
const uint64_t OB_ALL_VIRTUAL_BALANCE_TASK_TID = 12346; // "__all_virtual_balance_task"
const uint64_t OB_ALL_VIRTUAL_BALANCE_TASK_HISTORY_TID = 12347; // "__all_virtual_balance_task_history"
const uint64_t OB_ALL_VIRTUAL_RLS_POLICY_TID = 12348; // "__all_virtual_rls_policy"
const uint64_t OB_ALL_VIRTUAL_RLS_POLICY_HISTORY_TID = 12349; // "__all_virtual_rls_policy_history"
const uint64_t OB_ALL_VIRTUAL_RLS_SECURITY_COLUMN_TID = 12350; // "__all_virtual_rls_security_column"
const uint64_t OB_ALL_VIRTUAL_RLS_SECURITY_COLUMN_HISTORY_TID = 12351; // "__all_virtual_rls_security_column_history"
const uint64_t OB_ALL_VIRTUAL_RLS_GROUP_TID = 12352; // "__all_virtual_rls_group"
const uint64_t OB_ALL_VIRTUAL_RLS_GROUP_HISTORY_TID = 12353; // "__all_virtual_rls_group_history"
const uint64_t OB_ALL_VIRTUAL_RLS_CONTEXT_TID = 12354; // "__all_virtual_rls_context"
const uint64_t OB_ALL_VIRTUAL_RLS_CONTEXT_HISTORY_TID = 12355; // "__all_virtual_rls_context_history"
const uint64_t OB_ALL_VIRTUAL_RLS_ATTRIBUTE_TID = 12356; // "__all_virtual_rls_attribute"
const uint64_t OB_ALL_VIRTUAL_RLS_ATTRIBUTE_HISTORY_TID = 12357; // "__all_virtual_rls_attribute_history"
const uint64_t OB_ALL_VIRTUAL_TENANT_MYSQL_SYS_AGENT_TID = 12358; // "__all_virtual_tenant_mysql_sys_agent"
const uint64_t OB_ALL_VIRTUAL_SQL_PLAN_TID = 12359; // "__all_virtual_sql_plan"
const uint64_t OB_ALL_VIRTUAL_CORE_TABLE_TID = 12362; // "__all_virtual_core_table"
const uint64_t OB_ALL_VIRTUAL_MALLOC_SAMPLE_INFO_TID = 12363; // "__all_virtual_malloc_sample_info"
const uint64_t OB_ALL_VIRTUAL_LS_ARB_REPLICA_TASK_TID = 12364; // "__all_virtual_ls_arb_replica_task"
const uint64_t OB_ALL_VIRTUAL_LS_ARB_REPLICA_TASK_HISTORY_TID = 12365; // "__all_virtual_ls_arb_replica_task_history"
const uint64_t OB_ALL_VIRTUAL_ARCHIVE_DEST_STATUS_TID = 12366; // "__all_virtual_archive_dest_status"
const uint64_t OB_ALL_VIRTUAL_IO_SCHEDULER_TID = 12369; // "__all_virtual_io_scheduler"
const uint64_t OB_ALL_VIRTUAL_EXTERNAL_TABLE_FILE_TID = 12371; // "__all_virtual_external_table_file"
const uint64_t OB_ALL_VIRTUAL_MDS_NODE_STAT_TID = 12373; // "__all_virtual_mds_node_stat"
const uint64_t OB_ALL_VIRTUAL_MDS_EVENT_HISTORY_TID = 12374; // "__all_virtual_mds_event_history"
const uint64_t OB_ALL_VIRTUAL_DUP_LS_LEASE_MGR_TID = 12376; // "__all_virtual_dup_ls_lease_mgr"
const uint64_t OB_ALL_VIRTUAL_DUP_LS_TABLET_SET_TID = 12378; // "__all_virtual_dup_ls_tablet_set"
const uint64_t OB_ALL_VIRTUAL_DUP_LS_TABLETS_TID = 12379; // "__all_virtual_dup_ls_tablets"
const uint64_t OB_ALL_VIRTUAL_TX_DATA_TID = 12380; // "__all_virtual_tx_data"
const uint64_t OB_ALL_VIRTUAL_TASK_OPT_STAT_GATHER_HISTORY_TID = 12381; // "__all_virtual_task_opt_stat_gather_history"
const uint64_t OB_ALL_VIRTUAL_TABLE_OPT_STAT_GATHER_HISTORY_TID = 12382; // "__all_virtual_table_opt_stat_gather_history"
const uint64_t OB_ALL_VIRTUAL_OPT_STAT_GATHER_MONITOR_TID = 12383; // "__all_virtual_opt_stat_gather_monitor"
const uint64_t OB_ALL_VIRTUAL_THREAD_TID = 12384; // "__all_virtual_thread"
const uint64_t OB_ALL_VIRTUAL_ARBITRATION_MEMBER_INFO_TID = 12385; // "__all_virtual_arbitration_member_info"
const uint64_t OB_ALL_VIRTUAL_SERVER_STORAGE_TID = 12386; // "__all_virtual_server_storage"
const uint64_t OB_ALL_VIRTUAL_ARBITRATION_SERVICE_STATUS_TID = 12387; // "__all_virtual_arbitration_service_status"
const uint64_t OB_ALL_VIRTUAL_WR_ACTIVE_SESSION_HISTORY_TID = 12388; // "__all_virtual_wr_active_session_history"
const uint64_t OB_ALL_VIRTUAL_WR_SNAPSHOT_TID = 12389; // "__all_virtual_wr_snapshot"
const uint64_t OB_ALL_VIRTUAL_WR_STATNAME_TID = 12390; // "__all_virtual_wr_statname"
const uint64_t OB_ALL_VIRTUAL_WR_SYSSTAT_TID = 12391; // "__all_virtual_wr_sysstat"
const uint64_t OB_ALL_VIRTUAL_KV_CONNECTION_TID = 12392; // "__all_virtual_kv_connection"
const uint64_t OB_ALL_VIRTUAL_VIRTUAL_LONG_OPS_STATUS_MYSQL_SYS_AGENT_TID = 12393; // "__all_virtual_virtual_long_ops_status_mysql_sys_agent"
const uint64_t OB_ALL_VIRTUAL_LS_TRANSFER_MEMBER_LIST_LOCK_INFO_TID = 12394; // "__all_virtual_ls_transfer_member_list_lock_info"
const uint64_t OB_ALL_VIRTUAL_TIMESTAMP_SERVICE_TID = 12395; // "__all_virtual_timestamp_service"
const uint64_t OB_ALL_VIRTUAL_RESOURCE_POOL_MYSQL_SYS_AGENT_TID = 12396; // "__all_virtual_resource_pool_mysql_sys_agent"
const uint64_t OB_ALL_VIRTUAL_PX_P2P_DATAHUB_TID = 12397; // "__all_virtual_px_p2p_datahub"
const uint64_t OB_ALL_VIRTUAL_COLUMN_GROUP_TID = 12398; // "__all_virtual_column_group"
const uint64_t OB_ALL_VIRTUAL_STORAGE_LEAK_INFO_TID = 12399; // "__all_virtual_storage_leak_info"
const uint64_t OB_ALL_VIRTUAL_LS_LOG_RESTORE_STATUS_TID = 12400; // "__all_virtual_ls_log_restore_status"
const uint64_t OB_ALL_VIRTUAL_TENANT_PARAMETER_TID = 12401; // "__all_virtual_tenant_parameter"
const uint64_t OB_ALL_VIRTUAL_TENANT_SNAPSHOT_TID = 12402; // "__all_virtual_tenant_snapshot"
const uint64_t OB_ALL_VIRTUAL_TENANT_SNAPSHOT_LS_TID = 12403; // "__all_virtual_tenant_snapshot_ls"
const uint64_t OB_ALL_VIRTUAL_TENANT_SNAPSHOT_LS_REPLICA_TID = 12404; // "__all_virtual_tenant_snapshot_ls_replica"
const uint64_t OB_ALL_VIRTUAL_TABLET_BUFFER_INFO_TID = 12405; // "__all_virtual_tablet_buffer_info"
const uint64_t OB_ALL_VIRTUAL_MLOG_TID = 12406; // "__all_virtual_mlog"
const uint64_t OB_ALL_VIRTUAL_MVIEW_TID = 12407; // "__all_virtual_mview"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_TID = 12408; // "__all_virtual_mview_refresh_stats_sys_defaults"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_PARAMS_TID = 12409; // "__all_virtual_mview_refresh_stats_params"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_RUN_STATS_TID = 12410; // "__all_virtual_mview_refresh_run_stats"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_TID = 12411; // "__all_virtual_mview_refresh_stats"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_CHANGE_STATS_TID = 12412; // "__all_virtual_mview_refresh_change_stats"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_STMT_STATS_TID = 12413; // "__all_virtual_mview_refresh_stmt_stats"
const uint64_t OB_ALL_VIRTUAL_WR_CONTROL_TID = 12414; // "__all_virtual_wr_control"
const uint64_t OB_ALL_VIRTUAL_TENANT_EVENT_HISTORY_TID = 12415; // "__all_virtual_tenant_event_history"
const uint64_t OB_ALL_VIRTUAL_BALANCE_TASK_HELPER_TID = 12416; // "__all_virtual_balance_task_helper"
const uint64_t OB_ALL_VIRTUAL_BALANCE_GROUP_LS_STAT_TID = 12417; // "__all_virtual_balance_group_ls_stat"
const uint64_t OB_ALL_VIRTUAL_CGROUP_CONFIG_TID = 12419; // "__all_virtual_cgroup_config"
const uint64_t OB_ALL_VIRTUAL_FLT_CONFIG_TID = 12420; // "__all_virtual_flt_config"
const uint64_t OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_CLASS_TID = 12421; // "__all_virtual_tenant_scheduler_job_class"
const uint64_t OB_ALL_VIRTUAL_RECOVER_TABLE_JOB_TID = 12422; // "__all_virtual_recover_table_job"
const uint64_t OB_ALL_VIRTUAL_RECOVER_TABLE_JOB_HISTORY_TID = 12423; // "__all_virtual_recover_table_job_history"
const uint64_t OB_ALL_VIRTUAL_IMPORT_TABLE_JOB_TID = 12424; // "__all_virtual_import_table_job"
const uint64_t OB_ALL_VIRTUAL_IMPORT_TABLE_JOB_HISTORY_TID = 12425; // "__all_virtual_import_table_job_history"
const uint64_t OB_ALL_VIRTUAL_IMPORT_TABLE_TASK_TID = 12426; // "__all_virtual_import_table_task"
const uint64_t OB_ALL_VIRTUAL_IMPORT_TABLE_TASK_HISTORY_TID = 12427; // "__all_virtual_import_table_task_history"
const uint64_t OB_ALL_VIRTUAL_DATA_ACTIVITY_METRICS_TID = 12429; // "__all_virtual_data_activity_metrics"
const uint64_t OB_ALL_VIRTUAL_COLUMN_GROUP_MAPPING_TID = 12430; // "__all_virtual_column_group_mapping"
const uint64_t OB_ALL_VIRTUAL_COLUMN_GROUP_HISTORY_TID = 12431; // "__all_virtual_column_group_history"
const uint64_t OB_ALL_VIRTUAL_COLUMN_GROUP_MAPPING_HISTORY_TID = 12432; // "__all_virtual_column_group_mapping_history"
const uint64_t OB_ALL_VIRTUAL_STORAGE_HA_ERROR_DIAGNOSE_TID = 12433; // "__all_virtual_storage_ha_error_diagnose"
const uint64_t OB_ALL_VIRTUAL_STORAGE_HA_PERF_DIAGNOSE_TID = 12434; // "__all_virtual_storage_ha_perf_diagnose"
const uint64_t OB_ALL_VIRTUAL_CLONE_JOB_TID = 12435; // "__all_virtual_clone_job"
const uint64_t OB_ALL_VIRTUAL_CLONE_JOB_HISTORY_TID = 12436; // "__all_virtual_clone_job_history"
const uint64_t OB_ALL_VIRTUAL_CHECKPOINT_DIAGNOSE_MEMTABLE_INFO_TID = 12437; // "__all_virtual_checkpoint_diagnose_memtable_info"
const uint64_t OB_ALL_VIRTUAL_CHECKPOINT_DIAGNOSE_CHECKPOINT_UNIT_INFO_TID = 12438; // "__all_virtual_checkpoint_diagnose_checkpoint_unit_info"
const uint64_t OB_ALL_VIRTUAL_CHECKPOINT_DIAGNOSE_INFO_TID = 12439; // "__all_virtual_checkpoint_diagnose_info"
const uint64_t OB_ALL_VIRTUAL_WR_SYSTEM_EVENT_TID = 12440; // "__all_virtual_wr_system_event"
const uint64_t OB_ALL_VIRTUAL_WR_EVENT_NAME_TID = 12441; // "__all_virtual_wr_event_name"
const uint64_t OB_ALL_VIRTUAL_TENANT_SCHEDULER_RUNNING_JOB_TID = 12442; // "__all_virtual_tenant_scheduler_running_job"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_PRIVILEGE_TID = 12443; // "__all_virtual_routine_privilege"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_PRIVILEGE_HISTORY_TID = 12444; // "__all_virtual_routine_privilege_history"
const uint64_t OB_ALL_VIRTUAL_SQLSTAT_TID = 12445; // "__all_virtual_sqlstat"
const uint64_t OB_ALL_VIRTUAL_WR_SQLSTAT_TID = 12446; // "__all_virtual_wr_sqlstat"
const uint64_t OB_ALL_VIRTUAL_AUX_STAT_TID = 12447; // "__all_virtual_aux_stat"
const uint64_t OB_ALL_VIRTUAL_DETECT_LOCK_INFO_TID = 12448; // "__all_virtual_detect_lock_info"
const uint64_t OB_ALL_VIRTUAL_CLIENT_TO_SERVER_SESSION_INFO_TID = 12449; // "__all_virtual_client_to_server_session_info"
const uint64_t OB_ALL_VIRTUAL_SYS_VARIABLE_DEFAULT_VALUE_TID = 12450; // "__all_virtual_sys_variable_default_value"
const uint64_t OB_ALL_VIRTUAL_TRANSFER_PARTITION_TASK_TID = 12451; // "__all_virtual_transfer_partition_task"
const uint64_t OB_ALL_VIRTUAL_TRANSFER_PARTITION_TASK_HISTORY_TID = 12452; // "__all_virtual_transfer_partition_task_history"
const uint64_t OB_ALL_VIRTUAL_TENANT_SNAPSHOT_JOB_TID = 12453; // "__all_virtual_tenant_snapshot_job"
const uint64_t OB_ALL_VIRTUAL_WR_SQLTEXT_TID = 12454; // "__all_virtual_wr_sqltext"
const uint64_t OB_ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_TID = 12456; // "__all_virtual_dbms_lock_allocated"
const uint64_t OB_ALL_VIRTUAL_SHARED_STORAGE_COMPACTION_INFO_TID = 12457; // "__all_virtual_shared_storage_compaction_info"
const uint64_t OB_ALL_VIRTUAL_LS_SNAPSHOT_TID = 12458; // "__all_virtual_ls_snapshot"
const uint64_t OB_ALL_VIRTUAL_INDEX_USAGE_INFO_TID = 12459; // "__all_virtual_index_usage_info"
const uint64_t OB_ALL_VIRTUAL_AUDIT_LOG_FILTER_TID = 12460; // "__all_virtual_audit_log_filter"
const uint64_t OB_ALL_VIRTUAL_AUDIT_LOG_USER_TID = 12461; // "__all_virtual_audit_log_user"
const uint64_t OB_ALL_VIRTUAL_COLUMN_PRIVILEGE_TID = 12462; // "__all_virtual_column_privilege"
const uint64_t OB_ALL_VIRTUAL_COLUMN_PRIVILEGE_HISTORY_TID = 12463; // "__all_virtual_column_privilege_history"
const uint64_t OB_ALL_VIRTUAL_TENANT_SNAPSHOT_LS_REPLICA_HISTORY_TID = 12464; // "__all_virtual_tenant_snapshot_ls_replica_history"
const uint64_t OB_ALL_VIRTUAL_SHARED_STORAGE_QUOTA_TID = 12465; // "__all_virtual_shared_storage_quota"
const uint64_t OB_ENABLED_ROLES_TID = 12466; // "ENABLED_ROLES"
const uint64_t OB_ALL_VIRTUAL_LS_REPLICA_TASK_HISTORY_TID = 12467; // "__all_virtual_ls_replica_task_history"
const uint64_t OB_ALL_VIRTUAL_SESSION_PS_INFO_TID = 12468; // "__all_virtual_session_ps_info"
const uint64_t OB_ALL_VIRTUAL_TRACEPOINT_INFO_TID = 12469; // "__all_virtual_tracepoint_info"
const uint64_t OB_ALL_VIRTUAL_TABLET_CHECKSUM_ERROR_INFO_TID = 12472; // "__all_virtual_tablet_checksum_error_info"
const uint64_t OB_ALL_VIRTUAL_COMPATIBILITY_CONTROL_TID = 12473; // "__all_virtual_compatibility_control"
const uint64_t OB_ALL_VIRTUAL_USER_PROXY_INFO_TID = 12474; // "__all_virtual_user_proxy_info"
const uint64_t OB_ALL_VIRTUAL_USER_PROXY_INFO_HISTORY_TID = 12475; // "__all_virtual_user_proxy_info_history"
const uint64_t OB_ALL_VIRTUAL_USER_PROXY_ROLE_INFO_TID = 12476; // "__all_virtual_user_proxy_role_info"
const uint64_t OB_ALL_VIRTUAL_USER_PROXY_ROLE_INFO_HISTORY_TID = 12477; // "__all_virtual_user_proxy_role_info_history"
const uint64_t OB_ALL_VIRTUAL_TABLET_REORGANIZE_HISTORY_TID = 12478; // "__all_virtual_tablet_reorganize_history"
const uint64_t OB_ALL_VIRTUAL_RES_MGR_DIRECTIVE_TID = 12479; // "__all_virtual_res_mgr_directive"
const uint64_t OB_ALL_VIRTUAL_SERVICE_TID = 12480; // "__all_virtual_service"
const uint64_t OB_ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_TID = 12481; // "__all_virtual_tenant_resource_limit"
const uint64_t OB_ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_DETAIL_TID = 12482; // "__all_virtual_tenant_resource_limit_detail"
const uint64_t OB_ALL_VIRTUAL_GROUP_IO_STAT_TID = 12483; // "__all_virtual_group_io_stat"
const uint64_t OB_ALL_VIRTUAL_STORAGE_IO_USAGE_TID = 12485; // "__all_virtual_storage_io_usage"
const uint64_t OB_ALL_VIRTUAL_ZONE_STORAGE_MYSQL_SYS_AGENT_TID = 12486; // "__all_virtual_zone_storage_mysql_sys_agent"
const uint64_t OB_ALL_VIRTUAL_NIC_INFO_TID = 12487; // "__all_virtual_nic_info"
const uint64_t OB_ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_TID = 12488; // "__all_virtual_scheduler_job_run_detail_v2"
const uint64_t OB_ALL_VIRTUAL_SPATIAL_REFERENCE_SYSTEMS_TID = 12490; // "__all_virtual_spatial_reference_systems"
const uint64_t OB_ALL_VIRTUAL_LOG_TRANSPORT_DEST_STAT_TID = 12491; // "__all_virtual_log_transport_dest_stat"
const uint64_t OB_ALL_VIRTUAL_SS_LOCAL_CACHE_INFO_TID = 12492; // "__all_virtual_ss_local_cache_info"
const uint64_t OB_ALL_VIRTUAL_KV_GROUP_COMMIT_STATUS_TID = 12493; // "__all_virtual_kv_group_commit_status"
const uint64_t OB_ALL_VIRTUAL_SPM_EVO_RESULT_TID = 12495; // "__all_virtual_spm_evo_result"
const uint64_t OB_ALL_VIRTUAL_VECTOR_INDEX_INFO_TID = 12496; // "__all_virtual_vector_index_info"
const uint64_t OB_ALL_VIRTUAL_PKG_TYPE_TID = 12497; // "__all_virtual_pkg_type"
const uint64_t OB_ALL_VIRTUAL_PKG_TYPE_ATTR_TID = 12498; // "__all_virtual_pkg_type_attr"
const uint64_t OB_ALL_VIRTUAL_PKG_COLL_TYPE_TID = 12499; // "__all_virtual_pkg_coll_type"
const uint64_t OB_ALL_VIRTUAL_KV_CLIENT_INFO_TID = 12500; // "__all_virtual_kv_client_info"
const uint64_t OB_ALL_VIRTUAL_WR_SQL_PLAN_TID = 12501; // "__all_virtual_wr_sql_plan"
const uint64_t OB_ALL_VIRTUAL_KV_REDIS_TABLE_TID = 12503; // "__all_virtual_kv_redis_table"
const uint64_t OB_ALL_VIRTUAL_FUNCTION_IO_STAT_TID = 12504; // "__all_virtual_function_io_stat"
const uint64_t OB_ALL_VIRTUAL_TEMP_FILE_TID = 12505; // "__all_virtual_temp_file"
const uint64_t OB_ALL_VIRTUAL_NCOMP_DLL_V2_TID = 12506; // "__all_virtual_ncomp_dll_v2"
const uint64_t OB_ALL_VIRTUAL_CS_REPLICA_TABLET_STATS_TID = 12513; // "__all_virtual_cs_replica_tablet_stats"
const uint64_t OB_ALL_VIRTUAL_DDL_DIAGNOSE_INFO_TID = 12514; // "__all_virtual_ddl_diagnose_info"
const uint64_t OB_ALL_VIRTUAL_PLUGIN_INFO_TID = 12515; // "__all_virtual_plugin_info"
const uint64_t OB_ALL_VIRTUAL_SQL_AUDIT_ORA_TID = 15009; // "ALL_VIRTUAL_SQL_AUDIT_ORA"
const uint64_t OB_ALL_VIRTUAL_PLAN_STAT_ORA_TID = 15010; // "ALL_VIRTUAL_PLAN_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_PLAN_CACHE_PLAN_EXPLAIN_ORA_TID = 15012; // "ALL_VIRTUAL_PLAN_CACHE_PLAN_EXPLAIN_ORA"
const uint64_t OB_TENANT_VIRTUAL_OUTLINE_AGENT_TID = 15023; // "TENANT_VIRTUAL_OUTLINE_AGENT"
const uint64_t OB_ALL_VIRTUAL_PRIVILEGE_ORA_TID = 15026; // "ALL_VIRTUAL_PRIVILEGE_ORA"
const uint64_t OB_ALL_VIRTUAL_SYS_PARAMETER_STAT_AGENT_TID = 15027; // "ALL_VIRTUAL_SYS_PARAMETER_STAT_AGENT"
const uint64_t OB_TENANT_VIRTUAL_TABLE_INDEX_AGENT_TID = 15028; // "TENANT_VIRTUAL_TABLE_INDEX_AGENT"
const uint64_t OB_TENANT_VIRTUAL_CHARSET_AGENT_TID = 15029; // "TENANT_VIRTUAL_CHARSET_AGENT"
const uint64_t OB_TENANT_VIRTUAL_ALL_TABLE_AGENT_TID = 15030; // "TENANT_VIRTUAL_ALL_TABLE_AGENT"
const uint64_t OB_TENANT_VIRTUAL_COLLATION_ORA_TID = 15031; // "TENANT_VIRTUAL_COLLATION_ORA"
const uint64_t OB_ALL_VIRTUAL_SERVER_AGENT_TID = 15033; // "ALL_VIRTUAL_SERVER_AGENT"
const uint64_t OB_ALL_VIRTUAL_PLAN_CACHE_STAT_ORA_TID = 15034; // "ALL_VIRTUAL_PLAN_CACHE_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_PROCESSLIST_ORA_TID = 15035; // "ALL_VIRTUAL_PROCESSLIST_ORA"
const uint64_t OB_ALL_VIRTUAL_SESSION_WAIT_ORA_TID = 15036; // "ALL_VIRTUAL_SESSION_WAIT_ORA"
const uint64_t OB_ALL_VIRTUAL_SESSION_WAIT_HISTORY_ORA_TID = 15037; // "ALL_VIRTUAL_SESSION_WAIT_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_MEMORY_INFO_ORA_TID = 15038; // "ALL_VIRTUAL_MEMORY_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_MEMSTORE_INFO_ORA_TID = 15039; // "ALL_VIRTUAL_TENANT_MEMSTORE_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_MEMSTORE_INFO_ORA_TID = 15040; // "ALL_VIRTUAL_MEMSTORE_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_SESSTAT_ORA_TID = 15042; // "ALL_VIRTUAL_SESSTAT_ORA"
const uint64_t OB_ALL_VIRTUAL_SYSSTAT_ORA_TID = 15043; // "ALL_VIRTUAL_SYSSTAT_ORA"
const uint64_t OB_ALL_VIRTUAL_SYSTEM_EVENT_ORA_TID = 15044; // "ALL_VIRTUAL_SYSTEM_EVENT_ORA"
const uint64_t OB_TENANT_VIRTUAL_SESSION_VARIABLE_ORA_TID = 15046; // "TENANT_VIRTUAL_SESSION_VARIABLE_ORA"
const uint64_t OB_TENANT_VIRTUAL_GLOBAL_VARIABLE_ORA_TID = 15047; // "TENANT_VIRTUAL_GLOBAL_VARIABLE_ORA"
const uint64_t OB_TENANT_VIRTUAL_SHOW_CREATE_TABLE_ORA_TID = 15048; // "TENANT_VIRTUAL_SHOW_CREATE_TABLE_ORA"
const uint64_t OB_TENANT_VIRTUAL_SHOW_CREATE_PROCEDURE_ORA_TID = 15049; // "TENANT_VIRTUAL_SHOW_CREATE_PROCEDURE_ORA"
const uint64_t OB_TENANT_VIRTUAL_SHOW_CREATE_TABLEGROUP_ORA_TID = 15050; // "TENANT_VIRTUAL_SHOW_CREATE_TABLEGROUP_ORA"
const uint64_t OB_TENANT_VIRTUAL_PRIVILEGE_GRANT_ORA_TID = 15051; // "TENANT_VIRTUAL_PRIVILEGE_GRANT_ORA"
const uint64_t OB_TENANT_VIRTUAL_TABLE_COLUMN_ORA_TID = 15052; // "TENANT_VIRTUAL_TABLE_COLUMN_ORA"
const uint64_t OB_ALL_VIRTUAL_TRACE_SPAN_INFO_ORA_TID = 15053; // "ALL_VIRTUAL_TRACE_SPAN_INFO_ORA"
const uint64_t OB_TENANT_VIRTUAL_CONCURRENT_LIMIT_SQL_AGENT_TID = 15054; // "TENANT_VIRTUAL_CONCURRENT_LIMIT_SQL_AGENT"
const uint64_t OB_ALL_VIRTUAL_DATA_TYPE_ORA_TID = 15060; // "ALL_VIRTUAL_DATA_TYPE_ORA"
const uint64_t OB_ALL_VIRTUAL_AUDIT_OPERATION_ORA_TID = 15077; // "ALL_VIRTUAL_AUDIT_OPERATION_ORA"
const uint64_t OB_ALL_VIRTUAL_AUDIT_ACTION_ORA_TID = 15078; // "ALL_VIRTUAL_AUDIT_ACTION_ORA"
const uint64_t OB_ALL_VIRTUAL_PX_WORKER_STAT_ORA_TID = 15080; // "ALL_VIRTUAL_PX_WORKER_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_PS_STAT_ORA_TID = 15081; // "ALL_VIRTUAL_PS_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_PS_ITEM_INFO_ORA_TID = 15082; // "ALL_VIRTUAL_PS_ITEM_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_PARAMETER_STAT_ORA_TID = 15083; // "ALL_VIRTUAL_TENANT_PARAMETER_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_SQL_WORKAREA_HISTORY_STAT_ORA_TID = 15084; // "ALL_VIRTUAL_SQL_WORKAREA_HISTORY_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_SQL_WORKAREA_ACTIVE_ORA_TID = 15085; // "ALL_VIRTUAL_SQL_WORKAREA_ACTIVE_ORA"
const uint64_t OB_ALL_VIRTUAL_SQL_WORKAREA_HISTOGRAM_ORA_TID = 15086; // "ALL_VIRTUAL_SQL_WORKAREA_HISTOGRAM_ORA"
const uint64_t OB_ALL_VIRTUAL_SQL_WORKAREA_MEMORY_INFO_ORA_TID = 15087; // "ALL_VIRTUAL_SQL_WORKAREA_MEMORY_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_MGR_ORA_TID = 15094; // "ALL_VIRTUAL_TABLE_MGR_ORA"
const uint64_t OB_ALL_VIRTUAL_SERVER_SCHEMA_INFO_ORA_TID = 15097; // "ALL_VIRTUAL_SERVER_SCHEMA_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_SQL_PLAN_MONITOR_ORA_TID = 15100; // "ALL_VIRTUAL_SQL_PLAN_MONITOR_ORA"
const uint64_t OB_ALL_VIRTUAL_SQL_MONITOR_STATNAME_ORA_TID = 15101; // "ALL_VIRTUAL_SQL_MONITOR_STATNAME_ORA"
const uint64_t OB_ALL_VIRTUAL_LOCK_WAIT_STAT_ORA_TID = 15102; // "ALL_VIRTUAL_LOCK_WAIT_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_OPEN_CURSOR_ORA_TID = 15103; // "ALL_VIRTUAL_OPEN_CURSOR_ORA"
const uint64_t OB_TENANT_VIRTUAL_OBJECT_DEFINITION_ORA_TID = 15110; // "TENANT_VIRTUAL_OBJECT_DEFINITION_ORA"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_PARAM_SYS_AGENT_TID = 15111; // "ALL_VIRTUAL_ROUTINE_PARAM_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_TYPE_SYS_AGENT_TID = 15112; // "ALL_VIRTUAL_TYPE_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_TYPE_ATTR_SYS_AGENT_TID = 15113; // "ALL_VIRTUAL_TYPE_ATTR_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_COLL_TYPE_SYS_AGENT_TID = 15114; // "ALL_VIRTUAL_COLL_TYPE_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_PACKAGE_SYS_AGENT_TID = 15115; // "ALL_VIRTUAL_PACKAGE_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_TENANT_TRIGGER_SYS_AGENT_TID = 15116; // "ALL_VIRTUAL_TENANT_TRIGGER_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_SYS_AGENT_TID = 15117; // "ALL_VIRTUAL_ROUTINE_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_GLOBAL_TRANSACTION_ORA_TID = 15118; // "ALL_VIRTUAL_GLOBAL_TRANSACTION_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_REAL_AGENT_ORA_TID = 15120; // "ALL_VIRTUAL_TABLE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_COLUMN_REAL_AGENT_ORA_TID = 15121; // "ALL_VIRTUAL_COLUMN_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DATABASE_REAL_AGENT_ORA_TID = 15122; // "ALL_VIRTUAL_DATABASE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_AUTO_INCREMENT_REAL_AGENT_ORA_TID = 15123; // "ALL_VIRTUAL_AUTO_INCREMENT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PART_REAL_AGENT_ORA_TID = 15124; // "ALL_VIRTUAL_PART_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SUB_PART_REAL_AGENT_ORA_TID = 15125; // "ALL_VIRTUAL_SUB_PART_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PACKAGE_REAL_AGENT_ORA_TID = 15126; // "ALL_VIRTUAL_PACKAGE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SEQUENCE_VALUE_REAL_AGENT_ORA_TID = 15127; // "ALL_VIRTUAL_SEQUENCE_VALUE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT_ORA_TID = 15128; // "ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_USER_REAL_AGENT_ORA_TID = 15129; // "ALL_VIRTUAL_USER_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SYNONYM_REAL_AGENT_ORA_TID = 15130; // "ALL_VIRTUAL_SYNONYM_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA_TID = 15131; // "ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RECYCLEBIN_REAL_AGENT_ORA_TID = 15135; // "ALL_VIRTUAL_RECYCLEBIN_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA_TID = 15136; // "ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLEGROUP_REAL_AGENT_ORA_TID = 15137; // "ALL_VIRTUAL_TABLEGROUP_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_FOREIGN_KEY_COLUMN_REAL_AGENT_ORA_TID = 15138; // "ALL_VIRTUAL_FOREIGN_KEY_COLUMN_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_CONSTRAINT_REAL_AGENT_ORA_TID = 15139; // "ALL_VIRTUAL_CONSTRAINT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TYPE_REAL_AGENT_ORA_TID = 15140; // "ALL_VIRTUAL_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TYPE_ATTR_REAL_AGENT_ORA_TID = 15141; // "ALL_VIRTUAL_TYPE_ATTR_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_COLL_TYPE_REAL_AGENT_ORA_TID = 15142; // "ALL_VIRTUAL_COLL_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_PARAM_REAL_AGENT_ORA_TID = 15143; // "ALL_VIRTUAL_ROUTINE_PARAM_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_KEYSTORE_REAL_AGENT_ORA_TID = 15145; // "ALL_VIRTUAL_TENANT_KEYSTORE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_POLICY_REAL_AGENT_ORA_TID = 15146; // "ALL_VIRTUAL_TENANT_OLS_POLICY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_COMPONENT_REAL_AGENT_ORA_TID = 15147; // "ALL_VIRTUAL_TENANT_OLS_COMPONENT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA_TID = 15148; // "ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_REAL_AGENT_ORA_TID = 15149; // "ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_TABLESPACE_REAL_AGENT_ORA_TID = 15150; // "ALL_VIRTUAL_TENANT_TABLESPACE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_PROFILE_REAL_AGENT_ORA_TID = 15151; // "ALL_VIRTUAL_TENANT_PROFILE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_REAL_AGENT_ORA_TID = 15152; // "ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_PRIVILEGE_REAL_AGENT_ORA_TID = 15153; // "ALL_VIRTUAL_TABLE_PRIVILEGE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_SECURITY_AUDIT_REAL_AGENT_ORA_TID = 15154; // "ALL_VIRTUAL_TENANT_SECURITY_AUDIT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA_TID = 15156; // "ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_SECURITY_AUDIT_RECORD_REAL_AGENT_ORA_TID = 15157; // "ALL_VIRTUAL_TENANT_SECURITY_AUDIT_RECORD_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_SYSAUTH_REAL_AGENT_ORA_TID = 15158; // "ALL_VIRTUAL_TENANT_SYSAUTH_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OBJAUTH_REAL_AGENT_ORA_TID = 15160; // "ALL_VIRTUAL_TENANT_OBJAUTH_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT_ORA_TID = 15162; // "ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DEF_SUB_PART_REAL_AGENT_ORA_TID = 15163; // "ALL_VIRTUAL_DEF_SUB_PART_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT_ORA_TID = 15164; // "ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DBLINK_REAL_AGENT_ORA_TID = 15165; // "ALL_VIRTUAL_DBLINK_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_CONSTRAINT_COLUMN_REAL_AGENT_ORA_TID = 15167; // "ALL_VIRTUAL_TENANT_CONSTRAINT_COLUMN_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_DEPENDENCY_REAL_AGENT_ORA_TID = 15168; // "ALL_VIRTUAL_TENANT_DEPENDENCY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_TIME_ZONE_REAL_AGENT_ORA_TID = 15170; // "ALL_VIRTUAL_TENANT_TIME_ZONE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_TIME_ZONE_NAME_REAL_AGENT_ORA_TID = 15171; // "ALL_VIRTUAL_TENANT_TIME_ZONE_NAME_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_TIME_ZONE_TRANSITION_REAL_AGENT_ORA_TID = 15172; // "ALL_VIRTUAL_TENANT_TIME_ZONE_TRANSITION_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_TIME_ZONE_TRANSITION_TYPE_REAL_AGENT_ORA_TID = 15173; // "ALL_VIRTUAL_TENANT_TIME_ZONE_TRANSITION_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RES_MGR_PLAN_REAL_AGENT_ORA_TID = 15174; // "ALL_VIRTUAL_RES_MGR_PLAN_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RES_MGR_DIRECTIVE_REAL_AGENT_ORA_TID = 15175; // "ALL_VIRTUAL_RES_MGR_DIRECTIVE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TRANS_LOCK_STAT_ORA_TID = 15176; // "ALL_VIRTUAL_TRANS_LOCK_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_RES_MGR_MAPPING_RULE_REAL_AGENT_ORA_TID = 15177; // "ALL_VIRTUAL_RES_MGR_MAPPING_RULE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLET_ENCRYPT_INFO_ORA_TID = 15178; // "ALL_VIRTUAL_TABLET_ENCRYPT_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_RES_MGR_CONSUMER_GROUP_REAL_AGENT_ORA_TID = 15179; // "ALL_VIRTUAL_RES_MGR_CONSUMER_GROUP_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_COLUMN_USAGE_REAL_AGENT_ORA_TID = 15181; // "ALL_VIRTUAL_COLUMN_USAGE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_JOB_REAL_AGENT_ORA_TID = 15183; // "ALL_VIRTUAL_JOB_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_JOB_LOG_REAL_AGENT_ORA_TID = 15184; // "ALL_VIRTUAL_JOB_LOG_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_DIRECTORY_REAL_AGENT_ORA_TID = 15185; // "ALL_VIRTUAL_TENANT_DIRECTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_STAT_REAL_AGENT_ORA_TID = 15186; // "ALL_VIRTUAL_TABLE_STAT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_COLUMN_STAT_REAL_AGENT_ORA_TID = 15187; // "ALL_VIRTUAL_COLUMN_STAT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_HISTOGRAM_STAT_REAL_AGENT_ORA_TID = 15188; // "ALL_VIRTUAL_HISTOGRAM_STAT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_MEMORY_INFO_ORA_TID = 15189; // "ALL_VIRTUAL_TENANT_MEMORY_INFO_ORA"
const uint64_t OB_TENANT_VIRTUAL_SHOW_CREATE_TRIGGER_ORA_TID = 15191; // "TENANT_VIRTUAL_SHOW_CREATE_TRIGGER_ORA"
const uint64_t OB_ALL_VIRTUAL_PX_TARGET_MONITOR_ORA_TID = 15192; // "ALL_VIRTUAL_PX_TARGET_MONITOR_ORA"
const uint64_t OB_ALL_VIRTUAL_MONITOR_MODIFIED_REAL_AGENT_ORA_TID = 15193; // "ALL_VIRTUAL_MONITOR_MODIFIED_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_STAT_HISTORY_REAL_AGENT_ORA_TID = 15194; // "ALL_VIRTUAL_TABLE_STAT_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_COLUMN_STAT_HISTORY_REAL_AGENT_ORA_TID = 15195; // "ALL_VIRTUAL_COLUMN_STAT_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_HISTOGRAM_STAT_HISTORY_REAL_AGENT_ORA_TID = 15196; // "ALL_VIRTUAL_HISTOGRAM_STAT_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_OPTSTAT_GLOBAL_PREFS_REAL_AGENT_ORA_TID = 15197; // "ALL_VIRTUAL_OPTSTAT_GLOBAL_PREFS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_OPTSTAT_USER_PREFS_REAL_AGENT_ORA_TID = 15198; // "ALL_VIRTUAL_OPTSTAT_USER_PREFS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DBLINK_INFO_ORA_TID = 15199; // "ALL_VIRTUAL_DBLINK_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_DAM_LAST_ARCH_TS_REAL_AGENT_ORA_TID = 15200; // "ALL_VIRTUAL_DAM_LAST_ARCH_TS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DAM_CLEANUP_JOBS_REAL_AGENT_ORA_TID = 15201; // "ALL_VIRTUAL_DAM_CLEANUP_JOBS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_REAL_AGENT_ORA_TID = 15202; // "ALL_VIRTUAL_TENANT_SCHEDULER_JOB_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_SCHEDULER_PROGRAM_REAL_AGENT_ORA_TID = 15203; // "ALL_VIRTUAL_TENANT_SCHEDULER_PROGRAM_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_CONTEXT_REAL_AGENT_ORA_TID = 15204; // "ALL_VIRTUAL_CONTEXT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_GLOBAL_CONTEXT_VALUE_ORA_TID = 15205; // "ALL_VIRTUAL_GLOBAL_CONTEXT_VALUE_ORA"
const uint64_t OB_ALL_VIRTUAL_TRANS_STAT_ORA_TID = 15206; // "ALL_VIRTUAL_TRANS_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_UNIT_ORA_TID = 15207; // "ALL_VIRTUAL_UNIT_ORA"
const uint64_t OB_ALL_VIRTUAL_KVCACHE_INFO_ORA_TID = 15208; // "ALL_VIRTUAL_KVCACHE_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_SERVER_COMPACTION_PROGRESS_ORA_TID = 15209; // "ALL_VIRTUAL_SERVER_COMPACTION_PROGRESS_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLET_COMPACTION_PROGRESS_ORA_TID = 15210; // "ALL_VIRTUAL_TABLET_COMPACTION_PROGRESS_ORA"
const uint64_t OB_ALL_VIRTUAL_COMPACTION_DIAGNOSE_INFO_ORA_TID = 15211; // "ALL_VIRTUAL_COMPACTION_DIAGNOSE_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_COMPACTION_SUGGESTION_ORA_TID = 15212; // "ALL_VIRTUAL_COMPACTION_SUGGESTION_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLET_COMPACTION_HISTORY_ORA_TID = 15213; // "ALL_VIRTUAL_TABLET_COMPACTION_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_META_TABLE_ORA_TID = 15214; // "ALL_VIRTUAL_LS_META_TABLE_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLET_TO_LS_REAL_AGENT_ORA_TID = 15215; // "ALL_VIRTUAL_TABLET_TO_LS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLET_META_TABLE_ORA_TID = 15216; // "ALL_VIRTUAL_TABLET_META_TABLE_ORA"
const uint64_t OB_ALL_VIRTUAL_CORE_ALL_TABLE_ORA_TID = 15217; // "ALL_VIRTUAL_CORE_ALL_TABLE_ORA"
const uint64_t OB_ALL_VIRTUAL_CORE_COLUMN_TABLE_ORA_TID = 15218; // "ALL_VIRTUAL_CORE_COLUMN_TABLE_ORA"
const uint64_t OB_ALL_VIRTUAL_DTL_INTERM_RESULT_MONITOR_ORA_TID = 15219; // "ALL_VIRTUAL_DTL_INTERM_RESULT_MONITOR_ORA"
const uint64_t OB_ALL_VIRTUAL_PROXY_SCHEMA_ORA_TID = 15220; // "ALL_VIRTUAL_PROXY_SCHEMA_ORA"
const uint64_t OB_ALL_VIRTUAL_PROXY_PARTITION_ORA_TID = 15221; // "ALL_VIRTUAL_PROXY_PARTITION_ORA"
const uint64_t OB_ALL_VIRTUAL_PROXY_PARTITION_INFO_ORA_TID = 15222; // "ALL_VIRTUAL_PROXY_PARTITION_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_PROXY_SUB_PARTITION_ORA_TID = 15223; // "ALL_VIRTUAL_PROXY_SUB_PARTITION_ORA"
const uint64_t OB_ALL_VIRTUAL_ZONE_MERGE_INFO_ORA_TID = 15224; // "ALL_VIRTUAL_ZONE_MERGE_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_MERGE_INFO_ORA_TID = 15225; // "ALL_VIRTUAL_MERGE_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OBJECT_TYPE_SYS_AGENT_TID = 15226; // "ALL_VIRTUAL_TENANT_OBJECT_TYPE_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_BACKUP_JOB_ORA_TID = 15227; // "ALL_VIRTUAL_BACKUP_JOB_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_JOB_HISTORY_ORA_TID = 15228; // "ALL_VIRTUAL_BACKUP_JOB_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_TASK_ORA_TID = 15229; // "ALL_VIRTUAL_BACKUP_TASK_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_TASK_HISTORY_ORA_TID = 15230; // "ALL_VIRTUAL_BACKUP_TASK_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_SET_FILES_ORA_TID = 15231; // "ALL_VIRTUAL_BACKUP_SET_FILES_ORA"
const uint64_t OB_ALL_VIRTUAL_PLAN_BASELINE_REAL_AGENT_ORA_TID = 15232; // "ALL_VIRTUAL_PLAN_BASELINE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PLAN_BASELINE_ITEM_REAL_AGENT_ORA_TID = 15233; // "ALL_VIRTUAL_PLAN_BASELINE_ITEM_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SPM_CONFIG_REAL_AGENT_ORA_TID = 15234; // "ALL_VIRTUAL_SPM_CONFIG_REAL_AGENT_ORA"
const uint64_t OB_TENANT_VIRTUAL_EVENT_NAME_ORA_TID = 15235; // "TENANT_VIRTUAL_EVENT_NAME_ORA"
const uint64_t OB_ALL_VIRTUAL_ASH_ORA_TID = 15236; // "ALL_VIRTUAL_ASH_ORA"
const uint64_t OB_ALL_VIRTUAL_DML_STATS_ORA_TID = 15237; // "ALL_VIRTUAL_DML_STATS_ORA"
const uint64_t OB_ALL_VIRTUAL_LOG_ARCHIVE_DEST_PARAMETER_ORA_TID = 15238; // "ALL_VIRTUAL_LOG_ARCHIVE_DEST_PARAMETER_ORA"
const uint64_t OB_ALL_VIRTUAL_LOG_ARCHIVE_PROGRESS_ORA_TID = 15239; // "ALL_VIRTUAL_LOG_ARCHIVE_PROGRESS_ORA"
const uint64_t OB_ALL_VIRTUAL_LOG_ARCHIVE_HISTORY_ORA_TID = 15240; // "ALL_VIRTUAL_LOG_ARCHIVE_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_LOG_ARCHIVE_PIECE_FILES_ORA_TID = 15241; // "ALL_VIRTUAL_LOG_ARCHIVE_PIECE_FILES_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_LOG_ARCHIVE_PROGRESS_ORA_TID = 15242; // "ALL_VIRTUAL_LS_LOG_ARCHIVE_PROGRESS_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_PARAMETER_ORA_TID = 15243; // "ALL_VIRTUAL_BACKUP_PARAMETER_ORA"
const uint64_t OB_ALL_VIRTUAL_RESTORE_JOB_ORA_TID = 15244; // "ALL_VIRTUAL_RESTORE_JOB_ORA"
const uint64_t OB_ALL_VIRTUAL_RESTORE_JOB_HISTORY_ORA_TID = 15245; // "ALL_VIRTUAL_RESTORE_JOB_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_RESTORE_PROGRESS_ORA_TID = 15246; // "ALL_VIRTUAL_RESTORE_PROGRESS_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_RESTORE_PROGRESS_ORA_TID = 15247; // "ALL_VIRTUAL_LS_RESTORE_PROGRESS_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_RESTORE_HISTORY_ORA_TID = 15248; // "ALL_VIRTUAL_LS_RESTORE_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_OUTLINE_REAL_AGENT_ORA_TID = 15249; // "ALL_VIRTUAL_OUTLINE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_OUTLINE_HISTORY_REAL_AGENT_ORA_TID = 15250; // "ALL_VIRTUAL_OUTLINE_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_STORAGE_INFO_ORA_TID = 15251; // "ALL_VIRTUAL_BACKUP_STORAGE_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_STORAGE_INFO_HISTORY_ORA_TID = 15252; // "ALL_VIRTUAL_BACKUP_STORAGE_INFO_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_JOB_ORA_TID = 15253; // "ALL_VIRTUAL_BACKUP_DELETE_JOB_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_JOB_HISTORY_ORA_TID = 15254; // "ALL_VIRTUAL_BACKUP_DELETE_JOB_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_TASK_ORA_TID = 15255; // "ALL_VIRTUAL_BACKUP_DELETE_TASK_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_TASK_HISTORY_ORA_TID = 15256; // "ALL_VIRTUAL_BACKUP_DELETE_TASK_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_BACKUP_DELETE_POLICY_ORA_TID = 15257; // "ALL_VIRTUAL_BACKUP_DELETE_POLICY_ORA"
const uint64_t OB_ALL_VIRTUAL_DEADLOCK_EVENT_HISTORY_ORA_TID = 15258; // "ALL_VIRTUAL_DEADLOCK_EVENT_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_LOG_STAT_ORA_TID = 15259; // "ALL_VIRTUAL_LOG_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_REPLAY_STAT_ORA_TID = 15260; // "ALL_VIRTUAL_REPLAY_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_APPLY_STAT_ORA_TID = 15261; // "ALL_VIRTUAL_APPLY_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_ARCHIVE_STAT_ORA_TID = 15262; // "ALL_VIRTUAL_ARCHIVE_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_STATUS_ORA_TID = 15266; // "ALL_VIRTUAL_LS_STATUS_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_RECOVERY_STAT_ORA_TID = 15267; // "ALL_VIRTUAL_LS_RECOVERY_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_ELECTION_REFERENCE_INFO_ORA_TID = 15268; // "ALL_VIRTUAL_LS_ELECTION_REFERENCE_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_INFO_ORA_TID = 15269; // "ALL_VIRTUAL_TENANT_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_FREEZE_INFO_REAL_AGENT_ORA_TID = 15270; // "ALL_VIRTUAL_FREEZE_INFO_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_REPLICA_TASK_ORA_TID = 15272; // "ALL_VIRTUAL_LS_REPLICA_TASK_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_REPLICA_TASK_PLAN_ORA_TID = 15273; // "ALL_VIRTUAL_LS_REPLICA_TASK_PLAN_ORA"
const uint64_t OB_ALL_VIRTUAL_SHOW_TRACE_ORA_TID = 15274; // "ALL_VIRTUAL_SHOW_TRACE_ORA"
const uint64_t OB_ALL_VIRTUAL_DATABASE_PRIVILEGE_REAL_AGENT_ORA_TID = 15275; // "ALL_VIRTUAL_DATABASE_PRIVILEGE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RLS_POLICY_REAL_AGENT_ORA_TID = 15276; // "ALL_VIRTUAL_RLS_POLICY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RLS_SECURITY_COLUMN_REAL_AGENT_ORA_TID = 15277; // "ALL_VIRTUAL_RLS_SECURITY_COLUMN_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RLS_GROUP_REAL_AGENT_ORA_TID = 15278; // "ALL_VIRTUAL_RLS_GROUP_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RLS_CONTEXT_REAL_AGENT_ORA_TID = 15279; // "ALL_VIRTUAL_RLS_CONTEXT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RLS_ATTRIBUTE_REAL_AGENT_ORA_TID = 15280; // "ALL_VIRTUAL_RLS_ATTRIBUTE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_REWRITE_RULES_REAL_AGENT_ORA_TID = 15281; // "ALL_VIRTUAL_TENANT_REWRITE_RULES_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_SYS_AGENT_TID = 15282; // "ALL_VIRTUAL_TENANT_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_SQL_PLAN_ORA_TID = 15284; // "ALL_VIRTUAL_SQL_PLAN_ORA"
const uint64_t OB_ALL_VIRTUAL_TRANS_SCHEDULER_ORA_TID = 15287; // "ALL_VIRTUAL_TRANS_SCHEDULER_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_ARB_REPLICA_TASK_ORA_TID = 15288; // "ALL_VIRTUAL_LS_ARB_REPLICA_TASK_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_ARB_REPLICA_TASK_HISTORY_ORA_TID = 15289; // "ALL_VIRTUAL_LS_ARB_REPLICA_TASK_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_ARCHIVE_DEST_STATUS_ORA_TID = 15290; // "ALL_VIRTUAL_ARCHIVE_DEST_STATUS_ORA"
const uint64_t OB_ALL_VIRTUAL_EXTERNAL_TABLE_FILE_REAL_AGENT_ORA_TID = 15292; // "ALL_VIRTUAL_EXTERNAL_TABLE_FILE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DATA_DICTIONARY_IN_LOG_REAL_AGENT_ORA_TID = 15293; // "ALL_VIRTUAL_DATA_DICTIONARY_IN_LOG_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TASK_OPT_STAT_GATHER_HISTORY_ORA_TID = 15294; // "ALL_VIRTUAL_TASK_OPT_STAT_GATHER_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_OPT_STAT_GATHER_HISTORY_ORA_TID = 15295; // "ALL_VIRTUAL_TABLE_OPT_STAT_GATHER_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_OPT_STAT_GATHER_MONITOR_ORA_TID = 15296; // "ALL_VIRTUAL_OPT_STAT_GATHER_MONITOR_ORA"
const uint64_t OB_ALL_VIRTUAL_LONG_OPS_STATUS_SYS_AGENT_TID = 15297; // "ALL_VIRTUAL_LONG_OPS_STATUS_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_THREAD_ORA_TID = 15298; // "ALL_VIRTUAL_THREAD_ORA"
const uint64_t OB_ALL_VIRTUAL_WR_ACTIVE_SESSION_HISTORY_ORA_TID = 15299; // "ALL_VIRTUAL_WR_ACTIVE_SESSION_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_WR_SNAPSHOT_ORA_TID = 15300; // "ALL_VIRTUAL_WR_SNAPSHOT_ORA"
const uint64_t OB_ALL_VIRTUAL_WR_STATNAME_ORA_TID = 15301; // "ALL_VIRTUAL_WR_STATNAME_ORA"
const uint64_t OB_ALL_VIRTUAL_WR_SYSSTAT_ORA_TID = 15302; // "ALL_VIRTUAL_WR_SYSSTAT_ORA"
const uint64_t OB_ALL_VIRTUAL_ARBITRATION_MEMBER_INFO_ORA_TID = 15303; // "ALL_VIRTUAL_ARBITRATION_MEMBER_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_ARBITRATION_SERVICE_STATUS_ORA_TID = 15304; // "ALL_VIRTUAL_ARBITRATION_SERVICE_STATUS_ORA"
const uint64_t OB_ALL_VIRTUAL_OBJ_LOCK_ORA_TID = 15305; // "ALL_VIRTUAL_OBJ_LOCK_ORA"
const uint64_t OB_ALL_VIRTUAL_LOG_RESTORE_SOURCE_ORA_TID = 15376; // "ALL_VIRTUAL_LOG_RESTORE_SOURCE_ORA"
const uint64_t OB_ALL_VIRTUAL_BALANCE_JOB_REAL_AGENT_ORA_TID = 15377; // "ALL_VIRTUAL_BALANCE_JOB_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_BALANCE_JOB_HISTORY_REAL_AGENT_ORA_TID = 15378; // "ALL_VIRTUAL_BALANCE_JOB_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_BALANCE_TASK_REAL_AGENT_ORA_TID = 15379; // "ALL_VIRTUAL_BALANCE_TASK_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_BALANCE_TASK_HISTORY_REAL_AGENT_ORA_TID = 15380; // "ALL_VIRTUAL_BALANCE_TASK_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TRANSFER_TASK_REAL_AGENT_ORA_TID = 15381; // "ALL_VIRTUAL_TRANSFER_TASK_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TRANSFER_TASK_HISTORY_REAL_AGENT_ORA_TID = 15382; // "ALL_VIRTUAL_TRANSFER_TASK_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RESOURCE_POOL_SYS_AGENT_TID = 15383; // "ALL_VIRTUAL_RESOURCE_POOL_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_PX_P2P_DATAHUB_ORA_TID = 15384; // "ALL_VIRTUAL_PX_P2P_DATAHUB_ORA"
const uint64_t OB_ALL_VIRTUAL_TIMESTAMP_SERVICE_ORA_TID = 15385; // "ALL_VIRTUAL_TIMESTAMP_SERVICE_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_LOG_RESTORE_STATUS_ORA_TID = 15387; // "ALL_VIRTUAL_LS_LOG_RESTORE_STATUS_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_PARAMETER_ORA_TID = 15388; // "ALL_VIRTUAL_TENANT_PARAMETER_ORA"
const uint64_t OB_ALL_VIRTUAL_MLOG_REAL_AGENT_ORA_TID = 15389; // "ALL_VIRTUAL_MLOG_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REAL_AGENT_ORA_TID = 15390; // "ALL_VIRTUAL_MVIEW_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_REAL_AGENT_ORA_TID = 15391; // "ALL_VIRTUAL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_PARAMS_REAL_AGENT_ORA_TID = 15392; // "ALL_VIRTUAL_MVIEW_REFRESH_STATS_PARAMS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_RUN_STATS_REAL_AGENT_ORA_TID = 15393; // "ALL_VIRTUAL_MVIEW_REFRESH_RUN_STATS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_REAL_AGENT_ORA_TID = 15394; // "ALL_VIRTUAL_MVIEW_REFRESH_STATS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_CHANGE_STATS_REAL_AGENT_ORA_TID = 15395; // "ALL_VIRTUAL_MVIEW_REFRESH_CHANGE_STATS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_MVIEW_REFRESH_STMT_STATS_REAL_AGENT_ORA_TID = 15396; // "ALL_VIRTUAL_MVIEW_REFRESH_STMT_STATS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_REAL_AGENT_ORA_TID = 15397; // "ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_WR_CONTROL_ORA_TID = 15398; // "ALL_VIRTUAL_WR_CONTROL_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_EVENT_HISTORY_ORA_TID = 15399; // "ALL_VIRTUAL_TENANT_EVENT_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_REAL_AGENT_ORA_TID = 15402; // "ALL_VIRTUAL_LS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_FLT_CONFIG_ORA_TID = 15403; // "ALL_VIRTUAL_FLT_CONFIG_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_RUN_DETAIL_REAL_AGENT_ORA_TID = 15404; // "ALL_VIRTUAL_TENANT_SCHEDULER_JOB_RUN_DETAIL_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SESSION_INFO_ORA_TID = 15405; // "ALL_VIRTUAL_SESSION_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_CLASS_REAL_AGENT_ORA_TID = 15406; // "ALL_VIRTUAL_TENANT_SCHEDULER_JOB_CLASS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RECOVER_TABLE_JOB_ORA_TID = 15407; // "ALL_VIRTUAL_RECOVER_TABLE_JOB_ORA"
const uint64_t OB_ALL_VIRTUAL_RECOVER_TABLE_JOB_HISTORY_ORA_TID = 15408; // "ALL_VIRTUAL_RECOVER_TABLE_JOB_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_IMPORT_TABLE_JOB_ORA_TID = 15409; // "ALL_VIRTUAL_IMPORT_TABLE_JOB_ORA"
const uint64_t OB_ALL_VIRTUAL_IMPORT_TABLE_JOB_HISTORY_ORA_TID = 15410; // "ALL_VIRTUAL_IMPORT_TABLE_JOB_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_IMPORT_TABLE_TASK_ORA_TID = 15411; // "ALL_VIRTUAL_IMPORT_TABLE_TASK_ORA"
const uint64_t OB_ALL_VIRTUAL_IMPORT_TABLE_TASK_HISTORY_ORA_TID = 15412; // "ALL_VIRTUAL_IMPORT_TABLE_TASK_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_INFO_ORA_TID = 15414; // "ALL_VIRTUAL_LS_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_CGROUP_CONFIG_ORA_TID = 15418; // "ALL_VIRTUAL_CGROUP_CONFIG_ORA"
const uint64_t OB_ALL_VIRTUAL_WR_SYSTEM_EVENT_ORA_TID = 15421; // "ALL_VIRTUAL_WR_SYSTEM_EVENT_ORA"
const uint64_t OB_ALL_VIRTUAL_WR_EVENT_NAME_ORA_TID = 15422; // "ALL_VIRTUAL_WR_EVENT_NAME_ORA"
const uint64_t OB_ALL_VIRTUAL_SQLSTAT_ORA_TID = 15424; // "ALL_VIRTUAL_SQLSTAT_ORA"
const uint64_t OB_ALL_VIRTUAL_WR_SQLSTAT_ORA_TID = 15425; // "ALL_VIRTUAL_WR_SQLSTAT_ORA"
const uint64_t OB_TENANT_VIRTUAL_STATNAME_ORA_TID = 15426; // "TENANT_VIRTUAL_STATNAME_ORA"
const uint64_t OB_ALL_VIRTUAL_AUX_STAT_REAL_AGENT_ORA_TID = 15427; // "ALL_VIRTUAL_AUX_STAT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SYS_VARIABLE_REAL_AGENT_ORA_TID = 15428; // "ALL_VIRTUAL_SYS_VARIABLE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SYS_VARIABLE_DEFAULT_VALUE_ORA_TID = 15429; // "ALL_VIRTUAL_SYS_VARIABLE_DEFAULT_VALUE_ORA"
const uint64_t OB_ALL_VIRTUAL_TRANSFER_PARTITION_TASK_REAL_AGENT_ORA_TID = 15430; // "ALL_VIRTUAL_TRANSFER_PARTITION_TASK_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TRANSFER_PARTITION_TASK_HISTORY_REAL_AGENT_ORA_TID = 15431; // "ALL_VIRTUAL_TRANSFER_PARTITION_TASK_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_WR_SQLTEXT_ORA_TID = 15432; // "ALL_VIRTUAL_WR_SQLTEXT_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_SNAPSHOT_ORA_TID = 15439; // "ALL_VIRTUAL_LS_SNAPSHOT_ORA"
const uint64_t OB_ALL_VIRTUAL_INDEX_USAGE_INFO_REAL_AGENT_ORA_TID = 15440; // "ALL_VIRTUAL_INDEX_USAGE_INFO_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SHARED_STORAGE_QUOTA_ORA_TID = 15441; // "ALL_VIRTUAL_SHARED_STORAGE_QUOTA_ORA"
const uint64_t OB_ALL_VIRTUAL_LS_REPLICA_TASK_HISTORY_ORA_TID = 15443; // "ALL_VIRTUAL_LS_REPLICA_TASK_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_SESSION_PS_INFO_ORA_TID = 15444; // "ALL_VIRTUAL_SESSION_PS_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_TRACEPOINT_INFO_ORA_TID = 15445; // "ALL_VIRTUAL_TRACEPOINT_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_USER_PROXY_INFO_REAL_AGENT_ORA_TID = 15446; // "ALL_VIRTUAL_USER_PROXY_INFO_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_USER_PROXY_ROLE_INFO_REAL_AGENT_ORA_TID = 15447; // "ALL_VIRTUAL_USER_PROXY_ROLE_INFO_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SERVICE_ORA_TID = 15449; // "ALL_VIRTUAL_SERVICE_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_ORA_TID = 15450; // "ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_DETAIL_ORA_TID = 15451; // "ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_DETAIL_ORA"
const uint64_t OB_ALL_VIRTUAL_GROUP_IO_STAT_ORA_TID = 15452; // "ALL_VIRTUAL_GROUP_IO_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_STORAGE_IO_USAGE_ORA_TID = 15454; // "ALL_VIRTUAL_STORAGE_IO_USAGE_ORA"
const uint64_t OB_ALL_VIRTUAL_ZONE_STORAGE_SYS_AGENT_TID = 15455; // "ALL_VIRTUAL_ZONE_STORAGE_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_NIC_INFO_ORA_TID = 15456; // "ALL_VIRTUAL_NIC_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_QUERY_RESPONSE_TIME_ORA_TID = 15457; // "ALL_VIRTUAL_QUERY_RESPONSE_TIME_ORA"
const uint64_t OB_ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_REAL_AGENT_ORA_TID = 15458; // "ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SPATIAL_REFERENCE_SYSTEMS_REAL_AGENT_ORA_TID = 15459; // "ALL_VIRTUAL_SPATIAL_REFERENCE_SYSTEMS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_LOG_TRANSPORT_DEST_STAT_ORA_TID = 15461; // "ALL_VIRTUAL_LOG_TRANSPORT_DEST_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_SS_LOCAL_CACHE_INFO_ORA_TID = 15462; // "ALL_VIRTUAL_SS_LOCAL_CACHE_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_SPM_EVO_RESULT_ORA_TID = 15466; // "ALL_VIRTUAL_SPM_EVO_RESULT_ORA"
const uint64_t OB_ALL_VIRTUAL_VECTOR_INDEX_INFO_ORA_TID = 15467; // "ALL_VIRTUAL_VECTOR_INDEX_INFO_ORA"
const uint64_t OB_ALL_VIRTUAL_PKG_TYPE_SYS_AGENT_TID = 15468; // "ALL_VIRTUAL_PKG_TYPE_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_PKG_TYPE_ATTR_SYS_AGENT_TID = 15469; // "ALL_VIRTUAL_PKG_TYPE_ATTR_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_PKG_COLL_TYPE_SYS_AGENT_TID = 15470; // "ALL_VIRTUAL_PKG_COLL_TYPE_SYS_AGENT"
const uint64_t OB_ALL_VIRTUAL_PKG_TYPE_REAL_AGENT_ORA_TID = 15471; // "ALL_VIRTUAL_PKG_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PKG_TYPE_ATTR_REAL_AGENT_ORA_TID = 15472; // "ALL_VIRTUAL_PKG_TYPE_ATTR_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PKG_COLL_TYPE_REAL_AGENT_ORA_TID = 15473; // "ALL_VIRTUAL_PKG_COLL_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_WR_SQL_PLAN_ORA_TID = 15481; // "ALL_VIRTUAL_WR_SQL_PLAN_ORA"
const uint64_t OB_ALL_VIRTUAL_RES_MGR_SYSSTAT_ORA_TID = 15482; // "ALL_VIRTUAL_RES_MGR_SYSSTAT_ORA"
const uint64_t OB_ALL_VIRTUAL_FUNCTION_IO_STAT_ORA_TID = 15484; // "ALL_VIRTUAL_FUNCTION_IO_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_TEMP_FILE_ORA_TID = 15485; // "ALL_VIRTUAL_TEMP_FILE_ORA"
const uint64_t OB_ALL_VIRTUAL_NCOMP_DLL_V2_REAL_AGENT_ORA_TID = 15486; // "ALL_VIRTUAL_NCOMP_DLL_V2_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLET_POINTER_STATUS_ORA_TID = 15489; // "ALL_VIRTUAL_TABLET_POINTER_STATUS_ORA"
const uint64_t OB_ALL_VIRTUAL_CS_REPLICA_TABLET_STATS_ORA_TID = 15493; // "ALL_VIRTUAL_CS_REPLICA_TABLET_STATS_ORA"
const uint64_t OB_GV_OB_PLAN_CACHE_STAT_TID = 20001; // "GV$OB_PLAN_CACHE_STAT"
const uint64_t OB_GV_OB_PLAN_CACHE_PLAN_STAT_TID = 20002; // "GV$OB_PLAN_CACHE_PLAN_STAT"
const uint64_t OB_SCHEMATA_TID = 20003; // "SCHEMATA"
const uint64_t OB_CHARACTER_SETS_TID = 20004; // "CHARACTER_SETS"
const uint64_t OB_GLOBAL_VARIABLES_TID = 20005; // "GLOBAL_VARIABLES"
const uint64_t OB_STATISTICS_TID = 20006; // "STATISTICS"
const uint64_t OB_VIEWS_TID = 20007; // "VIEWS"
const uint64_t OB_TABLES_TID = 20008; // "TABLES"
const uint64_t OB_COLLATIONS_TID = 20009; // "COLLATIONS"
const uint64_t OB_COLLATION_CHARACTER_SET_APPLICABILITY_TID = 20010; // "COLLATION_CHARACTER_SET_APPLICABILITY"
const uint64_t OB_PROCESSLIST_TID = 20011; // "PROCESSLIST"
const uint64_t OB_KEY_COLUMN_USAGE_TID = 20012; // "KEY_COLUMN_USAGE"
const uint64_t OB_ENGINES_TID = 20014; // "ENGINES"
const uint64_t OB_ROUTINES_TID = 20015; // "ROUTINES"
const uint64_t OB_PROFILING_TID = 20016; // "PROFILING"
const uint64_t OB_OPTIMIZER_TRACE_TID = 20017; // "OPTIMIZER_TRACE"
const uint64_t OB_PLUGINS_TID = 20018; // "PLUGINS"
const uint64_t OB_INNODB_SYS_COLUMNS_TID = 20019; // "INNODB_SYS_COLUMNS"
const uint64_t OB_INNODB_FT_BEING_DELETED_TID = 20020; // "INNODB_FT_BEING_DELETED"
const uint64_t OB_INNODB_FT_CONFIG_TID = 20021; // "INNODB_FT_CONFIG"
const uint64_t OB_INNODB_FT_DELETED_TID = 20022; // "INNODB_FT_DELETED"
const uint64_t OB_INNODB_FT_INDEX_CACHE_TID = 20023; // "INNODB_FT_INDEX_CACHE"
const uint64_t OB_GV_SESSION_EVENT_TID = 21000; // "GV$SESSION_EVENT"
const uint64_t OB_GV_SESSION_WAIT_TID = 21001; // "GV$SESSION_WAIT"
const uint64_t OB_GV_SESSION_WAIT_HISTORY_TID = 21002; // "GV$SESSION_WAIT_HISTORY"
const uint64_t OB_GV_SYSTEM_EVENT_TID = 21003; // "GV$SYSTEM_EVENT"
const uint64_t OB_GV_SESSTAT_TID = 21004; // "GV$SESSTAT"
const uint64_t OB_GV_SYSSTAT_TID = 21005; // "GV$SYSSTAT"
const uint64_t OB_V_STATNAME_TID = 21006; // "V$STATNAME"
const uint64_t OB_V_EVENT_NAME_TID = 21007; // "V$EVENT_NAME"
const uint64_t OB_V_SESSION_EVENT_TID = 21008; // "V$SESSION_EVENT"
const uint64_t OB_V_SESSION_WAIT_TID = 21009; // "V$SESSION_WAIT"
const uint64_t OB_V_SESSION_WAIT_HISTORY_TID = 21010; // "V$SESSION_WAIT_HISTORY"
const uint64_t OB_V_SESSTAT_TID = 21011; // "V$SESSTAT"
const uint64_t OB_V_SYSSTAT_TID = 21012; // "V$SYSSTAT"
const uint64_t OB_V_SYSTEM_EVENT_TID = 21013; // "V$SYSTEM_EVENT"
const uint64_t OB_GV_OB_SQL_AUDIT_TID = 21014; // "GV$OB_SQL_AUDIT"
const uint64_t OB_GV_LATCH_TID = 21015; // "GV$LATCH"
const uint64_t OB_GV_OB_MEMORY_TID = 21016; // "GV$OB_MEMORY"
const uint64_t OB_V_OB_MEMORY_TID = 21017; // "V$OB_MEMORY"
const uint64_t OB_GV_OB_MEMSTORE_TID = 21018; // "GV$OB_MEMSTORE"
const uint64_t OB_V_OB_MEMSTORE_TID = 21019; // "V$OB_MEMSTORE"
const uint64_t OB_GV_OB_MEMSTORE_INFO_TID = 21020; // "GV$OB_MEMSTORE_INFO"
const uint64_t OB_V_OB_MEMSTORE_INFO_TID = 21021; // "V$OB_MEMSTORE_INFO"
const uint64_t OB_V_OB_PLAN_CACHE_STAT_TID = 21022; // "V$OB_PLAN_CACHE_STAT"
const uint64_t OB_V_OB_PLAN_CACHE_PLAN_STAT_TID = 21023; // "V$OB_PLAN_CACHE_PLAN_STAT"
const uint64_t OB_GV_OB_PLAN_CACHE_PLAN_EXPLAIN_TID = 21024; // "GV$OB_PLAN_CACHE_PLAN_EXPLAIN"
const uint64_t OB_V_OB_PLAN_CACHE_PLAN_EXPLAIN_TID = 21025; // "V$OB_PLAN_CACHE_PLAN_EXPLAIN"
const uint64_t OB_V_OB_SQL_AUDIT_TID = 21026; // "V$OB_SQL_AUDIT"
const uint64_t OB_V_LATCH_TID = 21027; // "V$LATCH"
const uint64_t OB_GV_OB_RPC_OUTGOING_TID = 21028; // "GV$OB_RPC_OUTGOING"
const uint64_t OB_V_OB_RPC_OUTGOING_TID = 21029; // "V$OB_RPC_OUTGOING"
const uint64_t OB_GV_OB_RPC_INCOMING_TID = 21030; // "GV$OB_RPC_INCOMING"
const uint64_t OB_V_OB_RPC_INCOMING_TID = 21031; // "V$OB_RPC_INCOMING"
const uint64_t OB_GV_SQL_PLAN_MONITOR_TID = 21036; // "GV$SQL_PLAN_MONITOR"
const uint64_t OB_V_SQL_PLAN_MONITOR_TID = 21037; // "V$SQL_PLAN_MONITOR"
const uint64_t OB_DBA_RECYCLEBIN_TID = 21038; // "DBA_RECYCLEBIN"
const uint64_t OB_TIME_ZONE_TID = 21054; // "time_zone"
const uint64_t OB_TIME_ZONE_NAME_TID = 21055; // "time_zone_name"
const uint64_t OB_TIME_ZONE_TRANSITION_TID = 21056; // "time_zone_transition"
const uint64_t OB_TIME_ZONE_TRANSITION_TYPE_TID = 21057; // "time_zone_transition_type"
const uint64_t OB_GV_SESSION_LONGOPS_TID = 21059; // "GV$SESSION_LONGOPS"
const uint64_t OB_V_SESSION_LONGOPS_TID = 21060; // "V$SESSION_LONGOPS"
const uint64_t OB_DBA_OB_SEQUENCE_OBJECTS_TID = 21066; // "DBA_OB_SEQUENCE_OBJECTS"
const uint64_t OB_COLUMNS_TID = 21068; // "COLUMNS"
const uint64_t OB_GV_OB_PX_WORKER_STAT_TID = 21071; // "GV$OB_PX_WORKER_STAT"
const uint64_t OB_V_OB_PX_WORKER_STAT_TID = 21072; // "V$OB_PX_WORKER_STAT"
const uint64_t OB_GV_OB_PS_STAT_TID = 21079; // "GV$OB_PS_STAT"
const uint64_t OB_V_OB_PS_STAT_TID = 21080; // "V$OB_PS_STAT"
const uint64_t OB_GV_OB_PS_ITEM_INFO_TID = 21081; // "GV$OB_PS_ITEM_INFO"
const uint64_t OB_V_OB_PS_ITEM_INFO_TID = 21082; // "V$OB_PS_ITEM_INFO"
const uint64_t OB_GV_SQL_WORKAREA_TID = 21083; // "GV$SQL_WORKAREA"
const uint64_t OB_V_SQL_WORKAREA_TID = 21084; // "V$SQL_WORKAREA"
const uint64_t OB_GV_SQL_WORKAREA_ACTIVE_TID = 21085; // "GV$SQL_WORKAREA_ACTIVE"
const uint64_t OB_V_SQL_WORKAREA_ACTIVE_TID = 21086; // "V$SQL_WORKAREA_ACTIVE"
const uint64_t OB_GV_SQL_WORKAREA_HISTOGRAM_TID = 21087; // "GV$SQL_WORKAREA_HISTOGRAM"
const uint64_t OB_V_SQL_WORKAREA_HISTOGRAM_TID = 21088; // "V$SQL_WORKAREA_HISTOGRAM"
const uint64_t OB_GV_OB_SQL_WORKAREA_MEMORY_INFO_TID = 21089; // "GV$OB_SQL_WORKAREA_MEMORY_INFO"
const uint64_t OB_V_OB_SQL_WORKAREA_MEMORY_INFO_TID = 21090; // "V$OB_SQL_WORKAREA_MEMORY_INFO"
const uint64_t OB_GV_OB_PLAN_CACHE_REFERENCE_INFO_TID = 21097; // "GV$OB_PLAN_CACHE_REFERENCE_INFO"
const uint64_t OB_V_OB_PLAN_CACHE_REFERENCE_INFO_TID = 21098; // "V$OB_PLAN_CACHE_REFERENCE_INFO"
const uint64_t OB_GV_OB_SSTABLES_TID = 21100; // "GV$OB_SSTABLES"
const uint64_t OB_V_OB_SSTABLES_TID = 21101; // "V$OB_SSTABLES"
const uint64_t OB_CDB_OB_RESTORE_PROGRESS_TID = 21110; // "CDB_OB_RESTORE_PROGRESS"
const uint64_t OB_CDB_OB_RESTORE_HISTORY_TID = 21111; // "CDB_OB_RESTORE_HISTORY"
const uint64_t OB_GV_OB_SERVER_SCHEMA_INFO_TID = 21112; // "GV$OB_SERVER_SCHEMA_INFO"
const uint64_t OB_V_OB_SERVER_SCHEMA_INFO_TID = 21113; // "V$OB_SERVER_SCHEMA_INFO"
const uint64_t OB_V_SQL_MONITOR_STATNAME_TID = 21117; // "V$SQL_MONITOR_STATNAME"
const uint64_t OB_GV_OB_MERGE_INFO_TID = 21118; // "GV$OB_MERGE_INFO"
const uint64_t OB_V_OB_MERGE_INFO_TID = 21119; // "V$OB_MERGE_INFO"
const uint64_t OB_V_OB_ENCRYPTED_TABLES_TID = 21134; // "V$OB_ENCRYPTED_TABLES"
const uint64_t OB_V_ENCRYPTED_TABLESPACES_TID = 21135; // "V$ENCRYPTED_TABLESPACES"
const uint64_t OB_CDB_OB_ARCHIVELOG_PIECE_FILES_TID = 21136; // "CDB_OB_ARCHIVELOG_PIECE_FILES"
const uint64_t OB_CDB_OB_BACKUP_SET_FILES_TID = 21137; // "CDB_OB_BACKUP_SET_FILES"
const uint64_t OB_CONNECTION_CONTROL_FAILED_LOGIN_ATTEMPTS_TID = 21145; // "CONNECTION_CONTROL_FAILED_LOGIN_ATTEMPTS"
const uint64_t OB_GV_OB_TENANT_MEMORY_TID = 21146; // "GV$OB_TENANT_MEMORY"
const uint64_t OB_V_OB_TENANT_MEMORY_TID = 21147; // "V$OB_TENANT_MEMORY"
const uint64_t OB_GV_OB_PX_TARGET_MONITOR_TID = 21148; // "GV$OB_PX_TARGET_MONITOR"
const uint64_t OB_V_OB_PX_TARGET_MONITOR_TID = 21149; // "V$OB_PX_TARGET_MONITOR"
const uint64_t OB_COLUMN_PRIVILEGES_TID = 21150; // "COLUMN_PRIVILEGES"
const uint64_t OB_VIEW_TABLE_USAGE_TID = 21151; // "VIEW_TABLE_USAGE"
const uint64_t OB_CDB_OB_BACKUP_JOBS_TID = 21152; // "CDB_OB_BACKUP_JOBS"
const uint64_t OB_CDB_OB_BACKUP_JOB_HISTORY_TID = 21153; // "CDB_OB_BACKUP_JOB_HISTORY"
const uint64_t OB_CDB_OB_BACKUP_TASKS_TID = 21154; // "CDB_OB_BACKUP_TASKS"
const uint64_t OB_CDB_OB_BACKUP_TASK_HISTORY_TID = 21155; // "CDB_OB_BACKUP_TASK_HISTORY"
const uint64_t OB_FILES_TID = 21157; // "FILES"
const uint64_t OB_DBA_OB_TENANTS_TID = 21158; // "DBA_OB_TENANTS"
const uint64_t OB_DBA_OB_UNITS_TID = 21159; // "DBA_OB_UNITS"
const uint64_t OB_DBA_OB_UNIT_CONFIGS_TID = 21160; // "DBA_OB_UNIT_CONFIGS"
const uint64_t OB_DBA_OB_RESOURCE_POOLS_TID = 21161; // "DBA_OB_RESOURCE_POOLS"
const uint64_t OB_DBA_OB_SERVERS_TID = 21162; // "DBA_OB_SERVERS"
const uint64_t OB_DBA_OB_ZONES_TID = 21163; // "DBA_OB_ZONES"
const uint64_t OB_DBA_OB_ROOTSERVICE_EVENT_HISTORY_TID = 21164; // "DBA_OB_ROOTSERVICE_EVENT_HISTORY"
const uint64_t OB_DBA_OB_TENANT_JOBS_TID = 21165; // "DBA_OB_TENANT_JOBS"
const uint64_t OB_DBA_OB_UNIT_JOBS_TID = 21166; // "DBA_OB_UNIT_JOBS"
const uint64_t OB_DBA_OB_SERVER_JOBS_TID = 21167; // "DBA_OB_SERVER_JOBS"
const uint64_t OB_DBA_OB_LS_LOCATIONS_TID = 21168; // "DBA_OB_LS_LOCATIONS"
const uint64_t OB_CDB_OB_LS_LOCATIONS_TID = 21169; // "CDB_OB_LS_LOCATIONS"
const uint64_t OB_DBA_OB_TABLET_TO_LS_TID = 21170; // "DBA_OB_TABLET_TO_LS"
const uint64_t OB_CDB_OB_TABLET_TO_LS_TID = 21171; // "CDB_OB_TABLET_TO_LS"
const uint64_t OB_DBA_OB_TABLET_REPLICAS_TID = 21172; // "DBA_OB_TABLET_REPLICAS"
const uint64_t OB_CDB_OB_TABLET_REPLICAS_TID = 21173; // "CDB_OB_TABLET_REPLICAS"
const uint64_t OB_DBA_OB_TABLEGROUPS_TID = 21174; // "DBA_OB_TABLEGROUPS"
const uint64_t OB_CDB_OB_TABLEGROUPS_TID = 21175; // "CDB_OB_TABLEGROUPS"
const uint64_t OB_DBA_OB_TABLEGROUP_PARTITIONS_TID = 21176; // "DBA_OB_TABLEGROUP_PARTITIONS"
const uint64_t OB_CDB_OB_TABLEGROUP_PARTITIONS_TID = 21177; // "CDB_OB_TABLEGROUP_PARTITIONS"
const uint64_t OB_DBA_OB_TABLEGROUP_SUBPARTITIONS_TID = 21178; // "DBA_OB_TABLEGROUP_SUBPARTITIONS"
const uint64_t OB_CDB_OB_TABLEGROUP_SUBPARTITIONS_TID = 21179; // "CDB_OB_TABLEGROUP_SUBPARTITIONS"
const uint64_t OB_DBA_OB_DATABASES_TID = 21180; // "DBA_OB_DATABASES"
const uint64_t OB_CDB_OB_DATABASES_TID = 21181; // "CDB_OB_DATABASES"
const uint64_t OB_DBA_OB_TABLEGROUP_TABLES_TID = 21182; // "DBA_OB_TABLEGROUP_TABLES"
const uint64_t OB_CDB_OB_TABLEGROUP_TABLES_TID = 21183; // "CDB_OB_TABLEGROUP_TABLES"
const uint64_t OB_DBA_OB_ZONE_MAJOR_COMPACTION_TID = 21184; // "DBA_OB_ZONE_MAJOR_COMPACTION"
const uint64_t OB_CDB_OB_ZONE_MAJOR_COMPACTION_TID = 21185; // "CDB_OB_ZONE_MAJOR_COMPACTION"
const uint64_t OB_DBA_OB_MAJOR_COMPACTION_TID = 21186; // "DBA_OB_MAJOR_COMPACTION"
const uint64_t OB_CDB_OB_MAJOR_COMPACTION_TID = 21187; // "CDB_OB_MAJOR_COMPACTION"
const uint64_t OB_CDB_OBJECTS_TID = 21188; // "CDB_OBJECTS"
const uint64_t OB_CDB_TABLES_TID = 21189; // "CDB_TABLES"
const uint64_t OB_CDB_TAB_COLS_V_TID = 21190; // "CDB_TAB_COLS_V$"
const uint64_t OB_CDB_TAB_COLS_TID = 21191; // "CDB_TAB_COLS"
const uint64_t OB_CDB_INDEXES_TID = 21192; // "CDB_INDEXES"
const uint64_t OB_CDB_IND_COLUMNS_TID = 21193; // "CDB_IND_COLUMNS"
const uint64_t OB_CDB_PART_TABLES_TID = 21194; // "CDB_PART_TABLES"
const uint64_t OB_CDB_TAB_PARTITIONS_TID = 21195; // "CDB_TAB_PARTITIONS"
const uint64_t OB_CDB_TAB_SUBPARTITIONS_TID = 21196; // "CDB_TAB_SUBPARTITIONS"
const uint64_t OB_CDB_SUBPARTITION_TEMPLATES_TID = 21197; // "CDB_SUBPARTITION_TEMPLATES"
const uint64_t OB_CDB_PART_KEY_COLUMNS_TID = 21198; // "CDB_PART_KEY_COLUMNS"
const uint64_t OB_CDB_SUBPART_KEY_COLUMNS_TID = 21199; // "CDB_SUBPART_KEY_COLUMNS"
const uint64_t OB_CDB_PART_INDEXES_TID = 21200; // "CDB_PART_INDEXES"
const uint64_t OB_CDB_IND_PARTITIONS_TID = 21201; // "CDB_IND_PARTITIONS"
const uint64_t OB_CDB_IND_SUBPARTITIONS_TID = 21202; // "CDB_IND_SUBPARTITIONS"
const uint64_t OB_CDB_TAB_COL_STATISTICS_TID = 21203; // "CDB_TAB_COL_STATISTICS"
const uint64_t OB_DBA_OBJECTS_TID = 21204; // "DBA_OBJECTS"
const uint64_t OB_DBA_PART_TABLES_TID = 21205; // "DBA_PART_TABLES"
const uint64_t OB_DBA_PART_KEY_COLUMNS_TID = 21206; // "DBA_PART_KEY_COLUMNS"
const uint64_t OB_DBA_SUBPART_KEY_COLUMNS_TID = 21207; // "DBA_SUBPART_KEY_COLUMNS"
const uint64_t OB_DBA_TAB_PARTITIONS_TID = 21208; // "DBA_TAB_PARTITIONS"
const uint64_t OB_DBA_TAB_SUBPARTITIONS_TID = 21209; // "DBA_TAB_SUBPARTITIONS"
const uint64_t OB_DBA_SUBPARTITION_TEMPLATES_TID = 21210; // "DBA_SUBPARTITION_TEMPLATES"
const uint64_t OB_DBA_PART_INDEXES_TID = 21211; // "DBA_PART_INDEXES"
const uint64_t OB_DBA_IND_PARTITIONS_TID = 21212; // "DBA_IND_PARTITIONS"
const uint64_t OB_DBA_IND_SUBPARTITIONS_TID = 21213; // "DBA_IND_SUBPARTITIONS"
const uint64_t OB_GV_OB_SERVERS_TID = 21214; // "GV$OB_SERVERS"
const uint64_t OB_V_OB_SERVERS_TID = 21215; // "V$OB_SERVERS"
const uint64_t OB_GV_OB_UNITS_TID = 21217; // "GV$OB_UNITS"
const uint64_t OB_V_OB_UNITS_TID = 21218; // "V$OB_UNITS"
const uint64_t OB_GV_OB_PARAMETERS_TID = 21219; // "GV$OB_PARAMETERS"
const uint64_t OB_V_OB_PARAMETERS_TID = 21220; // "V$OB_PARAMETERS"
const uint64_t OB_GV_OB_PROCESSLIST_TID = 21221; // "GV$OB_PROCESSLIST"
const uint64_t OB_V_OB_PROCESSLIST_TID = 21222; // "V$OB_PROCESSLIST"
const uint64_t OB_GV_OB_KVCACHE_TID = 21223; // "GV$OB_KVCACHE"
const uint64_t OB_V_OB_KVCACHE_TID = 21224; // "V$OB_KVCACHE"
const uint64_t OB_GV_OB_TRANSACTION_PARTICIPANTS_TID = 21225; // "GV$OB_TRANSACTION_PARTICIPANTS"
const uint64_t OB_V_OB_TRANSACTION_PARTICIPANTS_TID = 21226; // "V$OB_TRANSACTION_PARTICIPANTS"
const uint64_t OB_GV_OB_COMPACTION_PROGRESS_TID = 21227; // "GV$OB_COMPACTION_PROGRESS"
const uint64_t OB_V_OB_COMPACTION_PROGRESS_TID = 21228; // "V$OB_COMPACTION_PROGRESS"
const uint64_t OB_GV_OB_TABLET_COMPACTION_PROGRESS_TID = 21229; // "GV$OB_TABLET_COMPACTION_PROGRESS"
const uint64_t OB_V_OB_TABLET_COMPACTION_PROGRESS_TID = 21230; // "V$OB_TABLET_COMPACTION_PROGRESS"
const uint64_t OB_GV_OB_TABLET_COMPACTION_HISTORY_TID = 21231; // "GV$OB_TABLET_COMPACTION_HISTORY"
const uint64_t OB_V_OB_TABLET_COMPACTION_HISTORY_TID = 21232; // "V$OB_TABLET_COMPACTION_HISTORY"
const uint64_t OB_GV_OB_COMPACTION_DIAGNOSE_INFO_TID = 21233; // "GV$OB_COMPACTION_DIAGNOSE_INFO"
const uint64_t OB_V_OB_COMPACTION_DIAGNOSE_INFO_TID = 21234; // "V$OB_COMPACTION_DIAGNOSE_INFO"
const uint64_t OB_GV_OB_COMPACTION_SUGGESTIONS_TID = 21235; // "GV$OB_COMPACTION_SUGGESTIONS"
const uint64_t OB_V_OB_COMPACTION_SUGGESTIONS_TID = 21236; // "V$OB_COMPACTION_SUGGESTIONS"
const uint64_t OB_GV_OB_DTL_INTERM_RESULT_MONITOR_TID = 21237; // "GV$OB_DTL_INTERM_RESULT_MONITOR"
const uint64_t OB_V_OB_DTL_INTERM_RESULT_MONITOR_TID = 21238; // "V$OB_DTL_INTERM_RESULT_MONITOR"
const uint64_t OB_GV_OB_IO_CALIBRATION_STATUS_TID = 21239; // "GV$OB_IO_CALIBRATION_STATUS"
const uint64_t OB_V_OB_IO_CALIBRATION_STATUS_TID = 21240; // "V$OB_IO_CALIBRATION_STATUS"
const uint64_t OB_GV_OB_IO_BENCHMARK_TID = 21241; // "GV$OB_IO_BENCHMARK"
const uint64_t OB_V_OB_IO_BENCHMARK_TID = 21242; // "V$OB_IO_BENCHMARK"
const uint64_t OB_CDB_OB_BACKUP_DELETE_JOBS_TID = 21245; // "CDB_OB_BACKUP_DELETE_JOBS"
const uint64_t OB_CDB_OB_BACKUP_DELETE_JOB_HISTORY_TID = 21246; // "CDB_OB_BACKUP_DELETE_JOB_HISTORY"
const uint64_t OB_CDB_OB_BACKUP_DELETE_TASKS_TID = 21247; // "CDB_OB_BACKUP_DELETE_TASKS"
const uint64_t OB_CDB_OB_BACKUP_DELETE_TASK_HISTORY_TID = 21248; // "CDB_OB_BACKUP_DELETE_TASK_HISTORY"
const uint64_t OB_CDB_OB_BACKUP_DELETE_POLICY_TID = 21249; // "CDB_OB_BACKUP_DELETE_POLICY"
const uint64_t OB_CDB_OB_BACKUP_STORAGE_INFO_TID = 21250; // "CDB_OB_BACKUP_STORAGE_INFO"
const uint64_t OB_DBA_TAB_STATISTICS_TID = 21251; // "DBA_TAB_STATISTICS"
const uint64_t OB_DBA_TAB_COL_STATISTICS_TID = 21252; // "DBA_TAB_COL_STATISTICS"
const uint64_t OB_DBA_PART_COL_STATISTICS_TID = 21253; // "DBA_PART_COL_STATISTICS"
const uint64_t OB_DBA_SUBPART_COL_STATISTICS_TID = 21254; // "DBA_SUBPART_COL_STATISTICS"
const uint64_t OB_DBA_TAB_HISTOGRAMS_TID = 21255; // "DBA_TAB_HISTOGRAMS"
const uint64_t OB_DBA_PART_HISTOGRAMS_TID = 21256; // "DBA_PART_HISTOGRAMS"
const uint64_t OB_DBA_SUBPART_HISTOGRAMS_TID = 21257; // "DBA_SUBPART_HISTOGRAMS"
const uint64_t OB_DBA_TAB_STATS_HISTORY_TID = 21258; // "DBA_TAB_STATS_HISTORY"
const uint64_t OB_DBA_IND_STATISTICS_TID = 21259; // "DBA_IND_STATISTICS"
const uint64_t OB_DBA_OB_BACKUP_JOBS_TID = 21260; // "DBA_OB_BACKUP_JOBS"
const uint64_t OB_DBA_OB_BACKUP_JOB_HISTORY_TID = 21261; // "DBA_OB_BACKUP_JOB_HISTORY"
const uint64_t OB_DBA_OB_BACKUP_TASKS_TID = 21262; // "DBA_OB_BACKUP_TASKS"
const uint64_t OB_DBA_OB_BACKUP_TASK_HISTORY_TID = 21263; // "DBA_OB_BACKUP_TASK_HISTORY"
const uint64_t OB_DBA_OB_BACKUP_SET_FILES_TID = 21264; // "DBA_OB_BACKUP_SET_FILES"
const uint64_t OB_DBA_SQL_PLAN_BASELINES_TID = 21265; // "DBA_SQL_PLAN_BASELINES"
const uint64_t OB_DBA_SQL_MANAGEMENT_CONFIG_TID = 21266; // "DBA_SQL_MANAGEMENT_CONFIG"
const uint64_t OB_GV_ACTIVE_SESSION_HISTORY_TID = 21267; // "GV$ACTIVE_SESSION_HISTORY"
const uint64_t OB_V_ACTIVE_SESSION_HISTORY_TID = 21268; // "V$ACTIVE_SESSION_HISTORY"
const uint64_t OB_GV_DML_STATS_TID = 21269; // "GV$DML_STATS"
const uint64_t OB_V_DML_STATS_TID = 21270; // "V$DML_STATS"
const uint64_t OB_DBA_TAB_MODIFICATIONS_TID = 21271; // "DBA_TAB_MODIFICATIONS"
const uint64_t OB_DBA_SCHEDULER_JOBS_TID = 21272; // "DBA_SCHEDULER_JOBS"
const uint64_t OB_DBA_OB_OUTLINE_CONCURRENT_HISTORY_TID = 21273; // "DBA_OB_OUTLINE_CONCURRENT_HISTORY"
const uint64_t OB_CDB_OB_BACKUP_STORAGE_INFO_HISTORY_TID = 21274; // "CDB_OB_BACKUP_STORAGE_INFO_HISTORY"
const uint64_t OB_DBA_OB_BACKUP_STORAGE_INFO_TID = 21275; // "DBA_OB_BACKUP_STORAGE_INFO"
const uint64_t OB_DBA_OB_BACKUP_STORAGE_INFO_HISTORY_TID = 21276; // "DBA_OB_BACKUP_STORAGE_INFO_HISTORY"
const uint64_t OB_DBA_OB_BACKUP_DELETE_POLICY_TID = 21277; // "DBA_OB_BACKUP_DELETE_POLICY"
const uint64_t OB_DBA_OB_BACKUP_DELETE_JOBS_TID = 21278; // "DBA_OB_BACKUP_DELETE_JOBS"
const uint64_t OB_DBA_OB_BACKUP_DELETE_JOB_HISTORY_TID = 21279; // "DBA_OB_BACKUP_DELETE_JOB_HISTORY"
const uint64_t OB_DBA_OB_BACKUP_DELETE_TASKS_TID = 21280; // "DBA_OB_BACKUP_DELETE_TASKS"
const uint64_t OB_DBA_OB_BACKUP_DELETE_TASK_HISTORY_TID = 21281; // "DBA_OB_BACKUP_DELETE_TASK_HISTORY"
const uint64_t OB_DBA_OB_OUTLINES_TID = 21282; // "DBA_OB_OUTLINES"
const uint64_t OB_DBA_OB_CONCURRENT_LIMIT_SQL_TID = 21283; // "DBA_OB_CONCURRENT_LIMIT_SQL"
const uint64_t OB_DBA_OB_RESTORE_PROGRESS_TID = 21284; // "DBA_OB_RESTORE_PROGRESS"
const uint64_t OB_DBA_OB_RESTORE_HISTORY_TID = 21285; // "DBA_OB_RESTORE_HISTORY"
const uint64_t OB_DBA_OB_ARCHIVE_DEST_TID = 21287; // "DBA_OB_ARCHIVE_DEST"
const uint64_t OB_DBA_OB_ARCHIVELOG_TID = 21288; // "DBA_OB_ARCHIVELOG"
const uint64_t OB_DBA_OB_ARCHIVELOG_SUMMARY_TID = 21289; // "DBA_OB_ARCHIVELOG_SUMMARY"
const uint64_t OB_DBA_OB_ARCHIVELOG_PIECE_FILES_TID = 21290; // "DBA_OB_ARCHIVELOG_PIECE_FILES"
const uint64_t OB_DBA_OB_BACKUP_PARAMETER_TID = 21291; // "DBA_OB_BACKUP_PARAMETER"
const uint64_t OB_CDB_OB_ARCHIVE_DEST_TID = 21293; // "CDB_OB_ARCHIVE_DEST"
const uint64_t OB_CDB_OB_ARCHIVELOG_TID = 21294; // "CDB_OB_ARCHIVELOG"
const uint64_t OB_CDB_OB_ARCHIVELOG_SUMMARY_TID = 21295; // "CDB_OB_ARCHIVELOG_SUMMARY"
const uint64_t OB_CDB_OB_BACKUP_PARAMETER_TID = 21296; // "CDB_OB_BACKUP_PARAMETER"
const uint64_t OB_DBA_OB_DEADLOCK_EVENT_HISTORY_TID = 21297; // "DBA_OB_DEADLOCK_EVENT_HISTORY"
const uint64_t OB_CDB_OB_DEADLOCK_EVENT_HISTORY_TID = 21298; // "CDB_OB_DEADLOCK_EVENT_HISTORY"
const uint64_t OB_CDB_OB_SYS_VARIABLES_TID = 21299; // "CDB_OB_SYS_VARIABLES"
const uint64_t OB_DBA_OB_KV_TTL_TASKS_TID = 21300; // "DBA_OB_KV_TTL_TASKS"
const uint64_t OB_DBA_OB_KV_TTL_TASK_HISTORY_TID = 21301; // "DBA_OB_KV_TTL_TASK_HISTORY"
const uint64_t OB_GV_OB_LOG_STAT_TID = 21302; // "GV$OB_LOG_STAT"
const uint64_t OB_V_OB_LOG_STAT_TID = 21303; // "V$OB_LOG_STAT"
const uint64_t OB_ST_GEOMETRY_COLUMNS_TID = 21304; // "ST_GEOMETRY_COLUMNS"
const uint64_t OB_ST_SPATIAL_REFERENCE_SYSTEMS_TID = 21305; // "ST_SPATIAL_REFERENCE_SYSTEMS"
const uint64_t OB_QUERY_RESPONSE_TIME_TID = 21306; // "QUERY_RESPONSE_TIME"
const uint64_t OB_CDB_OB_KV_TTL_TASKS_TID = 21307; // "CDB_OB_KV_TTL_TASKS"
const uint64_t OB_CDB_OB_KV_TTL_TASK_HISTORY_TID = 21308; // "CDB_OB_KV_TTL_TASK_HISTORY"
const uint64_t OB_DBA_RSRC_PLANS_TID = 21311; // "DBA_RSRC_PLANS"
const uint64_t OB_DBA_RSRC_PLAN_DIRECTIVES_TID = 21312; // "DBA_RSRC_PLAN_DIRECTIVES"
const uint64_t OB_DBA_RSRC_GROUP_MAPPINGS_TID = 21313; // "DBA_RSRC_GROUP_MAPPINGS"
const uint64_t OB_DBA_RSRC_CONSUMER_GROUPS_TID = 21314; // "DBA_RSRC_CONSUMER_GROUPS"
const uint64_t OB_V_RSRC_PLAN_TID = 21315; // "V$RSRC_PLAN"
const uint64_t OB_CDB_OB_COLUMN_CHECKSUM_ERROR_INFO_TID = 21316; // "CDB_OB_COLUMN_CHECKSUM_ERROR_INFO"
const uint64_t OB_CDB_OB_TABLET_CHECKSUM_ERROR_INFO_TID = 21317; // "CDB_OB_TABLET_CHECKSUM_ERROR_INFO"
const uint64_t OB_DBA_OB_LS_TID = 21318; // "DBA_OB_LS"
const uint64_t OB_CDB_OB_LS_TID = 21319; // "CDB_OB_LS"
const uint64_t OB_DBA_OB_TABLE_LOCATIONS_TID = 21320; // "DBA_OB_TABLE_LOCATIONS"
const uint64_t OB_CDB_OB_TABLE_LOCATIONS_TID = 21321; // "CDB_OB_TABLE_LOCATIONS"
const uint64_t OB_DBA_OB_SERVER_EVENT_HISTORY_TID = 21324; // "DBA_OB_SERVER_EVENT_HISTORY"
const uint64_t OB_CDB_OB_FREEZE_INFO_TID = 21325; // "CDB_OB_FREEZE_INFO"
const uint64_t OB_DBA_OB_FREEZE_INFO_TID = 21326; // "DBA_OB_FREEZE_INFO"
const uint64_t OB_DBA_OB_LS_REPLICA_TASKS_TID = 21329; // "DBA_OB_LS_REPLICA_TASKS"
const uint64_t OB_CDB_OB_LS_REPLICA_TASKS_TID = 21330; // "CDB_OB_LS_REPLICA_TASKS"
const uint64_t OB_V_OB_LS_REPLICA_TASK_PLAN_TID = 21331; // "V$OB_LS_REPLICA_TASK_PLAN"
const uint64_t OB_DBA_OB_AUTO_INCREMENT_TID = 21332; // "DBA_OB_AUTO_INCREMENT"
const uint64_t OB_CDB_OB_AUTO_INCREMENT_TID = 21333; // "CDB_OB_AUTO_INCREMENT"
const uint64_t OB_DBA_SEQUENCES_TID = 21334; // "DBA_SEQUENCES"
const uint64_t OB_DBA_SCHEDULER_WINDOWS_TID = 21335; // "DBA_SCHEDULER_WINDOWS"
const uint64_t OB_DBA_OB_USERS_TID = 21336; // "DBA_OB_USERS"
const uint64_t OB_CDB_OB_USERS_TID = 21337; // "CDB_OB_USERS"
const uint64_t OB_DBA_OB_DATABASE_PRIVILEGE_TID = 21338; // "DBA_OB_DATABASE_PRIVILEGE"
const uint64_t OB_CDB_OB_DATABASE_PRIVILEGE_TID = 21339; // "CDB_OB_DATABASE_PRIVILEGE"
const uint64_t OB_DBA_OB_USER_DEFINED_RULES_TID = 21340; // "DBA_OB_USER_DEFINED_RULES"
const uint64_t OB_GV_OB_SQL_PLAN_TID = 21341; // "GV$OB_SQL_PLAN"
const uint64_t OB_V_OB_SQL_PLAN_TID = 21342; // "V$OB_SQL_PLAN"
const uint64_t OB_DBA_OB_CLUSTER_EVENT_HISTORY_TID = 21345; // "DBA_OB_CLUSTER_EVENT_HISTORY"
const uint64_t OB_PARAMETERS_TID = 21346; // "PARAMETERS"
const uint64_t OB_TABLE_PRIVILEGES_TID = 21347; // "TABLE_PRIVILEGES"
const uint64_t OB_USER_PRIVILEGES_TID = 21348; // "USER_PRIVILEGES"
const uint64_t OB_SCHEMA_PRIVILEGES_TID = 21349; // "SCHEMA_PRIVILEGES"
const uint64_t OB_CHECK_CONSTRAINTS_TID = 21350; // "CHECK_CONSTRAINTS"
const uint64_t OB_REFERENTIAL_CONSTRAINTS_TID = 21351; // "REFERENTIAL_CONSTRAINTS"
const uint64_t OB_TABLE_CONSTRAINTS_TID = 21352; // "TABLE_CONSTRAINTS"
const uint64_t OB_GV_OB_TRANSACTION_SCHEDULERS_TID = 21353; // "GV$OB_TRANSACTION_SCHEDULERS"
const uint64_t OB_V_OB_TRANSACTION_SCHEDULERS_TID = 21354; // "V$OB_TRANSACTION_SCHEDULERS"
const uint64_t OB_TRIGGERS_TID = 21355; // "TRIGGERS"
const uint64_t OB_PARTITIONS_TID = 21356; // "PARTITIONS"
const uint64_t OB_DBA_OB_ARBITRATION_SERVICE_TID = 21357; // "DBA_OB_ARBITRATION_SERVICE"
const uint64_t OB_CDB_OB_LS_ARB_REPLICA_TASKS_TID = 21358; // "CDB_OB_LS_ARB_REPLICA_TASKS"
const uint64_t OB_DBA_OB_LS_ARB_REPLICA_TASKS_TID = 21359; // "DBA_OB_LS_ARB_REPLICA_TASKS"
const uint64_t OB_CDB_OB_LS_ARB_REPLICA_TASK_HISTORY_TID = 21360; // "CDB_OB_LS_ARB_REPLICA_TASK_HISTORY"
const uint64_t OB_DBA_OB_LS_ARB_REPLICA_TASK_HISTORY_TID = 21361; // "DBA_OB_LS_ARB_REPLICA_TASK_HISTORY"
const uint64_t OB_V_OB_ARCHIVE_DEST_STATUS_TID = 21362; // "V$OB_ARCHIVE_DEST_STATUS"
const uint64_t OB_DBA_OB_LS_LOG_ARCHIVE_PROGRESS_TID = 21363; // "DBA_OB_LS_LOG_ARCHIVE_PROGRESS"
const uint64_t OB_CDB_OB_LS_LOG_ARCHIVE_PROGRESS_TID = 21364; // "CDB_OB_LS_LOG_ARCHIVE_PROGRESS"
const uint64_t OB_DBA_OB_RSRC_IO_DIRECTIVES_TID = 21369; // "DBA_OB_RSRC_IO_DIRECTIVES"
const uint64_t OB_GV_OB_TABLET_STATS_TID = 21370; // "GV$OB_TABLET_STATS"
const uint64_t OB_V_OB_TABLET_STATS_TID = 21371; // "V$OB_TABLET_STATS"
const uint64_t OB_DBA_OB_ACCESS_POINT_TID = 21372; // "DBA_OB_ACCESS_POINT"
const uint64_t OB_CDB_OB_ACCESS_POINT_TID = 21373; // "CDB_OB_ACCESS_POINT"
const uint64_t OB_CDB_OB_DATA_DICTIONARY_IN_LOG_TID = 21374; // "CDB_OB_DATA_DICTIONARY_IN_LOG"
const uint64_t OB_DBA_OB_DATA_DICTIONARY_IN_LOG_TID = 21375; // "DBA_OB_DATA_DICTIONARY_IN_LOG"
const uint64_t OB_GV_OB_OPT_STAT_GATHER_MONITOR_TID = 21376; // "GV$OB_OPT_STAT_GATHER_MONITOR"
const uint64_t OB_V_OB_OPT_STAT_GATHER_MONITOR_TID = 21377; // "V$OB_OPT_STAT_GATHER_MONITOR"
const uint64_t OB_DBA_OB_TASK_OPT_STAT_GATHER_HISTORY_TID = 21378; // "DBA_OB_TASK_OPT_STAT_GATHER_HISTORY"
const uint64_t OB_DBA_OB_TABLE_OPT_STAT_GATHER_HISTORY_TID = 21379; // "DBA_OB_TABLE_OPT_STAT_GATHER_HISTORY"
const uint64_t OB_GV_OB_THREAD_TID = 21380; // "GV$OB_THREAD"
const uint64_t OB_V_OB_THREAD_TID = 21381; // "V$OB_THREAD"
const uint64_t OB_GV_OB_ARBITRATION_MEMBER_INFO_TID = 21382; // "GV$OB_ARBITRATION_MEMBER_INFO"
const uint64_t OB_V_OB_ARBITRATION_MEMBER_INFO_TID = 21383; // "V$OB_ARBITRATION_MEMBER_INFO"
const uint64_t OB_DBA_OB_ZONE_STORAGE_TID = 21384; // "DBA_OB_ZONE_STORAGE"
const uint64_t OB_GV_OB_SERVER_STORAGE_TID = 21385; // "GV$OB_SERVER_STORAGE"
const uint64_t OB_V_OB_SERVER_STORAGE_TID = 21386; // "V$OB_SERVER_STORAGE"
const uint64_t OB_GV_OB_ARBITRATION_SERVICE_STATUS_TID = 21387; // "GV$OB_ARBITRATION_SERVICE_STATUS"
const uint64_t OB_V_OB_ARBITRATION_SERVICE_STATUS_TID = 21388; // "V$OB_ARBITRATION_SERVICE_STATUS"
const uint64_t OB_DBA_WR_ACTIVE_SESSION_HISTORY_TID = 21389; // "DBA_WR_ACTIVE_SESSION_HISTORY"
const uint64_t OB_CDB_WR_ACTIVE_SESSION_HISTORY_TID = 21390; // "CDB_WR_ACTIVE_SESSION_HISTORY"
const uint64_t OB_DBA_WR_SNAPSHOT_TID = 21391; // "DBA_WR_SNAPSHOT"
const uint64_t OB_CDB_WR_SNAPSHOT_TID = 21392; // "CDB_WR_SNAPSHOT"
const uint64_t OB_DBA_WR_STATNAME_TID = 21393; // "DBA_WR_STATNAME"
const uint64_t OB_CDB_WR_STATNAME_TID = 21394; // "CDB_WR_STATNAME"
const uint64_t OB_DBA_WR_SYSSTAT_TID = 21395; // "DBA_WR_SYSSTAT"
const uint64_t OB_CDB_WR_SYSSTAT_TID = 21396; // "CDB_WR_SYSSTAT"
const uint64_t OB_GV_OB_KV_CONNECTIONS_TID = 21397; // "GV$OB_KV_CONNECTIONS"
const uint64_t OB_V_OB_KV_CONNECTIONS_TID = 21398; // "V$OB_KV_CONNECTIONS"
const uint64_t OB_GV_OB_LOCKS_TID = 21399; // "GV$OB_LOCKS"
const uint64_t OB_V_OB_LOCKS_TID = 21400; // "V$OB_LOCKS"
const uint64_t OB_CDB_OB_LOG_RESTORE_SOURCE_TID = 21401; // "CDB_OB_LOG_RESTORE_SOURCE"
const uint64_t OB_DBA_OB_LOG_RESTORE_SOURCE_TID = 21402; // "DBA_OB_LOG_RESTORE_SOURCE"
const uint64_t OB_V_OB_TIMESTAMP_SERVICE_TID = 21404; // "V$OB_TIMESTAMP_SERVICE"
const uint64_t OB_DBA_OB_BALANCE_JOBS_TID = 21405; // "DBA_OB_BALANCE_JOBS"
const uint64_t OB_CDB_OB_BALANCE_JOBS_TID = 21406; // "CDB_OB_BALANCE_JOBS"
const uint64_t OB_DBA_OB_BALANCE_JOB_HISTORY_TID = 21407; // "DBA_OB_BALANCE_JOB_HISTORY"
const uint64_t OB_CDB_OB_BALANCE_JOB_HISTORY_TID = 21408; // "CDB_OB_BALANCE_JOB_HISTORY"
const uint64_t OB_DBA_OB_BALANCE_TASKS_TID = 21409; // "DBA_OB_BALANCE_TASKS"
const uint64_t OB_CDB_OB_BALANCE_TASKS_TID = 21410; // "CDB_OB_BALANCE_TASKS"
const uint64_t OB_DBA_OB_BALANCE_TASK_HISTORY_TID = 21411; // "DBA_OB_BALANCE_TASK_HISTORY"
const uint64_t OB_CDB_OB_BALANCE_TASK_HISTORY_TID = 21412; // "CDB_OB_BALANCE_TASK_HISTORY"
const uint64_t OB_DBA_OB_TRANSFER_TASKS_TID = 21413; // "DBA_OB_TRANSFER_TASKS"
const uint64_t OB_CDB_OB_TRANSFER_TASKS_TID = 21414; // "CDB_OB_TRANSFER_TASKS"
const uint64_t OB_DBA_OB_TRANSFER_TASK_HISTORY_TID = 21415; // "DBA_OB_TRANSFER_TASK_HISTORY"
const uint64_t OB_CDB_OB_TRANSFER_TASK_HISTORY_TID = 21416; // "CDB_OB_TRANSFER_TASK_HISTORY"
const uint64_t OB_DBA_OB_EXTERNAL_TABLE_FILES_TID = 21417; // "DBA_OB_EXTERNAL_TABLE_FILES"
const uint64_t OB_ALL_OB_EXTERNAL_TABLE_FILES_TID = 21418; // "ALL_OB_EXTERNAL_TABLE_FILES"
const uint64_t OB_GV_OB_PX_P2P_DATAHUB_TID = 21419; // "GV$OB_PX_P2P_DATAHUB"
const uint64_t OB_V_OB_PX_P2P_DATAHUB_TID = 21420; // "V$OB_PX_P2P_DATAHUB"
const uint64_t OB_GV_SQL_JOIN_FILTER_TID = 21421; // "GV$SQL_JOIN_FILTER"
const uint64_t OB_V_SQL_JOIN_FILTER_TID = 21422; // "V$SQL_JOIN_FILTER"
const uint64_t OB_DBA_OB_TABLE_STAT_STALE_INFO_TID = 21423; // "DBA_OB_TABLE_STAT_STALE_INFO"
const uint64_t OB_V_OB_LS_LOG_RESTORE_STATUS_TID = 21424; // "V$OB_LS_LOG_RESTORE_STATUS"
const uint64_t OB_CDB_OB_EXTERNAL_TABLE_FILES_TID = 21425; // "CDB_OB_EXTERNAL_TABLE_FILES"
const uint64_t OB_DBA_DB_LINKS_TID = 21426; // "DBA_DB_LINKS"
const uint64_t OB_DBA_WR_CONTROL_TID = 21443; // "DBA_WR_CONTROL"
const uint64_t OB_CDB_WR_CONTROL_TID = 21444; // "CDB_WR_CONTROL"
const uint64_t OB_DBA_OB_LS_HISTORY_TID = 21445; // "DBA_OB_LS_HISTORY"
const uint64_t OB_CDB_OB_LS_HISTORY_TID = 21446; // "CDB_OB_LS_HISTORY"
const uint64_t OB_DBA_OB_TENANT_EVENT_HISTORY_TID = 21447; // "DBA_OB_TENANT_EVENT_HISTORY"
const uint64_t OB_CDB_OB_TENANT_EVENT_HISTORY_TID = 21448; // "CDB_OB_TENANT_EVENT_HISTORY"
const uint64_t OB_GV_OB_FLT_TRACE_CONFIG_TID = 21449; // "GV$OB_FLT_TRACE_CONFIG"
const uint64_t OB_GV_OB_SESSION_TID = 21459; // "GV$OB_SESSION"
const uint64_t OB_V_OB_SESSION_TID = 21460; // "V$OB_SESSION"
const uint64_t OB_GV_OB_PL_CACHE_OBJECT_TID = 21461; // "GV$OB_PL_CACHE_OBJECT"
const uint64_t OB_V_OB_PL_CACHE_OBJECT_TID = 21462; // "V$OB_PL_CACHE_OBJECT"
const uint64_t OB_CDB_OB_RECOVER_TABLE_JOBS_TID = 21463; // "CDB_OB_RECOVER_TABLE_JOBS"
const uint64_t OB_DBA_OB_RECOVER_TABLE_JOBS_TID = 21464; // "DBA_OB_RECOVER_TABLE_JOBS"
const uint64_t OB_CDB_OB_RECOVER_TABLE_JOB_HISTORY_TID = 21465; // "CDB_OB_RECOVER_TABLE_JOB_HISTORY"
const uint64_t OB_DBA_OB_RECOVER_TABLE_JOB_HISTORY_TID = 21466; // "DBA_OB_RECOVER_TABLE_JOB_HISTORY"
const uint64_t OB_CDB_OB_IMPORT_TABLE_JOBS_TID = 21467; // "CDB_OB_IMPORT_TABLE_JOBS"
const uint64_t OB_DBA_OB_IMPORT_TABLE_JOBS_TID = 21468; // "DBA_OB_IMPORT_TABLE_JOBS"
const uint64_t OB_CDB_OB_IMPORT_TABLE_JOB_HISTORY_TID = 21469; // "CDB_OB_IMPORT_TABLE_JOB_HISTORY"
const uint64_t OB_DBA_OB_IMPORT_TABLE_JOB_HISTORY_TID = 21470; // "DBA_OB_IMPORT_TABLE_JOB_HISTORY"
const uint64_t OB_CDB_OB_IMPORT_TABLE_TASKS_TID = 21471; // "CDB_OB_IMPORT_TABLE_TASKS"
const uint64_t OB_DBA_OB_IMPORT_TABLE_TASKS_TID = 21472; // "DBA_OB_IMPORT_TABLE_TASKS"
const uint64_t OB_CDB_OB_IMPORT_TABLE_TASK_HISTORY_TID = 21473; // "CDB_OB_IMPORT_TABLE_TASK_HISTORY"
const uint64_t OB_DBA_OB_IMPORT_TABLE_TASK_HISTORY_TID = 21474; // "DBA_OB_IMPORT_TABLE_TASK_HISTORY"
const uint64_t OB_GV_OB_TENANT_RUNTIME_INFO_TID = 21477; // "GV$OB_TENANT_RUNTIME_INFO"
const uint64_t OB_V_OB_TENANT_RUNTIME_INFO_TID = 21478; // "V$OB_TENANT_RUNTIME_INFO"
const uint64_t OB_GV_OB_CGROUP_CONFIG_TID = 21479; // "GV$OB_CGROUP_CONFIG"
const uint64_t OB_V_OB_CGROUP_CONFIG_TID = 21480; // "V$OB_CGROUP_CONFIG"
const uint64_t OB_DBA_WR_SYSTEM_EVENT_TID = 21481; // "DBA_WR_SYSTEM_EVENT"
const uint64_t OB_CDB_WR_SYSTEM_EVENT_TID = 21482; // "CDB_WR_SYSTEM_EVENT"
const uint64_t OB_DBA_WR_EVENT_NAME_TID = 21483; // "DBA_WR_EVENT_NAME"
const uint64_t OB_CDB_WR_EVENT_NAME_TID = 21484; // "CDB_WR_EVENT_NAME"
const uint64_t OB_DBA_OB_FORMAT_OUTLINES_TID = 21485; // "DBA_OB_FORMAT_OUTLINES"
const uint64_t OB_PROCS_PRIV_TID = 21486; // "procs_priv"
const uint64_t OB_GV_OB_SQLSTAT_TID = 21487; // "GV$OB_SQLSTAT"
const uint64_t OB_V_OB_SQLSTAT_TID = 21488; // "V$OB_SQLSTAT"
const uint64_t OB_DBA_WR_SQLSTAT_TID = 21489; // "DBA_WR_SQLSTAT"
const uint64_t OB_CDB_WR_SQLSTAT_TID = 21490; // "CDB_WR_SQLSTAT"
const uint64_t OB_GV_OB_SESS_TIME_MODEL_TID = 21491; // "GV$OB_SESS_TIME_MODEL"
const uint64_t OB_V_OB_SESS_TIME_MODEL_TID = 21492; // "V$OB_SESS_TIME_MODEL"
const uint64_t OB_GV_OB_SYS_TIME_MODEL_TID = 21493; // "GV$OB_SYS_TIME_MODEL"
const uint64_t OB_V_OB_SYS_TIME_MODEL_TID = 21494; // "V$OB_SYS_TIME_MODEL"
const uint64_t OB_DBA_WR_SYS_TIME_MODEL_TID = 21495; // "DBA_WR_SYS_TIME_MODEL"
const uint64_t OB_CDB_WR_SYS_TIME_MODEL_TID = 21496; // "CDB_WR_SYS_TIME_MODEL"
const uint64_t OB_DBA_OB_AUX_STATISTICS_TID = 21497; // "DBA_OB_AUX_STATISTICS"
const uint64_t OB_CDB_OB_AUX_STATISTICS_TID = 21498; // "CDB_OB_AUX_STATISTICS"
const uint64_t OB_DBA_INDEX_USAGE_TID = 21499; // "DBA_INDEX_USAGE"
const uint64_t OB_DBA_OB_SYS_VARIABLES_TID = 21500; // "DBA_OB_SYS_VARIABLES"
const uint64_t OB_DBA_OB_TRANSFER_PARTITION_TASKS_TID = 21501; // "DBA_OB_TRANSFER_PARTITION_TASKS"
const uint64_t OB_CDB_OB_TRANSFER_PARTITION_TASKS_TID = 21502; // "CDB_OB_TRANSFER_PARTITION_TASKS"
const uint64_t OB_DBA_OB_TRANSFER_PARTITION_TASK_HISTORY_TID = 21503; // "DBA_OB_TRANSFER_PARTITION_TASK_HISTORY"
const uint64_t OB_CDB_OB_TRANSFER_PARTITION_TASK_HISTORY_TID = 21504; // "CDB_OB_TRANSFER_PARTITION_TASK_HISTORY"
const uint64_t OB_DBA_WR_SQLTEXT_TID = 21505; // "DBA_WR_SQLTEXT"
const uint64_t OB_CDB_WR_SQLTEXT_TID = 21506; // "CDB_WR_SQLTEXT"
const uint64_t OB_GV_OB_ACTIVE_SESSION_HISTORY_TID = 21507; // "GV$OB_ACTIVE_SESSION_HISTORY"
const uint64_t OB_V_OB_ACTIVE_SESSION_HISTORY_TID = 21508; // "V$OB_ACTIVE_SESSION_HISTORY"
const uint64_t OB_DBA_OB_TRUSTED_ROOT_CERTIFICATE_TID = 21509; // "DBA_OB_TRUSTED_ROOT_CERTIFICATE"
const uint64_t OB_DBA_OB_CLONE_PROGRESS_TID = 21510; // "DBA_OB_CLONE_PROGRESS"
const uint64_t OB_ROLE_EDGES_TID = 21511; // "role_edges"
const uint64_t OB_DEFAULT_ROLES_TID = 21512; // "default_roles"
const uint64_t OB_CDB_INDEX_USAGE_TID = 21513; // "CDB_INDEX_USAGE"
const uint64_t OB_AUDIT_LOG_FILTER_TID = 21514; // "audit_log_filter"
const uint64_t OB_AUDIT_LOG_USER_TID = 21515; // "audit_log_user"
const uint64_t OB_COLUMNS_PRIV_TID = 21516; // "columns_priv"
const uint64_t OB_GV_OB_LS_SNAPSHOTS_TID = 21517; // "GV$OB_LS_SNAPSHOTS"
const uint64_t OB_V_OB_LS_SNAPSHOTS_TID = 21518; // "V$OB_LS_SNAPSHOTS"
const uint64_t OB_DBA_OB_CLONE_HISTORY_TID = 21519; // "DBA_OB_CLONE_HISTORY"
const uint64_t OB_GV_OB_SHARED_STORAGE_QUOTA_TID = 21520; // "GV$OB_SHARED_STORAGE_QUOTA"
const uint64_t OB_V_OB_SHARED_STORAGE_QUOTA_TID = 21521; // "V$OB_SHARED_STORAGE_QUOTA"
const uint64_t OB_DBA_OB_LS_REPLICA_TASK_HISTORY_TID = 21523; // "DBA_OB_LS_REPLICA_TASK_HISTORY"
const uint64_t OB_CDB_OB_LS_REPLICA_TASK_HISTORY_TID = 21524; // "CDB_OB_LS_REPLICA_TASK_HISTORY"
const uint64_t OB_CDB_MVIEW_LOGS_TID = 21525; // "CDB_MVIEW_LOGS"
const uint64_t OB_DBA_MVIEW_LOGS_TID = 21526; // "DBA_MVIEW_LOGS"
const uint64_t OB_CDB_MVIEWS_TID = 21527; // "CDB_MVIEWS"
const uint64_t OB_DBA_MVIEWS_TID = 21528; // "DBA_MVIEWS"
const uint64_t OB_CDB_MVREF_STATS_SYS_DEFAULTS_TID = 21529; // "CDB_MVREF_STATS_SYS_DEFAULTS"
const uint64_t OB_DBA_MVREF_STATS_SYS_DEFAULTS_TID = 21530; // "DBA_MVREF_STATS_SYS_DEFAULTS"
const uint64_t OB_CDB_MVREF_STATS_PARAMS_TID = 21531; // "CDB_MVREF_STATS_PARAMS"
const uint64_t OB_DBA_MVREF_STATS_PARAMS_TID = 21532; // "DBA_MVREF_STATS_PARAMS"
const uint64_t OB_CDB_MVREF_RUN_STATS_TID = 21533; // "CDB_MVREF_RUN_STATS"
const uint64_t OB_DBA_MVREF_RUN_STATS_TID = 21534; // "DBA_MVREF_RUN_STATS"
const uint64_t OB_CDB_MVREF_STATS_TID = 21535; // "CDB_MVREF_STATS"
const uint64_t OB_DBA_MVREF_STATS_TID = 21536; // "DBA_MVREF_STATS"
const uint64_t OB_CDB_MVREF_CHANGE_STATS_TID = 21537; // "CDB_MVREF_CHANGE_STATS"
const uint64_t OB_DBA_MVREF_CHANGE_STATS_TID = 21538; // "DBA_MVREF_CHANGE_STATS"
const uint64_t OB_CDB_MVREF_STMT_STATS_TID = 21539; // "CDB_MVREF_STMT_STATS"
const uint64_t OB_DBA_MVREF_STMT_STATS_TID = 21540; // "DBA_MVREF_STMT_STATS"
const uint64_t OB_GV_OB_SESSION_PS_INFO_TID = 21541; // "GV$OB_SESSION_PS_INFO"
const uint64_t OB_V_OB_SESSION_PS_INFO_TID = 21542; // "V$OB_SESSION_PS_INFO"
const uint64_t OB_GV_OB_TRACEPOINT_INFO_TID = 21543; // "GV$OB_TRACEPOINT_INFO"
const uint64_t OB_V_OB_TRACEPOINT_INFO_TID = 21544; // "V$OB_TRACEPOINT_INFO"
const uint64_t OB_V_OB_COMPATIBILITY_CONTROL_TID = 21545; // "V$OB_COMPATIBILITY_CONTROL"
const uint64_t OB_DBA_OB_RSRC_DIRECTIVES_TID = 21546; // "DBA_OB_RSRC_DIRECTIVES"
const uint64_t OB_CDB_OB_RSRC_DIRECTIVES_TID = 21547; // "CDB_OB_RSRC_DIRECTIVES"
const uint64_t OB_DBA_OB_SERVICES_TID = 21548; // "DBA_OB_SERVICES"
const uint64_t OB_CDB_OB_SERVICES_TID = 21549; // "CDB_OB_SERVICES"
const uint64_t OB_GV_OB_TENANT_RESOURCE_LIMIT_TID = 21550; // "GV$OB_TENANT_RESOURCE_LIMIT"
const uint64_t OB_V_OB_TENANT_RESOURCE_LIMIT_TID = 21551; // "V$OB_TENANT_RESOURCE_LIMIT"
const uint64_t OB_GV_OB_TENANT_RESOURCE_LIMIT_DETAIL_TID = 21552; // "GV$OB_TENANT_RESOURCE_LIMIT_DETAIL"
const uint64_t OB_V_OB_TENANT_RESOURCE_LIMIT_DETAIL_TID = 21553; // "V$OB_TENANT_RESOURCE_LIMIT_DETAIL"
const uint64_t OB_INNODB_LOCK_WAITS_TID = 21554; // "INNODB_LOCK_WAITS"
const uint64_t OB_INNODB_LOCKS_TID = 21555; // "INNODB_LOCKS"
const uint64_t OB_INNODB_TRX_TID = 21556; // "INNODB_TRX"
const uint64_t OB_NDB_TRANSID_MYSQL_CONNECTION_MAP_TID = 21557; // "NDB_TRANSID_MYSQL_CONNECTION_MAP"
const uint64_t OB_V_OB_GROUP_IO_STAT_TID = 21558; // "V$OB_GROUP_IO_STAT"
const uint64_t OB_GV_OB_GROUP_IO_STAT_TID = 21559; // "GV$OB_GROUP_IO_STAT"
const uint64_t OB_DBA_OB_STORAGE_IO_USAGE_TID = 21560; // "DBA_OB_STORAGE_IO_USAGE"
const uint64_t OB_CDB_OB_STORAGE_IO_USAGE_TID = 21561; // "CDB_OB_STORAGE_IO_USAGE"
const uint64_t OB_TABLESPACES_TID = 21562; // "TABLESPACES"
const uint64_t OB_INNODB_BUFFER_PAGE_TID = 21563; // "INNODB_BUFFER_PAGE"
const uint64_t OB_INNODB_BUFFER_PAGE_LRU_TID = 21564; // "INNODB_BUFFER_PAGE_LRU"
const uint64_t OB_INNODB_BUFFER_POOL_STATS_TID = 21565; // "INNODB_BUFFER_POOL_STATS"
const uint64_t OB_INNODB_CMP_TID = 21566; // "INNODB_CMP"
const uint64_t OB_INNODB_CMP_PER_INDEX_TID = 21567; // "INNODB_CMP_PER_INDEX"
const uint64_t OB_INNODB_CMP_PER_INDEX_RESET_TID = 21568; // "INNODB_CMP_PER_INDEX_RESET"
const uint64_t OB_INNODB_CMP_RESET_TID = 21569; // "INNODB_CMP_RESET"
const uint64_t OB_INNODB_CMPMEM_TID = 21570; // "INNODB_CMPMEM"
const uint64_t OB_INNODB_CMPMEM_RESET_TID = 21571; // "INNODB_CMPMEM_RESET"
const uint64_t OB_INNODB_SYS_DATAFILES_TID = 21572; // "INNODB_SYS_DATAFILES"
const uint64_t OB_INNODB_SYS_INDEXES_TID = 21573; // "INNODB_SYS_INDEXES"
const uint64_t OB_INNODB_SYS_TABLES_TID = 21574; // "INNODB_SYS_TABLES"
const uint64_t OB_INNODB_SYS_TABLESPACES_TID = 21575; // "INNODB_SYS_TABLESPACES"
const uint64_t OB_INNODB_SYS_TABLESTATS_TID = 21576; // "INNODB_SYS_TABLESTATS"
const uint64_t OB_INNODB_SYS_VIRTUAL_TID = 21577; // "INNODB_SYS_VIRTUAL"
const uint64_t OB_INNODB_TEMP_TABLE_INFO_TID = 21578; // "INNODB_TEMP_TABLE_INFO"
const uint64_t OB_INNODB_METRICS_TID = 21579; // "INNODB_METRICS"
const uint64_t OB_EVENTS_TID = 21580; // "EVENTS"
const uint64_t OB_V_OB_NIC_INFO_TID = 21581; // "V$OB_NIC_INFO"
const uint64_t OB_ROLE_TABLE_GRANTS_TID = 21582; // "ROLE_TABLE_GRANTS"
const uint64_t OB_ROLE_COLUMN_GRANTS_TID = 21583; // "ROLE_COLUMN_GRANTS"
const uint64_t OB_ROLE_ROUTINE_GRANTS_TID = 21584; // "ROLE_ROUTINE_GRANTS"
const uint64_t OB_FUNC_TID = 21585; // "func"
const uint64_t OB_GV_OB_NIC_INFO_TID = 21586; // "GV$OB_NIC_INFO"
const uint64_t OB_GV_OB_QUERY_RESPONSE_TIME_HISTOGRAM_TID = 21587; // "GV$OB_QUERY_RESPONSE_TIME_HISTOGRAM"
const uint64_t OB_V_OB_QUERY_RESPONSE_TIME_HISTOGRAM_TID = 21588; // "V$OB_QUERY_RESPONSE_TIME_HISTOGRAM"
const uint64_t OB_DBA_SCHEDULER_JOB_RUN_DETAILS_TID = 21589; // "DBA_SCHEDULER_JOB_RUN_DETAILS"
const uint64_t OB_CDB_SCHEDULER_JOB_RUN_DETAILS_TID = 21590; // "CDB_SCHEDULER_JOB_RUN_DETAILS"
const uint64_t OB_CDB_OB_SERVER_SPACE_USAGE_TID = 21592; // "CDB_OB_SERVER_SPACE_USAGE"
const uint64_t OB_CDB_OB_SPACE_USAGE_TID = 21594; // "CDB_OB_SPACE_USAGE"
const uint64_t OB_DBA_OB_TABLE_SPACE_USAGE_TID = 21595; // "DBA_OB_TABLE_SPACE_USAGE"
const uint64_t OB_CDB_OB_TABLE_SPACE_USAGE_TID = 21596; // "CDB_OB_TABLE_SPACE_USAGE"
const uint64_t OB_GV_OB_LOG_TRANSPORT_DEST_STAT_TID = 21597; // "GV$OB_LOG_TRANSPORT_DEST_STAT"
const uint64_t OB_V_OB_LOG_TRANSPORT_DEST_STAT_TID = 21598; // "V$OB_LOG_TRANSPORT_DEST_STAT"
const uint64_t OB_GV_OB_SS_LOCAL_CACHE_TID = 21599; // "GV$OB_SS_LOCAL_CACHE"
const uint64_t OB_V_OB_SS_LOCAL_CACHE_TID = 21600; // "V$OB_SS_LOCAL_CACHE"
const uint64_t OB_GV_OB_KV_GROUP_COMMIT_STATUS_TID = 21601; // "GV$OB_KV_GROUP_COMMIT_STATUS"
const uint64_t OB_V_OB_KV_GROUP_COMMIT_STATUS_TID = 21602; // "V$OB_KV_GROUP_COMMIT_STATUS"
const uint64_t OB_INNODB_SYS_FIELDS_TID = 21603; // "INNODB_SYS_FIELDS"
const uint64_t OB_INNODB_SYS_FOREIGN_TID = 21604; // "INNODB_SYS_FOREIGN"
const uint64_t OB_INNODB_SYS_FOREIGN_COLS_TID = 21605; // "INNODB_SYS_FOREIGN_COLS"
const uint64_t OB_GV_OB_KV_CLIENT_INFO_TID = 21607; // "GV$OB_KV_CLIENT_INFO"
const uint64_t OB_V_OB_KV_CLIENT_INFO_TID = 21608; // "V$OB_KV_CLIENT_INFO"
const uint64_t OB_GV_OB_RES_MGR_SYSSTAT_TID = 21610; // "GV$OB_RES_MGR_SYSSTAT"
const uint64_t OB_V_OB_RES_MGR_SYSSTAT_TID = 21611; // "V$OB_RES_MGR_SYSSTAT"
const uint64_t OB_DBA_WR_SQL_PLAN_TID = 21612; // "DBA_WR_SQL_PLAN"
const uint64_t OB_CDB_WR_SQL_PLAN_TID = 21613; // "CDB_WR_SQL_PLAN"
const uint64_t OB_DBA_OB_SPM_EVO_RESULT_TID = 21616; // "DBA_OB_SPM_EVO_RESULT"
const uint64_t OB_CDB_OB_SPM_EVO_RESULT_TID = 21617; // "CDB_OB_SPM_EVO_RESULT"
const uint64_t OB_DBA_OB_KV_REDIS_TABLE_TID = 21618; // "DBA_OB_KV_REDIS_TABLE"
const uint64_t OB_CDB_OB_KV_REDIS_TABLE_TID = 21619; // "CDB_OB_KV_REDIS_TABLE"
const uint64_t OB_GV_OB_FUNCTION_IO_STAT_TID = 21620; // "GV$OB_FUNCTION_IO_STAT"
const uint64_t OB_V_OB_FUNCTION_IO_STAT_TID = 21621; // "V$OB_FUNCTION_IO_STAT"
const uint64_t OB_DBA_OB_TEMP_FILES_TID = 21622; // "DBA_OB_TEMP_FILES"
const uint64_t OB_CDB_OB_TEMP_FILES_TID = 21623; // "CDB_OB_TEMP_FILES"
const uint64_t OB_PROC_TID = 21628; // "proc"
const uint64_t OB_DBA_OB_CS_REPLICA_STATS_TID = 21633; // "DBA_OB_CS_REPLICA_STATS"
const uint64_t OB_CDB_OB_CS_REPLICA_STATS_TID = 21634; // "CDB_OB_CS_REPLICA_STATS"
const uint64_t OB_GV_OB_PLUGINS_TID = 21635; // "GV$OB_PLUGINS"
const uint64_t OB_V_OB_PLUGINS_TID = 21636; // "V$OB_PLUGINS"
const uint64_t OB_DBA_SYNONYMS_TID = 25001; // "DBA_SYNONYMS"
const uint64_t OB_DBA_OBJECTS_ORA_TID = 25002; // "DBA_OBJECTS_ORA"
const uint64_t OB_ALL_OBJECTS_TID = 25003; // "ALL_OBJECTS"
const uint64_t OB_USER_OBJECTS_TID = 25004; // "USER_OBJECTS"
const uint64_t OB_DBA_SEQUENCES_ORA_TID = 25005; // "DBA_SEQUENCES_ORA"
const uint64_t OB_ALL_SEQUENCES_ORA_TID = 25006; // "ALL_SEQUENCES_ORA"
const uint64_t OB_USER_SEQUENCES_ORA_TID = 25007; // "USER_SEQUENCES_ORA"
const uint64_t OB_DBA_USERS_TID = 25008; // "DBA_USERS"
const uint64_t OB_ALL_USERS_TID = 25009; // "ALL_USERS"
const uint64_t OB_ALL_SYNONYMS_TID = 25010; // "ALL_SYNONYMS"
const uint64_t OB_USER_SYNONYMS_TID = 25011; // "USER_SYNONYMS"
const uint64_t OB_DBA_IND_COLUMNS_TID = 25012; // "DBA_IND_COLUMNS"
const uint64_t OB_ALL_IND_COLUMNS_TID = 25013; // "ALL_IND_COLUMNS"
const uint64_t OB_USER_IND_COLUMNS_TID = 25014; // "USER_IND_COLUMNS"
const uint64_t OB_DBA_CONSTRAINTS_TID = 25015; // "DBA_CONSTRAINTS"
const uint64_t OB_ALL_CONSTRAINTS_TID = 25016; // "ALL_CONSTRAINTS"
const uint64_t OB_USER_CONSTRAINTS_TID = 25017; // "USER_CONSTRAINTS"
const uint64_t OB_ALL_TAB_COLS_V_TID = 25018; // "ALL_TAB_COLS_V$"
const uint64_t OB_DBA_TAB_COLS_V_TID = 25019; // "DBA_TAB_COLS_V$"
const uint64_t OB_USER_TAB_COLS_V_TID = 25020; // "USER_TAB_COLS_V$"
const uint64_t OB_ALL_TAB_COLS_TID = 25021; // "ALL_TAB_COLS"
const uint64_t OB_DBA_TAB_COLS_TID = 25022; // "DBA_TAB_COLS"
const uint64_t OB_USER_TAB_COLS_TID = 25023; // "USER_TAB_COLS"
const uint64_t OB_ALL_TAB_COLUMNS_TID = 25024; // "ALL_TAB_COLUMNS"
const uint64_t OB_DBA_TAB_COLUMNS_TID = 25025; // "DBA_TAB_COLUMNS"
const uint64_t OB_USER_TAB_COLUMNS_TID = 25026; // "USER_TAB_COLUMNS"
const uint64_t OB_ALL_TABLES_TID = 25027; // "ALL_TABLES"
const uint64_t OB_DBA_TABLES_TID = 25028; // "DBA_TABLES"
const uint64_t OB_USER_TABLES_TID = 25029; // "USER_TABLES"
const uint64_t OB_DBA_TAB_COMMENTS_TID = 25030; // "DBA_TAB_COMMENTS"
const uint64_t OB_ALL_TAB_COMMENTS_TID = 25031; // "ALL_TAB_COMMENTS"
const uint64_t OB_USER_TAB_COMMENTS_TID = 25032; // "USER_TAB_COMMENTS"
const uint64_t OB_DBA_COL_COMMENTS_TID = 25033; // "DBA_COL_COMMENTS"
const uint64_t OB_ALL_COL_COMMENTS_TID = 25034; // "ALL_COL_COMMENTS"
const uint64_t OB_USER_COL_COMMENTS_TID = 25035; // "USER_COL_COMMENTS"
const uint64_t OB_DBA_INDEXES_TID = 25036; // "DBA_INDEXES"
const uint64_t OB_ALL_INDEXES_TID = 25037; // "ALL_INDEXES"
const uint64_t OB_USER_INDEXES_TID = 25038; // "USER_INDEXES"
const uint64_t OB_DBA_CONS_COLUMNS_TID = 25039; // "DBA_CONS_COLUMNS"
const uint64_t OB_ALL_CONS_COLUMNS_TID = 25040; // "ALL_CONS_COLUMNS"
const uint64_t OB_USER_CONS_COLUMNS_TID = 25041; // "USER_CONS_COLUMNS"
const uint64_t OB_USER_SEGMENTS_TID = 25042; // "USER_SEGMENTS"
const uint64_t OB_DBA_SEGMENTS_TID = 25043; // "DBA_SEGMENTS"
const uint64_t OB_DBA_TYPES_TID = 25044; // "DBA_TYPES"
const uint64_t OB_ALL_TYPES_TID = 25045; // "ALL_TYPES"
const uint64_t OB_USER_TYPES_TID = 25046; // "USER_TYPES"
const uint64_t OB_DBA_TYPE_ATTRS_TID = 25047; // "DBA_TYPE_ATTRS"
const uint64_t OB_ALL_TYPE_ATTRS_TID = 25048; // "ALL_TYPE_ATTRS"
const uint64_t OB_USER_TYPE_ATTRS_TID = 25049; // "USER_TYPE_ATTRS"
const uint64_t OB_DBA_COLL_TYPES_TID = 25050; // "DBA_COLL_TYPES"
const uint64_t OB_ALL_COLL_TYPES_TID = 25051; // "ALL_COLL_TYPES"
const uint64_t OB_USER_COLL_TYPES_TID = 25052; // "USER_COLL_TYPES"
const uint64_t OB_DBA_PROCEDURES_TID = 25053; // "DBA_PROCEDURES"
const uint64_t OB_DBA_ARGUMENTS_TID = 25054; // "DBA_ARGUMENTS"
const uint64_t OB_DBA_SOURCE_TID = 25055; // "DBA_SOURCE"
const uint64_t OB_ALL_PROCEDURES_TID = 25056; // "ALL_PROCEDURES"
const uint64_t OB_ALL_ARGUMENTS_TID = 25057; // "ALL_ARGUMENTS"
const uint64_t OB_ALL_SOURCE_TID = 25058; // "ALL_SOURCE"
const uint64_t OB_USER_PROCEDURES_TID = 25059; // "USER_PROCEDURES"
const uint64_t OB_USER_ARGUMENTS_TID = 25060; // "USER_ARGUMENTS"
const uint64_t OB_USER_SOURCE_TID = 25061; // "USER_SOURCE"
const uint64_t OB_DBA_PART_KEY_COLUMNS_ORA_TID = 25062; // "DBA_PART_KEY_COLUMNS_ORA"
const uint64_t OB_ALL_PART_KEY_COLUMNS_TID = 25063; // "ALL_PART_KEY_COLUMNS"
const uint64_t OB_USER_PART_KEY_COLUMNS_TID = 25064; // "USER_PART_KEY_COLUMNS"
const uint64_t OB_DBA_SUBPART_KEY_COLUMNS_ORA_TID = 25065; // "DBA_SUBPART_KEY_COLUMNS_ORA"
const uint64_t OB_ALL_SUBPART_KEY_COLUMNS_TID = 25066; // "ALL_SUBPART_KEY_COLUMNS"
const uint64_t OB_USER_SUBPART_KEY_COLUMNS_TID = 25067; // "USER_SUBPART_KEY_COLUMNS"
const uint64_t OB_DBA_VIEWS_TID = 25068; // "DBA_VIEWS"
const uint64_t OB_ALL_VIEWS_TID = 25069; // "ALL_VIEWS"
const uint64_t OB_USER_VIEWS_TID = 25070; // "USER_VIEWS"
const uint64_t OB_ALL_TAB_PARTITIONS_ORA_TID = 25071; // "ALL_TAB_PARTITIONS_ORA"
const uint64_t OB_ALL_TAB_SUBPARTITIONS_ORA_TID = 25072; // "ALL_TAB_SUBPARTITIONS_ORA"
const uint64_t OB_ALL_PART_TABLES_ORA_TID = 25073; // "ALL_PART_TABLES_ORA"
const uint64_t OB_DBA_PART_TABLES_ORA_TID = 25074; // "DBA_PART_TABLES_ORA"
const uint64_t OB_USER_PART_TABLES_ORA_TID = 25075; // "USER_PART_TABLES_ORA"
const uint64_t OB_DBA_TAB_PARTITIONS_ORA_TID = 25076; // "DBA_TAB_PARTITIONS_ORA"
const uint64_t OB_USER_TAB_PARTITIONS_ORA_TID = 25077; // "USER_TAB_PARTITIONS_ORA"
const uint64_t OB_DBA_TAB_SUBPARTITIONS_ORA_TID = 25078; // "DBA_TAB_SUBPARTITIONS_ORA"
const uint64_t OB_USER_TAB_SUBPARTITIONS_ORA_TID = 25079; // "USER_TAB_SUBPARTITIONS_ORA"
const uint64_t OB_DBA_SUBPARTITION_TEMPLATES_ORA_TID = 25080; // "DBA_SUBPARTITION_TEMPLATES_ORA"
const uint64_t OB_ALL_SUBPARTITION_TEMPLATES_ORA_TID = 25081; // "ALL_SUBPARTITION_TEMPLATES_ORA"
const uint64_t OB_USER_SUBPARTITION_TEMPLATES_ORA_TID = 25082; // "USER_SUBPARTITION_TEMPLATES_ORA"
const uint64_t OB_DBA_PART_INDEXES_ORA_TID = 25083; // "DBA_PART_INDEXES_ORA"
const uint64_t OB_ALL_PART_INDEXES_ORA_TID = 25084; // "ALL_PART_INDEXES_ORA"
const uint64_t OB_USER_PART_INDEXES_ORA_TID = 25085; // "USER_PART_INDEXES_ORA"
const uint64_t OB_ALL_ALL_TABLES_ORA_TID = 25086; // "ALL_ALL_TABLES_ORA"
const uint64_t OB_DBA_ALL_TABLES_ORA_TID = 25087; // "DBA_ALL_TABLES_ORA"
const uint64_t OB_USER_ALL_TABLES_ORA_TID = 25088; // "USER_ALL_TABLES_ORA"
const uint64_t OB_DBA_PROFILES_ORA_TID = 25089; // "DBA_PROFILES_ORA"
const uint64_t OB_USER_PROFILES_ORA_TID = 25090; // "USER_PROFILES_ORA"
const uint64_t OB_ALL_PROFILES_ORA_TID = 25091; // "ALL_PROFILES_ORA"
const uint64_t OB_ALL_MVIEW_COMMENTS_ORA_TID = 25092; // "ALL_MVIEW_COMMENTS_ORA"
const uint64_t OB_USER_MVIEW_COMMENTS_ORA_TID = 25093; // "USER_MVIEW_COMMENTS_ORA"
const uint64_t OB_DBA_MVIEW_COMMENTS_ORA_TID = 25094; // "DBA_MVIEW_COMMENTS_ORA"
const uint64_t OB_ALL_SCHEDULER_PROGRAM_ARGS_ORA_TID = 25095; // "ALL_SCHEDULER_PROGRAM_ARGS_ORA"
const uint64_t OB_DBA_SCHEDULER_PROGRAM_ARGS_ORA_TID = 25096; // "DBA_SCHEDULER_PROGRAM_ARGS_ORA"
const uint64_t OB_USER_SCHEDULER_PROGRAM_ARGS_ORA_TID = 25097; // "USER_SCHEDULER_PROGRAM_ARGS_ORA"
const uint64_t OB_ALL_SCHEDULER_JOB_ARGS_ORA_TID = 25098; // "ALL_SCHEDULER_JOB_ARGS_ORA"
const uint64_t OB_DBA_SCHEDULER_JOB_ARGS_ORA_TID = 25099; // "DBA_SCHEDULER_JOB_ARGS_ORA"
const uint64_t OB_USER_SCHEDULER_JOB_ARGS_ORA_TID = 25100; // "USER_SCHEDULER_JOB_ARGS_ORA"
const uint64_t OB_ALL_ERRORS_ORA_TID = 25101; // "ALL_ERRORS_ORA"
const uint64_t OB_DBA_ERRORS_ORA_TID = 25102; // "DBA_ERRORS_ORA"
const uint64_t OB_USER_ERRORS_ORA_TID = 25103; // "USER_ERRORS_ORA"
const uint64_t OB_ALL_TYPE_METHODS_ORA_TID = 25104; // "ALL_TYPE_METHODS_ORA"
const uint64_t OB_DBA_TYPE_METHODS_ORA_TID = 25105; // "DBA_TYPE_METHODS_ORA"
const uint64_t OB_USER_TYPE_METHODS_ORA_TID = 25106; // "USER_TYPE_METHODS_ORA"
const uint64_t OB_ALL_METHOD_PARAMS_ORA_TID = 25107; // "ALL_METHOD_PARAMS_ORA"
const uint64_t OB_DBA_METHOD_PARAMS_ORA_TID = 25108; // "DBA_METHOD_PARAMS_ORA"
const uint64_t OB_USER_METHOD_PARAMS_ORA_TID = 25109; // "USER_METHOD_PARAMS_ORA"
const uint64_t OB_DBA_TABLESPACES_ORA_TID = 25110; // "DBA_TABLESPACES_ORA"
const uint64_t OB_USER_TABLESPACES_ORA_TID = 25111; // "USER_TABLESPACES_ORA"
const uint64_t OB_DBA_IND_EXPRESSIONS_TID = 25112; // "DBA_IND_EXPRESSIONS"
const uint64_t OB_USER_IND_EXPRESSIONS_TID = 25113; // "USER_IND_EXPRESSIONS"
const uint64_t OB_ALL_IND_EXPRESSIONS_TID = 25114; // "ALL_IND_EXPRESSIONS"
const uint64_t OB_ALL_IND_PARTITIONS_TID = 25115; // "ALL_IND_PARTITIONS"
const uint64_t OB_USER_IND_PARTITIONS_TID = 25116; // "USER_IND_PARTITIONS"
const uint64_t OB_DBA_IND_PARTITIONS_ORA_TID = 25117; // "DBA_IND_PARTITIONS_ORA"
const uint64_t OB_DBA_IND_SUBPARTITIONS_ORA_TID = 25118; // "DBA_IND_SUBPARTITIONS_ORA"
const uint64_t OB_ALL_IND_SUBPARTITIONS_TID = 25119; // "ALL_IND_SUBPARTITIONS"
const uint64_t OB_USER_IND_SUBPARTITIONS_TID = 25120; // "USER_IND_SUBPARTITIONS"
const uint64_t OB_DBA_ROLES_TID = 25121; // "DBA_ROLES"
const uint64_t OB_DBA_ROLE_PRIVS_TID = 25122; // "DBA_ROLE_PRIVS"
const uint64_t OB_USER_ROLE_PRIVS_TID = 25123; // "USER_ROLE_PRIVS"
const uint64_t OB_DBA_TAB_PRIVS_TID = 25124; // "DBA_TAB_PRIVS"
const uint64_t OB_ALL_TAB_PRIVS_TID = 25125; // "ALL_TAB_PRIVS"
const uint64_t OB_USER_TAB_PRIVS_TID = 25126; // "USER_TAB_PRIVS"
const uint64_t OB_DBA_SYS_PRIVS_TID = 25127; // "DBA_SYS_PRIVS"
const uint64_t OB_USER_SYS_PRIVS_TID = 25128; // "USER_SYS_PRIVS"
const uint64_t OB_AUDIT_ACTIONS_ORA_TID = 25129; // "AUDIT_ACTIONS_ORA"
const uint64_t OB_STMT_AUDIT_OPTION_MAP_ORA_TID = 25130; // "STMT_AUDIT_OPTION_MAP_ORA"
const uint64_t OB_ALL_DEF_AUDIT_OPTS_ORA_TID = 25131; // "ALL_DEF_AUDIT_OPTS_ORA"
const uint64_t OB_DBA_STMT_AUDIT_OPTS_ORA_TID = 25132; // "DBA_STMT_AUDIT_OPTS_ORA"
const uint64_t OB_DBA_OBJ_AUDIT_OPTS_ORA_TID = 25133; // "DBA_OBJ_AUDIT_OPTS_ORA"
const uint64_t OB_DBA_AUDIT_TRAIL_ORA_TID = 25134; // "DBA_AUDIT_TRAIL_ORA"
const uint64_t OB_USER_AUDIT_TRAIL_ORA_TID = 25135; // "USER_AUDIT_TRAIL_ORA"
const uint64_t OB_DBA_AUDIT_EXISTS_ORA_TID = 25136; // "DBA_AUDIT_EXISTS_ORA"
const uint64_t OB_DBA_AUDIT_SESSION_ORA_TID = 25137; // "DBA_AUDIT_SESSION_ORA"
const uint64_t OB_USER_AUDIT_SESSION_ORA_TID = 25138; // "USER_AUDIT_SESSION_ORA"
const uint64_t OB_DBA_AUDIT_STATEMENT_ORA_TID = 25139; // "DBA_AUDIT_STATEMENT_ORA"
const uint64_t OB_USER_AUDIT_STATEMENT_ORA_TID = 25140; // "USER_AUDIT_STATEMENT_ORA"
const uint64_t OB_DBA_AUDIT_OBJECT_ORA_TID = 25141; // "DBA_AUDIT_OBJECT_ORA"
const uint64_t OB_USER_AUDIT_OBJECT_ORA_TID = 25142; // "USER_AUDIT_OBJECT_ORA"
const uint64_t OB_DBA_COL_PRIVS_ORA_TID = 25143; // "DBA_COL_PRIVS_ORA"
const uint64_t OB_USER_COL_PRIVS_ORA_TID = 25144; // "USER_COL_PRIVS_ORA"
const uint64_t OB_ALL_COL_PRIVS_ORA_TID = 25145; // "ALL_COL_PRIVS_ORA"
const uint64_t OB_ROLE_TAB_PRIVS_ORA_TID = 25146; // "ROLE_TAB_PRIVS_ORA"
const uint64_t OB_ROLE_SYS_PRIVS_ORA_TID = 25147; // "ROLE_SYS_PRIVS_ORA"
const uint64_t OB_ROLE_ROLE_PRIVS_ORA_TID = 25148; // "ROLE_ROLE_PRIVS_ORA"
const uint64_t OB_DICTIONARY_ORA_TID = 25149; // "DICTIONARY_ORA"
const uint64_t OB_DICT_ORA_TID = 25150; // "DICT_ORA"
const uint64_t OB_ALL_TRIGGERS_TID = 25151; // "ALL_TRIGGERS"
const uint64_t OB_DBA_TRIGGERS_TID = 25152; // "DBA_TRIGGERS"
const uint64_t OB_USER_TRIGGERS_TID = 25153; // "USER_TRIGGERS"
const uint64_t OB_ALL_DEPENDENCIES_ORA_TID = 25154; // "ALL_DEPENDENCIES_ORA"
const uint64_t OB_DBA_DEPENDENCIES_ORA_TID = 25155; // "DBA_DEPENDENCIES_ORA"
const uint64_t OB_USER_DEPENDENCIES_ORA_TID = 25156; // "USER_DEPENDENCIES_ORA"
const uint64_t OB_DBA_RSRC_PLANS_ORA_TID = 25157; // "DBA_RSRC_PLANS_ORA"
const uint64_t OB_DBA_RSRC_PLAN_DIRECTIVES_ORA_TID = 25158; // "DBA_RSRC_PLAN_DIRECTIVES_ORA"
const uint64_t OB_DBA_RSRC_GROUP_MAPPINGS_ORA_TID = 25159; // "DBA_RSRC_GROUP_MAPPINGS_ORA"
const uint64_t OB_DBA_RECYCLEBIN_ORA_TID = 25160; // "DBA_RECYCLEBIN_ORA"
const uint64_t OB_USER_RECYCLEBIN_ORA_TID = 25161; // "USER_RECYCLEBIN_ORA"
const uint64_t OB_DBA_RSRC_CONSUMER_GROUPS_ORA_TID = 25162; // "DBA_RSRC_CONSUMER_GROUPS_ORA"
const uint64_t OB_DBA_OB_LS_LOCATIONS_ORA_TID = 25163; // "DBA_OB_LS_LOCATIONS_ORA"
const uint64_t OB_DBA_OB_TABLET_TO_LS_ORA_TID = 25164; // "DBA_OB_TABLET_TO_LS_ORA"
const uint64_t OB_DBA_OB_TABLET_REPLICAS_ORA_TID = 25165; // "DBA_OB_TABLET_REPLICAS_ORA"
const uint64_t OB_DBA_OB_TABLEGROUPS_ORA_TID = 25166; // "DBA_OB_TABLEGROUPS_ORA"
const uint64_t OB_DBA_OB_TABLEGROUP_PARTITIONS_ORA_TID = 25167; // "DBA_OB_TABLEGROUP_PARTITIONS_ORA"
const uint64_t OB_DBA_OB_TABLEGROUP_SUBPARTITIONS_ORA_TID = 25168; // "DBA_OB_TABLEGROUP_SUBPARTITIONS_ORA"
const uint64_t OB_DBA_OB_DATABASES_ORA_TID = 25169; // "DBA_OB_DATABASES_ORA"
const uint64_t OB_DBA_OB_TABLEGROUP_TABLES_ORA_TID = 25170; // "DBA_OB_TABLEGROUP_TABLES_ORA"
const uint64_t OB_DBA_OB_ZONE_MAJOR_COMPACTION_ORA_TID = 25171; // "DBA_OB_ZONE_MAJOR_COMPACTION_ORA"
const uint64_t OB_DBA_OB_MAJOR_COMPACTION_ORA_TID = 25172; // "DBA_OB_MAJOR_COMPACTION_ORA"
const uint64_t OB_ALL_IND_STATISTICS_ORA_TID = 25173; // "ALL_IND_STATISTICS_ORA"
const uint64_t OB_DBA_IND_STATISTICS_ORA_TID = 25174; // "DBA_IND_STATISTICS_ORA"
const uint64_t OB_USER_IND_STATISTICS_ORA_TID = 25175; // "USER_IND_STATISTICS_ORA"
const uint64_t OB_DBA_OB_BACKUP_JOBS_ORA_TID = 25176; // "DBA_OB_BACKUP_JOBS_ORA"
const uint64_t OB_DBA_OB_BACKUP_JOB_HISTORY_ORA_TID = 25177; // "DBA_OB_BACKUP_JOB_HISTORY_ORA"
const uint64_t OB_DBA_OB_BACKUP_TASKS_ORA_TID = 25178; // "DBA_OB_BACKUP_TASKS_ORA"
const uint64_t OB_DBA_OB_BACKUP_TASK_HISTORY_ORA_TID = 25179; // "DBA_OB_BACKUP_TASK_HISTORY_ORA"
const uint64_t OB_DBA_OB_BACKUP_SET_FILES_ORA_TID = 25180; // "DBA_OB_BACKUP_SET_FILES_ORA"
const uint64_t OB_ALL_TAB_MODIFICATIONS_ORA_TID = 25181; // "ALL_TAB_MODIFICATIONS_ORA"
const uint64_t OB_DBA_TAB_MODIFICATIONS_ORA_TID = 25182; // "DBA_TAB_MODIFICATIONS_ORA"
const uint64_t OB_USER_TAB_MODIFICATIONS_ORA_TID = 25183; // "USER_TAB_MODIFICATIONS_ORA"
const uint64_t OB_DBA_OB_BACKUP_STORAGE_INFO_ORA_TID = 25184; // "DBA_OB_BACKUP_STORAGE_INFO_ORA"
const uint64_t OB_DBA_OB_BACKUP_STORAGE_INFO_HISTORY_ORA_TID = 25185; // "DBA_OB_BACKUP_STORAGE_INFO_HISTORY_ORA"
const uint64_t OB_DBA_OB_BACKUP_DELETE_POLICY_ORA_TID = 25186; // "DBA_OB_BACKUP_DELETE_POLICY_ORA"
const uint64_t OB_DBA_OB_BACKUP_DELETE_JOBS_ORA_TID = 25187; // "DBA_OB_BACKUP_DELETE_JOBS_ORA"
const uint64_t OB_DBA_OB_BACKUP_DELETE_JOB_HISTORY_ORA_TID = 25188; // "DBA_OB_BACKUP_DELETE_JOB_HISTORY_ORA"
const uint64_t OB_DBA_OB_BACKUP_DELETE_TASKS_ORA_TID = 25189; // "DBA_OB_BACKUP_DELETE_TASKS_ORA"
const uint64_t OB_DBA_OB_BACKUP_DELETE_TASK_HISTORY_ORA_TID = 25190; // "DBA_OB_BACKUP_DELETE_TASK_HISTORY_ORA"
const uint64_t OB_DBA_OB_RESTORE_PROGRESS_ORA_TID = 25191; // "DBA_OB_RESTORE_PROGRESS_ORA"
const uint64_t OB_DBA_OB_RESTORE_HISTORY_ORA_TID = 25192; // "DBA_OB_RESTORE_HISTORY_ORA"
const uint64_t OB_DBA_OB_ARCHIVE_DEST_ORA_TID = 25194; // "DBA_OB_ARCHIVE_DEST_ORA"
const uint64_t OB_DBA_OB_ARCHIVELOG_ORA_TID = 25195; // "DBA_OB_ARCHIVELOG_ORA"
const uint64_t OB_DBA_OB_ARCHIVELOG_SUMMARY_ORA_TID = 25196; // "DBA_OB_ARCHIVELOG_SUMMARY_ORA"
const uint64_t OB_DBA_OB_ARCHIVELOG_PIECE_FILES_ORA_TID = 25197; // "DBA_OB_ARCHIVELOG_PIECE_FILES_ORA"
const uint64_t OB_DBA_OB_BACKUP_PARAMETER_ORA_TID = 25198; // "DBA_OB_BACKUP_PARAMETER_ORA"
const uint64_t OB_DBA_OB_FREEZE_INFO_ORA_TID = 25202; // "DBA_OB_FREEZE_INFO_ORA"
const uint64_t OB_DBA_OB_LS_REPLICA_TASKS_ORA_TID = 25203; // "DBA_OB_LS_REPLICA_TASKS_ORA"
const uint64_t OB_V_OB_LS_REPLICA_TASK_PLAN_ORA_TID = 25204; // "V$OB_LS_REPLICA_TASK_PLAN_ORA"
const uint64_t OB_ALL_SCHEDULER_WINDOWS_ORA_TID = 25205; // "ALL_SCHEDULER_WINDOWS_ORA"
const uint64_t OB_DBA_SCHEDULER_WINDOWS_ORA_TID = 25206; // "DBA_SCHEDULER_WINDOWS_ORA"
const uint64_t OB_DBA_OB_DATABASE_PRIVILEGE_ORA_TID = 25207; // "DBA_OB_DATABASE_PRIVILEGE_ORA"
const uint64_t OB_DBA_OB_TENANTS_ORA_TID = 25208; // "DBA_OB_TENANTS_ORA"
const uint64_t OB_DBA_POLICIES_ORA_TID = 25209; // "DBA_POLICIES_ORA"
const uint64_t OB_ALL_POLICIES_ORA_TID = 25210; // "ALL_POLICIES_ORA"
const uint64_t OB_USER_POLICIES_ORA_TID = 25211; // "USER_POLICIES_ORA"
const uint64_t OB_DBA_POLICY_GROUPS_ORA_TID = 25212; // "DBA_POLICY_GROUPS_ORA"
const uint64_t OB_ALL_POLICY_GROUPS_ORA_TID = 25213; // "ALL_POLICY_GROUPS_ORA"
const uint64_t OB_USER_POLICY_GROUPS_ORA_TID = 25214; // "USER_POLICY_GROUPS_ORA"
const uint64_t OB_DBA_POLICY_CONTEXTS_ORA_TID = 25215; // "DBA_POLICY_CONTEXTS_ORA"
const uint64_t OB_ALL_POLICY_CONTEXTS_ORA_TID = 25216; // "ALL_POLICY_CONTEXTS_ORA"
const uint64_t OB_USER_POLICY_CONTEXTS_ORA_TID = 25217; // "USER_POLICY_CONTEXTS_ORA"
const uint64_t OB_DBA_SEC_RELEVANT_COLS_ORA_TID = 25218; // "DBA_SEC_RELEVANT_COLS_ORA"
const uint64_t OB_ALL_SEC_RELEVANT_COLS_ORA_TID = 25219; // "ALL_SEC_RELEVANT_COLS_ORA"
const uint64_t OB_USER_SEC_RELEVANT_COLS_ORA_TID = 25220; // "USER_SEC_RELEVANT_COLS_ORA"
const uint64_t OB_DBA_OB_LS_ARB_REPLICA_TASKS_ORA_TID = 25221; // "DBA_OB_LS_ARB_REPLICA_TASKS_ORA"
const uint64_t OB_DBA_OB_LS_ARB_REPLICA_TASK_HISTORY_ORA_TID = 25222; // "DBA_OB_LS_ARB_REPLICA_TASK_HISTORY_ORA"
const uint64_t OB_DBA_OB_RSRC_IO_DIRECTIVES_ORA_TID = 25223; // "DBA_OB_RSRC_IO_DIRECTIVES_ORA"
const uint64_t OB_ALL_DB_LINKS_ORA_TID = 25224; // "ALL_DB_LINKS_ORA"
const uint64_t OB_DBA_DB_LINKS_ORA_TID = 25225; // "DBA_DB_LINKS_ORA"
const uint64_t OB_USER_DB_LINKS_ORA_TID = 25226; // "USER_DB_LINKS_ORA"
const uint64_t OB_DBA_OB_TASK_OPT_STAT_GATHER_HISTORY_ORA_TID = 25227; // "DBA_OB_TASK_OPT_STAT_GATHER_HISTORY_ORA"
const uint64_t OB_DBA_OB_TABLE_OPT_STAT_GATHER_HISTORY_ORA_TID = 25228; // "DBA_OB_TABLE_OPT_STAT_GATHER_HISTORY_ORA"
const uint64_t OB_DBA_WR_ACTIVE_SESSION_HISTORY_ORA_TID = 25229; // "DBA_WR_ACTIVE_SESSION_HISTORY_ORA"
const uint64_t OB_DBA_WR_SNAPSHOT_ORA_TID = 25230; // "DBA_WR_SNAPSHOT_ORA"
const uint64_t OB_DBA_WR_STATNAME_ORA_TID = 25231; // "DBA_WR_STATNAME_ORA"
const uint64_t OB_DBA_WR_SYSSTAT_ORA_TID = 25232; // "DBA_WR_SYSSTAT_ORA"
const uint64_t OB_DBA_OB_LOG_RESTORE_SOURCE_ORA_TID = 25233; // "DBA_OB_LOG_RESTORE_SOURCE_ORA"
const uint64_t OB_DBA_OB_EXTERNAL_TABLE_FILES_ORA_TID = 25234; // "DBA_OB_EXTERNAL_TABLE_FILES_ORA"
const uint64_t OB_ALL_OB_EXTERNAL_TABLE_FILES_ORA_TID = 25235; // "ALL_OB_EXTERNAL_TABLE_FILES_ORA"
const uint64_t OB_DBA_OB_BALANCE_JOBS_ORA_TID = 25237; // "DBA_OB_BALANCE_JOBS_ORA"
const uint64_t OB_DBA_OB_BALANCE_JOB_HISTORY_ORA_TID = 25238; // "DBA_OB_BALANCE_JOB_HISTORY_ORA"
const uint64_t OB_DBA_OB_BALANCE_TASKS_ORA_TID = 25239; // "DBA_OB_BALANCE_TASKS_ORA"
const uint64_t OB_DBA_OB_BALANCE_TASK_HISTORY_ORA_TID = 25240; // "DBA_OB_BALANCE_TASK_HISTORY_ORA"
const uint64_t OB_DBA_OB_TRANSFER_TASKS_ORA_TID = 25241; // "DBA_OB_TRANSFER_TASKS_ORA"
const uint64_t OB_DBA_OB_TRANSFER_TASK_HISTORY_ORA_TID = 25242; // "DBA_OB_TRANSFER_TASK_HISTORY_ORA"
const uint64_t OB_GV_OB_PX_P2P_DATAHUB_ORA_TID = 25243; // "GV$OB_PX_P2P_DATAHUB_ORA"
const uint64_t OB_V_OB_PX_P2P_DATAHUB_ORA_TID = 25244; // "V$OB_PX_P2P_DATAHUB_ORA"
const uint64_t OB_GV_SQL_JOIN_FILTER_ORA_TID = 25245; // "GV$SQL_JOIN_FILTER_ORA"
const uint64_t OB_V_SQL_JOIN_FILTER_ORA_TID = 25246; // "V$SQL_JOIN_FILTER_ORA"
const uint64_t OB_DBA_OB_TABLE_STAT_STALE_INFO_ORA_TID = 25247; // "DBA_OB_TABLE_STAT_STALE_INFO_ORA"
const uint64_t OB_DBMS_LOCK_ALLOCATED_ORA_TID = 25256; // "DBMS_LOCK_ALLOCATED_ORA"
const uint64_t OB_DBA_WR_CONTROL_ORA_TID = 25257; // "DBA_WR_CONTROL_ORA"
const uint64_t OB_DBA_OB_LS_HISTORY_ORA_TID = 25258; // "DBA_OB_LS_HISTORY_ORA"
const uint64_t OB_DBA_OB_TENANT_EVENT_HISTORY_ORA_TID = 25259; // "DBA_OB_TENANT_EVENT_HISTORY_ORA"
const uint64_t OB_DBA_SCHEDULER_JOB_RUN_DETAILS_ORA_TID = 25260; // "DBA_SCHEDULER_JOB_RUN_DETAILS_ORA"
const uint64_t OB_DBA_SCHEDULER_JOB_CLASSES_TID = 25261; // "DBA_SCHEDULER_JOB_CLASSES"
const uint64_t OB_DBA_OB_RECOVER_TABLE_JOBS_ORA_TID = 25262; // "DBA_OB_RECOVER_TABLE_JOBS_ORA"
const uint64_t OB_DBA_OB_RECOVER_TABLE_JOB_HISTORY_ORA_TID = 25263; // "DBA_OB_RECOVER_TABLE_JOB_HISTORY_ORA"
const uint64_t OB_DBA_OB_IMPORT_TABLE_JOBS_ORA_TID = 25264; // "DBA_OB_IMPORT_TABLE_JOBS_ORA"
const uint64_t OB_DBA_OB_IMPORT_TABLE_JOB_HISTORY_ORA_TID = 25265; // "DBA_OB_IMPORT_TABLE_JOB_HISTORY_ORA"
const uint64_t OB_DBA_OB_IMPORT_TABLE_TASKS_ORA_TID = 25266; // "DBA_OB_IMPORT_TABLE_TASKS_ORA"
const uint64_t OB_DBA_OB_IMPORT_TABLE_TASK_HISTORY_ORA_TID = 25267; // "DBA_OB_IMPORT_TABLE_TASK_HISTORY_ORA"
const uint64_t OB_DBA_WR_SYSTEM_EVENT_ORA_TID = 25269; // "DBA_WR_SYSTEM_EVENT_ORA"
const uint64_t OB_DBA_WR_EVENT_NAME_ORA_TID = 25270; // "DBA_WR_EVENT_NAME_ORA"
const uint64_t OB_DBA_OB_FORMAT_OUTLINES_ORA_TID = 25272; // "DBA_OB_FORMAT_OUTLINES_ORA"
const uint64_t OB_DBA_WR_SQLSTAT_ORA_TID = 25273; // "DBA_WR_SQLSTAT_ORA"
const uint64_t OB_DBA_WR_SYS_TIME_MODEL_ORA_TID = 25274; // "DBA_WR_SYS_TIME_MODEL_ORA"
const uint64_t OB_DBA_OB_TRANSFER_PARTITION_TASKS_ORA_TID = 25275; // "DBA_OB_TRANSFER_PARTITION_TASKS_ORA"
const uint64_t OB_DBA_OB_TRANSFER_PARTITION_TASK_HISTORY_ORA_TID = 25276; // "DBA_OB_TRANSFER_PARTITION_TASK_HISTORY_ORA"
const uint64_t OB_DBA_WR_SQLTEXT_ORA_TID = 25277; // "DBA_WR_SQLTEXT_ORA"
const uint64_t OB_USER_USERS_TID = 25278; // "USER_USERS"
const uint64_t OB_DBA_OB_LS_REPLICA_TASK_HISTORY_ORA_TID = 25279; // "DBA_OB_LS_REPLICA_TASK_HISTORY_ORA"
const uint64_t OB_DBA_MVIEW_LOGS_ORA_TID = 25283; // "DBA_MVIEW_LOGS_ORA"
const uint64_t OB_ALL_MVIEW_LOGS_ORA_TID = 25284; // "ALL_MVIEW_LOGS_ORA"
const uint64_t OB_USER_MVIEW_LOGS_ORA_TID = 25285; // "USER_MVIEW_LOGS_ORA"
const uint64_t OB_DBA_MVIEWS_ORA_TID = 25286; // "DBA_MVIEWS_ORA"
const uint64_t OB_ALL_MVIEWS_ORA_TID = 25287; // "ALL_MVIEWS_ORA"
const uint64_t OB_USER_MVIEWS_ORA_TID = 25288; // "USER_MVIEWS_ORA"
const uint64_t OB_DBA_MVREF_STATS_SYS_DEFAULTS_ORA_TID = 25289; // "DBA_MVREF_STATS_SYS_DEFAULTS_ORA"
const uint64_t OB_USER_MVREF_STATS_SYS_DEFAULTS_ORA_TID = 25290; // "USER_MVREF_STATS_SYS_DEFAULTS_ORA"
const uint64_t OB_DBA_MVREF_STATS_PARAMS_ORA_TID = 25291; // "DBA_MVREF_STATS_PARAMS_ORA"
const uint64_t OB_USER_MVREF_STATS_PARAMS_ORA_TID = 25292; // "USER_MVREF_STATS_PARAMS_ORA"
const uint64_t OB_DBA_MVREF_RUN_STATS_ORA_TID = 25293; // "DBA_MVREF_RUN_STATS_ORA"
const uint64_t OB_USER_MVREF_RUN_STATS_ORA_TID = 25294; // "USER_MVREF_RUN_STATS_ORA"
const uint64_t OB_DBA_MVREF_STATS_ORA_TID = 25295; // "DBA_MVREF_STATS_ORA"
const uint64_t OB_USER_MVREF_STATS_ORA_TID = 25296; // "USER_MVREF_STATS_ORA"
const uint64_t OB_DBA_MVREF_CHANGE_STATS_ORA_TID = 25297; // "DBA_MVREF_CHANGE_STATS_ORA"
const uint64_t OB_USER_MVREF_CHANGE_STATS_ORA_TID = 25298; // "USER_MVREF_CHANGE_STATS_ORA"
const uint64_t OB_DBA_MVREF_STMT_STATS_ORA_TID = 25299; // "DBA_MVREF_STMT_STATS_ORA"
const uint64_t OB_USER_MVREF_STMT_STATS_ORA_TID = 25300; // "USER_MVREF_STMT_STATS_ORA"
const uint64_t OB_PROXY_USERS_TID = 25301; // "PROXY_USERS"
const uint64_t OB_DBA_OB_SERVICES_ORA_TID = 25302; // "DBA_OB_SERVICES_ORA"
const uint64_t OB_DBA_OB_STORAGE_IO_USAGE_ORA_TID = 25303; // "DBA_OB_STORAGE_IO_USAGE_ORA"
const uint64_t OB_USER_SCHEDULER_JOBS_ORA_TID = 25305; // "USER_SCHEDULER_JOBS_ORA"
const uint64_t OB_GV_OB_SQL_AUDIT_ORA_TID = 28002; // "GV$OB_SQL_AUDIT_ORA"
const uint64_t OB_V_OB_SQL_AUDIT_ORA_TID = 28003; // "V$OB_SQL_AUDIT_ORA"
const uint64_t OB_GV_INSTANCE_TID = 28004; // "GV$INSTANCE"
const uint64_t OB_V_INSTANCE_TID = 28005; // "V$INSTANCE"
const uint64_t OB_GV_OB_PLAN_CACHE_PLAN_STAT_ORA_TID = 28006; // "GV$OB_PLAN_CACHE_PLAN_STAT_ORA"
const uint64_t OB_V_OB_PLAN_CACHE_PLAN_STAT_ORA_TID = 28007; // "V$OB_PLAN_CACHE_PLAN_STAT_ORA"
const uint64_t OB_GV_OB_PLAN_CACHE_PLAN_EXPLAIN_ORA_TID = 28008; // "GV$OB_PLAN_CACHE_PLAN_EXPLAIN_ORA"
const uint64_t OB_V_OB_PLAN_CACHE_PLAN_EXPLAIN_ORA_TID = 28009; // "V$OB_PLAN_CACHE_PLAN_EXPLAIN_ORA"
const uint64_t OB_GV_SESSION_WAIT_ORA_TID = 28010; // "GV$SESSION_WAIT_ORA"
const uint64_t OB_V_SESSION_WAIT_ORA_TID = 28011; // "V$SESSION_WAIT_ORA"
const uint64_t OB_GV_SESSION_WAIT_HISTORY_ORA_TID = 28012; // "GV$SESSION_WAIT_HISTORY_ORA"
const uint64_t OB_V_SESSION_WAIT_HISTORY_ORA_TID = 28013; // "V$SESSION_WAIT_HISTORY_ORA"
const uint64_t OB_GV_OB_MEMORY_ORA_TID = 28014; // "GV$OB_MEMORY_ORA"
const uint64_t OB_V_OB_MEMORY_ORA_TID = 28015; // "V$OB_MEMORY_ORA"
const uint64_t OB_GV_OB_MEMSTORE_ORA_TID = 28016; // "GV$OB_MEMSTORE_ORA"
const uint64_t OB_V_OB_MEMSTORE_ORA_TID = 28017; // "V$OB_MEMSTORE_ORA"
const uint64_t OB_GV_OB_MEMSTORE_INFO_ORA_TID = 28018; // "GV$OB_MEMSTORE_INFO_ORA"
const uint64_t OB_V_OB_MEMSTORE_INFO_ORA_TID = 28019; // "V$OB_MEMSTORE_INFO_ORA"
const uint64_t OB_GV_SESSTAT_ORA_TID = 28021; // "GV$SESSTAT_ORA"
const uint64_t OB_V_SESSTAT_ORA_TID = 28022; // "V$SESSTAT_ORA"
const uint64_t OB_GV_SYSSTAT_ORA_TID = 28023; // "GV$SYSSTAT_ORA"
const uint64_t OB_V_SYSSTAT_ORA_TID = 28024; // "V$SYSSTAT_ORA"
const uint64_t OB_GV_SYSTEM_EVENT_ORA_TID = 28025; // "GV$SYSTEM_EVENT_ORA"
const uint64_t OB_V_SYSTEM_EVENT_ORA_TID = 28026; // "V$SYSTEM_EVENT_ORA"
const uint64_t OB_GV_OB_PLAN_CACHE_STAT_ORA_TID = 28029; // "GV$OB_PLAN_CACHE_STAT_ORA"
const uint64_t OB_V_OB_PLAN_CACHE_STAT_ORA_TID = 28030; // "V$OB_PLAN_CACHE_STAT_ORA"
const uint64_t OB_NLS_SESSION_PARAMETERS_ORA_TID = 28032; // "NLS_SESSION_PARAMETERS_ORA"
const uint64_t OB_NLS_INSTANCE_PARAMETERS_ORA_TID = 28033; // "NLS_INSTANCE_PARAMETERS_ORA"
const uint64_t OB_NLS_DATABASE_PARAMETERS_ORA_TID = 28034; // "NLS_DATABASE_PARAMETERS_ORA"
const uint64_t OB_V_NLS_PARAMETERS_ORA_TID = 28035; // "V$NLS_PARAMETERS_ORA"
const uint64_t OB_V_VERSION_ORA_TID = 28036; // "V$VERSION_ORA"
const uint64_t OB_GV_OB_PX_WORKER_STAT_ORA_TID = 28037; // "GV$OB_PX_WORKER_STAT_ORA"
const uint64_t OB_V_OB_PX_WORKER_STAT_ORA_TID = 28038; // "V$OB_PX_WORKER_STAT_ORA"
const uint64_t OB_GV_OB_PS_STAT_ORA_TID = 28039; // "GV$OB_PS_STAT_ORA"
const uint64_t OB_V_OB_PS_STAT_ORA_TID = 28040; // "V$OB_PS_STAT_ORA"
const uint64_t OB_GV_OB_PS_ITEM_INFO_ORA_TID = 28041; // "GV$OB_PS_ITEM_INFO_ORA"
const uint64_t OB_V_OB_PS_ITEM_INFO_ORA_TID = 28042; // "V$OB_PS_ITEM_INFO_ORA"
const uint64_t OB_GV_SQL_WORKAREA_ACTIVE_ORA_TID = 28045; // "GV$SQL_WORKAREA_ACTIVE_ORA"
const uint64_t OB_V_SQL_WORKAREA_ACTIVE_ORA_TID = 28046; // "V$SQL_WORKAREA_ACTIVE_ORA"
const uint64_t OB_GV_SQL_WORKAREA_HISTOGRAM_ORA_TID = 28047; // "GV$SQL_WORKAREA_HISTOGRAM_ORA"
const uint64_t OB_V_SQL_WORKAREA_HISTOGRAM_ORA_TID = 28048; // "V$SQL_WORKAREA_HISTOGRAM_ORA"
const uint64_t OB_GV_OB_SQL_WORKAREA_MEMORY_INFO_ORA_TID = 28049; // "GV$OB_SQL_WORKAREA_MEMORY_INFO_ORA"
const uint64_t OB_V_OB_SQL_WORKAREA_MEMORY_INFO_ORA_TID = 28050; // "V$OB_SQL_WORKAREA_MEMORY_INFO_ORA"
const uint64_t OB_GV_OB_PLAN_CACHE_REFERENCE_INFO_ORA_TID = 28051; // "GV$OB_PLAN_CACHE_REFERENCE_INFO_ORA"
const uint64_t OB_V_OB_PLAN_CACHE_REFERENCE_INFO_ORA_TID = 28052; // "V$OB_PLAN_CACHE_REFERENCE_INFO_ORA"
const uint64_t OB_GV_SQL_WORKAREA_ORA_TID = 28053; // "GV$SQL_WORKAREA_ORA"
const uint64_t OB_V_SQL_WORKAREA_ORA_TID = 28054; // "V$SQL_WORKAREA_ORA"
const uint64_t OB_GV_OB_SSTABLES_ORA_TID = 28055; // "GV$OB_SSTABLES_ORA"
const uint64_t OB_V_OB_SSTABLES_ORA_TID = 28056; // "V$OB_SSTABLES_ORA"
const uint64_t OB_GV_OB_SERVER_SCHEMA_INFO_ORA_TID = 28057; // "GV$OB_SERVER_SCHEMA_INFO_ORA"
const uint64_t OB_V_OB_SERVER_SCHEMA_INFO_ORA_TID = 28058; // "V$OB_SERVER_SCHEMA_INFO_ORA"
const uint64_t OB_GV_SQL_PLAN_MONITOR_ORA_TID = 28059; // "GV$SQL_PLAN_MONITOR_ORA"
const uint64_t OB_V_SQL_PLAN_MONITOR_ORA_TID = 28060; // "V$SQL_PLAN_MONITOR_ORA"
const uint64_t OB_V_SQL_MONITOR_STATNAME_ORA_TID = 28061; // "V$SQL_MONITOR_STATNAME_ORA"
const uint64_t OB_GV_OPEN_CURSOR_ORA_TID = 28064; // "GV$OPEN_CURSOR_ORA"
const uint64_t OB_V_OPEN_CURSOR_ORA_TID = 28065; // "V$OPEN_CURSOR_ORA"
const uint64_t OB_V_TIMEZONE_NAMES_ORA_TID = 28066; // "V$TIMEZONE_NAMES_ORA"
const uint64_t OB_GV_GLOBAL_TRANSACTION_ORA_TID = 28067; // "GV$GLOBAL_TRANSACTION_ORA"
const uint64_t OB_V_GLOBAL_TRANSACTION_ORA_TID = 28068; // "V$GLOBAL_TRANSACTION_ORA"
const uint64_t OB_V_RSRC_PLAN_ORA_TID = 28070; // "V$RSRC_PLAN_ORA"
const uint64_t OB_V_OB_ENCRYPTED_TABLES_ORA_TID = 28072; // "V$OB_ENCRYPTED_TABLES_ORA"
const uint64_t OB_V_ENCRYPTED_TABLESPACES_ORA_TID = 28073; // "V$ENCRYPTED_TABLESPACES_ORA"
const uint64_t OB_ALL_TAB_COL_STATISTICS_ORA_TID = 28074; // "ALL_TAB_COL_STATISTICS_ORA"
const uint64_t OB_DBA_TAB_COL_STATISTICS_ORA_TID = 28075; // "DBA_TAB_COL_STATISTICS_ORA"
const uint64_t OB_USER_TAB_COL_STATISTICS_ORA_TID = 28076; // "USER_TAB_COL_STATISTICS_ORA"
const uint64_t OB_ALL_PART_COL_STATISTICS_ORA_TID = 28077; // "ALL_PART_COL_STATISTICS_ORA"
const uint64_t OB_DBA_PART_COL_STATISTICS_ORA_TID = 28078; // "DBA_PART_COL_STATISTICS_ORA"
const uint64_t OB_USER_PART_COL_STATISTICS_ORA_TID = 28079; // "USER_PART_COL_STATISTICS_ORA"
const uint64_t OB_ALL_SUBPART_COL_STATISTICS_ORA_TID = 28080; // "ALL_SUBPART_COL_STATISTICS_ORA"
const uint64_t OB_DBA_SUBPART_COL_STATISTICS_ORA_TID = 28081; // "DBA_SUBPART_COL_STATISTICS_ORA"
const uint64_t OB_USER_SUBPART_COL_STATISTICS_ORA_TID = 28082; // "USER_SUBPART_COL_STATISTICS_ORA"
const uint64_t OB_ALL_TAB_HISTOGRAMS_ORA_TID = 28083; // "ALL_TAB_HISTOGRAMS_ORA"
const uint64_t OB_DBA_TAB_HISTOGRAMS_ORA_TID = 28084; // "DBA_TAB_HISTOGRAMS_ORA"
const uint64_t OB_USER_TAB_HISTOGRAMS_ORA_TID = 28085; // "USER_TAB_HISTOGRAMS_ORA"
const uint64_t OB_ALL_PART_HISTOGRAMS_ORA_TID = 28086; // "ALL_PART_HISTOGRAMS_ORA"
const uint64_t OB_DBA_PART_HISTOGRAMS_ORA_TID = 28087; // "DBA_PART_HISTOGRAMS_ORA"
const uint64_t OB_USER_PART_HISTOGRAMS_ORA_TID = 28088; // "USER_PART_HISTOGRAMS_ORA"
const uint64_t OB_ALL_SUBPART_HISTOGRAMS_ORA_TID = 28089; // "ALL_SUBPART_HISTOGRAMS_ORA"
const uint64_t OB_DBA_SUBPART_HISTOGRAMS_ORA_TID = 28090; // "DBA_SUBPART_HISTOGRAMS_ORA"
const uint64_t OB_USER_SUBPART_HISTOGRAMS_ORA_TID = 28091; // "USER_SUBPART_HISTOGRAMS_ORA"
const uint64_t OB_ALL_TAB_STATISTICS_ORA_TID = 28092; // "ALL_TAB_STATISTICS_ORA"
const uint64_t OB_DBA_TAB_STATISTICS_ORA_TID = 28093; // "DBA_TAB_STATISTICS_ORA"
const uint64_t OB_USER_TAB_STATISTICS_ORA_TID = 28094; // "USER_TAB_STATISTICS_ORA"
const uint64_t OB_DBA_JOBS_TID = 28096; // "DBA_JOBS"
const uint64_t OB_USER_JOBS_TID = 28097; // "USER_JOBS"
const uint64_t OB_DBA_JOBS_RUNNING_TID = 28098; // "DBA_JOBS_RUNNING"
const uint64_t OB_ALL_DIRECTORIES_TID = 28099; // "ALL_DIRECTORIES"
const uint64_t OB_DBA_DIRECTORIES_TID = 28100; // "DBA_DIRECTORIES"
const uint64_t OB_GV_OB_TENANT_MEMORY_ORA_TID = 28101; // "GV$OB_TENANT_MEMORY_ORA"
const uint64_t OB_V_OB_TENANT_MEMORY_ORA_TID = 28102; // "V$OB_TENANT_MEMORY_ORA"
const uint64_t OB_GV_OB_PX_TARGET_MONITOR_ORA_TID = 28103; // "GV$OB_PX_TARGET_MONITOR_ORA"
const uint64_t OB_V_OB_PX_TARGET_MONITOR_ORA_TID = 28104; // "V$OB_PX_TARGET_MONITOR_ORA"
const uint64_t OB_ALL_TAB_STATS_HISTORY_ORA_TID = 28105; // "ALL_TAB_STATS_HISTORY_ORA"
const uint64_t OB_DBA_TAB_STATS_HISTORY_ORA_TID = 28106; // "DBA_TAB_STATS_HISTORY_ORA"
const uint64_t OB_USER_TAB_STATS_HISTORY_ORA_TID = 28107; // "USER_TAB_STATS_HISTORY_ORA"
const uint64_t OB_GV_DBLINK_TID = 28108; // "GV$DBLINK"
const uint64_t OB_V_DBLINK_TID = 28109; // "V$DBLINK"
const uint64_t OB_DBA_SCHEDULER_JOBS_ORA_TID = 28110; // "DBA_SCHEDULER_JOBS_ORA"
const uint64_t OB_DBA_SCHEDULER_PROGRAM_TID = 28111; // "DBA_SCHEDULER_PROGRAM"
const uint64_t OB_DBA_CONTEXT_TID = 28112; // "DBA_CONTEXT"
const uint64_t OB_V_GLOBALCONTEXT_TID = 28113; // "V$GLOBALCONTEXT"
const uint64_t OB_GV_OB_UNITS_ORA_TID = 28114; // "GV$OB_UNITS_ORA"
const uint64_t OB_V_OB_UNITS_ORA_TID = 28115; // "V$OB_UNITS_ORA"
const uint64_t OB_GV_OB_PARAMETERS_ORA_TID = 28116; // "GV$OB_PARAMETERS_ORA"
const uint64_t OB_V_OB_PARAMETERS_ORA_TID = 28117; // "V$OB_PARAMETERS_ORA"
const uint64_t OB_GV_OB_PROCESSLIST_ORA_TID = 28118; // "GV$OB_PROCESSLIST_ORA"
const uint64_t OB_V_OB_PROCESSLIST_ORA_TID = 28119; // "V$OB_PROCESSLIST_ORA"
const uint64_t OB_GV_OB_KVCACHE_ORA_TID = 28120; // "GV$OB_KVCACHE_ORA"
const uint64_t OB_V_OB_KVCACHE_ORA_TID = 28121; // "V$OB_KVCACHE_ORA"
const uint64_t OB_GV_OB_TRANSACTION_PARTICIPANTS_ORA_TID = 28122; // "GV$OB_TRANSACTION_PARTICIPANTS_ORA"
const uint64_t OB_V_OB_TRANSACTION_PARTICIPANTS_ORA_TID = 28123; // "V$OB_TRANSACTION_PARTICIPANTS_ORA"
const uint64_t OB_GV_OB_COMPACTION_PROGRESS_ORA_TID = 28124; // "GV$OB_COMPACTION_PROGRESS_ORA"
const uint64_t OB_V_OB_COMPACTION_PROGRESS_ORA_TID = 28125; // "V$OB_COMPACTION_PROGRESS_ORA"
const uint64_t OB_GV_OB_TABLET_COMPACTION_PROGRESS_ORA_TID = 28126; // "GV$OB_TABLET_COMPACTION_PROGRESS_ORA"
const uint64_t OB_V_OB_TABLET_COMPACTION_PROGRESS_ORA_TID = 28127; // "V$OB_TABLET_COMPACTION_PROGRESS_ORA"
const uint64_t OB_GV_OB_TABLET_COMPACTION_HISTORY_ORA_TID = 28128; // "GV$OB_TABLET_COMPACTION_HISTORY_ORA"
const uint64_t OB_V_OB_TABLET_COMPACTION_HISTORY_ORA_TID = 28129; // "V$OB_TABLET_COMPACTION_HISTORY_ORA"
const uint64_t OB_GV_OB_COMPACTION_DIAGNOSE_INFO_ORA_TID = 28130; // "GV$OB_COMPACTION_DIAGNOSE_INFO_ORA"
const uint64_t OB_V_OB_COMPACTION_DIAGNOSE_INFO_ORA_TID = 28131; // "V$OB_COMPACTION_DIAGNOSE_INFO_ORA"
const uint64_t OB_GV_OB_COMPACTION_SUGGESTIONS_ORA_TID = 28132; // "GV$OB_COMPACTION_SUGGESTIONS_ORA"
const uint64_t OB_V_OB_COMPACTION_SUGGESTIONS_ORA_TID = 28133; // "V$OB_COMPACTION_SUGGESTIONS_ORA"
const uint64_t OB_GV_OB_DTL_INTERM_RESULT_MONITOR_ORA_TID = 28134; // "GV$OB_DTL_INTERM_RESULT_MONITOR_ORA"
const uint64_t OB_V_OB_DTL_INTERM_RESULT_MONITOR_ORA_TID = 28135; // "V$OB_DTL_INTERM_RESULT_MONITOR_ORA"
const uint64_t OB_DBA_SQL_PLAN_BASELINES_ORA_TID = 28136; // "DBA_SQL_PLAN_BASELINES_ORA"
const uint64_t OB_DBA_SQL_MANAGEMENT_CONFIG_ORA_TID = 28137; // "DBA_SQL_MANAGEMENT_CONFIG_ORA"
const uint64_t OB_V_EVENT_NAME_ORA_TID = 28138; // "V$EVENT_NAME_ORA"
const uint64_t OB_GV_ACTIVE_SESSION_HISTORY_ORA_TID = 28139; // "GV$ACTIVE_SESSION_HISTORY_ORA"
const uint64_t OB_V_ACTIVE_SESSION_HISTORY_ORA_TID = 28140; // "V$ACTIVE_SESSION_HISTORY_ORA"
const uint64_t OB_GV_DML_STATS_ORA_TID = 28141; // "GV$DML_STATS_ORA"
const uint64_t OB_V_DML_STATS_ORA_TID = 28142; // "V$DML_STATS_ORA"
const uint64_t OB_DBA_OB_OUTLINE_CONCURRENT_HISTORY_ORA_TID = 28143; // "DBA_OB_OUTLINE_CONCURRENT_HISTORY_ORA"
const uint64_t OB_DBA_OB_OUTLINES_ORA_TID = 28144; // "DBA_OB_OUTLINES_ORA"
const uint64_t OB_DBA_OB_CONCURRENT_LIMIT_SQL_ORA_TID = 28145; // "DBA_OB_CONCURRENT_LIMIT_SQL_ORA"
const uint64_t OB_DBA_OB_DEADLOCK_EVENT_HISTORY_ORA_TID = 28146; // "DBA_OB_DEADLOCK_EVENT_HISTORY_ORA"
const uint64_t OB_GV_OB_LOG_STAT_ORA_TID = 28147; // "GV$OB_LOG_STAT_ORA"
const uint64_t OB_V_OB_LOG_STAT_ORA_TID = 28148; // "V$OB_LOG_STAT_ORA"
const uint64_t OB_GV_OB_GLOBAL_TRANSACTION_ORA_TID = 28149; // "GV$OB_GLOBAL_TRANSACTION_ORA"
const uint64_t OB_V_OB_GLOBAL_TRANSACTION_ORA_TID = 28150; // "V$OB_GLOBAL_TRANSACTION_ORA"
const uint64_t OB_DBA_OB_LS_ORA_TID = 28151; // "DBA_OB_LS_ORA"
const uint64_t OB_DBA_OB_TABLE_LOCATIONS_ORA_TID = 28152; // "DBA_OB_TABLE_LOCATIONS_ORA"
const uint64_t OB_ALL_TRIGGER_ORDERING_TID = 28155; // "ALL_TRIGGER_ORDERING"
const uint64_t OB_DBA_TRIGGER_ORDERING_TID = 28156; // "DBA_TRIGGER_ORDERING"
const uint64_t OB_USER_TRIGGER_ORDERING_TID = 28157; // "USER_TRIGGER_ORDERING"
const uint64_t OB_GV_OB_TRANSACTION_SCHEDULERS_ORA_TID = 28159; // "GV$OB_TRANSACTION_SCHEDULERS_ORA"
const uint64_t OB_V_OB_TRANSACTION_SCHEDULERS_ORA_TID = 28160; // "V$OB_TRANSACTION_SCHEDULERS_ORA"
const uint64_t OB_DBA_OB_USER_DEFINED_RULES_ORA_TID = 28171; // "DBA_OB_USER_DEFINED_RULES_ORA"
const uint64_t OB_GV_OB_SQL_PLAN_ORA_TID = 28172; // "GV$OB_SQL_PLAN_ORA"
const uint64_t OB_V_OB_SQL_PLAN_ORA_TID = 28173; // "V$OB_SQL_PLAN_ORA"
const uint64_t OB_V_OB_ARCHIVE_DEST_STATUS_ORA_TID = 28176; // "V$OB_ARCHIVE_DEST_STATUS_ORA"
const uint64_t OB_DBA_OB_LS_LOG_ARCHIVE_PROGRESS_ORA_TID = 28177; // "DBA_OB_LS_LOG_ARCHIVE_PROGRESS_ORA"
const uint64_t OB_GV_OB_LOCKS_ORA_TID = 28179; // "GV$OB_LOCKS_ORA"
const uint64_t OB_V_OB_LOCKS_ORA_TID = 28180; // "V$OB_LOCKS_ORA"
const uint64_t OB_DBA_OB_ACCESS_POINT_ORA_TID = 28181; // "DBA_OB_ACCESS_POINT_ORA"
const uint64_t OB_DBA_OB_DATA_DICTIONARY_IN_LOG_ORA_TID = 28182; // "DBA_OB_DATA_DICTIONARY_IN_LOG_ORA"
const uint64_t OB_GV_OB_OPT_STAT_GATHER_MONITOR_ORA_TID = 28183; // "GV$OB_OPT_STAT_GATHER_MONITOR_ORA"
const uint64_t OB_V_OB_OPT_STAT_GATHER_MONITOR_ORA_TID = 28184; // "V$OB_OPT_STAT_GATHER_MONITOR_ORA"
const uint64_t OB_GV_SESSION_LONGOPS_ORA_TID = 28185; // "GV$SESSION_LONGOPS_ORA"
const uint64_t OB_V_SESSION_LONGOPS_ORA_TID = 28186; // "V$SESSION_LONGOPS_ORA"
const uint64_t OB_GV_OB_THREAD_ORA_TID = 28187; // "GV$OB_THREAD_ORA"
const uint64_t OB_V_OB_THREAD_ORA_TID = 28188; // "V$OB_THREAD_ORA"
const uint64_t OB_GV_OB_ARBITRATION_MEMBER_INFO_ORA_TID = 28189; // "GV$OB_ARBITRATION_MEMBER_INFO_ORA"
const uint64_t OB_V_OB_ARBITRATION_MEMBER_INFO_ORA_TID = 28190; // "V$OB_ARBITRATION_MEMBER_INFO_ORA"
const uint64_t OB_GV_OB_ARBITRATION_SERVICE_STATUS_ORA_TID = 28191; // "GV$OB_ARBITRATION_SERVICE_STATUS_ORA"
const uint64_t OB_V_OB_ARBITRATION_SERVICE_STATUS_ORA_TID = 28192; // "V$OB_ARBITRATION_SERVICE_STATUS_ORA"
const uint64_t OB_V_OB_TIMESTAMP_SERVICE_ORA_TID = 28193; // "V$OB_TIMESTAMP_SERVICE_ORA"
const uint64_t OB_V_OB_LS_LOG_RESTORE_STATUS_ORA_TID = 28194; // "V$OB_LS_LOG_RESTORE_STATUS_ORA"
const uint64_t OB_GV_OB_FLT_TRACE_CONFIG_ORA_TID = 28195; // "GV$OB_FLT_TRACE_CONFIG_ORA"
const uint64_t OB_GV_OB_SESSION_ORA_TID = 28196; // "GV$OB_SESSION_ORA"
const uint64_t OB_V_OB_SESSION_ORA_TID = 28197; // "V$OB_SESSION_ORA"
const uint64_t OB_GV_OB_PL_CACHE_OBJECT_ORA_TID = 28198; // "GV$OB_PL_CACHE_OBJECT_ORA"
const uint64_t OB_V_OB_PL_CACHE_OBJECT_ORA_TID = 28199; // "V$OB_PL_CACHE_OBJECT_ORA"
const uint64_t OB_GV_OB_CGROUP_CONFIG_ORA_TID = 28200; // "GV$OB_CGROUP_CONFIG_ORA"
const uint64_t OB_V_OB_CGROUP_CONFIG_ORA_TID = 28201; // "V$OB_CGROUP_CONFIG_ORA"
const uint64_t OB_GV_OB_SQLSTAT_ORA_TID = 28203; // "GV$OB_SQLSTAT_ORA"
const uint64_t OB_V_OB_SQLSTAT_ORA_TID = 28204; // "V$OB_SQLSTAT_ORA"
const uint64_t OB_GV_OB_SESS_TIME_MODEL_ORA_TID = 28205; // "GV$OB_SESS_TIME_MODEL_ORA"
const uint64_t OB_V_OB_SESS_TIME_MODEL_ORA_TID = 28206; // "V$OB_SESS_TIME_MODEL_ORA"
const uint64_t OB_GV_OB_SYS_TIME_MODEL_ORA_TID = 28207; // "GV$OB_SYS_TIME_MODEL_ORA"
const uint64_t OB_V_OB_SYS_TIME_MODEL_ORA_TID = 28208; // "V$OB_SYS_TIME_MODEL_ORA"
const uint64_t OB_V_STATNAME_ORA_TID = 28209; // "V$STATNAME_ORA"
const uint64_t OB_DBA_OB_AUX_STATISTICS_ORA_TID = 28210; // "DBA_OB_AUX_STATISTICS_ORA"
const uint64_t OB_DBA_OB_SYS_VARIABLES_ORA_TID = 28211; // "DBA_OB_SYS_VARIABLES_ORA"
const uint64_t OB_GV_OB_ACTIVE_SESSION_HISTORY_ORA_TID = 28212; // "GV$OB_ACTIVE_SESSION_HISTORY_ORA"
const uint64_t OB_V_OB_ACTIVE_SESSION_HISTORY_ORA_TID = 28213; // "V$OB_ACTIVE_SESSION_HISTORY_ORA"
const uint64_t OB_DBA_INDEX_USAGE_ORA_TID = 28214; // "DBA_INDEX_USAGE_ORA"
const uint64_t OB_GV_OB_LS_SNAPSHOTS_ORA_TID = 28215; // "GV$OB_LS_SNAPSHOTS_ORA"
const uint64_t OB_V_OB_LS_SNAPSHOTS_ORA_TID = 28216; // "V$OB_LS_SNAPSHOTS_ORA"
const uint64_t OB_GV_OB_SHARED_STORAGE_QUOTA_ORA_TID = 28217; // "GV$OB_SHARED_STORAGE_QUOTA_ORA"
const uint64_t OB_V_OB_SHARED_STORAGE_QUOTA_ORA_TID = 28218; // "V$OB_SHARED_STORAGE_QUOTA_ORA"
const uint64_t OB_GV_OB_SESSION_PS_INFO_ORA_TID = 28219; // "GV$OB_SESSION_PS_INFO_ORA"
const uint64_t OB_V_OB_SESSION_PS_INFO_ORA_TID = 28220; // "V$OB_SESSION_PS_INFO_ORA"
const uint64_t OB_GV_OB_TRACEPOINT_INFO_ORA_TID = 28221; // "GV$OB_TRACEPOINT_INFO_ORA"
const uint64_t OB_V_OB_TRACEPOINT_INFO_ORA_TID = 28222; // "V$OB_TRACEPOINT_INFO_ORA"
const uint64_t OB_DBA_OB_RSRC_DIRECTIVES_ORA_TID = 28223; // "DBA_OB_RSRC_DIRECTIVES_ORA"
const uint64_t OB_GV_OB_TENANT_RESOURCE_LIMIT_ORA_TID = 28224; // "GV$OB_TENANT_RESOURCE_LIMIT_ORA"
const uint64_t OB_V_OB_TENANT_RESOURCE_LIMIT_ORA_TID = 28225; // "V$OB_TENANT_RESOURCE_LIMIT_ORA"
const uint64_t OB_GV_OB_TENANT_RESOURCE_LIMIT_DETAIL_ORA_TID = 28226; // "GV$OB_TENANT_RESOURCE_LIMIT_DETAIL_ORA"
const uint64_t OB_V_OB_TENANT_RESOURCE_LIMIT_DETAIL_ORA_TID = 28227; // "V$OB_TENANT_RESOURCE_LIMIT_DETAIL_ORA"
const uint64_t OB_V_OB_GROUP_IO_STAT_ORA_TID = 28228; // "V$OB_GROUP_IO_STAT_ORA"
const uint64_t OB_GV_OB_GROUP_IO_STAT_ORA_TID = 28229; // "GV$OB_GROUP_IO_STAT_ORA"
const uint64_t OB_GV_OB_NIC_INFO_ORA_TID = 28230; // "GV$OB_NIC_INFO_ORA"
const uint64_t OB_V_OB_NIC_INFO_ORA_TID = 28231; // "V$OB_NIC_INFO_ORA"
const uint64_t OB_GV_OB_QUERY_RESPONSE_TIME_HISTOGRAM_ORA_TID = 28232; // "GV$OB_QUERY_RESPONSE_TIME_HISTOGRAM_ORA"
const uint64_t OB_V_OB_QUERY_RESPONSE_TIME_HISTOGRAM_ORA_TID = 28233; // "V$OB_QUERY_RESPONSE_TIME_HISTOGRAM_ORA"
const uint64_t OB_DBA_OB_SPATIAL_COLUMNS_ORA_TID = 28234; // "DBA_OB_SPATIAL_COLUMNS_ORA"
const uint64_t OB_DBA_OB_TABLE_SPACE_USAGE_ORA_TID = 28237; // "DBA_OB_TABLE_SPACE_USAGE_ORA"
const uint64_t OB_GV_OB_LOG_TRANSPORT_DEST_STAT_ORA_TID = 28238; // "GV$OB_LOG_TRANSPORT_DEST_STAT_ORA"
const uint64_t OB_V_OB_LOG_TRANSPORT_DEST_STAT_ORA_TID = 28239; // "V$OB_LOG_TRANSPORT_DEST_STAT_ORA"
const uint64_t OB_GV_OB_SS_LOCAL_CACHE_ORA_TID = 28240; // "GV$OB_SS_LOCAL_CACHE_ORA"
const uint64_t OB_V_OB_SS_LOCAL_CACHE_ORA_TID = 28241; // "V$OB_SS_LOCAL_CACHE_ORA"
const uint64_t OB_ALL_PLSQL_TYPES_TID = 28244; // "ALL_PLSQL_TYPES"
const uint64_t OB_DBA_PLSQL_TYPES_TID = 28245; // "DBA_PLSQL_TYPES"
const uint64_t OB_USER_PLSQL_TYPES_TID = 28246; // "USER_PLSQL_TYPES"
const uint64_t OB_ALL_PLSQL_COLL_TYPES_TID = 28247; // "ALL_PLSQL_COLL_TYPES"
const uint64_t OB_DBA_PLSQL_COLL_TYPES_TID = 28248; // "DBA_PLSQL_COLL_TYPES"
const uint64_t OB_USER_PLSQL_COLL_TYPES_TID = 28249; // "USER_PLSQL_COLL_TYPES"
const uint64_t OB_ALL_PLSQL_TYPE_ATTRS_TID = 28250; // "ALL_PLSQL_TYPE_ATTRS"
const uint64_t OB_DBA_PLSQL_TYPE_ATTRS_TID = 28251; // "DBA_PLSQL_TYPE_ATTRS"
const uint64_t OB_USER_PLSQL_TYPE_ATTRS_TID = 28252; // "USER_PLSQL_TYPE_ATTRS"
const uint64_t OB_GV_OB_RES_MGR_SYSSTAT_ORA_TID = 28257; // "GV$OB_RES_MGR_SYSSTAT_ORA"
const uint64_t OB_V_OB_RES_MGR_SYSSTAT_ORA_TID = 28258; // "V$OB_RES_MGR_SYSSTAT_ORA"
const uint64_t OB_DBA_WR_SQL_PLAN_ORA_TID = 28259; // "DBA_WR_SQL_PLAN_ORA"
const uint64_t OB_DBA_OB_SPM_EVO_RESULT_ORA_TID = 28261; // "DBA_OB_SPM_EVO_RESULT_ORA"
const uint64_t OB_GV_OB_FUNCTION_IO_STAT_ORA_TID = 28262; // "GV$OB_FUNCTION_IO_STAT_ORA"
const uint64_t OB_V_OB_FUNCTION_IO_STAT_ORA_TID = 28263; // "V$OB_FUNCTION_IO_STAT_ORA"
const uint64_t OB_DBA_OB_TEMP_FILES_ORA_TID = 28264; // "DBA_OB_TEMP_FILES_ORA"
const uint64_t OB_DBA_OB_CS_REPLICA_STATS_ORA_TID = 28271; // "DBA_OB_CS_REPLICA_STATS_ORA"
const uint64_t OB_ALL_TABLE_AUX_LOB_META_TID = 50003; // "__all_table_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_AUX_LOB_META_TID = 50004; // "__all_column_aux_lob_meta"
const uint64_t OB_ALL_DDL_OPERATION_AUX_LOB_META_TID = 50005; // "__all_ddl_operation_aux_lob_meta"
const uint64_t OB_ALL_USER_AUX_LOB_META_TID = 50102; // "__all_user_aux_lob_meta"
const uint64_t OB_ALL_USER_HISTORY_AUX_LOB_META_TID = 50103; // "__all_user_history_aux_lob_meta"
const uint64_t OB_ALL_DATABASE_AUX_LOB_META_TID = 50104; // "__all_database_aux_lob_meta"
const uint64_t OB_ALL_DATABASE_HISTORY_AUX_LOB_META_TID = 50105; // "__all_database_history_aux_lob_meta"
const uint64_t OB_ALL_TABLEGROUP_AUX_LOB_META_TID = 50106; // "__all_tablegroup_aux_lob_meta"
const uint64_t OB_ALL_TABLEGROUP_HISTORY_AUX_LOB_META_TID = 50107; // "__all_tablegroup_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_AUX_LOB_META_TID = 50108; // "__all_tenant_aux_lob_meta"
const uint64_t OB_ALL_TENANT_HISTORY_AUX_LOB_META_TID = 50109; // "__all_tenant_history_aux_lob_meta"
const uint64_t OB_ALL_TABLE_PRIVILEGE_AUX_LOB_META_TID = 50110; // "__all_table_privilege_aux_lob_meta"
const uint64_t OB_ALL_TABLE_PRIVILEGE_HISTORY_AUX_LOB_META_TID = 50111; // "__all_table_privilege_history_aux_lob_meta"
const uint64_t OB_ALL_DATABASE_PRIVILEGE_AUX_LOB_META_TID = 50112; // "__all_database_privilege_aux_lob_meta"
const uint64_t OB_ALL_DATABASE_PRIVILEGE_HISTORY_AUX_LOB_META_TID = 50113; // "__all_database_privilege_history_aux_lob_meta"
const uint64_t OB_ALL_TABLE_HISTORY_AUX_LOB_META_TID = 50114; // "__all_table_history_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_HISTORY_AUX_LOB_META_TID = 50115; // "__all_column_history_aux_lob_meta"
const uint64_t OB_ALL_ZONE_AUX_LOB_META_TID = 50116; // "__all_zone_aux_lob_meta"
const uint64_t OB_ALL_SERVER_AUX_LOB_META_TID = 50117; // "__all_server_aux_lob_meta"
const uint64_t OB_ALL_SYS_PARAMETER_AUX_LOB_META_TID = 50118; // "__all_sys_parameter_aux_lob_meta"
const uint64_t OB_TENANT_PARAMETER_AUX_LOB_META_TID = 50119; // "__tenant_parameter_aux_lob_meta"
const uint64_t OB_ALL_SYS_VARIABLE_AUX_LOB_META_TID = 50120; // "__all_sys_variable_aux_lob_meta"
const uint64_t OB_ALL_SYS_STAT_AUX_LOB_META_TID = 50121; // "__all_sys_stat_aux_lob_meta"
const uint64_t OB_ALL_UNIT_AUX_LOB_META_TID = 50123; // "__all_unit_aux_lob_meta"
const uint64_t OB_ALL_UNIT_CONFIG_AUX_LOB_META_TID = 50124; // "__all_unit_config_aux_lob_meta"
const uint64_t OB_ALL_RESOURCE_POOL_AUX_LOB_META_TID = 50125; // "__all_resource_pool_aux_lob_meta"
const uint64_t OB_ALL_CHARSET_AUX_LOB_META_TID = 50128; // "__all_charset_aux_lob_meta"
const uint64_t OB_ALL_COLLATION_AUX_LOB_META_TID = 50129; // "__all_collation_aux_lob_meta"
const uint64_t OB_HELP_TOPIC_AUX_LOB_META_TID = 50130; // "help_topic_aux_lob_meta"
const uint64_t OB_HELP_CATEGORY_AUX_LOB_META_TID = 50131; // "help_category_aux_lob_meta"
const uint64_t OB_HELP_KEYWORD_AUX_LOB_META_TID = 50132; // "help_keyword_aux_lob_meta"
const uint64_t OB_HELP_RELATION_AUX_LOB_META_TID = 50133; // "help_relation_aux_lob_meta"
const uint64_t OB_ALL_DUMMY_AUX_LOB_META_TID = 50135; // "__all_dummy_aux_lob_meta"
const uint64_t OB_ALL_ROOTSERVICE_EVENT_HISTORY_AUX_LOB_META_TID = 50140; // "__all_rootservice_event_history_aux_lob_meta"
const uint64_t OB_ALL_PRIVILEGE_AUX_LOB_META_TID = 50141; // "__all_privilege_aux_lob_meta"
const uint64_t OB_ALL_OUTLINE_AUX_LOB_META_TID = 50142; // "__all_outline_aux_lob_meta"
const uint64_t OB_ALL_OUTLINE_HISTORY_AUX_LOB_META_TID = 50143; // "__all_outline_history_aux_lob_meta"
const uint64_t OB_ALL_RECYCLEBIN_AUX_LOB_META_TID = 50145; // "__all_recyclebin_aux_lob_meta"
const uint64_t OB_ALL_PART_AUX_LOB_META_TID = 50146; // "__all_part_aux_lob_meta"
const uint64_t OB_ALL_PART_HISTORY_AUX_LOB_META_TID = 50147; // "__all_part_history_aux_lob_meta"
const uint64_t OB_ALL_SUB_PART_AUX_LOB_META_TID = 50148; // "__all_sub_part_aux_lob_meta"
const uint64_t OB_ALL_SUB_PART_HISTORY_AUX_LOB_META_TID = 50149; // "__all_sub_part_history_aux_lob_meta"
const uint64_t OB_ALL_PART_INFO_AUX_LOB_META_TID = 50150; // "__all_part_info_aux_lob_meta"
const uint64_t OB_ALL_PART_INFO_HISTORY_AUX_LOB_META_TID = 50151; // "__all_part_info_history_aux_lob_meta"
const uint64_t OB_ALL_DEF_SUB_PART_AUX_LOB_META_TID = 50152; // "__all_def_sub_part_aux_lob_meta"
const uint64_t OB_ALL_DEF_SUB_PART_HISTORY_AUX_LOB_META_TID = 50153; // "__all_def_sub_part_history_aux_lob_meta"
const uint64_t OB_ALL_SERVER_EVENT_HISTORY_AUX_LOB_META_TID = 50154; // "__all_server_event_history_aux_lob_meta"
const uint64_t OB_ALL_ROOTSERVICE_JOB_AUX_LOB_META_TID = 50155; // "__all_rootservice_job_aux_lob_meta"
const uint64_t OB_ALL_SYS_VARIABLE_HISTORY_AUX_LOB_META_TID = 50157; // "__all_sys_variable_history_aux_lob_meta"
const uint64_t OB_ALL_RESTORE_JOB_AUX_LOB_META_TID = 50158; // "__all_restore_job_aux_lob_meta"
const uint64_t OB_ALL_RESTORE_JOB_HISTORY_AUX_LOB_META_TID = 50160; // "__all_restore_job_history_aux_lob_meta"
const uint64_t OB_ALL_DDL_ID_AUX_LOB_META_TID = 50165; // "__all_ddl_id_aux_lob_meta"
const uint64_t OB_ALL_FOREIGN_KEY_AUX_LOB_META_TID = 50166; // "__all_foreign_key_aux_lob_meta"
const uint64_t OB_ALL_FOREIGN_KEY_HISTORY_AUX_LOB_META_TID = 50167; // "__all_foreign_key_history_aux_lob_meta"
const uint64_t OB_ALL_FOREIGN_KEY_COLUMN_AUX_LOB_META_TID = 50168; // "__all_foreign_key_column_aux_lob_meta"
const uint64_t OB_ALL_FOREIGN_KEY_COLUMN_HISTORY_AUX_LOB_META_TID = 50169; // "__all_foreign_key_column_history_aux_lob_meta"
const uint64_t OB_ALL_SYNONYM_AUX_LOB_META_TID = 50180; // "__all_synonym_aux_lob_meta"
const uint64_t OB_ALL_SYNONYM_HISTORY_AUX_LOB_META_TID = 50181; // "__all_synonym_history_aux_lob_meta"
const uint64_t OB_ALL_AUTO_INCREMENT_AUX_LOB_META_TID = 50182; // "__all_auto_increment_aux_lob_meta"
const uint64_t OB_ALL_DDL_CHECKSUM_AUX_LOB_META_TID = 50188; // "__all_ddl_checksum_aux_lob_meta"
const uint64_t OB_ALL_ROUTINE_AUX_LOB_META_TID = 50189; // "__all_routine_aux_lob_meta"
const uint64_t OB_ALL_ROUTINE_HISTORY_AUX_LOB_META_TID = 50190; // "__all_routine_history_aux_lob_meta"
const uint64_t OB_ALL_ROUTINE_PARAM_AUX_LOB_META_TID = 50191; // "__all_routine_param_aux_lob_meta"
const uint64_t OB_ALL_ROUTINE_PARAM_HISTORY_AUX_LOB_META_TID = 50192; // "__all_routine_param_history_aux_lob_meta"
const uint64_t OB_ALL_PACKAGE_AUX_LOB_META_TID = 50196; // "__all_package_aux_lob_meta"
const uint64_t OB_ALL_PACKAGE_HISTORY_AUX_LOB_META_TID = 50197; // "__all_package_history_aux_lob_meta"
const uint64_t OB_ALL_ACQUIRED_SNAPSHOT_AUX_LOB_META_TID = 50202; // "__all_acquired_snapshot_aux_lob_meta"
const uint64_t OB_ALL_CONSTRAINT_AUX_LOB_META_TID = 50206; // "__all_constraint_aux_lob_meta"
const uint64_t OB_ALL_CONSTRAINT_HISTORY_AUX_LOB_META_TID = 50207; // "__all_constraint_history_aux_lob_meta"
const uint64_t OB_ALL_ORI_SCHEMA_VERSION_AUX_LOB_META_TID = 50208; // "__all_ori_schema_version_aux_lob_meta"
const uint64_t OB_ALL_FUNC_AUX_LOB_META_TID = 50209; // "__all_func_aux_lob_meta"
const uint64_t OB_ALL_FUNC_HISTORY_AUX_LOB_META_TID = 50210; // "__all_func_history_aux_lob_meta"
const uint64_t OB_ALL_TEMP_TABLE_AUX_LOB_META_TID = 50211; // "__all_temp_table_aux_lob_meta"
const uint64_t OB_ALL_SEQUENCE_OBJECT_AUX_LOB_META_TID = 50213; // "__all_sequence_object_aux_lob_meta"
const uint64_t OB_ALL_SEQUENCE_OBJECT_HISTORY_AUX_LOB_META_TID = 50214; // "__all_sequence_object_history_aux_lob_meta"
const uint64_t OB_ALL_SEQUENCE_VALUE_AUX_LOB_META_TID = 50215; // "__all_sequence_value_aux_lob_meta"
const uint64_t OB_ALL_FREEZE_SCHEMA_VERSION_AUX_LOB_META_TID = 50219; // "__all_freeze_schema_version_aux_lob_meta"
const uint64_t OB_ALL_TYPE_AUX_LOB_META_TID = 50220; // "__all_type_aux_lob_meta"
const uint64_t OB_ALL_TYPE_HISTORY_AUX_LOB_META_TID = 50221; // "__all_type_history_aux_lob_meta"
const uint64_t OB_ALL_TYPE_ATTR_AUX_LOB_META_TID = 50222; // "__all_type_attr_aux_lob_meta"
const uint64_t OB_ALL_TYPE_ATTR_HISTORY_AUX_LOB_META_TID = 50223; // "__all_type_attr_history_aux_lob_meta"
const uint64_t OB_ALL_COLL_TYPE_AUX_LOB_META_TID = 50224; // "__all_coll_type_aux_lob_meta"
const uint64_t OB_ALL_COLL_TYPE_HISTORY_AUX_LOB_META_TID = 50225; // "__all_coll_type_history_aux_lob_meta"
const uint64_t OB_ALL_WEAK_READ_SERVICE_AUX_LOB_META_TID = 50226; // "__all_weak_read_service_aux_lob_meta"
const uint64_t OB_ALL_DBLINK_AUX_LOB_META_TID = 50232; // "__all_dblink_aux_lob_meta"
const uint64_t OB_ALL_DBLINK_HISTORY_AUX_LOB_META_TID = 50233; // "__all_dblink_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_ROLE_GRANTEE_MAP_AUX_LOB_META_TID = 50235; // "__all_tenant_role_grantee_map_aux_lob_meta"
const uint64_t OB_ALL_TENANT_ROLE_GRANTEE_MAP_HISTORY_AUX_LOB_META_TID = 50236; // "__all_tenant_role_grantee_map_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_KEYSTORE_AUX_LOB_META_TID = 50237; // "__all_tenant_keystore_aux_lob_meta"
const uint64_t OB_ALL_TENANT_KEYSTORE_HISTORY_AUX_LOB_META_TID = 50238; // "__all_tenant_keystore_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OLS_POLICY_AUX_LOB_META_TID = 50239; // "__all_tenant_ols_policy_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OLS_POLICY_HISTORY_AUX_LOB_META_TID = 50240; // "__all_tenant_ols_policy_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OLS_COMPONENT_AUX_LOB_META_TID = 50241; // "__all_tenant_ols_component_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OLS_COMPONENT_HISTORY_AUX_LOB_META_TID = 50242; // "__all_tenant_ols_component_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OLS_LABEL_AUX_LOB_META_TID = 50243; // "__all_tenant_ols_label_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OLS_LABEL_HISTORY_AUX_LOB_META_TID = 50244; // "__all_tenant_ols_label_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OLS_USER_LEVEL_AUX_LOB_META_TID = 50245; // "__all_tenant_ols_user_level_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OLS_USER_LEVEL_HISTORY_AUX_LOB_META_TID = 50246; // "__all_tenant_ols_user_level_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_TABLESPACE_AUX_LOB_META_TID = 50247; // "__all_tenant_tablespace_aux_lob_meta"
const uint64_t OB_ALL_TENANT_TABLESPACE_HISTORY_AUX_LOB_META_TID = 50248; // "__all_tenant_tablespace_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_USER_FAILED_LOGIN_STAT_AUX_LOB_META_TID = 50249; // "__all_tenant_user_failed_login_stat_aux_lob_meta"
const uint64_t OB_ALL_TENANT_PROFILE_AUX_LOB_META_TID = 50250; // "__all_tenant_profile_aux_lob_meta"
const uint64_t OB_ALL_TENANT_PROFILE_HISTORY_AUX_LOB_META_TID = 50251; // "__all_tenant_profile_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SECURITY_AUDIT_AUX_LOB_META_TID = 50252; // "__all_tenant_security_audit_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SECURITY_AUDIT_HISTORY_AUX_LOB_META_TID = 50253; // "__all_tenant_security_audit_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_TRIGGER_AUX_LOB_META_TID = 50254; // "__all_tenant_trigger_aux_lob_meta"
const uint64_t OB_ALL_TENANT_TRIGGER_HISTORY_AUX_LOB_META_TID = 50255; // "__all_tenant_trigger_history_aux_lob_meta"
const uint64_t OB_ALL_SEED_PARAMETER_AUX_LOB_META_TID = 50256; // "__all_seed_parameter_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SECURITY_AUDIT_RECORD_AUX_LOB_META_TID = 50259; // "__all_tenant_security_audit_record_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SYSAUTH_AUX_LOB_META_TID = 50260; // "__all_tenant_sysauth_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SYSAUTH_HISTORY_AUX_LOB_META_TID = 50261; // "__all_tenant_sysauth_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OBJAUTH_AUX_LOB_META_TID = 50262; // "__all_tenant_objauth_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OBJAUTH_HISTORY_AUX_LOB_META_TID = 50263; // "__all_tenant_objauth_history_aux_lob_meta"
const uint64_t OB_ALL_RESTORE_INFO_AUX_LOB_META_TID = 50265; // "__all_restore_info_aux_lob_meta"
const uint64_t OB_ALL_TENANT_ERROR_AUX_LOB_META_TID = 50272; // "__all_tenant_error_aux_lob_meta"
const uint64_t OB_ALL_RESTORE_PROGRESS_AUX_LOB_META_TID = 50279; // "__all_restore_progress_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OBJECT_TYPE_AUX_LOB_META_TID = 50283; // "__all_tenant_object_type_aux_lob_meta"
const uint64_t OB_ALL_TENANT_OBJECT_TYPE_HISTORY_AUX_LOB_META_TID = 50284; // "__all_tenant_object_type_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_TIME_ZONE_AUX_LOB_META_TID = 50290; // "__all_tenant_time_zone_aux_lob_meta"
const uint64_t OB_ALL_TENANT_TIME_ZONE_NAME_AUX_LOB_META_TID = 50291; // "__all_tenant_time_zone_name_aux_lob_meta"
const uint64_t OB_ALL_TENANT_TIME_ZONE_TRANSITION_AUX_LOB_META_TID = 50292; // "__all_tenant_time_zone_transition_aux_lob_meta"
const uint64_t OB_ALL_TENANT_TIME_ZONE_TRANSITION_TYPE_AUX_LOB_META_TID = 50293; // "__all_tenant_time_zone_transition_type_aux_lob_meta"
const uint64_t OB_ALL_TENANT_CONSTRAINT_COLUMN_AUX_LOB_META_TID = 50294; // "__all_tenant_constraint_column_aux_lob_meta"
const uint64_t OB_ALL_TENANT_CONSTRAINT_COLUMN_HISTORY_AUX_LOB_META_TID = 50295; // "__all_tenant_constraint_column_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_GLOBAL_TRANSACTION_AUX_LOB_META_TID = 50296; // "__all_tenant_global_transaction_aux_lob_meta"
const uint64_t OB_ALL_TENANT_DEPENDENCY_AUX_LOB_META_TID = 50297; // "__all_tenant_dependency_aux_lob_meta"
const uint64_t OB_ALL_RES_MGR_PLAN_AUX_LOB_META_TID = 50305; // "__all_res_mgr_plan_aux_lob_meta"
const uint64_t OB_ALL_RES_MGR_DIRECTIVE_AUX_LOB_META_TID = 50306; // "__all_res_mgr_directive_aux_lob_meta"
const uint64_t OB_ALL_RES_MGR_MAPPING_RULE_AUX_LOB_META_TID = 50307; // "__all_res_mgr_mapping_rule_aux_lob_meta"
const uint64_t OB_ALL_DDL_ERROR_MESSAGE_AUX_LOB_META_TID = 50308; // "__all_ddl_error_message_aux_lob_meta"
const uint64_t OB_ALL_SPACE_USAGE_AUX_LOB_META_TID = 50309; // "__all_space_usage_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_SET_FILES_AUX_LOB_META_TID = 50315; // "__all_backup_set_files_aux_lob_meta"
const uint64_t OB_ALL_RES_MGR_CONSUMER_GROUP_AUX_LOB_META_TID = 50316; // "__all_res_mgr_consumer_group_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_INFO_AUX_LOB_META_TID = 50317; // "__all_backup_info_aux_lob_meta"
const uint64_t OB_ALL_DDL_TASK_STATUS_AUX_LOB_META_TID = 50319; // "__all_ddl_task_status_aux_lob_meta"
const uint64_t OB_ALL_REGION_NETWORK_BANDWIDTH_LIMIT_AUX_LOB_META_TID = 50320; // "__all_region_network_bandwidth_limit_aux_lob_meta"
const uint64_t OB_ALL_DEADLOCK_EVENT_HISTORY_AUX_LOB_META_TID = 50322; // "__all_deadlock_event_history_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_USAGE_AUX_LOB_META_TID = 50323; // "__all_column_usage_aux_lob_meta"
const uint64_t OB_ALL_JOB_AUX_LOB_META_TID = 50324; // "__all_job_aux_lob_meta"
const uint64_t OB_ALL_JOB_LOG_AUX_LOB_META_TID = 50325; // "__all_job_log_aux_lob_meta"
const uint64_t OB_ALL_TENANT_DIRECTORY_AUX_LOB_META_TID = 50326; // "__all_tenant_directory_aux_lob_meta"
const uint64_t OB_ALL_TENANT_DIRECTORY_HISTORY_AUX_LOB_META_TID = 50327; // "__all_tenant_directory_history_aux_lob_meta"
const uint64_t OB_ALL_TABLE_STAT_AUX_LOB_META_TID = 50328; // "__all_table_stat_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_STAT_AUX_LOB_META_TID = 50329; // "__all_column_stat_aux_lob_meta"
const uint64_t OB_ALL_HISTOGRAM_STAT_AUX_LOB_META_TID = 50330; // "__all_histogram_stat_aux_lob_meta"
const uint64_t OB_ALL_MONITOR_MODIFIED_AUX_LOB_META_TID = 50331; // "__all_monitor_modified_aux_lob_meta"
const uint64_t OB_ALL_TABLE_STAT_HISTORY_AUX_LOB_META_TID = 50332; // "__all_table_stat_history_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_STAT_HISTORY_AUX_LOB_META_TID = 50333; // "__all_column_stat_history_aux_lob_meta"
const uint64_t OB_ALL_HISTOGRAM_STAT_HISTORY_AUX_LOB_META_TID = 50334; // "__all_histogram_stat_history_aux_lob_meta"
const uint64_t OB_ALL_OPTSTAT_GLOBAL_PREFS_AUX_LOB_META_TID = 50335; // "__all_optstat_global_prefs_aux_lob_meta"
const uint64_t OB_ALL_OPTSTAT_USER_PREFS_AUX_LOB_META_TID = 50336; // "__all_optstat_user_prefs_aux_lob_meta"
const uint64_t OB_ALL_LS_META_TABLE_AUX_LOB_META_TID = 50342; // "__all_ls_meta_table_aux_lob_meta"
const uint64_t OB_ALL_TABLET_TO_LS_AUX_LOB_META_TID = 50343; // "__all_tablet_to_ls_aux_lob_meta"
const uint64_t OB_ALL_TABLET_META_TABLE_AUX_LOB_META_TID = 50344; // "__all_tablet_meta_table_aux_lob_meta"
const uint64_t OB_ALL_LS_STATUS_AUX_LOB_META_TID = 50345; // "__all_ls_status_aux_lob_meta"
const uint64_t OB_ALL_LOG_ARCHIVE_PROGRESS_AUX_LOB_META_TID = 50348; // "__all_log_archive_progress_aux_lob_meta"
const uint64_t OB_ALL_LOG_ARCHIVE_HISTORY_AUX_LOB_META_TID = 50349; // "__all_log_archive_history_aux_lob_meta"
const uint64_t OB_ALL_LOG_ARCHIVE_PIECE_FILES_AUX_LOB_META_TID = 50350; // "__all_log_archive_piece_files_aux_lob_meta"
const uint64_t OB_ALL_LS_LOG_ARCHIVE_PROGRESS_AUX_LOB_META_TID = 50351; // "__all_ls_log_archive_progress_aux_lob_meta"
const uint64_t OB_ALL_LS_AUX_LOB_META_TID = 50352; // "__all_ls_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_STORAGE_INFO_AUX_LOB_META_TID = 50354; // "__all_backup_storage_info_aux_lob_meta"
const uint64_t OB_ALL_DAM_LAST_ARCH_TS_AUX_LOB_META_TID = 50355; // "__all_dam_last_arch_ts_aux_lob_meta"
const uint64_t OB_ALL_DAM_CLEANUP_JOBS_AUX_LOB_META_TID = 50356; // "__all_dam_cleanup_jobs_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_JOB_AUX_LOB_META_TID = 50357; // "__all_backup_job_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_JOB_HISTORY_AUX_LOB_META_TID = 50358; // "__all_backup_job_history_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_TASK_AUX_LOB_META_TID = 50359; // "__all_backup_task_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_TASK_HISTORY_AUX_LOB_META_TID = 50360; // "__all_backup_task_history_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_LS_TASK_AUX_LOB_META_TID = 50361; // "__all_backup_ls_task_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_LS_TASK_HISTORY_AUX_LOB_META_TID = 50362; // "__all_backup_ls_task_history_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_LS_TASK_INFO_AUX_LOB_META_TID = 50363; // "__all_backup_ls_task_info_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_SKIPPED_TABLET_AUX_LOB_META_TID = 50364; // "__all_backup_skipped_tablet_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_SKIPPED_TABLET_HISTORY_AUX_LOB_META_TID = 50365; // "__all_backup_skipped_tablet_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_INFO_AUX_LOB_META_TID = 50366; // "__all_tenant_info_aux_lob_meta"
const uint64_t OB_ALL_TABLET_TO_TABLE_HISTORY_AUX_LOB_META_TID = 50369; // "__all_tablet_to_table_history_aux_lob_meta"
const uint64_t OB_ALL_LS_RECOVERY_STAT_AUX_LOB_META_TID = 50370; // "__all_ls_recovery_stat_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_LS_TASK_INFO_HISTORY_AUX_LOB_META_TID = 50371; // "__all_backup_ls_task_info_history_aux_lob_meta"
const uint64_t OB_ALL_TABLET_REPLICA_CHECKSUM_AUX_LOB_META_TID = 50372; // "__all_tablet_replica_checksum_aux_lob_meta"
const uint64_t OB_ALL_TABLET_CHECKSUM_AUX_LOB_META_TID = 50373; // "__all_tablet_checksum_aux_lob_meta"
const uint64_t OB_ALL_LS_REPLICA_TASK_AUX_LOB_META_TID = 50374; // "__all_ls_replica_task_aux_lob_meta"
const uint64_t OB_ALL_PENDING_TRANSACTION_AUX_LOB_META_TID = 50375; // "__all_pending_transaction_aux_lob_meta"
const uint64_t OB_ALL_BALANCE_GROUP_LS_STAT_AUX_LOB_META_TID = 50376; // "__all_balance_group_ls_stat_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SCHEDULER_JOB_AUX_LOB_META_TID = 50377; // "__all_tenant_scheduler_job_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SCHEDULER_JOB_RUN_DETAIL_AUX_LOB_META_TID = 50378; // "__all_tenant_scheduler_job_run_detail_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SCHEDULER_PROGRAM_AUX_LOB_META_TID = 50379; // "__all_tenant_scheduler_program_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SCHEDULER_PROGRAM_ARGUMENT_AUX_LOB_META_TID = 50380; // "__all_tenant_scheduler_program_argument_aux_lob_meta"
const uint64_t OB_ALL_CONTEXT_AUX_LOB_META_TID = 50381; // "__all_context_aux_lob_meta"
const uint64_t OB_ALL_CONTEXT_HISTORY_AUX_LOB_META_TID = 50382; // "__all_context_history_aux_lob_meta"
const uint64_t OB_ALL_GLOBAL_CONTEXT_VALUE_AUX_LOB_META_TID = 50383; // "__all_global_context_value_aux_lob_meta"
const uint64_t OB_ALL_LS_ELECTION_REFERENCE_INFO_AUX_LOB_META_TID = 50385; // "__all_ls_election_reference_info_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_DELETE_JOB_AUX_LOB_META_TID = 50386; // "__all_backup_delete_job_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_DELETE_JOB_HISTORY_AUX_LOB_META_TID = 50387; // "__all_backup_delete_job_history_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_DELETE_TASK_AUX_LOB_META_TID = 50388; // "__all_backup_delete_task_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_DELETE_TASK_HISTORY_AUX_LOB_META_TID = 50389; // "__all_backup_delete_task_history_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_DELETE_LS_TASK_AUX_LOB_META_TID = 50390; // "__all_backup_delete_ls_task_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_DELETE_LS_TASK_HISTORY_AUX_LOB_META_TID = 50391; // "__all_backup_delete_ls_task_history_aux_lob_meta"
const uint64_t OB_ALL_ZONE_MERGE_INFO_AUX_LOB_META_TID = 50392; // "__all_zone_merge_info_aux_lob_meta"
const uint64_t OB_ALL_MERGE_INFO_AUX_LOB_META_TID = 50393; // "__all_merge_info_aux_lob_meta"
const uint64_t OB_ALL_FREEZE_INFO_AUX_LOB_META_TID = 50394; // "__all_freeze_info_aux_lob_meta"
const uint64_t OB_ALL_DISK_IO_CALIBRATION_AUX_LOB_META_TID = 50395; // "__all_disk_io_calibration_aux_lob_meta"
const uint64_t OB_ALL_PLAN_BASELINE_AUX_LOB_META_TID = 50396; // "__all_plan_baseline_aux_lob_meta"
const uint64_t OB_ALL_PLAN_BASELINE_ITEM_AUX_LOB_META_TID = 50397; // "__all_plan_baseline_item_aux_lob_meta"
const uint64_t OB_ALL_SPM_CONFIG_AUX_LOB_META_TID = 50398; // "__all_spm_config_aux_lob_meta"
const uint64_t OB_ALL_LOG_ARCHIVE_DEST_PARAMETER_AUX_LOB_META_TID = 50399; // "__all_log_archive_dest_parameter_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_PARAMETER_AUX_LOB_META_TID = 50400; // "__all_backup_parameter_aux_lob_meta"
const uint64_t OB_ALL_LS_RESTORE_PROGRESS_AUX_LOB_META_TID = 50401; // "__all_ls_restore_progress_aux_lob_meta"
const uint64_t OB_ALL_LS_RESTORE_HISTORY_AUX_LOB_META_TID = 50402; // "__all_ls_restore_history_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_STORAGE_INFO_HISTORY_AUX_LOB_META_TID = 50403; // "__all_backup_storage_info_history_aux_lob_meta"
const uint64_t OB_ALL_BACKUP_DELETE_POLICY_AUX_LOB_META_TID = 50404; // "__all_backup_delete_policy_aux_lob_meta"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_AUX_LOB_META_TID = 50405; // "__all_mock_fk_parent_table_aux_lob_meta"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_HISTORY_AUX_LOB_META_TID = 50406; // "__all_mock_fk_parent_table_history_aux_lob_meta"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_AUX_LOB_META_TID = 50407; // "__all_mock_fk_parent_table_column_aux_lob_meta"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_HISTORY_AUX_LOB_META_TID = 50408; // "__all_mock_fk_parent_table_column_history_aux_lob_meta"
const uint64_t OB_ALL_LOG_RESTORE_SOURCE_AUX_LOB_META_TID = 50409; // "__all_log_restore_source_aux_lob_meta"
const uint64_t OB_ALL_KV_TTL_TASK_AUX_LOB_META_TID = 50410; // "__all_kv_ttl_task_aux_lob_meta"
const uint64_t OB_ALL_KV_TTL_TASK_HISTORY_AUX_LOB_META_TID = 50411; // "__all_kv_ttl_task_history_aux_lob_meta"
const uint64_t OB_ALL_SERVICE_EPOCH_AUX_LOB_META_TID = 50412; // "__all_service_epoch_aux_lob_meta"
const uint64_t OB_ALL_SPATIAL_REFERENCE_SYSTEMS_AUX_LOB_META_TID = 50413; // "__all_spatial_reference_systems_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_CHECKSUM_ERROR_INFO_AUX_LOB_META_TID = 50416; // "__all_column_checksum_error_info_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_GROUP_AUX_LOB_META_TID = 50419; // "__all_column_group_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_GROUP_HISTORY_AUX_LOB_META_TID = 50420; // "__all_column_group_history_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_GROUP_MAPPING_AUX_LOB_META_TID = 50421; // "__all_column_group_mapping_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_GROUP_MAPPING_HISTORY_AUX_LOB_META_TID = 50422; // "__all_column_group_mapping_history_aux_lob_meta"
const uint64_t OB_ALL_TRANSFER_TASK_AUX_LOB_META_TID = 50423; // "__all_transfer_task_aux_lob_meta"
const uint64_t OB_ALL_TRANSFER_TASK_HISTORY_AUX_LOB_META_TID = 50424; // "__all_transfer_task_history_aux_lob_meta"
const uint64_t OB_ALL_BALANCE_JOB_AUX_LOB_META_TID = 50425; // "__all_balance_job_aux_lob_meta"
const uint64_t OB_ALL_BALANCE_JOB_HISTORY_AUX_LOB_META_TID = 50426; // "__all_balance_job_history_aux_lob_meta"
const uint64_t OB_ALL_BALANCE_TASK_AUX_LOB_META_TID = 50427; // "__all_balance_task_aux_lob_meta"
const uint64_t OB_ALL_BALANCE_TASK_HISTORY_AUX_LOB_META_TID = 50428; // "__all_balance_task_history_aux_lob_meta"
const uint64_t OB_ALL_ARBITRATION_SERVICE_AUX_LOB_META_TID = 50429; // "__all_arbitration_service_aux_lob_meta"
const uint64_t OB_ALL_LS_ARB_REPLICA_TASK_AUX_LOB_META_TID = 50430; // "__all_ls_arb_replica_task_aux_lob_meta"
const uint64_t OB_ALL_DATA_DICTIONARY_IN_LOG_AUX_LOB_META_TID = 50431; // "__all_data_dictionary_in_log_aux_lob_meta"
const uint64_t OB_ALL_LS_ARB_REPLICA_TASK_HISTORY_AUX_LOB_META_TID = 50432; // "__all_ls_arb_replica_task_history_aux_lob_meta"
const uint64_t OB_ALL_RLS_POLICY_AUX_LOB_META_TID = 50433; // "__all_rls_policy_aux_lob_meta"
const uint64_t OB_ALL_RLS_POLICY_HISTORY_AUX_LOB_META_TID = 50434; // "__all_rls_policy_history_aux_lob_meta"
const uint64_t OB_ALL_RLS_SECURITY_COLUMN_AUX_LOB_META_TID = 50435; // "__all_rls_security_column_aux_lob_meta"
const uint64_t OB_ALL_RLS_SECURITY_COLUMN_HISTORY_AUX_LOB_META_TID = 50436; // "__all_rls_security_column_history_aux_lob_meta"
const uint64_t OB_ALL_RLS_GROUP_AUX_LOB_META_TID = 50437; // "__all_rls_group_aux_lob_meta"
const uint64_t OB_ALL_RLS_GROUP_HISTORY_AUX_LOB_META_TID = 50438; // "__all_rls_group_history_aux_lob_meta"
const uint64_t OB_ALL_RLS_CONTEXT_AUX_LOB_META_TID = 50439; // "__all_rls_context_aux_lob_meta"
const uint64_t OB_ALL_RLS_CONTEXT_HISTORY_AUX_LOB_META_TID = 50440; // "__all_rls_context_history_aux_lob_meta"
const uint64_t OB_ALL_RLS_ATTRIBUTE_AUX_LOB_META_TID = 50441; // "__all_rls_attribute_aux_lob_meta"
const uint64_t OB_ALL_RLS_ATTRIBUTE_HISTORY_AUX_LOB_META_TID = 50442; // "__all_rls_attribute_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_REWRITE_RULES_AUX_LOB_META_TID = 50443; // "__all_tenant_rewrite_rules_aux_lob_meta"
const uint64_t OB_ALL_RESERVED_SNAPSHOT_AUX_LOB_META_TID = 50444; // "__all_reserved_snapshot_aux_lob_meta"
const uint64_t OB_ALL_CLUSTER_EVENT_HISTORY_AUX_LOB_META_TID = 50445; // "__all_cluster_event_history_aux_lob_meta"
const uint64_t OB_ALL_LS_TRANSFER_MEMBER_LIST_LOCK_INFO_AUX_LOB_META_TID = 50446; // "__all_ls_transfer_member_list_lock_info_aux_lob_meta"
const uint64_t OB_ALL_EXTERNAL_TABLE_FILE_AUX_LOB_META_TID = 50450; // "__all_external_table_file_aux_lob_meta"
const uint64_t OB_ALL_TASK_OPT_STAT_GATHER_HISTORY_AUX_LOB_META_TID = 50451; // "__all_task_opt_stat_gather_history_aux_lob_meta"
const uint64_t OB_ALL_TABLE_OPT_STAT_GATHER_HISTORY_AUX_LOB_META_TID = 50452; // "__all_table_opt_stat_gather_history_aux_lob_meta"
const uint64_t OB_ALL_ZONE_STORAGE_AUX_LOB_META_TID = 50453; // "__all_zone_storage_aux_lob_meta"
const uint64_t OB_ALL_ZONE_STORAGE_OPERATION_AUX_LOB_META_TID = 50454; // "__all_zone_storage_operation_aux_lob_meta"
const uint64_t OB_WR_ACTIVE_SESSION_HISTORY_AUX_LOB_META_TID = 50455; // "__wr_active_session_history_aux_lob_meta"
const uint64_t OB_WR_SNAPSHOT_AUX_LOB_META_TID = 50456; // "__wr_snapshot_aux_lob_meta"
const uint64_t OB_WR_STATNAME_AUX_LOB_META_TID = 50457; // "__wr_statname_aux_lob_meta"
const uint64_t OB_WR_SYSSTAT_AUX_LOB_META_TID = 50458; // "__wr_sysstat_aux_lob_meta"
const uint64_t OB_ALL_BALANCE_TASK_HELPER_AUX_LOB_META_TID = 50459; // "__all_balance_task_helper_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SNAPSHOT_AUX_LOB_META_TID = 50460; // "__all_tenant_snapshot_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SNAPSHOT_LS_AUX_LOB_META_TID = 50461; // "__all_tenant_snapshot_ls_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_AUX_LOB_META_TID = 50462; // "__all_tenant_snapshot_ls_replica_aux_lob_meta"
const uint64_t OB_ALL_MLOG_AUX_LOB_META_TID = 50463; // "__all_mlog_aux_lob_meta"
const uint64_t OB_ALL_MVIEW_AUX_LOB_META_TID = 50464; // "__all_mview_aux_lob_meta"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_AUX_LOB_META_TID = 50465; // "__all_mview_refresh_stats_sys_defaults_aux_lob_meta"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_PARAMS_AUX_LOB_META_TID = 50466; // "__all_mview_refresh_stats_params_aux_lob_meta"
const uint64_t OB_ALL_MVIEW_REFRESH_RUN_STATS_AUX_LOB_META_TID = 50467; // "__all_mview_refresh_run_stats_aux_lob_meta"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_AUX_LOB_META_TID = 50468; // "__all_mview_refresh_stats_aux_lob_meta"
const uint64_t OB_ALL_MVIEW_REFRESH_CHANGE_STATS_AUX_LOB_META_TID = 50469; // "__all_mview_refresh_change_stats_aux_lob_meta"
const uint64_t OB_ALL_MVIEW_REFRESH_STMT_STATS_AUX_LOB_META_TID = 50470; // "__all_mview_refresh_stmt_stats_aux_lob_meta"
const uint64_t OB_ALL_DBMS_LOCK_ALLOCATED_AUX_LOB_META_TID = 50471; // "__all_dbms_lock_allocated_aux_lob_meta"
const uint64_t OB_WR_CONTROL_AUX_LOB_META_TID = 50472; // "__wr_control_aux_lob_meta"
const uint64_t OB_ALL_TENANT_EVENT_HISTORY_AUX_LOB_META_TID = 50473; // "__all_tenant_event_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SCHEDULER_JOB_CLASS_AUX_LOB_META_TID = 50474; // "__all_tenant_scheduler_job_class_aux_lob_meta"
const uint64_t OB_ALL_RECOVER_TABLE_JOB_AUX_LOB_META_TID = 50475; // "__all_recover_table_job_aux_lob_meta"
const uint64_t OB_ALL_RECOVER_TABLE_JOB_HISTORY_AUX_LOB_META_TID = 50476; // "__all_recover_table_job_history_aux_lob_meta"
const uint64_t OB_ALL_IMPORT_TABLE_JOB_AUX_LOB_META_TID = 50477; // "__all_import_table_job_aux_lob_meta"
const uint64_t OB_ALL_IMPORT_TABLE_JOB_HISTORY_AUX_LOB_META_TID = 50478; // "__all_import_table_job_history_aux_lob_meta"
const uint64_t OB_ALL_IMPORT_TABLE_TASK_AUX_LOB_META_TID = 50479; // "__all_import_table_task_aux_lob_meta"
const uint64_t OB_ALL_IMPORT_TABLE_TASK_HISTORY_AUX_LOB_META_TID = 50480; // "__all_import_table_task_history_aux_lob_meta"
const uint64_t OB_ALL_TABLET_REORGANIZE_HISTORY_AUX_LOB_META_TID = 50482; // "__all_tablet_reorganize_history_aux_lob_meta"
const uint64_t OB_ALL_STORAGE_HA_ERROR_DIAGNOSE_HISTORY_AUX_LOB_META_TID = 50483; // "__all_storage_ha_error_diagnose_history_aux_lob_meta"
const uint64_t OB_ALL_STORAGE_HA_PERF_DIAGNOSE_HISTORY_AUX_LOB_META_TID = 50484; // "__all_storage_ha_perf_diagnose_history_aux_lob_meta"
const uint64_t OB_ALL_CLONE_JOB_AUX_LOB_META_TID = 50485; // "__all_clone_job_aux_lob_meta"
const uint64_t OB_ALL_CLONE_JOB_HISTORY_AUX_LOB_META_TID = 50486; // "__all_clone_job_history_aux_lob_meta"
const uint64_t OB_WR_SYSTEM_EVENT_AUX_LOB_META_TID = 50487; // "__wr_system_event_aux_lob_meta"
const uint64_t OB_WR_EVENT_NAME_AUX_LOB_META_TID = 50488; // "__wr_event_name_aux_lob_meta"
const uint64_t OB_ALL_ROUTINE_PRIVILEGE_AUX_LOB_META_TID = 50490; // "__all_routine_privilege_aux_lob_meta"
const uint64_t OB_ALL_ROUTINE_PRIVILEGE_HISTORY_AUX_LOB_META_TID = 50491; // "__all_routine_privilege_history_aux_lob_meta"
const uint64_t OB_WR_SQLSTAT_AUX_LOB_META_TID = 50492; // "__wr_sqlstat_aux_lob_meta"
const uint64_t OB_ALL_NCOMP_DLL_AUX_LOB_META_TID = 50493; // "__all_ncomp_dll_aux_lob_meta"
const uint64_t OB_ALL_AUX_STAT_AUX_LOB_META_TID = 50494; // "__all_aux_stat_aux_lob_meta"
const uint64_t OB_ALL_INDEX_USAGE_INFO_AUX_LOB_META_TID = 50495; // "__all_index_usage_info_aux_lob_meta"
const uint64_t OB_ALL_DETECT_LOCK_INFO_AUX_LOB_META_TID = 50496; // "__all_detect_lock_info_aux_lob_meta"
const uint64_t OB_ALL_CLIENT_TO_SERVER_SESSION_INFO_AUX_LOB_META_TID = 50497; // "__all_client_to_server_session_info_aux_lob_meta"
const uint64_t OB_ALL_TRANSFER_PARTITION_TASK_AUX_LOB_META_TID = 50498; // "__all_transfer_partition_task_aux_lob_meta"
const uint64_t OB_ALL_TRANSFER_PARTITION_TASK_HISTORY_AUX_LOB_META_TID = 50499; // "__all_transfer_partition_task_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SNAPSHOT_JOB_AUX_LOB_META_TID = 50500; // "__all_tenant_snapshot_job_aux_lob_meta"
const uint64_t OB_WR_SQLTEXT_AUX_LOB_META_TID = 50501; // "__wr_sqltext_aux_lob_meta"
const uint64_t OB_ALL_TRUSTED_ROOT_CERTIFICATE_AUX_LOB_META_TID = 50502; // "__all_trusted_root_certificate_aux_lob_meta"
const uint64_t OB_ALL_AUDIT_LOG_FILTER_AUX_LOB_META_TID = 50503; // "__all_audit_log_filter_aux_lob_meta"
const uint64_t OB_ALL_AUDIT_LOG_USER_AUX_LOB_META_TID = 50504; // "__all_audit_log_user_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_PRIVILEGE_AUX_LOB_META_TID = 50505; // "__all_column_privilege_aux_lob_meta"
const uint64_t OB_ALL_COLUMN_PRIVILEGE_HISTORY_AUX_LOB_META_TID = 50506; // "__all_column_privilege_history_aux_lob_meta"
const uint64_t OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_HISTORY_AUX_LOB_META_TID = 50507; // "__all_tenant_snapshot_ls_replica_history_aux_lob_meta"
const uint64_t OB_ALL_LS_REPLICA_TASK_HISTORY_AUX_LOB_META_TID = 50508; // "__all_ls_replica_task_history_aux_lob_meta"
const uint64_t OB_ALL_TABLET_CHECKSUM_ERROR_INFO_AUX_LOB_META_TID = 50511; // "__all_tablet_checksum_error_info_aux_lob_meta"
const uint64_t OB_ALL_USER_PROXY_INFO_AUX_LOB_META_TID = 50512; // "__all_user_proxy_info_aux_lob_meta"
const uint64_t OB_ALL_USER_PROXY_INFO_HISTORY_AUX_LOB_META_TID = 50513; // "__all_user_proxy_info_history_aux_lob_meta"
const uint64_t OB_ALL_USER_PROXY_ROLE_INFO_AUX_LOB_META_TID = 50514; // "__all_user_proxy_role_info_aux_lob_meta"
const uint64_t OB_ALL_USER_PROXY_ROLE_INFO_HISTORY_AUX_LOB_META_TID = 50515; // "__all_user_proxy_role_info_history_aux_lob_meta"
const uint64_t OB_ALL_SERVICE_AUX_LOB_META_TID = 50516; // "__all_service_aux_lob_meta"
const uint64_t OB_ALL_STORAGE_IO_USAGE_AUX_LOB_META_TID = 50517; // "__all_storage_io_usage_aux_lob_meta"
const uint64_t OB_ALL_MVIEW_DEP_AUX_LOB_META_TID = 50518; // "__all_mview_dep_aux_lob_meta"
const uint64_t OB_ALL_SCHEDULER_JOB_RUN_DETAIL_V2_AUX_LOB_META_TID = 50519; // "__all_scheduler_job_run_detail_v2_aux_lob_meta"
const uint64_t OB_ALL_SPM_EVO_RESULT_AUX_LOB_META_TID = 50520; // "__all_spm_evo_result_aux_lob_meta"
const uint64_t OB_ALL_PKG_TYPE_AUX_LOB_META_TID = 50522; // "__all_pkg_type_aux_lob_meta"
const uint64_t OB_ALL_PKG_TYPE_ATTR_AUX_LOB_META_TID = 50523; // "__all_pkg_type_attr_aux_lob_meta"
const uint64_t OB_ALL_PKG_COLL_TYPE_AUX_LOB_META_TID = 50524; // "__all_pkg_coll_type_aux_lob_meta"
const uint64_t OB_WR_SQL_PLAN_AUX_LOB_META_TID = 50525; // "__wr_sql_plan_aux_lob_meta"
const uint64_t OB_ALL_KV_REDIS_TABLE_AUX_LOB_META_TID = 50527; // "__all_kv_redis_table_aux_lob_meta"
const uint64_t OB_ALL_NCOMP_DLL_V2_AUX_LOB_META_TID = 50528; // "__all_ncomp_dll_v2_aux_lob_meta"
const uint64_t OB_FT_DICT_IK_UTF8_AUX_LOB_META_TID = 50531; // "__ft_dict_ik_utf8_aux_lob_meta"
const uint64_t OB_FT_STOPWORD_IK_UTF8_AUX_LOB_META_TID = 50532; // "__ft_stopword_ik_utf8_aux_lob_meta"
const uint64_t OB_FT_QUANTIFIER_IK_UTF8_AUX_LOB_META_TID = 50533; // "__ft_quantifier_ik_utf8_aux_lob_meta"
const uint64_t OB_ALL_TABLE_AUX_LOB_PIECE_TID = 60003; // "__all_table_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_AUX_LOB_PIECE_TID = 60004; // "__all_column_aux_lob_piece"
const uint64_t OB_ALL_DDL_OPERATION_AUX_LOB_PIECE_TID = 60005; // "__all_ddl_operation_aux_lob_piece"
const uint64_t OB_ALL_USER_AUX_LOB_PIECE_TID = 60102; // "__all_user_aux_lob_piece"
const uint64_t OB_ALL_USER_HISTORY_AUX_LOB_PIECE_TID = 60103; // "__all_user_history_aux_lob_piece"
const uint64_t OB_ALL_DATABASE_AUX_LOB_PIECE_TID = 60104; // "__all_database_aux_lob_piece"
const uint64_t OB_ALL_DATABASE_HISTORY_AUX_LOB_PIECE_TID = 60105; // "__all_database_history_aux_lob_piece"
const uint64_t OB_ALL_TABLEGROUP_AUX_LOB_PIECE_TID = 60106; // "__all_tablegroup_aux_lob_piece"
const uint64_t OB_ALL_TABLEGROUP_HISTORY_AUX_LOB_PIECE_TID = 60107; // "__all_tablegroup_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_AUX_LOB_PIECE_TID = 60108; // "__all_tenant_aux_lob_piece"
const uint64_t OB_ALL_TENANT_HISTORY_AUX_LOB_PIECE_TID = 60109; // "__all_tenant_history_aux_lob_piece"
const uint64_t OB_ALL_TABLE_PRIVILEGE_AUX_LOB_PIECE_TID = 60110; // "__all_table_privilege_aux_lob_piece"
const uint64_t OB_ALL_TABLE_PRIVILEGE_HISTORY_AUX_LOB_PIECE_TID = 60111; // "__all_table_privilege_history_aux_lob_piece"
const uint64_t OB_ALL_DATABASE_PRIVILEGE_AUX_LOB_PIECE_TID = 60112; // "__all_database_privilege_aux_lob_piece"
const uint64_t OB_ALL_DATABASE_PRIVILEGE_HISTORY_AUX_LOB_PIECE_TID = 60113; // "__all_database_privilege_history_aux_lob_piece"
const uint64_t OB_ALL_TABLE_HISTORY_AUX_LOB_PIECE_TID = 60114; // "__all_table_history_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_HISTORY_AUX_LOB_PIECE_TID = 60115; // "__all_column_history_aux_lob_piece"
const uint64_t OB_ALL_ZONE_AUX_LOB_PIECE_TID = 60116; // "__all_zone_aux_lob_piece"
const uint64_t OB_ALL_SERVER_AUX_LOB_PIECE_TID = 60117; // "__all_server_aux_lob_piece"
const uint64_t OB_ALL_SYS_PARAMETER_AUX_LOB_PIECE_TID = 60118; // "__all_sys_parameter_aux_lob_piece"
const uint64_t OB_TENANT_PARAMETER_AUX_LOB_PIECE_TID = 60119; // "__tenant_parameter_aux_lob_piece"
const uint64_t OB_ALL_SYS_VARIABLE_AUX_LOB_PIECE_TID = 60120; // "__all_sys_variable_aux_lob_piece"
const uint64_t OB_ALL_SYS_STAT_AUX_LOB_PIECE_TID = 60121; // "__all_sys_stat_aux_lob_piece"
const uint64_t OB_ALL_UNIT_AUX_LOB_PIECE_TID = 60123; // "__all_unit_aux_lob_piece"
const uint64_t OB_ALL_UNIT_CONFIG_AUX_LOB_PIECE_TID = 60124; // "__all_unit_config_aux_lob_piece"
const uint64_t OB_ALL_RESOURCE_POOL_AUX_LOB_PIECE_TID = 60125; // "__all_resource_pool_aux_lob_piece"
const uint64_t OB_ALL_CHARSET_AUX_LOB_PIECE_TID = 60128; // "__all_charset_aux_lob_piece"
const uint64_t OB_ALL_COLLATION_AUX_LOB_PIECE_TID = 60129; // "__all_collation_aux_lob_piece"
const uint64_t OB_HELP_TOPIC_AUX_LOB_PIECE_TID = 60130; // "help_topic_aux_lob_piece"
const uint64_t OB_HELP_CATEGORY_AUX_LOB_PIECE_TID = 60131; // "help_category_aux_lob_piece"
const uint64_t OB_HELP_KEYWORD_AUX_LOB_PIECE_TID = 60132; // "help_keyword_aux_lob_piece"
const uint64_t OB_HELP_RELATION_AUX_LOB_PIECE_TID = 60133; // "help_relation_aux_lob_piece"
const uint64_t OB_ALL_DUMMY_AUX_LOB_PIECE_TID = 60135; // "__all_dummy_aux_lob_piece"
const uint64_t OB_ALL_ROOTSERVICE_EVENT_HISTORY_AUX_LOB_PIECE_TID = 60140; // "__all_rootservice_event_history_aux_lob_piece"
const uint64_t OB_ALL_PRIVILEGE_AUX_LOB_PIECE_TID = 60141; // "__all_privilege_aux_lob_piece"
const uint64_t OB_ALL_OUTLINE_AUX_LOB_PIECE_TID = 60142; // "__all_outline_aux_lob_piece"
const uint64_t OB_ALL_OUTLINE_HISTORY_AUX_LOB_PIECE_TID = 60143; // "__all_outline_history_aux_lob_piece"
const uint64_t OB_ALL_RECYCLEBIN_AUX_LOB_PIECE_TID = 60145; // "__all_recyclebin_aux_lob_piece"
const uint64_t OB_ALL_PART_AUX_LOB_PIECE_TID = 60146; // "__all_part_aux_lob_piece"
const uint64_t OB_ALL_PART_HISTORY_AUX_LOB_PIECE_TID = 60147; // "__all_part_history_aux_lob_piece"
const uint64_t OB_ALL_SUB_PART_AUX_LOB_PIECE_TID = 60148; // "__all_sub_part_aux_lob_piece"
const uint64_t OB_ALL_SUB_PART_HISTORY_AUX_LOB_PIECE_TID = 60149; // "__all_sub_part_history_aux_lob_piece"
const uint64_t OB_ALL_PART_INFO_AUX_LOB_PIECE_TID = 60150; // "__all_part_info_aux_lob_piece"
const uint64_t OB_ALL_PART_INFO_HISTORY_AUX_LOB_PIECE_TID = 60151; // "__all_part_info_history_aux_lob_piece"
const uint64_t OB_ALL_DEF_SUB_PART_AUX_LOB_PIECE_TID = 60152; // "__all_def_sub_part_aux_lob_piece"
const uint64_t OB_ALL_DEF_SUB_PART_HISTORY_AUX_LOB_PIECE_TID = 60153; // "__all_def_sub_part_history_aux_lob_piece"
const uint64_t OB_ALL_SERVER_EVENT_HISTORY_AUX_LOB_PIECE_TID = 60154; // "__all_server_event_history_aux_lob_piece"
const uint64_t OB_ALL_ROOTSERVICE_JOB_AUX_LOB_PIECE_TID = 60155; // "__all_rootservice_job_aux_lob_piece"
const uint64_t OB_ALL_SYS_VARIABLE_HISTORY_AUX_LOB_PIECE_TID = 60157; // "__all_sys_variable_history_aux_lob_piece"
const uint64_t OB_ALL_RESTORE_JOB_AUX_LOB_PIECE_TID = 60158; // "__all_restore_job_aux_lob_piece"
const uint64_t OB_ALL_RESTORE_JOB_HISTORY_AUX_LOB_PIECE_TID = 60160; // "__all_restore_job_history_aux_lob_piece"
const uint64_t OB_ALL_DDL_ID_AUX_LOB_PIECE_TID = 60165; // "__all_ddl_id_aux_lob_piece"
const uint64_t OB_ALL_FOREIGN_KEY_AUX_LOB_PIECE_TID = 60166; // "__all_foreign_key_aux_lob_piece"
const uint64_t OB_ALL_FOREIGN_KEY_HISTORY_AUX_LOB_PIECE_TID = 60167; // "__all_foreign_key_history_aux_lob_piece"
const uint64_t OB_ALL_FOREIGN_KEY_COLUMN_AUX_LOB_PIECE_TID = 60168; // "__all_foreign_key_column_aux_lob_piece"
const uint64_t OB_ALL_FOREIGN_KEY_COLUMN_HISTORY_AUX_LOB_PIECE_TID = 60169; // "__all_foreign_key_column_history_aux_lob_piece"
const uint64_t OB_ALL_SYNONYM_AUX_LOB_PIECE_TID = 60180; // "__all_synonym_aux_lob_piece"
const uint64_t OB_ALL_SYNONYM_HISTORY_AUX_LOB_PIECE_TID = 60181; // "__all_synonym_history_aux_lob_piece"
const uint64_t OB_ALL_AUTO_INCREMENT_AUX_LOB_PIECE_TID = 60182; // "__all_auto_increment_aux_lob_piece"
const uint64_t OB_ALL_DDL_CHECKSUM_AUX_LOB_PIECE_TID = 60188; // "__all_ddl_checksum_aux_lob_piece"
const uint64_t OB_ALL_ROUTINE_AUX_LOB_PIECE_TID = 60189; // "__all_routine_aux_lob_piece"
const uint64_t OB_ALL_ROUTINE_HISTORY_AUX_LOB_PIECE_TID = 60190; // "__all_routine_history_aux_lob_piece"
const uint64_t OB_ALL_ROUTINE_PARAM_AUX_LOB_PIECE_TID = 60191; // "__all_routine_param_aux_lob_piece"
const uint64_t OB_ALL_ROUTINE_PARAM_HISTORY_AUX_LOB_PIECE_TID = 60192; // "__all_routine_param_history_aux_lob_piece"
const uint64_t OB_ALL_PACKAGE_AUX_LOB_PIECE_TID = 60196; // "__all_package_aux_lob_piece"
const uint64_t OB_ALL_PACKAGE_HISTORY_AUX_LOB_PIECE_TID = 60197; // "__all_package_history_aux_lob_piece"
const uint64_t OB_ALL_ACQUIRED_SNAPSHOT_AUX_LOB_PIECE_TID = 60202; // "__all_acquired_snapshot_aux_lob_piece"
const uint64_t OB_ALL_CONSTRAINT_AUX_LOB_PIECE_TID = 60206; // "__all_constraint_aux_lob_piece"
const uint64_t OB_ALL_CONSTRAINT_HISTORY_AUX_LOB_PIECE_TID = 60207; // "__all_constraint_history_aux_lob_piece"
const uint64_t OB_ALL_ORI_SCHEMA_VERSION_AUX_LOB_PIECE_TID = 60208; // "__all_ori_schema_version_aux_lob_piece"
const uint64_t OB_ALL_FUNC_AUX_LOB_PIECE_TID = 60209; // "__all_func_aux_lob_piece"
const uint64_t OB_ALL_FUNC_HISTORY_AUX_LOB_PIECE_TID = 60210; // "__all_func_history_aux_lob_piece"
const uint64_t OB_ALL_TEMP_TABLE_AUX_LOB_PIECE_TID = 60211; // "__all_temp_table_aux_lob_piece"
const uint64_t OB_ALL_SEQUENCE_OBJECT_AUX_LOB_PIECE_TID = 60213; // "__all_sequence_object_aux_lob_piece"
const uint64_t OB_ALL_SEQUENCE_OBJECT_HISTORY_AUX_LOB_PIECE_TID = 60214; // "__all_sequence_object_history_aux_lob_piece"
const uint64_t OB_ALL_SEQUENCE_VALUE_AUX_LOB_PIECE_TID = 60215; // "__all_sequence_value_aux_lob_piece"
const uint64_t OB_ALL_FREEZE_SCHEMA_VERSION_AUX_LOB_PIECE_TID = 60219; // "__all_freeze_schema_version_aux_lob_piece"
const uint64_t OB_ALL_TYPE_AUX_LOB_PIECE_TID = 60220; // "__all_type_aux_lob_piece"
const uint64_t OB_ALL_TYPE_HISTORY_AUX_LOB_PIECE_TID = 60221; // "__all_type_history_aux_lob_piece"
const uint64_t OB_ALL_TYPE_ATTR_AUX_LOB_PIECE_TID = 60222; // "__all_type_attr_aux_lob_piece"
const uint64_t OB_ALL_TYPE_ATTR_HISTORY_AUX_LOB_PIECE_TID = 60223; // "__all_type_attr_history_aux_lob_piece"
const uint64_t OB_ALL_COLL_TYPE_AUX_LOB_PIECE_TID = 60224; // "__all_coll_type_aux_lob_piece"
const uint64_t OB_ALL_COLL_TYPE_HISTORY_AUX_LOB_PIECE_TID = 60225; // "__all_coll_type_history_aux_lob_piece"
const uint64_t OB_ALL_WEAK_READ_SERVICE_AUX_LOB_PIECE_TID = 60226; // "__all_weak_read_service_aux_lob_piece"
const uint64_t OB_ALL_DBLINK_AUX_LOB_PIECE_TID = 60232; // "__all_dblink_aux_lob_piece"
const uint64_t OB_ALL_DBLINK_HISTORY_AUX_LOB_PIECE_TID = 60233; // "__all_dblink_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_ROLE_GRANTEE_MAP_AUX_LOB_PIECE_TID = 60235; // "__all_tenant_role_grantee_map_aux_lob_piece"
const uint64_t OB_ALL_TENANT_ROLE_GRANTEE_MAP_HISTORY_AUX_LOB_PIECE_TID = 60236; // "__all_tenant_role_grantee_map_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_KEYSTORE_AUX_LOB_PIECE_TID = 60237; // "__all_tenant_keystore_aux_lob_piece"
const uint64_t OB_ALL_TENANT_KEYSTORE_HISTORY_AUX_LOB_PIECE_TID = 60238; // "__all_tenant_keystore_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OLS_POLICY_AUX_LOB_PIECE_TID = 60239; // "__all_tenant_ols_policy_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OLS_POLICY_HISTORY_AUX_LOB_PIECE_TID = 60240; // "__all_tenant_ols_policy_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OLS_COMPONENT_AUX_LOB_PIECE_TID = 60241; // "__all_tenant_ols_component_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OLS_COMPONENT_HISTORY_AUX_LOB_PIECE_TID = 60242; // "__all_tenant_ols_component_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OLS_LABEL_AUX_LOB_PIECE_TID = 60243; // "__all_tenant_ols_label_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OLS_LABEL_HISTORY_AUX_LOB_PIECE_TID = 60244; // "__all_tenant_ols_label_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OLS_USER_LEVEL_AUX_LOB_PIECE_TID = 60245; // "__all_tenant_ols_user_level_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OLS_USER_LEVEL_HISTORY_AUX_LOB_PIECE_TID = 60246; // "__all_tenant_ols_user_level_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_TABLESPACE_AUX_LOB_PIECE_TID = 60247; // "__all_tenant_tablespace_aux_lob_piece"
const uint64_t OB_ALL_TENANT_TABLESPACE_HISTORY_AUX_LOB_PIECE_TID = 60248; // "__all_tenant_tablespace_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_USER_FAILED_LOGIN_STAT_AUX_LOB_PIECE_TID = 60249; // "__all_tenant_user_failed_login_stat_aux_lob_piece"
const uint64_t OB_ALL_TENANT_PROFILE_AUX_LOB_PIECE_TID = 60250; // "__all_tenant_profile_aux_lob_piece"
const uint64_t OB_ALL_TENANT_PROFILE_HISTORY_AUX_LOB_PIECE_TID = 60251; // "__all_tenant_profile_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SECURITY_AUDIT_AUX_LOB_PIECE_TID = 60252; // "__all_tenant_security_audit_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SECURITY_AUDIT_HISTORY_AUX_LOB_PIECE_TID = 60253; // "__all_tenant_security_audit_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_TRIGGER_AUX_LOB_PIECE_TID = 60254; // "__all_tenant_trigger_aux_lob_piece"
const uint64_t OB_ALL_TENANT_TRIGGER_HISTORY_AUX_LOB_PIECE_TID = 60255; // "__all_tenant_trigger_history_aux_lob_piece"
const uint64_t OB_ALL_SEED_PARAMETER_AUX_LOB_PIECE_TID = 60256; // "__all_seed_parameter_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SECURITY_AUDIT_RECORD_AUX_LOB_PIECE_TID = 60259; // "__all_tenant_security_audit_record_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SYSAUTH_AUX_LOB_PIECE_TID = 60260; // "__all_tenant_sysauth_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SYSAUTH_HISTORY_AUX_LOB_PIECE_TID = 60261; // "__all_tenant_sysauth_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OBJAUTH_AUX_LOB_PIECE_TID = 60262; // "__all_tenant_objauth_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OBJAUTH_HISTORY_AUX_LOB_PIECE_TID = 60263; // "__all_tenant_objauth_history_aux_lob_piece"
const uint64_t OB_ALL_RESTORE_INFO_AUX_LOB_PIECE_TID = 60265; // "__all_restore_info_aux_lob_piece"
const uint64_t OB_ALL_TENANT_ERROR_AUX_LOB_PIECE_TID = 60272; // "__all_tenant_error_aux_lob_piece"
const uint64_t OB_ALL_RESTORE_PROGRESS_AUX_LOB_PIECE_TID = 60279; // "__all_restore_progress_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OBJECT_TYPE_AUX_LOB_PIECE_TID = 60283; // "__all_tenant_object_type_aux_lob_piece"
const uint64_t OB_ALL_TENANT_OBJECT_TYPE_HISTORY_AUX_LOB_PIECE_TID = 60284; // "__all_tenant_object_type_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_TIME_ZONE_AUX_LOB_PIECE_TID = 60290; // "__all_tenant_time_zone_aux_lob_piece"
const uint64_t OB_ALL_TENANT_TIME_ZONE_NAME_AUX_LOB_PIECE_TID = 60291; // "__all_tenant_time_zone_name_aux_lob_piece"
const uint64_t OB_ALL_TENANT_TIME_ZONE_TRANSITION_AUX_LOB_PIECE_TID = 60292; // "__all_tenant_time_zone_transition_aux_lob_piece"
const uint64_t OB_ALL_TENANT_TIME_ZONE_TRANSITION_TYPE_AUX_LOB_PIECE_TID = 60293; // "__all_tenant_time_zone_transition_type_aux_lob_piece"
const uint64_t OB_ALL_TENANT_CONSTRAINT_COLUMN_AUX_LOB_PIECE_TID = 60294; // "__all_tenant_constraint_column_aux_lob_piece"
const uint64_t OB_ALL_TENANT_CONSTRAINT_COLUMN_HISTORY_AUX_LOB_PIECE_TID = 60295; // "__all_tenant_constraint_column_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_GLOBAL_TRANSACTION_AUX_LOB_PIECE_TID = 60296; // "__all_tenant_global_transaction_aux_lob_piece"
const uint64_t OB_ALL_TENANT_DEPENDENCY_AUX_LOB_PIECE_TID = 60297; // "__all_tenant_dependency_aux_lob_piece"
const uint64_t OB_ALL_RES_MGR_PLAN_AUX_LOB_PIECE_TID = 60305; // "__all_res_mgr_plan_aux_lob_piece"
const uint64_t OB_ALL_RES_MGR_DIRECTIVE_AUX_LOB_PIECE_TID = 60306; // "__all_res_mgr_directive_aux_lob_piece"
const uint64_t OB_ALL_RES_MGR_MAPPING_RULE_AUX_LOB_PIECE_TID = 60307; // "__all_res_mgr_mapping_rule_aux_lob_piece"
const uint64_t OB_ALL_DDL_ERROR_MESSAGE_AUX_LOB_PIECE_TID = 60308; // "__all_ddl_error_message_aux_lob_piece"
const uint64_t OB_ALL_SPACE_USAGE_AUX_LOB_PIECE_TID = 60309; // "__all_space_usage_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_SET_FILES_AUX_LOB_PIECE_TID = 60315; // "__all_backup_set_files_aux_lob_piece"
const uint64_t OB_ALL_RES_MGR_CONSUMER_GROUP_AUX_LOB_PIECE_TID = 60316; // "__all_res_mgr_consumer_group_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_INFO_AUX_LOB_PIECE_TID = 60317; // "__all_backup_info_aux_lob_piece"
const uint64_t OB_ALL_DDL_TASK_STATUS_AUX_LOB_PIECE_TID = 60319; // "__all_ddl_task_status_aux_lob_piece"
const uint64_t OB_ALL_REGION_NETWORK_BANDWIDTH_LIMIT_AUX_LOB_PIECE_TID = 60320; // "__all_region_network_bandwidth_limit_aux_lob_piece"
const uint64_t OB_ALL_DEADLOCK_EVENT_HISTORY_AUX_LOB_PIECE_TID = 60322; // "__all_deadlock_event_history_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_USAGE_AUX_LOB_PIECE_TID = 60323; // "__all_column_usage_aux_lob_piece"
const uint64_t OB_ALL_JOB_AUX_LOB_PIECE_TID = 60324; // "__all_job_aux_lob_piece"
const uint64_t OB_ALL_JOB_LOG_AUX_LOB_PIECE_TID = 60325; // "__all_job_log_aux_lob_piece"
const uint64_t OB_ALL_TENANT_DIRECTORY_AUX_LOB_PIECE_TID = 60326; // "__all_tenant_directory_aux_lob_piece"
const uint64_t OB_ALL_TENANT_DIRECTORY_HISTORY_AUX_LOB_PIECE_TID = 60327; // "__all_tenant_directory_history_aux_lob_piece"
const uint64_t OB_ALL_TABLE_STAT_AUX_LOB_PIECE_TID = 60328; // "__all_table_stat_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_STAT_AUX_LOB_PIECE_TID = 60329; // "__all_column_stat_aux_lob_piece"
const uint64_t OB_ALL_HISTOGRAM_STAT_AUX_LOB_PIECE_TID = 60330; // "__all_histogram_stat_aux_lob_piece"
const uint64_t OB_ALL_MONITOR_MODIFIED_AUX_LOB_PIECE_TID = 60331; // "__all_monitor_modified_aux_lob_piece"
const uint64_t OB_ALL_TABLE_STAT_HISTORY_AUX_LOB_PIECE_TID = 60332; // "__all_table_stat_history_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_STAT_HISTORY_AUX_LOB_PIECE_TID = 60333; // "__all_column_stat_history_aux_lob_piece"
const uint64_t OB_ALL_HISTOGRAM_STAT_HISTORY_AUX_LOB_PIECE_TID = 60334; // "__all_histogram_stat_history_aux_lob_piece"
const uint64_t OB_ALL_OPTSTAT_GLOBAL_PREFS_AUX_LOB_PIECE_TID = 60335; // "__all_optstat_global_prefs_aux_lob_piece"
const uint64_t OB_ALL_OPTSTAT_USER_PREFS_AUX_LOB_PIECE_TID = 60336; // "__all_optstat_user_prefs_aux_lob_piece"
const uint64_t OB_ALL_LS_META_TABLE_AUX_LOB_PIECE_TID = 60342; // "__all_ls_meta_table_aux_lob_piece"
const uint64_t OB_ALL_TABLET_TO_LS_AUX_LOB_PIECE_TID = 60343; // "__all_tablet_to_ls_aux_lob_piece"
const uint64_t OB_ALL_TABLET_META_TABLE_AUX_LOB_PIECE_TID = 60344; // "__all_tablet_meta_table_aux_lob_piece"
const uint64_t OB_ALL_LS_STATUS_AUX_LOB_PIECE_TID = 60345; // "__all_ls_status_aux_lob_piece"
const uint64_t OB_ALL_LOG_ARCHIVE_PROGRESS_AUX_LOB_PIECE_TID = 60348; // "__all_log_archive_progress_aux_lob_piece"
const uint64_t OB_ALL_LOG_ARCHIVE_HISTORY_AUX_LOB_PIECE_TID = 60349; // "__all_log_archive_history_aux_lob_piece"
const uint64_t OB_ALL_LOG_ARCHIVE_PIECE_FILES_AUX_LOB_PIECE_TID = 60350; // "__all_log_archive_piece_files_aux_lob_piece"
const uint64_t OB_ALL_LS_LOG_ARCHIVE_PROGRESS_AUX_LOB_PIECE_TID = 60351; // "__all_ls_log_archive_progress_aux_lob_piece"
const uint64_t OB_ALL_LS_AUX_LOB_PIECE_TID = 60352; // "__all_ls_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_STORAGE_INFO_AUX_LOB_PIECE_TID = 60354; // "__all_backup_storage_info_aux_lob_piece"
const uint64_t OB_ALL_DAM_LAST_ARCH_TS_AUX_LOB_PIECE_TID = 60355; // "__all_dam_last_arch_ts_aux_lob_piece"
const uint64_t OB_ALL_DAM_CLEANUP_JOBS_AUX_LOB_PIECE_TID = 60356; // "__all_dam_cleanup_jobs_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_JOB_AUX_LOB_PIECE_TID = 60357; // "__all_backup_job_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_JOB_HISTORY_AUX_LOB_PIECE_TID = 60358; // "__all_backup_job_history_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_TASK_AUX_LOB_PIECE_TID = 60359; // "__all_backup_task_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_TASK_HISTORY_AUX_LOB_PIECE_TID = 60360; // "__all_backup_task_history_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_LS_TASK_AUX_LOB_PIECE_TID = 60361; // "__all_backup_ls_task_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_LS_TASK_HISTORY_AUX_LOB_PIECE_TID = 60362; // "__all_backup_ls_task_history_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_LS_TASK_INFO_AUX_LOB_PIECE_TID = 60363; // "__all_backup_ls_task_info_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_SKIPPED_TABLET_AUX_LOB_PIECE_TID = 60364; // "__all_backup_skipped_tablet_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_SKIPPED_TABLET_HISTORY_AUX_LOB_PIECE_TID = 60365; // "__all_backup_skipped_tablet_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_INFO_AUX_LOB_PIECE_TID = 60366; // "__all_tenant_info_aux_lob_piece"
const uint64_t OB_ALL_TABLET_TO_TABLE_HISTORY_AUX_LOB_PIECE_TID = 60369; // "__all_tablet_to_table_history_aux_lob_piece"
const uint64_t OB_ALL_LS_RECOVERY_STAT_AUX_LOB_PIECE_TID = 60370; // "__all_ls_recovery_stat_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_LS_TASK_INFO_HISTORY_AUX_LOB_PIECE_TID = 60371; // "__all_backup_ls_task_info_history_aux_lob_piece"
const uint64_t OB_ALL_TABLET_REPLICA_CHECKSUM_AUX_LOB_PIECE_TID = 60372; // "__all_tablet_replica_checksum_aux_lob_piece"
const uint64_t OB_ALL_TABLET_CHECKSUM_AUX_LOB_PIECE_TID = 60373; // "__all_tablet_checksum_aux_lob_piece"
const uint64_t OB_ALL_LS_REPLICA_TASK_AUX_LOB_PIECE_TID = 60374; // "__all_ls_replica_task_aux_lob_piece"
const uint64_t OB_ALL_PENDING_TRANSACTION_AUX_LOB_PIECE_TID = 60375; // "__all_pending_transaction_aux_lob_piece"
const uint64_t OB_ALL_BALANCE_GROUP_LS_STAT_AUX_LOB_PIECE_TID = 60376; // "__all_balance_group_ls_stat_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SCHEDULER_JOB_AUX_LOB_PIECE_TID = 60377; // "__all_tenant_scheduler_job_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SCHEDULER_JOB_RUN_DETAIL_AUX_LOB_PIECE_TID = 60378; // "__all_tenant_scheduler_job_run_detail_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SCHEDULER_PROGRAM_AUX_LOB_PIECE_TID = 60379; // "__all_tenant_scheduler_program_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SCHEDULER_PROGRAM_ARGUMENT_AUX_LOB_PIECE_TID = 60380; // "__all_tenant_scheduler_program_argument_aux_lob_piece"
const uint64_t OB_ALL_CONTEXT_AUX_LOB_PIECE_TID = 60381; // "__all_context_aux_lob_piece"
const uint64_t OB_ALL_CONTEXT_HISTORY_AUX_LOB_PIECE_TID = 60382; // "__all_context_history_aux_lob_piece"
const uint64_t OB_ALL_GLOBAL_CONTEXT_VALUE_AUX_LOB_PIECE_TID = 60383; // "__all_global_context_value_aux_lob_piece"
const uint64_t OB_ALL_LS_ELECTION_REFERENCE_INFO_AUX_LOB_PIECE_TID = 60385; // "__all_ls_election_reference_info_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_DELETE_JOB_AUX_LOB_PIECE_TID = 60386; // "__all_backup_delete_job_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_DELETE_JOB_HISTORY_AUX_LOB_PIECE_TID = 60387; // "__all_backup_delete_job_history_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_DELETE_TASK_AUX_LOB_PIECE_TID = 60388; // "__all_backup_delete_task_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_DELETE_TASK_HISTORY_AUX_LOB_PIECE_TID = 60389; // "__all_backup_delete_task_history_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_DELETE_LS_TASK_AUX_LOB_PIECE_TID = 60390; // "__all_backup_delete_ls_task_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_DELETE_LS_TASK_HISTORY_AUX_LOB_PIECE_TID = 60391; // "__all_backup_delete_ls_task_history_aux_lob_piece"
const uint64_t OB_ALL_ZONE_MERGE_INFO_AUX_LOB_PIECE_TID = 60392; // "__all_zone_merge_info_aux_lob_piece"
const uint64_t OB_ALL_MERGE_INFO_AUX_LOB_PIECE_TID = 60393; // "__all_merge_info_aux_lob_piece"
const uint64_t OB_ALL_FREEZE_INFO_AUX_LOB_PIECE_TID = 60394; // "__all_freeze_info_aux_lob_piece"
const uint64_t OB_ALL_DISK_IO_CALIBRATION_AUX_LOB_PIECE_TID = 60395; // "__all_disk_io_calibration_aux_lob_piece"
const uint64_t OB_ALL_PLAN_BASELINE_AUX_LOB_PIECE_TID = 60396; // "__all_plan_baseline_aux_lob_piece"
const uint64_t OB_ALL_PLAN_BASELINE_ITEM_AUX_LOB_PIECE_TID = 60397; // "__all_plan_baseline_item_aux_lob_piece"
const uint64_t OB_ALL_SPM_CONFIG_AUX_LOB_PIECE_TID = 60398; // "__all_spm_config_aux_lob_piece"
const uint64_t OB_ALL_LOG_ARCHIVE_DEST_PARAMETER_AUX_LOB_PIECE_TID = 60399; // "__all_log_archive_dest_parameter_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_PARAMETER_AUX_LOB_PIECE_TID = 60400; // "__all_backup_parameter_aux_lob_piece"
const uint64_t OB_ALL_LS_RESTORE_PROGRESS_AUX_LOB_PIECE_TID = 60401; // "__all_ls_restore_progress_aux_lob_piece"
const uint64_t OB_ALL_LS_RESTORE_HISTORY_AUX_LOB_PIECE_TID = 60402; // "__all_ls_restore_history_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_STORAGE_INFO_HISTORY_AUX_LOB_PIECE_TID = 60403; // "__all_backup_storage_info_history_aux_lob_piece"
const uint64_t OB_ALL_BACKUP_DELETE_POLICY_AUX_LOB_PIECE_TID = 60404; // "__all_backup_delete_policy_aux_lob_piece"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_AUX_LOB_PIECE_TID = 60405; // "__all_mock_fk_parent_table_aux_lob_piece"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_HISTORY_AUX_LOB_PIECE_TID = 60406; // "__all_mock_fk_parent_table_history_aux_lob_piece"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_AUX_LOB_PIECE_TID = 60407; // "__all_mock_fk_parent_table_column_aux_lob_piece"
const uint64_t OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_HISTORY_AUX_LOB_PIECE_TID = 60408; // "__all_mock_fk_parent_table_column_history_aux_lob_piece"
const uint64_t OB_ALL_LOG_RESTORE_SOURCE_AUX_LOB_PIECE_TID = 60409; // "__all_log_restore_source_aux_lob_piece"
const uint64_t OB_ALL_KV_TTL_TASK_AUX_LOB_PIECE_TID = 60410; // "__all_kv_ttl_task_aux_lob_piece"
const uint64_t OB_ALL_KV_TTL_TASK_HISTORY_AUX_LOB_PIECE_TID = 60411; // "__all_kv_ttl_task_history_aux_lob_piece"
const uint64_t OB_ALL_SERVICE_EPOCH_AUX_LOB_PIECE_TID = 60412; // "__all_service_epoch_aux_lob_piece"
const uint64_t OB_ALL_SPATIAL_REFERENCE_SYSTEMS_AUX_LOB_PIECE_TID = 60413; // "__all_spatial_reference_systems_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_CHECKSUM_ERROR_INFO_AUX_LOB_PIECE_TID = 60416; // "__all_column_checksum_error_info_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_GROUP_AUX_LOB_PIECE_TID = 60419; // "__all_column_group_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_GROUP_HISTORY_AUX_LOB_PIECE_TID = 60420; // "__all_column_group_history_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_GROUP_MAPPING_AUX_LOB_PIECE_TID = 60421; // "__all_column_group_mapping_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_GROUP_MAPPING_HISTORY_AUX_LOB_PIECE_TID = 60422; // "__all_column_group_mapping_history_aux_lob_piece"
const uint64_t OB_ALL_TRANSFER_TASK_AUX_LOB_PIECE_TID = 60423; // "__all_transfer_task_aux_lob_piece"
const uint64_t OB_ALL_TRANSFER_TASK_HISTORY_AUX_LOB_PIECE_TID = 60424; // "__all_transfer_task_history_aux_lob_piece"
const uint64_t OB_ALL_BALANCE_JOB_AUX_LOB_PIECE_TID = 60425; // "__all_balance_job_aux_lob_piece"
const uint64_t OB_ALL_BALANCE_JOB_HISTORY_AUX_LOB_PIECE_TID = 60426; // "__all_balance_job_history_aux_lob_piece"
const uint64_t OB_ALL_BALANCE_TASK_AUX_LOB_PIECE_TID = 60427; // "__all_balance_task_aux_lob_piece"
const uint64_t OB_ALL_BALANCE_TASK_HISTORY_AUX_LOB_PIECE_TID = 60428; // "__all_balance_task_history_aux_lob_piece"
const uint64_t OB_ALL_ARBITRATION_SERVICE_AUX_LOB_PIECE_TID = 60429; // "__all_arbitration_service_aux_lob_piece"
const uint64_t OB_ALL_LS_ARB_REPLICA_TASK_AUX_LOB_PIECE_TID = 60430; // "__all_ls_arb_replica_task_aux_lob_piece"
const uint64_t OB_ALL_DATA_DICTIONARY_IN_LOG_AUX_LOB_PIECE_TID = 60431; // "__all_data_dictionary_in_log_aux_lob_piece"
const uint64_t OB_ALL_LS_ARB_REPLICA_TASK_HISTORY_AUX_LOB_PIECE_TID = 60432; // "__all_ls_arb_replica_task_history_aux_lob_piece"
const uint64_t OB_ALL_RLS_POLICY_AUX_LOB_PIECE_TID = 60433; // "__all_rls_policy_aux_lob_piece"
const uint64_t OB_ALL_RLS_POLICY_HISTORY_AUX_LOB_PIECE_TID = 60434; // "__all_rls_policy_history_aux_lob_piece"
const uint64_t OB_ALL_RLS_SECURITY_COLUMN_AUX_LOB_PIECE_TID = 60435; // "__all_rls_security_column_aux_lob_piece"
const uint64_t OB_ALL_RLS_SECURITY_COLUMN_HISTORY_AUX_LOB_PIECE_TID = 60436; // "__all_rls_security_column_history_aux_lob_piece"
const uint64_t OB_ALL_RLS_GROUP_AUX_LOB_PIECE_TID = 60437; // "__all_rls_group_aux_lob_piece"
const uint64_t OB_ALL_RLS_GROUP_HISTORY_AUX_LOB_PIECE_TID = 60438; // "__all_rls_group_history_aux_lob_piece"
const uint64_t OB_ALL_RLS_CONTEXT_AUX_LOB_PIECE_TID = 60439; // "__all_rls_context_aux_lob_piece"
const uint64_t OB_ALL_RLS_CONTEXT_HISTORY_AUX_LOB_PIECE_TID = 60440; // "__all_rls_context_history_aux_lob_piece"
const uint64_t OB_ALL_RLS_ATTRIBUTE_AUX_LOB_PIECE_TID = 60441; // "__all_rls_attribute_aux_lob_piece"
const uint64_t OB_ALL_RLS_ATTRIBUTE_HISTORY_AUX_LOB_PIECE_TID = 60442; // "__all_rls_attribute_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_REWRITE_RULES_AUX_LOB_PIECE_TID = 60443; // "__all_tenant_rewrite_rules_aux_lob_piece"
const uint64_t OB_ALL_RESERVED_SNAPSHOT_AUX_LOB_PIECE_TID = 60444; // "__all_reserved_snapshot_aux_lob_piece"
const uint64_t OB_ALL_CLUSTER_EVENT_HISTORY_AUX_LOB_PIECE_TID = 60445; // "__all_cluster_event_history_aux_lob_piece"
const uint64_t OB_ALL_LS_TRANSFER_MEMBER_LIST_LOCK_INFO_AUX_LOB_PIECE_TID = 60446; // "__all_ls_transfer_member_list_lock_info_aux_lob_piece"
const uint64_t OB_ALL_EXTERNAL_TABLE_FILE_AUX_LOB_PIECE_TID = 60450; // "__all_external_table_file_aux_lob_piece"
const uint64_t OB_ALL_TASK_OPT_STAT_GATHER_HISTORY_AUX_LOB_PIECE_TID = 60451; // "__all_task_opt_stat_gather_history_aux_lob_piece"
const uint64_t OB_ALL_TABLE_OPT_STAT_GATHER_HISTORY_AUX_LOB_PIECE_TID = 60452; // "__all_table_opt_stat_gather_history_aux_lob_piece"
const uint64_t OB_ALL_ZONE_STORAGE_AUX_LOB_PIECE_TID = 60453; // "__all_zone_storage_aux_lob_piece"
const uint64_t OB_ALL_ZONE_STORAGE_OPERATION_AUX_LOB_PIECE_TID = 60454; // "__all_zone_storage_operation_aux_lob_piece"
const uint64_t OB_WR_ACTIVE_SESSION_HISTORY_AUX_LOB_PIECE_TID = 60455; // "__wr_active_session_history_aux_lob_piece"
const uint64_t OB_WR_SNAPSHOT_AUX_LOB_PIECE_TID = 60456; // "__wr_snapshot_aux_lob_piece"
const uint64_t OB_WR_STATNAME_AUX_LOB_PIECE_TID = 60457; // "__wr_statname_aux_lob_piece"
const uint64_t OB_WR_SYSSTAT_AUX_LOB_PIECE_TID = 60458; // "__wr_sysstat_aux_lob_piece"
const uint64_t OB_ALL_BALANCE_TASK_HELPER_AUX_LOB_PIECE_TID = 60459; // "__all_balance_task_helper_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SNAPSHOT_AUX_LOB_PIECE_TID = 60460; // "__all_tenant_snapshot_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SNAPSHOT_LS_AUX_LOB_PIECE_TID = 60461; // "__all_tenant_snapshot_ls_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_AUX_LOB_PIECE_TID = 60462; // "__all_tenant_snapshot_ls_replica_aux_lob_piece"
const uint64_t OB_ALL_MLOG_AUX_LOB_PIECE_TID = 60463; // "__all_mlog_aux_lob_piece"
const uint64_t OB_ALL_MVIEW_AUX_LOB_PIECE_TID = 60464; // "__all_mview_aux_lob_piece"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_AUX_LOB_PIECE_TID = 60465; // "__all_mview_refresh_stats_sys_defaults_aux_lob_piece"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_PARAMS_AUX_LOB_PIECE_TID = 60466; // "__all_mview_refresh_stats_params_aux_lob_piece"
const uint64_t OB_ALL_MVIEW_REFRESH_RUN_STATS_AUX_LOB_PIECE_TID = 60467; // "__all_mview_refresh_run_stats_aux_lob_piece"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_AUX_LOB_PIECE_TID = 60468; // "__all_mview_refresh_stats_aux_lob_piece"
const uint64_t OB_ALL_MVIEW_REFRESH_CHANGE_STATS_AUX_LOB_PIECE_TID = 60469; // "__all_mview_refresh_change_stats_aux_lob_piece"
const uint64_t OB_ALL_MVIEW_REFRESH_STMT_STATS_AUX_LOB_PIECE_TID = 60470; // "__all_mview_refresh_stmt_stats_aux_lob_piece"
const uint64_t OB_ALL_DBMS_LOCK_ALLOCATED_AUX_LOB_PIECE_TID = 60471; // "__all_dbms_lock_allocated_aux_lob_piece"
const uint64_t OB_WR_CONTROL_AUX_LOB_PIECE_TID = 60472; // "__wr_control_aux_lob_piece"
const uint64_t OB_ALL_TENANT_EVENT_HISTORY_AUX_LOB_PIECE_TID = 60473; // "__all_tenant_event_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SCHEDULER_JOB_CLASS_AUX_LOB_PIECE_TID = 60474; // "__all_tenant_scheduler_job_class_aux_lob_piece"
const uint64_t OB_ALL_RECOVER_TABLE_JOB_AUX_LOB_PIECE_TID = 60475; // "__all_recover_table_job_aux_lob_piece"
const uint64_t OB_ALL_RECOVER_TABLE_JOB_HISTORY_AUX_LOB_PIECE_TID = 60476; // "__all_recover_table_job_history_aux_lob_piece"
const uint64_t OB_ALL_IMPORT_TABLE_JOB_AUX_LOB_PIECE_TID = 60477; // "__all_import_table_job_aux_lob_piece"
const uint64_t OB_ALL_IMPORT_TABLE_JOB_HISTORY_AUX_LOB_PIECE_TID = 60478; // "__all_import_table_job_history_aux_lob_piece"
const uint64_t OB_ALL_IMPORT_TABLE_TASK_AUX_LOB_PIECE_TID = 60479; // "__all_import_table_task_aux_lob_piece"
const uint64_t OB_ALL_IMPORT_TABLE_TASK_HISTORY_AUX_LOB_PIECE_TID = 60480; // "__all_import_table_task_history_aux_lob_piece"
const uint64_t OB_ALL_TABLET_REORGANIZE_HISTORY_AUX_LOB_PIECE_TID = 60482; // "__all_tablet_reorganize_history_aux_lob_piece"
const uint64_t OB_ALL_STORAGE_HA_ERROR_DIAGNOSE_HISTORY_AUX_LOB_PIECE_TID = 60483; // "__all_storage_ha_error_diagnose_history_aux_lob_piece"
const uint64_t OB_ALL_STORAGE_HA_PERF_DIAGNOSE_HISTORY_AUX_LOB_PIECE_TID = 60484; // "__all_storage_ha_perf_diagnose_history_aux_lob_piece"
const uint64_t OB_ALL_CLONE_JOB_AUX_LOB_PIECE_TID = 60485; // "__all_clone_job_aux_lob_piece"
const uint64_t OB_ALL_CLONE_JOB_HISTORY_AUX_LOB_PIECE_TID = 60486; // "__all_clone_job_history_aux_lob_piece"
const uint64_t OB_WR_SYSTEM_EVENT_AUX_LOB_PIECE_TID = 60487; // "__wr_system_event_aux_lob_piece"
const uint64_t OB_WR_EVENT_NAME_AUX_LOB_PIECE_TID = 60488; // "__wr_event_name_aux_lob_piece"
const uint64_t OB_ALL_ROUTINE_PRIVILEGE_AUX_LOB_PIECE_TID = 60490; // "__all_routine_privilege_aux_lob_piece"
const uint64_t OB_ALL_ROUTINE_PRIVILEGE_HISTORY_AUX_LOB_PIECE_TID = 60491; // "__all_routine_privilege_history_aux_lob_piece"
const uint64_t OB_WR_SQLSTAT_AUX_LOB_PIECE_TID = 60492; // "__wr_sqlstat_aux_lob_piece"
const uint64_t OB_ALL_NCOMP_DLL_AUX_LOB_PIECE_TID = 60493; // "__all_ncomp_dll_aux_lob_piece"
const uint64_t OB_ALL_AUX_STAT_AUX_LOB_PIECE_TID = 60494; // "__all_aux_stat_aux_lob_piece"
const uint64_t OB_ALL_INDEX_USAGE_INFO_AUX_LOB_PIECE_TID = 60495; // "__all_index_usage_info_aux_lob_piece"
const uint64_t OB_ALL_DETECT_LOCK_INFO_AUX_LOB_PIECE_TID = 60496; // "__all_detect_lock_info_aux_lob_piece"
const uint64_t OB_ALL_CLIENT_TO_SERVER_SESSION_INFO_AUX_LOB_PIECE_TID = 60497; // "__all_client_to_server_session_info_aux_lob_piece"
const uint64_t OB_ALL_TRANSFER_PARTITION_TASK_AUX_LOB_PIECE_TID = 60498; // "__all_transfer_partition_task_aux_lob_piece"
const uint64_t OB_ALL_TRANSFER_PARTITION_TASK_HISTORY_AUX_LOB_PIECE_TID = 60499; // "__all_transfer_partition_task_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SNAPSHOT_JOB_AUX_LOB_PIECE_TID = 60500; // "__all_tenant_snapshot_job_aux_lob_piece"
const uint64_t OB_WR_SQLTEXT_AUX_LOB_PIECE_TID = 60501; // "__wr_sqltext_aux_lob_piece"
const uint64_t OB_ALL_TRUSTED_ROOT_CERTIFICATE_AUX_LOB_PIECE_TID = 60502; // "__all_trusted_root_certificate_aux_lob_piece"
const uint64_t OB_ALL_AUDIT_LOG_FILTER_AUX_LOB_PIECE_TID = 60503; // "__all_audit_log_filter_aux_lob_piece"
const uint64_t OB_ALL_AUDIT_LOG_USER_AUX_LOB_PIECE_TID = 60504; // "__all_audit_log_user_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_PRIVILEGE_AUX_LOB_PIECE_TID = 60505; // "__all_column_privilege_aux_lob_piece"
const uint64_t OB_ALL_COLUMN_PRIVILEGE_HISTORY_AUX_LOB_PIECE_TID = 60506; // "__all_column_privilege_history_aux_lob_piece"
const uint64_t OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_HISTORY_AUX_LOB_PIECE_TID = 60507; // "__all_tenant_snapshot_ls_replica_history_aux_lob_piece"
const uint64_t OB_ALL_LS_REPLICA_TASK_HISTORY_AUX_LOB_PIECE_TID = 60508; // "__all_ls_replica_task_history_aux_lob_piece"
const uint64_t OB_ALL_TABLET_CHECKSUM_ERROR_INFO_AUX_LOB_PIECE_TID = 60511; // "__all_tablet_checksum_error_info_aux_lob_piece"
const uint64_t OB_ALL_USER_PROXY_INFO_AUX_LOB_PIECE_TID = 60512; // "__all_user_proxy_info_aux_lob_piece"
const uint64_t OB_ALL_USER_PROXY_INFO_HISTORY_AUX_LOB_PIECE_TID = 60513; // "__all_user_proxy_info_history_aux_lob_piece"
const uint64_t OB_ALL_USER_PROXY_ROLE_INFO_AUX_LOB_PIECE_TID = 60514; // "__all_user_proxy_role_info_aux_lob_piece"
const uint64_t OB_ALL_USER_PROXY_ROLE_INFO_HISTORY_AUX_LOB_PIECE_TID = 60515; // "__all_user_proxy_role_info_history_aux_lob_piece"
const uint64_t OB_ALL_SERVICE_AUX_LOB_PIECE_TID = 60516; // "__all_service_aux_lob_piece"
const uint64_t OB_ALL_STORAGE_IO_USAGE_AUX_LOB_PIECE_TID = 60517; // "__all_storage_io_usage_aux_lob_piece"
const uint64_t OB_ALL_MVIEW_DEP_AUX_LOB_PIECE_TID = 60518; // "__all_mview_dep_aux_lob_piece"
const uint64_t OB_ALL_SCHEDULER_JOB_RUN_DETAIL_V2_AUX_LOB_PIECE_TID = 60519; // "__all_scheduler_job_run_detail_v2_aux_lob_piece"
const uint64_t OB_ALL_SPM_EVO_RESULT_AUX_LOB_PIECE_TID = 60520; // "__all_spm_evo_result_aux_lob_piece"
const uint64_t OB_ALL_PKG_TYPE_AUX_LOB_PIECE_TID = 60522; // "__all_pkg_type_aux_lob_piece"
const uint64_t OB_ALL_PKG_TYPE_ATTR_AUX_LOB_PIECE_TID = 60523; // "__all_pkg_type_attr_aux_lob_piece"
const uint64_t OB_ALL_PKG_COLL_TYPE_AUX_LOB_PIECE_TID = 60524; // "__all_pkg_coll_type_aux_lob_piece"
const uint64_t OB_WR_SQL_PLAN_AUX_LOB_PIECE_TID = 60525; // "__wr_sql_plan_aux_lob_piece"
const uint64_t OB_ALL_KV_REDIS_TABLE_AUX_LOB_PIECE_TID = 60527; // "__all_kv_redis_table_aux_lob_piece"
const uint64_t OB_ALL_NCOMP_DLL_V2_AUX_LOB_PIECE_TID = 60528; // "__all_ncomp_dll_v2_aux_lob_piece"
const uint64_t OB_FT_DICT_IK_UTF8_AUX_LOB_PIECE_TID = 60531; // "__ft_dict_ik_utf8_aux_lob_piece"
const uint64_t OB_FT_STOPWORD_IK_UTF8_AUX_LOB_PIECE_TID = 60532; // "__ft_stopword_ik_utf8_aux_lob_piece"
const uint64_t OB_FT_QUANTIFIER_IK_UTF8_AUX_LOB_PIECE_TID = 60533; // "__ft_quantifier_ik_utf8_aux_lob_piece"
const uint64_t OB_ALL_VIRTUAL_PLAN_CACHE_STAT_ALL_VIRTUAL_PLAN_CACHE_STAT_I1_TID = 14999; // "__all_virtual_plan_cache_stat"
const uint64_t OB_ALL_VIRTUAL_SESSION_EVENT_ALL_VIRTUAL_SESSION_EVENT_I1_TID = 14998; // "__all_virtual_session_event"
const uint64_t OB_ALL_VIRTUAL_SESSION_WAIT_ALL_VIRTUAL_SESSION_WAIT_I1_TID = 14997; // "__all_virtual_session_wait"
const uint64_t OB_ALL_VIRTUAL_SESSION_WAIT_HISTORY_ALL_VIRTUAL_SESSION_WAIT_HISTORY_I1_TID = 14996; // "__all_virtual_session_wait_history"
const uint64_t OB_ALL_VIRTUAL_SYSTEM_EVENT_ALL_VIRTUAL_SYSTEM_EVENT_I1_TID = 14995; // "__all_virtual_system_event"
const uint64_t OB_ALL_VIRTUAL_SESSTAT_ALL_VIRTUAL_SESSTAT_I1_TID = 14994; // "__all_virtual_sesstat"
const uint64_t OB_ALL_VIRTUAL_SYSSTAT_ALL_VIRTUAL_SYSSTAT_I1_TID = 14993; // "__all_virtual_sysstat"
const uint64_t OB_ALL_VIRTUAL_SQL_AUDIT_ALL_VIRTUAL_SQL_AUDIT_I1_TID = 14992; // "__all_virtual_sql_audit"
const uint64_t OB_ALL_VIRTUAL_SQL_PLAN_MONITOR_ALL_VIRTUAL_SQL_PLAN_MONITOR_I1_TID = 14991; // "__all_virtual_sql_plan_monitor"
const uint64_t OB_ALL_VIRTUAL_ASH_ALL_VIRTUAL_ASH_I1_TID = 14990; // "__all_virtual_ash"
const uint64_t OB_ALL_VIRTUAL_DDL_DIAGNOSE_INFO_ALL_VIRTUAL_DDL_DIAGNOSE_INFO_I1_TID = 14989; // "__all_virtual_ddl_diagnose_info"
const uint64_t OB_ALL_VIRTUAL_SQL_AUDIT_ORA_ALL_VIRTUAL_SQL_AUDIT_I1_TID = 19999; // "ALL_VIRTUAL_SQL_AUDIT_ORA"
const uint64_t OB_ALL_VIRTUAL_PLAN_CACHE_STAT_ORA_ALL_VIRTUAL_PLAN_CACHE_STAT_I1_TID = 19998; // "ALL_VIRTUAL_PLAN_CACHE_STAT_ORA"
const uint64_t OB_ALL_VIRTUAL_SESSION_WAIT_ORA_ALL_VIRTUAL_SESSION_WAIT_I1_TID = 19997; // "ALL_VIRTUAL_SESSION_WAIT_ORA"
const uint64_t OB_ALL_VIRTUAL_SESSION_WAIT_HISTORY_ORA_ALL_VIRTUAL_SESSION_WAIT_HISTORY_I1_TID = 19996; // "ALL_VIRTUAL_SESSION_WAIT_HISTORY_ORA"
const uint64_t OB_ALL_VIRTUAL_SESSTAT_ORA_ALL_VIRTUAL_SESSTAT_I1_TID = 19995; // "ALL_VIRTUAL_SESSTAT_ORA"
const uint64_t OB_ALL_VIRTUAL_SYSSTAT_ORA_ALL_VIRTUAL_SYSSTAT_I1_TID = 19994; // "ALL_VIRTUAL_SYSSTAT_ORA"
const uint64_t OB_ALL_VIRTUAL_SYSTEM_EVENT_ORA_ALL_VIRTUAL_SYSTEM_EVENT_I1_TID = 19993; // "ALL_VIRTUAL_SYSTEM_EVENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SQL_PLAN_MONITOR_ORA_ALL_VIRTUAL_SQL_PLAN_MONITOR_I1_TID = 19992; // "ALL_VIRTUAL_SQL_PLAN_MONITOR_ORA"
const uint64_t OB_ALL_VIRTUAL_ASH_ORA_ALL_VIRTUAL_ASH_I1_TID = 19991; // "ALL_VIRTUAL_ASH_ORA"
const uint64_t OB_ALL_TABLE_IDX_DATA_TABLE_ID_TID = 100001; // "__all_table"
const uint64_t OB_ALL_TABLE_IDX_DB_TB_NAME_TID = 100002; // "__all_table"
const uint64_t OB_ALL_TABLE_IDX_TB_NAME_TID = 100003; // "__all_table"
const uint64_t OB_ALL_COLUMN_IDX_TB_COLUMN_NAME_TID = 100004; // "__all_column"
const uint64_t OB_ALL_COLUMN_IDX_COLUMN_NAME_TID = 100005; // "__all_column"
const uint64_t OB_ALL_DDL_OPERATION_IDX_DDL_TYPE_TID = 100006; // "__all_ddl_operation"
const uint64_t OB_ALL_TABLE_HISTORY_IDX_DATA_TABLE_ID_TID = 101001; // "__all_table_history"
const uint64_t OB_ALL_LOG_ARCHIVE_PIECE_FILES_IDX_STATUS_TID = 101002; // "__all_log_archive_piece_files"
const uint64_t OB_ALL_BACKUP_SET_FILES_IDX_STATUS_TID = 101003; // "__all_backup_set_files"
const uint64_t OB_ALL_DDL_TASK_STATUS_IDX_TASK_KEY_TID = 101004; // "__all_ddl_task_status"
const uint64_t OB_ALL_USER_IDX_UR_NAME_TID = 101005; // "__all_user"
const uint64_t OB_ALL_DATABASE_IDX_DB_NAME_TID = 101006; // "__all_database"
const uint64_t OB_ALL_TABLEGROUP_IDX_TG_NAME_TID = 101007; // "__all_tablegroup"
const uint64_t OB_ALL_TENANT_HISTORY_IDX_TENANT_DELETED_TID = 101008; // "__all_tenant_history"
const uint64_t OB_ALL_ROOTSERVICE_EVENT_HISTORY_IDX_RS_MODULE_TID = 101009; // "__all_rootservice_event_history"
const uint64_t OB_ALL_ROOTSERVICE_EVENT_HISTORY_IDX_RS_EVENT_TID = 101010; // "__all_rootservice_event_history"
const uint64_t OB_ALL_RECYCLEBIN_IDX_RECYCLEBIN_DB_TYPE_TID = 101011; // "__all_recyclebin"
const uint64_t OB_ALL_PART_IDX_PART_NAME_TID = 101012; // "__all_part"
const uint64_t OB_ALL_SUB_PART_IDX_SUB_PART_NAME_TID = 101013; // "__all_sub_part"
const uint64_t OB_ALL_DEF_SUB_PART_IDX_DEF_SUB_PART_NAME_TID = 101014; // "__all_def_sub_part"
const uint64_t OB_ALL_SERVER_EVENT_HISTORY_IDX_SERVER_MODULE_TID = 101015; // "__all_server_event_history"
const uint64_t OB_ALL_SERVER_EVENT_HISTORY_IDX_SERVER_EVENT_TID = 101016; // "__all_server_event_history"
const uint64_t OB_ALL_ROOTSERVICE_JOB_IDX_RS_JOB_TYPE_TID = 101017; // "__all_rootservice_job"
const uint64_t OB_ALL_FOREIGN_KEY_IDX_FK_CHILD_TID_TID = 101018; // "__all_foreign_key"
const uint64_t OB_ALL_FOREIGN_KEY_IDX_FK_PARENT_TID_TID = 101019; // "__all_foreign_key"
const uint64_t OB_ALL_FOREIGN_KEY_IDX_FK_NAME_TID = 101020; // "__all_foreign_key"
const uint64_t OB_ALL_FOREIGN_KEY_HISTORY_IDX_FK_HIS_CHILD_TID_TID = 101021; // "__all_foreign_key_history"
const uint64_t OB_ALL_FOREIGN_KEY_HISTORY_IDX_FK_HIS_PARENT_TID_TID = 101022; // "__all_foreign_key_history"
const uint64_t OB_ALL_SYNONYM_IDX_DB_SYNONYM_NAME_TID = 101023; // "__all_synonym"
const uint64_t OB_ALL_SYNONYM_IDX_SYNONYM_NAME_TID = 101024; // "__all_synonym"
const uint64_t OB_ALL_DDL_CHECKSUM_IDX_DDL_CHECKSUM_TASK_TID = 101025; // "__all_ddl_checksum"
const uint64_t OB_ALL_ROUTINE_IDX_DB_ROUTINE_NAME_TID = 101026; // "__all_routine"
const uint64_t OB_ALL_ROUTINE_IDX_ROUTINE_NAME_TID = 101027; // "__all_routine"
const uint64_t OB_ALL_ROUTINE_IDX_ROUTINE_PKG_ID_TID = 101028; // "__all_routine"
const uint64_t OB_ALL_ROUTINE_PARAM_IDX_ROUTINE_PARAM_NAME_TID = 101029; // "__all_routine_param"
const uint64_t OB_ALL_PACKAGE_IDX_DB_PKG_NAME_TID = 101030; // "__all_package"
const uint64_t OB_ALL_PACKAGE_IDX_PKG_NAME_TID = 101031; // "__all_package"
const uint64_t OB_ALL_ACQUIRED_SNAPSHOT_IDX_SNAPSHOT_TABLET_TID = 101032; // "__all_acquired_snapshot"
const uint64_t OB_ALL_CONSTRAINT_IDX_CST_NAME_TID = 101033; // "__all_constraint"
const uint64_t OB_ALL_TYPE_IDX_DB_TYPE_NAME_TID = 101034; // "__all_type"
const uint64_t OB_ALL_TYPE_IDX_TYPE_NAME_TID = 101035; // "__all_type"
const uint64_t OB_ALL_TYPE_ATTR_IDX_TYPE_ATTR_NAME_TID = 101036; // "__all_type_attr"
const uint64_t OB_ALL_COLL_TYPE_IDX_COLL_NAME_TYPE_TID = 101037; // "__all_coll_type"
const uint64_t OB_ALL_DBLINK_IDX_OWNER_DBLINK_NAME_TID = 101038; // "__all_dblink"
const uint64_t OB_ALL_DBLINK_IDX_DBLINK_NAME_TID = 101039; // "__all_dblink"
const uint64_t OB_ALL_TENANT_ROLE_GRANTEE_MAP_IDX_GRANTEE_ROLE_ID_TID = 101040; // "__all_tenant_role_grantee_map"
const uint64_t OB_ALL_TENANT_ROLE_GRANTEE_MAP_HISTORY_IDX_GRANTEE_HIS_ROLE_ID_TID = 101041; // "__all_tenant_role_grantee_map_history"
const uint64_t OB_ALL_TENANT_KEYSTORE_IDX_KEYSTORE_MASTER_KEY_ID_TID = 101042; // "__all_tenant_keystore"
const uint64_t OB_ALL_TENANT_KEYSTORE_HISTORY_IDX_KEYSTORE_HIS_MASTER_KEY_ID_TID = 101043; // "__all_tenant_keystore_history"
const uint64_t OB_ALL_TENANT_OLS_POLICY_IDX_OLS_POLICY_NAME_TID = 101044; // "__all_tenant_ols_policy"
const uint64_t OB_ALL_TENANT_OLS_POLICY_IDX_OLS_POLICY_COL_NAME_TID = 101045; // "__all_tenant_ols_policy"
const uint64_t OB_ALL_TENANT_OLS_COMPONENT_IDX_OLS_COM_POLICY_ID_TID = 101046; // "__all_tenant_ols_component"
const uint64_t OB_ALL_TENANT_OLS_LABEL_IDX_OLS_LAB_POLICY_ID_TID = 101047; // "__all_tenant_ols_label"
const uint64_t OB_ALL_TENANT_OLS_LABEL_IDX_OLS_LAB_TAG_TID = 101048; // "__all_tenant_ols_label"
const uint64_t OB_ALL_TENANT_OLS_LABEL_IDX_OLS_LAB_TID = 101049; // "__all_tenant_ols_label"
const uint64_t OB_ALL_TENANT_OLS_USER_LEVEL_IDX_OLS_LEVEL_UID_TID = 101050; // "__all_tenant_ols_user_level"
const uint64_t OB_ALL_TENANT_OLS_USER_LEVEL_IDX_OLS_LEVEL_POLICY_ID_TID = 101051; // "__all_tenant_ols_user_level"
const uint64_t OB_ALL_TENANT_PROFILE_IDX_PROFILE_NAME_TID = 101052; // "__all_tenant_profile"
const uint64_t OB_ALL_TENANT_SECURITY_AUDIT_IDX_AUDIT_TYPE_TID = 101053; // "__all_tenant_security_audit"
const uint64_t OB_ALL_TENANT_TRIGGER_IDX_TRIGGER_BASE_OBJ_ID_TID = 101054; // "__all_tenant_trigger"
const uint64_t OB_ALL_TENANT_TRIGGER_IDX_DB_TRIGGER_NAME_TID = 101055; // "__all_tenant_trigger"
const uint64_t OB_ALL_TENANT_TRIGGER_IDX_TRIGGER_NAME_TID = 101056; // "__all_tenant_trigger"
const uint64_t OB_ALL_TENANT_TRIGGER_HISTORY_IDX_TRIGGER_HIS_BASE_OBJ_ID_TID = 101057; // "__all_tenant_trigger_history"
const uint64_t OB_ALL_TENANT_OBJAUTH_IDX_OBJAUTH_GRANTOR_TID = 101058; // "__all_tenant_objauth"
const uint64_t OB_ALL_TENANT_OBJAUTH_IDX_OBJAUTH_GRANTEE_TID = 101059; // "__all_tenant_objauth"
const uint64_t OB_ALL_TENANT_OBJECT_TYPE_IDX_OBJ_TYPE_DB_OBJ_NAME_TID = 101060; // "__all_tenant_object_type"
const uint64_t OB_ALL_TENANT_OBJECT_TYPE_IDX_OBJ_TYPE_OBJ_NAME_TID = 101061; // "__all_tenant_object_type"
const uint64_t OB_ALL_TENANT_GLOBAL_TRANSACTION_IDX_XA_TRANS_ID_TID = 101062; // "__all_tenant_global_transaction"
const uint64_t OB_ALL_TENANT_DEPENDENCY_IDX_DEPENDENCY_REF_OBJ_TID = 101063; // "__all_tenant_dependency"
const uint64_t OB_ALL_DDL_ERROR_MESSAGE_IDX_DDL_ERROR_OBJECT_TID = 101064; // "__all_ddl_error_message"
const uint64_t OB_ALL_TABLE_STAT_HISTORY_IDX_TABLE_STAT_HIS_SAVTIME_TID = 101065; // "__all_table_stat_history"
const uint64_t OB_ALL_COLUMN_STAT_HISTORY_IDX_COLUMN_STAT_HIS_SAVTIME_TID = 101066; // "__all_column_stat_history"
const uint64_t OB_ALL_HISTOGRAM_STAT_HISTORY_IDX_HISTOGRAM_STAT_HIS_SAVTIME_TID = 101067; // "__all_histogram_stat_history"
const uint64_t OB_ALL_TABLET_TO_LS_IDX_TABLET_TO_LS_ID_TID = 101068; // "__all_tablet_to_ls"
const uint64_t OB_ALL_TABLET_TO_LS_IDX_TABLET_TO_TABLE_ID_TID = 101069; // "__all_tablet_to_ls"
const uint64_t OB_ALL_PENDING_TRANSACTION_IDX_PENDING_TX_ID_TID = 101070; // "__all_pending_transaction"
const uint64_t OB_ALL_CONTEXT_IDX_CTX_NAMESPACE_TID = 101071; // "__all_context"
const uint64_t OB_ALL_PLAN_BASELINE_ITEM_IDX_SPM_ITEM_SQL_ID_TID = 101072; // "__all_plan_baseline_item"
const uint64_t OB_ALL_PLAN_BASELINE_ITEM_IDX_SPM_ITEM_VALUE_TID = 101073; // "__all_plan_baseline_item"
const uint64_t OB_ALL_TENANT_DIRECTORY_IDX_DIRECTORY_NAME_TID = 101074; // "__all_tenant_directory"
const uint64_t OB_ALL_JOB_IDX_JOB_POWNER_TID = 101075; // "__all_job"
const uint64_t OB_ALL_SEQUENCE_OBJECT_IDX_SEQ_OBJ_DB_NAME_TID = 101076; // "__all_sequence_object"
const uint64_t OB_ALL_SEQUENCE_OBJECT_IDX_SEQ_OBJ_NAME_TID = 101077; // "__all_sequence_object"
const uint64_t OB_ALL_RECYCLEBIN_IDX_RECYCLEBIN_ORI_NAME_TID = 101078; // "__all_recyclebin"
const uint64_t OB_ALL_TABLE_PRIVILEGE_IDX_TB_PRIV_DB_NAME_TID = 101079; // "__all_table_privilege"
const uint64_t OB_ALL_TABLE_PRIVILEGE_IDX_TB_PRIV_TB_NAME_TID = 101080; // "__all_table_privilege"
const uint64_t OB_ALL_DATABASE_PRIVILEGE_IDX_DB_PRIV_DB_NAME_TID = 101081; // "__all_database_privilege"
const uint64_t OB_ALL_RLS_POLICY_IDX_RLS_POLICY_TABLE_ID_TID = 101082; // "__all_rls_policy"
const uint64_t OB_ALL_RLS_POLICY_IDX_RLS_POLICY_GROUP_ID_TID = 101083; // "__all_rls_policy"
const uint64_t OB_ALL_RLS_POLICY_HISTORY_IDX_RLS_POLICY_HIS_TABLE_ID_TID = 101084; // "__all_rls_policy_history"
const uint64_t OB_ALL_RLS_GROUP_IDX_RLS_GROUP_TABLE_ID_TID = 101085; // "__all_rls_group"
const uint64_t OB_ALL_RLS_GROUP_HISTORY_IDX_RLS_GROUP_HIS_TABLE_ID_TID = 101086; // "__all_rls_group_history"
const uint64_t OB_ALL_RLS_CONTEXT_IDX_RLS_CONTEXT_TABLE_ID_TID = 101087; // "__all_rls_context"
const uint64_t OB_ALL_RLS_CONTEXT_HISTORY_IDX_RLS_CONTEXT_HIS_TABLE_ID_TID = 101088; // "__all_rls_context_history"
const uint64_t OB_ALL_TENANT_SNAPSHOT_IDX_TENANT_SNAPSHOT_NAME_TID = 101089; // "__all_tenant_snapshot"
const uint64_t OB_ALL_DBMS_LOCK_ALLOCATED_IDX_DBMS_LOCK_ALLOCATED_LOCKHANDLE_TID = 101090; // "__all_dbms_lock_allocated"
const uint64_t OB_ALL_DBMS_LOCK_ALLOCATED_IDX_DBMS_LOCK_ALLOCATED_EXPIRATION_TID = 101091; // "__all_dbms_lock_allocated"
const uint64_t OB_ALL_TABLET_REORGANIZE_HISTORY_IDX_TABLET_HIS_TABLE_ID_SRC_TID = 101092; // "__all_tablet_reorganize_history"
const uint64_t OB_ALL_KV_TTL_TASK_IDX_KV_TTL_TASK_TABLE_ID_TID = 101093; // "__all_kv_ttl_task"
const uint64_t OB_ALL_KV_TTL_TASK_HISTORY_IDX_KV_TTL_TASK_HISTORY_UPD_TIME_TID = 101094; // "__all_kv_ttl_task_history"
const uint64_t OB_ALL_MVIEW_REFRESH_RUN_STATS_IDX_MVIEW_REFRESH_RUN_STATS_NUM_MVS_CURRENT_TID = 101095; // "__all_mview_refresh_run_stats"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_IDX_MVIEW_REFRESH_STATS_END_TIME_TID = 101096; // "__all_mview_refresh_stats"
const uint64_t OB_ALL_MVIEW_REFRESH_STATS_IDX_MVIEW_REFRESH_STATS_MVIEW_END_TIME_TID = 101097; // "__all_mview_refresh_stats"
const uint64_t OB_ALL_TRANSFER_PARTITION_TASK_IDX_TRANSFER_PARTITION_KEY_TID = 101098; // "__all_transfer_partition_task"
const uint64_t OB_ALL_CLIENT_TO_SERVER_SESSION_INFO_IDX_CLIENT_TO_SERVER_SESSION_INFO_CLIENT_SESSION_ID_TID = 101099; // "__all_client_to_server_session_info"
const uint64_t OB_ALL_COLUMN_PRIVILEGE_IDX_COLUMN_PRIVILEGE_NAME_TID = 101100; // "__all_column_privilege"
const uint64_t OB_ALL_USER_PROXY_INFO_IDX_USER_PROXY_INFO_PROXY_USER_ID_TID = 101101; // "__all_user_proxy_info"
const uint64_t OB_ALL_USER_PROXY_INFO_HISTORY_IDX_USER_PROXY_INFO_PROXY_USER_ID_HISTORY_TID = 101102; // "__all_user_proxy_info_history"
const uint64_t OB_ALL_USER_PROXY_ROLE_INFO_HISTORY_IDX_USER_PROXY_ROLE_INFO_PROXY_USER_ID_HISTORY_TID = 101103; // "__all_user_proxy_role_info_history"
const uint64_t OB_ALL_SCHEDULER_JOB_RUN_DETAIL_V2_IDX_SCHEDULER_JOB_RUN_DETAIL_V2_TIME_TID = 101105; // "__all_scheduler_job_run_detail_v2"
const uint64_t OB_ALL_SCHEDULER_JOB_RUN_DETAIL_V2_IDX_SCHEDULER_JOB_RUN_DETAIL_V2_JOB_CLASS_TIME_TID = 101106; // "__all_scheduler_job_run_detail_v2"
const uint64_t OB_ALL_PKG_TYPE_IDX_PKG_DB_TYPE_NAME_TID = 101107; // "__all_pkg_type"
const uint64_t OB_ALL_PKG_TYPE_IDX_PKG_TYPE_NAME_TID = 101108; // "__all_pkg_type"
const uint64_t OB_ALL_PKG_TYPE_ATTR_IDX_PKG_TYPE_ATTR_NAME_TID = 101109; // "__all_pkg_type_attr"
const uint64_t OB_ALL_PKG_TYPE_ATTR_IDX_PKG_TYPE_ATTR_ID_TID = 101110; // "__all_pkg_type_attr"
const uint64_t OB_ALL_PKG_COLL_TYPE_IDX_PKG_COLL_NAME_TYPE_TID = 101111; // "__all_pkg_coll_type"
const uint64_t OB_ALL_PKG_COLL_TYPE_IDX_PKG_COLL_NAME_ID_TID = 101112; // "__all_pkg_coll_type"
const uint64_t OB_ALL_TABLET_REORGANIZE_HISTORY_IDX_TABLET_HIS_TABLE_ID_DEST_TID = 101104; // "__all_tablet_reorganize_history"
const uint64_t OB_ALL_VIRTUAL_TABLE_REAL_AGENT_ORA_IDX_DATA_TABLE_ID_REAL_AGENT_TID = 15306; // "ALL_VIRTUAL_TABLE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_REAL_AGENT_ORA_IDX_DB_TB_NAME_REAL_AGENT_TID = 15307; // "ALL_VIRTUAL_TABLE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_REAL_AGENT_ORA_IDX_TB_NAME_REAL_AGENT_TID = 15308; // "ALL_VIRTUAL_TABLE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_COLUMN_REAL_AGENT_ORA_IDX_TB_COLUMN_NAME_REAL_AGENT_TID = 15309; // "ALL_VIRTUAL_COLUMN_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_COLUMN_REAL_AGENT_ORA_IDX_COLUMN_NAME_REAL_AGENT_TID = 15310; // "ALL_VIRTUAL_COLUMN_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_USER_REAL_AGENT_ORA_IDX_UR_NAME_REAL_AGENT_TID = 15311; // "ALL_VIRTUAL_USER_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DATABASE_REAL_AGENT_ORA_IDX_DB_NAME_REAL_AGENT_TID = 15312; // "ALL_VIRTUAL_DATABASE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLEGROUP_REAL_AGENT_ORA_IDX_TG_NAME_REAL_AGENT_TID = 15313; // "ALL_VIRTUAL_TABLEGROUP_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RECYCLEBIN_REAL_AGENT_ORA_IDX_RECYCLEBIN_DB_TYPE_REAL_AGENT_TID = 15314; // "ALL_VIRTUAL_RECYCLEBIN_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PART_REAL_AGENT_ORA_IDX_PART_NAME_REAL_AGENT_TID = 15315; // "ALL_VIRTUAL_PART_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SUB_PART_REAL_AGENT_ORA_IDX_SUB_PART_NAME_REAL_AGENT_TID = 15316; // "ALL_VIRTUAL_SUB_PART_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DEF_SUB_PART_REAL_AGENT_ORA_IDX_DEF_SUB_PART_NAME_REAL_AGENT_TID = 15317; // "ALL_VIRTUAL_DEF_SUB_PART_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA_IDX_FK_CHILD_TID_REAL_AGENT_TID = 15318; // "ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA_IDX_FK_PARENT_TID_REAL_AGENT_TID = 15319; // "ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA_IDX_FK_NAME_REAL_AGENT_TID = 15320; // "ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SYNONYM_REAL_AGENT_ORA_IDX_DB_SYNONYM_NAME_REAL_AGENT_TID = 15321; // "ALL_VIRTUAL_SYNONYM_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SYNONYM_REAL_AGENT_ORA_IDX_SYNONYM_NAME_REAL_AGENT_TID = 15322; // "ALL_VIRTUAL_SYNONYM_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA_IDX_DB_ROUTINE_NAME_REAL_AGENT_TID = 15323; // "ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA_IDX_ROUTINE_NAME_REAL_AGENT_TID = 15324; // "ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA_IDX_ROUTINE_PKG_ID_REAL_AGENT_TID = 15325; // "ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_ROUTINE_PARAM_REAL_AGENT_ORA_IDX_ROUTINE_PARAM_NAME_REAL_AGENT_TID = 15326; // "ALL_VIRTUAL_ROUTINE_PARAM_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PACKAGE_REAL_AGENT_ORA_IDX_DB_PKG_NAME_REAL_AGENT_TID = 15327; // "ALL_VIRTUAL_PACKAGE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PACKAGE_REAL_AGENT_ORA_IDX_PKG_NAME_REAL_AGENT_TID = 15328; // "ALL_VIRTUAL_PACKAGE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_CONSTRAINT_REAL_AGENT_ORA_IDX_CST_NAME_REAL_AGENT_TID = 15329; // "ALL_VIRTUAL_CONSTRAINT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TYPE_REAL_AGENT_ORA_IDX_DB_TYPE_NAME_REAL_AGENT_TID = 15330; // "ALL_VIRTUAL_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TYPE_REAL_AGENT_ORA_IDX_TYPE_NAME_REAL_AGENT_TID = 15331; // "ALL_VIRTUAL_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TYPE_ATTR_REAL_AGENT_ORA_IDX_TYPE_ATTR_NAME_REAL_AGENT_TID = 15332; // "ALL_VIRTUAL_TYPE_ATTR_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_COLL_TYPE_REAL_AGENT_ORA_IDX_COLL_NAME_TYPE_REAL_AGENT_TID = 15333; // "ALL_VIRTUAL_COLL_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DBLINK_REAL_AGENT_ORA_IDX_OWNER_DBLINK_NAME_REAL_AGENT_TID = 15334; // "ALL_VIRTUAL_DBLINK_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DBLINK_REAL_AGENT_ORA_IDX_DBLINK_NAME_REAL_AGENT_TID = 15335; // "ALL_VIRTUAL_DBLINK_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_REAL_AGENT_ORA_IDX_GRANTEE_ROLE_ID_REAL_AGENT_TID = 15336; // "ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_KEYSTORE_REAL_AGENT_ORA_IDX_KEYSTORE_MASTER_KEY_ID_REAL_AGENT_TID = 15337; // "ALL_VIRTUAL_TENANT_KEYSTORE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_POLICY_REAL_AGENT_ORA_IDX_OLS_POLICY_NAME_REAL_AGENT_TID = 15338; // "ALL_VIRTUAL_TENANT_OLS_POLICY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_POLICY_REAL_AGENT_ORA_IDX_OLS_POLICY_COL_NAME_REAL_AGENT_TID = 15339; // "ALL_VIRTUAL_TENANT_OLS_POLICY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_COMPONENT_REAL_AGENT_ORA_IDX_OLS_COM_POLICY_ID_REAL_AGENT_TID = 15340; // "ALL_VIRTUAL_TENANT_OLS_COMPONENT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA_IDX_OLS_LAB_POLICY_ID_REAL_AGENT_TID = 15341; // "ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA_IDX_OLS_LAB_TAG_REAL_AGENT_TID = 15342; // "ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA_IDX_OLS_LAB_REAL_AGENT_TID = 15343; // "ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_REAL_AGENT_ORA_IDX_OLS_LEVEL_UID_REAL_AGENT_TID = 15344; // "ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_REAL_AGENT_ORA_IDX_OLS_LEVEL_POLICY_ID_REAL_AGENT_TID = 15345; // "ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_PROFILE_REAL_AGENT_ORA_IDX_PROFILE_NAME_REAL_AGENT_TID = 15346; // "ALL_VIRTUAL_TENANT_PROFILE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_SECURITY_AUDIT_REAL_AGENT_ORA_IDX_AUDIT_TYPE_REAL_AGENT_TID = 15347; // "ALL_VIRTUAL_TENANT_SECURITY_AUDIT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA_IDX_TRIGGER_BASE_OBJ_ID_REAL_AGENT_TID = 15348; // "ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA_IDX_DB_TRIGGER_NAME_REAL_AGENT_TID = 15349; // "ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA_IDX_TRIGGER_NAME_REAL_AGENT_TID = 15350; // "ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OBJAUTH_REAL_AGENT_ORA_IDX_OBJAUTH_GRANTOR_REAL_AGENT_TID = 15351; // "ALL_VIRTUAL_TENANT_OBJAUTH_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OBJAUTH_REAL_AGENT_ORA_IDX_OBJAUTH_GRANTEE_REAL_AGENT_TID = 15352; // "ALL_VIRTUAL_TENANT_OBJAUTH_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT_ORA_IDX_OBJ_TYPE_DB_OBJ_NAME_REAL_AGENT_TID = 15353; // "ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT_ORA_IDX_OBJ_TYPE_OBJ_NAME_REAL_AGENT_TID = 15354; // "ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_DEPENDENCY_REAL_AGENT_ORA_IDX_DEPENDENCY_REF_OBJ_REAL_AGENT_TID = 15355; // "ALL_VIRTUAL_TENANT_DEPENDENCY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_STAT_HISTORY_REAL_AGENT_ORA_IDX_TABLE_STAT_HIS_SAVTIME_REAL_AGENT_TID = 15356; // "ALL_VIRTUAL_TABLE_STAT_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_COLUMN_STAT_HISTORY_REAL_AGENT_ORA_IDX_COLUMN_STAT_HIS_SAVTIME_REAL_AGENT_TID = 15357; // "ALL_VIRTUAL_COLUMN_STAT_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_HISTOGRAM_STAT_HISTORY_REAL_AGENT_ORA_IDX_HISTOGRAM_STAT_HIS_SAVTIME_REAL_AGENT_TID = 15358; // "ALL_VIRTUAL_HISTOGRAM_STAT_HISTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLET_TO_LS_REAL_AGENT_ORA_IDX_TABLET_TO_LS_ID_REAL_AGENT_TID = 15359; // "ALL_VIRTUAL_TABLET_TO_LS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLET_TO_LS_REAL_AGENT_ORA_IDX_TABLET_TO_TABLE_ID_REAL_AGENT_TID = 15360; // "ALL_VIRTUAL_TABLET_TO_LS_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_CONTEXT_REAL_AGENT_ORA_IDX_CTX_NAMESPACE_REAL_AGENT_TID = 15361; // "ALL_VIRTUAL_CONTEXT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PLAN_BASELINE_ITEM_REAL_AGENT_ORA_IDX_SPM_ITEM_SQL_ID_REAL_AGENT_TID = 15362; // "ALL_VIRTUAL_PLAN_BASELINE_ITEM_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PLAN_BASELINE_ITEM_REAL_AGENT_ORA_IDX_SPM_ITEM_VALUE_REAL_AGENT_TID = 15363; // "ALL_VIRTUAL_PLAN_BASELINE_ITEM_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TENANT_DIRECTORY_REAL_AGENT_ORA_IDX_DIRECTORY_NAME_REAL_AGENT_TID = 15364; // "ALL_VIRTUAL_TENANT_DIRECTORY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_JOB_REAL_AGENT_ORA_IDX_JOB_POWNER_REAL_AGENT_TID = 15365; // "ALL_VIRTUAL_JOB_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT_ORA_IDX_SEQ_OBJ_DB_NAME_REAL_AGENT_TID = 15366; // "ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT_ORA_IDX_SEQ_OBJ_NAME_REAL_AGENT_TID = 15367; // "ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RECYCLEBIN_REAL_AGENT_ORA_IDX_RECYCLEBIN_ORI_NAME_REAL_AGENT_TID = 15368; // "ALL_VIRTUAL_RECYCLEBIN_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_PRIVILEGE_REAL_AGENT_ORA_IDX_TB_PRIV_DB_NAME_REAL_AGENT_TID = 15369; // "ALL_VIRTUAL_TABLE_PRIVILEGE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_TABLE_PRIVILEGE_REAL_AGENT_ORA_IDX_TB_PRIV_TB_NAME_REAL_AGENT_TID = 15370; // "ALL_VIRTUAL_TABLE_PRIVILEGE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DATABASE_PRIVILEGE_REAL_AGENT_ORA_IDX_DB_PRIV_DB_NAME_REAL_AGENT_TID = 15371; // "ALL_VIRTUAL_DATABASE_PRIVILEGE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RLS_POLICY_REAL_AGENT_ORA_IDX_RLS_POLICY_TABLE_ID_REAL_AGENT_TID = 15372; // "ALL_VIRTUAL_RLS_POLICY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RLS_POLICY_REAL_AGENT_ORA_IDX_RLS_POLICY_GROUP_ID_REAL_AGENT_TID = 15373; // "ALL_VIRTUAL_RLS_POLICY_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RLS_GROUP_REAL_AGENT_ORA_IDX_RLS_GROUP_TABLE_ID_REAL_AGENT_TID = 15374; // "ALL_VIRTUAL_RLS_GROUP_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_RLS_CONTEXT_REAL_AGENT_ORA_IDX_RLS_CONTEXT_TABLE_ID_REAL_AGENT_TID = 15375; // "ALL_VIRTUAL_RLS_CONTEXT_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_REAL_AGENT_ORA_IDX_DBMS_LOCK_ALLOCATED_LOCKHANDLE_REAL_AGENT_TID = 15415; // "ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_REAL_AGENT_ORA_IDX_DBMS_LOCK_ALLOCATED_EXPIRATION_REAL_AGENT_TID = 15416; // "ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_USER_PROXY_INFO_REAL_AGENT_ORA_IDX_USER_PROXY_INFO_PROXY_USER_ID_REAL_AGENT_TID = 15448; // "ALL_VIRTUAL_USER_PROXY_INFO_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_REAL_AGENT_ORA_IDX_SCHEDULER_JOB_RUN_DETAIL_V2_TIME_REAL_AGENT_TID = 15460; // "ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_REAL_AGENT_ORA_IDX_SCHEDULER_JOB_RUN_DETAIL_V2_JOB_CLASS_TIME_REAL_AGENT_TID = 15463; // "ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PKG_TYPE_REAL_AGENT_ORA_IDX_PKG_DB_TYPE_NAME_REAL_AGENT_TID = 15474; // "ALL_VIRTUAL_PKG_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PKG_TYPE_REAL_AGENT_ORA_IDX_PKG_TYPE_NAME_REAL_AGENT_TID = 15475; // "ALL_VIRTUAL_PKG_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PKG_TYPE_ATTR_REAL_AGENT_ORA_IDX_PKG_TYPE_ATTR_NAME_REAL_AGENT_TID = 15476; // "ALL_VIRTUAL_PKG_TYPE_ATTR_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PKG_TYPE_ATTR_REAL_AGENT_ORA_IDX_PKG_TYPE_ATTR_ID_REAL_AGENT_TID = 15477; // "ALL_VIRTUAL_PKG_TYPE_ATTR_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PKG_COLL_TYPE_REAL_AGENT_ORA_IDX_PKG_COLL_NAME_TYPE_REAL_AGENT_TID = 15478; // "ALL_VIRTUAL_PKG_COLL_TYPE_REAL_AGENT_ORA"
const uint64_t OB_ALL_VIRTUAL_PKG_COLL_TYPE_REAL_AGENT_ORA_IDX_PKG_COLL_NAME_ID_REAL_AGENT_TID = 15479; // "ALL_VIRTUAL_PKG_COLL_TYPE_REAL_AGENT_ORA"

const char *const OB_ALL_CORE_TABLE_TNAME = "__all_core_table";
const char *const OB_ALL_TABLE_TNAME = "__all_table";
const char *const OB_ALL_COLUMN_TNAME = "__all_column";
const char *const OB_ALL_DDL_OPERATION_TNAME = "__all_ddl_operation";
const char *const OB_ALL_USER_TNAME = "__all_user";
const char *const OB_ALL_USER_HISTORY_TNAME = "__all_user_history";
const char *const OB_ALL_DATABASE_TNAME = "__all_database";
const char *const OB_ALL_DATABASE_HISTORY_TNAME = "__all_database_history";
const char *const OB_ALL_TABLEGROUP_TNAME = "__all_tablegroup";
const char *const OB_ALL_TABLEGROUP_HISTORY_TNAME = "__all_tablegroup_history";
const char *const OB_ALL_TENANT_TNAME = "__all_tenant";
const char *const OB_ALL_TENANT_HISTORY_TNAME = "__all_tenant_history";
const char *const OB_ALL_TABLE_PRIVILEGE_TNAME = "__all_table_privilege";
const char *const OB_ALL_TABLE_PRIVILEGE_HISTORY_TNAME = "__all_table_privilege_history";
const char *const OB_ALL_DATABASE_PRIVILEGE_TNAME = "__all_database_privilege";
const char *const OB_ALL_DATABASE_PRIVILEGE_HISTORY_TNAME = "__all_database_privilege_history";
const char *const OB_ALL_TABLE_HISTORY_TNAME = "__all_table_history";
const char *const OB_ALL_COLUMN_HISTORY_TNAME = "__all_column_history";
const char *const OB_ALL_ZONE_TNAME = "__all_zone";
const char *const OB_ALL_SERVER_TNAME = "__all_server";
const char *const OB_ALL_SYS_PARAMETER_TNAME = "__all_sys_parameter";
const char *const OB_TENANT_PARAMETER_TNAME = "__tenant_parameter";
const char *const OB_ALL_SYS_VARIABLE_TNAME = "__all_sys_variable";
const char *const OB_ALL_SYS_STAT_TNAME = "__all_sys_stat";
const char *const OB_ALL_UNIT_TNAME = "__all_unit";
const char *const OB_ALL_UNIT_CONFIG_TNAME = "__all_unit_config";
const char *const OB_ALL_RESOURCE_POOL_TNAME = "__all_resource_pool";
const char *const OB_ALL_CHARSET_TNAME = "__all_charset";
const char *const OB_ALL_COLLATION_TNAME = "__all_collation";
const char *const OB_HELP_TOPIC_TNAME = "help_topic";
const char *const OB_HELP_CATEGORY_TNAME = "help_category";
const char *const OB_HELP_KEYWORD_TNAME = "help_keyword";
const char *const OB_HELP_RELATION_TNAME = "help_relation";
const char *const OB_ALL_DUMMY_TNAME = "__all_dummy";
const char *const OB_ALL_ROOTSERVICE_EVENT_HISTORY_TNAME = "__all_rootservice_event_history";
const char *const OB_ALL_PRIVILEGE_TNAME = "__all_privilege";
const char *const OB_ALL_OUTLINE_TNAME = "__all_outline";
const char *const OB_ALL_OUTLINE_HISTORY_TNAME = "__all_outline_history";
const char *const OB_ALL_RECYCLEBIN_TNAME = "__all_recyclebin";
const char *const OB_ALL_PART_TNAME = "__all_part";
const char *const OB_ALL_PART_HISTORY_TNAME = "__all_part_history";
const char *const OB_ALL_SUB_PART_TNAME = "__all_sub_part";
const char *const OB_ALL_SUB_PART_HISTORY_TNAME = "__all_sub_part_history";
const char *const OB_ALL_PART_INFO_TNAME = "__all_part_info";
const char *const OB_ALL_PART_INFO_HISTORY_TNAME = "__all_part_info_history";
const char *const OB_ALL_DEF_SUB_PART_TNAME = "__all_def_sub_part";
const char *const OB_ALL_DEF_SUB_PART_HISTORY_TNAME = "__all_def_sub_part_history";
const char *const OB_ALL_SERVER_EVENT_HISTORY_TNAME = "__all_server_event_history";
const char *const OB_ALL_ROOTSERVICE_JOB_TNAME = "__all_rootservice_job";
const char *const OB_ALL_SYS_VARIABLE_HISTORY_TNAME = "__all_sys_variable_history";
const char *const OB_ALL_RESTORE_JOB_TNAME = "__all_restore_job";
const char *const OB_ALL_RESTORE_JOB_HISTORY_TNAME = "__all_restore_job_history";
const char *const OB_ALL_DDL_ID_TNAME = "__all_ddl_id";
const char *const OB_ALL_FOREIGN_KEY_TNAME = "__all_foreign_key";
const char *const OB_ALL_FOREIGN_KEY_HISTORY_TNAME = "__all_foreign_key_history";
const char *const OB_ALL_FOREIGN_KEY_COLUMN_TNAME = "__all_foreign_key_column";
const char *const OB_ALL_FOREIGN_KEY_COLUMN_HISTORY_TNAME = "__all_foreign_key_column_history";
const char *const OB_ALL_SYNONYM_TNAME = "__all_synonym";
const char *const OB_ALL_SYNONYM_HISTORY_TNAME = "__all_synonym_history";
const char *const OB_ALL_AUTO_INCREMENT_TNAME = "__all_auto_increment";
const char *const OB_ALL_DDL_CHECKSUM_TNAME = "__all_ddl_checksum";
const char *const OB_ALL_ROUTINE_TNAME = "__all_routine";
const char *const OB_ALL_ROUTINE_HISTORY_TNAME = "__all_routine_history";
const char *const OB_ALL_ROUTINE_PARAM_TNAME = "__all_routine_param";
const char *const OB_ALL_ROUTINE_PARAM_HISTORY_TNAME = "__all_routine_param_history";
const char *const OB_ALL_PACKAGE_TNAME = "__all_package";
const char *const OB_ALL_PACKAGE_HISTORY_TNAME = "__all_package_history";
const char *const OB_ALL_ACQUIRED_SNAPSHOT_TNAME = "__all_acquired_snapshot";
const char *const OB_ALL_CONSTRAINT_TNAME = "__all_constraint";
const char *const OB_ALL_CONSTRAINT_HISTORY_TNAME = "__all_constraint_history";
const char *const OB_ALL_ORI_SCHEMA_VERSION_TNAME = "__all_ori_schema_version";
const char *const OB_ALL_FUNC_TNAME = "__all_func";
const char *const OB_ALL_FUNC_HISTORY_TNAME = "__all_func_history";
const char *const OB_ALL_TEMP_TABLE_TNAME = "__all_temp_table";
const char *const OB_ALL_SEQUENCE_OBJECT_TNAME = "__all_sequence_object";
const char *const OB_ALL_SEQUENCE_OBJECT_HISTORY_TNAME = "__all_sequence_object_history";
const char *const OB_ALL_SEQUENCE_VALUE_TNAME = "__all_sequence_value";
const char *const OB_ALL_FREEZE_SCHEMA_VERSION_TNAME = "__all_freeze_schema_version";
const char *const OB_ALL_TYPE_TNAME = "__all_type";
const char *const OB_ALL_TYPE_HISTORY_TNAME = "__all_type_history";
const char *const OB_ALL_TYPE_ATTR_TNAME = "__all_type_attr";
const char *const OB_ALL_TYPE_ATTR_HISTORY_TNAME = "__all_type_attr_history";
const char *const OB_ALL_COLL_TYPE_TNAME = "__all_coll_type";
const char *const OB_ALL_COLL_TYPE_HISTORY_TNAME = "__all_coll_type_history";
const char *const OB_ALL_WEAK_READ_SERVICE_TNAME = "__all_weak_read_service";
const char *const OB_ALL_DBLINK_TNAME = "__all_dblink";
const char *const OB_ALL_DBLINK_HISTORY_TNAME = "__all_dblink_history";
const char *const OB_ALL_TENANT_ROLE_GRANTEE_MAP_TNAME = "__all_tenant_role_grantee_map";
const char *const OB_ALL_TENANT_ROLE_GRANTEE_MAP_HISTORY_TNAME = "__all_tenant_role_grantee_map_history";
const char *const OB_ALL_TENANT_KEYSTORE_TNAME = "__all_tenant_keystore";
const char *const OB_ALL_TENANT_KEYSTORE_HISTORY_TNAME = "__all_tenant_keystore_history";
const char *const OB_ALL_TENANT_OLS_POLICY_TNAME = "__all_tenant_ols_policy";
const char *const OB_ALL_TENANT_OLS_POLICY_HISTORY_TNAME = "__all_tenant_ols_policy_history";
const char *const OB_ALL_TENANT_OLS_COMPONENT_TNAME = "__all_tenant_ols_component";
const char *const OB_ALL_TENANT_OLS_COMPONENT_HISTORY_TNAME = "__all_tenant_ols_component_history";
const char *const OB_ALL_TENANT_OLS_LABEL_TNAME = "__all_tenant_ols_label";
const char *const OB_ALL_TENANT_OLS_LABEL_HISTORY_TNAME = "__all_tenant_ols_label_history";
const char *const OB_ALL_TENANT_OLS_USER_LEVEL_TNAME = "__all_tenant_ols_user_level";
const char *const OB_ALL_TENANT_OLS_USER_LEVEL_HISTORY_TNAME = "__all_tenant_ols_user_level_history";
const char *const OB_ALL_TENANT_TABLESPACE_TNAME = "__all_tenant_tablespace";
const char *const OB_ALL_TENANT_TABLESPACE_HISTORY_TNAME = "__all_tenant_tablespace_history";
const char *const OB_ALL_TENANT_USER_FAILED_LOGIN_STAT_TNAME = "__all_tenant_user_failed_login_stat";
const char *const OB_ALL_TENANT_PROFILE_TNAME = "__all_tenant_profile";
const char *const OB_ALL_TENANT_PROFILE_HISTORY_TNAME = "__all_tenant_profile_history";
const char *const OB_ALL_TENANT_SECURITY_AUDIT_TNAME = "__all_tenant_security_audit";
const char *const OB_ALL_TENANT_SECURITY_AUDIT_HISTORY_TNAME = "__all_tenant_security_audit_history";
const char *const OB_ALL_TENANT_TRIGGER_TNAME = "__all_tenant_trigger";
const char *const OB_ALL_TENANT_TRIGGER_HISTORY_TNAME = "__all_tenant_trigger_history";
const char *const OB_ALL_SEED_PARAMETER_TNAME = "__all_seed_parameter";
const char *const OB_ALL_TENANT_SECURITY_AUDIT_RECORD_TNAME = "__all_tenant_security_audit_record";
const char *const OB_ALL_TENANT_SYSAUTH_TNAME = "__all_tenant_sysauth";
const char *const OB_ALL_TENANT_SYSAUTH_HISTORY_TNAME = "__all_tenant_sysauth_history";
const char *const OB_ALL_TENANT_OBJAUTH_TNAME = "__all_tenant_objauth";
const char *const OB_ALL_TENANT_OBJAUTH_HISTORY_TNAME = "__all_tenant_objauth_history";
const char *const OB_ALL_RESTORE_INFO_TNAME = "__all_restore_info";
const char *const OB_ALL_TENANT_ERROR_TNAME = "__all_tenant_error";
const char *const OB_ALL_RESTORE_PROGRESS_TNAME = "__all_restore_progress";
const char *const OB_ALL_TENANT_OBJECT_TYPE_TNAME = "__all_tenant_object_type";
const char *const OB_ALL_TENANT_OBJECT_TYPE_HISTORY_TNAME = "__all_tenant_object_type_history";
const char *const OB_ALL_TENANT_TIME_ZONE_TNAME = "__all_tenant_time_zone";
const char *const OB_ALL_TENANT_TIME_ZONE_NAME_TNAME = "__all_tenant_time_zone_name";
const char *const OB_ALL_TENANT_TIME_ZONE_TRANSITION_TNAME = "__all_tenant_time_zone_transition";
const char *const OB_ALL_TENANT_TIME_ZONE_TRANSITION_TYPE_TNAME = "__all_tenant_time_zone_transition_type";
const char *const OB_ALL_TENANT_CONSTRAINT_COLUMN_TNAME = "__all_tenant_constraint_column";
const char *const OB_ALL_TENANT_CONSTRAINT_COLUMN_HISTORY_TNAME = "__all_tenant_constraint_column_history";
const char *const OB_ALL_TENANT_GLOBAL_TRANSACTION_TNAME = "__all_tenant_global_transaction";
const char *const OB_ALL_TENANT_DEPENDENCY_TNAME = "__all_tenant_dependency";
const char *const OB_ALL_RES_MGR_PLAN_TNAME = "__all_res_mgr_plan";
const char *const OB_ALL_RES_MGR_DIRECTIVE_TNAME = "__all_res_mgr_directive";
const char *const OB_ALL_RES_MGR_MAPPING_RULE_TNAME = "__all_res_mgr_mapping_rule";
const char *const OB_ALL_DDL_ERROR_MESSAGE_TNAME = "__all_ddl_error_message";
const char *const OB_ALL_SPACE_USAGE_TNAME = "__all_space_usage";
const char *const OB_ALL_BACKUP_SET_FILES_TNAME = "__all_backup_set_files";
const char *const OB_ALL_RES_MGR_CONSUMER_GROUP_TNAME = "__all_res_mgr_consumer_group";
const char *const OB_ALL_BACKUP_INFO_TNAME = "__all_backup_info";
const char *const OB_ALL_DDL_TASK_STATUS_TNAME = "__all_ddl_task_status";
const char *const OB_ALL_REGION_NETWORK_BANDWIDTH_LIMIT_TNAME = "__all_region_network_bandwidth_limit";
const char *const OB_ALL_DEADLOCK_EVENT_HISTORY_TNAME = "__all_deadlock_event_history";
const char *const OB_ALL_COLUMN_USAGE_TNAME = "__all_column_usage";
const char *const OB_ALL_JOB_TNAME = "__all_job";
const char *const OB_ALL_JOB_LOG_TNAME = "__all_job_log";
const char *const OB_ALL_TENANT_DIRECTORY_TNAME = "__all_tenant_directory";
const char *const OB_ALL_TENANT_DIRECTORY_HISTORY_TNAME = "__all_tenant_directory_history";
const char *const OB_ALL_TABLE_STAT_TNAME = "__all_table_stat";
const char *const OB_ALL_COLUMN_STAT_TNAME = "__all_column_stat";
const char *const OB_ALL_HISTOGRAM_STAT_TNAME = "__all_histogram_stat";
const char *const OB_ALL_MONITOR_MODIFIED_TNAME = "__all_monitor_modified";
const char *const OB_ALL_TABLE_STAT_HISTORY_TNAME = "__all_table_stat_history";
const char *const OB_ALL_COLUMN_STAT_HISTORY_TNAME = "__all_column_stat_history";
const char *const OB_ALL_HISTOGRAM_STAT_HISTORY_TNAME = "__all_histogram_stat_history";
const char *const OB_ALL_OPTSTAT_GLOBAL_PREFS_TNAME = "__all_optstat_global_prefs";
const char *const OB_ALL_OPTSTAT_USER_PREFS_TNAME = "__all_optstat_user_prefs";
const char *const OB_ALL_LS_META_TABLE_TNAME = "__all_ls_meta_table";
const char *const OB_ALL_TABLET_TO_LS_TNAME = "__all_tablet_to_ls";
const char *const OB_ALL_TABLET_META_TABLE_TNAME = "__all_tablet_meta_table";
const char *const OB_ALL_LS_STATUS_TNAME = "__all_ls_status";
const char *const OB_ALL_LOG_ARCHIVE_PROGRESS_TNAME = "__all_log_archive_progress";
const char *const OB_ALL_LOG_ARCHIVE_HISTORY_TNAME = "__all_log_archive_history";
const char *const OB_ALL_LOG_ARCHIVE_PIECE_FILES_TNAME = "__all_log_archive_piece_files";
const char *const OB_ALL_LS_LOG_ARCHIVE_PROGRESS_TNAME = "__all_ls_log_archive_progress";
const char *const OB_ALL_LS_TNAME = "__all_ls";
const char *const OB_ALL_BACKUP_STORAGE_INFO_TNAME = "__all_backup_storage_info";
const char *const OB_ALL_DAM_LAST_ARCH_TS_TNAME = "__all_dam_last_arch_ts";
const char *const OB_ALL_DAM_CLEANUP_JOBS_TNAME = "__all_dam_cleanup_jobs";
const char *const OB_ALL_BACKUP_JOB_TNAME = "__all_backup_job";
const char *const OB_ALL_BACKUP_JOB_HISTORY_TNAME = "__all_backup_job_history";
const char *const OB_ALL_BACKUP_TASK_TNAME = "__all_backup_task";
const char *const OB_ALL_BACKUP_TASK_HISTORY_TNAME = "__all_backup_task_history";
const char *const OB_ALL_BACKUP_LS_TASK_TNAME = "__all_backup_ls_task";
const char *const OB_ALL_BACKUP_LS_TASK_HISTORY_TNAME = "__all_backup_ls_task_history";
const char *const OB_ALL_BACKUP_LS_TASK_INFO_TNAME = "__all_backup_ls_task_info";
const char *const OB_ALL_BACKUP_SKIPPED_TABLET_TNAME = "__all_backup_skipped_tablet";
const char *const OB_ALL_BACKUP_SKIPPED_TABLET_HISTORY_TNAME = "__all_backup_skipped_tablet_history";
const char *const OB_ALL_TENANT_INFO_TNAME = "__all_tenant_info";
const char *const OB_ALL_TABLET_TO_TABLE_HISTORY_TNAME = "__all_tablet_to_table_history";
const char *const OB_ALL_LS_RECOVERY_STAT_TNAME = "__all_ls_recovery_stat";
const char *const OB_ALL_BACKUP_LS_TASK_INFO_HISTORY_TNAME = "__all_backup_ls_task_info_history";
const char *const OB_ALL_TABLET_REPLICA_CHECKSUM_TNAME = "__all_tablet_replica_checksum";
const char *const OB_ALL_TABLET_CHECKSUM_TNAME = "__all_tablet_checksum";
const char *const OB_ALL_LS_REPLICA_TASK_TNAME = "__all_ls_replica_task";
const char *const OB_ALL_PENDING_TRANSACTION_TNAME = "__all_pending_transaction";
const char *const OB_ALL_BALANCE_GROUP_LS_STAT_TNAME = "__all_balance_group_ls_stat";
const char *const OB_ALL_TENANT_SCHEDULER_JOB_TNAME = "__all_tenant_scheduler_job";
const char *const OB_ALL_TENANT_SCHEDULER_JOB_RUN_DETAIL_TNAME = "__all_tenant_scheduler_job_run_detail";
const char *const OB_ALL_TENANT_SCHEDULER_PROGRAM_TNAME = "__all_tenant_scheduler_program";
const char *const OB_ALL_TENANT_SCHEDULER_PROGRAM_ARGUMENT_TNAME = "__all_tenant_scheduler_program_argument";
const char *const OB_ALL_CONTEXT_TNAME = "__all_context";
const char *const OB_ALL_CONTEXT_HISTORY_TNAME = "__all_context_history";
const char *const OB_ALL_GLOBAL_CONTEXT_VALUE_TNAME = "__all_global_context_value";
const char *const OB_ALL_LS_ELECTION_REFERENCE_INFO_TNAME = "__all_ls_election_reference_info";
const char *const OB_ALL_BACKUP_DELETE_JOB_TNAME = "__all_backup_delete_job";
const char *const OB_ALL_BACKUP_DELETE_JOB_HISTORY_TNAME = "__all_backup_delete_job_history";
const char *const OB_ALL_BACKUP_DELETE_TASK_TNAME = "__all_backup_delete_task";
const char *const OB_ALL_BACKUP_DELETE_TASK_HISTORY_TNAME = "__all_backup_delete_task_history";
const char *const OB_ALL_BACKUP_DELETE_LS_TASK_TNAME = "__all_backup_delete_ls_task";
const char *const OB_ALL_BACKUP_DELETE_LS_TASK_HISTORY_TNAME = "__all_backup_delete_ls_task_history";
const char *const OB_ALL_ZONE_MERGE_INFO_TNAME = "__all_zone_merge_info";
const char *const OB_ALL_MERGE_INFO_TNAME = "__all_merge_info";
const char *const OB_ALL_FREEZE_INFO_TNAME = "__all_freeze_info";
const char *const OB_ALL_DISK_IO_CALIBRATION_TNAME = "__all_disk_io_calibration";
const char *const OB_ALL_PLAN_BASELINE_TNAME = "__all_plan_baseline";
const char *const OB_ALL_PLAN_BASELINE_ITEM_TNAME = "__all_plan_baseline_item";
const char *const OB_ALL_SPM_CONFIG_TNAME = "__all_spm_config";
const char *const OB_ALL_LOG_ARCHIVE_DEST_PARAMETER_TNAME = "__all_log_archive_dest_parameter";
const char *const OB_ALL_BACKUP_PARAMETER_TNAME = "__all_backup_parameter";
const char *const OB_ALL_LS_RESTORE_PROGRESS_TNAME = "__all_ls_restore_progress";
const char *const OB_ALL_LS_RESTORE_HISTORY_TNAME = "__all_ls_restore_history";
const char *const OB_ALL_BACKUP_STORAGE_INFO_HISTORY_TNAME = "__all_backup_storage_info_history";
const char *const OB_ALL_BACKUP_DELETE_POLICY_TNAME = "__all_backup_delete_policy";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_TNAME = "__all_mock_fk_parent_table";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_HISTORY_TNAME = "__all_mock_fk_parent_table_history";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_TNAME = "__all_mock_fk_parent_table_column";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_HISTORY_TNAME = "__all_mock_fk_parent_table_column_history";
const char *const OB_ALL_LOG_RESTORE_SOURCE_TNAME = "__all_log_restore_source";
const char *const OB_ALL_KV_TTL_TASK_TNAME = "__all_kv_ttl_task";
const char *const OB_ALL_KV_TTL_TASK_HISTORY_TNAME = "__all_kv_ttl_task_history";
const char *const OB_ALL_SERVICE_EPOCH_TNAME = "__all_service_epoch";
const char *const OB_ALL_SPATIAL_REFERENCE_SYSTEMS_TNAME = "__all_spatial_reference_systems";
const char *const OB_ALL_COLUMN_CHECKSUM_ERROR_INFO_TNAME = "__all_column_checksum_error_info";
const char *const OB_ALL_COLUMN_GROUP_TNAME = "__all_column_group";
const char *const OB_ALL_COLUMN_GROUP_HISTORY_TNAME = "__all_column_group_history";
const char *const OB_ALL_COLUMN_GROUP_MAPPING_TNAME = "__all_column_group_mapping";
const char *const OB_ALL_COLUMN_GROUP_MAPPING_HISTORY_TNAME = "__all_column_group_mapping_history";
const char *const OB_ALL_TRANSFER_TASK_TNAME = "__all_transfer_task";
const char *const OB_ALL_TRANSFER_TASK_HISTORY_TNAME = "__all_transfer_task_history";
const char *const OB_ALL_BALANCE_JOB_TNAME = "__all_balance_job";
const char *const OB_ALL_BALANCE_JOB_HISTORY_TNAME = "__all_balance_job_history";
const char *const OB_ALL_BALANCE_TASK_TNAME = "__all_balance_task";
const char *const OB_ALL_BALANCE_TASK_HISTORY_TNAME = "__all_balance_task_history";
const char *const OB_ALL_ARBITRATION_SERVICE_TNAME = "__all_arbitration_service";
const char *const OB_ALL_LS_ARB_REPLICA_TASK_TNAME = "__all_ls_arb_replica_task";
const char *const OB_ALL_DATA_DICTIONARY_IN_LOG_TNAME = "__all_data_dictionary_in_log";
const char *const OB_ALL_LS_ARB_REPLICA_TASK_HISTORY_TNAME = "__all_ls_arb_replica_task_history";
const char *const OB_ALL_RLS_POLICY_TNAME = "__all_rls_policy";
const char *const OB_ALL_RLS_POLICY_HISTORY_TNAME = "__all_rls_policy_history";
const char *const OB_ALL_RLS_SECURITY_COLUMN_TNAME = "__all_rls_security_column";
const char *const OB_ALL_RLS_SECURITY_COLUMN_HISTORY_TNAME = "__all_rls_security_column_history";
const char *const OB_ALL_RLS_GROUP_TNAME = "__all_rls_group";
const char *const OB_ALL_RLS_GROUP_HISTORY_TNAME = "__all_rls_group_history";
const char *const OB_ALL_RLS_CONTEXT_TNAME = "__all_rls_context";
const char *const OB_ALL_RLS_CONTEXT_HISTORY_TNAME = "__all_rls_context_history";
const char *const OB_ALL_RLS_ATTRIBUTE_TNAME = "__all_rls_attribute";
const char *const OB_ALL_RLS_ATTRIBUTE_HISTORY_TNAME = "__all_rls_attribute_history";
const char *const OB_ALL_TENANT_REWRITE_RULES_TNAME = "__all_tenant_rewrite_rules";
const char *const OB_ALL_RESERVED_SNAPSHOT_TNAME = "__all_reserved_snapshot";
const char *const OB_ALL_CLUSTER_EVENT_HISTORY_TNAME = "__all_cluster_event_history";
const char *const OB_ALL_LS_TRANSFER_MEMBER_LIST_LOCK_INFO_TNAME = "__all_ls_transfer_member_list_lock_info";
const char *const OB_ALL_EXTERNAL_TABLE_FILE_TNAME = "__all_external_table_file";
const char *const OB_ALL_TASK_OPT_STAT_GATHER_HISTORY_TNAME = "__all_task_opt_stat_gather_history";
const char *const OB_ALL_TABLE_OPT_STAT_GATHER_HISTORY_TNAME = "__all_table_opt_stat_gather_history";
const char *const OB_ALL_ZONE_STORAGE_TNAME = "__all_zone_storage";
const char *const OB_ALL_ZONE_STORAGE_OPERATION_TNAME = "__all_zone_storage_operation";
const char *const OB_WR_ACTIVE_SESSION_HISTORY_TNAME = "__wr_active_session_history";
const char *const OB_WR_SNAPSHOT_TNAME = "__wr_snapshot";
const char *const OB_WR_STATNAME_TNAME = "__wr_statname";
const char *const OB_WR_SYSSTAT_TNAME = "__wr_sysstat";
const char *const OB_ALL_BALANCE_TASK_HELPER_TNAME = "__all_balance_task_helper";
const char *const OB_ALL_TENANT_SNAPSHOT_TNAME = "__all_tenant_snapshot";
const char *const OB_ALL_TENANT_SNAPSHOT_LS_TNAME = "__all_tenant_snapshot_ls";
const char *const OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_TNAME = "__all_tenant_snapshot_ls_replica";
const char *const OB_ALL_MLOG_TNAME = "__all_mlog";
const char *const OB_ALL_MVIEW_TNAME = "__all_mview";
const char *const OB_ALL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_TNAME = "__all_mview_refresh_stats_sys_defaults";
const char *const OB_ALL_MVIEW_REFRESH_STATS_PARAMS_TNAME = "__all_mview_refresh_stats_params";
const char *const OB_ALL_MVIEW_REFRESH_RUN_STATS_TNAME = "__all_mview_refresh_run_stats";
const char *const OB_ALL_MVIEW_REFRESH_STATS_TNAME = "__all_mview_refresh_stats";
const char *const OB_ALL_MVIEW_REFRESH_CHANGE_STATS_TNAME = "__all_mview_refresh_change_stats";
const char *const OB_ALL_MVIEW_REFRESH_STMT_STATS_TNAME = "__all_mview_refresh_stmt_stats";
const char *const OB_ALL_DBMS_LOCK_ALLOCATED_TNAME = "__all_dbms_lock_allocated";
const char *const OB_WR_CONTROL_TNAME = "__wr_control";
const char *const OB_ALL_TENANT_EVENT_HISTORY_TNAME = "__all_tenant_event_history";
const char *const OB_ALL_TENANT_SCHEDULER_JOB_CLASS_TNAME = "__all_tenant_scheduler_job_class";
const char *const OB_ALL_RECOVER_TABLE_JOB_TNAME = "__all_recover_table_job";
const char *const OB_ALL_RECOVER_TABLE_JOB_HISTORY_TNAME = "__all_recover_table_job_history";
const char *const OB_ALL_IMPORT_TABLE_JOB_TNAME = "__all_import_table_job";
const char *const OB_ALL_IMPORT_TABLE_JOB_HISTORY_TNAME = "__all_import_table_job_history";
const char *const OB_ALL_IMPORT_TABLE_TASK_TNAME = "__all_import_table_task";
const char *const OB_ALL_IMPORT_TABLE_TASK_HISTORY_TNAME = "__all_import_table_task_history";
const char *const OB_ALL_TABLET_REORGANIZE_HISTORY_TNAME = "__all_tablet_reorganize_history";
const char *const OB_ALL_STORAGE_HA_ERROR_DIAGNOSE_HISTORY_TNAME = "__all_storage_ha_error_diagnose_history";
const char *const OB_ALL_STORAGE_HA_PERF_DIAGNOSE_HISTORY_TNAME = "__all_storage_ha_perf_diagnose_history";
const char *const OB_ALL_CLONE_JOB_TNAME = "__all_clone_job";
const char *const OB_ALL_CLONE_JOB_HISTORY_TNAME = "__all_clone_job_history";
const char *const OB_WR_SYSTEM_EVENT_TNAME = "__wr_system_event";
const char *const OB_WR_EVENT_NAME_TNAME = "__wr_event_name";
const char *const OB_ALL_ROUTINE_PRIVILEGE_TNAME = "__all_routine_privilege";
const char *const OB_ALL_ROUTINE_PRIVILEGE_HISTORY_TNAME = "__all_routine_privilege_history";
const char *const OB_WR_SQLSTAT_TNAME = "__wr_sqlstat";
const char *const OB_ALL_NCOMP_DLL_TNAME = "__all_ncomp_dll";
const char *const OB_ALL_AUX_STAT_TNAME = "__all_aux_stat";
const char *const OB_ALL_INDEX_USAGE_INFO_TNAME = "__all_index_usage_info";
const char *const OB_ALL_DETECT_LOCK_INFO_TNAME = "__all_detect_lock_info";
const char *const OB_ALL_CLIENT_TO_SERVER_SESSION_INFO_TNAME = "__all_client_to_server_session_info";
const char *const OB_ALL_TRANSFER_PARTITION_TASK_TNAME = "__all_transfer_partition_task";
const char *const OB_ALL_TRANSFER_PARTITION_TASK_HISTORY_TNAME = "__all_transfer_partition_task_history";
const char *const OB_ALL_TENANT_SNAPSHOT_JOB_TNAME = "__all_tenant_snapshot_job";
const char *const OB_WR_SQLTEXT_TNAME = "__wr_sqltext";
const char *const OB_ALL_TRUSTED_ROOT_CERTIFICATE_TNAME = "__all_trusted_root_certificate";
const char *const OB_ALL_AUDIT_LOG_FILTER_TNAME = "__all_audit_log_filter";
const char *const OB_ALL_AUDIT_LOG_USER_TNAME = "__all_audit_log_user";
const char *const OB_ALL_COLUMN_PRIVILEGE_TNAME = "__all_column_privilege";
const char *const OB_ALL_COLUMN_PRIVILEGE_HISTORY_TNAME = "__all_column_privilege_history";
const char *const OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_HISTORY_TNAME = "__all_tenant_snapshot_ls_replica_history";
const char *const OB_ALL_LS_REPLICA_TASK_HISTORY_TNAME = "__all_ls_replica_task_history";
const char *const OB_ALL_TABLET_CHECKSUM_ERROR_INFO_TNAME = "__all_tablet_checksum_error_info";
const char *const OB_ALL_USER_PROXY_INFO_TNAME = "__all_user_proxy_info";
const char *const OB_ALL_USER_PROXY_INFO_HISTORY_TNAME = "__all_user_proxy_info_history";
const char *const OB_ALL_USER_PROXY_ROLE_INFO_TNAME = "__all_user_proxy_role_info";
const char *const OB_ALL_USER_PROXY_ROLE_INFO_HISTORY_TNAME = "__all_user_proxy_role_info_history";
const char *const OB_ALL_SERVICE_TNAME = "__all_service";
const char *const OB_ALL_STORAGE_IO_USAGE_TNAME = "__all_storage_io_usage";
const char *const OB_ALL_MVIEW_DEP_TNAME = "__all_mview_dep";
const char *const OB_ALL_SCHEDULER_JOB_RUN_DETAIL_V2_TNAME = "__all_scheduler_job_run_detail_v2";
const char *const OB_ALL_SPM_EVO_RESULT_TNAME = "__all_spm_evo_result";
const char *const OB_ALL_PKG_TYPE_TNAME = "__all_pkg_type";
const char *const OB_ALL_PKG_TYPE_ATTR_TNAME = "__all_pkg_type_attr";
const char *const OB_ALL_PKG_COLL_TYPE_TNAME = "__all_pkg_coll_type";
const char *const OB_WR_SQL_PLAN_TNAME = "__wr_sql_plan";
const char *const OB_ALL_KV_REDIS_TABLE_TNAME = "__all_kv_redis_table";
const char *const OB_ALL_NCOMP_DLL_V2_TNAME = "__all_ncomp_dll_v2";
const char *const OB_FT_DICT_IK_UTF8_TNAME = "__ft_dict_ik_utf8";
const char *const OB_FT_STOPWORD_IK_UTF8_TNAME = "__ft_stopword_ik_utf8";
const char *const OB_FT_QUANTIFIER_IK_UTF8_TNAME = "__ft_quantifier_ik_utf8";
const char *const OB_TENANT_VIRTUAL_ALL_TABLE_TNAME = "__tenant_virtual_all_table";
const char *const OB_TENANT_VIRTUAL_TABLE_COLUMN_TNAME = "__tenant_virtual_table_column";
const char *const OB_TENANT_VIRTUAL_TABLE_INDEX_TNAME = "__tenant_virtual_table_index";
const char *const OB_TENANT_VIRTUAL_SHOW_CREATE_DATABASE_TNAME = "__tenant_virtual_show_create_database";
const char *const OB_TENANT_VIRTUAL_SHOW_CREATE_TABLE_TNAME = "__tenant_virtual_show_create_table";
const char *const OB_TENANT_VIRTUAL_SESSION_VARIABLE_TNAME = "__tenant_virtual_session_variable";
const char *const OB_TENANT_VIRTUAL_PRIVILEGE_GRANT_TNAME = "__tenant_virtual_privilege_grant";
const char *const OB_ALL_VIRTUAL_PROCESSLIST_TNAME = "__all_virtual_processlist";
const char *const OB_TENANT_VIRTUAL_WARNING_TNAME = "__tenant_virtual_warning";
const char *const OB_TENANT_VIRTUAL_CURRENT_TENANT_TNAME = "__tenant_virtual_current_tenant";
const char *const OB_TENANT_VIRTUAL_DATABASE_STATUS_TNAME = "__tenant_virtual_database_status";
const char *const OB_TENANT_VIRTUAL_TENANT_STATUS_TNAME = "__tenant_virtual_tenant_status";
const char *const OB_TENANT_VIRTUAL_STATNAME_TNAME = "__tenant_virtual_statname";
const char *const OB_TENANT_VIRTUAL_EVENT_NAME_TNAME = "__tenant_virtual_event_name";
const char *const OB_TENANT_VIRTUAL_GLOBAL_VARIABLE_TNAME = "__tenant_virtual_global_variable";
const char *const OB_TENANT_VIRTUAL_SHOW_TABLES_TNAME = "__tenant_virtual_show_tables";
const char *const OB_TENANT_VIRTUAL_SHOW_CREATE_PROCEDURE_TNAME = "__tenant_virtual_show_create_procedure";
const char *const OB_ALL_VIRTUAL_CORE_META_TABLE_TNAME = "__all_virtual_core_meta_table";
const char *const OB_ALL_VIRTUAL_PLAN_CACHE_STAT_TNAME = "__all_virtual_plan_cache_stat";
const char *const OB_ALL_VIRTUAL_PLAN_STAT_TNAME = "__all_virtual_plan_stat";
const char *const OB_ALL_VIRTUAL_MEM_LEAK_CHECKER_INFO_TNAME = "__all_virtual_mem_leak_checker_info";
const char *const OB_ALL_VIRTUAL_LATCH_TNAME = "__all_virtual_latch";
const char *const OB_ALL_VIRTUAL_KVCACHE_INFO_TNAME = "__all_virtual_kvcache_info";
const char *const OB_ALL_VIRTUAL_DATA_TYPE_CLASS_TNAME = "__all_virtual_data_type_class";
const char *const OB_ALL_VIRTUAL_DATA_TYPE_TNAME = "__all_virtual_data_type";
const char *const OB_ALL_VIRTUAL_SESSION_EVENT_TNAME = "__all_virtual_session_event";
const char *const OB_ALL_VIRTUAL_SESSION_WAIT_TNAME = "__all_virtual_session_wait";
const char *const OB_ALL_VIRTUAL_SESSION_WAIT_HISTORY_TNAME = "__all_virtual_session_wait_history";
const char *const OB_ALL_VIRTUAL_SYSTEM_EVENT_TNAME = "__all_virtual_system_event";
const char *const OB_ALL_VIRTUAL_TENANT_MEMSTORE_INFO_TNAME = "__all_virtual_tenant_memstore_info";
const char *const OB_ALL_VIRTUAL_CONCURRENCY_OBJECT_POOL_TNAME = "__all_virtual_concurrency_object_pool";
const char *const OB_ALL_VIRTUAL_SESSTAT_TNAME = "__all_virtual_sesstat";
const char *const OB_ALL_VIRTUAL_SYSSTAT_TNAME = "__all_virtual_sysstat";
const char *const OB_ALL_VIRTUAL_DISK_STAT_TNAME = "__all_virtual_disk_stat";
const char *const OB_ALL_VIRTUAL_MEMSTORE_INFO_TNAME = "__all_virtual_memstore_info";
const char *const OB_ALL_VIRTUAL_UPGRADE_INSPECTION_TNAME = "__all_virtual_upgrade_inspection";
const char *const OB_ALL_VIRTUAL_TRANS_STAT_TNAME = "__all_virtual_trans_stat";
const char *const OB_ALL_VIRTUAL_TRANS_CTX_MGR_STAT_TNAME = "__all_virtual_trans_ctx_mgr_stat";
const char *const OB_ALL_VIRTUAL_TRANS_SCHEDULER_TNAME = "__all_virtual_trans_scheduler";
const char *const OB_ALL_VIRTUAL_SQL_AUDIT_TNAME = "__all_virtual_sql_audit";
const char *const OB_ALL_VIRTUAL_CORE_ALL_TABLE_TNAME = "__all_virtual_core_all_table";
const char *const OB_ALL_VIRTUAL_CORE_COLUMN_TABLE_TNAME = "__all_virtual_core_column_table";
const char *const OB_ALL_VIRTUAL_MEMORY_INFO_TNAME = "__all_virtual_memory_info";
const char *const OB_ALL_VIRTUAL_SYS_PARAMETER_STAT_TNAME = "__all_virtual_sys_parameter_stat";
const char *const OB_ALL_VIRTUAL_TRACE_SPAN_INFO_TNAME = "__all_virtual_trace_span_info";
const char *const OB_ALL_VIRTUAL_ENGINE_TNAME = "__all_virtual_engine";
const char *const OB_ALL_VIRTUAL_PROXY_SERVER_STAT_TNAME = "__all_virtual_proxy_server_stat";
const char *const OB_ALL_VIRTUAL_PROXY_SYS_VARIABLE_TNAME = "__all_virtual_proxy_sys_variable";
const char *const OB_ALL_VIRTUAL_PROXY_SCHEMA_TNAME = "__all_virtual_proxy_schema";
const char *const OB_ALL_VIRTUAL_PLAN_CACHE_PLAN_EXPLAIN_TNAME = "__all_virtual_plan_cache_plan_explain";
const char *const OB_ALL_VIRTUAL_OBRPC_STAT_TNAME = "__all_virtual_obrpc_stat";
const char *const OB_TENANT_VIRTUAL_OUTLINE_TNAME = "__tenant_virtual_outline";
const char *const OB_TENANT_VIRTUAL_CONCURRENT_LIMIT_SQL_TNAME = "__tenant_virtual_concurrent_limit_sql";
const char *const OB_ALL_VIRTUAL_TABLET_SSTABLE_MACRO_INFO_TNAME = "__all_virtual_tablet_sstable_macro_info";
const char *const OB_ALL_VIRTUAL_PROXY_PARTITION_INFO_TNAME = "__all_virtual_proxy_partition_info";
const char *const OB_ALL_VIRTUAL_PROXY_PARTITION_TNAME = "__all_virtual_proxy_partition";
const char *const OB_ALL_VIRTUAL_PROXY_SUB_PARTITION_TNAME = "__all_virtual_proxy_sub_partition";
const char *const OB_ALL_VIRTUAL_SYS_TASK_STATUS_TNAME = "__all_virtual_sys_task_status";
const char *const OB_ALL_VIRTUAL_MACRO_BLOCK_MARKER_STATUS_TNAME = "__all_virtual_macro_block_marker_status";
const char *const OB_ALL_VIRTUAL_IO_STAT_TNAME = "__all_virtual_io_stat";
const char *const OB_ALL_VIRTUAL_LONG_OPS_STATUS_TNAME = "__all_virtual_long_ops_status";
const char *const OB_ALL_VIRTUAL_SERVER_OBJECT_POOL_TNAME = "__all_virtual_server_object_pool";
const char *const OB_ALL_VIRTUAL_TRANS_LOCK_STAT_TNAME = "__all_virtual_trans_lock_stat";
const char *const OB_TENANT_VIRTUAL_SHOW_CREATE_TABLEGROUP_TNAME = "__tenant_virtual_show_create_tablegroup";
const char *const OB_ALL_VIRTUAL_SERVER_BLACKLIST_TNAME = "__all_virtual_server_blacklist";
const char *const OB_ALL_VIRTUAL_TENANT_PARAMETER_STAT_TNAME = "__all_virtual_tenant_parameter_stat";
const char *const OB_ALL_VIRTUAL_SERVER_SCHEMA_INFO_TNAME = "__all_virtual_server_schema_info";
const char *const OB_ALL_VIRTUAL_MEMORY_CONTEXT_STAT_TNAME = "__all_virtual_memory_context_stat";
const char *const OB_ALL_VIRTUAL_DUMP_TENANT_INFO_TNAME = "__all_virtual_dump_tenant_info";
const char *const OB_ALL_VIRTUAL_TENANT_PARAMETER_INFO_TNAME = "__all_virtual_tenant_parameter_info";
const char *const OB_ALL_VIRTUAL_AUDIT_OPERATION_TNAME = "__all_virtual_audit_operation";
const char *const OB_ALL_VIRTUAL_AUDIT_ACTION_TNAME = "__all_virtual_audit_action";
const char *const OB_ALL_VIRTUAL_DAG_WARNING_HISTORY_TNAME = "__all_virtual_dag_warning_history";
const char *const OB_ALL_VIRTUAL_TABLET_ENCRYPT_INFO_TNAME = "__all_virtual_tablet_encrypt_info";
const char *const OB_TENANT_VIRTUAL_SHOW_RESTORE_PREVIEW_TNAME = "__tenant_virtual_show_restore_preview";
const char *const OB_ALL_VIRTUAL_MASTER_KEY_VERSION_INFO_TNAME = "__all_virtual_master_key_version_info";
const char *const OB_ALL_VIRTUAL_DAG_TNAME = "__all_virtual_dag";
const char *const OB_ALL_VIRTUAL_DAG_SCHEDULER_TNAME = "__all_virtual_dag_scheduler";
const char *const OB_ALL_VIRTUAL_SERVER_COMPACTION_PROGRESS_TNAME = "__all_virtual_server_compaction_progress";
const char *const OB_ALL_VIRTUAL_TABLET_COMPACTION_PROGRESS_TNAME = "__all_virtual_tablet_compaction_progress";
const char *const OB_ALL_VIRTUAL_COMPACTION_DIAGNOSE_INFO_TNAME = "__all_virtual_compaction_diagnose_info";
const char *const OB_ALL_VIRTUAL_COMPACTION_SUGGESTION_TNAME = "__all_virtual_compaction_suggestion";
const char *const OB_ALL_VIRTUAL_SESSION_INFO_TNAME = "__all_virtual_session_info";
const char *const OB_ALL_VIRTUAL_TABLET_COMPACTION_HISTORY_TNAME = "__all_virtual_tablet_compaction_history";
const char *const OB_ALL_VIRTUAL_IO_CALIBRATION_STATUS_TNAME = "__all_virtual_io_calibration_status";
const char *const OB_ALL_VIRTUAL_IO_BENCHMARK_TNAME = "__all_virtual_io_benchmark";
const char *const OB_ALL_VIRTUAL_IO_QUOTA_TNAME = "__all_virtual_io_quota";
const char *const OB_ALL_VIRTUAL_SERVER_COMPACTION_EVENT_HISTORY_TNAME = "__all_virtual_server_compaction_event_history";
const char *const OB_ALL_VIRTUAL_TABLET_STAT_TNAME = "__all_virtual_tablet_stat";
const char *const OB_ALL_VIRTUAL_DDL_SIM_POINT_TNAME = "__all_virtual_ddl_sim_point";
const char *const OB_ALL_VIRTUAL_DDL_SIM_POINT_STAT_TNAME = "__all_virtual_ddl_sim_point_stat";
const char *const OB_ALL_VIRTUAL_RES_MGR_SYSSTAT_TNAME = "__all_virtual_res_mgr_sysstat";
const char *const OB_SESSION_VARIABLES_TNAME = "SESSION_VARIABLES";
const char *const OB_GLOBAL_STATUS_TNAME = "GLOBAL_STATUS";
const char *const OB_SESSION_STATUS_TNAME = "SESSION_STATUS";
const char *const OB_USER_TNAME = "user";
const char *const OB_DB_TNAME = "db";
const char *const OB_ALL_VIRTUAL_LOCK_WAIT_STAT_TNAME = "__all_virtual_lock_wait_stat";
const char *const OB_TENANT_VIRTUAL_COLLATION_TNAME = "__tenant_virtual_collation";
const char *const OB_TENANT_VIRTUAL_CHARSET_TNAME = "__tenant_virtual_charset";
const char *const OB_ALL_VIRTUAL_TENANT_MEMSTORE_ALLOCATOR_INFO_TNAME = "__all_virtual_tenant_memstore_allocator_info";
const char *const OB_ALL_VIRTUAL_TABLE_MGR_TNAME = "__all_virtual_table_mgr";
const char *const OB_ALL_VIRTUAL_FREEZE_INFO_TNAME = "__all_virtual_freeze_info";
const char *const OB_ALL_VIRTUAL_BAD_BLOCK_TABLE_TNAME = "__all_virtual_bad_block_table";
const char *const OB_ALL_VIRTUAL_PX_WORKER_STAT_TNAME = "__all_virtual_px_worker_stat";
const char *const OB_ALL_VIRTUAL_AUTO_INCREMENT_TNAME = "__all_virtual_auto_increment";
const char *const OB_ALL_VIRTUAL_SEQUENCE_VALUE_TNAME = "__all_virtual_sequence_value";
const char *const OB_ALL_VIRTUAL_TABLET_STORE_STAT_TNAME = "__all_virtual_tablet_store_stat";
const char *const OB_ALL_VIRTUAL_DDL_OPERATION_TNAME = "__all_virtual_ddl_operation";
const char *const OB_ALL_VIRTUAL_OUTLINE_TNAME = "__all_virtual_outline";
const char *const OB_ALL_VIRTUAL_OUTLINE_HISTORY_TNAME = "__all_virtual_outline_history";
const char *const OB_ALL_VIRTUAL_SYNONYM_TNAME = "__all_virtual_synonym";
const char *const OB_ALL_VIRTUAL_SYNONYM_HISTORY_TNAME = "__all_virtual_synonym_history";
const char *const OB_ALL_VIRTUAL_DATABASE_PRIVILEGE_TNAME = "__all_virtual_database_privilege";
const char *const OB_ALL_VIRTUAL_DATABASE_PRIVILEGE_HISTORY_TNAME = "__all_virtual_database_privilege_history";
const char *const OB_ALL_VIRTUAL_TABLE_PRIVILEGE_TNAME = "__all_virtual_table_privilege";
const char *const OB_ALL_VIRTUAL_TABLE_PRIVILEGE_HISTORY_TNAME = "__all_virtual_table_privilege_history";
const char *const OB_ALL_VIRTUAL_DATABASE_TNAME = "__all_virtual_database";
const char *const OB_ALL_VIRTUAL_DATABASE_HISTORY_TNAME = "__all_virtual_database_history";
const char *const OB_ALL_VIRTUAL_TABLEGROUP_TNAME = "__all_virtual_tablegroup";
const char *const OB_ALL_VIRTUAL_TABLEGROUP_HISTORY_TNAME = "__all_virtual_tablegroup_history";
const char *const OB_ALL_VIRTUAL_TABLE_TNAME = "__all_virtual_table";
const char *const OB_ALL_VIRTUAL_TABLE_HISTORY_TNAME = "__all_virtual_table_history";
const char *const OB_ALL_VIRTUAL_COLUMN_TNAME = "__all_virtual_column";
const char *const OB_ALL_VIRTUAL_COLUMN_HISTORY_TNAME = "__all_virtual_column_history";
const char *const OB_ALL_VIRTUAL_PART_TNAME = "__all_virtual_part";
const char *const OB_ALL_VIRTUAL_PART_HISTORY_TNAME = "__all_virtual_part_history";
const char *const OB_ALL_VIRTUAL_PART_INFO_TNAME = "__all_virtual_part_info";
const char *const OB_ALL_VIRTUAL_PART_INFO_HISTORY_TNAME = "__all_virtual_part_info_history";
const char *const OB_ALL_VIRTUAL_DEF_SUB_PART_TNAME = "__all_virtual_def_sub_part";
const char *const OB_ALL_VIRTUAL_DEF_SUB_PART_HISTORY_TNAME = "__all_virtual_def_sub_part_history";
const char *const OB_ALL_VIRTUAL_SUB_PART_TNAME = "__all_virtual_sub_part";
const char *const OB_ALL_VIRTUAL_SUB_PART_HISTORY_TNAME = "__all_virtual_sub_part_history";
const char *const OB_ALL_VIRTUAL_CONSTRAINT_TNAME = "__all_virtual_constraint";
const char *const OB_ALL_VIRTUAL_CONSTRAINT_HISTORY_TNAME = "__all_virtual_constraint_history";
const char *const OB_ALL_VIRTUAL_FOREIGN_KEY_TNAME = "__all_virtual_foreign_key";
const char *const OB_ALL_VIRTUAL_FOREIGN_KEY_HISTORY_TNAME = "__all_virtual_foreign_key_history";
const char *const OB_ALL_VIRTUAL_FOREIGN_KEY_COLUMN_TNAME = "__all_virtual_foreign_key_column";
const char *const OB_ALL_VIRTUAL_FOREIGN_KEY_COLUMN_HISTORY_TNAME = "__all_virtual_foreign_key_column_history";
const char *const OB_ALL_VIRTUAL_TEMP_TABLE_TNAME = "__all_virtual_temp_table";
const char *const OB_ALL_VIRTUAL_ORI_SCHEMA_VERSION_TNAME = "__all_virtual_ori_schema_version";
const char *const OB_ALL_VIRTUAL_SYS_STAT_TNAME = "__all_virtual_sys_stat";
const char *const OB_ALL_VIRTUAL_USER_TNAME = "__all_virtual_user";
const char *const OB_ALL_VIRTUAL_USER_HISTORY_TNAME = "__all_virtual_user_history";
const char *const OB_ALL_VIRTUAL_SYS_VARIABLE_TNAME = "__all_virtual_sys_variable";
const char *const OB_ALL_VIRTUAL_SYS_VARIABLE_HISTORY_TNAME = "__all_virtual_sys_variable_history";
const char *const OB_ALL_VIRTUAL_FUNC_TNAME = "__all_virtual_func";
const char *const OB_ALL_VIRTUAL_FUNC_HISTORY_TNAME = "__all_virtual_func_history";
const char *const OB_ALL_VIRTUAL_PACKAGE_TNAME = "__all_virtual_package";
const char *const OB_ALL_VIRTUAL_PACKAGE_HISTORY_TNAME = "__all_virtual_package_history";
const char *const OB_ALL_VIRTUAL_ROUTINE_TNAME = "__all_virtual_routine";
const char *const OB_ALL_VIRTUAL_ROUTINE_HISTORY_TNAME = "__all_virtual_routine_history";
const char *const OB_ALL_VIRTUAL_ROUTINE_PARAM_TNAME = "__all_virtual_routine_param";
const char *const OB_ALL_VIRTUAL_ROUTINE_PARAM_HISTORY_TNAME = "__all_virtual_routine_param_history";
const char *const OB_ALL_VIRTUAL_TYPE_TNAME = "__all_virtual_type";
const char *const OB_ALL_VIRTUAL_TYPE_HISTORY_TNAME = "__all_virtual_type_history";
const char *const OB_ALL_VIRTUAL_TYPE_ATTR_TNAME = "__all_virtual_type_attr";
const char *const OB_ALL_VIRTUAL_TYPE_ATTR_HISTORY_TNAME = "__all_virtual_type_attr_history";
const char *const OB_ALL_VIRTUAL_COLL_TYPE_TNAME = "__all_virtual_coll_type";
const char *const OB_ALL_VIRTUAL_COLL_TYPE_HISTORY_TNAME = "__all_virtual_coll_type_history";
const char *const OB_ALL_VIRTUAL_RECYCLEBIN_TNAME = "__all_virtual_recyclebin";
const char *const OB_ALL_VIRTUAL_SEQUENCE_OBJECT_TNAME = "__all_virtual_sequence_object";
const char *const OB_ALL_VIRTUAL_SEQUENCE_OBJECT_HISTORY_TNAME = "__all_virtual_sequence_object_history";
const char *const OB_ALL_VIRTUAL_RAID_STAT_TNAME = "__all_virtual_raid_stat";
const char *const OB_ALL_VIRTUAL_DTL_CHANNEL_TNAME = "__all_virtual_dtl_channel";
const char *const OB_ALL_VIRTUAL_DTL_MEMORY_TNAME = "__all_virtual_dtl_memory";
const char *const OB_ALL_VIRTUAL_DBLINK_TNAME = "__all_virtual_dblink";
const char *const OB_ALL_VIRTUAL_DBLINK_HISTORY_TNAME = "__all_virtual_dblink_history";
const char *const OB_ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_TNAME = "__all_virtual_tenant_role_grantee_map";
const char *const OB_ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_HISTORY_TNAME = "__all_virtual_tenant_role_grantee_map_history";
const char *const OB_ALL_VIRTUAL_TENANT_KEYSTORE_TNAME = "__all_virtual_tenant_keystore";
const char *const OB_ALL_VIRTUAL_TENANT_KEYSTORE_HISTORY_TNAME = "__all_virtual_tenant_keystore_history";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_POLICY_TNAME = "__all_virtual_tenant_ols_policy";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_POLICY_HISTORY_TNAME = "__all_virtual_tenant_ols_policy_history";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_COMPONENT_TNAME = "__all_virtual_tenant_ols_component";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_COMPONENT_HISTORY_TNAME = "__all_virtual_tenant_ols_component_history";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_LABEL_TNAME = "__all_virtual_tenant_ols_label";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_LABEL_HISTORY_TNAME = "__all_virtual_tenant_ols_label_history";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_TNAME = "__all_virtual_tenant_ols_user_level";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_HISTORY_TNAME = "__all_virtual_tenant_ols_user_level_history";
const char *const OB_ALL_VIRTUAL_TENANT_TABLESPACE_TNAME = "__all_virtual_tenant_tablespace";
const char *const OB_ALL_VIRTUAL_TENANT_TABLESPACE_HISTORY_TNAME = "__all_virtual_tenant_tablespace_history";
const char *const OB_ALL_VIRTUAL_INFORMATION_COLUMNS_TNAME = "__ALL_VIRTUAL_INFORMATION_COLUMNS";
const char *const OB_ALL_VIRTUAL_TENANT_USER_FAILED_LOGIN_STAT_TNAME = "__all_virtual_tenant_user_failed_login_stat";
const char *const OB_ALL_VIRTUAL_TENANT_PROFILE_TNAME = "__all_virtual_tenant_profile";
const char *const OB_ALL_VIRTUAL_TENANT_PROFILE_HISTORY_TNAME = "__all_virtual_tenant_profile_history";
const char *const OB_ALL_VIRTUAL_SECURITY_AUDIT_TNAME = "__all_virtual_security_audit";
const char *const OB_ALL_VIRTUAL_SECURITY_AUDIT_HISTORY_TNAME = "__all_virtual_security_audit_history";
const char *const OB_ALL_VIRTUAL_TRIGGER_TNAME = "__all_virtual_trigger";
const char *const OB_ALL_VIRTUAL_TRIGGER_HISTORY_TNAME = "__all_virtual_trigger_history";
const char *const OB_ALL_VIRTUAL_PS_STAT_TNAME = "__all_virtual_ps_stat";
const char *const OB_ALL_VIRTUAL_PS_ITEM_INFO_TNAME = "__all_virtual_ps_item_info";
const char *const OB_ALL_VIRTUAL_SQL_WORKAREA_HISTORY_STAT_TNAME = "__all_virtual_sql_workarea_history_stat";
const char *const OB_ALL_VIRTUAL_SQL_WORKAREA_ACTIVE_TNAME = "__all_virtual_sql_workarea_active";
const char *const OB_ALL_VIRTUAL_SQL_WORKAREA_HISTOGRAM_TNAME = "__all_virtual_sql_workarea_histogram";
const char *const OB_ALL_VIRTUAL_SQL_WORKAREA_MEMORY_INFO_TNAME = "__all_virtual_sql_workarea_memory_info";
const char *const OB_ALL_VIRTUAL_SECURITY_AUDIT_RECORD_TNAME = "__all_virtual_security_audit_record";
const char *const OB_ALL_VIRTUAL_SYSAUTH_TNAME = "__all_virtual_sysauth";
const char *const OB_ALL_VIRTUAL_SYSAUTH_HISTORY_TNAME = "__all_virtual_sysauth_history";
const char *const OB_ALL_VIRTUAL_OBJAUTH_TNAME = "__all_virtual_objauth";
const char *const OB_ALL_VIRTUAL_OBJAUTH_HISTORY_TNAME = "__all_virtual_objauth_history";
const char *const OB_ALL_VIRTUAL_BACKUP_INFO_TNAME = "__all_virtual_backup_info";
const char *const OB_ALL_VIRTUAL_ERROR_TNAME = "__all_virtual_error";
const char *const OB_ALL_VIRTUAL_ID_SERVICE_TNAME = "__all_virtual_id_service";
const char *const OB_ALL_VIRTUAL_OBJECT_TYPE_TNAME = "__all_virtual_object_type";
const char *const OB_ALL_VIRTUAL_SQL_PLAN_MONITOR_TNAME = "__all_virtual_sql_plan_monitor";
const char *const OB_ALL_VIRTUAL_SQL_MONITOR_STATNAME_TNAME = "__all_virtual_sql_monitor_statname";
const char *const OB_ALL_VIRTUAL_OPEN_CURSOR_TNAME = "__all_virtual_open_cursor";
const char *const OB_ALL_VIRTUAL_TIME_ZONE_TNAME = "__all_virtual_time_zone";
const char *const OB_ALL_VIRTUAL_TIME_ZONE_NAME_TNAME = "__all_virtual_time_zone_name";
const char *const OB_ALL_VIRTUAL_TIME_ZONE_TRANSITION_TNAME = "__all_virtual_time_zone_transition";
const char *const OB_ALL_VIRTUAL_TIME_ZONE_TRANSITION_TYPE_TNAME = "__all_virtual_time_zone_transition_type";
const char *const OB_ALL_VIRTUAL_CONSTRAINT_COLUMN_TNAME = "__all_virtual_constraint_column";
const char *const OB_ALL_VIRTUAL_CONSTRAINT_COLUMN_HISTORY_TNAME = "__all_virtual_constraint_column_history";
const char *const OB_ALL_VIRTUAL_FILES_TNAME = "__all_virtual_files";
const char *const OB_ALL_VIRTUAL_DEPENDENCY_TNAME = "__all_virtual_dependency";
const char *const OB_TENANT_VIRTUAL_OBJECT_DEFINITION_TNAME = "__tenant_virtual_object_definition";
const char *const OB_ALL_VIRTUAL_GLOBAL_TRANSACTION_TNAME = "__all_virtual_global_transaction";
const char *const OB_ALL_VIRTUAL_DDL_TASK_STATUS_TNAME = "__all_virtual_ddl_task_status";
const char *const OB_ALL_VIRTUAL_DEADLOCK_EVENT_HISTORY_TNAME = "__all_virtual_deadlock_event_history";
const char *const OB_ALL_VIRTUAL_COLUMN_USAGE_TNAME = "__all_virtual_column_usage";
const char *const OB_ALL_VIRTUAL_TENANT_CTX_MEMORY_INFO_TNAME = "__all_virtual_tenant_ctx_memory_info";
const char *const OB_ALL_VIRTUAL_JOB_TNAME = "__all_virtual_job";
const char *const OB_ALL_VIRTUAL_JOB_LOG_TNAME = "__all_virtual_job_log";
const char *const OB_ALL_VIRTUAL_TENANT_DIRECTORY_TNAME = "__all_virtual_tenant_directory";
const char *const OB_ALL_VIRTUAL_TENANT_DIRECTORY_HISTORY_TNAME = "__all_virtual_tenant_directory_history";
const char *const OB_ALL_VIRTUAL_TABLE_STAT_TNAME = "__all_virtual_table_stat";
const char *const OB_ALL_VIRTUAL_COLUMN_STAT_TNAME = "__all_virtual_column_stat";
const char *const OB_ALL_VIRTUAL_HISTOGRAM_STAT_TNAME = "__all_virtual_histogram_stat";
const char *const OB_ALL_VIRTUAL_TENANT_MEMORY_INFO_TNAME = "__all_virtual_tenant_memory_info";
const char *const OB_TENANT_VIRTUAL_SHOW_CREATE_TRIGGER_TNAME = "__tenant_virtual_show_create_trigger";
const char *const OB_ALL_VIRTUAL_PX_TARGET_MONITOR_TNAME = "__all_virtual_px_target_monitor";
const char *const OB_ALL_VIRTUAL_MONITOR_MODIFIED_TNAME = "__all_virtual_monitor_modified";
const char *const OB_ALL_VIRTUAL_TABLE_STAT_HISTORY_TNAME = "__all_virtual_table_stat_history";
const char *const OB_ALL_VIRTUAL_COLUMN_STAT_HISTORY_TNAME = "__all_virtual_column_stat_history";
const char *const OB_ALL_VIRTUAL_HISTOGRAM_STAT_HISTORY_TNAME = "__all_virtual_histogram_stat_history";
const char *const OB_ALL_VIRTUAL_OPTSTAT_GLOBAL_PREFS_TNAME = "__all_virtual_optstat_global_prefs";
const char *const OB_ALL_VIRTUAL_OPTSTAT_USER_PREFS_TNAME = "__all_virtual_optstat_user_prefs";
const char *const OB_ALL_VIRTUAL_DBLINK_INFO_TNAME = "__all_virtual_dblink_info";
const char *const OB_ALL_VIRTUAL_LOG_ARCHIVE_PROGRESS_TNAME = "__all_virtual_log_archive_progress";
const char *const OB_ALL_VIRTUAL_LOG_ARCHIVE_HISTORY_TNAME = "__all_virtual_log_archive_history";
const char *const OB_ALL_VIRTUAL_LOG_ARCHIVE_PIECE_FILES_TNAME = "__all_virtual_log_archive_piece_files";
const char *const OB_ALL_VIRTUAL_LS_LOG_ARCHIVE_PROGRESS_TNAME = "__all_virtual_ls_log_archive_progress";
const char *const OB_ALL_VIRTUAL_BACKUP_STORAGE_INFO_TNAME = "__all_virtual_backup_storage_info";
const char *const OB_ALL_VIRTUAL_LS_STATUS_TNAME = "__all_virtual_ls_status";
const char *const OB_ALL_VIRTUAL_LS_TNAME = "__all_virtual_ls";
const char *const OB_ALL_VIRTUAL_LS_META_TABLE_TNAME = "__all_virtual_ls_meta_table";
const char *const OB_ALL_VIRTUAL_TABLET_META_TABLE_TNAME = "__all_virtual_tablet_meta_table";
const char *const OB_ALL_VIRTUAL_TABLET_TO_LS_TNAME = "__all_virtual_tablet_to_ls";
const char *const OB_ALL_VIRTUAL_LOAD_DATA_STAT_TNAME = "__all_virtual_load_data_stat";
const char *const OB_ALL_VIRTUAL_DAM_LAST_ARCH_TS_TNAME = "__all_virtual_dam_last_arch_ts";
const char *const OB_ALL_VIRTUAL_DAM_CLEANUP_JOBS_TNAME = "__all_virtual_dam_cleanup_jobs";
const char *const OB_ALL_VIRTUAL_BACKUP_TASK_TNAME = "__all_virtual_backup_task";
const char *const OB_ALL_VIRTUAL_BACKUP_TASK_HISTORY_TNAME = "__all_virtual_backup_task_history";
const char *const OB_ALL_VIRTUAL_BACKUP_LS_TASK_TNAME = "__all_virtual_backup_ls_task";
const char *const OB_ALL_VIRTUAL_BACKUP_LS_TASK_HISTORY_TNAME = "__all_virtual_backup_ls_task_history";
const char *const OB_ALL_VIRTUAL_BACKUP_LS_TASK_INFO_TNAME = "__all_virtual_backup_ls_task_info";
const char *const OB_ALL_VIRTUAL_BACKUP_SKIPPED_TABLET_TNAME = "__all_virtual_backup_skipped_tablet";
const char *const OB_ALL_VIRTUAL_BACKUP_SKIPPED_TABLET_HISTORY_TNAME = "__all_virtual_backup_skipped_tablet_history";
const char *const OB_ALL_VIRTUAL_BACKUP_SCHEDULE_TASK_TNAME = "__all_virtual_backup_schedule_task";
const char *const OB_ALL_VIRTUAL_TABLET_TO_TABLE_HISTORY_TNAME = "__all_virtual_tablet_to_table_history";
const char *const OB_ALL_VIRTUAL_LOG_STAT_TNAME = "__all_virtual_log_stat";
const char *const OB_ALL_VIRTUAL_TENANT_INFO_TNAME = "__all_virtual_tenant_info";
const char *const OB_ALL_VIRTUAL_LS_RECOVERY_STAT_TNAME = "__all_virtual_ls_recovery_stat";
const char *const OB_ALL_VIRTUAL_BACKUP_LS_TASK_INFO_HISTORY_TNAME = "__all_virtual_backup_ls_task_info_history";
const char *const OB_ALL_VIRTUAL_TABLET_REPLICA_CHECKSUM_TNAME = "__all_virtual_tablet_replica_checksum";
const char *const OB_ALL_VIRTUAL_DDL_CHECKSUM_TNAME = "__all_virtual_ddl_checksum";
const char *const OB_ALL_VIRTUAL_DDL_ERROR_MESSAGE_TNAME = "__all_virtual_ddl_error_message";
const char *const OB_ALL_VIRTUAL_LS_REPLICA_TASK_TNAME = "__all_virtual_ls_replica_task";
const char *const OB_ALL_VIRTUAL_PENDING_TRANSACTION_TNAME = "__all_virtual_pending_transaction";
const char *const OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_TNAME = "__all_virtual_tenant_scheduler_job";
const char *const OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_RUN_DETAIL_TNAME = "__all_virtual_tenant_scheduler_job_run_detail";
const char *const OB_ALL_VIRTUAL_TENANT_SCHEDULER_PROGRAM_TNAME = "__all_virtual_tenant_scheduler_program";
const char *const OB_ALL_VIRTUAL_TENANT_SCHEDULER_PROGRAM_ARGUMENT_TNAME = "__all_virtual_tenant_scheduler_program_argument";
const char *const OB_ALL_VIRTUAL_TENANT_CONTEXT_TNAME = "__all_virtual_tenant_context";
const char *const OB_ALL_VIRTUAL_TENANT_CONTEXT_HISTORY_TNAME = "__all_virtual_tenant_context_history";
const char *const OB_ALL_VIRTUAL_GLOBAL_CONTEXT_VALUE_TNAME = "__all_virtual_global_context_value";
const char *const OB_ALL_VIRTUAL_UNIT_TNAME = "__all_virtual_unit";
const char *const OB_ALL_VIRTUAL_SERVER_TNAME = "__all_virtual_server";
const char *const OB_ALL_VIRTUAL_LS_ELECTION_REFERENCE_INFO_TNAME = "__all_virtual_ls_election_reference_info";
const char *const OB_ALL_VIRTUAL_DTL_INTERM_RESULT_MONITOR_TNAME = "__all_virtual_dtl_interm_result_monitor";
const char *const OB_ALL_VIRTUAL_ARCHIVE_STAT_TNAME = "__all_virtual_archive_stat";
const char *const OB_ALL_VIRTUAL_APPLY_STAT_TNAME = "__all_virtual_apply_stat";
const char *const OB_ALL_VIRTUAL_REPLAY_STAT_TNAME = "__all_virtual_replay_stat";
const char *const OB_ALL_VIRTUAL_PROXY_ROUTINE_TNAME = "__all_virtual_proxy_routine";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_TASK_TNAME = "__all_virtual_backup_delete_task";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_TASK_HISTORY_TNAME = "__all_virtual_backup_delete_task_history";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_LS_TASK_TNAME = "__all_virtual_backup_delete_ls_task";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_LS_TASK_HISTORY_TNAME = "__all_virtual_backup_delete_ls_task_history";
const char *const OB_ALL_VIRTUAL_LS_INFO_TNAME = "__all_virtual_ls_info";
const char *const OB_ALL_VIRTUAL_TABLET_INFO_TNAME = "__all_virtual_tablet_info";
const char *const OB_ALL_VIRTUAL_OBJ_LOCK_TNAME = "__all_virtual_obj_lock";
const char *const OB_ALL_VIRTUAL_ZONE_MERGE_INFO_TNAME = "__all_virtual_zone_merge_info";
const char *const OB_ALL_VIRTUAL_MERGE_INFO_TNAME = "__all_virtual_merge_info";
const char *const OB_ALL_VIRTUAL_TX_DATA_TABLE_TNAME = "__all_virtual_tx_data_table";
const char *const OB_ALL_VIRTUAL_TRANSACTION_FREEZE_CHECKPOINT_TNAME = "__all_virtual_transaction_freeze_checkpoint";
const char *const OB_ALL_VIRTUAL_TRANSACTION_CHECKPOINT_TNAME = "__all_virtual_transaction_checkpoint";
const char *const OB_ALL_VIRTUAL_CHECKPOINT_TNAME = "__all_virtual_checkpoint";
const char *const OB_ALL_VIRTUAL_BACKUP_SET_FILES_TNAME = "__all_virtual_backup_set_files";
const char *const OB_ALL_VIRTUAL_BACKUP_JOB_TNAME = "__all_virtual_backup_job";
const char *const OB_ALL_VIRTUAL_BACKUP_JOB_HISTORY_TNAME = "__all_virtual_backup_job_history";
const char *const OB_ALL_VIRTUAL_PLAN_BASELINE_TNAME = "__all_virtual_plan_baseline";
const char *const OB_ALL_VIRTUAL_PLAN_BASELINE_ITEM_TNAME = "__all_virtual_plan_baseline_item";
const char *const OB_ALL_VIRTUAL_SPM_CONFIG_TNAME = "__all_virtual_spm_config";
const char *const OB_ALL_VIRTUAL_ASH_TNAME = "__all_virtual_ash";
const char *const OB_ALL_VIRTUAL_DML_STATS_TNAME = "__all_virtual_dml_stats";
const char *const OB_ALL_VIRTUAL_LOG_ARCHIVE_DEST_PARAMETER_TNAME = "__all_virtual_log_archive_dest_parameter";
const char *const OB_ALL_VIRTUAL_BACKUP_PARAMETER_TNAME = "__all_virtual_backup_parameter";
const char *const OB_ALL_VIRTUAL_RESTORE_JOB_TNAME = "__all_virtual_restore_job";
const char *const OB_ALL_VIRTUAL_RESTORE_JOB_HISTORY_TNAME = "__all_virtual_restore_job_history";
const char *const OB_ALL_VIRTUAL_RESTORE_PROGRESS_TNAME = "__all_virtual_restore_progress";
const char *const OB_ALL_VIRTUAL_LS_RESTORE_PROGRESS_TNAME = "__all_virtual_ls_restore_progress";
const char *const OB_ALL_VIRTUAL_LS_RESTORE_HISTORY_TNAME = "__all_virtual_ls_restore_history";
const char *const OB_ALL_VIRTUAL_BACKUP_STORAGE_INFO_HISTORY_TNAME = "__all_virtual_backup_storage_info_history";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_JOB_TNAME = "__all_virtual_backup_delete_job";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_JOB_HISTORY_TNAME = "__all_virtual_backup_delete_job_history";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_POLICY_TNAME = "__all_virtual_backup_delete_policy";
const char *const OB_ALL_VIRTUAL_TABLET_DDL_KV_INFO_TNAME = "__all_virtual_tablet_ddl_kv_info";
const char *const OB_ALL_VIRTUAL_PRIVILEGE_TNAME = "__all_virtual_privilege";
const char *const OB_ALL_VIRTUAL_TABLET_POINTER_STATUS_TNAME = "__all_virtual_tablet_pointer_status";
const char *const OB_ALL_VIRTUAL_STORAGE_META_MEMORY_STATUS_TNAME = "__all_virtual_storage_meta_memory_status";
const char *const OB_ALL_VIRTUAL_KVCACHE_STORE_MEMBLOCK_TNAME = "__all_virtual_kvcache_store_memblock";
const char *const OB_ALL_VIRTUAL_MOCK_FK_PARENT_TABLE_TNAME = "__all_virtual_mock_fk_parent_table";
const char *const OB_ALL_VIRTUAL_MOCK_FK_PARENT_TABLE_HISTORY_TNAME = "__all_virtual_mock_fk_parent_table_history";
const char *const OB_ALL_VIRTUAL_MOCK_FK_PARENT_TABLE_COLUMN_TNAME = "__all_virtual_mock_fk_parent_table_column";
const char *const OB_ALL_VIRTUAL_MOCK_FK_PARENT_TABLE_COLUMN_HISTORY_TNAME = "__all_virtual_mock_fk_parent_table_column_history";
const char *const OB_ALL_VIRTUAL_LOG_RESTORE_SOURCE_TNAME = "__all_virtual_log_restore_source";
const char *const OB_ALL_VIRTUAL_QUERY_RESPONSE_TIME_TNAME = "__all_virtual_query_response_time";
const char *const OB_ALL_VIRTUAL_KV_TTL_TASK_TNAME = "__all_virtual_kv_ttl_task";
const char *const OB_ALL_VIRTUAL_KV_TTL_TASK_HISTORY_TNAME = "__all_virtual_kv_ttl_task_history";
const char *const OB_ALL_VIRTUAL_COLUMN_CHECKSUM_ERROR_INFO_TNAME = "__all_virtual_column_checksum_error_info";
const char *const OB_ALL_VIRTUAL_TABLET_COMPACTION_INFO_TNAME = "__all_virtual_tablet_compaction_info";
const char *const OB_ALL_VIRTUAL_LS_REPLICA_TASK_PLAN_TNAME = "__all_virtual_ls_replica_task_plan";
const char *const OB_ALL_VIRTUAL_SCHEMA_MEMORY_TNAME = "__all_virtual_schema_memory";
const char *const OB_ALL_VIRTUAL_SCHEMA_SLOT_TNAME = "__all_virtual_schema_slot";
const char *const OB_ALL_VIRTUAL_MINOR_FREEZE_INFO_TNAME = "__all_virtual_minor_freeze_info";
const char *const OB_ALL_VIRTUAL_SHOW_TRACE_TNAME = "__all_virtual_show_trace";
const char *const OB_ALL_VIRTUAL_HA_DIAGNOSE_TNAME = "__all_virtual_ha_diagnose";
const char *const OB_ALL_VIRTUAL_DATA_DICTIONARY_IN_LOG_TNAME = "__all_virtual_data_dictionary_in_log";
const char *const OB_ALL_VIRTUAL_TRANSFER_TASK_TNAME = "__all_virtual_transfer_task";
const char *const OB_ALL_VIRTUAL_TRANSFER_TASK_HISTORY_TNAME = "__all_virtual_transfer_task_history";
const char *const OB_ALL_VIRTUAL_BALANCE_JOB_TNAME = "__all_virtual_balance_job";
const char *const OB_ALL_VIRTUAL_BALANCE_JOB_HISTORY_TNAME = "__all_virtual_balance_job_history";
const char *const OB_ALL_VIRTUAL_BALANCE_TASK_TNAME = "__all_virtual_balance_task";
const char *const OB_ALL_VIRTUAL_BALANCE_TASK_HISTORY_TNAME = "__all_virtual_balance_task_history";
const char *const OB_ALL_VIRTUAL_RLS_POLICY_TNAME = "__all_virtual_rls_policy";
const char *const OB_ALL_VIRTUAL_RLS_POLICY_HISTORY_TNAME = "__all_virtual_rls_policy_history";
const char *const OB_ALL_VIRTUAL_RLS_SECURITY_COLUMN_TNAME = "__all_virtual_rls_security_column";
const char *const OB_ALL_VIRTUAL_RLS_SECURITY_COLUMN_HISTORY_TNAME = "__all_virtual_rls_security_column_history";
const char *const OB_ALL_VIRTUAL_RLS_GROUP_TNAME = "__all_virtual_rls_group";
const char *const OB_ALL_VIRTUAL_RLS_GROUP_HISTORY_TNAME = "__all_virtual_rls_group_history";
const char *const OB_ALL_VIRTUAL_RLS_CONTEXT_TNAME = "__all_virtual_rls_context";
const char *const OB_ALL_VIRTUAL_RLS_CONTEXT_HISTORY_TNAME = "__all_virtual_rls_context_history";
const char *const OB_ALL_VIRTUAL_RLS_ATTRIBUTE_TNAME = "__all_virtual_rls_attribute";
const char *const OB_ALL_VIRTUAL_RLS_ATTRIBUTE_HISTORY_TNAME = "__all_virtual_rls_attribute_history";
const char *const OB_ALL_VIRTUAL_TENANT_MYSQL_SYS_AGENT_TNAME = "__all_virtual_tenant_mysql_sys_agent";
const char *const OB_ALL_VIRTUAL_SQL_PLAN_TNAME = "__all_virtual_sql_plan";
const char *const OB_ALL_VIRTUAL_CORE_TABLE_TNAME = "__all_virtual_core_table";
const char *const OB_ALL_VIRTUAL_MALLOC_SAMPLE_INFO_TNAME = "__all_virtual_malloc_sample_info";
const char *const OB_ALL_VIRTUAL_LS_ARB_REPLICA_TASK_TNAME = "__all_virtual_ls_arb_replica_task";
const char *const OB_ALL_VIRTUAL_LS_ARB_REPLICA_TASK_HISTORY_TNAME = "__all_virtual_ls_arb_replica_task_history";
const char *const OB_ALL_VIRTUAL_ARCHIVE_DEST_STATUS_TNAME = "__all_virtual_archive_dest_status";
const char *const OB_ALL_VIRTUAL_IO_SCHEDULER_TNAME = "__all_virtual_io_scheduler";
const char *const OB_ALL_VIRTUAL_EXTERNAL_TABLE_FILE_TNAME = "__all_virtual_external_table_file";
const char *const OB_ALL_VIRTUAL_MDS_NODE_STAT_TNAME = "__all_virtual_mds_node_stat";
const char *const OB_ALL_VIRTUAL_MDS_EVENT_HISTORY_TNAME = "__all_virtual_mds_event_history";
const char *const OB_ALL_VIRTUAL_DUP_LS_LEASE_MGR_TNAME = "__all_virtual_dup_ls_lease_mgr";
const char *const OB_ALL_VIRTUAL_DUP_LS_TABLET_SET_TNAME = "__all_virtual_dup_ls_tablet_set";
const char *const OB_ALL_VIRTUAL_DUP_LS_TABLETS_TNAME = "__all_virtual_dup_ls_tablets";
const char *const OB_ALL_VIRTUAL_TX_DATA_TNAME = "__all_virtual_tx_data";
const char *const OB_ALL_VIRTUAL_TASK_OPT_STAT_GATHER_HISTORY_TNAME = "__all_virtual_task_opt_stat_gather_history";
const char *const OB_ALL_VIRTUAL_TABLE_OPT_STAT_GATHER_HISTORY_TNAME = "__all_virtual_table_opt_stat_gather_history";
const char *const OB_ALL_VIRTUAL_OPT_STAT_GATHER_MONITOR_TNAME = "__all_virtual_opt_stat_gather_monitor";
const char *const OB_ALL_VIRTUAL_THREAD_TNAME = "__all_virtual_thread";
const char *const OB_ALL_VIRTUAL_ARBITRATION_MEMBER_INFO_TNAME = "__all_virtual_arbitration_member_info";
const char *const OB_ALL_VIRTUAL_SERVER_STORAGE_TNAME = "__all_virtual_server_storage";
const char *const OB_ALL_VIRTUAL_ARBITRATION_SERVICE_STATUS_TNAME = "__all_virtual_arbitration_service_status";
const char *const OB_ALL_VIRTUAL_WR_ACTIVE_SESSION_HISTORY_TNAME = "__all_virtual_wr_active_session_history";
const char *const OB_ALL_VIRTUAL_WR_SNAPSHOT_TNAME = "__all_virtual_wr_snapshot";
const char *const OB_ALL_VIRTUAL_WR_STATNAME_TNAME = "__all_virtual_wr_statname";
const char *const OB_ALL_VIRTUAL_WR_SYSSTAT_TNAME = "__all_virtual_wr_sysstat";
const char *const OB_ALL_VIRTUAL_KV_CONNECTION_TNAME = "__all_virtual_kv_connection";
const char *const OB_ALL_VIRTUAL_VIRTUAL_LONG_OPS_STATUS_MYSQL_SYS_AGENT_TNAME = "__all_virtual_virtual_long_ops_status_mysql_sys_agent";
const char *const OB_ALL_VIRTUAL_LS_TRANSFER_MEMBER_LIST_LOCK_INFO_TNAME = "__all_virtual_ls_transfer_member_list_lock_info";
const char *const OB_ALL_VIRTUAL_TIMESTAMP_SERVICE_TNAME = "__all_virtual_timestamp_service";
const char *const OB_ALL_VIRTUAL_RESOURCE_POOL_MYSQL_SYS_AGENT_TNAME = "__all_virtual_resource_pool_mysql_sys_agent";
const char *const OB_ALL_VIRTUAL_PX_P2P_DATAHUB_TNAME = "__all_virtual_px_p2p_datahub";
const char *const OB_ALL_VIRTUAL_COLUMN_GROUP_TNAME = "__all_virtual_column_group";
const char *const OB_ALL_VIRTUAL_STORAGE_LEAK_INFO_TNAME = "__all_virtual_storage_leak_info";
const char *const OB_ALL_VIRTUAL_LS_LOG_RESTORE_STATUS_TNAME = "__all_virtual_ls_log_restore_status";
const char *const OB_ALL_VIRTUAL_TENANT_PARAMETER_TNAME = "__all_virtual_tenant_parameter";
const char *const OB_ALL_VIRTUAL_TENANT_SNAPSHOT_TNAME = "__all_virtual_tenant_snapshot";
const char *const OB_ALL_VIRTUAL_TENANT_SNAPSHOT_LS_TNAME = "__all_virtual_tenant_snapshot_ls";
const char *const OB_ALL_VIRTUAL_TENANT_SNAPSHOT_LS_REPLICA_TNAME = "__all_virtual_tenant_snapshot_ls_replica";
const char *const OB_ALL_VIRTUAL_TABLET_BUFFER_INFO_TNAME = "__all_virtual_tablet_buffer_info";
const char *const OB_ALL_VIRTUAL_MLOG_TNAME = "__all_virtual_mlog";
const char *const OB_ALL_VIRTUAL_MVIEW_TNAME = "__all_virtual_mview";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_TNAME = "__all_virtual_mview_refresh_stats_sys_defaults";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_PARAMS_TNAME = "__all_virtual_mview_refresh_stats_params";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_RUN_STATS_TNAME = "__all_virtual_mview_refresh_run_stats";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_TNAME = "__all_virtual_mview_refresh_stats";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_CHANGE_STATS_TNAME = "__all_virtual_mview_refresh_change_stats";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_STMT_STATS_TNAME = "__all_virtual_mview_refresh_stmt_stats";
const char *const OB_ALL_VIRTUAL_WR_CONTROL_TNAME = "__all_virtual_wr_control";
const char *const OB_ALL_VIRTUAL_TENANT_EVENT_HISTORY_TNAME = "__all_virtual_tenant_event_history";
const char *const OB_ALL_VIRTUAL_BALANCE_TASK_HELPER_TNAME = "__all_virtual_balance_task_helper";
const char *const OB_ALL_VIRTUAL_BALANCE_GROUP_LS_STAT_TNAME = "__all_virtual_balance_group_ls_stat";
const char *const OB_ALL_VIRTUAL_CGROUP_CONFIG_TNAME = "__all_virtual_cgroup_config";
const char *const OB_ALL_VIRTUAL_FLT_CONFIG_TNAME = "__all_virtual_flt_config";
const char *const OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_CLASS_TNAME = "__all_virtual_tenant_scheduler_job_class";
const char *const OB_ALL_VIRTUAL_RECOVER_TABLE_JOB_TNAME = "__all_virtual_recover_table_job";
const char *const OB_ALL_VIRTUAL_RECOVER_TABLE_JOB_HISTORY_TNAME = "__all_virtual_recover_table_job_history";
const char *const OB_ALL_VIRTUAL_IMPORT_TABLE_JOB_TNAME = "__all_virtual_import_table_job";
const char *const OB_ALL_VIRTUAL_IMPORT_TABLE_JOB_HISTORY_TNAME = "__all_virtual_import_table_job_history";
const char *const OB_ALL_VIRTUAL_IMPORT_TABLE_TASK_TNAME = "__all_virtual_import_table_task";
const char *const OB_ALL_VIRTUAL_IMPORT_TABLE_TASK_HISTORY_TNAME = "__all_virtual_import_table_task_history";
const char *const OB_ALL_VIRTUAL_DATA_ACTIVITY_METRICS_TNAME = "__all_virtual_data_activity_metrics";
const char *const OB_ALL_VIRTUAL_COLUMN_GROUP_MAPPING_TNAME = "__all_virtual_column_group_mapping";
const char *const OB_ALL_VIRTUAL_COLUMN_GROUP_HISTORY_TNAME = "__all_virtual_column_group_history";
const char *const OB_ALL_VIRTUAL_COLUMN_GROUP_MAPPING_HISTORY_TNAME = "__all_virtual_column_group_mapping_history";
const char *const OB_ALL_VIRTUAL_STORAGE_HA_ERROR_DIAGNOSE_TNAME = "__all_virtual_storage_ha_error_diagnose";
const char *const OB_ALL_VIRTUAL_STORAGE_HA_PERF_DIAGNOSE_TNAME = "__all_virtual_storage_ha_perf_diagnose";
const char *const OB_ALL_VIRTUAL_CLONE_JOB_TNAME = "__all_virtual_clone_job";
const char *const OB_ALL_VIRTUAL_CLONE_JOB_HISTORY_TNAME = "__all_virtual_clone_job_history";
const char *const OB_ALL_VIRTUAL_CHECKPOINT_DIAGNOSE_MEMTABLE_INFO_TNAME = "__all_virtual_checkpoint_diagnose_memtable_info";
const char *const OB_ALL_VIRTUAL_CHECKPOINT_DIAGNOSE_CHECKPOINT_UNIT_INFO_TNAME = "__all_virtual_checkpoint_diagnose_checkpoint_unit_info";
const char *const OB_ALL_VIRTUAL_CHECKPOINT_DIAGNOSE_INFO_TNAME = "__all_virtual_checkpoint_diagnose_info";
const char *const OB_ALL_VIRTUAL_WR_SYSTEM_EVENT_TNAME = "__all_virtual_wr_system_event";
const char *const OB_ALL_VIRTUAL_WR_EVENT_NAME_TNAME = "__all_virtual_wr_event_name";
const char *const OB_ALL_VIRTUAL_TENANT_SCHEDULER_RUNNING_JOB_TNAME = "__all_virtual_tenant_scheduler_running_job";
const char *const OB_ALL_VIRTUAL_ROUTINE_PRIVILEGE_TNAME = "__all_virtual_routine_privilege";
const char *const OB_ALL_VIRTUAL_ROUTINE_PRIVILEGE_HISTORY_TNAME = "__all_virtual_routine_privilege_history";
const char *const OB_ALL_VIRTUAL_SQLSTAT_TNAME = "__all_virtual_sqlstat";
const char *const OB_ALL_VIRTUAL_WR_SQLSTAT_TNAME = "__all_virtual_wr_sqlstat";
const char *const OB_ALL_VIRTUAL_AUX_STAT_TNAME = "__all_virtual_aux_stat";
const char *const OB_ALL_VIRTUAL_DETECT_LOCK_INFO_TNAME = "__all_virtual_detect_lock_info";
const char *const OB_ALL_VIRTUAL_CLIENT_TO_SERVER_SESSION_INFO_TNAME = "__all_virtual_client_to_server_session_info";
const char *const OB_ALL_VIRTUAL_SYS_VARIABLE_DEFAULT_VALUE_TNAME = "__all_virtual_sys_variable_default_value";
const char *const OB_ALL_VIRTUAL_TRANSFER_PARTITION_TASK_TNAME = "__all_virtual_transfer_partition_task";
const char *const OB_ALL_VIRTUAL_TRANSFER_PARTITION_TASK_HISTORY_TNAME = "__all_virtual_transfer_partition_task_history";
const char *const OB_ALL_VIRTUAL_TENANT_SNAPSHOT_JOB_TNAME = "__all_virtual_tenant_snapshot_job";
const char *const OB_ALL_VIRTUAL_WR_SQLTEXT_TNAME = "__all_virtual_wr_sqltext";
const char *const OB_ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_TNAME = "__all_virtual_dbms_lock_allocated";
const char *const OB_ALL_VIRTUAL_SHARED_STORAGE_COMPACTION_INFO_TNAME = "__all_virtual_shared_storage_compaction_info";
const char *const OB_ALL_VIRTUAL_LS_SNAPSHOT_TNAME = "__all_virtual_ls_snapshot";
const char *const OB_ALL_VIRTUAL_INDEX_USAGE_INFO_TNAME = "__all_virtual_index_usage_info";
const char *const OB_ALL_VIRTUAL_AUDIT_LOG_FILTER_TNAME = "__all_virtual_audit_log_filter";
const char *const OB_ALL_VIRTUAL_AUDIT_LOG_USER_TNAME = "__all_virtual_audit_log_user";
const char *const OB_ALL_VIRTUAL_COLUMN_PRIVILEGE_TNAME = "__all_virtual_column_privilege";
const char *const OB_ALL_VIRTUAL_COLUMN_PRIVILEGE_HISTORY_TNAME = "__all_virtual_column_privilege_history";
const char *const OB_ALL_VIRTUAL_TENANT_SNAPSHOT_LS_REPLICA_HISTORY_TNAME = "__all_virtual_tenant_snapshot_ls_replica_history";
const char *const OB_ALL_VIRTUAL_SHARED_STORAGE_QUOTA_TNAME = "__all_virtual_shared_storage_quota";
const char *const OB_ENABLED_ROLES_TNAME = "ENABLED_ROLES";
const char *const OB_ALL_VIRTUAL_LS_REPLICA_TASK_HISTORY_TNAME = "__all_virtual_ls_replica_task_history";
const char *const OB_ALL_VIRTUAL_SESSION_PS_INFO_TNAME = "__all_virtual_session_ps_info";
const char *const OB_ALL_VIRTUAL_TRACEPOINT_INFO_TNAME = "__all_virtual_tracepoint_info";
const char *const OB_ALL_VIRTUAL_TABLET_CHECKSUM_ERROR_INFO_TNAME = "__all_virtual_tablet_checksum_error_info";
const char *const OB_ALL_VIRTUAL_COMPATIBILITY_CONTROL_TNAME = "__all_virtual_compatibility_control";
const char *const OB_ALL_VIRTUAL_USER_PROXY_INFO_TNAME = "__all_virtual_user_proxy_info";
const char *const OB_ALL_VIRTUAL_USER_PROXY_INFO_HISTORY_TNAME = "__all_virtual_user_proxy_info_history";
const char *const OB_ALL_VIRTUAL_USER_PROXY_ROLE_INFO_TNAME = "__all_virtual_user_proxy_role_info";
const char *const OB_ALL_VIRTUAL_USER_PROXY_ROLE_INFO_HISTORY_TNAME = "__all_virtual_user_proxy_role_info_history";
const char *const OB_ALL_VIRTUAL_TABLET_REORGANIZE_HISTORY_TNAME = "__all_virtual_tablet_reorganize_history";
const char *const OB_ALL_VIRTUAL_RES_MGR_DIRECTIVE_TNAME = "__all_virtual_res_mgr_directive";
const char *const OB_ALL_VIRTUAL_SERVICE_TNAME = "__all_virtual_service";
const char *const OB_ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_TNAME = "__all_virtual_tenant_resource_limit";
const char *const OB_ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_DETAIL_TNAME = "__all_virtual_tenant_resource_limit_detail";
const char *const OB_ALL_VIRTUAL_GROUP_IO_STAT_TNAME = "__all_virtual_group_io_stat";
const char *const OB_ALL_VIRTUAL_STORAGE_IO_USAGE_TNAME = "__all_virtual_storage_io_usage";
const char *const OB_ALL_VIRTUAL_ZONE_STORAGE_MYSQL_SYS_AGENT_TNAME = "__all_virtual_zone_storage_mysql_sys_agent";
const char *const OB_ALL_VIRTUAL_NIC_INFO_TNAME = "__all_virtual_nic_info";
const char *const OB_ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_TNAME = "__all_virtual_scheduler_job_run_detail_v2";
const char *const OB_ALL_VIRTUAL_SPATIAL_REFERENCE_SYSTEMS_TNAME = "__all_virtual_spatial_reference_systems";
const char *const OB_ALL_VIRTUAL_LOG_TRANSPORT_DEST_STAT_TNAME = "__all_virtual_log_transport_dest_stat";
const char *const OB_ALL_VIRTUAL_SS_LOCAL_CACHE_INFO_TNAME = "__all_virtual_ss_local_cache_info";
const char *const OB_ALL_VIRTUAL_KV_GROUP_COMMIT_STATUS_TNAME = "__all_virtual_kv_group_commit_status";
const char *const OB_ALL_VIRTUAL_SPM_EVO_RESULT_TNAME = "__all_virtual_spm_evo_result";
const char *const OB_ALL_VIRTUAL_VECTOR_INDEX_INFO_TNAME = "__all_virtual_vector_index_info";
const char *const OB_ALL_VIRTUAL_PKG_TYPE_TNAME = "__all_virtual_pkg_type";
const char *const OB_ALL_VIRTUAL_PKG_TYPE_ATTR_TNAME = "__all_virtual_pkg_type_attr";
const char *const OB_ALL_VIRTUAL_PKG_COLL_TYPE_TNAME = "__all_virtual_pkg_coll_type";
const char *const OB_ALL_VIRTUAL_KV_CLIENT_INFO_TNAME = "__all_virtual_kv_client_info";
const char *const OB_ALL_VIRTUAL_WR_SQL_PLAN_TNAME = "__all_virtual_wr_sql_plan";
const char *const OB_ALL_VIRTUAL_KV_REDIS_TABLE_TNAME = "__all_virtual_kv_redis_table";
const char *const OB_ALL_VIRTUAL_FUNCTION_IO_STAT_TNAME = "__all_virtual_function_io_stat";
const char *const OB_ALL_VIRTUAL_TEMP_FILE_TNAME = "__all_virtual_temp_file";
const char *const OB_ALL_VIRTUAL_NCOMP_DLL_V2_TNAME = "__all_virtual_ncomp_dll_v2";
const char *const OB_ALL_VIRTUAL_CS_REPLICA_TABLET_STATS_TNAME = "__all_virtual_cs_replica_tablet_stats";
const char *const OB_ALL_VIRTUAL_DDL_DIAGNOSE_INFO_TNAME = "__all_virtual_ddl_diagnose_info";
const char *const OB_ALL_VIRTUAL_PLUGIN_INFO_TNAME = "__all_virtual_plugin_info";
const char *const OB_ALL_VIRTUAL_SQL_AUDIT_ORA_TNAME = "ALL_VIRTUAL_SQL_AUDIT";
const char *const OB_ALL_VIRTUAL_PLAN_STAT_ORA_TNAME = "ALL_VIRTUAL_PLAN_STAT";
const char *const OB_ALL_VIRTUAL_PLAN_CACHE_PLAN_EXPLAIN_ORA_TNAME = "ALL_VIRTUAL_PLAN_CACHE_PLAN_EXPLAIN";
const char *const OB_TENANT_VIRTUAL_OUTLINE_AGENT_TNAME = "TENANT_VIRTUAL_OUTLINE_AGENT";
const char *const OB_ALL_VIRTUAL_PRIVILEGE_ORA_TNAME = "ALL_VIRTUAL_PRIVILEGE";
const char *const OB_ALL_VIRTUAL_SYS_PARAMETER_STAT_AGENT_TNAME = "ALL_VIRTUAL_SYS_PARAMETER_STAT_AGENT";
const char *const OB_TENANT_VIRTUAL_TABLE_INDEX_AGENT_TNAME = "TENANT_VIRTUAL_TABLE_INDEX_AGENT";
const char *const OB_TENANT_VIRTUAL_CHARSET_AGENT_TNAME = "TENANT_VIRTUAL_CHARSET_AGENT";
const char *const OB_TENANT_VIRTUAL_ALL_TABLE_AGENT_TNAME = "TENANT_VIRTUAL_ALL_TABLE_AGENT";
const char *const OB_TENANT_VIRTUAL_COLLATION_ORA_TNAME = "TENANT_VIRTUAL_COLLATION";
const char *const OB_ALL_VIRTUAL_SERVER_AGENT_TNAME = "ALL_VIRTUAL_SERVER_AGENT";
const char *const OB_ALL_VIRTUAL_PLAN_CACHE_STAT_ORA_TNAME = "ALL_VIRTUAL_PLAN_CACHE_STAT";
const char *const OB_ALL_VIRTUAL_PROCESSLIST_ORA_TNAME = "ALL_VIRTUAL_PROCESSLIST";
const char *const OB_ALL_VIRTUAL_SESSION_WAIT_ORA_TNAME = "ALL_VIRTUAL_SESSION_WAIT";
const char *const OB_ALL_VIRTUAL_SESSION_WAIT_HISTORY_ORA_TNAME = "ALL_VIRTUAL_SESSION_WAIT_HISTORY";
const char *const OB_ALL_VIRTUAL_MEMORY_INFO_ORA_TNAME = "ALL_VIRTUAL_MEMORY_INFO";
const char *const OB_ALL_VIRTUAL_TENANT_MEMSTORE_INFO_ORA_TNAME = "ALL_VIRTUAL_TENANT_MEMSTORE_INFO";
const char *const OB_ALL_VIRTUAL_MEMSTORE_INFO_ORA_TNAME = "ALL_VIRTUAL_MEMSTORE_INFO";
const char *const OB_ALL_VIRTUAL_SESSTAT_ORA_TNAME = "ALL_VIRTUAL_SESSTAT";
const char *const OB_ALL_VIRTUAL_SYSSTAT_ORA_TNAME = "ALL_VIRTUAL_SYSSTAT";
const char *const OB_ALL_VIRTUAL_SYSTEM_EVENT_ORA_TNAME = "ALL_VIRTUAL_SYSTEM_EVENT";
const char *const OB_TENANT_VIRTUAL_SESSION_VARIABLE_ORA_TNAME = "TENANT_VIRTUAL_SESSION_VARIABLE";
const char *const OB_TENANT_VIRTUAL_GLOBAL_VARIABLE_ORA_TNAME = "TENANT_VIRTUAL_GLOBAL_VARIABLE";
const char *const OB_TENANT_VIRTUAL_SHOW_CREATE_TABLE_ORA_TNAME = "TENANT_VIRTUAL_SHOW_CREATE_TABLE";
const char *const OB_TENANT_VIRTUAL_SHOW_CREATE_PROCEDURE_ORA_TNAME = "TENANT_VIRTUAL_SHOW_CREATE_PROCEDURE";
const char *const OB_TENANT_VIRTUAL_SHOW_CREATE_TABLEGROUP_ORA_TNAME = "TENANT_VIRTUAL_SHOW_CREATE_TABLEGROUP";
const char *const OB_TENANT_VIRTUAL_PRIVILEGE_GRANT_ORA_TNAME = "TENANT_VIRTUAL_PRIVILEGE_GRANT";
const char *const OB_TENANT_VIRTUAL_TABLE_COLUMN_ORA_TNAME = "TENANT_VIRTUAL_TABLE_COLUMN";
const char *const OB_ALL_VIRTUAL_TRACE_SPAN_INFO_ORA_TNAME = "ALL_VIRTUAL_TRACE_SPAN_INFO";
const char *const OB_TENANT_VIRTUAL_CONCURRENT_LIMIT_SQL_AGENT_TNAME = "TENANT_VIRTUAL_CONCURRENT_LIMIT_SQL_AGENT";
const char *const OB_ALL_VIRTUAL_DATA_TYPE_ORA_TNAME = "ALL_VIRTUAL_DATA_TYPE";
const char *const OB_ALL_VIRTUAL_AUDIT_OPERATION_ORA_TNAME = "ALL_VIRTUAL_AUDIT_OPERATION";
const char *const OB_ALL_VIRTUAL_AUDIT_ACTION_ORA_TNAME = "ALL_VIRTUAL_AUDIT_ACTION";
const char *const OB_ALL_VIRTUAL_PX_WORKER_STAT_ORA_TNAME = "ALL_VIRTUAL_PX_WORKER_STAT";
const char *const OB_ALL_VIRTUAL_PS_STAT_ORA_TNAME = "ALL_VIRTUAL_PS_STAT";
const char *const OB_ALL_VIRTUAL_PS_ITEM_INFO_ORA_TNAME = "ALL_VIRTUAL_PS_ITEM_INFO";
const char *const OB_ALL_VIRTUAL_TENANT_PARAMETER_STAT_ORA_TNAME = "ALL_VIRTUAL_TENANT_PARAMETER_STAT";
const char *const OB_ALL_VIRTUAL_SQL_WORKAREA_HISTORY_STAT_ORA_TNAME = "ALL_VIRTUAL_SQL_WORKAREA_HISTORY_STAT";
const char *const OB_ALL_VIRTUAL_SQL_WORKAREA_ACTIVE_ORA_TNAME = "ALL_VIRTUAL_SQL_WORKAREA_ACTIVE";
const char *const OB_ALL_VIRTUAL_SQL_WORKAREA_HISTOGRAM_ORA_TNAME = "ALL_VIRTUAL_SQL_WORKAREA_HISTOGRAM";
const char *const OB_ALL_VIRTUAL_SQL_WORKAREA_MEMORY_INFO_ORA_TNAME = "ALL_VIRTUAL_SQL_WORKAREA_MEMORY_INFO";
const char *const OB_ALL_VIRTUAL_TABLE_MGR_ORA_TNAME = "ALL_VIRTUAL_TABLE_MGR";
const char *const OB_ALL_VIRTUAL_SERVER_SCHEMA_INFO_ORA_TNAME = "ALL_VIRTUAL_SERVER_SCHEMA_INFO";
const char *const OB_ALL_VIRTUAL_SQL_PLAN_MONITOR_ORA_TNAME = "ALL_VIRTUAL_SQL_PLAN_MONITOR";
const char *const OB_ALL_VIRTUAL_SQL_MONITOR_STATNAME_ORA_TNAME = "ALL_VIRTUAL_SQL_MONITOR_STATNAME";
const char *const OB_ALL_VIRTUAL_LOCK_WAIT_STAT_ORA_TNAME = "ALL_VIRTUAL_LOCK_WAIT_STAT";
const char *const OB_ALL_VIRTUAL_OPEN_CURSOR_ORA_TNAME = "ALL_VIRTUAL_OPEN_CURSOR";
const char *const OB_TENANT_VIRTUAL_OBJECT_DEFINITION_ORA_TNAME = "TENANT_VIRTUAL_OBJECT_DEFINITION";
const char *const OB_ALL_VIRTUAL_ROUTINE_PARAM_SYS_AGENT_TNAME = "ALL_VIRTUAL_ROUTINE_PARAM_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_TYPE_SYS_AGENT_TNAME = "ALL_VIRTUAL_TYPE_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_TYPE_ATTR_SYS_AGENT_TNAME = "ALL_VIRTUAL_TYPE_ATTR_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_COLL_TYPE_SYS_AGENT_TNAME = "ALL_VIRTUAL_COLL_TYPE_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_PACKAGE_SYS_AGENT_TNAME = "ALL_VIRTUAL_PACKAGE_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_TRIGGER_SYS_AGENT_TNAME = "ALL_VIRTUAL_TENANT_TRIGGER_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_ROUTINE_SYS_AGENT_TNAME = "ALL_VIRTUAL_ROUTINE_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_GLOBAL_TRANSACTION_ORA_TNAME = "ALL_VIRTUAL_GLOBAL_TRANSACTION";
const char *const OB_ALL_VIRTUAL_TABLE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TABLE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_COLUMN_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_COLUMN_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_DATABASE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_DATABASE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_AUTO_INCREMENT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_AUTO_INCREMENT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_PART_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_PART_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SUB_PART_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_SUB_PART_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_PACKAGE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_PACKAGE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SEQUENCE_VALUE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_SEQUENCE_VALUE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_USER_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_USER_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SYNONYM_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_SYNONYM_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_RECYCLEBIN_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_RECYCLEBIN_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_ROUTINE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TABLEGROUP_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TABLEGROUP_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_FOREIGN_KEY_COLUMN_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_FOREIGN_KEY_COLUMN_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_CONSTRAINT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_CONSTRAINT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TYPE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TYPE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TYPE_ATTR_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TYPE_ATTR_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_COLL_TYPE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_COLL_TYPE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_ROUTINE_PARAM_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_ROUTINE_PARAM_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_KEYSTORE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_KEYSTORE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_POLICY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_OLS_POLICY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_COMPONENT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_OLS_COMPONENT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_TABLESPACE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_TABLESPACE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_PROFILE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_PROFILE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TABLE_PRIVILEGE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TABLE_PRIVILEGE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_SECURITY_AUDIT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_SECURITY_AUDIT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_SECURITY_AUDIT_RECORD_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_SECURITY_AUDIT_RECORD_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_SYSAUTH_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_SYSAUTH_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_OBJAUTH_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_OBJAUTH_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_DEF_SUB_PART_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_DEF_SUB_PART_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_DBLINK_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_DBLINK_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_CONSTRAINT_COLUMN_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_CONSTRAINT_COLUMN_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_DEPENDENCY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_DEPENDENCY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_TIME_ZONE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_TIME_ZONE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_TIME_ZONE_NAME_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_TIME_ZONE_NAME_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_TIME_ZONE_TRANSITION_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_TIME_ZONE_TRANSITION_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_TIME_ZONE_TRANSITION_TYPE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_TIME_ZONE_TRANSITION_TYPE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_RES_MGR_PLAN_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_RES_MGR_PLAN_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_RES_MGR_DIRECTIVE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_RES_MGR_DIRECTIVE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TRANS_LOCK_STAT_ORA_TNAME = "ALL_VIRTUAL_TRANS_LOCK_STAT";
const char *const OB_ALL_VIRTUAL_RES_MGR_MAPPING_RULE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_RES_MGR_MAPPING_RULE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TABLET_ENCRYPT_INFO_ORA_TNAME = "ALL_VIRTUAL_TABLET_ENCRYPT_INFO";
const char *const OB_ALL_VIRTUAL_RES_MGR_CONSUMER_GROUP_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_RES_MGR_CONSUMER_GROUP_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_COLUMN_USAGE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_COLUMN_USAGE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_JOB_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_JOB_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_JOB_LOG_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_JOB_LOG_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_DIRECTORY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_DIRECTORY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TABLE_STAT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TABLE_STAT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_COLUMN_STAT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_COLUMN_STAT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_HISTOGRAM_STAT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_HISTOGRAM_STAT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_MEMORY_INFO_ORA_TNAME = "ALL_VIRTUAL_TENANT_MEMORY_INFO";
const char *const OB_TENANT_VIRTUAL_SHOW_CREATE_TRIGGER_ORA_TNAME = "TENANT_VIRTUAL_SHOW_CREATE_TRIGGER";
const char *const OB_ALL_VIRTUAL_PX_TARGET_MONITOR_ORA_TNAME = "ALL_VIRTUAL_PX_TARGET_MONITOR";
const char *const OB_ALL_VIRTUAL_MONITOR_MODIFIED_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_MONITOR_MODIFIED_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TABLE_STAT_HISTORY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TABLE_STAT_HISTORY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_COLUMN_STAT_HISTORY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_COLUMN_STAT_HISTORY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_HISTOGRAM_STAT_HISTORY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_HISTOGRAM_STAT_HISTORY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_OPTSTAT_GLOBAL_PREFS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_OPTSTAT_GLOBAL_PREFS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_OPTSTAT_USER_PREFS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_OPTSTAT_USER_PREFS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_DBLINK_INFO_ORA_TNAME = "ALL_VIRTUAL_DBLINK_INFO";
const char *const OB_ALL_VIRTUAL_DAM_LAST_ARCH_TS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_DAM_LAST_ARCH_TS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_DAM_CLEANUP_JOBS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_DAM_CLEANUP_JOBS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_SCHEDULER_JOB_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_SCHEDULER_PROGRAM_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_SCHEDULER_PROGRAM_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_CONTEXT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_CONTEXT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_GLOBAL_CONTEXT_VALUE_ORA_TNAME = "ALL_VIRTUAL_GLOBAL_CONTEXT_VALUE";
const char *const OB_ALL_VIRTUAL_TRANS_STAT_ORA_TNAME = "ALL_VIRTUAL_TRANS_STAT";
const char *const OB_ALL_VIRTUAL_UNIT_ORA_TNAME = "ALL_VIRTUAL_UNIT";
const char *const OB_ALL_VIRTUAL_KVCACHE_INFO_ORA_TNAME = "ALL_VIRTUAL_KVCACHE_INFO";
const char *const OB_ALL_VIRTUAL_SERVER_COMPACTION_PROGRESS_ORA_TNAME = "ALL_VIRTUAL_SERVER_COMPACTION_PROGRESS";
const char *const OB_ALL_VIRTUAL_TABLET_COMPACTION_PROGRESS_ORA_TNAME = "ALL_VIRTUAL_TABLET_COMPACTION_PROGRESS";
const char *const OB_ALL_VIRTUAL_COMPACTION_DIAGNOSE_INFO_ORA_TNAME = "ALL_VIRTUAL_COMPACTION_DIAGNOSE_INFO";
const char *const OB_ALL_VIRTUAL_COMPACTION_SUGGESTION_ORA_TNAME = "ALL_VIRTUAL_COMPACTION_SUGGESTION";
const char *const OB_ALL_VIRTUAL_TABLET_COMPACTION_HISTORY_ORA_TNAME = "ALL_VIRTUAL_TABLET_COMPACTION_HISTORY";
const char *const OB_ALL_VIRTUAL_LS_META_TABLE_ORA_TNAME = "ALL_VIRTUAL_LS_META_TABLE";
const char *const OB_ALL_VIRTUAL_TABLET_TO_LS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TABLET_TO_LS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TABLET_META_TABLE_ORA_TNAME = "ALL_VIRTUAL_TABLET_META_TABLE";
const char *const OB_ALL_VIRTUAL_CORE_ALL_TABLE_ORA_TNAME = "ALL_VIRTUAL_CORE_ALL_TABLE";
const char *const OB_ALL_VIRTUAL_CORE_COLUMN_TABLE_ORA_TNAME = "ALL_VIRTUAL_CORE_COLUMN_TABLE";
const char *const OB_ALL_VIRTUAL_DTL_INTERM_RESULT_MONITOR_ORA_TNAME = "ALL_VIRTUAL_DTL_INTERM_RESULT_MONITOR";
const char *const OB_ALL_VIRTUAL_PROXY_SCHEMA_ORA_TNAME = "ALL_VIRTUAL_PROXY_SCHEMA";
const char *const OB_ALL_VIRTUAL_PROXY_PARTITION_ORA_TNAME = "ALL_VIRTUAL_PROXY_PARTITION";
const char *const OB_ALL_VIRTUAL_PROXY_PARTITION_INFO_ORA_TNAME = "ALL_VIRTUAL_PROXY_PARTITION_INFO";
const char *const OB_ALL_VIRTUAL_PROXY_SUB_PARTITION_ORA_TNAME = "ALL_VIRTUAL_PROXY_SUB_PARTITION";
const char *const OB_ALL_VIRTUAL_ZONE_MERGE_INFO_ORA_TNAME = "ALL_VIRTUAL_ZONE_MERGE_INFO";
const char *const OB_ALL_VIRTUAL_MERGE_INFO_ORA_TNAME = "ALL_VIRTUAL_MERGE_INFO";
const char *const OB_ALL_VIRTUAL_TENANT_OBJECT_TYPE_SYS_AGENT_TNAME = "ALL_VIRTUAL_TENANT_OBJECT_TYPE_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_BACKUP_JOB_ORA_TNAME = "ALL_VIRTUAL_BACKUP_JOB";
const char *const OB_ALL_VIRTUAL_BACKUP_JOB_HISTORY_ORA_TNAME = "ALL_VIRTUAL_BACKUP_JOB_HISTORY";
const char *const OB_ALL_VIRTUAL_BACKUP_TASK_ORA_TNAME = "ALL_VIRTUAL_BACKUP_TASK";
const char *const OB_ALL_VIRTUAL_BACKUP_TASK_HISTORY_ORA_TNAME = "ALL_VIRTUAL_BACKUP_TASK_HISTORY";
const char *const OB_ALL_VIRTUAL_BACKUP_SET_FILES_ORA_TNAME = "ALL_VIRTUAL_BACKUP_SET_FILES";
const char *const OB_ALL_VIRTUAL_PLAN_BASELINE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_PLAN_BASELINE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_PLAN_BASELINE_ITEM_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_PLAN_BASELINE_ITEM_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SPM_CONFIG_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_SPM_CONFIG_REAL_AGENT";
const char *const OB_TENANT_VIRTUAL_EVENT_NAME_ORA_TNAME = "TENANT_VIRTUAL_EVENT_NAME";
const char *const OB_ALL_VIRTUAL_ASH_ORA_TNAME = "ALL_VIRTUAL_ASH";
const char *const OB_ALL_VIRTUAL_DML_STATS_ORA_TNAME = "ALL_VIRTUAL_DML_STATS";
const char *const OB_ALL_VIRTUAL_LOG_ARCHIVE_DEST_PARAMETER_ORA_TNAME = "ALL_VIRTUAL_LOG_ARCHIVE_DEST_PARAMETER";
const char *const OB_ALL_VIRTUAL_LOG_ARCHIVE_PROGRESS_ORA_TNAME = "ALL_VIRTUAL_LOG_ARCHIVE_PROGRESS";
const char *const OB_ALL_VIRTUAL_LOG_ARCHIVE_HISTORY_ORA_TNAME = "ALL_VIRTUAL_LOG_ARCHIVE_HISTORY";
const char *const OB_ALL_VIRTUAL_LOG_ARCHIVE_PIECE_FILES_ORA_TNAME = "ALL_VIRTUAL_LOG_ARCHIVE_PIECE_FILES";
const char *const OB_ALL_VIRTUAL_LS_LOG_ARCHIVE_PROGRESS_ORA_TNAME = "ALL_VIRTUAL_LS_LOG_ARCHIVE_PROGRESS";
const char *const OB_ALL_VIRTUAL_BACKUP_PARAMETER_ORA_TNAME = "ALL_VIRTUAL_BACKUP_PARAMETER";
const char *const OB_ALL_VIRTUAL_RESTORE_JOB_ORA_TNAME = "ALL_VIRTUAL_RESTORE_JOB";
const char *const OB_ALL_VIRTUAL_RESTORE_JOB_HISTORY_ORA_TNAME = "ALL_VIRTUAL_RESTORE_JOB_HISTORY";
const char *const OB_ALL_VIRTUAL_RESTORE_PROGRESS_ORA_TNAME = "ALL_VIRTUAL_RESTORE_PROGRESS";
const char *const OB_ALL_VIRTUAL_LS_RESTORE_PROGRESS_ORA_TNAME = "ALL_VIRTUAL_LS_RESTORE_PROGRESS";
const char *const OB_ALL_VIRTUAL_LS_RESTORE_HISTORY_ORA_TNAME = "ALL_VIRTUAL_LS_RESTORE_HISTORY";
const char *const OB_ALL_VIRTUAL_OUTLINE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_OUTLINE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_OUTLINE_HISTORY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_OUTLINE_HISTORY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_BACKUP_STORAGE_INFO_ORA_TNAME = "ALL_VIRTUAL_BACKUP_STORAGE_INFO";
const char *const OB_ALL_VIRTUAL_BACKUP_STORAGE_INFO_HISTORY_ORA_TNAME = "ALL_VIRTUAL_BACKUP_STORAGE_INFO_HISTORY";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_JOB_ORA_TNAME = "ALL_VIRTUAL_BACKUP_DELETE_JOB";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_JOB_HISTORY_ORA_TNAME = "ALL_VIRTUAL_BACKUP_DELETE_JOB_HISTORY";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_TASK_ORA_TNAME = "ALL_VIRTUAL_BACKUP_DELETE_TASK";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_TASK_HISTORY_ORA_TNAME = "ALL_VIRTUAL_BACKUP_DELETE_TASK_HISTORY";
const char *const OB_ALL_VIRTUAL_BACKUP_DELETE_POLICY_ORA_TNAME = "ALL_VIRTUAL_BACKUP_DELETE_POLICY";
const char *const OB_ALL_VIRTUAL_DEADLOCK_EVENT_HISTORY_ORA_TNAME = "ALL_VIRTUAL_DEADLOCK_EVENT_HISTORY";
const char *const OB_ALL_VIRTUAL_LOG_STAT_ORA_TNAME = "ALL_VIRTUAL_LOG_STAT";
const char *const OB_ALL_VIRTUAL_REPLAY_STAT_ORA_TNAME = "ALL_VIRTUAL_REPLAY_STAT";
const char *const OB_ALL_VIRTUAL_APPLY_STAT_ORA_TNAME = "ALL_VIRTUAL_APPLY_STAT";
const char *const OB_ALL_VIRTUAL_ARCHIVE_STAT_ORA_TNAME = "ALL_VIRTUAL_ARCHIVE_STAT";
const char *const OB_ALL_VIRTUAL_LS_STATUS_ORA_TNAME = "ALL_VIRTUAL_LS_STATUS";
const char *const OB_ALL_VIRTUAL_LS_RECOVERY_STAT_ORA_TNAME = "ALL_VIRTUAL_LS_RECOVERY_STAT";
const char *const OB_ALL_VIRTUAL_LS_ELECTION_REFERENCE_INFO_ORA_TNAME = "ALL_VIRTUAL_LS_ELECTION_REFERENCE_INFO";
const char *const OB_ALL_VIRTUAL_TENANT_INFO_ORA_TNAME = "ALL_VIRTUAL_TENANT_INFO";
const char *const OB_ALL_VIRTUAL_FREEZE_INFO_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_FREEZE_INFO_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_LS_REPLICA_TASK_ORA_TNAME = "ALL_VIRTUAL_LS_REPLICA_TASK";
const char *const OB_ALL_VIRTUAL_LS_REPLICA_TASK_PLAN_ORA_TNAME = "ALL_VIRTUAL_LS_REPLICA_TASK_PLAN";
const char *const OB_ALL_VIRTUAL_SHOW_TRACE_ORA_TNAME = "ALL_VIRTUAL_SHOW_TRACE";
const char *const OB_ALL_VIRTUAL_DATABASE_PRIVILEGE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_DATABASE_PRIVILEGE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_RLS_POLICY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_RLS_POLICY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_RLS_SECURITY_COLUMN_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_RLS_SECURITY_COLUMN_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_RLS_GROUP_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_RLS_GROUP_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_RLS_CONTEXT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_RLS_CONTEXT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_RLS_ATTRIBUTE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_RLS_ATTRIBUTE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_REWRITE_RULES_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_REWRITE_RULES_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TENANT_SYS_AGENT_TNAME = "ALL_VIRTUAL_TENANT_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_SQL_PLAN_ORA_TNAME = "ALL_VIRTUAL_SQL_PLAN";
const char *const OB_ALL_VIRTUAL_TRANS_SCHEDULER_ORA_TNAME = "ALL_VIRTUAL_TRANS_SCHEDULER";
const char *const OB_ALL_VIRTUAL_LS_ARB_REPLICA_TASK_ORA_TNAME = "ALL_VIRTUAL_LS_ARB_REPLICA_TASK";
const char *const OB_ALL_VIRTUAL_LS_ARB_REPLICA_TASK_HISTORY_ORA_TNAME = "ALL_VIRTUAL_LS_ARB_REPLICA_TASK_HISTORY";
const char *const OB_ALL_VIRTUAL_ARCHIVE_DEST_STATUS_ORA_TNAME = "ALL_VIRTUAL_ARCHIVE_DEST_STATUS";
const char *const OB_ALL_VIRTUAL_EXTERNAL_TABLE_FILE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_EXTERNAL_TABLE_FILE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_DATA_DICTIONARY_IN_LOG_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_DATA_DICTIONARY_IN_LOG_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TASK_OPT_STAT_GATHER_HISTORY_ORA_TNAME = "ALL_VIRTUAL_TASK_OPT_STAT_GATHER_HISTORY";
const char *const OB_ALL_VIRTUAL_TABLE_OPT_STAT_GATHER_HISTORY_ORA_TNAME = "ALL_VIRTUAL_TABLE_OPT_STAT_GATHER_HISTORY";
const char *const OB_ALL_VIRTUAL_OPT_STAT_GATHER_MONITOR_ORA_TNAME = "ALL_VIRTUAL_OPT_STAT_GATHER_MONITOR";
const char *const OB_ALL_VIRTUAL_LONG_OPS_STATUS_SYS_AGENT_TNAME = "ALL_VIRTUAL_LONG_OPS_STATUS_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_THREAD_ORA_TNAME = "ALL_VIRTUAL_THREAD";
const char *const OB_ALL_VIRTUAL_WR_ACTIVE_SESSION_HISTORY_ORA_TNAME = "ALL_VIRTUAL_WR_ACTIVE_SESSION_HISTORY";
const char *const OB_ALL_VIRTUAL_WR_SNAPSHOT_ORA_TNAME = "ALL_VIRTUAL_WR_SNAPSHOT";
const char *const OB_ALL_VIRTUAL_WR_STATNAME_ORA_TNAME = "ALL_VIRTUAL_WR_STATNAME";
const char *const OB_ALL_VIRTUAL_WR_SYSSTAT_ORA_TNAME = "ALL_VIRTUAL_WR_SYSSTAT";
const char *const OB_ALL_VIRTUAL_ARBITRATION_MEMBER_INFO_ORA_TNAME = "ALL_VIRTUAL_ARBITRATION_MEMBER_INFO";
const char *const OB_ALL_VIRTUAL_ARBITRATION_SERVICE_STATUS_ORA_TNAME = "ALL_VIRTUAL_ARBITRATION_SERVICE_STATUS";
const char *const OB_ALL_VIRTUAL_OBJ_LOCK_ORA_TNAME = "ALL_VIRTUAL_OBJ_LOCK";
const char *const OB_ALL_VIRTUAL_LOG_RESTORE_SOURCE_ORA_TNAME = "ALL_VIRTUAL_LOG_RESTORE_SOURCE";
const char *const OB_ALL_VIRTUAL_BALANCE_JOB_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_BALANCE_JOB_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_BALANCE_JOB_HISTORY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_BALANCE_JOB_HISTORY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_BALANCE_TASK_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_BALANCE_TASK_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_BALANCE_TASK_HISTORY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_BALANCE_TASK_HISTORY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TRANSFER_TASK_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TRANSFER_TASK_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TRANSFER_TASK_HISTORY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TRANSFER_TASK_HISTORY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_RESOURCE_POOL_SYS_AGENT_TNAME = "ALL_VIRTUAL_RESOURCE_POOL_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_PX_P2P_DATAHUB_ORA_TNAME = "ALL_VIRTUAL_PX_P2P_DATAHUB";
const char *const OB_ALL_VIRTUAL_TIMESTAMP_SERVICE_ORA_TNAME = "ALL_VIRTUAL_TIMESTAMP_SERVICE";
const char *const OB_ALL_VIRTUAL_LS_LOG_RESTORE_STATUS_ORA_TNAME = "ALL_VIRTUAL_LS_LOG_RESTORE_STATUS";
const char *const OB_ALL_VIRTUAL_TENANT_PARAMETER_ORA_TNAME = "ALL_VIRTUAL_TENANT_PARAMETER";
const char *const OB_ALL_VIRTUAL_MLOG_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_MLOG_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_MVIEW_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_MVIEW_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_PARAMS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_MVIEW_REFRESH_STATS_PARAMS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_RUN_STATS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_MVIEW_REFRESH_RUN_STATS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_STATS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_MVIEW_REFRESH_STATS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_CHANGE_STATS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_MVIEW_REFRESH_CHANGE_STATS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_MVIEW_REFRESH_STMT_STATS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_MVIEW_REFRESH_STMT_STATS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_WR_CONTROL_ORA_TNAME = "ALL_VIRTUAL_WR_CONTROL";
const char *const OB_ALL_VIRTUAL_TENANT_EVENT_HISTORY_ORA_TNAME = "ALL_VIRTUAL_TENANT_EVENT_HISTORY";
const char *const OB_ALL_VIRTUAL_LS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_LS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_FLT_CONFIG_ORA_TNAME = "ALL_VIRTUAL_FLT_CONFIG";
const char *const OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_RUN_DETAIL_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_SCHEDULER_JOB_RUN_DETAIL_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SESSION_INFO_ORA_TNAME = "ALL_VIRTUAL_SESSION_INFO";
const char *const OB_ALL_VIRTUAL_TENANT_SCHEDULER_JOB_CLASS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TENANT_SCHEDULER_JOB_CLASS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_RECOVER_TABLE_JOB_ORA_TNAME = "ALL_VIRTUAL_RECOVER_TABLE_JOB";
const char *const OB_ALL_VIRTUAL_RECOVER_TABLE_JOB_HISTORY_ORA_TNAME = "ALL_VIRTUAL_RECOVER_TABLE_JOB_HISTORY";
const char *const OB_ALL_VIRTUAL_IMPORT_TABLE_JOB_ORA_TNAME = "ALL_VIRTUAL_IMPORT_TABLE_JOB";
const char *const OB_ALL_VIRTUAL_IMPORT_TABLE_JOB_HISTORY_ORA_TNAME = "ALL_VIRTUAL_IMPORT_TABLE_JOB_HISTORY";
const char *const OB_ALL_VIRTUAL_IMPORT_TABLE_TASK_ORA_TNAME = "ALL_VIRTUAL_IMPORT_TABLE_TASK";
const char *const OB_ALL_VIRTUAL_IMPORT_TABLE_TASK_HISTORY_ORA_TNAME = "ALL_VIRTUAL_IMPORT_TABLE_TASK_HISTORY";
const char *const OB_ALL_VIRTUAL_LS_INFO_ORA_TNAME = "ALL_VIRTUAL_LS_INFO";
const char *const OB_ALL_VIRTUAL_CGROUP_CONFIG_ORA_TNAME = "ALL_VIRTUAL_CGROUP_CONFIG";
const char *const OB_ALL_VIRTUAL_WR_SYSTEM_EVENT_ORA_TNAME = "ALL_VIRTUAL_WR_SYSTEM_EVENT";
const char *const OB_ALL_VIRTUAL_WR_EVENT_NAME_ORA_TNAME = "ALL_VIRTUAL_WR_EVENT_NAME";
const char *const OB_ALL_VIRTUAL_SQLSTAT_ORA_TNAME = "ALL_VIRTUAL_SQLSTAT";
const char *const OB_ALL_VIRTUAL_WR_SQLSTAT_ORA_TNAME = "ALL_VIRTUAL_WR_SQLSTAT";
const char *const OB_TENANT_VIRTUAL_STATNAME_ORA_TNAME = "TENANT_VIRTUAL_STATNAME";
const char *const OB_ALL_VIRTUAL_AUX_STAT_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_AUX_STAT_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SYS_VARIABLE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_SYS_VARIABLE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SYS_VARIABLE_DEFAULT_VALUE_ORA_TNAME = "ALL_VIRTUAL_SYS_VARIABLE_DEFAULT_VALUE";
const char *const OB_ALL_VIRTUAL_TRANSFER_PARTITION_TASK_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TRANSFER_PARTITION_TASK_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TRANSFER_PARTITION_TASK_HISTORY_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_TRANSFER_PARTITION_TASK_HISTORY_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_WR_SQLTEXT_ORA_TNAME = "ALL_VIRTUAL_WR_SQLTEXT";
const char *const OB_ALL_VIRTUAL_LS_SNAPSHOT_ORA_TNAME = "ALL_VIRTUAL_LS_SNAPSHOT";
const char *const OB_ALL_VIRTUAL_INDEX_USAGE_INFO_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_INDEX_USAGE_INFO_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SHARED_STORAGE_QUOTA_ORA_TNAME = "ALL_VIRTUAL_SHARED_STORAGE_QUOTA";
const char *const OB_ALL_VIRTUAL_LS_REPLICA_TASK_HISTORY_ORA_TNAME = "ALL_VIRTUAL_LS_REPLICA_TASK_HISTORY";
const char *const OB_ALL_VIRTUAL_SESSION_PS_INFO_ORA_TNAME = "ALL_VIRTUAL_SESSION_PS_INFO";
const char *const OB_ALL_VIRTUAL_TRACEPOINT_INFO_ORA_TNAME = "ALL_VIRTUAL_TRACEPOINT_INFO";
const char *const OB_ALL_VIRTUAL_USER_PROXY_INFO_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_USER_PROXY_INFO_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_USER_PROXY_ROLE_INFO_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_USER_PROXY_ROLE_INFO_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SERVICE_ORA_TNAME = "ALL_VIRTUAL_SERVICE";
const char *const OB_ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_ORA_TNAME = "ALL_VIRTUAL_TENANT_RESOURCE_LIMIT";
const char *const OB_ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_DETAIL_ORA_TNAME = "ALL_VIRTUAL_TENANT_RESOURCE_LIMIT_DETAIL";
const char *const OB_ALL_VIRTUAL_GROUP_IO_STAT_ORA_TNAME = "ALL_VIRTUAL_GROUP_IO_STAT";
const char *const OB_ALL_VIRTUAL_STORAGE_IO_USAGE_ORA_TNAME = "ALL_VIRTUAL_STORAGE_IO_USAGE";
const char *const OB_ALL_VIRTUAL_ZONE_STORAGE_SYS_AGENT_TNAME = "ALL_VIRTUAL_ZONE_STORAGE_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_NIC_INFO_ORA_TNAME = "ALL_VIRTUAL_NIC_INFO";
const char *const OB_ALL_VIRTUAL_QUERY_RESPONSE_TIME_ORA_TNAME = "ALL_VIRTUAL_QUERY_RESPONSE_TIME";
const char *const OB_ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_SPATIAL_REFERENCE_SYSTEMS_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_SPATIAL_REFERENCE_SYSTEMS_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_LOG_TRANSPORT_DEST_STAT_ORA_TNAME = "ALL_VIRTUAL_LOG_TRANSPORT_DEST_STAT";
const char *const OB_ALL_VIRTUAL_SS_LOCAL_CACHE_INFO_ORA_TNAME = "ALL_VIRTUAL_SS_LOCAL_CACHE_INFO";
const char *const OB_ALL_VIRTUAL_SPM_EVO_RESULT_ORA_TNAME = "ALL_VIRTUAL_SPM_EVO_RESULT";
const char *const OB_ALL_VIRTUAL_VECTOR_INDEX_INFO_ORA_TNAME = "ALL_VIRTUAL_VECTOR_INDEX_INFO";
const char *const OB_ALL_VIRTUAL_PKG_TYPE_SYS_AGENT_TNAME = "ALL_VIRTUAL_PKG_TYPE_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_PKG_TYPE_ATTR_SYS_AGENT_TNAME = "ALL_VIRTUAL_PKG_TYPE_ATTR_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_PKG_COLL_TYPE_SYS_AGENT_TNAME = "ALL_VIRTUAL_PKG_COLL_TYPE_SYS_AGENT";
const char *const OB_ALL_VIRTUAL_PKG_TYPE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_PKG_TYPE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_PKG_TYPE_ATTR_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_PKG_TYPE_ATTR_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_PKG_COLL_TYPE_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_PKG_COLL_TYPE_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_WR_SQL_PLAN_ORA_TNAME = "ALL_VIRTUAL_WR_SQL_PLAN";
const char *const OB_ALL_VIRTUAL_RES_MGR_SYSSTAT_ORA_TNAME = "ALL_VIRTUAL_RES_MGR_SYSSTAT";
const char *const OB_ALL_VIRTUAL_FUNCTION_IO_STAT_ORA_TNAME = "ALL_VIRTUAL_FUNCTION_IO_STAT";
const char *const OB_ALL_VIRTUAL_TEMP_FILE_ORA_TNAME = "ALL_VIRTUAL_TEMP_FILE";
const char *const OB_ALL_VIRTUAL_NCOMP_DLL_V2_REAL_AGENT_ORA_TNAME = "ALL_VIRTUAL_NCOMP_DLL_V2_REAL_AGENT";
const char *const OB_ALL_VIRTUAL_TABLET_POINTER_STATUS_ORA_TNAME = "ALL_VIRTUAL_TABLET_POINTER_STATUS";
const char *const OB_ALL_VIRTUAL_CS_REPLICA_TABLET_STATS_ORA_TNAME = "ALL_VIRTUAL_CS_REPLICA_TABLET_STATS";
const char *const OB_GV_OB_PLAN_CACHE_STAT_TNAME = "GV$OB_PLAN_CACHE_STAT";
const char *const OB_GV_OB_PLAN_CACHE_PLAN_STAT_TNAME = "GV$OB_PLAN_CACHE_PLAN_STAT";
const char *const OB_SCHEMATA_TNAME = "SCHEMATA";
const char *const OB_CHARACTER_SETS_TNAME = "CHARACTER_SETS";
const char *const OB_GLOBAL_VARIABLES_TNAME = "GLOBAL_VARIABLES";
const char *const OB_STATISTICS_TNAME = "STATISTICS";
const char *const OB_VIEWS_TNAME = "VIEWS";
const char *const OB_TABLES_TNAME = "TABLES";
const char *const OB_COLLATIONS_TNAME = "COLLATIONS";
const char *const OB_COLLATION_CHARACTER_SET_APPLICABILITY_TNAME = "COLLATION_CHARACTER_SET_APPLICABILITY";
const char *const OB_PROCESSLIST_TNAME = "PROCESSLIST";
const char *const OB_KEY_COLUMN_USAGE_TNAME = "KEY_COLUMN_USAGE";
const char *const OB_ENGINES_TNAME = "ENGINES";
const char *const OB_ROUTINES_TNAME = "ROUTINES";
const char *const OB_PROFILING_TNAME = "PROFILING";
const char *const OB_OPTIMIZER_TRACE_TNAME = "OPTIMIZER_TRACE";
const char *const OB_PLUGINS_TNAME = "PLUGINS";
const char *const OB_INNODB_SYS_COLUMNS_TNAME = "INNODB_SYS_COLUMNS";
const char *const OB_INNODB_FT_BEING_DELETED_TNAME = "INNODB_FT_BEING_DELETED";
const char *const OB_INNODB_FT_CONFIG_TNAME = "INNODB_FT_CONFIG";
const char *const OB_INNODB_FT_DELETED_TNAME = "INNODB_FT_DELETED";
const char *const OB_INNODB_FT_INDEX_CACHE_TNAME = "INNODB_FT_INDEX_CACHE";
const char *const OB_GV_SESSION_EVENT_TNAME = "GV$SESSION_EVENT";
const char *const OB_GV_SESSION_WAIT_TNAME = "GV$SESSION_WAIT";
const char *const OB_GV_SESSION_WAIT_HISTORY_TNAME = "GV$SESSION_WAIT_HISTORY";
const char *const OB_GV_SYSTEM_EVENT_TNAME = "GV$SYSTEM_EVENT";
const char *const OB_GV_SESSTAT_TNAME = "GV$SESSTAT";
const char *const OB_GV_SYSSTAT_TNAME = "GV$SYSSTAT";
const char *const OB_V_STATNAME_TNAME = "V$STATNAME";
const char *const OB_V_EVENT_NAME_TNAME = "V$EVENT_NAME";
const char *const OB_V_SESSION_EVENT_TNAME = "V$SESSION_EVENT";
const char *const OB_V_SESSION_WAIT_TNAME = "V$SESSION_WAIT";
const char *const OB_V_SESSION_WAIT_HISTORY_TNAME = "V$SESSION_WAIT_HISTORY";
const char *const OB_V_SESSTAT_TNAME = "V$SESSTAT";
const char *const OB_V_SYSSTAT_TNAME = "V$SYSSTAT";
const char *const OB_V_SYSTEM_EVENT_TNAME = "V$SYSTEM_EVENT";
const char *const OB_GV_OB_SQL_AUDIT_TNAME = "GV$OB_SQL_AUDIT";
const char *const OB_GV_LATCH_TNAME = "GV$LATCH";
const char *const OB_GV_OB_MEMORY_TNAME = "GV$OB_MEMORY";
const char *const OB_V_OB_MEMORY_TNAME = "V$OB_MEMORY";
const char *const OB_GV_OB_MEMSTORE_TNAME = "GV$OB_MEMSTORE";
const char *const OB_V_OB_MEMSTORE_TNAME = "V$OB_MEMSTORE";
const char *const OB_GV_OB_MEMSTORE_INFO_TNAME = "GV$OB_MEMSTORE_INFO";
const char *const OB_V_OB_MEMSTORE_INFO_TNAME = "V$OB_MEMSTORE_INFO";
const char *const OB_V_OB_PLAN_CACHE_STAT_TNAME = "V$OB_PLAN_CACHE_STAT";
const char *const OB_V_OB_PLAN_CACHE_PLAN_STAT_TNAME = "V$OB_PLAN_CACHE_PLAN_STAT";
const char *const OB_GV_OB_PLAN_CACHE_PLAN_EXPLAIN_TNAME = "GV$OB_PLAN_CACHE_PLAN_EXPLAIN";
const char *const OB_V_OB_PLAN_CACHE_PLAN_EXPLAIN_TNAME = "V$OB_PLAN_CACHE_PLAN_EXPLAIN";
const char *const OB_V_OB_SQL_AUDIT_TNAME = "V$OB_SQL_AUDIT";
const char *const OB_V_LATCH_TNAME = "V$LATCH";
const char *const OB_GV_OB_RPC_OUTGOING_TNAME = "GV$OB_RPC_OUTGOING";
const char *const OB_V_OB_RPC_OUTGOING_TNAME = "V$OB_RPC_OUTGOING";
const char *const OB_GV_OB_RPC_INCOMING_TNAME = "GV$OB_RPC_INCOMING";
const char *const OB_V_OB_RPC_INCOMING_TNAME = "V$OB_RPC_INCOMING";
const char *const OB_GV_SQL_PLAN_MONITOR_TNAME = "GV$SQL_PLAN_MONITOR";
const char *const OB_V_SQL_PLAN_MONITOR_TNAME = "V$SQL_PLAN_MONITOR";
const char *const OB_DBA_RECYCLEBIN_TNAME = "DBA_RECYCLEBIN";
const char *const OB_TIME_ZONE_TNAME = "time_zone";
const char *const OB_TIME_ZONE_NAME_TNAME = "time_zone_name";
const char *const OB_TIME_ZONE_TRANSITION_TNAME = "time_zone_transition";
const char *const OB_TIME_ZONE_TRANSITION_TYPE_TNAME = "time_zone_transition_type";
const char *const OB_GV_SESSION_LONGOPS_TNAME = "GV$SESSION_LONGOPS";
const char *const OB_V_SESSION_LONGOPS_TNAME = "V$SESSION_LONGOPS";
const char *const OB_DBA_OB_SEQUENCE_OBJECTS_TNAME = "DBA_OB_SEQUENCE_OBJECTS";
const char *const OB_COLUMNS_TNAME = "COLUMNS";
const char *const OB_GV_OB_PX_WORKER_STAT_TNAME = "GV$OB_PX_WORKER_STAT";
const char *const OB_V_OB_PX_WORKER_STAT_TNAME = "V$OB_PX_WORKER_STAT";
const char *const OB_GV_OB_PS_STAT_TNAME = "GV$OB_PS_STAT";
const char *const OB_V_OB_PS_STAT_TNAME = "V$OB_PS_STAT";
const char *const OB_GV_OB_PS_ITEM_INFO_TNAME = "GV$OB_PS_ITEM_INFO";
const char *const OB_V_OB_PS_ITEM_INFO_TNAME = "V$OB_PS_ITEM_INFO";
const char *const OB_GV_SQL_WORKAREA_TNAME = "GV$SQL_WORKAREA";
const char *const OB_V_SQL_WORKAREA_TNAME = "V$SQL_WORKAREA";
const char *const OB_GV_SQL_WORKAREA_ACTIVE_TNAME = "GV$SQL_WORKAREA_ACTIVE";
const char *const OB_V_SQL_WORKAREA_ACTIVE_TNAME = "V$SQL_WORKAREA_ACTIVE";
const char *const OB_GV_SQL_WORKAREA_HISTOGRAM_TNAME = "GV$SQL_WORKAREA_HISTOGRAM";
const char *const OB_V_SQL_WORKAREA_HISTOGRAM_TNAME = "V$SQL_WORKAREA_HISTOGRAM";
const char *const OB_GV_OB_SQL_WORKAREA_MEMORY_INFO_TNAME = "GV$OB_SQL_WORKAREA_MEMORY_INFO";
const char *const OB_V_OB_SQL_WORKAREA_MEMORY_INFO_TNAME = "V$OB_SQL_WORKAREA_MEMORY_INFO";
const char *const OB_GV_OB_PLAN_CACHE_REFERENCE_INFO_TNAME = "GV$OB_PLAN_CACHE_REFERENCE_INFO";
const char *const OB_V_OB_PLAN_CACHE_REFERENCE_INFO_TNAME = "V$OB_PLAN_CACHE_REFERENCE_INFO";
const char *const OB_GV_OB_SSTABLES_TNAME = "GV$OB_SSTABLES";
const char *const OB_V_OB_SSTABLES_TNAME = "V$OB_SSTABLES";
const char *const OB_CDB_OB_RESTORE_PROGRESS_TNAME = "CDB_OB_RESTORE_PROGRESS";
const char *const OB_CDB_OB_RESTORE_HISTORY_TNAME = "CDB_OB_RESTORE_HISTORY";
const char *const OB_GV_OB_SERVER_SCHEMA_INFO_TNAME = "GV$OB_SERVER_SCHEMA_INFO";
const char *const OB_V_OB_SERVER_SCHEMA_INFO_TNAME = "V$OB_SERVER_SCHEMA_INFO";
const char *const OB_V_SQL_MONITOR_STATNAME_TNAME = "V$SQL_MONITOR_STATNAME";
const char *const OB_GV_OB_MERGE_INFO_TNAME = "GV$OB_MERGE_INFO";
const char *const OB_V_OB_MERGE_INFO_TNAME = "V$OB_MERGE_INFO";
const char *const OB_V_OB_ENCRYPTED_TABLES_TNAME = "V$OB_ENCRYPTED_TABLES";
const char *const OB_V_ENCRYPTED_TABLESPACES_TNAME = "V$ENCRYPTED_TABLESPACES";
const char *const OB_CDB_OB_ARCHIVELOG_PIECE_FILES_TNAME = "CDB_OB_ARCHIVELOG_PIECE_FILES";
const char *const OB_CDB_OB_BACKUP_SET_FILES_TNAME = "CDB_OB_BACKUP_SET_FILES";
const char *const OB_CONNECTION_CONTROL_FAILED_LOGIN_ATTEMPTS_TNAME = "CONNECTION_CONTROL_FAILED_LOGIN_ATTEMPTS";
const char *const OB_GV_OB_TENANT_MEMORY_TNAME = "GV$OB_TENANT_MEMORY";
const char *const OB_V_OB_TENANT_MEMORY_TNAME = "V$OB_TENANT_MEMORY";
const char *const OB_GV_OB_PX_TARGET_MONITOR_TNAME = "GV$OB_PX_TARGET_MONITOR";
const char *const OB_V_OB_PX_TARGET_MONITOR_TNAME = "V$OB_PX_TARGET_MONITOR";
const char *const OB_COLUMN_PRIVILEGES_TNAME = "COLUMN_PRIVILEGES";
const char *const OB_VIEW_TABLE_USAGE_TNAME = "VIEW_TABLE_USAGE";
const char *const OB_CDB_OB_BACKUP_JOBS_TNAME = "CDB_OB_BACKUP_JOBS";
const char *const OB_CDB_OB_BACKUP_JOB_HISTORY_TNAME = "CDB_OB_BACKUP_JOB_HISTORY";
const char *const OB_CDB_OB_BACKUP_TASKS_TNAME = "CDB_OB_BACKUP_TASKS";
const char *const OB_CDB_OB_BACKUP_TASK_HISTORY_TNAME = "CDB_OB_BACKUP_TASK_HISTORY";
const char *const OB_FILES_TNAME = "FILES";
const char *const OB_DBA_OB_TENANTS_TNAME = "DBA_OB_TENANTS";
const char *const OB_DBA_OB_UNITS_TNAME = "DBA_OB_UNITS";
const char *const OB_DBA_OB_UNIT_CONFIGS_TNAME = "DBA_OB_UNIT_CONFIGS";
const char *const OB_DBA_OB_RESOURCE_POOLS_TNAME = "DBA_OB_RESOURCE_POOLS";
const char *const OB_DBA_OB_SERVERS_TNAME = "DBA_OB_SERVERS";
const char *const OB_DBA_OB_ZONES_TNAME = "DBA_OB_ZONES";
const char *const OB_DBA_OB_ROOTSERVICE_EVENT_HISTORY_TNAME = "DBA_OB_ROOTSERVICE_EVENT_HISTORY";
const char *const OB_DBA_OB_TENANT_JOBS_TNAME = "DBA_OB_TENANT_JOBS";
const char *const OB_DBA_OB_UNIT_JOBS_TNAME = "DBA_OB_UNIT_JOBS";
const char *const OB_DBA_OB_SERVER_JOBS_TNAME = "DBA_OB_SERVER_JOBS";
const char *const OB_DBA_OB_LS_LOCATIONS_TNAME = "DBA_OB_LS_LOCATIONS";
const char *const OB_CDB_OB_LS_LOCATIONS_TNAME = "CDB_OB_LS_LOCATIONS";
const char *const OB_DBA_OB_TABLET_TO_LS_TNAME = "DBA_OB_TABLET_TO_LS";
const char *const OB_CDB_OB_TABLET_TO_LS_TNAME = "CDB_OB_TABLET_TO_LS";
const char *const OB_DBA_OB_TABLET_REPLICAS_TNAME = "DBA_OB_TABLET_REPLICAS";
const char *const OB_CDB_OB_TABLET_REPLICAS_TNAME = "CDB_OB_TABLET_REPLICAS";
const char *const OB_DBA_OB_TABLEGROUPS_TNAME = "DBA_OB_TABLEGROUPS";
const char *const OB_CDB_OB_TABLEGROUPS_TNAME = "CDB_OB_TABLEGROUPS";
const char *const OB_DBA_OB_TABLEGROUP_PARTITIONS_TNAME = "DBA_OB_TABLEGROUP_PARTITIONS";
const char *const OB_CDB_OB_TABLEGROUP_PARTITIONS_TNAME = "CDB_OB_TABLEGROUP_PARTITIONS";
const char *const OB_DBA_OB_TABLEGROUP_SUBPARTITIONS_TNAME = "DBA_OB_TABLEGROUP_SUBPARTITIONS";
const char *const OB_CDB_OB_TABLEGROUP_SUBPARTITIONS_TNAME = "CDB_OB_TABLEGROUP_SUBPARTITIONS";
const char *const OB_DBA_OB_DATABASES_TNAME = "DBA_OB_DATABASES";
const char *const OB_CDB_OB_DATABASES_TNAME = "CDB_OB_DATABASES";
const char *const OB_DBA_OB_TABLEGROUP_TABLES_TNAME = "DBA_OB_TABLEGROUP_TABLES";
const char *const OB_CDB_OB_TABLEGROUP_TABLES_TNAME = "CDB_OB_TABLEGROUP_TABLES";
const char *const OB_DBA_OB_ZONE_MAJOR_COMPACTION_TNAME = "DBA_OB_ZONE_MAJOR_COMPACTION";
const char *const OB_CDB_OB_ZONE_MAJOR_COMPACTION_TNAME = "CDB_OB_ZONE_MAJOR_COMPACTION";
const char *const OB_DBA_OB_MAJOR_COMPACTION_TNAME = "DBA_OB_MAJOR_COMPACTION";
const char *const OB_CDB_OB_MAJOR_COMPACTION_TNAME = "CDB_OB_MAJOR_COMPACTION";
const char *const OB_CDB_OBJECTS_TNAME = "CDB_OBJECTS";
const char *const OB_CDB_TABLES_TNAME = "CDB_TABLES";
const char *const OB_CDB_TAB_COLS_V_TNAME = "CDB_TAB_COLS_V$";
const char *const OB_CDB_TAB_COLS_TNAME = "CDB_TAB_COLS";
const char *const OB_CDB_INDEXES_TNAME = "CDB_INDEXES";
const char *const OB_CDB_IND_COLUMNS_TNAME = "CDB_IND_COLUMNS";
const char *const OB_CDB_PART_TABLES_TNAME = "CDB_PART_TABLES";
const char *const OB_CDB_TAB_PARTITIONS_TNAME = "CDB_TAB_PARTITIONS";
const char *const OB_CDB_TAB_SUBPARTITIONS_TNAME = "CDB_TAB_SUBPARTITIONS";
const char *const OB_CDB_SUBPARTITION_TEMPLATES_TNAME = "CDB_SUBPARTITION_TEMPLATES";
const char *const OB_CDB_PART_KEY_COLUMNS_TNAME = "CDB_PART_KEY_COLUMNS";
const char *const OB_CDB_SUBPART_KEY_COLUMNS_TNAME = "CDB_SUBPART_KEY_COLUMNS";
const char *const OB_CDB_PART_INDEXES_TNAME = "CDB_PART_INDEXES";
const char *const OB_CDB_IND_PARTITIONS_TNAME = "CDB_IND_PARTITIONS";
const char *const OB_CDB_IND_SUBPARTITIONS_TNAME = "CDB_IND_SUBPARTITIONS";
const char *const OB_CDB_TAB_COL_STATISTICS_TNAME = "CDB_TAB_COL_STATISTICS";
const char *const OB_DBA_OBJECTS_TNAME = "DBA_OBJECTS";
const char *const OB_DBA_PART_TABLES_TNAME = "DBA_PART_TABLES";
const char *const OB_DBA_PART_KEY_COLUMNS_TNAME = "DBA_PART_KEY_COLUMNS";
const char *const OB_DBA_SUBPART_KEY_COLUMNS_TNAME = "DBA_SUBPART_KEY_COLUMNS";
const char *const OB_DBA_TAB_PARTITIONS_TNAME = "DBA_TAB_PARTITIONS";
const char *const OB_DBA_TAB_SUBPARTITIONS_TNAME = "DBA_TAB_SUBPARTITIONS";
const char *const OB_DBA_SUBPARTITION_TEMPLATES_TNAME = "DBA_SUBPARTITION_TEMPLATES";
const char *const OB_DBA_PART_INDEXES_TNAME = "DBA_PART_INDEXES";
const char *const OB_DBA_IND_PARTITIONS_TNAME = "DBA_IND_PARTITIONS";
const char *const OB_DBA_IND_SUBPARTITIONS_TNAME = "DBA_IND_SUBPARTITIONS";
const char *const OB_GV_OB_SERVERS_TNAME = "GV$OB_SERVERS";
const char *const OB_V_OB_SERVERS_TNAME = "V$OB_SERVERS";
const char *const OB_GV_OB_UNITS_TNAME = "GV$OB_UNITS";
const char *const OB_V_OB_UNITS_TNAME = "V$OB_UNITS";
const char *const OB_GV_OB_PARAMETERS_TNAME = "GV$OB_PARAMETERS";
const char *const OB_V_OB_PARAMETERS_TNAME = "V$OB_PARAMETERS";
const char *const OB_GV_OB_PROCESSLIST_TNAME = "GV$OB_PROCESSLIST";
const char *const OB_V_OB_PROCESSLIST_TNAME = "V$OB_PROCESSLIST";
const char *const OB_GV_OB_KVCACHE_TNAME = "GV$OB_KVCACHE";
const char *const OB_V_OB_KVCACHE_TNAME = "V$OB_KVCACHE";
const char *const OB_GV_OB_TRANSACTION_PARTICIPANTS_TNAME = "GV$OB_TRANSACTION_PARTICIPANTS";
const char *const OB_V_OB_TRANSACTION_PARTICIPANTS_TNAME = "V$OB_TRANSACTION_PARTICIPANTS";
const char *const OB_GV_OB_COMPACTION_PROGRESS_TNAME = "GV$OB_COMPACTION_PROGRESS";
const char *const OB_V_OB_COMPACTION_PROGRESS_TNAME = "V$OB_COMPACTION_PROGRESS";
const char *const OB_GV_OB_TABLET_COMPACTION_PROGRESS_TNAME = "GV$OB_TABLET_COMPACTION_PROGRESS";
const char *const OB_V_OB_TABLET_COMPACTION_PROGRESS_TNAME = "V$OB_TABLET_COMPACTION_PROGRESS";
const char *const OB_GV_OB_TABLET_COMPACTION_HISTORY_TNAME = "GV$OB_TABLET_COMPACTION_HISTORY";
const char *const OB_V_OB_TABLET_COMPACTION_HISTORY_TNAME = "V$OB_TABLET_COMPACTION_HISTORY";
const char *const OB_GV_OB_COMPACTION_DIAGNOSE_INFO_TNAME = "GV$OB_COMPACTION_DIAGNOSE_INFO";
const char *const OB_V_OB_COMPACTION_DIAGNOSE_INFO_TNAME = "V$OB_COMPACTION_DIAGNOSE_INFO";
const char *const OB_GV_OB_COMPACTION_SUGGESTIONS_TNAME = "GV$OB_COMPACTION_SUGGESTIONS";
const char *const OB_V_OB_COMPACTION_SUGGESTIONS_TNAME = "V$OB_COMPACTION_SUGGESTIONS";
const char *const OB_GV_OB_DTL_INTERM_RESULT_MONITOR_TNAME = "GV$OB_DTL_INTERM_RESULT_MONITOR";
const char *const OB_V_OB_DTL_INTERM_RESULT_MONITOR_TNAME = "V$OB_DTL_INTERM_RESULT_MONITOR";
const char *const OB_GV_OB_IO_CALIBRATION_STATUS_TNAME = "GV$OB_IO_CALIBRATION_STATUS";
const char *const OB_V_OB_IO_CALIBRATION_STATUS_TNAME = "V$OB_IO_CALIBRATION_STATUS";
const char *const OB_GV_OB_IO_BENCHMARK_TNAME = "GV$OB_IO_BENCHMARK";
const char *const OB_V_OB_IO_BENCHMARK_TNAME = "V$OB_IO_BENCHMARK";
const char *const OB_CDB_OB_BACKUP_DELETE_JOBS_TNAME = "CDB_OB_BACKUP_DELETE_JOBS";
const char *const OB_CDB_OB_BACKUP_DELETE_JOB_HISTORY_TNAME = "CDB_OB_BACKUP_DELETE_JOB_HISTORY";
const char *const OB_CDB_OB_BACKUP_DELETE_TASKS_TNAME = "CDB_OB_BACKUP_DELETE_TASKS";
const char *const OB_CDB_OB_BACKUP_DELETE_TASK_HISTORY_TNAME = "CDB_OB_BACKUP_DELETE_TASK_HISTORY";
const char *const OB_CDB_OB_BACKUP_DELETE_POLICY_TNAME = "CDB_OB_BACKUP_DELETE_POLICY";
const char *const OB_CDB_OB_BACKUP_STORAGE_INFO_TNAME = "CDB_OB_BACKUP_STORAGE_INFO";
const char *const OB_DBA_TAB_STATISTICS_TNAME = "DBA_TAB_STATISTICS";
const char *const OB_DBA_TAB_COL_STATISTICS_TNAME = "DBA_TAB_COL_STATISTICS";
const char *const OB_DBA_PART_COL_STATISTICS_TNAME = "DBA_PART_COL_STATISTICS";
const char *const OB_DBA_SUBPART_COL_STATISTICS_TNAME = "DBA_SUBPART_COL_STATISTICS";
const char *const OB_DBA_TAB_HISTOGRAMS_TNAME = "DBA_TAB_HISTOGRAMS";
const char *const OB_DBA_PART_HISTOGRAMS_TNAME = "DBA_PART_HISTOGRAMS";
const char *const OB_DBA_SUBPART_HISTOGRAMS_TNAME = "DBA_SUBPART_HISTOGRAMS";
const char *const OB_DBA_TAB_STATS_HISTORY_TNAME = "DBA_TAB_STATS_HISTORY";
const char *const OB_DBA_IND_STATISTICS_TNAME = "DBA_IND_STATISTICS";
const char *const OB_DBA_OB_BACKUP_JOBS_TNAME = "DBA_OB_BACKUP_JOBS";
const char *const OB_DBA_OB_BACKUP_JOB_HISTORY_TNAME = "DBA_OB_BACKUP_JOB_HISTORY";
const char *const OB_DBA_OB_BACKUP_TASKS_TNAME = "DBA_OB_BACKUP_TASKS";
const char *const OB_DBA_OB_BACKUP_TASK_HISTORY_TNAME = "DBA_OB_BACKUP_TASK_HISTORY";
const char *const OB_DBA_OB_BACKUP_SET_FILES_TNAME = "DBA_OB_BACKUP_SET_FILES";
const char *const OB_DBA_SQL_PLAN_BASELINES_TNAME = "DBA_SQL_PLAN_BASELINES";
const char *const OB_DBA_SQL_MANAGEMENT_CONFIG_TNAME = "DBA_SQL_MANAGEMENT_CONFIG";
const char *const OB_GV_ACTIVE_SESSION_HISTORY_TNAME = "GV$ACTIVE_SESSION_HISTORY";
const char *const OB_V_ACTIVE_SESSION_HISTORY_TNAME = "V$ACTIVE_SESSION_HISTORY";
const char *const OB_GV_DML_STATS_TNAME = "GV$DML_STATS";
const char *const OB_V_DML_STATS_TNAME = "V$DML_STATS";
const char *const OB_DBA_TAB_MODIFICATIONS_TNAME = "DBA_TAB_MODIFICATIONS";
const char *const OB_DBA_SCHEDULER_JOBS_TNAME = "DBA_SCHEDULER_JOBS";
const char *const OB_DBA_OB_OUTLINE_CONCURRENT_HISTORY_TNAME = "DBA_OB_OUTLINE_CONCURRENT_HISTORY";
const char *const OB_CDB_OB_BACKUP_STORAGE_INFO_HISTORY_TNAME = "CDB_OB_BACKUP_STORAGE_INFO_HISTORY";
const char *const OB_DBA_OB_BACKUP_STORAGE_INFO_TNAME = "DBA_OB_BACKUP_STORAGE_INFO";
const char *const OB_DBA_OB_BACKUP_STORAGE_INFO_HISTORY_TNAME = "DBA_OB_BACKUP_STORAGE_INFO_HISTORY";
const char *const OB_DBA_OB_BACKUP_DELETE_POLICY_TNAME = "DBA_OB_BACKUP_DELETE_POLICY";
const char *const OB_DBA_OB_BACKUP_DELETE_JOBS_TNAME = "DBA_OB_BACKUP_DELETE_JOBS";
const char *const OB_DBA_OB_BACKUP_DELETE_JOB_HISTORY_TNAME = "DBA_OB_BACKUP_DELETE_JOB_HISTORY";
const char *const OB_DBA_OB_BACKUP_DELETE_TASKS_TNAME = "DBA_OB_BACKUP_DELETE_TASKS";
const char *const OB_DBA_OB_BACKUP_DELETE_TASK_HISTORY_TNAME = "DBA_OB_BACKUP_DELETE_TASK_HISTORY";
const char *const OB_DBA_OB_OUTLINES_TNAME = "DBA_OB_OUTLINES";
const char *const OB_DBA_OB_CONCURRENT_LIMIT_SQL_TNAME = "DBA_OB_CONCURRENT_LIMIT_SQL";
const char *const OB_DBA_OB_RESTORE_PROGRESS_TNAME = "DBA_OB_RESTORE_PROGRESS";
const char *const OB_DBA_OB_RESTORE_HISTORY_TNAME = "DBA_OB_RESTORE_HISTORY";
const char *const OB_DBA_OB_ARCHIVE_DEST_TNAME = "DBA_OB_ARCHIVE_DEST";
const char *const OB_DBA_OB_ARCHIVELOG_TNAME = "DBA_OB_ARCHIVELOG";
const char *const OB_DBA_OB_ARCHIVELOG_SUMMARY_TNAME = "DBA_OB_ARCHIVELOG_SUMMARY";
const char *const OB_DBA_OB_ARCHIVELOG_PIECE_FILES_TNAME = "DBA_OB_ARCHIVELOG_PIECE_FILES";
const char *const OB_DBA_OB_BACKUP_PARAMETER_TNAME = "DBA_OB_BACKUP_PARAMETER";
const char *const OB_CDB_OB_ARCHIVE_DEST_TNAME = "CDB_OB_ARCHIVE_DEST";
const char *const OB_CDB_OB_ARCHIVELOG_TNAME = "CDB_OB_ARCHIVELOG";
const char *const OB_CDB_OB_ARCHIVELOG_SUMMARY_TNAME = "CDB_OB_ARCHIVELOG_SUMMARY";
const char *const OB_CDB_OB_BACKUP_PARAMETER_TNAME = "CDB_OB_BACKUP_PARAMETER";
const char *const OB_DBA_OB_DEADLOCK_EVENT_HISTORY_TNAME = "DBA_OB_DEADLOCK_EVENT_HISTORY";
const char *const OB_CDB_OB_DEADLOCK_EVENT_HISTORY_TNAME = "CDB_OB_DEADLOCK_EVENT_HISTORY";
const char *const OB_CDB_OB_SYS_VARIABLES_TNAME = "CDB_OB_SYS_VARIABLES";
const char *const OB_DBA_OB_KV_TTL_TASKS_TNAME = "DBA_OB_KV_TTL_TASKS";
const char *const OB_DBA_OB_KV_TTL_TASK_HISTORY_TNAME = "DBA_OB_KV_TTL_TASK_HISTORY";
const char *const OB_GV_OB_LOG_STAT_TNAME = "GV$OB_LOG_STAT";
const char *const OB_V_OB_LOG_STAT_TNAME = "V$OB_LOG_STAT";
const char *const OB_ST_GEOMETRY_COLUMNS_TNAME = "ST_GEOMETRY_COLUMNS";
const char *const OB_ST_SPATIAL_REFERENCE_SYSTEMS_TNAME = "ST_SPATIAL_REFERENCE_SYSTEMS";
const char *const OB_QUERY_RESPONSE_TIME_TNAME = "QUERY_RESPONSE_TIME";
const char *const OB_CDB_OB_KV_TTL_TASKS_TNAME = "CDB_OB_KV_TTL_TASKS";
const char *const OB_CDB_OB_KV_TTL_TASK_HISTORY_TNAME = "CDB_OB_KV_TTL_TASK_HISTORY";
const char *const OB_DBA_RSRC_PLANS_TNAME = "DBA_RSRC_PLANS";
const char *const OB_DBA_RSRC_PLAN_DIRECTIVES_TNAME = "DBA_RSRC_PLAN_DIRECTIVES";
const char *const OB_DBA_RSRC_GROUP_MAPPINGS_TNAME = "DBA_RSRC_GROUP_MAPPINGS";
const char *const OB_DBA_RSRC_CONSUMER_GROUPS_TNAME = "DBA_RSRC_CONSUMER_GROUPS";
const char *const OB_V_RSRC_PLAN_TNAME = "V$RSRC_PLAN";
const char *const OB_CDB_OB_COLUMN_CHECKSUM_ERROR_INFO_TNAME = "CDB_OB_COLUMN_CHECKSUM_ERROR_INFO";
const char *const OB_CDB_OB_TABLET_CHECKSUM_ERROR_INFO_TNAME = "CDB_OB_TABLET_CHECKSUM_ERROR_INFO";
const char *const OB_DBA_OB_LS_TNAME = "DBA_OB_LS";
const char *const OB_CDB_OB_LS_TNAME = "CDB_OB_LS";
const char *const OB_DBA_OB_TABLE_LOCATIONS_TNAME = "DBA_OB_TABLE_LOCATIONS";
const char *const OB_CDB_OB_TABLE_LOCATIONS_TNAME = "CDB_OB_TABLE_LOCATIONS";
const char *const OB_DBA_OB_SERVER_EVENT_HISTORY_TNAME = "DBA_OB_SERVER_EVENT_HISTORY";
const char *const OB_CDB_OB_FREEZE_INFO_TNAME = "CDB_OB_FREEZE_INFO";
const char *const OB_DBA_OB_FREEZE_INFO_TNAME = "DBA_OB_FREEZE_INFO";
const char *const OB_DBA_OB_LS_REPLICA_TASKS_TNAME = "DBA_OB_LS_REPLICA_TASKS";
const char *const OB_CDB_OB_LS_REPLICA_TASKS_TNAME = "CDB_OB_LS_REPLICA_TASKS";
const char *const OB_V_OB_LS_REPLICA_TASK_PLAN_TNAME = "V$OB_LS_REPLICA_TASK_PLAN";
const char *const OB_DBA_OB_AUTO_INCREMENT_TNAME = "DBA_OB_AUTO_INCREMENT";
const char *const OB_CDB_OB_AUTO_INCREMENT_TNAME = "CDB_OB_AUTO_INCREMENT";
const char *const OB_DBA_SEQUENCES_TNAME = "DBA_SEQUENCES";
const char *const OB_DBA_SCHEDULER_WINDOWS_TNAME = "DBA_SCHEDULER_WINDOWS";
const char *const OB_DBA_OB_USERS_TNAME = "DBA_OB_USERS";
const char *const OB_CDB_OB_USERS_TNAME = "CDB_OB_USERS";
const char *const OB_DBA_OB_DATABASE_PRIVILEGE_TNAME = "DBA_OB_DATABASE_PRIVILEGE";
const char *const OB_CDB_OB_DATABASE_PRIVILEGE_TNAME = "CDB_OB_DATABASE_PRIVILEGE";
const char *const OB_DBA_OB_USER_DEFINED_RULES_TNAME = "DBA_OB_USER_DEFINED_RULES";
const char *const OB_GV_OB_SQL_PLAN_TNAME = "GV$OB_SQL_PLAN";
const char *const OB_V_OB_SQL_PLAN_TNAME = "V$OB_SQL_PLAN";
const char *const OB_DBA_OB_CLUSTER_EVENT_HISTORY_TNAME = "DBA_OB_CLUSTER_EVENT_HISTORY";
const char *const OB_PARAMETERS_TNAME = "PARAMETERS";
const char *const OB_TABLE_PRIVILEGES_TNAME = "TABLE_PRIVILEGES";
const char *const OB_USER_PRIVILEGES_TNAME = "USER_PRIVILEGES";
const char *const OB_SCHEMA_PRIVILEGES_TNAME = "SCHEMA_PRIVILEGES";
const char *const OB_CHECK_CONSTRAINTS_TNAME = "CHECK_CONSTRAINTS";
const char *const OB_REFERENTIAL_CONSTRAINTS_TNAME = "REFERENTIAL_CONSTRAINTS";
const char *const OB_TABLE_CONSTRAINTS_TNAME = "TABLE_CONSTRAINTS";
const char *const OB_GV_OB_TRANSACTION_SCHEDULERS_TNAME = "GV$OB_TRANSACTION_SCHEDULERS";
const char *const OB_V_OB_TRANSACTION_SCHEDULERS_TNAME = "V$OB_TRANSACTION_SCHEDULERS";
const char *const OB_TRIGGERS_TNAME = "TRIGGERS";
const char *const OB_PARTITIONS_TNAME = "PARTITIONS";
const char *const OB_DBA_OB_ARBITRATION_SERVICE_TNAME = "DBA_OB_ARBITRATION_SERVICE";
const char *const OB_CDB_OB_LS_ARB_REPLICA_TASKS_TNAME = "CDB_OB_LS_ARB_REPLICA_TASKS";
const char *const OB_DBA_OB_LS_ARB_REPLICA_TASKS_TNAME = "DBA_OB_LS_ARB_REPLICA_TASKS";
const char *const OB_CDB_OB_LS_ARB_REPLICA_TASK_HISTORY_TNAME = "CDB_OB_LS_ARB_REPLICA_TASK_HISTORY";
const char *const OB_DBA_OB_LS_ARB_REPLICA_TASK_HISTORY_TNAME = "DBA_OB_LS_ARB_REPLICA_TASK_HISTORY";
const char *const OB_V_OB_ARCHIVE_DEST_STATUS_TNAME = "V$OB_ARCHIVE_DEST_STATUS";
const char *const OB_DBA_OB_LS_LOG_ARCHIVE_PROGRESS_TNAME = "DBA_OB_LS_LOG_ARCHIVE_PROGRESS";
const char *const OB_CDB_OB_LS_LOG_ARCHIVE_PROGRESS_TNAME = "CDB_OB_LS_LOG_ARCHIVE_PROGRESS";
const char *const OB_DBA_OB_RSRC_IO_DIRECTIVES_TNAME = "DBA_OB_RSRC_IO_DIRECTIVES";
const char *const OB_GV_OB_TABLET_STATS_TNAME = "GV$OB_TABLET_STATS";
const char *const OB_V_OB_TABLET_STATS_TNAME = "V$OB_TABLET_STATS";
const char *const OB_DBA_OB_ACCESS_POINT_TNAME = "DBA_OB_ACCESS_POINT";
const char *const OB_CDB_OB_ACCESS_POINT_TNAME = "CDB_OB_ACCESS_POINT";
const char *const OB_CDB_OB_DATA_DICTIONARY_IN_LOG_TNAME = "CDB_OB_DATA_DICTIONARY_IN_LOG";
const char *const OB_DBA_OB_DATA_DICTIONARY_IN_LOG_TNAME = "DBA_OB_DATA_DICTIONARY_IN_LOG";
const char *const OB_GV_OB_OPT_STAT_GATHER_MONITOR_TNAME = "GV$OB_OPT_STAT_GATHER_MONITOR";
const char *const OB_V_OB_OPT_STAT_GATHER_MONITOR_TNAME = "V$OB_OPT_STAT_GATHER_MONITOR";
const char *const OB_DBA_OB_TASK_OPT_STAT_GATHER_HISTORY_TNAME = "DBA_OB_TASK_OPT_STAT_GATHER_HISTORY";
const char *const OB_DBA_OB_TABLE_OPT_STAT_GATHER_HISTORY_TNAME = "DBA_OB_TABLE_OPT_STAT_GATHER_HISTORY";
const char *const OB_GV_OB_THREAD_TNAME = "GV$OB_THREAD";
const char *const OB_V_OB_THREAD_TNAME = "V$OB_THREAD";
const char *const OB_GV_OB_ARBITRATION_MEMBER_INFO_TNAME = "GV$OB_ARBITRATION_MEMBER_INFO";
const char *const OB_V_OB_ARBITRATION_MEMBER_INFO_TNAME = "V$OB_ARBITRATION_MEMBER_INFO";
const char *const OB_DBA_OB_ZONE_STORAGE_TNAME = "DBA_OB_ZONE_STORAGE";
const char *const OB_GV_OB_SERVER_STORAGE_TNAME = "GV$OB_SERVER_STORAGE";
const char *const OB_V_OB_SERVER_STORAGE_TNAME = "V$OB_SERVER_STORAGE";
const char *const OB_GV_OB_ARBITRATION_SERVICE_STATUS_TNAME = "GV$OB_ARBITRATION_SERVICE_STATUS";
const char *const OB_V_OB_ARBITRATION_SERVICE_STATUS_TNAME = "V$OB_ARBITRATION_SERVICE_STATUS";
const char *const OB_DBA_WR_ACTIVE_SESSION_HISTORY_TNAME = "DBA_WR_ACTIVE_SESSION_HISTORY";
const char *const OB_CDB_WR_ACTIVE_SESSION_HISTORY_TNAME = "CDB_WR_ACTIVE_SESSION_HISTORY";
const char *const OB_DBA_WR_SNAPSHOT_TNAME = "DBA_WR_SNAPSHOT";
const char *const OB_CDB_WR_SNAPSHOT_TNAME = "CDB_WR_SNAPSHOT";
const char *const OB_DBA_WR_STATNAME_TNAME = "DBA_WR_STATNAME";
const char *const OB_CDB_WR_STATNAME_TNAME = "CDB_WR_STATNAME";
const char *const OB_DBA_WR_SYSSTAT_TNAME = "DBA_WR_SYSSTAT";
const char *const OB_CDB_WR_SYSSTAT_TNAME = "CDB_WR_SYSSTAT";
const char *const OB_GV_OB_KV_CONNECTIONS_TNAME = "GV$OB_KV_CONNECTIONS";
const char *const OB_V_OB_KV_CONNECTIONS_TNAME = "V$OB_KV_CONNECTIONS";
const char *const OB_GV_OB_LOCKS_TNAME = "GV$OB_LOCKS";
const char *const OB_V_OB_LOCKS_TNAME = "V$OB_LOCKS";
const char *const OB_CDB_OB_LOG_RESTORE_SOURCE_TNAME = "CDB_OB_LOG_RESTORE_SOURCE";
const char *const OB_DBA_OB_LOG_RESTORE_SOURCE_TNAME = "DBA_OB_LOG_RESTORE_SOURCE";
const char *const OB_V_OB_TIMESTAMP_SERVICE_TNAME = "V$OB_TIMESTAMP_SERVICE";
const char *const OB_DBA_OB_BALANCE_JOBS_TNAME = "DBA_OB_BALANCE_JOBS";
const char *const OB_CDB_OB_BALANCE_JOBS_TNAME = "CDB_OB_BALANCE_JOBS";
const char *const OB_DBA_OB_BALANCE_JOB_HISTORY_TNAME = "DBA_OB_BALANCE_JOB_HISTORY";
const char *const OB_CDB_OB_BALANCE_JOB_HISTORY_TNAME = "CDB_OB_BALANCE_JOB_HISTORY";
const char *const OB_DBA_OB_BALANCE_TASKS_TNAME = "DBA_OB_BALANCE_TASKS";
const char *const OB_CDB_OB_BALANCE_TASKS_TNAME = "CDB_OB_BALANCE_TASKS";
const char *const OB_DBA_OB_BALANCE_TASK_HISTORY_TNAME = "DBA_OB_BALANCE_TASK_HISTORY";
const char *const OB_CDB_OB_BALANCE_TASK_HISTORY_TNAME = "CDB_OB_BALANCE_TASK_HISTORY";
const char *const OB_DBA_OB_TRANSFER_TASKS_TNAME = "DBA_OB_TRANSFER_TASKS";
const char *const OB_CDB_OB_TRANSFER_TASKS_TNAME = "CDB_OB_TRANSFER_TASKS";
const char *const OB_DBA_OB_TRANSFER_TASK_HISTORY_TNAME = "DBA_OB_TRANSFER_TASK_HISTORY";
const char *const OB_CDB_OB_TRANSFER_TASK_HISTORY_TNAME = "CDB_OB_TRANSFER_TASK_HISTORY";
const char *const OB_DBA_OB_EXTERNAL_TABLE_FILES_TNAME = "DBA_OB_EXTERNAL_TABLE_FILES";
const char *const OB_ALL_OB_EXTERNAL_TABLE_FILES_TNAME = "ALL_OB_EXTERNAL_TABLE_FILES";
const char *const OB_GV_OB_PX_P2P_DATAHUB_TNAME = "GV$OB_PX_P2P_DATAHUB";
const char *const OB_V_OB_PX_P2P_DATAHUB_TNAME = "V$OB_PX_P2P_DATAHUB";
const char *const OB_GV_SQL_JOIN_FILTER_TNAME = "GV$SQL_JOIN_FILTER";
const char *const OB_V_SQL_JOIN_FILTER_TNAME = "V$SQL_JOIN_FILTER";
const char *const OB_DBA_OB_TABLE_STAT_STALE_INFO_TNAME = "DBA_OB_TABLE_STAT_STALE_INFO";
const char *const OB_V_OB_LS_LOG_RESTORE_STATUS_TNAME = "V$OB_LS_LOG_RESTORE_STATUS";
const char *const OB_CDB_OB_EXTERNAL_TABLE_FILES_TNAME = "CDB_OB_EXTERNAL_TABLE_FILES";
const char *const OB_DBA_DB_LINKS_TNAME = "DBA_DB_LINKS";
const char *const OB_DBA_WR_CONTROL_TNAME = "DBA_WR_CONTROL";
const char *const OB_CDB_WR_CONTROL_TNAME = "CDB_WR_CONTROL";
const char *const OB_DBA_OB_LS_HISTORY_TNAME = "DBA_OB_LS_HISTORY";
const char *const OB_CDB_OB_LS_HISTORY_TNAME = "CDB_OB_LS_HISTORY";
const char *const OB_DBA_OB_TENANT_EVENT_HISTORY_TNAME = "DBA_OB_TENANT_EVENT_HISTORY";
const char *const OB_CDB_OB_TENANT_EVENT_HISTORY_TNAME = "CDB_OB_TENANT_EVENT_HISTORY";
const char *const OB_GV_OB_FLT_TRACE_CONFIG_TNAME = "GV$OB_FLT_TRACE_CONFIG";
const char *const OB_GV_OB_SESSION_TNAME = "GV$OB_SESSION";
const char *const OB_V_OB_SESSION_TNAME = "V$OB_SESSION";
const char *const OB_GV_OB_PL_CACHE_OBJECT_TNAME = "GV$OB_PL_CACHE_OBJECT";
const char *const OB_V_OB_PL_CACHE_OBJECT_TNAME = "V$OB_PL_CACHE_OBJECT";
const char *const OB_CDB_OB_RECOVER_TABLE_JOBS_TNAME = "CDB_OB_RECOVER_TABLE_JOBS";
const char *const OB_DBA_OB_RECOVER_TABLE_JOBS_TNAME = "DBA_OB_RECOVER_TABLE_JOBS";
const char *const OB_CDB_OB_RECOVER_TABLE_JOB_HISTORY_TNAME = "CDB_OB_RECOVER_TABLE_JOB_HISTORY";
const char *const OB_DBA_OB_RECOVER_TABLE_JOB_HISTORY_TNAME = "DBA_OB_RECOVER_TABLE_JOB_HISTORY";
const char *const OB_CDB_OB_IMPORT_TABLE_JOBS_TNAME = "CDB_OB_IMPORT_TABLE_JOBS";
const char *const OB_DBA_OB_IMPORT_TABLE_JOBS_TNAME = "DBA_OB_IMPORT_TABLE_JOBS";
const char *const OB_CDB_OB_IMPORT_TABLE_JOB_HISTORY_TNAME = "CDB_OB_IMPORT_TABLE_JOB_HISTORY";
const char *const OB_DBA_OB_IMPORT_TABLE_JOB_HISTORY_TNAME = "DBA_OB_IMPORT_TABLE_JOB_HISTORY";
const char *const OB_CDB_OB_IMPORT_TABLE_TASKS_TNAME = "CDB_OB_IMPORT_TABLE_TASKS";
const char *const OB_DBA_OB_IMPORT_TABLE_TASKS_TNAME = "DBA_OB_IMPORT_TABLE_TASKS";
const char *const OB_CDB_OB_IMPORT_TABLE_TASK_HISTORY_TNAME = "CDB_OB_IMPORT_TABLE_TASK_HISTORY";
const char *const OB_DBA_OB_IMPORT_TABLE_TASK_HISTORY_TNAME = "DBA_OB_IMPORT_TABLE_TASK_HISTORY";
const char *const OB_GV_OB_TENANT_RUNTIME_INFO_TNAME = "GV$OB_TENANT_RUNTIME_INFO";
const char *const OB_V_OB_TENANT_RUNTIME_INFO_TNAME = "V$OB_TENANT_RUNTIME_INFO";
const char *const OB_GV_OB_CGROUP_CONFIG_TNAME = "GV$OB_CGROUP_CONFIG";
const char *const OB_V_OB_CGROUP_CONFIG_TNAME = "V$OB_CGROUP_CONFIG";
const char *const OB_DBA_WR_SYSTEM_EVENT_TNAME = "DBA_WR_SYSTEM_EVENT";
const char *const OB_CDB_WR_SYSTEM_EVENT_TNAME = "CDB_WR_SYSTEM_EVENT";
const char *const OB_DBA_WR_EVENT_NAME_TNAME = "DBA_WR_EVENT_NAME";
const char *const OB_CDB_WR_EVENT_NAME_TNAME = "CDB_WR_EVENT_NAME";
const char *const OB_DBA_OB_FORMAT_OUTLINES_TNAME = "DBA_OB_FORMAT_OUTLINES";
const char *const OB_PROCS_PRIV_TNAME = "procs_priv";
const char *const OB_GV_OB_SQLSTAT_TNAME = "GV$OB_SQLSTAT";
const char *const OB_V_OB_SQLSTAT_TNAME = "V$OB_SQLSTAT";
const char *const OB_DBA_WR_SQLSTAT_TNAME = "DBA_WR_SQLSTAT";
const char *const OB_CDB_WR_SQLSTAT_TNAME = "CDB_WR_SQLSTAT";
const char *const OB_GV_OB_SESS_TIME_MODEL_TNAME = "GV$OB_SESS_TIME_MODEL";
const char *const OB_V_OB_SESS_TIME_MODEL_TNAME = "V$OB_SESS_TIME_MODEL";
const char *const OB_GV_OB_SYS_TIME_MODEL_TNAME = "GV$OB_SYS_TIME_MODEL";
const char *const OB_V_OB_SYS_TIME_MODEL_TNAME = "V$OB_SYS_TIME_MODEL";
const char *const OB_DBA_WR_SYS_TIME_MODEL_TNAME = "DBA_WR_SYS_TIME_MODEL";
const char *const OB_CDB_WR_SYS_TIME_MODEL_TNAME = "CDB_WR_SYS_TIME_MODEL";
const char *const OB_DBA_OB_AUX_STATISTICS_TNAME = "DBA_OB_AUX_STATISTICS";
const char *const OB_CDB_OB_AUX_STATISTICS_TNAME = "CDB_OB_AUX_STATISTICS";
const char *const OB_DBA_INDEX_USAGE_TNAME = "DBA_INDEX_USAGE";
const char *const OB_DBA_OB_SYS_VARIABLES_TNAME = "DBA_OB_SYS_VARIABLES";
const char *const OB_DBA_OB_TRANSFER_PARTITION_TASKS_TNAME = "DBA_OB_TRANSFER_PARTITION_TASKS";
const char *const OB_CDB_OB_TRANSFER_PARTITION_TASKS_TNAME = "CDB_OB_TRANSFER_PARTITION_TASKS";
const char *const OB_DBA_OB_TRANSFER_PARTITION_TASK_HISTORY_TNAME = "DBA_OB_TRANSFER_PARTITION_TASK_HISTORY";
const char *const OB_CDB_OB_TRANSFER_PARTITION_TASK_HISTORY_TNAME = "CDB_OB_TRANSFER_PARTITION_TASK_HISTORY";
const char *const OB_DBA_WR_SQLTEXT_TNAME = "DBA_WR_SQLTEXT";
const char *const OB_CDB_WR_SQLTEXT_TNAME = "CDB_WR_SQLTEXT";
const char *const OB_GV_OB_ACTIVE_SESSION_HISTORY_TNAME = "GV$OB_ACTIVE_SESSION_HISTORY";
const char *const OB_V_OB_ACTIVE_SESSION_HISTORY_TNAME = "V$OB_ACTIVE_SESSION_HISTORY";
const char *const OB_DBA_OB_TRUSTED_ROOT_CERTIFICATE_TNAME = "DBA_OB_TRUSTED_ROOT_CERTIFICATE";
const char *const OB_DBA_OB_CLONE_PROGRESS_TNAME = "DBA_OB_CLONE_PROGRESS";
const char *const OB_ROLE_EDGES_TNAME = "role_edges";
const char *const OB_DEFAULT_ROLES_TNAME = "default_roles";
const char *const OB_CDB_INDEX_USAGE_TNAME = "CDB_INDEX_USAGE";
const char *const OB_AUDIT_LOG_FILTER_TNAME = "audit_log_filter";
const char *const OB_AUDIT_LOG_USER_TNAME = "audit_log_user";
const char *const OB_COLUMNS_PRIV_TNAME = "columns_priv";
const char *const OB_GV_OB_LS_SNAPSHOTS_TNAME = "GV$OB_LS_SNAPSHOTS";
const char *const OB_V_OB_LS_SNAPSHOTS_TNAME = "V$OB_LS_SNAPSHOTS";
const char *const OB_DBA_OB_CLONE_HISTORY_TNAME = "DBA_OB_CLONE_HISTORY";
const char *const OB_GV_OB_SHARED_STORAGE_QUOTA_TNAME = "GV$OB_SHARED_STORAGE_QUOTA";
const char *const OB_V_OB_SHARED_STORAGE_QUOTA_TNAME = "V$OB_SHARED_STORAGE_QUOTA";
const char *const OB_DBA_OB_LS_REPLICA_TASK_HISTORY_TNAME = "DBA_OB_LS_REPLICA_TASK_HISTORY";
const char *const OB_CDB_OB_LS_REPLICA_TASK_HISTORY_TNAME = "CDB_OB_LS_REPLICA_TASK_HISTORY";
const char *const OB_CDB_MVIEW_LOGS_TNAME = "CDB_MVIEW_LOGS";
const char *const OB_DBA_MVIEW_LOGS_TNAME = "DBA_MVIEW_LOGS";
const char *const OB_CDB_MVIEWS_TNAME = "CDB_MVIEWS";
const char *const OB_DBA_MVIEWS_TNAME = "DBA_MVIEWS";
const char *const OB_CDB_MVREF_STATS_SYS_DEFAULTS_TNAME = "CDB_MVREF_STATS_SYS_DEFAULTS";
const char *const OB_DBA_MVREF_STATS_SYS_DEFAULTS_TNAME = "DBA_MVREF_STATS_SYS_DEFAULTS";
const char *const OB_CDB_MVREF_STATS_PARAMS_TNAME = "CDB_MVREF_STATS_PARAMS";
const char *const OB_DBA_MVREF_STATS_PARAMS_TNAME = "DBA_MVREF_STATS_PARAMS";
const char *const OB_CDB_MVREF_RUN_STATS_TNAME = "CDB_MVREF_RUN_STATS";
const char *const OB_DBA_MVREF_RUN_STATS_TNAME = "DBA_MVREF_RUN_STATS";
const char *const OB_CDB_MVREF_STATS_TNAME = "CDB_MVREF_STATS";
const char *const OB_DBA_MVREF_STATS_TNAME = "DBA_MVREF_STATS";
const char *const OB_CDB_MVREF_CHANGE_STATS_TNAME = "CDB_MVREF_CHANGE_STATS";
const char *const OB_DBA_MVREF_CHANGE_STATS_TNAME = "DBA_MVREF_CHANGE_STATS";
const char *const OB_CDB_MVREF_STMT_STATS_TNAME = "CDB_MVREF_STMT_STATS";
const char *const OB_DBA_MVREF_STMT_STATS_TNAME = "DBA_MVREF_STMT_STATS";
const char *const OB_GV_OB_SESSION_PS_INFO_TNAME = "GV$OB_SESSION_PS_INFO";
const char *const OB_V_OB_SESSION_PS_INFO_TNAME = "V$OB_SESSION_PS_INFO";
const char *const OB_GV_OB_TRACEPOINT_INFO_TNAME = "GV$OB_TRACEPOINT_INFO";
const char *const OB_V_OB_TRACEPOINT_INFO_TNAME = "V$OB_TRACEPOINT_INFO";
const char *const OB_V_OB_COMPATIBILITY_CONTROL_TNAME = "V$OB_COMPATIBILITY_CONTROL";
const char *const OB_DBA_OB_RSRC_DIRECTIVES_TNAME = "DBA_OB_RSRC_DIRECTIVES";
const char *const OB_CDB_OB_RSRC_DIRECTIVES_TNAME = "CDB_OB_RSRC_DIRECTIVES";
const char *const OB_DBA_OB_SERVICES_TNAME = "DBA_OB_SERVICES";
const char *const OB_CDB_OB_SERVICES_TNAME = "CDB_OB_SERVICES";
const char *const OB_GV_OB_TENANT_RESOURCE_LIMIT_TNAME = "GV$OB_TENANT_RESOURCE_LIMIT";
const char *const OB_V_OB_TENANT_RESOURCE_LIMIT_TNAME = "V$OB_TENANT_RESOURCE_LIMIT";
const char *const OB_GV_OB_TENANT_RESOURCE_LIMIT_DETAIL_TNAME = "GV$OB_TENANT_RESOURCE_LIMIT_DETAIL";
const char *const OB_V_OB_TENANT_RESOURCE_LIMIT_DETAIL_TNAME = "V$OB_TENANT_RESOURCE_LIMIT_DETAIL";
const char *const OB_INNODB_LOCK_WAITS_TNAME = "INNODB_LOCK_WAITS";
const char *const OB_INNODB_LOCKS_TNAME = "INNODB_LOCKS";
const char *const OB_INNODB_TRX_TNAME = "INNODB_TRX";
const char *const OB_NDB_TRANSID_MYSQL_CONNECTION_MAP_TNAME = "NDB_TRANSID_MYSQL_CONNECTION_MAP";
const char *const OB_V_OB_GROUP_IO_STAT_TNAME = "V$OB_GROUP_IO_STAT";
const char *const OB_GV_OB_GROUP_IO_STAT_TNAME = "GV$OB_GROUP_IO_STAT";
const char *const OB_DBA_OB_STORAGE_IO_USAGE_TNAME = "DBA_OB_STORAGE_IO_USAGE";
const char *const OB_CDB_OB_STORAGE_IO_USAGE_TNAME = "CDB_OB_STORAGE_IO_USAGE";
const char *const OB_TABLESPACES_TNAME = "TABLESPACES";
const char *const OB_INNODB_BUFFER_PAGE_TNAME = "INNODB_BUFFER_PAGE";
const char *const OB_INNODB_BUFFER_PAGE_LRU_TNAME = "INNODB_BUFFER_PAGE_LRU";
const char *const OB_INNODB_BUFFER_POOL_STATS_TNAME = "INNODB_BUFFER_POOL_STATS";
const char *const OB_INNODB_CMP_TNAME = "INNODB_CMP";
const char *const OB_INNODB_CMP_PER_INDEX_TNAME = "INNODB_CMP_PER_INDEX";
const char *const OB_INNODB_CMP_PER_INDEX_RESET_TNAME = "INNODB_CMP_PER_INDEX_RESET";
const char *const OB_INNODB_CMP_RESET_TNAME = "INNODB_CMP_RESET";
const char *const OB_INNODB_CMPMEM_TNAME = "INNODB_CMPMEM";
const char *const OB_INNODB_CMPMEM_RESET_TNAME = "INNODB_CMPMEM_RESET";
const char *const OB_INNODB_SYS_DATAFILES_TNAME = "INNODB_SYS_DATAFILES";
const char *const OB_INNODB_SYS_INDEXES_TNAME = "INNODB_SYS_INDEXES";
const char *const OB_INNODB_SYS_TABLES_TNAME = "INNODB_SYS_TABLES";
const char *const OB_INNODB_SYS_TABLESPACES_TNAME = "INNODB_SYS_TABLESPACES";
const char *const OB_INNODB_SYS_TABLESTATS_TNAME = "INNODB_SYS_TABLESTATS";
const char *const OB_INNODB_SYS_VIRTUAL_TNAME = "INNODB_SYS_VIRTUAL";
const char *const OB_INNODB_TEMP_TABLE_INFO_TNAME = "INNODB_TEMP_TABLE_INFO";
const char *const OB_INNODB_METRICS_TNAME = "INNODB_METRICS";
const char *const OB_EVENTS_TNAME = "EVENTS";
const char *const OB_V_OB_NIC_INFO_TNAME = "V$OB_NIC_INFO";
const char *const OB_ROLE_TABLE_GRANTS_TNAME = "ROLE_TABLE_GRANTS";
const char *const OB_ROLE_COLUMN_GRANTS_TNAME = "ROLE_COLUMN_GRANTS";
const char *const OB_ROLE_ROUTINE_GRANTS_TNAME = "ROLE_ROUTINE_GRANTS";
const char *const OB_FUNC_TNAME = "func";
const char *const OB_GV_OB_NIC_INFO_TNAME = "GV$OB_NIC_INFO";
const char *const OB_GV_OB_QUERY_RESPONSE_TIME_HISTOGRAM_TNAME = "GV$OB_QUERY_RESPONSE_TIME_HISTOGRAM";
const char *const OB_V_OB_QUERY_RESPONSE_TIME_HISTOGRAM_TNAME = "V$OB_QUERY_RESPONSE_TIME_HISTOGRAM";
const char *const OB_DBA_SCHEDULER_JOB_RUN_DETAILS_TNAME = "DBA_SCHEDULER_JOB_RUN_DETAILS";
const char *const OB_CDB_SCHEDULER_JOB_RUN_DETAILS_TNAME = "CDB_SCHEDULER_JOB_RUN_DETAILS";
const char *const OB_CDB_OB_SERVER_SPACE_USAGE_TNAME = "CDB_OB_SERVER_SPACE_USAGE";
const char *const OB_CDB_OB_SPACE_USAGE_TNAME = "CDB_OB_SPACE_USAGE";
const char *const OB_DBA_OB_TABLE_SPACE_USAGE_TNAME = "DBA_OB_TABLE_SPACE_USAGE";
const char *const OB_CDB_OB_TABLE_SPACE_USAGE_TNAME = "CDB_OB_TABLE_SPACE_USAGE";
const char *const OB_GV_OB_LOG_TRANSPORT_DEST_STAT_TNAME = "GV$OB_LOG_TRANSPORT_DEST_STAT";
const char *const OB_V_OB_LOG_TRANSPORT_DEST_STAT_TNAME = "V$OB_LOG_TRANSPORT_DEST_STAT";
const char *const OB_GV_OB_SS_LOCAL_CACHE_TNAME = "GV$OB_SS_LOCAL_CACHE";
const char *const OB_V_OB_SS_LOCAL_CACHE_TNAME = "V$OB_SS_LOCAL_CACHE";
const char *const OB_GV_OB_KV_GROUP_COMMIT_STATUS_TNAME = "GV$OB_KV_GROUP_COMMIT_STATUS";
const char *const OB_V_OB_KV_GROUP_COMMIT_STATUS_TNAME = "V$OB_KV_GROUP_COMMIT_STATUS";
const char *const OB_INNODB_SYS_FIELDS_TNAME = "INNODB_SYS_FIELDS";
const char *const OB_INNODB_SYS_FOREIGN_TNAME = "INNODB_SYS_FOREIGN";
const char *const OB_INNODB_SYS_FOREIGN_COLS_TNAME = "INNODB_SYS_FOREIGN_COLS";
const char *const OB_GV_OB_KV_CLIENT_INFO_TNAME = "GV$OB_KV_CLIENT_INFO";
const char *const OB_V_OB_KV_CLIENT_INFO_TNAME = "V$OB_KV_CLIENT_INFO";
const char *const OB_GV_OB_RES_MGR_SYSSTAT_TNAME = "GV$OB_RES_MGR_SYSSTAT";
const char *const OB_V_OB_RES_MGR_SYSSTAT_TNAME = "V$OB_RES_MGR_SYSSTAT";
const char *const OB_DBA_WR_SQL_PLAN_TNAME = "DBA_WR_SQL_PLAN";
const char *const OB_CDB_WR_SQL_PLAN_TNAME = "CDB_WR_SQL_PLAN";
const char *const OB_DBA_OB_SPM_EVO_RESULT_TNAME = "DBA_OB_SPM_EVO_RESULT";
const char *const OB_CDB_OB_SPM_EVO_RESULT_TNAME = "CDB_OB_SPM_EVO_RESULT";
const char *const OB_DBA_OB_KV_REDIS_TABLE_TNAME = "DBA_OB_KV_REDIS_TABLE";
const char *const OB_CDB_OB_KV_REDIS_TABLE_TNAME = "CDB_OB_KV_REDIS_TABLE";
const char *const OB_GV_OB_FUNCTION_IO_STAT_TNAME = "GV$OB_FUNCTION_IO_STAT";
const char *const OB_V_OB_FUNCTION_IO_STAT_TNAME = "V$OB_FUNCTION_IO_STAT";
const char *const OB_DBA_OB_TEMP_FILES_TNAME = "DBA_OB_TEMP_FILES";
const char *const OB_CDB_OB_TEMP_FILES_TNAME = "CDB_OB_TEMP_FILES";
const char *const OB_PROC_TNAME = "proc";
const char *const OB_DBA_OB_CS_REPLICA_STATS_TNAME = "DBA_OB_CS_REPLICA_STATS";
const char *const OB_CDB_OB_CS_REPLICA_STATS_TNAME = "CDB_OB_CS_REPLICA_STATS";
const char *const OB_GV_OB_PLUGINS_TNAME = "GV$OB_PLUGINS";
const char *const OB_V_OB_PLUGINS_TNAME = "V$OB_PLUGINS";
const char *const OB_DBA_SYNONYMS_TNAME = "DBA_SYNONYMS";
const char *const OB_DBA_OBJECTS_ORA_TNAME = "DBA_OBJECTS";
const char *const OB_ALL_OBJECTS_TNAME = "ALL_OBJECTS";
const char *const OB_USER_OBJECTS_TNAME = "USER_OBJECTS";
const char *const OB_DBA_SEQUENCES_ORA_TNAME = "DBA_SEQUENCES";
const char *const OB_ALL_SEQUENCES_ORA_TNAME = "ALL_SEQUENCES";
const char *const OB_USER_SEQUENCES_ORA_TNAME = "USER_SEQUENCES";
const char *const OB_DBA_USERS_TNAME = "DBA_USERS";
const char *const OB_ALL_USERS_TNAME = "ALL_USERS";
const char *const OB_ALL_SYNONYMS_TNAME = "ALL_SYNONYMS";
const char *const OB_USER_SYNONYMS_TNAME = "USER_SYNONYMS";
const char *const OB_DBA_IND_COLUMNS_TNAME = "DBA_IND_COLUMNS";
const char *const OB_ALL_IND_COLUMNS_TNAME = "ALL_IND_COLUMNS";
const char *const OB_USER_IND_COLUMNS_TNAME = "USER_IND_COLUMNS";
const char *const OB_DBA_CONSTRAINTS_TNAME = "DBA_CONSTRAINTS";
const char *const OB_ALL_CONSTRAINTS_TNAME = "ALL_CONSTRAINTS";
const char *const OB_USER_CONSTRAINTS_TNAME = "USER_CONSTRAINTS";
const char *const OB_ALL_TAB_COLS_V_TNAME = "ALL_TAB_COLS_V$";
const char *const OB_DBA_TAB_COLS_V_TNAME = "DBA_TAB_COLS_V$";
const char *const OB_USER_TAB_COLS_V_TNAME = "USER_TAB_COLS_V$";
const char *const OB_ALL_TAB_COLS_TNAME = "ALL_TAB_COLS";
const char *const OB_DBA_TAB_COLS_TNAME = "DBA_TAB_COLS";
const char *const OB_USER_TAB_COLS_TNAME = "USER_TAB_COLS";
const char *const OB_ALL_TAB_COLUMNS_TNAME = "ALL_TAB_COLUMNS";
const char *const OB_DBA_TAB_COLUMNS_TNAME = "DBA_TAB_COLUMNS";
const char *const OB_USER_TAB_COLUMNS_TNAME = "USER_TAB_COLUMNS";
const char *const OB_ALL_TABLES_TNAME = "ALL_TABLES";
const char *const OB_DBA_TABLES_TNAME = "DBA_TABLES";
const char *const OB_USER_TABLES_TNAME = "USER_TABLES";
const char *const OB_DBA_TAB_COMMENTS_TNAME = "DBA_TAB_COMMENTS";
const char *const OB_ALL_TAB_COMMENTS_TNAME = "ALL_TAB_COMMENTS";
const char *const OB_USER_TAB_COMMENTS_TNAME = "USER_TAB_COMMENTS";
const char *const OB_DBA_COL_COMMENTS_TNAME = "DBA_COL_COMMENTS";
const char *const OB_ALL_COL_COMMENTS_TNAME = "ALL_COL_COMMENTS";
const char *const OB_USER_COL_COMMENTS_TNAME = "USER_COL_COMMENTS";
const char *const OB_DBA_INDEXES_TNAME = "DBA_INDEXES";
const char *const OB_ALL_INDEXES_TNAME = "ALL_INDEXES";
const char *const OB_USER_INDEXES_TNAME = "USER_INDEXES";
const char *const OB_DBA_CONS_COLUMNS_TNAME = "DBA_CONS_COLUMNS";
const char *const OB_ALL_CONS_COLUMNS_TNAME = "ALL_CONS_COLUMNS";
const char *const OB_USER_CONS_COLUMNS_TNAME = "USER_CONS_COLUMNS";
const char *const OB_USER_SEGMENTS_TNAME = "USER_SEGMENTS";
const char *const OB_DBA_SEGMENTS_TNAME = "DBA_SEGMENTS";
const char *const OB_DBA_TYPES_TNAME = "DBA_TYPES";
const char *const OB_ALL_TYPES_TNAME = "ALL_TYPES";
const char *const OB_USER_TYPES_TNAME = "USER_TYPES";
const char *const OB_DBA_TYPE_ATTRS_TNAME = "DBA_TYPE_ATTRS";
const char *const OB_ALL_TYPE_ATTRS_TNAME = "ALL_TYPE_ATTRS";
const char *const OB_USER_TYPE_ATTRS_TNAME = "USER_TYPE_ATTRS";
const char *const OB_DBA_COLL_TYPES_TNAME = "DBA_COLL_TYPES";
const char *const OB_ALL_COLL_TYPES_TNAME = "ALL_COLL_TYPES";
const char *const OB_USER_COLL_TYPES_TNAME = "USER_COLL_TYPES";
const char *const OB_DBA_PROCEDURES_TNAME = "DBA_PROCEDURES";
const char *const OB_DBA_ARGUMENTS_TNAME = "DBA_ARGUMENTS";
const char *const OB_DBA_SOURCE_TNAME = "DBA_SOURCE";
const char *const OB_ALL_PROCEDURES_TNAME = "ALL_PROCEDURES";
const char *const OB_ALL_ARGUMENTS_TNAME = "ALL_ARGUMENTS";
const char *const OB_ALL_SOURCE_TNAME = "ALL_SOURCE";
const char *const OB_USER_PROCEDURES_TNAME = "USER_PROCEDURES";
const char *const OB_USER_ARGUMENTS_TNAME = "USER_ARGUMENTS";
const char *const OB_USER_SOURCE_TNAME = "USER_SOURCE";
const char *const OB_DBA_PART_KEY_COLUMNS_ORA_TNAME = "DBA_PART_KEY_COLUMNS";
const char *const OB_ALL_PART_KEY_COLUMNS_TNAME = "ALL_PART_KEY_COLUMNS";
const char *const OB_USER_PART_KEY_COLUMNS_TNAME = "USER_PART_KEY_COLUMNS";
const char *const OB_DBA_SUBPART_KEY_COLUMNS_ORA_TNAME = "DBA_SUBPART_KEY_COLUMNS";
const char *const OB_ALL_SUBPART_KEY_COLUMNS_TNAME = "ALL_SUBPART_KEY_COLUMNS";
const char *const OB_USER_SUBPART_KEY_COLUMNS_TNAME = "USER_SUBPART_KEY_COLUMNS";
const char *const OB_DBA_VIEWS_TNAME = "DBA_VIEWS";
const char *const OB_ALL_VIEWS_TNAME = "ALL_VIEWS";
const char *const OB_USER_VIEWS_TNAME = "USER_VIEWS";
const char *const OB_ALL_TAB_PARTITIONS_ORA_TNAME = "ALL_TAB_PARTITIONS";
const char *const OB_ALL_TAB_SUBPARTITIONS_ORA_TNAME = "ALL_TAB_SUBPARTITIONS";
const char *const OB_ALL_PART_TABLES_ORA_TNAME = "ALL_PART_TABLES";
const char *const OB_DBA_PART_TABLES_ORA_TNAME = "DBA_PART_TABLES";
const char *const OB_USER_PART_TABLES_ORA_TNAME = "USER_PART_TABLES";
const char *const OB_DBA_TAB_PARTITIONS_ORA_TNAME = "DBA_TAB_PARTITIONS";
const char *const OB_USER_TAB_PARTITIONS_ORA_TNAME = "USER_TAB_PARTITIONS";
const char *const OB_DBA_TAB_SUBPARTITIONS_ORA_TNAME = "DBA_TAB_SUBPARTITIONS";
const char *const OB_USER_TAB_SUBPARTITIONS_ORA_TNAME = "USER_TAB_SUBPARTITIONS";
const char *const OB_DBA_SUBPARTITION_TEMPLATES_ORA_TNAME = "DBA_SUBPARTITION_TEMPLATES";
const char *const OB_ALL_SUBPARTITION_TEMPLATES_ORA_TNAME = "ALL_SUBPARTITION_TEMPLATES";
const char *const OB_USER_SUBPARTITION_TEMPLATES_ORA_TNAME = "USER_SUBPARTITION_TEMPLATES";
const char *const OB_DBA_PART_INDEXES_ORA_TNAME = "DBA_PART_INDEXES";
const char *const OB_ALL_PART_INDEXES_ORA_TNAME = "ALL_PART_INDEXES";
const char *const OB_USER_PART_INDEXES_ORA_TNAME = "USER_PART_INDEXES";
const char *const OB_ALL_ALL_TABLES_ORA_TNAME = "ALL_ALL_TABLES";
const char *const OB_DBA_ALL_TABLES_ORA_TNAME = "DBA_ALL_TABLES";
const char *const OB_USER_ALL_TABLES_ORA_TNAME = "USER_ALL_TABLES";
const char *const OB_DBA_PROFILES_ORA_TNAME = "DBA_PROFILES";
const char *const OB_USER_PROFILES_ORA_TNAME = "USER_PROFILES";
const char *const OB_ALL_PROFILES_ORA_TNAME = "ALL_PROFILES";
const char *const OB_ALL_MVIEW_COMMENTS_ORA_TNAME = "ALL_MVIEW_COMMENTS";
const char *const OB_USER_MVIEW_COMMENTS_ORA_TNAME = "USER_MVIEW_COMMENTS";
const char *const OB_DBA_MVIEW_COMMENTS_ORA_TNAME = "DBA_MVIEW_COMMENTS";
const char *const OB_ALL_SCHEDULER_PROGRAM_ARGS_ORA_TNAME = "ALL_SCHEDULER_PROGRAM_ARGS";
const char *const OB_DBA_SCHEDULER_PROGRAM_ARGS_ORA_TNAME = "DBA_SCHEDULER_PROGRAM_ARGS";
const char *const OB_USER_SCHEDULER_PROGRAM_ARGS_ORA_TNAME = "USER_SCHEDULER_PROGRAM_ARGS";
const char *const OB_ALL_SCHEDULER_JOB_ARGS_ORA_TNAME = "ALL_SCHEDULER_JOB_ARGS";
const char *const OB_DBA_SCHEDULER_JOB_ARGS_ORA_TNAME = "DBA_SCHEDULER_JOB_ARGS";
const char *const OB_USER_SCHEDULER_JOB_ARGS_ORA_TNAME = "USER_SCHEDULER_JOB_ARGS";
const char *const OB_ALL_ERRORS_ORA_TNAME = "ALL_ERRORS";
const char *const OB_DBA_ERRORS_ORA_TNAME = "DBA_ERRORS";
const char *const OB_USER_ERRORS_ORA_TNAME = "USER_ERRORS";
const char *const OB_ALL_TYPE_METHODS_ORA_TNAME = "ALL_TYPE_METHODS";
const char *const OB_DBA_TYPE_METHODS_ORA_TNAME = "DBA_TYPE_METHODS";
const char *const OB_USER_TYPE_METHODS_ORA_TNAME = "USER_TYPE_METHODS";
const char *const OB_ALL_METHOD_PARAMS_ORA_TNAME = "ALL_METHOD_PARAMS";
const char *const OB_DBA_METHOD_PARAMS_ORA_TNAME = "DBA_METHOD_PARAMS";
const char *const OB_USER_METHOD_PARAMS_ORA_TNAME = "USER_METHOD_PARAMS";
const char *const OB_DBA_TABLESPACES_ORA_TNAME = "DBA_TABLESPACES";
const char *const OB_USER_TABLESPACES_ORA_TNAME = "USER_TABLESPACES";
const char *const OB_DBA_IND_EXPRESSIONS_TNAME = "DBA_IND_EXPRESSIONS";
const char *const OB_USER_IND_EXPRESSIONS_TNAME = "USER_IND_EXPRESSIONS";
const char *const OB_ALL_IND_EXPRESSIONS_TNAME = "ALL_IND_EXPRESSIONS";
const char *const OB_ALL_IND_PARTITIONS_TNAME = "ALL_IND_PARTITIONS";
const char *const OB_USER_IND_PARTITIONS_TNAME = "USER_IND_PARTITIONS";
const char *const OB_DBA_IND_PARTITIONS_ORA_TNAME = "DBA_IND_PARTITIONS";
const char *const OB_DBA_IND_SUBPARTITIONS_ORA_TNAME = "DBA_IND_SUBPARTITIONS";
const char *const OB_ALL_IND_SUBPARTITIONS_TNAME = "ALL_IND_SUBPARTITIONS";
const char *const OB_USER_IND_SUBPARTITIONS_TNAME = "USER_IND_SUBPARTITIONS";
const char *const OB_DBA_ROLES_TNAME = "DBA_ROLES";
const char *const OB_DBA_ROLE_PRIVS_TNAME = "DBA_ROLE_PRIVS";
const char *const OB_USER_ROLE_PRIVS_TNAME = "USER_ROLE_PRIVS";
const char *const OB_DBA_TAB_PRIVS_TNAME = "DBA_TAB_PRIVS";
const char *const OB_ALL_TAB_PRIVS_TNAME = "ALL_TAB_PRIVS";
const char *const OB_USER_TAB_PRIVS_TNAME = "USER_TAB_PRIVS";
const char *const OB_DBA_SYS_PRIVS_TNAME = "DBA_SYS_PRIVS";
const char *const OB_USER_SYS_PRIVS_TNAME = "USER_SYS_PRIVS";
const char *const OB_AUDIT_ACTIONS_ORA_TNAME = "AUDIT_ACTIONS";
const char *const OB_STMT_AUDIT_OPTION_MAP_ORA_TNAME = "STMT_AUDIT_OPTION_MAP";
const char *const OB_ALL_DEF_AUDIT_OPTS_ORA_TNAME = "ALL_DEF_AUDIT_OPTS";
const char *const OB_DBA_STMT_AUDIT_OPTS_ORA_TNAME = "DBA_STMT_AUDIT_OPTS";
const char *const OB_DBA_OBJ_AUDIT_OPTS_ORA_TNAME = "DBA_OBJ_AUDIT_OPTS";
const char *const OB_DBA_AUDIT_TRAIL_ORA_TNAME = "DBA_AUDIT_TRAIL";
const char *const OB_USER_AUDIT_TRAIL_ORA_TNAME = "USER_AUDIT_TRAIL";
const char *const OB_DBA_AUDIT_EXISTS_ORA_TNAME = "DBA_AUDIT_EXISTS";
const char *const OB_DBA_AUDIT_SESSION_ORA_TNAME = "DBA_AUDIT_SESSION";
const char *const OB_USER_AUDIT_SESSION_ORA_TNAME = "USER_AUDIT_SESSION";
const char *const OB_DBA_AUDIT_STATEMENT_ORA_TNAME = "DBA_AUDIT_STATEMENT";
const char *const OB_USER_AUDIT_STATEMENT_ORA_TNAME = "USER_AUDIT_STATEMENT";
const char *const OB_DBA_AUDIT_OBJECT_ORA_TNAME = "DBA_AUDIT_OBJECT";
const char *const OB_USER_AUDIT_OBJECT_ORA_TNAME = "USER_AUDIT_OBJECT";
const char *const OB_DBA_COL_PRIVS_ORA_TNAME = "DBA_COL_PRIVS";
const char *const OB_USER_COL_PRIVS_ORA_TNAME = "USER_COL_PRIVS";
const char *const OB_ALL_COL_PRIVS_ORA_TNAME = "ALL_COL_PRIVS";
const char *const OB_ROLE_TAB_PRIVS_ORA_TNAME = "ROLE_TAB_PRIVS";
const char *const OB_ROLE_SYS_PRIVS_ORA_TNAME = "ROLE_SYS_PRIVS";
const char *const OB_ROLE_ROLE_PRIVS_ORA_TNAME = "ROLE_ROLE_PRIVS";
const char *const OB_DICTIONARY_ORA_TNAME = "DICTIONARY";
const char *const OB_DICT_ORA_TNAME = "DICT";
const char *const OB_ALL_TRIGGERS_TNAME = "ALL_TRIGGERS";
const char *const OB_DBA_TRIGGERS_TNAME = "DBA_TRIGGERS";
const char *const OB_USER_TRIGGERS_TNAME = "USER_TRIGGERS";
const char *const OB_ALL_DEPENDENCIES_ORA_TNAME = "ALL_DEPENDENCIES";
const char *const OB_DBA_DEPENDENCIES_ORA_TNAME = "DBA_DEPENDENCIES";
const char *const OB_USER_DEPENDENCIES_ORA_TNAME = "USER_DEPENDENCIES";
const char *const OB_DBA_RSRC_PLANS_ORA_TNAME = "DBA_RSRC_PLANS";
const char *const OB_DBA_RSRC_PLAN_DIRECTIVES_ORA_TNAME = "DBA_RSRC_PLAN_DIRECTIVES";
const char *const OB_DBA_RSRC_GROUP_MAPPINGS_ORA_TNAME = "DBA_RSRC_GROUP_MAPPINGS";
const char *const OB_DBA_RECYCLEBIN_ORA_TNAME = "DBA_RECYCLEBIN";
const char *const OB_USER_RECYCLEBIN_ORA_TNAME = "USER_RECYCLEBIN";
const char *const OB_DBA_RSRC_CONSUMER_GROUPS_ORA_TNAME = "DBA_RSRC_CONSUMER_GROUPS";
const char *const OB_DBA_OB_LS_LOCATIONS_ORA_TNAME = "DBA_OB_LS_LOCATIONS";
const char *const OB_DBA_OB_TABLET_TO_LS_ORA_TNAME = "DBA_OB_TABLET_TO_LS";
const char *const OB_DBA_OB_TABLET_REPLICAS_ORA_TNAME = "DBA_OB_TABLET_REPLICAS";
const char *const OB_DBA_OB_TABLEGROUPS_ORA_TNAME = "DBA_OB_TABLEGROUPS";
const char *const OB_DBA_OB_TABLEGROUP_PARTITIONS_ORA_TNAME = "DBA_OB_TABLEGROUP_PARTITIONS";
const char *const OB_DBA_OB_TABLEGROUP_SUBPARTITIONS_ORA_TNAME = "DBA_OB_TABLEGROUP_SUBPARTITIONS";
const char *const OB_DBA_OB_DATABASES_ORA_TNAME = "DBA_OB_DATABASES";
const char *const OB_DBA_OB_TABLEGROUP_TABLES_ORA_TNAME = "DBA_OB_TABLEGROUP_TABLES";
const char *const OB_DBA_OB_ZONE_MAJOR_COMPACTION_ORA_TNAME = "DBA_OB_ZONE_MAJOR_COMPACTION";
const char *const OB_DBA_OB_MAJOR_COMPACTION_ORA_TNAME = "DBA_OB_MAJOR_COMPACTION";
const char *const OB_ALL_IND_STATISTICS_ORA_TNAME = "ALL_IND_STATISTICS";
const char *const OB_DBA_IND_STATISTICS_ORA_TNAME = "DBA_IND_STATISTICS";
const char *const OB_USER_IND_STATISTICS_ORA_TNAME = "USER_IND_STATISTICS";
const char *const OB_DBA_OB_BACKUP_JOBS_ORA_TNAME = "DBA_OB_BACKUP_JOBS";
const char *const OB_DBA_OB_BACKUP_JOB_HISTORY_ORA_TNAME = "DBA_OB_BACKUP_JOB_HISTORY";
const char *const OB_DBA_OB_BACKUP_TASKS_ORA_TNAME = "DBA_OB_BACKUP_TASKS";
const char *const OB_DBA_OB_BACKUP_TASK_HISTORY_ORA_TNAME = "DBA_OB_BACKUP_TASK_HISTORY";
const char *const OB_DBA_OB_BACKUP_SET_FILES_ORA_TNAME = "DBA_OB_BACKUP_SET_FILES";
const char *const OB_ALL_TAB_MODIFICATIONS_ORA_TNAME = "ALL_TAB_MODIFICATIONS";
const char *const OB_DBA_TAB_MODIFICATIONS_ORA_TNAME = "DBA_TAB_MODIFICATIONS";
const char *const OB_USER_TAB_MODIFICATIONS_ORA_TNAME = "USER_TAB_MODIFICATIONS";
const char *const OB_DBA_OB_BACKUP_STORAGE_INFO_ORA_TNAME = "DBA_OB_BACKUP_STORAGE_INFO";
const char *const OB_DBA_OB_BACKUP_STORAGE_INFO_HISTORY_ORA_TNAME = "DBA_OB_BACKUP_STORAGE_INFO_HISTORY";
const char *const OB_DBA_OB_BACKUP_DELETE_POLICY_ORA_TNAME = "DBA_OB_BACKUP_DELETE_POLICY";
const char *const OB_DBA_OB_BACKUP_DELETE_JOBS_ORA_TNAME = "DBA_OB_BACKUP_DELETE_JOBS";
const char *const OB_DBA_OB_BACKUP_DELETE_JOB_HISTORY_ORA_TNAME = "DBA_OB_BACKUP_DELETE_JOB_HISTORY";
const char *const OB_DBA_OB_BACKUP_DELETE_TASKS_ORA_TNAME = "DBA_OB_BACKUP_DELETE_TASKS";
const char *const OB_DBA_OB_BACKUP_DELETE_TASK_HISTORY_ORA_TNAME = "DBA_OB_BACKUP_DELETE_TASK_HISTORY";
const char *const OB_DBA_OB_RESTORE_PROGRESS_ORA_TNAME = "DBA_OB_RESTORE_PROGRESS";
const char *const OB_DBA_OB_RESTORE_HISTORY_ORA_TNAME = "DBA_OB_RESTORE_HISTORY";
const char *const OB_DBA_OB_ARCHIVE_DEST_ORA_TNAME = "DBA_OB_ARCHIVE_DEST";
const char *const OB_DBA_OB_ARCHIVELOG_ORA_TNAME = "DBA_OB_ARCHIVELOG";
const char *const OB_DBA_OB_ARCHIVELOG_SUMMARY_ORA_TNAME = "DBA_OB_ARCHIVELOG_SUMMARY";
const char *const OB_DBA_OB_ARCHIVELOG_PIECE_FILES_ORA_TNAME = "DBA_OB_ARCHIVELOG_PIECE_FILES";
const char *const OB_DBA_OB_BACKUP_PARAMETER_ORA_TNAME = "DBA_OB_BACKUP_PARAMETER";
const char *const OB_DBA_OB_FREEZE_INFO_ORA_TNAME = "DBA_OB_FREEZE_INFO";
const char *const OB_DBA_OB_LS_REPLICA_TASKS_ORA_TNAME = "DBA_OB_LS_REPLICA_TASKS";
const char *const OB_V_OB_LS_REPLICA_TASK_PLAN_ORA_TNAME = "V$OB_LS_REPLICA_TASK_PLAN";
const char *const OB_ALL_SCHEDULER_WINDOWS_ORA_TNAME = "ALL_SCHEDULER_WINDOWS";
const char *const OB_DBA_SCHEDULER_WINDOWS_ORA_TNAME = "DBA_SCHEDULER_WINDOWS";
const char *const OB_DBA_OB_DATABASE_PRIVILEGE_ORA_TNAME = "DBA_OB_DATABASE_PRIVILEGE";
const char *const OB_DBA_OB_TENANTS_ORA_TNAME = "DBA_OB_TENANTS";
const char *const OB_DBA_POLICIES_ORA_TNAME = "DBA_POLICIES";
const char *const OB_ALL_POLICIES_ORA_TNAME = "ALL_POLICIES";
const char *const OB_USER_POLICIES_ORA_TNAME = "USER_POLICIES";
const char *const OB_DBA_POLICY_GROUPS_ORA_TNAME = "DBA_POLICY_GROUPS";
const char *const OB_ALL_POLICY_GROUPS_ORA_TNAME = "ALL_POLICY_GROUPS";
const char *const OB_USER_POLICY_GROUPS_ORA_TNAME = "USER_POLICY_GROUPS";
const char *const OB_DBA_POLICY_CONTEXTS_ORA_TNAME = "DBA_POLICY_CONTEXTS";
const char *const OB_ALL_POLICY_CONTEXTS_ORA_TNAME = "ALL_POLICY_CONTEXTS";
const char *const OB_USER_POLICY_CONTEXTS_ORA_TNAME = "USER_POLICY_CONTEXTS";
const char *const OB_DBA_SEC_RELEVANT_COLS_ORA_TNAME = "DBA_SEC_RELEVANT_COLS";
const char *const OB_ALL_SEC_RELEVANT_COLS_ORA_TNAME = "ALL_SEC_RELEVANT_COLS";
const char *const OB_USER_SEC_RELEVANT_COLS_ORA_TNAME = "USER_SEC_RELEVANT_COLS";
const char *const OB_DBA_OB_LS_ARB_REPLICA_TASKS_ORA_TNAME = "DBA_OB_LS_ARB_REPLICA_TASKS";
const char *const OB_DBA_OB_LS_ARB_REPLICA_TASK_HISTORY_ORA_TNAME = "DBA_OB_LS_ARB_REPLICA_TASK_HISTORY";
const char *const OB_DBA_OB_RSRC_IO_DIRECTIVES_ORA_TNAME = "DBA_OB_RSRC_IO_DIRECTIVES";
const char *const OB_ALL_DB_LINKS_ORA_TNAME = "ALL_DB_LINKS";
const char *const OB_DBA_DB_LINKS_ORA_TNAME = "DBA_DB_LINKS";
const char *const OB_USER_DB_LINKS_ORA_TNAME = "USER_DB_LINKS";
const char *const OB_DBA_OB_TASK_OPT_STAT_GATHER_HISTORY_ORA_TNAME = "DBA_OB_TASK_OPT_STAT_GATHER_HISTORY";
const char *const OB_DBA_OB_TABLE_OPT_STAT_GATHER_HISTORY_ORA_TNAME = "DBA_OB_TABLE_OPT_STAT_GATHER_HISTORY";
const char *const OB_DBA_WR_ACTIVE_SESSION_HISTORY_ORA_TNAME = "DBA_WR_ACTIVE_SESSION_HISTORY";
const char *const OB_DBA_WR_SNAPSHOT_ORA_TNAME = "DBA_WR_SNAPSHOT";
const char *const OB_DBA_WR_STATNAME_ORA_TNAME = "DBA_WR_STATNAME";
const char *const OB_DBA_WR_SYSSTAT_ORA_TNAME = "DBA_WR_SYSSTAT";
const char *const OB_DBA_OB_LOG_RESTORE_SOURCE_ORA_TNAME = "DBA_OB_LOG_RESTORE_SOURCE";
const char *const OB_DBA_OB_EXTERNAL_TABLE_FILES_ORA_TNAME = "DBA_OB_EXTERNAL_TABLE_FILES";
const char *const OB_ALL_OB_EXTERNAL_TABLE_FILES_ORA_TNAME = "ALL_OB_EXTERNAL_TABLE_FILES";
const char *const OB_DBA_OB_BALANCE_JOBS_ORA_TNAME = "DBA_OB_BALANCE_JOBS";
const char *const OB_DBA_OB_BALANCE_JOB_HISTORY_ORA_TNAME = "DBA_OB_BALANCE_JOB_HISTORY";
const char *const OB_DBA_OB_BALANCE_TASKS_ORA_TNAME = "DBA_OB_BALANCE_TASKS";
const char *const OB_DBA_OB_BALANCE_TASK_HISTORY_ORA_TNAME = "DBA_OB_BALANCE_TASK_HISTORY";
const char *const OB_DBA_OB_TRANSFER_TASKS_ORA_TNAME = "DBA_OB_TRANSFER_TASKS";
const char *const OB_DBA_OB_TRANSFER_TASK_HISTORY_ORA_TNAME = "DBA_OB_TRANSFER_TASK_HISTORY";
const char *const OB_GV_OB_PX_P2P_DATAHUB_ORA_TNAME = "GV$OB_PX_P2P_DATAHUB";
const char *const OB_V_OB_PX_P2P_DATAHUB_ORA_TNAME = "V$OB_PX_P2P_DATAHUB";
const char *const OB_GV_SQL_JOIN_FILTER_ORA_TNAME = "GV$SQL_JOIN_FILTER";
const char *const OB_V_SQL_JOIN_FILTER_ORA_TNAME = "V$SQL_JOIN_FILTER";
const char *const OB_DBA_OB_TABLE_STAT_STALE_INFO_ORA_TNAME = "DBA_OB_TABLE_STAT_STALE_INFO";
const char *const OB_DBMS_LOCK_ALLOCATED_ORA_TNAME = "DBMS_LOCK_ALLOCATED";
const char *const OB_DBA_WR_CONTROL_ORA_TNAME = "DBA_WR_CONTROL";
const char *const OB_DBA_OB_LS_HISTORY_ORA_TNAME = "DBA_OB_LS_HISTORY";
const char *const OB_DBA_OB_TENANT_EVENT_HISTORY_ORA_TNAME = "DBA_OB_TENANT_EVENT_HISTORY";
const char *const OB_DBA_SCHEDULER_JOB_RUN_DETAILS_ORA_TNAME = "DBA_SCHEDULER_JOB_RUN_DETAILS";
const char *const OB_DBA_SCHEDULER_JOB_CLASSES_TNAME = "DBA_SCHEDULER_JOB_CLASSES";
const char *const OB_DBA_OB_RECOVER_TABLE_JOBS_ORA_TNAME = "DBA_OB_RECOVER_TABLE_JOBS";
const char *const OB_DBA_OB_RECOVER_TABLE_JOB_HISTORY_ORA_TNAME = "DBA_OB_RECOVER_TABLE_JOB_HISTORY";
const char *const OB_DBA_OB_IMPORT_TABLE_JOBS_ORA_TNAME = "DBA_OB_IMPORT_TABLE_JOBS";
const char *const OB_DBA_OB_IMPORT_TABLE_JOB_HISTORY_ORA_TNAME = "DBA_OB_IMPORT_TABLE_JOB_HISTORY";
const char *const OB_DBA_OB_IMPORT_TABLE_TASKS_ORA_TNAME = "DBA_OB_IMPORT_TABLE_TASKS";
const char *const OB_DBA_OB_IMPORT_TABLE_TASK_HISTORY_ORA_TNAME = "DBA_OB_IMPORT_TABLE_TASK_HISTORY";
const char *const OB_DBA_WR_SYSTEM_EVENT_ORA_TNAME = "DBA_WR_SYSTEM_EVENT";
const char *const OB_DBA_WR_EVENT_NAME_ORA_TNAME = "DBA_WR_EVENT_NAME";
const char *const OB_DBA_OB_FORMAT_OUTLINES_ORA_TNAME = "DBA_OB_FORMAT_OUTLINES";
const char *const OB_DBA_WR_SQLSTAT_ORA_TNAME = "DBA_WR_SQLSTAT";
const char *const OB_DBA_WR_SYS_TIME_MODEL_ORA_TNAME = "DBA_WR_SYS_TIME_MODEL";
const char *const OB_DBA_OB_TRANSFER_PARTITION_TASKS_ORA_TNAME = "DBA_OB_TRANSFER_PARTITION_TASKS";
const char *const OB_DBA_OB_TRANSFER_PARTITION_TASK_HISTORY_ORA_TNAME = "DBA_OB_TRANSFER_PARTITION_TASK_HISTORY";
const char *const OB_DBA_WR_SQLTEXT_ORA_TNAME = "DBA_WR_SQLTEXT";
const char *const OB_USER_USERS_TNAME = "USER_USERS";
const char *const OB_DBA_OB_LS_REPLICA_TASK_HISTORY_ORA_TNAME = "DBA_OB_LS_REPLICA_TASK_HISTORY";
const char *const OB_DBA_MVIEW_LOGS_ORA_TNAME = "DBA_MVIEW_LOGS";
const char *const OB_ALL_MVIEW_LOGS_ORA_TNAME = "ALL_MVIEW_LOGS";
const char *const OB_USER_MVIEW_LOGS_ORA_TNAME = "USER_MVIEW_LOGS";
const char *const OB_DBA_MVIEWS_ORA_TNAME = "DBA_MVIEWS";
const char *const OB_ALL_MVIEWS_ORA_TNAME = "ALL_MVIEWS";
const char *const OB_USER_MVIEWS_ORA_TNAME = "USER_MVIEWS";
const char *const OB_DBA_MVREF_STATS_SYS_DEFAULTS_ORA_TNAME = "DBA_MVREF_STATS_SYS_DEFAULTS";
const char *const OB_USER_MVREF_STATS_SYS_DEFAULTS_ORA_TNAME = "USER_MVREF_STATS_SYS_DEFAULTS";
const char *const OB_DBA_MVREF_STATS_PARAMS_ORA_TNAME = "DBA_MVREF_STATS_PARAMS";
const char *const OB_USER_MVREF_STATS_PARAMS_ORA_TNAME = "USER_MVREF_STATS_PARAMS";
const char *const OB_DBA_MVREF_RUN_STATS_ORA_TNAME = "DBA_MVREF_RUN_STATS";
const char *const OB_USER_MVREF_RUN_STATS_ORA_TNAME = "USER_MVREF_RUN_STATS";
const char *const OB_DBA_MVREF_STATS_ORA_TNAME = "DBA_MVREF_STATS";
const char *const OB_USER_MVREF_STATS_ORA_TNAME = "USER_MVREF_STATS";
const char *const OB_DBA_MVREF_CHANGE_STATS_ORA_TNAME = "DBA_MVREF_CHANGE_STATS";
const char *const OB_USER_MVREF_CHANGE_STATS_ORA_TNAME = "USER_MVREF_CHANGE_STATS";
const char *const OB_DBA_MVREF_STMT_STATS_ORA_TNAME = "DBA_MVREF_STMT_STATS";
const char *const OB_USER_MVREF_STMT_STATS_ORA_TNAME = "USER_MVREF_STMT_STATS";
const char *const OB_PROXY_USERS_TNAME = "PROXY_USERS";
const char *const OB_DBA_OB_SERVICES_ORA_TNAME = "DBA_OB_SERVICES";
const char *const OB_DBA_OB_STORAGE_IO_USAGE_ORA_TNAME = "DBA_OB_STORAGE_IO_USAGE";
const char *const OB_USER_SCHEDULER_JOBS_ORA_TNAME = "USER_SCHEDULER_JOBS";
const char *const OB_GV_OB_SQL_AUDIT_ORA_TNAME = "GV$OB_SQL_AUDIT";
const char *const OB_V_OB_SQL_AUDIT_ORA_TNAME = "V$OB_SQL_AUDIT";
const char *const OB_GV_INSTANCE_TNAME = "GV$INSTANCE";
const char *const OB_V_INSTANCE_TNAME = "V$INSTANCE";
const char *const OB_GV_OB_PLAN_CACHE_PLAN_STAT_ORA_TNAME = "GV$OB_PLAN_CACHE_PLAN_STAT";
const char *const OB_V_OB_PLAN_CACHE_PLAN_STAT_ORA_TNAME = "V$OB_PLAN_CACHE_PLAN_STAT";
const char *const OB_GV_OB_PLAN_CACHE_PLAN_EXPLAIN_ORA_TNAME = "GV$OB_PLAN_CACHE_PLAN_EXPLAIN";
const char *const OB_V_OB_PLAN_CACHE_PLAN_EXPLAIN_ORA_TNAME = "V$OB_PLAN_CACHE_PLAN_EXPLAIN";
const char *const OB_GV_SESSION_WAIT_ORA_TNAME = "GV$SESSION_WAIT";
const char *const OB_V_SESSION_WAIT_ORA_TNAME = "V$SESSION_WAIT";
const char *const OB_GV_SESSION_WAIT_HISTORY_ORA_TNAME = "GV$SESSION_WAIT_HISTORY";
const char *const OB_V_SESSION_WAIT_HISTORY_ORA_TNAME = "V$SESSION_WAIT_HISTORY";
const char *const OB_GV_OB_MEMORY_ORA_TNAME = "GV$OB_MEMORY";
const char *const OB_V_OB_MEMORY_ORA_TNAME = "V$OB_MEMORY";
const char *const OB_GV_OB_MEMSTORE_ORA_TNAME = "GV$OB_MEMSTORE";
const char *const OB_V_OB_MEMSTORE_ORA_TNAME = "V$OB_MEMSTORE";
const char *const OB_GV_OB_MEMSTORE_INFO_ORA_TNAME = "GV$OB_MEMSTORE_INFO";
const char *const OB_V_OB_MEMSTORE_INFO_ORA_TNAME = "V$OB_MEMSTORE_INFO";
const char *const OB_GV_SESSTAT_ORA_TNAME = "GV$SESSTAT";
const char *const OB_V_SESSTAT_ORA_TNAME = "V$SESSTAT";
const char *const OB_GV_SYSSTAT_ORA_TNAME = "GV$SYSSTAT";
const char *const OB_V_SYSSTAT_ORA_TNAME = "V$SYSSTAT";
const char *const OB_GV_SYSTEM_EVENT_ORA_TNAME = "GV$SYSTEM_EVENT";
const char *const OB_V_SYSTEM_EVENT_ORA_TNAME = "V$SYSTEM_EVENT";
const char *const OB_GV_OB_PLAN_CACHE_STAT_ORA_TNAME = "GV$OB_PLAN_CACHE_STAT";
const char *const OB_V_OB_PLAN_CACHE_STAT_ORA_TNAME = "V$OB_PLAN_CACHE_STAT";
const char *const OB_NLS_SESSION_PARAMETERS_ORA_TNAME = "NLS_SESSION_PARAMETERS";
const char *const OB_NLS_INSTANCE_PARAMETERS_ORA_TNAME = "NLS_INSTANCE_PARAMETERS";
const char *const OB_NLS_DATABASE_PARAMETERS_ORA_TNAME = "NLS_DATABASE_PARAMETERS";
const char *const OB_V_NLS_PARAMETERS_ORA_TNAME = "V$NLS_PARAMETERS";
const char *const OB_V_VERSION_ORA_TNAME = "V$VERSION";
const char *const OB_GV_OB_PX_WORKER_STAT_ORA_TNAME = "GV$OB_PX_WORKER_STAT";
const char *const OB_V_OB_PX_WORKER_STAT_ORA_TNAME = "V$OB_PX_WORKER_STAT";
const char *const OB_GV_OB_PS_STAT_ORA_TNAME = "GV$OB_PS_STAT";
const char *const OB_V_OB_PS_STAT_ORA_TNAME = "V$OB_PS_STAT";
const char *const OB_GV_OB_PS_ITEM_INFO_ORA_TNAME = "GV$OB_PS_ITEM_INFO";
const char *const OB_V_OB_PS_ITEM_INFO_ORA_TNAME = "V$OB_PS_ITEM_INFO";
const char *const OB_GV_SQL_WORKAREA_ACTIVE_ORA_TNAME = "GV$SQL_WORKAREA_ACTIVE";
const char *const OB_V_SQL_WORKAREA_ACTIVE_ORA_TNAME = "V$SQL_WORKAREA_ACTIVE";
const char *const OB_GV_SQL_WORKAREA_HISTOGRAM_ORA_TNAME = "GV$SQL_WORKAREA_HISTOGRAM";
const char *const OB_V_SQL_WORKAREA_HISTOGRAM_ORA_TNAME = "V$SQL_WORKAREA_HISTOGRAM";
const char *const OB_GV_OB_SQL_WORKAREA_MEMORY_INFO_ORA_TNAME = "GV$OB_SQL_WORKAREA_MEMORY_INFO";
const char *const OB_V_OB_SQL_WORKAREA_MEMORY_INFO_ORA_TNAME = "V$OB_SQL_WORKAREA_MEMORY_INFO";
const char *const OB_GV_OB_PLAN_CACHE_REFERENCE_INFO_ORA_TNAME = "GV$OB_PLAN_CACHE_REFERENCE_INFO";
const char *const OB_V_OB_PLAN_CACHE_REFERENCE_INFO_ORA_TNAME = "V$OB_PLAN_CACHE_REFERENCE_INFO";
const char *const OB_GV_SQL_WORKAREA_ORA_TNAME = "GV$SQL_WORKAREA";
const char *const OB_V_SQL_WORKAREA_ORA_TNAME = "V$SQL_WORKAREA";
const char *const OB_GV_OB_SSTABLES_ORA_TNAME = "GV$OB_SSTABLES";
const char *const OB_V_OB_SSTABLES_ORA_TNAME = "V$OB_SSTABLES";
const char *const OB_GV_OB_SERVER_SCHEMA_INFO_ORA_TNAME = "GV$OB_SERVER_SCHEMA_INFO";
const char *const OB_V_OB_SERVER_SCHEMA_INFO_ORA_TNAME = "V$OB_SERVER_SCHEMA_INFO";
const char *const OB_GV_SQL_PLAN_MONITOR_ORA_TNAME = "GV$SQL_PLAN_MONITOR";
const char *const OB_V_SQL_PLAN_MONITOR_ORA_TNAME = "V$SQL_PLAN_MONITOR";
const char *const OB_V_SQL_MONITOR_STATNAME_ORA_TNAME = "V$SQL_MONITOR_STATNAME";
const char *const OB_GV_OPEN_CURSOR_ORA_TNAME = "GV$OPEN_CURSOR";
const char *const OB_V_OPEN_CURSOR_ORA_TNAME = "V$OPEN_CURSOR";
const char *const OB_V_TIMEZONE_NAMES_ORA_TNAME = "V$TIMEZONE_NAMES";
const char *const OB_GV_GLOBAL_TRANSACTION_ORA_TNAME = "GV$GLOBAL_TRANSACTION";
const char *const OB_V_GLOBAL_TRANSACTION_ORA_TNAME = "V$GLOBAL_TRANSACTION";
const char *const OB_V_RSRC_PLAN_ORA_TNAME = "V$RSRC_PLAN";
const char *const OB_V_OB_ENCRYPTED_TABLES_ORA_TNAME = "V$OB_ENCRYPTED_TABLES";
const char *const OB_V_ENCRYPTED_TABLESPACES_ORA_TNAME = "V$ENCRYPTED_TABLESPACES";
const char *const OB_ALL_TAB_COL_STATISTICS_ORA_TNAME = "ALL_TAB_COL_STATISTICS";
const char *const OB_DBA_TAB_COL_STATISTICS_ORA_TNAME = "DBA_TAB_COL_STATISTICS";
const char *const OB_USER_TAB_COL_STATISTICS_ORA_TNAME = "USER_TAB_COL_STATISTICS";
const char *const OB_ALL_PART_COL_STATISTICS_ORA_TNAME = "ALL_PART_COL_STATISTICS";
const char *const OB_DBA_PART_COL_STATISTICS_ORA_TNAME = "DBA_PART_COL_STATISTICS";
const char *const OB_USER_PART_COL_STATISTICS_ORA_TNAME = "USER_PART_COL_STATISTICS";
const char *const OB_ALL_SUBPART_COL_STATISTICS_ORA_TNAME = "ALL_SUBPART_COL_STATISTICS";
const char *const OB_DBA_SUBPART_COL_STATISTICS_ORA_TNAME = "DBA_SUBPART_COL_STATISTICS";
const char *const OB_USER_SUBPART_COL_STATISTICS_ORA_TNAME = "USER_SUBPART_COL_STATISTICS";
const char *const OB_ALL_TAB_HISTOGRAMS_ORA_TNAME = "ALL_TAB_HISTOGRAMS";
const char *const OB_DBA_TAB_HISTOGRAMS_ORA_TNAME = "DBA_TAB_HISTOGRAMS";
const char *const OB_USER_TAB_HISTOGRAMS_ORA_TNAME = "USER_TAB_HISTOGRAMS";
const char *const OB_ALL_PART_HISTOGRAMS_ORA_TNAME = "ALL_PART_HISTOGRAMS";
const char *const OB_DBA_PART_HISTOGRAMS_ORA_TNAME = "DBA_PART_HISTOGRAMS";
const char *const OB_USER_PART_HISTOGRAMS_ORA_TNAME = "USER_PART_HISTOGRAMS";
const char *const OB_ALL_SUBPART_HISTOGRAMS_ORA_TNAME = "ALL_SUBPART_HISTOGRAMS";
const char *const OB_DBA_SUBPART_HISTOGRAMS_ORA_TNAME = "DBA_SUBPART_HISTOGRAMS";
const char *const OB_USER_SUBPART_HISTOGRAMS_ORA_TNAME = "USER_SUBPART_HISTOGRAMS";
const char *const OB_ALL_TAB_STATISTICS_ORA_TNAME = "ALL_TAB_STATISTICS";
const char *const OB_DBA_TAB_STATISTICS_ORA_TNAME = "DBA_TAB_STATISTICS";
const char *const OB_USER_TAB_STATISTICS_ORA_TNAME = "USER_TAB_STATISTICS";
const char *const OB_DBA_JOBS_TNAME = "DBA_JOBS";
const char *const OB_USER_JOBS_TNAME = "USER_JOBS";
const char *const OB_DBA_JOBS_RUNNING_TNAME = "DBA_JOBS_RUNNING";
const char *const OB_ALL_DIRECTORIES_TNAME = "ALL_DIRECTORIES";
const char *const OB_DBA_DIRECTORIES_TNAME = "DBA_DIRECTORIES";
const char *const OB_GV_OB_TENANT_MEMORY_ORA_TNAME = "GV$OB_TENANT_MEMORY";
const char *const OB_V_OB_TENANT_MEMORY_ORA_TNAME = "V$OB_TENANT_MEMORY";
const char *const OB_GV_OB_PX_TARGET_MONITOR_ORA_TNAME = "GV$OB_PX_TARGET_MONITOR";
const char *const OB_V_OB_PX_TARGET_MONITOR_ORA_TNAME = "V$OB_PX_TARGET_MONITOR";
const char *const OB_ALL_TAB_STATS_HISTORY_ORA_TNAME = "ALL_TAB_STATS_HISTORY";
const char *const OB_DBA_TAB_STATS_HISTORY_ORA_TNAME = "DBA_TAB_STATS_HISTORY";
const char *const OB_USER_TAB_STATS_HISTORY_ORA_TNAME = "USER_TAB_STATS_HISTORY";
const char *const OB_GV_DBLINK_TNAME = "GV$DBLINK";
const char *const OB_V_DBLINK_TNAME = "V$DBLINK";
const char *const OB_DBA_SCHEDULER_JOBS_ORA_TNAME = "DBA_SCHEDULER_JOBS";
const char *const OB_DBA_SCHEDULER_PROGRAM_TNAME = "DBA_SCHEDULER_PROGRAM";
const char *const OB_DBA_CONTEXT_TNAME = "DBA_CONTEXT";
const char *const OB_V_GLOBALCONTEXT_TNAME = "V$GLOBALCONTEXT";
const char *const OB_GV_OB_UNITS_ORA_TNAME = "GV$OB_UNITS";
const char *const OB_V_OB_UNITS_ORA_TNAME = "V$OB_UNITS";
const char *const OB_GV_OB_PARAMETERS_ORA_TNAME = "GV$OB_PARAMETERS";
const char *const OB_V_OB_PARAMETERS_ORA_TNAME = "V$OB_PARAMETERS";
const char *const OB_GV_OB_PROCESSLIST_ORA_TNAME = "GV$OB_PROCESSLIST";
const char *const OB_V_OB_PROCESSLIST_ORA_TNAME = "V$OB_PROCESSLIST";
const char *const OB_GV_OB_KVCACHE_ORA_TNAME = "GV$OB_KVCACHE";
const char *const OB_V_OB_KVCACHE_ORA_TNAME = "V$OB_KVCACHE";
const char *const OB_GV_OB_TRANSACTION_PARTICIPANTS_ORA_TNAME = "GV$OB_TRANSACTION_PARTICIPANTS";
const char *const OB_V_OB_TRANSACTION_PARTICIPANTS_ORA_TNAME = "V$OB_TRANSACTION_PARTICIPANTS";
const char *const OB_GV_OB_COMPACTION_PROGRESS_ORA_TNAME = "GV$OB_COMPACTION_PROGRESS";
const char *const OB_V_OB_COMPACTION_PROGRESS_ORA_TNAME = "V$OB_COMPACTION_PROGRESS";
const char *const OB_GV_OB_TABLET_COMPACTION_PROGRESS_ORA_TNAME = "GV$OB_TABLET_COMPACTION_PROGRESS";
const char *const OB_V_OB_TABLET_COMPACTION_PROGRESS_ORA_TNAME = "V$OB_TABLET_COMPACTION_PROGRESS";
const char *const OB_GV_OB_TABLET_COMPACTION_HISTORY_ORA_TNAME = "GV$OB_TABLET_COMPACTION_HISTORY";
const char *const OB_V_OB_TABLET_COMPACTION_HISTORY_ORA_TNAME = "V$OB_TABLET_COMPACTION_HISTORY";
const char *const OB_GV_OB_COMPACTION_DIAGNOSE_INFO_ORA_TNAME = "GV$OB_COMPACTION_DIAGNOSE_INFO";
const char *const OB_V_OB_COMPACTION_DIAGNOSE_INFO_ORA_TNAME = "V$OB_COMPACTION_DIAGNOSE_INFO";
const char *const OB_GV_OB_COMPACTION_SUGGESTIONS_ORA_TNAME = "GV$OB_COMPACTION_SUGGESTIONS";
const char *const OB_V_OB_COMPACTION_SUGGESTIONS_ORA_TNAME = "V$OB_COMPACTION_SUGGESTIONS";
const char *const OB_GV_OB_DTL_INTERM_RESULT_MONITOR_ORA_TNAME = "GV$OB_DTL_INTERM_RESULT_MONITOR";
const char *const OB_V_OB_DTL_INTERM_RESULT_MONITOR_ORA_TNAME = "V$OB_DTL_INTERM_RESULT_MONITOR";
const char *const OB_DBA_SQL_PLAN_BASELINES_ORA_TNAME = "DBA_SQL_PLAN_BASELINES";
const char *const OB_DBA_SQL_MANAGEMENT_CONFIG_ORA_TNAME = "DBA_SQL_MANAGEMENT_CONFIG";
const char *const OB_V_EVENT_NAME_ORA_TNAME = "V$EVENT_NAME";
const char *const OB_GV_ACTIVE_SESSION_HISTORY_ORA_TNAME = "GV$ACTIVE_SESSION_HISTORY";
const char *const OB_V_ACTIVE_SESSION_HISTORY_ORA_TNAME = "V$ACTIVE_SESSION_HISTORY";
const char *const OB_GV_DML_STATS_ORA_TNAME = "GV$DML_STATS";
const char *const OB_V_DML_STATS_ORA_TNAME = "V$DML_STATS";
const char *const OB_DBA_OB_OUTLINE_CONCURRENT_HISTORY_ORA_TNAME = "DBA_OB_OUTLINE_CONCURRENT_HISTORY";
const char *const OB_DBA_OB_OUTLINES_ORA_TNAME = "DBA_OB_OUTLINES";
const char *const OB_DBA_OB_CONCURRENT_LIMIT_SQL_ORA_TNAME = "DBA_OB_CONCURRENT_LIMIT_SQL";
const char *const OB_DBA_OB_DEADLOCK_EVENT_HISTORY_ORA_TNAME = "DBA_OB_DEADLOCK_EVENT_HISTORY";
const char *const OB_GV_OB_LOG_STAT_ORA_TNAME = "GV$OB_LOG_STAT";
const char *const OB_V_OB_LOG_STAT_ORA_TNAME = "V$OB_LOG_STAT";
const char *const OB_GV_OB_GLOBAL_TRANSACTION_ORA_TNAME = "GV$OB_GLOBAL_TRANSACTION";
const char *const OB_V_OB_GLOBAL_TRANSACTION_ORA_TNAME = "V$OB_GLOBAL_TRANSACTION";
const char *const OB_DBA_OB_LS_ORA_TNAME = "DBA_OB_LS";
const char *const OB_DBA_OB_TABLE_LOCATIONS_ORA_TNAME = "DBA_OB_TABLE_LOCATIONS";
const char *const OB_ALL_TRIGGER_ORDERING_TNAME = "ALL_TRIGGER_ORDERING";
const char *const OB_DBA_TRIGGER_ORDERING_TNAME = "DBA_TRIGGER_ORDERING";
const char *const OB_USER_TRIGGER_ORDERING_TNAME = "USER_TRIGGER_ORDERING";
const char *const OB_GV_OB_TRANSACTION_SCHEDULERS_ORA_TNAME = "GV$OB_TRANSACTION_SCHEDULERS";
const char *const OB_V_OB_TRANSACTION_SCHEDULERS_ORA_TNAME = "V$OB_TRANSACTION_SCHEDULERS";
const char *const OB_DBA_OB_USER_DEFINED_RULES_ORA_TNAME = "DBA_OB_USER_DEFINED_RULES";
const char *const OB_GV_OB_SQL_PLAN_ORA_TNAME = "GV$OB_SQL_PLAN";
const char *const OB_V_OB_SQL_PLAN_ORA_TNAME = "V$OB_SQL_PLAN";
const char *const OB_V_OB_ARCHIVE_DEST_STATUS_ORA_TNAME = "V$OB_ARCHIVE_DEST_STATUS";
const char *const OB_DBA_OB_LS_LOG_ARCHIVE_PROGRESS_ORA_TNAME = "DBA_OB_LS_LOG_ARCHIVE_PROGRESS";
const char *const OB_GV_OB_LOCKS_ORA_TNAME = "GV$OB_LOCKS";
const char *const OB_V_OB_LOCKS_ORA_TNAME = "V$OB_LOCKS";
const char *const OB_DBA_OB_ACCESS_POINT_ORA_TNAME = "DBA_OB_ACCESS_POINT";
const char *const OB_DBA_OB_DATA_DICTIONARY_IN_LOG_ORA_TNAME = "DBA_OB_DATA_DICTIONARY_IN_LOG";
const char *const OB_GV_OB_OPT_STAT_GATHER_MONITOR_ORA_TNAME = "GV$OB_OPT_STAT_GATHER_MONITOR";
const char *const OB_V_OB_OPT_STAT_GATHER_MONITOR_ORA_TNAME = "V$OB_OPT_STAT_GATHER_MONITOR";
const char *const OB_GV_SESSION_LONGOPS_ORA_TNAME = "GV$SESSION_LONGOPS";
const char *const OB_V_SESSION_LONGOPS_ORA_TNAME = "V$SESSION_LONGOPS";
const char *const OB_GV_OB_THREAD_ORA_TNAME = "GV$OB_THREAD";
const char *const OB_V_OB_THREAD_ORA_TNAME = "V$OB_THREAD";
const char *const OB_GV_OB_ARBITRATION_MEMBER_INFO_ORA_TNAME = "GV$OB_ARBITRATION_MEMBER_INFO";
const char *const OB_V_OB_ARBITRATION_MEMBER_INFO_ORA_TNAME = "V$OB_ARBITRATION_MEMBER_INFO";
const char *const OB_GV_OB_ARBITRATION_SERVICE_STATUS_ORA_TNAME = "GV$OB_ARBITRATION_SERVICE_STATUS";
const char *const OB_V_OB_ARBITRATION_SERVICE_STATUS_ORA_TNAME = "V$OB_ARBITRATION_SERVICE_STATUS";
const char *const OB_V_OB_TIMESTAMP_SERVICE_ORA_TNAME = "V$OB_TIMESTAMP_SERVICE";
const char *const OB_V_OB_LS_LOG_RESTORE_STATUS_ORA_TNAME = "V$OB_LS_LOG_RESTORE_STATUS";
const char *const OB_GV_OB_FLT_TRACE_CONFIG_ORA_TNAME = "GV$OB_FLT_TRACE_CONFIG";
const char *const OB_GV_OB_SESSION_ORA_TNAME = "GV$OB_SESSION";
const char *const OB_V_OB_SESSION_ORA_TNAME = "V$OB_SESSION";
const char *const OB_GV_OB_PL_CACHE_OBJECT_ORA_TNAME = "GV$OB_PL_CACHE_OBJECT";
const char *const OB_V_OB_PL_CACHE_OBJECT_ORA_TNAME = "V$OB_PL_CACHE_OBJECT";
const char *const OB_GV_OB_CGROUP_CONFIG_ORA_TNAME = "GV$OB_CGROUP_CONFIG";
const char *const OB_V_OB_CGROUP_CONFIG_ORA_TNAME = "V$OB_CGROUP_CONFIG";
const char *const OB_GV_OB_SQLSTAT_ORA_TNAME = "GV$OB_SQLSTAT";
const char *const OB_V_OB_SQLSTAT_ORA_TNAME = "V$OB_SQLSTAT";
const char *const OB_GV_OB_SESS_TIME_MODEL_ORA_TNAME = "GV$OB_SESS_TIME_MODEL";
const char *const OB_V_OB_SESS_TIME_MODEL_ORA_TNAME = "V$OB_SESS_TIME_MODEL";
const char *const OB_GV_OB_SYS_TIME_MODEL_ORA_TNAME = "GV$OB_SYS_TIME_MODEL";
const char *const OB_V_OB_SYS_TIME_MODEL_ORA_TNAME = "V$OB_SYS_TIME_MODEL";
const char *const OB_V_STATNAME_ORA_TNAME = "V$STATNAME";
const char *const OB_DBA_OB_AUX_STATISTICS_ORA_TNAME = "DBA_OB_AUX_STATISTICS";
const char *const OB_DBA_OB_SYS_VARIABLES_ORA_TNAME = "DBA_OB_SYS_VARIABLES";
const char *const OB_GV_OB_ACTIVE_SESSION_HISTORY_ORA_TNAME = "GV$OB_ACTIVE_SESSION_HISTORY";
const char *const OB_V_OB_ACTIVE_SESSION_HISTORY_ORA_TNAME = "V$OB_ACTIVE_SESSION_HISTORY";
const char *const OB_DBA_INDEX_USAGE_ORA_TNAME = "DBA_INDEX_USAGE";
const char *const OB_GV_OB_LS_SNAPSHOTS_ORA_TNAME = "GV$OB_LS_SNAPSHOTS";
const char *const OB_V_OB_LS_SNAPSHOTS_ORA_TNAME = "V$OB_LS_SNAPSHOTS";
const char *const OB_GV_OB_SHARED_STORAGE_QUOTA_ORA_TNAME = "GV$OB_SHARED_STORAGE_QUOTA";
const char *const OB_V_OB_SHARED_STORAGE_QUOTA_ORA_TNAME = "V$OB_SHARED_STORAGE_QUOTA";
const char *const OB_GV_OB_SESSION_PS_INFO_ORA_TNAME = "GV$OB_SESSION_PS_INFO";
const char *const OB_V_OB_SESSION_PS_INFO_ORA_TNAME = "V$OB_SESSION_PS_INFO";
const char *const OB_GV_OB_TRACEPOINT_INFO_ORA_TNAME = "GV$OB_TRACEPOINT_INFO";
const char *const OB_V_OB_TRACEPOINT_INFO_ORA_TNAME = "V$OB_TRACEPOINT_INFO";
const char *const OB_DBA_OB_RSRC_DIRECTIVES_ORA_TNAME = "DBA_OB_RSRC_DIRECTIVES";
const char *const OB_GV_OB_TENANT_RESOURCE_LIMIT_ORA_TNAME = "GV$OB_TENANT_RESOURCE_LIMIT";
const char *const OB_V_OB_TENANT_RESOURCE_LIMIT_ORA_TNAME = "V$OB_TENANT_RESOURCE_LIMIT";
const char *const OB_GV_OB_TENANT_RESOURCE_LIMIT_DETAIL_ORA_TNAME = "GV$OB_TENANT_RESOURCE_LIMIT_DETAIL";
const char *const OB_V_OB_TENANT_RESOURCE_LIMIT_DETAIL_ORA_TNAME = "V$OB_TENANT_RESOURCE_LIMIT_DETAIL";
const char *const OB_V_OB_GROUP_IO_STAT_ORA_TNAME = "V$OB_GROUP_IO_STAT";
const char *const OB_GV_OB_GROUP_IO_STAT_ORA_TNAME = "GV$OB_GROUP_IO_STAT";
const char *const OB_GV_OB_NIC_INFO_ORA_TNAME = "GV$OB_NIC_INFO";
const char *const OB_V_OB_NIC_INFO_ORA_TNAME = "V$OB_NIC_INFO";
const char *const OB_GV_OB_QUERY_RESPONSE_TIME_HISTOGRAM_ORA_TNAME = "GV$OB_QUERY_RESPONSE_TIME_HISTOGRAM";
const char *const OB_V_OB_QUERY_RESPONSE_TIME_HISTOGRAM_ORA_TNAME = "V$OB_QUERY_RESPONSE_TIME_HISTOGRAM";
const char *const OB_DBA_OB_SPATIAL_COLUMNS_ORA_TNAME = "DBA_OB_SPATIAL_COLUMNS";
const char *const OB_DBA_OB_TABLE_SPACE_USAGE_ORA_TNAME = "DBA_OB_TABLE_SPACE_USAGE";
const char *const OB_GV_OB_LOG_TRANSPORT_DEST_STAT_ORA_TNAME = "GV$OB_LOG_TRANSPORT_DEST_STAT";
const char *const OB_V_OB_LOG_TRANSPORT_DEST_STAT_ORA_TNAME = "V$OB_LOG_TRANSPORT_DEST_STAT";
const char *const OB_GV_OB_SS_LOCAL_CACHE_ORA_TNAME = "GV$OB_SS_LOCAL_CACHE";
const char *const OB_V_OB_SS_LOCAL_CACHE_ORA_TNAME = "V$OB_SS_LOCAL_CACHE";
const char *const OB_ALL_PLSQL_TYPES_TNAME = "ALL_PLSQL_TYPES";
const char *const OB_DBA_PLSQL_TYPES_TNAME = "DBA_PLSQL_TYPES";
const char *const OB_USER_PLSQL_TYPES_TNAME = "USER_PLSQL_TYPES";
const char *const OB_ALL_PLSQL_COLL_TYPES_TNAME = "ALL_PLSQL_COLL_TYPES";
const char *const OB_DBA_PLSQL_COLL_TYPES_TNAME = "DBA_PLSQL_COLL_TYPES";
const char *const OB_USER_PLSQL_COLL_TYPES_TNAME = "USER_PLSQL_COLL_TYPES";
const char *const OB_ALL_PLSQL_TYPE_ATTRS_TNAME = "ALL_PLSQL_TYPE_ATTRS";
const char *const OB_DBA_PLSQL_TYPE_ATTRS_TNAME = "DBA_PLSQL_TYPE_ATTRS";
const char *const OB_USER_PLSQL_TYPE_ATTRS_TNAME = "USER_PLSQL_TYPE_ATTRS";
const char *const OB_GV_OB_RES_MGR_SYSSTAT_ORA_TNAME = "GV$OB_RES_MGR_SYSSTAT";
const char *const OB_V_OB_RES_MGR_SYSSTAT_ORA_TNAME = "V$OB_RES_MGR_SYSSTAT";
const char *const OB_DBA_WR_SQL_PLAN_ORA_TNAME = "DBA_WR_SQL_PLAN";
const char *const OB_DBA_OB_SPM_EVO_RESULT_ORA_TNAME = "DBA_OB_SPM_EVO_RESULT";
const char *const OB_GV_OB_FUNCTION_IO_STAT_ORA_TNAME = "GV$OB_FUNCTION_IO_STAT";
const char *const OB_V_OB_FUNCTION_IO_STAT_ORA_TNAME = "V$OB_FUNCTION_IO_STAT";
const char *const OB_DBA_OB_TEMP_FILES_ORA_TNAME = "DBA_OB_TEMP_FILES";
const char *const OB_DBA_OB_CS_REPLICA_STATS_ORA_TNAME = "DBA_OB_CS_REPLICA_STATS";
const char *const OB_ALL_TABLE_AUX_LOB_META_TNAME = "__all_table_aux_lob_meta";
const char *const OB_ALL_COLUMN_AUX_LOB_META_TNAME = "__all_column_aux_lob_meta";
const char *const OB_ALL_DDL_OPERATION_AUX_LOB_META_TNAME = "__all_ddl_operation_aux_lob_meta";
const char *const OB_ALL_USER_AUX_LOB_META_TNAME = "__all_user_aux_lob_meta";
const char *const OB_ALL_USER_HISTORY_AUX_LOB_META_TNAME = "__all_user_history_aux_lob_meta";
const char *const OB_ALL_DATABASE_AUX_LOB_META_TNAME = "__all_database_aux_lob_meta";
const char *const OB_ALL_DATABASE_HISTORY_AUX_LOB_META_TNAME = "__all_database_history_aux_lob_meta";
const char *const OB_ALL_TABLEGROUP_AUX_LOB_META_TNAME = "__all_tablegroup_aux_lob_meta";
const char *const OB_ALL_TABLEGROUP_HISTORY_AUX_LOB_META_TNAME = "__all_tablegroup_history_aux_lob_meta";
const char *const OB_ALL_TENANT_AUX_LOB_META_TNAME = "__all_tenant_aux_lob_meta";
const char *const OB_ALL_TENANT_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_history_aux_lob_meta";
const char *const OB_ALL_TABLE_PRIVILEGE_AUX_LOB_META_TNAME = "__all_table_privilege_aux_lob_meta";
const char *const OB_ALL_TABLE_PRIVILEGE_HISTORY_AUX_LOB_META_TNAME = "__all_table_privilege_history_aux_lob_meta";
const char *const OB_ALL_DATABASE_PRIVILEGE_AUX_LOB_META_TNAME = "__all_database_privilege_aux_lob_meta";
const char *const OB_ALL_DATABASE_PRIVILEGE_HISTORY_AUX_LOB_META_TNAME = "__all_database_privilege_history_aux_lob_meta";
const char *const OB_ALL_TABLE_HISTORY_AUX_LOB_META_TNAME = "__all_table_history_aux_lob_meta";
const char *const OB_ALL_COLUMN_HISTORY_AUX_LOB_META_TNAME = "__all_column_history_aux_lob_meta";
const char *const OB_ALL_ZONE_AUX_LOB_META_TNAME = "__all_zone_aux_lob_meta";
const char *const OB_ALL_SERVER_AUX_LOB_META_TNAME = "__all_server_aux_lob_meta";
const char *const OB_ALL_SYS_PARAMETER_AUX_LOB_META_TNAME = "__all_sys_parameter_aux_lob_meta";
const char *const OB_TENANT_PARAMETER_AUX_LOB_META_TNAME = "__tenant_parameter_aux_lob_meta";
const char *const OB_ALL_SYS_VARIABLE_AUX_LOB_META_TNAME = "__all_sys_variable_aux_lob_meta";
const char *const OB_ALL_SYS_STAT_AUX_LOB_META_TNAME = "__all_sys_stat_aux_lob_meta";
const char *const OB_ALL_UNIT_AUX_LOB_META_TNAME = "__all_unit_aux_lob_meta";
const char *const OB_ALL_UNIT_CONFIG_AUX_LOB_META_TNAME = "__all_unit_config_aux_lob_meta";
const char *const OB_ALL_RESOURCE_POOL_AUX_LOB_META_TNAME = "__all_resource_pool_aux_lob_meta";
const char *const OB_ALL_CHARSET_AUX_LOB_META_TNAME = "__all_charset_aux_lob_meta";
const char *const OB_ALL_COLLATION_AUX_LOB_META_TNAME = "__all_collation_aux_lob_meta";
const char *const OB_HELP_TOPIC_AUX_LOB_META_TNAME = "help_topic_aux_lob_meta";
const char *const OB_HELP_CATEGORY_AUX_LOB_META_TNAME = "help_category_aux_lob_meta";
const char *const OB_HELP_KEYWORD_AUX_LOB_META_TNAME = "help_keyword_aux_lob_meta";
const char *const OB_HELP_RELATION_AUX_LOB_META_TNAME = "help_relation_aux_lob_meta";
const char *const OB_ALL_DUMMY_AUX_LOB_META_TNAME = "__all_dummy_aux_lob_meta";
const char *const OB_ALL_ROOTSERVICE_EVENT_HISTORY_AUX_LOB_META_TNAME = "__all_rootservice_event_history_aux_lob_meta";
const char *const OB_ALL_PRIVILEGE_AUX_LOB_META_TNAME = "__all_privilege_aux_lob_meta";
const char *const OB_ALL_OUTLINE_AUX_LOB_META_TNAME = "__all_outline_aux_lob_meta";
const char *const OB_ALL_OUTLINE_HISTORY_AUX_LOB_META_TNAME = "__all_outline_history_aux_lob_meta";
const char *const OB_ALL_RECYCLEBIN_AUX_LOB_META_TNAME = "__all_recyclebin_aux_lob_meta";
const char *const OB_ALL_PART_AUX_LOB_META_TNAME = "__all_part_aux_lob_meta";
const char *const OB_ALL_PART_HISTORY_AUX_LOB_META_TNAME = "__all_part_history_aux_lob_meta";
const char *const OB_ALL_SUB_PART_AUX_LOB_META_TNAME = "__all_sub_part_aux_lob_meta";
const char *const OB_ALL_SUB_PART_HISTORY_AUX_LOB_META_TNAME = "__all_sub_part_history_aux_lob_meta";
const char *const OB_ALL_PART_INFO_AUX_LOB_META_TNAME = "__all_part_info_aux_lob_meta";
const char *const OB_ALL_PART_INFO_HISTORY_AUX_LOB_META_TNAME = "__all_part_info_history_aux_lob_meta";
const char *const OB_ALL_DEF_SUB_PART_AUX_LOB_META_TNAME = "__all_def_sub_part_aux_lob_meta";
const char *const OB_ALL_DEF_SUB_PART_HISTORY_AUX_LOB_META_TNAME = "__all_def_sub_part_history_aux_lob_meta";
const char *const OB_ALL_SERVER_EVENT_HISTORY_AUX_LOB_META_TNAME = "__all_server_event_history_aux_lob_meta";
const char *const OB_ALL_ROOTSERVICE_JOB_AUX_LOB_META_TNAME = "__all_rootservice_job_aux_lob_meta";
const char *const OB_ALL_SYS_VARIABLE_HISTORY_AUX_LOB_META_TNAME = "__all_sys_variable_history_aux_lob_meta";
const char *const OB_ALL_RESTORE_JOB_AUX_LOB_META_TNAME = "__all_restore_job_aux_lob_meta";
const char *const OB_ALL_RESTORE_JOB_HISTORY_AUX_LOB_META_TNAME = "__all_restore_job_history_aux_lob_meta";
const char *const OB_ALL_DDL_ID_AUX_LOB_META_TNAME = "__all_ddl_id_aux_lob_meta";
const char *const OB_ALL_FOREIGN_KEY_AUX_LOB_META_TNAME = "__all_foreign_key_aux_lob_meta";
const char *const OB_ALL_FOREIGN_KEY_HISTORY_AUX_LOB_META_TNAME = "__all_foreign_key_history_aux_lob_meta";
const char *const OB_ALL_FOREIGN_KEY_COLUMN_AUX_LOB_META_TNAME = "__all_foreign_key_column_aux_lob_meta";
const char *const OB_ALL_FOREIGN_KEY_COLUMN_HISTORY_AUX_LOB_META_TNAME = "__all_foreign_key_column_history_aux_lob_meta";
const char *const OB_ALL_SYNONYM_AUX_LOB_META_TNAME = "__all_synonym_aux_lob_meta";
const char *const OB_ALL_SYNONYM_HISTORY_AUX_LOB_META_TNAME = "__all_synonym_history_aux_lob_meta";
const char *const OB_ALL_AUTO_INCREMENT_AUX_LOB_META_TNAME = "__all_auto_increment_aux_lob_meta";
const char *const OB_ALL_DDL_CHECKSUM_AUX_LOB_META_TNAME = "__all_ddl_checksum_aux_lob_meta";
const char *const OB_ALL_ROUTINE_AUX_LOB_META_TNAME = "__all_routine_aux_lob_meta";
const char *const OB_ALL_ROUTINE_HISTORY_AUX_LOB_META_TNAME = "__all_routine_history_aux_lob_meta";
const char *const OB_ALL_ROUTINE_PARAM_AUX_LOB_META_TNAME = "__all_routine_param_aux_lob_meta";
const char *const OB_ALL_ROUTINE_PARAM_HISTORY_AUX_LOB_META_TNAME = "__all_routine_param_history_aux_lob_meta";
const char *const OB_ALL_PACKAGE_AUX_LOB_META_TNAME = "__all_package_aux_lob_meta";
const char *const OB_ALL_PACKAGE_HISTORY_AUX_LOB_META_TNAME = "__all_package_history_aux_lob_meta";
const char *const OB_ALL_ACQUIRED_SNAPSHOT_AUX_LOB_META_TNAME = "__all_acquired_snapshot_aux_lob_meta";
const char *const OB_ALL_CONSTRAINT_AUX_LOB_META_TNAME = "__all_constraint_aux_lob_meta";
const char *const OB_ALL_CONSTRAINT_HISTORY_AUX_LOB_META_TNAME = "__all_constraint_history_aux_lob_meta";
const char *const OB_ALL_ORI_SCHEMA_VERSION_AUX_LOB_META_TNAME = "__all_ori_schema_version_aux_lob_meta";
const char *const OB_ALL_FUNC_AUX_LOB_META_TNAME = "__all_func_aux_lob_meta";
const char *const OB_ALL_FUNC_HISTORY_AUX_LOB_META_TNAME = "__all_func_history_aux_lob_meta";
const char *const OB_ALL_TEMP_TABLE_AUX_LOB_META_TNAME = "__all_temp_table_aux_lob_meta";
const char *const OB_ALL_SEQUENCE_OBJECT_AUX_LOB_META_TNAME = "__all_sequence_object_aux_lob_meta";
const char *const OB_ALL_SEQUENCE_OBJECT_HISTORY_AUX_LOB_META_TNAME = "__all_sequence_object_history_aux_lob_meta";
const char *const OB_ALL_SEQUENCE_VALUE_AUX_LOB_META_TNAME = "__all_sequence_value_aux_lob_meta";
const char *const OB_ALL_FREEZE_SCHEMA_VERSION_AUX_LOB_META_TNAME = "__all_freeze_schema_version_aux_lob_meta";
const char *const OB_ALL_TYPE_AUX_LOB_META_TNAME = "__all_type_aux_lob_meta";
const char *const OB_ALL_TYPE_HISTORY_AUX_LOB_META_TNAME = "__all_type_history_aux_lob_meta";
const char *const OB_ALL_TYPE_ATTR_AUX_LOB_META_TNAME = "__all_type_attr_aux_lob_meta";
const char *const OB_ALL_TYPE_ATTR_HISTORY_AUX_LOB_META_TNAME = "__all_type_attr_history_aux_lob_meta";
const char *const OB_ALL_COLL_TYPE_AUX_LOB_META_TNAME = "__all_coll_type_aux_lob_meta";
const char *const OB_ALL_COLL_TYPE_HISTORY_AUX_LOB_META_TNAME = "__all_coll_type_history_aux_lob_meta";
const char *const OB_ALL_WEAK_READ_SERVICE_AUX_LOB_META_TNAME = "__all_weak_read_service_aux_lob_meta";
const char *const OB_ALL_DBLINK_AUX_LOB_META_TNAME = "__all_dblink_aux_lob_meta";
const char *const OB_ALL_DBLINK_HISTORY_AUX_LOB_META_TNAME = "__all_dblink_history_aux_lob_meta";
const char *const OB_ALL_TENANT_ROLE_GRANTEE_MAP_AUX_LOB_META_TNAME = "__all_tenant_role_grantee_map_aux_lob_meta";
const char *const OB_ALL_TENANT_ROLE_GRANTEE_MAP_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_role_grantee_map_history_aux_lob_meta";
const char *const OB_ALL_TENANT_KEYSTORE_AUX_LOB_META_TNAME = "__all_tenant_keystore_aux_lob_meta";
const char *const OB_ALL_TENANT_KEYSTORE_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_keystore_history_aux_lob_meta";
const char *const OB_ALL_TENANT_OLS_POLICY_AUX_LOB_META_TNAME = "__all_tenant_ols_policy_aux_lob_meta";
const char *const OB_ALL_TENANT_OLS_POLICY_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_ols_policy_history_aux_lob_meta";
const char *const OB_ALL_TENANT_OLS_COMPONENT_AUX_LOB_META_TNAME = "__all_tenant_ols_component_aux_lob_meta";
const char *const OB_ALL_TENANT_OLS_COMPONENT_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_ols_component_history_aux_lob_meta";
const char *const OB_ALL_TENANT_OLS_LABEL_AUX_LOB_META_TNAME = "__all_tenant_ols_label_aux_lob_meta";
const char *const OB_ALL_TENANT_OLS_LABEL_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_ols_label_history_aux_lob_meta";
const char *const OB_ALL_TENANT_OLS_USER_LEVEL_AUX_LOB_META_TNAME = "__all_tenant_ols_user_level_aux_lob_meta";
const char *const OB_ALL_TENANT_OLS_USER_LEVEL_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_ols_user_level_history_aux_lob_meta";
const char *const OB_ALL_TENANT_TABLESPACE_AUX_LOB_META_TNAME = "__all_tenant_tablespace_aux_lob_meta";
const char *const OB_ALL_TENANT_TABLESPACE_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_tablespace_history_aux_lob_meta";
const char *const OB_ALL_TENANT_USER_FAILED_LOGIN_STAT_AUX_LOB_META_TNAME = "__all_tenant_user_failed_login_stat_aux_lob_meta";
const char *const OB_ALL_TENANT_PROFILE_AUX_LOB_META_TNAME = "__all_tenant_profile_aux_lob_meta";
const char *const OB_ALL_TENANT_PROFILE_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_profile_history_aux_lob_meta";
const char *const OB_ALL_TENANT_SECURITY_AUDIT_AUX_LOB_META_TNAME = "__all_tenant_security_audit_aux_lob_meta";
const char *const OB_ALL_TENANT_SECURITY_AUDIT_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_security_audit_history_aux_lob_meta";
const char *const OB_ALL_TENANT_TRIGGER_AUX_LOB_META_TNAME = "__all_tenant_trigger_aux_lob_meta";
const char *const OB_ALL_TENANT_TRIGGER_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_trigger_history_aux_lob_meta";
const char *const OB_ALL_SEED_PARAMETER_AUX_LOB_META_TNAME = "__all_seed_parameter_aux_lob_meta";
const char *const OB_ALL_TENANT_SECURITY_AUDIT_RECORD_AUX_LOB_META_TNAME = "__all_tenant_security_audit_record_aux_lob_meta";
const char *const OB_ALL_TENANT_SYSAUTH_AUX_LOB_META_TNAME = "__all_tenant_sysauth_aux_lob_meta";
const char *const OB_ALL_TENANT_SYSAUTH_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_sysauth_history_aux_lob_meta";
const char *const OB_ALL_TENANT_OBJAUTH_AUX_LOB_META_TNAME = "__all_tenant_objauth_aux_lob_meta";
const char *const OB_ALL_TENANT_OBJAUTH_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_objauth_history_aux_lob_meta";
const char *const OB_ALL_RESTORE_INFO_AUX_LOB_META_TNAME = "__all_restore_info_aux_lob_meta";
const char *const OB_ALL_TENANT_ERROR_AUX_LOB_META_TNAME = "__all_tenant_error_aux_lob_meta";
const char *const OB_ALL_RESTORE_PROGRESS_AUX_LOB_META_TNAME = "__all_restore_progress_aux_lob_meta";
const char *const OB_ALL_TENANT_OBJECT_TYPE_AUX_LOB_META_TNAME = "__all_tenant_object_type_aux_lob_meta";
const char *const OB_ALL_TENANT_OBJECT_TYPE_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_object_type_history_aux_lob_meta";
const char *const OB_ALL_TENANT_TIME_ZONE_AUX_LOB_META_TNAME = "__all_tenant_time_zone_aux_lob_meta";
const char *const OB_ALL_TENANT_TIME_ZONE_NAME_AUX_LOB_META_TNAME = "__all_tenant_time_zone_name_aux_lob_meta";
const char *const OB_ALL_TENANT_TIME_ZONE_TRANSITION_AUX_LOB_META_TNAME = "__all_tenant_time_zone_transition_aux_lob_meta";
const char *const OB_ALL_TENANT_TIME_ZONE_TRANSITION_TYPE_AUX_LOB_META_TNAME = "__all_tenant_time_zone_transition_type_aux_lob_meta";
const char *const OB_ALL_TENANT_CONSTRAINT_COLUMN_AUX_LOB_META_TNAME = "__all_tenant_constraint_column_aux_lob_meta";
const char *const OB_ALL_TENANT_CONSTRAINT_COLUMN_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_constraint_column_history_aux_lob_meta";
const char *const OB_ALL_TENANT_GLOBAL_TRANSACTION_AUX_LOB_META_TNAME = "__all_tenant_global_transaction_aux_lob_meta";
const char *const OB_ALL_TENANT_DEPENDENCY_AUX_LOB_META_TNAME = "__all_tenant_dependency_aux_lob_meta";
const char *const OB_ALL_RES_MGR_PLAN_AUX_LOB_META_TNAME = "__all_res_mgr_plan_aux_lob_meta";
const char *const OB_ALL_RES_MGR_DIRECTIVE_AUX_LOB_META_TNAME = "__all_res_mgr_directive_aux_lob_meta";
const char *const OB_ALL_RES_MGR_MAPPING_RULE_AUX_LOB_META_TNAME = "__all_res_mgr_mapping_rule_aux_lob_meta";
const char *const OB_ALL_DDL_ERROR_MESSAGE_AUX_LOB_META_TNAME = "__all_ddl_error_message_aux_lob_meta";
const char *const OB_ALL_SPACE_USAGE_AUX_LOB_META_TNAME = "__all_space_usage_aux_lob_meta";
const char *const OB_ALL_BACKUP_SET_FILES_AUX_LOB_META_TNAME = "__all_backup_set_files_aux_lob_meta";
const char *const OB_ALL_RES_MGR_CONSUMER_GROUP_AUX_LOB_META_TNAME = "__all_res_mgr_consumer_group_aux_lob_meta";
const char *const OB_ALL_BACKUP_INFO_AUX_LOB_META_TNAME = "__all_backup_info_aux_lob_meta";
const char *const OB_ALL_DDL_TASK_STATUS_AUX_LOB_META_TNAME = "__all_ddl_task_status_aux_lob_meta";
const char *const OB_ALL_REGION_NETWORK_BANDWIDTH_LIMIT_AUX_LOB_META_TNAME = "__all_region_network_bandwidth_limit_aux_lob_meta";
const char *const OB_ALL_DEADLOCK_EVENT_HISTORY_AUX_LOB_META_TNAME = "__all_deadlock_event_history_aux_lob_meta";
const char *const OB_ALL_COLUMN_USAGE_AUX_LOB_META_TNAME = "__all_column_usage_aux_lob_meta";
const char *const OB_ALL_JOB_AUX_LOB_META_TNAME = "__all_job_aux_lob_meta";
const char *const OB_ALL_JOB_LOG_AUX_LOB_META_TNAME = "__all_job_log_aux_lob_meta";
const char *const OB_ALL_TENANT_DIRECTORY_AUX_LOB_META_TNAME = "__all_tenant_directory_aux_lob_meta";
const char *const OB_ALL_TENANT_DIRECTORY_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_directory_history_aux_lob_meta";
const char *const OB_ALL_TABLE_STAT_AUX_LOB_META_TNAME = "__all_table_stat_aux_lob_meta";
const char *const OB_ALL_COLUMN_STAT_AUX_LOB_META_TNAME = "__all_column_stat_aux_lob_meta";
const char *const OB_ALL_HISTOGRAM_STAT_AUX_LOB_META_TNAME = "__all_histogram_stat_aux_lob_meta";
const char *const OB_ALL_MONITOR_MODIFIED_AUX_LOB_META_TNAME = "__all_monitor_modified_aux_lob_meta";
const char *const OB_ALL_TABLE_STAT_HISTORY_AUX_LOB_META_TNAME = "__all_table_stat_history_aux_lob_meta";
const char *const OB_ALL_COLUMN_STAT_HISTORY_AUX_LOB_META_TNAME = "__all_column_stat_history_aux_lob_meta";
const char *const OB_ALL_HISTOGRAM_STAT_HISTORY_AUX_LOB_META_TNAME = "__all_histogram_stat_history_aux_lob_meta";
const char *const OB_ALL_OPTSTAT_GLOBAL_PREFS_AUX_LOB_META_TNAME = "__all_optstat_global_prefs_aux_lob_meta";
const char *const OB_ALL_OPTSTAT_USER_PREFS_AUX_LOB_META_TNAME = "__all_optstat_user_prefs_aux_lob_meta";
const char *const OB_ALL_LS_META_TABLE_AUX_LOB_META_TNAME = "__all_ls_meta_table_aux_lob_meta";
const char *const OB_ALL_TABLET_TO_LS_AUX_LOB_META_TNAME = "__all_tablet_to_ls_aux_lob_meta";
const char *const OB_ALL_TABLET_META_TABLE_AUX_LOB_META_TNAME = "__all_tablet_meta_table_aux_lob_meta";
const char *const OB_ALL_LS_STATUS_AUX_LOB_META_TNAME = "__all_ls_status_aux_lob_meta";
const char *const OB_ALL_LOG_ARCHIVE_PROGRESS_AUX_LOB_META_TNAME = "__all_log_archive_progress_aux_lob_meta";
const char *const OB_ALL_LOG_ARCHIVE_HISTORY_AUX_LOB_META_TNAME = "__all_log_archive_history_aux_lob_meta";
const char *const OB_ALL_LOG_ARCHIVE_PIECE_FILES_AUX_LOB_META_TNAME = "__all_log_archive_piece_files_aux_lob_meta";
const char *const OB_ALL_LS_LOG_ARCHIVE_PROGRESS_AUX_LOB_META_TNAME = "__all_ls_log_archive_progress_aux_lob_meta";
const char *const OB_ALL_LS_AUX_LOB_META_TNAME = "__all_ls_aux_lob_meta";
const char *const OB_ALL_BACKUP_STORAGE_INFO_AUX_LOB_META_TNAME = "__all_backup_storage_info_aux_lob_meta";
const char *const OB_ALL_DAM_LAST_ARCH_TS_AUX_LOB_META_TNAME = "__all_dam_last_arch_ts_aux_lob_meta";
const char *const OB_ALL_DAM_CLEANUP_JOBS_AUX_LOB_META_TNAME = "__all_dam_cleanup_jobs_aux_lob_meta";
const char *const OB_ALL_BACKUP_JOB_AUX_LOB_META_TNAME = "__all_backup_job_aux_lob_meta";
const char *const OB_ALL_BACKUP_JOB_HISTORY_AUX_LOB_META_TNAME = "__all_backup_job_history_aux_lob_meta";
const char *const OB_ALL_BACKUP_TASK_AUX_LOB_META_TNAME = "__all_backup_task_aux_lob_meta";
const char *const OB_ALL_BACKUP_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_backup_task_history_aux_lob_meta";
const char *const OB_ALL_BACKUP_LS_TASK_AUX_LOB_META_TNAME = "__all_backup_ls_task_aux_lob_meta";
const char *const OB_ALL_BACKUP_LS_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_backup_ls_task_history_aux_lob_meta";
const char *const OB_ALL_BACKUP_LS_TASK_INFO_AUX_LOB_META_TNAME = "__all_backup_ls_task_info_aux_lob_meta";
const char *const OB_ALL_BACKUP_SKIPPED_TABLET_AUX_LOB_META_TNAME = "__all_backup_skipped_tablet_aux_lob_meta";
const char *const OB_ALL_BACKUP_SKIPPED_TABLET_HISTORY_AUX_LOB_META_TNAME = "__all_backup_skipped_tablet_history_aux_lob_meta";
const char *const OB_ALL_TENANT_INFO_AUX_LOB_META_TNAME = "__all_tenant_info_aux_lob_meta";
const char *const OB_ALL_TABLET_TO_TABLE_HISTORY_AUX_LOB_META_TNAME = "__all_tablet_to_table_history_aux_lob_meta";
const char *const OB_ALL_LS_RECOVERY_STAT_AUX_LOB_META_TNAME = "__all_ls_recovery_stat_aux_lob_meta";
const char *const OB_ALL_BACKUP_LS_TASK_INFO_HISTORY_AUX_LOB_META_TNAME = "__all_backup_ls_task_info_history_aux_lob_meta";
const char *const OB_ALL_TABLET_REPLICA_CHECKSUM_AUX_LOB_META_TNAME = "__all_tablet_replica_checksum_aux_lob_meta";
const char *const OB_ALL_TABLET_CHECKSUM_AUX_LOB_META_TNAME = "__all_tablet_checksum_aux_lob_meta";
const char *const OB_ALL_LS_REPLICA_TASK_AUX_LOB_META_TNAME = "__all_ls_replica_task_aux_lob_meta";
const char *const OB_ALL_PENDING_TRANSACTION_AUX_LOB_META_TNAME = "__all_pending_transaction_aux_lob_meta";
const char *const OB_ALL_BALANCE_GROUP_LS_STAT_AUX_LOB_META_TNAME = "__all_balance_group_ls_stat_aux_lob_meta";
const char *const OB_ALL_TENANT_SCHEDULER_JOB_AUX_LOB_META_TNAME = "__all_tenant_scheduler_job_aux_lob_meta";
const char *const OB_ALL_TENANT_SCHEDULER_JOB_RUN_DETAIL_AUX_LOB_META_TNAME = "__all_tenant_scheduler_job_run_detail_aux_lob_meta";
const char *const OB_ALL_TENANT_SCHEDULER_PROGRAM_AUX_LOB_META_TNAME = "__all_tenant_scheduler_program_aux_lob_meta";
const char *const OB_ALL_TENANT_SCHEDULER_PROGRAM_ARGUMENT_AUX_LOB_META_TNAME = "__all_tenant_scheduler_program_argument_aux_lob_meta";
const char *const OB_ALL_CONTEXT_AUX_LOB_META_TNAME = "__all_context_aux_lob_meta";
const char *const OB_ALL_CONTEXT_HISTORY_AUX_LOB_META_TNAME = "__all_context_history_aux_lob_meta";
const char *const OB_ALL_GLOBAL_CONTEXT_VALUE_AUX_LOB_META_TNAME = "__all_global_context_value_aux_lob_meta";
const char *const OB_ALL_LS_ELECTION_REFERENCE_INFO_AUX_LOB_META_TNAME = "__all_ls_election_reference_info_aux_lob_meta";
const char *const OB_ALL_BACKUP_DELETE_JOB_AUX_LOB_META_TNAME = "__all_backup_delete_job_aux_lob_meta";
const char *const OB_ALL_BACKUP_DELETE_JOB_HISTORY_AUX_LOB_META_TNAME = "__all_backup_delete_job_history_aux_lob_meta";
const char *const OB_ALL_BACKUP_DELETE_TASK_AUX_LOB_META_TNAME = "__all_backup_delete_task_aux_lob_meta";
const char *const OB_ALL_BACKUP_DELETE_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_backup_delete_task_history_aux_lob_meta";
const char *const OB_ALL_BACKUP_DELETE_LS_TASK_AUX_LOB_META_TNAME = "__all_backup_delete_ls_task_aux_lob_meta";
const char *const OB_ALL_BACKUP_DELETE_LS_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_backup_delete_ls_task_history_aux_lob_meta";
const char *const OB_ALL_ZONE_MERGE_INFO_AUX_LOB_META_TNAME = "__all_zone_merge_info_aux_lob_meta";
const char *const OB_ALL_MERGE_INFO_AUX_LOB_META_TNAME = "__all_merge_info_aux_lob_meta";
const char *const OB_ALL_FREEZE_INFO_AUX_LOB_META_TNAME = "__all_freeze_info_aux_lob_meta";
const char *const OB_ALL_DISK_IO_CALIBRATION_AUX_LOB_META_TNAME = "__all_disk_io_calibration_aux_lob_meta";
const char *const OB_ALL_PLAN_BASELINE_AUX_LOB_META_TNAME = "__all_plan_baseline_aux_lob_meta";
const char *const OB_ALL_PLAN_BASELINE_ITEM_AUX_LOB_META_TNAME = "__all_plan_baseline_item_aux_lob_meta";
const char *const OB_ALL_SPM_CONFIG_AUX_LOB_META_TNAME = "__all_spm_config_aux_lob_meta";
const char *const OB_ALL_LOG_ARCHIVE_DEST_PARAMETER_AUX_LOB_META_TNAME = "__all_log_archive_dest_parameter_aux_lob_meta";
const char *const OB_ALL_BACKUP_PARAMETER_AUX_LOB_META_TNAME = "__all_backup_parameter_aux_lob_meta";
const char *const OB_ALL_LS_RESTORE_PROGRESS_AUX_LOB_META_TNAME = "__all_ls_restore_progress_aux_lob_meta";
const char *const OB_ALL_LS_RESTORE_HISTORY_AUX_LOB_META_TNAME = "__all_ls_restore_history_aux_lob_meta";
const char *const OB_ALL_BACKUP_STORAGE_INFO_HISTORY_AUX_LOB_META_TNAME = "__all_backup_storage_info_history_aux_lob_meta";
const char *const OB_ALL_BACKUP_DELETE_POLICY_AUX_LOB_META_TNAME = "__all_backup_delete_policy_aux_lob_meta";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_AUX_LOB_META_TNAME = "__all_mock_fk_parent_table_aux_lob_meta";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_HISTORY_AUX_LOB_META_TNAME = "__all_mock_fk_parent_table_history_aux_lob_meta";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_AUX_LOB_META_TNAME = "__all_mock_fk_parent_table_column_aux_lob_meta";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_HISTORY_AUX_LOB_META_TNAME = "__all_mock_fk_parent_table_column_history_aux_lob_meta";
const char *const OB_ALL_LOG_RESTORE_SOURCE_AUX_LOB_META_TNAME = "__all_log_restore_source_aux_lob_meta";
const char *const OB_ALL_KV_TTL_TASK_AUX_LOB_META_TNAME = "__all_kv_ttl_task_aux_lob_meta";
const char *const OB_ALL_KV_TTL_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_kv_ttl_task_history_aux_lob_meta";
const char *const OB_ALL_SERVICE_EPOCH_AUX_LOB_META_TNAME = "__all_service_epoch_aux_lob_meta";
const char *const OB_ALL_SPATIAL_REFERENCE_SYSTEMS_AUX_LOB_META_TNAME = "__all_spatial_reference_systems_aux_lob_meta";
const char *const OB_ALL_COLUMN_CHECKSUM_ERROR_INFO_AUX_LOB_META_TNAME = "__all_column_checksum_error_info_aux_lob_meta";
const char *const OB_ALL_COLUMN_GROUP_AUX_LOB_META_TNAME = "__all_column_group_aux_lob_meta";
const char *const OB_ALL_COLUMN_GROUP_HISTORY_AUX_LOB_META_TNAME = "__all_column_group_history_aux_lob_meta";
const char *const OB_ALL_COLUMN_GROUP_MAPPING_AUX_LOB_META_TNAME = "__all_column_group_mapping_aux_lob_meta";
const char *const OB_ALL_COLUMN_GROUP_MAPPING_HISTORY_AUX_LOB_META_TNAME = "__all_column_group_mapping_history_aux_lob_meta";
const char *const OB_ALL_TRANSFER_TASK_AUX_LOB_META_TNAME = "__all_transfer_task_aux_lob_meta";
const char *const OB_ALL_TRANSFER_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_transfer_task_history_aux_lob_meta";
const char *const OB_ALL_BALANCE_JOB_AUX_LOB_META_TNAME = "__all_balance_job_aux_lob_meta";
const char *const OB_ALL_BALANCE_JOB_HISTORY_AUX_LOB_META_TNAME = "__all_balance_job_history_aux_lob_meta";
const char *const OB_ALL_BALANCE_TASK_AUX_LOB_META_TNAME = "__all_balance_task_aux_lob_meta";
const char *const OB_ALL_BALANCE_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_balance_task_history_aux_lob_meta";
const char *const OB_ALL_ARBITRATION_SERVICE_AUX_LOB_META_TNAME = "__all_arbitration_service_aux_lob_meta";
const char *const OB_ALL_LS_ARB_REPLICA_TASK_AUX_LOB_META_TNAME = "__all_ls_arb_replica_task_aux_lob_meta";
const char *const OB_ALL_DATA_DICTIONARY_IN_LOG_AUX_LOB_META_TNAME = "__all_data_dictionary_in_log_aux_lob_meta";
const char *const OB_ALL_LS_ARB_REPLICA_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_ls_arb_replica_task_history_aux_lob_meta";
const char *const OB_ALL_RLS_POLICY_AUX_LOB_META_TNAME = "__all_rls_policy_aux_lob_meta";
const char *const OB_ALL_RLS_POLICY_HISTORY_AUX_LOB_META_TNAME = "__all_rls_policy_history_aux_lob_meta";
const char *const OB_ALL_RLS_SECURITY_COLUMN_AUX_LOB_META_TNAME = "__all_rls_security_column_aux_lob_meta";
const char *const OB_ALL_RLS_SECURITY_COLUMN_HISTORY_AUX_LOB_META_TNAME = "__all_rls_security_column_history_aux_lob_meta";
const char *const OB_ALL_RLS_GROUP_AUX_LOB_META_TNAME = "__all_rls_group_aux_lob_meta";
const char *const OB_ALL_RLS_GROUP_HISTORY_AUX_LOB_META_TNAME = "__all_rls_group_history_aux_lob_meta";
const char *const OB_ALL_RLS_CONTEXT_AUX_LOB_META_TNAME = "__all_rls_context_aux_lob_meta";
const char *const OB_ALL_RLS_CONTEXT_HISTORY_AUX_LOB_META_TNAME = "__all_rls_context_history_aux_lob_meta";
const char *const OB_ALL_RLS_ATTRIBUTE_AUX_LOB_META_TNAME = "__all_rls_attribute_aux_lob_meta";
const char *const OB_ALL_RLS_ATTRIBUTE_HISTORY_AUX_LOB_META_TNAME = "__all_rls_attribute_history_aux_lob_meta";
const char *const OB_ALL_TENANT_REWRITE_RULES_AUX_LOB_META_TNAME = "__all_tenant_rewrite_rules_aux_lob_meta";
const char *const OB_ALL_RESERVED_SNAPSHOT_AUX_LOB_META_TNAME = "__all_reserved_snapshot_aux_lob_meta";
const char *const OB_ALL_CLUSTER_EVENT_HISTORY_AUX_LOB_META_TNAME = "__all_cluster_event_history_aux_lob_meta";
const char *const OB_ALL_LS_TRANSFER_MEMBER_LIST_LOCK_INFO_AUX_LOB_META_TNAME = "__all_ls_transfer_member_list_lock_info_aux_lob_meta";
const char *const OB_ALL_EXTERNAL_TABLE_FILE_AUX_LOB_META_TNAME = "__all_external_table_file_aux_lob_meta";
const char *const OB_ALL_TASK_OPT_STAT_GATHER_HISTORY_AUX_LOB_META_TNAME = "__all_task_opt_stat_gather_history_aux_lob_meta";
const char *const OB_ALL_TABLE_OPT_STAT_GATHER_HISTORY_AUX_LOB_META_TNAME = "__all_table_opt_stat_gather_history_aux_lob_meta";
const char *const OB_ALL_ZONE_STORAGE_AUX_LOB_META_TNAME = "__all_zone_storage_aux_lob_meta";
const char *const OB_ALL_ZONE_STORAGE_OPERATION_AUX_LOB_META_TNAME = "__all_zone_storage_operation_aux_lob_meta";
const char *const OB_WR_ACTIVE_SESSION_HISTORY_AUX_LOB_META_TNAME = "__wr_active_session_history_aux_lob_meta";
const char *const OB_WR_SNAPSHOT_AUX_LOB_META_TNAME = "__wr_snapshot_aux_lob_meta";
const char *const OB_WR_STATNAME_AUX_LOB_META_TNAME = "__wr_statname_aux_lob_meta";
const char *const OB_WR_SYSSTAT_AUX_LOB_META_TNAME = "__wr_sysstat_aux_lob_meta";
const char *const OB_ALL_BALANCE_TASK_HELPER_AUX_LOB_META_TNAME = "__all_balance_task_helper_aux_lob_meta";
const char *const OB_ALL_TENANT_SNAPSHOT_AUX_LOB_META_TNAME = "__all_tenant_snapshot_aux_lob_meta";
const char *const OB_ALL_TENANT_SNAPSHOT_LS_AUX_LOB_META_TNAME = "__all_tenant_snapshot_ls_aux_lob_meta";
const char *const OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_AUX_LOB_META_TNAME = "__all_tenant_snapshot_ls_replica_aux_lob_meta";
const char *const OB_ALL_MLOG_AUX_LOB_META_TNAME = "__all_mlog_aux_lob_meta";
const char *const OB_ALL_MVIEW_AUX_LOB_META_TNAME = "__all_mview_aux_lob_meta";
const char *const OB_ALL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_AUX_LOB_META_TNAME = "__all_mview_refresh_stats_sys_defaults_aux_lob_meta";
const char *const OB_ALL_MVIEW_REFRESH_STATS_PARAMS_AUX_LOB_META_TNAME = "__all_mview_refresh_stats_params_aux_lob_meta";
const char *const OB_ALL_MVIEW_REFRESH_RUN_STATS_AUX_LOB_META_TNAME = "__all_mview_refresh_run_stats_aux_lob_meta";
const char *const OB_ALL_MVIEW_REFRESH_STATS_AUX_LOB_META_TNAME = "__all_mview_refresh_stats_aux_lob_meta";
const char *const OB_ALL_MVIEW_REFRESH_CHANGE_STATS_AUX_LOB_META_TNAME = "__all_mview_refresh_change_stats_aux_lob_meta";
const char *const OB_ALL_MVIEW_REFRESH_STMT_STATS_AUX_LOB_META_TNAME = "__all_mview_refresh_stmt_stats_aux_lob_meta";
const char *const OB_ALL_DBMS_LOCK_ALLOCATED_AUX_LOB_META_TNAME = "__all_dbms_lock_allocated_aux_lob_meta";
const char *const OB_WR_CONTROL_AUX_LOB_META_TNAME = "__wr_control_aux_lob_meta";
const char *const OB_ALL_TENANT_EVENT_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_event_history_aux_lob_meta";
const char *const OB_ALL_TENANT_SCHEDULER_JOB_CLASS_AUX_LOB_META_TNAME = "__all_tenant_scheduler_job_class_aux_lob_meta";
const char *const OB_ALL_RECOVER_TABLE_JOB_AUX_LOB_META_TNAME = "__all_recover_table_job_aux_lob_meta";
const char *const OB_ALL_RECOVER_TABLE_JOB_HISTORY_AUX_LOB_META_TNAME = "__all_recover_table_job_history_aux_lob_meta";
const char *const OB_ALL_IMPORT_TABLE_JOB_AUX_LOB_META_TNAME = "__all_import_table_job_aux_lob_meta";
const char *const OB_ALL_IMPORT_TABLE_JOB_HISTORY_AUX_LOB_META_TNAME = "__all_import_table_job_history_aux_lob_meta";
const char *const OB_ALL_IMPORT_TABLE_TASK_AUX_LOB_META_TNAME = "__all_import_table_task_aux_lob_meta";
const char *const OB_ALL_IMPORT_TABLE_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_import_table_task_history_aux_lob_meta";
const char *const OB_ALL_TABLET_REORGANIZE_HISTORY_AUX_LOB_META_TNAME = "__all_tablet_reorganize_history_aux_lob_meta";
const char *const OB_ALL_STORAGE_HA_ERROR_DIAGNOSE_HISTORY_AUX_LOB_META_TNAME = "__all_storage_ha_error_diagnose_history_aux_lob_meta";
const char *const OB_ALL_STORAGE_HA_PERF_DIAGNOSE_HISTORY_AUX_LOB_META_TNAME = "__all_storage_ha_perf_diagnose_history_aux_lob_meta";
const char *const OB_ALL_CLONE_JOB_AUX_LOB_META_TNAME = "__all_clone_job_aux_lob_meta";
const char *const OB_ALL_CLONE_JOB_HISTORY_AUX_LOB_META_TNAME = "__all_clone_job_history_aux_lob_meta";
const char *const OB_WR_SYSTEM_EVENT_AUX_LOB_META_TNAME = "__wr_system_event_aux_lob_meta";
const char *const OB_WR_EVENT_NAME_AUX_LOB_META_TNAME = "__wr_event_name_aux_lob_meta";
const char *const OB_ALL_ROUTINE_PRIVILEGE_AUX_LOB_META_TNAME = "__all_routine_privilege_aux_lob_meta";
const char *const OB_ALL_ROUTINE_PRIVILEGE_HISTORY_AUX_LOB_META_TNAME = "__all_routine_privilege_history_aux_lob_meta";
const char *const OB_WR_SQLSTAT_AUX_LOB_META_TNAME = "__wr_sqlstat_aux_lob_meta";
const char *const OB_ALL_NCOMP_DLL_AUX_LOB_META_TNAME = "__all_ncomp_dll_aux_lob_meta";
const char *const OB_ALL_AUX_STAT_AUX_LOB_META_TNAME = "__all_aux_stat_aux_lob_meta";
const char *const OB_ALL_INDEX_USAGE_INFO_AUX_LOB_META_TNAME = "__all_index_usage_info_aux_lob_meta";
const char *const OB_ALL_DETECT_LOCK_INFO_AUX_LOB_META_TNAME = "__all_detect_lock_info_aux_lob_meta";
const char *const OB_ALL_CLIENT_TO_SERVER_SESSION_INFO_AUX_LOB_META_TNAME = "__all_client_to_server_session_info_aux_lob_meta";
const char *const OB_ALL_TRANSFER_PARTITION_TASK_AUX_LOB_META_TNAME = "__all_transfer_partition_task_aux_lob_meta";
const char *const OB_ALL_TRANSFER_PARTITION_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_transfer_partition_task_history_aux_lob_meta";
const char *const OB_ALL_TENANT_SNAPSHOT_JOB_AUX_LOB_META_TNAME = "__all_tenant_snapshot_job_aux_lob_meta";
const char *const OB_WR_SQLTEXT_AUX_LOB_META_TNAME = "__wr_sqltext_aux_lob_meta";
const char *const OB_ALL_TRUSTED_ROOT_CERTIFICATE_AUX_LOB_META_TNAME = "__all_trusted_root_certificate_aux_lob_meta";
const char *const OB_ALL_AUDIT_LOG_FILTER_AUX_LOB_META_TNAME = "__all_audit_log_filter_aux_lob_meta";
const char *const OB_ALL_AUDIT_LOG_USER_AUX_LOB_META_TNAME = "__all_audit_log_user_aux_lob_meta";
const char *const OB_ALL_COLUMN_PRIVILEGE_AUX_LOB_META_TNAME = "__all_column_privilege_aux_lob_meta";
const char *const OB_ALL_COLUMN_PRIVILEGE_HISTORY_AUX_LOB_META_TNAME = "__all_column_privilege_history_aux_lob_meta";
const char *const OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_HISTORY_AUX_LOB_META_TNAME = "__all_tenant_snapshot_ls_replica_history_aux_lob_meta";
const char *const OB_ALL_LS_REPLICA_TASK_HISTORY_AUX_LOB_META_TNAME = "__all_ls_replica_task_history_aux_lob_meta";
const char *const OB_ALL_TABLET_CHECKSUM_ERROR_INFO_AUX_LOB_META_TNAME = "__all_tablet_checksum_error_info_aux_lob_meta";
const char *const OB_ALL_USER_PROXY_INFO_AUX_LOB_META_TNAME = "__all_user_proxy_info_aux_lob_meta";
const char *const OB_ALL_USER_PROXY_INFO_HISTORY_AUX_LOB_META_TNAME = "__all_user_proxy_info_history_aux_lob_meta";
const char *const OB_ALL_USER_PROXY_ROLE_INFO_AUX_LOB_META_TNAME = "__all_user_proxy_role_info_aux_lob_meta";
const char *const OB_ALL_USER_PROXY_ROLE_INFO_HISTORY_AUX_LOB_META_TNAME = "__all_user_proxy_role_info_history_aux_lob_meta";
const char *const OB_ALL_SERVICE_AUX_LOB_META_TNAME = "__all_service_aux_lob_meta";
const char *const OB_ALL_STORAGE_IO_USAGE_AUX_LOB_META_TNAME = "__all_storage_io_usage_aux_lob_meta";
const char *const OB_ALL_MVIEW_DEP_AUX_LOB_META_TNAME = "__all_mview_dep_aux_lob_meta";
const char *const OB_ALL_SCHEDULER_JOB_RUN_DETAIL_V2_AUX_LOB_META_TNAME = "__all_scheduler_job_run_detail_v2_aux_lob_meta";
const char *const OB_ALL_SPM_EVO_RESULT_AUX_LOB_META_TNAME = "__all_spm_evo_result_aux_lob_meta";
const char *const OB_ALL_PKG_TYPE_AUX_LOB_META_TNAME = "__all_pkg_type_aux_lob_meta";
const char *const OB_ALL_PKG_TYPE_ATTR_AUX_LOB_META_TNAME = "__all_pkg_type_attr_aux_lob_meta";
const char *const OB_ALL_PKG_COLL_TYPE_AUX_LOB_META_TNAME = "__all_pkg_coll_type_aux_lob_meta";
const char *const OB_WR_SQL_PLAN_AUX_LOB_META_TNAME = "__wr_sql_plan_aux_lob_meta";
const char *const OB_ALL_KV_REDIS_TABLE_AUX_LOB_META_TNAME = "__all_kv_redis_table_aux_lob_meta";
const char *const OB_ALL_NCOMP_DLL_V2_AUX_LOB_META_TNAME = "__all_ncomp_dll_v2_aux_lob_meta";
const char *const OB_FT_DICT_IK_UTF8_AUX_LOB_META_TNAME = "__ft_dict_ik_utf8_aux_lob_meta";
const char *const OB_FT_STOPWORD_IK_UTF8_AUX_LOB_META_TNAME = "__ft_stopword_ik_utf8_aux_lob_meta";
const char *const OB_FT_QUANTIFIER_IK_UTF8_AUX_LOB_META_TNAME = "__ft_quantifier_ik_utf8_aux_lob_meta";
const char *const OB_ALL_TABLE_AUX_LOB_PIECE_TNAME = "__all_table_aux_lob_piece";
const char *const OB_ALL_COLUMN_AUX_LOB_PIECE_TNAME = "__all_column_aux_lob_piece";
const char *const OB_ALL_DDL_OPERATION_AUX_LOB_PIECE_TNAME = "__all_ddl_operation_aux_lob_piece";
const char *const OB_ALL_USER_AUX_LOB_PIECE_TNAME = "__all_user_aux_lob_piece";
const char *const OB_ALL_USER_HISTORY_AUX_LOB_PIECE_TNAME = "__all_user_history_aux_lob_piece";
const char *const OB_ALL_DATABASE_AUX_LOB_PIECE_TNAME = "__all_database_aux_lob_piece";
const char *const OB_ALL_DATABASE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_database_history_aux_lob_piece";
const char *const OB_ALL_TABLEGROUP_AUX_LOB_PIECE_TNAME = "__all_tablegroup_aux_lob_piece";
const char *const OB_ALL_TABLEGROUP_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tablegroup_history_aux_lob_piece";
const char *const OB_ALL_TENANT_AUX_LOB_PIECE_TNAME = "__all_tenant_aux_lob_piece";
const char *const OB_ALL_TENANT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_history_aux_lob_piece";
const char *const OB_ALL_TABLE_PRIVILEGE_AUX_LOB_PIECE_TNAME = "__all_table_privilege_aux_lob_piece";
const char *const OB_ALL_TABLE_PRIVILEGE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_table_privilege_history_aux_lob_piece";
const char *const OB_ALL_DATABASE_PRIVILEGE_AUX_LOB_PIECE_TNAME = "__all_database_privilege_aux_lob_piece";
const char *const OB_ALL_DATABASE_PRIVILEGE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_database_privilege_history_aux_lob_piece";
const char *const OB_ALL_TABLE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_table_history_aux_lob_piece";
const char *const OB_ALL_COLUMN_HISTORY_AUX_LOB_PIECE_TNAME = "__all_column_history_aux_lob_piece";
const char *const OB_ALL_ZONE_AUX_LOB_PIECE_TNAME = "__all_zone_aux_lob_piece";
const char *const OB_ALL_SERVER_AUX_LOB_PIECE_TNAME = "__all_server_aux_lob_piece";
const char *const OB_ALL_SYS_PARAMETER_AUX_LOB_PIECE_TNAME = "__all_sys_parameter_aux_lob_piece";
const char *const OB_TENANT_PARAMETER_AUX_LOB_PIECE_TNAME = "__tenant_parameter_aux_lob_piece";
const char *const OB_ALL_SYS_VARIABLE_AUX_LOB_PIECE_TNAME = "__all_sys_variable_aux_lob_piece";
const char *const OB_ALL_SYS_STAT_AUX_LOB_PIECE_TNAME = "__all_sys_stat_aux_lob_piece";
const char *const OB_ALL_UNIT_AUX_LOB_PIECE_TNAME = "__all_unit_aux_lob_piece";
const char *const OB_ALL_UNIT_CONFIG_AUX_LOB_PIECE_TNAME = "__all_unit_config_aux_lob_piece";
const char *const OB_ALL_RESOURCE_POOL_AUX_LOB_PIECE_TNAME = "__all_resource_pool_aux_lob_piece";
const char *const OB_ALL_CHARSET_AUX_LOB_PIECE_TNAME = "__all_charset_aux_lob_piece";
const char *const OB_ALL_COLLATION_AUX_LOB_PIECE_TNAME = "__all_collation_aux_lob_piece";
const char *const OB_HELP_TOPIC_AUX_LOB_PIECE_TNAME = "help_topic_aux_lob_piece";
const char *const OB_HELP_CATEGORY_AUX_LOB_PIECE_TNAME = "help_category_aux_lob_piece";
const char *const OB_HELP_KEYWORD_AUX_LOB_PIECE_TNAME = "help_keyword_aux_lob_piece";
const char *const OB_HELP_RELATION_AUX_LOB_PIECE_TNAME = "help_relation_aux_lob_piece";
const char *const OB_ALL_DUMMY_AUX_LOB_PIECE_TNAME = "__all_dummy_aux_lob_piece";
const char *const OB_ALL_ROOTSERVICE_EVENT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_rootservice_event_history_aux_lob_piece";
const char *const OB_ALL_PRIVILEGE_AUX_LOB_PIECE_TNAME = "__all_privilege_aux_lob_piece";
const char *const OB_ALL_OUTLINE_AUX_LOB_PIECE_TNAME = "__all_outline_aux_lob_piece";
const char *const OB_ALL_OUTLINE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_outline_history_aux_lob_piece";
const char *const OB_ALL_RECYCLEBIN_AUX_LOB_PIECE_TNAME = "__all_recyclebin_aux_lob_piece";
const char *const OB_ALL_PART_AUX_LOB_PIECE_TNAME = "__all_part_aux_lob_piece";
const char *const OB_ALL_PART_HISTORY_AUX_LOB_PIECE_TNAME = "__all_part_history_aux_lob_piece";
const char *const OB_ALL_SUB_PART_AUX_LOB_PIECE_TNAME = "__all_sub_part_aux_lob_piece";
const char *const OB_ALL_SUB_PART_HISTORY_AUX_LOB_PIECE_TNAME = "__all_sub_part_history_aux_lob_piece";
const char *const OB_ALL_PART_INFO_AUX_LOB_PIECE_TNAME = "__all_part_info_aux_lob_piece";
const char *const OB_ALL_PART_INFO_HISTORY_AUX_LOB_PIECE_TNAME = "__all_part_info_history_aux_lob_piece";
const char *const OB_ALL_DEF_SUB_PART_AUX_LOB_PIECE_TNAME = "__all_def_sub_part_aux_lob_piece";
const char *const OB_ALL_DEF_SUB_PART_HISTORY_AUX_LOB_PIECE_TNAME = "__all_def_sub_part_history_aux_lob_piece";
const char *const OB_ALL_SERVER_EVENT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_server_event_history_aux_lob_piece";
const char *const OB_ALL_ROOTSERVICE_JOB_AUX_LOB_PIECE_TNAME = "__all_rootservice_job_aux_lob_piece";
const char *const OB_ALL_SYS_VARIABLE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_sys_variable_history_aux_lob_piece";
const char *const OB_ALL_RESTORE_JOB_AUX_LOB_PIECE_TNAME = "__all_restore_job_aux_lob_piece";
const char *const OB_ALL_RESTORE_JOB_HISTORY_AUX_LOB_PIECE_TNAME = "__all_restore_job_history_aux_lob_piece";
const char *const OB_ALL_DDL_ID_AUX_LOB_PIECE_TNAME = "__all_ddl_id_aux_lob_piece";
const char *const OB_ALL_FOREIGN_KEY_AUX_LOB_PIECE_TNAME = "__all_foreign_key_aux_lob_piece";
const char *const OB_ALL_FOREIGN_KEY_HISTORY_AUX_LOB_PIECE_TNAME = "__all_foreign_key_history_aux_lob_piece";
const char *const OB_ALL_FOREIGN_KEY_COLUMN_AUX_LOB_PIECE_TNAME = "__all_foreign_key_column_aux_lob_piece";
const char *const OB_ALL_FOREIGN_KEY_COLUMN_HISTORY_AUX_LOB_PIECE_TNAME = "__all_foreign_key_column_history_aux_lob_piece";
const char *const OB_ALL_SYNONYM_AUX_LOB_PIECE_TNAME = "__all_synonym_aux_lob_piece";
const char *const OB_ALL_SYNONYM_HISTORY_AUX_LOB_PIECE_TNAME = "__all_synonym_history_aux_lob_piece";
const char *const OB_ALL_AUTO_INCREMENT_AUX_LOB_PIECE_TNAME = "__all_auto_increment_aux_lob_piece";
const char *const OB_ALL_DDL_CHECKSUM_AUX_LOB_PIECE_TNAME = "__all_ddl_checksum_aux_lob_piece";
const char *const OB_ALL_ROUTINE_AUX_LOB_PIECE_TNAME = "__all_routine_aux_lob_piece";
const char *const OB_ALL_ROUTINE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_routine_history_aux_lob_piece";
const char *const OB_ALL_ROUTINE_PARAM_AUX_LOB_PIECE_TNAME = "__all_routine_param_aux_lob_piece";
const char *const OB_ALL_ROUTINE_PARAM_HISTORY_AUX_LOB_PIECE_TNAME = "__all_routine_param_history_aux_lob_piece";
const char *const OB_ALL_PACKAGE_AUX_LOB_PIECE_TNAME = "__all_package_aux_lob_piece";
const char *const OB_ALL_PACKAGE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_package_history_aux_lob_piece";
const char *const OB_ALL_ACQUIRED_SNAPSHOT_AUX_LOB_PIECE_TNAME = "__all_acquired_snapshot_aux_lob_piece";
const char *const OB_ALL_CONSTRAINT_AUX_LOB_PIECE_TNAME = "__all_constraint_aux_lob_piece";
const char *const OB_ALL_CONSTRAINT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_constraint_history_aux_lob_piece";
const char *const OB_ALL_ORI_SCHEMA_VERSION_AUX_LOB_PIECE_TNAME = "__all_ori_schema_version_aux_lob_piece";
const char *const OB_ALL_FUNC_AUX_LOB_PIECE_TNAME = "__all_func_aux_lob_piece";
const char *const OB_ALL_FUNC_HISTORY_AUX_LOB_PIECE_TNAME = "__all_func_history_aux_lob_piece";
const char *const OB_ALL_TEMP_TABLE_AUX_LOB_PIECE_TNAME = "__all_temp_table_aux_lob_piece";
const char *const OB_ALL_SEQUENCE_OBJECT_AUX_LOB_PIECE_TNAME = "__all_sequence_object_aux_lob_piece";
const char *const OB_ALL_SEQUENCE_OBJECT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_sequence_object_history_aux_lob_piece";
const char *const OB_ALL_SEQUENCE_VALUE_AUX_LOB_PIECE_TNAME = "__all_sequence_value_aux_lob_piece";
const char *const OB_ALL_FREEZE_SCHEMA_VERSION_AUX_LOB_PIECE_TNAME = "__all_freeze_schema_version_aux_lob_piece";
const char *const OB_ALL_TYPE_AUX_LOB_PIECE_TNAME = "__all_type_aux_lob_piece";
const char *const OB_ALL_TYPE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_type_history_aux_lob_piece";
const char *const OB_ALL_TYPE_ATTR_AUX_LOB_PIECE_TNAME = "__all_type_attr_aux_lob_piece";
const char *const OB_ALL_TYPE_ATTR_HISTORY_AUX_LOB_PIECE_TNAME = "__all_type_attr_history_aux_lob_piece";
const char *const OB_ALL_COLL_TYPE_AUX_LOB_PIECE_TNAME = "__all_coll_type_aux_lob_piece";
const char *const OB_ALL_COLL_TYPE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_coll_type_history_aux_lob_piece";
const char *const OB_ALL_WEAK_READ_SERVICE_AUX_LOB_PIECE_TNAME = "__all_weak_read_service_aux_lob_piece";
const char *const OB_ALL_DBLINK_AUX_LOB_PIECE_TNAME = "__all_dblink_aux_lob_piece";
const char *const OB_ALL_DBLINK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_dblink_history_aux_lob_piece";
const char *const OB_ALL_TENANT_ROLE_GRANTEE_MAP_AUX_LOB_PIECE_TNAME = "__all_tenant_role_grantee_map_aux_lob_piece";
const char *const OB_ALL_TENANT_ROLE_GRANTEE_MAP_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_role_grantee_map_history_aux_lob_piece";
const char *const OB_ALL_TENANT_KEYSTORE_AUX_LOB_PIECE_TNAME = "__all_tenant_keystore_aux_lob_piece";
const char *const OB_ALL_TENANT_KEYSTORE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_keystore_history_aux_lob_piece";
const char *const OB_ALL_TENANT_OLS_POLICY_AUX_LOB_PIECE_TNAME = "__all_tenant_ols_policy_aux_lob_piece";
const char *const OB_ALL_TENANT_OLS_POLICY_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_ols_policy_history_aux_lob_piece";
const char *const OB_ALL_TENANT_OLS_COMPONENT_AUX_LOB_PIECE_TNAME = "__all_tenant_ols_component_aux_lob_piece";
const char *const OB_ALL_TENANT_OLS_COMPONENT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_ols_component_history_aux_lob_piece";
const char *const OB_ALL_TENANT_OLS_LABEL_AUX_LOB_PIECE_TNAME = "__all_tenant_ols_label_aux_lob_piece";
const char *const OB_ALL_TENANT_OLS_LABEL_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_ols_label_history_aux_lob_piece";
const char *const OB_ALL_TENANT_OLS_USER_LEVEL_AUX_LOB_PIECE_TNAME = "__all_tenant_ols_user_level_aux_lob_piece";
const char *const OB_ALL_TENANT_OLS_USER_LEVEL_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_ols_user_level_history_aux_lob_piece";
const char *const OB_ALL_TENANT_TABLESPACE_AUX_LOB_PIECE_TNAME = "__all_tenant_tablespace_aux_lob_piece";
const char *const OB_ALL_TENANT_TABLESPACE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_tablespace_history_aux_lob_piece";
const char *const OB_ALL_TENANT_USER_FAILED_LOGIN_STAT_AUX_LOB_PIECE_TNAME = "__all_tenant_user_failed_login_stat_aux_lob_piece";
const char *const OB_ALL_TENANT_PROFILE_AUX_LOB_PIECE_TNAME = "__all_tenant_profile_aux_lob_piece";
const char *const OB_ALL_TENANT_PROFILE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_profile_history_aux_lob_piece";
const char *const OB_ALL_TENANT_SECURITY_AUDIT_AUX_LOB_PIECE_TNAME = "__all_tenant_security_audit_aux_lob_piece";
const char *const OB_ALL_TENANT_SECURITY_AUDIT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_security_audit_history_aux_lob_piece";
const char *const OB_ALL_TENANT_TRIGGER_AUX_LOB_PIECE_TNAME = "__all_tenant_trigger_aux_lob_piece";
const char *const OB_ALL_TENANT_TRIGGER_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_trigger_history_aux_lob_piece";
const char *const OB_ALL_SEED_PARAMETER_AUX_LOB_PIECE_TNAME = "__all_seed_parameter_aux_lob_piece";
const char *const OB_ALL_TENANT_SECURITY_AUDIT_RECORD_AUX_LOB_PIECE_TNAME = "__all_tenant_security_audit_record_aux_lob_piece";
const char *const OB_ALL_TENANT_SYSAUTH_AUX_LOB_PIECE_TNAME = "__all_tenant_sysauth_aux_lob_piece";
const char *const OB_ALL_TENANT_SYSAUTH_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_sysauth_history_aux_lob_piece";
const char *const OB_ALL_TENANT_OBJAUTH_AUX_LOB_PIECE_TNAME = "__all_tenant_objauth_aux_lob_piece";
const char *const OB_ALL_TENANT_OBJAUTH_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_objauth_history_aux_lob_piece";
const char *const OB_ALL_RESTORE_INFO_AUX_LOB_PIECE_TNAME = "__all_restore_info_aux_lob_piece";
const char *const OB_ALL_TENANT_ERROR_AUX_LOB_PIECE_TNAME = "__all_tenant_error_aux_lob_piece";
const char *const OB_ALL_RESTORE_PROGRESS_AUX_LOB_PIECE_TNAME = "__all_restore_progress_aux_lob_piece";
const char *const OB_ALL_TENANT_OBJECT_TYPE_AUX_LOB_PIECE_TNAME = "__all_tenant_object_type_aux_lob_piece";
const char *const OB_ALL_TENANT_OBJECT_TYPE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_object_type_history_aux_lob_piece";
const char *const OB_ALL_TENANT_TIME_ZONE_AUX_LOB_PIECE_TNAME = "__all_tenant_time_zone_aux_lob_piece";
const char *const OB_ALL_TENANT_TIME_ZONE_NAME_AUX_LOB_PIECE_TNAME = "__all_tenant_time_zone_name_aux_lob_piece";
const char *const OB_ALL_TENANT_TIME_ZONE_TRANSITION_AUX_LOB_PIECE_TNAME = "__all_tenant_time_zone_transition_aux_lob_piece";
const char *const OB_ALL_TENANT_TIME_ZONE_TRANSITION_TYPE_AUX_LOB_PIECE_TNAME = "__all_tenant_time_zone_transition_type_aux_lob_piece";
const char *const OB_ALL_TENANT_CONSTRAINT_COLUMN_AUX_LOB_PIECE_TNAME = "__all_tenant_constraint_column_aux_lob_piece";
const char *const OB_ALL_TENANT_CONSTRAINT_COLUMN_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_constraint_column_history_aux_lob_piece";
const char *const OB_ALL_TENANT_GLOBAL_TRANSACTION_AUX_LOB_PIECE_TNAME = "__all_tenant_global_transaction_aux_lob_piece";
const char *const OB_ALL_TENANT_DEPENDENCY_AUX_LOB_PIECE_TNAME = "__all_tenant_dependency_aux_lob_piece";
const char *const OB_ALL_RES_MGR_PLAN_AUX_LOB_PIECE_TNAME = "__all_res_mgr_plan_aux_lob_piece";
const char *const OB_ALL_RES_MGR_DIRECTIVE_AUX_LOB_PIECE_TNAME = "__all_res_mgr_directive_aux_lob_piece";
const char *const OB_ALL_RES_MGR_MAPPING_RULE_AUX_LOB_PIECE_TNAME = "__all_res_mgr_mapping_rule_aux_lob_piece";
const char *const OB_ALL_DDL_ERROR_MESSAGE_AUX_LOB_PIECE_TNAME = "__all_ddl_error_message_aux_lob_piece";
const char *const OB_ALL_SPACE_USAGE_AUX_LOB_PIECE_TNAME = "__all_space_usage_aux_lob_piece";
const char *const OB_ALL_BACKUP_SET_FILES_AUX_LOB_PIECE_TNAME = "__all_backup_set_files_aux_lob_piece";
const char *const OB_ALL_RES_MGR_CONSUMER_GROUP_AUX_LOB_PIECE_TNAME = "__all_res_mgr_consumer_group_aux_lob_piece";
const char *const OB_ALL_BACKUP_INFO_AUX_LOB_PIECE_TNAME = "__all_backup_info_aux_lob_piece";
const char *const OB_ALL_DDL_TASK_STATUS_AUX_LOB_PIECE_TNAME = "__all_ddl_task_status_aux_lob_piece";
const char *const OB_ALL_REGION_NETWORK_BANDWIDTH_LIMIT_AUX_LOB_PIECE_TNAME = "__all_region_network_bandwidth_limit_aux_lob_piece";
const char *const OB_ALL_DEADLOCK_EVENT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_deadlock_event_history_aux_lob_piece";
const char *const OB_ALL_COLUMN_USAGE_AUX_LOB_PIECE_TNAME = "__all_column_usage_aux_lob_piece";
const char *const OB_ALL_JOB_AUX_LOB_PIECE_TNAME = "__all_job_aux_lob_piece";
const char *const OB_ALL_JOB_LOG_AUX_LOB_PIECE_TNAME = "__all_job_log_aux_lob_piece";
const char *const OB_ALL_TENANT_DIRECTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_directory_aux_lob_piece";
const char *const OB_ALL_TENANT_DIRECTORY_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_directory_history_aux_lob_piece";
const char *const OB_ALL_TABLE_STAT_AUX_LOB_PIECE_TNAME = "__all_table_stat_aux_lob_piece";
const char *const OB_ALL_COLUMN_STAT_AUX_LOB_PIECE_TNAME = "__all_column_stat_aux_lob_piece";
const char *const OB_ALL_HISTOGRAM_STAT_AUX_LOB_PIECE_TNAME = "__all_histogram_stat_aux_lob_piece";
const char *const OB_ALL_MONITOR_MODIFIED_AUX_LOB_PIECE_TNAME = "__all_monitor_modified_aux_lob_piece";
const char *const OB_ALL_TABLE_STAT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_table_stat_history_aux_lob_piece";
const char *const OB_ALL_COLUMN_STAT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_column_stat_history_aux_lob_piece";
const char *const OB_ALL_HISTOGRAM_STAT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_histogram_stat_history_aux_lob_piece";
const char *const OB_ALL_OPTSTAT_GLOBAL_PREFS_AUX_LOB_PIECE_TNAME = "__all_optstat_global_prefs_aux_lob_piece";
const char *const OB_ALL_OPTSTAT_USER_PREFS_AUX_LOB_PIECE_TNAME = "__all_optstat_user_prefs_aux_lob_piece";
const char *const OB_ALL_LS_META_TABLE_AUX_LOB_PIECE_TNAME = "__all_ls_meta_table_aux_lob_piece";
const char *const OB_ALL_TABLET_TO_LS_AUX_LOB_PIECE_TNAME = "__all_tablet_to_ls_aux_lob_piece";
const char *const OB_ALL_TABLET_META_TABLE_AUX_LOB_PIECE_TNAME = "__all_tablet_meta_table_aux_lob_piece";
const char *const OB_ALL_LS_STATUS_AUX_LOB_PIECE_TNAME = "__all_ls_status_aux_lob_piece";
const char *const OB_ALL_LOG_ARCHIVE_PROGRESS_AUX_LOB_PIECE_TNAME = "__all_log_archive_progress_aux_lob_piece";
const char *const OB_ALL_LOG_ARCHIVE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_log_archive_history_aux_lob_piece";
const char *const OB_ALL_LOG_ARCHIVE_PIECE_FILES_AUX_LOB_PIECE_TNAME = "__all_log_archive_piece_files_aux_lob_piece";
const char *const OB_ALL_LS_LOG_ARCHIVE_PROGRESS_AUX_LOB_PIECE_TNAME = "__all_ls_log_archive_progress_aux_lob_piece";
const char *const OB_ALL_LS_AUX_LOB_PIECE_TNAME = "__all_ls_aux_lob_piece";
const char *const OB_ALL_BACKUP_STORAGE_INFO_AUX_LOB_PIECE_TNAME = "__all_backup_storage_info_aux_lob_piece";
const char *const OB_ALL_DAM_LAST_ARCH_TS_AUX_LOB_PIECE_TNAME = "__all_dam_last_arch_ts_aux_lob_piece";
const char *const OB_ALL_DAM_CLEANUP_JOBS_AUX_LOB_PIECE_TNAME = "__all_dam_cleanup_jobs_aux_lob_piece";
const char *const OB_ALL_BACKUP_JOB_AUX_LOB_PIECE_TNAME = "__all_backup_job_aux_lob_piece";
const char *const OB_ALL_BACKUP_JOB_HISTORY_AUX_LOB_PIECE_TNAME = "__all_backup_job_history_aux_lob_piece";
const char *const OB_ALL_BACKUP_TASK_AUX_LOB_PIECE_TNAME = "__all_backup_task_aux_lob_piece";
const char *const OB_ALL_BACKUP_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_backup_task_history_aux_lob_piece";
const char *const OB_ALL_BACKUP_LS_TASK_AUX_LOB_PIECE_TNAME = "__all_backup_ls_task_aux_lob_piece";
const char *const OB_ALL_BACKUP_LS_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_backup_ls_task_history_aux_lob_piece";
const char *const OB_ALL_BACKUP_LS_TASK_INFO_AUX_LOB_PIECE_TNAME = "__all_backup_ls_task_info_aux_lob_piece";
const char *const OB_ALL_BACKUP_SKIPPED_TABLET_AUX_LOB_PIECE_TNAME = "__all_backup_skipped_tablet_aux_lob_piece";
const char *const OB_ALL_BACKUP_SKIPPED_TABLET_HISTORY_AUX_LOB_PIECE_TNAME = "__all_backup_skipped_tablet_history_aux_lob_piece";
const char *const OB_ALL_TENANT_INFO_AUX_LOB_PIECE_TNAME = "__all_tenant_info_aux_lob_piece";
const char *const OB_ALL_TABLET_TO_TABLE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tablet_to_table_history_aux_lob_piece";
const char *const OB_ALL_LS_RECOVERY_STAT_AUX_LOB_PIECE_TNAME = "__all_ls_recovery_stat_aux_lob_piece";
const char *const OB_ALL_BACKUP_LS_TASK_INFO_HISTORY_AUX_LOB_PIECE_TNAME = "__all_backup_ls_task_info_history_aux_lob_piece";
const char *const OB_ALL_TABLET_REPLICA_CHECKSUM_AUX_LOB_PIECE_TNAME = "__all_tablet_replica_checksum_aux_lob_piece";
const char *const OB_ALL_TABLET_CHECKSUM_AUX_LOB_PIECE_TNAME = "__all_tablet_checksum_aux_lob_piece";
const char *const OB_ALL_LS_REPLICA_TASK_AUX_LOB_PIECE_TNAME = "__all_ls_replica_task_aux_lob_piece";
const char *const OB_ALL_PENDING_TRANSACTION_AUX_LOB_PIECE_TNAME = "__all_pending_transaction_aux_lob_piece";
const char *const OB_ALL_BALANCE_GROUP_LS_STAT_AUX_LOB_PIECE_TNAME = "__all_balance_group_ls_stat_aux_lob_piece";
const char *const OB_ALL_TENANT_SCHEDULER_JOB_AUX_LOB_PIECE_TNAME = "__all_tenant_scheduler_job_aux_lob_piece";
const char *const OB_ALL_TENANT_SCHEDULER_JOB_RUN_DETAIL_AUX_LOB_PIECE_TNAME = "__all_tenant_scheduler_job_run_detail_aux_lob_piece";
const char *const OB_ALL_TENANT_SCHEDULER_PROGRAM_AUX_LOB_PIECE_TNAME = "__all_tenant_scheduler_program_aux_lob_piece";
const char *const OB_ALL_TENANT_SCHEDULER_PROGRAM_ARGUMENT_AUX_LOB_PIECE_TNAME = "__all_tenant_scheduler_program_argument_aux_lob_piece";
const char *const OB_ALL_CONTEXT_AUX_LOB_PIECE_TNAME = "__all_context_aux_lob_piece";
const char *const OB_ALL_CONTEXT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_context_history_aux_lob_piece";
const char *const OB_ALL_GLOBAL_CONTEXT_VALUE_AUX_LOB_PIECE_TNAME = "__all_global_context_value_aux_lob_piece";
const char *const OB_ALL_LS_ELECTION_REFERENCE_INFO_AUX_LOB_PIECE_TNAME = "__all_ls_election_reference_info_aux_lob_piece";
const char *const OB_ALL_BACKUP_DELETE_JOB_AUX_LOB_PIECE_TNAME = "__all_backup_delete_job_aux_lob_piece";
const char *const OB_ALL_BACKUP_DELETE_JOB_HISTORY_AUX_LOB_PIECE_TNAME = "__all_backup_delete_job_history_aux_lob_piece";
const char *const OB_ALL_BACKUP_DELETE_TASK_AUX_LOB_PIECE_TNAME = "__all_backup_delete_task_aux_lob_piece";
const char *const OB_ALL_BACKUP_DELETE_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_backup_delete_task_history_aux_lob_piece";
const char *const OB_ALL_BACKUP_DELETE_LS_TASK_AUX_LOB_PIECE_TNAME = "__all_backup_delete_ls_task_aux_lob_piece";
const char *const OB_ALL_BACKUP_DELETE_LS_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_backup_delete_ls_task_history_aux_lob_piece";
const char *const OB_ALL_ZONE_MERGE_INFO_AUX_LOB_PIECE_TNAME = "__all_zone_merge_info_aux_lob_piece";
const char *const OB_ALL_MERGE_INFO_AUX_LOB_PIECE_TNAME = "__all_merge_info_aux_lob_piece";
const char *const OB_ALL_FREEZE_INFO_AUX_LOB_PIECE_TNAME = "__all_freeze_info_aux_lob_piece";
const char *const OB_ALL_DISK_IO_CALIBRATION_AUX_LOB_PIECE_TNAME = "__all_disk_io_calibration_aux_lob_piece";
const char *const OB_ALL_PLAN_BASELINE_AUX_LOB_PIECE_TNAME = "__all_plan_baseline_aux_lob_piece";
const char *const OB_ALL_PLAN_BASELINE_ITEM_AUX_LOB_PIECE_TNAME = "__all_plan_baseline_item_aux_lob_piece";
const char *const OB_ALL_SPM_CONFIG_AUX_LOB_PIECE_TNAME = "__all_spm_config_aux_lob_piece";
const char *const OB_ALL_LOG_ARCHIVE_DEST_PARAMETER_AUX_LOB_PIECE_TNAME = "__all_log_archive_dest_parameter_aux_lob_piece";
const char *const OB_ALL_BACKUP_PARAMETER_AUX_LOB_PIECE_TNAME = "__all_backup_parameter_aux_lob_piece";
const char *const OB_ALL_LS_RESTORE_PROGRESS_AUX_LOB_PIECE_TNAME = "__all_ls_restore_progress_aux_lob_piece";
const char *const OB_ALL_LS_RESTORE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_ls_restore_history_aux_lob_piece";
const char *const OB_ALL_BACKUP_STORAGE_INFO_HISTORY_AUX_LOB_PIECE_TNAME = "__all_backup_storage_info_history_aux_lob_piece";
const char *const OB_ALL_BACKUP_DELETE_POLICY_AUX_LOB_PIECE_TNAME = "__all_backup_delete_policy_aux_lob_piece";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_AUX_LOB_PIECE_TNAME = "__all_mock_fk_parent_table_aux_lob_piece";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_mock_fk_parent_table_history_aux_lob_piece";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_AUX_LOB_PIECE_TNAME = "__all_mock_fk_parent_table_column_aux_lob_piece";
const char *const OB_ALL_MOCK_FK_PARENT_TABLE_COLUMN_HISTORY_AUX_LOB_PIECE_TNAME = "__all_mock_fk_parent_table_column_history_aux_lob_piece";
const char *const OB_ALL_LOG_RESTORE_SOURCE_AUX_LOB_PIECE_TNAME = "__all_log_restore_source_aux_lob_piece";
const char *const OB_ALL_KV_TTL_TASK_AUX_LOB_PIECE_TNAME = "__all_kv_ttl_task_aux_lob_piece";
const char *const OB_ALL_KV_TTL_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_kv_ttl_task_history_aux_lob_piece";
const char *const OB_ALL_SERVICE_EPOCH_AUX_LOB_PIECE_TNAME = "__all_service_epoch_aux_lob_piece";
const char *const OB_ALL_SPATIAL_REFERENCE_SYSTEMS_AUX_LOB_PIECE_TNAME = "__all_spatial_reference_systems_aux_lob_piece";
const char *const OB_ALL_COLUMN_CHECKSUM_ERROR_INFO_AUX_LOB_PIECE_TNAME = "__all_column_checksum_error_info_aux_lob_piece";
const char *const OB_ALL_COLUMN_GROUP_AUX_LOB_PIECE_TNAME = "__all_column_group_aux_lob_piece";
const char *const OB_ALL_COLUMN_GROUP_HISTORY_AUX_LOB_PIECE_TNAME = "__all_column_group_history_aux_lob_piece";
const char *const OB_ALL_COLUMN_GROUP_MAPPING_AUX_LOB_PIECE_TNAME = "__all_column_group_mapping_aux_lob_piece";
const char *const OB_ALL_COLUMN_GROUP_MAPPING_HISTORY_AUX_LOB_PIECE_TNAME = "__all_column_group_mapping_history_aux_lob_piece";
const char *const OB_ALL_TRANSFER_TASK_AUX_LOB_PIECE_TNAME = "__all_transfer_task_aux_lob_piece";
const char *const OB_ALL_TRANSFER_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_transfer_task_history_aux_lob_piece";
const char *const OB_ALL_BALANCE_JOB_AUX_LOB_PIECE_TNAME = "__all_balance_job_aux_lob_piece";
const char *const OB_ALL_BALANCE_JOB_HISTORY_AUX_LOB_PIECE_TNAME = "__all_balance_job_history_aux_lob_piece";
const char *const OB_ALL_BALANCE_TASK_AUX_LOB_PIECE_TNAME = "__all_balance_task_aux_lob_piece";
const char *const OB_ALL_BALANCE_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_balance_task_history_aux_lob_piece";
const char *const OB_ALL_ARBITRATION_SERVICE_AUX_LOB_PIECE_TNAME = "__all_arbitration_service_aux_lob_piece";
const char *const OB_ALL_LS_ARB_REPLICA_TASK_AUX_LOB_PIECE_TNAME = "__all_ls_arb_replica_task_aux_lob_piece";
const char *const OB_ALL_DATA_DICTIONARY_IN_LOG_AUX_LOB_PIECE_TNAME = "__all_data_dictionary_in_log_aux_lob_piece";
const char *const OB_ALL_LS_ARB_REPLICA_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_ls_arb_replica_task_history_aux_lob_piece";
const char *const OB_ALL_RLS_POLICY_AUX_LOB_PIECE_TNAME = "__all_rls_policy_aux_lob_piece";
const char *const OB_ALL_RLS_POLICY_HISTORY_AUX_LOB_PIECE_TNAME = "__all_rls_policy_history_aux_lob_piece";
const char *const OB_ALL_RLS_SECURITY_COLUMN_AUX_LOB_PIECE_TNAME = "__all_rls_security_column_aux_lob_piece";
const char *const OB_ALL_RLS_SECURITY_COLUMN_HISTORY_AUX_LOB_PIECE_TNAME = "__all_rls_security_column_history_aux_lob_piece";
const char *const OB_ALL_RLS_GROUP_AUX_LOB_PIECE_TNAME = "__all_rls_group_aux_lob_piece";
const char *const OB_ALL_RLS_GROUP_HISTORY_AUX_LOB_PIECE_TNAME = "__all_rls_group_history_aux_lob_piece";
const char *const OB_ALL_RLS_CONTEXT_AUX_LOB_PIECE_TNAME = "__all_rls_context_aux_lob_piece";
const char *const OB_ALL_RLS_CONTEXT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_rls_context_history_aux_lob_piece";
const char *const OB_ALL_RLS_ATTRIBUTE_AUX_LOB_PIECE_TNAME = "__all_rls_attribute_aux_lob_piece";
const char *const OB_ALL_RLS_ATTRIBUTE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_rls_attribute_history_aux_lob_piece";
const char *const OB_ALL_TENANT_REWRITE_RULES_AUX_LOB_PIECE_TNAME = "__all_tenant_rewrite_rules_aux_lob_piece";
const char *const OB_ALL_RESERVED_SNAPSHOT_AUX_LOB_PIECE_TNAME = "__all_reserved_snapshot_aux_lob_piece";
const char *const OB_ALL_CLUSTER_EVENT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_cluster_event_history_aux_lob_piece";
const char *const OB_ALL_LS_TRANSFER_MEMBER_LIST_LOCK_INFO_AUX_LOB_PIECE_TNAME = "__all_ls_transfer_member_list_lock_info_aux_lob_piece";
const char *const OB_ALL_EXTERNAL_TABLE_FILE_AUX_LOB_PIECE_TNAME = "__all_external_table_file_aux_lob_piece";
const char *const OB_ALL_TASK_OPT_STAT_GATHER_HISTORY_AUX_LOB_PIECE_TNAME = "__all_task_opt_stat_gather_history_aux_lob_piece";
const char *const OB_ALL_TABLE_OPT_STAT_GATHER_HISTORY_AUX_LOB_PIECE_TNAME = "__all_table_opt_stat_gather_history_aux_lob_piece";
const char *const OB_ALL_ZONE_STORAGE_AUX_LOB_PIECE_TNAME = "__all_zone_storage_aux_lob_piece";
const char *const OB_ALL_ZONE_STORAGE_OPERATION_AUX_LOB_PIECE_TNAME = "__all_zone_storage_operation_aux_lob_piece";
const char *const OB_WR_ACTIVE_SESSION_HISTORY_AUX_LOB_PIECE_TNAME = "__wr_active_session_history_aux_lob_piece";
const char *const OB_WR_SNAPSHOT_AUX_LOB_PIECE_TNAME = "__wr_snapshot_aux_lob_piece";
const char *const OB_WR_STATNAME_AUX_LOB_PIECE_TNAME = "__wr_statname_aux_lob_piece";
const char *const OB_WR_SYSSTAT_AUX_LOB_PIECE_TNAME = "__wr_sysstat_aux_lob_piece";
const char *const OB_ALL_BALANCE_TASK_HELPER_AUX_LOB_PIECE_TNAME = "__all_balance_task_helper_aux_lob_piece";
const char *const OB_ALL_TENANT_SNAPSHOT_AUX_LOB_PIECE_TNAME = "__all_tenant_snapshot_aux_lob_piece";
const char *const OB_ALL_TENANT_SNAPSHOT_LS_AUX_LOB_PIECE_TNAME = "__all_tenant_snapshot_ls_aux_lob_piece";
const char *const OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_AUX_LOB_PIECE_TNAME = "__all_tenant_snapshot_ls_replica_aux_lob_piece";
const char *const OB_ALL_MLOG_AUX_LOB_PIECE_TNAME = "__all_mlog_aux_lob_piece";
const char *const OB_ALL_MVIEW_AUX_LOB_PIECE_TNAME = "__all_mview_aux_lob_piece";
const char *const OB_ALL_MVIEW_REFRESH_STATS_SYS_DEFAULTS_AUX_LOB_PIECE_TNAME = "__all_mview_refresh_stats_sys_defaults_aux_lob_piece";
const char *const OB_ALL_MVIEW_REFRESH_STATS_PARAMS_AUX_LOB_PIECE_TNAME = "__all_mview_refresh_stats_params_aux_lob_piece";
const char *const OB_ALL_MVIEW_REFRESH_RUN_STATS_AUX_LOB_PIECE_TNAME = "__all_mview_refresh_run_stats_aux_lob_piece";
const char *const OB_ALL_MVIEW_REFRESH_STATS_AUX_LOB_PIECE_TNAME = "__all_mview_refresh_stats_aux_lob_piece";
const char *const OB_ALL_MVIEW_REFRESH_CHANGE_STATS_AUX_LOB_PIECE_TNAME = "__all_mview_refresh_change_stats_aux_lob_piece";
const char *const OB_ALL_MVIEW_REFRESH_STMT_STATS_AUX_LOB_PIECE_TNAME = "__all_mview_refresh_stmt_stats_aux_lob_piece";
const char *const OB_ALL_DBMS_LOCK_ALLOCATED_AUX_LOB_PIECE_TNAME = "__all_dbms_lock_allocated_aux_lob_piece";
const char *const OB_WR_CONTROL_AUX_LOB_PIECE_TNAME = "__wr_control_aux_lob_piece";
const char *const OB_ALL_TENANT_EVENT_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_event_history_aux_lob_piece";
const char *const OB_ALL_TENANT_SCHEDULER_JOB_CLASS_AUX_LOB_PIECE_TNAME = "__all_tenant_scheduler_job_class_aux_lob_piece";
const char *const OB_ALL_RECOVER_TABLE_JOB_AUX_LOB_PIECE_TNAME = "__all_recover_table_job_aux_lob_piece";
const char *const OB_ALL_RECOVER_TABLE_JOB_HISTORY_AUX_LOB_PIECE_TNAME = "__all_recover_table_job_history_aux_lob_piece";
const char *const OB_ALL_IMPORT_TABLE_JOB_AUX_LOB_PIECE_TNAME = "__all_import_table_job_aux_lob_piece";
const char *const OB_ALL_IMPORT_TABLE_JOB_HISTORY_AUX_LOB_PIECE_TNAME = "__all_import_table_job_history_aux_lob_piece";
const char *const OB_ALL_IMPORT_TABLE_TASK_AUX_LOB_PIECE_TNAME = "__all_import_table_task_aux_lob_piece";
const char *const OB_ALL_IMPORT_TABLE_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_import_table_task_history_aux_lob_piece";
const char *const OB_ALL_TABLET_REORGANIZE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tablet_reorganize_history_aux_lob_piece";
const char *const OB_ALL_STORAGE_HA_ERROR_DIAGNOSE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_storage_ha_error_diagnose_history_aux_lob_piece";
const char *const OB_ALL_STORAGE_HA_PERF_DIAGNOSE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_storage_ha_perf_diagnose_history_aux_lob_piece";
const char *const OB_ALL_CLONE_JOB_AUX_LOB_PIECE_TNAME = "__all_clone_job_aux_lob_piece";
const char *const OB_ALL_CLONE_JOB_HISTORY_AUX_LOB_PIECE_TNAME = "__all_clone_job_history_aux_lob_piece";
const char *const OB_WR_SYSTEM_EVENT_AUX_LOB_PIECE_TNAME = "__wr_system_event_aux_lob_piece";
const char *const OB_WR_EVENT_NAME_AUX_LOB_PIECE_TNAME = "__wr_event_name_aux_lob_piece";
const char *const OB_ALL_ROUTINE_PRIVILEGE_AUX_LOB_PIECE_TNAME = "__all_routine_privilege_aux_lob_piece";
const char *const OB_ALL_ROUTINE_PRIVILEGE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_routine_privilege_history_aux_lob_piece";
const char *const OB_WR_SQLSTAT_AUX_LOB_PIECE_TNAME = "__wr_sqlstat_aux_lob_piece";
const char *const OB_ALL_NCOMP_DLL_AUX_LOB_PIECE_TNAME = "__all_ncomp_dll_aux_lob_piece";
const char *const OB_ALL_AUX_STAT_AUX_LOB_PIECE_TNAME = "__all_aux_stat_aux_lob_piece";
const char *const OB_ALL_INDEX_USAGE_INFO_AUX_LOB_PIECE_TNAME = "__all_index_usage_info_aux_lob_piece";
const char *const OB_ALL_DETECT_LOCK_INFO_AUX_LOB_PIECE_TNAME = "__all_detect_lock_info_aux_lob_piece";
const char *const OB_ALL_CLIENT_TO_SERVER_SESSION_INFO_AUX_LOB_PIECE_TNAME = "__all_client_to_server_session_info_aux_lob_piece";
const char *const OB_ALL_TRANSFER_PARTITION_TASK_AUX_LOB_PIECE_TNAME = "__all_transfer_partition_task_aux_lob_piece";
const char *const OB_ALL_TRANSFER_PARTITION_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_transfer_partition_task_history_aux_lob_piece";
const char *const OB_ALL_TENANT_SNAPSHOT_JOB_AUX_LOB_PIECE_TNAME = "__all_tenant_snapshot_job_aux_lob_piece";
const char *const OB_WR_SQLTEXT_AUX_LOB_PIECE_TNAME = "__wr_sqltext_aux_lob_piece";
const char *const OB_ALL_TRUSTED_ROOT_CERTIFICATE_AUX_LOB_PIECE_TNAME = "__all_trusted_root_certificate_aux_lob_piece";
const char *const OB_ALL_AUDIT_LOG_FILTER_AUX_LOB_PIECE_TNAME = "__all_audit_log_filter_aux_lob_piece";
const char *const OB_ALL_AUDIT_LOG_USER_AUX_LOB_PIECE_TNAME = "__all_audit_log_user_aux_lob_piece";
const char *const OB_ALL_COLUMN_PRIVILEGE_AUX_LOB_PIECE_TNAME = "__all_column_privilege_aux_lob_piece";
const char *const OB_ALL_COLUMN_PRIVILEGE_HISTORY_AUX_LOB_PIECE_TNAME = "__all_column_privilege_history_aux_lob_piece";
const char *const OB_ALL_TENANT_SNAPSHOT_LS_REPLICA_HISTORY_AUX_LOB_PIECE_TNAME = "__all_tenant_snapshot_ls_replica_history_aux_lob_piece";
const char *const OB_ALL_LS_REPLICA_TASK_HISTORY_AUX_LOB_PIECE_TNAME = "__all_ls_replica_task_history_aux_lob_piece";
const char *const OB_ALL_TABLET_CHECKSUM_ERROR_INFO_AUX_LOB_PIECE_TNAME = "__all_tablet_checksum_error_info_aux_lob_piece";
const char *const OB_ALL_USER_PROXY_INFO_AUX_LOB_PIECE_TNAME = "__all_user_proxy_info_aux_lob_piece";
const char *const OB_ALL_USER_PROXY_INFO_HISTORY_AUX_LOB_PIECE_TNAME = "__all_user_proxy_info_history_aux_lob_piece";
const char *const OB_ALL_USER_PROXY_ROLE_INFO_AUX_LOB_PIECE_TNAME = "__all_user_proxy_role_info_aux_lob_piece";
const char *const OB_ALL_USER_PROXY_ROLE_INFO_HISTORY_AUX_LOB_PIECE_TNAME = "__all_user_proxy_role_info_history_aux_lob_piece";
const char *const OB_ALL_SERVICE_AUX_LOB_PIECE_TNAME = "__all_service_aux_lob_piece";
const char *const OB_ALL_STORAGE_IO_USAGE_AUX_LOB_PIECE_TNAME = "__all_storage_io_usage_aux_lob_piece";
const char *const OB_ALL_MVIEW_DEP_AUX_LOB_PIECE_TNAME = "__all_mview_dep_aux_lob_piece";
const char *const OB_ALL_SCHEDULER_JOB_RUN_DETAIL_V2_AUX_LOB_PIECE_TNAME = "__all_scheduler_job_run_detail_v2_aux_lob_piece";
const char *const OB_ALL_SPM_EVO_RESULT_AUX_LOB_PIECE_TNAME = "__all_spm_evo_result_aux_lob_piece";
const char *const OB_ALL_PKG_TYPE_AUX_LOB_PIECE_TNAME = "__all_pkg_type_aux_lob_piece";
const char *const OB_ALL_PKG_TYPE_ATTR_AUX_LOB_PIECE_TNAME = "__all_pkg_type_attr_aux_lob_piece";
const char *const OB_ALL_PKG_COLL_TYPE_AUX_LOB_PIECE_TNAME = "__all_pkg_coll_type_aux_lob_piece";
const char *const OB_WR_SQL_PLAN_AUX_LOB_PIECE_TNAME = "__wr_sql_plan_aux_lob_piece";
const char *const OB_ALL_KV_REDIS_TABLE_AUX_LOB_PIECE_TNAME = "__all_kv_redis_table_aux_lob_piece";
const char *const OB_ALL_NCOMP_DLL_V2_AUX_LOB_PIECE_TNAME = "__all_ncomp_dll_v2_aux_lob_piece";
const char *const OB_FT_DICT_IK_UTF8_AUX_LOB_PIECE_TNAME = "__ft_dict_ik_utf8_aux_lob_piece";
const char *const OB_FT_STOPWORD_IK_UTF8_AUX_LOB_PIECE_TNAME = "__ft_stopword_ik_utf8_aux_lob_piece";
const char *const OB_FT_QUANTIFIER_IK_UTF8_AUX_LOB_PIECE_TNAME = "__ft_quantifier_ik_utf8_aux_lob_piece";
const char *const OB_ALL_VIRTUAL_PLAN_CACHE_STAT_ALL_VIRTUAL_PLAN_CACHE_STAT_I1_TNAME = "__idx_11003_all_virtual_plan_cache_stat_i1";
const char *const OB_ALL_VIRTUAL_SESSION_EVENT_ALL_VIRTUAL_SESSION_EVENT_I1_TNAME = "__idx_11013_all_virtual_session_event_i1";
const char *const OB_ALL_VIRTUAL_SESSION_WAIT_ALL_VIRTUAL_SESSION_WAIT_I1_TNAME = "__idx_11014_all_virtual_session_wait_i1";
const char *const OB_ALL_VIRTUAL_SESSION_WAIT_HISTORY_ALL_VIRTUAL_SESSION_WAIT_HISTORY_I1_TNAME = "__idx_11015_all_virtual_session_wait_history_i1";
const char *const OB_ALL_VIRTUAL_SYSTEM_EVENT_ALL_VIRTUAL_SYSTEM_EVENT_I1_TNAME = "__idx_11017_all_virtual_system_event_i1";
const char *const OB_ALL_VIRTUAL_SESSTAT_ALL_VIRTUAL_SESSTAT_I1_TNAME = "__idx_11020_all_virtual_sesstat_i1";
const char *const OB_ALL_VIRTUAL_SYSSTAT_ALL_VIRTUAL_SYSSTAT_I1_TNAME = "__idx_11021_all_virtual_sysstat_i1";
const char *const OB_ALL_VIRTUAL_SQL_AUDIT_ALL_VIRTUAL_SQL_AUDIT_I1_TNAME = "__idx_11031_all_virtual_sql_audit_i1";
const char *const OB_ALL_VIRTUAL_SQL_PLAN_MONITOR_ALL_VIRTUAL_SQL_PLAN_MONITOR_I1_TNAME = "__idx_12185_all_virtual_sql_plan_monitor_i1";
const char *const OB_ALL_VIRTUAL_ASH_ALL_VIRTUAL_ASH_I1_TNAME = "__idx_12302_all_virtual_ash_i1";
const char *const OB_ALL_VIRTUAL_DDL_DIAGNOSE_INFO_ALL_VIRTUAL_DDL_DIAGNOSE_INFO_I1_TNAME = "__idx_12514_all_virtual_ddl_diagnose_info_i1";
const char *const OB_ALL_VIRTUAL_SQL_AUDIT_ORA_ALL_VIRTUAL_SQL_AUDIT_I1_TNAME = "__idx_15009_all_virtual_sql_audit_i1";
const char *const OB_ALL_VIRTUAL_PLAN_CACHE_STAT_ORA_ALL_VIRTUAL_PLAN_CACHE_STAT_I1_TNAME = "__idx_15034_all_virtual_plan_cache_stat_i1";
const char *const OB_ALL_VIRTUAL_SESSION_WAIT_ORA_ALL_VIRTUAL_SESSION_WAIT_I1_TNAME = "__idx_15036_all_virtual_session_wait_i1";
const char *const OB_ALL_VIRTUAL_SESSION_WAIT_HISTORY_ORA_ALL_VIRTUAL_SESSION_WAIT_HISTORY_I1_TNAME = "__idx_15037_all_virtual_session_wait_history_i1";
const char *const OB_ALL_VIRTUAL_SESSTAT_ORA_ALL_VIRTUAL_SESSTAT_I1_TNAME = "__idx_15042_all_virtual_sesstat_i1";
const char *const OB_ALL_VIRTUAL_SYSSTAT_ORA_ALL_VIRTUAL_SYSSTAT_I1_TNAME = "__idx_15043_all_virtual_sysstat_i1";
const char *const OB_ALL_VIRTUAL_SYSTEM_EVENT_ORA_ALL_VIRTUAL_SYSTEM_EVENT_I1_TNAME = "__idx_15044_all_virtual_system_event_i1";
const char *const OB_ALL_VIRTUAL_SQL_PLAN_MONITOR_ORA_ALL_VIRTUAL_SQL_PLAN_MONITOR_I1_TNAME = "__idx_15100_all_virtual_sql_plan_monitor_i1";
const char *const OB_ALL_VIRTUAL_ASH_ORA_ALL_VIRTUAL_ASH_I1_TNAME = "__idx_15236_all_virtual_ash_i1";
const char *const OB_ALL_TABLE_IDX_DATA_TABLE_ID_TNAME = "__idx_3_idx_data_table_id";
const char *const OB_ALL_TABLE_IDX_DB_TB_NAME_TNAME = "__idx_3_idx_db_tb_name";
const char *const OB_ALL_TABLE_IDX_TB_NAME_TNAME = "__idx_3_idx_tb_name";
const char *const OB_ALL_COLUMN_IDX_TB_COLUMN_NAME_TNAME = "__idx_4_idx_tb_column_name";
const char *const OB_ALL_COLUMN_IDX_COLUMN_NAME_TNAME = "__idx_4_idx_column_name";
const char *const OB_ALL_DDL_OPERATION_IDX_DDL_TYPE_TNAME = "__idx_5_idx_ddl_type";
const char *const OB_ALL_TABLE_HISTORY_IDX_DATA_TABLE_ID_TNAME = "__idx_114_idx_data_table_id";
const char *const OB_ALL_LOG_ARCHIVE_PIECE_FILES_IDX_STATUS_TNAME = "__idx_350_idx_status";
const char *const OB_ALL_BACKUP_SET_FILES_IDX_STATUS_TNAME = "__idx_315_idx_status";
const char *const OB_ALL_DDL_TASK_STATUS_IDX_TASK_KEY_TNAME = "__idx_319_idx_task_key";
const char *const OB_ALL_USER_IDX_UR_NAME_TNAME = "__idx_102_idx_ur_name";
const char *const OB_ALL_DATABASE_IDX_DB_NAME_TNAME = "__idx_104_idx_db_name";
const char *const OB_ALL_TABLEGROUP_IDX_TG_NAME_TNAME = "__idx_106_idx_tg_name";
const char *const OB_ALL_TENANT_HISTORY_IDX_TENANT_DELETED_TNAME = "__idx_109_idx_tenant_deleted";
const char *const OB_ALL_ROOTSERVICE_EVENT_HISTORY_IDX_RS_MODULE_TNAME = "__idx_140_idx_rs_module";
const char *const OB_ALL_ROOTSERVICE_EVENT_HISTORY_IDX_RS_EVENT_TNAME = "__idx_140_idx_rs_event";
const char *const OB_ALL_RECYCLEBIN_IDX_RECYCLEBIN_DB_TYPE_TNAME = "__idx_145_idx_recyclebin_db_type";
const char *const OB_ALL_PART_IDX_PART_NAME_TNAME = "__idx_146_idx_part_name";
const char *const OB_ALL_SUB_PART_IDX_SUB_PART_NAME_TNAME = "__idx_148_idx_sub_part_name";
const char *const OB_ALL_DEF_SUB_PART_IDX_DEF_SUB_PART_NAME_TNAME = "__idx_152_idx_def_sub_part_name";
const char *const OB_ALL_SERVER_EVENT_HISTORY_IDX_SERVER_MODULE_TNAME = "__idx_154_idx_server_module";
const char *const OB_ALL_SERVER_EVENT_HISTORY_IDX_SERVER_EVENT_TNAME = "__idx_154_idx_server_event";
const char *const OB_ALL_ROOTSERVICE_JOB_IDX_RS_JOB_TYPE_TNAME = "__idx_155_idx_rs_job_type";
const char *const OB_ALL_FOREIGN_KEY_IDX_FK_CHILD_TID_TNAME = "__idx_166_idx_fk_child_tid";
const char *const OB_ALL_FOREIGN_KEY_IDX_FK_PARENT_TID_TNAME = "__idx_166_idx_fk_parent_tid";
const char *const OB_ALL_FOREIGN_KEY_IDX_FK_NAME_TNAME = "__idx_166_idx_fk_name";
const char *const OB_ALL_FOREIGN_KEY_HISTORY_IDX_FK_HIS_CHILD_TID_TNAME = "__idx_167_idx_fk_his_child_tid";
const char *const OB_ALL_FOREIGN_KEY_HISTORY_IDX_FK_HIS_PARENT_TID_TNAME = "__idx_167_idx_fk_his_parent_tid";
const char *const OB_ALL_SYNONYM_IDX_DB_SYNONYM_NAME_TNAME = "__idx_180_idx_db_synonym_name";
const char *const OB_ALL_SYNONYM_IDX_SYNONYM_NAME_TNAME = "__idx_180_idx_synonym_name";
const char *const OB_ALL_DDL_CHECKSUM_IDX_DDL_CHECKSUM_TASK_TNAME = "__idx_188_idx_ddl_checksum_task";
const char *const OB_ALL_ROUTINE_IDX_DB_ROUTINE_NAME_TNAME = "__idx_189_idx_db_routine_name";
const char *const OB_ALL_ROUTINE_IDX_ROUTINE_NAME_TNAME = "__idx_189_idx_routine_name";
const char *const OB_ALL_ROUTINE_IDX_ROUTINE_PKG_ID_TNAME = "__idx_189_idx_routine_pkg_id";
const char *const OB_ALL_ROUTINE_PARAM_IDX_ROUTINE_PARAM_NAME_TNAME = "__idx_191_idx_routine_param_name";
const char *const OB_ALL_PACKAGE_IDX_DB_PKG_NAME_TNAME = "__idx_196_idx_db_pkg_name";
const char *const OB_ALL_PACKAGE_IDX_PKG_NAME_TNAME = "__idx_196_idx_pkg_name";
const char *const OB_ALL_ACQUIRED_SNAPSHOT_IDX_SNAPSHOT_TABLET_TNAME = "__idx_202_idx_snapshot_tablet";
const char *const OB_ALL_CONSTRAINT_IDX_CST_NAME_TNAME = "__idx_206_idx_cst_name";
const char *const OB_ALL_TYPE_IDX_DB_TYPE_NAME_TNAME = "__idx_220_idx_db_type_name";
const char *const OB_ALL_TYPE_IDX_TYPE_NAME_TNAME = "__idx_220_idx_type_name";
const char *const OB_ALL_TYPE_ATTR_IDX_TYPE_ATTR_NAME_TNAME = "__idx_222_idx_type_attr_name";
const char *const OB_ALL_COLL_TYPE_IDX_COLL_NAME_TYPE_TNAME = "__idx_224_idx_coll_name_type";
const char *const OB_ALL_DBLINK_IDX_OWNER_DBLINK_NAME_TNAME = "__idx_232_idx_owner_dblink_name";
const char *const OB_ALL_DBLINK_IDX_DBLINK_NAME_TNAME = "__idx_232_idx_dblink_name";
const char *const OB_ALL_TENANT_ROLE_GRANTEE_MAP_IDX_GRANTEE_ROLE_ID_TNAME = "__idx_235_idx_grantee_role_id";
const char *const OB_ALL_TENANT_ROLE_GRANTEE_MAP_HISTORY_IDX_GRANTEE_HIS_ROLE_ID_TNAME = "__idx_236_idx_grantee_his_role_id";
const char *const OB_ALL_TENANT_KEYSTORE_IDX_KEYSTORE_MASTER_KEY_ID_TNAME = "__idx_237_idx_keystore_master_key_id";
const char *const OB_ALL_TENANT_KEYSTORE_HISTORY_IDX_KEYSTORE_HIS_MASTER_KEY_ID_TNAME = "__idx_238_idx_keystore_his_master_key_id";
const char *const OB_ALL_TENANT_OLS_POLICY_IDX_OLS_POLICY_NAME_TNAME = "__idx_239_idx_ols_policy_name";
const char *const OB_ALL_TENANT_OLS_POLICY_IDX_OLS_POLICY_COL_NAME_TNAME = "__idx_239_idx_ols_policy_col_name";
const char *const OB_ALL_TENANT_OLS_COMPONENT_IDX_OLS_COM_POLICY_ID_TNAME = "__idx_241_idx_ols_com_policy_id";
const char *const OB_ALL_TENANT_OLS_LABEL_IDX_OLS_LAB_POLICY_ID_TNAME = "__idx_243_idx_ols_lab_policy_id";
const char *const OB_ALL_TENANT_OLS_LABEL_IDX_OLS_LAB_TAG_TNAME = "__idx_243_idx_ols_lab_tag";
const char *const OB_ALL_TENANT_OLS_LABEL_IDX_OLS_LAB_TNAME = "__idx_243_idx_ols_lab";
const char *const OB_ALL_TENANT_OLS_USER_LEVEL_IDX_OLS_LEVEL_UID_TNAME = "__idx_245_idx_ols_level_uid";
const char *const OB_ALL_TENANT_OLS_USER_LEVEL_IDX_OLS_LEVEL_POLICY_ID_TNAME = "__idx_245_idx_ols_level_policy_id";
const char *const OB_ALL_TENANT_PROFILE_IDX_PROFILE_NAME_TNAME = "__idx_250_idx_profile_name";
const char *const OB_ALL_TENANT_SECURITY_AUDIT_IDX_AUDIT_TYPE_TNAME = "__idx_252_idx_audit_type";
const char *const OB_ALL_TENANT_TRIGGER_IDX_TRIGGER_BASE_OBJ_ID_TNAME = "__idx_254_idx_trigger_base_obj_id";
const char *const OB_ALL_TENANT_TRIGGER_IDX_DB_TRIGGER_NAME_TNAME = "__idx_254_idx_db_trigger_name";
const char *const OB_ALL_TENANT_TRIGGER_IDX_TRIGGER_NAME_TNAME = "__idx_254_idx_trigger_name";
const char *const OB_ALL_TENANT_TRIGGER_HISTORY_IDX_TRIGGER_HIS_BASE_OBJ_ID_TNAME = "__idx_255_idx_trigger_his_base_obj_id";
const char *const OB_ALL_TENANT_OBJAUTH_IDX_OBJAUTH_GRANTOR_TNAME = "__idx_262_idx_objauth_grantor";
const char *const OB_ALL_TENANT_OBJAUTH_IDX_OBJAUTH_GRANTEE_TNAME = "__idx_262_idx_objauth_grantee";
const char *const OB_ALL_TENANT_OBJECT_TYPE_IDX_OBJ_TYPE_DB_OBJ_NAME_TNAME = "__idx_283_idx_obj_type_db_obj_name";
const char *const OB_ALL_TENANT_OBJECT_TYPE_IDX_OBJ_TYPE_OBJ_NAME_TNAME = "__idx_283_idx_obj_type_obj_name";
const char *const OB_ALL_TENANT_GLOBAL_TRANSACTION_IDX_XA_TRANS_ID_TNAME = "__idx_296_idx_xa_trans_id";
const char *const OB_ALL_TENANT_DEPENDENCY_IDX_DEPENDENCY_REF_OBJ_TNAME = "__idx_297_idx_dependency_ref_obj";
const char *const OB_ALL_DDL_ERROR_MESSAGE_IDX_DDL_ERROR_OBJECT_TNAME = "__idx_308_idx_ddl_error_object";
const char *const OB_ALL_TABLE_STAT_HISTORY_IDX_TABLE_STAT_HIS_SAVTIME_TNAME = "__idx_332_idx_table_stat_his_savtime";
const char *const OB_ALL_COLUMN_STAT_HISTORY_IDX_COLUMN_STAT_HIS_SAVTIME_TNAME = "__idx_333_idx_column_stat_his_savtime";
const char *const OB_ALL_HISTOGRAM_STAT_HISTORY_IDX_HISTOGRAM_STAT_HIS_SAVTIME_TNAME = "__idx_334_idx_histogram_stat_his_savtime";
const char *const OB_ALL_TABLET_TO_LS_IDX_TABLET_TO_LS_ID_TNAME = "__idx_343_idx_tablet_to_ls_id";
const char *const OB_ALL_TABLET_TO_LS_IDX_TABLET_TO_TABLE_ID_TNAME = "__idx_343_idx_tablet_to_table_id";
const char *const OB_ALL_PENDING_TRANSACTION_IDX_PENDING_TX_ID_TNAME = "__idx_375_idx_pending_tx_id";
const char *const OB_ALL_CONTEXT_IDX_CTX_NAMESPACE_TNAME = "__idx_381_idx_ctx_namespace";
const char *const OB_ALL_PLAN_BASELINE_ITEM_IDX_SPM_ITEM_SQL_ID_TNAME = "__idx_397_idx_spm_item_sql_id";
const char *const OB_ALL_PLAN_BASELINE_ITEM_IDX_SPM_ITEM_VALUE_TNAME = "__idx_397_idx_spm_item_value";
const char *const OB_ALL_TENANT_DIRECTORY_IDX_DIRECTORY_NAME_TNAME = "__idx_326_idx_directory_name";
const char *const OB_ALL_JOB_IDX_JOB_POWNER_TNAME = "__idx_324_idx_job_powner";
const char *const OB_ALL_SEQUENCE_OBJECT_IDX_SEQ_OBJ_DB_NAME_TNAME = "__idx_213_idx_seq_obj_db_name";
const char *const OB_ALL_SEQUENCE_OBJECT_IDX_SEQ_OBJ_NAME_TNAME = "__idx_213_idx_seq_obj_name";
const char *const OB_ALL_RECYCLEBIN_IDX_RECYCLEBIN_ORI_NAME_TNAME = "__idx_145_idx_recyclebin_ori_name";
const char *const OB_ALL_TABLE_PRIVILEGE_IDX_TB_PRIV_DB_NAME_TNAME = "__idx_110_idx_tb_priv_db_name";
const char *const OB_ALL_TABLE_PRIVILEGE_IDX_TB_PRIV_TB_NAME_TNAME = "__idx_110_idx_tb_priv_tb_name";
const char *const OB_ALL_DATABASE_PRIVILEGE_IDX_DB_PRIV_DB_NAME_TNAME = "__idx_112_idx_db_priv_db_name";
const char *const OB_ALL_RLS_POLICY_IDX_RLS_POLICY_TABLE_ID_TNAME = "__idx_433_idx_rls_policy_table_id";
const char *const OB_ALL_RLS_POLICY_IDX_RLS_POLICY_GROUP_ID_TNAME = "__idx_433_idx_rls_policy_group_id";
const char *const OB_ALL_RLS_POLICY_HISTORY_IDX_RLS_POLICY_HIS_TABLE_ID_TNAME = "__idx_434_idx_rls_policy_his_table_id";
const char *const OB_ALL_RLS_GROUP_IDX_RLS_GROUP_TABLE_ID_TNAME = "__idx_437_idx_rls_group_table_id";
const char *const OB_ALL_RLS_GROUP_HISTORY_IDX_RLS_GROUP_HIS_TABLE_ID_TNAME = "__idx_438_idx_rls_group_his_table_id";
const char *const OB_ALL_RLS_CONTEXT_IDX_RLS_CONTEXT_TABLE_ID_TNAME = "__idx_439_idx_rls_context_table_id";
const char *const OB_ALL_RLS_CONTEXT_HISTORY_IDX_RLS_CONTEXT_HIS_TABLE_ID_TNAME = "__idx_440_idx_rls_context_his_table_id";
const char *const OB_ALL_TENANT_SNAPSHOT_IDX_TENANT_SNAPSHOT_NAME_TNAME = "__idx_460_idx_tenant_snapshot_name";
const char *const OB_ALL_DBMS_LOCK_ALLOCATED_IDX_DBMS_LOCK_ALLOCATED_LOCKHANDLE_TNAME = "__idx_471_idx_dbms_lock_allocated_lockhandle";
const char *const OB_ALL_DBMS_LOCK_ALLOCATED_IDX_DBMS_LOCK_ALLOCATED_EXPIRATION_TNAME = "__idx_471_idx_dbms_lock_allocated_expiration";
const char *const OB_ALL_TABLET_REORGANIZE_HISTORY_IDX_TABLET_HIS_TABLE_ID_SRC_TNAME = "__idx_482_idx_tablet_his_table_id_src";
const char *const OB_ALL_KV_TTL_TASK_IDX_KV_TTL_TASK_TABLE_ID_TNAME = "__idx_410_idx_kv_ttl_task_table_id";
const char *const OB_ALL_KV_TTL_TASK_HISTORY_IDX_KV_TTL_TASK_HISTORY_UPD_TIME_TNAME = "__idx_411_idx_kv_ttl_task_history_upd_time";
const char *const OB_ALL_MVIEW_REFRESH_RUN_STATS_IDX_MVIEW_REFRESH_RUN_STATS_NUM_MVS_CURRENT_TNAME = "__idx_467_idx_mview_refresh_run_stats_num_mvs_current";
const char *const OB_ALL_MVIEW_REFRESH_STATS_IDX_MVIEW_REFRESH_STATS_END_TIME_TNAME = "__idx_468_idx_mview_refresh_stats_end_time";
const char *const OB_ALL_MVIEW_REFRESH_STATS_IDX_MVIEW_REFRESH_STATS_MVIEW_END_TIME_TNAME = "__idx_468_idx_mview_refresh_stats_mview_end_time";
const char *const OB_ALL_TRANSFER_PARTITION_TASK_IDX_TRANSFER_PARTITION_KEY_TNAME = "__idx_498_idx_transfer_partition_key";
const char *const OB_ALL_CLIENT_TO_SERVER_SESSION_INFO_IDX_CLIENT_TO_SERVER_SESSION_INFO_CLIENT_SESSION_ID_TNAME = "__idx_497_idx_client_to_server_session_info_client_session_id";
const char *const OB_ALL_COLUMN_PRIVILEGE_IDX_COLUMN_PRIVILEGE_NAME_TNAME = "__idx_505_idx_column_privilege_name";
const char *const OB_ALL_USER_PROXY_INFO_IDX_USER_PROXY_INFO_PROXY_USER_ID_TNAME = "__idx_512_idx_user_proxy_info_proxy_user_id";
const char *const OB_ALL_USER_PROXY_INFO_HISTORY_IDX_USER_PROXY_INFO_PROXY_USER_ID_HISTORY_TNAME = "__idx_513_idx_user_proxy_info_proxy_user_id_history";
const char *const OB_ALL_USER_PROXY_ROLE_INFO_HISTORY_IDX_USER_PROXY_ROLE_INFO_PROXY_USER_ID_HISTORY_TNAME = "__idx_515_idx_user_proxy_role_info_proxy_user_id_history";
const char *const OB_ALL_SCHEDULER_JOB_RUN_DETAIL_V2_IDX_SCHEDULER_JOB_RUN_DETAIL_V2_TIME_TNAME = "__idx_519_idx_scheduler_job_run_detail_v2_time";
const char *const OB_ALL_SCHEDULER_JOB_RUN_DETAIL_V2_IDX_SCHEDULER_JOB_RUN_DETAIL_V2_JOB_CLASS_TIME_TNAME = "__idx_519_idx_scheduler_job_run_detail_v2_job_class_time";
const char *const OB_ALL_PKG_TYPE_IDX_PKG_DB_TYPE_NAME_TNAME = "__idx_522_idx_pkg_db_type_name";
const char *const OB_ALL_PKG_TYPE_IDX_PKG_TYPE_NAME_TNAME = "__idx_522_idx_pkg_type_name";
const char *const OB_ALL_PKG_TYPE_ATTR_IDX_PKG_TYPE_ATTR_NAME_TNAME = "__idx_523_idx_pkg_type_attr_name";
const char *const OB_ALL_PKG_TYPE_ATTR_IDX_PKG_TYPE_ATTR_ID_TNAME = "__idx_523_idx_pkg_type_attr_id";
const char *const OB_ALL_PKG_COLL_TYPE_IDX_PKG_COLL_NAME_TYPE_TNAME = "__idx_524_idx_pkg_coll_name_type";
const char *const OB_ALL_PKG_COLL_TYPE_IDX_PKG_COLL_NAME_ID_TNAME = "__idx_524_idx_pkg_coll_name_id";
const char *const OB_ALL_TABLET_REORGANIZE_HISTORY_IDX_TABLET_HIS_TABLE_ID_DEST_TNAME = "__idx_482_idx_tablet_his_table_id_dest";
const char *const OB_ALL_VIRTUAL_TABLE_REAL_AGENT_ORA_IDX_DATA_TABLE_ID_REAL_AGENT_TNAME = "__idx_15120_idx_data_table_id_real_agent";
const char *const OB_ALL_VIRTUAL_TABLE_REAL_AGENT_ORA_IDX_DB_TB_NAME_REAL_AGENT_TNAME = "__idx_15120_idx_db_tb_name_real_agent";
const char *const OB_ALL_VIRTUAL_TABLE_REAL_AGENT_ORA_IDX_TB_NAME_REAL_AGENT_TNAME = "__idx_15120_idx_tb_name_real_agent";
const char *const OB_ALL_VIRTUAL_COLUMN_REAL_AGENT_ORA_IDX_TB_COLUMN_NAME_REAL_AGENT_TNAME = "__idx_15121_idx_tb_column_name_real_agent";
const char *const OB_ALL_VIRTUAL_COLUMN_REAL_AGENT_ORA_IDX_COLUMN_NAME_REAL_AGENT_TNAME = "__idx_15121_idx_column_name_real_agent";
const char *const OB_ALL_VIRTUAL_USER_REAL_AGENT_ORA_IDX_UR_NAME_REAL_AGENT_TNAME = "__idx_15129_idx_ur_name_real_agent";
const char *const OB_ALL_VIRTUAL_DATABASE_REAL_AGENT_ORA_IDX_DB_NAME_REAL_AGENT_TNAME = "__idx_15122_idx_db_name_real_agent";
const char *const OB_ALL_VIRTUAL_TABLEGROUP_REAL_AGENT_ORA_IDX_TG_NAME_REAL_AGENT_TNAME = "__idx_15137_idx_tg_name_real_agent";
const char *const OB_ALL_VIRTUAL_RECYCLEBIN_REAL_AGENT_ORA_IDX_RECYCLEBIN_DB_TYPE_REAL_AGENT_TNAME = "__idx_15135_idx_recyclebin_db_type_real_agent";
const char *const OB_ALL_VIRTUAL_PART_REAL_AGENT_ORA_IDX_PART_NAME_REAL_AGENT_TNAME = "__idx_15124_idx_part_name_real_agent";
const char *const OB_ALL_VIRTUAL_SUB_PART_REAL_AGENT_ORA_IDX_SUB_PART_NAME_REAL_AGENT_TNAME = "__idx_15125_idx_sub_part_name_real_agent";
const char *const OB_ALL_VIRTUAL_DEF_SUB_PART_REAL_AGENT_ORA_IDX_DEF_SUB_PART_NAME_REAL_AGENT_TNAME = "__idx_15163_idx_def_sub_part_name_real_agent";
const char *const OB_ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA_IDX_FK_CHILD_TID_REAL_AGENT_TNAME = "__idx_15131_idx_fk_child_tid_real_agent";
const char *const OB_ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA_IDX_FK_PARENT_TID_REAL_AGENT_TNAME = "__idx_15131_idx_fk_parent_tid_real_agent";
const char *const OB_ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT_ORA_IDX_FK_NAME_REAL_AGENT_TNAME = "__idx_15131_idx_fk_name_real_agent";
const char *const OB_ALL_VIRTUAL_SYNONYM_REAL_AGENT_ORA_IDX_DB_SYNONYM_NAME_REAL_AGENT_TNAME = "__idx_15130_idx_db_synonym_name_real_agent";
const char *const OB_ALL_VIRTUAL_SYNONYM_REAL_AGENT_ORA_IDX_SYNONYM_NAME_REAL_AGENT_TNAME = "__idx_15130_idx_synonym_name_real_agent";
const char *const OB_ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA_IDX_DB_ROUTINE_NAME_REAL_AGENT_TNAME = "__idx_15136_idx_db_routine_name_real_agent";
const char *const OB_ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA_IDX_ROUTINE_NAME_REAL_AGENT_TNAME = "__idx_15136_idx_routine_name_real_agent";
const char *const OB_ALL_VIRTUAL_ROUTINE_REAL_AGENT_ORA_IDX_ROUTINE_PKG_ID_REAL_AGENT_TNAME = "__idx_15136_idx_routine_pkg_id_real_agent";
const char *const OB_ALL_VIRTUAL_ROUTINE_PARAM_REAL_AGENT_ORA_IDX_ROUTINE_PARAM_NAME_REAL_AGENT_TNAME = "__idx_15143_idx_routine_param_name_real_agent";
const char *const OB_ALL_VIRTUAL_PACKAGE_REAL_AGENT_ORA_IDX_DB_PKG_NAME_REAL_AGENT_TNAME = "__idx_15126_idx_db_pkg_name_real_agent";
const char *const OB_ALL_VIRTUAL_PACKAGE_REAL_AGENT_ORA_IDX_PKG_NAME_REAL_AGENT_TNAME = "__idx_15126_idx_pkg_name_real_agent";
const char *const OB_ALL_VIRTUAL_CONSTRAINT_REAL_AGENT_ORA_IDX_CST_NAME_REAL_AGENT_TNAME = "__idx_15139_idx_cst_name_real_agent";
const char *const OB_ALL_VIRTUAL_TYPE_REAL_AGENT_ORA_IDX_DB_TYPE_NAME_REAL_AGENT_TNAME = "__idx_15140_idx_db_type_name_real_agent";
const char *const OB_ALL_VIRTUAL_TYPE_REAL_AGENT_ORA_IDX_TYPE_NAME_REAL_AGENT_TNAME = "__idx_15140_idx_type_name_real_agent";
const char *const OB_ALL_VIRTUAL_TYPE_ATTR_REAL_AGENT_ORA_IDX_TYPE_ATTR_NAME_REAL_AGENT_TNAME = "__idx_15141_idx_type_attr_name_real_agent";
const char *const OB_ALL_VIRTUAL_COLL_TYPE_REAL_AGENT_ORA_IDX_COLL_NAME_TYPE_REAL_AGENT_TNAME = "__idx_15142_idx_coll_name_type_real_agent";
const char *const OB_ALL_VIRTUAL_DBLINK_REAL_AGENT_ORA_IDX_OWNER_DBLINK_NAME_REAL_AGENT_TNAME = "__idx_15165_idx_owner_dblink_name_real_agent";
const char *const OB_ALL_VIRTUAL_DBLINK_REAL_AGENT_ORA_IDX_DBLINK_NAME_REAL_AGENT_TNAME = "__idx_15165_idx_dblink_name_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_ROLE_GRANTEE_MAP_REAL_AGENT_ORA_IDX_GRANTEE_ROLE_ID_REAL_AGENT_TNAME = "__idx_15152_idx_grantee_role_id_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_KEYSTORE_REAL_AGENT_ORA_IDX_KEYSTORE_MASTER_KEY_ID_REAL_AGENT_TNAME = "__idx_15145_idx_keystore_master_key_id_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_POLICY_REAL_AGENT_ORA_IDX_OLS_POLICY_NAME_REAL_AGENT_TNAME = "__idx_15146_idx_ols_policy_name_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_POLICY_REAL_AGENT_ORA_IDX_OLS_POLICY_COL_NAME_REAL_AGENT_TNAME = "__idx_15146_idx_ols_policy_col_name_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_COMPONENT_REAL_AGENT_ORA_IDX_OLS_COM_POLICY_ID_REAL_AGENT_TNAME = "__idx_15147_idx_ols_com_policy_id_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA_IDX_OLS_LAB_POLICY_ID_REAL_AGENT_TNAME = "__idx_15148_idx_ols_lab_policy_id_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA_IDX_OLS_LAB_TAG_REAL_AGENT_TNAME = "__idx_15148_idx_ols_lab_tag_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_LABEL_REAL_AGENT_ORA_IDX_OLS_LAB_REAL_AGENT_TNAME = "__idx_15148_idx_ols_lab_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_REAL_AGENT_ORA_IDX_OLS_LEVEL_UID_REAL_AGENT_TNAME = "__idx_15149_idx_ols_level_uid_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OLS_USER_LEVEL_REAL_AGENT_ORA_IDX_OLS_LEVEL_POLICY_ID_REAL_AGENT_TNAME = "__idx_15149_idx_ols_level_policy_id_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_PROFILE_REAL_AGENT_ORA_IDX_PROFILE_NAME_REAL_AGENT_TNAME = "__idx_15151_idx_profile_name_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_SECURITY_AUDIT_REAL_AGENT_ORA_IDX_AUDIT_TYPE_REAL_AGENT_TNAME = "__idx_15154_idx_audit_type_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA_IDX_TRIGGER_BASE_OBJ_ID_REAL_AGENT_TNAME = "__idx_15156_idx_trigger_base_obj_id_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA_IDX_DB_TRIGGER_NAME_REAL_AGENT_TNAME = "__idx_15156_idx_db_trigger_name_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT_ORA_IDX_TRIGGER_NAME_REAL_AGENT_TNAME = "__idx_15156_idx_trigger_name_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OBJAUTH_REAL_AGENT_ORA_IDX_OBJAUTH_GRANTOR_REAL_AGENT_TNAME = "__idx_15160_idx_objauth_grantor_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OBJAUTH_REAL_AGENT_ORA_IDX_OBJAUTH_GRANTEE_REAL_AGENT_TNAME = "__idx_15160_idx_objauth_grantee_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT_ORA_IDX_OBJ_TYPE_DB_OBJ_NAME_REAL_AGENT_TNAME = "__idx_15164_idx_obj_type_db_obj_name_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT_ORA_IDX_OBJ_TYPE_OBJ_NAME_REAL_AGENT_TNAME = "__idx_15164_idx_obj_type_obj_name_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_DEPENDENCY_REAL_AGENT_ORA_IDX_DEPENDENCY_REF_OBJ_REAL_AGENT_TNAME = "__idx_15168_idx_dependency_ref_obj_real_agent";
const char *const OB_ALL_VIRTUAL_TABLE_STAT_HISTORY_REAL_AGENT_ORA_IDX_TABLE_STAT_HIS_SAVTIME_REAL_AGENT_TNAME = "__idx_15194_idx_table_stat_his_savtime_real_agent";
const char *const OB_ALL_VIRTUAL_COLUMN_STAT_HISTORY_REAL_AGENT_ORA_IDX_COLUMN_STAT_HIS_SAVTIME_REAL_AGENT_TNAME = "__idx_15195_idx_column_stat_his_savtime_real_agent";
const char *const OB_ALL_VIRTUAL_HISTOGRAM_STAT_HISTORY_REAL_AGENT_ORA_IDX_HISTOGRAM_STAT_HIS_SAVTIME_REAL_AGENT_TNAME = "__idx_15196_idx_histogram_stat_his_savtime_real_agent";
const char *const OB_ALL_VIRTUAL_TABLET_TO_LS_REAL_AGENT_ORA_IDX_TABLET_TO_LS_ID_REAL_AGENT_TNAME = "__idx_15215_idx_tablet_to_ls_id_real_agent";
const char *const OB_ALL_VIRTUAL_TABLET_TO_LS_REAL_AGENT_ORA_IDX_TABLET_TO_TABLE_ID_REAL_AGENT_TNAME = "__idx_15215_idx_tablet_to_table_id_real_agent";
const char *const OB_ALL_VIRTUAL_CONTEXT_REAL_AGENT_ORA_IDX_CTX_NAMESPACE_REAL_AGENT_TNAME = "__idx_15204_idx_ctx_namespace_real_agent";
const char *const OB_ALL_VIRTUAL_PLAN_BASELINE_ITEM_REAL_AGENT_ORA_IDX_SPM_ITEM_SQL_ID_REAL_AGENT_TNAME = "__idx_15233_idx_spm_item_sql_id_real_agent";
const char *const OB_ALL_VIRTUAL_PLAN_BASELINE_ITEM_REAL_AGENT_ORA_IDX_SPM_ITEM_VALUE_REAL_AGENT_TNAME = "__idx_15233_idx_spm_item_value_real_agent";
const char *const OB_ALL_VIRTUAL_TENANT_DIRECTORY_REAL_AGENT_ORA_IDX_DIRECTORY_NAME_REAL_AGENT_TNAME = "__idx_15185_idx_directory_name_real_agent";
const char *const OB_ALL_VIRTUAL_JOB_REAL_AGENT_ORA_IDX_JOB_POWNER_REAL_AGENT_TNAME = "__idx_15183_idx_job_powner_real_agent";
const char *const OB_ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT_ORA_IDX_SEQ_OBJ_DB_NAME_REAL_AGENT_TNAME = "__idx_15128_idx_seq_obj_db_name_real_agent";
const char *const OB_ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT_ORA_IDX_SEQ_OBJ_NAME_REAL_AGENT_TNAME = "__idx_15128_idx_seq_obj_name_real_agent";
const char *const OB_ALL_VIRTUAL_RECYCLEBIN_REAL_AGENT_ORA_IDX_RECYCLEBIN_ORI_NAME_REAL_AGENT_TNAME = "__idx_15135_idx_recyclebin_ori_name_real_agent";
const char *const OB_ALL_VIRTUAL_TABLE_PRIVILEGE_REAL_AGENT_ORA_IDX_TB_PRIV_DB_NAME_REAL_AGENT_TNAME = "__idx_15153_idx_tb_priv_db_name_real_agent";
const char *const OB_ALL_VIRTUAL_TABLE_PRIVILEGE_REAL_AGENT_ORA_IDX_TB_PRIV_TB_NAME_REAL_AGENT_TNAME = "__idx_15153_idx_tb_priv_tb_name_real_agent";
const char *const OB_ALL_VIRTUAL_DATABASE_PRIVILEGE_REAL_AGENT_ORA_IDX_DB_PRIV_DB_NAME_REAL_AGENT_TNAME = "__idx_15275_idx_db_priv_db_name_real_agent";
const char *const OB_ALL_VIRTUAL_RLS_POLICY_REAL_AGENT_ORA_IDX_RLS_POLICY_TABLE_ID_REAL_AGENT_TNAME = "__idx_15276_idx_rls_policy_table_id_real_agent";
const char *const OB_ALL_VIRTUAL_RLS_POLICY_REAL_AGENT_ORA_IDX_RLS_POLICY_GROUP_ID_REAL_AGENT_TNAME = "__idx_15276_idx_rls_policy_group_id_real_agent";
const char *const OB_ALL_VIRTUAL_RLS_GROUP_REAL_AGENT_ORA_IDX_RLS_GROUP_TABLE_ID_REAL_AGENT_TNAME = "__idx_15278_idx_rls_group_table_id_real_agent";
const char *const OB_ALL_VIRTUAL_RLS_CONTEXT_REAL_AGENT_ORA_IDX_RLS_CONTEXT_TABLE_ID_REAL_AGENT_TNAME = "__idx_15279_idx_rls_context_table_id_real_agent";
const char *const OB_ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_REAL_AGENT_ORA_IDX_DBMS_LOCK_ALLOCATED_LOCKHANDLE_REAL_AGENT_TNAME = "__idx_15397_idx_dbms_lock_allocated_lockhandle_real_agent";
const char *const OB_ALL_VIRTUAL_DBMS_LOCK_ALLOCATED_REAL_AGENT_ORA_IDX_DBMS_LOCK_ALLOCATED_EXPIRATION_REAL_AGENT_TNAME = "__idx_15397_idx_dbms_lock_allocated_expiration_real_agent";
const char *const OB_ALL_VIRTUAL_USER_PROXY_INFO_REAL_AGENT_ORA_IDX_USER_PROXY_INFO_PROXY_USER_ID_REAL_AGENT_TNAME = "__idx_15446_idx_user_proxy_info_proxy_user_id_real_agent";
const char *const OB_ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_REAL_AGENT_ORA_IDX_SCHEDULER_JOB_RUN_DETAIL_V2_TIME_REAL_AGENT_TNAME = "__idx_15458_idx_scheduler_job_run_detail_v2_time_real_agent";
const char *const OB_ALL_VIRTUAL_SCHEDULER_JOB_RUN_DETAIL_V2_REAL_AGENT_ORA_IDX_SCHEDULER_JOB_RUN_DETAIL_V2_JOB_CLASS_TIME_REAL_AGENT_TNAME = "__idx_15458_idx_scheduler_job_run_detail_v2_job_class_time_real_agent";
const char *const OB_ALL_VIRTUAL_PKG_TYPE_REAL_AGENT_ORA_IDX_PKG_DB_TYPE_NAME_REAL_AGENT_TNAME = "__idx_15471_idx_pkg_db_type_name_real_agent";
const char *const OB_ALL_VIRTUAL_PKG_TYPE_REAL_AGENT_ORA_IDX_PKG_TYPE_NAME_REAL_AGENT_TNAME = "__idx_15471_idx_pkg_type_name_real_agent";
const char *const OB_ALL_VIRTUAL_PKG_TYPE_ATTR_REAL_AGENT_ORA_IDX_PKG_TYPE_ATTR_NAME_REAL_AGENT_TNAME = "__idx_15472_idx_pkg_type_attr_name_real_agent";
const char *const OB_ALL_VIRTUAL_PKG_TYPE_ATTR_REAL_AGENT_ORA_IDX_PKG_TYPE_ATTR_ID_REAL_AGENT_TNAME = "__idx_15472_idx_pkg_type_attr_id_real_agent";
const char *const OB_ALL_VIRTUAL_PKG_COLL_TYPE_REAL_AGENT_ORA_IDX_PKG_COLL_NAME_TYPE_REAL_AGENT_TNAME = "__idx_15473_idx_pkg_coll_name_type_real_agent";
const char *const OB_ALL_VIRTUAL_PKG_COLL_TYPE_REAL_AGENT_ORA_IDX_PKG_COLL_NAME_ID_REAL_AGENT_TNAME = "__idx_15473_idx_pkg_coll_name_id_real_agent";

// initial data for __all_privilege
struct PrivilegeRow {
  const char *privilege_;
  const char *context_;
  const char *comment_;
};

  const char* const ALTER_TB_MSG = "To alter the table";
  const char* const CREATE_DB_TB_MSG = "To create new databases and tables";
  const char* const CREATE_VIEW_MSG = "To create new views";
  const char* const CREATE_USER_MSG = "To create new users";
  const char* const DELETE_ROWS_MSG = "To delete existing rows";
  const char* const DROP_DB_TB_VIEWS_MSG = "To drop databases, tables, and views";
  const char* const GRANT_OPTION_MSG = "To give to other users those privileges you possess";
  const char* const INDEX_MSG = "To create or drop indexes";
  const char* const INSERT_MSG = "To insert data into tables";
  const char* const PROCESS_MSG = "To view the plain text of currently executing queries";
  const char* const SELECT_MSG = "To retrieve rows from table";
  const char* const SHOW_DB_MSG = "To see all databases with SHOW DATABASES";
  const char* const SHOW_VIEW_MSG = "To see views with SHOW CREATE VIEW";
  const char* const SUPER_MSG = "To use KILL thread, SET GLOBAL, CHANGE MASTER, etc.";
  const char* const UPDATE_MSG = "To update existing rows";
  const char* const USAGE_MSG = "No privileges - allow connect only";
static const PrivilegeRow all_privileges[] =
{
  {"Alter", "Tables",  ALTER_TB_MSG},
  {"Create", "Databases,Tables,Indexes",  CREATE_DB_TB_MSG},
  {"Create view", "Tables",  CREATE_VIEW_MSG},
  {"Create user", "Server Admin",  CREATE_USER_MSG},
  {"Delete", "Tables",  DELETE_ROWS_MSG},
  {"Drop", "Databases,Tables", DROP_DB_TB_VIEWS_MSG},
  {"Grant option",  "Databases,Tables,Functions,Procedures", GRANT_OPTION_MSG},
  {"Index", "Tables",  INDEX_MSG},
  {"Insert", "Tables",  INSERT_MSG},
  {"Process", "Server Admin", PROCESS_MSG},
  {"Select", "Tables",  SELECT_MSG},
  {"Show databases","Server Admin", SHOW_DB_MSG},
  {"Show view","Tables", SHOW_VIEW_MSG},
  {"Super","Server Admin", SUPER_MSG},
  {"Update", "Tables",  UPDATE_MSG},
  {"Usage","Server Admin",USAGE_MSG},
  {NULL, NULL, NULL},
};

} // end namespace share
} // end namespace oceanbase
#endif /* _OB_INNER_TABLE_SCHEMA_CONSTANTS_H_ */
