/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef OCEANBASE_SQL_ENGINE_EXPR_OB_EXPR_REGEXP_COUNT_
#define OCEANBASE_SQL_ENGINE_EXPR_OB_EXPR_REGEXP_COUNT_

#include "lib/string/ob_string.h"
#include "sql/engine/expr/ob_expr_regexp_context.h"

namespace oceanbase
{
namespace sql
{
class ObExprRegexpCount : public ObFuncExprOperator
{
public:
  explicit ObExprRegexpCount(common::ObIAllocator &alloc);
  virtual ~ObExprRegexpCount();
  virtual int calc_result_typeN(ObExprResType &type,
                                ObExprResType *types,
                                int64_t param_num,
                                common::ObExprTypeCtx &type_ctx) const;
  virtual int cg_expr(ObExprCGCtx &op_cg_ctx,
                      const ObRawExpr &raw_expr,
                      ObExpr &rt_expr) const override;
  virtual bool need_rt_ctx() const override { return true; }

  static int eval_regexp_count(const ObExpr &expr, ObEvalCtx &ctx, ObDatum &expr_datum);

  static int eval_hs_regexp_count(const ObExpr &expr, ObEvalCtx &ctx, ObDatum &expr_datum);
private:
  template<typename RegExpCtx>
  static int regexp_count(const ObExpr &expr, ObEvalCtx &ctx, ObDatum &expr_datum);
  DISALLOW_COPY_AND_ASSIGN(ObExprRegexpCount);
};
}
}
#endif /* OCEANBASE_SQL_ENGINE_EXPR_OB_EXPR_REGEXP_SUBSTR_ */
