###
### This file includes initial data for tenant sys table __all_spatial_reference_systems
###


START TRANSACTION;

#
## The initial data for __all_spatial_reference_systems
#

REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2000, 'Anguilla 1957 / British West Indies Grid', 'EPSG', 2000, 'PROJCS["Anguilla 1957 / British West Indies Grid",GEOGCS["Anguilla 1957",DATUM["Anguilla 1957",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],AUTHORITY["EPSG","6600"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4600"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2000"]]', 270292.6900021691, 303430.5383902239, 1997917.7241574571, 2031055.5725455120,'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2001, 'Antigua 1943 / British West Indies Grid', 'EPSG', 2001, 'PROJCS["Antigua 1943 / British West Indies Grid",GEOGCS["Antigua 1943",DATUM["Antigua 1943",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-255,-15,71,0,0,0,0],AUTHORITY["EPSG","6601"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4601"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2001"]]', 404823.3246404784, 442478.3852287518, 1869341.2590560496, 1906996.3196443231,'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-255,-15,71,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2002, 'Dominica 1945 / British West Indies Grid', 'EPSG', 2002, 'PROJCS["Dominica 1945 / British West Indies Grid",GEOGCS["Dominica 1945",DATUM["Dominica 1945",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[725,685,536,0,0,0,0],AUTHORITY["EPSG","6602"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4602"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2002"]]', 434428.8485927079, 497807.0644272475, 1671915.3578715520, 1735293.5737060916,'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=725,685,536,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2003, 'Grenada 1953 / British West Indies Grid', 'EPSG', 2003, 'PROJCS["Grenada 1953 / British West Indies Grid",GEOGCS["Grenada 1953",DATUM["Grenada 1953",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[72,213.7,93,0,0,0,0],AUTHORITY["EPSG","6603"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4603"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2003"]]', 407644.3368739204, 480174.1683301597, 1318296.4975937004, 1390826.3290499396,'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2004, 'Montserrat 1958 / British West Indies Grid', 'EPSG', 2004, 'PROJCS["Montserrat 1958 / British West Indies Grid",GEOGCS["Montserrat 1958",DATUM["Montserrat 1958",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[174,359,365,0,0,0,0],AUTHORITY["EPSG","6604"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4604"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2004"]]', 365564.0546507168, 394344.6098679476, 1836395.6122759146, 1865176.1674931454,'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=174,359,365,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2005, 'St. Kitts 1955 / British West Indies Grid', 'EPSG', 2005, 'PROJCS["St. Kitts 1955 / British West Indies Grid",GEOGCS["St. Kitts 1955",DATUM["St. Kitts 1955",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[9,183,236,0,0,0,0],AUTHORITY["EPSG","6605"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4605"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2005"]]', 301119.7967152261, 347716.9524530786, 1884739.0620418234, 1931336.2177796758,'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=9,183,236,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2006, 'St. Lucia 1955 / British West Indies Grid', 'EPSG', 2006, 'PROJCS["St. Lucia 1955 / British West Indies Grid",GEOGCS["St. Lucia 1955",DATUM["St. Lucia 1955",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-153,153,307,0,0,0,0],AUTHORITY["EPSG","6606"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4606"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2006"]]', 481985.5116665583, 539646.7977062278, 1508727.7468814795, 1566389.0329211490,'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-149,128,296,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2007, 'St. Vincent 45 / British West Indies Grid', 'EPSG', 2007, 'PROJCS["St. Vincent 45 / British West Indies Grid",GEOGCS["St. Vincent 1945",DATUM["St. Vincent 1945",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[195.671,332.517,274.607,0,0,0,0],AUTHORITY["EPSG","6607"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4607"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2007"]]', 424338.3479106334, 527984.1475852343, 1383894.1169695003, 1487539.9166441012,'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=195.671,332.517,274.607,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2009, 'NAD27(CGQ77) / SCoPQ zone 3', 'EPSG', 2009, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 3",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-58.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2009"]]', 193571.8327763323, 408889.2683373818, 5556331.4678739166, 5771648.9034349661,'+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2010, 'NAD27(CGQ77) / SCoPQ zone 4', 'EPSG', 2010, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 4",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-61.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2010"]]', 24343.7426829529, 585256.2573170481, 5214598.4145907009, 5775510.9292247962,'+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2011, 'NAD27(CGQ77) / SCoPQ zone 5', 'EPSG', 2011, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 5",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-64.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2011"]]', -416817.2100178412, 1026417.2100178403, 5285452.5051280568, 6728686.9251637384,'+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2012, 'NAD27(CGQ77) / SCoPQ zone 6', 'EPSG', 2012, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 6",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-67.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2012"]]', -371571.2887233583, 981171.2887233583, 5216045.0607123385, 6568787.6381590552,'+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2013, 'NAD27(CGQ77) / SCoPQ zone 7', 'EPSG', 2013, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 7",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-70.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2013"]]', -666680.8510810625, 1276280.8510810635, 4949069.9375066218, 6892031.6396687477,'+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2014, 'NAD27(CGQ77) / SCoPQ zone 8', 'EPSG', 2014, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 8",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-73.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2014"]]', -710130.8503797319, 1319730.8503797308, 4945176.3870252339, 6975038.0877846967,'+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2015, 'NAD27(CGQ77) / SCoPQ zone 9', 'EPSG', 2015, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 9",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-76.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2015"]]', -693387.5806433724, 1302987.5806433724, 4988047.1557314929, 6984422.3170182377,'+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2016, 'NAD27(CGQ77) / SCoPQ zone 10', 'EPSG', 2016, 'PROJCS["NAD27(CGQ77) / SCoPQ zone 10",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-79.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2016"]]', -590023.0338345485, 1288329.2760625545, 5084858.2822336729, 6963210.5921307758,'+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2017, 'NAD27(76) / MTM zone 8', 'EPSG', 2017, 'PROJCS["NAD27(76) / MTM zone 8",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-73.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2017"]]', 173419.2855551106, 251624.6053255068, 4980853.7986784491, 5059059.1184488453,'+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2018, 'NAD27(76) / MTM zone 9', 'EPSG', 2018, 'PROJCS["NAD27(76) / MTM zone 9",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-76.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2018"]]', 153411.8426890241, 456188.1573109758, 4827283.8776284320, 5130060.1922503837,'+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2019, 'NAD27(76) / MTM zone 10', 'EPSG', 2019, 'PROJCS["NAD27(76) / MTM zone 10",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-79.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2019"]]', 12258.5552873119, 598166.5391980345, 4669656.6695874473, 5255564.6534981700,'+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2020, 'NAD27(76) / MTM zone 11', 'EPSG', 2020, 'PROJCS["NAD27(76) / MTM zone 11",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2020"]]', 71044.2937409532, 571865.2834354372, 4605262.6145164811, 5106083.6042109651,'+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2021, 'NAD27(76) / MTM zone 12', 'EPSG', 2021, 'PROJCS["NAD27(76) / MTM zone 12",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2021"]]', -227864.8993426017, 837464.8993426017, 5075965.3198190480, 6141295.1185042514,'+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2022, 'NAD27(76) / MTM zone 13', 'EPSG', 2022, 'PROJCS["NAD27(76) / MTM zone 13",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2022"]]', -249859.2704442661, 859459.2704442670, 5075119.3824689840, 6184437.9233575170,'+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2023, 'NAD27(76) / MTM zone 14', 'EPSG', 2023, 'PROJCS["NAD27(76) / MTM zone 14",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2023"]]', -246490.3050320601, 856090.3050320591, 5205293.3174030697, 6307873.9274671888,'+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2024, 'NAD27(76) / MTM zone 15', 'EPSG', 2024, 'PROJCS["NAD27(76) / MTM zone 15",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2024"]]', -211823.2530754858, 821423.2530754858, 5295560.3739802840, 6328806.8801312555,'+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2025, 'NAD27(76) / MTM zone 16', 'EPSG', 2025, 'PROJCS["NAD27(76) / MTM zone 16",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2025"]]', -108214.5182014937, 717814.5182014947, 5309551.1026216363, 6135580.1390246246,'+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2026, 'NAD27(76) / MTM zone 17', 'EPSG', 2026, 'PROJCS["NAD27(76) / MTM zone 17",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2026"]]', 124497.7281966525, 651608.2054672436, 5384598.7479375493, 5911709.2252081405,'+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2027, 'NAD27(76) / UTM zone 15N', 'EPSG', 2027, 'PROJCS["NAD27(76) / UTM zone 15N",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2027"]]', 57486.1350539049, 1004387.5218607298, 5303484.3600714749, 6250385.7468782997,'+proj=utm +zone=15 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2028, 'NAD27(76) / UTM zone 16N', 'EPSG', 2028, 'PROJCS["NAD27(76) / UTM zone 16N",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2028"]]', -123803.9196001797, 1123803.9196001807, 5086434.9796236140, 6334042.8188239745,'+proj=utm +zone=16 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2029, 'NAD27(76) / UTM zone 17N', 'EPSG', 2029, 'PROJCS["NAD27(76) / UTM zone 17N",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2029"]]', -291738.5216795418, 1291738.5216795419, 4586822.4258581658, 6170299.4692172495,'+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2030, 'NAD27(76) / UTM zone 18N', 'EPSG', 2030, 'PROJCS["NAD27(76) / UTM zone 18N",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2030"]]', 251695.6015567692, 558717.5169525356, 4824864.2940851511, 5131886.2094809175,'+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2031, 'NAD27(CGQ77) / UTM zone 17N', 'EPSG', 2031, 'PROJCS["NAD27(CGQ77) / UTM zone 17N",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2031"]]', -294653.2639975561, 1585332.1231633451, 5083873.6032105460, 6963858.9903714472,'+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2032, 'NAD27(CGQ77) / UTM zone 18N', 'EPSG', 2032, 'PROJCS["NAD27(CGQ77) / UTM zone 18N",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2032"]]', -519527.0927453607, 1519527.0927453617, 4946788.9974453218, 6985843.1829360442,'+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2033, 'NAD27(CGQ77) / UTM zone 19N', 'EPSG', 2033, 'PROJCS["NAD27(CGQ77) / UTM zone 19N",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2033"]]', -470904.6490590832, 1470904.6490590823, 4950880.8232178890, 6892690.1213360544,'+proj=utm +zone=19 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2034, 'NAD27(CGQ77) / UTM zone 20N', 'EPSG', 2034, 'PROJCS["NAD27(CGQ77) / UTM zone 20N",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2034"]]', -266818.2012591803, 1266818.2012591803, 5197600.0899585869, 6731236.4924769474,'+proj=utm +zone=20 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2035, 'NAD27(CGQ77) / UTM zone 21N', 'EPSG', 2035, 'PROJCS["NAD27(CGQ77) / UTM zone 21N",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2035"]]', 281757.8928131836, 497280.9159934178, 5555656.5199960237, 5771179.5431762580,'+proj=utm +zone=21 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2039, 'Israel 1993 / Israeli TM Grid', 'EPSG', 2039, 'PROJCS["Israel 1993 / Israeli TM Grid",GEOGCS["Israel 1993",DATUM["Israel 1993",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-48,55,52,0,0,0,0],AUTHORITY["EPSG","6141"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4141"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31.7343936111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",35.2045169444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1.0000067,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",219529.584,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",626907.39,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2039"]]', -28196.5177503762, 413843.4912561989, 365200.3451232911, 807240.3541298662,'+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.20451694444445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps=GRS80 +towgs84=-48,55,52,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2040, 'Locodjo 1965 / UTM zone 30N', 'EPSG', 2040, 'PROJCS["Locodjo 1965 / UTM zone 30N",GEOGCS["Locodjo 1965",DATUM["Locodjo 1965",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-125,53,467,0,0,0,0],AUTHORITY["EPSG","6142"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4142"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-3,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2040"]]', 43125.0148561678, 681679.3247306888, 531097.2782665058, 1169651.5881410267,'+proj=utm +zone=30 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2041, 'Abidjan 1987 / UTM zone 30N', 'EPSG', 2041, 'PROJCS["Abidjan 1987 / UTM zone 30N",GEOGCS["Abidjan 1987",DATUM["Abidjan 1987",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY["EPSG","6143"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4143"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-3,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2041"]]', 43124.9868185163, 681679.3181269695, 531097.5075404981, 1169651.8388489513,'+proj=utm +zone=30 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2042, 'Locodjo 1965 / UTM zone 29N', 'EPSG', 2042, 'PROJCS["Locodjo 1965 / UTM zone 29N",GEOGCS["Locodjo 1965",DATUM["Locodjo 1965",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-125,53,467,0,0,0,0],AUTHORITY["EPSG","6142"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4142"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2042"]]', 316198.1127092437, 1059427.0925188011, 459433.9160117884, 1202662.8958213458,'+proj=utm +zone=29 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2043, 'Abidjan 1987 / UTM zone 29N', 'EPSG', 2043, 'PROJCS["Abidjan 1987 / UTM zone 29N",GEOGCS["Abidjan 1987",DATUM["Abidjan 1987",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY["EPSG","6143"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4143"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2043"]]', 316198.0692529253, 1059427.0737363950, 459434.1425815447, 1202663.1470650144,'+proj=utm +zone=29 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2044, 'Hanoi 1972 / Gauss-Kruger zone 18', 'EPSG', 2044, 'PROJCS["Hanoi 1972 / Gauss-Kruger zone 18",GEOGCS["Hanoi 1972",DATUM["Hanoi 1972",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY["EPSG","6147"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4147"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",18500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2044"]]', 17653232.3139616227, 19362111.8866028809, 908313.0814400598, 2617192.6540813181,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2045, 'Hanoi 1972 / Gauss-Kruger zone 19', 'EPSG', 2045, 'PROJCS["Hanoi 1972 / Gauss-Kruger zone 19",GEOGCS["Hanoi 1972",DATUM["Hanoi 1972",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY["EPSG","6147"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4147"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",19500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2045"]]', 18616577.5444450183, 19901376.3140059830, 1128045.5318590555, 2412844.3014200203,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2046, 'Hartebeesthoek94 / Lo15', 'EPSG', 2046, 'PROJCS["Hartebeesthoek94 / Lo15",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2046"]]', 26766.2806859741, 80994.2227995661, 2508112.6895977765, 2562340.6317113685,'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2047, 'Hartebeesthoek94 / Lo17', 'EPSG', 2047, 'PROJCS["Hartebeesthoek94 / Lo17",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",17,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2047"]]', -314571.9344630000, 270319.0177535858, 3090640.4263632425, 3675531.3785798282,'+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2048, 'Hartebeesthoek94 / Lo19', 'EPSG', 2048, 'PROJCS["Hartebeesthoek94 / Lo19",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",19,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2048"]]', -374317.9290707895, 375298.1588854669, 3126545.2077633011, 3876161.2957195576,'+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2049, 'Hartebeesthoek94 / Lo21', 'EPSG', 2049, 'PROJCS["Hartebeesthoek94 / Lo21",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2049"]]', -583387.6642030213, 583387.6642030213, 2717408.2603990877, 3884183.5888051304,'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2050, 'Hartebeesthoek94 / Lo23', 'EPSG', 2050, 'PROJCS["Hartebeesthoek94 / Lo23",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",23,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2050"]]', -519324.7259049920, 518317.2605173544, 2775276.1403827272, 3812918.1268050735,'+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2051, 'Hartebeesthoek94 / Lo25', 'EPSG', 2051, 'PROJCS["Hartebeesthoek94 / Lo25",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2051"]]', -551011.0816643499, 549999.1221981562, 2713126.5425087243, 3814136.7463712304,'+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2052, 'Hartebeesthoek94 / Lo27', 'EPSG', 2052, 'PROJCS["Hartebeesthoek94 / Lo27",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2052"]]', -628798.5052362101, 628798.5052362098, 2511842.2145416239, 3769439.2250140439,'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2053, 'Hartebeesthoek94 / Lo29', 'EPSG', 2053, 'PROJCS["Hartebeesthoek94 / Lo29",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",29,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2053"]]', -627640.8880017681, 628672.6801470664, 2424374.8419402082, 3680688.4100890427,'+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2054, 'Hartebeesthoek94 / Lo31', 'EPSG', 2054, 'PROJCS["Hartebeesthoek94 / Lo31",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",31,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2054"]]', -528340.0736344025, 527308.9361391160, 2438207.6469892761, 3493856.6567627946,'+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2055, 'Hartebeesthoek94 / Lo33', 'EPSG', 2055, 'PROJCS["Hartebeesthoek94 / Lo33",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2055"]]', -68913.3688672314, 178192.9913108856, 2960718.8373926537, 3207825.1975707706,'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2056, 'CH1903+ / LV95', 'EPSG', 2056, 'PROJCS["CH1903+ / LV95",GEOGCS["CH1903+",DATUM["CH1903+",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[674.374,15.056,405.346,0,0,0,0],AUTHORITY["EPSG","6150"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4150"]],PROJECTION["Hotine Oblique Mercator (variant B)",AUTHORITY["EPSG","9815"]],PARAMETER["Latitude of projection centre",46.9524055555556,AUTHORITY["EPSG","8811"]],PARAMETER["Longitude of projection centre",7.43958333333333,AUTHORITY["EPSG","8812"]],PARAMETER["Azimuth of initial line",90,AUTHORITY["EPSG","8813"]],PARAMETER["Angle from Rectified to Skew Grid",90,AUTHORITY["EPSG","8814"]],PARAMETER["Scale factor on initial line",1,AUTHORITY["EPSG","8815"]],PARAMETER["Easting at projection centre",2600000,AUTHORITY["EPSG","8816"]],PARAMETER["Northing at projection centre",1200000,AUTHORITY["EPSG","8817"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2056"]]', 2478030.6106637927, 2844160.7693039019, 1004578.9665416119, 1370709.1251817210,'+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333333333 +k_0=1 +x_0=2600000 +y_0=1200000 +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2057, 'Rassadiran / Nakhl e Taqi', 'EPSG', 2057, 'PROJCS["Rassadiran / Nakhl e Taqi",GEOGCS["Rassadiran",DATUM["Rassadiran",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-133.63,-157.5,-158.62,0,0,0,0],AUTHORITY["EPSG","6153"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4153"]],PROJECTION["Hotine Oblique Mercator (variant B)",AUTHORITY["EPSG","9815"]],PARAMETER["Latitude of projection centre",27.5188288055556,AUTHORITY["EPSG","8811"]],PARAMETER["Longitude of projection centre",52.6035391666667,AUTHORITY["EPSG","8812"]],PARAMETER["Azimuth of initial line",0.571661194444444,AUTHORITY["EPSG","8813"]],PARAMETER["Angle from Rectified to Skew Grid",0.571661194444444,AUTHORITY["EPSG","8814"]],PARAMETER["Scale factor on initial line",0.999895934,AUTHORITY["EPSG","8815"]],PARAMETER["Easting at projection centre",658377.437,AUTHORITY["EPSG","8816"]],PARAMETER["Northing at projection centre",3044969.194,AUTHORITY["EPSG","8817"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2057"]]', 645835.8062493714, 671187.0045217022, 3030331.9415148072, 3055683.1397871380,'+proj=omerc +lat_0=27.51882880555555 +lonc=52.60353916666667 +alpha=0.5716611944444444 +k=0.999895934 +x_0=658377.437 +y_0=3044969.194 +gamma=0.5716611944444444 +ellps=intl +towgs84=-133.63,-157.5,-158.62,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2058, 'ED50(ED77) / UTM zone 38N', 'EPSG', 2058, 'PROJCS["ED50(ED77) / UTM zone 38N",GEOGCS["ED50(ED77)",DATUM["European Datum 1950(1977)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-110.33,-97.73,-119.85,0.3423,1.1634,0.2715,0.063],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2058"]]', 88000.8342449232, 1105896.2803742635, 3409503.5507586384, 4427398.9968879787,'+proj=utm +zone=38 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2059, 'ED50(ED77) / UTM zone 39N', 'EPSG', 2059, 'PROJCS["ED50(ED77) / UTM zone 39N",GEOGCS["ED50(ED77)",DATUM["European Datum 1950(1977)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-110.33,-97.73,-119.85,0.3423,1.1634,0.2715,0.063],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2059"]]', -321338.3168831192, 1321322.6114874963, 2788981.7956364369, 4431642.7240070524,'+proj=utm +zone=39 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2060, 'ED50(ED77) / UTM zone 40N', 'EPSG', 2060, 'PROJCS["ED50(ED77) / UTM zone 40N",GEOGCS["ED50(ED77)",DATUM["European Datum 1950(1977)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-110.33,-97.73,-119.85,0.3423,1.1634,0.2715,0.063],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2060"]]', -248037.4134924149, 1247984.9698901469, 2775177.8488227443, 4271200.2322053060,'+proj=utm +zone=40 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2061, 'ED50(ED77) / UTM zone 41N', 'EPSG', 2061, 'PROJCS["ED50(ED77) / UTM zone 41N",GEOGCS["ED50(ED77)",DATUM["European Datum 1950(1977)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-110.33,-97.73,-119.85,0.3423,1.1634,0.2715,0.063],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2061"]]', -330314.6204348997, 1061759.8718681998, 2740618.2109540682, 4132692.7032571677,'+proj=utm +zone=41 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2062, 'Madrid 1870 (Madrid) / Spain', 'EPSG', 2062, 'PROJCS["Madrid 1870 (Madrid) / Spain",GEOGCS["Madrid 1870 (Madrid)",DATUM["Madrid 1870 (Madrid)",SPHEROID["Struve 1860",6378298.3,294.73,AUTHORITY["EPSG","7028"]],AUTHORITY["EPSG","6903"]],PRIMEM["Madrid",-3.6879388888888895,AUTHORITY["EPSG","8905"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4903"]],PROJECTION["Lambert Conic Conformal (1SP)",AUTHORITY["EPSG","9801"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",0,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9988085293,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",600000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",600000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2062"]]', 64013.8045348395, 1261761.4003598367, 7985.4291327629, 1205733.0249577601,'+proj=lcc +lat_1=40 +lat_0=40 +lon_0=0 +k_0=0.9988085293 +x_0=600000 +y_0=600000 +a=6378298.3 +b=6356657.142669561 +pm=madrid +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2065, 'S-JTSK (Ferro) / Krovak', 'EPSG', 2065, 'PROJCS["S-JTSK (Ferro) / Krovak",GEOGCS["S-JTSK (Ferro)",DATUM["System of the Unified Trigonometrical Cadastral Network (Ferro)",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],AUTHORITY["EPSG","6818"]],PRIMEM["Ferro",-17.677777777777774,AUTHORITY["EPSG","8909"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4818"]],PROJECTION["Krovak",AUTHORITY["EPSG","9819"]],PARAMETER["Latitude of projection centre",49.5111111111111,AUTHORITY["EPSG","8811"]],PARAMETER["Longitude of origin",42.5111111111111,AUTHORITY["EPSG","8833"]],PARAMETER["Co-latitude of cone axis",30.2881397222222,AUTHORITY["EPSG","1036"]],PARAMETER["Latitude of pseudo standard parallel",78.5111111111111,AUTHORITY["EPSG","8818"]],PARAMETER["Scale factor on pseudo standard parallel",0.9999,AUTHORITY["EPSG","8819"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",SOUTH],AXIS["Y",WEST],AUTHORITY["EPSG","2065"]]', -967343.6257742228, -143516.1861128735, -1544086.4760468017, -720259.0363854524,'+proj=krovak +lat_0=49.5 +lon_0=42.5 +alpha=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +towgs84=570.8,85.7,462.8,4.998,1.587,5.261,3.56 +pm=ferro +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2066, 'Mount Dillon / Tobago Grid', 'EPSG', 2066, 'PROJCS["Mount Dillon / Tobago Grid",GEOGCS["Mount Dillon",DATUM["Mount Dillon",SPHEROID["Clarke 1858",6378293.645208759,294.26067636926103,AUTHORITY["EPSG","7007"]],AUTHORITY["EPSG","6157"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4157"]],PROJECTION["Cassini-Soldner",AUTHORITY["EPSG","9806"]],PARAMETER["Latitude of natural origin",11.2521786111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-60.6860088888889,AUTHORITY["EPSG","8802"]],PARAMETER["False easting",187500,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",180000,AUTHORITY["EPSG","8807"]],UNIT["Clarke\'s link",0.201166195164,AUTHORITY["EPSG","9039"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2066"]]', 66276.6108586482, 326113.4307719298, 46184.1909656317, 306021.0108789132,'+proj=cass +lat_0=11.25217861111111 +lon_0=-60.68600888888889 +x_0=37718.66159325 +y_0=36209.91512952 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.201166195164 +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2067, 'Naparima 1955 / UTM zone 20N', 'EPSG', 2067, 'PROJCS["Naparima 1955 / UTM zone 20N",GEOGCS["Naparima 1955",DATUM["Naparima 1955",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-0.465,372.095,171.736,0,0,0,0],AUTHORITY["EPSG","6158"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4158"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2067"]]', 608818.0272888450, 738003.9838627426, 1090341.5461983377, 1219527.5027722354,'+proj=utm +zone=20 +ellps=intl +towgs84=-0.465,372.095,171.736,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2068, 'ELD79 / Libya zone 5', 'EPSG', 2068, 'PROJCS["ELD79 / Libya zone 5",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2068"]]', -29440.3308732443, 561005.8735685578, 2795632.5624809598, 3386078.7669227619,'+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2069, 'ELD79 / Libya zone 6', 'EPSG', 2069, 'PROJCS["ELD79 / Libya zone 6",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",11,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2069"]]', -360083.0075810826, 760233.2584922964, 2579757.6162936463, 3700073.8823670252,'+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2070, 'ELD79 / Libya zone 7', 'EPSG', 2070, 'PROJCS["ELD79 / Libya zone 7",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",13,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2070"]]', -391171.7108984339, 791312.6138867731, 2499930.1482934453, 3682414.4730786524,'+proj=tmerc +lat_0=0 +lon_0=13 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2071, 'ELD79 / Libya zone 8', 'EPSG', 2071, 'PROJCS["ELD79 / Libya zone 8",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2071"]]', -386547.2686434841, 786678.6520140748, 2479066.3583736426, 3652292.2790312016,'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2072, 'ELD79 / Libya zone 9', 'EPSG', 2072, 'PROJCS["ELD79 / Libya zone 9",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",17,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2072"]]', -308193.3423538264, 709343.9524073741, 2470985.5521126433, 3488522.8468738439,'+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2073, 'ELD79 / Libya zone 10', 'EPSG', 2073, 'PROJCS["ELD79 / Libya zone 10",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",19,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2073"]]', -412417.1676079305, 812529.0433816865, 2359585.4915780091, 3584531.7025676262,'+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2074, 'ELD79 / Libya zone 11', 'EPSG', 2074, 'PROJCS["ELD79 / Libya zone 11",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2074"]]', -517858.0289212677, 917959.9404810768, 2244809.6023006585, 3680627.5717030031,'+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2075, 'ELD79 / Libya zone 12', 'EPSG', 2075, 'PROJCS["ELD79 / Libya zone 12",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",23,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2075"]]', -576003.4116829618, 976095.2348658085, 2127437.1599498016, 3679535.8064985720,'+proj=tmerc +lat_0=0 +lon_0=23 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2076, 'ELD79 / Libya zone 13', 'EPSG', 2076, 'PROJCS["ELD79 / Libya zone 13",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2076"]]', -542007.7866747525, 859416.5480844417, 2184280.7526855264, 3585705.0874447207,'+proj=tmerc +lat_0=0 +lon_0=25 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2077, 'ELD79 / UTM zone 32N', 'EPSG', 2077, 'PROJCS["ELD79 / UTM zone 32N",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2077"]]', 105697.1397294146, 1229722.1891223993, 2578585.6012545826, 3702610.6506475674,'+proj=utm +zone=32 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2078, 'ELD79 / UTM zone 33N', 'EPSG', 2078, 'PROJCS["ELD79 / UTM zone 33N",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2078"]]', -107612.1070584363, 1108772.9444224413, 2469167.1246937069, 3685552.1761745845,'+proj=utm +zone=33 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2079, 'ELD79 / UTM zone 34N', 'EPSG', 2079, 'PROJCS["ELD79 / UTM zone 34N",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2079"]]', -278609.8958552903, 1277661.3232434705, 2129158.4778307129, 3685429.6969294737,'+proj=utm +zone=34 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2080, 'ELD79 / UTM zone 35N', 'EPSG', 2080, 'PROJCS["ELD79 / UTM zone 35N",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2080"]]', -443156.5909490716, 960467.5935844416, 2184561.1672278929, 3588185.3517614061,'+proj=utm +zone=35 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2081, 'Chos Malal 1914 / Argentina 2', 'EPSG', 2081, 'PROJCS["Chos Malal 1914 / Argentina 2",GEOGCS["Chos Malal 1914",DATUM["Chos Malal 1914",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6160"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4160"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-90,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2081"]]', 2222280.5327640168, 2730911.8150605330, 5501842.8841788028, 6010474.1664753189,'+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2082, 'Pampa del Castillo / Argentina 2', 'EPSG', 2082, 'PROJCS["Pampa del Castillo / Argentina 2",GEOGCS["Pampa del Castillo",DATUM["Pampa del Castillo",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[27.5,14,186.4,0,0,0,0],AUTHORITY["EPSG","6161"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4161"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-90,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2082"]]', 2451481.3829121468, 2627043.8478679275, 4823606.7307401933, 4999169.1956959739,'+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2083, 'Hito XVIII 1963 / Argentina 2', 'EPSG', 2083, 'PROJCS["Hito XVIII 1963 / Argentina 2",GEOGCS["Hito XVIII 1963",DATUM["Hito XVIII 1963",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[18.38,192.45,96.82,0.056,-0.142,-0.2,-0.0013],AUTHORITY["EPSG","6254"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4254"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-90,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2083"]]', 2428091.2561298289, 2696487.8996950233, 3909871.4097482661, 4178268.0533134605,'+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=16,196,93,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2084, 'Hito XVIII 1963 / UTM zone 19S', 'EPSG', 2084, 'PROJCS["Hito XVIII 1963 / UTM zone 19S",GEOGCS["Hito XVIII 1963",DATUM["Hito XVIII 1963",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[18.38,192.45,96.82,0.056,-0.142,-0.2,-0.0013],AUTHORITY["EPSG","6254"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4254"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2084"]]', 442610.0974820001, 789295.3928651271, 3937675.9759423953, 4284361.2713255224,'+proj=utm +zone=19 +south +ellps=intl +towgs84=16,196,93,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2087, 'ELD79 / TM 12 NE', 'EPSG', 2087, 'PROJCS["ELD79 / TM 12 NE",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2087"]]', -96523.0043465529, 1128556.5411901686, 2479472.2687172592, 3704551.8142539807,'+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2088, 'Carthage / TM 11 NE', 'EPSG', 2088, 'PROJCS["Carthage / TM 11 NE",GEOGCS["Carthage",DATUM["Carthage",SPHEROID["Clarke 1880 (IGN)",6378249.2,293.4660212936269,AUTHORITY["EPSG","7011"]],TOWGS84[-263,6,431,0,0,0,0],AUTHORITY["EPSG","6223"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4223"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",11,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2088"]]', 175519.8113525297, 775886.9626248870, 3666851.4482789108, 4267218.5995512681,'+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9996 +x_0=500000 +y_0=0 +datum=carthage +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2089, 'Yemen NGN96 / UTM zone 38N', 'EPSG', 2089, 'PROJCS["Yemen NGN96 / UTM zone 38N",GEOGCS["Yemen NGN96",DATUM["Yemen National Geodetic Network 1996",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6163"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4163"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2089"]]', 156812.3970984510, 843187.6029015496, 1267525.6217742833, 1953900.8275773818,'+proj=utm +zone=38 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2090, 'Yemen NGN96 / UTM zone 39N', 'EPSG', 2090, 'PROJCS["Yemen NGN96 / UTM zone 39N",GEOGCS["Yemen NGN96",DATUM["Yemen National Geodetic Network 1996",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6163"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4163"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2090"]]', -49900.3750671523, 1049900.3750671566, 1024870.6780811447, 2124671.4282154536,'+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2093, 'Hanoi 1972 / GK 106 NE', 'EPSG', 2093, 'PROJCS["Hanoi 1972 / GK 106 NE",GEOGCS["Hanoi 1972",DATUM["Hanoi 1972",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY["EPSG","6147"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4147"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",106,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2093"]]', 439258.6944006374, 679416.7841419156, 988857.6568177296, 1229015.7465590077,'+proj=tmerc +lat_0=0 +lon_0=106 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2094, 'WGS 72BE / TM 106 NE', 'EPSG', 2094, 'PROJCS["WGS 72BE / TM 106 NE",GEOGCS["WGS 72BE",DATUM["WGS 72 Transit Broadcast Ephemeris",SPHEROID["WGS 72",6378135,298.26,AUTHORITY["EPSG","7043"]],TOWGS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY["EPSG","6324"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4324"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",106,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2094"]]', 551293.9241295769, 948773.1748652770, 860633.1588574366, 1258112.4095931367,'+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y_0=0 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2095, 'Bissau / UTM zone 28N', 'EPSG', 2095, 'PROJCS["Bissau / UTM zone 28N",GEOGCS["Bissau",DATUM["Bissau",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-173,253,27,0,0,0,0],AUTHORITY["EPSG","6165"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4165"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2095"]]', 299482.6133409775, 655292.9526240266, 1124794.6627202990, 1480605.0020033481,'+proj=utm +zone=28 +ellps=intl +towgs84=-173,253,27,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2096, 'Korean 1985 / East Belt', 'EPSG', 2096, 'PROJCS["Korean 1985 / East Belt",GEOGCS["Korean 1985",DATUM["Korean Datum 1985",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-145.907,505.034,685.756,1.162,-2.347,-1.592,6.342],AUTHORITY["EPSG","6162"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4162"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2096"]]', -55666.5869601196, 423521.3645784955, 101535.5947744675, 580723.5463130825,'+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2097, 'Korean 1985 / Central Belt', 'EPSG', 2097, 'PROJCS["Korean 1985 / Central Belt",GEOGCS["Korean 1985",DATUM["Korean Datum 1985",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-145.907,505.034,685.756,1.162,-2.347,-1.592,6.342],AUTHORITY["EPSG","6162"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4162"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",127,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2097"]]', -52134.6975577579, 452134.6975577556, 42527.2325983619, 546796.6277138754,'+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2098, 'Korean 1985 / West Belt', 'EPSG', 2098, 'PROJCS["Korean 1985 / West Belt",GEOGCS["Korean 1985",DATUM["Korean Datum 1985",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-145.907,505.034,685.756,1.162,-2.347,-1.592,6.342],AUTHORITY["EPSG","6162"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4162"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",125,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2098"]]', -9366.6904746147, 458332.1194833788, 46206.8310358996, 513905.6409938931,'+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2099, 'Qatar 1948 / Qatar Grid', 'EPSG', 2099, 'PROJCS["Qatar 1948 / Qatar Grid",GEOGCS["Qatar 1948",DATUM["Qatar 1948",SPHEROID["Helmert 1906",6378200,298.3,AUTHORITY["EPSG","7020"]],AUTHORITY["EPSG","6286"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4286"]],PROJECTION["Cassini-Soldner",AUTHORITY["EPSG","9806"]],PARAMETER["Latitude of natural origin",25.3823611111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",50.7613888888889,AUTHORITY["EPSG","8802"]],PARAMETER["False easting",100000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",100000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2099"]]', 47701.0741229029, 238135.1105018930, 4136.0689017467, 194570.1052807368,'+proj=cass +lat_0=25.38236111111111 +lon_0=50.76138888888889 +x_0=100000 +y_0=100000 +ellps=helmert +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2100, 'GGRS87 / Greek Grid', 'EPSG', 2100, 'PROJCS["GGRS87 / Greek Grid",GEOGCS["GGRS87",DATUM["Greek Geodetic Reference System 1987",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-199.87,74.79,246.62,0,0,0,0],AUTHORITY["EPSG","6121"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4121"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2100"]]', 78913.5194410779, 908895.3140082296, 3834567.5028201445, 4664549.2973872963,'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_0=0 +datum=GGRS87 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2101, 'Lake / Maracaibo Grid M1', 'EPSG', 2101, 'PROJCS["Lake / Maracaibo Grid M1",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert Conic Conformal (1SP)",AUTHORITY["EPSG","9801"]],PARAMETER["Latitude of natural origin",10.1777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-71.6056177777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",-52684.972,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2101"]]', -87091.7622819333, 28019.4193757056, -73331.7348984136, 41779.4467592252,'+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=0 +y_0=-52684.972 +ellps=intl +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2102, 'Lake / Maracaibo Grid', 'EPSG', 2102, 'PROJCS["Lake / Maracaibo Grid",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert Conic Conformal (1SP)",AUTHORITY["EPSG","9801"]],PARAMETER["Latitude of natural origin",10.1777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-71.6056177777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",147315.028,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2102"]]', 112908.2377180667, 228019.4193757056, 126668.2651015864, 241779.4467592252,'+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=200000 +y_0=147315.028 +ellps=intl +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2103, 'Lake / Maracaibo Grid M3', 'EPSG', 2103, 'PROJCS["Lake / Maracaibo Grid M3",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert Conic Conformal (1SP)",AUTHORITY["EPSG","9801"]],PARAMETER["Latitude of natural origin",10.1777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-71.6056177777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",447315.028,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2103"]]', 412908.2377180667, 528019.4193757056, 426668.2651015864, 541779.4467592252,'+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=500000 +y_0=447315.028 +ellps=intl +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2104, 'Lake / Maracaibo La Rosa Grid', 'EPSG', 2104, 'PROJCS["Lake / Maracaibo La Rosa Grid",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert Conic Conformal (1SP)",AUTHORITY["EPSG","9801"]],PARAMETER["Latitude of natural origin",10.1777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-71.6056177777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",-17044,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",-23139.97,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2104"]]', -16731.3026758484, 41968.2650257742, -42701.8941684902, 15997.6735331324,'+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=-17044 +y_0=-23139.97 +ellps=intl +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2105, 'NZGD2000 / Mount Eden 2000', 'EPSG', 2105, 'PROJCS["NZGD2000 / Mount Eden 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-36.8797222222222,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174.764166666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2105"]]', 49778.3798512655, 619322.9631778308, 548956.5970257090, 1118501.1803522743,'+proj=tmerc +lat_0=-36.87972222222222 +lon_0=174.7641666666667 +k=0.9999 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2106, 'NZGD2000 / Bay of Plenty 2000', 'EPSG', 2106, 'PROJCS["NZGD2000 / Bay of Plenty 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-37.7611111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",176.466111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2106"]]', 291855.7140827884, 512384.8777337122, 643527.7452001977, 864056.9088511216,'+proj=tmerc +lat_0=-37.76111111111111 +lon_0=176.4661111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2107, 'NZGD2000 / Poverty Bay 2000', 'EPSG', 2107, 'PROJCS["NZGD2000 / Poverty Bay 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-38.6244444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177.885555555556,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2107"]]', 292158.2557042534, 471482.8856528788, 749784.1728803082, 929108.8028289335,'+proj=tmerc +lat_0=-38.62444444444444 +lon_0=177.8855555555556 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2108, 'NZGD2000 / Hawkes Bay 2000', 'EPSG', 2108, 'PROJCS["NZGD2000 / Hawkes Bay 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-39.6508333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",176.673611111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2108"]]', 320243.2040169587, 525127.8524106519, 689221.2699244076, 894105.9183181009,'+proj=tmerc +lat_0=-39.65083333333333 +lon_0=176.6736111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2109, 'NZGD2000 / Taranaki 2000', 'EPSG', 2109, 'PROJCS["NZGD2000 / Taranaki 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-39.1355555555556,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174.227777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2109"]]', 349063.8998252554, 508979.1305437874, 724672.7801025654, 884588.0108210974,'+proj=tmerc +lat_0=-39.13555555555556 +lon_0=174.2277777777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2110, 'NZGD2000 / Tuhirangi 2000', 'EPSG', 2110, 'PROJCS["NZGD2000 / Tuhirangi 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-39.5122222222222,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",175.64,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2110"]]', 331526.4440643112, 462398.5226002141, 767865.2061641973, 898737.2847001002,'+proj=tmerc +lat_0=-39.51222222222222 +lon_0=175.64 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2111, 'NZGD2000 / Wanganui 2000', 'EPSG', 2111, 'PROJCS["NZGD2000 / Wanganui 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-40.2419444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",175.488055555556,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2111"]]', 299494.8888883330, 474159.6738050293, 715222.9718567099, 889887.7567734062,'+proj=tmerc +lat_0=-40.24194444444444 +lon_0=175.4880555555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2112, 'NZGD2000 / Wairarapa 2000', 'EPSG', 2112, 'PROJCS["NZGD2000 / Wairarapa 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-40.9252777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",175.647222222222,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2112"]]', 331494.9989712701, 491085.9339841814, 713828.5422753666, 873419.4772882780,'+proj=tmerc +lat_0=-40.92527777777777 +lon_0=175.6472222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2113, 'NZGD2000 / Wellington 2000', 'EPSG', 2113, 'PROJCS["NZGD2000 / Wellington 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-41.3011111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174.776388888889,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2113"]]', 376983.9525979346, 450584.4768477206, 773774.8307800313, 847375.3550298173,'+proj=tmerc +lat_0=-41.3011111111111 +lon_0=174.7763888888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2114, 'NZGD2000 / Collingwood 2000', 'EPSG', 2114, 'PROJCS["NZGD2000 / Collingwood 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-40.7147222222222,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",172.671944444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2114"]]', 352658.4796889185, 442769.3861242644, 742027.9633684927, 832138.8698038387,'+proj=tmerc +lat_0=-40.71472222222223 +lon_0=172.6719444444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2115, 'NZGD2000 / Nelson 2000', 'EPSG', 2115, 'PROJCS["NZGD2000 / Nelson 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-41.2744444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",173.299166666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2115"]]', 307161.9058255102, 482830.9476438540, 695652.0955776102, 871321.1373959539,'+proj=tmerc +lat_0=-41.27444444444444 +lon_0=173.2991666666667 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2116, 'NZGD2000 / Karamea 2000', 'EPSG', 2116, 'PROJCS["NZGD2000 / Karamea 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-41.2897222222222,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",172.108888888889,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2116"]]', 375856.7889633007, 461490.0175868160, 775941.3696225754, 861574.5982460907,'+proj=tmerc +lat_0=-41.28972222222222 +lon_0=172.1088888888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2117, 'NZGD2000 / Buller 2000', 'EPSG', 2117, 'PROJCS["NZGD2000 / Buller 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-41.8105555555556,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171.581111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2117"]]', 372085.3951323677, 471200.5176442167, 750868.3806539122, 849983.5031657612,'+proj=tmerc +lat_0=-41.81055555555555 +lon_0=171.5811111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2118, 'NZGD2000 / Grey 2000', 'EPSG', 2118, 'PROJCS["NZGD2000 / Grey 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-42.3336111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171.549722222222,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2118"]]', 361477.3172201158, 505366.8793403164, 751390.9801487222, 895280.5422689228,'+proj=tmerc +lat_0=-42.33361111111111 +lon_0=171.5497222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2119, 'NZGD2000 / Amuri 2000', 'EPSG', 2119, 'PROJCS["NZGD2000 / Amuri 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-42.6888888888889,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",173.01,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2119"]]', 303746.7247086538, 447439.7082099833, 746532.3565318497, 890225.3400331792,'+proj=tmerc +lat_0=-42.68888888888888 +lon_0=173.01 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2120, 'NZGD2000 / Marlborough 2000', 'EPSG', 2120, 'PROJCS["NZGD2000 / Marlborough 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-41.5444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",173.801944444445,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2120"]]', 287790.3239071124, 495859.6629425438, 672846.9765383589, 880916.3155737904,'+proj=tmerc +lat_0=-41.54444444444444 +lon_0=173.8019444444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2121, 'NZGD2000 / Hokitika 2000', 'EPSG', 2121, 'PROJCS["NZGD2000 / Hokitika 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-42.8861111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",170.979722222222,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2121"]]', 348986.3678190554, 477400.9491052686, 742849.9241949752, 871264.5054811884,'+proj=tmerc +lat_0=-42.88611111111111 +lon_0=170.9797222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2122, 'NZGD2000 / Okarito 2000', 'EPSG', 2122, 'PROJCS["NZGD2000 / Okarito 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-43.11,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",170.260833333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2122"]]', 311573.9040474917, 454042.7176498746, 693403.5116048877, 835872.3252072706,'+proj=tmerc +lat_0=-43.11 +lon_0=170.2608333333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2123, 'NZGD2000 / Jacksons Bay 2000', 'EPSG', 2123, 'PROJCS["NZGD2000 / Jacksons Bay 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-43.9777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168.606111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2123"]]', 349520.5891572814, 516433.2088372601, 709621.4311559983, 876534.0508359770,'+proj=tmerc +lat_0=-43.97777777777778 +lon_0=168.6061111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2124, 'NZGD2000 / Mount Pleasant 2000', 'EPSG', 2124, 'PROJCS["NZGD2000 / Mount Pleasant 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-43.5905555555556,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",172.726944444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2124"]]', 263769.9014014462, 457238.3454675112, 732026.4481210015, 925494.8921870665,'+proj=tmerc +lat_0=-43.59055555555556 +lon_0=172.7269444444445 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2125, 'NZGD2000 / Gawler 2000', 'EPSG', 2125, 'PROJCS["NZGD2000 / Gawler 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-43.7486111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171.360555555556,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2125"]]', 342052.6272937431, 475758.2244816920, 739347.0733851238, 873052.6705730727,'+proj=tmerc +lat_0=-43.74861111111111 +lon_0=171.3605555555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2126, 'NZGD2000 / Timaru 2000', 'EPSG', 2126, 'PROJCS["NZGD2000 / Timaru 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-44.4019444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171.057222222222,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2126"]]', 275313.8223157081, 464328.7062000643, 731383.4376628774, 920398.3215472336,'+proj=tmerc +lat_0=-44.40194444444445 +lon_0=171.0572222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2127, 'NZGD2000 / Lindis Peak 2000', 'EPSG', 2127, 'PROJCS["NZGD2000 / Lindis Peak 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-44.735,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",169.4675,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2127"]]', 299291.7840807848, 494663.5006499617, 721989.8968095447, 917361.6133787216,'+proj=tmerc +lat_0=-44.735 +lon_0=169.4675 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2128, 'NZGD2000 / Mount Nicholas 2000', 'EPSG', 2128, 'PROJCS["NZGD2000 / Mount Nicholas 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-45.1327777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168.398611111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2128"]]', 326750.1827886948, 475865.9640086957, 747182.4852417636, 896298.2664617645,'+proj=tmerc +lat_0=-45.13277777777778 +lon_0=168.3986111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2129, 'NZGD2000 / Mount York 2000', 'EPSG', 2129, 'PROJCS["NZGD2000 / Mount York 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-45.5636111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",167.738611111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2129"]]', 259895.9051947204, 468784.8250830195, 709888.0642164461, 918776.9841047451,'+proj=tmerc +lat_0=-45.56361111111111 +lon_0=167.7386111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2130, 'NZGD2000 / Observation Point 2000', 'EPSG', 2130, 'PROJCS["NZGD2000 / Observation Point 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-45.8161111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",170.628333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2130"]]', 320191.3578076389, 460228.2461191341, 796516.4082885034, 936553.2965999986,'+proj=tmerc +lat_0=-45.81611111111111 +lon_0=170.6283333333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2131, 'NZGD2000 / North Taieri 2000', 'EPSG', 2131, 'PROJCS["NZGD2000 / North Taieri 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-45.8613888888889,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",170.2825,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2131"]]', 267516.1919421859, 449637.2926151972, 695011.7044632514, 877132.8051362626,'+proj=tmerc +lat_0=-45.86138888888889 +lon_0=170.2825 +k=0.99996 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2132, 'NZGD2000 / Bluff 2000', 'EPSG', 2132, 'PROJCS["NZGD2000 / Bluff 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-46.6111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168.342777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2132"]]', 267535.6706000026, 499103.8227258224, 713854.9836694428, 945423.1357952626,'+proj=tmerc +lat_0=-46.6 +lon_0=168.3427777777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2133, 'NZGD2000 / UTM zone 58S', 'EPSG', 2133, 'PROJCS["NZGD2000 / UTM zone 58S",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2133"]]', -436707.5274757222, 1436707.5274757200, 3766067.7959205859, 5639482.8508720280,'+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2134, 'NZGD2000 / UTM zone 59S', 'EPSG', 2134, 'PROJCS["NZGD2000 / UTM zone 59S",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2134"]]', -953665.0429641943, 1953665.0429641943, 3739510.4697025536, 6646840.5556309422,'+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2135, 'NZGD2000 / UTM zone 60S', 'EPSG', 2135, 'PROJCS["NZGD2000 / UTM zone 60S",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2135"]]', -1110747.4639607639, 2110747.4639607664, 3914771.4939084545, 7136266.4218299847,'+proj=utm +zone=60 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2136, 'Accra / Ghana National Grid', 'EPSG', 2136, 'PROJCS["Accra / Ghana National Grid",GEOGCS["Accra",DATUM["Accra",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],TOWGS84[-199,32,322,0,0,0,0],AUTHORITY["EPSG","6168"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4168"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",4.66666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-1,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99975,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",900000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["Gold Coast foot",0.3047997101815088,AUTHORITY["EPSG","9094"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2136"]]', -328900.7711471507, 2121429.6197992872, -45645.9929935927, 2404684.3979528452,'+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.99975 +x_0=274319.7391633579 +y_0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +to_meter=0.3047997101815088 +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2137, 'Accra / TM 1 NW', 'EPSG', 2137, 'PROJCS["Accra / TM 1 NW",GEOGCS["Accra",DATUM["Accra",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],TOWGS84[-199,32,322,0,0,0,0],AUTHORITY["EPSG","6168"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4168"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-1,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2137"]]', 176374.2840103703, 858099.4500545930, 71686.2776127554, 753411.4436569780,'+proj=tmerc +lat_0=0 +lon_0=-1 +k=0.9996 +x_0=500000 +y_0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2138, 'NAD27(CGQ77) / Quebec Lambert', 'EPSG', 2138, 'PROJCS["NAD27(CGQ77) / Quebec Lambert",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",44,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-68.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",60,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",46,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",0,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2138"]]', -1002397.4097898558, 1006299.3869399926, 142744.2726623979, 2151441.0693922464,'+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_0=0 +y_0=0 +ellps=clrk66 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2154, 'RGF93 / Lambert-93', 'EPSG', 2154, 'PROJCS["RGF93 / Lambert-93",GEOGCS["RGF93",DATUM["Reseau Geodesique Francais 1993",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6171"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4171"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",46.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",3,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",49,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",700000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6600000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2154"]]', -412284.9175915429, 1354628.6788576755, 5751502.4316810320, 7518416.0281302504,'+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2157, 'IRENET95 / Irish Transverse Mercator', 'EPSG', 2157, 'PROJCS["IRENET95 / Irish Transverse Mercator",GEOGCS["IRENET95",DATUM["IRENET95",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6173"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4173"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",53.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-8,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99982,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",600000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",750000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2157"]]', 369658.8194022811, 837299.0887971336, 509368.2001009441, 977008.4694957966,'+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=0.99982 +x_0=600000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2158, 'IRENET95 / UTM zone 29N', 'EPSG', 2158, 'PROJCS["IRENET95 / UTM zone 29N",GEOGCS["IRENET95",DATUM["IRENET95",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6173"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4173"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2158"]]', 336760.3688421948, 809321.7278875126, 5685262.8662423904, 6157824.2252877082,'+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2159, 'Sierra Leone 1924 / New Colony Grid', 'EPSG', 2159, 'PROJCS["Sierra Leone 1924 / New Colony Grid",GEOGCS["Sierra Leone 1924",DATUM["Sierra Leone Colony 1924",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],AUTHORITY["EPSG","6174"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4174"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",6.66666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["Gold Coast foot",0.3047997101815088,AUTHORITY["EPSG","9094"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2159"]]', 10210.9861092167, 97273.0287447434, 598787.7978659393, 685849.8405014660,'+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_0=152399.8550907544 +y_0=0 +a=6378300 +b=6356751.689189189 +to_meter=0.3047997101815088 +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2160, 'Sierra Leone 1924 / New War Office Grid', 'EPSG', 2160, 'PROJCS["Sierra Leone 1924 / New War Office Grid",GEOGCS["Sierra Leone 1924",DATUM["Sierra Leone Colony 1924",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],AUTHORITY["EPSG","6174"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4174"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",6.66666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",800000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",600000,AUTHORITY["EPSG","8807"]],UNIT["Gold Coast foot",0.3047997101815088,AUTHORITY["EPSG","9094"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2160"]]', 310210.9861092168, 397273.0287447437, 1198787.7978659392, 1285849.8405014660,'+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_0=243839.7681452071 +y_0=182879.8261089053 +a=6378300 +b=6356751.689189189 +to_meter=0.3047997101815088 +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2161, 'Sierra Leone 1968 / UTM zone 28N', 'EPSG', 2161, 'PROJCS["Sierra Leone 1968 / UTM zone 28N",GEOGCS["Sierra Leone 1968",DATUM["Sierra Leone 1968",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-88,4,101,0,0,0,0],AUTHORITY["EPSG","6175"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4175"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2161"]]', 595164.3821384236, 917159.4157473358, 784368.1882991646, 1106363.2219080769,'+proj=utm +zone=28 +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2162, 'Sierra Leone 1968 / UTM zone 29N', 'EPSG', 2162, 'PROJCS["Sierra Leone 1968 / UTM zone 29N",GEOGCS["Sierra Leone 1968",DATUM["Sierra Leone 1968",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-88,4,101,0,0,0,0],AUTHORITY["EPSG","6175"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4175"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2162"]]', 85118.7186404436, 445212.4302646398, 753644.3663136904, 1113738.0779378867,'+proj=utm +zone=29 +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2163, 'US National Atlas Equal Area', 'EPSG', 2163, 'PROJCS["US National Atlas Equal Area",GEOGCS["Unspecified datum based upon the Clarke 1866 Authalic Sphere",DATUM["Not specified (based on Clarke 1866 Authalic Sphere)",SPHEROID["Clarke 1866 Authalic Sphere",6370997,0,AUTHORITY["EPSG","7052"]],AUTHORITY["EPSG","6052"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4052"]],PROJECTION["Lambert Azimuthal Equal Area (Spherical)",AUTHORITY["EPSG","1027"]],PARAMETER["Latitude of natural origin",45,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-100,AUTHORITY["EPSG","8802"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2163"]]', -8280935.0084466737, 3930755.4147011231, -4973942.7026070478, 7237747.7205407490,'+proj=laea +lat_0=45 +lon_0=-100 +x_0=0 +y_0=0 +a=6370997 +b=6370997 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2164, 'Locodjo 1965 / TM 5 NW', 'EPSG', 2164, 'PROJCS["Locodjo 1965 / TM 5 NW",GEOGCS["Locodjo 1965",DATUM["Locodjo 1965",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-125,53,467,0,0,0,0],AUTHORITY["EPSG","6142"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4142"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2164"]]', 206275.4213386623, 720155.0833545338, 86112.3296537336, 599991.9916696051,'+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2165, 'Abidjan 1987 / TM 5 NW', 'EPSG', 2165, 'PROJCS["Abidjan 1987 / TM 5 NW",GEOGCS["Abidjan 1987",DATUM["Abidjan 1987",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY["EPSG","6143"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4143"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2165"]]', 206275.3895891488, 720155.0705695403, 86112.5427455047, 599992.2237258962,'+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2169, 'Luxembourg 1930 / Gauss', 'EPSG', 2169, 'PROJCS["Luxembourg 1930 / Gauss",GEOGCS["Luxembourg 1930",DATUM["Luxembourg 1930",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-189.6806,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.4598],AUTHORITY["EPSG","6181"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4181"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",49.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",6.17777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",80000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",100000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2169"]]', 33842.4381056076, 120628.2925296510, 54528.0152301813, 141313.8696542247,'+proj=tmerc +lat_0=49.83333333333334 +lon_0=6.166666666666667 +k=1 +x_0=80000 +y_0=100000 +ellps=intl +towgs84=-189.6806,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.4598 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2172, 'Pulkovo 1942(58) / Poland zone II', 'EPSG', 2172, 'PROJCS["Pulkovo 1942(58) / Poland zone II",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo 1942(58)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4179"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",53.0019444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21.5027777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9998,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4603000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",5806000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2172"]]', 4417202.8853108730, 4785174.0401414907, 5615813.3477114025, 5983784.5025420202,'+proj=sterea +lat_0=53.00194444444445 +lon_0=21.50277777777778 +k=0.9998 +x_0=4603000 +y_0=5806000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2173, 'Pulkovo 1942(58) / Poland zone III', 'EPSG', 2173, 'PROJCS["Pulkovo 1942(58) / Poland zone III",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo 1942(58)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4179"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",53.5833333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",17.0083333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9998,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3501000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",5999000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2173"]]', 3296863.2790247454, 3713821.7460732617, 5788073.9238817627, 6205032.3909302791,'+proj=sterea +lat_0=53.58333333333334 +lon_0=17.00833333333333 +k=0.9998 +x_0=3501000 +y_0=5999000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2174, 'Pulkovo 1942(58) / Poland zone IV', 'EPSG', 2174, 'PROJCS["Pulkovo 1942(58) / Poland zone IV",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo 1942(58)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4179"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",51.6708333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",16.6722222222222,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9998,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3703000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",5627000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2174"]]', 3470421.8426476896, 3927520.2138002126, 5367405.3480426925, 5824503.7191952155,'+proj=sterea +lat_0=51.67083333333333 +lon_0=16.67222222222222 +k=0.9998 +x_0=3703000 +y_0=5627000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2175, 'Pulkovo 1942(58) / Poland zone V', 'EPSG', 2175, 'PROJCS["Pulkovo 1942(58) / Poland zone V",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo 1942(58)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4179"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",18.9583333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999983,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",237000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",-4700000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2175"]]', 127330.6334945262, 352967.4228739144, 768891.7836690796, 994528.5730484678,'+proj=tmerc +lat_0=0 +lon_0=18.95833333333333 +k=0.999983 +x_0=237000 +y_0=-4700000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2176, 'ETRS89 / Poland CS2000 zone 5', 'EPSG', 2176, 'PROJCS["ETRS89 / Poland CS2000 zone 5",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999923,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",5500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["x",NORTH],AXIS["y",EAST],AUTHORITY["EPSG","2176"]]', 5227947.6507144302, 5817684.3824769024, 5558351.1720929813, 6148087.9038554536,'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.999923 +x_0=5500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2177, 'ETRS89 / Poland CS2000 zone 6', 'EPSG', 2177, 'PROJCS["ETRS89 / Poland CS2000 zone 6",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",18,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999923,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",6500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["x",NORTH],AXIS["y",EAST],AUTHORITY["EPSG","2177"]]', 6121623.7566167757, 6878376.2433832243, 5459108.7211042655, 6215861.2078707140,'+proj=tmerc +lat_0=0 +lon_0=18 +k=0.999923 +x_0=6500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2178, 'ETRS89 / Poland CS2000 zone 7', 'EPSG', 2178, 'PROJCS["ETRS89 / Poland CS2000 zone 7",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999923,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",7500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["x",NORTH],AXIS["y",EAST],AUTHORITY["EPSG","2178"]]', 7184149.7240463584, 7815850.2759536406, 5428153.4936015579, 6059854.0455088400,'+proj=tmerc +lat_0=0 +lon_0=21 +k=0.999923 +x_0=7500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2179, 'ETRS89 / Poland CS2000 zone 8', 'EPSG', 2179, 'PROJCS["ETRS89 / Poland CS2000 zone 8",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999923,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",8500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["x",NORTH],AXIS["y",EAST],AUTHORITY["EPSG","2179"]]', 8137103.3422743875, 8764124.0716875576, 5417162.3021273772, 6044183.0315405474,'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.999923 +x_0=8500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2180, 'ETRS89 / Poland CS92', 'EPSG', 2180, 'PROJCS["ETRS89 / Poland CS92",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",19,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9993,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",-5300000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["x",NORTH],AXIS["y",EAST],AUTHORITY["EPSG","2180"]]', 109573.4691694318, 911620.1702803742, 121788.4671384952, 923835.1682494377,'+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9993 +x_0=500000 +y_0=-5300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2188, 'Azores Occidental 1939 / UTM zone 25N', 'EPSG', 2188, 'PROJCS["Azores Occidental 1939 / UTM zone 25N",GEOGCS["Azores Occidental 1939",DATUM["Azores Occidental Islands 1939",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-422.651,-172.995,84.02,0,0,0,0],AUTHORITY["EPSG","6182"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4182"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2188"]]', 629412.1383300235, 684244.1196771553, 4350260.9397381035, 4405092.9210852353,'+proj=utm +zone=25 +ellps=intl +towgs84=-425,-169,81,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2189, 'Azores Central 1948 / UTM zone 26N', 'EPSG', 2189, 'PROJCS["Azores Central 1948 / UTM zone 26N",GEOGCS["Azores Central 1948",DATUM["Azores Central Islands 1948",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-104,167,-38,0,0,0,0],AUTHORITY["EPSG","6183"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4183"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2189"]]', 330427.9627369097, 505895.2863622347, 4200028.0156821712, 4375495.3393074962,'+proj=utm +zone=26 +ellps=intl +towgs84=-104,167,-38,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2190, 'Azores Oriental 1940 / UTM zone 26N', 'EPSG', 2190, 'PROJCS["Azores Oriental 1940 / UTM zone 26N",GEOGCS["Azores Oriental 1940",DATUM["Azores Oriental Islands 1940",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-203,141,53,0,0,0,0],AUTHORITY["EPSG","6184"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4184"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2190"]]', 589486.6564854867, 717463.2761178061, 4078499.2309960372, 4206475.8506283566,'+proj=utm +zone=26 +ellps=intl +towgs84=-203,141,53,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2193, 'NZGD2000 / New Zealand Transverse Mercator 2000', 'EPSG', 2193, 'PROJCS["NZGD2000 / New Zealand Transverse Mercator 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",173,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1600000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2193"]]', 786466.9656942535, 2321096.1472377533, 4707298.5930351519, 6241927.7745786517,'+proj=tmerc +lat_0=0 +lon_0=173 +k=0.9996 +x_0=1600000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2195, 'NAD83(HARN) / UTM zone 2S', 'EPSG', 2195, 'PROJCS["NAD83(HARN) / UTM zone 2S",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2195"]]', 506899.2011294434, 820248.9226923949, 8255884.5735264980, 8569234.2950894496,'+proj=utm +zone=2 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2196, 'ETRS89 / Kp2000 Jutland', 'EPSG', 2196, 'PROJCS["ETRS89 / Kp2000 Jutland",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2196"]]', 27941.5700090024, 390765.2380629295, 6054247.6679201763, 6417071.3359741034,'+proj=tmerc +lat_0=0 +lon_0=9.5 +k=0.99995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2197, 'ETRS89 / Kp2000 Zealand', 'EPSG', 2197, 'PROJCS["ETRS89 / Kp2000 Zealand",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2197"]]', 386258.1452326990, 580063.8353838636, 6038873.9377834158, 6232679.6279345803,'+proj=tmerc +lat_0=0 +lon_0=12 +k=0.99995 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2198, 'ETRS89 / Kp2000 Bornholm', 'EPSG', 2198, 'PROJCS["ETRS89 / Kp2000 Bornholm",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",900000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2198"]]', 870212.6639031580, 918892.1668538065, 6089641.1596705282, 6138320.6626211767,'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2200, 'ATS77 / New Brunswick Stereographic (ATS77)', 'EPSG', 2200, 'PROJCS["ATS77 / New Brunswick Stereographic (ATS77)",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",46.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-66.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999912,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2200"]]', 88883.5519029415, 530976.6486233600, 561898.9309885962, 1003992.0277090147,'+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=300000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2201, 'REGVEN / UTM zone 18N', 'EPSG', 2201, 'PROJCS["REGVEN / UTM zone 18N",GEOGCS["REGVEN",DATUM["Red Geodesica Venezolana",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6189"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4189"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2201"]]', 489402.9844025244, 1019806.5317735542, 766068.9720570988, 1296472.5194281287,'+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2202, 'REGVEN / UTM zone 19N', 'EPSG', 2202, 'PROJCS["REGVEN / UTM zone 19N",GEOGCS["REGVEN",DATUM["Red Geodesica Venezolana",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6189"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4189"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2202"]]', -358305.8732542442, 1358305.8732542427, 47786.6793235281, 1764398.4258320150,'+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2203, 'REGVEN / UTM zone 20N', 'EPSG', 2203, 'PROJCS["REGVEN / UTM zone 20N",GEOGCS["REGVEN",DATUM["Red Geodesica Venezolana",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6189"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4189"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2203"]]', -369914.9677841068, 1486970.9974771505, 35127.6397804151, 1892013.6050416724,'+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2204, 'NAD27 / Tennessee', 'EPSG', 2204, 'PROJCS["NAD27 / Tennessee",GEOGCS["NAD27",DATUM["North American Datum 1927",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],TOWGS84[-32.3841359,180.4090461,120.8442577,-2.1545854,-0.1498782,0.5742915,8.1049164],AUTHORITY["EPSG","6267"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4267"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-86,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.2611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36.4166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",100000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2204"]]', 657273.7940902557, 3354698.4229772737, -796861.7236657073, 1900562.9052213106,'+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=34.66666666666666 +lon_0=-86 +x_0=609601.2192024384 +y_0=30480.06096012192 +datum=NAD27 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2205, 'NAD83 / Kentucky North', 'EPSG', 2205, 'PROJCS["NAD83 / Kentucky North",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.9777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2205"]]', 343063.5783981882, 663108.0194191305, -55347.0895147103, 264697.3515062319,'+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +datum=NAD83 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2206, 'ED50 / 3-degree Gauss-Kruger zone 9', 'EPSG', 2206, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 9",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",9500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2206"]]', 9181443.9909020178, 9829403.6692792066, 4029626.8755516950, 4677586.5539288838,'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2207, 'ED50 / 3-degree Gauss-Kruger zone 10', 'EPSG', 2207, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 10",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",10500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2207"]]', 10188296.8420759960, 10811785.8996031360, 3981427.1789860352, 4604916.2365131752,'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2208, 'ED50 / 3-degree Gauss-Kruger zone 11', 'EPSG', 2208, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 11",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",11500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2208"]]', 11147864.2877913025, 11852205.3250214792, 3969883.6856869336, 4674224.7229171104,'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2209, 'ED50 / 3-degree Gauss-Kruger zone 12', 'EPSG', 2209, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 12",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",12500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2209"]]', 12134004.0916886923, 12866052.2014635227, 3951594.7297296598, 4683642.8395044902,'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2210, 'ED50 / 3-degree Gauss-Kruger zone 13', 'EPSG', 2210, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 13",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",13500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2210"]]', 13238495.7854005215, 13761547.0337864770, 4049942.4702823463, 4572993.7186683018,'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2211, 'ED50 / 3-degree Gauss-Kruger zone 14', 'EPSG', 2211, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 14",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",14500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2211"]]', 14235586.1471423139, 14764443.0807338539, 4089785.2753591840, 4618642.2089507241,'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2212, 'ED50 / 3-degree Gauss-Kruger zone 15', 'EPSG', 2212, 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 15",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",15500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2212"]]', 15191714.2021516890, 15660427.5611658364, 4084353.8939048168, 4553067.2529189643,'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2213, 'ETRS89 / TM 30 NE', 'EPSG', 2213, 'PROJCS["ETRS89 / TM 30 NE",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2213"]]', 385459.0856610991, 618587.1976612350, 4791791.6391448415, 5024919.7511449774,'+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2215, 'Manoca 1962 / UTM zone 32N', 'EPSG', 2215, 'PROJCS["Manoca 1962 / UTM zone 32N",GEOGCS["Manoca 1962",DATUM["Manoca 1962",SPHEROID["Clarke 1880 (IGN)",6378249.2,293.4660212936269,AUTHORITY["EPSG","7011"]],TOWGS84[-70.9,-151.8,-41.4,0,0,0,0],AUTHORITY["EPSG","6193"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4193"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2215"]]', 384661.5798092073, 710147.8090128891, 232539.7945586205, 558026.0237623024,'+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2216, 'Qornoq 1927 / UTM zone 22N', 'EPSG', 2216, 'PROJCS["Qornoq 1927 / UTM zone 22N",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2216"]]', -219467.8850348096, 1219039.4589377421, 6697983.8340535783, 8136491.1780261300,'+proj=utm +zone=22 +ellps=intl +towgs84=164,138,-189,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2217, 'Qornoq 1927 / UTM zone 23N', 'EPSG', 2217, 'PROJCS["Qornoq 1927 / UTM zone 23N",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2217"]]', 325019.4301229967, 645338.3401979579, 6594406.5287773638, 6914725.4388523250,'+proj=utm +zone=23 +ellps=intl +towgs84=164,138,-189,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (1, 2218, 'Scoresbysund 1952 / Greenland zone 5 east', 'EPSG', 2218, 'PROJCS["Scoresbysund 1952 / Greenland zone 5 east",GEOGCS["Scoresbysund 1952",DATUM["Scoresbysund 1952",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[105,326,-102.5,0,0,0.814,-0.6],AUTHORITY["EPSG","6195"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4195"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",70.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2218"]]', NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2219, 'ATS77 / UTM zone 19N', 'EPSG', 2219, 'PROJCS["ATS77 / UTM zone 19N",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2219"]]', 362785.1625751117, 879192.0358365812, 4821957.2635839023, 5338364.1368453717,'+proj=utm +zone=19 +a=6378135 +b=6356750.304921594 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2220, 'ATS77 / UTM zone 20N', 'EPSG', 2220, 'PROJCS["ATS77 / UTM zone 20N",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2220"]]', 246493.2215322746, 775368.9894497383, 4800546.1440918654, 5329421.9120093291,'+proj=utm +zone=20 +a=6378135 +b=6356750.304921594 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (1, 2221, 'Scoresbysund 1952 / Greenland zone 6 east', 'EPSG', 2221, 'PROJCS["Scoresbysund 1952 / Greenland zone 6 east",GEOGCS["Scoresbysund 1952",DATUM["Scoresbysund 1952",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[105,326,-102.5,0,0,0.814,-0.6],AUTHORITY["EPSG","6195"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4195"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",67.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-32,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2221"]]', NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2222, 'NAD83 / Arizona East (ft)', 'EPSG', 2222, 'PROJCS["NAD83 / Arizona East (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-110.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2222"]]', -440814.0918560317, 1710706.4654839328, 80450.0554670153, 2231970.6128069799,'+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2223, 'NAD83 / Arizona Central (ft)', 'EPSG', 2223, 'PROJCS["NAD83 / Arizona Central (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-111.927777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2223"]]', -368255.3897498195, 1781786.8885216091, 81591.0176148102, 2231633.2958862388,'+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2224, 'NAD83 / Arizona West (ft)', 'EPSG', 2224, 'PROJCS["NAD83 / Arizona West (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-113.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2224"]]', -210777.0770989750, 1663452.4515956906, 347507.4201468524, 2221736.9488415180,'+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2225, 'NAD83 / California zone 1 (ftUS)', 'EPSG', 2225, 'PROJCS["NAD83 / California zone 1 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-122,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.6777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2225"]]', 5846041.2662284890, 7153310.6223322922, 1529027.4344871240, 2836296.7905909272,'+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2226, 'NAD83 / California zone 2 (ftUS)', 'EPSG', 2226, 'PROJCS["NAD83 / California zone 2 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-122,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2226"]]', 5942168.2905052014, 7296373.3546982838, 1489730.8713681373, 2843935.9355612198,'+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2227, 'NAD83 / California zone 3 (ftUS)', 'EPSG', 2227, 'PROJCS["NAD83 / California zone 3 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.4444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.0777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2227"]]', 5792757.7403533669, 7374521.7625433825, 1304183.2145662616, 2885947.2367562772,'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2228, 'NAD83 / California zone 4 (ftUS)', 'EPSG', 2228, 'PROJCS["NAD83 / California zone 4 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",35.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-119,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.2611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2228"]]', 5631004.2433378307, 7602027.2925262273, 1160795.1338200969, 3131818.1830084934,'+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2229, 'NAD83 / California zone 5 (ftUS)', 'EPSG', 2229, 'PROJCS["NAD83 / California zone 5 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-118,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.4666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.0333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2229"]]', 5465009.1609394993, 7799722.7566179926, 778801.2782715261, 3113514.8739500193,'+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2230, 'NAD83 / California zone 6 (ftUS)', 'EPSG', 2230, 'PROJCS["NAD83 / California zone 6 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",32.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-116.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",33.8833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.7944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2230"]]', 5953058.1721292577, 7148702.1176366721, 1461893.0434756203, 2657536.9889830348,'+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2231, 'NAD83 / Colorado North (ftUS)', 'EPSG', 2231, 'PROJCS["NAD83 / Colorado North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2231"]]', 1956911.1907966209, 4014914.7888573541, 337058.3887309746, 2395061.9867917079,'+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2232, 'NAD83 / Colorado Central (ftUS)', 'EPSG', 2232, 'PROJCS["NAD83 / Colorado Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.75,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.45,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2232"]]', 1935901.4206690077, 4035356.3814456815, 436314.1162787601, 2535769.0770554338,'+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2233, 'NAD83 / Colorado South (ftUS)', 'EPSG', 2233, 'PROJCS["NAD83 / Colorado South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.4444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.2333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2233"]]', 1919281.3811031677, 4051526.7235410091, 376533.5652725727, 2508778.9077104141,'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2234, 'NAD83 / Connecticut (ftUS)', 'EPSG', 2234, 'PROJCS["NAD83 / Connecticut (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-72.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.8666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.2111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2234"]]', 718634.5613581235, 1278604.3634990656, 469904.7219670957, 1029874.5241080378,'+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2235, 'NAD83 / Delaware (ftUS)', 'EPSG', 2235, 'PROJCS["NAD83 / Delaware (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75.4166666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2235"]]', 398139.0533871993, 932335.0829083968, 150191.3809581253, 684387.4104793228,'+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2236, 'NAD83 / Florida East (ftUS)', 'EPSG', 2236, 'PROJCS["NAD83 / Florida East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2236"]]', -608026.5451337624, 1820522.2989065010, -17570.8361189638, 2410978.0079212997,'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2237, 'NAD83 / Florida West (ftUS)', 'EPSG', 2237, 'PROJCS["NAD83 / Florida West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2237"]]', -51165.2097146506, 1209463.7267959713, 680540.5974188186, 1941169.5339294404,'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2238, 'NAD83 / Florida North (ftUS)', 'EPSG', 2238, 'PROJCS["NAD83 / Florida North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",29,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",30.7611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",29.5833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2238"]]', 934299.6926004398, 2788994.4871284789, -512688.5297606914, 1342006.2647673476,'+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2239, 'NAD83 / Georgia East (ftUS)', 'EPSG', 2239, 'PROJCS["NAD83 / Georgia East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2239"]]', -146629.5169246417, 1488401.8846826870, 101838.6781480814, 1736870.0797554100,'+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2240, 'NAD83 / Georgia West (ftUS)', 'EPSG', 2240, 'PROJCS["NAD83 / Georgia West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-84.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2296583.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2240"]]', 1423510.6048609097, 3085768.6736376111, 195444.3503321179, 1857702.4191088194,'+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2241, 'NAD83 / Idaho East (ftUS)', 'EPSG', 2241, 'PROJCS["NAD83 / Idaho East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-112.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999947368,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2241"]]', 140209.7798920330, 1186622.3882233428, 99522.3084515608, 1145934.9167828705,'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2242, 'NAD83 / Idaho Central (ftUS)', 'EPSG', 2242, 'PROJCS["NAD83 / Idaho Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999947368,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1640416.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2242"]]', 939868.1707004819, 2346402.2708041169, 93450.8194352621, 1499984.9195388971,'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2243, 'NAD83 / Idaho West (ftUS)', 'EPSG', 2243, 'PROJCS["NAD83 / Idaho West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-115.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2624666.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2243"]]', 1285391.9874189828, 3947630.1428406274, 69864.3459746134, 2732102.5013962581,'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2246, 'NAD83 / Kentucky North (ftUS)', 'EPSG', 2246, 'PROJCS["NAD83 / Kentucky North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.9777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2246"]]', 1125534.4237947230, 2175546.8940442651, -181584.5761828456, 868427.8940666964,'+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2247, 'NAD83 / Kentucky South (ftUS)', 'EPSG', 2247, 'PROJCS["NAD83 / Kentucky South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-85.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36.7444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2247"]]', 472901.3825377016, 2802056.9948331868, 861066.8511629028, 3190222.4634583879,'+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2248, 'NAD83 / Maryland (ftUS)', 'EPSG', 2248, 'PROJCS["NAD83 / Maryland (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-77,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.45,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.3111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1312333.333,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2248"]]', 568489.8727476340, 1923598.5208979542, -238548.4155566238, 1116560.2325936964,'+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2249, 'NAD83 / Massachusetts Mainland (ftUS)', 'EPSG', 2249, 'PROJCS["NAD83 / Massachusetts Mainland (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-71.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",42.6944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",656166.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",2460625,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2249"]]', 88025.5978945497, 1125647.6066771208, 2375303.3233752861, 3412925.3321578573,'+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2250, 'NAD83 / Massachusetts Island (ftUS)', 'EPSG', 2250, 'PROJCS["NAD83 / Massachusetts Island (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-70.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.4944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.2833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2250"]]', 1521953.6260255815, 1813926.8365537962, -18031.3871921602, 273941.8233360544,'+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2251, 'NAD83 / Michigan North (ft)', 'EPSG', 2251, 'PROJCS["NAD83 / Michigan North (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",44.7944444444444,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-87,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.0944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.4944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",26246719.16,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2251"]]', 25327364.1849734153, 27202208.7918202054, -219105.7059533730, 1655738.9008934170,'+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2252, 'NAD83 / Michigan Central (ft)', 'EPSG', 2252, 'PROJCS["NAD83 / Michigan Central (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.3277777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.3777777777778,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",45.7,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.1944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",19685039.37,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2252"]]', 18948689.2785201354, 20263905.6751991751, -85661.6848125225, 1229554.7118665172,'+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2253, 'NAD83 / Michigan South (ft)', 'EPSG', 2253, 'PROJCS["NAD83 / Michigan South (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.3777777777778,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43.6777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.1,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",13123359.58,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2253"]]', 12321832.5443331297, 13761970.1370578375, -179461.3318255346, 1260676.2608991732,'+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2254, 'NAD83 / Mississippi East (ftUS)', 'EPSG', 2254, 'PROJCS["NAD83 / Mississippi East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",29.5,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-88.8333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",984250,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2254"]]', -24525.9601216527, 1868524.3196642272, 149823.4529049959, 2042873.7326908758,'+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2255, 'NAD83 / Mississippi West (ftUS)', 'EPSG', 2255, 'PROJCS["NAD83 / Mississippi West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",29.5,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-90.3333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2296583.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2255"]]', 1481870.3520568162, 3000580.2059323339, 517627.2438610209, 2036337.0977365385,'+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2256, 'NAD83 / Montana (ft)', 'EPSG', 2256, 'PROJCS["NAD83 / Montana (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",44.2611111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-109.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",49,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968503.937,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2256"]]', 188180.4616167685, 3459187.8426047730, -691576.9379574262, 2579430.4430305782,'+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2257, 'NAD83 / New Mexico East (ftUS)', 'EPSG', 2257, 'PROJCS["NAD83 / New Mexico East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-104.333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999909091,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",541337.5,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2257"]]', -411747.9143079264, 1480988.4137679958, 329927.9929537366, 2222664.3210296589,'+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2258, 'NAD83 / New Mexico Central (ftUS)', 'EPSG', 2258, 'PROJCS["NAD83 / New Mexico Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-106.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1640416.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2258"]]', 641484.1130068585, 2617595.4975113216, 248546.8579984872, 2224658.2425029502,'+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2259, 'NAD83 / New Mexico West (ftUS)', 'EPSG', 2259, 'PROJCS["NAD83 / New Mexico West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-107.833333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999916667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2723091.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2259"]]', 1694213.4771599608, 3841485.7660572015, 80867.0245529482, 2228139.3134501890,'+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2260, 'NAD83 / New York East (ftUS)', 'EPSG', 2260, 'PROJCS["NAD83 / New York East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-74.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",492125,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2260"]]', -306494.5782674673, 1263092.9216830805, 717842.3978640770, 2287429.8978146248,'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2261, 'NAD83 / New York Central (ftUS)', 'EPSG', 2261, 'PROJCS["NAD83 / New York Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-76.5944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",820208.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2261"]]', 411909.0156937001, 1330905.7168343650, 709496.7300538094, 1628493.4311944743,'+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2262, 'NAD83 / New York West (ftUS)', 'EPSG', 2262, 'PROJCS["NAD83 / New York West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-78.5944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1148291.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2262"]]', 812596.6429117845, 1493954.5803753060, 687305.7585516067, 1368663.6960151282,'+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2263, 'NAD83 / New York Long Island (ftUS)', 'EPSG', 2263, 'PROJCS["NAD83 / New York Long Island (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-74,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.0333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.6777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",984250,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2263"]]', 898220.3850237117, 1609995.9677288195, -90325.5924131781, 621449.9902919298,'+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2264, 'NAD83 / North Carolina (ftUS)', 'EPSG', 2264, 'PROJCS["NAD83 / North Carolina (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.75,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-79,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.1666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2264"]]', 327409.7001211236, 3153702.6527693654, -850710.8124347464, 1975582.1402134955,'+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2265, 'NAD83 / North Dakota North (ft)', 'EPSG', 2265, 'PROJCS["NAD83 / North Dakota North (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",47,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",48.7444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",47.4444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968503.937,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2265"]]', 1044425.3557686503, 2917439.5384883113, -521740.9174792969, 1351273.2652403641,'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2266, 'NAD83 / North Dakota South (ft)', 'EPSG', 2266, 'PROJCS["NAD83 / North Dakota South (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.4944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",46.1944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968503.937,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2266"]]', 1027249.6733193446, 3011434.1639237794, -527172.4012944551, 1457012.0893099797,'+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2267, 'NAD83 / Oklahoma North (ftUS)', 'EPSG', 2267, 'PROJCS["NAD83 / Oklahoma North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",35,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.7666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",35.5666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2267"]]', 425278.4897388127, 3088220.5535046816, -887823.7840004148, 1775118.2797654540,'+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2268, 'NAD83 / Oklahoma South (ftUS)', 'EPSG', 2268, 'PROJCS["NAD83 / Oklahoma South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.2333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",33.9333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2268"]]', 1325636.2611207864, 3092230.2753731059, -411664.6726968498, 1354929.3415554697,'+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2269, 'NAD83 / Oregon North (ft)', 'EPSG', 2269, 'PROJCS["NAD83 / Oregon North (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",46,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",8202099.738,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2269"]]', 7195222.2103881408, 9303692.0165200103, -506135.4940195194, 1602334.3121123502,'+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2270, 'NAD83 / Oregon South (ft)', 'EPSG', 2270, 'PROJCS["NAD83 / Oregon South (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",44,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",4921259.843,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2270"]]', 3764910.9396473403, 5941785.3719619451, -480450.8423395365, 1696423.5899750683,'+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2271, 'NAD83 / Pennsylvania North (ftUS)', 'EPSG', 2271, 'PROJCS["NAD83 / Pennsylvania North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-77.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.95,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.8833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2271"]]', 1164219.3676399728, 2847720.2622661291, -318796.2579014467, 1364704.6367247096,'+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2272, 'NAD83 / Pennsylvania South (ftUS)', 'EPSG', 2272, 'PROJCS["NAD83 / Pennsylvania South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-77.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.9333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2272"]]', 1153770.3450468860, 2853530.7092643525, -431587.7872397194, 1268172.5769777470,'+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2273, 'NAD83 / South Carolina (ft)', 'EPSG', 2273, 'PROJCS["NAD83 / South Carolina (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",31.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-81,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",34.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2273"]]', 1238686.8013525444, 2798491.8409484804, -117528.6601167727, 1442276.3794791634,'+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2274, 'NAD83 / Tennessee (ftUS)', 'EPSG', 2274, 'PROJCS["NAD83 / Tennessee (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-86,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.4166666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",35.2611111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2274"]]', 625804.8257016587, 3323167.1146772094, -775477.8236392579, 1921884.4653362927,'+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2275, 'NAD83 / Texas North (ftUS)', 'EPSG', 2275, 'PROJCS["NAD83 / Texas North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-101.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.1944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.65,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",656166.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3280833.333,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2275"]]', 175669.6558717848, 1130623.2030102078, 3316423.8184528235, 4271377.3655912466,'+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2276, 'NAD83 / Texas North Central (ftUS)', 'EPSG', 2276, 'PROJCS["NAD83 / Texas North Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",31.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",33.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.1444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6561666.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2276"]]', 491288.7623681445, 3423961.6430775337, 5665001.3267335976, 8597674.2074429867,'+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2277, 'NAD83 / Texas Central (ftUS)', 'EPSG', 2277, 'PROJCS["NAD83 / Texas Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",29.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.333333333333,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",31.8833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",30.1166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2296583.333,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",9842500,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2277"]]', 206847.0073912112, 4546796.2101559430, 8227557.4277779689, 12567506.6305427006,'+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2278, 'NAD83 / Texas South Central (ftUS)', 'EPSG', 2278, 'PROJCS["NAD83 / Texas South Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",27.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-99,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",30.2833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",28.3833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",13123333.333,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2278"]]', -43942.1854797237, 3735415.3450922344, 11782887.3710882869, 15562244.9016602449,'+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2279, 'NAD83 / Texas South (ftUS)', 'EPSG', 2279, 'PROJCS["NAD83 / Texas South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",25.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",27.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",26.1666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",984250,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",16404166.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2279"]]', 402969.8771172301, 1549082.8540666529, 16326687.4052730831, 17472800.3822225058,'+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2280, 'NAD83 / Utah North (ft)', 'EPSG', 2280, 'PROJCS["NAD83 / Utah North (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640419.948,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3280839.895,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2280"]]', 906837.9047417803, 2351778.2714620959, 2913175.8789947880, 4358116.2457151036,'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2281, 'NAD83 / Utah Central (ft)', 'EPSG', 2281, 'PROJCS["NAD83 / Utah Central (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",38.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.65,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.0277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640419.948,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6561679.79,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2281"]]', 881809.0461935633, 2373275.2697651057, 6354594.0743449792, 7846060.2979165217,'+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2282, 'NAD83 / Utah South (ft)', 'EPSG', 2282, 'PROJCS["NAD83 / Utah South (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.35,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.2166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640419.948,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",9842519.685,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2282"]]', 866432.3728622786, 2388129.3146947981, 9498591.8270199684, 11020288.7688524878,'+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +datum=NAD83 +units=ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2283, 'NAD83 / Virginia North (ftUS)', 'EPSG', 2283, 'PROJCS["NAD83 / Virginia North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-78.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.2111111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.0333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",11482916.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6561666.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2283"]]', 11011453.8511636588, 12078659.5792080131, 6378399.0531860162, 7445604.7812303705,'+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2000000.0001016 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2284, 'NAD83 / Virginia South (ftUS)', 'EPSG', 2284, 'PROJCS["NAD83 / Virginia South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-78.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36.7666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",11482916.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3280833.333,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2284"]]', 9912651.2955856711, 12469112.0806377012, 2422943.1031810936, 4979403.8882331237,'+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=999999.9998983998 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2285, 'NAD83 / Washington North (ftUS)', 'EPSG', 2285, 'PROJCS["NAD83 / Washington North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",47,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.833333333333,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",48.7444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",47.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2285"]]', 616220.7871368168, 2628942.1882490924, -593888.6569181362, 1418832.7441941394,'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2286, 'NAD83 / Washington South (ftUS)', 'EPSG', 2286, 'PROJCS["NAD83 / Washington South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.3333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.8333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2286"]]', 603027.3244402962, 2598454.2759028664, -522532.4210010134, 1472894.5304615568,'+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0001016001 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2287, 'NAD83 / Wisconsin North (ftUS)', 'EPSG', 2287, 'PROJCS["NAD83 / Wisconsin North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",46.7666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.5666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2287"]]', 1200989.8518878329, 2494521.4336325097, -209273.7296164864, 1084257.8521281904,'+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2288, 'NAD83 / Wisconsin Central (ftUS)', 'EPSG', 2288, 'PROJCS["NAD83 / Wisconsin Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",45.5111111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.2611111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2288"]]', 1172925.2341094100, 2990277.6681687693, -505618.9856049127, 1311733.4484544466,'+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2289, 'NAD83 / Wisconsin South (ftUS)', 'EPSG', 2289, 'PROJCS["NAD83 / Wisconsin South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",42,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",44.0777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.7444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2289"]]', 1558559.8554930536, 2815324.9669639074, -107324.2174365646, 1149440.8940342891,'+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-ft +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2290, 'ATS77 / Prince Edward Isl. Stereographic (ATS77)', 'EPSG', 2290, 'PROJCS["ATS77 / Prince Edward Isl. Stereographic (ATS77)",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",47.2611111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999912,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",400000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2290"]]', 580350.0188032044, 789385.6661772370, 212394.4507643605, 421430.0981383930,'+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=700000 +y_0=400000 +a=6378135 +b=6356750.304921594 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2294, 'ATS77 / MTM Nova Scotia zone 4', 'EPSG', 2294, 'PROJCS["ATS77 / MTM Nova Scotia zone 4",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-61.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2294"]]', 4369477.1203060164, 4651942.3868484846, 4940104.7367198281, 5222570.0032622963,'+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=4500000 +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2295, 'ATS77 / MTM Nova Scotia zone 5', 'EPSG', 2295, 'PROJCS["ATS77 / MTM Nova Scotia zone 5",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-64.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",5500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2295"]]', 5337623.1141540025, 5639699.5500945618, 4803070.9785739615, 5105147.4145145208,'+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=5500000 +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (1, 2296, 'Ammassalik 1958 / Greenland zone 7 east', 'EPSG', 2296, 'PROJCS["Ammassalik 1958 / Greenland zone 7 east",GEOGCS["Ammassalik 1958",DATUM["Ammassalik 1958",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-45,417,-3.5,0,0,0.814,-0.6],AUTHORITY["EPSG","6196"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4196"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",64.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-40,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2296"]]', NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (1, 2299, 'Qornoq 1927 / Greenland zone 2 west', 'EPSG', 2299, 'PROJCS["Qornoq 1927 / Greenland zone 2 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",79.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-64,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2299"]]', NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (1, 2301, 'Qornoq 1927 / Greenland zone 3 west', 'EPSG', 2301, 'PROJCS["Qornoq 1927 / Greenland zone 3 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",76.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-64,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2301"]]', NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (1, 2303, 'Qornoq 1927 / Greenland zone 4 west', 'EPSG', 2303, 'PROJCS["Qornoq 1927 / Greenland zone 4 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",73.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-52,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2303"]]', NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (1, 2304, 'Qornoq 1927 / Greenland zone 5 west', 'EPSG', 2304, 'PROJCS["Qornoq 1927 / Greenland zone 5 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",70.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-52,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2304"]]', NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (1, 2305, 'Qornoq 1927 / Greenland zone 6 west', 'EPSG', 2305, 'PROJCS["Qornoq 1927 / Greenland zone 6 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",67.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-52,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2305"]]', NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (1, 2306, 'Qornoq 1927 / Greenland zone 7 west', 'EPSG', 2306, 'PROJCS["Qornoq 1927 / Greenland zone 7 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",64.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-52,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2306"]]', NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (1, 2307, 'Qornoq 1927 / Greenland zone 8 east', 'EPSG', 2307, 'PROJCS["Qornoq 1927 / Greenland zone 8 east",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",61.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-48,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2307"]]', NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2308, 'Batavia / TM 109 SE', 'EPSG', 2308, 'PROJCS["Batavia / TM 109 SE",GEOGCS["Batavia",DATUM["Batavia",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-377.7,675.1,-52.2,0,0,0,0],AUTHORITY["EPSG","6211"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4211"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",109,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2308"]]', 131740.0889992454, 621394.1924597418, 9148854.2058095410, 9638508.3092700374,'+proj=tmerc +lat_0=0 +lon_0=109 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2309, 'WGS 84 / TM 116 SE', 'EPSG', 2309, 'PROJCS["WGS 84 / TM 116 SE",GEOGCS["WGS 84",DATUM["World Geodetic System 1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4326"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",116,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2309"]]', 136920.7630007495, 620915.6086452618, 8913823.9708662103, 9397818.8165107225,'+proj=tmerc +lat_0=0 +lon_0=116 +k=0.9996 +x_0=500000 +y_0=10000000 +datum=WGS84 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2310, 'WGS 84 / TM 132 SE', 'EPSG', 2310, 'PROJCS["WGS 84 / TM 132 SE",GEOGCS["WGS 84",DATUM["World Geodetic System 1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4326"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2310"]]', 483473.5565996787, 706729.1070092416, 9616936.4825402359, 9840192.0329497987,'+proj=tmerc +lat_0=0 +lon_0=132 +k=0.9996 +x_0=500000 +y_0=10000000 +datum=WGS84 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2311, 'WGS 84 / TM 6 NE', 'EPSG', 2311, 'PROJCS["WGS 84 / TM 6 NE",GEOGCS["WGS 84",DATUM["World Geodetic System 1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4326"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",6,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2311"]]', 115363.9761536272, 789981.1508343365, 122106.0030860483, 796723.1777667575,'+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0=0 +datum=WGS84 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2312, 'Garoua / UTM zone 33N', 'EPSG', 2312, 'PROJCS["Garoua / UTM zone 33N",GEOGCS["Garoua",DATUM["Garoua",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],AUTHORITY["EPSG","6197"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4197"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2312"]]', 266233.9815259877, 414030.3102677620, 964941.6468721218, 1112737.9756138960,'+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2313, 'Kousseri / UTM zone 33N', 'EPSG', 2313, 'PROJCS["Kousseri / UTM zone 33N",GEOGCS["Kousseri",DATUM["Kousseri",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],AUTHORITY["EPSG","6198"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4198"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2313"]]', 398080.2354074043, 521271.5382393529, 1290896.6705290530, 1414087.9733610015,'+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2314, 'Trinidad 1903 / Trinidad Grid (ftCla)', 'EPSG', 2314, 'PROJCS["Trinidad 1903 / Trinidad Grid (ftCla)",GEOGCS["Trinidad 1903",DATUM["Trinidad 1903",SPHEROID["Clarke 1858",6378293.645208759,294.26067636926103,AUTHORITY["EPSG","7007"]],TOWGS84[-61.702,284.488,472.052,0,0,0,0],AUTHORITY["EPSG","6302"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4302"]],PROJECTION["Cassini-Soldner",AUTHORITY["EPSG","9806"]],PARAMETER["Latitude of natural origin",10.4416666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-61.3333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["False easting",283800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",214500,AUTHORITY["EPSG","8807"]],UNIT["Clarke\'s foot",0.3047972654,AUTHORITY["EPSG","9005"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2314"]]', -3834.1689076088, 778432.5547986915, -94405.4353045421, 687861.2884017582,'+proj=cass +lat_0=10.44166666666667 +lon_0=-61.33333333333334 +x_0=86501.46392052001 +y_0=65379.0134283 +a=6378293.645208759 +b=6356617.987679838 +towgs84=-61.702,284.488,472.052,0,0,0,0 +to_meter=0.3047972654 +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2315, 'Campo Inchauspe / UTM zone 19S', 'EPSG', 2315, 'PROJCS["Campo Inchauspe / UTM zone 19S",GEOGCS["Campo Inchauspe",DATUM["Campo Inchauspe",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-148,136,90,0,0,0,0],AUTHORITY["EPSG","6221"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4221"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2315"]]', 442784.6300874333, 789469.9642101662, 3937679.9603063829, 4284365.2944291158,'+proj=utm +zone=19 +south +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2316, 'Campo Inchauspe / UTM zone 20S', 'EPSG', 2316, 'PROJCS["Campo Inchauspe / UTM zone 20S",GEOGCS["Campo Inchauspe",DATUM["Campo Inchauspe",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-148,136,90,0,0,0,0],AUTHORITY["EPSG","6221"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4221"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2316"]]', 240114.4021683003, 656302.4156394715, 3900758.5466350205, 4316946.5601061918,'+proj=utm +zone=20 +south +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2317, 'PSAD56 / ICN Regional', 'EPSG', 2317, 'PROJCS["PSAD56 / ICN Regional",GEOGCS["PSAD56",DATUM["Provisional South American Datum 1956",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-60.31,245.935,31.008,12.324,3.755,-7.37,0.447],AUTHORITY["EPSG","6248"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4248"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",6,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-66,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",9,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",3,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2317"]]', 145963.1643136597, 1722689.5551679656, 266147.3488864188, 1842873.7397407248,'+proj=lcc +lat_1=9 +lat_2=3 +lat_0=6 +lon_0=-66 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2318, 'Ain el Abd / Aramco Lambert', 'EPSG', 2318, 'PROJCS["Ain el Abd / Aramco Lambert",GEOGCS["Ain el Abd",DATUM["Ain el Abd 1970",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-18.944,-379.364,-24.063,0.04,-0.764,6.431,3.657],AUTHORITY["EPSG","6204"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4204"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",25.08951,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",48,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",17,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",33,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",0,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2318"]]', -1494905.0916184374, 870590.3301917499, -1272385.1891534916, 1093110.2326566957,'+proj=lcc +lat_1=17 +lat_2=33 +lat_0=25.08951 +lon_0=48 +x_0=0 +y_0=0 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2319, 'ED50 / TM27', 'EPSG', 2319, 'PROJCS["ED50 / TM27",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2319"]]', 181443.9909020183, 829403.6692792070, 4029626.8755516950, 4677586.5539288838,'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2320, 'ED50 / TM30', 'EPSG', 2320, 'PROJCS["ED50 / TM30",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2320"]]', 188296.8420759957, 811785.8996031358, 3981427.1789860352, 4604916.2365131752,'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2321, 'ED50 / TM33', 'EPSG', 2321, 'PROJCS["ED50 / TM33",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2321"]]', 147864.2877913022, 852205.3250214789, 3969883.6856869336, 4674224.7229171104,'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2322, 'ED50 / TM36', 'EPSG', 2322, 'PROJCS["ED50 / TM36",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2322"]]', 134004.0916886921, 866052.2014635225, 3951594.7297296598, 4683642.8395044902,'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2323, 'ED50 / TM39', 'EPSG', 2323, 'PROJCS["ED50 / TM39",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2323"]]', 238495.7854005212, 761547.0337864767, 4049942.4702823463, 4572993.7186683018,'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2324, 'ED50 / TM42', 'EPSG', 2324, 'PROJCS["ED50 / TM42",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2324"]]', 235586.1471423136, 764443.0807338537, 4089785.2753591840, 4618642.2089507241,'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2325, 'ED50 / TM45', 'EPSG', 2325, 'PROJCS["ED50 / TM45",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2325"]]', 191714.2021516894, 660427.5611658369, 4084353.8939048168, 4553067.2529189643,'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2326, 'Hong Kong 1980 Grid System', 'EPSG', 2326, 'PROJCS["Hong Kong 1980 Grid System",GEOGCS["Hong Kong 1980",DATUM["Hong Kong 1980",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-162.619,-276.959,-161.764,0.067753,-2.243649,-1.158827,-1.094246],AUTHORITY["EPSG","6611"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4611"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",22.3121333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114.178555555556,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",836694.05,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",819069.8,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2326"]]', 791712.1745882405, 872183.5249107983, 783799.5884308523, 864270.9387534101,'+proj=tmerc +lat_0=22.31213333333334 +lon_0=114.1785555555556 +k=1 +x_0=836694.05 +y_0=819069.8 +ellps=intl +towgs84=-162.619,-276.959,-161.764,0.067753,-2.243649,-1.158827,-1.094246 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2327, 'Xian 1980 / Gauss-Kruger zone 13', 'EPSG', 2327, 'PROJCS["Xian 1980 / Gauss-Kruger zone 13",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",13500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2327"]]', 13246097.9771474539, 13901975.0910263495, 3909453.2498091338, 4565330.3636880294,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2328, 'Xian 1980 / Gauss-Kruger zone 14', 'EPSG', 2328, 'PROJCS["Xian 1980 / Gauss-Kruger zone 14",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",14500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2328"]]', 13455638.7486915044, 15542414.0604581558, 3190600.6292936848, 5277375.9410603363,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2329, 'Xian 1980 / Gauss-Kruger zone 15', 'EPSG', 2329, 'PROJCS["Xian 1980 / Gauss-Kruger zone 15",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",15500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2329"]]', 14237792.1245882176, 16762207.8754117843, 2978113.8798822760, 5502529.6307058428,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2330, 'Xian 1980 / Gauss-Kruger zone 16', 'EPSG', 2330, 'PROJCS["Xian 1980 / Gauss-Kruger zone 16",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",16500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2330"]]', 15334763.7418662666, 17666223.2734632321, 3025075.3526162713, 5356534.8842132368,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2331, 'Xian 1980 / Gauss-Kruger zone 17', 'EPSG', 2331, 'PROJCS["Xian 1980 / Gauss-Kruger zone 17",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",17500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2331"]]', 16228233.4228630797, 18772806.4439897737, 2291481.1550387021, 4836054.1761653961,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2332, 'Xian 1980 / Gauss-Kruger zone 18', 'EPSG', 2332, 'PROJCS["Xian 1980 / Gauss-Kruger zone 18",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",18500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2332"]]', 17291800.6532498066, 19708199.3467501934, 2338279.5822850327, 4754678.2757854195,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2333, 'Xian 1980 / Gauss-Kruger zone 19', 'EPSG', 2333, 'PROJCS["Xian 1980 / Gauss-Kruger zone 19",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",19500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2333"]]', 17942179.9221964456, 21057820.0778035544, 1945828.1682649569, 5061468.3238720656,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2334, 'Xian 1980 / Gauss-Kruger zone 20', 'EPSG', 2334, 'PROJCS["Xian 1980 / Gauss-Kruger zone 20",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",20500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2334"]]', 18803838.7721593965, 22196161.2278406035, 2387123.4338790665, 5779445.8895602736,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2335, 'Xian 1980 / Gauss-Kruger zone 21', 'EPSG', 2335, 'PROJCS["Xian 1980 / Gauss-Kruger zone 21",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",21500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2335"]]', 19927963.1551023036, 23072036.8448976927, 2857523.6359516588, 6001597.3257470479,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2336, 'Xian 1980 / Gauss-Kruger zone 22', 'EPSG', 2336, 'PROJCS["Xian 1980 / Gauss-Kruger zone 22",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",22500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2336"]]', 21812154.6146744600, 23187845.3853255438, 4506239.2395456669, 5881930.0101967507,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2337, 'Xian 1980 / Gauss-Kruger zone 23', 'EPSG', 2337, 'PROJCS["Xian 1980 / Gauss-Kruger zone 23",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",23500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2337"]]', 23175622.5563104634, 23570888.3376323733, 4979593.8178019288, 5374859.5991238386,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2338, 'Xian 1980 / Gauss-Kruger CM 75E', 'EPSG', 2338, 'PROJCS["Xian 1980 / Gauss-Kruger CM 75E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2338"]]', 246097.9771474535, 901975.0910263491, 3909453.2498091338, 4565330.3636880294,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2339, 'Xian 1980 / Gauss-Kruger CM 81E', 'EPSG', 2339, 'PROJCS["Xian 1980 / Gauss-Kruger CM 81E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2339"]]', -544361.2513084955, 1542414.0604581559, 3190600.6292936848, 5277375.9410603363,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2340, 'Xian 1980 / Gauss-Kruger CM 87E', 'EPSG', 2340, 'PROJCS["Xian 1980 / Gauss-Kruger CM 87E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2340"]]', -762207.8754117827, 1762207.8754117840, 2978113.8798822760, 5502529.6307058428,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2341, 'Xian 1980 / Gauss-Kruger CM 93E', 'EPSG', 2341, 'PROJCS["Xian 1980 / Gauss-Kruger CM 93E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2341"]]', -665236.2581337334, 1666223.2734632320, 3025075.3526162713, 5356534.8842132368,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2342, 'Xian 1980 / Gauss-Kruger CM 99E', 'EPSG', 2342, 'PROJCS["Xian 1980 / Gauss-Kruger CM 99E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2342"]]', -771766.5771369193, 1772806.4439897747, 2291481.1550387021, 4836054.1761653961,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2343, 'Xian 1980 / Gauss-Kruger CM 105E', 'EPSG', 2343, 'PROJCS["Xian 1980 / Gauss-Kruger CM 105E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2343"]]', -708199.3467501941, 1708199.3467501928, 2338279.5822850327, 4754678.2757854195,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2344, 'Xian 1980 / Gauss-Kruger CM 111E', 'EPSG', 2344, 'PROJCS["Xian 1980 / Gauss-Kruger CM 111E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2344"]]', -1057820.0778035544, 2057820.0778035544, 1945828.1682649569, 5061468.3238720656,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2345, 'Xian 1980 / Gauss-Kruger CM 117E', 'EPSG', 2345, 'PROJCS["Xian 1980 / Gauss-Kruger CM 117E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2345"]]', -1196161.2278406036, 2196161.2278406035, 2387123.4338790665, 5779445.8895602736,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2346, 'Xian 1980 / Gauss-Kruger CM 123E', 'EPSG', 2346, 'PROJCS["Xian 1980 / Gauss-Kruger CM 123E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2346"]]', -1072036.8448976959, 2072036.8448976932, 2857523.6359516588, 6001597.3257470479,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2347, 'Xian 1980 / Gauss-Kruger CM 129E', 'EPSG', 2347, 'PROJCS["Xian 1980 / Gauss-Kruger CM 129E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2347"]]', -187845.3853255408, 1187845.3853255429, 4506239.2395456669, 5881930.0101967507,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2348, 'Xian 1980 / Gauss-Kruger CM 135E', 'EPSG', 2348, 'PROJCS["Xian 1980 / Gauss-Kruger CM 135E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2348"]]', 175622.5563104624, 570888.3376323723, 4979593.8178019288, 5374859.5991238386,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2349, 'Xian 1980 / 3-degree Gauss-Kruger zone 25', 'EPSG', 2349, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 25",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",25500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2349"]]', 25225950.3038964614, 25784896.3277695283, 3954592.6375977316, 4513538.6614707985,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2350, 'Xian 1980 / 3-degree Gauss-Kruger zone 26', 'EPSG', 2350, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 26",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",26500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2350"]]', 25876740.3407336750, 27123259.6592663250, 3411297.0298515646, 4657816.3483842146,'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2351, 'Xian 1980 / 3-degree Gauss-Kruger zone 27', 'EPSG', 2351, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 27",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",27500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2351"]]', 26580945.7144227585, 28420019.8004252279, 3280152.0172248474, 5119226.1032273168,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2352, 'Xian 1980 / 3-degree Gauss-Kruger zone 28', 'EPSG', 2352, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 28",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",28500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2352"]]', 27405014.3262462852, 29594985.6737537111, 3086054.3964062362, 5276025.7439136621,'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2353, 'Xian 1980 / 3-degree Gauss-Kruger zone 29', 'EPSG', 2353, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 29",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",29500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2353"]]', 28265754.2734876583, 30734245.7265123417, 3029711.2201918111, 5498202.6732164944,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2354, 'Xian 1980 / 3-degree Gauss-Kruger zone 30', 'EPSG', 2354, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 30",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",30500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2354"]]', 29282035.2704086645, 31717964.7295913355, 2977148.8743647748, 5413078.3335474458,'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2355, 'Xian 1980 / 3-degree Gauss-Kruger zone 31', 'EPSG', 2355, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 31",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",31500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2355"]]', 30494693.3699783247, 32505306.6300216716, 3028541.2198271241, 5039154.4798704710,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2356, 'Xian 1980 / 3-degree Gauss-Kruger zone 32', 'EPSG', 2356, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 32",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",32500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2356"]]', 31561553.5697949914, 33439428.1414149987, 3088730.9199028963, 4966605.4915229037,'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2357, 'Xian 1980 / 3-degree Gauss-Kruger zone 33', 'EPSG', 2357, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 33",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",33500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2357"]]', 32269825.4125420042, 34730174.5874579958, 2324116.9935439142, 4784466.1684599057,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2358, 'Xian 1980 / 3-degree Gauss-Kruger zone 34', 'EPSG', 2358, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 34",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",34500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2358"]]', 33256592.2816430340, 35743407.7183569660, 2290383.3618468610, 4777198.7985607930,'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2359, 'Xian 1980 / 3-degree Gauss-Kruger zone 35', 'EPSG', 2359, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 35",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",35500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2359"]]', 34363221.4722095745, 36636778.5277904255, 2446219.5631228230, 4719776.6187036739,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2360, 'Xian 1980 / 3-degree Gauss-Kruger zone 36', 'EPSG', 2360, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 36",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",36500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2360"]]', 35100016.9308940184, 37899983.0691059816, 1958815.4530596834, 4758781.5912716467,'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2361, 'Xian 1980 / 3-degree Gauss-Kruger zone 37', 'EPSG', 2361, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 37",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",37500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2361"]]', 35942879.6360548458, 39057120.3639451542, 1943914.6756886420, 5058155.4035789504,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2362, 'Xian 1980 / 3-degree Gauss-Kruger zone 38', 'EPSG', 2362, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 38",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",38500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2362"]]', 37119580.0665513807, 39880419.9334486193, 2328305.9413582298, 5089145.8082554683,'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2363, 'Xian 1980 / 3-degree Gauss-Kruger zone 39', 'EPSG', 2363, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 39",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",39500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2363"]]', 37925667.1119535855, 41074332.8880464145, 2440467.0289126726, 5589132.8050055016,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2364, 'Xian 1980 / 3-degree Gauss-Kruger zone 40', 'EPSG', 2364, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 40",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",40500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2364"]]', 38831498.3791119342, 42168501.6208880658, 2639567.8598034762, 5976571.1015796077,'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2365, 'Xian 1980 / 3-degree Gauss-Kruger zone 41', 'EPSG', 2365, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 41",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",41500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2365"]]', 40036585.9716565900, 42963414.0283434100, 3067450.2946598537, 5994278.3513466737,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2366, 'Xian 1980 / 3-degree Gauss-Kruger zone 42', 'EPSG', 2366, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 42",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",42500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2366"]]', 41747963.3654876836, 43252036.6345123164, 4422782.7168385056, 5926855.9858631384,'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2367, 'Xian 1980 / 3-degree Gauss-Kruger zone 43', 'EPSG', 2367, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 43",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",43500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2367"]]', 42986769.4857245978, 44013230.5142754097, 4563012.9158904059, 5589473.9444412179,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2368, 'Xian 1980 / 3-degree Gauss-Kruger zone 44', 'EPSG', 2368, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 44",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",44500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2368"]]', 44126646.0595950267, 44873353.9404049658, 4685022.0494492475, 5431729.9302591866,'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2369, 'Xian 1980 / 3-degree Gauss-Kruger zone 45', 'EPSG', 2369, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 45",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",45500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2369"]]', 45285262.6732225728, 45581198.3815628651, 5073750.4757479222, 5369686.1840882146,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2370, 'Xian 1980 / 3-degree Gauss-Kruger CM 75E', 'EPSG', 2370, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 75E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2370"]]', 225950.3038964618, 784896.3277695286, 3954592.6375977316, 4513538.6614707985,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2371, 'Xian 1980 / 3-degree Gauss-Kruger CM 78E', 'EPSG', 2371, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 78E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2371"]]', -123259.6592663244, 1123259.6592663256, 3411297.0298515646, 4657816.3483842146,'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2372, 'Xian 1980 / 3-degree Gauss-Kruger CM 81E', 'EPSG', 2372, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 81E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2372"]]', -419054.2855772407, 1420019.8004252288, 3280152.0172248474, 5119226.1032273168,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2373, 'Xian 1980 / 3-degree Gauss-Kruger CM 84E', 'EPSG', 2373, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 84E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2373"]]', -594985.6737537136, 1594985.6737537124, 3086054.3964062362, 5276025.7439136621,'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2374, 'Xian 1980 / 3-degree Gauss-Kruger CM 87E', 'EPSG', 2374, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 87E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2374"]]', -734245.7265123410, 1734245.7265123423, 3029711.2201918111, 5498202.6732164944,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2375, 'Xian 1980 / 3-degree Gauss-Kruger CM 90E', 'EPSG', 2375, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 90E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2375"]]', -717964.7295913355, 1717964.7295913355, 2977148.8743647748, 5413078.3335474458,'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2376, 'Xian 1980 / 3-degree Gauss-Kruger CM 93E', 'EPSG', 2376, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 93E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2376"]]', -505306.6300216741, 1505306.6300216728, 3028541.2198271241, 5039154.4798704710,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2377, 'Xian 1980 / 3-degree Gauss-Kruger CM 96E', 'EPSG', 2377, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 96E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2377"]]', -438446.4302050095, 1439428.1414149978, 3088730.9199028963, 4966605.4915229037,'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2378, 'Xian 1980 / 3-degree Gauss-Kruger CM 99E', 'EPSG', 2378, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 99E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2378"]]', -730174.5874579951, 1730174.5874579964, 2324116.9935439142, 4784466.1684599057,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2379, 'Xian 1980 / 3-degree Gauss-Kruger CM 102E', 'EPSG', 2379, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 102E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2379"]]', -743407.7183569660, 1743407.7183569660, 2290383.3618468610, 4777198.7985607930,'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2380, 'Xian 1980 / 3-degree Gauss-Kruger CM 105E', 'EPSG', 2380, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 105E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2380"]]', -636778.5277904261, 1636778.5277904248, 2446219.5631228230, 4719776.6187036739,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2381, 'Xian 1980 / 3-degree Gauss-Kruger CM 108E', 'EPSG', 2381, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 108E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2381"]]', -899983.0691059810, 1899983.0691059823, 1958815.4530596834, 4758781.5912716467,'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2382, 'Xian 1980 / 3-degree Gauss-Kruger CM 111E', 'EPSG', 2382, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 111E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2382"]]', -1057120.3639451542, 2057120.3639451542, 1943914.6756886420, 5058155.4035789504,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2383, 'Xian 1980 / 3-degree Gauss-Kruger CM 114E', 'EPSG', 2383, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 114E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2383"]]', -880419.9334486206, 1880419.9334486180, 2328305.9413582298, 5089145.8082554683,'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2384, 'Xian 1980 / 3-degree Gauss-Kruger CM 117E', 'EPSG', 2384, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 117E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2384"]]', -1074332.8880464145, 2074332.8880464145, 2440467.0289126726, 5589132.8050055016,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2385, 'Xian 1980 / 3-degree Gauss-Kruger CM 120E', 'EPSG', 2385, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 120E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2385"]]', -1168501.6208880645, 2168501.6208880671, 2639567.8598034762, 5976571.1015796077,'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2386, 'Xian 1980 / 3-degree Gauss-Kruger CM 123E', 'EPSG', 2386, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 123E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2386"]]', -963414.0283434113, 1963414.0283434088, 3067450.2946598537, 5994278.3513466737,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2387, 'Xian 1980 / 3-degree Gauss-Kruger CM 126E', 'EPSG', 2387, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 126E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2387"]]', -252036.6345123164, 1252036.6345123164, 4422782.7168385056, 5926855.9858631384,'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2388, 'Xian 1980 / 3-degree Gauss-Kruger CM 129E', 'EPSG', 2388, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 129E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2388"]]', -13230.5142754049, 1013230.5142754071, 4563012.9158904059, 5589473.9444412179,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2389, 'Xian 1980 / 3-degree Gauss-Kruger CM 132E', 'EPSG', 2389, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 132E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2389"]]', 126646.0595950294, 873353.9404049685, 4685022.0494492475, 5431729.9302591866,'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2390, 'Xian 1980 / 3-degree Gauss-Kruger CM 135E', 'EPSG', 2390, 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 135E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2390"]]', 285262.6732225736, 581198.3815628659, 5073750.4757479222, 5369686.1840882146,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2391, 'KKJ / Finland zone 1', 'EPSG', 2391, 'PROJCS["KKJ / Finland zone 1",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma (1966)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2391"]]', 945514.8087082366, 2054858.2996728828, 6607103.0759570749, 7716446.5669217211,'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=1500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2392, 'KKJ / Finland zone 2', 'EPSG', 2392, 'PROJCS["KKJ / Finland zone 2",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma (1966)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2392"]]', 1969863.6469694170, 3030492.6233070755, 6606916.8552541522, 7667545.8315918107,'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2393, 'KKJ / Finland Uniform Coordinate System', 'EPSG', 2393, 'PROJCS["KKJ / Finland Uniform Coordinate System",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma (1966)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2393"]]', 2806743.0038378867, 4015900.1737736236, 6612028.8112762197, 7821185.9812119567,'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=3500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2394, 'KKJ / Finland zone 4', 'EPSG', 2394, 'PROJCS["KKJ / Finland zone 4",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma (1966)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2394"]]', 3986006.2274821334, 5014315.0777416994, 6740086.1542180380, 7768395.0044776039,'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=4500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2395, 'South Yemen / Gauss-Kruger zone 8', 'EPSG', 2395, 'PROJCS["South Yemen / Gauss-Kruger zone 8",GEOGCS["South Yemen",DATUM["South Yemen",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY["EPSG","6164"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4164"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",8500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2395"]]', 8291596.9095764414, 8857497.3898931730, 1376411.6118421837, 1942312.0921589152,'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2396, 'South Yemen / Gauss-Kruger zone 9', 'EPSG', 2396, 'PROJCS["South Yemen / Gauss-Kruger zone 9",GEOGCS["South Yemen",DATUM["South Yemen",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY["EPSG","6164"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4164"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",9500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2396"]]', 9161480.5928751574, 9745558.0373352870, 1531439.8330169158, 2115517.2774770455,'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2397, 'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3', 'EPSG', 2397, 'PROJCS["Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo 1942(83)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24,-123,-94,0.02,-0.25,-0.13,1.1],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2397"]]', 3515065.8620275924, 3655748.8223312991, 5577629.1818918052, 5718312.1421955119,'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2398, 'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4', 'EPSG', 2398, 'PROJCS["Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo 1942(83)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24,-123,-94,0.02,-0.25,-0.13,1.1],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2398"]]', 4166314.4642459074, 4833939.5875693370, 5414682.4196705687, 6082307.5429939983,'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2399, 'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5', 'EPSG', 2399, 'PROJCS["Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo 1942(83)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24,-123,-94,0.02,-0.25,-0.13,1.1],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",5500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2399"]]', 5026981.6118334032, 5973271.6364191944, 5139145.0228912591, 6085435.0474770504,'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2401, 'Beijing 1954 / 3-degree Gauss-Kruger zone 25', 'EPSG', 2401, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 25",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",25500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2401"]]', 25226008.0594522418, 25784948.9161726659, 3954640.4535769565, 4513581.3102973806,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2402, 'Beijing 1954 / 3-degree Gauss-Kruger zone 26', 'EPSG', 2402, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 26",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",26500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2402"]]', 25876793.9293008590, 27123301.1825140124, 3411348.6388548777, 4657855.8920680311,'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2403, 'Beijing 1954 / 3-degree Gauss-Kruger zone 27', 'EPSG', 2403, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 27",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",27500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2403"]]', 26580994.4852243244, 28420050.5369649426, 3280203.7938249629, 5119259.8455655811,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2404, 'Beijing 1954 / 3-degree Gauss-Kruger zone 28', 'EPSG', 2404, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 28",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",28500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2404"]]', 27405057.1461992091, 29595006.5585308099, 3086107.2914315946, 5276056.7037631954,'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2405, 'Beijing 1954 / 3-degree Gauss-Kruger zone 29', 'EPSG', 2405, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 29",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",29500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2405"]]', 28265790.5929175379, 30734257.1246975114, 3029764.0313022648, 5498230.5630822383,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2406, 'Beijing 1954 / 3-degree Gauss-Kruger zone 30', 'EPSG', 2406, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 30",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",30500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2406"]]', 29282063.5964196313, 31717968.0032980304, 2977201.7847057721, 5413106.1915841712,'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2407, 'Beijing 1954 / 3-degree Gauss-Kruger zone 31', 'EPSG', 2407, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 31",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",31500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2407"]]', 30494711.6571316017, 32505303.7380789438, 3028593.2971200833, 5039185.3780674253,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2408, 'Beijing 1954 / 3-degree Gauss-Kruger zone 32', 'EPSG', 2408, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 32",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",32500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2408"]]', 31561563.0685372952, 33439417.7803979923, 3088782.2469715044, 4966636.9588322015,'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2409, 'Beijing 1954 / 3-degree Gauss-Kruger zone 33', 'EPSG', 2409, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 33",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",33500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2409"]]', 32269830.0757278145, 34730152.8284079007, 2324176.8246382788, 4784499.5773183651,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2410, 'Beijing 1954 / 3-degree Gauss-Kruger zone 34', 'EPSG', 2410, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 34",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",34500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2410"]]', 33256588.8845568821, 35743377.8220591768, 2290443.7934231766, 4777232.7309254712,'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2411, 'Beijing 1954 / 3-degree Gauss-Kruger zone 35', 'EPSG', 2411, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 35",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",35500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2411"]]', 34363208.7322685011, 36636741.8680835701, 2446278.7217553834, 4719811.8575704523,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2412, 'Beijing 1954 / 3-degree Gauss-Kruger zone 36', 'EPSG', 2412, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 36",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",36500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2412"]]', 35099998.6879765727, 37899935.9414688311, 1958880.2127202348, 4758817.4662124932,'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2413, 'Beijing 1954 / 3-degree Gauss-Kruger zone 37', 'EPSG', 2413, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 37",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",37500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2413"]]', 35942854.5889512095, 39057064.2487733718, 1943980.1642604620, 5058189.8240826243,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2414, 'Beijing 1954 / 3-degree Gauss-Kruger zone 38', 'EPSG', 2414, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 38",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",38500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2414"]]', 37119545.0272061493, 39880358.2412816320, 2328368.4186939482, 5089181.6327694309,'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2415, 'Beijing 1954 / 3-degree Gauss-Kruger zone 39', 'EPSG', 2415, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 39",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",39500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2415"]]', 37925625.4259468416, 41074262.5384024804, 2440529.4227939498, 5589166.5352495887,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2416, 'Beijing 1954 / 3-degree Gauss-Kruger zone 40', 'EPSG', 2416, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 40",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",40500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2416"]]', 38831449.0567115300, 42168423.9105738274, 2639629.6224381499, 5976604.4763004473,'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2417, 'Beijing 1954 / 3-degree Gauss-Kruger zone 41', 'EPSG', 2417, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 41",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",41500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2417"]]', 40036526.8182757672, 42963331.5001361419, 3067509.7962649631, 5994314.4781253377,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2418, 'Beijing 1954 / 3-degree Gauss-Kruger zone 42', 'EPSG', 2418, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 42",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",42500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2418"]]', 41747890.7278789936, 43251953.3299840407, 4422833.1377548885, 5926895.7398599356,'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2419, 'Beijing 1954 / 3-degree Gauss-Kruger zone 43', 'EPSG', 2419, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 43",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",43500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2419"]]', 42986688.0664244105, 44013142.1582616310, 4563065.0710577985, 5589519.1628950190,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2420, 'Beijing 1954 / 3-degree Gauss-Kruger zone 44', 'EPSG', 2420, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 44",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",44500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2420"]]', 44126556.8323569152, 44873260.0244742033, 4685076.4462461666, 5431779.6383634546,'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2421, 'Beijing 1954 / 3-degree Gauss-Kruger zone 45', 'EPSG', 2421, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 45",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",45500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2421"]]', 45285165.8808845886, 45581099.9237017325, 5073805.9395858500, 5369739.9824029939,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2422, 'Beijing 1954 / 3-degree Gauss-Kruger CM 75E', 'EPSG', 2422, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 75E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2422"]]', 226008.0594522411, 784948.9161726653, 3954640.4535769565, 4513581.3102973806,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2423, 'Beijing 1954 / 3-degree Gauss-Kruger CM 78E', 'EPSG', 2423, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 78E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2423"]]', -123206.0706991415, 1123301.1825140118, 3411348.6388548777, 4657855.8920680311,'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2424, 'Beijing 1954 / 3-degree Gauss-Kruger CM 81E', 'EPSG', 2424, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 81E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2424"]]', -419005.5147756764, 1420050.5369649419, 3280203.7938249629, 5119259.8455655811,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2425, 'Beijing 1954 / 3-degree Gauss-Kruger CM 84E', 'EPSG', 2425, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 84E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2425"]]', -594942.8538007917, 1595006.5585308092, 3086107.2914315946, 5276056.7037631954,'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2426, 'Beijing 1954 / 3-degree Gauss-Kruger CM 87E', 'EPSG', 2426, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 87E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2426"]]', -734209.4070824622, 1734257.1246975113, 3029764.0313022648, 5498230.5630822383,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2427, 'Beijing 1954 / 3-degree Gauss-Kruger CM 90E', 'EPSG', 2427, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 90E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2427"]]', -717936.4035803670, 1717968.0032980320, 2977201.7847057721, 5413106.1915841712,'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2428, 'Beijing 1954 / 3-degree Gauss-Kruger CM 93E', 'EPSG', 2428, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 93E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2428"]]', -505288.3428683981, 1505303.7380789439, 3028593.2971200833, 5039185.3780674253,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2429, 'Beijing 1954 / 3-degree Gauss-Kruger CM 96E', 'EPSG', 2429, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 96E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2429"]]', -438436.9314627048, 1439417.7803979923, 3088782.2469715044, 4966636.9588322015,'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2430, 'Beijing 1954 / 3-degree Gauss-Kruger CM 99E', 'EPSG', 2430, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 99E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2430"]]', -730169.9242721861, 1730152.8284079002, 2324176.8246382788, 4784499.5773183651,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2431, 'Beijing 1954 / 3-degree Gauss-Kruger CM 102E', 'EPSG', 2431, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 102E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2431"]]', -743411.1154431187, 1743377.8220591759, 2290443.7934231766, 4777232.7309254712,'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2432, 'Beijing 1954 / 3-degree Gauss-Kruger CM 105E', 'EPSG', 2432, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 105E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2432"]]', -636791.2677314996, 1636741.8680835694, 2446278.7217553834, 4719811.8575704523,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2433, 'Beijing 1954 / 3-degree Gauss-Kruger CM 108E', 'EPSG', 2433, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 108E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2433"]]', -900001.3120234291, 1899935.9414688293, 1958880.2127202348, 4758817.4662124932,'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2434, 'Beijing 1954 / 3-degree Gauss-Kruger CM 111E', 'EPSG', 2434, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 111E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2434"]]', -1057145.4110487923, 2057064.2487733699, 1943980.1642604620, 5058189.8240826243,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2435, 'Beijing 1954 / 3-degree Gauss-Kruger CM 114E', 'EPSG', 2435, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 114E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2435"]]', -880454.9727938484, 1880358.2412816343, 2328368.4186939482, 5089181.6327694309,'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2436, 'Beijing 1954 / 3-degree Gauss-Kruger CM 117E', 'EPSG', 2436, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 117E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2436"]]', -1074374.5740531562, 2074262.5384024827, 2440529.4227939498, 5589166.5352495887,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2437, 'Beijing 1954 / 3-degree Gauss-Kruger CM 120E', 'EPSG', 2437, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 120E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2437"]]', -1168550.9432884700, 2168423.9105738274, 2639629.6224381499, 5976604.4763004473,'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2438, 'Beijing 1954 / 3-degree Gauss-Kruger CM 123E', 'EPSG', 2438, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 123E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2438"]]', -963473.1817242340, 1963331.5001361406, 3067509.7962649631, 5994314.4781253377,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2439, 'Beijing 1954 / 3-degree Gauss-Kruger CM 126E', 'EPSG', 2439, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 126E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2439"]]', -252109.2721210064, 1251953.3299840408, 4422833.1377548885, 5926895.7398599356,'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2440, 'Beijing 1954 / 3-degree Gauss-Kruger CM 129E', 'EPSG', 2440, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 129E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2440"]]', -13311.9335755908, 1013142.1582616296, 4563065.0710577985, 5589519.1628950190,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2441, 'Beijing 1954 / 3-degree Gauss-Kruger CM 132E', 'EPSG', 2441, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 132E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2441"]]', 126556.8323569131, 873260.0244742012, 4685076.4462461666, 5431779.6383634546,'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2442, 'Beijing 1954 / 3-degree Gauss-Kruger CM 135E', 'EPSG', 2442, 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 135E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2442"]]', 285165.8808845894, 581099.9237017332, 5073805.9395858500, 5369739.9824029939,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2443, 'JGD2000 / Japan Plane Rectangular CS I', 'EPSG', 2443, 'PROJCS["JGD2000 / Japan Plane Rectangular CS I",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",33,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2443"]]', -467081.2205988898, 430343.2111835823, -686379.0562554617, 211045.3755270103,'+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2444, 'JGD2000 / Japan Plane Rectangular CS II', 'EPSG', 2444, 'PROJCS["JGD2000 / Japan Plane Rectangular CS II",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",33,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",131,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2444"]]', -228938.0780196763, 210638.8644033779, -320637.2353484136, 118939.7070746406,'+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2445, 'JGD2000 / Japan Plane Rectangular CS III', 'EPSG', 2445, 'PROJCS["JGD2000 / Japan Plane Rectangular CS III",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2445"]]', -155019.4342720699, 151929.8563686780, -258030.0085318216, 48919.2821089262,'+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2446, 'JGD2000 / Japan Plane Rectangular CS IV', 'EPSG', 2446, 'PROJCS["JGD2000 / Japan Plane Rectangular CS IV",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",33,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",133.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2446"]]', -150713.6653059171, 128206.0886364094, -75316.5507449827, 203603.2031973438,'+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2447, 'JGD2000 / Japan Plane Rectangular CS V', 'EPSG', 2447, 'PROJCS["JGD2000 / Japan Plane Rectangular CS V",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",134.344444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2447"]]', -115308.6940413185, 109159.2424734179, -231415.7433267184, -6947.8068119821,'+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2448, 'JGD2000 / Japan Plane Rectangular CS VI', 'EPSG', 2448, 'PROJCS["JGD2000 / Japan Plane Rectangular CS VI",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",136,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2448"]]', -176071.4392895480, 162117.4888678688, -294468.2116353887, 43720.7165220281,'+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2449, 'JGD2000 / Japan Plane Rectangular CS VII', 'EPSG', 2449, 'PROJCS["JGD2000 / Japan Plane Rectangular CS VII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",137.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2449"]]', -189779.9076790606, 164681.5729779215, -171902.6678897571, 182558.8127672251,'+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2450, 'JGD2000 / Japan Plane Rectangular CS VIII', 'EPSG', 2450, 'PROJCS["JGD2000 / Japan Plane Rectangular CS VIII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",138.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2450"]]', -222706.4404677202, 243819.3775958932, -170303.5275223758, 296222.2905412376,'+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2451, 'JGD2000 / Japan Plane Rectangular CS IX', 'EPSG', 2451, 'PROJCS["JGD2000 / Japan Plane Rectangular CS IX",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",139.833333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2451"]]', -507769.9107963820, 492549.5397150898, -760399.7366012278, 239919.7139102441,'+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2452, 'JGD2000 / Japan Plane Rectangular CS X', 'EPSG', 2452, 'PROJCS["JGD2000 / Japan Plane Rectangular CS X",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",140.833333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2452"]]', -223907.3565833657, 220675.1653306369, -259720.0584113966, 184862.4635026060,'+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2453, 'JGD2000 / Japan Plane Rectangular CS XI', 'EPSG', 2453, 'PROJCS["JGD2000 / Japan Plane Rectangular CS XI",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",44,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",140.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2453"]]', -107740.6874098845, 132849.1418584731, -299687.2973386001, -59097.4680702425,'+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2454, 'JGD2000 / Japan Plane Rectangular CS XII', 'EPSG', 2454, 'PROJCS["JGD2000 / Japan Plane Rectangular CS XII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",44,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",142.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2454"]]', -195846.0830443690, 195846.0830443690, -212140.9588791955, 179551.2072095425,'+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2455, 'JGD2000 / Japan Plane Rectangular CS XIII', 'EPSG', 2455, 'PROJCS["JGD2000 / Japan Plane Rectangular CS XIII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",44,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",144.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2455"]]', -146993.0062527556, 145332.7141741446, -240953.7434782146, 51371.9769486857,'+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2456, 'JGD2000 / Japan Plane Rectangular CS XIV', 'EPSG', 2456, 'PROJCS["JGD2000 / Japan Plane Rectangular CS XIV",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",26,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",142,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2456"]]', -204203.9203352763, 156634.5886576435, -154218.9707947213, 206619.5381981985,'+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2457, 'JGD2000 / Japan Plane Rectangular CS XV', 'EPSG', 2457, 'PROJCS["JGD2000 / Japan Plane Rectangular CS XV",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",26,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",127.511111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2457"]]', -90624.3215614553, 93627.2658654803, -40307.4179138893, 143944.1695130463,'+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2458, 'JGD2000 / Japan Plane Rectangular CS XVI', 'EPSG', 2458, 'PROJCS["JGD2000 / Japan Plane Rectangular CS XVI",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",26,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",124,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2458"]]', -124516.1847128898, 159120.0878662539, -311724.1830025762, -28087.9104234325,'+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2459, 'JGD2000 / Japan Plane Rectangular CS XVII', 'EPSG', 2459, 'PROJCS["JGD2000 / Japan Plane Rectangular CS XVII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",26,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",131,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2459"]]', -67481.6803979435, 118035.1495000928, -180786.1129001267, 4730.7169979095,'+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2460, 'JGD2000 / Japan Plane Rectangular CS XVIII', 'EPSG', 2460, 'PROJCS["JGD2000 / Japan Plane Rectangular CS XVIII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",20,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",136,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2460"]]', 1793.9940734289, 16994.7327768698, 39449.5414045088, 54650.2801079497,'+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2461, 'JGD2000 / Japan Plane Rectangular CS XIX', 'EPSG', 2461, 'PROJCS["JGD2000 / Japan Plane Rectangular CS XIX",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",26,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",154,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2461"]]', -9519.2102393588, 5456.4924872152, -197446.1275712418, -182470.4248446678,'+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2462, 'Albanian 1987 / Gauss-Kruger zone 4', 'EPSG', 2462, 'PROJCS["Albanian 1987 / Gauss-Kruger zone 4",GEOGCS["Albanian 1987",DATUM["Albanian 1987",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-44.183,-0.58,-38.489,2.3867,2.7072,-3.5196,-8.2703],AUTHORITY["EPSG","6191"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4191"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2462"]]', 4250524.7216338493, 4602086.4248113114, 4382928.3624241991, 4734490.0656016612,'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=-44.183,-0.58,-38.489,2.3867,2.7072,-3.5196,-8.2703 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2463, 'Pulkovo 1995 / Gauss-Kruger CM 21E', 'EPSG', 2463, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 21E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2463"]]', 402784.0028895977, 626101.1536547519, 5966935.6861965002, 6190252.8369616543,'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2464, 'Pulkovo 1995 / Gauss-Kruger CM 27E', 'EPSG', 2464, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 27E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2464"]]', -217900.4545680495, 1382266.8096992466, 6143464.9892755725, 7743632.2535428687,'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2465, 'Pulkovo 1995 / Gauss-Kruger CM 33E', 'EPSG', 2465, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 33E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2465"]]', -639231.2250699148, 1639472.2876291996, 5539258.8638259259, 7817962.3765250404,'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2466, 'Pulkovo 1995 / Gauss-Kruger CM 39E', 'EPSG', 2466, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 39E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2466"]]', -1006919.2993865314, 2007960.7667146828, 4729208.1467501934, 7744088.2128514076,'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2467, 'Pulkovo 1995 / Gauss-Kruger CM 45E', 'EPSG', 2467, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 45E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2467"]]', -1799389.8193032805, 2799603.4719795699, 4477662.9665519771, 9076656.2578348276,'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2468, 'Pulkovo 1995 / Gauss-Kruger CM 51E', 'EPSG', 2468, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 51E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2468"]]', -1816259.8931803299, 2816456.6288643153, 4499222.9894477546, 9131939.5114923997,'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2469, 'Pulkovo 1995 / Gauss-Kruger CM 57E', 'EPSG', 2469, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 57E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2469"]]', -1321062.0545053537, 2321240.5483575507, 5527457.6462916930, 9169760.2491545973,'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2470, 'Pulkovo 1995 / Gauss-Kruger CM 63E', 'EPSG', 2470, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 63E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2470"]]', -1301965.0417295492, 2302122.3874085061, 5549315.4893558602, 9153402.9184939155,'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2471, 'Pulkovo 1995 / Gauss-Kruger CM 69E', 'EPSG', 2471, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 69E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2471"]]', -830460.1917861990, 1830594.9716562039, 5950093.8726167210, 8611149.0360591238,'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2472, 'Pulkovo 1995 / Gauss-Kruger CM 75E', 'EPSG', 2472, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 75E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2472"]]', -1037351.2320490340, 2037461.4297496023, 5838666.8227664833, 8913479.4845651197,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2473, 'Pulkovo 1995 / Gauss-Kruger CM 81E', 'EPSG', 2473, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 81E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2473"]]', -1257350.5482736421, 2257434.7345340540, 5554353.7486071067, 9069139.0314148029,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2474, 'Pulkovo 1995 / Gauss-Kruger CM 87E', 'EPSG', 2474, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 87E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2474"]]', -1364956.6090489135, 2365013.9058993402, 5370067.9534980305, 9100038.4684462842,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2475, 'Pulkovo 1995 / Gauss-Kruger CM 93E', 'EPSG', 2475, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 93E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2475"]]', -1322195.8706331257, 2322225.8541424282, 5462890.8283015717, 9107312.5530771256,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2476, 'Pulkovo 1995 / Gauss-Kruger CM 99E', 'EPSG', 2476, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 99E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2476"]]', -1329721.6762012766, 2329723.8562877581, 5444809.1646942588, 9104254.6971832935,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2477, 'Pulkovo 1995 / Gauss-Kruger CM 105E', 'EPSG', 2477, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 105E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2477"]]', -1228239.1616402693, 2228213.4649158518, 5438705.3559189917, 8895157.9824751128,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2478, 'Pulkovo 1995 / Gauss-Kruger CM 111E', 'EPSG', 2478, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 111E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2478"]]', -1102348.3604064523, 2102294.9675739929, 5387952.4972571784, 8592595.8252376237,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2479, 'Pulkovo 1995 / Gauss-Kruger CM 117E', 'EPSG', 2479, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 117E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2479"]]', -1031687.8542971247, 2031607.3853414278, 5431814.4228614613, 8495109.6625000138,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2480, 'Pulkovo 1995 / Gauss-Kruger CM 123E', 'EPSG', 2480, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 123E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2480"]]', -802417.6207522987, 1802311.0773952135, 5663054.9805613997, 8267783.6787089120,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2481, 'Pulkovo 1995 / Gauss-Kruger CM 129E', 'EPSG', 2481, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 129E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2481"]]', -1315071.7047649668, 2314939.0339845953, 4614019.6244335001, 8244030.3631830622,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2482, 'Pulkovo 1995 / Gauss-Kruger CM 135E', 'EPSG', 2482, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 135E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2482"]]', -1440381.5809638934, 2440225.1555016599, 4651421.5226064210, 8532028.2590719743,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2483, 'Pulkovo 1995 / Gauss-Kruger CM 141E', 'EPSG', 2483, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 141E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2483"]]', -1261868.3276271636, 2261690.0748866762, 5014991.0869016208, 8538549.4894154605,'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2484, 'Pulkovo 1995 / Gauss-Kruger CM 147E', 'EPSG', 2484, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 147E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2484"]]', -1423209.4175748488, 2423010.6929944534, 4759866.8410119818, 8606086.9515812841,'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2485, 'Pulkovo 1995 / Gauss-Kruger CM 153E', 'EPSG', 2485, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 153E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2485"]]', -1265356.0216415311, 2265139.3743703677, 5007092.1387761279, 8537587.5347880268,'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2486, 'Pulkovo 1995 / Gauss-Kruger CM 159E', 'EPSG', 2486, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 159E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2486"]]', -1059716.4145892291, 2059484.4122292509, 5515296.3340879353, 8634497.1609064154,'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2487, 'Pulkovo 1995 / Gauss-Kruger CM 165E', 'EPSG', 2487, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 165E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2487"]]', -401162.3257706649, 1400917.4511659380, 6007824.8685330199, 7809904.6454696227,'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2488, 'Pulkovo 1995 / Gauss-Kruger CM 171E', 'EPSG', 2488, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 171E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2488"]]', -411597.9936650554, 1411342.4087702092, 6005208.8971360740, 7828149.2995713386,'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2489, 'Pulkovo 1995 / Gauss-Kruger CM 177E', 'EPSG', 2489, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 177E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2489"]]', -75990.8665672826, 1075728.1807475836, 6819569.2843636736, 7971288.3316785399,'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2490, 'Pulkovo 1995 / Gauss-Kruger CM 177W', 'EPSG', 2490, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 177W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2490"]]', 76895.3471691672, 922837.1822496423, 7126166.7522787212, 7972108.5873591963,'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2491, 'Pulkovo 1995 / Gauss-Kruger CM 171W', 'EPSG', 2491, 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 171W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2491"]]', 302719.6305212867, 649914.7009140610, 7117200.1261259737, 7464395.1965187480,'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2494, 'Pulkovo 1942 / Gauss-Kruger CM 21E', 'EPSG', 2494, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 21E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2494"]]', -107708.4908988379, 1225227.3440334388, 5288359.0977679614, 6621294.9327002380,'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2495, 'Pulkovo 1942 / Gauss-Kruger CM 27E', 'EPSG', 2495, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 27E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2495"]]', -905268.9686348384, 1906299.5651868283, 4955383.2366820019, 7766951.7705036687,'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2496, 'Pulkovo 1942 / Gauss-Kruger CM 33E', 'EPSG', 2496, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 33E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2496"]]', -987225.8294678848, 1987460.7075016157, 4856663.6014990738, 7831350.1384685742,'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2497, 'Pulkovo 1942 / Gauss-Kruger CM 39E', 'EPSG', 2497, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 39E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2497"]]', -1108414.9937643559, 2108635.5715232602, 4530908.3289924041, 7747958.8942800201,'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2498, 'Pulkovo 1942 / Gauss-Kruger CM 45E', 'EPSG', 2498, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 45E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2498"]]', -1934680.6675702829, 2935752.7492283227, 4211451.6182707315, 9081885.0350693371,'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2499, 'Pulkovo 1942 / Gauss-Kruger CM 51E', 'EPSG', 2499, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 51E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2499"]]', -2050141.2595665430, 3050326.0280203953, 4040465.9780614475, 9140933.2656483859,'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2500, 'Pulkovo 1942 / Gauss-Kruger CM 57E', 'EPSG', 2500, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 57E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2500"]]', -2096467.6131774553, 3096631.9752839573, 4006480.7120453135, 9199580.3005067262,'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2501, 'Pulkovo 1942 / Gauss-Kruger CM 63E', 'EPSG', 2501, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 63E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2501"]]', -2198610.9637338708, 3198751.3831519016, 3790522.1990626755, 9187884.5459484478,'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2502, 'Pulkovo 1942 / Gauss-Kruger CM 69E', 'EPSG', 2502, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 69E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2502"]]', -1837768.1447859954, 2837885.3423396005, 3974232.1763927457, 8649885.6635183417,'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2503, 'Pulkovo 1942 / Gauss-Kruger CM 75E', 'EPSG', 2503, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 75E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2503"]]', -1983930.0331124946, 2984021.1665589967, 3981927.6785447103, 8949878.8782162016,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2504, 'Pulkovo 1942 / Gauss-Kruger CM 81E', 'EPSG', 2504, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 81E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2504"]]', -1814659.2978719751, 2815567.4178705847, 4460363.2509990625, 9090589.9667416223,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2505, 'Pulkovo 1942 / Gauss-Kruger CM 87E', 'EPSG', 2505, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 87E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2505"]]', -1495035.2696992536, 2495078.7743175128, 5114917.5560218836, 9105031.6000386500,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2506, 'Pulkovo 1942 / Gauss-Kruger CM 93E', 'EPSG', 2506, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 93E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2506"]]', -1322201.9700071866, 2322218.7006719919, 5462881.1583670101, 9107301.8290461886,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2507, 'Pulkovo 1942 / Gauss-Kruger CM 99E', 'EPSG', 2507, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 99E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2507"]]', -1329729.0171473748, 2329715.4853414780, 5444798.5180799312, 9104243.0205687840,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2508, 'Pulkovo 1942 / Gauss-Kruger CM 105E', 'EPSG', 2508, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 105E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2508"]]', -1228247.8325256995, 2228203.8918961263, 5438693.8297767613, 8895145.5541985871,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2509, 'Pulkovo 1942 / Gauss-Kruger CM 111E', 'EPSG', 2509, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 111E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2509"]]', -1102358.5913537259, 2102283.9945444230, 5387940.2416382385, 8592582.8275363875,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2510, 'Pulkovo 1942 / Gauss-Kruger CM 117E', 'EPSG', 2510, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 117E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2510"]]', -1031699.3432784133, 2031595.3278242332, 5431801.4856509205, 8495096.1567535669,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2511, 'Pulkovo 1942 / Gauss-Kruger CM 123E', 'EPSG', 2511, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 123E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2511"]]', -802429.8558344193, 1802298.6359708321, 5663041.3773907010, 8267769.8691959524,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2512, 'Pulkovo 1942 / Gauss-Kruger CM 129E', 'EPSG', 2512, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 129E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2512"]]', -1315088.4547646639, 2314921.4937322418, 4614006.3547313806, 8244016.3032282864,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2513, 'Pulkovo 1942 / Gauss-Kruger CM 135E', 'EPSG', 2513, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 135E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2513"]]', -1440399.5383546835, 2440206.5351263387, 4651407.9211448642, 8532013.9946258863,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2514, 'Pulkovo 1942 / Gauss-Kruger CM 141E', 'EPSG', 2514, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 141E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2514"]]', -1261886.6471798122, 2261671.5264380052, 5014977.1189511833, 8538535.2925690008,'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2515, 'Pulkovo 1942 / Gauss-Kruger CM 147E', 'EPSG', 2515, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 147E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2515"]]', -1423229.7750047809, 2422990.1866349602, 4759852.9988496520, 8606072.9604893930,'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2516, 'Pulkovo 1942 / Gauss-Kruger CM 153E', 'EPSG', 2516, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 153E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2516"]]', -1265377.0254335030, 2265118.5808361281, 5007078.3354539990, 8537573.9417236301,'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2517, 'Pulkovo 1942 / Gauss-Kruger CM 159E', 'EPSG', 2517, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 159E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2517"]]', -1059737.2587859991, 2059464.1026099342, 5515282.7181507756, 8634484.0795467089,'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2518, 'Pulkovo 1942 / Gauss-Kruger CM 165E', 'EPSG', 2518, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 165E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2518"]]', -401183.0866779274, 1400897.5750158705, 6007811.7046761474, 7809892.3663699452,'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2519, 'Pulkovo 1942 / Gauss-Kruger CM 171E', 'EPSG', 2519, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 171E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2519"]]', -411619.8848378053, 1411321.5137582425, 6005196.3910414836, 7828137.7896375313,'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2520, 'Pulkovo 1942 / Gauss-Kruger CM 177E', 'EPSG', 2520, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 177E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2520"]]', -76011.3948881404, 1075708.6123201039, 6819557.7053745271, 7971277.7125827714,'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2521, 'Pulkovo 1942 / Gauss-Kruger CM 177W', 'EPSG', 2521, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 177W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2521"]]', 76874.7820794338, 922817.5490218535, 7126156.2261469705, 7972098.9930893903,'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2522, 'Pulkovo 1942 / Gauss-Kruger CM 171W', 'EPSG', 2522, 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 171W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2522"]]', 302698.2427807108, 649894.0954848906, 7117190.8312674843, 7464386.6839716641,'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2523, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 7', 'EPSG', 2523, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 7",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",7500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2523"]]', 6874214.4692966597, 8131237.7080387395, 5322063.7662691678, 6579087.0050112476,'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2524, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 8', 'EPSG', 2524, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 8",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",8500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2524"]]', 7803373.6991621500, 9196876.1712838241, 5260603.1617842664, 6654105.6339059404,'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2525, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 9', 'EPSG', 2525, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 9",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",9500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2525"]]', 8129702.9910364462, 10870541.6649280140, 4962361.7832506317, 7703200.4571421994,'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2526, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 10', 'EPSG', 2526, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 10",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",10500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2526"]]', 9071722.0285069637, 11928518.4133580148, 4951220.9718360647, 7808017.3566871158,'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2527, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 11', 'EPSG', 2527, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 11",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",11500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2527"]]', 10012164.4043732887, 12988070.4653997621, 4853355.5152005237, 7829261.5762269972,'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2528, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 12', 'EPSG', 2528, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 12",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",12500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2528"]]', 11065456.8088356744, 13934772.6213803046, 4887625.6897153620, 7756941.5022599922,'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2529, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 13', 'EPSG', 2529, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 13",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",13500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2529"]]', 12010691.2645930463, 14989530.5695556196, 4714403.8714875119, 7693243.1764500853,'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2530, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 14', 'EPSG', 2530, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 14",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",14500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2530"]]', 12895596.4966875442, 16105457.8811290584, 4481136.4849139533, 7690997.8693554675,'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2531, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 15', 'EPSG', 2531, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 15",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",15500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2531"]]', 13070138.6359961801, 17930064.9739145893, 4208442.5441588196, 9068368.8820772287,'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2532, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 16', 'EPSG', 2532, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 16",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",48,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",16500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2532"]]', 14033154.1490460608, 18967040.5338091728, 4148177.7090548790, 9082064.0938179911,'+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2533, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 17', 'EPSG', 2533, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 17",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",17500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2533"]]', 14977635.7859732214, 20022549.2259884623, 4073885.1604431912, 9118798.6004584322,'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2534, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 18', 'EPSG', 2534, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 18",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",54,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",18500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2534"]]', 15947555.5893935429, 21052619.3739739528, 4036095.7490047773, 9141159.5335851872,'+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2535, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 19', 'EPSG', 2535, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 19",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",19500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2535"]]', 16937580.3683026463, 22062584.4546430155, 4070117.4948330650, 9195121.5811734341,'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2536, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 20', 'EPSG', 2536, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 20",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",60,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",20500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2536"]]', 17813492.1644560595, 23186660.0358240965, 3828953.4273552226, 9202121.2987232597,'+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2537, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 21', 'EPSG', 2537, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 21",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",21500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2537"]]', 18800265.8117852006, 24199874.6062788088, 3787387.0393841448, 9186995.8338777530,'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2538, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 22', 'EPSG', 2538, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 22",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",66,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",22500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2538"]]', 19895649.8801691960, 25104479.4423559775, 3916443.5101999123, 9125273.0723866937,'+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2539, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 23', 'EPSG', 2539, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 23",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",23500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2539"]]', 21176346.5843202848, 25823770.8196248595, 4000484.0698738055, 8647908.3051783802,'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2540, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 24', 'EPSG', 2540, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 24",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",72,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",24500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2540"]]', 22364425.6295711227, 26635678.6808191597, 3978859.5559520513, 8250112.6072000883,'+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2541, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 25', 'EPSG', 2541, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 25",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",25500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2541"]]', 23039849.7368712745, 27960241.7450601101, 4027416.1739651431, 8947808.1821539787,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2542, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 26', 'EPSG', 2542, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 26",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",26500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2542"]]', 24149115.9500277798, 28850964.6000410606, 4389100.1235398680, 9090948.7735531487,'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2543, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 27', 'EPSG', 2543, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 27",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",27500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2543"]]', 25228807.2687752960, 29771260.5157025005, 4545427.1275453428, 9087880.3744725473,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2544, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 28', 'EPSG', 2544, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 28",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",28500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2544"]]', 26620282.8464838079, 30379773.5930872337, 4926011.3138918503, 8685502.0604952761,'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2545, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 29', 'EPSG', 2545, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 29",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",29500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2545"]]', 27755619.4657350297, 31244424.2290674743, 5146847.3119369730, 8635652.0752694175,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2546, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 30', 'EPSG', 2546, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 30",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",30500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2546"]]', 28654668.7640195941, 32345362.4084201971, 5408707.3798330855, 9099401.0242336885,'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2547, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 31', 'EPSG', 2547, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 31",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",31500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2547"]]', 29697462.8171165586, 33302554.1420711762, 5490429.2579139887, 9095520.5828686062,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2548, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 32', 'EPSG', 2548, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 32",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",32500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2548"]]', 30667361.8676847464, 34332639.6855999545, 5441445.8367480047, 9106723.6546632128,'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2549, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 33', 'EPSG', 2549, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 33",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",33500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2549"]]', 31696945.9645131380, 35303040.5390381589, 5449256.2491035988, 9055350.8236286197,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2551, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 34', 'EPSG', 2551, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 34",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",34500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2551"]]', 32787990.0181271537, 36211981.6753777088, 5495021.8767883811, 8919013.5340389362,'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2552, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 35', 'EPSG', 2552, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 35",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",35500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2552"]]', 33814690.2397897088, 37185266.2469916946, 5491599.9666947786, 8862175.9738967644,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2553, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 36', 'EPSG', 2553, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 36",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",36500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2553"]]', 34810802.3589493222, 38189138.1897496246, 5393580.6787654268, 8771916.5095657293,'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2554, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 37', 'EPSG', 2554, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 37",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",37500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2554"]]', 35896710.4029673428, 39103214.9818864747, 5384652.7747517565, 8591157.3536708885,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2555, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 38', 'EPSG', 2555, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 38",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",38500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2555"]]', 36923326.5592897203, 40076584.1880189363, 5424600.7993409404, 8577858.4280701565,'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2556, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 39', 'EPSG', 2556, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 39",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",39500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2556"]]', 38056196.6129223779, 40943699.3536601812, 5431936.7801543115, 8319439.5208921149,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2557, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 40', 'EPSG', 2557, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 40",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",40500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2557"]]', 39123424.5126893210, 41876457.1689248395, 5474561.9414404003, 8227594.5976759189,'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2558, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 41', 'EPSG', 2558, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 41",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",41500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2558"]]', 40293433.5728981929, 42706436.6817465885, 5849337.0116476077, 8262340.1204960033,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2559, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 42', 'EPSG', 2559, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 42",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",42500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2559"]]', 41102521.1995763195, 43897332.0214793223, 5474874.3234241841, 8269685.1453271868,'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2560, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 43', 'EPSG', 2560, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 43",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",43500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2560"]]', 41709558.4152548327, 45290274.9563264684, 4658339.8595482903, 8239056.4006199259,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2561, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 44', 'EPSG', 2561, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 44",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",44500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2561"]]', 42778110.8931024590, 46221708.7700729227, 4614323.2166731263, 8057921.0936435900,'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2562, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 45', 'EPSG', 2562, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 45",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",45500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2562"]]', 43579554.5006455969, 47420252.5755679939, 4661121.1011198678, 8501819.1760422649,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2563, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 46', 'EPSG', 2563, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 46",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",138,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",46500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2563"]]', 44674785.9614457309, 48325010.1634173945, 4889226.1262895239, 8539450.3282611875,'+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2564, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 47', 'EPSG', 2564, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 47",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",47500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2564"]]', 45739515.3486350622, 49260269.5201025907, 5011746.7989225328, 8532500.9703900613,'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2565, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 48', 'EPSG', 2565, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 48",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",144,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",48500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2565"]]', 46625153.0995999455, 50374618.3967314035, 4759539.7858394893, 8509005.0829709474,'+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2566, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 49', 'EPSG', 2566, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 49",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",49500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2566"]]', 47579305.1016543512, 51420455.3034629296, 4756668.9552586316, 8597819.1570672100,'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2567, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 50', 'EPSG', 2567, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 50",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",150,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",50500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2567"]]', 48668847.9884666350, 52330903.1018120128, 4939021.1709736019, 8601076.2843189797,'+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2568, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 51', 'EPSG', 2568, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 51",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",51500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2568"]]', 49788614.7760674399, 53211127.4909968781, 5111467.0711653349, 8533979.7860947731,'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2569, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 52', 'EPSG', 2569, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 52",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",156,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",52500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2569"]]', 50867035.8779043589, 54132698.7644656117, 5370210.7384778016, 8635873.6250390544,'+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2570, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 53', 'EPSG', 2570, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 53",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",53500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2570"]]', 52355132.3364360142, 54644595.3373055947, 5649256.9699481433, 7938719.9708177237,'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2571, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 54', 'EPSG', 2571, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 54",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",162,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",54500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2571"]]', 53535678.2740286757, 55464043.5823426227, 5987800.1816603929, 7916165.4899743399,'+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2572, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 55', 'EPSG', 2572, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 55",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",55500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2572"]]', 54623210.7240912223, 56376503.9226098975, 6030128.0841269338, 7783421.2826456089,'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2573, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 56', 'EPSG', 2573, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 56",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",56500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2573"]]', 55594816.9395868607, 57404890.7389633082, 6002328.8517936874, 7812402.6511701349,'+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2574, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 57', 'EPSG', 2574, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 57",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",57500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2574"]]', 56901097.0157054419, 58098608.7990281453, 6616501.4972633243, 7814013.2805860277,'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2575, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 58', 'EPSG', 2575, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 58",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",58500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2575"]]', 57976412.9186289591, 59023288.4070992413, 6745286.7736530626, 7792162.2621233448,'+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2576, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 59', 'EPSG', 2576, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 59",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",59500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2576"]]', 58977501.0040531338, 60022196.5473490253, 6867894.4002199026, 7912589.9435157942,'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2578, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 61', 'EPSG', 2578, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 61",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",61500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2578"]]', 61101487.5899600426, 61898205.0362952386, 7168007.5286390314, 7964724.9749742273,'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2579, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 62', 'EPSG', 2579, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 62",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",62500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2579"]]', 62292309.6285155481, 62707380.2207578803, 7115164.6758191735, 7530235.2680615056,'+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2580, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 63', 'EPSG', 2580, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 63",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",63500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2580"]]', 63341017.3205421325, 63655289.4429011438, 7133750.7482918305, 7448022.8706508418,'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2581, 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 64', 'EPSG', 2581, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 64",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",64500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2581"]]', 64440302.5103955819, 64459062.2156658219, 7289523.8340393022, 7308283.5393095421,'+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2582, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 21E', 'EPSG', 2582, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 21E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2582"]]', -125785.5307033403, 1131237.7080387395, 5322063.7662691678, 6579087.0050112476,'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2583, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 24E', 'EPSG', 2583, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 24E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2583"]]', -196626.3008378504, 1196876.1712838237, 5260603.1617842664, 6654105.6339059404,'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2584, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 27E', 'EPSG', 2584, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 27E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2584"]]', -870297.0089635540, 1870541.6649280137, 4962361.7832506317, 7703200.4571421994,'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2585, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 30E', 'EPSG', 2585, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 30E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2585"]]', -928277.9714930361, 1928518.4133580149, 4951220.9718360647, 7808017.3566871158,'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2586, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 33E', 'EPSG', 2586, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 33E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2586"]]', -987835.5956267115, 1988070.4653997620, 4853355.5152005237, 7829261.5762269972,'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2587, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 36E', 'EPSG', 2587, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 36E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2587"]]', -934543.1911643256, 1934772.6213803045, 4887625.6897153620, 7756941.5022599922,'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2588, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 39E', 'EPSG', 2588, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 39E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2588"]]', -989308.7354069530, 1989530.5695556203, 4714403.8714875119, 7693243.1764500853,'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2589, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 42E', 'EPSG', 2589, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 42E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2589"]]', -1104403.5033124554, 2105457.8811290588, 4481136.4849139533, 7690997.8693554675,'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2590, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 45E', 'EPSG', 2590, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 45E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2590"]]', -1929861.3640038204, 2930064.9739145888, 4208442.5441588196, 9068368.8820772287,'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2591, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 48E', 'EPSG', 2591, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 48E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",48,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2591"]]', -1966845.8509539388, 2967040.5338091732, 4148177.7090548790, 9082064.0938179911,'+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2592, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 51E', 'EPSG', 2592, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 51E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2592"]]', -2022364.2140267794, 3022549.2259884616, 4073885.1604431912, 9118798.6004584322,'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2593, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 54E', 'EPSG', 2593, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 54E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",54,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2593"]]', -2052444.4106064565, 3052619.3739739534, 4036095.7490047773, 9141159.5335851872,'+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2594, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 57E', 'EPSG', 2594, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 57E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2594"]]', -2062419.6316973521, 3062584.4546430171, 4070117.4948330650, 9195121.5811734341,'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2595, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 60E', 'EPSG', 2595, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 60E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",60,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2595"]]', -2186507.8355439411, 3186660.0358240960, 3828953.4273552226, 9202121.2987232597,'+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2596, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 63E', 'EPSG', 2596, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 63E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2596"]]', -2199734.1882147999, 3199874.6062788084, 3787387.0393841448, 9186995.8338777530,'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2597, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 66E', 'EPSG', 2597, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 66E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",66,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2597"]]', -2104350.1198308043, 3104479.4423559772, 3916443.5101999123, 9125273.0723866937,'+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2598, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 69E', 'EPSG', 2598, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 69E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2598"]]', -1823653.4156797159, 2823770.8196248589, 4000484.0698738055, 8647908.3051783802,'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2599, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 72E', 'EPSG', 2599, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 72E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",72,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2599"]]', -1635574.3704288780, 2635678.6808191591, 3978859.5559520513, 8250112.6072000883,'+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2601, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 75E', 'EPSG', 2601, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 75E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2601"]]', -1960150.2631287260, 2960241.7450601095, 4027416.1739651431, 8947808.1821539787,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2602, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 78E', 'EPSG', 2602, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 78E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2602"]]', -1850884.0499722218, 2850964.6000410589, 4389100.1235398680, 9090948.7735531487,'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2603, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 81E', 'EPSG', 2603, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 81E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2603"]]', -1771192.7312247037, 2771260.5157025008, 4545427.1275453428, 9087880.3744725473,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2604, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 84E', 'EPSG', 2604, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 84E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2604"]]', -1379717.1535161935, 2379773.5930872324, 4926011.3138918503, 8685502.0604952761,'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2605, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 87E', 'EPSG', 2605, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 87E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2605"]]', -1244380.5342649708, 2244424.2290674738, 5146847.3119369730, 8635652.0752694175,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2606, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 90E', 'EPSG', 2606, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 90E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2606"]]', -1345331.2359804062, 2345362.4084201968, 5408707.3798330855, 9099401.0242336885,'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2607, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 93E', 'EPSG', 2607, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 93E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2607"]]', -1302537.1828834406, 2302554.1420711770, 5490429.2579139887, 9095520.5828686062,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2608, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 96E', 'EPSG', 2608, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 96E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2608"]]', -1332638.1323152522, 2332639.6855999559, 5441445.8367480047, 9106723.6546632128,'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2609, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 99E', 'EPSG', 2609, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 99E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2609"]]', -1303054.0354868626, 2303040.5390381584, 5449256.2491035988, 9055350.8236286197,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2610, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 102E', 'EPSG', 2610, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 102E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2610"]]', -1212009.9818728468, 2211981.6753777084, 5495021.8767883811, 8919013.5340389362,'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2611, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 105E', 'EPSG', 2611, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 105E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2611"]]', -1185309.7602102916, 2185266.2469916941, 5491599.9666947786, 8862175.9738967644,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2612, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 108E', 'EPSG', 2612, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 108E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2612"]]', -1189197.6410506791, 2189138.1897496233, 5393580.6787654268, 8771916.5095657293,'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2613, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 111E', 'EPSG', 2613, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 111E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2613"]]', -1103289.5970326598, 2103214.9818864721, 5384652.7747517565, 8591157.3536708885,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2614, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 114E', 'EPSG', 2614, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 114E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2614"]]', -1076673.4407102807, 2076584.1880189354, 5424600.7993409404, 8577858.4280701565,'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2615, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 117E', 'EPSG', 2615, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 117E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2615"]]', -943803.3870776190, 1943699.3536601844, 5431936.7801543115, 8319439.5208921149,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2616, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 120E', 'EPSG', 2616, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 120E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2616"]]', -876575.4873106815, 1876457.1689248370, 5474561.9414404003, 8227594.5976759189,'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2617, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 123E', 'EPSG', 2617, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 123E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2617"]]', -706566.4271018081, 1706436.6817465875, 5849337.0116476077, 8262340.1204960033,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2618, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 126E', 'EPSG', 2618, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 126E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2618"]]', -897478.8004236804, 1897332.0214793223, 5474874.3234241841, 8269685.1453271868,'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2619, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 129E', 'EPSG', 2619, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 129E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2619"]]', -1290441.5847451680, 2290274.9563264677, 4658339.8595482903, 8239056.4006199259,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2620, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 132E', 'EPSG', 2620, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 132E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2620"]]', -1221889.1068975406, 2221708.7700729232, 4614323.2166731263, 8057921.0936435900,'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2621, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 135E', 'EPSG', 2621, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 135E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2621"]]', -1420445.4993544022, 2420252.5755679948, 4661121.1011198678, 8501819.1760422649,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2622, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 138E', 'EPSG', 2622, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 138E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",138,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2622"]]', -1325214.0385542704, 2325010.1634173932, 4889226.1262895239, 8539450.3282611875,'+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2623, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 141E', 'EPSG', 2623, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 141E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2623"]]', -1260484.6513649387, 2260269.5201025898, 5011746.7989225328, 8532500.9703900613,'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2624, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 144E', 'EPSG', 2624, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 144E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",144,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2624"]]', -1374846.9004000547, 2374618.3967314033, 4759539.7858394893, 8509005.0829709474,'+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2625, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 147E', 'EPSG', 2625, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 147E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2625"]]', -1420694.8983456493, 2420455.3034629292, 4756668.9552586316, 8597819.1570672100,'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2626, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 150E', 'EPSG', 2626, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 150E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",150,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2626"]]', -1331152.0115333669, 2330903.1018120109, 4939021.1709736019, 8601076.2843189797,'+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2627, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 153E', 'EPSG', 2627, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 153E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2627"]]', -1211385.2239325587, 2211127.4909968795, 5111467.0711653349, 8533979.7860947731,'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2628, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 156E', 'EPSG', 2628, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 156E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",156,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2628"]]', -1132964.1220956394, 2132698.7644656133, 5370210.7384778016, 8635873.6250390544,'+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2629, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 159E', 'EPSG', 2629, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 159E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2629"]]', -644867.6635639848, 1644595.3373055957, 5649256.9699481433, 7938719.9708177237,'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2630, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 162E', 'EPSG', 2630, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 162E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",162,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2630"]]', -464321.7259713266, 1464043.5823426204, 5987800.1816603929, 7916165.4899743399,'+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2631, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 165E', 'EPSG', 2631, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 165E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2631"]]', -376789.2759087800, 1376503.9226098951, 6030128.0841269338, 7783421.2826456089,'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2632, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 168E', 'EPSG', 2632, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 168E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2632"]]', -405183.0604131407, 1404890.7389633068, 6002328.8517936874, 7812402.6511701349,'+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2633, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 171E', 'EPSG', 2633, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 171E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2633"]]', -98902.9842945562, 1098608.7990281472, 6616501.4972633243, 7814013.2805860277,'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2634, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 174E', 'EPSG', 2634, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 174E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2634"]]', -23587.0813710409, 1023288.4070992414, 6745286.7736530626, 7792162.2621233448,'+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2635, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 177E', 'EPSG', 2635, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 177E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2635"]]', -22498.9959468655, 1022196.5473490260, 6867894.4002199026, 7912589.9435157942,'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2636, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 180E', 'EPSG', 2636, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 180E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",180,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2636"]]', -45712.7838849538, 1045406.5646147691, 6883722.2099012443, 7974841.5584009672,'+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2637, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 177W', 'EPSG', 2637, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 177W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2637"]]', 101487.5899600425, 898205.0362952384, 7168007.5286390314, 7964724.9749742273,'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2638, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 174W', 'EPSG', 2638, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 174W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2638"]]', 292309.6285155484, 707380.2207578805, 7115164.6758191735, 7530235.2680615056,'+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2639, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 171W', 'EPSG', 2639, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 171W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2639"]]', 341017.3205421329, 655289.4429011443, 7133750.7482918305, 7448022.8706508418,'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2640, 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 168W', 'EPSG', 2640, 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 168W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2640"]]', 440302.5103955836, 459062.2156658235, 7289523.8340393022, 7308283.5393095421,'+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.12 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2641, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 7', 'EPSG', 2641, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 7",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",7500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2641"]]', 7403265.4698859863, 7601546.3368389140, 5979169.7624209575, 6177450.6293738852,'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2642, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 8', 'EPSG', 2642, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 8",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",8500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2642"]]', 8372770.4581688370, 8457740.6348109871, 6022841.1945102697, 6107811.3711524198,'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2643, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 9', 'EPSG', 2643, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 9",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",9500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2643"]]', 8788211.1682350619, 10281825.6667367013, 6185596.0773020030, 7679210.5758036424,'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2644, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 10', 'EPSG', 2644, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 10",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",10500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2644"]]', 9515254.2043997038, 11484992.1093078379, 5821216.6379296926, 7790954.5428378268,'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2645, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 11', 'EPSG', 2645, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 11",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",11500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2645"]]', 10412246.4645733024, 12587994.6945440032, 5638122.4193172414, 7813870.6492879423,'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2646, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 12', 'EPSG', 2646, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 12",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",12500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2646"]]', 11065851.0902531769, 13935177.5322921157, 4887622.2805642004, 7756948.7226031392,'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2647, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 13', 'EPSG', 2647, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 13",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",13500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2647"]]', 12025714.6764238298, 14974513.7065400194, 4743864.5769743875, 7692663.6070905772,'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2648, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 14', 'EPSG', 2648, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 14",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",14500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2648"]]', 13002616.8338736566, 15997604.5523719107, 4691867.4156902842, 7686855.1341885384,'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2649, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 15', 'EPSG', 2649, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 15",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",15500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2649"]]', 13246264.6541041766, 17753949.0639471601, 4553910.6021031450, 9061595.0119461285,'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2650, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 16', 'EPSG', 2650, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 16",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",48,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",16500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2650"]]', 14199447.1773585090, 18800758.2978138486, 4474358.0687301960, 9075669.1891855355,'+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2651, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 17', 'EPSG', 2651, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 17",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",17500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2651"]]', 15249025.8013019735, 19751171.0254392712, 4606217.0624688780, 9108362.2866061758,'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2652, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 18', 'EPSG', 2652, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 18",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",54,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",18500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2652"]]', 16709657.7515507058, 20290530.5901554248, 5530977.6235243731, 9111850.4621290921,'+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2653, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 19', 'EPSG', 2653, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 19",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",19500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2653"]]', 17682367.9974436330, 21317810.5016947074, 5531036.7115170139, 9166479.2157680883,'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2654, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 20', 'EPSG', 2654, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 20",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",60,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",20500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2654"]]', 18677731.9335744024, 22322436.2121434085, 5524181.1239166867, 9168885.4024856927,'+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2655, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 21', 'EPSG', 2655, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 21",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",21500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2655"]]', 19718245.8599942371, 23281911.5247275897, 5588028.0833621908, 9151693.7480955433,'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2656, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 22', 'EPSG', 2656, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 22",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",66,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",22500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2656"]]', 20938207.7479710222, 24061938.7356393806, 5961449.2507965571, 9085180.2384649155,'+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2657, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 23', 'EPSG', 2657, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 23",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",23500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2657"]]', 22212069.5112818043, 24788065.3526417639, 6032083.0849222762, 8608078.9262822357,'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2658, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 24', 'EPSG', 2658, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 24",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",72,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",24500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2658"]]', 23332973.2983162425, 25667149.3402481318, 5878691.3946278527, 8212867.4365597420,'+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2659, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 25', 'EPSG', 2659, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 25",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",25500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2659"]]', 23978969.6740191110, 27021140.5559494182, 5869524.8864947172, 8911695.7684250244,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2660, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 26', 'EPSG', 2660, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 26",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",26500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2660"]]', 24787783.5440629880, 28212313.7371552762, 5641862.6725961213, 9066392.8656884096,'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2661, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 27', 'EPSG', 2661, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 27",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",27500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2661"]]', 25742079.2533522351, 29258004.9328590566, 5552222.3138976656, 9068147.9934044871,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2662, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 28', 'EPSG', 2662, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 28",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",28500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2662"]]', 26878701.4602247711, 30121369.3519051884, 5432904.2876715122, 8675572.1793519294,'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2663, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 29', 'EPSG', 2663, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 29",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",29500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2663"]]', 27872416.0128150929, 31127641.2831885058, 5375944.4722933711, 8631169.7426667840,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2664, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 30', 'EPSG', 2664, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 30",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",30500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2664"]]', 28654674.2189468634, 32345369.4830049048, 5408716.0604670029, 9099411.3245250443,'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2665, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 31', 'EPSG', 2665, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 31",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",31500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2665"]]', 29697468.5770246263, 33302561.4345626098, 5490438.5454508473, 9095531.4029888309,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2666, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 32', 'EPSG', 2666, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 32",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",32500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2666"]]', 30667368.3602297817, 34332647.7412790518, 5441455.5892183718, 9106734.9702676420,'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2667, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 33', 'EPSG', 2667, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 33",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",33500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2667"]]', 31696953.0449571285, 35303049.1406664912, 5449266.4922503621, 9055362.5879597248,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2668, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 34', 'EPSG', 2668, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 34",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",34500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2668"]]', 32787997.6044347288, 36211990.6794569565, 5495032.6164789690, 8919025.6915011968,'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2669, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 35', 'EPSG', 2669, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 35",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",35500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2669"]]', 33814698.4880534935, 37185275.8669471291, 5491611.1329395928, 8862188.5118332283,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2670, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 36', 'EPSG', 2670, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 36",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",36500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2670"]]', 34810811.5851404140, 38189148.8072885653, 5393592.1624225908, 8771929.3845707421,'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2671, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 37', 'EPSG', 2671, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 37",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",37500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2671"]]', 35896720.3649593655, 39103226.2414912146, 5384664.6228737489, 8591170.4994055980,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2672, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 38', 'EPSG', 2672, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 38",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",38500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2672"]]', 36923337.0814124477, 40076595.9198614824, 5424613.0233636029, 8577871.8618126376,'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2673, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 39', 'EPSG', 2673, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 39",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",39500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2673"]]', 38056207.8638567292, 40943711.6664393655, 5431949.3187857872, 8319453.1213684234,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2674, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 40', 'EPSG', 2674, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 40",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",40500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2674"]]', 39123436.3531401239, 41876469.9487671622, 5474574.7899373339, 8227608.3855643722,'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2675, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 41', 'EPSG', 2675, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 41",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",41500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2675"]]', 40293444.9484108746, 42706448.6926773354, 5849350.3593513327, 8262354.1036177935,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2676, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 42', 'EPSG', 2676, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 42",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",42500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2676"]]', 41102534.4398689622, 43897346.0927642083, 5474887.6267474827, 8269699.2796427289,'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2677, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 43', 'EPSG', 2677, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 43",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",43500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2677"]]', 41709574.7405709049, 45290292.6292383203, 4658352.7499920537, 8239070.6386594691,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2678, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 44', 'EPSG', 2678, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 44",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",44500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2678"]]', 42778128.0744652280, 46221727.1700788608, 4614336.2453298781, 8057935.3409435109,'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2679, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 45', 'EPSG', 2679, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 45",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",45500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2679"]]', 43579572.1543531056, 47420271.4314523403, 4661134.3077092261, 8501833.5848084608,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2680, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 46', 'EPSG', 2680, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 46",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",138,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",46500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2680"]]', 44674803.6716169797, 48325028.8173259191, 4889239.5839405403, 8539464.7296494797,'+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2681, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 47', 'EPSG', 2681, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 47",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",47500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2681"]]', 45739533.4089701909, 49260288.3384070855, 5011760.3856501703, 8532515.3150870648,'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2682, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 48', 'EPSG', 2682, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 48",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",144,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",48500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2682"]]', 46625172.5391373604, 50374638.6122894020, 4759553.2579936057, 8509019.3311456472,'+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2683, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 49', 'EPSG', 2683, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 49",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",49500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2683"]]', 47579325.2049756880, 51420476.0711114397, 4756682.4227426290, 8597833.2888783808,'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2684, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 50', 'EPSG', 2684, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 50",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",150,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",50500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2684"]]', 48668868.2618603724, 52330923.8264530134, 4939034.6785461148, 8601090.2431387557,'+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2685, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 51', 'EPSG', 2685, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 51",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",51500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2685"]]', 49788635.2411086428, 53211148.2080264596, 5111480.5572790777, 8533993.5241968945,'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2686, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 52', 'EPSG', 2686, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 52",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",156,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",52500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2686"]]', 50867056.2596925491, 54132719.2156737081, 5370224.1713825485, 8635887.1273637076,'+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2687, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 53', 'EPSG', 2687, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 53",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",53500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2687"]]', 52355152.6474873463, 54644615.4679803883, 5649270.2842773118, 7938733.1047703537,'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2688, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 54', 'EPSG', 2688, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 54",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",162,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",54500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2688"]]', 53535698.2298152975, 55464063.2286833220, 5987813.3170091238, 7916178.3158771482,'+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2689, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 55', 'EPSG', 2689, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 55",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",55500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2689"]]', 54623231.1706437375, 56376523.9785448033, 6030140.9492908781, 7783433.7571919439,'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2690, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 56', 'EPSG', 2690, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 56",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",56500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2690"]]', 55594838.0405822870, 57404911.3901863593, 6002341.4079085168, 7812414.7575125891,'+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2691, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 57', 'EPSG', 2691, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 57",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",57500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2691"]]', 56901116.8776874900, 58098628.1740593552, 6616513.6875708438, 7814024.9839427090,'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2692, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 58', 'EPSG', 2692, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 58",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",58500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2692"]]', 57976432.9414424168, 59023307.9190534858, 6745298.5523867661, 7792173.5299978351,'+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2693, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 59', 'EPSG', 2693, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 59",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",59500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2693"]]', 58977521.1755147270, 60022216.1911144786, 6867905.7264582311, 7912600.7420579827,'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2695, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 61', 'EPSG', 2695, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 61",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",61500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2695"]]', 61101507.8274768238, 61898224.7492559309, 7168017.8219681132, 7964734.7437472202,'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2696, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 62', 'EPSG', 2696, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 62",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",62500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2696"]]', 62292330.4713322322, 62707400.5577851657, 7115174.4493517431, 7530244.5358046766,'+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2697, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 63', 'EPSG', 2697, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 63",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",63500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2697"]]', 63341038.5093978707, 63655310.1465983774, 7133759.9484316449, 7448031.5856321516,'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2698, 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 64', 'EPSG', 2698, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 64",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",64500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2698"]]', 64440323.4030605021, 64459083.0693042365, 7289532.0744999938, 7308291.7407437281,'+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2699, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 21E', 'EPSG', 2699, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 21E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2699"]]', 403265.4698859867, 601546.3368389137, 5979169.7624209579, 6177450.6293738848,'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2700, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 24E', 'EPSG', 2700, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 24E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2700"]]', 372770.4581688373, 457740.6348109874, 6022841.1945102697, 6107811.3711524198,'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2701, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 27E', 'EPSG', 2701, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 27E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2701"]]', -211788.8317649374, 1281825.6667367020, 6185596.0773020030, 7679210.5758036424,'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2702, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 30E', 'EPSG', 2702, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 30E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2702"]]', -484745.7956002963, 1484992.1093078378, 5821216.6379296926, 7790954.5428378268,'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2703, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 33E', 'EPSG', 2703, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 33E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2703"]]', -587753.5354266975, 1587994.6945440034, 5638122.4193172414, 7813870.6492879423,'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2704, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 36E', 'EPSG', 2704, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 36E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2704"]]', -934148.9097468236, 1935177.5322921151, 4887622.2805642004, 7756948.7226031392,'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2705, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 39E', 'EPSG', 2705, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 39E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2705"]]', -974285.3235761702, 1974513.7065400194, 4743864.5769743875, 7692663.6070905772,'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2706, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 42E', 'EPSG', 2706, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 42E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2706"]]', -997383.1661263430, 1997604.5523719111, 4691867.4156902842, 7686855.1341885384,'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2707, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 45E', 'EPSG', 2707, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 45E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2707"]]', -1753735.3458958232, 2753949.0639471604, 4553910.6021031450, 9061595.0119461285,'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2708, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 48E', 'EPSG', 2708, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 48E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",48,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2708"]]', -1800552.8226414912, 2800758.2978138483, 4474358.0687301960, 9075669.1891855355,'+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2709, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 51E', 'EPSG', 2709, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 51E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2709"]]', -1750974.1986980256, 2751171.0254392722, 4606217.0624688780, 9108362.2866061758,'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2710, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 54E', 'EPSG', 2710, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 54E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",54,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2710"]]', -1290342.2484492935, 2290530.5901554256, 5530977.6235243731, 9111850.4621290921,'+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2711, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 57E', 'EPSG', 2711, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 57E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2711"]]', -1317632.0025563660, 2317810.5016947084, 5531036.7115170139, 9166479.2157680883,'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2712, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 60E', 'EPSG', 2712, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 60E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",60,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2712"]]', -1322268.0664255960, 2322436.2121434100, 5524181.1239166867, 9168885.4024856927,'+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2713, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 63E', 'EPSG', 2713, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 63E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2713"]]', -1281754.1400057645, 2281911.5247275880, 5588028.0833621908, 9151693.7480955433,'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2714, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 66E', 'EPSG', 2714, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 66E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",66,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2714"]]', -1061792.2520289792, 2061938.7356393793, 5961449.2507965571, 9085180.2384649155,'+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2715, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 69E', 'EPSG', 2715, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 69E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2715"]]', -787930.4887181959, 1788065.3526417637, 6032083.0849222762, 8608078.9262822357,'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2716, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 72E', 'EPSG', 2716, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 72E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",72,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2716"]]', -667026.7016837578, 1667149.3402481315, 5878691.3946278527, 8212867.4365597420,'+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2717, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 75E', 'EPSG', 2717, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 75E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2717"]]', -1021030.3259808903, 2021140.5559494170, 5869524.8864947172, 8911695.7684250244,'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2718, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 78E', 'EPSG', 2718, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 78E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2718"]]', -1212216.4559370118, 2212313.7371552764, 5641862.6725961213, 9066392.8656884096,'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2719, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 81E', 'EPSG', 2719, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 81E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2719"]]', -1257920.7466477658, 2258004.9328590556, 5552222.3138976656, 9068147.9934044871,'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2720, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 84E', 'EPSG', 2720, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 84E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2720"]]', -1121298.5397752284, 2121369.3519051889, 5432904.2876715122, 8675572.1793519294,'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2721, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 87E', 'EPSG', 2721, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 87E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2721"]]', -1127583.9871849068, 2127641.2831885061, 5375944.4722933711, 8631169.7426667840,'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2722, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 90E', 'EPSG', 2722, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 90E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2722"]]', -1345325.7810531361, 2345369.4830049053, 5408716.0604670029, 9099411.3245250443,'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2723, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 93E', 'EPSG', 2723, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 93E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2723"]]', -1302531.4229753744, 2302561.4345626092, 5490438.5454508473, 9095531.4029888309,'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2724, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 96E', 'EPSG', 2724, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 96E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2724"]]', -1332631.6397702179, 2332647.7412790523, 5441455.5892183718, 9106734.9702676420,'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2725, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 99E', 'EPSG', 2725, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 99E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2725"]]', -1303046.9550428723, 2303049.1406664904, 5449266.4922503621, 9055362.5879597248,'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2726, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 102E', 'EPSG', 2726, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 102E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2726"]]', -1212002.3955652709, 2211990.6794569569, 5495032.6164789690, 8919025.6915011968,'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2727, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 105E', 'EPSG', 2727, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 105E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2727"]]', -1185301.5119465034, 2185275.8669471322, 5491611.1329395928, 8862188.5118332283,'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2728, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 108E', 'EPSG', 2728, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 108E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2728"]]', -1189188.4148595842, 2189148.8072885671, 5393592.1624225908, 8771929.3845707421,'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2729, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 111E', 'EPSG', 2729, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 111E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2729"]]', -1103279.6350406336, 2103226.2414912156, 5384664.6228737489, 8591170.4994055980,'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2730, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 114E', 'EPSG', 2730, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 114E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2730"]]', -1076662.9185875501, 2076595.9198614846, 5424613.0233636029, 8577871.8618126376,'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2731, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 117E', 'EPSG', 2731, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 117E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2731"]]', -943792.1361432690, 1943711.6664393673, 5431949.3187857872, 8319453.1213684234,'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2732, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 120E', 'EPSG', 2732, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 120E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2732"]]', -876563.6468598788, 1876469.9487671596, 5474574.7899373339, 8227608.3855643722,'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2733, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 123E', 'EPSG', 2733, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 123E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2733"]]', -706555.0515891253, 1706448.6926773356, 5849350.3593513327, 8262354.1036177935,'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2734, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 126E', 'EPSG', 2734, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 126E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2734"]]', -897465.5601310373, 1897346.0927642088, 5474887.6267474827, 8269699.2796427289,'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2735, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 129E', 'EPSG', 2735, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 129E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2735"]]', -1290425.2594290975, 2290292.6292383179, 4658352.7499920537, 8239070.6386594691,'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2736, 'Tete / UTM zone 36S', 'EPSG', 2736, 'PROJCS["Tete / UTM zone 36S",GEOGCS["Tete",DATUM["Tete",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],TOWGS84[-115.064,-87.39,-101.716,-0.058,4.001,-2.062,9.366],AUTHORITY["EPSG","6127"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4127"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2736"]]', -379140.0174410927, 1402156.6215769511, 6990412.1670347918, 8771708.8060528356,'+proj=utm +zone=36 +south +ellps=clrk66 +towgs84=-80,-100,-228,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2737, 'Tete / UTM zone 37S', 'EPSG', 2737, 'PROJCS["Tete / UTM zone 37S",GEOGCS["Tete",DATUM["Tete",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],TOWGS84[-115.064,-87.39,-101.716,-0.058,4.001,-2.062,9.366],AUTHORITY["EPSG","6127"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4127"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2737"]]', -54173.0701854923, 932629.8159406440, 7879935.1347958269, 8866738.0209219632,'+proj=utm +zone=37 +south +ellps=clrk66 +towgs84=-80,-100,-228,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2738, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 132E', 'EPSG', 2738, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 132E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2738"]]', -1221871.9255347735, 2221727.1700788594, 4614336.2453298781, 8057935.3409435109,'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2739, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 135E', 'EPSG', 2739, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 135E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2739"]]', -1420427.8456468952, 2420271.4314523395, 4661134.3077092261, 8501833.5848084608,'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2740, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 138E', 'EPSG', 2740, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 138E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",138,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2740"]]', -1325196.3283830191, 2325028.8173259203, 4889239.5839405403, 8539464.7296494797,'+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2741, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 141E', 'EPSG', 2741, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 141E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2741"]]', -1260466.5910298099, 2260288.3384070846, 5011760.3856501703, 8532515.3150870648,'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2742, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 144E', 'EPSG', 2742, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 144E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",144,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2742"]]', -1374827.4608626396, 2374638.6122894019, 4759553.2579936057, 8509019.3311456472,'+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2743, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 147E', 'EPSG', 2743, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 147E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2743"]]', -1420674.7950243128, 2420476.0711114390, 4756682.4227426290, 8597833.2888783808,'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2744, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 150E', 'EPSG', 2744, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 150E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",150,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2744"]]', -1331131.7381396275, 2330923.8264530134, 4939034.6785461148, 8601090.2431387557,'+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2745, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 153E', 'EPSG', 2745, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 153E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2745"]]', -1211364.7588913575, 2211148.2080264592, 5111480.5572790777, 8533993.5241968945,'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2746, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 156E', 'EPSG', 2746, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 156E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",156,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2746"]]', -1132943.7403074485, 2132719.2156737105, 5370224.1713825485, 8635887.1273637076,'+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2747, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 159E', 'EPSG', 2747, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 159E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2747"]]', -644847.3525126560, 1644615.4679803859, 5649270.2842773118, 7938733.1047703537,'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2748, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 162E', 'EPSG', 2748, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 162E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",162,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2748"]]', -464301.7701847004, 1464063.2286833240, 5987813.3170091238, 7916178.3158771482,'+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2749, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 165E', 'EPSG', 2749, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 165E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2749"]]', -376768.8293562609, 1376523.9785448049, 6030140.9492908781, 7783433.7571919439,'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2750, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 168E', 'EPSG', 2750, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 168E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2750"]]', -405161.9594177135, 1404911.3901863588, 6002341.4079085168, 7812414.7575125891,'+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2751, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 171E', 'EPSG', 2751, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 171E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2751"]]', -98883.1223125096, 1098628.1740593556, 6616513.6875708438, 7814024.9839427090,'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2752, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 174E', 'EPSG', 2752, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 174E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2752"]]', -23567.0585575842, 1023307.9190534848, 6745298.5523867661, 7792173.5299978351,'+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2753, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 177E', 'EPSG', 2753, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 177E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2753"]]', -22478.8244852725, 1022216.1911144790, 6867905.7264582311, 7912600.7420579827,'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2754, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 180E', 'EPSG', 2754, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 180E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",180,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2754"]]', -45692.1624881678, 1045426.6275387745, 6883733.0643718857, 7974851.8543988280,'+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2755, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 177W', 'EPSG', 2755, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 177W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2755"]]', 101507.8274768214, 898224.7492559284, 7168017.8219681132, 7964734.7437472202,'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2756, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 174W', 'EPSG', 2756, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 174W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2756"]]', 292330.4713322329, 707400.5577851663, 7115174.4493517431, 7530244.5358046766,'+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2757, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 171W', 'EPSG', 2757, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 171W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2757"]]', 341038.5093978715, 655310.1465983781, 7133759.9484316449, 7448031.5856321516,'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2758, 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 168W', 'EPSG', 2758, 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 168W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2758"]]', 440323.4030605002, 459083.0693042345, 7289532.0744999938, 7308291.7407437281,'+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2759, 'NAD83(HARN) / Alabama East', 'EPSG', 2759, 'PROJCS["NAD83(HARN) / Alabama East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30.5,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-85.8333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2759"]]', -31904.5747558115, 430631.0197985155, 45808.7311360172, 508344.3256903442,'+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2760, 'NAD83(HARN) / Alabama West', 'EPSG', 2760, 'PROJCS["NAD83(HARN) / Alabama West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-87.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",600000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2760"]]', 329073.1880907814, 892124.4444890515, 5096.0396635230, 568147.2960617930,'+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2761, 'NAD83(HARN) / Arizona East', 'EPSG', 2761, 'PROJCS["NAD83(HARN) / Arizona East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-110.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",213360,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2761"]]', -134360.1351977185, 521423.3306795028, 24521.1769063462, 680304.6427835675,'+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2762, 'NAD83(HARN) / Arizona Central', 'EPSG', 2762, 'PROJCS["NAD83(HARN) / Arizona Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-111.927777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",213360,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2762"]]', -112244.2427957450, 543088.6436213865, 24868.9421689941, 680201.8285861257,'+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2763, 'NAD83(HARN) / Arizona West', 'EPSG', 2763, 'PROJCS["NAD83(HARN) / Arizona West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-113.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",213360,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2763"]]', -64244.8530997676, 507020.3072463666, 105920.2616607606, 677185.4220068948,'+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2764, 'NAD83(HARN) / Arkansas North', 'EPSG', 2764, 'PROJCS["NAD83(HARN) / Arkansas North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-92,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.2333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.9333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",400000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2764"]]', 150753.9112811858, 625422.4145583265, -95607.1821843011, 379061.3210928397,'+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2765, 'NAD83(HARN) / Arkansas South', 'EPSG', 2765, 'PROJCS["NAD83(HARN) / Arkansas South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",32.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-92,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",34.7666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",33.3111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",400000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",400000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2765"]]', 160642.0832646886, 557138.6212969550, 357698.8014033370, 754195.3394356034,'+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2766, 'NAD83(HARN) / California zone 1', 'EPSG', 2766, 'PROJCS["NAD83(HARN) / California zone 1",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-122,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.6777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2766"]]', 1781876.9415987257, 2180333.4382521581, 466048.4940270632, 864504.9906804956,'+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2767, 'NAD83(HARN) / California zone 2', 'EPSG', 2767, 'PROJCS["NAD83(HARN) / California zone 2",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-122,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2767"]]', 1811176.5171974187, 2223939.0462885278, 454070.8776331636, 866833.4067242726,'+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2768, 'NAD83(HARN) / California zone 3', 'EPSG', 2768, 'PROJCS["NAD83(HARN) / California zone 3",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.4444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.0777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2768"]]', 1765636.0904302861, 2247758.7286390787, 397515.8387298739, 879638.4769386666,'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2769, 'NAD83(HARN) / California zone 4', 'EPSG', 2769, 'PROJCS["NAD83(HARN) / California zone 4",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",35.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-119,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.2611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2769"]]', 1716333.5259348216, 2317102.5528654985, 353811.0643088940, 954580.0912395709,'+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2770, 'NAD83(HARN) / California zone 5', 'EPSG', 2770, 'PROJCS["NAD83(HARN) / California zone 5",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-118,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.4666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.0333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2770"]]', 1665738.1236290058, 2377360.2508360640, 237379.1042737699, 949001.2314808281,'+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2771, 'NAD83(HARN) / California zone 6', 'EPSG', 2771, 'PROJCS["NAD83(HARN) / California zone 6",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",32.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-116.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",33.8833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.7944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2771"]]', 1814495.7597549162, 2178928.7632115830, 445585.8907215502, 810018.8941782170,'+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2772, 'NAD83(HARN) / Colorado North', 'EPSG', 2772, 'PROJCS["NAD83(HARN) / Colorado North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",914401.8289,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",304800.6096,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2772"]]', 596467.7239865998, 1223748.4752370133, 102735.6023551866, 730016.3536056001,'+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2773, 'NAD83(HARN) / Colorado Central', 'EPSG', 2773, 'PROJCS["NAD83(HARN) / Colorado Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.75,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.45,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",914401.8289,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",304800.6096,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2773"]]', 590063.9332441219, 1229979.0851191554, 132988.8086181640, 772903.9604931976,'+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2774, 'NAD83(HARN) / Colorado South', 'EPSG', 2774, 'PROJCS["NAD83(HARN) / Colorado South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.4444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.2333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",914401.8289,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",304800.6096,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2774"]]', 584998.1350528573, 1234907.8152472714, 114767.6602291813, 764677.3404235954,'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2775, 'NAD83(HARN) / Connecticut', 'EPSG', 2775, 'PROJCS["NAD83(HARN) / Connecticut",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-72.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.8666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.2111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",304800.6096,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",152400.3048,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2775"]]', 219040.2523812415, 389719.3894320746, 143227.2457094525, 313906.3827602857,'+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=152400.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2776, 'NAD83(HARN) / Delaware', 'EPSG', 2776, 'PROJCS["NAD83(HARN) / Delaware",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75.4166666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2776"]]', 121353.0260768704, 284176.3015214823, 45778.4244728855, 208601.6999174973,'+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2777, 'NAD83(HARN) / Florida East', 'EPSG', 2777, 'PROJCS["NAD83(HARN) / Florida East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2777"]]', -185326.8617120941, 554896.3063977140, -5355.6015602633, 734867.5665495447,'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2778, 'NAD83(HARN) / Florida West', 'EPSG', 2778, 'PROJCS["NAD83(HARN) / Florida West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2778"]]', -15595.1872129998, 368645.2811163740, 207429.1889516337, 591669.6572810076,'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2779, 'NAD83(HARN) / Florida North', 'EPSG', 2779, 'PROJCS["NAD83(HARN) / Florida North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",29,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",30.7611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",29.5833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2779"]]', 284775.1158548456, 850087.2198511995, -156267.7764066114, 409044.3275897424,'+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2780, 'NAD83(HARN) / Georgia East', 'EPSG', 2780, 'PROJCS["NAD83(HARN) / Georgia East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2780"]]', -44692.7662457632, 453665.8016812860, 31040.4911805176, 529399.0591075668,'+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2781, 'NAD83(HARN) / Georgia West', 'EPSG', 2781, 'PROJCS["NAD83(HARN) / Georgia West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-84.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2781"]]', 433886.9002370054, 940544.1729146891, 59571.5571243437, 566228.8298020274,'+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2782, 'NAD83(HARN) / Hawaii zone 1', 'EPSG', 2782, 'PROJCS["NAD83(HARN) / Hawaii zone 1",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",18.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-155.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2782"]]', 424350.4804784782, 592509.6682758155, 931.7452158948, 169090.9330132321,'+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2783, 'NAD83(HARN) / Hawaii zone 2', 'EPSG', 2783, 'PROJCS["NAD83(HARN) / Hawaii zone 2",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",20.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-156.666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2783"]]', 424669.8936732579, 579851.9051770758, -19671.6285003318, 135510.3830034861,'+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666666667 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2784, 'NAD83(HARN) / Hawaii zone 3', 'EPSG', 2784, 'PROJCS["NAD83(HARN) / Hawaii zone 3",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",21.1666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-158,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2784"]]', 464240.7199637720, 541989.1855708613, -4691.7488686206, 73056.7167384688,'+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2785, 'NAD83(HARN) / Hawaii zone 4', 'EPSG', 2785, 'PROJCS["NAD83(HARN) / Hawaii zone 4",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",21.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-159.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2785"]]', 462528.3586549216, 529199.7043667524, -9311.0227698857, 57360.3229419451,'+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2786, 'NAD83(HARN) / Hawaii zone 5', 'EPSG', 2786, 'PROJCS["NAD83(HARN) / Hawaii zone 5",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",21.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-160.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2786"]]', 482662.2859316225, 521820.8401306380, 6265.5541510309, 45424.1083500464,'+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2787, 'NAD83(HARN) / Idaho East', 'EPSG', 2787, 'PROJCS["NAD83(HARN) / Idaho East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-112.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999947368,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2787"]]', 42736.0262815442, 361683.2271953291, 30334.4602849562, 349281.6611987412,'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2788, 'NAD83(HARN) / Idaho Central', 'EPSG', 2788, 'PROJCS["NAD83(HARN) / Idaho Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999947368,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2788"]]', 286472.3912726894, 715184.8424091793, 28483.8667316013, 457196.3178680913,'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2789, 'NAD83(HARN) / Idaho West', 'EPSG', 2789, 'PROJCS["NAD83(HARN) / Idaho West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-115.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",800000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2789"]]', 391788.2612402283, 1203240.0739163704, 21294.6952424526, 832746.5079185947,'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2790, 'NAD83(HARN) / Illinois East', 'EPSG', 2790, 'PROJCS["NAD83(HARN) / Illinois East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-88.3333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999975,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2790"]]', 2014.3311894121, 630598.5714558428, 31980.1584165710, 660564.3986830016,'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2791, 'NAD83(HARN) / Illinois West', 'EPSG', 2791, 'PROJCS["NAD83(HARN) / Illinois West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-90.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2791"]]', 375457.5543570877, 1014154.9017490124, 23202.0932539738, 661899.4406458986,'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2792, 'NAD83(HARN) / Indiana East', 'EPSG', 2792, 'PROJCS["NAD83(HARN) / Indiana East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",37.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-85.6666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",100000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",250000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2792"]]', -122179.4560766986, 318956.7555790266, 291831.8602893918, 732968.0719451169,'+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2793, 'NAD83(HARN) / Indiana West', 'EPSG', 2793, 'PROJCS["NAD83(HARN) / Indiana West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",37.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-87.0944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",900000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",250000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2793"]]', 663125.3476324839, 1125127.1935431398, 271416.4721023938, 733418.3180130497,'+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2794, 'NAD83(HARN) / Iowa North', 'EPSG', 2794, 'PROJCS["NAD83(HARN) / Iowa North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-93.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43.2777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.0777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2794"]]', 1227662.7933965352, 1788934.7109006041, 855561.2414159612, 1416833.1589200301,'+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs',NULL);
REPLACE INTO oceanbase.__all_spatial_reference_systems(srs_version, srs_id, srs_name, organization, organization_coordsys_id, definition, minX, maxX, minY, maxY, proj4text, description) VALUES (1, 2795, 'NAD83(HARN) / Iowa South', 'EPSG', 2795, 'PROJCS["NAD83(HARN) / Iowa South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-93.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.6277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2795"]]', 265614.1451012262, 795502.9781998167, -126736.4130797163, 403152.4200188742,'+proj=lcc +lat_1=41.78333333333333 