/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package jdk.jfr.api.consumer;

import java.util.List;

import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Recording;
import jdk.jfr.consumer.RecordedEvent;
import jdk.test.lib.Asserts;
import jdk.test.lib.jfr.Events;

/**
 * @test
 * @summary Verifies that a single JFR event is recorded as expected
 * @key jfr
 *
 * @library /lib /
 * @run main/othervm jdk.jfr.api.consumer.TestSingleRecordedEvent
 */
public class TestSingleRecordedEvent {

    @Description("MyDescription")
    private static class MyEvent extends Event {
    }

    public static void main(String[] args) throws Throwable {
        Recording r = new Recording();
        r.start();
        // Commit a single event to the recording
        MyEvent event = new MyEvent();
        event.commit();
        r.stop();
        List<RecordedEvent> events = Events.fromRecording(r);
        Events.hasEvents(events);

        // Should be 1 event only
        Asserts.assertEquals(events.size(), 1);

        RecordedEvent recordedEvent = events.get(0);

        // Event description should be the same
        Asserts.assertEquals(recordedEvent.getEventType().getDescription(), "MyDescription");
    }
}
