//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcompute

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms
//     part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAvailabilitySetsClient creates a new instance of AvailabilitySetsClient.
func (c *ClientFactory) NewAvailabilitySetsClient() *AvailabilitySetsClient {
	subClient, _ := NewAvailabilitySetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCapacityReservationGroupsClient creates a new instance of CapacityReservationGroupsClient.
func (c *ClientFactory) NewCapacityReservationGroupsClient() *CapacityReservationGroupsClient {
	subClient, _ := NewCapacityReservationGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCapacityReservationsClient creates a new instance of CapacityReservationsClient.
func (c *ClientFactory) NewCapacityReservationsClient() *CapacityReservationsClient {
	subClient, _ := NewCapacityReservationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCloudServiceOperatingSystemsClient creates a new instance of CloudServiceOperatingSystemsClient.
func (c *ClientFactory) NewCloudServiceOperatingSystemsClient() *CloudServiceOperatingSystemsClient {
	subClient, _ := NewCloudServiceOperatingSystemsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCloudServiceRoleInstancesClient creates a new instance of CloudServiceRoleInstancesClient.
func (c *ClientFactory) NewCloudServiceRoleInstancesClient() *CloudServiceRoleInstancesClient {
	subClient, _ := NewCloudServiceRoleInstancesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCloudServiceRolesClient creates a new instance of CloudServiceRolesClient.
func (c *ClientFactory) NewCloudServiceRolesClient() *CloudServiceRolesClient {
	subClient, _ := NewCloudServiceRolesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCloudServicesClient creates a new instance of CloudServicesClient.
func (c *ClientFactory) NewCloudServicesClient() *CloudServicesClient {
	subClient, _ := NewCloudServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCloudServicesUpdateDomainClient creates a new instance of CloudServicesUpdateDomainClient.
func (c *ClientFactory) NewCloudServicesUpdateDomainClient() *CloudServicesUpdateDomainClient {
	subClient, _ := NewCloudServicesUpdateDomainClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCommunityGalleriesClient creates a new instance of CommunityGalleriesClient.
func (c *ClientFactory) NewCommunityGalleriesClient() *CommunityGalleriesClient {
	subClient, _ := NewCommunityGalleriesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCommunityGalleryImageVersionsClient creates a new instance of CommunityGalleryImageVersionsClient.
func (c *ClientFactory) NewCommunityGalleryImageVersionsClient() *CommunityGalleryImageVersionsClient {
	subClient, _ := NewCommunityGalleryImageVersionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCommunityGalleryImagesClient creates a new instance of CommunityGalleryImagesClient.
func (c *ClientFactory) NewCommunityGalleryImagesClient() *CommunityGalleryImagesClient {
	subClient, _ := NewCommunityGalleryImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDedicatedHostGroupsClient creates a new instance of DedicatedHostGroupsClient.
func (c *ClientFactory) NewDedicatedHostGroupsClient() *DedicatedHostGroupsClient {
	subClient, _ := NewDedicatedHostGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDedicatedHostsClient creates a new instance of DedicatedHostsClient.
func (c *ClientFactory) NewDedicatedHostsClient() *DedicatedHostsClient {
	subClient, _ := NewDedicatedHostsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDiskAccessesClient creates a new instance of DiskAccessesClient.
func (c *ClientFactory) NewDiskAccessesClient() *DiskAccessesClient {
	subClient, _ := NewDiskAccessesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDiskEncryptionSetsClient creates a new instance of DiskEncryptionSetsClient.
func (c *ClientFactory) NewDiskEncryptionSetsClient() *DiskEncryptionSetsClient {
	subClient, _ := NewDiskEncryptionSetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDiskRestorePointClient creates a new instance of DiskRestorePointClient.
func (c *ClientFactory) NewDiskRestorePointClient() *DiskRestorePointClient {
	subClient, _ := NewDiskRestorePointClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDisksClient creates a new instance of DisksClient.
func (c *ClientFactory) NewDisksClient() *DisksClient {
	subClient, _ := NewDisksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGalleriesClient creates a new instance of GalleriesClient.
func (c *ClientFactory) NewGalleriesClient() *GalleriesClient {
	subClient, _ := NewGalleriesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGalleryApplicationVersionsClient creates a new instance of GalleryApplicationVersionsClient.
func (c *ClientFactory) NewGalleryApplicationVersionsClient() *GalleryApplicationVersionsClient {
	subClient, _ := NewGalleryApplicationVersionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGalleryApplicationsClient creates a new instance of GalleryApplicationsClient.
func (c *ClientFactory) NewGalleryApplicationsClient() *GalleryApplicationsClient {
	subClient, _ := NewGalleryApplicationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGalleryImageVersionsClient creates a new instance of GalleryImageVersionsClient.
func (c *ClientFactory) NewGalleryImageVersionsClient() *GalleryImageVersionsClient {
	subClient, _ := NewGalleryImageVersionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGalleryImagesClient creates a new instance of GalleryImagesClient.
func (c *ClientFactory) NewGalleryImagesClient() *GalleryImagesClient {
	subClient, _ := NewGalleryImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGallerySharingProfileClient creates a new instance of GallerySharingProfileClient.
func (c *ClientFactory) NewGallerySharingProfileClient() *GallerySharingProfileClient {
	subClient, _ := NewGallerySharingProfileClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewImagesClient creates a new instance of ImagesClient.
func (c *ClientFactory) NewImagesClient() *ImagesClient {
	subClient, _ := NewImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLogAnalyticsClient creates a new instance of LogAnalyticsClient.
func (c *ClientFactory) NewLogAnalyticsClient() *LogAnalyticsClient {
	subClient, _ := NewLogAnalyticsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewProximityPlacementGroupsClient creates a new instance of ProximityPlacementGroupsClient.
func (c *ClientFactory) NewProximityPlacementGroupsClient() *ProximityPlacementGroupsClient {
	subClient, _ := NewProximityPlacementGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewResourceSKUsClient creates a new instance of ResourceSKUsClient.
func (c *ClientFactory) NewResourceSKUsClient() *ResourceSKUsClient {
	subClient, _ := NewResourceSKUsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorePointCollectionsClient creates a new instance of RestorePointCollectionsClient.
func (c *ClientFactory) NewRestorePointCollectionsClient() *RestorePointCollectionsClient {
	subClient, _ := NewRestorePointCollectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorePointsClient creates a new instance of RestorePointsClient.
func (c *ClientFactory) NewRestorePointsClient() *RestorePointsClient {
	subClient, _ := NewRestorePointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSSHPublicKeysClient creates a new instance of SSHPublicKeysClient.
func (c *ClientFactory) NewSSHPublicKeysClient() *SSHPublicKeysClient {
	subClient, _ := NewSSHPublicKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSharedGalleriesClient creates a new instance of SharedGalleriesClient.
func (c *ClientFactory) NewSharedGalleriesClient() *SharedGalleriesClient {
	subClient, _ := NewSharedGalleriesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSharedGalleryImageVersionsClient creates a new instance of SharedGalleryImageVersionsClient.
func (c *ClientFactory) NewSharedGalleryImageVersionsClient() *SharedGalleryImageVersionsClient {
	subClient, _ := NewSharedGalleryImageVersionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSharedGalleryImagesClient creates a new instance of SharedGalleryImagesClient.
func (c *ClientFactory) NewSharedGalleryImagesClient() *SharedGalleryImagesClient {
	subClient, _ := NewSharedGalleryImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSnapshotsClient creates a new instance of SnapshotsClient.
func (c *ClientFactory) NewSnapshotsClient() *SnapshotsClient {
	subClient, _ := NewSnapshotsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewUsageClient creates a new instance of UsageClient.
func (c *ClientFactory) NewUsageClient() *UsageClient {
	subClient, _ := NewUsageClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineExtensionImagesClient creates a new instance of VirtualMachineExtensionImagesClient.
func (c *ClientFactory) NewVirtualMachineExtensionImagesClient() *VirtualMachineExtensionImagesClient {
	subClient, _ := NewVirtualMachineExtensionImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineExtensionsClient creates a new instance of VirtualMachineExtensionsClient.
func (c *ClientFactory) NewVirtualMachineExtensionsClient() *VirtualMachineExtensionsClient {
	subClient, _ := NewVirtualMachineExtensionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineImagesClient creates a new instance of VirtualMachineImagesClient.
func (c *ClientFactory) NewVirtualMachineImagesClient() *VirtualMachineImagesClient {
	subClient, _ := NewVirtualMachineImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineImagesEdgeZoneClient creates a new instance of VirtualMachineImagesEdgeZoneClient.
func (c *ClientFactory) NewVirtualMachineImagesEdgeZoneClient() *VirtualMachineImagesEdgeZoneClient {
	subClient, _ := NewVirtualMachineImagesEdgeZoneClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineRunCommandsClient creates a new instance of VirtualMachineRunCommandsClient.
func (c *ClientFactory) NewVirtualMachineRunCommandsClient() *VirtualMachineRunCommandsClient {
	subClient, _ := NewVirtualMachineRunCommandsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineScaleSetExtensionsClient creates a new instance of VirtualMachineScaleSetExtensionsClient.
func (c *ClientFactory) NewVirtualMachineScaleSetExtensionsClient() *VirtualMachineScaleSetExtensionsClient {
	subClient, _ := NewVirtualMachineScaleSetExtensionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineScaleSetRollingUpgradesClient creates a new instance of VirtualMachineScaleSetRollingUpgradesClient.
func (c *ClientFactory) NewVirtualMachineScaleSetRollingUpgradesClient() *VirtualMachineScaleSetRollingUpgradesClient {
	subClient, _ := NewVirtualMachineScaleSetRollingUpgradesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineScaleSetVMExtensionsClient creates a new instance of VirtualMachineScaleSetVMExtensionsClient.
func (c *ClientFactory) NewVirtualMachineScaleSetVMExtensionsClient() *VirtualMachineScaleSetVMExtensionsClient {
	subClient, _ := NewVirtualMachineScaleSetVMExtensionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineScaleSetVMRunCommandsClient creates a new instance of VirtualMachineScaleSetVMRunCommandsClient.
func (c *ClientFactory) NewVirtualMachineScaleSetVMRunCommandsClient() *VirtualMachineScaleSetVMRunCommandsClient {
	subClient, _ := NewVirtualMachineScaleSetVMRunCommandsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineScaleSetVMsClient creates a new instance of VirtualMachineScaleSetVMsClient.
func (c *ClientFactory) NewVirtualMachineScaleSetVMsClient() *VirtualMachineScaleSetVMsClient {
	subClient, _ := NewVirtualMachineScaleSetVMsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineScaleSetsClient creates a new instance of VirtualMachineScaleSetsClient.
func (c *ClientFactory) NewVirtualMachineScaleSetsClient() *VirtualMachineScaleSetsClient {
	subClient, _ := NewVirtualMachineScaleSetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineSizesClient creates a new instance of VirtualMachineSizesClient.
func (c *ClientFactory) NewVirtualMachineSizesClient() *VirtualMachineSizesClient {
	subClient, _ := NewVirtualMachineSizesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachinesClient creates a new instance of VirtualMachinesClient.
func (c *ClientFactory) NewVirtualMachinesClient() *VirtualMachinesClient {
	subClient, _ := NewVirtualMachinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
