/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// CollectionImportAPIService CollectionImportAPI service
type CollectionImportAPIService service

type CollectionImportAPICollectionImportReadRequest struct {
	ctx context.Context
	ApiService *CollectionImportAPIService
	ansibleCollectionImportHref string
	since *string
	fields *[]string
	excludeFields *[]string
}

// Filter messages since a given timestamp
func (r CollectionImportAPICollectionImportReadRequest) Since(since string) CollectionImportAPICollectionImportReadRequest {
	r.since = &since
	return r
}

// A list of fields to include in the response.
func (r CollectionImportAPICollectionImportReadRequest) Fields(fields []string) CollectionImportAPICollectionImportReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r CollectionImportAPICollectionImportReadRequest) ExcludeFields(excludeFields []string) CollectionImportAPICollectionImportReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r CollectionImportAPICollectionImportReadRequest) Execute() (*CollectionImportDetailResponse, *http.Response, error) {
	return r.ApiService.CollectionImportReadExecute(r)
}

/*
CollectionImportRead Inspect a collection import

Returns a CollectionImport object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleCollectionImportHref
 @return CollectionImportAPICollectionImportReadRequest
*/
func (a *CollectionImportAPIService) CollectionImportRead(ctx context.Context, ansibleCollectionImportHref string) CollectionImportAPICollectionImportReadRequest {
	return CollectionImportAPICollectionImportReadRequest{
		ApiService: a,
		ctx: ctx,
		ansibleCollectionImportHref: ansibleCollectionImportHref,
	}
}

// Execute executes the request
//  @return CollectionImportDetailResponse
func (a *CollectionImportAPIService) CollectionImportReadExecute(r CollectionImportAPICollectionImportReadRequest) (*CollectionImportDetailResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *CollectionImportDetailResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "CollectionImportAPIService.CollectionImportRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_collection_import_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_collection_import_href"+"}", parameterValueToString(r.ansibleCollectionImportHref, "ansibleCollectionImportHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.since != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "since", r.since, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
