/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentReleasesAPIService ContentReleasesAPI service
type ContentReleasesAPIService service

type ContentReleasesAPIContentDebReleasesCreateRequest struct {
	ctx context.Context
	ApiService *ContentReleasesAPIService
	debRelease *DebRelease
}

func (r ContentReleasesAPIContentDebReleasesCreateRequest) DebRelease(debRelease DebRelease) ContentReleasesAPIContentDebReleasesCreateRequest {
	r.debRelease = &debRelease
	return r
}

func (r ContentReleasesAPIContentDebReleasesCreateRequest) Execute() (*DebReleaseResponse, *http.Response, error) {
	return r.ApiService.ContentDebReleasesCreateExecute(r)
}

/*
ContentDebReleasesCreate Create a release

The Release contains release file fields, that are not relevant to the APT repo structure.

Associated artifacts: None; contains only metadata.

By non-structure relevant release file fields, we mean anything other than the Components and
Architectures fields. These are handled by their own models and are not part of this model.

Note that the distribution field is part of this model, but is not added to any published
release files. The "distribution" is defined as the path between 'dists/' and some 'Release'
file. As such, it encodes the path to the relevant release file within the APT repository.
It is often (but not always) equal to the "codename" or the "suite".

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentReleasesAPIContentDebReleasesCreateRequest
*/
func (a *ContentReleasesAPIService) ContentDebReleasesCreate(ctx context.Context) ContentReleasesAPIContentDebReleasesCreateRequest {
	return ContentReleasesAPIContentDebReleasesCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return DebReleaseResponse
func (a *ContentReleasesAPIService) ContentDebReleasesCreateExecute(r ContentReleasesAPIContentDebReleasesCreateRequest) (*DebReleaseResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebReleaseResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleasesAPIService.ContentDebReleasesCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/releases/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.debRelease == nil {
		return localVarReturnValue, nil, reportError("debRelease is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.debRelease
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentReleasesAPIContentDebReleasesListRequest struct {
	ctx context.Context
	ApiService *ContentReleasesAPIService
	codename *string
	distribution *string
	limit *int32
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	suite *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where codename matches value
func (r ContentReleasesAPIContentDebReleasesListRequest) Codename(codename string) ContentReleasesAPIContentDebReleasesListRequest {
	r.codename = &codename
	return r
}

// Filter results where distribution matches value
func (r ContentReleasesAPIContentDebReleasesListRequest) Distribution(distribution string) ContentReleasesAPIContentDebReleasesListRequest {
	r.distribution = &distribution
	return r
}

// Number of results to return per page.
func (r ContentReleasesAPIContentDebReleasesListRequest) Limit(limit int32) ContentReleasesAPIContentDebReleasesListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r ContentReleasesAPIContentDebReleasesListRequest) Offset(offset int32) ContentReleasesAPIContentDebReleasesListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;codename&#x60; - Codename * &#x60;-codename&#x60; - Codename (descending) * &#x60;suite&#x60; - Suite * &#x60;-suite&#x60; - Suite (descending) * &#x60;distribution&#x60; - Distribution * &#x60;-distribution&#x60; - Distribution (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentReleasesAPIContentDebReleasesListRequest) Ordering(ordering []string) ContentReleasesAPIContentDebReleasesListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentReleasesAPIContentDebReleasesListRequest) PulpHrefIn(pulpHrefIn []string) ContentReleasesAPIContentDebReleasesListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentReleasesAPIContentDebReleasesListRequest) PulpIdIn(pulpIdIn []string) ContentReleasesAPIContentDebReleasesListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository Version referenced by HREF
func (r ContentReleasesAPIContentDebReleasesListRequest) RepositoryVersion(repositoryVersion string) ContentReleasesAPIContentDebReleasesListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentReleasesAPIContentDebReleasesListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentReleasesAPIContentDebReleasesListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentReleasesAPIContentDebReleasesListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentReleasesAPIContentDebReleasesListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// Filter results where suite matches value
func (r ContentReleasesAPIContentDebReleasesListRequest) Suite(suite string) ContentReleasesAPIContentDebReleasesListRequest {
	r.suite = &suite
	return r
}

// A list of fields to include in the response.
func (r ContentReleasesAPIContentDebReleasesListRequest) Fields(fields []string) ContentReleasesAPIContentDebReleasesListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentReleasesAPIContentDebReleasesListRequest) ExcludeFields(excludeFields []string) ContentReleasesAPIContentDebReleasesListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentReleasesAPIContentDebReleasesListRequest) Execute() (*PaginateddebReleaseResponseList, *http.Response, error) {
	return r.ApiService.ContentDebReleasesListExecute(r)
}

/*
ContentDebReleasesList List releases

The Release contains release file fields, that are not relevant to the APT repo structure.

Associated artifacts: None; contains only metadata.

By non-structure relevant release file fields, we mean anything other than the Components and
Architectures fields. These are handled by their own models and are not part of this model.

Note that the distribution field is part of this model, but is not added to any published
release files. The "distribution" is defined as the path between 'dists/' and some 'Release'
file. As such, it encodes the path to the relevant release file within the APT repository.
It is often (but not always) equal to the "codename" or the "suite".

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentReleasesAPIContentDebReleasesListRequest
*/
func (a *ContentReleasesAPIService) ContentDebReleasesList(ctx context.Context) ContentReleasesAPIContentDebReleasesListRequest {
	return ContentReleasesAPIContentDebReleasesListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginateddebReleaseResponseList
func (a *ContentReleasesAPIService) ContentDebReleasesListExecute(r ContentReleasesAPIContentDebReleasesListRequest) (*PaginateddebReleaseResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginateddebReleaseResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleasesAPIService.ContentDebReleasesList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/releases/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.codename != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "codename", r.codename, "")
	}
	if r.distribution != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "distribution", r.distribution, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.suite != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "suite", r.suite, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentReleasesAPIContentDebReleasesReadRequest struct {
	ctx context.Context
	ApiService *ContentReleasesAPIService
	debReleaseHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentReleasesAPIContentDebReleasesReadRequest) Fields(fields []string) ContentReleasesAPIContentDebReleasesReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentReleasesAPIContentDebReleasesReadRequest) ExcludeFields(excludeFields []string) ContentReleasesAPIContentDebReleasesReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentReleasesAPIContentDebReleasesReadRequest) Execute() (*DebReleaseResponse, *http.Response, error) {
	return r.ApiService.ContentDebReleasesReadExecute(r)
}

/*
ContentDebReleasesRead Inspect a release

The Release contains release file fields, that are not relevant to the APT repo structure.

Associated artifacts: None; contains only metadata.

By non-structure relevant release file fields, we mean anything other than the Components and
Architectures fields. These are handled by their own models and are not part of this model.

Note that the distribution field is part of this model, but is not added to any published
release files. The "distribution" is defined as the path between 'dists/' and some 'Release'
file. As such, it encodes the path to the relevant release file within the APT repository.
It is often (but not always) equal to the "codename" or the "suite".

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debReleaseHref
 @return ContentReleasesAPIContentDebReleasesReadRequest
*/
func (a *ContentReleasesAPIService) ContentDebReleasesRead(ctx context.Context, debReleaseHref string) ContentReleasesAPIContentDebReleasesReadRequest {
	return ContentReleasesAPIContentDebReleasesReadRequest{
		ApiService: a,
		ctx: ctx,
		debReleaseHref: debReleaseHref,
	}
}

// Execute executes the request
//  @return DebReleaseResponse
func (a *ContentReleasesAPIService) ContentDebReleasesReadExecute(r ContentReleasesAPIContentDebReleasesReadRequest) (*DebReleaseResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebReleaseResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleasesAPIService.ContentDebReleasesRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_release_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_release_href"+"}", parameterValueToString(r.debReleaseHref, "debReleaseHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
