/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// UsersAPIService UsersAPI service
type UsersAPIService service

type UsersAPIUsersCreateRequest struct {
	ctx context.Context
	ApiService *UsersAPIService
	user *User
}

func (r UsersAPIUsersCreateRequest) User(user User) UsersAPIUsersCreateRequest {
	r.user = &user
	return r
}

func (r UsersAPIUsersCreateRequest) Execute() (*UserResponse, *http.Response, error) {
	return r.ApiService.UsersCreateExecute(r)
}

/*
UsersCreate Create an user

ViewSet for User.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return UsersAPIUsersCreateRequest
*/
func (a *UsersAPIService) UsersCreate(ctx context.Context) UsersAPIUsersCreateRequest {
	return UsersAPIUsersCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return UserResponse
func (a *UsersAPIService) UsersCreateExecute(r UsersAPIUsersCreateRequest) (*UserResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UserResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UsersAPIService.UsersCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/users/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.user == nil {
		return localVarReturnValue, nil, reportError("user is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.user
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UsersAPIUsersDeleteRequest struct {
	ctx context.Context
	ApiService *UsersAPIService
	authUserHref string
}

func (r UsersAPIUsersDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.UsersDeleteExecute(r)
}

/*
UsersDelete Delete an user

ViewSet for User.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param authUserHref
 @return UsersAPIUsersDeleteRequest
*/
func (a *UsersAPIService) UsersDelete(ctx context.Context, authUserHref string) UsersAPIUsersDeleteRequest {
	return UsersAPIUsersDeleteRequest{
		ApiService: a,
		ctx: ctx,
		authUserHref: authUserHref,
	}
}

// Execute executes the request
func (a *UsersAPIService) UsersDeleteExecute(r UsersAPIUsersDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UsersAPIService.UsersDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{auth_user_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"auth_user_href"+"}", parameterValueToString(r.authUserHref, "authUserHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type UsersAPIUsersListRequest struct {
	ctx context.Context
	ApiService *UsersAPIService
	email *string
	emailContains *string
	emailIcontains *string
	emailIexact *string
	emailIn *[]string
	firstName *string
	firstNameContains *string
	firstNameIcontains *string
	firstNameIexact *string
	firstNameIn *[]string
	isActive *bool
	isStaff *bool
	lastName *string
	lastNameContains *string
	lastNameIcontains *string
	lastNameIexact *string
	lastNameIn *[]string
	limit *int32
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	username *string
	usernameContains *string
	usernameIcontains *string
	usernameIexact *string
	usernameIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Filter results where email matches value
func (r UsersAPIUsersListRequest) Email(email string) UsersAPIUsersListRequest {
	r.email = &email
	return r
}

// Filter results where email contains value
func (r UsersAPIUsersListRequest) EmailContains(emailContains string) UsersAPIUsersListRequest {
	r.emailContains = &emailContains
	return r
}

// Filter results where email contains value
func (r UsersAPIUsersListRequest) EmailIcontains(emailIcontains string) UsersAPIUsersListRequest {
	r.emailIcontains = &emailIcontains
	return r
}

// Filter results where email matches value
func (r UsersAPIUsersListRequest) EmailIexact(emailIexact string) UsersAPIUsersListRequest {
	r.emailIexact = &emailIexact
	return r
}

// Filter results where email is in a comma-separated list of values
func (r UsersAPIUsersListRequest) EmailIn(emailIn []string) UsersAPIUsersListRequest {
	r.emailIn = &emailIn
	return r
}

// Filter results where first_name matches value
func (r UsersAPIUsersListRequest) FirstName(firstName string) UsersAPIUsersListRequest {
	r.firstName = &firstName
	return r
}

// Filter results where first_name contains value
func (r UsersAPIUsersListRequest) FirstNameContains(firstNameContains string) UsersAPIUsersListRequest {
	r.firstNameContains = &firstNameContains
	return r
}

// Filter results where first_name contains value
func (r UsersAPIUsersListRequest) FirstNameIcontains(firstNameIcontains string) UsersAPIUsersListRequest {
	r.firstNameIcontains = &firstNameIcontains
	return r
}

// Filter results where first_name matches value
func (r UsersAPIUsersListRequest) FirstNameIexact(firstNameIexact string) UsersAPIUsersListRequest {
	r.firstNameIexact = &firstNameIexact
	return r
}

// Filter results where first_name is in a comma-separated list of values
func (r UsersAPIUsersListRequest) FirstNameIn(firstNameIn []string) UsersAPIUsersListRequest {
	r.firstNameIn = &firstNameIn
	return r
}

// Filter results where is_active matches value
func (r UsersAPIUsersListRequest) IsActive(isActive bool) UsersAPIUsersListRequest {
	r.isActive = &isActive
	return r
}

// Filter results where is_staff matches value
func (r UsersAPIUsersListRequest) IsStaff(isStaff bool) UsersAPIUsersListRequest {
	r.isStaff = &isStaff
	return r
}

// Filter results where last_name matches value
func (r UsersAPIUsersListRequest) LastName(lastName string) UsersAPIUsersListRequest {
	r.lastName = &lastName
	return r
}

// Filter results where last_name contains value
func (r UsersAPIUsersListRequest) LastNameContains(lastNameContains string) UsersAPIUsersListRequest {
	r.lastNameContains = &lastNameContains
	return r
}

// Filter results where last_name contains value
func (r UsersAPIUsersListRequest) LastNameIcontains(lastNameIcontains string) UsersAPIUsersListRequest {
	r.lastNameIcontains = &lastNameIcontains
	return r
}

// Filter results where last_name matches value
func (r UsersAPIUsersListRequest) LastNameIexact(lastNameIexact string) UsersAPIUsersListRequest {
	r.lastNameIexact = &lastNameIexact
	return r
}

// Filter results where last_name is in a comma-separated list of values
func (r UsersAPIUsersListRequest) LastNameIn(lastNameIn []string) UsersAPIUsersListRequest {
	r.lastNameIn = &lastNameIn
	return r
}

// Number of results to return per page.
func (r UsersAPIUsersListRequest) Limit(limit int32) UsersAPIUsersListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r UsersAPIUsersListRequest) Offset(offset int32) UsersAPIUsersListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;id&#x60; - Id * &#x60;-id&#x60; - Id (descending) * &#x60;password&#x60; - Password * &#x60;-password&#x60; - Password (descending) * &#x60;last_login&#x60; - Last login * &#x60;-last_login&#x60; - Last login (descending) * &#x60;is_superuser&#x60; - Is superuser * &#x60;-is_superuser&#x60; - Is superuser (descending) * &#x60;username&#x60; - Username * &#x60;-username&#x60; - Username (descending) * &#x60;first_name&#x60; - First name * &#x60;-first_name&#x60; - First name (descending) * &#x60;last_name&#x60; - Last name * &#x60;-last_name&#x60; - Last name (descending) * &#x60;email&#x60; - Email * &#x60;-email&#x60; - Email (descending) * &#x60;is_staff&#x60; - Is staff * &#x60;-is_staff&#x60; - Is staff (descending) * &#x60;is_active&#x60; - Is active * &#x60;-is_active&#x60; - Is active (descending) * &#x60;date_joined&#x60; - Date joined * &#x60;-date_joined&#x60; - Date joined (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r UsersAPIUsersListRequest) Ordering(ordering []string) UsersAPIUsersListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r UsersAPIUsersListRequest) PulpHrefIn(pulpHrefIn []string) UsersAPIUsersListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r UsersAPIUsersListRequest) PulpIdIn(pulpIdIn []string) UsersAPIUsersListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter results where username matches value
func (r UsersAPIUsersListRequest) Username(username string) UsersAPIUsersListRequest {
	r.username = &username
	return r
}

// Filter results where username contains value
func (r UsersAPIUsersListRequest) UsernameContains(usernameContains string) UsersAPIUsersListRequest {
	r.usernameContains = &usernameContains
	return r
}

// Filter results where username contains value
func (r UsersAPIUsersListRequest) UsernameIcontains(usernameIcontains string) UsersAPIUsersListRequest {
	r.usernameIcontains = &usernameIcontains
	return r
}

// Filter results where username matches value
func (r UsersAPIUsersListRequest) UsernameIexact(usernameIexact string) UsersAPIUsersListRequest {
	r.usernameIexact = &usernameIexact
	return r
}

// Filter results where username is in a comma-separated list of values
func (r UsersAPIUsersListRequest) UsernameIn(usernameIn []string) UsersAPIUsersListRequest {
	r.usernameIn = &usernameIn
	return r
}

// A list of fields to include in the response.
func (r UsersAPIUsersListRequest) Fields(fields []string) UsersAPIUsersListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r UsersAPIUsersListRequest) ExcludeFields(excludeFields []string) UsersAPIUsersListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r UsersAPIUsersListRequest) Execute() (*PaginatedUserResponseList, *http.Response, error) {
	return r.ApiService.UsersListExecute(r)
}

/*
UsersList List users

ViewSet for User.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return UsersAPIUsersListRequest
*/
func (a *UsersAPIService) UsersList(ctx context.Context) UsersAPIUsersListRequest {
	return UsersAPIUsersListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedUserResponseList
func (a *UsersAPIService) UsersListExecute(r UsersAPIUsersListRequest) (*PaginatedUserResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedUserResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UsersAPIService.UsersList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/users/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.email != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "email", r.email, "")
	}
	if r.emailContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "email__contains", r.emailContains, "")
	}
	if r.emailIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "email__icontains", r.emailIcontains, "")
	}
	if r.emailIexact != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "email__iexact", r.emailIexact, "")
	}
	if r.emailIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "email__in", r.emailIn, "csv")
	}
	if r.firstName != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "first_name", r.firstName, "")
	}
	if r.firstNameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "first_name__contains", r.firstNameContains, "")
	}
	if r.firstNameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "first_name__icontains", r.firstNameIcontains, "")
	}
	if r.firstNameIexact != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "first_name__iexact", r.firstNameIexact, "")
	}
	if r.firstNameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "first_name__in", r.firstNameIn, "csv")
	}
	if r.isActive != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "is_active", r.isActive, "")
	}
	if r.isStaff != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "is_staff", r.isStaff, "")
	}
	if r.lastName != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "last_name", r.lastName, "")
	}
	if r.lastNameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "last_name__contains", r.lastNameContains, "")
	}
	if r.lastNameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "last_name__icontains", r.lastNameIcontains, "")
	}
	if r.lastNameIexact != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "last_name__iexact", r.lastNameIexact, "")
	}
	if r.lastNameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "last_name__in", r.lastNameIn, "csv")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.username != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "username", r.username, "")
	}
	if r.usernameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "username__contains", r.usernameContains, "")
	}
	if r.usernameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "username__icontains", r.usernameIcontains, "")
	}
	if r.usernameIexact != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "username__iexact", r.usernameIexact, "")
	}
	if r.usernameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "username__in", r.usernameIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UsersAPIUsersPartialUpdateRequest struct {
	ctx context.Context
	ApiService *UsersAPIService
	authUserHref string
	patchedUser *PatchedUser
}

func (r UsersAPIUsersPartialUpdateRequest) PatchedUser(patchedUser PatchedUser) UsersAPIUsersPartialUpdateRequest {
	r.patchedUser = &patchedUser
	return r
}

func (r UsersAPIUsersPartialUpdateRequest) Execute() (*UserResponse, *http.Response, error) {
	return r.ApiService.UsersPartialUpdateExecute(r)
}

/*
UsersPartialUpdate Update an user

ViewSet for User.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param authUserHref
 @return UsersAPIUsersPartialUpdateRequest
*/
func (a *UsersAPIService) UsersPartialUpdate(ctx context.Context, authUserHref string) UsersAPIUsersPartialUpdateRequest {
	return UsersAPIUsersPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		authUserHref: authUserHref,
	}
}

// Execute executes the request
//  @return UserResponse
func (a *UsersAPIService) UsersPartialUpdateExecute(r UsersAPIUsersPartialUpdateRequest) (*UserResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UserResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UsersAPIService.UsersPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{auth_user_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"auth_user_href"+"}", parameterValueToString(r.authUserHref, "authUserHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedUser == nil {
		return localVarReturnValue, nil, reportError("patchedUser is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedUser
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UsersAPIUsersReadRequest struct {
	ctx context.Context
	ApiService *UsersAPIService
	authUserHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r UsersAPIUsersReadRequest) Fields(fields []string) UsersAPIUsersReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r UsersAPIUsersReadRequest) ExcludeFields(excludeFields []string) UsersAPIUsersReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r UsersAPIUsersReadRequest) Execute() (*UserResponse, *http.Response, error) {
	return r.ApiService.UsersReadExecute(r)
}

/*
UsersRead Inspect an user

ViewSet for User.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param authUserHref
 @return UsersAPIUsersReadRequest
*/
func (a *UsersAPIService) UsersRead(ctx context.Context, authUserHref string) UsersAPIUsersReadRequest {
	return UsersAPIUsersReadRequest{
		ApiService: a,
		ctx: ctx,
		authUserHref: authUserHref,
	}
}

// Execute executes the request
//  @return UserResponse
func (a *UsersAPIService) UsersReadExecute(r UsersAPIUsersReadRequest) (*UserResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UserResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UsersAPIService.UsersRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{auth_user_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"auth_user_href"+"}", parameterValueToString(r.authUserHref, "authUserHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UsersAPIUsersUpdateRequest struct {
	ctx context.Context
	ApiService *UsersAPIService
	authUserHref string
	user *User
}

func (r UsersAPIUsersUpdateRequest) User(user User) UsersAPIUsersUpdateRequest {
	r.user = &user
	return r
}

func (r UsersAPIUsersUpdateRequest) Execute() (*UserResponse, *http.Response, error) {
	return r.ApiService.UsersUpdateExecute(r)
}

/*
UsersUpdate Update an user

ViewSet for User.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param authUserHref
 @return UsersAPIUsersUpdateRequest
*/
func (a *UsersAPIService) UsersUpdate(ctx context.Context, authUserHref string) UsersAPIUsersUpdateRequest {
	return UsersAPIUsersUpdateRequest{
		ApiService: a,
		ctx: ctx,
		authUserHref: authUserHref,
	}
}

// Execute executes the request
//  @return UserResponse
func (a *UsersAPIService) UsersUpdateExecute(r UsersAPIUsersUpdateRequest) (*UserResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UserResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UsersAPIService.UsersUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{auth_user_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"auth_user_href"+"}", parameterValueToString(r.authUserHref, "authUserHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.user == nil {
		return localVarReturnValue, nil, reportError("user is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.user
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
