/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the MavenMavenArtifactResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &MavenMavenArtifactResponse{}

// MavenMavenArtifactResponse A Serializer for MavenArtifact.
type MavenMavenArtifactResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// Artifact file representing the physical content
	Artifact string `json:"artifact"`
	// Group Id of the artifact's package.
	GroupId *string `json:"group_id,omitempty"`
	// Artifact Id of the artifact's package.
	ArtifactId *string `json:"artifact_id,omitempty"`
	// Version of the artifact's package.
	Version *string `json:"version,omitempty"`
	// Filename of the artifact.
	Filename *string `json:"filename,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _MavenMavenArtifactResponse MavenMavenArtifactResponse

// NewMavenMavenArtifactResponse instantiates a new MavenMavenArtifactResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewMavenMavenArtifactResponse(artifact string) *MavenMavenArtifactResponse {
	this := MavenMavenArtifactResponse{}
	this.Artifact = artifact
	return &this
}

// NewMavenMavenArtifactResponseWithDefaults instantiates a new MavenMavenArtifactResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewMavenMavenArtifactResponseWithDefaults() *MavenMavenArtifactResponse {
	this := MavenMavenArtifactResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *MavenMavenArtifactResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MavenMavenArtifactResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *MavenMavenArtifactResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *MavenMavenArtifactResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *MavenMavenArtifactResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MavenMavenArtifactResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *MavenMavenArtifactResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *MavenMavenArtifactResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetArtifact returns the Artifact field value
func (o *MavenMavenArtifactResponse) GetArtifact() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value
// and a boolean to check if the value has been set.
func (o *MavenMavenArtifactResponse) GetArtifactOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Artifact, true
}

// SetArtifact sets field value
func (o *MavenMavenArtifactResponse) SetArtifact(v string) {
	o.Artifact = v
}

// GetGroupId returns the GroupId field value if set, zero value otherwise.
func (o *MavenMavenArtifactResponse) GetGroupId() string {
	if o == nil || IsNil(o.GroupId) {
		var ret string
		return ret
	}
	return *o.GroupId
}

// GetGroupIdOk returns a tuple with the GroupId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MavenMavenArtifactResponse) GetGroupIdOk() (*string, bool) {
	if o == nil || IsNil(o.GroupId) {
		return nil, false
	}
	return o.GroupId, true
}

// HasGroupId returns a boolean if a field has been set.
func (o *MavenMavenArtifactResponse) HasGroupId() bool {
	if o != nil && !IsNil(o.GroupId) {
		return true
	}

	return false
}

// SetGroupId gets a reference to the given string and assigns it to the GroupId field.
func (o *MavenMavenArtifactResponse) SetGroupId(v string) {
	o.GroupId = &v
}

// GetArtifactId returns the ArtifactId field value if set, zero value otherwise.
func (o *MavenMavenArtifactResponse) GetArtifactId() string {
	if o == nil || IsNil(o.ArtifactId) {
		var ret string
		return ret
	}
	return *o.ArtifactId
}

// GetArtifactIdOk returns a tuple with the ArtifactId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MavenMavenArtifactResponse) GetArtifactIdOk() (*string, bool) {
	if o == nil || IsNil(o.ArtifactId) {
		return nil, false
	}
	return o.ArtifactId, true
}

// HasArtifactId returns a boolean if a field has been set.
func (o *MavenMavenArtifactResponse) HasArtifactId() bool {
	if o != nil && !IsNil(o.ArtifactId) {
		return true
	}

	return false
}

// SetArtifactId gets a reference to the given string and assigns it to the ArtifactId field.
func (o *MavenMavenArtifactResponse) SetArtifactId(v string) {
	o.ArtifactId = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *MavenMavenArtifactResponse) GetVersion() string {
	if o == nil || IsNil(o.Version) {
		var ret string
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MavenMavenArtifactResponse) GetVersionOk() (*string, bool) {
	if o == nil || IsNil(o.Version) {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *MavenMavenArtifactResponse) HasVersion() bool {
	if o != nil && !IsNil(o.Version) {
		return true
	}

	return false
}

// SetVersion gets a reference to the given string and assigns it to the Version field.
func (o *MavenMavenArtifactResponse) SetVersion(v string) {
	o.Version = &v
}

// GetFilename returns the Filename field value if set, zero value otherwise.
func (o *MavenMavenArtifactResponse) GetFilename() string {
	if o == nil || IsNil(o.Filename) {
		var ret string
		return ret
	}
	return *o.Filename
}

// GetFilenameOk returns a tuple with the Filename field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MavenMavenArtifactResponse) GetFilenameOk() (*string, bool) {
	if o == nil || IsNil(o.Filename) {
		return nil, false
	}
	return o.Filename, true
}

// HasFilename returns a boolean if a field has been set.
func (o *MavenMavenArtifactResponse) HasFilename() bool {
	if o != nil && !IsNil(o.Filename) {
		return true
	}

	return false
}

// SetFilename gets a reference to the given string and assigns it to the Filename field.
func (o *MavenMavenArtifactResponse) SetFilename(v string) {
	o.Filename = &v
}

func (o MavenMavenArtifactResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o MavenMavenArtifactResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["artifact"] = o.Artifact
	if !IsNil(o.GroupId) {
		toSerialize["group_id"] = o.GroupId
	}
	if !IsNil(o.ArtifactId) {
		toSerialize["artifact_id"] = o.ArtifactId
	}
	if !IsNil(o.Version) {
		toSerialize["version"] = o.Version
	}
	if !IsNil(o.Filename) {
		toSerialize["filename"] = o.Filename
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *MavenMavenArtifactResponse) UnmarshalJSON(bytes []byte) (err error) {
	varMavenMavenArtifactResponse := _MavenMavenArtifactResponse{}

	if err = json.Unmarshal(bytes, &varMavenMavenArtifactResponse); err == nil {
		*o = MavenMavenArtifactResponse(varMavenMavenArtifactResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "group_id")
		delete(additionalProperties, "artifact_id")
		delete(additionalProperties, "version")
		delete(additionalProperties, "filename")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableMavenMavenArtifactResponse struct {
	value *MavenMavenArtifactResponse
	isSet bool
}

func (v NullableMavenMavenArtifactResponse) Get() *MavenMavenArtifactResponse {
	return v.value
}

func (v *NullableMavenMavenArtifactResponse) Set(val *MavenMavenArtifactResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableMavenMavenArtifactResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableMavenMavenArtifactResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableMavenMavenArtifactResponse(val *MavenMavenArtifactResponse) *NullableMavenMavenArtifactResponse {
	return &NullableMavenMavenArtifactResponse{value: val, isSet: true}
}

func (v NullableMavenMavenArtifactResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableMavenMavenArtifactResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


