/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the PulpExport type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PulpExport{}

// PulpExport Serializer for PulpExports.
type PulpExport struct {
	// A URI of the task that ran the Export.
	Task NullableString `json:"task,omitempty"`
	// Do a Full (true) or Incremental (false) export.
	Full *bool `json:"full,omitempty"`
	// Generate report on what would be exported and disk-space required.
	DryRun *bool `json:"dry_run,omitempty"`
	// List of explicit repo-version hrefs to export (replaces current_version).
	Versions []string `json:"versions,omitempty"`
	// Chunk export-tarfile into pieces of chunk_size bytes. Recognizes units of B/KB/MB/GB/TB. A chunk has a maximum size of 1TB.
	ChunkSize *string `json:"chunk_size,omitempty"`
	// List of explicit last-exported-repo-version hrefs (replaces last_export).
	StartVersions []string `json:"start_versions,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PulpExport PulpExport

// NewPulpExport instantiates a new PulpExport object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPulpExport() *PulpExport {
	this := PulpExport{}
	var full bool = true
	this.Full = &full
	var dryRun bool = false
	this.DryRun = &dryRun
	return &this
}

// NewPulpExportWithDefaults instantiates a new PulpExport object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPulpExportWithDefaults() *PulpExport {
	this := PulpExport{}
	var full bool = true
	this.Full = &full
	var dryRun bool = false
	this.DryRun = &dryRun
	return &this
}

// GetTask returns the Task field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PulpExport) GetTask() string {
	if o == nil || IsNil(o.Task.Get()) {
		var ret string
		return ret
	}
	return *o.Task.Get()
}

// GetTaskOk returns a tuple with the Task field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PulpExport) GetTaskOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Task.Get(), o.Task.IsSet()
}

// HasTask returns a boolean if a field has been set.
func (o *PulpExport) HasTask() bool {
	if o != nil && o.Task.IsSet() {
		return true
	}

	return false
}

// SetTask gets a reference to the given NullableString and assigns it to the Task field.
func (o *PulpExport) SetTask(v string) {
	o.Task.Set(&v)
}
// SetTaskNil sets the value for Task to be an explicit nil
func (o *PulpExport) SetTaskNil() {
	o.Task.Set(nil)
}

// UnsetTask ensures that no value is present for Task, not even an explicit nil
func (o *PulpExport) UnsetTask() {
	o.Task.Unset()
}

// GetFull returns the Full field value if set, zero value otherwise.
func (o *PulpExport) GetFull() bool {
	if o == nil || IsNil(o.Full) {
		var ret bool
		return ret
	}
	return *o.Full
}

// GetFullOk returns a tuple with the Full field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpExport) GetFullOk() (*bool, bool) {
	if o == nil || IsNil(o.Full) {
		return nil, false
	}
	return o.Full, true
}

// HasFull returns a boolean if a field has been set.
func (o *PulpExport) HasFull() bool {
	if o != nil && !IsNil(o.Full) {
		return true
	}

	return false
}

// SetFull gets a reference to the given bool and assigns it to the Full field.
func (o *PulpExport) SetFull(v bool) {
	o.Full = &v
}

// GetDryRun returns the DryRun field value if set, zero value otherwise.
func (o *PulpExport) GetDryRun() bool {
	if o == nil || IsNil(o.DryRun) {
		var ret bool
		return ret
	}
	return *o.DryRun
}

// GetDryRunOk returns a tuple with the DryRun field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpExport) GetDryRunOk() (*bool, bool) {
	if o == nil || IsNil(o.DryRun) {
		return nil, false
	}
	return o.DryRun, true
}

// HasDryRun returns a boolean if a field has been set.
func (o *PulpExport) HasDryRun() bool {
	if o != nil && !IsNil(o.DryRun) {
		return true
	}

	return false
}

// SetDryRun gets a reference to the given bool and assigns it to the DryRun field.
func (o *PulpExport) SetDryRun(v bool) {
	o.DryRun = &v
}

// GetVersions returns the Versions field value if set, zero value otherwise.
func (o *PulpExport) GetVersions() []string {
	if o == nil || IsNil(o.Versions) {
		var ret []string
		return ret
	}
	return o.Versions
}

// GetVersionsOk returns a tuple with the Versions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpExport) GetVersionsOk() ([]string, bool) {
	if o == nil || IsNil(o.Versions) {
		return nil, false
	}
	return o.Versions, true
}

// HasVersions returns a boolean if a field has been set.
func (o *PulpExport) HasVersions() bool {
	if o != nil && !IsNil(o.Versions) {
		return true
	}

	return false
}

// SetVersions gets a reference to the given []string and assigns it to the Versions field.
func (o *PulpExport) SetVersions(v []string) {
	o.Versions = v
}

// GetChunkSize returns the ChunkSize field value if set, zero value otherwise.
func (o *PulpExport) GetChunkSize() string {
	if o == nil || IsNil(o.ChunkSize) {
		var ret string
		return ret
	}
	return *o.ChunkSize
}

// GetChunkSizeOk returns a tuple with the ChunkSize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpExport) GetChunkSizeOk() (*string, bool) {
	if o == nil || IsNil(o.ChunkSize) {
		return nil, false
	}
	return o.ChunkSize, true
}

// HasChunkSize returns a boolean if a field has been set.
func (o *PulpExport) HasChunkSize() bool {
	if o != nil && !IsNil(o.ChunkSize) {
		return true
	}

	return false
}

// SetChunkSize gets a reference to the given string and assigns it to the ChunkSize field.
func (o *PulpExport) SetChunkSize(v string) {
	o.ChunkSize = &v
}

// GetStartVersions returns the StartVersions field value if set, zero value otherwise.
func (o *PulpExport) GetStartVersions() []string {
	if o == nil || IsNil(o.StartVersions) {
		var ret []string
		return ret
	}
	return o.StartVersions
}

// GetStartVersionsOk returns a tuple with the StartVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpExport) GetStartVersionsOk() ([]string, bool) {
	if o == nil || IsNil(o.StartVersions) {
		return nil, false
	}
	return o.StartVersions, true
}

// HasStartVersions returns a boolean if a field has been set.
func (o *PulpExport) HasStartVersions() bool {
	if o != nil && !IsNil(o.StartVersions) {
		return true
	}

	return false
}

// SetStartVersions gets a reference to the given []string and assigns it to the StartVersions field.
func (o *PulpExport) SetStartVersions(v []string) {
	o.StartVersions = v
}

func (o PulpExport) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PulpExport) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if o.Task.IsSet() {
		toSerialize["task"] = o.Task.Get()
	}
	if !IsNil(o.Full) {
		toSerialize["full"] = o.Full
	}
	if !IsNil(o.DryRun) {
		toSerialize["dry_run"] = o.DryRun
	}
	if !IsNil(o.Versions) {
		toSerialize["versions"] = o.Versions
	}
	if !IsNil(o.ChunkSize) {
		toSerialize["chunk_size"] = o.ChunkSize
	}
	if !IsNil(o.StartVersions) {
		toSerialize["start_versions"] = o.StartVersions
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PulpExport) UnmarshalJSON(bytes []byte) (err error) {
	varPulpExport := _PulpExport{}

	if err = json.Unmarshal(bytes, &varPulpExport); err == nil {
		*o = PulpExport(varPulpExport)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "task")
		delete(additionalProperties, "full")
		delete(additionalProperties, "dry_run")
		delete(additionalProperties, "versions")
		delete(additionalProperties, "chunk_size")
		delete(additionalProperties, "start_versions")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePulpExport struct {
	value *PulpExport
	isSet bool
}

func (v NullablePulpExport) Get() *PulpExport {
	return v.value
}

func (v *NullablePulpExport) Set(val *PulpExport) {
	v.value = val
	v.isSet = true
}

func (v NullablePulpExport) IsSet() bool {
	return v.isSet
}

func (v *NullablePulpExport) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePulpExport(val *PulpExport) *NullablePulpExport {
	return &NullablePulpExport{value: val, isSet: true}
}

func (v NullablePulpExport) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePulpExport) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


