/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the AnsibleAnsibleRepository type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AnsibleAnsibleRepository{}

// AnsibleAnsibleRepository Serializer for Ansible Repositories.
type AnsibleAnsibleRepository struct {
	PulpLabels *map[string]string `json:"pulp_labels,omitempty"`
	// A unique name for this repository.
	Name string `json:"name"`
	// An optional description.
	Description NullableString `json:"description,omitempty"`
	// Retain X versions of the repository. Default is null which retains all versions.
	RetainRepoVersions NullableInt64 `json:"retain_repo_versions,omitempty"`
	// An optional remote to use by default when syncing.
	Remote NullableString `json:"remote,omitempty"`
	// Last synced metadata time.
	LastSyncedMetadataTime NullableTime `json:"last_synced_metadata_time,omitempty"`
	// Gpg public key to verify collection signatures against
	Gpgkey NullableString `json:"gpgkey,omitempty"`
	Private *bool `json:"private,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _AnsibleAnsibleRepository AnsibleAnsibleRepository

// NewAnsibleAnsibleRepository instantiates a new AnsibleAnsibleRepository object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAnsibleAnsibleRepository(name string) *AnsibleAnsibleRepository {
	this := AnsibleAnsibleRepository{}
	this.Name = name
	return &this
}

// NewAnsibleAnsibleRepositoryWithDefaults instantiates a new AnsibleAnsibleRepository object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAnsibleAnsibleRepositoryWithDefaults() *AnsibleAnsibleRepository {
	this := AnsibleAnsibleRepository{}
	return &this
}

// GetPulpLabels returns the PulpLabels field value if set, zero value otherwise.
func (o *AnsibleAnsibleRepository) GetPulpLabels() map[string]string {
	if o == nil || IsNil(o.PulpLabels) {
		var ret map[string]string
		return ret
	}
	return *o.PulpLabels
}

// GetPulpLabelsOk returns a tuple with the PulpLabels field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AnsibleAnsibleRepository) GetPulpLabelsOk() (*map[string]string, bool) {
	if o == nil || IsNil(o.PulpLabels) {
		return nil, false
	}
	return o.PulpLabels, true
}

// HasPulpLabels returns a boolean if a field has been set.
func (o *AnsibleAnsibleRepository) HasPulpLabels() bool {
	if o != nil && !IsNil(o.PulpLabels) {
		return true
	}

	return false
}

// SetPulpLabels gets a reference to the given map[string]string and assigns it to the PulpLabels field.
func (o *AnsibleAnsibleRepository) SetPulpLabels(v map[string]string) {
	o.PulpLabels = &v
}

// GetName returns the Name field value
func (o *AnsibleAnsibleRepository) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *AnsibleAnsibleRepository) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *AnsibleAnsibleRepository) SetName(v string) {
	o.Name = v
}

// GetDescription returns the Description field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *AnsibleAnsibleRepository) GetDescription() string {
	if o == nil || IsNil(o.Description.Get()) {
		var ret string
		return ret
	}
	return *o.Description.Get()
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *AnsibleAnsibleRepository) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Description.Get(), o.Description.IsSet()
}

// HasDescription returns a boolean if a field has been set.
func (o *AnsibleAnsibleRepository) HasDescription() bool {
	if o != nil && o.Description.IsSet() {
		return true
	}

	return false
}

// SetDescription gets a reference to the given NullableString and assigns it to the Description field.
func (o *AnsibleAnsibleRepository) SetDescription(v string) {
	o.Description.Set(&v)
}
// SetDescriptionNil sets the value for Description to be an explicit nil
func (o *AnsibleAnsibleRepository) SetDescriptionNil() {
	o.Description.Set(nil)
}

// UnsetDescription ensures that no value is present for Description, not even an explicit nil
func (o *AnsibleAnsibleRepository) UnsetDescription() {
	o.Description.Unset()
}

// GetRetainRepoVersions returns the RetainRepoVersions field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *AnsibleAnsibleRepository) GetRetainRepoVersions() int64 {
	if o == nil || IsNil(o.RetainRepoVersions.Get()) {
		var ret int64
		return ret
	}
	return *o.RetainRepoVersions.Get()
}

// GetRetainRepoVersionsOk returns a tuple with the RetainRepoVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *AnsibleAnsibleRepository) GetRetainRepoVersionsOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.RetainRepoVersions.Get(), o.RetainRepoVersions.IsSet()
}

// HasRetainRepoVersions returns a boolean if a field has been set.
func (o *AnsibleAnsibleRepository) HasRetainRepoVersions() bool {
	if o != nil && o.RetainRepoVersions.IsSet() {
		return true
	}

	return false
}

// SetRetainRepoVersions gets a reference to the given NullableInt64 and assigns it to the RetainRepoVersions field.
func (o *AnsibleAnsibleRepository) SetRetainRepoVersions(v int64) {
	o.RetainRepoVersions.Set(&v)
}
// SetRetainRepoVersionsNil sets the value for RetainRepoVersions to be an explicit nil
func (o *AnsibleAnsibleRepository) SetRetainRepoVersionsNil() {
	o.RetainRepoVersions.Set(nil)
}

// UnsetRetainRepoVersions ensures that no value is present for RetainRepoVersions, not even an explicit nil
func (o *AnsibleAnsibleRepository) UnsetRetainRepoVersions() {
	o.RetainRepoVersions.Unset()
}

// GetRemote returns the Remote field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *AnsibleAnsibleRepository) GetRemote() string {
	if o == nil || IsNil(o.Remote.Get()) {
		var ret string
		return ret
	}
	return *o.Remote.Get()
}

// GetRemoteOk returns a tuple with the Remote field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *AnsibleAnsibleRepository) GetRemoteOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Remote.Get(), o.Remote.IsSet()
}

// HasRemote returns a boolean if a field has been set.
func (o *AnsibleAnsibleRepository) HasRemote() bool {
	if o != nil && o.Remote.IsSet() {
		return true
	}

	return false
}

// SetRemote gets a reference to the given NullableString and assigns it to the Remote field.
func (o *AnsibleAnsibleRepository) SetRemote(v string) {
	o.Remote.Set(&v)
}
// SetRemoteNil sets the value for Remote to be an explicit nil
func (o *AnsibleAnsibleRepository) SetRemoteNil() {
	o.Remote.Set(nil)
}

// UnsetRemote ensures that no value is present for Remote, not even an explicit nil
func (o *AnsibleAnsibleRepository) UnsetRemote() {
	o.Remote.Unset()
}

// GetLastSyncedMetadataTime returns the LastSyncedMetadataTime field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *AnsibleAnsibleRepository) GetLastSyncedMetadataTime() time.Time {
	if o == nil || IsNil(o.LastSyncedMetadataTime.Get()) {
		var ret time.Time
		return ret
	}
	return *o.LastSyncedMetadataTime.Get()
}

// GetLastSyncedMetadataTimeOk returns a tuple with the LastSyncedMetadataTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *AnsibleAnsibleRepository) GetLastSyncedMetadataTimeOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastSyncedMetadataTime.Get(), o.LastSyncedMetadataTime.IsSet()
}

// HasLastSyncedMetadataTime returns a boolean if a field has been set.
func (o *AnsibleAnsibleRepository) HasLastSyncedMetadataTime() bool {
	if o != nil && o.LastSyncedMetadataTime.IsSet() {
		return true
	}

	return false
}

// SetLastSyncedMetadataTime gets a reference to the given NullableTime and assigns it to the LastSyncedMetadataTime field.
func (o *AnsibleAnsibleRepository) SetLastSyncedMetadataTime(v time.Time) {
	o.LastSyncedMetadataTime.Set(&v)
}
// SetLastSyncedMetadataTimeNil sets the value for LastSyncedMetadataTime to be an explicit nil
func (o *AnsibleAnsibleRepository) SetLastSyncedMetadataTimeNil() {
	o.LastSyncedMetadataTime.Set(nil)
}

// UnsetLastSyncedMetadataTime ensures that no value is present for LastSyncedMetadataTime, not even an explicit nil
func (o *AnsibleAnsibleRepository) UnsetLastSyncedMetadataTime() {
	o.LastSyncedMetadataTime.Unset()
}

// GetGpgkey returns the Gpgkey field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *AnsibleAnsibleRepository) GetGpgkey() string {
	if o == nil || IsNil(o.Gpgkey.Get()) {
		var ret string
		return ret
	}
	return *o.Gpgkey.Get()
}

// GetGpgkeyOk returns a tuple with the Gpgkey field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *AnsibleAnsibleRepository) GetGpgkeyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Gpgkey.Get(), o.Gpgkey.IsSet()
}

// HasGpgkey returns a boolean if a field has been set.
func (o *AnsibleAnsibleRepository) HasGpgkey() bool {
	if o != nil && o.Gpgkey.IsSet() {
		return true
	}

	return false
}

// SetGpgkey gets a reference to the given NullableString and assigns it to the Gpgkey field.
func (o *AnsibleAnsibleRepository) SetGpgkey(v string) {
	o.Gpgkey.Set(&v)
}
// SetGpgkeyNil sets the value for Gpgkey to be an explicit nil
func (o *AnsibleAnsibleRepository) SetGpgkeyNil() {
	o.Gpgkey.Set(nil)
}

// UnsetGpgkey ensures that no value is present for Gpgkey, not even an explicit nil
func (o *AnsibleAnsibleRepository) UnsetGpgkey() {
	o.Gpgkey.Unset()
}

// GetPrivate returns the Private field value if set, zero value otherwise.
func (o *AnsibleAnsibleRepository) GetPrivate() bool {
	if o == nil || IsNil(o.Private) {
		var ret bool
		return ret
	}
	return *o.Private
}

// GetPrivateOk returns a tuple with the Private field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AnsibleAnsibleRepository) GetPrivateOk() (*bool, bool) {
	if o == nil || IsNil(o.Private) {
		return nil, false
	}
	return o.Private, true
}

// HasPrivate returns a boolean if a field has been set.
func (o *AnsibleAnsibleRepository) HasPrivate() bool {
	if o != nil && !IsNil(o.Private) {
		return true
	}

	return false
}

// SetPrivate gets a reference to the given bool and assigns it to the Private field.
func (o *AnsibleAnsibleRepository) SetPrivate(v bool) {
	o.Private = &v
}

func (o AnsibleAnsibleRepository) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AnsibleAnsibleRepository) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpLabels) {
		toSerialize["pulp_labels"] = o.PulpLabels
	}
	toSerialize["name"] = o.Name
	if o.Description.IsSet() {
		toSerialize["description"] = o.Description.Get()
	}
	if o.RetainRepoVersions.IsSet() {
		toSerialize["retain_repo_versions"] = o.RetainRepoVersions.Get()
	}
	if o.Remote.IsSet() {
		toSerialize["remote"] = o.Remote.Get()
	}
	if o.LastSyncedMetadataTime.IsSet() {
		toSerialize["last_synced_metadata_time"] = o.LastSyncedMetadataTime.Get()
	}
	if o.Gpgkey.IsSet() {
		toSerialize["gpgkey"] = o.Gpgkey.Get()
	}
	if !IsNil(o.Private) {
		toSerialize["private"] = o.Private
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AnsibleAnsibleRepository) UnmarshalJSON(bytes []byte) (err error) {
	varAnsibleAnsibleRepository := _AnsibleAnsibleRepository{}

	if err = json.Unmarshal(bytes, &varAnsibleAnsibleRepository); err == nil {
		*o = AnsibleAnsibleRepository(varAnsibleAnsibleRepository)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_labels")
		delete(additionalProperties, "name")
		delete(additionalProperties, "description")
		delete(additionalProperties, "retain_repo_versions")
		delete(additionalProperties, "remote")
		delete(additionalProperties, "last_synced_metadata_time")
		delete(additionalProperties, "gpgkey")
		delete(additionalProperties, "private")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAnsibleAnsibleRepository struct {
	value *AnsibleAnsibleRepository
	isSet bool
}

func (v NullableAnsibleAnsibleRepository) Get() *AnsibleAnsibleRepository {
	return v.value
}

func (v *NullableAnsibleAnsibleRepository) Set(val *AnsibleAnsibleRepository) {
	v.value = val
	v.isSet = true
}

func (v NullableAnsibleAnsibleRepository) IsSet() bool {
	return v.isSet
}

func (v *NullableAnsibleAnsibleRepository) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAnsibleAnsibleRepository(val *AnsibleAnsibleRepository) *NullableAnsibleAnsibleRepository {
	return &NullableAnsibleAnsibleRepository{value: val, isSet: true}
}

func (v NullableAnsibleAnsibleRepository) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAnsibleAnsibleRepository) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


