/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the FileFilePublicationResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &FileFilePublicationResponse{}

// FileFilePublicationResponse Serializer for File Publications.
type FileFilePublicationResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	RepositoryVersion *string `json:"repository_version,omitempty"`
	// A URI of the repository to be published.
	Repository *string `json:"repository,omitempty"`
	// This publication is currently hosted as defined by these distributions.
	Distributions []string `json:"distributions,omitempty"`
	// Filename to use for manifest file containing metadata for all the files.
	Manifest NullableString `json:"manifest,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _FileFilePublicationResponse FileFilePublicationResponse

// NewFileFilePublicationResponse instantiates a new FileFilePublicationResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewFileFilePublicationResponse() *FileFilePublicationResponse {
	this := FileFilePublicationResponse{}
	var manifest string = "PULP_MANIFEST"
	this.Manifest = *NewNullableString(&manifest)
	return &this
}

// NewFileFilePublicationResponseWithDefaults instantiates a new FileFilePublicationResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewFileFilePublicationResponseWithDefaults() *FileFilePublicationResponse {
	this := FileFilePublicationResponse{}
	var manifest string = "PULP_MANIFEST"
	this.Manifest = *NewNullableString(&manifest)
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *FileFilePublicationResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *FileFilePublicationResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *FileFilePublicationResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *FileFilePublicationResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *FileFilePublicationResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *FileFilePublicationResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *FileFilePublicationResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *FileFilePublicationResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetRepositoryVersion returns the RepositoryVersion field value if set, zero value otherwise.
func (o *FileFilePublicationResponse) GetRepositoryVersion() string {
	if o == nil || IsNil(o.RepositoryVersion) {
		var ret string
		return ret
	}
	return *o.RepositoryVersion
}

// GetRepositoryVersionOk returns a tuple with the RepositoryVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *FileFilePublicationResponse) GetRepositoryVersionOk() (*string, bool) {
	if o == nil || IsNil(o.RepositoryVersion) {
		return nil, false
	}
	return o.RepositoryVersion, true
}

// HasRepositoryVersion returns a boolean if a field has been set.
func (o *FileFilePublicationResponse) HasRepositoryVersion() bool {
	if o != nil && !IsNil(o.RepositoryVersion) {
		return true
	}

	return false
}

// SetRepositoryVersion gets a reference to the given string and assigns it to the RepositoryVersion field.
func (o *FileFilePublicationResponse) SetRepositoryVersion(v string) {
	o.RepositoryVersion = &v
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *FileFilePublicationResponse) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *FileFilePublicationResponse) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *FileFilePublicationResponse) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *FileFilePublicationResponse) SetRepository(v string) {
	o.Repository = &v
}

// GetDistributions returns the Distributions field value if set, zero value otherwise.
func (o *FileFilePublicationResponse) GetDistributions() []string {
	if o == nil || IsNil(o.Distributions) {
		var ret []string
		return ret
	}
	return o.Distributions
}

// GetDistributionsOk returns a tuple with the Distributions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *FileFilePublicationResponse) GetDistributionsOk() ([]string, bool) {
	if o == nil || IsNil(o.Distributions) {
		return nil, false
	}
	return o.Distributions, true
}

// HasDistributions returns a boolean if a field has been set.
func (o *FileFilePublicationResponse) HasDistributions() bool {
	if o != nil && !IsNil(o.Distributions) {
		return true
	}

	return false
}

// SetDistributions gets a reference to the given []string and assigns it to the Distributions field.
func (o *FileFilePublicationResponse) SetDistributions(v []string) {
	o.Distributions = v
}

// GetManifest returns the Manifest field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *FileFilePublicationResponse) GetManifest() string {
	if o == nil || IsNil(o.Manifest.Get()) {
		var ret string
		return ret
	}
	return *o.Manifest.Get()
}

// GetManifestOk returns a tuple with the Manifest field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *FileFilePublicationResponse) GetManifestOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Manifest.Get(), o.Manifest.IsSet()
}

// HasManifest returns a boolean if a field has been set.
func (o *FileFilePublicationResponse) HasManifest() bool {
	if o != nil && o.Manifest.IsSet() {
		return true
	}

	return false
}

// SetManifest gets a reference to the given NullableString and assigns it to the Manifest field.
func (o *FileFilePublicationResponse) SetManifest(v string) {
	o.Manifest.Set(&v)
}
// SetManifestNil sets the value for Manifest to be an explicit nil
func (o *FileFilePublicationResponse) SetManifestNil() {
	o.Manifest.Set(nil)
}

// UnsetManifest ensures that no value is present for Manifest, not even an explicit nil
func (o *FileFilePublicationResponse) UnsetManifest() {
	o.Manifest.Unset()
}

func (o FileFilePublicationResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o FileFilePublicationResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	if !IsNil(o.RepositoryVersion) {
		toSerialize["repository_version"] = o.RepositoryVersion
	}
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	if !IsNil(o.Distributions) {
		toSerialize["distributions"] = o.Distributions
	}
	if o.Manifest.IsSet() {
		toSerialize["manifest"] = o.Manifest.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *FileFilePublicationResponse) UnmarshalJSON(bytes []byte) (err error) {
	varFileFilePublicationResponse := _FileFilePublicationResponse{}

	if err = json.Unmarshal(bytes, &varFileFilePublicationResponse); err == nil {
		*o = FileFilePublicationResponse(varFileFilePublicationResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "repository_version")
		delete(additionalProperties, "repository")
		delete(additionalProperties, "distributions")
		delete(additionalProperties, "manifest")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableFileFilePublicationResponse struct {
	value *FileFilePublicationResponse
	isSet bool
}

func (v NullableFileFilePublicationResponse) Get() *FileFilePublicationResponse {
	return v.value
}

func (v *NullableFileFilePublicationResponse) Set(val *FileFilePublicationResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableFileFilePublicationResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableFileFilePublicationResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableFileFilePublicationResponse(val *FileFilePublicationResponse) *NullableFileFilePublicationResponse {
	return &NullableFileFilePublicationResponse{value: val, isSet: true}
}

func (v NullableFileFilePublicationResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableFileFilePublicationResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


