/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CAService;
import com.netscape.ca.CASigningUnit;
import com.netscape.ca.CRLConfig;
import com.netscape.ca.CRLExtensionConfig;
import com.netscape.ca.CRLExtensionsConfig;
import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.CRLIssuingPointConfig;
import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.BadRequestDataException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CADisabledException;
import com.netscape.certsrv.ca.CAEnabledException;
import com.netscape.certsrv.ca.CAMissingCertException;
import com.netscape.certsrv.ca.CAMissingKeyException;
import com.netscape.certsrv.ca.CANotFoundException;
import com.netscape.certsrv.ca.CANotLeafException;
import com.netscape.certsrv.ca.CATypeException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CRLSigningInfoEvent;
import com.netscape.certsrv.logging.event.CertSigningInfoEvent;
import com.netscape.certsrv.logging.event.OCSPSigningInfoEvent;
import com.netscape.certsrv.ocsp.IOCSPService;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.certsrv.security.SigningUnitConfig;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.servlet.cert.CertEnrollmentRequestFactory;
import com.netscape.cms.servlet.cert.EnrollmentProcessor;
import com.netscape.cms.servlet.cert.RenewalProcessor;
import com.netscape.cms.servlet.cert.RevocationProcessor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.util.StatsSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.ocsp.BasicOCSPResponse;
import com.netscape.cmsutil.ocsp.CertID;
import com.netscape.cmsutil.ocsp.CertStatus;
import com.netscape.cmsutil.ocsp.GoodInfo;
import com.netscape.cmsutil.ocsp.KeyHashID;
import com.netscape.cmsutil.ocsp.NameID;
import com.netscape.cmsutil.ocsp.OCSPRequest;
import com.netscape.cmsutil.ocsp.OCSPResponse;
import com.netscape.cmsutil.ocsp.OCSPResponseStatus;
import com.netscape.cmsutil.ocsp.Request;
import com.netscape.cmsutil.ocsp.ResponderID;
import com.netscape.cmsutil.ocsp.ResponseBytes;
import com.netscape.cmsutil.ocsp.ResponseData;
import com.netscape.cmsutil.ocsp.RevokedInfo;
import com.netscape.cmsutil.ocsp.SingleResponse;
import com.netscape.cmsutil.ocsp.TBSRequest;
import com.netscape.cmsutil.ocsp.UnknownInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.interfaces.RSAKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NicknameConflictException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.UserCertConflictException;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X500Signer;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateAuthority
extends Subsystem
implements IAuthority,
IOCSPService {
    public static final Logger logger = LoggerFactory.getLogger(CertificateAuthority.class);
    public static final String ID = "ca";
    public static final String PROP_REGISTRATION = "Registration";
    public static final String PROP_POLICY = "Policy";
    public static final String PROP_GATEWAY = "gateway";
    public static final String PROP_CLASS = "class";
    public static final String PROP_TYPE = "type";
    public static final String PROP_IMPL = "impl";
    public static final String PROP_PLUGIN = "plugin";
    public static final String PROP_INSTANCE = "instance";
    public static final String PROP_LISTENER_SUBSTORE = "listener";
    public static final String PROP_LDAP_PUBLISH_SUBSTORE = "ldappublish";
    public static final String PROP_ENABLE_PUBLISH = "enablePublish";
    public static final String PROP_ENABLE_LDAP_PUBLISH = "enableLdapPublish";
    public static final String PROP_X509CERT_VERSION = "X509CertVersion";
    public static final String PROP_ENABLE_PAST_CATIME = "enablePastCATime";
    public static final String PROP_ENABLE_PAST_CATIME_CACERT = "enablePastCATime_caCert";
    public static final String PROP_DEF_VALIDITY = "DefaultIssueValidity";
    public static final String PROP_FAST_SIGNING = "fastSigning";
    public static final String PROP_ENABLE_ADMIN_ENROLL = "enableAdminEnroll";
    public static final String PROP_CRL_PAGE_SIZE = "pageSize";
    public static final String PROP_MASTER_CRL = "MasterCRL";
    public static final String PROP_NOTIFY_SUBSTORE = "notification";
    public static final String PROP_CERT_ISSUED_SUBSTORE = "certIssued";
    public static final String PROP_CERT_REVOKED_SUBSTORE = "certRevoked";
    public static final String PROP_REQ_IN_Q_SUBSTORE = "requestInQ";
    public static final String PROP_PUB_QUEUE_SUBSTORE = "publishingQueue";
    public static final String PROP_ISSUER_NAME = "name";
    public static final String PROP_CA_NAMES = "CAs";
    public static final String PROP_ENABLE_OCSP = "ocsp";
    public static final String PROP_ID = "id";
    public static final String OFFICIAL_NAME = "Certificate Manager";
    public static final OBJECT_IDENTIFIER OCSP_NONCE = new OBJECT_IDENTIFIER("1.3.6.1.5.5.7.48.1.2");
    public static final int FASTSIGNING_DISABLED = 0;
    public static final int FASTSIGNING_ENABLED = 1;
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long YEAR = 31536000000L;
    protected boolean hostCA;
    protected AuthorityID authorityID = null;
    protected AuthorityID authorityParentID = null;
    protected BigInteger authoritySerial = null;
    protected String authorityDescription = null;
    protected Collection<String> authorityKeyHosts = null;
    protected boolean authorityEnabled = true;
    private boolean hasKeys = false;
    ECAException signingUnitException = null;
    protected CAConfig mConfig;
    protected CASigningUnit mSigningUnit;
    protected CASigningUnit mOCSPSigningUnit;
    protected CASigningUnit mCRLSigningUnit;
    protected CertificateIssuerName mIssuerObj = null;
    protected CertificateSubjectName mSubjectObj = null;
    protected X500Name mName = null;
    protected String mNickname = null;
    protected long mCertSerialNumberCounter = System.currentTimeMillis();
    protected long mRequestID = System.currentTimeMillis();
    protected String[] mAllowedSignAlgors = null;
    protected String[] mCASigningAlgorithms = null;
    protected long mNumOCSPRequest = 0L;
    protected long mTotalTime = 0L;
    protected long mTotalData = 0L;
    protected long mSignTime = 0L;
    protected long mLookupTime = 0L;
    private ResponderID mResponderIDByName = null;
    private ResponderID mResponderIDByHash = null;
    private String mId = null;

    public CertificateAuthority() {
        this.hostCA = true;
    }

    public CertificateAuthority(X500Name dn, AuthorityID aid, AuthorityID parentAID, BigInteger serial, String signingKeyNickname, Collection<String> authorityKeyHosts, String authorityDescription, boolean authorityEnabled) throws EBaseException {
        this.mId = ID;
        this.hostCA = false;
        this.mName = dn;
        this.authorityID = aid;
        this.authorityParentID = parentAID;
        this.authoritySerial = serial;
        this.authorityDescription = authorityDescription;
        this.authorityEnabled = authorityEnabled;
        this.authorityKeyHosts = authorityKeyHosts;
        this.mNickname = signingKeyNickname;
    }

    public boolean isHostAuthority() {
        return this.hostCA;
    }

    public void ensureReady() throws ECAException {
        if (!this.authorityEnabled) {
            throw new CADisabledException("Authority is disabled");
        }
        if (!this.isReady()) {
            if (this.signingUnitException == null) {
                throw new CAMissingKeyException("Authority does not yet have signing key and cert in local NSSDB");
            }
            throw this.signingUnitException;
        }
    }

    public boolean isReady() {
        return this.hasKeys;
    }

    public boolean getAuthorityEnabled() {
        return this.authorityEnabled;
    }

    public void setAuthorityEnabled(boolean authorityEnabled) {
        this.authorityEnabled = authorityEnabled;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    public void init(ConfigStore config) throws Exception {
        logger.info("CertificateAuthority: Initializing " + (String)(this.authorityID == null ? "host CA" : "authority " + this.authorityID));
        CAEngine caEngine = (CAEngine)this.engine;
        CAEngineConfig cs = caEngine.getConfig();
        this.mConfig = cs.getCAConfig();
        try {
            this.initCertSigningUnit();
            this.initCRLSigningUnit();
            this.initOCSPSigningUnit();
            this.checkForNewerCert();
        }
        catch (CAMissingCertException | CAMissingKeyException e) {
            logger.warn("CertificateAuthority: CA signing key and cert not (yet) present in NSS database");
            this.signingUnitException = e;
            caEngine.startKeyRetriever(this);
        }
        catch (Exception e) {
            throw new EBaseException(e);
        }
    }

    private void checkForNewerCert() throws EBaseException {
        logger.info("CertificateAuthority: Checking for newer CA cert");
        logger.info("CertificateAuthority: serial number: " + this.authoritySerial);
        if (this.authoritySerial == null) {
            return;
        }
        X509CertImpl caCertImpl = this.mSigningUnit.getCertImpl();
        if (this.authoritySerial.equals(caCertImpl.getSerialNumber())) {
            return;
        }
        logger.info("CertificateAuthority: Updating CA cert");
        logger.info("CertificateAuthority: serial number: " + this.authoritySerial);
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certificateRepository = engine.getCertificateRepository();
        try {
            X509Certificate oldCert = this.mSigningUnit.getCert();
            CryptoManager manager = CryptoManager.getInstance();
            X509CertImpl newCert = certificateRepository.getX509Certificate(this.authoritySerial);
            manager.importUserCACertPackage(newCert.getEncoded(), this.mNickname);
            manager.getInternalKeyStorageToken().getCryptoStore().deleteCert(oldCert);
            logger.info("CertificateAuthority: Reinitializing signing units after new certificate");
            this.initCertSigningUnit();
            this.initCRLSigningUnit();
            this.initOCSPSigningUnit();
        }
        catch (CAMissingCertException e) {
            logger.warn("CertificateAuthority: CA signing cert not (yet) present in NSS database");
            this.signingUnitException = e;
        }
        catch (CAMissingKeyException e) {
            logger.warn("CertificateAuthority: CA signing key not (yet) present in NSS database");
            this.signingUnitException = e;
        }
        catch (CertificateException e) {
            throw new ECAException("Failed to update certificate", (Throwable)e);
        }
        catch (NotInitializedException e) {
            throw new ECAException("CryptoManager not initialized", (Throwable)e);
        }
        catch (NicknameConflictException e) {
            throw new ECAException("Failed to update certificate; nickname conflict", (Throwable)e);
        }
        catch (UserCertConflictException e) {
            throw new ECAException("Failed to update certificate; user cert conflict", (Throwable)e);
        }
        catch (NoSuchItemOnTokenException | TokenException e) {
            throw new ECAException("Failed to update certificate", e);
        }
        catch (Exception e) {
            throw new EBaseException(e);
        }
    }

    public boolean isClone() {
        return CAService.mCLAConnector != null;
    }

    public void startup() throws EBaseException {
    }

    public void shutdown() {
    }

    public CAConfig getConfigStore() {
        return this.mConfig;
    }

    public CAConfig getConfig() {
        return this.mConfig;
    }

    public void setConfig(CAConfig config) {
        this.mConfig = config;
    }

    public SignatureAlgorithm getDefaultSignatureAlgorithm() {
        return this.mSigningUnit.getDefaultSignatureAlgorithm();
    }

    public String getDefaultAlgorithm() {
        return this.mSigningUnit.getDefaultAlgorithm();
    }

    public void setDefaultAlgorithm(String algorithm) throws EBaseException {
        this.mSigningUnit.setDefaultAlgorithm(algorithm);
    }

    public boolean addCRLIssuingPoint(CRLConfig crlConfig, String id, boolean enable, String description) {
        CAEngine engine = CAEngine.getInstance();
        crlConfig.makeSubStore(id);
        CRLIssuingPointConfig ipConfig = crlConfig.getCRLIssuingPointConfig(id);
        if (ipConfig != null) {
            ipConfig.setAllowExtensions(true);
            ipConfig.setAlwaysUpdate(false);
            ipConfig.setAutoUpdateInterval(240);
            ipConfig.setCACertsOnly(false);
            ipConfig.setCacheUpdateInterval(15);
            ipConfig.setClassName("com.netscape.ca.CRLIssuingPoint");
            ipConfig.setDailyUpdates("3:45");
            ipConfig.setDescription(description);
            ipConfig.setEnable(enable);
            ipConfig.setEnableCRLCache(true);
            ipConfig.setEnableCRLUpdates(true);
            ipConfig.setEnableCacheTesting(false);
            ipConfig.setEnableCacheRecovery(true);
            ipConfig.setEnableDailyUpdates(false);
            ipConfig.setEnableUpdateInterval(true);
            ipConfig.setExtendedNextUpdate(true);
            ipConfig.setIncludeExpiredCerts(false);
            ipConfig.setMinUpdateInterval(0);
            ipConfig.setNextUpdateGracePeriod(0);
            ipConfig.setPublishOnStart(false);
            ipConfig.setSaveMemory(false);
            ipConfig.setSigningAlgorithm("SHA256withRSA");
            ipConfig.setUpdateSchema(1);
            CRLExtensionsConfig extsConfig = ipConfig.getExtensionsConfig();
            CRLExtensionConfig extConfig = extsConfig.getExtensionConfig("AuthorityInformationAccess");
            extConfig.putString("enable", "false");
            extConfig.putString("critical", "false");
            extConfig.putString(PROP_TYPE, "CRLExtension");
            extConfig.putString(PROP_CLASS, "com.netscape.cms.crl.CMSAuthInfoAccessExtension");
            extConfig.putString("numberOfAccessDescriptions", "1");
            extConfig.putString("accessMethod0", "caIssuers");
            extConfig.putString("accessLocationType0", "URI");
            extConfig.putString("accessLocation0", "");
            extConfig = extsConfig.getExtensionConfig("AuthorityKeyIdentifier");
            extConfig.putString("enable", "false");
            extConfig.putString("critical", "false");
            extConfig.putString(PROP_TYPE, "CRLExtension");
            extConfig.putString(PROP_CLASS, "com.netscape.cms.crl.CMSAuthorityKeyIdentifierExtension");
            extConfig = extsConfig.getExtensionConfig("IssuerAlternativeName");
            extConfig.putString("enable", "false");
            extConfig.putString("critical", "false");
            extConfig.putString(PROP_TYPE, "CRLExtension");
            extConfig.putString(PROP_CLASS, "com.netscape.cms.crl.CMSIssuerAlternativeNameExtension");
            extConfig.putString("numNames", "0");
            extConfig.putString("nameType0", "");
            extConfig.putString("name0", "");
            extConfig = extsConfig.getExtensionConfig("CRLNumber");
            extConfig.putString("enable", "true");
            extConfig.putString("critical", "false");
            extConfig.putString(PROP_TYPE, "CRLExtension");
            extConfig.putString(PROP_CLASS, "com.netscape.cms.crl.CMSCRLNumberExtension");
            extConfig = extsConfig.getExtensionConfig("DeltaCRLIndicator");
            extConfig.putString("enable", "false");
            extConfig.putString("critical", "true");
            extConfig.putString(PROP_TYPE, "CRLExtension");
            extConfig.putString(PROP_CLASS, "com.netscape.cms.crl.CMSDeltaCRLIndicatorExtension");
            extConfig = extsConfig.getExtensionConfig("IssuingDistributionPoint");
            extConfig.putString("enable", "false");
            extConfig.putString("critical", "true");
            extConfig.putString(PROP_TYPE, "CRLExtension");
            extConfig.putString(PROP_CLASS, "com.netscape.cms.crl.CMSIssuingDistributionPointExtension");
            extConfig.putString("pointType", "");
            extConfig.putString("pointName", "");
            extConfig.putString("onlyContainsUserCerts", "false");
            extConfig.putString("onlyContainsCACerts", "false");
            extConfig.putString("onlySomeReasons", "");
            extConfig.putString("indirectCRL", "false");
            extConfig = extsConfig.getExtensionConfig("CRLReason");
            extConfig.putString("enable", "true");
            extConfig.putString("critical", "false");
            extConfig.putString(PROP_TYPE, "CRLEntryExtension");
            extConfig.putString(PROP_CLASS, "com.netscape.cms.crl.CMSCRLReasonExtension");
            extConfig = extsConfig.getExtensionConfig("InvalidityDate");
            extConfig.putString("enable", "true");
            extConfig.putString("critical", "false");
            extConfig.putString(PROP_TYPE, "CRLEntryExtension");
            extConfig.putString(PROP_CLASS, "com.netscape.cms.crl.CMSInvalidityDateExtension");
            extConfig = extsConfig.getExtensionConfig("FreshestCRL");
            extConfig.putString("enable", "false");
            extConfig.putString("critical", "false");
            extConfig.putString(PROP_TYPE, "CRLExtension");
            extConfig.putString(PROP_CLASS, "com.netscape.cms.crl.CMSFreshestCRLExtension");
            extConfig.putString("numPoints", "0");
            extConfig.putString("pointType0", "");
            extConfig.putString("pointName0", "");
            String issuingPointClassName = null;
            Class<?> issuingPointClass = null;
            CRLIssuingPoint issuingPoint = null;
            try {
                issuingPointClassName = ipConfig.getClassName();
                issuingPointClass = Class.forName(issuingPointClassName);
                issuingPoint = (CRLIssuingPoint)issuingPointClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                issuingPoint.init(this, id, ipConfig);
                engine.addCRLIssuingPoint(id, issuingPoint);
            }
            catch (Exception e) {
                logger.error("CertificateAuthority: " + e.getMessage(), (Throwable)e);
                crlConfig.removeSubStore(id);
                return false;
            }
        }
        return true;
    }

    public void deleteCRLIssuingPoint(CRLConfig crlConfig, String id) {
        CAEngine engine = CAEngine.getInstance();
        CRLIssuingPoint ip = engine.removeCRLIssuingPoint(id);
        if (ip != null) {
            ip.shutdown();
            ip = null;
            crlConfig.removeSubStore(id);
            try {
                engine.getCRLRepository().deleteCRLIssuingPointRecord(id);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"FAILED_REMOVING_CRL_IP_2", (Object[])new Object[]{id, e.toString()}), (Throwable)e);
            }
        }
    }

    public X500Name getX500Name() {
        return this.mName;
    }

    public CertificateIssuerName getIssuerObj() {
        return this.mIssuerObj;
    }

    public CertificateSubjectName getSubjectObj() {
        return this.mSubjectObj;
    }

    public X500Name getCRLX500Name() {
        X509CertImpl crlCertImpl = this.mCRLSigningUnit.getCertImpl();
        return crlCertImpl.getSubjectName();
    }

    public X500Name getOCSPX500Name() {
        X509CertImpl certImpl = this.mOCSPSigningUnit.getCertImpl();
        return certImpl.getSubjectName();
    }

    public String getNickname() {
        return this.mNickname;
    }

    public CASigningUnit getSigningUnit() {
        return this.mSigningUnit;
    }

    public CASigningUnit getCRLSigningUnit() {
        return this.mCRLSigningUnit;
    }

    public CASigningUnit getOCSPSigningUnit() {
        return this.mOCSPSigningUnit;
    }

    public void setBasicConstraintMaxLen(int num) {
        this.mConfig.putString("Policy.rule.BasicConstraintsExt.maxPathLen", "" + num);
    }

    public X509CRLImpl sign(X509CRLImpl crl, String algname) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        this.ensureReady();
        X509CRLImpl signedcrl = null;
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        if (statsSub != null) {
            statsSub.startTiming("signing");
        }
        try (DerOutputStream out = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            if (algname == null) {
                algname = this.mSigningUnit.getDefaultAlgorithm();
            }
            crl.encodeInfo((OutputStream)tmp);
            AlgorithmId.get((String)algname).encode(tmp);
            byte[] tbsCertList = crl.getTBSCertList();
            byte[] signature = this.mCRLSigningUnit.sign(tbsCertList, algname);
            if (crl.setSignature(signature)) {
                tmp.putBitString(signature);
                out.write((byte)48, tmp);
                if (crl.setSignedCRL(out.toByteArray())) {
                    signedcrl = crl;
                } else {
                    logger.warn("Failed to add signed-CRL to CRL object.");
                }
            } else {
                logger.warn("Failed to add signature to CRL object.");
            }
        }
        catch (CRLException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_SIGN_CRL", (Object[])new Object[]{e.toString(), e.getMessage()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_CRL_FAILED", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
        catch (X509ExtensionException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_SIGN_CRL", (Object[])new Object[]{e.toString(), e.getMessage()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_CRL_FAILED", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_SIGN_CRL", (Object[])new Object[]{e.toString(), e.getMessage()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_CRL_FAILED", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_SIGN_CRL", (Object[])new Object[]{e.toString(), e.getMessage()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_CRL_FAILED", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
        catch (SignatureException e) {
            logger.error(CMS.getUserMessage((String)"CMS_CA_SIGNING_OPERATION_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
            engine.checkForAndAutoShutdown();
            throw new EBaseException((Exception)e);
        }
        catch (Exception e) {
            logger.error("Unable to sign data: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        finally {
            if (statsSub != null) {
                statsSub.endTiming("signing");
            }
        }
        return signedcrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509CertImpl sign(X509CertInfo certInfo, String algname) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        this.ensureReady();
        X509CertImpl signedcert = null;
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        if (statsSub != null) {
            statsSub.startTiming("signing");
        }
        try (DerOutputStream out = new DerOutputStream();
             DerOutputStream tmp = new DerOutputStream();){
            if (certInfo == null) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CA_NO_CERTINFO", (Object[])new Object[0]));
                X509CertImpl x509CertImpl = null;
                return x509CertImpl;
            }
            if (algname == null) {
                algname = this.mSigningUnit.getDefaultAlgorithm();
            }
            logger.debug("sign cert get algorithm");
            AlgorithmId alg = AlgorithmId.get((String)algname);
            logger.debug("sign cert encoding cert");
            certInfo.encode((OutputStream)tmp);
            byte[] rawCert = tmp.toByteArray();
            logger.debug("sign cert encoding algorithm");
            alg.encode(tmp);
            logger.debug("CA cert signing: signing cert");
            byte[] signature = this.mSigningUnit.sign(rawCert, algname);
            tmp.putBitString(signature);
            out.write((byte)48, tmp);
            switch (engine.getFastSigning()) {
                case 0: {
                    signedcert = new X509CertImpl(out.toByteArray());
                    return signedcert;
                }
                case 1: {
                    signedcert = new X509CertImpl(out.toByteArray(), certInfo);
                    return signedcert;
                }
            }
            return signedcert;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_SIGN_CERT", (Object[])new Object[]{e.toString(), e.getMessage()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_CERT_FAILED", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_SIGN_CERT", (Object[])new Object[]{e.toString(), e.getMessage()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_CERT_FAILED", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_SIGN_CERT", (Object[])new Object[]{e.toString(), e.getMessage()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_CERT_FAILED", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
        catch (SignatureException e) {
            logger.error(CMS.getUserMessage((String)"CMS_CA_SIGNING_OPERATION_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
            engine.checkForAndAutoShutdown();
            throw new EBaseException((Exception)e);
        }
        catch (Exception e) {
            logger.error("Unable to sign data: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        finally {
            if (statsSub != null) {
                statsSub.endTiming("signing");
            }
        }
    }

    public byte[] sign(byte[] data, String algname) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        this.ensureReady();
        try {
            return this.mSigningUnit.sign(data, algname);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_ALGOR_NOT_SUPPORTED", (String[])new String[]{algname}), (Throwable)e);
        }
        catch (SignatureException e) {
            logger.error(CMS.getUserMessage((String)"CMS_CA_SIGNING_OPERATION_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
            engine.checkForAndAutoShutdown();
            throw new EBaseException((Exception)e);
        }
        catch (Exception e) {
            logger.error("Unable to sign data: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
    }

    public void log(int level, String msg) {
    }

    public CertificateChain getCACertChain() {
        return this.mSigningUnit.getCertChain();
    }

    public X509CertImpl getCACert() throws EBaseException {
        X509CertImpl caCertImpl = this.mSigningUnit.getCertImpl();
        if (caCertImpl != null) {
            return caCertImpl;
        }
        String cert = this.mConfig.getString("signing.cert");
        logger.debug("CertificateAuthority: CA signing cert: " + cert);
        if (StringUtils.isEmpty((CharSequence)cert)) {
            logger.error("CertificateAuthority: Missing CA signing certificate");
            throw new EBaseException("Missing CA signing certificate");
        }
        byte[] bytes = Utils.base64decode((String)cert);
        logger.debug("CertificateAuthority: size: " + bytes.length + " bytes");
        try {
            return new X509CertImpl(bytes);
        }
        catch (CertificateException e) {
            logger.error("Unable to parse CA signing cert: " + e.getMessage(), (Throwable)e);
            throw new EBaseException((Exception)e);
        }
    }

    public X509Certificate getCaX509Cert() {
        return this.mSigningUnit.getCert();
    }

    public String[] getCASigningAlgorithms() {
        if (this.mCASigningAlgorithms != null) {
            return this.mCASigningAlgorithms;
        }
        X509CertImpl caCertImpl = this.mSigningUnit.getCertImpl();
        if (caCertImpl == null) {
            return null;
        }
        X509Key caPubKey = null;
        try {
            caPubKey = (X509Key)caCertImpl.get("x509.info.key.value");
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        if (caPubKey == null) {
            return null;
        }
        AlgorithmId alg = caPubKey.getAlgorithmId();
        if (alg == null) {
            return null;
        }
        this.mCASigningAlgorithms = AlgorithmId.getSigningAlgorithms((AlgorithmId)alg);
        if (this.mCASigningAlgorithms == null) {
            logger.warn("CA - no signing algorithms for " + alg.getName());
        } else {
            logger.debug("CA First signing algorithm is " + this.mCASigningAlgorithms[0]);
        }
        return this.mCASigningAlgorithms;
    }

    public synchronized void initCertSigningUnit() throws Exception {
        logger.info("CertificateAuthority: Initializing cert signing unit");
        SigningUnitConfig caSigningCfg = this.mConfig.getSigningUnitConfig();
        this.mSigningUnit = new CASigningUnit();
        this.mSigningUnit.init(caSigningCfg, this.mNickname);
        this.hasKeys = true;
        this.signingUnitException = null;
        this.mNickname = this.mSigningUnit.getNickname();
        X509Certificate caCert = this.mSigningUnit.getCert();
        logger.info("CertificateAuthority: - nickname: " + caCert.getNickname());
        X509CertImpl caCertImpl = this.mSigningUnit.getCertImpl();
        this.mName = caCertImpl.getSubjectName();
        this.getCASigningAlgorithms();
        this.mSubjectObj = caCertImpl.getSubjectObj();
        logger.debug("CertificateAuthority: - subject DN: " + this.mSubjectObj);
        X500Name issuerName = (X500Name)this.mSubjectObj.get("dname");
        this.mIssuerObj = new CertificateIssuerName(issuerName);
        logger.debug("CertificateAuthority: - issuer DN: " + this.mIssuerObj);
        String certSigningSKI = CryptoUtil.getSKIString((X509CertImpl)caCertImpl);
        Auditor auditor = this.engine.getAuditor();
        if (this.hostCA) {
            auditor.log((LogEvent)CertSigningInfoEvent.createSuccessEvent((String)"$System$", (String)certSigningSKI));
        } else {
            auditor.log((LogEvent)CertSigningInfoEvent.createSuccessEvent((String)"$System$", (String)certSigningSKI, (AuthorityID)this.authorityID));
        }
    }

    public synchronized void initCRLSigningUnit() throws Exception {
        logger.info("CertificateAuthority: Initializing CRL signing unit");
        SigningUnitConfig crlSigningConfig = this.mConfig.getCRLSigningUnitConfig();
        if (this.hostCA && crlSigningConfig != null && crlSigningConfig.size() > 0) {
            this.mCRLSigningUnit = new CASigningUnit();
            this.mCRLSigningUnit.init(crlSigningConfig, null);
        } else {
            this.mCRLSigningUnit = this.mSigningUnit;
        }
        X509Certificate crlCert = this.mCRLSigningUnit.getCert();
        logger.info("CertificateAuthority: - nickname: " + crlCert.getNickname());
        X509CertImpl crlCertImpl = this.mCRLSigningUnit.getCertImpl();
        String crlSigningSKI = CryptoUtil.getSKIString((X509CertImpl)crlCertImpl);
        Auditor auditor = this.engine.getAuditor();
        if (this.hostCA) {
            auditor.log((LogEvent)CRLSigningInfoEvent.createSuccessEvent((String)"$System$", (String)crlSigningSKI));
        }
    }

    public synchronized void initOCSPSigningUnit() throws Exception {
        logger.info("CertificateAuthority: Initializing OCSP signing unit");
        SigningUnitConfig ocspSigningConfig = this.mConfig.getOCSPSigningUnitConfig();
        if (this.hostCA && ocspSigningConfig != null && ocspSigningConfig.size() > 0) {
            this.mOCSPSigningUnit = new CASigningUnit();
            this.mOCSPSigningUnit.init(ocspSigningConfig, null);
        } else {
            this.mOCSPSigningUnit = this.mSigningUnit;
        }
        X509Certificate ocspCert = this.mOCSPSigningUnit.getCert();
        logger.info("CertificateAuthority: - nickname: " + ocspCert.getNickname());
        X509CertImpl ocspCertImpl = this.mOCSPSigningUnit.getCertImpl();
        String ocspSigningSKI = CryptoUtil.getSKIString((X509CertImpl)ocspCertImpl);
        Auditor auditor = this.engine.getAuditor();
        if (this.hostCA) {
            auditor.log((LogEvent)OCSPSigningInfoEvent.createSuccessEvent((String)"$System$", (String)ocspSigningSKI));
        } else {
            auditor.log((LogEvent)OCSPSigningInfoEvent.createSuccessEvent((String)"$System$", (String)ocspSigningSKI, (AuthorityID)this.authorityID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getCertFromFile(String path) throws FileNotFoundException, IOException {
        File file = new File(path);
        Long l = file.length();
        byte[] b = new byte[l.intValue()];
        try (FileInputStream in = null;){
            in = new FileInputStream(path);
            in.read(b);
        }
        return b;
    }

    public String getOfficialName() {
        return OFFICIAL_NAME;
    }

    public long getNumOCSPRequest() {
        return this.mNumOCSPRequest;
    }

    public long getOCSPRequestTotalTime() {
        return this.mTotalTime;
    }

    public long getOCSPTotalData() {
        return this.mTotalData;
    }

    public long getOCSPTotalSignTime() {
        return this.mSignTime;
    }

    public long getOCSPTotalLookupTime() {
        return this.mLookupTime;
    }

    public ResponderID getResponderIDByName() {
        try {
            X500Name name = this.getOCSPX500Name();
            Name.Template nameTemplate = new Name.Template();
            return new NameID((Name)nameTemplate.decode((InputStream)new ByteArrayInputStream(name.getEncoded())));
        }
        catch (IOException e) {
            return null;
        }
        catch (InvalidBERException e) {
            return null;
        }
    }

    public ResponderID getResponderIDByHash() {
        PublicKey publicKey = this.getOCSPSigningUnit().getPublicKey();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(publicKey.getEncoded());
        byte[] digested = md.digest();
        return new KeyHashID(new OCTET_STRING(digested));
    }

    public OCSPResponse validate(OCSPRequest request) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        if (!engine.getEnableOCSP()) {
            logger.debug("CertificateAuthority: OCSP service disabled");
            throw new EBaseException("OCSP service disabled");
        }
        TBSRequest tbsReq = request.getTBSRequest();
        if (tbsReq.getRequestCount() == 0) {
            logger.error(CMS.getLogMessage((String)"OCSP_REQUEST_FAILURE", (Object[])new Object[]{"No Request Found"}));
            throw new EBaseException("OCSP request is empty");
        }
        CertificateAuthority ocspCA = this;
        if (engine.getCAs().size() > 0 && tbsReq.getRequestCount() > 0) {
            Request req = tbsReq.getRequestAt(0);
            INTEGER serialNo = req.getCertID().getSerialNumber();
            CertificateRepository certificateRepository = engine.getCertificateRepository();
            X509CertImpl cert = certificateRepository.getX509Certificate((BigInteger)serialNo);
            X500Name certIssuerDN = cert.getIssuerName();
            ocspCA = engine.getCA(certIssuerDN);
        }
        if (ocspCA == null) {
            logger.error("CertificateAuthority: Could not locate issuing CA");
            throw new CANotFoundException("Could not locate issuing CA");
        }
        if (ocspCA != this) {
            return ocspCA.validate(request);
        }
        logger.debug("CertificateAuthority: validating OCSP request");
        ++this.mNumOCSPRequest;
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        long startTime = new Date().getTime();
        try {
            Vector<SingleResponse> singleResponses = new Vector<SingleResponse>();
            if (statsSub != null) {
                statsSub.startTiming("lookup");
            }
            long lookupStartTime = new Date().getTime();
            for (int i = 0; i < tbsReq.getRequestCount(); ++i) {
                Request req = tbsReq.getRequestAt(i);
                SingleResponse sr = this.processRequest(req);
                singleResponses.addElement(sr);
            }
            long lookupEndTime = new Date().getTime();
            this.mLookupTime += lookupEndTime - lookupStartTime;
            if (statsSub != null) {
                statsSub.endTiming("lookup");
            }
            if (statsSub != null) {
                statsSub.startTiming("build_response");
            }
            Object[] res = new SingleResponse[singleResponses.size()];
            singleResponses.copyInto(res);
            ResponderID rid = null;
            if (engine.getOCSPResponderByName()) {
                if (this.mResponderIDByName == null) {
                    this.mResponderIDByName = this.getResponderIDByName();
                }
                rid = this.mResponderIDByName;
            } else {
                if (this.mResponderIDByHash == null) {
                    this.mResponderIDByHash = this.getResponderIDByHash();
                }
                rid = this.mResponderIDByHash;
            }
            Extension[] nonce = null;
            for (int j = 0; j < tbsReq.getExtensionsCount(); ++j) {
                Extension thisExt = tbsReq.getRequestExtensionAt(j);
                if (!thisExt.getExtnId().equals((Object)OCSP_NONCE)) continue;
                nonce = new Extension[]{thisExt};
            }
            ResponseData rd = new ResponseData(rid, new GeneralizedTime(new Date()), (SingleResponse[])res, nonce);
            if (statsSub != null) {
                statsSub.endTiming("build_response");
            }
            if (statsSub != null) {
                statsSub.startTiming("signing");
            }
            long signStartTime = new Date().getTime();
            BasicOCSPResponse basicRes = this.sign(rd);
            long signEndTime = new Date().getTime();
            this.mSignTime += signEndTime - signStartTime;
            if (statsSub != null) {
                statsSub.endTiming("signing");
            }
            OCSPResponse response = new OCSPResponse(OCSPResponseStatus.SUCCESSFUL, new ResponseBytes(ResponseBytes.OCSP_BASIC, new OCTET_STRING(ASN1Util.encode((ASN1Value)basicRes))));
            long endTime = new Date().getTime();
            this.mTotalTime += endTime - startTime;
            return response;
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_OCSP_REQUEST", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw e;
        }
    }

    private BasicOCSPResponse sign(ResponseData rd) throws EBaseException {
        BasicOCSPResponse basicOCSPResponse;
        CAEngine engine = CAEngine.getInstance();
        this.ensureReady();
        String algname = this.mOCSPSigningUnit.getDefaultAlgorithm();
        DerOutputStream out = new DerOutputStream();
        try {
            BasicOCSPResponse response;
            DerOutputStream tmp = new DerOutputStream();
            byte[] rd_data = ASN1Util.encode((ASN1Value)rd);
            if (rd_data != null) {
                this.mTotalData += (long)rd_data.length;
            }
            rd.encode((OutputStream)tmp);
            AlgorithmId.get((String)algname).encode(tmp);
            logger.debug("adding signature");
            byte[] signature = this.mOCSPSigningUnit.sign(rd_data, algname);
            tmp.putBitString(signature);
            DerOutputStream tmpChain = new DerOutputStream();
            DerOutputStream tmp1 = new DerOutputStream();
            java.security.cert.X509Certificate[] chains = this.mOCSPSigningUnit.getCertChain().getChain();
            for (int i = 0; i < chains.length; ++i) {
                tmpChain.putDerValue(new DerValue(chains[i].getEncoded()));
            }
            tmp1.write((byte)48, tmpChain);
            tmp.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), tmp1);
            out.write((byte)48, tmp);
            basicOCSPResponse = response = new BasicOCSPResponse(out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoSuchAlgorithmException e) {
                logger.error(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_ALGOR_NOT_SUPPORTED", (String[])new String[]{algname}), (Throwable)e);
            }
            catch (SignatureException e) {
                logger.error(CMS.getUserMessage((String)"CMS_CA_SIGNING_OPERATION_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
                engine.checkForAndAutoShutdown();
                throw new EBaseException((Exception)e);
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_OCSP_SIGN", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new EBaseException(e);
            }
        }
        out.close();
        return basicOCSPResponse;
    }

    private SingleResponse processRequest(Request req) {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certificateRepository = engine.getCertificateRepository();
        CertID cid = req.getCertID();
        INTEGER serialNo = cid.getSerialNumber();
        logger.debug("CertificateAuthority: processing request for cert 0x" + serialNo.toString(16));
        Object certStatus = null;
        GeneralizedTime thisUpdate = new GeneralizedTime(new Date());
        byte[] nameHash = null;
        String digestName = cid.getDigestName();
        if (digestName != null) {
            try {
                MessageDigest md = MessageDigest.getInstance(digestName);
                nameHash = md.digest(this.mName.getEncoded());
            }
            catch (IOException | NoSuchAlgorithmException md) {
                // empty catch block
            }
        }
        if (!Arrays.equals(cid.getIssuerNameHash().toByteArray(), nameHash)) {
            return new SingleResponse(cid, (CertStatus)new UnknownInfo(), thisUpdate, null);
        }
        boolean ocspUseCache = true;
        try {
            ocspUseCache = this.mConfig.getBoolean("ocspUseCache", false);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        if (ocspUseCache) {
            String issuingPointId = PROP_MASTER_CRL;
            try {
                issuingPointId = this.mConfig.getString("ocspUseCacheIssuingPointId", PROP_MASTER_CRL);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            CRLIssuingPoint point = engine.getCRLIssuingPoint(issuingPointId);
            GeneralizedTime nextUpdate = null;
            Date crlNextUpdate = point.getNextUpdate();
            if (crlNextUpdate != null) {
                nextUpdate = new GeneralizedTime(crlNextUpdate);
            }
            if (point.isCRLCacheEnabled()) {
                BigInteger sno = new BigInteger(serialNo.toString());
                boolean checkDeltaCache = false;
                boolean includeExpiredCerts = false;
                try {
                    checkDeltaCache = this.mConfig.getBoolean("ocspUseCacheCheckDeltaCache", false);
                }
                catch (EBaseException eBaseException) {
                    // empty catch block
                }
                try {
                    includeExpiredCerts = this.mConfig.getBoolean("ocspUseCacheIncludeExpiredCerts", false);
                }
                catch (EBaseException eBaseException) {
                    // empty catch block
                }
                Date revokedOn = point.getRevocationDateFromCache(sno, checkDeltaCache, includeExpiredCerts);
                certStatus = revokedOn == null ? new GoodInfo() : new RevokedInfo(new GeneralizedTime(revokedOn));
                return new SingleResponse(cid, (CertStatus)certStatus, thisUpdate, nextUpdate);
            }
        }
        try {
            CertRecord rec = certificateRepository.readCertificateRecord((BigInteger)serialNo);
            String status = rec.getStatus();
            certStatus = status == null ? new UnknownInfo() : (status.equals("VALID") ? new GoodInfo() : (status.equals("INVALID") ? new UnknownInfo() : (status.equals("REVOKED") ? new RevokedInfo(new GeneralizedTime(rec.getRevokedOn())) : (status.equals("EXPIRED") ? new UnknownInfo() : (status.equals("REVOKED_EXPIRED") ? new RevokedInfo(new GeneralizedTime(rec.getRevokedOn())) : new UnknownInfo())))));
        }
        catch (Exception e) {
            certStatus = new UnknownInfo();
        }
        return new SingleResponse(cid, (CertStatus)certStatus, thisUpdate, null);
    }

    public AuthorityID getAuthorityID() {
        return this.authorityID;
    }

    public void setAuthorityID(AuthorityID aid) {
        this.authorityID = aid;
    }

    public AuthorityID getAuthorityParentID() {
        return this.authorityParentID;
    }

    public String getAuthorityDescription() {
        return this.authorityDescription;
    }

    public void setAuthorityDescription(String desc) {
        this.authorityDescription = desc;
    }

    public Collection<String> getAuthorityKeyHosts() {
        return this.authorityKeyHosts;
    }

    public X509CertImpl generateSigningCert(X500Name subjectX500Name, AuthToken authToken) throws Exception {
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken token = cryptoManager.getInternalKeyStorageToken();
        logger.info("CertificateAuthority: generating RSA key");
        KeyPairGenerator gen = token.getKeyPairGenerator(KeyPairAlgorithm.RSA);
        int keySize = 3072;
        PublicKey thisPub = this.mSigningUnit.getPublicKey();
        if (thisPub instanceof RSAKey) {
            keySize = ((RSAKey)((Object)thisPub)).getModulus().bitLength();
        }
        gen.initialize(keySize);
        KeyPair keypair = gen.genKeyPair();
        PublicKey pub = keypair.getPublic();
        X509Key x509key = CryptoUtil.createX509Key((PublicKey)pub);
        logger.info("CertificateAuthority: creating PKCS #10 request");
        PKCS10 pkcs10 = new PKCS10(x509key);
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(keypair.getPrivate());
        pkcs10.encodeAndSign(new X500Signer(signature, subjectX500Name));
        String pkcs10String = CertUtil.toPEM((PKCS10)pkcs10);
        logger.info("CertificateAuthority: signing certificate");
        CAEngine engine = CAEngine.getInstance();
        ProfileSubsystem ps = engine.getProfileSubsystem();
        String profileId = "caCACert";
        Profile profile = ps.getProfile(profileId);
        ArgBlock argBlock = new ArgBlock();
        argBlock.set("cert_request_type", (Object)"pkcs10");
        argBlock.set("cert_request", (Object)pkcs10String);
        Locale locale = Locale.getDefault();
        CertEnrollmentRequest certRequest = CertEnrollmentRequestFactory.create(argBlock, profile, locale);
        EnrollmentProcessor processor = new EnrollmentProcessor("createSubCA", locale);
        processor.setCMSEngine(engine);
        processor.init();
        HashMap<String, Object> resultMap = processor.processEnrollment(certRequest, null, this.authorityID, null, authToken);
        com.netscape.cmscore.request.Request[] requests = (com.netscape.cmscore.request.Request[])resultMap.get("requests");
        com.netscape.cmscore.request.Request request = requests[0];
        Integer result = request.getExtDataInInteger("Result");
        if (result != null && !result.equals(com.netscape.cmscore.request.Request.RES_SUCCESS)) {
            throw new EBaseException("Unable to generate signing certificate: " + result);
        }
        RequestStatus requestStatus = request.getRequestStatus();
        if (requestStatus != RequestStatus.COMPLETE) {
            String msg = "Unable to generate signing certificate: " + requestStatus;
            String errorMsg = request.getExtDataInString("Error");
            if (errorMsg != null) {
                msg = msg + ": " + errorMsg;
            }
            throw new BadRequestDataException(msg);
        }
        return request.getExtDataInCert("req_issued_cert");
    }

    public void renewAuthority(HttpServletRequest httpReq) throws Exception {
        CAEngine engine = CAEngine.getInstance();
        if (this.authorityParentID != null && !this.authorityParentID.equals(this.authorityID)) {
            CertificateAuthority issuer = engine.getCA(this.authorityParentID);
            issuer.ensureReady();
        }
        ProfileSubsystem ps = engine.getProfileSubsystem();
        Profile profile = ps.getProfile("caManualRenewal");
        CertEnrollmentRequest req = CertEnrollmentRequestFactory.create(new ArgBlock(), profile, httpReq.getLocale());
        X509CertImpl caCertImpl = this.mSigningUnit.getCertImpl();
        req.setSerialNum(new CertId(caCertImpl.getSerialNumber()));
        RenewalProcessor processor = new RenewalProcessor("renewAuthority", httpReq.getLocale());
        processor.setCMSEngine(engine);
        processor.init();
        HashMap<String, Object> resultMap = processor.processRenewal(req, httpReq, null);
        com.netscape.cmscore.request.Request[] requests = (com.netscape.cmscore.request.Request[])resultMap.get("requests");
        com.netscape.cmscore.request.Request request = requests[0];
        Integer result = request.getExtDataInInteger("Result");
        if (result != null && !result.equals(com.netscape.cmscore.request.Request.RES_SUCCESS)) {
            throw new EBaseException("renewAuthority: certificate renewal submission resulted in error: " + result);
        }
        RequestStatus requestStatus = request.getRequestStatus();
        if (requestStatus != RequestStatus.COMPLETE) {
            throw new EBaseException("renewAuthority: certificate renewal did not complete; status: " + requestStatus);
        }
        X509CertImpl cert = request.getExtDataInCert("req_issued_cert");
        this.authoritySerial = cert.getSerialNumber();
        engine.updateAuthoritySerialNumber(this.authorityID, this.authoritySerial);
        this.checkForNewerCert();
    }

    public synchronized void deleteAuthority(HttpServletRequest httpReq) throws EBaseException {
        if (this.hostCA) {
            throw new CATypeException("Cannot delete the host CA");
        }
        if (this.authorityEnabled) {
            throw new CAEnabledException("Must disable CA before deletion");
        }
        CAEngine engine = CAEngine.getInstance();
        boolean hasSubCAs = false;
        for (CertificateAuthority ca : engine.getCAs()) {
            AuthorityID parentAID = ca.getAuthorityParentID();
            if (parentAID == null || !parentAID.equals(this.authorityID)) continue;
            hasSubCAs = true;
            break;
        }
        if (hasSubCAs) {
            throw new CANotLeafException("CA with sub-CAs cannot be deleted (delete sub-CAs first)");
        }
        this.revokeAuthority(httpReq);
        engine.deleteAuthorityEntry(this.authorityID);
        this.deleteAuthorityNSSDB();
    }

    private void revokeAuthority(HttpServletRequest httpReq) throws EBaseException {
        logger.debug("revokeAuthority: checking serial " + this.authoritySerial);
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certificateRepository = engine.getCertificateRepository();
        CertRecord certRecord = certificateRepository.readCertificateRecord(this.authoritySerial);
        String curStatus = certRecord.getStatus();
        logger.debug("revokeAuthority: current cert status: " + curStatus);
        if (curStatus.equals("REVOKED") || curStatus.equals("REVOKED_EXPIRED")) {
            return;
        }
        logger.debug("revokeAuthority: revoking cert");
        RevocationProcessor processor = new RevocationProcessor("CertificateAuthority.revokeAuthority", httpReq.getLocale());
        processor.setCMSEngine(engine);
        processor.init();
        processor.setSerialNumber(new CertId(this.authoritySerial));
        processor.setRevocationReason(RevocationReason.UNSPECIFIED);
        processor.setAuthority(this);
        try {
            processor.createCRLExtension();
        }
        catch (IOException e) {
            throw new ECAException("Unable to create CRL extensions", (Throwable)e);
        }
        X509CertImpl caCertImpl = this.mSigningUnit.getCertImpl();
        processor.addCertificateToRevoke(caCertImpl);
        processor.createRevocationRequest();
        processor.auditChangeRequest("Success");
        processor.processRevocationRequest();
        processor.auditChangeRequestProcessed("Success");
    }

    void deleteAuthorityNSSDB() throws ECAException {
        CryptoManager cryptoManager;
        if (this.hostCA) {
            String msg = "Attempt to delete host authority signing key; not proceeding";
            logger.warn(msg);
            return;
        }
        try {
            cryptoManager = CryptoManager.getInstance();
        }
        catch (NotInitializedException e) {
            throw new ECAException("CryptoManager not initialized");
        }
        CryptoStore cryptoStore = cryptoManager.getInternalKeyStorageToken().getCryptoStore();
        try {
            cryptoStore.deleteCert(this.mSigningUnit.getCert());
        }
        catch (NoSuchItemOnTokenException e) {
            logger.warn("deleteAuthority: cert is not on token: " + e);
        }
        catch (TokenException e) {
            logger.error("deleteAuthority: TokenExcepetion while deleting cert: " + e.getMessage(), (Throwable)e);
            throw new ECAException("TokenException while deleting cert: " + e);
        }
    }
}

