/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.crl;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import java.util.StringTokenizer;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPoint;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPointExtension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSIssuingDistributionPointExtension
extends CMSCRLExtension
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CMSIssuingDistributionPointExtension.class);
    public static final String PROP_POINTTYPE = "pointType";
    public static final String PROP_POINTNAME = "pointName";
    public static final String PROP_DIRNAME = "DirectoryName";
    public static final String PROP_URINAME = "URI";
    public static final String PROP_RDNNAME = "RelativeToIssuer";
    public static final String PROP_CACERTS = "onlyContainsCACerts";
    public static final String PROP_USERCERTS = "onlyContainsUserCerts";
    public static final String PROP_INDIRECT = "indirectCRL";
    public static final String PROP_REASONS = "onlySomeReasons";
    private static final String[] reasonFlags = new String[]{"unused", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "privilegeWithdrawn"};

    @Override
    public Extension setCRLExtensionCriticality(Extension ext, boolean critical) {
        IssuingDistributionPointExtension issuingDPointExt = (IssuingDistributionPointExtension)ext;
        issuingDPointExt.setCritical(critical);
        return issuingDPointExt;
    }

    @Override
    public Extension getCRLExtension(ConfigStore config, Object ip, boolean critical) {
        logger.debug("in CMSIssuingDistributionPointExtension::getCRLExtension.");
        IssuingDistributionPointExtension issuingDPointExt = null;
        IssuingDistributionPoint issuingDPoint = new IssuingDistributionPoint();
        GeneralNames names = new GeneralNames();
        RDN rdnName = null;
        String pointType = null;
        try {
            pointType = config.getString(PROP_POINTTYPE);
        }
        catch (EPropertyNotFound e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (pointType != null) {
            String pointName = null;
            try {
                pointName = config.getString(PROP_POINTNAME);
            }
            catch (EPropertyNotFound e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (pointName != null && pointName.length() > 0) {
                if (pointType.equalsIgnoreCase(PROP_RDNNAME)) {
                    try {
                        rdnName = new RDN(pointName);
                    }
                    catch (IOException e) {
                        logger.warn(CMS.getLogMessage((String)"CRL_CREATE_RDN", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                } else if (pointType.equalsIgnoreCase(PROP_DIRNAME)) {
                    try {
                        X500Name dirName = new X500Name(pointName);
                        names.addElement((Object)dirName);
                    }
                    catch (IOException e) {
                        logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_500NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                } else if (pointType.equalsIgnoreCase(PROP_URINAME)) {
                    URIName uriName = new URIName(pointName);
                    names.addElement((Object)uriName);
                } else {
                    logger.warn(CMS.getLogMessage((String)"CRL_INVALID_POTINT_TYPE", (Object[])new Object[]{pointType}));
                }
            }
        }
        if (rdnName != null) {
            issuingDPoint.setRelativeName(rdnName);
        } else if (names.size() > 0) {
            try {
                issuingDPoint.setFullName(names);
            }
            catch (IOException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CANNOT_SET_NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (GeneralNamesException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CANNOT_SET_NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
        }
        String reasons = null;
        try {
            reasons = config.getString(PROP_REASONS, null);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_INVALID_PROPERTY", (Object[])new Object[]{PROP_REASONS, e.toString()}), (Throwable)e);
        }
        if (reasons != null && reasons.length() > 0) {
            boolean[] bits = new boolean[]{false, false, false, false, false, false, false};
            int k = 0;
            StringTokenizer st = new StringTokenizer(reasons, ",");
            block21: while (st.hasMoreTokens()) {
                String bitName = st.nextToken();
                for (int i = 1; i < reasonFlags.length; ++i) {
                    if (!bitName.equalsIgnoreCase(reasonFlags[i])) continue;
                    bits[i] = true;
                    ++k;
                    continue block21;
                }
            }
            if (k > 0) {
                BitArray ba = new BitArray(bits);
                issuingDPoint.setOnlySomeReasons(ba);
            }
        }
        try {
            boolean caCertsOnly = config.getBoolean(PROP_CACERTS, false);
            if (caCertsOnly) {
                issuingDPoint.setOnlyContainsCACerts(caCertsOnly);
            }
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_INVALID_PROPERTY", (Object[])new Object[]{"caCertsOnly", e.toString()}), (Throwable)e);
        }
        try {
            boolean userCertsOnly = config.getBoolean(PROP_USERCERTS, false);
            if (userCertsOnly) {
                issuingDPoint.setOnlyContainsUserCerts(userCertsOnly);
            }
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_INVALID_PROPERTY", (Object[])new Object[]{"userCertsOnly", e.toString()}), (Throwable)e);
        }
        try {
            boolean indirectCRL = config.getBoolean(PROP_INDIRECT, false);
            if (indirectCRL) {
                issuingDPoint.setIndirectCRL(indirectCRL);
            }
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_INVALID_PROPERTY", (Object[])new Object[]{PROP_INDIRECT, e.toString()}), (Throwable)e);
        }
        issuingDPointExt = new IssuingDistributionPointExtension(issuingDPoint);
        issuingDPointExt.setCritical(critical);
        return issuingDPointExt;
    }

    @Override
    public String getCRLExtOID() {
        return PKIXExtensions.IssuingDistributionPoint_Id.toString();
    }

    @Override
    public void getConfigParams(ConfigStore config, NameValuePairs nvp) {
        String pointType = null;
        try {
            pointType = config.getString(PROP_POINTTYPE);
        }
        catch (EPropertyNotFound e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (pointType != null && pointType.length() > 0) {
            nvp.put((Object)PROP_POINTTYPE, (Object)pointType);
        } else {
            nvp.put((Object)PROP_POINTTYPE, (Object)"");
        }
        String pointName = null;
        try {
            pointName = config.getString(PROP_POINTNAME);
        }
        catch (EPropertyNotFound e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (pointName != null && pointName.length() > 0) {
            nvp.put((Object)PROP_POINTNAME, (Object)pointName);
        } else {
            nvp.put((Object)PROP_POINTNAME, (Object)"");
        }
        String reasons = null;
        try {
            reasons = config.getString(PROP_REASONS, null);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_INVALID_PROPERTY", (Object[])new Object[]{PROP_REASONS, e.toString()}), (Throwable)e);
        }
        if (reasons != null && reasons.length() > 0) {
            nvp.put((Object)PROP_REASONS, (Object)reasons);
        } else {
            nvp.put((Object)PROP_REASONS, (Object)"");
        }
        try {
            boolean caCertsOnly = config.getBoolean(PROP_CACERTS, false);
            nvp.put((Object)PROP_CACERTS, (Object)String.valueOf(caCertsOnly));
        }
        catch (EBaseException e) {
            nvp.put((Object)PROP_CACERTS, (Object)"false");
            logger.warn(CMS.getLogMessage((String)"CRL_INVALID_PROPERTY", (Object[])new Object[]{"caCertsOnly", e.toString()}), (Throwable)e);
        }
    }

    public String[] getExtendedPluginInfo() {
        StringBuffer sb_reasons = new StringBuffer();
        sb_reasons.append(reasonFlags[1]);
        for (int i = 2; i < reasonFlags.length; ++i) {
            sb_reasons.append(", ");
            sb_reasons.append(reasonFlags[i]);
        }
        String[] params = new String[]{"enable;boolean;Check to enable Issuing Distribution Point CRL extension.", "critical;boolean;Set criticality for Issuing Distribution Point CRL extension.", "pointType;choice(DirectoryName,URI,RelativeToIssuer);Select Issuing Distribution Point name type.", "pointName;string;Enter Issuing Distribution Point name corresponding to the selected point type.", "onlySomeReasons;string;Select any combination of the following reasons: " + sb_reasons.toString(), "onlyContainsCACerts;boolean;Check if CRL contains CA certificates only", "HELP_TOKEN;configuration-ca-edit-crlextension-issuingdistributionpoint", "HELP_TEXT;The issuing distribution point is a critical CRL extension that identifies the CRL distribution point for a particular CRL."};
        return params;
    }
}

