/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.security.JssSubsystem;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

@WebServlet(name="caReasonToRevoke", urlPatterns={"/agent/ca/reasonToRevoke"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="templatePath", value="/agent/ca/reasonToRevoke.template"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="ID", value="caReasonToRevoke"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.ca.certificates")})
public class ReasonToRevoke
extends CMSServlet {
    private static final long serialVersionUID = -8447580860330758660L;
    private static final String TPL_FILE = "reasonToRevoke.template";
    private static final String INFO = "ReasonToRevoke";
    private CertificateRepository mCertDB;
    private String mFormPath = null;
    private CertificateAuthority mCA;
    private SecureRandom mRandom = null;
    private int mTimeLimits = 30;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        this.mFormPath = "/ca/reasonToRevoke.template";
        this.mCA = engine.getCA();
        this.mCertDB = engine.getCertificateRepository();
        if (this.mCA != null && engine.getEnableNonces()) {
            this.mRandom = jssSubsystem.getRandomNumberGenerator();
        }
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        try {
            this.mTimeLimits = Integer.parseInt(sc.getInitParameter("timeLimits"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "revoke");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        String revokeAll = null;
        int totalRecordCount = 1;
        EBaseException error = null;
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        try {
            if (req.getParameter("totalRecordCount") != null) {
                totalRecordCount = Integer.parseInt(req.getParameter("totalRecordCount"));
            }
            revokeAll = req.getParameter("revokeAll");
            this.process(argSet, header, req, resp, revokeAll, totalRecordCount, locale[0]);
        }
        catch (EBaseException e) {
            error = e;
        }
        catch (NumberFormatException e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_INVALID_RECORD_COUNT_FORMAT", (Object[])new Object[0]), (Throwable)e);
            error = new EBaseException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_BASE_INVALID_NUMBER_FORMAT", (String[])new String[0]), (Throwable)e);
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_OUT_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, HttpServletRequest req, HttpServletResponse resp, String revokeAll, int totalRecordCount, Locale locale) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certRepository = engine.getCertificateRepository();
        header.addStringValue("revokeAll", revokeAll);
        header.addIntegerValue("totalRecordCount", totalRecordCount);
        try {
            X509CertImpl caCert;
            X509CertImpl certInDB;
            if (this.mCA != null && (certInDB = certRepository.getX509Certificate((caCert = this.mCA.getSigningUnit().getCertImpl()).getSerialNumber())) != null && certInDB.equals((Object)caCert)) {
                header.addStringValue("caSerialNumber", caCert.getSerialNumber().toString(16));
            }
            Enumeration<CertRecord> e = this.mCertDB.searchCertificates(revokeAll, totalRecordCount, this.mTimeLimits);
            ArrayList<CallSite> noncesList = new ArrayList<CallSite>();
            int count = 0;
            while (e != null && e.hasMoreElements()) {
                CertRecord rec = e.nextElement();
                if (rec == null) continue;
                X509CertImpl xcert = rec.getCertificate();
                if (xcert != null && this.mCA != null && engine.getEnableNonces()) {
                    long n = this.mRandom.nextLong();
                    Map<Object, Long> nonces = engine.getNonces(req, "cert-revoke");
                    nonces.put(xcert.getSerialNumber(), n);
                    noncesList.add((CallSite)((Object)(xcert.getSerialNumber() + ":" + n)));
                }
                if (rec.getStatus().equals("REVOKED")) continue;
                ++count;
                ArgBlock rarg = new ArgBlock();
                rarg.addStringValue("serialNumber", xcert.getSerialNumber().toString(16));
                rarg.addStringValue("serialNumberDecimal", xcert.getSerialNumber().toString());
                rarg.addStringValue("subject", xcert.getSubjectName().toString());
                rarg.addLongValue("validNotBefore", xcert.getNotBefore().getTime() / 1000L);
                rarg.addLongValue("validNotAfter", xcert.getNotAfter().getTime() / 1000L);
                argSet.addRepeatRecord(rarg);
            }
            header.addIntegerValue("verifiedRecordCount", count);
            if (this.mCA != null && engine.getEnableNonces()) {
                header.addStringValue("nonce", StringUtils.join((Object[])noncesList.toArray(), (String)","));
            }
        }
        catch (EBaseException e) {
            logger.error("ReasonToRevoke: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

