/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.connector;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.connector.Connector;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.connector.RequestTransfer;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmsutil.http.HttpResponse;
import java.util.Hashtable;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConnector
extends Connector {
    public static Logger logger = LoggerFactory.getLogger(LocalConnector.class);
    CertificateAuthority mSource;
    IAuthority mDest = null;
    Hashtable<String, Request> mSourceReqs = new Hashtable();

    public LocalConnector(CertificateAuthority source, IAuthority dest) {
        this.mSource = source;
        this.mDest = dest;
        logger.debug("Local connector setup for dest " + this.mDest.getId());
        this.engine.registerRequestListener((RequestListener)new LocalConnListener());
        logger.debug("Connector inited");
    }

    public boolean send(Request r) throws EBaseException {
        logger.debug("send request type " + r.getRequestType() + " status=" + r.getRequestStatus());
        logger.debug("to " + this.mDest.getId() + " id=" + r.getRequestId());
        CAEngine caEngine = (CAEngine)this.engine;
        CertRequestRepository requestRepository = caEngine.getCertRequestRepository();
        Request destreq = requestRepository.createRequest(r.getRequestType());
        logger.debug("local connector dest req " + destreq.getRequestId() + " created for source rId " + r.getRequestId());
        destreq.setSourceId(this.mSource.getX500Name().toString() + ":" + r.getRequestId().toString());
        this.transferRequest(r, destreq);
        destreq.setExtData("requestorType", "RA");
        logger.debug("connector dest " + this.mDest.getId() + " processing " + destreq.getRequestId());
        SessionContext s = SessionContext.getContext();
        if (s.get((Object)"userid") == null) {
            s.put((Object)"userid", (Object)("$local$" + this.mSource.getId()));
        }
        this.mSourceReqs.put(r.getRequestId().toString(), r);
        try {
            RequestQueue destQ = this.engine.getRequestQueue();
            destQ.processRequest(destreq);
        }
        catch (EBaseException ex) {
            throw ex;
        }
        finally {
            this.mSourceReqs.remove(r.getRequestId().toString());
        }
        logger.debug("connector dest " + this.mDest.getId() + " processed " + destreq.getRequestId() + " status " + destreq.getRequestStatus());
        if (destreq.getRequestStatus() == RequestStatus.COMPLETE) {
            this.transferRequest(destreq, r);
            return true;
        }
        return false;
    }

    public HttpResponse send(String op, String r) throws EBaseException {
        logger.debug("LocalConnector send() with String.  Should not get here.");
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    protected void transferRequest(Request src, Request dest) {
        RequestTransfer.transfer((Request)src, (Request)dest);
    }

    public class LocalConnListener
    extends RequestListener {
        public void init(Subsystem sys, ConfigStore config) throws EBaseException {
        }

        public void set(String name, String val) {
        }

        public void accept(Request destreq) {
            try {
                this.acceptImpl(destreq);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void acceptImpl(Request destreq) throws Exception {
            logger.debug("dest " + LocalConnector.this.mDest.getId() + " done with " + destreq.getRequestId());
            CAEngine engine = CAEngine.getInstance();
            RequestQueue sourceQ = engine.getRequestQueue();
            String sourceNameAndId = destreq.getSourceId();
            String sourceName = LocalConnector.this.mSource.getX500Name().toString();
            if (sourceNameAndId == null || !sourceNameAndId.toString().regionMatches(0, sourceName, 0, sourceName.length())) {
                logger.debug("request " + destreq.getRequestId() + " from " + sourceNameAndId + " not ours.");
                return;
            }
            int index = sourceNameAndId.lastIndexOf(58);
            if (index == -1) {
                logger.error("request " + destreq.getRequestId() + " for " + sourceNameAndId + " malformed.");
                return;
            }
            String sourceId = sourceNameAndId.substring(index + 1);
            RequestId rId = new RequestId(sourceId);
            Request r = null;
            r = LocalConnector.this.mSourceReqs.get(rId.toString());
            if (r != null) {
                if (r.getRequestStatus() != RequestStatus.SVC_PENDING) {
                    logger.warn("request state of " + rId + "not pending  from dest authority " + LocalConnector.this.mDest.getId());
                    sourceQ.releaseRequest(r);
                    return;
                }
                LocalConnector.this.transferRequest(destreq, r);
                sourceQ.markAsServiced(r);
                sourceQ.releaseRequest(r);
                logger.debug("released request " + r.getRequestId());
            }
        }
    }
}

