/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.LdapConnFactory;
import com.netscape.certsrv.publish.Mapper;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.ldap.HandleEnrollment;
import com.netscape.cmscore.ldap.HandleRenewal;
import com.netscape.cmscore.ldap.HandleRevocation;
import com.netscape.cmscore.ldap.HandleUnrevocation;
import com.netscape.cmscore.ldap.LdapMappers;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPConnection;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPublishModule
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(LdapPublishModule.class);
    protected ConfigStore mConfig;
    protected LdapBoundConnFactory mLdapConnFactory = null;
    private boolean mInited = false;
    protected CertificateAuthority mAuthority = null;
    protected Hashtable<String, LdapMappers> mMappers = new Hashtable();
    protected Hashtable<String, RequestListener> mEventHandlers = new Hashtable();
    public static final String ATTR_LDAPPUBLISH_STATUS = "LdapPublishStatus";
    public static final String PROP_LDAP = "ldap";
    public static final String PROP_MAPPER = "mapper";
    public static final String PROP_PUBLISHER = "publisher";
    public static final String PROP_CLASS = "class";
    public static final String PROP_TYPE = "type";
    public static final String PROP_TYPE_CA = "ca";
    public static final String PROP_TYPE_CLIENT = "client";
    public static final String PROP_TYPE_CRL = "crl";
    protected CAPublisherProcessor mPubProcessor;

    public LdapPublishModule() {
    }

    public void init(Subsystem sub, ConfigStore config) throws EBaseException {
    }

    public void set(String name, String val) {
    }

    public LdapPublishModule(LdapBoundConnFactory factory) {
        this.mLdapConnFactory = factory;
        this.mInited = true;
    }

    public void init(CertificateAuthority authority, CAPublisherProcessor p, ConfigStore config) throws EBaseException {
        if (this.mInited) {
            return;
        }
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        this.mAuthority = authority;
        this.mPubProcessor = p;
        this.mConfig = config;
        PKISocketConfig socketConfig = cs.getSocketConfig();
        LDAPConfig ldapCfg = (LDAPConfig)this.mConfig.getSubStore(PROP_LDAP, LDAPConfig.class);
        this.mLdapConnFactory = new LdapBoundConnFactory("LdapPublishModule");
        this.mLdapConnFactory.setCMSEngine((CMSEngine)engine);
        this.mLdapConnFactory.init(socketConfig, ldapCfg, engine.getPasswordStore());
        this.initHandlers();
        engine.registerRequestListener(this);
    }

    public void init(CertificateAuthority authority, ConfigStore config) throws EBaseException {
        if (this.mInited) {
            return;
        }
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        this.mAuthority = authority;
        this.mConfig = config;
        PKISocketConfig socketConfig = cs.getSocketConfig();
        LDAPConfig ldapCfg = (LDAPConfig)this.mConfig.getSubStore(PROP_LDAP, LDAPConfig.class);
        this.mLdapConnFactory = new LdapBoundConnFactory("LdapPublishModule");
        this.mLdapConnFactory.setCMSEngine((CMSEngine)engine);
        this.mLdapConnFactory.init(socketConfig, ldapCfg, engine.getPasswordStore());
        this.initMappers(config);
        this.initHandlers();
        engine.registerRequestListener(this);
    }

    public LdapConnFactory getLdapConnFactory() {
        return this.mLdapConnFactory;
    }

    protected LdapMappers getMappers(String certType) {
        LdapMappers mappers = null;
        mappers = certType == null ? this.mMappers.get(PROP_TYPE_CLIENT) : this.mMappers.get(certType);
        return mappers;
    }

    protected void initMappers(ConfigStore config) throws EBaseException {
        ConfigStore types = this.mConfig.getSubStore(PROP_TYPE, ConfigStore.class);
        if (types == null || types.size() <= 0) {
            logger.debug("No ldap publishing configurations.");
            return;
        }
        Enumeration substores = types.getSubStoreNames().elements();
        while (substores.hasMoreElements()) {
            String certType = (String)substores.nextElement();
            ConfigStore current = types.getSubStore(certType, ConfigStore.class);
            if (current == null || current.size() <= 0) {
                logger.debug("No ldap publish configuration for " + certType + " found.");
                continue;
            }
            Mapper mapper = null;
            Publisher publisher = null;
            ConfigStore mapperConf = null;
            ConfigStore publisherConf = null;
            String mapperClassName = null;
            String publisherClassName = null;
            try {
                mapperConf = current.getSubStore(PROP_MAPPER, ConfigStore.class);
                mapperClassName = mapperConf.getString(PROP_CLASS, null);
                if (mapperClassName != null && mapperClassName.length() > 0) {
                    logger.debug("mapper " + mapperClassName + " for " + certType);
                    mapper = (Mapper)Class.forName(mapperClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    mapper.init(mapperConf);
                }
                if ((publisherClassName = (publisherConf = current.getSubStore(PROP_PUBLISHER, ConfigStore.class)).getString(PROP_CLASS, null)) != null && publisherClassName.length() > 0) {
                    logger.debug("publisher " + publisherClassName + " for " + certType);
                    publisher = (Publisher)Class.forName(publisherClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    publisher.init(publisherConf);
                }
                this.mMappers.put(certType, new LdapMappers(mapper, publisher));
            }
            catch (EBaseException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_LDAP_INIT_ERROR", (Object[])new Object[]{certType, e.toString()}), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_LDAP_INIT_ERROR", (Object[])new Object[]{certType, e.toString()}), (Throwable)e);
                throw new EBaseException(e);
            }
        }
        this.mInited = true;
    }

    protected void initHandlers() {
        this.mEventHandlers.put("enrollment", new HandleEnrollment(this));
        this.mEventHandlers.put("renewal", new HandleRenewal(this));
        this.mEventHandlers.put("revocation", new HandleRevocation(this));
        this.mEventHandlers.put("unrevocation", new HandleUnrevocation(this));
    }

    public void accept(Request request) {
        String type = request.getRequestType();
        RequestListener handler = this.mEventHandlers.get(type);
        if (handler == null) {
            logger.debug("Nothing to publish for request type " + type);
            return;
        }
        handler.accept(request);
    }

    public void publish(String certType, X509Certificate cert) throws ELdapException {
        LdapMappers mappers = this.getMappers(certType);
        if (mappers == null || mappers.publisher == null) {
            logger.debug("publisher for " + certType + " is null");
            return;
        }
        this.publish(mappers.mapper, mappers.publisher, cert);
        this.setPublishedFlag(cert.getSerialNumber(), true);
    }

    public void unpublish(String certType, X509Certificate cert) throws ELdapException {
        LdapMappers mappers = this.getMappers(certType);
        if (mappers == null || mappers.publisher == null) {
            logger.debug("publisher for " + certType + " is null");
            return;
        }
        this.unpublish(mappers.mapper, mappers.publisher, cert);
        this.setPublishedFlag(cert.getSerialNumber(), false);
    }

    public void setPublishedFlag(BigInteger serialNo, boolean published) {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certdb = engine.getCertificateRepository();
        try {
            CertRecord certRec = certdb.readCertificateRecord(serialNo);
            MetaInfo metaInfo = certRec.getMetaInfo();
            if (metaInfo == null) {
                metaInfo = new MetaInfo();
            }
            metaInfo.set("inLdapPublishDir", (Object)String.valueOf(published));
            ModificationSet modSet = new ModificationSet();
            modSet.add("certMetaInfo", 2, (Object)metaInfo);
            certdb.modifyCertificateRecord(serialNo, modSet);
        }
        catch (EBaseException e) {
            logger.warn("LdapPublishModule: Cannot mark cert 0x" + serialNo.toString(16) + " published as " + published + " in the ldap directory");
            logger.warn("LdapPublishModule: Cert Record not found: " + e.getMessage(), (Throwable)e);
        }
    }

    public LDAPConnection getConn() throws ELdapException {
        return this.mLdapConnFactory.getConn();
    }

    public void returnConn(LDAPConnection conn) throws ELdapException {
        this.mLdapConnFactory.returnConn(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Mapper mapper, Publisher publisher, X509Certificate cert) throws ELdapException {
        LDAPConnection conn = null;
        try {
            String dirdn = null;
            String result = null;
            conn = this.mLdapConnFactory.getConn();
            if (mapper == null) {
                dirdn = cert.getSubjectDN().toString();
                logger.debug("no mapper found. Using subject name exactly: " + cert.getSubjectDN());
            } else {
                result = mapper.map(conn, (Object)cert);
                dirdn = result;
                if (dirdn == null) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISH_NOT_MATCH", (Object[])new Object[]{cert.getSerialNumber().toString(16), cert.getSubjectDN().toString()}));
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH", (String[])new String[]{cert.getSubjectDN().toString()}));
                }
            }
            publisher.publish(conn, dirdn, (Object)cert);
        }
        finally {
            if (conn != null) {
                this.mLdapConnFactory.returnConn(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpublish(Mapper mapper, Publisher publisher, X509Certificate cert) throws ELdapException {
        LDAPConnection conn = null;
        try {
            String dirdn = null;
            String result = null;
            conn = this.mLdapConnFactory.getConn();
            if (mapper == null) {
                dirdn = cert.getSubjectDN().toString();
            } else {
                result = mapper.map(conn, (Object)cert);
                dirdn = result;
                if (dirdn == null) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISH_NOT_MATCH", (Object[])new Object[]{cert.getSerialNumber().toString(16), cert.getSubjectDN().toString()}));
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH", (String[])new String[]{cert.getSubjectDN().toString()}));
                }
            }
            publisher.unpublish(conn, dirdn, (Object)cert);
        }
        finally {
            if (conn != null) {
                this.mLdapConnFactory.returnConn(conn);
            }
        }
    }

    public void publish(X509CRLImpl crl) throws ELdapException {
        LdapMappers mappers = this.getMappers(PROP_TYPE_CRL);
        if (mappers == null || mappers.publisher == null) {
            logger.debug("publisher for crl is null");
            return;
        }
        LDAPConnection conn = null;
        String dn = null;
        try {
            String result = null;
            conn = this.mLdapConnFactory.getConn();
            if (mappers.mapper == null) {
                dn = ((X500Name)crl.getIssuerDN()).toLdapDNString();
            } else {
                result = mappers.mapper.map(conn, (Object)crl);
                dn = result;
                if (dn == null) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_LDAP_CRL_NOT_MATCH", (Object[])new Object[0]));
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH", (String[])new String[]{crl.getIssuerDN().toString()}));
                }
            }
            mappers.publisher.publish(conn, dn, (Object)crl);
        }
        catch (ELdapException e) {
            logger.error("Error publishing CRL to " + dn + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error("Error publishing CRL to " + dn + ": " + e.getMessage(), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_ISSUER_FROM_CRL_FAILED", (String[])new String[]{""}));
        }
        finally {
            if (conn != null) {
                this.mLdapConnFactory.returnConn(conn);
            }
        }
    }

    public void publish(String dn, X509CRL crl) throws ELdapException {
        LdapMappers mappers = this.getMappers(PROP_TYPE_CRL);
        if (mappers == null || mappers.publisher == null) {
            logger.debug("publisher for crl is null");
            return;
        }
        LDAPConnection conn = null;
        try {
            conn = this.mLdapConnFactory.getConn();
            mappers.publisher.publish(conn, dn, (Object)crl);
        }
        catch (ELdapException e) {
            logger.error("Error publishing CRL to " + dn + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (conn != null) {
                this.mLdapConnFactory.returnConn(conn);
            }
        }
    }
}

