/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.tomcat;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import javax.ws.rs.ServiceUnavailableException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.CredentialHandler;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.RealmBase;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.ietf.jgss.GSSContext;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyRealm
implements Realm {
    private static Logger logger = LoggerFactory.getLogger(ProxyRealm.class);
    public static Map<String, ProxyRealm> proxies = new HashMap<String, ProxyRealm>();
    public Container container;
    public String name;
    public Realm realm;

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
        if (container instanceof Context) {
            Context context = (Context)container;
            String contextName = context.getBaseName();
            this.name = contextName.toUpperCase();
            proxies.put(contextName, this);
        }
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
        realm.setContainer(this.container);
    }

    public static void registerRealm(String contextName, Realm realm) {
        ProxyRealm proxy = proxies.get(contextName);
        if (proxy == null) {
            return;
        }
        if (realm instanceof RealmBase) {
            ((RealmBase)realm).setContainer(proxy.getContainer());
        }
        proxy.setRealm(realm);
    }

    public void validateRealm() {
        if (this.realm != null) {
            return;
        }
        String message = String.format("%s subsystem unavailable. Check %s debug log.", this.name, this.name);
        logger.error(message);
        throw new ServiceUnavailableException(message);
    }

    public Principal authenticate(String username) {
        this.validateRealm();
        logger.info("Authenticating user " + username);
        try {
            Principal principal = this.realm.authenticate(username);
            logger.info("Principal: " + principal);
            return principal;
        }
        catch (Exception e) {
            logger.error("Unable to authenticate " + username + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Principal authenticate(String username, String password) {
        this.validateRealm();
        logger.info("Authenticating user " + username + " with password");
        try {
            Principal principal = this.realm.authenticate(username, password);
            logger.info("Principal: " + principal);
            return principal;
        }
        catch (Exception e) {
            logger.error("Unable to authenticate " + username + " with password: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Principal authenticate(X509Certificate[] certs) {
        X500Principal subjectDN;
        this.validateRealm();
        logger.info("Authenticating certificate chain:");
        for (X509Certificate cert : certs) {
            logger.info("- " + cert.getSubjectDN());
        }
        try {
            CertificateChain chain = new CertificateChain(certs);
            chain.sort();
            List sortedCerts = chain.getCertificates();
            int size = sortedCerts.size();
            X509Certificate userCert = (X509Certificate)sortedCerts.get(size - 1);
            subjectDN = userCert.getSubjectX500Principal();
            logger.info("Authenticating cert " + subjectDN);
        }
        catch (Exception e) {
            logger.error("Unable to sort certificates: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Unable to sort certificates: " + e.getMessage(), e);
        }
        try {
            Principal principal = this.realm.authenticate(certs);
            logger.info("Principal: " + principal);
            return principal;
        }
        catch (Exception e) {
            logger.error("Unable to authenticate " + subjectDN + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realmName, String md5a2) {
        this.validateRealm();
        logger.info("Authenticating user " + username + " for realm " + realmName);
        try {
            Principal principal = this.realm.authenticate(username, digest, nonce, nc, cnonce, qop, realmName, md5a2);
            logger.info("Principal: " + principal);
            return principal;
        }
        catch (Exception e) {
            logger.error("Unable to authenticate " + username + " for realm " + realmName + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Principal authenticate(GSSContext gssContext, boolean storeCreds) {
        this.validateRealm();
        logger.info("Authenticating GSS context " + gssContext);
        try {
            Principal principal = this.realm.authenticate(gssContext, storeCreds);
            logger.info("Principal: " + principal);
            return principal;
        }
        catch (Exception e) {
            logger.error("Unable to authenticate " + gssContext + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        this.validateRealm();
        return this.realm.hasResourcePermission(request, response, constraints, context);
    }

    public void backgroundProcess() {
        this.validateRealm();
        this.realm.backgroundProcess();
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        this.validateRealm();
        return this.realm.findSecurityConstraints(request, context);
    }

    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        this.validateRealm();
        return this.realm.hasRole(wrapper, principal, role);
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraint) throws IOException {
        this.validateRealm();
        return this.realm.hasUserDataPermission(request, response, constraint);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.validateRealm();
        this.realm.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.validateRealm();
        this.realm.removePropertyChangeListener(listener);
    }

    public CredentialHandler getCredentialHandler() {
        this.validateRealm();
        return this.realm.getCredentialHandler();
    }

    public void setCredentialHandler(CredentialHandler handler) {
        this.validateRealm();
        this.realm.setCredentialHandler(handler);
    }

    public String[] getRoles(Principal principal) {
        this.validateRealm();
        return this.realm.getRoles(principal);
    }

    public boolean isAvailable() {
        this.validateRealm();
        return this.realm.isAvailable();
    }
}

