/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;

@WebServlet(name="kraKRAGrantRecovery", urlPatterns={"/agent/kra/grantRecovery"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="kra"), @WebInitParam(name="templatePath", value="/agent/kra/grantRecovery.template"), @WebInitParam(name="ID", value="kraKRAGrantRecovery"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.kra.key")})
public class GrantRecovery
extends CMSServlet {
    private static final long serialVersionUID = 991970686415492L;
    private static final String INFO = "grantRecovery";
    private static final String TPL_FILE = "grantRecovery.template";
    private static final String OUT_OP = "op";
    private static final String OUT_SERVICE_URL = "serviceURL";
    private static final String OUT_ERROR = "errorDetails";
    private KeyRecoveryAuthority mService;
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/kra/grantRecovery.template";
        KRAEngine engine = KRAEngine.getInstance();
        this.mService = engine.getKRA();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig cs = engine.getConfig();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "recover");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        String agentID = authToken.getInString("uid");
        if (cs.getBoolean("kra.keySplitting")) {
            agentID = req.getParameter("agentID");
        }
        try {
            this.process(argSet, header, req.getParameter("recoveryID"), agentID, req.getParameter("agentPWD"), req, resp, locale[0]);
        }
        catch (NumberFormatException e) {
            header.addStringValue(OUT_ERROR, CMS.getUserMessage((Locale)locale[0], (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, String recoveryID, String agentID, String agentPWD, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        String auditRecoveryID = recoveryID;
        String auditAgentID = agentID;
        if (auditRecoveryID != null) {
            if ((auditRecoveryID = auditRecoveryID.trim()).equals("")) {
                auditRecoveryID = "$Unidentified$";
            }
        } else {
            auditRecoveryID = "$Unidentified$";
        }
        if (auditAgentID != null) {
            if ((auditAgentID = auditAgentID.trim()).equals("")) {
                auditAgentID = "$Unidentified$";
            }
        } else {
            auditAgentID = "$Unidentified$";
        }
        try {
            header.addStringValue(OUT_OP, req.getParameter(OUT_OP));
            header.addStringValue(OUT_SERVICE_URL, req.getRequestURI());
            Hashtable<String, Object> h = this.mService.getRecoveryParams(recoveryID);
            if (h == null) {
                header.addStringValue(OUT_ERROR, "No such token found");
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_KEY_RECOVERY_AGENT_LOGIN_4", (Object[])new Object[]{auditSubjectID, "Failure", auditRecoveryID, auditAgentID});
                auditor.log(auditMessage);
                return;
            }
            header.addStringValue("serialNumber", (String)h.get("keyID"));
            header.addStringValue("serialNumberInHex", new BigInteger((String)h.get("keyID")).toString(16));
            this.mService.addDistributedCredential(recoveryID, agentID, agentPWD);
            header.addStringValue("agentID", agentID);
            header.addStringValue("recoveryID", recoveryID);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_KEY_RECOVERY_AGENT_LOGIN_4", (Object[])new Object[]{auditSubjectID, "Success", auditRecoveryID, auditAgentID});
            auditor.log(auditMessage);
        }
        catch (EBaseException e) {
            header.addStringValue(OUT_ERROR, e.toString(locale));
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_KEY_RECOVERY_AGENT_LOGIN_4", (Object[])new Object[]{auditSubjectID, "Failure", auditRecoveryID, auditAgentID});
            auditor.log(auditMessage);
        }
        catch (Exception e) {
            header.addStringValue(OUT_ERROR, e.toString());
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_KEY_RECOVERY_AGENT_LOGIN_4", (Object[])new Object[]{auditSubjectID, "Failure", auditRecoveryID, auditAgentID});
            auditor.log(auditMessage);
        }
    }
}

