/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.jobs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.jobs.ItemCounter;
import com.netscape.cms.jobs.RenewalNotificationJob;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.ElementProcessor;
import com.netscape.cmscore.notification.EmailFormProcessor;
import com.netscape.cmscore.request.Request;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CertRecProcessor
extends ElementProcessor {
    public static Logger logger = LoggerFactory.getLogger(CertRecProcessor.class);
    protected CMSEngine engine;
    protected RenewalNotificationJob mJob;
    protected String mEmailTemplate;
    protected String mSummaryItemTemplate;
    protected ItemCounter mIC;

    public CertRecProcessor(CMSEngine engine, RenewalNotificationJob job, String emailTemplate, String summaryItemTemplate, ItemCounter ic) {
        this.engine = engine;
        this.mJob = job;
        this.mEmailTemplate = emailTemplate;
        this.mSummaryItemTemplate = summaryItemTemplate;
        this.mIC = ic;
    }

    public void process(Object o) throws EBaseException {
        block11: {
            CertRecord cr = (CertRecord)o;
            String ridString = null;
            boolean numFailCounted = false;
            if (cr != null) {
                this.mJob.buildItemParams(cr.getCertificate());
                this.mJob.buildItemParams("HttpHost", this.mJob.mHttpHost);
                this.mJob.buildItemParams("HttpPort", this.mJob.mHttpPort);
                MetaInfo metaInfo = null;
                metaInfo = (MetaInfo)cr.get("certMetaInfo");
                if (metaInfo == null) {
                    ++this.mIC.mNumFail;
                    numFailCounted = true;
                    if (this.mJob.mSummary) {
                        this.mJob.buildItemParams("Status", "failed");
                    }
                    logger.warn("CertRecProcessor: " + CMS.getLogMessage((String)"JOBS_GET_CERT_ERROR", (Object[])new Object[]{cr.getCertificate().getSerialNumber().toString(16)}));
                } else {
                    ridString = (String)metaInfo.get("requestId");
                }
            }
            CAEngine caEngine = (CAEngine)this.engine;
            Request req = null;
            if (ridString != null) {
                RequestId rid = new RequestId(ridString);
                try {
                    req = caEngine.getRequestRepository().readRequest(rid);
                }
                catch (Exception e) {
                    logger.warn("huh RenewalNotificationJob Exception: " + e.getMessage(), (Throwable)e);
                }
                if (req != null) {
                    this.mJob.buildItemParams(req);
                }
            }
            try {
                EmailFormProcessor emfp = new EmailFormProcessor();
                String message = emfp.getEmailContent(this.mEmailTemplate, this.mJob.mItemParams);
                this.mJob.mailUser(this.mJob.mEmailSubject, message, this.mJob.mEmailSender, req, cr);
                this.mJob.buildItemParams("Status", "succeeded");
                ++this.mIC.mNumSuccessful;
            }
            catch (Exception e) {
                logger.warn("RenewalNotificationJob: " + e.getMessage(), (Throwable)e);
                this.mJob.buildItemParams("Status", "failed");
                if (numFailCounted) break block11;
                ++this.mIC.mNumFail;
            }
        }
        if (this.mJob.mSummary) {
            EmailFormProcessor summaryItemEmfp = new EmailFormProcessor();
            String c = summaryItemEmfp.getEmailContent(this.mSummaryItemTemplate, this.mJob.mItemParams);
            this.mIC.mItemListContent = this.mIC.mItemListContent == null ? c : this.mIC.mItemListContent + c;
        }
    }
}

